import{s as tt,n as st,o as it}from"../chunks/scheduler.7da89386.js";import{S as nt,i as Mt,g as M,s as i,r as o,A as at,h as a,f as t,c as n,j as et,u as y,x as r,k as lt,y as rt,a as s,v as T,d as p,t as U,w as d}from"../chunks/index.0b7befd3.js";import{C as w}from"../chunks/CodeBlock.c5b6371f.js";import{H as J,E as ot}from"../chunks/getInferenceSnippets.6ead4bda.js";function yt(bl){let c,Ie,Ce,he,m,fe,C,kl=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers.`,je,u,Al=`See <a href="kernel-requirements.md">Kernel requirements</a> for more information the
requirements of Hub layers.`,be,I,ke,h,Ae,f,gl=`A layer can be made extensible with the <code>use_kernel_forward_from_hub</code>
decorator. For example:`,ge,j,$e,b,$l=`The decorator does not change the behavior of the class — it annotates
the class with the given name (here <code>SiluAndMul</code>). The <code>kernelize</code> function
described below uses this name to look up kernels for the layer.`,Ee,k,Re,A,El=`An existing layer that does not (yet) have the <code>use_kernel_forward_from_hub</code>
decorator can be made extensible using the <code>replace_kernel_forward_from_hub</code>
function:`,ve,g,Ne,$,Rl=`<strong>Warning:</strong> we strongly recommend using layers with a decorator, since
it signifies that the maintainer intends to keep the <code>forward</code> signature
compatible with layers from the hub.`,_e,E,Be,R,vl=`A model will not use Hub kernels by default, even if it contains extensible
layers. To enable the use of Hub kernels in the model, it needs to be
‘kernelized’ using the <code>kernelize</code> function. This function traverses the
model graph and replaces the <code>forward</code> methods of extensible layers for which
Hub kernels are registered. <code>kernelize</code> can be used as follows:`,Ge,v,Le,N,Nl=`The <code>kernelize</code> function modifies the model in-place, the model itself is
returned as a convenience. The <code>mode</code> specifies that the model will be used
in inference. Similarly, you can ask <code>kernelize</code> to prepare the model for
training:`,He,_,Se,B,_l=`A model that is kernelized for training can also be used for inference, but
not the other way around. If you want to change the mode of the kernelized
model, you can just run <code>kernelize</code> on the model again with the new mode.`,Ze,G,Bl=`If you want to compile a model with <code>torch.compile</code>, this should be indicated
in the mode as well. You can do this by combining <code>Mode.INFERENCE</code> or
<code>Mode.TRAINING</code> with <code>Mode.TORCH_COMPILE</code> using the set union (<code>|</code>) operator:`,We,L,Qe,H,Gl=`When the <code>mode</code> argument is not specified,
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> is used as the default. This mode
aligns most closely with pure PyTorch layers which also support training
and <code>torch.compile</code>. However, to select the most performant kernels, it
is often good to make the mode specific as possible.`,Ve,S,xe,Z,Ll=`Kernels can be registered per device type. For instance, separate <code>cuda</code> and
<code>metal</code> kernels could be registered for the name <code>SiluAndMul</code>. By default,
<code>kernelize</code> will try to infer the device type from the model’s parameters.
You can pass the device type to <code>kernelize</code> if the device type cannot be
inferred (e.g. because the model has no parameters):`,Xe,W,Fe,Q,ze,V,Hl=`If the <code>TRAINING</code> and/or <code>TORCH_COMPILE</code> modes are used, but a registered
kernel does not support backward passes or <code>torch.compile</code> respectively,
<code>kernelize</code> will fall back to the original, non-kernelized, layer. You
can let <code>kernelize</code> raise an exception instead by using <code>use_fallback=False</code>:`,qe,x,Ye,X,Sl="This can be useful if you want to guarantee that Hub kernels are used.",Pe,F,Ke,z,Zl=`The kernels that are used are logged at the <code>INFO</code> level by <code>kernelize</code>.
See the <a href="https://docs.python.org/3/library/logging.html" rel="nofollow">Python logging</a>
documentation for information on how to configure logging.`,Oe,q,De,Y,Wl=`<code>kernelize</code> relies on kernel mappings to find Hub kernels for layers.
Kernel mappings map a kernel name such as <code>SiluAndMul</code> to a kernel on
the Hub. For example:`,el,P,ll,K,Ql="You can register such a mapping using <code>register_kernel_mapping</code>:",tl,O,sl,D,Vl=`This will register the kernel mapping in the current context, which is
normally global. It is recommended to scope the mapping to where it is
used with the <code>use_kernel_mapping</code> context manager:`,il,ee,nl,le,xl=`This ensures that the mapping is not active anymore outside the
<code>with</code>-scope.`,Ml,te,al,se,Xl=`You might want to register two different kernels for a particular layer,
where one kernel is optimized for a specific mode. You can do so by
registering layer repositories for specific modes. For example:`,rl,ie,ol,ne,Fl=`The <code>kernelize</code> function will attempt to use the following registered
kernels for a given mode:`,yl,Me,zl=`<li><code>INFERENCE</code>: <code>INFERENCE</code> → <code>INFERENCE | TORCH_COMPILE</code> → <code>TRAINING</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>INFERENCE | TORCH_COMPILE</code>: <code>INFERENCE | TORCH_COMPILE</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING</code>: <code>TRAINING</code> → <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING | TORCH_COMPILE</code>: <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li>`,Tl,ae,ql=`<code>Mode.FALLBACK</code> is a special mode that is used when no other mode matches. It
is also used when a kernel is registered without a mode, as described in the
previous section.`,pl,re,Ul,oe,Yl=`In this case, both <code>Mode.INFERENCE | Mode.TORCH_COMPILE</code> and
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> will use the <code>Mode.FALLBACK</code> kernel,
since the other kernels do not support <code>torch.compile</code>.`,dl,ye,wl,Te,Pl=`Some kernels only work with newer CUDA architectures. For instance, some
kernels require capability 9.0 for the TMA unit on Hopper GPUs. <code>kernels</code>
supports registering layers for a range of CUDA capabilities. To do so,
you need to register the layer for a <code>Device</code> with type <code>cuda</code> and
set the supported range of CUDA capabilities with using <code>CUDAProperties</code>:`,Jl,pe,cl,Ue,Kl="Capabilities behave as follows:",ml,de,Ol=`<li><p>The minimum and maximum capabilities are inclusive.</p></li> <li><p>When a new kernel is registered with the same min/max capabilities as
an existing kernel, the new kernel will replace the old kernel.</p></li> <li><p>When there are multiple kernels that support a capability, the kernel
with the smaller capability interval will be used. E.g. given:</p> <ul><li><code>KernelA</code> with <code>min_capability=80</code> and <code>max_capability=89</code>;</li> <li><code>KernelB</code> with <code>min_capability=75</code> and <code>max_capability=89</code>;</li> <li><code>kernelize</code> runs on a system with capability 8.6.</li></ul> <p>Then <code>KernelA</code> will be used because the interval 80..89 is smaller
than 75..89. The motivation is that kernels with smaller ranges
tend to be more optimized for a specific set of GPUs. <strong>This behavior
might still change in the future.</strong></p></li>`,Cl,we,ul,Je,Dl=`The <code>LocalLayerRepository</code> class is provided to load a repository from
a local directory. For example:`,Il,ce,hl,me,fl,ue,jl;return m=new J({props:{title:"Layers",local:"layers",headingTag:"h1"}}),I=new J({props:{title:"Making a layer extensible with kernels from the hub",local:"making-a-layer-extensible-with-kernels-from-the-hub",headingTag:"h2"}}),h=new J({props:{title:"Using a decorator",local:"using-a-decorator",headingTag:"h3"}}),j=new w({props:{code:"JTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBpbnB1dCUzQSUyMHRvcmNoLlRlbnNvciklMjAtJTNFJTIwdG9yY2guVGVuc29yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZCUyMCUzRCUyMGlucHV0LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KGlucHV0JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIwaW5wdXQlNUIuLi4lMkMlMjBkJTNBJTVE",highlighted:`<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, <span class="hljs-built_in">input</span>: torch.Tensor</span>) -&gt; torch.Tensor:
        d = <span class="hljs-built_in">input</span>.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(<span class="hljs-built_in">input</span>[..., :d]) * <span class="hljs-built_in">input</span>[..., d:]`,wrap:!1}}),k=new J({props:{title:"External layers",local:"external-layers",headingTag:"h3"}}),g=new w({props:{code:"ZnJvbSUyMHNvbWVsaWJyYXJ5JTIwaW1wb3J0JTIwU2lsdUFuZE11bCUwQSUwQXJlcGxhY2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoU2lsdUFuZE11bCUyQyUyMCUyMlNpbHVBbmRNdWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> somelibrary <span class="hljs-keyword">import</span> SiluAndMul

replace_kernel_forward_from_hub(SiluAndMul, <span class="hljs-string">&quot;SiluAndMul&quot;</span>)`,wrap:!1}}),E=new J({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),v=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSk=",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE)`,wrap:!1}}),_=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.TRAINING)`,wrap:!1}}),L=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEElMEElMjMlMjBJbmZlcmVuY2UlMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSklMEElMEElMjMlMjBUcmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUp",highlighted:`model = MyModel(...)

<span class="hljs-comment"># Inference</span>
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE)

<span class="hljs-comment"># Training</span>
model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),S=new J({props:{title:"Kernel device",local:"kernel-device",headingTag:"h3"}}),W=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`model = MyModel(...)
model = kernelize(model, device=<span class="hljs-string">&quot;cuda&quot;</span>, mode=Mode.INFERENCE)`,wrap:!1}}),Q=new J({props:{title:"Fallback forward",local:"fallback-forward",headingTag:"h3"}}),x=new w({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMHVzZV9mYWxsYmFjayUzREZhbHNlKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE, use_fallback=<span class="hljs-literal">False</span>)`,wrap:!1}}),F=new J({props:{title:"Inspecting kernels which kernels are used",local:"inspecting-kernels-which-kernels-are-used",headingTag:"h3"}}),q=new J({props:{title:"Registering a hub kernel for a layer",local:"registering-a-hub-kernel-for-a-layer",headingTag:"h2"}}),P=new w({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}`,wrap:!1}}),O=new w({props:{code:"cmVnaXN0ZXJfa2VybmVsX21hcHBpbmcoa2VybmVsX2xheWVyX21hcHBpbmcp",highlighted:"register_kernel_mapping(kernel_layer_mapping)",wrap:!1}}),ee=new w({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyhrZXJuZWxfbGF5ZXJfbWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBsYXllciUyMGZvciUyMHdoaWNoJTIwdGhlJTIwbWFwcGluZyUyMGlzJTIwYXBwbGllZC4lMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCk=",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(kernel_layer_mapping):
    <span class="hljs-comment"># Use the layer for which the mapping is applied.</span>
    model = kernelize(model)`,wrap:!1}}),te=new J({props:{title:"Registering kernels for specific modes",local:"registering-kernels-for-specific-modes",headingTag:"h3"}}),ie=new w({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
          Mode.INFERENCE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
          Mode.TRAINING | Mode.TORCH_COMPILE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
      }
    }
}`,wrap:!1}}),re=new w({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuRkFMTEJBQ0slM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.FALLBACK: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
        }
    }
}`,wrap:!1}}),ye=new J({props:{title:"Registering kernels for specific CUDA capabilities",local:"registering-kernels-for-specific-cuda-capabilities",headingTag:"h3"}}),pe=new w({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGV2aWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvcGVydGllcyUzRENVREFQcm9wZXJ0aWVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1pbl9jYXBhYmlsaXR5JTNENzUlMkMlMjBtYXhfY2FwYWJpbGl0eSUzRDg5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERldmljZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fY2FwYWJpbGl0eSUzRDkwJTJDJTIwbWF4X2NhcGFiaWxpdHklM0RzeXMubWF4c2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taG9wcGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">89</span>
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">90</span>, max_capability=sys.maxsize
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation-hopper&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
    }
}`,wrap:!1}}),we=new J({props:{title:"Loading from a local repository for testing",local:"loading-from-a-local-repository-for-testing",headingTag:"h3"}}),ce=new w({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExvY2FsTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGluc3RhbGxfa2VybmVsJTIwd2lsbCUyMGdpdmUlMjB0aGUlMjBmdWxseS1yZXNvbHZlZCUyMHBhdGguJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19wYXRoJTNEJTIyJTJGaG9tZSUyRmRhbmllbCUyRmtlcm5lbHMlMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFja2FnZV9uYW1lJTNEJTIyYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGluaGVyaXRfbWFwcGluZyUzREZhbHNlJTJDJTBBKSUzQSUwQSUyMCUyMCUyMCUyMGtlcm5lbGl6ZShsaW5lYXIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`with use_kernel_mapping(
    {
        <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
            <span class="hljs-string">&quot;cuda&quot;</span>: LocalLayerRepository(
                # install_kernel will give the fully-resolved path.
                <span class="hljs-attribute">repo_path</span>=<span class="hljs-string">&quot;/home/daniel/kernels/activation&quot;</span>,
                <span class="hljs-attribute">package_name</span>=<span class="hljs-string">&quot;activation&quot;</span>,
                <span class="hljs-attribute">layer_name</span>=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            )
        }
    },
    <span class="hljs-attribute">inherit_mapping</span>=<span class="hljs-literal">False</span>,
):
    kernelize(linear, <span class="hljs-attribute">mode</span>=Mode.INFERENCE)`,wrap:!1}}),me=new ot({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/layers.md"}}),{c(){c=M("meta"),Ie=i(),Ce=M("p"),he=i(),o(m.$$.fragment),fe=i(),C=M("p"),C.innerHTML=kl,je=i(),u=M("p"),u.innerHTML=Al,be=i(),o(I.$$.fragment),ke=i(),o(h.$$.fragment),Ae=i(),f=M("p"),f.innerHTML=gl,ge=i(),o(j.$$.fragment),$e=i(),b=M("p"),b.innerHTML=$l,Ee=i(),o(k.$$.fragment),Re=i(),A=M("p"),A.innerHTML=El,ve=i(),o(g.$$.fragment),Ne=i(),$=M("p"),$.innerHTML=Rl,_e=i(),o(E.$$.fragment),Be=i(),R=M("p"),R.innerHTML=vl,Ge=i(),o(v.$$.fragment),Le=i(),N=M("p"),N.innerHTML=Nl,He=i(),o(_.$$.fragment),Se=i(),B=M("p"),B.innerHTML=_l,Ze=i(),G=M("p"),G.innerHTML=Bl,We=i(),o(L.$$.fragment),Qe=i(),H=M("p"),H.innerHTML=Gl,Ve=i(),o(S.$$.fragment),xe=i(),Z=M("p"),Z.innerHTML=Ll,Xe=i(),o(W.$$.fragment),Fe=i(),o(Q.$$.fragment),ze=i(),V=M("p"),V.innerHTML=Hl,qe=i(),o(x.$$.fragment),Ye=i(),X=M("p"),X.textContent=Sl,Pe=i(),o(F.$$.fragment),Ke=i(),z=M("p"),z.innerHTML=Zl,Oe=i(),o(q.$$.fragment),De=i(),Y=M("p"),Y.innerHTML=Wl,el=i(),o(P.$$.fragment),ll=i(),K=M("p"),K.innerHTML=Ql,tl=i(),o(O.$$.fragment),sl=i(),D=M("p"),D.innerHTML=Vl,il=i(),o(ee.$$.fragment),nl=i(),le=M("p"),le.innerHTML=xl,Ml=i(),o(te.$$.fragment),al=i(),se=M("p"),se.textContent=Xl,rl=i(),o(ie.$$.fragment),ol=i(),ne=M("p"),ne.innerHTML=Fl,yl=i(),Me=M("ul"),Me.innerHTML=zl,Tl=i(),ae=M("p"),ae.innerHTML=ql,pl=i(),o(re.$$.fragment),Ul=i(),oe=M("p"),oe.innerHTML=Yl,dl=i(),o(ye.$$.fragment),wl=i(),Te=M("p"),Te.innerHTML=Pl,Jl=i(),o(pe.$$.fragment),cl=i(),Ue=M("p"),Ue.textContent=Kl,ml=i(),de=M("ul"),de.innerHTML=Ol,Cl=i(),o(we.$$.fragment),ul=i(),Je=M("p"),Je.innerHTML=Dl,Il=i(),o(ce.$$.fragment),hl=i(),o(me.$$.fragment),fl=i(),ue=M("p"),this.h()},l(e){const l=at("svelte-u9bgzb",document.head);c=a(l,"META",{name:!0,content:!0}),l.forEach(t),Ie=n(e),Ce=a(e,"P",{}),et(Ce).forEach(t),he=n(e),y(m.$$.fragment,e),fe=n(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-178x673"&&(C.innerHTML=kl),je=n(e),u=a(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-v68zn9"&&(u.innerHTML=Al),be=n(e),y(I.$$.fragment,e),ke=n(e),y(h.$$.fragment,e),Ae=n(e),f=a(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1jd41lf"&&(f.innerHTML=gl),ge=n(e),y(j.$$.fragment,e),$e=n(e),b=a(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-tily1x"&&(b.innerHTML=$l),Ee=n(e),y(k.$$.fragment,e),Re=n(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1hj9ahw"&&(A.innerHTML=El),ve=n(e),y(g.$$.fragment,e),Ne=n(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-13coke1"&&($.innerHTML=Rl),_e=n(e),y(E.$$.fragment,e),Be=n(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-stkx9y"&&(R.innerHTML=vl),Ge=n(e),y(v.$$.fragment,e),Le=n(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1mdicvi"&&(N.innerHTML=Nl),He=n(e),y(_.$$.fragment,e),Se=n(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-xhc5xj"&&(B.innerHTML=_l),Ze=n(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-195gdzl"&&(G.innerHTML=Bl),We=n(e),y(L.$$.fragment,e),Qe=n(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1pcqrau"&&(H.innerHTML=Gl),Ve=n(e),y(S.$$.fragment,e),xe=n(e),Z=a(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-808tau"&&(Z.innerHTML=Ll),Xe=n(e),y(W.$$.fragment,e),Fe=n(e),y(Q.$$.fragment,e),ze=n(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-yu926d"&&(V.innerHTML=Hl),qe=n(e),y(x.$$.fragment,e),Ye=n(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1lkusth"&&(X.textContent=Sl),Pe=n(e),y(F.$$.fragment,e),Ke=n(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-161p6z8"&&(z.innerHTML=Zl),Oe=n(e),y(q.$$.fragment,e),De=n(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1r5il31"&&(Y.innerHTML=Wl),el=n(e),y(P.$$.fragment,e),ll=n(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1mzc83p"&&(K.innerHTML=Ql),tl=n(e),y(O.$$.fragment,e),sl=n(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-p5ro9n"&&(D.innerHTML=Vl),il=n(e),y(ee.$$.fragment,e),nl=n(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-z3xuuf"&&(le.innerHTML=xl),Ml=n(e),y(te.$$.fragment,e),al=n(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ed3b6y"&&(se.textContent=Xl),rl=n(e),y(ie.$$.fragment,e),ol=n(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-sek2d8"&&(ne.innerHTML=Fl),yl=n(e),Me=a(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-ewhtf4"&&(Me.innerHTML=zl),Tl=n(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-m4furw"&&(ae.innerHTML=ql),pl=n(e),y(re.$$.fragment,e),Ul=n(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1oi4pcx"&&(oe.innerHTML=Yl),dl=n(e),y(ye.$$.fragment,e),wl=n(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1wl92tu"&&(Te.innerHTML=Pl),Jl=n(e),y(pe.$$.fragment,e),cl=n(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1k7nbkd"&&(Ue.textContent=Kl),ml=n(e),de=a(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-xyngc6"&&(de.innerHTML=Ol),Cl=n(e),y(we.$$.fragment,e),ul=n(e),Je=a(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-qa4iob"&&(Je.innerHTML=Dl),Il=n(e),y(ce.$$.fragment,e),hl=n(e),y(me.$$.fragment,e),fl=n(e),ue=a(e,"P",{}),et(ue).forEach(t),this.h()},h(){lt(c,"name","hf:doc:metadata"),lt(c,"content",Tt)},m(e,l){rt(document.head,c),s(e,Ie,l),s(e,Ce,l),s(e,he,l),T(m,e,l),s(e,fe,l),s(e,C,l),s(e,je,l),s(e,u,l),s(e,be,l),T(I,e,l),s(e,ke,l),T(h,e,l),s(e,Ae,l),s(e,f,l),s(e,ge,l),T(j,e,l),s(e,$e,l),s(e,b,l),s(e,Ee,l),T(k,e,l),s(e,Re,l),s(e,A,l),s(e,ve,l),T(g,e,l),s(e,Ne,l),s(e,$,l),s(e,_e,l),T(E,e,l),s(e,Be,l),s(e,R,l),s(e,Ge,l),T(v,e,l),s(e,Le,l),s(e,N,l),s(e,He,l),T(_,e,l),s(e,Se,l),s(e,B,l),s(e,Ze,l),s(e,G,l),s(e,We,l),T(L,e,l),s(e,Qe,l),s(e,H,l),s(e,Ve,l),T(S,e,l),s(e,xe,l),s(e,Z,l),s(e,Xe,l),T(W,e,l),s(e,Fe,l),T(Q,e,l),s(e,ze,l),s(e,V,l),s(e,qe,l),T(x,e,l),s(e,Ye,l),s(e,X,l),s(e,Pe,l),T(F,e,l),s(e,Ke,l),s(e,z,l),s(e,Oe,l),T(q,e,l),s(e,De,l),s(e,Y,l),s(e,el,l),T(P,e,l),s(e,ll,l),s(e,K,l),s(e,tl,l),T(O,e,l),s(e,sl,l),s(e,D,l),s(e,il,l),T(ee,e,l),s(e,nl,l),s(e,le,l),s(e,Ml,l),T(te,e,l),s(e,al,l),s(e,se,l),s(e,rl,l),T(ie,e,l),s(e,ol,l),s(e,ne,l),s(e,yl,l),s(e,Me,l),s(e,Tl,l),s(e,ae,l),s(e,pl,l),T(re,e,l),s(e,Ul,l),s(e,oe,l),s(e,dl,l),T(ye,e,l),s(e,wl,l),s(e,Te,l),s(e,Jl,l),T(pe,e,l),s(e,cl,l),s(e,Ue,l),s(e,ml,l),s(e,de,l),s(e,Cl,l),T(we,e,l),s(e,ul,l),s(e,Je,l),s(e,Il,l),T(ce,e,l),s(e,hl,l),T(me,e,l),s(e,fl,l),s(e,ue,l),jl=!0},p:st,i(e){jl||(p(m.$$.fragment,e),p(I.$$.fragment,e),p(h.$$.fragment,e),p(j.$$.fragment,e),p(k.$$.fragment,e),p(g.$$.fragment,e),p(E.$$.fragment,e),p(v.$$.fragment,e),p(_.$$.fragment,e),p(L.$$.fragment,e),p(S.$$.fragment,e),p(W.$$.fragment,e),p(Q.$$.fragment,e),p(x.$$.fragment,e),p(F.$$.fragment,e),p(q.$$.fragment,e),p(P.$$.fragment,e),p(O.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(ie.$$.fragment,e),p(re.$$.fragment,e),p(ye.$$.fragment,e),p(pe.$$.fragment,e),p(we.$$.fragment,e),p(ce.$$.fragment,e),p(me.$$.fragment,e),jl=!0)},o(e){U(m.$$.fragment,e),U(I.$$.fragment,e),U(h.$$.fragment,e),U(j.$$.fragment,e),U(k.$$.fragment,e),U(g.$$.fragment,e),U(E.$$.fragment,e),U(v.$$.fragment,e),U(_.$$.fragment,e),U(L.$$.fragment,e),U(S.$$.fragment,e),U(W.$$.fragment,e),U(Q.$$.fragment,e),U(x.$$.fragment,e),U(F.$$.fragment,e),U(q.$$.fragment,e),U(P.$$.fragment,e),U(O.$$.fragment,e),U(ee.$$.fragment,e),U(te.$$.fragment,e),U(ie.$$.fragment,e),U(re.$$.fragment,e),U(ye.$$.fragment,e),U(pe.$$.fragment,e),U(we.$$.fragment,e),U(ce.$$.fragment,e),U(me.$$.fragment,e),jl=!1},d(e){e&&(t(Ie),t(Ce),t(he),t(fe),t(C),t(je),t(u),t(be),t(ke),t(Ae),t(f),t(ge),t($e),t(b),t(Ee),t(Re),t(A),t(ve),t(Ne),t($),t(_e),t(Be),t(R),t(Ge),t(Le),t(N),t(He),t(Se),t(B),t(Ze),t(G),t(We),t(Qe),t(H),t(Ve),t(xe),t(Z),t(Xe),t(Fe),t(ze),t(V),t(qe),t(Ye),t(X),t(Pe),t(Ke),t(z),t(Oe),t(De),t(Y),t(el),t(ll),t(K),t(tl),t(sl),t(D),t(il),t(nl),t(le),t(Ml),t(al),t(se),t(rl),t(ol),t(ne),t(yl),t(Me),t(Tl),t(ae),t(pl),t(Ul),t(oe),t(dl),t(wl),t(Te),t(Jl),t(cl),t(Ue),t(ml),t(de),t(Cl),t(ul),t(Je),t(Il),t(hl),t(fl),t(ue)),t(c),d(m,e),d(I,e),d(h,e),d(j,e),d(k,e),d(g,e),d(E,e),d(v,e),d(_,e),d(L,e),d(S,e),d(W,e),d(Q,e),d(x,e),d(F,e),d(q,e),d(P,e),d(O,e),d(ee,e),d(te,e),d(ie,e),d(re,e),d(ye,e),d(pe,e),d(we,e),d(ce,e),d(me,e)}}}const Tt='{"title":"Layers","local":"layers","sections":[{"title":"Making a layer extensible with kernels from the hub","local":"making-a-layer-extensible-with-kernels-from-the-hub","sections":[{"title":"Using a decorator","local":"using-a-decorator","sections":[],"depth":3},{"title":"External layers","local":"external-layers","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"Kernel device","local":"kernel-device","sections":[],"depth":3},{"title":"Fallback forward","local":"fallback-forward","sections":[],"depth":3},{"title":"Inspecting kernels which kernels are used","local":"inspecting-kernels-which-kernels-are-used","sections":[],"depth":3}],"depth":2},{"title":"Registering a hub kernel for a layer","local":"registering-a-hub-kernel-for-a-layer","sections":[{"title":"Registering kernels for specific modes","local":"registering-kernels-for-specific-modes","sections":[],"depth":3},{"title":"Registering kernels for specific CUDA capabilities","local":"registering-kernels-for-specific-cuda-capabilities","sections":[],"depth":3},{"title":"Loading from a local repository for testing","local":"loading-from-a-local-repository-for-testing","sections":[],"depth":3}],"depth":2}],"depth":1}';function pt(bl){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends nt{constructor(c){super(),Mt(this,c,pt,yt,tt,{})}}export{ct as component};
