import{s as il,f as dl,n as pl,o as cl}from"../chunks/scheduler.85c25b89.js";import{S as ml,i as hl,g as r,s as n,r as c,A as fl,h as s,f as a,c as l,j as v,u as m,x as d,k as M,l as ul,y as i,a as o,v as h,d as f,t as u,w as g}from"../chunks/index.c9bcf812.js";import{D as b}from"../chunks/Docstring.46c9d080.js";import{C as qt}from"../chunks/CodeBlock.94efc595.js";import{H as y,E as gl}from"../chunks/EditOnGithub.ec73e7c7.js";function _l(Go){let j,Lt,Nt,Rt,R,Bt,B,So='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',Zt,Z,Xo="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",Wt,W,Ht,H,Yo="Fine-tuning a language model via DPO consists of two steps and is easier than PPO:",zt,z,Vo="<li><strong>Data collection</strong>: Gather a preference dataset with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>",Qt,Q,Ko='DPO-compatible datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>.',Gt,G,en='This process is illustrated in the sketch below (from <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">figure 1 of the original paper</a>):',St,I,tn,Xt,S,an='Read more about DPO algorithm in the <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">original paper</a>.',Yt,X,Vt,Y,on='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',Kt,$,nn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',ea,V,ln="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",ta,K,rn="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",aa,ee,sn="for example:",oa,te,na,ae,dn="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",la,oe,ra,ne,pn="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",sa,le,ia,re,cn="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",da,se,pa,ie,mn="After this one can then call:",ca,de,ma,pe,hn="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",ha,ce,fa,me,fn="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",ua,he,un='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',ga,fe,gn='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',_a,ue,_n='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Pass the <code>label_smoothing</code> argument to the trainer to use it (default is 0).',Ma,ge,Mn='The <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> authors propose an unbiased estimate of the DPO loss that is robust to preference noise in the data. Like in cDPO, assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5). Use <code>loss_type=&quot;robust&quot;</code> to the trainer to use it.',va,_e,vn='The <a href="https://arxiv.org/pdf/2402.00856" rel="nofollow">EXO</a> authors propose to minimize the reverse KL instead of the negative log-sigmoid loss of DPO which corresponds to forward KL. Setting <code>loss_type</code>=<code>exo_pair</code> and a non-zero <code>label_smoothing</code> (default <code>1e-3</code>) leads to a simplified version of EXO on pair-wise preferences (see Eqn. (16) of the <a href="https://arxiv.org/pdf/2402.00856" rel="nofollow">EXO paper</a>). The full version of EXO uses <code>K&gt;2</code> completions generated by the SFT policy, which becomes an unbiased estimator of the PPO objective (up to a constant) when <code>K</code> is sufficiently large.',ba,Me,bn='The <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;bco_pair&quot;</code> argument.',ya,ve,yn='The <a href="https://arxiv.org/abs/2405.00675" rel="nofollow">SPPO</a> authors claim that SPPO is capable of solving the Nash equilibrium iteratively by pushing the chosen rewards to be as large as 1/2 and the rejected rewards to be as small as -1/2 and can alleviate data sparsity issues. The implementation using loss_type=“sppo_hard” approximates this algorithm by employing hard label probabilities, assigning 1 to the winner and 0 to the loser.',Ta,be,Tn='The <a href="https://arxiv.org/abs/2402.05369" rel="nofollow">NCA</a> authors shows that NCA optimizes the absolute likelihood for each response rather than the relative likelihood.',wa,ye,wn='The <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper suggests syncing the reference model weights after every <code>ref_model_sync_steps</code> steps of SGD with weight <code>ref_model_mixup_alpha</code> during DPO training. To toggle this callback use the <code>sync_ref_model</code> flag in the <code>DPOConfig</code>.',Ja,Te,Jn='The <a href="https://arxiv.org/abs/2404.19733" rel="nofollow">RPO</a> paper implements an iterative preference tuning algorithm using a loss related to the RPO loss in this <a href="https://arxiv.org/abs/2405.16436" rel="nofollow">paper</a> that essentially consists of the SFT loss on the chosen preferences together with a weighted DPO loss. To use this loss set the <code>rpo_alpha</code> in the <code>DPOConfig</code> to an appropriate value.',Ua,we,Un='The <a href="https://arxiv.org/abs/2406.05882" rel="nofollow">AOT</a> authors propose to use Distributional Preference Alignment Via Optimal Transport. Traditionally, the alignment algorithms use paired preferences at a sample level, which does not ensure alignment on the distributional level. AOT, on the other hand, can align LLMs on paired or unpaired preference data by making the reward distribution of the positive samples stochastically dominant in the first order on the distribution of negative samples. Specifically, <code>loss_type=&quot;aot&quot;</code> is appropriate for  paired datasets, where each prompt has both chosen and rejected responses; <code>loss_type=&quot;aot_pair&quot;</code> is for unpaired datasets. In a nutshell, <code>loss_type=&quot;aot&quot;</code> ensures that the log-likelihood ratio of chosen to rejected of the aligned model has higher quantiles than that ratio for the reference model. <code>loss_type=&quot;aot_pair&quot;</code> ensures that the chosen reward is higher on all quantiles than the rejected reward. Note that in both cases quantiles are obtained via sorting. To fully leverage the advantages of the AOT algorithm, it is important to maximize the per-GPU batch size.',Ca,Je,ja,Ue,Cn=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,xa,Ce,jn=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,Ia,je,$a,xe,xn="While training and evaluating we record the following reward metrics:",Oa,Ie,In="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Pa,$e,Da,Oe,$n='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',ka,Pe,On="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",Fa,De,Pn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Aa,ke,Na,Fe,Dn='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Ea,Ae,qa,Ne,kn="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",La,Ee,Fn="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>model_ref</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",Ra,qe,Ba,Le,An='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',Za,Re,Nn="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",Wa,Be,Ha,Ze,En="To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in DPOTrainer.",za,We,qn="For example:",Qa,He,Ga,ze,Sa,p,Qe,mo,ct,Ln="Initialize DPOTrainer.",ho,O,Ge,fo,mt,Rn=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,uo,P,Se,go,ht,Bn="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",_o,w,Xe,Mo,ft,Zn="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",vo,ut,Wn="We do this to avoid doing two forward passes, because it’s faster for FSDP.",bo,D,Ye,yo,gt,Hn="Concatenate the chosen and rejected inputs into a single tensor.",To,k,Ve,wo,_t,zn="Compute the DPO loss for a batch of policy and reference model log probabilities.",Jo,J,Ke,Uo,Mt,Qn=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Co,vt,Gn="Works both with or without labels.",jo,F,et,xo,bt,Sn="Compute the log probabilities of the given labels under the given logits.",Io,A,tt,$o,yt,Xn="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Oo,N,at,Po,Tt,Yn="Generate samples from the model and reference model for the given batch of inputs.",Do,U,ot,ko,wt,Vn="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Fo,Jt,Kn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Ao,C,nt,No,Ut,el="Returns the training <code>~torch.utils.data.DataLoader</code>.",Eo,Ct,tl="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",qo,E,lt,Lo,jt,al="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ro,q,rt,Bo,xt,ol="Context manager for handling null reference model (that is, peft adapter manipulation).",Zo,T,st,Wo,It,nl="Tokenize a single row from a DPO specific dataset.",Ho,$t,ll=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,zo,Ot,rl=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,Xa,it,Ya,x,dt,Qo,Pt,sl="Initialize DPOConfig.",Va,pt,Ka,Et,eo;return R=new y({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),W=new y({props:{title:"How DPO works",local:"how-dpo-works",headingTag:"h2"}}),X=new y({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),te=new qt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),oe=new y({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),le=new y({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),se=new qt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQWRwb190cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args = DPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)
dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),de=new qt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),ce=new y({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),Je=new y({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),je=new y({props:{title:"Logging",local:"logging",headingTag:"h2"}}),$e=new y({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),ke=new qt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = DPOConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    beta=<span class="hljs-number">0.1</span>,
)

dpo_trainer = DPOTrainer(
    model,
    ref_model=<span class="hljs-literal">None</span>,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),Ae=new y({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),qe=new y({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),Be=new y({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),He=new qt({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),ze=new y({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Qe=new b({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L69"}}),Ge=new b({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L685"}}),Se=new b({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L898"}}),Xe=new b({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L1180"}}),Ye=new b({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L924",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Ve=new b({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L986",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ke=new b({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L1446"}}),et=new b({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L1147",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A Tuple of two tensor of shape ((batch_size,), (batch_size,)) containing the sum of log probabilities of the given labels under the given logits in the first tensor and the number of non-masked tokens in the second tensor.</p>
`}}),tt=new b({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L1254"}}),at=new b({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L1356"}}),ot=new b({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L633"}}),nt=new b({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L590"}}),lt=new b({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L1496"}}),rt=new b({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L886"}}),st=new b({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_trainer.py#L735"}}),it=new y({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),dt=new b({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"},{name:"f_divergence_type",val:": Optional = <FDivergenceType.REVERSE_KL: 'reverse_kl'>"},{name:"f_alpha_divergence_coef",val:": Optional = 1.0"},{name:"sync_ref_model",val:": bool = False"},{name:"ref_model_mixup_alpha",val:": float = 0.9"},{name:"ref_model_sync_steps",val:": int = 64"},{name:"rpo_alpha",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report and <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> paper that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper,
<code>&quot;bco_pair&quot;</code> from <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> paper or <code>&quot;robust&quot;</code> from <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> paper,
&#x201C;aot&#x201D; and &#x201C;aot_pair&#x201D; from alignment via optimal transport`,name:"loss_type"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code> defaults to <code>False</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"},{anchor:"trl.DPOConfig.f_divergence_type",description:`<strong>f_divergence_type</strong> (<code>FDivergenceType</code>, <em>optional</em>, defaults to <code>FDivergenceType.REVERSE_KL</code>) &#x2014;
The type of f-divergence regularization function to compute divergence between policy and reference model. This argument is optional, defaults to <code>FDivergenceType.REVERSE_KL</code>.`,name:"f_divergence_type"},{anchor:"trl.DPOConfig.f_alpha_divergence_coef",description:`<strong>f_alpha_divergence_coef</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
The alpha coef in alpha-divergence(u^-alpha) regularization function for DPO loss.`,name:"f_alpha_divergence_coef"},{anchor:"trl.DPOConfig.sync_ref_model",description:`<strong>sync_ref_model</strong> (&#x2018;bool&#x2019;, defaults to <code>False</code>) &#x2014;
The flag for syncing reference model during training from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"sync_ref_model"},{anchor:"trl.DPOConfig.ref_model_mixup_alpha",description:`<strong>ref_model_mixup_alpha</strong> (&#x2018;float&#x2019;, defaults to 1.0) &#x2014;
The alpha parameter from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_mixup_alpha"},{anchor:"trl.DPOConfig.ref_model_sync_steps",description:`<strong>ref_model_sync_steps</strong> (&#x2018;int&#x2019;, defaults to 2) &#x2014;
The tau parameter from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_sync_steps"},{anchor:"trl.DPOConfig.rpo_alpha",description:`<strong>rpo_alpha</strong> (&#x2018;float&#x2019;, defaults to <code>None</code>) &#x2014;
The alpha parameter from the <a href="https://arxiv.org/pdf/2404.19733" rel="nofollow">RPO</a> paper. If None, no weighting is applied and the loss is the same as the DPO loss.`,name:"rpo_alpha"}],source:"https://github.com/huggingface/trl/blob/vr_1735/trl/trainer/dpo_config.py#L32"}}),pt=new gl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){j=r("meta"),Lt=n(),Nt=r("p"),Rt=n(),c(R.$$.fragment),Bt=n(),B=r("p"),B.innerHTML=So,Zt=n(),Z=r("p"),Z.textContent=Xo,Wt=n(),c(W.$$.fragment),Ht=n(),H=r("p"),H.textContent=Yo,zt=n(),z=r("ol"),z.innerHTML=Vo,Qt=n(),Q=r("p"),Q.innerHTML=Ko,Gt=n(),G=r("p"),G.innerHTML=en,St=n(),I=r("img"),Xt=n(),S=r("p"),S.innerHTML=an,Yt=n(),c(X.$$.fragment),Vt=n(),Y=r("p"),Y.innerHTML=on,Kt=n(),$=r("div"),$.innerHTML=nn,ea=n(),V=r("p"),V.innerHTML=ln,ta=n(),K=r("ul"),K.innerHTML=rn,aa=n(),ee=r("p"),ee.textContent=sn,oa=n(),c(te.$$.fragment),na=n(),ae=r("p"),ae.innerHTML=dn,la=n(),c(oe.$$.fragment),ra=n(),ne=r("p"),ne.innerHTML=pn,sa=n(),c(le.$$.fragment),ia=n(),re=r("p"),re.innerHTML=cn,da=n(),c(se.$$.fragment),pa=n(),ie=r("p"),ie.textContent=mn,ca=n(),c(de.$$.fragment),ma=n(),pe=r("p"),pe.innerHTML=hn,ha=n(),c(ce.$$.fragment),fa=n(),me=r("p"),me.innerHTML=fn,ua=n(),he=r("p"),he.innerHTML=un,ga=n(),fe=r("p"),fe.innerHTML=gn,_a=n(),ue=r("p"),ue.innerHTML=_n,Ma=n(),ge=r("p"),ge.innerHTML=Mn,va=n(),_e=r("p"),_e.innerHTML=vn,ba=n(),Me=r("p"),Me.innerHTML=bn,ya=n(),ve=r("p"),ve.innerHTML=yn,Ta=n(),be=r("p"),be.innerHTML=Tn,wa=n(),ye=r("p"),ye.innerHTML=wn,Ja=n(),Te=r("p"),Te.innerHTML=Jn,Ua=n(),we=r("p"),we.innerHTML=Un,Ca=n(),c(Je.$$.fragment),ja=n(),Ue=r("p"),Ue.innerHTML=Cn,xa=n(),Ce=r("p"),Ce.innerHTML=jn,Ia=n(),c(je.$$.fragment),$a=n(),xe=r("p"),xe.textContent=xn,Oa=n(),Ie=r("ul"),Ie.innerHTML=In,Pa=n(),c($e.$$.fragment),Da=n(),Oe=r("p"),Oe.innerHTML=$n,ka=n(),Pe=r("table"),Pe.innerHTML=On,Fa=n(),De=r("p"),De.innerHTML=Pn,Aa=n(),c(ke.$$.fragment),Na=n(),Fe=r("p"),Fe.innerHTML=Dn,Ea=n(),c(Ae.$$.fragment),qa=n(),Ne=r("p"),Ne.textContent=kn,La=n(),Ee=r("ol"),Ee.innerHTML=Fn,Ra=n(),c(qe.$$.fragment),Ba=n(),Le=r("p"),Le.innerHTML=An,Za=n(),Re=r("p"),Re.textContent=Nn,Wa=n(),c(Be.$$.fragment),Ha=n(),Ze=r("p"),Ze.textContent=En,za=n(),We=r("p"),We.textContent=qn,Qa=n(),c(He.$$.fragment),Ga=n(),c(ze.$$.fragment),Sa=n(),p=r("div"),c(Qe.$$.fragment),mo=n(),ct=r("p"),ct.textContent=Ln,ho=n(),O=r("div"),c(Ge.$$.fragment),fo=n(),mt=r("p"),mt.innerHTML=Rn,uo=n(),P=r("div"),c(Se.$$.fragment),go=n(),ht=r("p"),ht.textContent=Bn,_o=n(),w=r("div"),c(Xe.$$.fragment),Mo=n(),ft=r("p"),ft.textContent=Zn,vo=n(),ut=r("p"),ut.textContent=Wn,bo=n(),D=r("div"),c(Ye.$$.fragment),yo=n(),gt=r("p"),gt.textContent=Hn,To=n(),k=r("div"),c(Ve.$$.fragment),wo=n(),_t=r("p"),_t.textContent=zn,Jo=n(),J=r("div"),c(Ke.$$.fragment),Uo=n(),Mt=r("p"),Mt.innerHTML=Qn,Co=n(),vt=r("p"),vt.textContent=Gn,jo=n(),F=r("div"),c(et.$$.fragment),xo=n(),bt=r("p"),bt.textContent=Sn,Io=n(),A=r("div"),c(tt.$$.fragment),$o=n(),yt=r("p"),yt.textContent=Xn,Oo=n(),N=r("div"),c(at.$$.fragment),Po=n(),Tt=r("p"),Tt.textContent=Yn,Do=n(),U=r("div"),c(ot.$$.fragment),ko=n(),wt=r("p"),wt.innerHTML=Vn,Fo=n(),Jt=r("p"),Jt.innerHTML=Kn,Ao=n(),C=r("div"),c(nt.$$.fragment),No=n(),Ut=r("p"),Ut.innerHTML=el,Eo=n(),Ct=r("p"),Ct.innerHTML=tl,qo=n(),E=r("div"),c(lt.$$.fragment),Lo=n(),jt=r("p"),jt.innerHTML=al,Ro=n(),q=r("div"),c(rt.$$.fragment),Bo=n(),xt=r("p"),xt.textContent=ol,Zo=n(),T=r("div"),c(st.$$.fragment),Wo=n(),It=r("p"),It.textContent=nl,Ho=n(),$t=r("p"),$t.textContent=ll,zo=n(),Ot=r("p"),Ot.textContent=rl,Xa=n(),c(it.$$.fragment),Ya=n(),x=r("div"),c(dt.$$.fragment),Qo=n(),Pt=r("p"),Pt.textContent=sl,Va=n(),c(pt.$$.fragment),Ka=n(),Et=r("p"),this.h()},l(e){const t=fl("svelte-u9bgzb",document.head);j=s(t,"META",{name:!0,content:!0}),t.forEach(a),Lt=l(e),Nt=s(e,"P",{}),v(Nt).forEach(a),Rt=l(e),m(R.$$.fragment,e),Bt=l(e),B=s(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-5p7twb"&&(B.innerHTML=So),Zt=l(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-xh4sh7"&&(Z.textContent=Xo),Wt=l(e),m(W.$$.fragment,e),Ht=l(e),H=s(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-e9zjgv"&&(H.textContent=Yo),zt=l(e),z=s(e,"OL",{"data-svelte-h":!0}),d(z)!=="svelte-1fzn07o"&&(z.innerHTML=Vo),Qt=l(e),Q=s(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-11tyi92"&&(Q.innerHTML=Ko),Gt=l(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-lms3te"&&(G.innerHTML=en),St=l(e),I=s(e,"IMG",{width:!0,alt:!0,src:!0}),Xt=l(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1yw8azb"&&(S.innerHTML=an),Yt=l(e),m(X.$$.fragment,e),Vt=l(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-dcawbe"&&(Y.innerHTML=on),Kt=l(e),$=s(e,"DIV",{style:!0,"data-svelte-h":!0}),d($)!=="svelte-z15c7z"&&($.innerHTML=nn),ea=l(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-cb9b0v"&&(V.innerHTML=ln),ta=l(e),K=s(e,"UL",{"data-svelte-h":!0}),d(K)!=="svelte-17vxuta"&&(K.innerHTML=rn),aa=l(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1gl9mvz"&&(ee.textContent=sn),oa=l(e),m(te.$$.fragment,e),na=l(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1a8oxjk"&&(ae.innerHTML=dn),la=l(e),m(oe.$$.fragment,e),ra=l(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-174yw9s"&&(ne.innerHTML=pn),sa=l(e),m(le.$$.fragment,e),ia=l(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1wn9xrv"&&(re.innerHTML=cn),da=l(e),m(se.$$.fragment,e),pa=l(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1lg6q1l"&&(ie.textContent=mn),ca=l(e),m(de.$$.fragment,e),ma=l(e),pe=s(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1ac5mum"&&(pe.innerHTML=hn),ha=l(e),m(ce.$$.fragment,e),fa=l(e),me=s(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-7nvktz"&&(me.innerHTML=fn),ua=l(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-bl9wh7"&&(he.innerHTML=un),ga=l(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1quvcuu"&&(fe.innerHTML=gn),_a=l(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-kuakol"&&(ue.innerHTML=_n),Ma=l(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-17kcyul"&&(ge.innerHTML=Mn),va=l(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-42riix"&&(_e.innerHTML=vn),ba=l(e),Me=s(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-nj941x"&&(Me.innerHTML=bn),ya=l(e),ve=s(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1nc29ji"&&(ve.innerHTML=yn),Ta=l(e),be=s(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-f69fd8"&&(be.innerHTML=Tn),wa=l(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1jgk22r"&&(ye.innerHTML=wn),Ja=l(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1r1f45a"&&(Te.innerHTML=Jn),Ua=l(e),we=s(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-17fvv4d"&&(we.innerHTML=Un),Ca=l(e),m(Je.$$.fragment,e),ja=l(e),Ue=s(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-3kfva2"&&(Ue.innerHTML=Cn),xa=l(e),Ce=s(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1c01yo3"&&(Ce.innerHTML=jn),Ia=l(e),m(je.$$.fragment,e),$a=l(e),xe=s(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-132s7j9"&&(xe.textContent=xn),Oa=l(e),Ie=s(e,"UL",{"data-svelte-h":!0}),d(Ie)!=="svelte-1oji3mm"&&(Ie.innerHTML=In),Pa=l(e),m($e.$$.fragment,e),Da=l(e),Oe=s(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-2145zu"&&(Oe.innerHTML=$n),ka=l(e),Pe=s(e,"TABLE",{"data-svelte-h":!0}),d(Pe)!=="svelte-435mua"&&(Pe.innerHTML=On),Fa=l(e),De=s(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1p74c9x"&&(De.innerHTML=Pn),Aa=l(e),m(ke.$$.fragment,e),Na=l(e),Fe=s(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1o18rwj"&&(Fe.innerHTML=Dn),Ea=l(e),m(Ae.$$.fragment,e),qa=l(e),Ne=s(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-4infz6"&&(Ne.textContent=kn),La=l(e),Ee=s(e,"OL",{"data-svelte-h":!0}),d(Ee)!=="svelte-1p7od7"&&(Ee.innerHTML=Fn),Ra=l(e),m(qe.$$.fragment,e),Ba=l(e),Le=s(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-rqj7uy"&&(Le.innerHTML=An),Za=l(e),Re=s(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1xhv3st"&&(Re.textContent=Nn),Wa=l(e),m(Be.$$.fragment,e),Ha=l(e),Ze=s(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-a0kxee"&&(Ze.textContent=En),za=l(e),We=s(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1gkqha7"&&(We.textContent=qn),Qa=l(e),m(He.$$.fragment,e),Ga=l(e),m(ze.$$.fragment,e),Sa=l(e),p=s(e,"DIV",{class:!0});var _=v(p);m(Qe.$$.fragment,_),mo=l(_),ct=s(_,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-n6cc8y"&&(ct.textContent=Ln),ho=l(_),O=s(_,"DIV",{class:!0});var to=v(O);m(Ge.$$.fragment,to),fo=l(to),mt=s(to,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-mcz8nm"&&(mt.innerHTML=Rn),to.forEach(a),uo=l(_),P=s(_,"DIV",{class:!0});var ao=v(P);m(Se.$$.fragment,ao),go=l(ao),ht=s(ao,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-10t1062"&&(ht.textContent=Bn),ao.forEach(a),_o=l(_),w=s(_,"DIV",{class:!0});var Dt=v(w);m(Xe.$$.fragment,Dt),Mo=l(Dt),ft=s(Dt,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-16i1nac"&&(ft.textContent=Zn),vo=l(Dt),ut=s(Dt,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-tgti68"&&(ut.textContent=Wn),Dt.forEach(a),bo=l(_),D=s(_,"DIV",{class:!0});var oo=v(D);m(Ye.$$.fragment,oo),yo=l(oo),gt=s(oo,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1cvsgkk"&&(gt.textContent=Hn),oo.forEach(a),To=l(_),k=s(_,"DIV",{class:!0});var no=v(k);m(Ve.$$.fragment,no),wo=l(no),_t=s(no,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-ymgxq7"&&(_t.textContent=zn),no.forEach(a),Jo=l(_),J=s(_,"DIV",{class:!0});var kt=v(J);m(Ke.$$.fragment,kt),Uo=l(kt),Mt=s(kt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-8qlty5"&&(Mt.innerHTML=Qn),Co=l(kt),vt=s(kt,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1tyo99t"&&(vt.textContent=Gn),kt.forEach(a),jo=l(_),F=s(_,"DIV",{class:!0});var lo=v(F);m(et.$$.fragment,lo),xo=l(lo),bt=s(lo,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-4nmimv"&&(bt.textContent=Sn),lo.forEach(a),Io=l(_),A=s(_,"DIV",{class:!0});var ro=v(A);m(tt.$$.fragment,ro),$o=l(ro),yt=s(ro,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-11q8u7l"&&(yt.textContent=Xn),ro.forEach(a),Oo=l(_),N=s(_,"DIV",{class:!0});var so=v(N);m(at.$$.fragment,so),Po=l(so),Tt=s(so,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-18uwvbi"&&(Tt.textContent=Yn),so.forEach(a),Do=l(_),U=s(_,"DIV",{class:!0});var Ft=v(U);m(ot.$$.fragment,Ft),ko=l(Ft),wt=s(Ft,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-xesobz"&&(wt.innerHTML=Vn),Fo=l(Ft),Jt=s(Ft,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-qg43tm"&&(Jt.innerHTML=Kn),Ft.forEach(a),Ao=l(_),C=s(_,"DIV",{class:!0});var At=v(C);m(nt.$$.fragment,At),No=l(At),Ut=s(At,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-dkae9b"&&(Ut.innerHTML=el),Eo=l(At),Ct=s(At,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-hmd5cw"&&(Ct.innerHTML=tl),At.forEach(a),qo=l(_),E=s(_,"DIV",{class:!0});var io=v(E);m(lt.$$.fragment,io),Lo=l(io),jt=s(io,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-nqksfz"&&(jt.innerHTML=al),io.forEach(a),Ro=l(_),q=s(_,"DIV",{class:!0});var po=v(q);m(rt.$$.fragment,po),Bo=l(po),xt=s(po,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-17kjsy4"&&(xt.textContent=ol),po.forEach(a),Zo=l(_),T=s(_,"DIV",{class:!0});var L=v(T);m(st.$$.fragment,L),Wo=l(L),It=s(L,"P",{"data-svelte-h":!0}),d(It)!=="svelte-1861yti"&&(It.textContent=nl),Ho=l(L),$t=s(L,"P",{"data-svelte-h":!0}),d($t)!=="svelte-1mn1gnw"&&($t.textContent=ll),zo=l(L),Ot=s(L,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-1xvpyih"&&(Ot.textContent=rl),L.forEach(a),_.forEach(a),Xa=l(e),m(it.$$.fragment,e),Ya=l(e),x=s(e,"DIV",{class:!0});var co=v(x);m(dt.$$.fragment,co),Qo=l(co),Pt=s(co,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1va94c9"&&(Pt.textContent=sl),co.forEach(a),Va=l(e),m(pt.$$.fragment,e),Ka=l(e),Et=s(e,"P",{}),v(Et).forEach(a),this.h()},h(){M(j,"name","hf:doc:metadata"),M(j,"content",Ml),M(I,"width","835"),M(I,"alt","Screenshot 2024-03-19 at 12 39 41"),dl(I.src,tn="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d")||M(I,"src",tn),ul($,"text-align","center"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,j),o(e,Lt,t),o(e,Nt,t),o(e,Rt,t),h(R,e,t),o(e,Bt,t),o(e,B,t),o(e,Zt,t),o(e,Z,t),o(e,Wt,t),h(W,e,t),o(e,Ht,t),o(e,H,t),o(e,zt,t),o(e,z,t),o(e,Qt,t),o(e,Q,t),o(e,Gt,t),o(e,G,t),o(e,St,t),o(e,I,t),o(e,Xt,t),o(e,S,t),o(e,Yt,t),h(X,e,t),o(e,Vt,t),o(e,Y,t),o(e,Kt,t),o(e,$,t),o(e,ea,t),o(e,V,t),o(e,ta,t),o(e,K,t),o(e,aa,t),o(e,ee,t),o(e,oa,t),h(te,e,t),o(e,na,t),o(e,ae,t),o(e,la,t),h(oe,e,t),o(e,ra,t),o(e,ne,t),o(e,sa,t),h(le,e,t),o(e,ia,t),o(e,re,t),o(e,da,t),h(se,e,t),o(e,pa,t),o(e,ie,t),o(e,ca,t),h(de,e,t),o(e,ma,t),o(e,pe,t),o(e,ha,t),h(ce,e,t),o(e,fa,t),o(e,me,t),o(e,ua,t),o(e,he,t),o(e,ga,t),o(e,fe,t),o(e,_a,t),o(e,ue,t),o(e,Ma,t),o(e,ge,t),o(e,va,t),o(e,_e,t),o(e,ba,t),o(e,Me,t),o(e,ya,t),o(e,ve,t),o(e,Ta,t),o(e,be,t),o(e,wa,t),o(e,ye,t),o(e,Ja,t),o(e,Te,t),o(e,Ua,t),o(e,we,t),o(e,Ca,t),h(Je,e,t),o(e,ja,t),o(e,Ue,t),o(e,xa,t),o(e,Ce,t),o(e,Ia,t),h(je,e,t),o(e,$a,t),o(e,xe,t),o(e,Oa,t),o(e,Ie,t),o(e,Pa,t),h($e,e,t),o(e,Da,t),o(e,Oe,t),o(e,ka,t),o(e,Pe,t),o(e,Fa,t),o(e,De,t),o(e,Aa,t),h(ke,e,t),o(e,Na,t),o(e,Fe,t),o(e,Ea,t),h(Ae,e,t),o(e,qa,t),o(e,Ne,t),o(e,La,t),o(e,Ee,t),o(e,Ra,t),h(qe,e,t),o(e,Ba,t),o(e,Le,t),o(e,Za,t),o(e,Re,t),o(e,Wa,t),h(Be,e,t),o(e,Ha,t),o(e,Ze,t),o(e,za,t),o(e,We,t),o(e,Qa,t),h(He,e,t),o(e,Ga,t),h(ze,e,t),o(e,Sa,t),o(e,p,t),h(Qe,p,null),i(p,mo),i(p,ct),i(p,ho),i(p,O),h(Ge,O,null),i(O,fo),i(O,mt),i(p,uo),i(p,P),h(Se,P,null),i(P,go),i(P,ht),i(p,_o),i(p,w),h(Xe,w,null),i(w,Mo),i(w,ft),i(w,vo),i(w,ut),i(p,bo),i(p,D),h(Ye,D,null),i(D,yo),i(D,gt),i(p,To),i(p,k),h(Ve,k,null),i(k,wo),i(k,_t),i(p,Jo),i(p,J),h(Ke,J,null),i(J,Uo),i(J,Mt),i(J,Co),i(J,vt),i(p,jo),i(p,F),h(et,F,null),i(F,xo),i(F,bt),i(p,Io),i(p,A),h(tt,A,null),i(A,$o),i(A,yt),i(p,Oo),i(p,N),h(at,N,null),i(N,Po),i(N,Tt),i(p,Do),i(p,U),h(ot,U,null),i(U,ko),i(U,wt),i(U,Fo),i(U,Jt),i(p,Ao),i(p,C),h(nt,C,null),i(C,No),i(C,Ut),i(C,Eo),i(C,Ct),i(p,qo),i(p,E),h(lt,E,null),i(E,Lo),i(E,jt),i(p,Ro),i(p,q),h(rt,q,null),i(q,Bo),i(q,xt),i(p,Zo),i(p,T),h(st,T,null),i(T,Wo),i(T,It),i(T,Ho),i(T,$t),i(T,zo),i(T,Ot),o(e,Xa,t),h(it,e,t),o(e,Ya,t),o(e,x,t),h(dt,x,null),i(x,Qo),i(x,Pt),o(e,Va,t),h(pt,e,t),o(e,Ka,t),o(e,Et,t),eo=!0},p:pl,i(e){eo||(f(R.$$.fragment,e),f(W.$$.fragment,e),f(X.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(le.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(Je.$$.fragment,e),f(je.$$.fragment,e),f($e.$$.fragment,e),f(ke.$$.fragment,e),f(Ae.$$.fragment,e),f(qe.$$.fragment,e),f(Be.$$.fragment,e),f(He.$$.fragment,e),f(ze.$$.fragment,e),f(Qe.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Xe.$$.fragment,e),f(Ye.$$.fragment,e),f(Ve.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(lt.$$.fragment,e),f(rt.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(dt.$$.fragment,e),f(pt.$$.fragment,e),eo=!0)},o(e){u(R.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u($e.$$.fragment,e),u(ke.$$.fragment,e),u(Ae.$$.fragment,e),u(qe.$$.fragment,e),u(Be.$$.fragment,e),u(He.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(Ye.$$.fragment,e),u(Ve.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(lt.$$.fragment,e),u(rt.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),eo=!1},d(e){e&&(a(Lt),a(Nt),a(Rt),a(Bt),a(B),a(Zt),a(Z),a(Wt),a(Ht),a(H),a(zt),a(z),a(Qt),a(Q),a(Gt),a(G),a(St),a(I),a(Xt),a(S),a(Yt),a(Vt),a(Y),a(Kt),a($),a(ea),a(V),a(ta),a(K),a(aa),a(ee),a(oa),a(na),a(ae),a(la),a(ra),a(ne),a(sa),a(ia),a(re),a(da),a(pa),a(ie),a(ca),a(ma),a(pe),a(ha),a(fa),a(me),a(ua),a(he),a(ga),a(fe),a(_a),a(ue),a(Ma),a(ge),a(va),a(_e),a(ba),a(Me),a(ya),a(ve),a(Ta),a(be),a(wa),a(ye),a(Ja),a(Te),a(Ua),a(we),a(Ca),a(ja),a(Ue),a(xa),a(Ce),a(Ia),a($a),a(xe),a(Oa),a(Ie),a(Pa),a(Da),a(Oe),a(ka),a(Pe),a(Fa),a(De),a(Aa),a(Na),a(Fe),a(Ea),a(qa),a(Ne),a(La),a(Ee),a(Ra),a(Ba),a(Le),a(Za),a(Re),a(Wa),a(Ha),a(Ze),a(za),a(We),a(Qa),a(Ga),a(Sa),a(p),a(Xa),a(Ya),a(x),a(Va),a(Ka),a(Et)),a(j),g(R,e),g(W,e),g(X,e),g(te,e),g(oe,e),g(le,e),g(se,e),g(de,e),g(ce,e),g(Je,e),g(je,e),g($e,e),g(ke,e),g(Ae,e),g(qe,e),g(Be,e),g(He,e),g(ze,e),g(Qe),g(Ge),g(Se),g(Xe),g(Ye),g(Ve),g(Ke),g(et),g(tt),g(at),g(ot),g(nt),g(lt),g(rt),g(st),g(it,e),g(dt),g(pt,e)}}}const Ml='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"How DPO works","local":"how-dpo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2}],"depth":1}';function vl(Go){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ul extends ml{constructor(j){super(),hl(this,j,vl,_l,il,{})}}export{Ul as component};
