import{s as cn,o as fn,n as Rt}from"../chunks/scheduler.8c3d61f6.js";import{S as un,i as hn,g as f,s as o,r as a,A as gn,h as u,f as n,c as l,j as Ce,u as r,x as g,k as Se,y as $,a as s,v as p,d,t as m,w as c}from"../chunks/index.589a98e8.js";import{T as Nt}from"../chunks/Tip.42aa8582.js";import{D as Qt}from"../chunks/Docstring.27406313.js";import{C as T}from"../chunks/CodeBlock.36627b28.js";import{E as yn}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as b,E as Mn}from"../chunks/EditOnGithub.e5a8d9cb.js";function bn(Z){let i,w="The SD3 pipeline uses three text encoders to generate an image. Model offloading is necessary in order for it to run on most commodity hardware. Please use the <code>torch.float16</code> data type for additional memory savings.";return{c(){i=f("p"),i.innerHTML=w},l(h){i=u(h,"P",{"data-svelte-h":!0}),g(i)!=="svelte-1abcova"&&(i.innerHTML=w)},m(h,M){s(h,i,M)},p:Rt,d(h){h&&n(i)}}}function wn(Z){let i,w="The prompt with the CLIP Text Encoders is still truncated to the 77 token limit.";return{c(){i=f("p"),i.textContent=w},l(h){i=u(h,"P",{"data-svelte-h":!0}),g(i)!=="svelte-1pfxyog"&&(i.textContent=w)},m(h,M){s(h,i,M)},p:Rt,d(h){h&&n(i)}}}function Tn(Z){let i,w="The following example loads a checkpoint stored in a 8-bit floating point format which requires PyTorch 2.3 or later.";return{c(){i=f("p"),i.textContent=w},l(h){i=u(h,"P",{"data-svelte-h":!0}),g(i)!=="svelte-msx2hu"&&(i.textContent=w)},m(h,M){s(h,i,M)},p:Rt,d(h){h&&n(i)}}}function _n(Z){let i,w="Examples:",h,M,_;return M=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){i=f("p"),i.textContent=w,h=o(),a(M.$$.fragment)},l(y){i=u(y,"P",{"data-svelte-h":!0}),g(i)!=="svelte-kvfsh7"&&(i.textContent=w),h=l(y),r(M.$$.fragment,y)},m(y,J){s(y,i,J),s(y,h,J),p(M,y,J),_=!0},p:Rt,i(y){_||(d(M.$$.fragment,y),_=!0)},o(y){m(M.$$.fragment,y),_=!1},d(y){y&&(n(i),n(h)),c(M,y)}}}function Jn(Z){let i,w,h,M,_,y,J,Et='Stable Diffusion 3 (SD3) was proposed in <a href="https://arxiv.org/pdf/2403.03206.pdf" rel="nofollow">Scaling Rectified Flow Transformers for High-Resolution Image Synthesis</a> by Patrick Esser, Sumith Kulal, Andreas Blattmann, Rahim Entezari, Jonas Muller, Harry Saini, Yam Levi, Dominik Lorenz, Axel Sauer, Frederic Boesel, Dustin Podell, Tim Dockhorn, Zion English, Kyle Lacey, Alex Goodwin, Yannik Marek, and Robin Rombach.',Re,x,Dt="The abstract from the paper is:",Xe,C,Ht="<em>Diffusion models create data from noise by inverting the forward paths of data towards noise and have emerged as a powerful generative modeling technique for high-dimensional, perceptual data such as images and videos. Rectified flow is a recent generative model formulation that connects data and noise in a straight line. Despite its better theoretical properties and conceptual simplicity, it is not yet decisively established as standard practice. In this work, we improve existing noise sampling techniques for training rectified flow models by biasing them towards perceptually relevant scales. Through a large-scale study, we demonstrate the superior performance of this approach compared to established diffusion formulations for high-resolution text-to-image synthesis. Additionally, we present a novel transformer-based architecture for text-to-image generation that uses separate weights for the two modalities and enables a bidirectional flow of information between image and text tokens, improving text comprehension typography, and human preference ratings. We demonstrate that this architecture follows predictable scaling trends and correlates lower validation loss to improved text-to-image synthesis as measured by various metrics and human evaluations.</em>",Ye,S,Ve,R,Ft='<em>As the model is gated, before using it with diffusers you first need to go to the <a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow">Stable Diffusion 3 Medium Hugging Face page</a>, fill in the form and accept the gate. Once you are in, you need to login so that your system knows you’ve accepted the gate.</em>',ze,X,Pt="Use the command below to log in:",Ne,Y,Qe,v,Ee,V,De,z,He,N,Lt="SD3 uses three text encoders, one if which is the very large T5-XXL model. This makes it challenging to run the model on GPUs with less than 24GB of VRAM, even when using <code>fp16</code> precision. The following section outlines a few memory optimizations in Diffusers that make it easier to run SD3 on low resource hardware.",Fe,Q,Pe,E,qt="The most basic memory optimization available in Diffusers allows you to offload the components of the model to CPU during inference in order to save memory, while seeing a slight increase in inference latency. Model offloading will only move a model component onto the GPU when it needs to be executed, while keeping the remaining components on the CPU.",Le,D,qe,H,Ae,F,At="Removing the memory-intensive 4.7B parameter T5-XXL text encoder during inference can significantly decrease the memory requirements for SD3 with only a slight loss in performance.",Oe,P,Ke,L,et,q,Ot="We can leverage the <code>bitsandbytes</code> library to load and quantize the T5-XXL text encoder to 8-bit precision. This allows you to keep using all three text encoders while only slightly impacting performance.",tt,A,Kt="First install the <code>bitsandbytes</code> library.",nt,O,st,K,en="Then load the T5-XXL model using the <code>BitsAndBytesConfig</code>.",ot,ee,lt,te,tn='You can find the end-to-end script <a href="https://gist.github.com/sayakpaul/82acb5976509851f2db1a83456e504f1" rel="nofollow">here</a>.',it,ne,at,se,rt,oe,nn="Using compiled components in the SD3 pipeline can speed up inference by as much as 4X. The following code snippet demonstrates how to compile the Transformer and VAE components of the SD3 pipeline.",pt,le,dt,ie,sn='Check out the full script <a href="https://gist.github.com/sayakpaul/508d89d7aad4f454900813da5d42ca97" rel="nofollow">here</a>.',mt,ae,ct,re,on="By default, the T5 Text Encoder prompt uses a maximum sequence length of <code>256</code>. This can be adjusted by setting the <code>max_sequence_length</code> to accept fewer or more tokens. Keep in mind that longer sequences require additional resources and result in longer generation times, such as during batch inference.",ft,pe,ut,de,ht,me,ln="You can send a different prompt to the CLIP Text Encoders and the T5 Text Encoder to prevent the prompt from being truncated by the CLIP Text Encoders and to improve generation.",gt,G,yt,ce,Mt,fe,bt,ue,an='Tiny AutoEncoder for Stable Diffusion (TAESD3) is a tiny distilled version of Stable Diffusion 3’s VAE by <a href="https://github.com/madebyollin/taesd" rel="nofollow">Ollin Boer Bohan</a> that can decode <a href="/docs/diffusers/pr_7790/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a> latents almost instantly.',wt,he,rn="To use with Stable Diffusion 3:",Tt,ge,_t,ye,Jt,Me,pn="The <code>SD3Transformer2DModel</code> and <code>StableDiffusion3Pipeline</code> classes support loading the original checkpoints via the <code>from_single_file</code> method. This method allows you to load the original checkpoint files that were used to train the models.",Ut,be,Zt,we,jt,Te,It,_e,Bt,Je,vt,Ue,Gt,W,Wt,Ze,kt,je,$t,U,Ie,Xt,j,Be,Yt,We,dn="Function invoked when calling the pipeline for generation.",Vt,k,zt,ke,ve,xt,Ge,Ct,$e,St;return _=new b({props:{title:"Stable Diffusion 3",local:"stable-diffusion-3",headingTag:"h1"}}),S=new b({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),Y=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),v=new Nt({props:{$$slots:{default:[bn]},$$scope:{ctx:Z}}}),V=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),z=new b({props:{title:"Memory Optimisations for SD3",local:"memory-optimisations-for-sd3",headingTag:"h2"}}),Q=new b({props:{title:"Running Inference with Model Offloading",local:"running-inference-with-model-offloading",headingTag:"h3"}}),D=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),H=new b({props:{title:"Dropping the T5 Text Encoder during Inference",local:"dropping-the-t5-text-encoder-during-inference",headingTag:"h3"}}),P=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLW5vLVQ1LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    text_encoder_3=<span class="hljs-literal">None</span>,
    tokenizer_3=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-no-T5.png&quot;</span>)`,wrap:!1}}),L=new b({props:{title:"Using a Quantized Version of the T5 Text Encoder",local:"using-a-quantized-version-of-the-t5-text-encoder",headingTag:"h3"}}),O=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),ee=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8zJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMyUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENy4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJzZDNfaGVsbG9fd29ybGQtOGJpdC1UNS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;text_encoder_3&quot;</span>,
    quantization_config=quantization_config,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    model_id,
    text_encoder_3=text_encoder,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    torch_dtype=torch.float16
)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-8bit-T5.png&quot;</span>)`,wrap:!1}}),ne=new b({props:{title:"Performance Optimizations for SD3",local:"performance-optimizations-for-sd3",headingTag:"h2"}}),se=new b({props:{title:"Using Torch Compile to Speed Up Inference",local:"using-torch-compile-to-speed-up-inference",headingTag:"h3"}}),le=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdG9yY2guc2V0X2Zsb2F0MzJfbWF0bXVsX3ByZWNpc2lvbiglMjJoaWdoJTIyKSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0tZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2V0X3Byb2dyZXNzX2Jhcl9jb25maWcoZGlzYWJsZSUzRFRydWUpJTBBJTBBcGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEElMEFwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBcGlwZS52YWUuZGVjb2RlJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnZhZS5kZWNvZGUlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBXYXJtJTIwVXAlMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDEpKSUwQSUwQSUyMyUyMFJ1biUyMEluZmVyZW5jZSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgxKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

torch.set_float32_matmul_precision(<span class="hljs-string">&quot;high&quot;</span>)

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

pipe.transformer.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)

pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Warm Up</span>
prompt = <span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    _ = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>))

<span class="hljs-comment"># Run Inference</span>
image = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>)).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),ae=new b({props:{title:"Using Long Prompts with the T5 Text Encoder",local:"using-long-prompts-with-the-t5-text-encoder",headingTag:"h2"}}),pe=new T({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. It features the distinctive, bulky body shape of a hippo. However, instead of the usual grey skin, the creature’s body resembles a golden-brown, crispy waffle fresh off the griddle. The skin is textured with the familiar grid pattern of a waffle, each square filled with a glistening sheen of syrup. The environment combines the natural habitat of a hippo with elements of a breakfast table setting, a river of warm, melted butter, with oversized utensils or plates peeking out from the lush, pancake-like foliage in the background, a towering pepper mill standing in for a tree.  As the sun rises in this fantastical world, it casts a warm, buttery glow over the scene. The creature, content in its butter river, lets out a yawn. Nearby, a flock of birds take flight&quot;</span>

image = pipe(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    guidance_scale=<span class="hljs-number">4.5</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new b({props:{title:"Sending a different prompt to the T5 Text Encoder",local:"sending-a-different-prompt-to-the-t5-text-encoder",headingTag:"h3"}}),G=new Nt({props:{$$slots:{default:[wn]},$$scope:{ctx:Z}}}),ce=new T({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. A river of warm, melted butter, pancake-like foliage in the background, a towering pepper mill standing in for a tree.&quot;</span>

prompt_3 = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. It features the distinctive, bulky body shape of a hippo. However, instead of the usual grey skin, the creature’s body resembles a golden-brown, crispy waffle fresh off the griddle. The skin is textured with the familiar grid pattern of a waffle, each square filled with a glistening sheen of syrup. The environment combines the natural habitat of a hippo with elements of a breakfast table setting, a river of warm, melted butter, with oversized utensils or plates peeking out from the lush, pancake-like foliage in the background, a towering pepper mill standing in for a tree.  As the sun rises in this fantastical world, it casts a warm, buttery glow over the scene. The creature, content in its butter river, lets out a yawn. Nearby, a flock of birds take flight&quot;</span>

image = pipe(
    prompt=prompt,
    prompt_3=prompt_3,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    guidance_scale=<span class="hljs-number">4.5</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),fe=new b({props:{title:"Tiny AutoEncoder for Stable Diffusion 3",local:"tiny-autoencoder-for-stable-diffusion-3",headingTag:"h2"}}),ge=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTJDJTIwQXV0b2VuY29kZXJUaW55JTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZDMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJzbGljZSUyMG9mJTIwZGVsaWNpb3VzJTIwTmV3JTIwWW9yay1zdHlsZSUyMGJlcnJ5JTIwY2hlZXNlY2FrZSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoZWVzZWNha2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline, AutoencoderTiny

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesd3&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cheesecake.png&quot;</span>)`,wrap:!1}}),ye=new b({props:{title:"Loading the original checkpoints via from_single_file",local:"loading-the-original-checkpoints-via-fromsinglefile",headingTag:"h2"}}),be=new b({props:{title:"Loading the original checkpoints for the SD3Transformer2DModel",local:"loading-the-original-checkpoints-for-the-sd3transformer2dmodel",headingTag:"h2"}}),we=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fc2luZ2xlX2ZpbGUoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bSUyRmJsb2IlMkZtYWluJTJGc2QzX21lZGl1bS5zYWZldGVuc29ycyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel

model = SD3Transformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium.safetensors&quot;</span>)`,wrap:!1}}),Te=new b({props:{title:"Loading the single checkpoint for the StableDiffusion3Pipeline",local:"loading-the-single-checkpoint-for-the-stablediffusion3pipeline",headingTag:"h2"}}),_e=new b({props:{title:"Loading the single file checkpoint without T5",local:"loading-the-single-file-checkpoint-without-t5",headingTag:"h3"}}),Je=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwcy5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLnBuZycp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips.safetensors&quot;</span>,
    torch_dtype=torch.float16,
    text_encoder_3=<span class="hljs-literal">None</span>
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file.png&#x27;</span>)`,wrap:!1}}),Ue=new b({props:{title:"Loading the single file checkpoint with T5",local:"loading-the-single-file-checkpoint-with-t5",headingTag:"h3"}}),W=new Nt({props:{warning:!1,$$slots:{default:[Tn]},$$scope:{ctx:Z}}}),Ze=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwc190NXh4bGZwOC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLXQ1LWZwOC5wbmcnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips_t5xxlfp8.safetensors&quot;</span>,
    torch_dtype=torch.float16,
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file-t5-fp8.png&#x27;</span>)`,wrap:!1}}),je=new b({props:{title:"StableDiffusion3Pipeline",local:"diffusers.StableDiffusion3Pipeline",headingTag:"h2"}}),Ie=new Qt({props:{name:"class diffusers.StableDiffusion3Pipeline",anchor:"diffusers.StableDiffusion3Pipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_7790/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_7790/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_7790/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"}],source:"https://github.com/huggingface/diffusers/blob/vr_7790/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L131"}}),Be=new Qt({props:{name:"__call__",anchor:"diffusers.StableDiffusion3Pipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"prompt_3",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 28"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_3",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_7790/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),k=new yn({props:{anchor:"diffusers.StableDiffusion3Pipeline.__call__.example",$$slots:{default:[_n]},$$scope:{ctx:Z}}}),ve=new Qt({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"prompt_2",val:": Union"},{name:"prompt_3",val:": Union"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"negative_prompt_3",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"max_sequence_length",val:": int = 256"},{name:"lora_scale",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_7790/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L318"}}),Ge=new Mn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/stable_diffusion_3.md"}}),{c(){i=f("meta"),w=o(),h=f("p"),M=o(),a(_.$$.fragment),y=o(),J=f("p"),J.innerHTML=Et,Re=o(),x=f("p"),x.textContent=Dt,Xe=o(),C=f("p"),C.innerHTML=Ht,Ye=o(),a(S.$$.fragment),Ve=o(),R=f("p"),R.innerHTML=Ft,ze=o(),X=f("p"),X.textContent=Pt,Ne=o(),a(Y.$$.fragment),Qe=o(),a(v.$$.fragment),Ee=o(),a(V.$$.fragment),De=o(),a(z.$$.fragment),He=o(),N=f("p"),N.innerHTML=Lt,Fe=o(),a(Q.$$.fragment),Pe=o(),E=f("p"),E.textContent=qt,Le=o(),a(D.$$.fragment),qe=o(),a(H.$$.fragment),Ae=o(),F=f("p"),F.textContent=At,Oe=o(),a(P.$$.fragment),Ke=o(),a(L.$$.fragment),et=o(),q=f("p"),q.innerHTML=Ot,tt=o(),A=f("p"),A.innerHTML=Kt,nt=o(),a(O.$$.fragment),st=o(),K=f("p"),K.innerHTML=en,ot=o(),a(ee.$$.fragment),lt=o(),te=f("p"),te.innerHTML=tn,it=o(),a(ne.$$.fragment),at=o(),a(se.$$.fragment),rt=o(),oe=f("p"),oe.textContent=nn,pt=o(),a(le.$$.fragment),dt=o(),ie=f("p"),ie.innerHTML=sn,mt=o(),a(ae.$$.fragment),ct=o(),re=f("p"),re.innerHTML=on,ft=o(),a(pe.$$.fragment),ut=o(),a(de.$$.fragment),ht=o(),me=f("p"),me.textContent=ln,gt=o(),a(G.$$.fragment),yt=o(),a(ce.$$.fragment),Mt=o(),a(fe.$$.fragment),bt=o(),ue=f("p"),ue.innerHTML=an,wt=o(),he=f("p"),he.textContent=rn,Tt=o(),a(ge.$$.fragment),_t=o(),a(ye.$$.fragment),Jt=o(),Me=f("p"),Me.innerHTML=pn,Ut=o(),a(be.$$.fragment),Zt=o(),a(we.$$.fragment),jt=o(),a(Te.$$.fragment),It=o(),a(_e.$$.fragment),Bt=o(),a(Je.$$.fragment),vt=o(),a(Ue.$$.fragment),Gt=o(),a(W.$$.fragment),Wt=o(),a(Ze.$$.fragment),kt=o(),a(je.$$.fragment),$t=o(),U=f("div"),a(Ie.$$.fragment),Xt=o(),j=f("div"),a(Be.$$.fragment),Yt=o(),We=f("p"),We.textContent=dn,Vt=o(),a(k.$$.fragment),zt=o(),ke=f("div"),a(ve.$$.fragment),xt=o(),a(Ge.$$.fragment),Ct=o(),$e=f("p"),this.h()},l(e){const t=gn("svelte-u9bgzb",document.head);i=u(t,"META",{name:!0,content:!0}),t.forEach(n),w=l(e),h=u(e,"P",{}),Ce(h).forEach(n),M=l(e),r(_.$$.fragment,e),y=l(e),J=u(e,"P",{"data-svelte-h":!0}),g(J)!=="svelte-3c386r"&&(J.innerHTML=Et),Re=l(e),x=u(e,"P",{"data-svelte-h":!0}),g(x)!=="svelte-1cwsb16"&&(x.textContent=Dt),Xe=l(e),C=u(e,"P",{"data-svelte-h":!0}),g(C)!=="svelte-vkvbjo"&&(C.innerHTML=Ht),Ye=l(e),r(S.$$.fragment,e),Ve=l(e),R=u(e,"P",{"data-svelte-h":!0}),g(R)!=="svelte-mtsbjp"&&(R.innerHTML=Ft),ze=l(e),X=u(e,"P",{"data-svelte-h":!0}),g(X)!=="svelte-12sg8l0"&&(X.textContent=Pt),Ne=l(e),r(Y.$$.fragment,e),Qe=l(e),r(v.$$.fragment,e),Ee=l(e),r(V.$$.fragment,e),De=l(e),r(z.$$.fragment,e),He=l(e),N=u(e,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1ovwj93"&&(N.innerHTML=Lt),Fe=l(e),r(Q.$$.fragment,e),Pe=l(e),E=u(e,"P",{"data-svelte-h":!0}),g(E)!=="svelte-uyrglw"&&(E.textContent=qt),Le=l(e),r(D.$$.fragment,e),qe=l(e),r(H.$$.fragment,e),Ae=l(e),F=u(e,"P",{"data-svelte-h":!0}),g(F)!=="svelte-k4awn"&&(F.textContent=At),Oe=l(e),r(P.$$.fragment,e),Ke=l(e),r(L.$$.fragment,e),et=l(e),q=u(e,"P",{"data-svelte-h":!0}),g(q)!=="svelte-vcvc4f"&&(q.innerHTML=Ot),tt=l(e),A=u(e,"P",{"data-svelte-h":!0}),g(A)!=="svelte-1t2mxsa"&&(A.innerHTML=Kt),nt=l(e),r(O.$$.fragment,e),st=l(e),K=u(e,"P",{"data-svelte-h":!0}),g(K)!=="svelte-1pykif5"&&(K.innerHTML=en),ot=l(e),r(ee.$$.fragment,e),lt=l(e),te=u(e,"P",{"data-svelte-h":!0}),g(te)!=="svelte-bsz29z"&&(te.innerHTML=tn),it=l(e),r(ne.$$.fragment,e),at=l(e),r(se.$$.fragment,e),rt=l(e),oe=u(e,"P",{"data-svelte-h":!0}),g(oe)!=="svelte-x56fi6"&&(oe.textContent=nn),pt=l(e),r(le.$$.fragment,e),dt=l(e),ie=u(e,"P",{"data-svelte-h":!0}),g(ie)!=="svelte-d39h5a"&&(ie.innerHTML=sn),mt=l(e),r(ae.$$.fragment,e),ct=l(e),re=u(e,"P",{"data-svelte-h":!0}),g(re)!=="svelte-ejr28n"&&(re.innerHTML=on),ft=l(e),r(pe.$$.fragment,e),ut=l(e),r(de.$$.fragment,e),ht=l(e),me=u(e,"P",{"data-svelte-h":!0}),g(me)!=="svelte-1ey7u3k"&&(me.textContent=ln),gt=l(e),r(G.$$.fragment,e),yt=l(e),r(ce.$$.fragment,e),Mt=l(e),r(fe.$$.fragment,e),bt=l(e),ue=u(e,"P",{"data-svelte-h":!0}),g(ue)!=="svelte-kih9cz"&&(ue.innerHTML=an),wt=l(e),he=u(e,"P",{"data-svelte-h":!0}),g(he)!=="svelte-cj7nlj"&&(he.textContent=rn),Tt=l(e),r(ge.$$.fragment,e),_t=l(e),r(ye.$$.fragment,e),Jt=l(e),Me=u(e,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-1pvw0yz"&&(Me.innerHTML=pn),Ut=l(e),r(be.$$.fragment,e),Zt=l(e),r(we.$$.fragment,e),jt=l(e),r(Te.$$.fragment,e),It=l(e),r(_e.$$.fragment,e),Bt=l(e),r(Je.$$.fragment,e),vt=l(e),r(Ue.$$.fragment,e),Gt=l(e),r(W.$$.fragment,e),Wt=l(e),r(Ze.$$.fragment,e),kt=l(e),r(je.$$.fragment,e),$t=l(e),U=u(e,"DIV",{class:!0});var I=Ce(U);r(Ie.$$.fragment,I),Xt=l(I),j=u(I,"DIV",{class:!0});var B=Ce(j);r(Be.$$.fragment,B),Yt=l(B),We=u(B,"P",{"data-svelte-h":!0}),g(We)!=="svelte-v78lg8"&&(We.textContent=dn),Vt=l(B),r(k.$$.fragment,B),B.forEach(n),zt=l(I),ke=u(I,"DIV",{class:!0});var xe=Ce(ke);r(ve.$$.fragment,xe),xe.forEach(n),I.forEach(n),xt=l(e),r(Ge.$$.fragment,e),Ct=l(e),$e=u(e,"P",{}),Ce($e).forEach(n),this.h()},h(){Se(i,"name","hf:doc:metadata"),Se(i,"content",Un),Se(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Se(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Se(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){$(document.head,i),s(e,w,t),s(e,h,t),s(e,M,t),p(_,e,t),s(e,y,t),s(e,J,t),s(e,Re,t),s(e,x,t),s(e,Xe,t),s(e,C,t),s(e,Ye,t),p(S,e,t),s(e,Ve,t),s(e,R,t),s(e,ze,t),s(e,X,t),s(e,Ne,t),p(Y,e,t),s(e,Qe,t),p(v,e,t),s(e,Ee,t),p(V,e,t),s(e,De,t),p(z,e,t),s(e,He,t),s(e,N,t),s(e,Fe,t),p(Q,e,t),s(e,Pe,t),s(e,E,t),s(e,Le,t),p(D,e,t),s(e,qe,t),p(H,e,t),s(e,Ae,t),s(e,F,t),s(e,Oe,t),p(P,e,t),s(e,Ke,t),p(L,e,t),s(e,et,t),s(e,q,t),s(e,tt,t),s(e,A,t),s(e,nt,t),p(O,e,t),s(e,st,t),s(e,K,t),s(e,ot,t),p(ee,e,t),s(e,lt,t),s(e,te,t),s(e,it,t),p(ne,e,t),s(e,at,t),p(se,e,t),s(e,rt,t),s(e,oe,t),s(e,pt,t),p(le,e,t),s(e,dt,t),s(e,ie,t),s(e,mt,t),p(ae,e,t),s(e,ct,t),s(e,re,t),s(e,ft,t),p(pe,e,t),s(e,ut,t),p(de,e,t),s(e,ht,t),s(e,me,t),s(e,gt,t),p(G,e,t),s(e,yt,t),p(ce,e,t),s(e,Mt,t),p(fe,e,t),s(e,bt,t),s(e,ue,t),s(e,wt,t),s(e,he,t),s(e,Tt,t),p(ge,e,t),s(e,_t,t),p(ye,e,t),s(e,Jt,t),s(e,Me,t),s(e,Ut,t),p(be,e,t),s(e,Zt,t),p(we,e,t),s(e,jt,t),p(Te,e,t),s(e,It,t),p(_e,e,t),s(e,Bt,t),p(Je,e,t),s(e,vt,t),p(Ue,e,t),s(e,Gt,t),p(W,e,t),s(e,Wt,t),p(Ze,e,t),s(e,kt,t),p(je,e,t),s(e,$t,t),s(e,U,t),p(Ie,U,null),$(U,Xt),$(U,j),p(Be,j,null),$(j,Yt),$(j,We),$(j,Vt),p(k,j,null),$(U,zt),$(U,ke),p(ve,ke,null),s(e,xt,t),p(Ge,e,t),s(e,Ct,t),s(e,$e,t),St=!0},p(e,[t]){const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),v.$set(I);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),G.$set(B);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),W.$set(xe);const mn={};t&2&&(mn.$$scope={dirty:t,ctx:e}),k.$set(mn)},i(e){St||(d(_.$$.fragment,e),d(S.$$.fragment,e),d(Y.$$.fragment,e),d(v.$$.fragment,e),d(V.$$.fragment,e),d(z.$$.fragment,e),d(Q.$$.fragment,e),d(D.$$.fragment,e),d(H.$$.fragment,e),d(P.$$.fragment,e),d(L.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ne.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(G.$$.fragment,e),d(ce.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(we.$$.fragment,e),d(Te.$$.fragment,e),d(_e.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),d(W.$$.fragment,e),d(Ze.$$.fragment,e),d(je.$$.fragment,e),d(Ie.$$.fragment,e),d(Be.$$.fragment,e),d(k.$$.fragment,e),d(ve.$$.fragment,e),d(Ge.$$.fragment,e),St=!0)},o(e){m(_.$$.fragment,e),m(S.$$.fragment,e),m(Y.$$.fragment,e),m(v.$$.fragment,e),m(V.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(D.$$.fragment,e),m(H.$$.fragment,e),m(P.$$.fragment,e),m(L.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(G.$$.fragment,e),m(ce.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(ye.$$.fragment,e),m(be.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(_e.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(W.$$.fragment,e),m(Ze.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(Be.$$.fragment,e),m(k.$$.fragment,e),m(ve.$$.fragment,e),m(Ge.$$.fragment,e),St=!1},d(e){e&&(n(w),n(h),n(M),n(y),n(J),n(Re),n(x),n(Xe),n(C),n(Ye),n(Ve),n(R),n(ze),n(X),n(Ne),n(Qe),n(Ee),n(De),n(He),n(N),n(Fe),n(Pe),n(E),n(Le),n(qe),n(Ae),n(F),n(Oe),n(Ke),n(et),n(q),n(tt),n(A),n(nt),n(st),n(K),n(ot),n(lt),n(te),n(it),n(at),n(rt),n(oe),n(pt),n(dt),n(ie),n(mt),n(ct),n(re),n(ft),n(ut),n(ht),n(me),n(gt),n(yt),n(Mt),n(bt),n(ue),n(wt),n(he),n(Tt),n(_t),n(Jt),n(Me),n(Ut),n(Zt),n(jt),n(It),n(Bt),n(vt),n(Gt),n(Wt),n(kt),n($t),n(U),n(xt),n(Ct),n($e)),n(i),c(_,e),c(S,e),c(Y,e),c(v,e),c(V,e),c(z,e),c(Q,e),c(D,e),c(H,e),c(P,e),c(L,e),c(O,e),c(ee,e),c(ne,e),c(se,e),c(le,e),c(ae,e),c(pe,e),c(de,e),c(G,e),c(ce,e),c(fe,e),c(ge,e),c(ye,e),c(be,e),c(we,e),c(Te,e),c(_e,e),c(Je,e),c(Ue,e),c(W,e),c(Ze,e),c(je,e),c(Ie),c(Be),c(k),c(ve),c(Ge,e)}}}const Un='{"title":"Stable Diffusion 3","local":"stable-diffusion-3","sections":[{"title":"Usage Example","local":"usage-example","sections":[],"depth":2},{"title":"Memory Optimisations for SD3","local":"memory-optimisations-for-sd3","sections":[{"title":"Running Inference with Model Offloading","local":"running-inference-with-model-offloading","sections":[],"depth":3},{"title":"Dropping the T5 Text Encoder during Inference","local":"dropping-the-t5-text-encoder-during-inference","sections":[],"depth":3},{"title":"Using a Quantized Version of the T5 Text Encoder","local":"using-a-quantized-version-of-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Performance Optimizations for SD3","local":"performance-optimizations-for-sd3","sections":[{"title":"Using Torch Compile to Speed Up Inference","local":"using-torch-compile-to-speed-up-inference","sections":[],"depth":3}],"depth":2},{"title":"Using Long Prompts with the T5 Text Encoder","local":"using-long-prompts-with-the-t5-text-encoder","sections":[{"title":"Sending a different prompt to the T5 Text Encoder","local":"sending-a-different-prompt-to-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Tiny AutoEncoder for Stable Diffusion 3","local":"tiny-autoencoder-for-stable-diffusion-3","sections":[],"depth":2},{"title":"Loading the original checkpoints via from_single_file","local":"loading-the-original-checkpoints-via-fromsinglefile","sections":[],"depth":2},{"title":"Loading the original checkpoints for the SD3Transformer2DModel","local":"loading-the-original-checkpoints-for-the-sd3transformer2dmodel","sections":[],"depth":2},{"title":"Loading the single checkpoint for the StableDiffusion3Pipeline","local":"loading-the-single-checkpoint-for-the-stablediffusion3pipeline","sections":[{"title":"Loading the single file checkpoint without T5","local":"loading-the-single-file-checkpoint-without-t5","sections":[],"depth":3},{"title":"Loading the single file checkpoint with T5","local":"loading-the-single-file-checkpoint-with-t5","sections":[],"depth":3}],"depth":2},{"title":"StableDiffusion3Pipeline","local":"diffusers.StableDiffusion3Pipeline","sections":[],"depth":2}],"depth":1}';function Zn(Z){return fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $n extends un{constructor(i){super(),hn(this,i,Zn,Jn,cn,{})}}export{$n as component};
