import{s as eh,n as th,o as lh}from"../chunks/scheduler.0219f8bd.js";import{S as oh,i as sh,g as i,s,r as a,A as nh,h as d,f as l,c as n,j as h,u as m,x as r,k as u,y as ih,a as o,v as p,d as c,t as f,w as T}from"../chunks/index.f61edf3b.js";import{C as Sp}from"../chunks/CodeBlock.38e566ae.js";import{H as _,E as dh}from"../chunks/EditOnGithub.48fa589f.js";function rh(Op){let $,Ws,Fs,Gs,v,Xs,b,Zs,y,Fp="Helper module for <code>Tensor</code> processing.",en,M,Yp=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,tn,x,Wp='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <code>Promise.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, k)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',ln,on,sn,C,nn,H,dn,L,Gp='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',rn,w,Xp='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',un,an,mn,A,pn,z,cn,g,Zp="Create a new Tensor or copy an existing Tensor.",fn,P,ec="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Tn,hn,_n,R,$n,U,vn,E,tc="Dimensions of the tensor.",bn,k,lc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',yn,Mn,xn,j,Cn,J,Hn,D,oc="Type of the tensor.",Ln,q,sc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',wn,An,zn,I,gn,K,Pn,B,nc="The data stored in the tensor.",Rn,N,ic='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Un,En,kn,V,jn,Q,Jn,S,dc="The number of elements in the tensor.",Dn,O,rc='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',qn,In,Kn,F,Bn,Y,Nn,W,uc="The location of the tensor data.",Vn,G,ac='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Qn,Sn,On,X,Fn,Z,Yn,ee,mc=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,Wn,te,pc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',Gn,Xn,Zn,le,ei,oe,ti,se,cc="Index into a Tensor object.",li,ne,fc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',oi,ie,Tc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",si,ni,ii,de,di,re,ri,ue,hc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',ui,ae,_c="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",ai,mi,pi,me,ci,pe,fi,ce,$c='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ti,fe,vc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",hi,_i,$i,Te,vi,he,bi,_e,bc=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,yi,$e,yc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',Mi,ve,Mc="<li><code>Error</code> If the tensor has more than one element.</li>",xi,Ci,Hi,be,Li,ye,wi,Me,xc="Convert tensor data to a n-dimensional JS list",Ai,xe,Cc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',zi,gi,Pi,Ce,Ri,He,Ui,Le,Hc="Return a new Tensor with the sigmoid function applied to each element.",Ei,we,Lc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',ki,ji,Ji,Ae,Di,ze,qi,ge,wc="Applies the sigmoid function to the tensor in place.",Ii,Pe,Ac='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Ki,Bi,Ni,Re,Vi,Ue,Qi,Ee,zc="Return a new Tensor with every element multiplied by a constant.",Si,ke,gc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Oi,je,Pc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Fi,Yi,Wi,Je,Gi,De,Xi,qe,Rc="Multiply the tensor by a constant in place.",Zi,Ie,Uc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',ed,Ke,Ec="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",td,ld,od,Be,sd,Ne,nd,Ve,kc="Return a new Tensor with every element divided by a constant.",id,Qe,jc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',dd,Se,Jc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",rd,ud,ad,Oe,md,Fe,pd,Ye,Dc="Divide the tensor by a constant in place.",cd,We,qc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',fd,Ge,Ic="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",Td,hd,_d,Xe,$d,Ze,vd,et,Kc="Return a new Tensor with every element added by a constant.",bd,tt,Bc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',yd,lt,Nc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Md,xd,Cd,ot,Hd,st,Ld,nt,Vc="Add the tensor by a constant in place.",wd,it,Qc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Ad,dt,Sc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",zd,gd,Pd,rt,Rd,ut,Ud,at,Oc="Return a permuted version of this Tensor, according to the provided dimensions.",Ed,mt,Fc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',kd,pt,Yc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",jd,Jd,Dd,ct,qd,ft,Id,Tt,Wc="Returns the sum of each row of the input tensor in the given dimension dim.",Kd,ht,Gc='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',Bd,_t,Xc="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Nd,Vd,Qd,$t,Sd,vt,Od,bt,Zc="Returns the matrix norm or vector norm of a given tensor.",Fd,yt,ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Yd,Mt,tf=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Wd,Gd,Xd,xt,Zd,Ct,er,Ht,lf="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",tr,Lt,of='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',lr,wt,sf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",or,sr,nr,At,ir,zt,dr,gt,nf="Performs <code>L_p</code> normalization of inputs over specified dimension.",rr,Pt,df='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',ur,Rt,rf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",ar,mr,pr,Ut,cr,Et,fr,kt,uf=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,Tr,jt,af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',hr,_r,$r,Jt,vr,Dt,br,qt,mf="Returns a tensor with all specified dimensions of input of size 1 removed.",yr,It,pf=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,Mr,Kt,cf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The squeezed tensor',xr,Bt,ff="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",Cr,Hr,Lr,Nt,wr,Vt,Ar,Qt,Tf='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',zr,St,hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',gr,Pr,Rr,Ot,Ur,Ft,Er,Yt,_f="Returns a new tensor with a dimension of size one inserted at the specified position.",kr,Wt,$f="NOTE: The returned tensor shares the same underlying data with this tensor.",jr,Gt,vf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The unsqueezed tensor',Jr,Xt,bf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",Dr,qr,Ir,Zt,Kr,el,Br,tl,yf='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Nr,ll,Mf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Vr,Qr,Sr,ol,Or,sl,Fr,nl,xf='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Yr,il,Cf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Wr,Gr,Xr,dl,Zr,rl,eu,ul,Hf=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,tu,al,Lf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The flattened tensor.',lu,ml,wf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",ou,su,nu,pl,iu,cl,du,fl,Af="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",ru,Tl,zf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',uu,hl,gf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",au,mu,pu,_l,cu,$l,fu,vl,Pf='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',Tu,bl,Rf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',hu,_u,$u,yl,vu,Ml,bu,xl,Uf="Clamps all elements in input into the range [ min, max ]",yu,Cl,Ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',Mu,Hl,kf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",xu,Cu,Hu,Ll,Lu,wl,wu,Al,jf='In-place version of @see <a href="Tensor.round">Tensor.round</a>',Au,zl,Jf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',zu,gu,Pu,gl,Ru,Pl,Uu,Rl,Df="Rounds elements of input to the nearest integer.",Eu,Ul,qf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - the output tensor.',ku,ju,Ju,El,Du,kl,qu,jl,If="Performs Tensor dtype conversion.",Iu,Jl,Kf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',Ku,Dl,Bf='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',Bu,Nu,Vu,ql,Qu,Il,Su,Kl,Nf="Permutes a tensor according to the provided axes.",Ou,Bl,Vf='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',Fu,Nl,Qf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",Yu,Wu,Gu,Vl,Xu,Ql,Zu,Sl,Sf="Interpolates an Tensor to the given size.",ea,Ol,Of='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',ta,Fl,Ff="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",la,oa,sa,Yl,na,Wl,ia,Gl,Yf=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,da,Xl,Wf='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The interpolated tensor.',ra,Zl,Gf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>",ua,aa,ma,eo,pa,to,ca,lo,Xf=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,fa,oo,Zf='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - The matrix product of the two tensors.',Ta,so,eT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code>Tensor</code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code>Tensor</code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>",ha,_a,$a,no,va,io,ba,ro,tT=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,ya,uo,lT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Tensor&gt;</code> - the output tensor.',Ma,ao,oT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code>Tensor</code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>",xa,Ca,Ha,mo,La,po,wa,co,sT=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,Aa,fo,nT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',za,To,iT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>Tensor</code></td><td><p>the input tensor</p></td> </tr><tr><td>k</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>",ga,Pa,Ra,ho,Ua,_o,Ea,$o,dT="Perform mean pooling of the last hidden state followed by a normalization step.",ka,vo,rT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',ja,bo,uT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",Ja,Da,qa,yo,Ia,Mo,Ka,xo,aT="Apply Layer Normalization for last certain number of dimensions.",Ba,Co,mT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',Na,Ho,pT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>",Va,Qa,Sa,Lo,Oa,wo,Fa,Ao,cT="Concatenates an array of tensors along a specified dimension.",Ya,zo,fT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',Wa,go,TT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",Ga,Xa,Za,Po,em,Ro,tm,Uo,hT="Stack an array of tensors along a specified dimension.",lm,Eo,_T='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',om,ko,$T="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",sm,nm,im,jo,dm,Jo,rm,Do,vT="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",um,qo,bT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',am,Io,yT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",mm,pm,cm,Ko,fm,Bo,Tm,No,MT="Returns the mean value of each row of the input tensor in the given dimension dim.",hm,Vo,xT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - A new tensor with means taken along the specified dimension.',_m,Qo,CT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",$m,vm,bm,So,ym,Oo,Mm,Fo,HT="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",xm,Yo,LT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The filled tensor.',Cm,Wo,wT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",Hm,Lm,wm,Go,Am,Xo,zm,Zo,AT="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",gm,es,zT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',Pm,ts,gT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Rm,Um,Em,ls,km,os,jm,ss,PT="Returns a tensor filled with the scalar value 1, with the same size as input.",Jm,ns,RT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The ones tensor.',Dm,is,UT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",qm,Im,Km,ds,Bm,rs,Nm,us,ET="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",Vm,as,kT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',Qm,ms,jT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Sm,Om,Fm,ps,Ym,cs,Wm,fs,JT="Returns a tensor filled with the scalar value 0, with the same size as input.",Gm,Ts,DT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The zeros tensor.',Xm,hs,qT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",Zm,ep,tp,_s,lp,$s,op,vs,IT="Quantizes the embeddings tensor to binary or unsigned binary precision.",sp,bs,KT='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The quantized tensor.',np,ys,BT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>",ip,dp,rp,Ms,up,xs,ap,Cs,NT='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',mp,pp,cp,Hs,fp,Ls,Tp,ws,VT="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",hp,As,QT='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',_p,zs,ST="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",$p,gs,OT="<strong>Example</strong>",vp,Ps,bp,yp,Mp,Rs,xp,Us,Cp,Es,FT='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',Hp,Lp,wp,ks,Ap,js,zp,Js,YT='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',gp,Pp,Rp,Ds,Up,qs,Ep,Is,WT="This creates a nested array of a given type and depth (see examples).",kp,Ks,GT='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',jp,Bs,Jp,Ns,XT="<strong>Example</strong>",Dp,Vs,qp,Qs,ZT="<strong>Example</strong>",Ip,Ss,Kp,Bp,Np,Os,Vp,Ys,Qp;return b=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),z=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),U=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),J=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),Q=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),oe=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),re=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),ye=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ze=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),Ue=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),st=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),ut=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),ft=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),vt=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),zt=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Et=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Dt=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Ft=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),el=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),sl=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),rl=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),cl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),$l=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),Ml=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),wl=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),Pl=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),kl=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Il=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),Ql=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Wl=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),to=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),io=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),po=new _({props:{title:"utils/tensor.topk(x, k) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),_o=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Mo=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),wo=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Ro=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Jo=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),Bo=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),Oo=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),Xo=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),os=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),rs=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),cs=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),$s=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),xs=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),Ls=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Ps=new Sp({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),Us=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),js=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),qs=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Bs=new Sp({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Vs=new Sp({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Ss=new Sp({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),Os=new dh({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=i("meta"),Ws=s(),Fs=i("p"),Gs=s(),v=i("a"),Xs=s(),a(b.$$.fragment),Zs=s(),y=i("p"),y.innerHTML=Fp,en=s(),M=i("p"),M.textContent=Yp,tn=s(),x=i("ul"),x.innerHTML=Wp,ln=s(),on=i("hr"),sn=s(),C=i("a"),nn=s(),a(H.$$.fragment),dn=s(),L=i("p"),L.innerHTML=Gp,rn=s(),w=i("ul"),w.innerHTML=Xp,un=s(),an=i("hr"),mn=s(),A=i("a"),pn=s(),a(z.$$.fragment),cn=s(),g=i("p"),g.textContent=Zp,fn=s(),P=i("table"),P.innerHTML=ec,Tn=s(),hn=i("hr"),_n=s(),R=i("a"),$n=s(),a(U.$$.fragment),vn=s(),E=i("p"),E.textContent=tc,bn=s(),k=i("p"),k.innerHTML=lc,yn=s(),Mn=i("hr"),xn=s(),j=i("a"),Cn=s(),a(J.$$.fragment),Hn=s(),D=i("p"),D.textContent=oc,Ln=s(),q=i("p"),q.innerHTML=sc,wn=s(),An=i("hr"),zn=s(),I=i("a"),gn=s(),a(K.$$.fragment),Pn=s(),B=i("p"),B.textContent=nc,Rn=s(),N=i("p"),N.innerHTML=ic,Un=s(),En=i("hr"),kn=s(),V=i("a"),jn=s(),a(Q.$$.fragment),Jn=s(),S=i("p"),S.textContent=dc,Dn=s(),O=i("p"),O.innerHTML=rc,qn=s(),In=i("hr"),Kn=s(),F=i("a"),Bn=s(),a(Y.$$.fragment),Nn=s(),W=i("p"),W.textContent=uc,Vn=s(),G=i("p"),G.innerHTML=ac,Qn=s(),Sn=i("hr"),On=s(),X=i("a"),Fn=s(),a(Z.$$.fragment),Yn=s(),ee=i("p"),ee.textContent=mc,Wn=s(),te=i("p"),te.innerHTML=pc,Gn=s(),Xn=i("hr"),Zn=s(),le=i("a"),ei=s(),a(oe.$$.fragment),ti=s(),se=i("p"),se.textContent=cc,li=s(),ne=i("p"),ne.innerHTML=fc,oi=s(),ie=i("table"),ie.innerHTML=Tc,si=s(),ni=i("hr"),ii=s(),de=i("a"),di=s(),a(re.$$.fragment),ri=s(),ue=i("p"),ue.innerHTML=hc,ui=s(),ae=i("table"),ae.innerHTML=_c,ai=s(),mi=i("hr"),pi=s(),me=i("a"),ci=s(),a(pe.$$.fragment),fi=s(),ce=i("p"),ce.innerHTML=$c,Ti=s(),fe=i("table"),fe.innerHTML=vc,hi=s(),_i=i("hr"),$i=s(),Te=i("a"),vi=s(),a(he.$$.fragment),bi=s(),_e=i("p"),_e.innerHTML=bc,yi=s(),$e=i("p"),$e.innerHTML=yc,Mi=s(),ve=i("ul"),ve.innerHTML=Mc,xi=s(),Ci=i("hr"),Hi=s(),be=i("a"),Li=s(),a(ye.$$.fragment),wi=s(),Me=i("p"),Me.textContent=xc,Ai=s(),xe=i("p"),xe.innerHTML=Cc,zi=s(),gi=i("hr"),Pi=s(),Ce=i("a"),Ri=s(),a(He.$$.fragment),Ui=s(),Le=i("p"),Le.textContent=Hc,Ei=s(),we=i("p"),we.innerHTML=Lc,ki=s(),ji=i("hr"),Ji=s(),Ae=i("a"),Di=s(),a(ze.$$.fragment),qi=s(),ge=i("p"),ge.textContent=wc,Ii=s(),Pe=i("p"),Pe.innerHTML=Ac,Ki=s(),Bi=i("hr"),Ni=s(),Re=i("a"),Vi=s(),a(Ue.$$.fragment),Qi=s(),Ee=i("p"),Ee.textContent=zc,Si=s(),ke=i("p"),ke.innerHTML=gc,Oi=s(),je=i("table"),je.innerHTML=Pc,Fi=s(),Yi=i("hr"),Wi=s(),Je=i("a"),Gi=s(),a(De.$$.fragment),Xi=s(),qe=i("p"),qe.textContent=Rc,Zi=s(),Ie=i("p"),Ie.innerHTML=Uc,ed=s(),Ke=i("table"),Ke.innerHTML=Ec,td=s(),ld=i("hr"),od=s(),Be=i("a"),sd=s(),a(Ne.$$.fragment),nd=s(),Ve=i("p"),Ve.textContent=kc,id=s(),Qe=i("p"),Qe.innerHTML=jc,dd=s(),Se=i("table"),Se.innerHTML=Jc,rd=s(),ud=i("hr"),ad=s(),Oe=i("a"),md=s(),a(Fe.$$.fragment),pd=s(),Ye=i("p"),Ye.textContent=Dc,cd=s(),We=i("p"),We.innerHTML=qc,fd=s(),Ge=i("table"),Ge.innerHTML=Ic,Td=s(),hd=i("hr"),_d=s(),Xe=i("a"),$d=s(),a(Ze.$$.fragment),vd=s(),et=i("p"),et.textContent=Kc,bd=s(),tt=i("p"),tt.innerHTML=Bc,yd=s(),lt=i("table"),lt.innerHTML=Nc,Md=s(),xd=i("hr"),Cd=s(),ot=i("a"),Hd=s(),a(st.$$.fragment),Ld=s(),nt=i("p"),nt.textContent=Vc,wd=s(),it=i("p"),it.innerHTML=Qc,Ad=s(),dt=i("table"),dt.innerHTML=Sc,zd=s(),gd=i("hr"),Pd=s(),rt=i("a"),Rd=s(),a(ut.$$.fragment),Ud=s(),at=i("p"),at.textContent=Oc,Ed=s(),mt=i("p"),mt.innerHTML=Fc,kd=s(),pt=i("table"),pt.innerHTML=Yc,jd=s(),Jd=i("hr"),Dd=s(),ct=i("a"),qd=s(),a(ft.$$.fragment),Id=s(),Tt=i("p"),Tt.textContent=Wc,Kd=s(),ht=i("p"),ht.innerHTML=Gc,Bd=s(),_t=i("table"),_t.innerHTML=Xc,Nd=s(),Vd=i("hr"),Qd=s(),$t=i("a"),Sd=s(),a(vt.$$.fragment),Od=s(),bt=i("p"),bt.textContent=Zc,Fd=s(),yt=i("p"),yt.innerHTML=ef,Yd=s(),Mt=i("table"),Mt.innerHTML=tf,Wd=s(),Gd=i("hr"),Xd=s(),xt=i("a"),Zd=s(),a(Ct.$$.fragment),er=s(),Ht=i("p"),Ht.innerHTML=lf,tr=s(),Lt=i("p"),Lt.innerHTML=of,lr=s(),wt=i("table"),wt.innerHTML=sf,or=s(),sr=i("hr"),nr=s(),At=i("a"),ir=s(),a(zt.$$.fragment),dr=s(),gt=i("p"),gt.innerHTML=nf,rr=s(),Pt=i("p"),Pt.innerHTML=df,ur=s(),Rt=i("table"),Rt.innerHTML=rf,ar=s(),mr=i("hr"),pr=s(),Ut=i("a"),cr=s(),a(Et.$$.fragment),fr=s(),kt=i("p"),kt.textContent=uf,Tr=s(),jt=i("p"),jt.innerHTML=af,hr=s(),_r=i("hr"),$r=s(),Jt=i("a"),vr=s(),a(Dt.$$.fragment),br=s(),qt=i("p"),qt.textContent=mf,yr=s(),It=i("p"),It.innerHTML=pf,Mr=s(),Kt=i("p"),Kt.innerHTML=cf,xr=s(),Bt=i("table"),Bt.innerHTML=ff,Cr=s(),Hr=i("hr"),Lr=s(),Nt=i("a"),wr=s(),a(Vt.$$.fragment),Ar=s(),Qt=i("p"),Qt.innerHTML=Tf,zr=s(),St=i("p"),St.innerHTML=hf,gr=s(),Pr=i("hr"),Rr=s(),Ot=i("a"),Ur=s(),a(Ft.$$.fragment),Er=s(),Yt=i("p"),Yt.textContent=_f,kr=s(),Wt=i("p"),Wt.textContent=$f,jr=s(),Gt=i("p"),Gt.innerHTML=vf,Jr=s(),Xt=i("table"),Xt.innerHTML=bf,Dr=s(),qr=i("hr"),Ir=s(),Zt=i("a"),Kr=s(),a(el.$$.fragment),Br=s(),tl=i("p"),tl.innerHTML=yf,Nr=s(),ll=i("p"),ll.innerHTML=Mf,Vr=s(),Qr=i("hr"),Sr=s(),ol=i("a"),Or=s(),a(sl.$$.fragment),Fr=s(),nl=i("p"),nl.innerHTML=xf,Yr=s(),il=i("p"),il.innerHTML=Cf,Wr=s(),Gr=i("hr"),Xr=s(),dl=i("a"),Zr=s(),a(rl.$$.fragment),eu=s(),ul=i("p"),ul.innerHTML=Hf,tu=s(),al=i("p"),al.innerHTML=Lf,lu=s(),ml=i("table"),ml.innerHTML=wf,ou=s(),su=i("hr"),nu=s(),pl=i("a"),iu=s(),a(cl.$$.fragment),du=s(),fl=i("p"),fl.innerHTML=Af,ru=s(),Tl=i("p"),Tl.innerHTML=zf,uu=s(),hl=i("table"),hl.innerHTML=gf,au=s(),mu=i("hr"),pu=s(),_l=i("a"),cu=s(),a($l.$$.fragment),fu=s(),vl=i("p"),vl.innerHTML=Pf,Tu=s(),bl=i("p"),bl.innerHTML=Rf,hu=s(),_u=i("hr"),$u=s(),yl=i("a"),vu=s(),a(Ml.$$.fragment),bu=s(),xl=i("p"),xl.textContent=Uf,yu=s(),Cl=i("p"),Cl.innerHTML=Ef,Mu=s(),Hl=i("table"),Hl.innerHTML=kf,xu=s(),Cu=i("hr"),Hu=s(),Ll=i("a"),Lu=s(),a(wl.$$.fragment),wu=s(),Al=i("p"),Al.innerHTML=jf,Au=s(),zl=i("p"),zl.innerHTML=Jf,zu=s(),gu=i("hr"),Pu=s(),gl=i("a"),Ru=s(),a(Pl.$$.fragment),Uu=s(),Rl=i("p"),Rl.textContent=Df,Eu=s(),Ul=i("p"),Ul.innerHTML=qf,ku=s(),ju=i("hr"),Ju=s(),El=i("a"),Du=s(),a(kl.$$.fragment),qu=s(),jl=i("p"),jl.textContent=If,Iu=s(),Jl=i("p"),Jl.innerHTML=Kf,Ku=s(),Dl=i("table"),Dl.innerHTML=Bf,Bu=s(),Nu=i("hr"),Vu=s(),ql=i("a"),Qu=s(),a(Il.$$.fragment),Su=s(),Kl=i("p"),Kl.textContent=Nf,Ou=s(),Bl=i("p"),Bl.innerHTML=Vf,Fu=s(),Nl=i("table"),Nl.innerHTML=Qf,Yu=s(),Wu=i("hr"),Gu=s(),Vl=i("a"),Xu=s(),a(Ql.$$.fragment),Zu=s(),Sl=i("p"),Sl.textContent=Sf,ea=s(),Ol=i("p"),Ol.innerHTML=Of,ta=s(),Fl=i("table"),Fl.innerHTML=Ff,la=s(),oa=i("hr"),sa=s(),Yl=i("a"),na=s(),a(Wl.$$.fragment),ia=s(),Gl=i("p"),Gl.innerHTML=Yf,da=s(),Xl=i("p"),Xl.innerHTML=Wf,ra=s(),Zl=i("table"),Zl.innerHTML=Gf,ua=s(),aa=i("hr"),ma=s(),eo=i("a"),pa=s(),a(to.$$.fragment),ca=s(),lo=i("p"),lo.innerHTML=Xf,fa=s(),oo=i("p"),oo.innerHTML=Zf,Ta=s(),so=i("table"),so.innerHTML=eT,ha=s(),_a=i("hr"),$a=s(),no=i("a"),va=s(),a(io.$$.fragment),ba=s(),ro=i("p"),ro.innerHTML=tT,ya=s(),uo=i("p"),uo.innerHTML=lT,Ma=s(),ao=i("table"),ao.innerHTML=oT,xa=s(),Ca=i("hr"),Ha=s(),mo=i("a"),La=s(),a(po.$$.fragment),wa=s(),co=i("p"),co.innerHTML=sT,Aa=s(),fo=i("p"),fo.innerHTML=nT,za=s(),To=i("table"),To.innerHTML=iT,ga=s(),Pa=i("hr"),Ra=s(),ho=i("a"),Ua=s(),a(_o.$$.fragment),Ea=s(),$o=i("p"),$o.textContent=dT,ka=s(),vo=i("p"),vo.innerHTML=rT,ja=s(),bo=i("table"),bo.innerHTML=uT,Ja=s(),Da=i("hr"),qa=s(),yo=i("a"),Ia=s(),a(Mo.$$.fragment),Ka=s(),xo=i("p"),xo.textContent=aT,Ba=s(),Co=i("p"),Co.innerHTML=mT,Na=s(),Ho=i("table"),Ho.innerHTML=pT,Va=s(),Qa=i("hr"),Sa=s(),Lo=i("a"),Oa=s(),a(wo.$$.fragment),Fa=s(),Ao=i("p"),Ao.textContent=cT,Ya=s(),zo=i("p"),zo.innerHTML=fT,Wa=s(),go=i("table"),go.innerHTML=TT,Ga=s(),Xa=i("hr"),Za=s(),Po=i("a"),em=s(),a(Ro.$$.fragment),tm=s(),Uo=i("p"),Uo.textContent=hT,lm=s(),Eo=i("p"),Eo.innerHTML=_T,om=s(),ko=i("table"),ko.innerHTML=$T,sm=s(),nm=i("hr"),im=s(),jo=i("a"),dm=s(),a(Jo.$$.fragment),rm=s(),Do=i("p"),Do.innerHTML=vT,um=s(),qo=i("p"),qo.innerHTML=bT,am=s(),Io=i("table"),Io.innerHTML=yT,mm=s(),pm=i("hr"),cm=s(),Ko=i("a"),fm=s(),a(Bo.$$.fragment),Tm=s(),No=i("p"),No.textContent=MT,hm=s(),Vo=i("p"),Vo.innerHTML=xT,_m=s(),Qo=i("table"),Qo.innerHTML=CT,$m=s(),vm=i("hr"),bm=s(),So=i("a"),ym=s(),a(Oo.$$.fragment),Mm=s(),Fo=i("p"),Fo.textContent=HT,xm=s(),Yo=i("p"),Yo.innerHTML=LT,Cm=s(),Wo=i("table"),Wo.innerHTML=wT,Hm=s(),Lm=i("hr"),wm=s(),Go=i("a"),Am=s(),a(Xo.$$.fragment),zm=s(),Zo=i("p"),Zo.textContent=AT,gm=s(),es=i("p"),es.innerHTML=zT,Pm=s(),ts=i("table"),ts.innerHTML=gT,Rm=s(),Um=i("hr"),Em=s(),ls=i("a"),km=s(),a(os.$$.fragment),jm=s(),ss=i("p"),ss.textContent=PT,Jm=s(),ns=i("p"),ns.innerHTML=RT,Dm=s(),is=i("table"),is.innerHTML=UT,qm=s(),Im=i("hr"),Km=s(),ds=i("a"),Bm=s(),a(rs.$$.fragment),Nm=s(),us=i("p"),us.textContent=ET,Vm=s(),as=i("p"),as.innerHTML=kT,Qm=s(),ms=i("table"),ms.innerHTML=jT,Sm=s(),Om=i("hr"),Fm=s(),ps=i("a"),Ym=s(),a(cs.$$.fragment),Wm=s(),fs=i("p"),fs.textContent=JT,Gm=s(),Ts=i("p"),Ts.innerHTML=DT,Xm=s(),hs=i("table"),hs.innerHTML=qT,Zm=s(),ep=i("hr"),tp=s(),_s=i("a"),lp=s(),a($s.$$.fragment),op=s(),vs=i("p"),vs.textContent=IT,sp=s(),bs=i("p"),bs.innerHTML=KT,np=s(),ys=i("table"),ys.innerHTML=BT,ip=s(),dp=i("hr"),rp=s(),Ms=i("a"),up=s(),a(xs.$$.fragment),ap=s(),Cs=i("p"),Cs.innerHTML=NT,mp=s(),pp=i("hr"),cp=s(),Hs=i("a"),fp=s(),a(Ls.$$.fragment),Tp=s(),ws=i("p"),ws.textContent=VT,hp=s(),As=i("p"),As.innerHTML=QT,_p=s(),zs=i("table"),zs.innerHTML=ST,$p=s(),gs=i("p"),gs.innerHTML=OT,vp=s(),a(Ps.$$.fragment),bp=s(),yp=i("hr"),Mp=s(),Rs=i("a"),xp=s(),a(Us.$$.fragment),Cp=s(),Es=i("p"),Es.innerHTML=FT,Hp=s(),Lp=i("hr"),wp=s(),ks=i("a"),Ap=s(),a(js.$$.fragment),zp=s(),Js=i("p"),Js.innerHTML=YT,gp=s(),Pp=i("hr"),Rp=s(),Ds=i("a"),Up=s(),a(qs.$$.fragment),Ep=s(),Is=i("p"),Is.textContent=WT,kp=s(),Ks=i("p"),Ks.innerHTML=GT,jp=s(),a(Bs.$$.fragment),Jp=s(),Ns=i("p"),Ns.innerHTML=XT,Dp=s(),a(Vs.$$.fragment),qp=s(),Qs=i("p"),Qs.innerHTML=ZT,Ip=s(),a(Ss.$$.fragment),Kp=s(),Bp=i("hr"),Np=s(),a(Os.$$.fragment),Vp=s(),Ys=i("p"),this.h()},l(e){const t=nh("svelte-u9bgzb",document.head);$=d(t,"META",{name:!0,content:!0}),t.forEach(l),Ws=n(e),Fs=d(e,"P",{}),h(Fs).forEach(l),Gs=n(e),v=d(e,"A",{id:!0,class:!0}),h(v).forEach(l),Xs=n(e),m(b.$$.fragment,e),Zs=n(e),y=d(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-uw4y1m"&&(y.innerHTML=Fp),en=n(e),M=d(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-il3kl8"&&(M.textContent=Yp),tn=n(e),x=d(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-rg2zd9"&&(x.innerHTML=Wp),ln=n(e),on=d(e,"HR",{}),sn=n(e),C=d(e,"A",{id:!0,class:!0}),h(C).forEach(l),nn=n(e),m(H.$$.fragment,e),dn=n(e),L=d(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ugrfrw"&&(L.innerHTML=Gp),rn=n(e),w=d(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-x6wsf6"&&(w.innerHTML=Xp),un=n(e),an=d(e,"HR",{}),mn=n(e),A=d(e,"A",{id:!0,class:!0}),h(A).forEach(l),pn=n(e),m(z.$$.fragment,e),cn=n(e),g=d(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-55wecd"&&(g.textContent=Zp),fn=n(e),P=d(e,"TABLE",{"data-svelte-h":!0}),r(P)!=="svelte-ee7emz"&&(P.innerHTML=ec),Tn=n(e),hn=d(e,"HR",{}),_n=n(e),R=d(e,"A",{id:!0,class:!0}),h(R).forEach(l),$n=n(e),m(U.$$.fragment,e),vn=n(e),E=d(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1gc2rt4"&&(E.textContent=tc),bn=n(e),k=d(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-10qzguj"&&(k.innerHTML=lc),yn=n(e),Mn=d(e,"HR",{}),xn=n(e),j=d(e,"A",{id:!0,class:!0}),h(j).forEach(l),Cn=n(e),m(J.$$.fragment,e),Hn=n(e),D=d(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-81y0bb"&&(D.textContent=oc),Ln=n(e),q=d(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-10qzguj"&&(q.innerHTML=sc),wn=n(e),An=d(e,"HR",{}),zn=n(e),I=d(e,"A",{id:!0,class:!0}),h(I).forEach(l),gn=n(e),m(K.$$.fragment,e),Pn=n(e),B=d(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1eqabt7"&&(B.textContent=nc),Rn=n(e),N=d(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-10qzguj"&&(N.innerHTML=ic),Un=n(e),En=d(e,"HR",{}),kn=n(e),V=d(e,"A",{id:!0,class:!0}),h(V).forEach(l),jn=n(e),m(Q.$$.fragment,e),Jn=n(e),S=d(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-krrt97"&&(S.textContent=dc),Dn=n(e),O=d(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-10qzguj"&&(O.innerHTML=rc),qn=n(e),In=d(e,"HR",{}),Kn=n(e),F=d(e,"A",{id:!0,class:!0}),h(F).forEach(l),Bn=n(e),m(Y.$$.fragment,e),Nn=n(e),W=d(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1iaptgl"&&(W.textContent=uc),Vn=n(e),G=d(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-10qzguj"&&(G.innerHTML=ac),Qn=n(e),Sn=d(e,"HR",{}),On=n(e),X=d(e,"A",{id:!0,class:!0}),h(X).forEach(l),Fn=n(e),m(Z.$$.fragment,e),Yn=n(e),ee=d(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1adn56z"&&(ee.textContent=mc),Wn=n(e),te=d(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1gxgvk6"&&(te.innerHTML=pc),Gn=n(e),Xn=d(e,"HR",{}),Zn=n(e),le=d(e,"A",{id:!0,class:!0}),h(le).forEach(l),ei=n(e),m(oe.$$.fragment,e),ti=n(e),se=d(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1u97xg1"&&(se.textContent=cc),li=n(e),ne=d(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1afa2dz"&&(ne.innerHTML=fc),oi=n(e),ie=d(e,"TABLE",{"data-svelte-h":!0}),r(ie)!=="svelte-1kq04ga"&&(ie.innerHTML=Tc),si=n(e),ni=d(e,"HR",{}),ii=n(e),de=d(e,"A",{id:!0,class:!0}),h(de).forEach(l),di=n(e),m(re.$$.fragment,e),ri=n(e),ue=d(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1cg22af"&&(ue.innerHTML=hc),ui=n(e),ae=d(e,"TABLE",{"data-svelte-h":!0}),r(ae)!=="svelte-1hful42"&&(ae.innerHTML=_c),ai=n(e),mi=d(e,"HR",{}),pi=n(e),me=d(e,"A",{id:!0,class:!0}),h(me).forEach(l),ci=n(e),m(pe.$$.fragment,e),fi=n(e),ce=d(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=$c),Ti=n(e),fe=d(e,"TABLE",{"data-svelte-h":!0}),r(fe)!=="svelte-153ftfy"&&(fe.innerHTML=vc),hi=n(e),_i=d(e,"HR",{}),$i=n(e),Te=d(e,"A",{id:!0,class:!0}),h(Te).forEach(l),vi=n(e),m(he.$$.fragment,e),bi=n(e),_e=d(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=bc),yi=n(e),$e=d(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-11rv1mu"&&($e.innerHTML=yc),Mi=n(e),ve=d(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-5t2sg3"&&(ve.innerHTML=Mc),xi=n(e),Ci=d(e,"HR",{}),Hi=n(e),be=d(e,"A",{id:!0,class:!0}),h(be).forEach(l),Li=n(e),m(ye.$$.fragment,e),wi=n(e),Me=d(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-87xdyr"&&(Me.textContent=xc),Ai=n(e),xe=d(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=Cc),zi=n(e),gi=d(e,"HR",{}),Pi=n(e),Ce=d(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Ri=n(e),m(He.$$.fragment,e),Ui=n(e),Le=d(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-2wti2w"&&(Le.textContent=Hc),Ei=n(e),we=d(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-kpq7mo"&&(we.innerHTML=Lc),ki=n(e),ji=d(e,"HR",{}),Ji=n(e),Ae=d(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),Di=n(e),m(ze.$$.fragment,e),qi=n(e),ge=d(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1edu6c8"&&(ge.textContent=wc),Ii=n(e),Pe=d(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1hc4oxa"&&(Pe.innerHTML=Ac),Ki=n(e),Bi=d(e,"HR",{}),Ni=n(e),Re=d(e,"A",{id:!0,class:!0}),h(Re).forEach(l),Vi=n(e),m(Ue.$$.fragment,e),Qi=n(e),Ee=d(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-xg80lg"&&(Ee.textContent=zc),Si=n(e),ke=d(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1aygav2"&&(ke.innerHTML=gc),Oi=n(e),je=d(e,"TABLE",{"data-svelte-h":!0}),r(je)!=="svelte-1tbtmqd"&&(je.innerHTML=Pc),Fi=n(e),Yi=d(e,"HR",{}),Wi=n(e),Je=d(e,"A",{id:!0,class:!0}),h(Je).forEach(l),Gi=n(e),m(De.$$.fragment,e),Xi=n(e),qe=d(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1i12x1s"&&(qe.textContent=Rc),Zi=n(e),Ie=d(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1hc4oxa"&&(Ie.innerHTML=Uc),ed=n(e),Ke=d(e,"TABLE",{"data-svelte-h":!0}),r(Ke)!=="svelte-1tbtmqd"&&(Ke.innerHTML=Ec),td=n(e),ld=d(e,"HR",{}),od=n(e),Be=d(e,"A",{id:!0,class:!0}),h(Be).forEach(l),sd=n(e),m(Ne.$$.fragment,e),nd=n(e),Ve=d(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-45kvaw"&&(Ve.textContent=kc),id=n(e),Qe=d(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1aygav2"&&(Qe.innerHTML=jc),dd=n(e),Se=d(e,"TABLE",{"data-svelte-h":!0}),r(Se)!=="svelte-46t58i"&&(Se.innerHTML=Jc),rd=n(e),ud=d(e,"HR",{}),ad=n(e),Oe=d(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),md=n(e),m(Fe.$$.fragment,e),pd=n(e),Ye=d(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-6s524n"&&(Ye.textContent=Dc),cd=n(e),We=d(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1hc4oxa"&&(We.innerHTML=qc),fd=n(e),Ge=d(e,"TABLE",{"data-svelte-h":!0}),r(Ge)!=="svelte-46t58i"&&(Ge.innerHTML=Ic),Td=n(e),hd=d(e,"HR",{}),_d=n(e),Xe=d(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),$d=n(e),m(Ze.$$.fragment,e),vd=n(e),et=d(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1hl64jn"&&(et.textContent=Kc),bd=n(e),tt=d(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1aygav2"&&(tt.innerHTML=Bc),yd=n(e),lt=d(e,"TABLE",{"data-svelte-h":!0}),r(lt)!=="svelte-1p5444"&&(lt.innerHTML=Nc),Md=n(e),xd=d(e,"HR",{}),Cd=n(e),ot=d(e,"A",{id:!0,class:!0}),h(ot).forEach(l),Hd=n(e),m(st.$$.fragment,e),Ld=n(e),nt=d(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-bbf4x3"&&(nt.textContent=Vc),wd=n(e),it=d(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1hc4oxa"&&(it.innerHTML=Qc),Ad=n(e),dt=d(e,"TABLE",{"data-svelte-h":!0}),r(dt)!=="svelte-1p5444"&&(dt.innerHTML=Sc),zd=n(e),gd=d(e,"HR",{}),Pd=n(e),rt=d(e,"A",{id:!0,class:!0}),h(rt).forEach(l),Rd=n(e),m(ut.$$.fragment,e),Ud=n(e),at=d(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1g8ouql"&&(at.textContent=Oc),Ed=n(e),mt=d(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1scc4l4"&&(mt.innerHTML=Fc),kd=n(e),pt=d(e,"TABLE",{"data-svelte-h":!0}),r(pt)!=="svelte-1p49qvp"&&(pt.innerHTML=Yc),jd=n(e),Jd=d(e,"HR",{}),Dd=n(e),ct=d(e,"A",{id:!0,class:!0}),h(ct).forEach(l),qd=n(e),m(ft.$$.fragment,e),Id=n(e),Tt=d(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-yjryb1"&&(Tt.textContent=Wc),Kd=n(e),ht=d(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-xtr8tc"&&(ht.innerHTML=Gc),Bd=n(e),_t=d(e,"TABLE",{"data-svelte-h":!0}),r(_t)!=="svelte-6xvdso"&&(_t.innerHTML=Xc),Nd=n(e),Vd=d(e,"HR",{}),Qd=n(e),$t=d(e,"A",{id:!0,class:!0}),h($t).forEach(l),Sd=n(e),m(vt.$$.fragment,e),Od=n(e),bt=d(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1okfsqx"&&(bt.textContent=Zc),Fd=n(e),yt=d(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1t556pk"&&(yt.innerHTML=ef),Yd=n(e),Mt=d(e,"TABLE",{"data-svelte-h":!0}),r(Mt)!=="svelte-13m2wni"&&(Mt.innerHTML=tf),Wd=n(e),Gd=d(e,"HR",{}),Xd=n(e),xt=d(e,"A",{id:!0,class:!0}),h(xt).forEach(l),Zd=n(e),m(Ct.$$.fragment,e),er=n(e),Ht=d(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1htpbrk"&&(Ht.innerHTML=lf),tr=n(e),Lt=d(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-1t0m8l6"&&(Lt.innerHTML=of),lr=n(e),wt=d(e,"TABLE",{"data-svelte-h":!0}),r(wt)!=="svelte-1qi99pl"&&(wt.innerHTML=sf),or=n(e),sr=d(e,"HR",{}),nr=n(e),At=d(e,"A",{id:!0,class:!0}),h(At).forEach(l),ir=n(e),m(zt.$$.fragment,e),dr=n(e),gt=d(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1ztgqp"&&(gt.innerHTML=nf),rr=n(e),Pt=d(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-mvb39p"&&(Pt.innerHTML=df),ur=n(e),Rt=d(e,"TABLE",{"data-svelte-h":!0}),r(Rt)!=="svelte-1qi99pl"&&(Rt.innerHTML=rf),ar=n(e),mr=d(e,"HR",{}),pr=n(e),Ut=d(e,"A",{id:!0,class:!0}),h(Ut).forEach(l),cr=n(e),m(Et.$$.fragment,e),fr=n(e),kt=d(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1a7u185"&&(kt.textContent=uf),Tr=n(e),jt=d(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1eu3doh"&&(jt.innerHTML=af),hr=n(e),_r=d(e,"HR",{}),$r=n(e),Jt=d(e,"A",{id:!0,class:!0}),h(Jt).forEach(l),vr=n(e),m(Dt.$$.fragment,e),br=n(e),qt=d(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-qls17b"&&(qt.textContent=mf),yr=n(e),It=d(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-5nabmy"&&(It.innerHTML=pf),Mr=n(e),Kt=d(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-muvb5c"&&(Kt.innerHTML=cf),xr=n(e),Bt=d(e,"TABLE",{"data-svelte-h":!0}),r(Bt)!=="svelte-52pnzr"&&(Bt.innerHTML=ff),Cr=n(e),Hr=d(e,"HR",{}),Lr=n(e),Nt=d(e,"A",{id:!0,class:!0}),h(Nt).forEach(l),wr=n(e),m(Vt.$$.fragment,e),Ar=n(e),Qt=d(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-19w0pic"&&(Qt.innerHTML=Tf),zr=n(e),St=d(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1mr58c3"&&(St.innerHTML=hf),gr=n(e),Pr=d(e,"HR",{}),Rr=n(e),Ot=d(e,"A",{id:!0,class:!0}),h(Ot).forEach(l),Ur=n(e),m(Ft.$$.fragment,e),Er=n(e),Yt=d(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-18ws76n"&&(Yt.textContent=_f),kr=n(e),Wt=d(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1tnr5gm"&&(Wt.textContent=$f),jr=n(e),Gt=d(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1si6y4t"&&(Gt.innerHTML=vf),Jr=n(e),Xt=d(e,"TABLE",{"data-svelte-h":!0}),r(Xt)!=="svelte-1u9lyxp"&&(Xt.innerHTML=bf),Dr=n(e),qr=d(e,"HR",{}),Ir=n(e),Zt=d(e,"A",{id:!0,class:!0}),h(Zt).forEach(l),Kr=n(e),m(el.$$.fragment,e),Br=n(e),tl=d(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-1b9ygao"&&(tl.innerHTML=yf),Nr=n(e),ll=d(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1mr58c3"&&(ll.innerHTML=Mf),Vr=n(e),Qr=d(e,"HR",{}),Sr=n(e),ol=d(e,"A",{id:!0,class:!0}),h(ol).forEach(l),Or=n(e),m(sl.$$.fragment,e),Fr=n(e),nl=d(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-1vkr5xo"&&(nl.innerHTML=xf),Yr=n(e),il=d(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-1mr58c3"&&(il.innerHTML=Cf),Wr=n(e),Gr=d(e,"HR",{}),Xr=n(e),dl=d(e,"A",{id:!0,class:!0}),h(dl).forEach(l),Zr=n(e),m(rl.$$.fragment,e),eu=n(e),ul=d(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-1gguudf"&&(ul.innerHTML=Hf),tu=n(e),al=d(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-6vkfxj"&&(al.innerHTML=Lf),lu=n(e),ml=d(e,"TABLE",{"data-svelte-h":!0}),r(ml)!=="svelte-z6whez"&&(ml.innerHTML=wf),ou=n(e),su=d(e,"HR",{}),nu=n(e),pl=d(e,"A",{id:!0,class:!0}),h(pl).forEach(l),iu=n(e),m(cl.$$.fragment,e),du=n(e),fl=d(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-d6gvut"&&(fl.innerHTML=Af),ru=n(e),Tl=d(e,"P",{"data-svelte-h":!0}),r(Tl)!=="svelte-18n9ux4"&&(Tl.innerHTML=zf),uu=n(e),hl=d(e,"TABLE",{"data-svelte-h":!0}),r(hl)!=="svelte-jj58dd"&&(hl.innerHTML=gf),au=n(e),mu=d(e,"HR",{}),pu=n(e),_l=d(e,"A",{id:!0,class:!0}),h(_l).forEach(l),cu=n(e),m($l.$$.fragment,e),fu=n(e),vl=d(e,"P",{"data-svelte-h":!0}),r(vl)!=="svelte-1adolpg"&&(vl.innerHTML=Pf),Tu=n(e),bl=d(e,"P",{"data-svelte-h":!0}),r(bl)!=="svelte-1mr58c3"&&(bl.innerHTML=Rf),hu=n(e),_u=d(e,"HR",{}),$u=n(e),yl=d(e,"A",{id:!0,class:!0}),h(yl).forEach(l),vu=n(e),m(Ml.$$.fragment,e),bu=n(e),xl=d(e,"P",{"data-svelte-h":!0}),r(xl)!=="svelte-1hm8vtj"&&(xl.textContent=Uf),yu=n(e),Cl=d(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-1ywpke5"&&(Cl.innerHTML=Ef),Mu=n(e),Hl=d(e,"TABLE",{"data-svelte-h":!0}),r(Hl)!=="svelte-9ff0sy"&&(Hl.innerHTML=kf),xu=n(e),Cu=d(e,"HR",{}),Hu=n(e),Ll=d(e,"A",{id:!0,class:!0}),h(Ll).forEach(l),Lu=n(e),m(wl.$$.fragment,e),wu=n(e),Al=d(e,"P",{"data-svelte-h":!0}),r(Al)!=="svelte-1e6kzks"&&(Al.innerHTML=jf),Au=n(e),zl=d(e,"P",{"data-svelte-h":!0}),r(zl)!=="svelte-1mr58c3"&&(zl.innerHTML=Jf),zu=n(e),gu=d(e,"HR",{}),Pu=n(e),gl=d(e,"A",{id:!0,class:!0}),h(gl).forEach(l),Ru=n(e),m(Pl.$$.fragment,e),Uu=n(e),Rl=d(e,"P",{"data-svelte-h":!0}),r(Rl)!=="svelte-t5k6jp"&&(Rl.textContent=Df),Eu=n(e),Ul=d(e,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-1ywpke5"&&(Ul.innerHTML=qf),ku=n(e),ju=d(e,"HR",{}),Ju=n(e),El=d(e,"A",{id:!0,class:!0}),h(El).forEach(l),Du=n(e),m(kl.$$.fragment,e),qu=n(e),jl=d(e,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-avw2a1"&&(jl.textContent=If),Iu=n(e),Jl=d(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-16q99cu"&&(Jl.innerHTML=Kf),Ku=n(e),Dl=d(e,"TABLE",{"data-svelte-h":!0}),r(Dl)!=="svelte-jj5vaa"&&(Dl.innerHTML=Bf),Bu=n(e),Nu=d(e,"HR",{}),Vu=n(e),ql=d(e,"A",{id:!0,class:!0}),h(ql).forEach(l),Qu=n(e),m(Il.$$.fragment,e),Su=n(e),Kl=d(e,"P",{"data-svelte-h":!0}),r(Kl)!=="svelte-167n5bd"&&(Kl.textContent=Nf),Ou=n(e),Bl=d(e,"P",{"data-svelte-h":!0}),r(Bl)!=="svelte-1pz529g"&&(Bl.innerHTML=Vf),Fu=n(e),Nl=d(e,"TABLE",{"data-svelte-h":!0}),r(Nl)!=="svelte-1oyadc3"&&(Nl.innerHTML=Qf),Yu=n(e),Wu=d(e,"HR",{}),Gu=n(e),Vl=d(e,"A",{id:!0,class:!0}),h(Vl).forEach(l),Xu=n(e),m(Ql.$$.fragment,e),Zu=n(e),Sl=d(e,"P",{"data-svelte-h":!0}),r(Sl)!=="svelte-fju8tm"&&(Sl.textContent=Sf),ea=n(e),Ol=d(e,"P",{"data-svelte-h":!0}),r(Ol)!=="svelte-13s6o0v"&&(Ol.innerHTML=Of),ta=n(e),Fl=d(e,"TABLE",{"data-svelte-h":!0}),r(Fl)!=="svelte-8i278m"&&(Fl.innerHTML=Ff),la=n(e),oa=d(e,"HR",{}),sa=n(e),Yl=d(e,"A",{id:!0,class:!0}),h(Yl).forEach(l),na=n(e),m(Wl.$$.fragment,e),ia=n(e),Gl=d(e,"P",{"data-svelte-h":!0}),r(Gl)!=="svelte-18v04la"&&(Gl.innerHTML=Yf),da=n(e),Xl=d(e,"P",{"data-svelte-h":!0}),r(Xl)!=="svelte-16ws0dc"&&(Xl.innerHTML=Wf),ra=n(e),Zl=d(e,"TABLE",{"data-svelte-h":!0}),r(Zl)!=="svelte-14k2n4x"&&(Zl.innerHTML=Gf),ua=n(e),aa=d(e,"HR",{}),ma=n(e),eo=d(e,"A",{id:!0,class:!0}),h(eo).forEach(l),pa=n(e),m(to.$$.fragment,e),ca=n(e),lo=d(e,"P",{"data-svelte-h":!0}),r(lo)!=="svelte-1yvow13"&&(lo.innerHTML=Xf),fa=n(e),oo=d(e,"P",{"data-svelte-h":!0}),r(oo)!=="svelte-13n2k7m"&&(oo.innerHTML=Zf),Ta=n(e),so=d(e,"TABLE",{"data-svelte-h":!0}),r(so)!=="svelte-1ha3siw"&&(so.innerHTML=eT),ha=n(e),_a=d(e,"HR",{}),$a=n(e),no=d(e,"A",{id:!0,class:!0}),h(no).forEach(l),va=n(e),m(io.$$.fragment,e),ba=n(e),ro=d(e,"P",{"data-svelte-h":!0}),r(ro)!=="svelte-19dtamh"&&(ro.innerHTML=tT),ya=n(e),uo=d(e,"P",{"data-svelte-h":!0}),r(uo)!=="svelte-1nr5iz8"&&(uo.innerHTML=lT),Ma=n(e),ao=d(e,"TABLE",{"data-svelte-h":!0}),r(ao)!=="svelte-1hw4pq9"&&(ao.innerHTML=oT),xa=n(e),Ca=d(e,"HR",{}),Ha=n(e),mo=d(e,"A",{id:!0,class:!0}),h(mo).forEach(l),La=n(e),m(po.$$.fragment,e),wa=n(e),co=d(e,"P",{"data-svelte-h":!0}),r(co)!=="svelte-bd7moq"&&(co.innerHTML=sT),Aa=n(e),fo=d(e,"P",{"data-svelte-h":!0}),r(fo)!=="svelte-jyg3bg"&&(fo.innerHTML=nT),za=n(e),To=d(e,"TABLE",{"data-svelte-h":!0}),r(To)!=="svelte-1sdadnq"&&(To.innerHTML=iT),ga=n(e),Pa=d(e,"HR",{}),Ra=n(e),ho=d(e,"A",{id:!0,class:!0}),h(ho).forEach(l),Ua=n(e),m(_o.$$.fragment,e),Ea=n(e),$o=d(e,"P",{"data-svelte-h":!0}),r($o)!=="svelte-11ei68w"&&($o.textContent=dT),ka=n(e),vo=d(e,"P",{"data-svelte-h":!0}),r(vo)!=="svelte-1p3llh"&&(vo.innerHTML=rT),ja=n(e),bo=d(e,"TABLE",{"data-svelte-h":!0}),r(bo)!=="svelte-1xe0vb8"&&(bo.innerHTML=uT),Ja=n(e),Da=d(e,"HR",{}),qa=n(e),yo=d(e,"A",{id:!0,class:!0}),h(yo).forEach(l),Ia=n(e),m(Mo.$$.fragment,e),Ka=n(e),xo=d(e,"P",{"data-svelte-h":!0}),r(xo)!=="svelte-7ivim4"&&(xo.textContent=aT),Ba=n(e),Co=d(e,"P",{"data-svelte-h":!0}),r(Co)!=="svelte-151n4qz"&&(Co.innerHTML=mT),Na=n(e),Ho=d(e,"TABLE",{"data-svelte-h":!0}),r(Ho)!=="svelte-iprxta"&&(Ho.innerHTML=pT),Va=n(e),Qa=d(e,"HR",{}),Sa=n(e),Lo=d(e,"A",{id:!0,class:!0}),h(Lo).forEach(l),Oa=n(e),m(wo.$$.fragment,e),Fa=n(e),Ao=d(e,"P",{"data-svelte-h":!0}),r(Ao)!=="svelte-k6p1db"&&(Ao.textContent=cT),Ya=n(e),zo=d(e,"P",{"data-svelte-h":!0}),r(zo)!=="svelte-1o30xnd"&&(zo.innerHTML=fT),Wa=n(e),go=d(e,"TABLE",{"data-svelte-h":!0}),r(go)!=="svelte-101obk2"&&(go.innerHTML=TT),Ga=n(e),Xa=d(e,"HR",{}),Za=n(e),Po=d(e,"A",{id:!0,class:!0}),h(Po).forEach(l),em=n(e),m(Ro.$$.fragment,e),tm=n(e),Uo=d(e,"P",{"data-svelte-h":!0}),r(Uo)!=="svelte-8afo9v"&&(Uo.textContent=hT),lm=n(e),Eo=d(e,"P",{"data-svelte-h":!0}),r(Eo)!=="svelte-1vvmhgz"&&(Eo.innerHTML=_T),om=n(e),ko=d(e,"TABLE",{"data-svelte-h":!0}),r(ko)!=="svelte-wz2jkw"&&(ko.innerHTML=$T),sm=n(e),nm=d(e,"HR",{}),im=n(e),jo=d(e,"A",{id:!0,class:!0}),h(jo).forEach(l),dm=n(e),m(Jo.$$.fragment,e),rm=n(e),Do=d(e,"P",{"data-svelte-h":!0}),r(Do)!=="svelte-11plveb"&&(Do.innerHTML=vT),um=n(e),qo=d(e,"P",{"data-svelte-h":!0}),r(qo)!=="svelte-1wu8g4g"&&(qo.innerHTML=bT),am=n(e),Io=d(e,"TABLE",{"data-svelte-h":!0}),r(Io)!=="svelte-1vsvca3"&&(Io.innerHTML=yT),mm=n(e),pm=d(e,"HR",{}),cm=n(e),Ko=d(e,"A",{id:!0,class:!0}),h(Ko).forEach(l),fm=n(e),m(Bo.$$.fragment,e),Tm=n(e),No=d(e,"P",{"data-svelte-h":!0}),r(No)!=="svelte-17f4oxi"&&(No.textContent=MT),hm=n(e),Vo=d(e,"P",{"data-svelte-h":!0}),r(Vo)!=="svelte-2yq8vx"&&(Vo.innerHTML=xT),_m=n(e),Qo=d(e,"TABLE",{"data-svelte-h":!0}),r(Qo)!=="svelte-m4z8c4"&&(Qo.innerHTML=CT),$m=n(e),vm=d(e,"HR",{}),bm=n(e),So=d(e,"A",{id:!0,class:!0}),h(So).forEach(l),ym=n(e),m(Oo.$$.fragment,e),Mm=n(e),Fo=d(e,"P",{"data-svelte-h":!0}),r(Fo)!=="svelte-10qu7f7"&&(Fo.textContent=HT),xm=n(e),Yo=d(e,"P",{"data-svelte-h":!0}),r(Yo)!=="svelte-14iug9a"&&(Yo.innerHTML=LT),Cm=n(e),Wo=d(e,"TABLE",{"data-svelte-h":!0}),r(Wo)!=="svelte-stphn2"&&(Wo.innerHTML=wT),Hm=n(e),Lm=d(e,"HR",{}),wm=n(e),Go=d(e,"A",{id:!0,class:!0}),h(Go).forEach(l),Am=n(e),m(Xo.$$.fragment,e),zm=n(e),Zo=d(e,"P",{"data-svelte-h":!0}),r(Zo)!=="svelte-1ayje0f"&&(Zo.textContent=AT),gm=n(e),es=d(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-1ywifoz"&&(es.innerHTML=zT),Pm=n(e),ts=d(e,"TABLE",{"data-svelte-h":!0}),r(ts)!=="svelte-gyxne1"&&(ts.innerHTML=gT),Rm=n(e),Um=d(e,"HR",{}),Em=n(e),ls=d(e,"A",{id:!0,class:!0}),h(ls).forEach(l),km=n(e),m(os.$$.fragment,e),jm=n(e),ss=d(e,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-1wvb8sq"&&(ss.textContent=PT),Jm=n(e),ns=d(e,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1ywifoz"&&(ns.innerHTML=RT),Dm=n(e),is=d(e,"TABLE",{"data-svelte-h":!0}),r(is)!=="svelte-1fk5fng"&&(is.innerHTML=UT),qm=n(e),Im=d(e,"HR",{}),Km=n(e),ds=d(e,"A",{id:!0,class:!0}),h(ds).forEach(l),Bm=n(e),m(rs.$$.fragment,e),Nm=n(e),us=d(e,"P",{"data-svelte-h":!0}),r(us)!=="svelte-1798kaw"&&(us.textContent=ET),Vm=n(e),as=d(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-11aypax"&&(as.innerHTML=kT),Qm=n(e),ms=d(e,"TABLE",{"data-svelte-h":!0}),r(ms)!=="svelte-gyxne1"&&(ms.innerHTML=jT),Sm=n(e),Om=d(e,"HR",{}),Fm=n(e),ps=d(e,"A",{id:!0,class:!0}),h(ps).forEach(l),Ym=n(e),m(cs.$$.fragment,e),Wm=n(e),fs=d(e,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-9nnpip"&&(fs.textContent=JT),Gm=n(e),Ts=d(e,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-11aypax"&&(Ts.innerHTML=DT),Xm=n(e),hs=d(e,"TABLE",{"data-svelte-h":!0}),r(hs)!=="svelte-1fk5fng"&&(hs.innerHTML=qT),Zm=n(e),ep=d(e,"HR",{}),tp=n(e),_s=d(e,"A",{id:!0,class:!0}),h(_s).forEach(l),lp=n(e),m($s.$$.fragment,e),op=n(e),vs=d(e,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-185sm1b"&&(vs.textContent=IT),sp=n(e),bs=d(e,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-1y8qzzr"&&(bs.innerHTML=KT),np=n(e),ys=d(e,"TABLE",{"data-svelte-h":!0}),r(ys)!=="svelte-1v01t7k"&&(ys.innerHTML=BT),ip=n(e),dp=d(e,"HR",{}),rp=n(e),Ms=d(e,"A",{id:!0,class:!0}),h(Ms).forEach(l),up=n(e),m(xs.$$.fragment,e),ap=n(e),Cs=d(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-12loz97"&&(Cs.innerHTML=NT),mp=n(e),pp=d(e,"HR",{}),cp=n(e),Hs=d(e,"A",{id:!0,class:!0}),h(Hs).forEach(l),fp=n(e),m(Ls.$$.fragment,e),Tp=n(e),ws=d(e,"P",{"data-svelte-h":!0}),r(ws)!=="svelte-40isdg"&&(ws.textContent=VT),hp=n(e),As=d(e,"P",{"data-svelte-h":!0}),r(As)!=="svelte-tlsa2h"&&(As.innerHTML=QT),_p=n(e),zs=d(e,"TABLE",{"data-svelte-h":!0}),r(zs)!=="svelte-17343p6"&&(zs.innerHTML=ST),$p=n(e),gs=d(e,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-1aswmub"&&(gs.innerHTML=OT),vp=n(e),m(Ps.$$.fragment,e),bp=n(e),yp=d(e,"HR",{}),Mp=n(e),Rs=d(e,"A",{id:!0,class:!0}),h(Rs).forEach(l),xp=n(e),m(Us.$$.fragment,e),Cp=n(e),Es=d(e,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-kp31r8"&&(Es.innerHTML=FT),Hp=n(e),Lp=d(e,"HR",{}),wp=n(e),ks=d(e,"A",{id:!0,class:!0}),h(ks).forEach(l),Ap=n(e),m(js.$$.fragment,e),zp=n(e),Js=d(e,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-1fs9no9"&&(Js.innerHTML=YT),gp=n(e),Pp=d(e,"HR",{}),Rp=n(e),Ds=d(e,"A",{id:!0,class:!0}),h(Ds).forEach(l),Up=n(e),m(qs.$$.fragment,e),Ep=n(e),Is=d(e,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-2mif9c"&&(Is.textContent=WT),kp=n(e),Ks=d(e,"P",{"data-svelte-h":!0}),r(Ks)!=="svelte-1jas2kw"&&(Ks.innerHTML=GT),jp=n(e),m(Bs.$$.fragment,e),Jp=n(e),Ns=d(e,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-1aswmub"&&(Ns.innerHTML=XT),Dp=n(e),m(Vs.$$.fragment,e),qp=n(e),Qs=d(e,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-1aswmub"&&(Qs.innerHTML=ZT),Ip=n(e),m(Ss.$$.fragment,e),Kp=n(e),Bp=d(e,"HR",{}),Np=n(e),m(Os.$$.fragment,e),Vp=n(e),Ys=d(e,"P",{}),h(Ys).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",uh),u(v,"id","module_utils/tensor"),u(v,"class","group"),u(C,"id","module_utils/tensor.Tensor"),u(C,"class","group"),u(A,"id","new_module_utils/tensor.Tensor_new"),u(A,"class","group"),u(R,"id","module_utils/tensor.Tensor+dims"),u(R,"class","group"),u(j,"id","module_utils/tensor.Tensor+type"),u(j,"class","group"),u(I,"id","module_utils/tensor.Tensor+data"),u(I,"class","group"),u(V,"id","module_utils/tensor.Tensor+size"),u(V,"class","group"),u(F,"id","module_utils/tensor.Tensor+location"),u(F,"class","group"),u(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),u(X,"class","group"),u(le,"id","module_utils/tensor.Tensor+_getitem"),u(le,"class","group"),u(de,"id","module_utils/tensor.Tensor+indexOf"),u(de,"class","group"),u(me,"id","module_utils/tensor.Tensor+_subarray"),u(me,"class","group"),u(Te,"id","module_utils/tensor.Tensor+item"),u(Te,"class","group"),u(be,"id","module_utils/tensor.Tensor+tolist"),u(be,"class","group"),u(Ce,"id","module_utils/tensor.Tensor+sigmoid"),u(Ce,"class","group"),u(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),u(Ae,"class","group"),u(Re,"id","module_utils/tensor.Tensor+mul"),u(Re,"class","group"),u(Je,"id","module_utils/tensor.Tensor+mul_"),u(Je,"class","group"),u(Be,"id","module_utils/tensor.Tensor+div"),u(Be,"class","group"),u(Oe,"id","module_utils/tensor.Tensor+div_"),u(Oe,"class","group"),u(Xe,"id","module_utils/tensor.Tensor+add"),u(Xe,"class","group"),u(ot,"id","module_utils/tensor.Tensor+add_"),u(ot,"class","group"),u(rt,"id","module_utils/tensor.Tensor+permute"),u(rt,"class","group"),u(ct,"id","module_utils/tensor.Tensor+sum"),u(ct,"class","group"),u($t,"id","module_utils/tensor.Tensor+norm"),u($t,"class","group"),u(xt,"id","module_utils/tensor.Tensor+normalize_"),u(xt,"class","group"),u(At,"id","module_utils/tensor.Tensor+normalize"),u(At,"class","group"),u(Ut,"id","module_utils/tensor.Tensor+stride"),u(Ut,"class","group"),u(Jt,"id","module_utils/tensor.Tensor+squeeze"),u(Jt,"class","group"),u(Nt,"id","module_utils/tensor.Tensor+squeeze_"),u(Nt,"class","group"),u(Ot,"id","module_utils/tensor.Tensor+unsqueeze"),u(Ot,"class","group"),u(Zt,"id","module_utils/tensor.Tensor+unsqueeze_"),u(Zt,"class","group"),u(ol,"id","module_utils/tensor.Tensor+flatten_"),u(ol,"class","group"),u(dl,"id","module_utils/tensor.Tensor+flatten"),u(dl,"class","group"),u(pl,"id","module_utils/tensor.Tensor+view"),u(pl,"class","group"),u(_l,"id","module_utils/tensor.Tensor+clamp_"),u(_l,"class","group"),u(yl,"id","module_utils/tensor.Tensor+clamp"),u(yl,"class","group"),u(Ll,"id","module_utils/tensor.Tensor+round_"),u(Ll,"class","group"),u(gl,"id","module_utils/tensor.Tensor+round"),u(gl,"class","group"),u(El,"id","module_utils/tensor.Tensor+to"),u(El,"class","group"),u(ql,"id","module_utils/tensor.permute"),u(ql,"class","group"),u(Vl,"id","module_utils/tensor.interpolate"),u(Vl,"class","group"),u(Yl,"id","module_utils/tensor.interpolate_4d"),u(Yl,"class","group"),u(eo,"id","module_utils/tensor.matmul"),u(eo,"class","group"),u(no,"id","module_utils/tensor.rfft"),u(no,"class","group"),u(mo,"id","module_utils/tensor.topk"),u(mo,"class","group"),u(ho,"id","module_utils/tensor.mean_pooling"),u(ho,"class","group"),u(yo,"id","module_utils/tensor.layer_norm"),u(yo,"class","group"),u(Lo,"id","module_utils/tensor.cat"),u(Lo,"class","group"),u(Po,"id","module_utils/tensor.stack"),u(Po,"class","group"),u(jo,"id","module_utils/tensor.std_mean"),u(jo,"class","group"),u(Ko,"id","module_utils/tensor.mean"),u(Ko,"class","group"),u(So,"id","module_utils/tensor.full"),u(So,"class","group"),u(Go,"id","module_utils/tensor.ones"),u(Go,"class","group"),u(ls,"id","module_utils/tensor.ones_like"),u(ls,"class","group"),u(ds,"id","module_utils/tensor.zeros"),u(ds,"class","group"),u(ps,"id","module_utils/tensor.zeros_like"),u(ps,"class","group"),u(_s,"id","module_utils/tensor.quantize_embeddings"),u(_s,"class","group"),u(Ms,"id","module_utils/tensor..args[0]"),u(Ms,"class","group"),u(Hs,"id","module_utils/tensor..reshape"),u(Hs,"class","group"),u(Rs,"id","module_utils/tensor..reshape..reshapedArray"),u(Rs,"class","group"),u(ks,"id","module_utils/tensor..DataArray"),u(ks,"class","group"),u(Ds,"id","module_utils/tensor..NestArray"),u(Ds,"class","group")},m(e,t){ih(document.head,$),o(e,Ws,t),o(e,Fs,t),o(e,Gs,t),o(e,v,t),o(e,Xs,t),p(b,e,t),o(e,Zs,t),o(e,y,t),o(e,en,t),o(e,M,t),o(e,tn,t),o(e,x,t),o(e,ln,t),o(e,on,t),o(e,sn,t),o(e,C,t),o(e,nn,t),p(H,e,t),o(e,dn,t),o(e,L,t),o(e,rn,t),o(e,w,t),o(e,un,t),o(e,an,t),o(e,mn,t),o(e,A,t),o(e,pn,t),p(z,e,t),o(e,cn,t),o(e,g,t),o(e,fn,t),o(e,P,t),o(e,Tn,t),o(e,hn,t),o(e,_n,t),o(e,R,t),o(e,$n,t),p(U,e,t),o(e,vn,t),o(e,E,t),o(e,bn,t),o(e,k,t),o(e,yn,t),o(e,Mn,t),o(e,xn,t),o(e,j,t),o(e,Cn,t),p(J,e,t),o(e,Hn,t),o(e,D,t),o(e,Ln,t),o(e,q,t),o(e,wn,t),o(e,An,t),o(e,zn,t),o(e,I,t),o(e,gn,t),p(K,e,t),o(e,Pn,t),o(e,B,t),o(e,Rn,t),o(e,N,t),o(e,Un,t),o(e,En,t),o(e,kn,t),o(e,V,t),o(e,jn,t),p(Q,e,t),o(e,Jn,t),o(e,S,t),o(e,Dn,t),o(e,O,t),o(e,qn,t),o(e,In,t),o(e,Kn,t),o(e,F,t),o(e,Bn,t),p(Y,e,t),o(e,Nn,t),o(e,W,t),o(e,Vn,t),o(e,G,t),o(e,Qn,t),o(e,Sn,t),o(e,On,t),o(e,X,t),o(e,Fn,t),p(Z,e,t),o(e,Yn,t),o(e,ee,t),o(e,Wn,t),o(e,te,t),o(e,Gn,t),o(e,Xn,t),o(e,Zn,t),o(e,le,t),o(e,ei,t),p(oe,e,t),o(e,ti,t),o(e,se,t),o(e,li,t),o(e,ne,t),o(e,oi,t),o(e,ie,t),o(e,si,t),o(e,ni,t),o(e,ii,t),o(e,de,t),o(e,di,t),p(re,e,t),o(e,ri,t),o(e,ue,t),o(e,ui,t),o(e,ae,t),o(e,ai,t),o(e,mi,t),o(e,pi,t),o(e,me,t),o(e,ci,t),p(pe,e,t),o(e,fi,t),o(e,ce,t),o(e,Ti,t),o(e,fe,t),o(e,hi,t),o(e,_i,t),o(e,$i,t),o(e,Te,t),o(e,vi,t),p(he,e,t),o(e,bi,t),o(e,_e,t),o(e,yi,t),o(e,$e,t),o(e,Mi,t),o(e,ve,t),o(e,xi,t),o(e,Ci,t),o(e,Hi,t),o(e,be,t),o(e,Li,t),p(ye,e,t),o(e,wi,t),o(e,Me,t),o(e,Ai,t),o(e,xe,t),o(e,zi,t),o(e,gi,t),o(e,Pi,t),o(e,Ce,t),o(e,Ri,t),p(He,e,t),o(e,Ui,t),o(e,Le,t),o(e,Ei,t),o(e,we,t),o(e,ki,t),o(e,ji,t),o(e,Ji,t),o(e,Ae,t),o(e,Di,t),p(ze,e,t),o(e,qi,t),o(e,ge,t),o(e,Ii,t),o(e,Pe,t),o(e,Ki,t),o(e,Bi,t),o(e,Ni,t),o(e,Re,t),o(e,Vi,t),p(Ue,e,t),o(e,Qi,t),o(e,Ee,t),o(e,Si,t),o(e,ke,t),o(e,Oi,t),o(e,je,t),o(e,Fi,t),o(e,Yi,t),o(e,Wi,t),o(e,Je,t),o(e,Gi,t),p(De,e,t),o(e,Xi,t),o(e,qe,t),o(e,Zi,t),o(e,Ie,t),o(e,ed,t),o(e,Ke,t),o(e,td,t),o(e,ld,t),o(e,od,t),o(e,Be,t),o(e,sd,t),p(Ne,e,t),o(e,nd,t),o(e,Ve,t),o(e,id,t),o(e,Qe,t),o(e,dd,t),o(e,Se,t),o(e,rd,t),o(e,ud,t),o(e,ad,t),o(e,Oe,t),o(e,md,t),p(Fe,e,t),o(e,pd,t),o(e,Ye,t),o(e,cd,t),o(e,We,t),o(e,fd,t),o(e,Ge,t),o(e,Td,t),o(e,hd,t),o(e,_d,t),o(e,Xe,t),o(e,$d,t),p(Ze,e,t),o(e,vd,t),o(e,et,t),o(e,bd,t),o(e,tt,t),o(e,yd,t),o(e,lt,t),o(e,Md,t),o(e,xd,t),o(e,Cd,t),o(e,ot,t),o(e,Hd,t),p(st,e,t),o(e,Ld,t),o(e,nt,t),o(e,wd,t),o(e,it,t),o(e,Ad,t),o(e,dt,t),o(e,zd,t),o(e,gd,t),o(e,Pd,t),o(e,rt,t),o(e,Rd,t),p(ut,e,t),o(e,Ud,t),o(e,at,t),o(e,Ed,t),o(e,mt,t),o(e,kd,t),o(e,pt,t),o(e,jd,t),o(e,Jd,t),o(e,Dd,t),o(e,ct,t),o(e,qd,t),p(ft,e,t),o(e,Id,t),o(e,Tt,t),o(e,Kd,t),o(e,ht,t),o(e,Bd,t),o(e,_t,t),o(e,Nd,t),o(e,Vd,t),o(e,Qd,t),o(e,$t,t),o(e,Sd,t),p(vt,e,t),o(e,Od,t),o(e,bt,t),o(e,Fd,t),o(e,yt,t),o(e,Yd,t),o(e,Mt,t),o(e,Wd,t),o(e,Gd,t),o(e,Xd,t),o(e,xt,t),o(e,Zd,t),p(Ct,e,t),o(e,er,t),o(e,Ht,t),o(e,tr,t),o(e,Lt,t),o(e,lr,t),o(e,wt,t),o(e,or,t),o(e,sr,t),o(e,nr,t),o(e,At,t),o(e,ir,t),p(zt,e,t),o(e,dr,t),o(e,gt,t),o(e,rr,t),o(e,Pt,t),o(e,ur,t),o(e,Rt,t),o(e,ar,t),o(e,mr,t),o(e,pr,t),o(e,Ut,t),o(e,cr,t),p(Et,e,t),o(e,fr,t),o(e,kt,t),o(e,Tr,t),o(e,jt,t),o(e,hr,t),o(e,_r,t),o(e,$r,t),o(e,Jt,t),o(e,vr,t),p(Dt,e,t),o(e,br,t),o(e,qt,t),o(e,yr,t),o(e,It,t),o(e,Mr,t),o(e,Kt,t),o(e,xr,t),o(e,Bt,t),o(e,Cr,t),o(e,Hr,t),o(e,Lr,t),o(e,Nt,t),o(e,wr,t),p(Vt,e,t),o(e,Ar,t),o(e,Qt,t),o(e,zr,t),o(e,St,t),o(e,gr,t),o(e,Pr,t),o(e,Rr,t),o(e,Ot,t),o(e,Ur,t),p(Ft,e,t),o(e,Er,t),o(e,Yt,t),o(e,kr,t),o(e,Wt,t),o(e,jr,t),o(e,Gt,t),o(e,Jr,t),o(e,Xt,t),o(e,Dr,t),o(e,qr,t),o(e,Ir,t),o(e,Zt,t),o(e,Kr,t),p(el,e,t),o(e,Br,t),o(e,tl,t),o(e,Nr,t),o(e,ll,t),o(e,Vr,t),o(e,Qr,t),o(e,Sr,t),o(e,ol,t),o(e,Or,t),p(sl,e,t),o(e,Fr,t),o(e,nl,t),o(e,Yr,t),o(e,il,t),o(e,Wr,t),o(e,Gr,t),o(e,Xr,t),o(e,dl,t),o(e,Zr,t),p(rl,e,t),o(e,eu,t),o(e,ul,t),o(e,tu,t),o(e,al,t),o(e,lu,t),o(e,ml,t),o(e,ou,t),o(e,su,t),o(e,nu,t),o(e,pl,t),o(e,iu,t),p(cl,e,t),o(e,du,t),o(e,fl,t),o(e,ru,t),o(e,Tl,t),o(e,uu,t),o(e,hl,t),o(e,au,t),o(e,mu,t),o(e,pu,t),o(e,_l,t),o(e,cu,t),p($l,e,t),o(e,fu,t),o(e,vl,t),o(e,Tu,t),o(e,bl,t),o(e,hu,t),o(e,_u,t),o(e,$u,t),o(e,yl,t),o(e,vu,t),p(Ml,e,t),o(e,bu,t),o(e,xl,t),o(e,yu,t),o(e,Cl,t),o(e,Mu,t),o(e,Hl,t),o(e,xu,t),o(e,Cu,t),o(e,Hu,t),o(e,Ll,t),o(e,Lu,t),p(wl,e,t),o(e,wu,t),o(e,Al,t),o(e,Au,t),o(e,zl,t),o(e,zu,t),o(e,gu,t),o(e,Pu,t),o(e,gl,t),o(e,Ru,t),p(Pl,e,t),o(e,Uu,t),o(e,Rl,t),o(e,Eu,t),o(e,Ul,t),o(e,ku,t),o(e,ju,t),o(e,Ju,t),o(e,El,t),o(e,Du,t),p(kl,e,t),o(e,qu,t),o(e,jl,t),o(e,Iu,t),o(e,Jl,t),o(e,Ku,t),o(e,Dl,t),o(e,Bu,t),o(e,Nu,t),o(e,Vu,t),o(e,ql,t),o(e,Qu,t),p(Il,e,t),o(e,Su,t),o(e,Kl,t),o(e,Ou,t),o(e,Bl,t),o(e,Fu,t),o(e,Nl,t),o(e,Yu,t),o(e,Wu,t),o(e,Gu,t),o(e,Vl,t),o(e,Xu,t),p(Ql,e,t),o(e,Zu,t),o(e,Sl,t),o(e,ea,t),o(e,Ol,t),o(e,ta,t),o(e,Fl,t),o(e,la,t),o(e,oa,t),o(e,sa,t),o(e,Yl,t),o(e,na,t),p(Wl,e,t),o(e,ia,t),o(e,Gl,t),o(e,da,t),o(e,Xl,t),o(e,ra,t),o(e,Zl,t),o(e,ua,t),o(e,aa,t),o(e,ma,t),o(e,eo,t),o(e,pa,t),p(to,e,t),o(e,ca,t),o(e,lo,t),o(e,fa,t),o(e,oo,t),o(e,Ta,t),o(e,so,t),o(e,ha,t),o(e,_a,t),o(e,$a,t),o(e,no,t),o(e,va,t),p(io,e,t),o(e,ba,t),o(e,ro,t),o(e,ya,t),o(e,uo,t),o(e,Ma,t),o(e,ao,t),o(e,xa,t),o(e,Ca,t),o(e,Ha,t),o(e,mo,t),o(e,La,t),p(po,e,t),o(e,wa,t),o(e,co,t),o(e,Aa,t),o(e,fo,t),o(e,za,t),o(e,To,t),o(e,ga,t),o(e,Pa,t),o(e,Ra,t),o(e,ho,t),o(e,Ua,t),p(_o,e,t),o(e,Ea,t),o(e,$o,t),o(e,ka,t),o(e,vo,t),o(e,ja,t),o(e,bo,t),o(e,Ja,t),o(e,Da,t),o(e,qa,t),o(e,yo,t),o(e,Ia,t),p(Mo,e,t),o(e,Ka,t),o(e,xo,t),o(e,Ba,t),o(e,Co,t),o(e,Na,t),o(e,Ho,t),o(e,Va,t),o(e,Qa,t),o(e,Sa,t),o(e,Lo,t),o(e,Oa,t),p(wo,e,t),o(e,Fa,t),o(e,Ao,t),o(e,Ya,t),o(e,zo,t),o(e,Wa,t),o(e,go,t),o(e,Ga,t),o(e,Xa,t),o(e,Za,t),o(e,Po,t),o(e,em,t),p(Ro,e,t),o(e,tm,t),o(e,Uo,t),o(e,lm,t),o(e,Eo,t),o(e,om,t),o(e,ko,t),o(e,sm,t),o(e,nm,t),o(e,im,t),o(e,jo,t),o(e,dm,t),p(Jo,e,t),o(e,rm,t),o(e,Do,t),o(e,um,t),o(e,qo,t),o(e,am,t),o(e,Io,t),o(e,mm,t),o(e,pm,t),o(e,cm,t),o(e,Ko,t),o(e,fm,t),p(Bo,e,t),o(e,Tm,t),o(e,No,t),o(e,hm,t),o(e,Vo,t),o(e,_m,t),o(e,Qo,t),o(e,$m,t),o(e,vm,t),o(e,bm,t),o(e,So,t),o(e,ym,t),p(Oo,e,t),o(e,Mm,t),o(e,Fo,t),o(e,xm,t),o(e,Yo,t),o(e,Cm,t),o(e,Wo,t),o(e,Hm,t),o(e,Lm,t),o(e,wm,t),o(e,Go,t),o(e,Am,t),p(Xo,e,t),o(e,zm,t),o(e,Zo,t),o(e,gm,t),o(e,es,t),o(e,Pm,t),o(e,ts,t),o(e,Rm,t),o(e,Um,t),o(e,Em,t),o(e,ls,t),o(e,km,t),p(os,e,t),o(e,jm,t),o(e,ss,t),o(e,Jm,t),o(e,ns,t),o(e,Dm,t),o(e,is,t),o(e,qm,t),o(e,Im,t),o(e,Km,t),o(e,ds,t),o(e,Bm,t),p(rs,e,t),o(e,Nm,t),o(e,us,t),o(e,Vm,t),o(e,as,t),o(e,Qm,t),o(e,ms,t),o(e,Sm,t),o(e,Om,t),o(e,Fm,t),o(e,ps,t),o(e,Ym,t),p(cs,e,t),o(e,Wm,t),o(e,fs,t),o(e,Gm,t),o(e,Ts,t),o(e,Xm,t),o(e,hs,t),o(e,Zm,t),o(e,ep,t),o(e,tp,t),o(e,_s,t),o(e,lp,t),p($s,e,t),o(e,op,t),o(e,vs,t),o(e,sp,t),o(e,bs,t),o(e,np,t),o(e,ys,t),o(e,ip,t),o(e,dp,t),o(e,rp,t),o(e,Ms,t),o(e,up,t),p(xs,e,t),o(e,ap,t),o(e,Cs,t),o(e,mp,t),o(e,pp,t),o(e,cp,t),o(e,Hs,t),o(e,fp,t),p(Ls,e,t),o(e,Tp,t),o(e,ws,t),o(e,hp,t),o(e,As,t),o(e,_p,t),o(e,zs,t),o(e,$p,t),o(e,gs,t),o(e,vp,t),p(Ps,e,t),o(e,bp,t),o(e,yp,t),o(e,Mp,t),o(e,Rs,t),o(e,xp,t),p(Us,e,t),o(e,Cp,t),o(e,Es,t),o(e,Hp,t),o(e,Lp,t),o(e,wp,t),o(e,ks,t),o(e,Ap,t),p(js,e,t),o(e,zp,t),o(e,Js,t),o(e,gp,t),o(e,Pp,t),o(e,Rp,t),o(e,Ds,t),o(e,Up,t),p(qs,e,t),o(e,Ep,t),o(e,Is,t),o(e,kp,t),o(e,Ks,t),o(e,jp,t),p(Bs,e,t),o(e,Jp,t),o(e,Ns,t),o(e,Dp,t),p(Vs,e,t),o(e,qp,t),o(e,Qs,t),o(e,Ip,t),p(Ss,e,t),o(e,Kp,t),o(e,Bp,t),o(e,Np,t),p(Os,e,t),o(e,Vp,t),o(e,Ys,t),Qp=!0},p:th,i(e){Qp||(c(b.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(U.$$.fragment,e),c(J.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(He.$$.fragment,e),c(ze.$$.fragment,e),c(Ue.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(st.$$.fragment,e),c(ut.$$.fragment,e),c(ft.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(zt.$$.fragment,e),c(Et.$$.fragment,e),c(Dt.$$.fragment,e),c(Vt.$$.fragment,e),c(Ft.$$.fragment,e),c(el.$$.fragment,e),c(sl.$$.fragment,e),c(rl.$$.fragment,e),c(cl.$$.fragment,e),c($l.$$.fragment,e),c(Ml.$$.fragment,e),c(wl.$$.fragment,e),c(Pl.$$.fragment,e),c(kl.$$.fragment,e),c(Il.$$.fragment,e),c(Ql.$$.fragment,e),c(Wl.$$.fragment,e),c(to.$$.fragment,e),c(io.$$.fragment,e),c(po.$$.fragment,e),c(_o.$$.fragment,e),c(Mo.$$.fragment,e),c(wo.$$.fragment,e),c(Ro.$$.fragment,e),c(Jo.$$.fragment,e),c(Bo.$$.fragment,e),c(Oo.$$.fragment,e),c(Xo.$$.fragment,e),c(os.$$.fragment,e),c(rs.$$.fragment,e),c(cs.$$.fragment,e),c($s.$$.fragment,e),c(xs.$$.fragment,e),c(Ls.$$.fragment,e),c(Ps.$$.fragment,e),c(Us.$$.fragment,e),c(js.$$.fragment,e),c(qs.$$.fragment,e),c(Bs.$$.fragment,e),c(Vs.$$.fragment,e),c(Ss.$$.fragment,e),c(Os.$$.fragment,e),Qp=!0)},o(e){f(b.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(U.$$.fragment,e),f(J.$$.fragment,e),f(K.$$.fragment,e),f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(Z.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(He.$$.fragment,e),f(ze.$$.fragment,e),f(Ue.$$.fragment,e),f(De.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Ze.$$.fragment,e),f(st.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(vt.$$.fragment,e),f(Ct.$$.fragment,e),f(zt.$$.fragment,e),f(Et.$$.fragment,e),f(Dt.$$.fragment,e),f(Vt.$$.fragment,e),f(Ft.$$.fragment,e),f(el.$$.fragment,e),f(sl.$$.fragment,e),f(rl.$$.fragment,e),f(cl.$$.fragment,e),f($l.$$.fragment,e),f(Ml.$$.fragment,e),f(wl.$$.fragment,e),f(Pl.$$.fragment,e),f(kl.$$.fragment,e),f(Il.$$.fragment,e),f(Ql.$$.fragment,e),f(Wl.$$.fragment,e),f(to.$$.fragment,e),f(io.$$.fragment,e),f(po.$$.fragment,e),f(_o.$$.fragment,e),f(Mo.$$.fragment,e),f(wo.$$.fragment,e),f(Ro.$$.fragment,e),f(Jo.$$.fragment,e),f(Bo.$$.fragment,e),f(Oo.$$.fragment,e),f(Xo.$$.fragment,e),f(os.$$.fragment,e),f(rs.$$.fragment,e),f(cs.$$.fragment,e),f($s.$$.fragment,e),f(xs.$$.fragment,e),f(Ls.$$.fragment,e),f(Ps.$$.fragment,e),f(Us.$$.fragment,e),f(js.$$.fragment,e),f(qs.$$.fragment,e),f(Bs.$$.fragment,e),f(Vs.$$.fragment,e),f(Ss.$$.fragment,e),f(Os.$$.fragment,e),Qp=!1},d(e){e&&(l(Ws),l(Fs),l(Gs),l(v),l(Xs),l(Zs),l(y),l(en),l(M),l(tn),l(x),l(ln),l(on),l(sn),l(C),l(nn),l(dn),l(L),l(rn),l(w),l(un),l(an),l(mn),l(A),l(pn),l(cn),l(g),l(fn),l(P),l(Tn),l(hn),l(_n),l(R),l($n),l(vn),l(E),l(bn),l(k),l(yn),l(Mn),l(xn),l(j),l(Cn),l(Hn),l(D),l(Ln),l(q),l(wn),l(An),l(zn),l(I),l(gn),l(Pn),l(B),l(Rn),l(N),l(Un),l(En),l(kn),l(V),l(jn),l(Jn),l(S),l(Dn),l(O),l(qn),l(In),l(Kn),l(F),l(Bn),l(Nn),l(W),l(Vn),l(G),l(Qn),l(Sn),l(On),l(X),l(Fn),l(Yn),l(ee),l(Wn),l(te),l(Gn),l(Xn),l(Zn),l(le),l(ei),l(ti),l(se),l(li),l(ne),l(oi),l(ie),l(si),l(ni),l(ii),l(de),l(di),l(ri),l(ue),l(ui),l(ae),l(ai),l(mi),l(pi),l(me),l(ci),l(fi),l(ce),l(Ti),l(fe),l(hi),l(_i),l($i),l(Te),l(vi),l(bi),l(_e),l(yi),l($e),l(Mi),l(ve),l(xi),l(Ci),l(Hi),l(be),l(Li),l(wi),l(Me),l(Ai),l(xe),l(zi),l(gi),l(Pi),l(Ce),l(Ri),l(Ui),l(Le),l(Ei),l(we),l(ki),l(ji),l(Ji),l(Ae),l(Di),l(qi),l(ge),l(Ii),l(Pe),l(Ki),l(Bi),l(Ni),l(Re),l(Vi),l(Qi),l(Ee),l(Si),l(ke),l(Oi),l(je),l(Fi),l(Yi),l(Wi),l(Je),l(Gi),l(Xi),l(qe),l(Zi),l(Ie),l(ed),l(Ke),l(td),l(ld),l(od),l(Be),l(sd),l(nd),l(Ve),l(id),l(Qe),l(dd),l(Se),l(rd),l(ud),l(ad),l(Oe),l(md),l(pd),l(Ye),l(cd),l(We),l(fd),l(Ge),l(Td),l(hd),l(_d),l(Xe),l($d),l(vd),l(et),l(bd),l(tt),l(yd),l(lt),l(Md),l(xd),l(Cd),l(ot),l(Hd),l(Ld),l(nt),l(wd),l(it),l(Ad),l(dt),l(zd),l(gd),l(Pd),l(rt),l(Rd),l(Ud),l(at),l(Ed),l(mt),l(kd),l(pt),l(jd),l(Jd),l(Dd),l(ct),l(qd),l(Id),l(Tt),l(Kd),l(ht),l(Bd),l(_t),l(Nd),l(Vd),l(Qd),l($t),l(Sd),l(Od),l(bt),l(Fd),l(yt),l(Yd),l(Mt),l(Wd),l(Gd),l(Xd),l(xt),l(Zd),l(er),l(Ht),l(tr),l(Lt),l(lr),l(wt),l(or),l(sr),l(nr),l(At),l(ir),l(dr),l(gt),l(rr),l(Pt),l(ur),l(Rt),l(ar),l(mr),l(pr),l(Ut),l(cr),l(fr),l(kt),l(Tr),l(jt),l(hr),l(_r),l($r),l(Jt),l(vr),l(br),l(qt),l(yr),l(It),l(Mr),l(Kt),l(xr),l(Bt),l(Cr),l(Hr),l(Lr),l(Nt),l(wr),l(Ar),l(Qt),l(zr),l(St),l(gr),l(Pr),l(Rr),l(Ot),l(Ur),l(Er),l(Yt),l(kr),l(Wt),l(jr),l(Gt),l(Jr),l(Xt),l(Dr),l(qr),l(Ir),l(Zt),l(Kr),l(Br),l(tl),l(Nr),l(ll),l(Vr),l(Qr),l(Sr),l(ol),l(Or),l(Fr),l(nl),l(Yr),l(il),l(Wr),l(Gr),l(Xr),l(dl),l(Zr),l(eu),l(ul),l(tu),l(al),l(lu),l(ml),l(ou),l(su),l(nu),l(pl),l(iu),l(du),l(fl),l(ru),l(Tl),l(uu),l(hl),l(au),l(mu),l(pu),l(_l),l(cu),l(fu),l(vl),l(Tu),l(bl),l(hu),l(_u),l($u),l(yl),l(vu),l(bu),l(xl),l(yu),l(Cl),l(Mu),l(Hl),l(xu),l(Cu),l(Hu),l(Ll),l(Lu),l(wu),l(Al),l(Au),l(zl),l(zu),l(gu),l(Pu),l(gl),l(Ru),l(Uu),l(Rl),l(Eu),l(Ul),l(ku),l(ju),l(Ju),l(El),l(Du),l(qu),l(jl),l(Iu),l(Jl),l(Ku),l(Dl),l(Bu),l(Nu),l(Vu),l(ql),l(Qu),l(Su),l(Kl),l(Ou),l(Bl),l(Fu),l(Nl),l(Yu),l(Wu),l(Gu),l(Vl),l(Xu),l(Zu),l(Sl),l(ea),l(Ol),l(ta),l(Fl),l(la),l(oa),l(sa),l(Yl),l(na),l(ia),l(Gl),l(da),l(Xl),l(ra),l(Zl),l(ua),l(aa),l(ma),l(eo),l(pa),l(ca),l(lo),l(fa),l(oo),l(Ta),l(so),l(ha),l(_a),l($a),l(no),l(va),l(ba),l(ro),l(ya),l(uo),l(Ma),l(ao),l(xa),l(Ca),l(Ha),l(mo),l(La),l(wa),l(co),l(Aa),l(fo),l(za),l(To),l(ga),l(Pa),l(Ra),l(ho),l(Ua),l(Ea),l($o),l(ka),l(vo),l(ja),l(bo),l(Ja),l(Da),l(qa),l(yo),l(Ia),l(Ka),l(xo),l(Ba),l(Co),l(Na),l(Ho),l(Va),l(Qa),l(Sa),l(Lo),l(Oa),l(Fa),l(Ao),l(Ya),l(zo),l(Wa),l(go),l(Ga),l(Xa),l(Za),l(Po),l(em),l(tm),l(Uo),l(lm),l(Eo),l(om),l(ko),l(sm),l(nm),l(im),l(jo),l(dm),l(rm),l(Do),l(um),l(qo),l(am),l(Io),l(mm),l(pm),l(cm),l(Ko),l(fm),l(Tm),l(No),l(hm),l(Vo),l(_m),l(Qo),l($m),l(vm),l(bm),l(So),l(ym),l(Mm),l(Fo),l(xm),l(Yo),l(Cm),l(Wo),l(Hm),l(Lm),l(wm),l(Go),l(Am),l(zm),l(Zo),l(gm),l(es),l(Pm),l(ts),l(Rm),l(Um),l(Em),l(ls),l(km),l(jm),l(ss),l(Jm),l(ns),l(Dm),l(is),l(qm),l(Im),l(Km),l(ds),l(Bm),l(Nm),l(us),l(Vm),l(as),l(Qm),l(ms),l(Sm),l(Om),l(Fm),l(ps),l(Ym),l(Wm),l(fs),l(Gm),l(Ts),l(Xm),l(hs),l(Zm),l(ep),l(tp),l(_s),l(lp),l(op),l(vs),l(sp),l(bs),l(np),l(ys),l(ip),l(dp),l(rp),l(Ms),l(up),l(ap),l(Cs),l(mp),l(pp),l(cp),l(Hs),l(fp),l(Tp),l(ws),l(hp),l(As),l(_p),l(zs),l($p),l(gs),l(vp),l(bp),l(yp),l(Mp),l(Rs),l(xp),l(Cp),l(Es),l(Hp),l(Lp),l(wp),l(ks),l(Ap),l(zp),l(Js),l(gp),l(Pp),l(Rp),l(Ds),l(Up),l(Ep),l(Is),l(kp),l(Ks),l(jp),l(Jp),l(Ns),l(Dp),l(qp),l(Qs),l(Ip),l(Kp),l(Bp),l(Np),l(Vp),l(Ys)),l($),T(b,e),T(H,e),T(z,e),T(U,e),T(J,e),T(K,e),T(Q,e),T(Y,e),T(Z,e),T(oe,e),T(re,e),T(pe,e),T(he,e),T(ye,e),T(He,e),T(ze,e),T(Ue,e),T(De,e),T(Ne,e),T(Fe,e),T(Ze,e),T(st,e),T(ut,e),T(ft,e),T(vt,e),T(Ct,e),T(zt,e),T(Et,e),T(Dt,e),T(Vt,e),T(Ft,e),T(el,e),T(sl,e),T(rl,e),T(cl,e),T($l,e),T(Ml,e),T(wl,e),T(Pl,e),T(kl,e),T(Il,e),T(Ql,e),T(Wl,e),T(to,e),T(io,e),T(po,e),T(_o,e),T(Mo,e),T(wo,e),T(Ro,e),T(Jo,e),T(Bo,e),T(Oo,e),T(Xo,e),T(os,e),T(rs,e),T(cs,e),T($s,e),T(xs,e),T(Ls,e),T(Ps,e),T(Us,e),T(js,e),T(qs,e),T(Bs,e),T(Vs,e),T(Ss,e),T(Os,e)}}}const uh='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, k) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function ah(Op){return lh(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Th extends oh{constructor($){super(),sh(this,$,ah,rh,eh,{})}}export{Th as component};
