import{s as Ls,n as Ds,o as Ks}from"../chunks/scheduler.7bc62968.js";import{S as Ps,i as Os,g as h,s as t,r as p,A as sl,h as r,f as a,c as e,j as As,x as y,u as i,k as Ss,y as ll,a as n,v as c,d as M,t as o,w as J}from"../chunks/index.66556066.js";import{C as j}from"../chunks/CodeBlock.a759539a.js";import{H as m,E as al}from"../chunks/EditOnGithub.46ca76a5.js";function nl($s){let d,O,K,ss,T,Ys='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',ls,w,as,U,ns,u,Rs="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ts,g,Vs='<li><a href="inference/README">@huggingface/inference</a>: Use Inference Endpoints (dedicated) and Inference API (serverless) to make calls to 100,000+ Machine Learning models</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li> <li><a href="agents/README">@huggingface/agents</a>: Interact with HF models through a natural language interface</li> <li><a href="gguf/README">@huggingface/gguf</a>: A GGUF parser that works on remotely hosted files.</li> <li><a href="tasks/README">@huggingface/tasks</a>: The definition files and source-of-truth for the Hub’s main primitives like pipeline tasks, model libraries, etc.</li> <li><a href="space-header/README">@huggingface/space-header</a>: Use the Space <code>mini_header</code> outside Hugging Face</li>',es,b,vs="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",ps,f,Xs="The libraries are still very young, please help us by opening issues!",is,I,cs,G,Ms,B,Fs="To install via NPM, you can download the libraries as needed:",os,Z,Js,C,xs="Then import the libraries in your code:",hs,k,rs,W,ys,N,Hs='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',ms,Q,js,E,ds,S,Ts,$,ws,Y,zs='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',Us,R,us,V,gs,v,bs,X,fs,F,Is,x,Gs,H,_s="There are more features of course, check each library’s README!",Bs,z,Zs,_,Cs,q,ks,A,Ws,L,qs="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",Ns,D,Qs,P,Es;return w=new j({props:{code:"JTJGJTJGJTIwUHJvZ3JhbWF0aWNhbGx5JTIwaW50ZXJhY3QlMjB3aXRoJTIwdGhlJTIwSHViJTBBJTBBYXdhaXQlMjBjcmVhdGVSZXBvKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlN0J0eXBlJTNBJTIwJTIybW9kZWwlMjIlMkMlMjBuYW1lJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiU3RCUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMEElN0QpJTNCJTBBJTBBYXdhaXQlMjB1cGxvYWRGaWxlKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlMjJteS11c2VyJTJGbmxwLW1vZGVsJTIyJTJDJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMCUyRiUyRiUyMENhbiUyMHdvcmslMjB3aXRoJTIwbmF0aXZlJTIwRmlsZSUyMGluJTIwYnJvd3NlcnMlMEElMjAlMjBmaWxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcGF0aCUzQSUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGVudCUzQSUyMG5ldyUyMEJsb2IoLi4uKSUyMCUwQSUyMCUyMCU3RCUwQSU3RCklM0IlMEElMEElMkYlMkYlMjBVc2UlMjBob3N0ZWQlMjBpbmZlcmVuY2UlMEElMEFhd2FpdCUyMGluZmVyZW5jZS50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBpbmZlcmVuY2UudGV4dFRvSW1hZ2UoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTInJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ2F3YXJkJTIwd2lubmluZyUyMGhpZ2glMjByZXNvbHV0aW9uJTIwcGhvdG8lMjBvZiUyMGElMjBnaWFudCUyMHRvcnRvaXNlJTJGKChsYWR5YmlyZCkpJTIwaHlicmlkJTJDJTIwJTVCdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lNUQnJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzQSUyMCdibHVycnknJTJDJTBBJTIwJTIwJTdEJTBBJTdEKSUwQSUwQSUyRiUyRiUyMGFuZCUyMG11Y2glMjBtb3JlJUUyJTgwJUE2",highlighted:`<span class="hljs-comment">// Programatically interact with the Hub</span>

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: {<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>},
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-comment">// Use hosted inference</span>

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})

<span class="hljs-comment">// and much more…</span>`,wrap:!1}}),U=new m({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),I=new m({props:{title:"Installation",local:"installation",headingTag:"h2"}}),G=new m({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),Z=new j({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRz",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/agents`,wrap:!1}}),k=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBIZkFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEFpbXBvcnQlMjB0eXBlJTIwJTdCJTIwUmVwb0lkJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNC",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),W=new m({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),Q=new j({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCdodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSU0MDIuOC4wJTJGJTJCZXNtJyUzQiUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGY2RuLmpzZGVsaXZyLm5ldCUyRm5wbSUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTQwMC4xNi4wJTJGJTJCZXNtJTIyJTNCJTBBJTNDJTJGc2NyaXB0JTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@2.8.0/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@0.16.0/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),E=new m({props:{title:"Deno",local:"deno",headingTag:"h3"}}),S=new j({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQWltcG9ydCUyMCU3QiUyMEhmQWdlbnQlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaHViJTIy",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),$=new m({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),R=new m({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),V=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-comment">// Chat completion API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.2&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the this sentence with words one plus one is equal &quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">100</span>
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);

<span class="hljs-comment">// Streaming chat completion API</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> inference.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.2&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the this sentence with words one plus one is equal &quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">100</span>
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>);
}

<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Amsterdam&#x27;</span>
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,  
})

<span class="hljs-comment">// Using your own dedicated inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2 = inference.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});

<span class="hljs-comment">//Chat Completion</span>
<span class="hljs-keyword">const</span> mistal = inference.<span class="hljs-title function_">endpoint</span>(
 <span class="hljs-string">&quot;https://api-inference.huggingface.co/models/mistralai/Mistral-7B-Instruct-v0.2&quot;</span>
);
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> mistal.<span class="hljs-title function_">chatCompletion</span>({
 <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.2&quot;</span>,
 <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the this sentence with words one plus one is equal &quot;</span> }],
 <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);`,wrap:!1}}),v=new m({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),X=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMjAlMkYlMkYlMjBvciUyMCU3QnR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbmxwLXRlc3QlMjIlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMjAlMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjBkZWxldGVGaWxlcyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCdHlwZSUzQSUyMCUyMnNwYWNlJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZteS1zcGFjZSUyMiU3RCUyQyUyMCUyRiUyRiUyMG9yJTIwJTIyc3BhY2VzJTJGbXktdXNlciUyRm15LXNwYWNlJTIyJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMHBhdGhzJTNBJTIwJTVCJTIyUkVBRE1FLm1kJTIyJTJDJTIwJTIyLmdpdGF0dHJpYnV0ZXMlMjIlNUQlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or {type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot;},</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: {<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span>}, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),F=new m({props:{title:"@huggingface/agents example",local:"huggingfaceagents-example",headingTag:"h3"}}),x=new j({props:{code:"aW1wb3J0JTIwJTdCSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMkMlMjBkZWZhdWx0VG9vbHMlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJyUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwSGZBZ2VudCglMEElMjAlMjBIRl9UT0tFTiUyQyUwQSUyMCUyMExMTUZyb21IdWIoSEZfVE9LRU4pJTJDJTBBJTIwJTIwJTVCLi4uZGVmYXVsdFRvb2xzJTVEJTBBKSUzQiUwQSUwQSUwQSUyRiUyRiUyMHlvdSUyMGNhbiUyMGdlbmVyYXRlJTIwdGhlJTIwY29kZSUyQyUyMGluc3BlY3QlMjBpdCUyMGFuZCUyMHRoZW4lMjBydW4lMjBpdCUwQWNvbnN0JTIwY29kZSUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZ2VuZXJhdGVDb2RlKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUzQiUwQWNvbnNvbGUubG9nKGNvZGUpJTNCJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZXZhbHVhdGVDb2RlKGNvZGUpJTBBY29uc29sZS5sb2cobWVzc2FnZXMpJTNCJTIwJTJGJTJGJTIwY29udGFpbnMlMjB0aGUlMjBkYXRhJTBBJTBBJTJGJTJGJTIwb3IlMjB5b3UlMjBjYW4lMjBydW4lMjB0aGUlMjBjb2RlJTIwZGlyZWN0bHklMkMlMjBob3dldmVyJTIweW91JTIwY2FuJ3QlMjBjaGVjayUyMHRoYXQlMjB0aGUlMjBjb2RlJTIwaXMlMjBzYWZlJTIwdG8lMjBleGVjdXRlJTIwdGhpcyUyMHdheSUyQyUyMHVzZSUyMGF0JTIweW91ciUyMG93biUyMHJpc2suJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQucnVuKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUwQWNvbnNvbGUubG9nKG1lc3NhZ2VzKSUzQiUyMA==",highlighted:`<span class="hljs-keyword">import</span> {<span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span>, defaultTools} <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/agents&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-variable constant_">HF_TOKEN</span>),
  [...defaultTools]
);


<span class="hljs-comment">// you can generate the code, inspect it and then run it</span>
<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code);
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.evaluateCode(code)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); <span class="hljs-comment">// contains the data</span>

<span class="hljs-comment">// or you can run the code directly, however you can&#x27;t check that the code is safe to execute this way, use at your own risk.</span>
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); `,wrap:!1}}),z=new m({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),_=new j({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),q=new m({props:{title:"Building",local:"building",headingTag:"h2"}}),A=new j({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),D=new al({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/index.md"}}),{c(){d=h("meta"),O=t(),K=h("p"),ss=t(),T=h("p"),T.innerHTML=Ys,ls=t(),p(w.$$.fragment),as=t(),p(U.$$.fragment),ns=t(),u=h("p"),u.textContent=Rs,ts=t(),g=h("ul"),g.innerHTML=Vs,es=t(),b=h("p"),b.textContent=vs,ps=t(),f=h("p"),f.textContent=Xs,is=t(),p(I.$$.fragment),cs=t(),p(G.$$.fragment),Ms=t(),B=h("p"),B.textContent=Fs,os=t(),p(Z.$$.fragment),Js=t(),C=h("p"),C.textContent=xs,hs=t(),p(k.$$.fragment),rs=t(),p(W.$$.fragment),ys=t(),N=h("p"),N.innerHTML=Hs,ms=t(),p(Q.$$.fragment),js=t(),p(E.$$.fragment),ds=t(),p(S.$$.fragment),Ts=t(),p($.$$.fragment),ws=t(),Y=h("p"),Y.innerHTML=zs,Us=t(),p(R.$$.fragment),us=t(),p(V.$$.fragment),gs=t(),p(v.$$.fragment),bs=t(),p(X.$$.fragment),fs=t(),p(F.$$.fragment),Is=t(),p(x.$$.fragment),Gs=t(),H=h("p"),H.textContent=_s,Bs=t(),p(z.$$.fragment),Zs=t(),p(_.$$.fragment),Cs=t(),p(q.$$.fragment),ks=t(),p(A.$$.fragment),Ws=t(),L=h("p"),L.innerHTML=qs,Ns=t(),p(D.$$.fragment),Qs=t(),P=h("p"),this.h()},l(s){const l=sl("svelte-u9bgzb",document.head);d=r(l,"META",{name:!0,content:!0}),l.forEach(a),O=e(s),K=r(s,"P",{}),As(K).forEach(a),ss=e(s),T=r(s,"P",{align:!0,"data-svelte-h":!0}),y(T)!=="svelte-9rngw"&&(T.innerHTML=Ys),ls=e(s),i(w.$$.fragment,s),as=e(s),i(U.$$.fragment,s),ns=e(s),u=r(s,"P",{"data-svelte-h":!0}),y(u)!=="svelte-1eufct4"&&(u.textContent=Rs),ts=e(s),g=r(s,"UL",{"data-svelte-h":!0}),y(g)!=="svelte-15r0c4s"&&(g.innerHTML=Vs),es=e(s),b=r(s,"P",{"data-svelte-h":!0}),y(b)!=="svelte-5pb56g"&&(b.textContent=vs),ps=e(s),f=r(s,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1vx14v7"&&(f.textContent=Xs),is=e(s),i(I.$$.fragment,s),cs=e(s),i(G.$$.fragment,s),Ms=e(s),B=r(s,"P",{"data-svelte-h":!0}),y(B)!=="svelte-18mxf19"&&(B.textContent=Fs),os=e(s),i(Z.$$.fragment,s),Js=e(s),C=r(s,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1fdwpsr"&&(C.textContent=xs),hs=e(s),i(k.$$.fragment,s),rs=e(s),i(W.$$.fragment,s),ys=e(s),N=r(s,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1td2f08"&&(N.innerHTML=Hs),ms=e(s),i(Q.$$.fragment,s),js=e(s),i(E.$$.fragment,s),ds=e(s),i(S.$$.fragment,s),Ts=e(s),i($.$$.fragment,s),ws=e(s),Y=r(s,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-mx6w21"&&(Y.innerHTML=zs),Us=e(s),i(R.$$.fragment,s),us=e(s),i(V.$$.fragment,s),gs=e(s),i(v.$$.fragment,s),bs=e(s),i(X.$$.fragment,s),fs=e(s),i(F.$$.fragment,s),Is=e(s),i(x.$$.fragment,s),Gs=e(s),H=r(s,"P",{"data-svelte-h":!0}),y(H)!=="svelte-16qnxzd"&&(H.textContent=_s),Bs=e(s),i(z.$$.fragment,s),Zs=e(s),i(_.$$.fragment,s),Cs=e(s),i(q.$$.fragment,s),ks=e(s),i(A.$$.fragment,s),Ws=e(s),L=r(s,"P",{"data-svelte-h":!0}),y(L)!=="svelte-ymfi8c"&&(L.innerHTML=qs),Ns=e(s),i(D.$$.fragment,s),Qs=e(s),P=r(s,"P",{}),As(P).forEach(a),this.h()},h(){Ss(d,"name","hf:doc:metadata"),Ss(d,"content",tl),Ss(T,"align","center")},m(s,l){ll(document.head,d),n(s,O,l),n(s,K,l),n(s,ss,l),n(s,T,l),n(s,ls,l),c(w,s,l),n(s,as,l),c(U,s,l),n(s,ns,l),n(s,u,l),n(s,ts,l),n(s,g,l),n(s,es,l),n(s,b,l),n(s,ps,l),n(s,f,l),n(s,is,l),c(I,s,l),n(s,cs,l),c(G,s,l),n(s,Ms,l),n(s,B,l),n(s,os,l),c(Z,s,l),n(s,Js,l),n(s,C,l),n(s,hs,l),c(k,s,l),n(s,rs,l),c(W,s,l),n(s,ys,l),n(s,N,l),n(s,ms,l),c(Q,s,l),n(s,js,l),c(E,s,l),n(s,ds,l),c(S,s,l),n(s,Ts,l),c($,s,l),n(s,ws,l),n(s,Y,l),n(s,Us,l),c(R,s,l),n(s,us,l),c(V,s,l),n(s,gs,l),c(v,s,l),n(s,bs,l),c(X,s,l),n(s,fs,l),c(F,s,l),n(s,Is,l),c(x,s,l),n(s,Gs,l),n(s,H,l),n(s,Bs,l),c(z,s,l),n(s,Zs,l),c(_,s,l),n(s,Cs,l),c(q,s,l),n(s,ks,l),c(A,s,l),n(s,Ws,l),n(s,L,l),n(s,Ns,l),c(D,s,l),n(s,Qs,l),n(s,P,l),Es=!0},p:Ds,i(s){Es||(M(w.$$.fragment,s),M(U.$$.fragment,s),M(I.$$.fragment,s),M(G.$$.fragment,s),M(Z.$$.fragment,s),M(k.$$.fragment,s),M(W.$$.fragment,s),M(Q.$$.fragment,s),M(E.$$.fragment,s),M(S.$$.fragment,s),M($.$$.fragment,s),M(R.$$.fragment,s),M(V.$$.fragment,s),M(v.$$.fragment,s),M(X.$$.fragment,s),M(F.$$.fragment,s),M(x.$$.fragment,s),M(z.$$.fragment,s),M(_.$$.fragment,s),M(q.$$.fragment,s),M(A.$$.fragment,s),M(D.$$.fragment,s),Es=!0)},o(s){o(w.$$.fragment,s),o(U.$$.fragment,s),o(I.$$.fragment,s),o(G.$$.fragment,s),o(Z.$$.fragment,s),o(k.$$.fragment,s),o(W.$$.fragment,s),o(Q.$$.fragment,s),o(E.$$.fragment,s),o(S.$$.fragment,s),o($.$$.fragment,s),o(R.$$.fragment,s),o(V.$$.fragment,s),o(v.$$.fragment,s),o(X.$$.fragment,s),o(F.$$.fragment,s),o(x.$$.fragment,s),o(z.$$.fragment,s),o(_.$$.fragment,s),o(q.$$.fragment,s),o(A.$$.fragment,s),o(D.$$.fragment,s),Es=!1},d(s){s&&(a(O),a(K),a(ss),a(T),a(ls),a(as),a(ns),a(u),a(ts),a(g),a(es),a(b),a(ps),a(f),a(is),a(cs),a(Ms),a(B),a(os),a(Js),a(C),a(hs),a(rs),a(ys),a(N),a(ms),a(js),a(ds),a(Ts),a(ws),a(Y),a(Us),a(us),a(gs),a(bs),a(fs),a(Is),a(Gs),a(H),a(Bs),a(Zs),a(Cs),a(ks),a(Ws),a(L),a(Ns),a(Qs),a(P)),a(d),J(w,s),J(U,s),J(I,s),J(G,s),J(Z,s),J(k,s),J(W,s),J(Q,s),J(E,s),J(S,s),J($,s),J(R,s),J(V,s),J(v,s),J(X,s),J(F,s),J(x,s),J(z,s),J(_,s),J(q,s),J(A,s),J(D,s)}}}const tl='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3},{"title":"@huggingface/agents example","local":"huggingfaceagents-example","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function el($s){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Ps{constructor(d){super(),Os(this,d,el,nl,Ls,{})}}export{ol as component};
