import{s as Gs,f as Ke,o as Ns,n as Ws}from"../chunks/scheduler.889ebb13.js";import{S as Es,i as Fs,g as i,s as n,r,A as Hs,h as o,f as l,c as a,j as kl,u as y,x as M,k as c,y as $s,a as s,v as U,d as J,t as p,w as T,m as As,n as Zs}from"../chunks/index.ca18042b.js";import{T as Rs}from"../chunks/Tip.b8116e3c.js";import{C as d}from"../chunks/CodeBlock.1db71023.js";import{C as xs}from"../chunks/CourseFloatingBanner.bff79cca.js";import{H as m}from"../chunks/Heading.3daa581c.js";import{E as Xs}from"../chunks/EditOnGithub.2e95618d.js";function Ss(Oe){let u,h,j="this guide",C;return{c(){u=As("If you want to learn more about why code agents are effective, check out "),h=i("a"),h.textContent=j,C=As(" from the smolagents documentation."),this.h()},l(w){u=Zs(w,"If you want to learn more about why code agents are effective, check out "),h=o(w,"A",{href:!0,target:!0,"data-svelte-h":!0}),M(h)!=="svelte-16eiqye"&&(h.textContent=j),C=Zs(w," from the smolagents documentation."),this.h()},h(){c(h,"href","https://huggingface.co/docs/smolagents/en/conceptual_guides/intro_agents#code-agents"),c(h,"target","_blank")},m(w,f){s(w,u,f),s(w,h,f),s(w,C,f)},p:Ws,d(w){w&&(l(u),l(h),l(C))}}}function Qs(Oe){let u,h,j,C,w,f,b,et,B,vl="Code agents are the default agent type in <code>smolagents</code>. They generate Python tool calls directly to perform actions, making them both efficient and accurate.",tt,k,Vl="Their streamlined approach reduces the number of required actions, simplifies complex operations, and enables reuse of existing code functions. <code>smolagents</code> provides a lightweight framework for building code agents, implemented in approximately 1,000 lines of code.",lt,v,Al=`<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png" alt="Code vs JSON Actions"/>
Graphic from the paper <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>`,st,I,nt,V,at,A,Zl="In a multi-step agent process, the LLM writes and executes actions, typically involving external tool calls. Traditional approaches use a JSON format to specify tool names and arguments as strings, <strong>which the system must parse to determine which tool to execute</strong>.",it,Z,Gl='However, research shows that <strong>tool-calling LLMs work more effectively with code directly</strong>. This is a core principle of <code>smolagents</code>, as shown in the diagram above from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',ot,G,Nl="Writing actions in code rather than JSON offers several key advantages:",Mt,N,Wl="<li><strong>Composability</strong>: Easily combine and reuse actions</li> <li><strong>Object Management</strong>: Work directly with complex structures like images</li> <li><strong>Generality</strong>: Express any computationally possible task</li> <li><strong>Natural for LLMs</strong>: High-quality code is already present in LLM training data</li>",rt,W,yt,E,El='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/codeagent_docs.png" alt="From https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',Ut,F,Fl='The diagram above illustrates how <code>CodeAgent.run()</code> operates, following the <a href="https://huggingface.co/papers/2210.03629" rel="nofollow">ReAct framework</a>, which is currently the preferred approach for building multi-step agents. We already introduced the <code>MultiStepAgent</code> in the previous section, which serves as the core building block for <code>smolagents</code>. The <code>CodeAgent</code> is a special kind of <code>MultiStepAgent</code>, as we will see in this example underneath.',Jt,H,Hl="A <code>CodeAgent</code> performs actions through a cycle of steps, with existing variables and knowledge being incorporated into the agent’s logs as follows:",pt,$,$l='<li><p>The system prompt is stored in a <code>SystemPromptStep</code>, and the user query is logged in a <code>TaskStep</code>.</p></li> <li><p>Then, the following while loop is executed:</p> <p>2.1 The method <code>agent.write_memory_to_messages()</code> writes the agent’s logs into a list of LLM-readable <a href="https://huggingface.co/docs/transformers/en/chat_templating" rel="nofollow">chat messages</a>.</p> <p>2.2 These messages are sent to a <code>Model</code>, which generates a completion.</p> <p>2.3 The completion is parsed to extract the action, which, in our case, could be a code snippet since we’re working with a <code>CodeAgent</code>.</p> <p>2.4 The action is executed.</p> <p>2.5 The results are logged into memory in an <code>ActionStep</code>.</p></li>',Tt,R,Rl="At the end of each step, if the agent includes any function calls (in <code>agent.step_callback</code>), they are executed. Below, you can see an comparison diagram between a multi-step agent using the ReAct framework and a one step agent.",wt,x,xl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/open-source-llms-as-agents/ReAct.png" alt="Comparison diagram between a multi-step agent using the ReAct framework and a one step agent"/>',ct,X,ut,S,Xl="Alfred is planning a party at the Wayne family mansion and needs your help to ensure everything goes smoothly. To assist him, we’ll apply what we’ve learned about how a multi-step <code>CodeAgent</code> operates.",ht,Q,Sl,dt,_,Ql="If you haven’t installed <code>smolagents</code> yet, you can do so by running the following command:",mt,Y,gt,q,_l="Let’s also login to the Hugging Face Hub to have access to the Inference API.",Ct,L,jt,z,ft,P,Yl="An important part of a successful party is the music. Alfred needs some help selecting the playlist. Luckily, <code>smolagents</code> has got us covered! We can build an agent capable of searching the web using DuckDuckGo. To give the agent access to this tool, we include it in the tool list when creating the agent.",It,D,ql,bt,K,Ll='For the model, we’ll rely on <code>HfApiModel</code>, which provides access to Hugging Face’s <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>. The default model is <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>, which is performant and available for fast inference, but you can select any compatible model from the Hub.',Bt,O,zl="Running an agent is quite straightforward:",kt,ee,vt,te,Pl="When you run this example, the output will <strong>display a trace of the workflow steps being executed</strong>. It will also print the corresponding Python code with the message:",Vt,le,At,se,Dl="After a few steps, you’ll see the generated playlist that Alfred can use for the party! 🎵",Zt,ne,Gt,ae,Kl,Nt,ie,Ol="Now that we have selected a playlist, we need to organize the menu for the guests. Again, Alfred can take advantage of <code>smolagents</code> to do so. Here, we use the <code>@tool</code> decorator to define a custom function that acts as a tool. We’ll cover tool creation in more detail later, so for now, we can simply run the code.",Wt,oe,es="As you can see in the example below, we will create a tool using <code>@tool</code> decorator and include it in the <code>tools</code> list.",Et,Me,Ft,re,ts="The agent will run for a few steps until finding the answer.",Ht,ye,ls="The menu is ready! 🥗",$t,Ue,Rt,Je,ss="We have the playlist and menu ready, but we need to check one more crucial detail: preparation time!",xt,pe,ns="Alfred needs to calculate when everything would be ready if he started preparing now, in case they need assistance from other superheroes.",Xt,Te,as=`<strong>Code execution has strict security measures</strong> - imports outside a predefined safe list are blocked by default. However, you can authorize additional imports by passing them as strings in <code>additional_authorized_imports</code>.
For more details on secure code execution, see the official <a href="https://huggingface.co/docs/smolagents/tutorials/secure_code_execution" rel="nofollow">guide</a>.`,St,we,is="When creating the agent, we ill use <code>additional_authorized_imports</code> to allow for importing the <code>datetime</code> module.",Qt,ce,_t,ue,os,Yt,he,Ms=`These examples are just the beginning of what you can do with code agents, and we’re already starting to see their utility for preparing the party.
You can learn more about how to build code agents in the <a href="https://huggingface.co/docs/smolagents" rel="nofollow">smolagents documentation</a>.`,qt,de,rs="<code>smolagents</code> specializes in agents that write and execute Python code snippets, offering sandboxed execution for security. It supports both open-source and proprietary language models, making it adaptable to various development environments.",Lt,me,zt,ge,ys="Wouldn’t it be <strong>amazing to share our very own Alfred agent with the community</strong>? By doing so, anyone can easily download and use the agent directly from the Hub, bringing the ultimate party planner of Gotham to their fingertips! Let’s make it happen! 🎉",Pt,Ce,Us="The <code>smolagents</code> library makes this possible by allowing you to share a complete agent with the community and download others for immediate use. It’s as simple as the following:",Dt,je,Kt,fe,Js="To download the agent again, use the code below:",Ot,Ie,el,be,ps='What’s also exciting is that shared agents are directly available as Hugging Face Spaces, allowing you to interact with them in real-time. You can explore other agents <a href="https://huggingface.co/spaces/davidberenstein1957/smolagents-and-tools" rel="nofollow">here</a>.',tl,Be,Ts='For example, the <em>AlfredAgent</em> is available <a href="https://huggingface.co/spaces/sergiopaniego/AlfredAgent" rel="nofollow">here</a>. You can try it out directly below:',ll,g,ws,sl,ke,cs="You may be wondering—how did Alfred build such an agent using <code>smolagents</code>? By integrating several tools, he can generate an agent as follows. Don’t worry about the tools for now, as we’ll have a dedicated section later in this unit to explore that in detail:",nl,ve,al,Ve,us="As you can see, we’ve created a <code>CodeAgent</code> with several tools that enhance the agent’s functionality, turning it into the ultimate party planner ready to share with the community! 🎉",il,Ae,ol,Ze,hs="Now that we created our first Code Agent, let’s  <strong>learn how we can create Tool Calling Agents</strong>, the second type of agent available in <code>smolagents</code>.",Ml,Ge,rl,Ne,ds="As Alfred fine-tunes the Party Preparator Agent, he’s growing weary of debugging its runs. Agents, by nature, are unpredictable and difficult to inspect. But since he aims to build the ultimate Party Preparator Agent and deploy it in production, he needs robust traceability for future monitoring and analysis.",yl,We,ms='Once again, <code>smolagents</code> comes to the rescue! It embraces the <a href="https://opentelemetry.io/" rel="nofollow">OpenTelemetry</a> standard for instrumenting agent runs, allowing seamless inspection and logging. With the help of <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> and the <code>SmolagentsInstrumentor</code>, Alfred can easily track and analyze his agent’s behavior.',Ul,Ee,gs="Setting it up is straightforward!",Jl,Fe,Cs="First, we need to install the necessary dependencies:",pl,He,Tl,$e,js='Next, Alfred has already created an account on Langfuse and has his API keys ready. If you haven’t done so yet, you can sign up for Langfuse Cloud <a href="https://cloud.langfuse.com/" rel="nofollow">here</a> or explore <a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">alternatives</a>.',wl,Re,fs="Once you have your API keys, they need to be properly configured as follows:",cl,xe,ul,Xe,Is="Finally, Alfred is ready to initialize the <code>SmolagentsInstrumentor</code> and start tracking his agent’s performance.",hl,Se,dl,Qe,bs="Alfred is now connected 🔌! The runs from <code>smolagents</code> are being logged in Langfuse, giving him full visibility into the agent’s behavior. With this setup, he’s ready to revisit previous runs and refine his Party Preparator Agent even further.",ml,_e,gl,Ye,Bs='Alfred can now access this logs <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z" rel="nofollow">here</a> to review and analyze them.',Cl,qe,ks='Meanwhile, the <a href="https://open.spotify.com/playlist/0gZMMHjuxMrrybQ7wTMTpw" rel="nofollow">suggested playlist</a> sets the perfect vibe for the party preparations. Cool, right? 🎶',jl,Le,fl,ze,vs='<li><a href="https://huggingface.co/blog/smolagents" rel="nofollow">smolagents Blog</a> - Introduction to smolagents and code interactions</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">smolagents: Building Good Agents</a> - Best practices for reliable agents</li> <li><a href="https://www.anthropic.com/research/building-effective-agents" rel="nofollow">Building Effective Agents - Anthropic</a> - Agent design principles</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">Sharing runs with OpenTelemetry</a> - Details about how to setup OpenTelemetry for tracking your agents.</li>',Il,Pe,bl,De,Bl;return w=new xs({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/unit2/smolagents/smolagents_code_agents.ipynb"}]}}),b=new m({props:{title:"Building Agents That Use Code",local:"building-agents-that-use-code",headingTag:"h1"}}),I=new Rs({props:{$$slots:{default:[Ss]},$$scope:{ctx:Oe}}}),V=new m({props:{title:"Why Code Agents?",local:"why-code-agents",headingTag:"h2"}}),W=new m({props:{title:"How Does a Code Agent Work?",local:"how-does-a-code-agent-work",headingTag:"h2"}}),X=new m({props:{title:"Let’s See Some Examples",local:"lets-see-some-examples",headingTag:"h2"}}),Y=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjAtVQ==",highlighted:"pip install smolagents -U",wrap:!1}}),L=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),z=new m({props:{title:"Selecting a Playlist for the Party Using smolagents",local:"selecting-a-playlist-for-the-party-using-smolagents",headingTag:"h3"}}),ee=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSklMEElMEFhZ2VudC5ydW4oJTIyU2VhcmNoJTIwZm9yJTIwdGhlJTIwYmVzdCUyMG11c2ljJTIwcmVjb21tZW5kYXRpb25zJTIwZm9yJTIwYSUyMHBhcnR5JTIwYXQlMjB0aGUlMjBXYXluZSdzJTIwbWFuc2lvbi4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel

agent = CodeAgent(tools=[DuckDuckGoSearchTool()], model=HfApiModel())

agent.run(<span class="hljs-string">&quot;Search for the best music recommendations for a party at the Wayne&#x27;s mansion.&quot;</span>)`,wrap:!1}}),le=new d({props:{code:"JTIwJUUyJTk0JTgwJTIwRXhlY3V0aW5nJTIwcGFyc2VkJTIwY29kZSUzQSUyMCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCUyMCUwQSUyMCUyMHJlc3VsdHMlMjAlM0QlMjB3ZWJfc2VhcmNoKHF1ZXJ5JTNEJTIyYmVzdCUyMG11c2ljJTIwZm9yJTIwYSUyMEJhdG1hbiUyMHBhcnR5JTIyKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMHByaW50KHJlc3VsdHMpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJTIw",highlighted:` ─ Executing parsed code: ──────────────────────────────────────────────────────────────────────────────────────── 
  results = web_search(query=<span class="hljs-string">&quot;best music for a Batman party&quot;</span>)                                                      
  <span class="hljs-built_in">print</span>(results)                                                                                                   
 ───────────────────────────────────────────────────────────────────────────────────────────────────────────────── `,wrap:!1}}),ne=new m({props:{title:"Using a Custom Tool to Prepare the Menu",local:"using-a-custom-tool-to-prepare-the-menu",headingTag:"h3"}}),Me=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjB0b29sJTBBJTBBJTIzJTIwVG9vbCUyMHRvJTIwc3VnZ2VzdCUyMGElMjBtZW51JTIwYmFzZWQlMjBvbiUyMHRoZSUyMG9jY2FzaW9uJTBBJTQwdG9vbCUwQWRlZiUyMHN1Z2dlc3RfbWVudShvY2Nhc2lvbiUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwU3VnZ2VzdHMlMjBhJTIwbWVudSUyMGJhc2VkJTIwb24lMjB0aGUlMjBvY2Nhc2lvbi4lMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2NjYXNpb24lM0ElMjBUaGUlMjB0eXBlJTIwb2YlMjBvY2Nhc2lvbiUyMGZvciUyMHRoZSUyMHBhcnR5LiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwb2NjYXNpb24lMjAlM0QlM0QlMjAlMjJjYXN1YWwlMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJQaXp6YSUyQyUyMHNuYWNrcyUyQyUyMGFuZCUyMGRyaW5rcy4lMjIlMEElMjAlMjAlMjAlMjBlbGlmJTIwb2NjYXNpb24lMjAlM0QlM0QlMjAlMjJmb3JtYWwlMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjIzLWNvdXJzZSUyMGRpbm5lciUyMHdpdGglMjB3aW5lJTIwYW5kJTIwZGVzc2VydC4lMjIlMEElMjAlMjAlMjAlMjBlbGlmJTIwb2NjYXNpb24lMjAlM0QlM0QlMjAlMjJzdXBlcmhlcm8lMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJCdWZmZXQlMjB3aXRoJTIwaGlnaC1lbmVyZ3klMjBhbmQlMjBoZWFsdGh5JTIwZm9vZC4lMjIlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyQ3VzdG9tJTIwbWVudSUyMGZvciUyMHRoZSUyMGJ1dGxlci4lMjIlMEElMEElMjMlMjBBbGZyZWQlMkMlMjB0aGUlMjBidXRsZXIlMkMlMjBwcmVwYXJpbmclMjB0aGUlMjBtZW51JTIwZm9yJTIwdGhlJTIwcGFydHklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnN1Z2dlc3RfbWVudSU1RCUyQyUyMG1vZGVsJTNESGZBcGlNb2RlbCgpKSUwQSUwQSUyMyUyMFByZXBhcmluZyUyMHRoZSUyMG1lbnUlMjBmb3IlMjB0aGUlMjBwYXJ0eSUwQWFnZW50LnJ1biglMjJQcmVwYXJlJTIwYSUyMGZvcm1hbCUyMG1lbnUlMjBmb3IlMjB0aGUlMjBwYXJ0eS4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, tool

<span class="hljs-comment"># Tool to suggest a menu based on the occasion</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggests a menu based on the occasion.
    Args:
        occasion: The type of occasion for the party.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, snacks, and drinks.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;3-course dinner with wine and dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet with high-energy and healthy food.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Custom menu for the butler.&quot;</span>

<span class="hljs-comment"># Alfred, the butler, preparing the menu for the party</span>
agent = CodeAgent(tools=[suggest_menu], model=HfApiModel())

<span class="hljs-comment"># Preparing the menu for the party</span>
agent.run(<span class="hljs-string">&quot;Prepare a formal menu for the party.&quot;</span>)`,wrap:!1}}),Ue=new m({props:{title:"Using Python Imports Inside the Agent",local:"using-python-imports-inside-the-agent",headingTag:"h3"}}),ce=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMGRhdGV0aW1lJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSUyQyUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJ2RhdGV0aW1lJyU1RCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQWxmcmVkJTIwbmVlZHMlMjB0byUyMHByZXBhcmUlMjBmb3IlMjB0aGUlMjBwYXJ0eS4lMjBIZXJlJTIwYXJlJTIwdGhlJTIwdGFza3MlM0ElMEElMjAlMjAlMjAlMjAxLiUyMFByZXBhcmUlMjB0aGUlMjBkcmlua3MlMjAtJTIwMzAlMjBtaW51dGVzJTBBJTIwJTIwJTIwJTIwMi4lMjBEZWNvcmF0ZSUyMHRoZSUyMG1hbnNpb24lMjAtJTIwNjAlMjBtaW51dGVzJTBBJTIwJTIwJTIwJTIwMy4lMjBTZXQlMjB1cCUyMHRoZSUyMG1lbnUlMjAtJTIwNDUlMjBtaW51dGVzJTBBJTIwJTIwJTIwJTIwMy4lMjBQcmVwYXJlJTIwdGhlJTIwbXVzaWMlMjBhbmQlMjBwbGF5bGlzdCUyMC0lMjA0NSUyMG1pbnV0ZXMlMEElMEElMjAlMjAlMjAlMjBJZiUyMHdlJTIwc3RhcnQlMjByaWdodCUyMG5vdyUyQyUyMGF0JTIwd2hhdCUyMHRpbWUlMjB3aWxsJTIwdGhlJTIwcGFydHklMjBiZSUyMHJlYWR5JTNGJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> datetime

agent = CodeAgent(tools=[], model=HfApiModel(), additional_authorized_imports=[<span class="hljs-string">&#x27;datetime&#x27;</span>])

agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Alfred needs to prepare for the party. Here are the tasks:
    1. Prepare the drinks - 30 minutes
    2. Decorate the mansion - 60 minutes
    3. Set up the menu - 45 minutes
    3. Prepare the music and playlist - 45 minutes

    If we start right now, at what time will the party be ready?
    &quot;&quot;&quot;</span>
)`,wrap:!1}}),me=new m({props:{title:"Sharing Our Custom Party Preparator Agent to the Hub",local:"sharing-our-custom-party-preparator-agent-to-the-hub",headingTag:"h3"}}),je=new d({props:{code:"JTIzJTIwQ2hhbmdlJTIwdG8lMjB5b3VyJTIwdXNlcm5hbWUlMjBhbmQlMjByZXBvJTIwbmFtZSUwQWFnZW50LnB1c2hfdG9faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnKQ==",highlighted:`<span class="hljs-comment"># Change to your username and repo name</span>
agent.push_to_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>)`,wrap:!1}}),Ie=new d({props:{code:"JTIzJTIwQ2hhbmdlJTIwdG8lMjB5b3VyJTIwdXNlcm5hbWUlMjBhbmQlMjByZXBvJTIwbmFtZSUwQWFsZnJlZF9hZ2VudCUyMCUzRCUyMGFnZW50LmZyb21faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnKSUwQSUwQWFsZnJlZF9hZ2VudC5ydW4oJTIyR2l2ZSUyMG1lJTIwYmVzdCUyMHBsYXlsaXN0JTIwZm9yJTIwYSUyMHBhcnR5JTIwYXQlMjB0aGUlMjBXYXluZSdzJTIwbWFuc2lvbi4lMjBUaGUlMjBwYXJ0eSUyMGlkZWElMjBpcyUyMGElMjAndmlsbGFpbiUyMG1hc3F1ZXJhZGUnJTIwdGhlbWUlMjIp",highlighted:`<span class="hljs-comment"># Change to your username and repo name</span>
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>)

alfred_agent.run(<span class="hljs-string">&quot;Give me best playlist for a party at the Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)`,wrap:!1}}),ve=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, HfApiModel, Tool, tool, VisitWebpageTool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggests a menu based on the occasion.
    Args:
        occasion: The type of occasion for the party.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, snacks, and drinks.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;3-course dinner with wine and dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet with high-energy and healthy food.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Custom menu for the butler.&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.
    
    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)


<span class="hljs-comment"># Alfred, the butler, preparing the menu for the party</span>
agent = CodeAgent(
    tools=[
        DuckDuckGoSearchTool(), 
        VisitWebpageTool(),
        suggest_menu,
        catering_service_tool,
        SuperheroPartyThemeTool()
    ], 
    model=HfApiModel(),
    max_steps=<span class="hljs-number">10</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

agent.run(<span class="hljs-string">&quot;Give me best playlist for a party at the Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)`,wrap:!1}}),Ae=new m({props:{title:"Now, it’s your turn: build your very own agent and share it with the community using the knowledge we’ve just learned! 🕵️‍♂️💡",local:"now-its-your-turn-build-your-very-own-agent-and-share-it-with-the-community-using-the-knowledge-weve-just-learned-",headingTag:"h2"}}),Ge=new m({props:{title:"Inspecting Our Party Preparator Agent with OpenTelemetry and Langfuse 📡",local:"inspecting-our-party-preparator-agent-with-opentelemetry-and-langfuse-",headingTag:"h3"}}),He=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wZW50ZWxlbWV0cnktc2RrJTIwb3BlbnRlbGVtZXRyeS1leHBvcnRlci1vdGxwJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cw==",highlighted:"pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents",wrap:!1}}),xe=new d({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBiYXNlNjQlMEElMEFMQU5HRlVTRV9QVUJMSUNfS0VZJTNEJTIycGstbGYtLi4uJTIyJTBBTEFOR0ZVU0VfU0VDUkVUX0tFWSUzRCUyMnNrLWxmLS4uLiUyMiUwQUxBTkdGVVNFX0FVVEglM0RiYXNlNjQuYjY0ZW5jb2RlKGYlMjIlN0JMQU5HRlVTRV9QVUJMSUNfS0VZJTdEJTNBJTdCTEFOR0ZVU0VfU0VDUkVUX0tFWSU3RCUyMi5lbmNvZGUoKSkuZGVjb2RlKCklMEElMEFvcy5lbnZpcm9uJTVCJTIyT1RFTF9FWFBPUlRFUl9PVExQX0VORFBPSU5UJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMkZhcGklMkZwdWJsaWMlMkZvdGVsJTIyJTIwJTIzJTIwRVUlMjBkYXRhJTIwcmVnaW9uJTBBJTIzJTIwb3MuZW52aXJvbiU1QiUyMk9URUxfRVhQT1JURVJfT1RMUF9FTkRQT0lOVCUyMiU1RCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGdXMuY2xvdWQubGFuZ2Z1c2UuY29tJTJGYXBpJTJGcHVibGljJTJGb3RlbCUyMiUyMCUyMyUyMFVTJTIwZGF0YSUyMHJlZ2lvbiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJBdXRob3JpemF0aW9uJTNEQmFzaWMlMjAlN0JMQU5HRlVTRV9BVVRIJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> base64

LANGFUSE_PUBLIC_KEY=<span class="hljs-string">&quot;pk-lf-...&quot;</span>
LANGFUSE_SECRET_KEY=<span class="hljs-string">&quot;sk-lf-...&quot;</span>
LANGFUSE_AUTH=base64.b64encode(<span class="hljs-string">f&quot;<span class="hljs-subst">{LANGFUSE_PUBLIC_KEY}</span>:<span class="hljs-subst">{LANGFUSE_SECRET_KEY}</span>&quot;</span>.encode()).decode()

os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_ENDPOINT&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com/api/public/otel&quot;</span> <span class="hljs-comment"># EU data region</span>
<span class="hljs-comment"># os.environ[&quot;OTEL_EXPORTER_OTLP_ENDPOINT&quot;] = &quot;https://us.cloud.langfuse.com/api/public/otel&quot; # US data region</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;Authorization=Basic <span class="hljs-subst">{LANGFUSE_AUTH}</span>&quot;</span>`,wrap:!1}}),Se=new d({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlJTIwaW1wb3J0JTIwVHJhY2VyUHJvdmlkZXIlMEElMEFmcm9tJTIwb3BlbmluZmVyZW5jZS5pbnN0cnVtZW50YXRpb24uc21vbGFnZW50cyUyMGltcG9ydCUyMFNtb2xhZ2VudHNJbnN0cnVtZW50b3IlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeS5leHBvcnRlci5vdGxwLnByb3RvLmh0dHAudHJhY2VfZXhwb3J0ZXIlMjBpbXBvcnQlMjBPVExQU3BhbkV4cG9ydGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlLmV4cG9ydCUyMGltcG9ydCUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMEElMEF0cmFjZV9wcm92aWRlciUyMCUzRCUyMFRyYWNlclByb3ZpZGVyKCklMEF0cmFjZV9wcm92aWRlci5hZGRfc3Bhbl9wcm9jZXNzb3IoU2ltcGxlU3BhblByb2Nlc3NvcihPVExQU3BhbkV4cG9ydGVyKCkpKSUwQSUwQVNtb2xhZ2VudHNJbnN0cnVtZW50b3IoKS5pbnN0cnVtZW50KHRyYWNlcl9wcm92aWRlciUzRHRyYWNlX3Byb3ZpZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.sdk.trace <span class="hljs-keyword">import</span> TracerProvider

<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
<span class="hljs-keyword">from</span> opentelemetry.exporter.otlp.proto.http.trace_exporter <span class="hljs-keyword">import</span> OTLPSpanExporter
<span class="hljs-keyword">from</span> opentelemetry.sdk.trace.export <span class="hljs-keyword">import</span> SimpleSpanProcessor

trace_provider = TracerProvider()
trace_provider.add_span_processor(SimpleSpanProcessor(OTLPSpanExporter()))

SmolagentsInstrumentor().instrument(tracer_provider=trace_provider)`,wrap:!1}}),_e=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSklMEFhbGZyZWRfYWdlbnQlMjAlM0QlMjBhZ2VudC5mcm9tX2h1Yignc2VyZ2lvcGFuaWVnbyUyRkFsZnJlZEFnZW50JyUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFhbGZyZWRfYWdlbnQucnVuKCUyMkdpdmUlMjBtZSUyMGJlc3QlMjBwbGF5bGlzdCUyMGZvciUyMGElMjBwYXJ0eSUyMGF0JTIwdGhlJTIwV2F5bmUncyUyMG1hbnNpb24uJTIwVGhlJTIwcGFydHklMjBpZGVhJTIwaXMlMjBhJTIwJ3ZpbGxhaW4lMjBtYXNxdWVyYWRlJyUyMHRoZW1lJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

agent = CodeAgent(tools=[], model=HfApiModel())
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
alfred_agent.run(<span class="hljs-string">&quot;Give me best playlist for a party at the Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)`,wrap:!1}}),Le=new m({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Pe=new Xs({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/code_agents.mdx"}}),{c(){u=i("meta"),h=n(),j=i("p"),C=n(),r(w.$$.fragment),f=n(),r(b.$$.fragment),et=n(),B=i("p"),B.innerHTML=vl,tt=n(),k=i("p"),k.innerHTML=Vl,lt=n(),v=i("p"),v.innerHTML=Al,st=n(),r(I.$$.fragment),nt=n(),r(V.$$.fragment),at=n(),A=i("p"),A.innerHTML=Zl,it=n(),Z=i("p"),Z.innerHTML=Gl,ot=n(),G=i("p"),G.textContent=Nl,Mt=n(),N=i("ul"),N.innerHTML=Wl,rt=n(),r(W.$$.fragment),yt=n(),E=i("p"),E.innerHTML=El,Ut=n(),F=i("p"),F.innerHTML=Fl,Jt=n(),H=i("p"),H.innerHTML=Hl,pt=n(),$=i("ol"),$.innerHTML=$l,Tt=n(),R=i("p"),R.innerHTML=Rl,wt=n(),x=i("p"),x.innerHTML=xl,ct=n(),r(X.$$.fragment),ut=n(),S=i("p"),S.innerHTML=Xl,ht=n(),Q=i("img"),dt=n(),_=i("p"),_.innerHTML=Ql,mt=n(),r(Y.$$.fragment),gt=n(),q=i("p"),q.textContent=_l,Ct=n(),r(L.$$.fragment),jt=n(),r(z.$$.fragment),ft=n(),P=i("p"),P.innerHTML=Yl,It=n(),D=i("img"),bt=n(),K=i("p"),K.innerHTML=Ll,Bt=n(),O=i("p"),O.textContent=zl,kt=n(),r(ee.$$.fragment),vt=n(),te=i("p"),te.innerHTML=Pl,Vt=n(),r(le.$$.fragment),At=n(),se=i("p"),se.textContent=Dl,Zt=n(),r(ne.$$.fragment),Gt=n(),ae=i("img"),Nt=n(),ie=i("p"),ie.innerHTML=Ol,Wt=n(),oe=i("p"),oe.innerHTML=es,Et=n(),r(Me.$$.fragment),Ft=n(),re=i("p"),re.textContent=ts,Ht=n(),ye=i("p"),ye.textContent=ls,$t=n(),r(Ue.$$.fragment),Rt=n(),Je=i("p"),Je.textContent=ss,xt=n(),pe=i("p"),pe.textContent=ns,Xt=n(),Te=i("p"),Te.innerHTML=as,St=n(),we=i("p"),we.innerHTML=is,Qt=n(),r(ce.$$.fragment),_t=n(),ue=i("img"),Yt=n(),he=i("p"),he.innerHTML=Ms,qt=n(),de=i("p"),de.innerHTML=rs,Lt=n(),r(me.$$.fragment),zt=n(),ge=i("p"),ge.innerHTML=ys,Pt=n(),Ce=i("p"),Ce.innerHTML=Us,Dt=n(),r(je.$$.fragment),Kt=n(),fe=i("p"),fe.textContent=Js,Ot=n(),r(Ie.$$.fragment),el=n(),be=i("p"),be.innerHTML=ps,tl=n(),Be=i("p"),Be.innerHTML=Ts,ll=n(),g=i("iframe"),sl=n(),ke=i("p"),ke.innerHTML=cs,nl=n(),r(ve.$$.fragment),al=n(),Ve=i("p"),Ve.innerHTML=us,il=n(),r(Ae.$$.fragment),ol=n(),Ze=i("p"),Ze.innerHTML=hs,Ml=n(),r(Ge.$$.fragment),rl=n(),Ne=i("p"),Ne.textContent=ds,yl=n(),We=i("p"),We.innerHTML=ms,Ul=n(),Ee=i("p"),Ee.textContent=gs,Jl=n(),Fe=i("p"),Fe.textContent=Cs,pl=n(),r(He.$$.fragment),Tl=n(),$e=i("p"),$e.innerHTML=js,wl=n(),Re=i("p"),Re.textContent=fs,cl=n(),r(xe.$$.fragment),ul=n(),Xe=i("p"),Xe.innerHTML=Is,hl=n(),r(Se.$$.fragment),dl=n(),Qe=i("p"),Qe.innerHTML=bs,ml=n(),r(_e.$$.fragment),gl=n(),Ye=i("p"),Ye.innerHTML=Bs,Cl=n(),qe=i("p"),qe.innerHTML=ks,jl=n(),r(Le.$$.fragment),fl=n(),ze=i("ul"),ze.innerHTML=vs,Il=n(),r(Pe.$$.fragment),bl=n(),De=i("p"),this.h()},l(e){const t=Hs("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),j=o(e,"P",{}),kl(j).forEach(l),C=a(e),y(w.$$.fragment,e),f=a(e),y(b.$$.fragment,e),et=a(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-ooajoa"&&(B.innerHTML=vl),tt=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1vji85d"&&(k.innerHTML=Vl),lt=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1uhgwdo"&&(v.innerHTML=Al),st=a(e),y(I.$$.fragment,e),nt=a(e),y(V.$$.fragment,e),at=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-i4pkup"&&(A.innerHTML=Zl),it=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-qsp339"&&(Z.innerHTML=Gl),ot=a(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1cvhdio"&&(G.textContent=Nl),Mt=a(e),N=o(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-1sdj82c"&&(N.innerHTML=Wl),rt=a(e),y(W.$$.fragment,e),yt=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-2i0rf5"&&(E.innerHTML=El),Ut=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1tll1mg"&&(F.innerHTML=Fl),Jt=a(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-10tcl0a"&&(H.innerHTML=Hl),pt=a(e),$=o(e,"OL",{"data-svelte-h":!0}),M($)!=="svelte-1cxivd8"&&($.innerHTML=$l),Tt=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-fvr3nw"&&(R.innerHTML=Rl),wt=a(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-g2xo6s"&&(x.innerHTML=xl),ct=a(e),y(X.$$.fragment,e),ut=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1bke2ma"&&(S.innerHTML=Xl),ht=a(e),Q=o(e,"IMG",{src:!0,alt:!0}),dt=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1rbs9u6"&&(_.innerHTML=Ql),mt=a(e),y(Y.$$.fragment,e),gt=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1doymd4"&&(q.textContent=_l),Ct=a(e),y(L.$$.fragment,e),jt=a(e),y(z.$$.fragment,e),ft=a(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-148x7vi"&&(P.innerHTML=Yl),It=a(e),D=o(e,"IMG",{src:!0,alt:!0}),bt=a(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-cuyv2x"&&(K.innerHTML=Ll),Bt=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1aau6qe"&&(O.textContent=zl),kt=a(e),y(ee.$$.fragment,e),vt=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1idfq95"&&(te.innerHTML=Pl),Vt=a(e),y(le.$$.fragment,e),At=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-qibxtx"&&(se.textContent=Dl),Zt=a(e),y(ne.$$.fragment,e),Gt=a(e),ae=o(e,"IMG",{src:!0,alt:!0}),Nt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1voj352"&&(ie.innerHTML=Ol),Wt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-13ytat2"&&(oe.innerHTML=es),Et=a(e),y(Me.$$.fragment,e),Ft=a(e),re=o(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1n4kpd8"&&(re.textContent=ts),Ht=a(e),ye=o(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-1f7ze3r"&&(ye.textContent=ls),$t=a(e),y(Ue.$$.fragment,e),Rt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-8depwo"&&(Je.textContent=ss),xt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-eykpll"&&(pe.textContent=ns),Xt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-fobjrc"&&(Te.innerHTML=as),St=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-mrhb4x"&&(we.innerHTML=is),Qt=a(e),y(ce.$$.fragment,e),_t=a(e),ue=o(e,"IMG",{src:!0,alt:!0}),Yt=a(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-vwsn9d"&&(he.innerHTML=Ms),qt=a(e),de=o(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-cubl8e"&&(de.innerHTML=rs),Lt=a(e),y(me.$$.fragment,e),zt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1hhl4b3"&&(ge.innerHTML=ys),Pt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1phne6y"&&(Ce.innerHTML=Us),Dt=a(e),y(je.$$.fragment,e),Kt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-rbahqz"&&(fe.textContent=Js),Ot=a(e),y(Ie.$$.fragment,e),el=a(e),be=o(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-ig9tc2"&&(be.innerHTML=ps),tl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-ivdwzg"&&(Be.innerHTML=Ts),ll=a(e),g=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),kl(g).forEach(l),sl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-1dqpcjq"&&(ke.innerHTML=cs),nl=a(e),y(ve.$$.fragment,e),al=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-1096ue8"&&(Ve.innerHTML=us),il=a(e),y(Ae.$$.fragment,e),ol=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1c0v7ho"&&(Ze.innerHTML=hs),Ml=a(e),y(Ge.$$.fragment,e),rl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-1cbcpl7"&&(Ne.textContent=ds),yl=a(e),We=o(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-lvq792"&&(We.innerHTML=ms),Ul=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-1nz0zrc"&&(Ee.textContent=gs),Jl=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-bon1th"&&(Fe.textContent=Cs),pl=a(e),y(He.$$.fragment,e),Tl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-1j4k9mc"&&($e.innerHTML=js),wl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-6s2c5k"&&(Re.textContent=fs),cl=a(e),y(xe.$$.fragment,e),ul=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-1ci9jvt"&&(Xe.innerHTML=Is),hl=a(e),y(Se.$$.fragment,e),dl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-1segbhq"&&(Qe.innerHTML=bs),ml=a(e),y(_e.$$.fragment,e),gl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-1y9qic2"&&(Ye.innerHTML=Bs),Cl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-emnj79"&&(qe.innerHTML=ks),jl=a(e),y(Le.$$.fragment,e),fl=a(e),ze=o(e,"UL",{"data-svelte-h":!0}),M(ze)!=="svelte-695w00"&&(ze.innerHTML=vs),Il=a(e),y(Pe.$$.fragment,e),bl=a(e),De=o(e,"P",{}),kl(De).forEach(l),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",_s),Ke(Q.src,Sl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-party.jpg")||c(Q,"src",Sl),c(Q,"alt","Alfred Party"),Ke(D.src,ql="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-playlist.jpg")||c(D,"src",ql),c(D,"alt","Alfred Playlist"),Ke(ae.src,Kl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-menu.jpg")||c(ae,"src",Kl),c(ae,"alt","Alfred Menu"),Ke(ue.src,os="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-process.jpg")||c(ue,"src",os),c(ue,"alt","Alfred Process"),Ke(g.src,ws="https://sergiopaniego-alfredagent.hf.space/")||c(g,"src",ws),c(g,"frameborder","0"),c(g,"width","850"),c(g,"height","450")},m(e,t){$s(document.head,u),s(e,h,t),s(e,j,t),s(e,C,t),U(w,e,t),s(e,f,t),U(b,e,t),s(e,et,t),s(e,B,t),s(e,tt,t),s(e,k,t),s(e,lt,t),s(e,v,t),s(e,st,t),U(I,e,t),s(e,nt,t),U(V,e,t),s(e,at,t),s(e,A,t),s(e,it,t),s(e,Z,t),s(e,ot,t),s(e,G,t),s(e,Mt,t),s(e,N,t),s(e,rt,t),U(W,e,t),s(e,yt,t),s(e,E,t),s(e,Ut,t),s(e,F,t),s(e,Jt,t),s(e,H,t),s(e,pt,t),s(e,$,t),s(e,Tt,t),s(e,R,t),s(e,wt,t),s(e,x,t),s(e,ct,t),U(X,e,t),s(e,ut,t),s(e,S,t),s(e,ht,t),s(e,Q,t),s(e,dt,t),s(e,_,t),s(e,mt,t),U(Y,e,t),s(e,gt,t),s(e,q,t),s(e,Ct,t),U(L,e,t),s(e,jt,t),U(z,e,t),s(e,ft,t),s(e,P,t),s(e,It,t),s(e,D,t),s(e,bt,t),s(e,K,t),s(e,Bt,t),s(e,O,t),s(e,kt,t),U(ee,e,t),s(e,vt,t),s(e,te,t),s(e,Vt,t),U(le,e,t),s(e,At,t),s(e,se,t),s(e,Zt,t),U(ne,e,t),s(e,Gt,t),s(e,ae,t),s(e,Nt,t),s(e,ie,t),s(e,Wt,t),s(e,oe,t),s(e,Et,t),U(Me,e,t),s(e,Ft,t),s(e,re,t),s(e,Ht,t),s(e,ye,t),s(e,$t,t),U(Ue,e,t),s(e,Rt,t),s(e,Je,t),s(e,xt,t),s(e,pe,t),s(e,Xt,t),s(e,Te,t),s(e,St,t),s(e,we,t),s(e,Qt,t),U(ce,e,t),s(e,_t,t),s(e,ue,t),s(e,Yt,t),s(e,he,t),s(e,qt,t),s(e,de,t),s(e,Lt,t),U(me,e,t),s(e,zt,t),s(e,ge,t),s(e,Pt,t),s(e,Ce,t),s(e,Dt,t),U(je,e,t),s(e,Kt,t),s(e,fe,t),s(e,Ot,t),U(Ie,e,t),s(e,el,t),s(e,be,t),s(e,tl,t),s(e,Be,t),s(e,ll,t),s(e,g,t),s(e,sl,t),s(e,ke,t),s(e,nl,t),U(ve,e,t),s(e,al,t),s(e,Ve,t),s(e,il,t),U(Ae,e,t),s(e,ol,t),s(e,Ze,t),s(e,Ml,t),U(Ge,e,t),s(e,rl,t),s(e,Ne,t),s(e,yl,t),s(e,We,t),s(e,Ul,t),s(e,Ee,t),s(e,Jl,t),s(e,Fe,t),s(e,pl,t),U(He,e,t),s(e,Tl,t),s(e,$e,t),s(e,wl,t),s(e,Re,t),s(e,cl,t),U(xe,e,t),s(e,ul,t),s(e,Xe,t),s(e,hl,t),U(Se,e,t),s(e,dl,t),s(e,Qe,t),s(e,ml,t),U(_e,e,t),s(e,gl,t),s(e,Ye,t),s(e,Cl,t),s(e,qe,t),s(e,jl,t),U(Le,e,t),s(e,fl,t),s(e,ze,t),s(e,Il,t),U(Pe,e,t),s(e,bl,t),s(e,De,t),Bl=!0},p(e,[t]){const Vs={};t&2&&(Vs.$$scope={dirty:t,ctx:e}),I.$set(Vs)},i(e){Bl||(J(w.$$.fragment,e),J(b.$$.fragment,e),J(I.$$.fragment,e),J(V.$$.fragment,e),J(W.$$.fragment,e),J(X.$$.fragment,e),J(Y.$$.fragment,e),J(L.$$.fragment,e),J(z.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(ne.$$.fragment,e),J(Me.$$.fragment,e),J(Ue.$$.fragment,e),J(ce.$$.fragment,e),J(me.$$.fragment,e),J(je.$$.fragment,e),J(Ie.$$.fragment,e),J(ve.$$.fragment,e),J(Ae.$$.fragment,e),J(Ge.$$.fragment,e),J(He.$$.fragment,e),J(xe.$$.fragment,e),J(Se.$$.fragment,e),J(_e.$$.fragment,e),J(Le.$$.fragment,e),J(Pe.$$.fragment,e),Bl=!0)},o(e){p(w.$$.fragment,e),p(b.$$.fragment,e),p(I.$$.fragment,e),p(V.$$.fragment,e),p(W.$$.fragment,e),p(X.$$.fragment,e),p(Y.$$.fragment,e),p(L.$$.fragment,e),p(z.$$.fragment,e),p(ee.$$.fragment,e),p(le.$$.fragment,e),p(ne.$$.fragment,e),p(Me.$$.fragment,e),p(Ue.$$.fragment,e),p(ce.$$.fragment,e),p(me.$$.fragment,e),p(je.$$.fragment,e),p(Ie.$$.fragment,e),p(ve.$$.fragment,e),p(Ae.$$.fragment,e),p(Ge.$$.fragment,e),p(He.$$.fragment,e),p(xe.$$.fragment,e),p(Se.$$.fragment,e),p(_e.$$.fragment,e),p(Le.$$.fragment,e),p(Pe.$$.fragment,e),Bl=!1},d(e){e&&(l(h),l(j),l(C),l(f),l(et),l(B),l(tt),l(k),l(lt),l(v),l(st),l(nt),l(at),l(A),l(it),l(Z),l(ot),l(G),l(Mt),l(N),l(rt),l(yt),l(E),l(Ut),l(F),l(Jt),l(H),l(pt),l($),l(Tt),l(R),l(wt),l(x),l(ct),l(ut),l(S),l(ht),l(Q),l(dt),l(_),l(mt),l(gt),l(q),l(Ct),l(jt),l(ft),l(P),l(It),l(D),l(bt),l(K),l(Bt),l(O),l(kt),l(vt),l(te),l(Vt),l(At),l(se),l(Zt),l(Gt),l(ae),l(Nt),l(ie),l(Wt),l(oe),l(Et),l(Ft),l(re),l(Ht),l(ye),l($t),l(Rt),l(Je),l(xt),l(pe),l(Xt),l(Te),l(St),l(we),l(Qt),l(_t),l(ue),l(Yt),l(he),l(qt),l(de),l(Lt),l(zt),l(ge),l(Pt),l(Ce),l(Dt),l(Kt),l(fe),l(Ot),l(el),l(be),l(tl),l(Be),l(ll),l(g),l(sl),l(ke),l(nl),l(al),l(Ve),l(il),l(ol),l(Ze),l(Ml),l(rl),l(Ne),l(yl),l(We),l(Ul),l(Ee),l(Jl),l(Fe),l(pl),l(Tl),l($e),l(wl),l(Re),l(cl),l(ul),l(Xe),l(hl),l(dl),l(Qe),l(ml),l(gl),l(Ye),l(Cl),l(qe),l(jl),l(fl),l(ze),l(Il),l(bl),l(De)),l(u),T(w,e),T(b,e),T(I,e),T(V,e),T(W,e),T(X,e),T(Y,e),T(L,e),T(z,e),T(ee,e),T(le,e),T(ne,e),T(Me,e),T(Ue,e),T(ce,e),T(me,e),T(je,e),T(Ie,e),T(ve,e),T(Ae,e),T(Ge,e),T(He,e),T(xe,e),T(Se,e),T(_e,e),T(Le,e),T(Pe,e)}}}const _s='{"title":"Building Agents That Use Code","local":"building-agents-that-use-code","sections":[{"title":"Why Code Agents?","local":"why-code-agents","sections":[],"depth":2},{"title":"How Does a Code Agent Work?","local":"how-does-a-code-agent-work","sections":[],"depth":2},{"title":"Let’s See Some Examples","local":"lets-see-some-examples","sections":[{"title":"Selecting a Playlist for the Party Using smolagents","local":"selecting-a-playlist-for-the-party-using-smolagents","sections":[],"depth":3},{"title":"Using a Custom Tool to Prepare the Menu","local":"using-a-custom-tool-to-prepare-the-menu","sections":[],"depth":3},{"title":"Using Python Imports Inside the Agent","local":"using-python-imports-inside-the-agent","sections":[],"depth":3},{"title":"Sharing Our Custom Party Preparator Agent to the Hub","local":"sharing-our-custom-party-preparator-agent-to-the-hub","sections":[],"depth":3}],"depth":2},{"title":"Now, it’s your turn: build your very own agent and share it with the community using the knowledge we’ve just learned! 🕵️‍♂️💡","local":"now-its-your-turn-build-your-very-own-agent-and-share-it-with-the-community-using-the-knowledge-weve-just-learned-","sections":[{"title":"Inspecting Our Party Preparator Agent with OpenTelemetry and Langfuse 📡","local":"inspecting-our-party-preparator-agent-with-opentelemetry-and-langfuse-","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Ys(Oe){return Ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends Es{constructor(u){super(),Fs(this,u,Ys,Qs,Gs,{})}}export{en as component};
