import{s as At,n as St,o as jt}from"../chunks/scheduler.a2b4ca8e.js";import{S as Kt,i as Bt,g as n,s as l,r as m,A as Rt,h as i,f as t,c as a,j as f,u,x as d,k as z,y as r,a as s,v as c,d as _,t as h,w as g}from"../chunks/index.d2f673cc.js";import{D as y}from"../chunks/Docstring.8be9aff1.js";import{H as ht}from"../chunks/Heading.675d4c1e.js";function Xt(gt){let w,Pe,xe,Te,I,we,q,bt="The <code>optimum.neuron.distributed</code> module provides a set of tools to perform distributed training and inference.",Ce,O,ke,U,ft="The main task in distributed training / inference is being able to shard things such as the model weights, the gradient, and/or the optimizer state. We built <code>Parallelizer</code> classes to handle the sharding.",Me,N,Le,V,zt="The <code>Parallelizer</code> class is the base abstract class being derived for every model supporting model parallelism. It provides methods to parallelize the model and save and load sharded checkpoints.",De,p,F,Be,le,vt="Base abstract class that handles model parallelism.",Re,k,W,Xe,ae,$t=`Parallelizes the model by transforming regular layer into their parallel counterparts.
Each concrete class must implement it.`,Ge,P,A,Je,ne,xt=`Parallelizes the model by transforming regular layer into their parallel counterparts using
<code>cls._parallelize()</code>.`,Qe,ie,yt=`It also makes sure that each parameter has loaded its weights or has been initialized if there is no pre-trained
weights associated to it.`,Ye,x,S,Ze,oe,Pt="Creates an optimizer ready for a parallelized model from an existing optimizer.",et,se,Tt="There are two cases:",tt,de,wt=`<li>The optimizer has been created via a lazy constructor from
<code>optimum.neuron.distributed.utils.make_optimizer_constructor_lazy</code>, it which case the exactly intended optimizer is
created for tensor parallelism.</li> <li>The optimizer was created with a regular constructor. In this case the optimizer for tensor parallelism
is created as close as possible to what was intended but that is not guaranteed.</li>`,rt,pe,j,lt,me,K,Ee,B,Ct="### Selecting Model-Specific Parallelizer Classes[[optimum.neuron.distributed.ParallelizersManager]]",He,R,kt="Each model that supports parallelization in <code>optimum-neuron</code> has its own derived <code>Parallelizer</code> class. The factory class <code>ParallelizersManager</code> allows you to retrieve such model-specific <code>Parallelizer</code>s easily.",Ie,v,X,at,M,G,nt,ue,Mt="Provides the list of supported model types for parallelization.",it,T,J,ot,ce,Lt="Returns a tuple of 3 booleans where:",st,_e,Dt="<li>The first element indicates if tensor parallelism can be used for this model,</li> <li>The second element indicates if sequence parallelism can be used on top of tensor parallelism for this model,</li> <li>The third element indicates if pipeline parallelism can be used for this model.</li>",dt,L,Q,pt,he,Et="Returns the parallelizer class associated to the model.",qe,Y,Ht="## Utils",Oe,Z,It="### Lazy Loading[[optimum.neuron.distributed.lazy_load_for_parallelism]]",Ue,ee,qt="Distributed training / inference is usually needed when the model is too big to fit in one device. Tools that allow for lazy loading of model weights and optimizer states are thus needed to avoid going out-of-memory before parallelization.",Ne,$,te,mt,ge,Ot="Context manager that makes the loading of a model lazy for model parallelism:",ut,be,Ut=`<li>Every <code>torch.nn.Linear</code> is put on the <code>torch.device(&quot;meta&quot;)</code> device, meaning that it takes no memory to
instantiate.</li> <li>Every <code>torch.nn.Embedding</code> is also put on the <code>torch.device(&quot;meta&quot;)</code> device.</li> <li>No state dict is actually loaded, instead a weight map is created and attached to the model. For more
information, read the <code>optimum.neuron.distributed.utils.from_pretrained_for_mp</code> docstring.</li>`,ct,fe,Nt="If both <code>tensor_parallel_size</code> and <code>pipeline_parallel_size</code> are set to 1, no lazy loading is performed.",Ve,C,re,_t,ze,Vt=`Transforms an optimizer constructor (optimizer class) to make it lazy by not initializing the parameters.
This makes the optimizer lightweight and usable to create a “real” optimizer once the model has been
parallelized.`,Fe,ye,We;return I=new ht({props:{title:"Optimum Neuron Distributed",local:"optimum-neuron-distributed",headingTag:"h1"}}),O=new ht({props:{title:"Parallelization",local:"parallelization",headingTag:"h2"}}),N=new ht({props:{title:"Base Parallelizer",local:"optimum.neuron.distributed.Parallelizer",headingTag:"h3"}}),F=new y({props:{name:"class optimum.neuron.distributed.Parallelizer",anchor:"optimum.neuron.distributed.Parallelizer",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/base.py#L136"}}),W=new y({props:{name:"_parallelize",anchor:"optimum.neuron.distributed.Parallelizer._parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"should_parallelize_layer_predicate_func",val:": Optional = None"},{name:"**parallel_layer_specific_kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.should_parallelize_layer_predicate_func",description:`<strong>should_parallelize_layer_predicate_func</strong> (Optional[Callable[[torch.nn.Module], bool]], defaults to <code>None</code>) &#x2014;
A function that takes a layer as input and returns a boolean specifying if the input layer should be
parallelized. This is useful to skip unnecessary parallelization, for pipeline parallelism for instance.`,name:"should_parallelize_layer_predicate_func"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.*parallel_layer_specific_kwargs",description:`*<strong>*parallel_layer_specific_kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Keyword arguments specific to some parallel layers, they will be ignored by the other parallel layers.`,name:"*parallel_layer_specific_kwargs"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/base.py#L239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),A=new y({props:{name:"parallelize",anchor:"optimum.neuron.distributed.Parallelizer.parallelize",parameters:[{name:"model",val:": Union"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"kv_size_multiplier",val:": Optional = None"},{name:"pipeline_parallel_input_names",val:": Union = None"},{name:"pipeline_parallel_num_microbatches",val:": int = 1"},{name:"pipeline_parallel_use_zero1_optimizer",val:": bool = False"},{name:"pipeline_parallel_gradient_checkpointing_enabled",val:": bool = False"},{name:"checkpoint_dir",val:": Union = None"},{name:"num_local_ranks_per_step",val:": int = 8"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.model",description:`<strong>model</strong> (<code>Union[PreTrainedModel, NeuronPeftModel]</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.kv_size_multiplier",description:`<strong>kv_size_multiplier</strong> (<code>Optional[int], defaults to </code>None\`) &#x2014;
The number of times to replicate the KV heads when the TP size is bigger than the number of KV heads.
If left unspecified, the smallest multiplier that makes the number of KV heads divisible by the TP size
will be used.`,name:"kv_size_multiplier"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_num_microbatches",description:`<strong>pipeline_parallel_num_microbatches</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of microbatches used for pipeline execution.`,name:"pipeline_parallel_num_microbatches"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_use_zero1_optimizer",description:`<strong>pipeline_parallel_use_zero1_optimizer</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
When zero-1 optimizer is used, set this to True, so the PP model will understand that zero-1 optimizer
will handle data parallel gradient averaging.`,name:"pipeline_parallel_use_zero1_optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.pipeline_parallel_gradient_checkpointing_enabled",description:`<strong>pipeline_parallel_gradient_checkpointing_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not gradient checkpointing should be enabled when doing pipeline parallelism.`,name:"pipeline_parallel_gradient_checkpointing_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.checkpoint_dir",description:`<strong>checkpoint_dir</strong> (<code>Optional[Union[str, Path]]</code>) &#x2014;
Path to a sharded checkpoint. If specified, the checkpoint weights will be loaded to the parallelized
model.`,name:"checkpoint_dir"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.num_local_ranks_per_step",description:`<strong>num_local_ranks_per_step</strong> (<code>int</code>, defaults to <code>8</code>) &#x2014;
Corresponds to the number of local ranks that can initialize and load the model weights at the same
time. If the value is inferior to 0, the maximum number of ranks will be used.`,name:"num_local_ranks_per_step"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/base.py#L500",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),S=new y({props:{name:"optimizer_for_mp",anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp",parameters:[{name:"optimizer",val:": torch.optim.Optimizer"},{name:"orig_param_to_parallel_param_on_xla",val:": Mapping"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014;
The original optimizer.`,name:"optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_mp.orig_param_to_parallel_param_on_xla",description:`<strong>orig_param_to_parallel_param_on_xla</strong> (<code>Mapping[int, torch.nn.Parameter]</code>) &#x2014;
A mapping (e.g. dict-like) that maps the id of a parameter in <code>optimizer</code> to the id of its
parallelized counterpart on an XLA device.`,name:"orig_param_to_parallel_param_on_xla"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/base.py#L912",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor parallelism ready optimizer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.optim.Optimizer</code></p>
`}}),j=new y({props:{name:"save_model_sharded_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.save_model_sharded_checkpoint",parameters:[{name:"model",val:": Union"},{name:"output_dir",val:": Union"},{name:"optimizer",val:": Optional = None"},{name:"use_xser",val:": bool = True"},{name:"async_save",val:": bool = False"},{name:"num_local_ranks_per_step",val:": int = 8"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/base.py#L952"}}),K=new y({props:{name:"load_model_sharded_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.load_model_sharded_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"load_dir",val:": Union"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/base.py#L1033"}}),X=new y({props:{name:"class optimum.neuron.distributed.ParallelizersManager",anchor:"optimum.neuron.distributed.ParallelizersManager",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/parallelizers_manager.py#L53"}}),G=new y({props:{name:"get_supported_model_types",anchor:"optimum.neuron.distributed.ParallelizersManager.get_supported_model_types",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/parallelizers_manager.py#L66"}}),J=new y({props:{name:"is_model_supported",anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/parallelizers_manager.py#L89"}}),Q=new y({props:{name:"parallelizer_for_model",anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/parallelizers_manager.py#L114"}}),te=new y({props:{name:"optimum.neuron.distributed.lazy_load_for_parallelism",anchor:"optimum.neuron.distributed.lazy_load_for_parallelism",parameters:[{name:"tensor_parallel_size",val:": int = 1"},{name:"pipeline_parallel_size",val:": int = 1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.tensor_parallel_size",description:`<strong>tensor_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The tensor parallel size considered.`,name:"tensor_parallel_size"},{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.pipeline_parallel_size",description:`<strong>pipeline_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The pipeline parallel size considered.`,name:"pipeline_parallel_size"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/utils.py#L1549"}}),re=new y({props:{name:"optimum.neuron.distributed.make_optimizer_constructor_lazy",anchor:"optimum.neuron.distributed.make_optimizer_constructor_lazy",parameters:[{name:"optimizer_cls",val:": Type"}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_633/optimum/neuron/distributed/utils.py#L1595"}}),{c(){w=n("meta"),Pe=l(),xe=n("p"),Te=l(),m(I.$$.fragment),we=l(),q=n("p"),q.innerHTML=bt,Ce=l(),m(O.$$.fragment),ke=l(),U=n("p"),U.innerHTML=ft,Me=l(),m(N.$$.fragment),Le=l(),V=n("p"),V.innerHTML=zt,De=l(),p=n("div"),m(F.$$.fragment),Be=l(),le=n("p"),le.textContent=vt,Re=l(),k=n("div"),m(W.$$.fragment),Xe=l(),ae=n("p"),ae.textContent=$t,Ge=l(),P=n("div"),m(A.$$.fragment),Je=l(),ne=n("p"),ne.innerHTML=xt,Qe=l(),ie=n("p"),ie.textContent=yt,Ye=l(),x=n("div"),m(S.$$.fragment),Ze=l(),oe=n("p"),oe.textContent=Pt,et=l(),se=n("p"),se.textContent=Tt,tt=l(),de=n("ol"),de.innerHTML=wt,rt=l(),pe=n("div"),m(j.$$.fragment),lt=l(),me=n("div"),m(K.$$.fragment),Ee=l(),B=n("p"),B.textContent=Ct,He=l(),R=n("p"),R.innerHTML=kt,Ie=l(),v=n("div"),m(X.$$.fragment),at=l(),M=n("div"),m(G.$$.fragment),nt=l(),ue=n("p"),ue.textContent=Mt,it=l(),T=n("div"),m(J.$$.fragment),ot=l(),ce=n("p"),ce.textContent=Lt,st=l(),_e=n("ul"),_e.innerHTML=Dt,dt=l(),L=n("div"),m(Q.$$.fragment),pt=l(),he=n("p"),he.textContent=Et,qe=l(),Y=n("p"),Y.textContent=Ht,Oe=l(),Z=n("p"),Z.textContent=It,Ue=l(),ee=n("p"),ee.textContent=qt,Ne=l(),$=n("div"),m(te.$$.fragment),mt=l(),ge=n("p"),ge.textContent=Ot,ut=l(),be=n("ul"),be.innerHTML=Ut,ct=l(),fe=n("p"),fe.innerHTML=Nt,Ve=l(),C=n("div"),m(re.$$.fragment),_t=l(),ze=n("p"),ze.textContent=Vt,Fe=l(),ye=n("p"),this.h()},l(e){const o=Rt("svelte-u9bgzb",document.head);w=i(o,"META",{name:!0,content:!0}),o.forEach(t),Pe=a(e),xe=i(e,"P",{}),f(xe).forEach(t),Te=a(e),u(I.$$.fragment,e),we=a(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-it0u39"&&(q.innerHTML=bt),Ce=a(e),u(O.$$.fragment,e),ke=a(e),U=i(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-5ss4zj"&&(U.innerHTML=ft),Me=a(e),u(N.$$.fragment,e),Le=a(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1bsvcro"&&(V.innerHTML=zt),De=a(e),p=i(e,"DIV",{class:!0});var b=f(p);u(F.$$.fragment,b),Be=a(b),le=i(b,"P",{"data-svelte-h":!0}),d(le)!=="svelte-h4ipsc"&&(le.textContent=vt),Re=a(b),k=i(b,"DIV",{class:!0});var Ae=f(k);u(W.$$.fragment,Ae),Xe=a(Ae),ae=i(Ae,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1e0iews"&&(ae.textContent=$t),Ae.forEach(t),Ge=a(b),P=i(b,"DIV",{class:!0});var ve=f(P);u(A.$$.fragment,ve),Je=a(ve),ne=i(ve,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1ytdrar"&&(ne.innerHTML=xt),Qe=a(ve),ie=i(ve,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-3oskg6"&&(ie.textContent=yt),ve.forEach(t),Ye=a(b),x=i(b,"DIV",{class:!0});var D=f(x);u(S.$$.fragment,D),Ze=a(D),oe=i(D,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-gytsrb"&&(oe.textContent=Pt),et=a(D),se=i(D,"P",{"data-svelte-h":!0}),d(se)!=="svelte-k6ubrx"&&(se.textContent=Tt),tt=a(D),de=i(D,"OL",{"data-svelte-h":!0}),d(de)!=="svelte-ogaf4b"&&(de.innerHTML=wt),D.forEach(t),rt=a(b),pe=i(b,"DIV",{class:!0});var Ft=f(pe);u(j.$$.fragment,Ft),Ft.forEach(t),lt=a(b),me=i(b,"DIV",{class:!0});var Wt=f(me);u(K.$$.fragment,Wt),Wt.forEach(t),b.forEach(t),Ee=a(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-cb80gg"&&(B.textContent=Ct),He=a(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1x1mrd0"&&(R.innerHTML=kt),Ie=a(e),v=i(e,"DIV",{class:!0});var E=f(v);u(X.$$.fragment,E),at=a(E),M=i(E,"DIV",{class:!0});var Se=f(M);u(G.$$.fragment,Se),nt=a(Se),ue=i(Se,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-esrxt2"&&(ue.textContent=Mt),Se.forEach(t),it=a(E),T=i(E,"DIV",{class:!0});var $e=f(T);u(J.$$.fragment,$e),ot=a($e),ce=i($e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1pefsnq"&&(ce.textContent=Lt),st=a($e),_e=i($e,"UL",{"data-svelte-h":!0}),d(_e)!=="svelte-1dpu6ok"&&(_e.innerHTML=Dt),$e.forEach(t),dt=a(E),L=i(E,"DIV",{class:!0});var je=f(L);u(Q.$$.fragment,je),pt=a(je),he=i(je,"P",{"data-svelte-h":!0}),d(he)!=="svelte-3qe9b8"&&(he.textContent=Et),je.forEach(t),E.forEach(t),qe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-jvm0tx"&&(Y.textContent=Ht),Oe=a(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1lfo7ps"&&(Z.textContent=It),Ue=a(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-4ddlue"&&(ee.textContent=qt),Ne=a(e),$=i(e,"DIV",{class:!0});var H=f($);u(te.$$.fragment,H),mt=a(H),ge=i(H,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-bh7x4"&&(ge.textContent=Ot),ut=a(H),be=i(H,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-1j7gypf"&&(be.innerHTML=Ut),ct=a(H),fe=i(H,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-oha5tr"&&(fe.innerHTML=Nt),H.forEach(t),Ve=a(e),C=i(e,"DIV",{class:!0});var Ke=f(C);u(re.$$.fragment,Ke),_t=a(Ke),ze=i(Ke,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1agud9l"&&(ze.textContent=Vt),Ke.forEach(t),Fe=a(e),ye=i(e,"P",{}),f(ye).forEach(t),this.h()},h(){z(w,"name","hf:doc:metadata"),z(w,"content",Gt),z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){r(document.head,w),s(e,Pe,o),s(e,xe,o),s(e,Te,o),c(I,e,o),s(e,we,o),s(e,q,o),s(e,Ce,o),c(O,e,o),s(e,ke,o),s(e,U,o),s(e,Me,o),c(N,e,o),s(e,Le,o),s(e,V,o),s(e,De,o),s(e,p,o),c(F,p,null),r(p,Be),r(p,le),r(p,Re),r(p,k),c(W,k,null),r(k,Xe),r(k,ae),r(p,Ge),r(p,P),c(A,P,null),r(P,Je),r(P,ne),r(P,Qe),r(P,ie),r(p,Ye),r(p,x),c(S,x,null),r(x,Ze),r(x,oe),r(x,et),r(x,se),r(x,tt),r(x,de),r(p,rt),r(p,pe),c(j,pe,null),r(p,lt),r(p,me),c(K,me,null),s(e,Ee,o),s(e,B,o),s(e,He,o),s(e,R,o),s(e,Ie,o),s(e,v,o),c(X,v,null),r(v,at),r(v,M),c(G,M,null),r(M,nt),r(M,ue),r(v,it),r(v,T),c(J,T,null),r(T,ot),r(T,ce),r(T,st),r(T,_e),r(v,dt),r(v,L),c(Q,L,null),r(L,pt),r(L,he),s(e,qe,o),s(e,Y,o),s(e,Oe,o),s(e,Z,o),s(e,Ue,o),s(e,ee,o),s(e,Ne,o),s(e,$,o),c(te,$,null),r($,mt),r($,ge),r($,ut),r($,be),r($,ct),r($,fe),s(e,Ve,o),s(e,C,o),c(re,C,null),r(C,_t),r(C,ze),s(e,Fe,o),s(e,ye,o),We=!0},p:St,i(e){We||(_(I.$$.fragment,e),_(O.$$.fragment,e),_(N.$$.fragment,e),_(F.$$.fragment,e),_(W.$$.fragment,e),_(A.$$.fragment,e),_(S.$$.fragment,e),_(j.$$.fragment,e),_(K.$$.fragment,e),_(X.$$.fragment,e),_(G.$$.fragment,e),_(J.$$.fragment,e),_(Q.$$.fragment,e),_(te.$$.fragment,e),_(re.$$.fragment,e),We=!0)},o(e){h(I.$$.fragment,e),h(O.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(S.$$.fragment,e),h(j.$$.fragment,e),h(K.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(Q.$$.fragment,e),h(te.$$.fragment,e),h(re.$$.fragment,e),We=!1},d(e){e&&(t(Pe),t(xe),t(Te),t(we),t(q),t(Ce),t(ke),t(U),t(Me),t(Le),t(V),t(De),t(p),t(Ee),t(B),t(He),t(R),t(Ie),t(v),t(qe),t(Y),t(Oe),t(Z),t(Ue),t(ee),t(Ne),t($),t(Ve),t(C),t(Fe),t(ye)),t(w),g(I,e),g(O,e),g(N,e),g(F),g(W),g(A),g(S),g(j),g(K),g(X),g(G),g(J),g(Q),g(te),g(re)}}}const Gt='{"title":"Optimum Neuron Distributed","local":"optimum-neuron-distributed","sections":[{"title":"Parallelization","local":"parallelization","sections":[{"title":"Base Parallelizer","local":"optimum.neuron.distributed.Parallelizer","sections":[],"depth":3}],"depth":2}],"depth":1}';function Jt(gt){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tr extends Kt{constructor(w){super(),Bt(this,w,Jt,Xt,At,{})}}export{tr as component};
