import{s as Tl,n as wl,o as gl}from"../chunks/scheduler.8c3d61f6.js";import{S as hl,i as Ul,g as n,s,r as c,A as bl,h as m,f as t,c as i,j as ul,u as o,x as p,k as u,y as Gl,a,v as M,d as J,t as d,w as r}from"../chunks/index.da70eac4.js";import{C as f}from"../chunks/CodeBlock.00a903b3.js";import{H as T,E as jl}from"../chunks/EditOnGithub.1e64e623.js";function fl(qe){let y,ne,se,me,Z,pe,I,De="OmniGen is an image generation model. Unlike existing text-to-image models, OmniGen is designed to handle a variety of tasks (e.g., text-to-image, image editing, controllable generation) within a single model. It has the following features:",ce,W,Ae="<li>Minimalist model architecture, consisting of only a VAE and a transformer module, for joint modeling of text and images.</li> <li>Support for multimodal inputs. It can process any text-image mixed data as instructions for image generation, rather than relying solely on text.</li>",oe,B,Oe=`For more information, please refer to the <a href="https://arxiv.org/pdf/2409.11340" rel="nofollow">paper</a>.
This guide will walk you through using OmniGen for various tasks and use cases.`,Me,V,Je,_,Pe='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/pr_10148/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method.',de,R,re,X,ye,v,Ke=`For text-to-image, pass a text prompt. By default, OmniGen generates a 1024x1024 image.
You can try setting the <code>height</code> and <code>width</code> parameters to generate images with different size.`,ue,Y,Te,w,el='<img src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/t2i_woman_with_book.png" alt="generated image"/>',we,k,ge,C,ll=`OmniGen supports for multimodal inputs.
When the input includes an image, you need to add a placeholder <code>&lt;img&gt;&lt;|image_1|&gt;&lt;/img&gt;</code> in the text prompt to represent the image.
It is recommended to enable ‘use_input_image_size_as_output’ to keep the edited image the same size as the original image.`,he,N,Ue,g,tl='<div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/t2i_woman_with_book.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/edit.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">edited image</figcaption></div>',be,x,al="OmniGen has some interesting features, such as the ability to infer user needs, as shown in the example below.",Ge,S,je,h,sl='<img src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/reasoning.png" alt="generated image"/>',fe,H,Ze,z,il=`OmniGen can handle several classic computer vision tasks.
As shown below, OmniGen can detect human skeletons in input images, which can be used as control conditions to generate new images.`,Ie,E,We,U,nl='<div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/edit.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/skeletal.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">detected skeleton</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/skeletal2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">skeleton to image</figcaption></div>',Be,Q,ml="OmniGen can also directly use relevant information from input images to generate new images.",Ve,F,_e,b,pl='<div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/same_pose.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Re,$,Xe,L,cl=`OmniGen can generate multiple images based on the people and objects in the input image and supports inputting multiple images simultaneously.
Additionally, OmniGen can extract desired objects from an image containing multiple objects based on instructions.`,ve,q,Ye,G,ol='<div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">input_image_1</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/4.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">input_image_2</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/id2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',ke,D,Ce,j,Ml='<div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/emma.jpeg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">person image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/dress.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">clothe image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/tryon.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Ne,A,xe,O,Jl=`For text-to-image task, OmniGen requires minimal memory and time costs (9G memory and 31s for a 1024*1024 image on A800 GPU).
However, when using input images, the computational cost increases.`,Se,P,dl="Here are some guidelines to help you reduce computational costs when input multiple images. The experiments are conducted on A800 GPU and input two images to OmniGen.",He,K,ze,ee,rl=`<li><p><code>use_kv_cache=True</code>:<br/> <code>use_kv_cache</code> will store key and value states of the input conditions to compute attention without redundant computations.
The default value is True, and OmniGen will offload the kv cache to cpu default.</p> <ul><li><code>use_kv_cache=False</code>: the inference time is 3m21s.</li> <li><code>use_kv_cache=True</code>: the inference time is 1m30s.</li></ul></li> <li><p><code>max_input_image_size</code>:<br/>
the maximum size of input image, which will be used to crop the input image</p> <ul><li><code>max_input_image_size=1024</code>: the inference time is 1m30s.</li> <li><code>max_input_image_size=512</code>: the inference time is 58s.</li></ul></li>`,Ee,le,Qe,te,yl="<li><p><code>pipe.enable_model_cpu_offload()</code>:</p> <ul><li>Without enabling cpu offloading, memory usage is <code>31 GB</code></li> <li>With enabling cpu offloading, memory usage is <code>28 GB</code></li></ul></li> <li><p><code>offload_transformer_block=True</code>:</p> <ul><li>offload transformer block to reduce memory usage</li> <li>When enabled, memory usage is under <code>25 GB</code></li></ul></li> <li><p><code>pipe.enable_sequential_cpu_offload()</code>:</p> <ul><li>significantly reduce memory usage at the cost of slow inference</li> <li>When enabled, memory usage is under <code>11 GB</code></li></ul></li>",Fe,ae,$e,ie,Le;return Z=new T({props:{title:"OmniGen",local:"omnigen",headingTag:"h1"}}),V=new T({props:{title:"Load model checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),R=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwT21uaUdlblBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyME9tbmlHZW5QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyU2hpdGFvJTJGT21uaUdlbi12MS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> OmniGenPipeline
pipe = OmniGenPipeline.from_pretrained(
    <span class="hljs-string">&quot;Shitao/OmniGen-v1-diffusers&quot;</span>,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),X=new T({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),Y=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwT21uaUdlblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME9tbmlHZW5QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyU2hpdGFvJTJGT21uaUdlbi12MS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJSZWFsaXN0aWMlMjBwaG90by4lMjBBJTIweW91bmclMjB3b21hbiUyMHNpdHMlMjBvbiUyMGElMjBzb2ZhJTJDJTIwaG9sZGluZyUyMGElMjBib29rJTIwYW5kJTIwZmFjaW5nJTIwdGhlJTIwY2FtZXJhLiUyMFNoZSUyMHdlYXJzJTIwZGVsaWNhdGUlMjBzaWx2ZXIlMjBob29wJTIwZWFycmluZ3MlMjBhZG9ybmVkJTIwd2l0aCUyMHRpbnklMkMlMjBzcGFya2xpbmclMjBkaWFtb25kcyUyMHRoYXQlMjBjYXRjaCUyMHRoZSUyMGxpZ2h0JTJDJTIwd2l0aCUyMGhlciUyMGxvbmclMjBjaGVzdG51dCUyMGhhaXIlMjBjYXNjYWRpbmclMjBvdmVyJTIwaGVyJTIwc2hvdWxkZXJzLiUyMEhlciUyMGV5ZXMlMjBhcmUlMjBmb2N1c2VkJTIwYW5kJTIwZ2VudGxlJTJDJTIwZnJhbWVkJTIwYnklMjBsb25nJTJDJTIwZGFyayUyMGxhc2hlcy4lMjBTaGUlMjBpcyUyMGRyZXNzZWQlMjBpbiUyMGElMjBjb3p5JTIwY3JlYW0lMjBzd2VhdGVyJTJDJTIwd2hpY2glMjBjb21wbGVtZW50cyUyMGhlciUyMHdhcm0lMkMlMjBpbnZpdGluZyUyMHNtaWxlLiUyMEJlaGluZCUyMGhlciUyQyUyMHRoZXJlJTIwaXMlMjBhJTIwdGFibGUlMjB3aXRoJTIwYSUyMGN1cCUyMG9mJTIwd2F0ZXIlMjBpbiUyMGElMjBzbGVlayUyQyUyMG1pbmltYWxpc3QlMjBibHVlJTIwbXVnLiUyMFRoZSUyMGJhY2tncm91bmQlMjBpcyUyMGElMjBzZXJlbmUlMjBpbmRvb3IlMjBzZXR0aW5nJTIwd2l0aCUyMHNvZnQlMjBuYXR1cmFsJTIwbGlnaHQlMjBmaWx0ZXJpbmclMjB0aHJvdWdoJTIwYSUyMHdpbmRvdyUyQyUyMGFkb3JuZWQlMjB3aXRoJTIwdGFzdGVmdWwlMjBhcnQlMjBhbmQlMjBmbG93ZXJzJTJDJTIwY3JlYXRpbmclMjBhJTIwY296eSUyMGFuZCUyMHBlYWNlZnVsJTIwYW1iaWFuY2UuJTIwNEslMkMlMjBIRC4lMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMyUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDExMSklMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> OmniGenPipeline

pipe = OmniGenPipeline.from_pretrained(
    <span class="hljs-string">&quot;Shitao/OmniGen-v1-diffusers&quot;</span>,
    torch_dtype=torch.bfloat16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Realistic photo. A young woman sits on a sofa, holding a book and facing the camera. She wears delicate silver hoop earrings adorned with tiny, sparkling diamonds that catch the light, with her long chestnut hair cascading over her shoulders. Her eyes are focused and gentle, framed by long, dark lashes. She is dressed in a cozy cream sweater, which complements her warm, inviting smile. Behind her, there is a table with a cup of water in a sleek, minimalist blue mug. The background is a serene indoor setting with soft natural light filtering through a window, adorned with tasteful art and flowers, creating a cozy and peaceful ambiance. 4K, HD.&quot;</span>
image = pipe(
    prompt=prompt,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">3</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">111</span>),
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),k=new T({props:{title:"Image edit",local:"image-edit",headingTag:"h2"}}),N=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwT21uaUdlblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMjAlMEElMEFwaXBlJTIwJTNEJTIwT21uaUdlblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTaGl0YW8lMkZPbW5pR2VuLXYxLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUzRCUyMiUzQ2ltZyUzRSUzQyU3Q2ltYWdlXzElN0MlM0UlM0MlMkZpbWclM0UlMjBSZW1vdmUlMjB0aGUlMjB3b21hbidzJTIwZWFycmluZ3MuJTIwUmVwbGFjZSUyMHRoZSUyMG11ZyUyMHdpdGglMjBhJTIwY2xlYXIlMjBnbGFzcyUyMGZpbGxlZCUyMHdpdGglMjBzcGFya2xpbmclMjBpY2VkJTIwY29sYS4lMjIlMEFpbnB1dF9pbWFnZXMlM0QlNUJsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRlZlY3RvclNwYWNlTGFiJTJGT21uaUdlbiUyRm1haW4lMkZpbWdzJTJGZG9jc19pbWclMkZ0Mmlfd29tYW5fd2l0aF9ib29rLnBuZyUyMiklNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwJTBBJTIwJTIwJTIwJTIwaW5wdXRfaW1hZ2VzJTNEaW5wdXRfaW1hZ2VzJTJDJTIwJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwJTBBJTIwJTIwJTIwJTIwaW1nX2d1aWRhbmNlX3NjYWxlJTNEMS42JTJDJTBBJTIwJTIwJTIwJTIwdXNlX2lucHV0X2ltYWdlX3NpemVfYXNfb3V0cHV0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDIyMikpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> OmniGenPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image 

pipe = OmniGenPipeline.from_pretrained(
    <span class="hljs-string">&quot;Shitao/OmniGen-v1-diffusers&quot;</span>,
    torch_dtype=torch.bfloat16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt=<span class="hljs-string">&quot;&lt;img&gt;&lt;|image_1|&gt;&lt;/img&gt; Remove the woman&#x27;s earrings. Replace the mug with a clear glass filled with sparkling iced cola.&quot;</span>
input_images=[load_image(<span class="hljs-string">&quot;https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/t2i_woman_with_book.png&quot;</span>)]
image = pipe(
    prompt=prompt, 
    input_images=input_images, 
    guidance_scale=<span class="hljs-number">2</span>, 
    img_guidance_scale=<span class="hljs-number">1.6</span>,
    use_input_image_size_as_output=<span class="hljs-literal">True</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">222</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),S=new f({props:{code:"cHJvbXB0JTNEJTIySWYlMjB0aGUlMjB3b21hbiUyMGlzJTIwdGhpcnN0eSUyQyUyMHdoYXQlMjBzaG91bGQlMjBzaGUlMjB0YWtlJTNGJTIwRmluZCUyMGl0JTIwaW4lMjB0aGUlMjBpbWFnZSUyMGFuZCUyMGhpZ2hsaWdodCUyMGl0JTIwaW4lMjBibHVlLiUyMCUzQ2ltZyUzRSUzQyU3Q2ltYWdlXzElN0MlM0UlM0MlMkZpbWclM0UlMjIlMEFpbnB1dF9pbWFnZXMlM0QlNUJsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRlZlY3RvclNwYWNlTGFiJTJGT21uaUdlbiUyRm1haW4lMkZpbWdzJTJGZG9jc19pbWclMkZlZGl0LnBuZyUyMiklNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwJTBBJTIwJTIwJTIwJTIwaW5wdXRfaW1hZ2VzJTNEaW5wdXRfaW1hZ2VzJTJDJTIwJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwJTBBJTIwJTIwJTIwJTIwaW1nX2d1aWRhbmNlX3NjYWxlJTNEMS42JTJDJTBBJTIwJTIwJTIwJTIwdXNlX2lucHV0X2ltYWdlX3NpemVfYXNfb3V0cHV0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt=<span class="hljs-string">&quot;If the woman is thirsty, what should she take? Find it in the image and highlight it in blue. &lt;img&gt;&lt;|image_1|&gt;&lt;/img&gt;&quot;</span>
input_images=[load_image(<span class="hljs-string">&quot;https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/edit.png&quot;</span>)]
image = pipe(
    prompt=prompt, 
    input_images=input_images, 
    guidance_scale=<span class="hljs-number">2</span>, 
    img_guidance_scale=<span class="hljs-number">1.6</span>,
    use_input_image_size_as_output=<span class="hljs-literal">True</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),H=new T({props:{title:"Controllable generation",local:"controllable-generation",headingTag:"h2"}}),E=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> OmniGenPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image 

pipe = OmniGenPipeline.from_pretrained(
    <span class="hljs-string">&quot;Shitao/OmniGen-v1-diffusers&quot;</span>,
    torch_dtype=torch.bfloat16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt=<span class="hljs-string">&quot;Detect the skeleton of human in this image: &lt;img&gt;&lt;|image_1|&gt;&lt;/img&gt;&quot;</span>
input_images=[load_image(<span class="hljs-string">&quot;https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/edit.png&quot;</span>)]
image1 = pipe(
    prompt=prompt, 
    input_images=input_images, 
    guidance_scale=<span class="hljs-number">2</span>, 
    img_guidance_scale=<span class="hljs-number">1.6</span>,
    use_input_image_size_as_output=<span class="hljs-literal">True</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">333</span>)).images[<span class="hljs-number">0</span>]
image1

prompt=<span class="hljs-string">&quot;Generate a new photo using the following picture and text as conditions: &lt;img&gt;&lt;|image_1|&gt;&lt;/img&gt;\\n A young boy is sitting on a sofa in the library, holding a book. His hair is neatly combed, and a faint smile plays on his lips, with a few freckles scattered across his cheeks. The library is quiet, with rows of shelves filled with books stretching out behind him.&quot;</span>
input_images=[load_image(<span class="hljs-string">&quot;https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/skeletal.png&quot;</span>)]
image2 = pipe(
    prompt=prompt, 
    input_images=input_images, 
    guidance_scale=<span class="hljs-number">2</span>, 
    img_guidance_scale=<span class="hljs-number">1.6</span>,
    use_input_image_size_as_output=<span class="hljs-literal">True</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">333</span>)).images[<span class="hljs-number">0</span>]
image2`,wrap:!1}}),F=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwT21uaUdlblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMjAlMEElMEFwaXBlJTIwJTNEJTIwT21uaUdlblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTaGl0YW8lMkZPbW5pR2VuLXYxLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUzRCUyMkZvbGxvd2luZyUyMHRoZSUyMHBvc2UlMjBvZiUyMHRoaXMlMjBpbWFnZSUyMCUzQ2ltZyUzRSUzQyU3Q2ltYWdlXzElN0MlM0UlM0MlMkZpbWclM0UlMkMlMjBnZW5lcmF0ZSUyMGElMjBuZXclMjBwaG90byUzQSUyMEElMjB5b3VuZyUyMGJveSUyMGlzJTIwc2l0dGluZyUyMG9uJTIwYSUyMHNvZmElMjBpbiUyMHRoZSUyMGxpYnJhcnklMkMlMjBob2xkaW5nJTIwYSUyMGJvb2suJTIwSGlzJTIwaGFpciUyMGlzJTIwbmVhdGx5JTIwY29tYmVkJTJDJTIwYW5kJTIwYSUyMGZhaW50JTIwc21pbGUlMjBwbGF5cyUyMG9uJTIwaGlzJTIwbGlwcyUyQyUyMHdpdGglMjBhJTIwZmV3JTIwZnJlY2tsZXMlMjBzY2F0dGVyZWQlMjBhY3Jvc3MlMjBoaXMlMjBjaGVla3MuJTIwVGhlJTIwbGlicmFyeSUyMGlzJTIwcXVpZXQlMkMlMjB3aXRoJTIwcm93cyUyMG9mJTIwc2hlbHZlcyUyMGZpbGxlZCUyMHdpdGglMjBib29rcyUyMHN0cmV0Y2hpbmclMjBvdXQlMjBiZWhpbmQlMjBoaW0uJTIyJTBBaW5wdXRfaW1hZ2VzJTNEJTVCbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZWZWN0b3JTcGFjZUxhYiUyRk9tbmlHZW4lMkZtYWluJTJGaW1ncyUyRmRvY3NfaW1nJTJGZWRpdC5wbmclMjIpJTVEJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMGlucHV0X2ltYWdlcyUzRGlucHV0X2ltYWdlcyUyQyUyMCUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMiUyQyUyMCUwQSUyMCUyMCUyMCUyMGltZ19ndWlkYW5jZV9zY2FsZSUzRDEuNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9pbnB1dF9pbWFnZV9zaXplX2FzX291dHB1dCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> OmniGenPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image 

pipe = OmniGenPipeline.from_pretrained(
    <span class="hljs-string">&quot;Shitao/OmniGen-v1-diffusers&quot;</span>,
    torch_dtype=torch.bfloat16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt=<span class="hljs-string">&quot;Following the pose of this image &lt;img&gt;&lt;|image_1|&gt;&lt;/img&gt;, generate a new photo: A young boy is sitting on a sofa in the library, holding a book. His hair is neatly combed, and a faint smile plays on his lips, with a few freckles scattered across his cheeks. The library is quiet, with rows of shelves filled with books stretching out behind him.&quot;</span>
input_images=[load_image(<span class="hljs-string">&quot;https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/edit.png&quot;</span>)]
image = pipe(
    prompt=prompt, 
    input_images=input_images, 
    guidance_scale=<span class="hljs-number">2</span>, 
    img_guidance_scale=<span class="hljs-number">1.6</span>,
    use_input_image_size_as_output=<span class="hljs-literal">True</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),$=new T({props:{title:"ID and object preserving",local:"id-and-object-preserving",headingTag:"h2"}}),q=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwT21uaUdlblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMjAlMEElMEFwaXBlJTIwJTNEJTIwT21uaUdlblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTaGl0YW8lMkZPbW5pR2VuLXYxLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUzRCUyMkElMjBtYW4lMjBhbmQlMjBhJTIwd29tYW4lMjBhcmUlMjBzaXR0aW5nJTIwYXQlMjBhJTIwY2xhc3Nyb29tJTIwZGVzay4lMjBUaGUlMjBtYW4lMjBpcyUyMHRoZSUyMG1hbiUyMHdpdGglMjB5ZWxsb3clMjBoYWlyJTIwaW4lMjAlM0NpbWclM0UlM0MlN0NpbWFnZV8xJTdDJTNFJTNDJTJGaW1nJTNFLiUyMFRoZSUyMHdvbWFuJTIwaXMlMjB0aGUlMjB3b21hbiUyMG9uJTIwdGhlJTIwbGVmdCUyMG9mJTIwJTNDaW1nJTNFJTNDJTdDaW1hZ2VfMiU3QyUzRSUzQyUyRmltZyUzRSUyMiUwQWlucHV0X2ltYWdlXzElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRlZlY3RvclNwYWNlTGFiJTJGT21uaUdlbiUyRm1haW4lMkZpbWdzJTJGZG9jc19pbWclMkYzLmpwZyUyMiklMEFpbnB1dF9pbWFnZV8yJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZWZWN0b3JTcGFjZUxhYiUyRk9tbmlHZW4lMkZtYWluJTJGaW1ncyUyRmRvY3NfaW1nJTJGNC5qcGclMjIpJTBBaW5wdXRfaW1hZ2VzJTNEJTVCaW5wdXRfaW1hZ2VfMSUyQyUyMGlucHV0X2ltYWdlXzIlNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwJTBBJTIwJTIwJTIwJTIwaW5wdXRfaW1hZ2VzJTNEaW5wdXRfaW1hZ2VzJTJDJTIwJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMi41JTJDJTIwJTBBJTIwJTIwJTIwJTIwaW1nX2d1aWRhbmNlX3NjYWxlJTNEMS42JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoNjY2KSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> OmniGenPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image 

pipe = OmniGenPipeline.from_pretrained(
    <span class="hljs-string">&quot;Shitao/OmniGen-v1-diffusers&quot;</span>,
    torch_dtype=torch.bfloat16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt=<span class="hljs-string">&quot;A man and a woman are sitting at a classroom desk. The man is the man with yellow hair in &lt;img&gt;&lt;|image_1|&gt;&lt;/img&gt;. The woman is the woman on the left of &lt;img&gt;&lt;|image_2|&gt;&lt;/img&gt;&quot;</span>
input_image_1 = load_image(<span class="hljs-string">&quot;https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/3.jpg&quot;</span>)
input_image_2 = load_image(<span class="hljs-string">&quot;https://raw.githubusercontent.com/VectorSpaceLab/OmniGen/main/imgs/docs_img/4.jpg&quot;</span>)
input_images=[input_image_1, input_image_2]
image = pipe(
    prompt=prompt, 
    input_images=input_images, 
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">2.5</span>, 
    img_guidance_scale=<span class="hljs-number">1.6</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">666</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwT21uaUdlblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMjAlMEElMEFwaXBlJTIwJTNEJTIwT21uaUdlblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTaGl0YW8lMkZPbW5pR2VuLXYxLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUwQXByb21wdCUzRCUyMkElMjB3b21hbiUyMGlzJTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMkMlMjB3ZWFyaW5nJTIwYSUyMHdoaXRlJTIwbG9uZy1zbGVldmUlMjBibG91c2UlMjB3aXRoJTIwbGFjZSUyMGRldGFpbHMlMjBvbiUyMHRoZSUyMHNsZWV2ZXMlMkMlMjBwYWlyZWQlMjB3aXRoJTIwYSUyMGJsdWUlMjBwbGVhdGVkJTIwc2tpcnQuJTIwVGhlJTIwd29tYW4lMjBpcyUyMCUzQ2ltZyUzRSUzQyU3Q2ltYWdlXzElN0MlM0UlM0MlMkZpbWclM0UuJTIwVGhlJTIwbG9uZy1zbGVldmUlMjBibG91c2UlMjBhbmQlMjBhJTIwcGxlYXRlZCUyMHNraXJ0JTIwYXJlJTIwJTNDaW1nJTNFJTNDJTdDaW1hZ2VfMiU3QyUzRSUzQyUyRmltZyUzRS4lMjIlMEFpbnB1dF9pbWFnZV8xJTIwJTNEJTIwbG9hZF9pbWFnZSglMjIlMkZzaGFyZSUyRmp1bmppZSUyRmNvZGUlMkZWSVNUQTIlMkZwcm9kdWNlX2RhdGElMkZsYWlvbl9uZXQlMkZkaWZmZ3B0JTJGT21uaUdlbiUyRmRvY3NfaW1nJTJGZW1tYS5qcGVnJTIyKSUwQWlucHV0X2ltYWdlXzIlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMiUyRnNoYXJlJTJGanVuamllJTJGY29kZSUyRlZJU1RBMiUyRnByb2R1Y2VfZGF0YSUyRmxhaW9uX25ldCUyRmRpZmZncHQlMkZPbW5pR2VuJTJGZG9jc19pbWclMkZkcmVzcy5qcGclMjIpJTBBaW5wdXRfaW1hZ2VzJTNEJTVCaW5wdXRfaW1hZ2VfMSUyQyUyMGlucHV0X2ltYWdlXzIlNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwJTBBJTIwJTIwJTIwJTIwaW5wdXRfaW1hZ2VzJTNEaW5wdXRfaW1hZ2VzJTJDJTIwJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMi41JTJDJTIwJTBBJTIwJTIwJTIwJTIwaW1nX2d1aWRhbmNlX3NjYWxlJTNEMS42JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoNjY2KSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> OmniGenPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image 

pipe = OmniGenPipeline.from_pretrained(
    <span class="hljs-string">&quot;Shitao/OmniGen-v1-diffusers&quot;</span>,
    torch_dtype=torch.bfloat16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)


prompt=<span class="hljs-string">&quot;A woman is walking down the street, wearing a white long-sleeve blouse with lace details on the sleeves, paired with a blue pleated skirt. The woman is &lt;img&gt;&lt;|image_1|&gt;&lt;/img&gt;. The long-sleeve blouse and a pleated skirt are &lt;img&gt;&lt;|image_2|&gt;&lt;/img&gt;.&quot;</span>
input_image_1 = load_image(<span class="hljs-string">&quot;/share/junjie/code/VISTA2/produce_data/laion_net/diffgpt/OmniGen/docs_img/emma.jpeg&quot;</span>)
input_image_2 = load_image(<span class="hljs-string">&quot;/share/junjie/code/VISTA2/produce_data/laion_net/diffgpt/OmniGen/docs_img/dress.jpg&quot;</span>)
input_images=[input_image_1, input_image_2]
image = pipe(
    prompt=prompt, 
    input_images=input_images, 
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">2.5</span>, 
    img_guidance_scale=<span class="hljs-number">1.6</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">666</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),A=new T({props:{title:"Optimization when inputting multiple images",local:"optimization-when-inputting-multiple-images",headingTag:"h2"}}),K=new T({props:{title:"inference speed",local:"inference-speed",headingTag:"h3"}}),le=new T({props:{title:"Memory",local:"memory",headingTag:"h3"}}),ae=new jl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/omnigen.md"}}),{c(){y=n("meta"),ne=s(),se=n("p"),me=s(),c(Z.$$.fragment),pe=s(),I=n("p"),I.textContent=De,ce=s(),W=n("ul"),W.innerHTML=Ae,oe=s(),B=n("p"),B.innerHTML=Oe,Me=s(),c(V.$$.fragment),Je=s(),_=n("p"),_.innerHTML=Pe,de=s(),c(R.$$.fragment),re=s(),c(X.$$.fragment),ye=s(),v=n("p"),v.innerHTML=Ke,ue=s(),c(Y.$$.fragment),Te=s(),w=n("div"),w.innerHTML=el,we=s(),c(k.$$.fragment),ge=s(),C=n("p"),C.innerHTML=ll,he=s(),c(N.$$.fragment),Ue=s(),g=n("div"),g.innerHTML=tl,be=s(),x=n("p"),x.textContent=al,Ge=s(),c(S.$$.fragment),je=s(),h=n("div"),h.innerHTML=sl,fe=s(),c(H.$$.fragment),Ze=s(),z=n("p"),z.textContent=il,Ie=s(),c(E.$$.fragment),We=s(),U=n("div"),U.innerHTML=nl,Be=s(),Q=n("p"),Q.textContent=ml,Ve=s(),c(F.$$.fragment),_e=s(),b=n("div"),b.innerHTML=pl,Re=s(),c($.$$.fragment),Xe=s(),L=n("p"),L.textContent=cl,ve=s(),c(q.$$.fragment),Ye=s(),G=n("div"),G.innerHTML=ol,ke=s(),c(D.$$.fragment),Ce=s(),j=n("div"),j.innerHTML=Ml,Ne=s(),c(A.$$.fragment),xe=s(),O=n("p"),O.textContent=Jl,Se=s(),P=n("p"),P.textContent=dl,He=s(),c(K.$$.fragment),ze=s(),ee=n("ul"),ee.innerHTML=rl,Ee=s(),c(le.$$.fragment),Qe=s(),te=n("ul"),te.innerHTML=yl,Fe=s(),c(ae.$$.fragment),$e=s(),ie=n("p"),this.h()},l(e){const l=bl("svelte-u9bgzb",document.head);y=m(l,"META",{name:!0,content:!0}),l.forEach(t),ne=i(e),se=m(e,"P",{}),ul(se).forEach(t),me=i(e),o(Z.$$.fragment,e),pe=i(e),I=m(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-u8xc9i"&&(I.textContent=De),ce=i(e),W=m(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-1e1t33d"&&(W.innerHTML=Ae),oe=i(e),B=m(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1qhio9r"&&(B.innerHTML=Oe),Me=i(e),o(V.$$.fragment,e),Je=i(e),_=m(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-ul0xyb"&&(_.innerHTML=Pe),de=i(e),o(R.$$.fragment,e),re=i(e),o(X.$$.fragment,e),ye=i(e),v=m(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1a87kfl"&&(v.innerHTML=Ke),ue=i(e),o(Y.$$.fragment,e),Te=i(e),w=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-uf526e"&&(w.innerHTML=el),we=i(e),o(k.$$.fragment,e),ge=i(e),C=m(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-nyhece"&&(C.innerHTML=ll),he=i(e),o(N.$$.fragment,e),Ue=i(e),g=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-ptjo10"&&(g.innerHTML=tl),be=i(e),x=m(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1faiga1"&&(x.textContent=al),Ge=i(e),o(S.$$.fragment,e),je=i(e),h=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-yas3w7"&&(h.innerHTML=sl),fe=i(e),o(H.$$.fragment,e),Ze=i(e),z=m(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-fnz9n8"&&(z.textContent=il),Ie=i(e),o(E.$$.fragment,e),We=i(e),U=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-n9fk6r"&&(U.innerHTML=nl),Be=i(e),Q=m(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1xps456"&&(Q.textContent=ml),Ve=i(e),o(F.$$.fragment,e),_e=i(e),b=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-17vyas4"&&(b.innerHTML=pl),Re=i(e),o($.$$.fragment,e),Xe=i(e),L=m(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-18p79vw"&&(L.textContent=cl),ve=i(e),o(q.$$.fragment,e),Ye=i(e),G=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-q7ysaf"&&(G.innerHTML=ol),ke=i(e),o(D.$$.fragment,e),Ce=i(e),j=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-164h1l6"&&(j.innerHTML=Ml),Ne=i(e),o(A.$$.fragment,e),xe=i(e),O=m(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-r192ug"&&(O.textContent=Jl),Se=i(e),P=m(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-8xp3ih"&&(P.textContent=dl),He=i(e),o(K.$$.fragment,e),ze=i(e),ee=m(e,"UL",{"data-svelte-h":!0}),p(ee)!=="svelte-neujg2"&&(ee.innerHTML=rl),Ee=i(e),o(le.$$.fragment,e),Qe=i(e),te=m(e,"UL",{"data-svelte-h":!0}),p(te)!=="svelte-ssfgjz"&&(te.innerHTML=yl),Fe=i(e),o(ae.$$.fragment,e),$e=i(e),ie=m(e,"P",{}),ul(ie).forEach(t),this.h()},h(){u(y,"name","hf:doc:metadata"),u(y,"content",Zl),u(w,"class","flex justify-center"),u(g,"class","flex flex-row gap-4"),u(h,"class","flex justify-center"),u(U,"class","flex flex-row gap-4"),u(b,"class","flex flex-row gap-4"),u(G,"class","flex flex-row gap-4"),u(j,"class","flex flex-row gap-4")},m(e,l){Gl(document.head,y),a(e,ne,l),a(e,se,l),a(e,me,l),M(Z,e,l),a(e,pe,l),a(e,I,l),a(e,ce,l),a(e,W,l),a(e,oe,l),a(e,B,l),a(e,Me,l),M(V,e,l),a(e,Je,l),a(e,_,l),a(e,de,l),M(R,e,l),a(e,re,l),M(X,e,l),a(e,ye,l),a(e,v,l),a(e,ue,l),M(Y,e,l),a(e,Te,l),a(e,w,l),a(e,we,l),M(k,e,l),a(e,ge,l),a(e,C,l),a(e,he,l),M(N,e,l),a(e,Ue,l),a(e,g,l),a(e,be,l),a(e,x,l),a(e,Ge,l),M(S,e,l),a(e,je,l),a(e,h,l),a(e,fe,l),M(H,e,l),a(e,Ze,l),a(e,z,l),a(e,Ie,l),M(E,e,l),a(e,We,l),a(e,U,l),a(e,Be,l),a(e,Q,l),a(e,Ve,l),M(F,e,l),a(e,_e,l),a(e,b,l),a(e,Re,l),M($,e,l),a(e,Xe,l),a(e,L,l),a(e,ve,l),M(q,e,l),a(e,Ye,l),a(e,G,l),a(e,ke,l),M(D,e,l),a(e,Ce,l),a(e,j,l),a(e,Ne,l),M(A,e,l),a(e,xe,l),a(e,O,l),a(e,Se,l),a(e,P,l),a(e,He,l),M(K,e,l),a(e,ze,l),a(e,ee,l),a(e,Ee,l),M(le,e,l),a(e,Qe,l),a(e,te,l),a(e,Fe,l),M(ae,e,l),a(e,$e,l),a(e,ie,l),Le=!0},p:wl,i(e){Le||(J(Z.$$.fragment,e),J(V.$$.fragment,e),J(R.$$.fragment,e),J(X.$$.fragment,e),J(Y.$$.fragment,e),J(k.$$.fragment,e),J(N.$$.fragment,e),J(S.$$.fragment,e),J(H.$$.fragment,e),J(E.$$.fragment,e),J(F.$$.fragment,e),J($.$$.fragment,e),J(q.$$.fragment,e),J(D.$$.fragment,e),J(A.$$.fragment,e),J(K.$$.fragment,e),J(le.$$.fragment,e),J(ae.$$.fragment,e),Le=!0)},o(e){d(Z.$$.fragment,e),d(V.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(k.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),d($.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),Le=!1},d(e){e&&(t(ne),t(se),t(me),t(pe),t(I),t(ce),t(W),t(oe),t(B),t(Me),t(Je),t(_),t(de),t(re),t(ye),t(v),t(ue),t(Te),t(w),t(we),t(ge),t(C),t(he),t(Ue),t(g),t(be),t(x),t(Ge),t(je),t(h),t(fe),t(Ze),t(z),t(Ie),t(We),t(U),t(Be),t(Q),t(Ve),t(_e),t(b),t(Re),t(Xe),t(L),t(ve),t(Ye),t(G),t(ke),t(Ce),t(j),t(Ne),t(xe),t(O),t(Se),t(P),t(He),t(ze),t(ee),t(Ee),t(Qe),t(te),t(Fe),t($e),t(ie)),t(y),r(Z,e),r(V,e),r(R,e),r(X,e),r(Y,e),r(k,e),r(N,e),r(S,e),r(H,e),r(E,e),r(F,e),r($,e),r(q,e),r(D,e),r(A,e),r(K,e),r(le,e),r(ae,e)}}}const Zl='{"title":"OmniGen","local":"omnigen","sections":[{"title":"Load model checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image edit","local":"image-edit","sections":[],"depth":2},{"title":"Controllable generation","local":"controllable-generation","sections":[],"depth":2},{"title":"ID and object preserving","local":"id-and-object-preserving","sections":[],"depth":2},{"title":"Optimization when inputting multiple images","local":"optimization-when-inputting-multiple-images","sections":[{"title":"inference speed","local":"inference-speed","sections":[],"depth":3},{"title":"Memory","local":"memory","sections":[],"depth":3}],"depth":2}],"depth":1}';function Il(qe){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends hl{constructor(y){super(),Ul(this,y,Il,fl,Tl,{})}}export{Rl as component};
