import{s as Ll,o as Kl,n as ql}from"../chunks/scheduler.c59d9fbb.js";import{S as Pl,i as lM,g as w,s as a,r as T,A as MM,h as j,f as s,c as n,j as $l,u as y,x as I,k as Hl,y as sM,a as U,v as e,d as C,t as J,w as t}from"../chunks/index.a47918e3.js";import{T as UM}from"../chunks/Tip.3fcf4aa4.js";import{C as r}from"../chunks/CodeBlock.f26209eb.js";import{H as K,E as aM}from"../chunks/index.0513ac52.js";function nM(ll){let i,A="Note that this trainer uses pairs between sentences as the training samples, so the number of training steps grows exponentially to the number of unlabeled examples. To avoid overfitting, consider setting <code>max_steps</code> relatively low.";return{c(){i=w("p"),i.innerHTML=A},l(p){i=j(p,"P",{"data-svelte-h":!0}),I(i)!=="svelte-1v3685y"&&(i.innerHTML=A)},m(p,q){U(p,i,q)},p:ql,d(p){p&&s(i)}}}function TM(ll){let i,A,p,q,m,Ml,h,Zl="If you have access to unlabeled data, then you can use knowledge distillation to improve the performance of your small SetFit model. The approach involves training a larger model and using unlabeled data to distil its performance into your smaller SetFit model. As a result, your SetFit model will become stronger.",sl,d,Wl="Additionally, you can also use knowledge distillation to replace your trained SetFit model with a more efficient model at less of a performance decrease.",Ul,b,Gl="This guide will show you how to proceed with knowledge distillation.",al,o,nl,N,Dl='Let’s consider a scenario with a little bit of labeled training data (e.g. 64 sentences). We will simulate this scenario using the <a href="https://huggingface.co/datasets/ag_news" rel="nofollow">ag_news</a> dataset for this guide.',Tl,O,yl,u,el,g,fl="We can use standard SetFit training approach to prepare a model.",Cl,V,Jl,F,tl,R,Ql="This model reaches 78.18% on our dataset. Certainly respectable given the tiny amount of training data, but we can use knowledge distillation to squeeze more performance out of our model.",il,Y,wl,x,Bl="Alongside our labeled training data, we may als have a lot of unlabeled training data (e.g. 500 sentences). Let’s prepare it:",jl,Z,Il,W,pl,G,Xl='Then, we will prepare a larger trained SetFit model that will act as the teacher to our smaller student model. The strong <a href="https://huggingface.co/sentence-transformers/paraphrase-mpnet-base-v2" rel="nofollow"><code>sentence-transformers/paraphrase-mpnet-base-v2</code></a> Sentence Transformer model will be used to initialize the SetFit model.',rl,D,cl,f,zl="We need to train this model on the labeled dataset first:",Al,Q,ml,B,hl,X,El="This large teacher model reaches 83.79%, which is quite strong for this little data, and noticeably, stronger than the 78.18% from our smaller (but more efficient) model.",dl,z,bl,E,_l='The performance from the stronger teacher_model can be distilled into the smaller model using the <a href="/docs/setfit/pr_594/en/reference/trainer#setfit.DistillationTrainer">DistillationTrainer</a>. It accepts a teacher and a student model, as well as an unlabeled dataset.',ol,c,Nl,_,Ol,S,ul,k,Sl="Using knowledge distillation, we were able to improve our model from 78.18% to 80.84% in a few minutes of training.",gl,v,Vl,$,kl="This snippet shows the entire knowledge distillation strategy in an end-to-end example:",Fl,H,Rl,L,Yl,P,xl;return m=new K({props:{title:"Knowledge Distillation",local:"knowledge-distillation",headingTag:"h1"}}),o=new K({props:{title:"Data preparation",local:"data-preparation",headingTag:"h2"}}),O=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMHNhbXBsZV9kYXRhc2V0JTBBJTBBJTIzJTIwTG9hZCUyMGElMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhZ19uZXdzJTIyKSUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBzYW1wbGUlMjBmZXctc2hvdCUyMGRhdGFzZXQlMjB0byUyMHRyYWluJTIwd2l0aCUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBzYW1wbGVfZGF0YXNldChkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMjBsYWJlbF9jb2x1bW4lM0QlMjJsYWJlbCUyMiUyQyUyMG51bV9zYW1wbGVzJTNEMTYpJTBBJTIzJTIwRGF0YXNldCglN0IlMEElMjMlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclNUQlMkMlMEElMjMlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDY0JTBBJTIzJTIwJTdEKSUwQSUwQSUyMyUyMERhdGFzZXQlMjBmb3IlMjBldmFsdWF0aW9uJTBBZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEElMjMlMjBEYXRhc2V0KCU3QiUwQSUyMyUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyU1RCUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNzYwMCUwQSUyMyUyMCU3RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> sample_dataset

<span class="hljs-comment"># Load a dataset from the Hugging Face Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;ag_news&quot;</span>)

<span class="hljs-comment"># Create a sample few-shot dataset to train with</span>
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">16</span>)
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 64</span>
<span class="hljs-comment"># })</span>

<span class="hljs-comment"># Dataset for evaluation</span>
eval_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 7600</span>
<span class="hljs-comment"># })</span>`,wrap:!1}}),u=new K({props:{title:"Baseline model",local:"baseline-model",headingTag:"h2"}}),V=new r({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBUcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS1NaW5pTE0tTDMtdjIlMjIpJTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMG51bV9lcG9jaHMlM0Q1JTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKSUwQSUwQW1ldHJpY3MlMjAlM0QlMjB0cmFpbmVyLmV2YWx1YXRlKCklMEFwcmludChtZXRyaWNzKQ==",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, TrainingArguments, Trainer

model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-MiniLM-L3-v2&quot;</span>)

args = TrainingArguments(
    batch_size=<span class="hljs-number">64</span>,
    num_epochs=<span class="hljs-number">5</span>,
)

trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)
trainer.train()

metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)`,wrap:!1}}),F=new r({props:{code:"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",highlighted:`***** Running training *****
  <span class="hljs-type">Num</span> <span class="hljs-variable">examples</span> <span class="hljs-operator">=</span> <span class="hljs-number">48</span>
  <span class="hljs-type">Num</span> <span class="hljs-variable">epochs</span> <span class="hljs-operator">=</span> <span class="hljs-number">5</span>
  Total <span class="hljs-type">optimization</span> <span class="hljs-variable">steps</span> <span class="hljs-operator">=</span> <span class="hljs-number">240</span>
  Total train <span class="hljs-type">batch</span> <span class="hljs-variable">size</span> <span class="hljs-operator">=</span> <span class="hljs-number">64</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.4173</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">8.333333333333333e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1756</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.7592592592592595e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.04</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.119</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.2962962962962964e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.08</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0872</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">8.333333333333334e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">3.12</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0542</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.7037037037037037e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">4.17</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">26.0837</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">588.873</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">9.201</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">5.0</span>}                                                     
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">240</span>/<span class="hljs-number">240</span> [<span class="hljs-number">00</span>:<span class="hljs-number">20</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">11.</span>97it/s] 
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.7818421052631579</span>}`,wrap:!1}}),Y=new K({props:{title:"Unlabeled Data Preparation",local:"unlabeled-data-preparation",headingTag:"h2"}}),Z=new r({props:{code:"JTIzJTIwQ3JlYXRlJTIwYSUyMGRhdGFzZXQlMjBvZiUyMHVubGFiZWxlZCUyMGV4YW1wbGVzJTIwdG8lMjBwZXJmb3JtJTIwa25vd2xlZGdlJTIwZGlzdGlsbGF0aW9uJTBBdW5sYWJlbGVkX3RyYWluX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuc2h1ZmZsZShzZWVkJTNEMCkuc2VsZWN0KHJhbmdlKDUwMCkpJTBBdW5sYWJlbGVkX3RyYWluX2RhdGFzZXQlMjAlM0QlMjB1bmxhYmVsZWRfdHJhaW5fZGF0YXNldC5yZW1vdmVfY29sdW1ucyglMjJsYWJlbCUyMiklMEElMjMlMjBEYXRhc2V0KCU3QiUwQSUyMyUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTVEJTJDJTBBJTIzJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA1MDAlMEElMjMlMjAlN0Qp",highlighted:`<span class="hljs-comment"># Create a dataset of unlabeled examples to perform knowledge distillation</span>
unlabeled_train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">0</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">500</span>))
unlabeled_train_dataset = unlabeled_train_dataset.remove_columns(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;],</span>
<span class="hljs-comment">#     num_rows: 500</span>
<span class="hljs-comment"># })</span>`,wrap:!1}}),W=new K({props:{title:"Teacher model",local:"teacher-model",headingTag:"h2"}}),D=new r({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBdGVhY2hlcl9tb2RlbCUyMCUzRCUyMFNldEZpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzZW50ZW5jZS10cmFuc2Zvcm1lcnMlMkZwYXJhcGhyYXNlLW1wbmV0LWJhc2UtdjIlMjIp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

teacher_model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>)`,wrap:!1}}),Q=new r({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRlYWNoZXJfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMG51bV9lcG9jaHMlM0QyJTJDJTBBKSUwQSUwQXRlYWNoZXJfdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0R0ZWFjaGVyX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRlYWNoZXJfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQSUwQSUyMyUyMFRyYWluJTIwdGVhY2hlciUyMG1vZGVsJTBBdGVhY2hlcl90cmFpbmVyLnRyYWluKCklMEF0ZWFjaGVyX21ldHJpY3MlMjAlM0QlMjB0ZWFjaGVyX3RyYWluZXIuZXZhbHVhdGUoKSUwQXByaW50KHRlYWNoZXJfbWV0cmljcyk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments, Trainer

teacher_args = TrainingArguments(
    batch_size=<span class="hljs-number">16</span>,
    num_epochs=<span class="hljs-number">2</span>,
)

teacher_trainer = Trainer(
    model=teacher_model,
    args=teacher_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

<span class="hljs-comment"># Train teacher model</span>
teacher_trainer.train()
teacher_metrics = teacher_trainer.evaluate()
<span class="hljs-built_in">print</span>(teacher_metrics)`,wrap:!1}}),B=new r({props:{code:"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",highlighted:`***** Running training *****
  <span class="hljs-type">Num</span> <span class="hljs-variable">examples</span> <span class="hljs-operator">=</span> <span class="hljs-number">192</span>
  <span class="hljs-type">Num</span> <span class="hljs-variable">epochs</span> <span class="hljs-operator">=</span> <span class="hljs-number">2</span>
  Total <span class="hljs-type">optimization</span> <span class="hljs-variable">steps</span> <span class="hljs-operator">=</span> <span class="hljs-number">384</span>
  Total train <span class="hljs-type">batch</span> <span class="hljs-variable">size</span> <span class="hljs-operator">=</span> <span class="hljs-number">16</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.4093</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">5.128205128205128e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1087</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.9362318840579713e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.26</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.001</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.6463768115942028e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.52</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0006</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.3565217391304348e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.78</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0003</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.0666666666666667e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.04</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0004</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">7.768115942028987e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.3</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0002</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">4.869565217391305e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.56</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0003</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.9710144927536233e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.82</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">84.3703</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">72.822</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">4.551</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.0</span>}                                                      
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">384</span>/<span class="hljs-number">384</span> [<span class="hljs-number">01</span>:<span class="hljs-number">24</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">4.</span>55it/s] 
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8378947368421052</span>}`,wrap:!1}}),z=new K({props:{title:"Knowledge Distillation",local:"knowledge-distillation",headingTag:"h2"}}),c=new UM({props:{warning:!0,$$slots:{default:[nM]},$$scope:{ctx:ll}}}),_=new r({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMERpc3RpbGxhdGlvblRyYWluZXIlMEElMEFkaXN0aWxsYXRpb25fYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDUwMCUyQyUwQSklMEElMEFkaXN0aWxsYXRpb25fdHJhaW5lciUyMCUzRCUyMERpc3RpbGxhdGlvblRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdGVhY2hlcl9tb2RlbCUzRHRlYWNoZXJfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBzdHVkZW50X21vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEZGlzdGlsbGF0aW9uX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdW5sYWJlbGVkX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RldmFsX2RhdGFzZXQlMkMlMEEpJTBBJTIzJTIwVHJhaW4lMjBzdHVkZW50JTIwd2l0aCUyMGtub3dsZWRnZSUyMGRpc3RpbGxhdGlvbiUwQWRpc3RpbGxhdGlvbl90cmFpbmVyLnRyYWluKCklMEFkaXN0aWxsYXRpb25fbWV0cmljcyUyMCUzRCUyMGRpc3RpbGxhdGlvbl90cmFpbmVyLmV2YWx1YXRlKCklMEFwcmludChkaXN0aWxsYXRpb25fbWV0cmljcyk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> DistillationTrainer

distillation_args = TrainingArguments(
    batch_size=<span class="hljs-number">16</span>,
    max_steps=<span class="hljs-number">500</span>,
)

distillation_trainer = DistillationTrainer(
    teacher_model=teacher_model,
    student_model=model,
    args=distillation_args,
    train_dataset=unlabeled_train_dataset,
    eval_dataset=eval_dataset,
)
<span class="hljs-comment"># Train student with knowledge distillation</span>
distillation_trainer.train()
distillation_metrics = distillation_trainer.evaluate()
<span class="hljs-built_in">print</span>(distillation_metrics)`,wrap:!1}}),S=new r({props:{code:"KioqKiolMjBSdW5uaW5nJTIwdHJhaW5pbmclMjAqKioqKiUwQSUyMCUyME51bSUyMGV4YW1wbGVzJTIwJTNEJTIwNzgyOSUwQSUyMCUyME51bSUyMGVwb2NocyUyMCUzRCUyMDElMEElMjAlMjBUb3RhbCUyMG9wdGltaXphdGlvbiUyMHN0ZXBzJTIwJTNEJTIwNzgyOSUwQSUyMCUyMFRvdGFsJTIwdHJhaW4lMjBiYXRjaCUyMHNpemUlMjAlM0QlMjAxNiUwQSU3QidlbWJlZGRpbmdfbG9zcyclM0ElMjAwLjUwNDglMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ElMjAyLjU1NDI3ODQxNjM0NzM4MmUtMDglMkMlMjAnZXBvY2gnJTNBJTIwMC4wJTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ2VtYmVkZGluZ19sb3NzJyUzQSUyMDAuNDUxNCUyQyUyMCdsZWFybmluZ19yYXRlJyUzQSUyMDEuMjc3MTM5MjA4MTczNjkxZS0wNiUyQyUyMCdlcG9jaCclM0ElMjAwLjAxJTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ2VtYmVkZGluZ19sb3NzJyUzQSUyMDAuMzMlMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ElMjAyLjU1NDI3ODQxNjM0NzM4MmUtMDYlMkMlMjAnZXBvY2gnJTNBJTIwMC4wMSU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSU3QidlbWJlZGRpbmdfbG9zcyclM0ElMjAwLjEyMTglMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ElMjAzLjgzMTQxNzYyNDUyMTA3M2UtMDYlMkMlMjAnZXBvY2gnJTNBJTIwMC4wMiU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSU3QidlbWJlZGRpbmdfbG9zcyclM0ElMjAwLjAyMTMlMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ElMjA1LjEwODU1NjgzMjY5NDc2NGUtMDYlMkMlMjAnZXBvY2gnJTNBJTIwMC4wMyU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSU3QidlbWJlZGRpbmdfbG9zcyclM0ElMjAwLjAxNiUyQyUyMCdsZWFybmluZ19yYXRlJyUzQSUyMDYuMzg1Njk2MDQwODY4NDU1ZS0wNiUyQyUyMCdlcG9jaCclM0ElMjAwLjAzJTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ2VtYmVkZGluZ19sb3NzJyUzQSUyMDAuMDA1NCUyQyUyMCdsZWFybmluZ19yYXRlJyUzQSUyMDcuNjYyODM1MjQ5MDQyMTQ3ZS0wNiUyQyUyMCdlcG9jaCclM0ElMjAwLjA0JTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ2VtYmVkZGluZ19sb3NzJyUzQSUyMDAuMDA0OSUyQyUyMCdsZWFybmluZ19yYXRlJyUzQSUyMDguOTM5OTc0NDU3MjE1ODM4ZS0wNiUyQyUyMCdlcG9jaCclM0ElMjAwLjA0JTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ2VtYmVkZGluZ19sb3NzJyUzQSUyMDAuMDAyJTJDJTIwJ2xlYXJuaW5nX3JhdGUnJTNBJTIwMS4wMjE3MTEzNjY1Mzg5NTI4ZS0wNSUyQyUyMCdlcG9jaCclM0ElMjAwLjA1JTdEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTdCJ2VtYmVkZGluZ19sb3NzJyUzQSUyMDAuMDAxOSUyQyUyMCdsZWFybmluZ19yYXRlJyUzQSUyMDEuMTQ5NDI1Mjg3MzU2MzIxOGUtMDUlMkMlMjAnZXBvY2gnJTNBJTIwMC4wNiU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSU3QidlbWJlZGRpbmdfbG9zcyclM0ElMjAwLjAwMTIlMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ElMjAxLjI3NzEzOTIwODE3MzY5MWUtMDUlMkMlMjAnZXBvY2gnJTNBJTIwMC4wNiU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSU3Qid0cmFpbl9ydW50aW1lJyUzQSUyMDIyLjI3MjUlMkMlMjAndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDM1OS4xODglMkMlMjAndHJhaW5fc3RlcHNfcGVyX3NlY29uZCclM0ElMjAyMi40NDklMkMlMjAnZXBvY2gnJTNBJTIwMC4wNiU3RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQTEwMCUyNSU3QyVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCVFMiU5NiU4OCU3QyUyMDUwMCUyRjUwMCUyMCU1QjAwJTNBMjIlM0MwMCUzQTAwJTJDJTIwMjIuNDVpdCUyRnMlNUQlMjAlMEEqKioqKiUyMFJ1bm5pbmclMjBldmFsdWF0aW9uJTIwKioqKiolMEElN0InYWNjdXJhY3knJTNBJTIwMC44MDg0MjEwNTI2MzE1Nzg5JTdE",highlighted:`***** Running training *****
  Num examples = <span class="hljs-number">7829</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">7829</span>
  Total train batch size = <span class="hljs-number">16</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.5048</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">2.554278416347382e-08</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.0</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.4514</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.277139208173691e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.33</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">2.554278416347382e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                    
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1218</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.831417624521073e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0213</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">5.108556832694764e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.03</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.016</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">6.385696040868455e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.03</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0054</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">7.662835249042147e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.04</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0049</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">8.939974457215838e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.04</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.002</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.0217113665389528e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.05</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0019</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.1494252873563218e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.06</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0012</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.277139208173691e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.06</span>}                                                                                  
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">22.2725</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">359.188</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">22.449</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.06</span>}                                                   
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">500</span>/<span class="hljs-number">500</span> [<span class="hljs-number">00</span>:<span class="hljs-number">22</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">22.45</span>it/s] 
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8084210526315789</span>}`,wrap:!1}}),v=new K({props:{title:"End-to-end",local:"end-to-end",headingTag:"h2"}}),H=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> sample_dataset

<span class="hljs-comment"># Load a dataset from the Hugging Face Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;ag_news&quot;</span>)

<span class="hljs-comment"># Create a sample few-shot dataset to train with</span>
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">16</span>)
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 64</span>
<span class="hljs-comment"># })</span>

<span class="hljs-comment"># Dataset for evaluation</span>
eval_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 7600</span>
<span class="hljs-comment"># })</span>

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, TrainingArguments, Trainer

model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-MiniLM-L3-v2&quot;</span>)

args = TrainingArguments(
    batch_size=<span class="hljs-number">64</span>,
    num_epochs=<span class="hljs-number">5</span>,
)

trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)
trainer.train()

metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)

<span class="hljs-comment"># Create a dataset of unlabeled examples to perform knowledge distillation</span>
unlabeled_train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">0</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">500</span>))
unlabeled_train_dataset = unlabeled_train_dataset.remove_columns(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;],</span>
<span class="hljs-comment">#     num_rows: 500</span>
<span class="hljs-comment"># })</span>

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

teacher_model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>)

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments, Trainer

teacher_args = TrainingArguments(
    batch_size=<span class="hljs-number">16</span>,
    num_epochs=<span class="hljs-number">2</span>,
)

teacher_trainer = Trainer(
    model=teacher_model,
    args=teacher_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

<span class="hljs-comment"># Train teacher model</span>
teacher_trainer.train()
teacher_metrics = teacher_trainer.evaluate()
<span class="hljs-built_in">print</span>(teacher_metrics)

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> DistillationTrainer

distillation_args = TrainingArguments(
    batch_size=<span class="hljs-number">16</span>,
    max_steps=<span class="hljs-number">500</span>,
)

distillation_trainer = DistillationTrainer(
    teacher_model=teacher_model,
    student_model=model,
    args=distillation_args,
    train_dataset=unlabeled_train_dataset,
    eval_dataset=eval_dataset,
)
<span class="hljs-comment"># Train student with knowledge distillation</span>
distillation_trainer.train()
distillation_metrics = distillation_trainer.evaluate()
<span class="hljs-built_in">print</span>(distillation_metrics)`,wrap:!1}}),L=new aM({props:{source:"https://github.com/huggingface/setfit/blob/main/docs/source/en/how_to/knowledge_distillation.mdx"}}),{c(){i=w("meta"),A=a(),p=w("p"),q=a(),T(m.$$.fragment),Ml=a(),h=w("p"),h.textContent=Zl,sl=a(),d=w("p"),d.textContent=Wl,Ul=a(),b=w("p"),b.textContent=Gl,al=a(),T(o.$$.fragment),nl=a(),N=w("p"),N.innerHTML=Dl,Tl=a(),T(O.$$.fragment),yl=a(),T(u.$$.fragment),el=a(),g=w("p"),g.textContent=fl,Cl=a(),T(V.$$.fragment),Jl=a(),T(F.$$.fragment),tl=a(),R=w("p"),R.textContent=Ql,il=a(),T(Y.$$.fragment),wl=a(),x=w("p"),x.textContent=Bl,jl=a(),T(Z.$$.fragment),Il=a(),T(W.$$.fragment),pl=a(),G=w("p"),G.innerHTML=Xl,rl=a(),T(D.$$.fragment),cl=a(),f=w("p"),f.textContent=zl,Al=a(),T(Q.$$.fragment),ml=a(),T(B.$$.fragment),hl=a(),X=w("p"),X.textContent=El,dl=a(),T(z.$$.fragment),bl=a(),E=w("p"),E.innerHTML=_l,ol=a(),T(c.$$.fragment),Nl=a(),T(_.$$.fragment),Ol=a(),T(S.$$.fragment),ul=a(),k=w("p"),k.textContent=Sl,gl=a(),T(v.$$.fragment),Vl=a(),$=w("p"),$.textContent=kl,Fl=a(),T(H.$$.fragment),Rl=a(),T(L.$$.fragment),Yl=a(),P=w("p"),this.h()},l(l){const M=MM("svelte-u9bgzb",document.head);i=j(M,"META",{name:!0,content:!0}),M.forEach(s),A=n(l),p=j(l,"P",{}),$l(p).forEach(s),q=n(l),y(m.$$.fragment,l),Ml=n(l),h=j(l,"P",{"data-svelte-h":!0}),I(h)!=="svelte-1iaeqif"&&(h.textContent=Zl),sl=n(l),d=j(l,"P",{"data-svelte-h":!0}),I(d)!=="svelte-19socj4"&&(d.textContent=Wl),Ul=n(l),b=j(l,"P",{"data-svelte-h":!0}),I(b)!=="svelte-1dkdhtd"&&(b.textContent=Gl),al=n(l),y(o.$$.fragment,l),nl=n(l),N=j(l,"P",{"data-svelte-h":!0}),I(N)!=="svelte-1ggqf13"&&(N.innerHTML=Dl),Tl=n(l),y(O.$$.fragment,l),yl=n(l),y(u.$$.fragment,l),el=n(l),g=j(l,"P",{"data-svelte-h":!0}),I(g)!=="svelte-1avn12v"&&(g.textContent=fl),Cl=n(l),y(V.$$.fragment,l),Jl=n(l),y(F.$$.fragment,l),tl=n(l),R=j(l,"P",{"data-svelte-h":!0}),I(R)!=="svelte-ewavsy"&&(R.textContent=Ql),il=n(l),y(Y.$$.fragment,l),wl=n(l),x=j(l,"P",{"data-svelte-h":!0}),I(x)!=="svelte-lgbx2q"&&(x.textContent=Bl),jl=n(l),y(Z.$$.fragment,l),Il=n(l),y(W.$$.fragment,l),pl=n(l),G=j(l,"P",{"data-svelte-h":!0}),I(G)!=="svelte-1yw0yn"&&(G.innerHTML=Xl),rl=n(l),y(D.$$.fragment,l),cl=n(l),f=j(l,"P",{"data-svelte-h":!0}),I(f)!=="svelte-1t1w4v"&&(f.textContent=zl),Al=n(l),y(Q.$$.fragment,l),ml=n(l),y(B.$$.fragment,l),hl=n(l),X=j(l,"P",{"data-svelte-h":!0}),I(X)!=="svelte-1tfc559"&&(X.textContent=El),dl=n(l),y(z.$$.fragment,l),bl=n(l),E=j(l,"P",{"data-svelte-h":!0}),I(E)!=="svelte-1s5zitz"&&(E.innerHTML=_l),ol=n(l),y(c.$$.fragment,l),Nl=n(l),y(_.$$.fragment,l),Ol=n(l),y(S.$$.fragment,l),ul=n(l),k=j(l,"P",{"data-svelte-h":!0}),I(k)!=="svelte-1mlr23c"&&(k.textContent=Sl),gl=n(l),y(v.$$.fragment,l),Vl=n(l),$=j(l,"P",{"data-svelte-h":!0}),I($)!=="svelte-jbt54l"&&($.textContent=kl),Fl=n(l),y(H.$$.fragment,l),Rl=n(l),y(L.$$.fragment,l),Yl=n(l),P=j(l,"P",{}),$l(P).forEach(s),this.h()},h(){Hl(i,"name","hf:doc:metadata"),Hl(i,"content",yM)},m(l,M){sM(document.head,i),U(l,A,M),U(l,p,M),U(l,q,M),e(m,l,M),U(l,Ml,M),U(l,h,M),U(l,sl,M),U(l,d,M),U(l,Ul,M),U(l,b,M),U(l,al,M),e(o,l,M),U(l,nl,M),U(l,N,M),U(l,Tl,M),e(O,l,M),U(l,yl,M),e(u,l,M),U(l,el,M),U(l,g,M),U(l,Cl,M),e(V,l,M),U(l,Jl,M),e(F,l,M),U(l,tl,M),U(l,R,M),U(l,il,M),e(Y,l,M),U(l,wl,M),U(l,x,M),U(l,jl,M),e(Z,l,M),U(l,Il,M),e(W,l,M),U(l,pl,M),U(l,G,M),U(l,rl,M),e(D,l,M),U(l,cl,M),U(l,f,M),U(l,Al,M),e(Q,l,M),U(l,ml,M),e(B,l,M),U(l,hl,M),U(l,X,M),U(l,dl,M),e(z,l,M),U(l,bl,M),U(l,E,M),U(l,ol,M),e(c,l,M),U(l,Nl,M),e(_,l,M),U(l,Ol,M),e(S,l,M),U(l,ul,M),U(l,k,M),U(l,gl,M),e(v,l,M),U(l,Vl,M),U(l,$,M),U(l,Fl,M),e(H,l,M),U(l,Rl,M),e(L,l,M),U(l,Yl,M),U(l,P,M),xl=!0},p(l,[M]){const vl={};M&2&&(vl.$$scope={dirty:M,ctx:l}),c.$set(vl)},i(l){xl||(C(m.$$.fragment,l),C(o.$$.fragment,l),C(O.$$.fragment,l),C(u.$$.fragment,l),C(V.$$.fragment,l),C(F.$$.fragment,l),C(Y.$$.fragment,l),C(Z.$$.fragment,l),C(W.$$.fragment,l),C(D.$$.fragment,l),C(Q.$$.fragment,l),C(B.$$.fragment,l),C(z.$$.fragment,l),C(c.$$.fragment,l),C(_.$$.fragment,l),C(S.$$.fragment,l),C(v.$$.fragment,l),C(H.$$.fragment,l),C(L.$$.fragment,l),xl=!0)},o(l){J(m.$$.fragment,l),J(o.$$.fragment,l),J(O.$$.fragment,l),J(u.$$.fragment,l),J(V.$$.fragment,l),J(F.$$.fragment,l),J(Y.$$.fragment,l),J(Z.$$.fragment,l),J(W.$$.fragment,l),J(D.$$.fragment,l),J(Q.$$.fragment,l),J(B.$$.fragment,l),J(z.$$.fragment,l),J(c.$$.fragment,l),J(_.$$.fragment,l),J(S.$$.fragment,l),J(v.$$.fragment,l),J(H.$$.fragment,l),J(L.$$.fragment,l),xl=!1},d(l){l&&(s(A),s(p),s(q),s(Ml),s(h),s(sl),s(d),s(Ul),s(b),s(al),s(nl),s(N),s(Tl),s(yl),s(el),s(g),s(Cl),s(Jl),s(tl),s(R),s(il),s(wl),s(x),s(jl),s(Il),s(pl),s(G),s(rl),s(cl),s(f),s(Al),s(ml),s(hl),s(X),s(dl),s(bl),s(E),s(ol),s(Nl),s(Ol),s(ul),s(k),s(gl),s(Vl),s($),s(Fl),s(Rl),s(Yl),s(P)),s(i),t(m,l),t(o,l),t(O,l),t(u,l),t(V,l),t(F,l),t(Y,l),t(Z,l),t(W,l),t(D,l),t(Q,l),t(B,l),t(z,l),t(c,l),t(_,l),t(S,l),t(v,l),t(H,l),t(L,l)}}}const yM='{"title":"Knowledge Distillation","local":"knowledge-distillation","sections":[{"title":"Data preparation","local":"data-preparation","sections":[],"depth":2},{"title":"Baseline model","local":"baseline-model","sections":[],"depth":2},{"title":"Unlabeled Data Preparation","local":"unlabeled-data-preparation","sections":[],"depth":2},{"title":"Teacher model","local":"teacher-model","sections":[],"depth":2},{"title":"Knowledge Distillation","local":"knowledge-distillation","sections":[],"depth":2},{"title":"End-to-end","local":"end-to-end","sections":[],"depth":2}],"depth":1}';function eM(ll){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jM extends Pl{constructor(i){super(),lM(this,i,eM,TM,Ll,{})}}export{jM as component};
