import{s as Pt,n as Et,o as St}from"../chunks/scheduler.412302f6.js";import{S as Qt,i as Yt,g as i,s,r as m,A as Vt,h as p,f as l,c as a,j as Ht,u as o,x as r,k as Xt,y as zt,a as n,v as d,d as y,t as M,w as u}from"../chunks/index.f36f02f5.js";import{C as Y}from"../chunks/CodeBlock.f4a4ce81.js";import{H as Q}from"../chunks/Heading.41d80af4.js";function At(Ct){let f,A,V,L,U,D,w,jt="This tutorial walks you through setting up and running model training on TPU using the <code>optimum-tpu</code> package.",N,T,q,J,$t='Before starting, ensure you have a running TPU instance (see <a href="../tutorials/tpu_setup.mdx">TPU Setup Guide</a>)',K,c,O,h,It="First, create and activate a virtual environment:",tt,g,et,C,bt="Install the required packages:",lt,j,nt,$,st,I,vt="To speed up your training on TPU, you can rely on Optimum TPU’s integration with FSDP (Fully Sharded Data Parallel). When training large models, FSDP automatically shards (splits) your model across all available TPU workers, providing several key benefits:",at,b,Zt="<li>Memory efficiency: Each TPU worker only stores a portion of the model parameters, reducing per-device memory requirements</li> <li>Automatic scaling: FSDP handles the complexity of distributing the model and aggregating gradients</li> <li>Performance optimization: Optimum TPU’s implementation is specifically tuned for TPU hardware</li>",it,v,Bt="This sharding happens automatically when you use the <code>fsdp_v2.get_fsdp_training_args(model)</code> configuration in your training setup, making it easy to train larger models that wouldn’t fit on a single TPU device.",pt,Z,rt,B,_t="The key modification to enable FSDP is just these few lines:",mt,_,ot,F,Ft="Then include these arguments in your trainer configuration:",dt,k,yt,W,Mt,R,kt="Here’s a full working example that demonstrates TPU training with FSDP:",ut,x,ft,G,Wt="Save this code as train.py and run it:",Ut,H,wt,X,Rt="You should now see the loss decrease during training. When the training is done, you will have a fine-tuned model. Congrats - you’ve just trained your first model on TPUs! 🙌",Tt,P,Jt,E,xt="Continue your TPU training journey by exploring:",ct,S,Gt='<li>More complex training scenarios in our <a href="../howto/more_examples">examples</a></li> <li>Different <a href="../supported-architectures">model architectures supported by Optimum TPU</a></li>',ht,z,gt;return U=new Q({props:{title:"First TPU Training on Google Cloud",local:"first-tpu-training-on-google-cloud",headingTag:"h1"}}),T=new Q({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),c=new Q({props:{title:"Environment Setup",local:"environment-setup",headingTag:"h2"}}),g=new Y({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLnZlbnYlMEFzb3VyY2UlMjAudmVudiUyRmJpbiUyRmFjdGl2YXRl",highlighted:`python -m venv .venv
<span class="hljs-built_in">source</span> .venv/bin/activate`,wrap:!1}}),j=new Y({props:{code:"JTIzJTIwSW5zdGFsbCUyMG9wdGltdW0tdHB1JTIwd2l0aCUyMFB5VG9yY2glMkZYTEElMjBzdXBwb3J0JTBBcGlwJTIwaW5zdGFsbCUyMG9wdGltdW0tdHB1JTIwLWYlMjBodHRwcyUzQSUyRiUyRnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20lMkZsaWJ0cHUtcmVsZWFzZXMlMkZpbmRleC5odG1sJTBBJTBBJTIzJTIwSW5zdGFsbCUyMGFkZGl0aW9uYWwlMjB0cmFpbmluZyUyMGRlcGVuZGVuY2llcyUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMGFjY2VsZXJhdGUlMjB0cmwlMjBwZWZ0JTIwZXZhbHVhdGU=",highlighted:`<span class="hljs-comment"># Install optimum-tpu with PyTorch/XLA support</span>
pip install optimum-tpu -f https://storage.googleapis.com/libtpu-releases/index.html

<span class="hljs-comment"># Install additional training dependencies</span>
pip install transformers datasets accelerate trl peft evaluate`,wrap:!1}}),$=new Q({props:{title:"Understanding FSDP for TPU Training",local:"understanding-fsdp-for-tpu-training",headingTag:"h2"}}),Z=new Q({props:{title:"How to Setup FSDP",local:"how-to-setup-fsdp",headingTag:"h2"}}),_=new Y({props:{code:"JTJCZnJvbSUyMG9wdGltdW0udHB1JTIwaW1wb3J0JTIwZnNkcF92MiUwQSUyQmZzZHBfdjIudXNlX2ZzZHBfdjIoKSUwQSUyQmZzZHBfdHJhaW5pbmdfYXJncyUyMCUzRCUyMGZzZHBfdjIuZ2V0X2ZzZHBfdHJhaW5pbmdfYXJncyhtb2RlbCk=",highlighted:`<span class="hljs-addition">+from optimum.tpu import fsdp_v2</span>
<span class="hljs-addition">+fsdp_v2.use_fsdp_v2()</span>
<span class="hljs-addition">+fsdp_training_args = fsdp_v2.get_fsdp_training_args(model)</span>`,wrap:!1}}),k=new Y({props:{code:"dHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFsb2FkZXJfZHJvcF9sYXN0JTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMFJlcXVpcmVkJTIwZm9yJTIwRlNEUHYyJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipmc2RwX3RyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`trainer = SFTTrainer(
    model=model,
    train_dataset=dataset,
    args=TrainingArguments(
        ...
<span class="hljs-addition">+       dataloader_drop_last=True,  # Required for FSDPv2</span>
<span class="hljs-addition">+       **fsdp_training_args,</span>
    ),
    ...
)`,wrap:!1}}),W=new Q({props:{title:"Complete example",local:"complete-example",headingTag:"h2"}}),x=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwU0ZUVHJhaW5lciUwQWZyb20lMjBvcHRpbXVtLnRwdSUyMGltcG9ydCUyMGZzZHBfdjIlMEElMEElMjMlMjBFbmFibGUlMjBGU0RQdjIlMjBmb3IlMjBUUFUlMEFmc2RwX3YyLnVzZV9mc2RwX3YyKCklMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMjBhbmQlMjBkYXRhc2V0JTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZnZW1tYS0yYiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnRhdHN1LWxhYiUyRmFscGFjYSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lNUIlM0ExMDAwJTVEJTIyKSUwQSUwQSUyMyUyMEdldCUyMEZTRFAlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUwQWZzZHBfdHJhaW5pbmdfYXJncyUyMCUzRCUyMGZzZHBfdjIuZ2V0X2ZzZHBfdHJhaW5pbmdfYXJncyhtb2RlbCklMEElMEElMjMlMjBDcmVhdGUlMjB0cmFpbmVyJTIwd2l0aCUyMG1pbmltYWwlMjBjb25maWd1cmF0aW9uJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGb3V0cHV0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YWxvYWRlcl9kcm9wX2xhc3QlM0RUcnVlJTJDJTIwJTIwJTIzJTIwUmVxdWlyZWQlMjBmb3IlMjBGU0RQdjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKmZzZHBfdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwciUzRDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmtfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEEpJTBBJTBBJTIzJTIwU3RhcnQlMjB0cmFpbmluZyUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, TrainingArguments
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> optimum.tpu <span class="hljs-keyword">import</span> fsdp_v2

<span class="hljs-comment"># Enable FSDPv2 for TPU</span>
fsdp_v2.use_fsdp_v2()

<span class="hljs-comment"># Load model and dataset</span>
model_id = <span class="hljs-string">&quot;google/gemma-2b&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16)
dataset = load_dataset(<span class="hljs-string">&quot;tatsu-lab/alpaca&quot;</span>, split=<span class="hljs-string">&quot;train[:1000]&quot;</span>)

<span class="hljs-comment"># Get FSDP training arguments</span>
fsdp_training_args = fsdp_v2.get_fsdp_training_args(model)

<span class="hljs-comment"># Create trainer with minimal configuration</span>
trainer = SFTTrainer(
    model=model,
    train_dataset=dataset,
    args=TrainingArguments(
        output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
        dataloader_drop_last=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Required for FSDPv2</span>
        **fsdp_training_args,
    ),
    peft_config=LoraConfig(
        r=<span class="hljs-number">8</span>,
        target_modules=[<span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
        task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    ),
)

<span class="hljs-comment"># Start training</span>
trainer.train()`,wrap:!1}}),H=new Y({props:{code:"cHl0aG9uJTIwdHJhaW4ucHk=",highlighted:'<span class="hljs-keyword">python</span> train.<span class="hljs-keyword">py</span>',wrap:!1}}),P=new Q({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),{c(){f=i("meta"),A=s(),V=i("p"),L=s(),m(U.$$.fragment),D=s(),w=i("p"),w.innerHTML=jt,N=s(),m(T.$$.fragment),q=s(),J=i("p"),J.innerHTML=$t,K=s(),m(c.$$.fragment),O=s(),h=i("p"),h.textContent=It,tt=s(),m(g.$$.fragment),et=s(),C=i("p"),C.textContent=bt,lt=s(),m(j.$$.fragment),nt=s(),m($.$$.fragment),st=s(),I=i("p"),I.textContent=vt,at=s(),b=i("ol"),b.innerHTML=Zt,it=s(),v=i("p"),v.innerHTML=Bt,pt=s(),m(Z.$$.fragment),rt=s(),B=i("p"),B.textContent=_t,mt=s(),m(_.$$.fragment),ot=s(),F=i("p"),F.textContent=Ft,dt=s(),m(k.$$.fragment),yt=s(),m(W.$$.fragment),Mt=s(),R=i("p"),R.textContent=kt,ut=s(),m(x.$$.fragment),ft=s(),G=i("p"),G.textContent=Wt,Ut=s(),m(H.$$.fragment),wt=s(),X=i("p"),X.textContent=Rt,Tt=s(),m(P.$$.fragment),Jt=s(),E=i("p"),E.textContent=xt,ct=s(),S=i("ul"),S.innerHTML=Gt,ht=s(),z=i("p"),this.h()},l(t){const e=Vt("svelte-u9bgzb",document.head);f=p(e,"META",{name:!0,content:!0}),e.forEach(l),A=a(t),V=p(t,"P",{}),Ht(V).forEach(l),L=a(t),o(U.$$.fragment,t),D=a(t),w=p(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1o5570l"&&(w.innerHTML=jt),N=a(t),o(T.$$.fragment,t),q=a(t),J=p(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-i434pa"&&(J.innerHTML=$t),K=a(t),o(c.$$.fragment,t),O=a(t),h=p(t,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1rzcys1"&&(h.textContent=It),tt=a(t),o(g.$$.fragment,t),et=a(t),C=p(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-wl0ft4"&&(C.textContent=bt),lt=a(t),o(j.$$.fragment,t),nt=a(t),o($.$$.fragment,t),st=a(t),I=p(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-zviihy"&&(I.textContent=vt),at=a(t),b=p(t,"OL",{"data-svelte-h":!0}),r(b)!=="svelte-1ktjxh9"&&(b.innerHTML=Zt),it=a(t),v=p(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-9gg4vr"&&(v.innerHTML=Bt),pt=a(t),o(Z.$$.fragment,t),rt=a(t),B=p(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-4x0fkp"&&(B.textContent=_t),mt=a(t),o(_.$$.fragment,t),ot=a(t),F=p(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-18ujneh"&&(F.textContent=Ft),dt=a(t),o(k.$$.fragment,t),yt=a(t),o(W.$$.fragment,t),Mt=a(t),R=p(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1ixrxpd"&&(R.textContent=kt),ut=a(t),o(x.$$.fragment,t),ft=a(t),G=p(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-47js6u"&&(G.textContent=Wt),Ut=a(t),o(H.$$.fragment,t),wt=a(t),X=p(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-x8m3su"&&(X.textContent=Rt),Tt=a(t),o(P.$$.fragment,t),Jt=a(t),E=p(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-vba212"&&(E.textContent=xt),ct=a(t),S=p(t,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-16xqjp7"&&(S.innerHTML=Gt),ht=a(t),z=p(t,"P",{}),Ht(z).forEach(l),this.h()},h(){Xt(f,"name","hf:doc:metadata"),Xt(f,"content",Lt)},m(t,e){zt(document.head,f),n(t,A,e),n(t,V,e),n(t,L,e),d(U,t,e),n(t,D,e),n(t,w,e),n(t,N,e),d(T,t,e),n(t,q,e),n(t,J,e),n(t,K,e),d(c,t,e),n(t,O,e),n(t,h,e),n(t,tt,e),d(g,t,e),n(t,et,e),n(t,C,e),n(t,lt,e),d(j,t,e),n(t,nt,e),d($,t,e),n(t,st,e),n(t,I,e),n(t,at,e),n(t,b,e),n(t,it,e),n(t,v,e),n(t,pt,e),d(Z,t,e),n(t,rt,e),n(t,B,e),n(t,mt,e),d(_,t,e),n(t,ot,e),n(t,F,e),n(t,dt,e),d(k,t,e),n(t,yt,e),d(W,t,e),n(t,Mt,e),n(t,R,e),n(t,ut,e),d(x,t,e),n(t,ft,e),n(t,G,e),n(t,Ut,e),d(H,t,e),n(t,wt,e),n(t,X,e),n(t,Tt,e),d(P,t,e),n(t,Jt,e),n(t,E,e),n(t,ct,e),n(t,S,e),n(t,ht,e),n(t,z,e),gt=!0},p:Et,i(t){gt||(y(U.$$.fragment,t),y(T.$$.fragment,t),y(c.$$.fragment,t),y(g.$$.fragment,t),y(j.$$.fragment,t),y($.$$.fragment,t),y(Z.$$.fragment,t),y(_.$$.fragment,t),y(k.$$.fragment,t),y(W.$$.fragment,t),y(x.$$.fragment,t),y(H.$$.fragment,t),y(P.$$.fragment,t),gt=!0)},o(t){M(U.$$.fragment,t),M(T.$$.fragment,t),M(c.$$.fragment,t),M(g.$$.fragment,t),M(j.$$.fragment,t),M($.$$.fragment,t),M(Z.$$.fragment,t),M(_.$$.fragment,t),M(k.$$.fragment,t),M(W.$$.fragment,t),M(x.$$.fragment,t),M(H.$$.fragment,t),M(P.$$.fragment,t),gt=!1},d(t){t&&(l(A),l(V),l(L),l(D),l(w),l(N),l(q),l(J),l(K),l(O),l(h),l(tt),l(et),l(C),l(lt),l(nt),l(st),l(I),l(at),l(b),l(it),l(v),l(pt),l(rt),l(B),l(mt),l(ot),l(F),l(dt),l(yt),l(Mt),l(R),l(ut),l(ft),l(G),l(Ut),l(wt),l(X),l(Tt),l(Jt),l(E),l(ct),l(S),l(ht),l(z)),l(f),u(U,t),u(T,t),u(c,t),u(g,t),u(j,t),u($,t),u(Z,t),u(_,t),u(k,t),u(W,t),u(x,t),u(H,t),u(P,t)}}}const Lt='{"title":"First TPU Training on Google Cloud","local":"first-tpu-training-on-google-cloud","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Environment Setup","local":"environment-setup","sections":[],"depth":2},{"title":"Understanding FSDP for TPU Training","local":"understanding-fsdp-for-tpu-training","sections":[],"depth":2},{"title":"How to Setup FSDP","local":"how-to-setup-fsdp","sections":[],"depth":2},{"title":"Complete example","local":"complete-example","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Dt(Ct){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class te extends Qt{constructor(f){super(),Yt(this,f,Dt,At,Pt,{})}}export{te as component};
