import{s as yn,n as wn,o as qn}from"../chunks/scheduler.5f3e6389.js";import{S as On,i as $n,e as a,s as n,c as l,h as Tn,a as r,d as i,b as o,f as x,g as d,j as u,k as b,l as t,m,n as c,t as p,o as g,p as f}from"../chunks/index.373ab25c.js";import{C as Nn,H as Pe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d7da809c.js";import{D as z}from"../chunks/Docstring.e1c1900d.js";function Qn(Kt){let T,Ee,We,Ve,V,Re,R,Xe,X,Jt="The configuration classes are the way to specify how a task should be done. There are two tasks supported with the ONNX Runtime package:",He,H,Yt='<li><p>Optimization: Performed by the <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a>, this task can be tweaked using an <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.OptimizationConfig">OptimizationConfig</a>.</p></li> <li><p>Quantization: Performed by the <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a>, quantization can be set using a <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a>. A calibration step is required in some cases (post training static quantization), which can be specified using a <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.CalibrationConfig">CalibrationConfig</a>.</p></li>',Se,S,Ue,q,U,_t,pe,Zt=`OptimizationConfig is the configuration class handling all the ONNX Runtime optimization parameters.
There are two stacks of optimizations:`,ht,ge,en="<li>The ONNX Runtime general-purpose optimization tool: it can work on any ONNX model.</li> <li>The ONNX Runtime transformers optimization tool: it can only work on a subset of transformers models.</li>",Be,_,B,xt,fe,tn="Factory to create common <code>OptimizationConfig</code>.",bt,k,G,zt,_e,nn="Creates an O1 <code>~OptimizationConfig</code>.",vt,F,j,Ct,he,on="Creates an O2 <code>~OptimizationConfig</code>.",yt,L,K,wt,xe,an="Creates an O3 <code>~OptimizationConfig</code>.",qt,D,J,Ot,be,rn="Creates an O4 <code>~OptimizationConfig</code>.",$t,M,Y,Tt,ze,sn="Creates an <code>~OptimizationConfig</code> with pre-defined arguments according to an optimization level.",Ge,Z,je,N,ee,Nt,ve,mn="QuantizationConfig is the configuration class handling all the ONNX Runtime quantization parameters.",Ke,te,Je,h,ne,Qt,P,oe,At,Ce,un='Creates a <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for ARM64.',kt,W,ie,Ft,ye,ln='Creates a <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX2 instruction set.',Lt,I,ae,Dt,we,dn='Creates a <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX512 instruction set.',Mt,v,re,Pt,qe,cn='Creates a <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for CPU with AVX512-VNNI instruction set.',Wt,Oe,pn=`When targeting Intel AVX512-VNNI CPU underlying execution engine leverage the CPU instruction VPDPBUSD to
compute  \\i32 += i8(w) * u8(x)\\ within a single instruction.`,It,$e,gn=`AVX512-VNNI (AVX512 Vector Neural Network Instruction)
is an x86 extension Instruction set and is a part of the AVX-512 ISA.`,Et,Te,fn="AVX512 VNNI is designed to accelerate convolutional neural network for INT8 inference.",Vt,C,se,Rt,Ne,_n='Creates a <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for ppc64le.',Xt,Qe,hn=`When targeting IBM POWER10 ppc64le, the underlying execution engine leverages 8-bit outer-product instructions
(e.g., xvi8ger4pp and signed/unsigned variants) to compute fused byte dot-products and accumulate into 32-bit results, i.e.,
i32 += i8(w) * u8(x) at 4-way granularity per output element within a single instruction using a 512-bit MMA accumulator.`,Ht,Ae,xn=`MMA (Matrix-Multiply Assist) is a POWER10 extension of the Power ISA and is part of the Power ISA v3.1 specification,
exposed via VSX-backed 512-bit accumulators and compiler intrinsics.`,St,ke,bn=`POWER10 MMA 8-bit outer-product instructions are designed to accelerate INT8 inference on ppc64le by fusing
multiply-accumulate data paths and minimizing instruction count.`,Ut,E,me,Bt,Fe,zn='Creates a <a href="/docs/optimum/pr_85/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.QuantizationConfig">QuantizationConfig</a> fit for TensorRT static quantization, targeting NVIDIA GPUs.',Ye,ue,Ze,Q,le,Gt,Le,vn=`CalibrationConfig is the configuration class handling all the ONNX Runtime parameters related to the calibration
step of static quantization.`,et,de,tt,A,ce,jt,De,Cn=`ORTConfig is the configuration class handling all the ONNX Runtime parameters related to the ONNX IR model export,
optimization and quantization parameters.`,nt,Ie,ot;return V=new Nn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),R=new Pe({props:{title:"Configuration",local:"configuration",headingTag:"h1"}}),S=new Pe({props:{title:"OptimizationConfig",local:"optimum.onnxruntime.OptimizationConfig",headingTag:"h2"}}),U=new z({props:{name:"class optimum.onnxruntime.OptimizationConfig",anchor:"optimum.onnxruntime.OptimizationConfig",parameters:[{name:"optimization_level",val:": int = 1"},{name:"enable_transformers_specific_optimizations",val:": bool = True"},{name:"optimize_for_gpu",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"disable_gelu_fusion",val:": bool = False"},{name:"disable_attention_fusion",val:": bool = False"},{name:"disable_bias_gelu_fusion",val:": bool = False"},{name:"disable_layer_norm_fusion",val:": bool = False"},{name:"disable_rotary_embeddings",val:": bool = False"},{name:"disable_skip_layer_norm_fusion",val:": bool = False"},{name:"disable_bias_skip_layer_norm_fusion",val:": bool = False"},{name:"disable_skip_group_norm_fusion",val:": bool = False"},{name:"disable_bias_splitgelu_fusion",val:": bool = False"},{name:"disable_bias_add_fusion",val:": bool = False"},{name:"disable_group_norm_fusion",val:": bool = True"},{name:"disable_embed_layer_norm_fusion",val:": bool = True"},{name:"enable_gemm_fast_gelu_fusion",val:": bool = False"},{name:"use_mask_index",val:": bool = False"},{name:"disable_packed_kv",val:": bool = True"},{name:"no_attention_mask",val:": bool = False"},{name:"use_raw_attention_mask",val:": bool = False"},{name:"disable_shape_inference",val:": bool = False"},{name:"use_multi_head_attention",val:": bool = False"},{name:"enable_gelu_approximation",val:": bool = False"},{name:"use_group_norm_channels_first",val:": bool = False"},{name:"disable_packed_qkv",val:": bool = False"},{name:"disable_nhwc_conv",val:": bool = False"}],parametersDescription:[{anchor:"optimum.onnxruntime.OptimizationConfig.optimization_level",description:`<strong>optimization_level</strong> (<code>int</code>, defaults to 1) &#x2014;
Optimization level performed by ONNX Runtime of the loaded graph.
Supported optimization level are 0, 1, 2 and 99.
<ul>
<li>0: will disable all optimizations</li>
<li>1: will enable basic optimizations</li>
<li>2: will enable basic and extended optimizations, including complex node fusions applied to the nodes
assigned to the CPU or CUDA execution provider, making the resulting optimized graph hardware dependent</li>
<li>99: will enable all available optimizations including layout optimizations</li>
</ul>`,name:"optimization_level"},{anchor:"optimum.onnxruntime.OptimizationConfig.optimize_for_gpu",description:`<strong>optimize_for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to optimize the model for GPU inference.
The optimized graph might contain operators for GPU or CPU only when <code>optimization_level</code> &gt; 1.`,name:"optimize_for_gpu"},{anchor:"optimum.onnxruntime.OptimizationConfig.fp16",description:`<strong>fp16</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether all weights and nodes should be converted from float32 to float16.`,name:"fp16"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_transformers_specific_optimizations",description:`<strong>enable_transformers_specific_optimizations</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to only use <code>transformers</code> specific optimizations on top of ONNX Runtime general optimizations.`,name:"enable_transformers_specific_optimizations"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_gelu_fusion",description:`<strong>disable_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable the Gelu fusion.`,name:"disable_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_layer_norm_fusion",description:`<strong>disable_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Layer Normalization fusion.`,name:"disable_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_attention_fusion",description:`<strong>disable_attention_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Attention fusion.`,name:"disable_attention_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_skip_layer_norm_fusion",description:`<strong>disable_skip_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable SkipLayerNormalization fusion.`,name:"disable_skip_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_bias_skip_layer_norm_fusion",description:`<strong>disable_bias_skip_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Add Bias and SkipLayerNormalization fusion.`,name:"disable_bias_skip_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_bias_gelu_fusion",description:`<strong>disable_bias_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Add Bias and Gelu / FastGelu fusion.`,name:"disable_bias_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_embed_layer_norm_fusion",description:`<strong>disable_embed_layer_norm_fusion</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to disable EmbedLayerNormalization fusion.
The default value is set to <code>True</code> since this fusion is incompatible with ONNX Runtime quantization.`,name:"disable_embed_layer_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_gelu_approximation",description:`<strong>enable_gelu_approximation</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to enable Gelu / BiasGelu to FastGelu conversion.
The default value is set to <code>False</code> since this approximation might slightly impact the model&#x2019;s accuracy.`,name:"enable_gelu_approximation"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_mask_index",description:`<strong>use_mask_index</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use mask index instead of raw attention mask in the attention operator.`,name:"use_mask_index"},{anchor:"optimum.onnxruntime.OptimizationConfig.no_attention_mask",description:`<strong>no_attention_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to not use attention masks. Only works for bert model type.`,name:"no_attention_mask"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_embed_layer_norm",description:`<strong>disable_embed_layer_norm</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to disable EmbedLayerNormalization fusion.
The default value is set to <code>True</code> since this fusion is incompatible with ONNX Runtime quantization`,name:"disable_embed_layer_norm"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_shape_inference",description:`<strong>disable_shape_inference</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable symbolic shape inference.
The default value is set to <code>False</code> but symbolic shape inference might cause issues sometimes.`,name:"disable_shape_inference"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_multi_head_attention",description:`<strong>use_multi_head_attention</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Experimental argument. Use MultiHeadAttention instead of Attention operator, which has merged weights for Q/K/V projection,
which might be faster in some cases since 3 MatMul is merged into one.&#x201D;
&#x201C;Note that MultiHeadAttention might be slower than Attention when qkv are not packed. &#x201D;`,name:"use_multi_head_attention"},{anchor:"optimum.onnxruntime.OptimizationConfig.enable_gemm_fast_gelu_fusion",description:`<strong>enable_gemm_fast_gelu_fusion</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Enable GemmfastGelu fusion.`,name:"enable_gemm_fast_gelu_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.use_raw_attention_mask",description:`<strong>use_raw_attention_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Use raw attention mask. Use this option if your input is not right-side padding. This might deactivate fused attention and get worse performance.`,name:"use_raw_attention_mask"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_group_norm_fusion",description:`<strong>disable_group_norm_fusion</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Do not fuse GroupNorm. Only works for model_type=unet.`,name:"disable_group_norm_fusion"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_packed_kv",description:`<strong>disable_packed_kv</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Do not use packed kv in cross attention. Only works for model_type=unet.`,name:"disable_packed_kv"},{anchor:"optimum.onnxruntime.OptimizationConfig.disable_rotary_embeddings",description:`<strong>disable_rotary_embeddings</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable Rotary Embedding fusion.`,name:"disable_rotary_embeddings"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L709"}}),B=new z({props:{name:"class optimum.onnxruntime.AutoOptimizationConfig",anchor:"optimum.onnxruntime.AutoOptimizationConfig",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L823"}}),G=new z({props:{name:"O1",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O1.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L880",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O1 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),j=new z({props:{name:"O2",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O2.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L896",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O2 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),K=new z({props:{name:"O3",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3",parameters:[{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O3.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L912",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O3 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),J=new z({props:{name:"O4",anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4",parameters:[{name:"for_gpu",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.O4.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L928",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the O4 optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),Y=new z({props:{name:"with_optimization_level",anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level",parameters:[{name:"optimization_level",val:": str"},{name:"for_gpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.optimization_level",description:`<strong>optimization_level</strong> (<code>str</code>) &#x2014;
The optimization level, the following values are allowed:
<ul>
<li>O1: Basic general optimizations</li>
<li>O2: Basic and extended general optimizations, transformers-specific fusions.</li>
<li>O3: Same as O2 with Fast Gelu approximation.</li>
<li>O4: Same as O3 with mixed precision.</li>
</ul>`,name:"optimization_level"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.for_gpu",description:`<strong>for_gpu</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether the model to optimize will run on GPU, some optimizations depends on the hardware the model
will run on. Only needed for optimization_level &gt; 1.`,name:"for_gpu"},{anchor:"optimum.onnxruntime.AutoOptimizationConfig.with_optimization_level.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Arguments to provide to the <code>~OptimizationConfig</code> constructor.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L848",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>OptimizationConfig</code> corresponding to the requested optimization level.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>OptimizationConfig</code></p>
`}}),Z=new Pe({props:{title:"QuantizationConfig",local:"optimum.onnxruntime.QuantizationConfig",headingTag:"h2"}}),ee=new z({props:{name:"class optimum.onnxruntime.QuantizationConfig",anchor:"optimum.onnxruntime.QuantizationConfig",parameters:[{name:"is_static",val:": bool"},{name:"format",val:": QuantFormat"},{name:"mode",val:": QuantizationMode = <QuantizationMode.QLinearOps: 1>"},{name:"activations_dtype",val:": QuantType = <QuantType.QUInt8: 1>"},{name:"activations_symmetric",val:": bool = False"},{name:"weights_dtype",val:": QuantType = <QuantType.QInt8: 0>"},{name:"weights_symmetric",val:": bool = True"},{name:"per_channel",val:": bool = False"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": list[str] = <factory>"},{name:"nodes_to_exclude",val:": list[str] = <factory>"},{name:"operators_to_quantize",val:": list[str] = <factory>"},{name:"qdq_add_pair_to_weight",val:": bool = False"},{name:"qdq_dedicated_pair",val:": bool = False"},{name:"qdq_op_type_per_channel_support_to_axis",val:": dict[str, int] = <factory>"}],parametersDescription:[{anchor:"optimum.onnxruntime.QuantizationConfig.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Whether to apply static quantization or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.QuantizationConfig.format",description:`<strong>format</strong> (<code>QuantFormat</code>) &#x2014;
Targeted ONNX Runtime quantization representation format.
For the Operator Oriented (QOperator) format, all the quantized operators have their own ONNX definitions.
For the Tensor Oriented (QDQ) format, the model is quantized by inserting QuantizeLinear / DeQuantizeLinear
operators.`,name:"format"},{anchor:"optimum.onnxruntime.QuantizationConfig.mode",description:`<strong>mode</strong> (<code>QuantizationMode</code>, defaults to <code>QuantizationMode.QLinearOps</code>) &#x2014;
Targeted ONNX Runtime quantization mode, default is QLinearOps to match QDQ format.
When targeting dynamic quantization mode, the default value is <code>QuantizationMode.IntegerOps</code> whereas the
default value for static quantization mode is <code>QuantizationMode.QLinearOps</code>.`,name:"mode"},{anchor:"optimum.onnxruntime.QuantizationConfig.activations_dtype",description:`<strong>activations_dtype</strong> (<code>QuantType</code>, defaults to <code>QuantType.QUInt8</code>) &#x2014;
The quantization data types to use for the activations.`,name:"activations_dtype"},{anchor:"optimum.onnxruntime.QuantizationConfig.activations_symmetric",description:`<strong>activations_symmetric</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to apply symmetric quantization on the activations.`,name:"activations_symmetric"},{anchor:"optimum.onnxruntime.QuantizationConfig.weights_dtype",description:`<strong>weights_dtype</strong> (<code>QuantType</code>, defaults to <code>QuantType.QInt8</code>) &#x2014;
The quantization data types to use for the weights.`,name:"weights_dtype"},{anchor:"optimum.onnxruntime.QuantizationConfig.weights_symmetric",description:`<strong>weights_symmetric</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to apply symmetric quantization on the weights.`,name:"weights_symmetric"},{anchor:"optimum.onnxruntime.QuantizationConfig.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can increase overall
accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.QuantizationConfig.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use reduce-range 7-bits integers instead of 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.QuantizationConfig.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>List[str]</code>, defaults to <code>[]</code>) &#x2014;
List of the nodes names to quantize. When unspecified, all nodes will be quantized. If empty, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.QuantizationConfig.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>List[str]</code>, defaults to <code>[]</code>) &#x2014;
List of the nodes names to exclude when applying quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.QuantizationConfig.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>List[str]</code>) &#x2014;
List of the operators types to quantize. Defaults to all quantizable operators for the given quantization mode and format. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_add_pair_to_weight",description:`<strong>qdq_add_pair_to_weight</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
By default, floating-point weights are quantized and feed to solely inserted DeQuantizeLinear node.
If set to True, the floating-point weights will remain and both QuantizeLinear / DeQuantizeLinear nodes
will be inserted.`,name:"qdq_add_pair_to_weight"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_dedicated_pair",description:`<strong>qdq_dedicated_pair</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
When inserting QDQ pair, multiple nodes can share a single QDQ pair as their inputs. If True, it will
create an identical and dedicated QDQ pair for each node.`,name:"qdq_dedicated_pair"},{anchor:"optimum.onnxruntime.QuantizationConfig.qdq_op_type_per_channel_support_to_axis",description:`<strong>qdq_op_type_per_channel_support_to_axis</strong> (<code>Dict[str, int]</code>) &#x2014;
Set the channel axis for a specific operator type. Effective only when per channel quantization is
supported and <code>per_channel</code> is set to True.`,name:"qdq_op_type_per_channel_support_to_axis"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L225"}}),te=new Pe({props:{title:"AutoQuantizationConfig",local:"optimum.onnxruntime.AutoQuantizationConfig",headingTag:"h2"}}),ne=new z({props:{name:"class optimum.onnxruntime.AutoQuantizationConfig",anchor:"optimum.onnxruntime.AutoQuantizationConfig",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L388"}}),oe=new z({props:{name:"arm64",anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.arm64.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L389"}}),ie=new z({props:{name:"avx2",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Indicate whether to use 8-bits integers (False) or reduce-range 7-bits integers (True).
As a baseline, it is always recommended testing with full range (reduce_range = False) and then, if
accuracy drop is significant, to try with reduced range (reduce_range = True).
Intel&#x2019;s CPUs using AVX512 (non VNNI) can suffer from saturation issue when invoking
the VPMADDUBSW instruction. To counter this, one should use 7-bits rather than 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx2.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L439"}}),ae=new z({props:{name:"avx512",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"reduce_range",val:": bool = False"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.reduce_range",description:`<strong>reduce_range</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Indicate whether to use 8-bits integers (False) or reduce-range 7-bits integers (True).
As a baseline, it is always recommended testing with full range (reduce_range = False) and then, if
accuracy drop is significant, to try with reduced range (reduce_range = True).
Intel&#x2019;s CPUs using AVX512 (non VNNI) can suffer from saturation issue when invoking
the VPMADDUBSW instruction. To counter this, one should use 7-bits rather than 8-bits integers.`,name:"reduce_range"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L494"}}),re=new z({props:{name:"avx512_vnni",anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.avx512_vnni.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L549"}}),se=new z({props:{name:"ppc64le",anchor:"optimum.onnxruntime.AutoQuantizationConfig.ppc64le",parameters:[{name:"is_static",val:": bool"},{name:"use_symmetric_activations",val:": bool = False"},{name:"use_symmetric_weights",val:": bool = True"},{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.ppc64le.is_static",description:`<strong>is_static</strong> (<code>bool</code>) &#x2014;
Boolean flag to indicate whether we target static or dynamic quantization.`,name:"is_static"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.ppc64le.use_symmetric_activations",description:`<strong>use_symmetric_activations</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use symmetric quantization for activations.`,name:"use_symmetric_activations"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.ppc64le.use_symmetric_weights",description:`<strong>use_symmetric_weights</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use symmetric quantization for weights.`,name:"use_symmetric_weights"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.ppc64le.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.ppc64le.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.ppc64le.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.ppc64le.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L605"}}),me=new z({props:{name:"tensorrt",anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt",parameters:[{name:"per_channel",val:": bool = True"},{name:"nodes_to_quantize",val:": list[str] | None = None"},{name:"nodes_to_exclude",val:": list[str] | None = None"},{name:"operators_to_quantize",val:": list[str] | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.per_channel",description:`<strong>per_channel</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether we should quantize per-channel (also known as &#x201C;per-row&#x201D;). Enabling this can
increase overall accuracy while making the quantized model heavier.`,name:"per_channel"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.nodes_to_quantize",description:`<strong>nodes_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to quantize. If <code>None</code>, all nodes being operators from <code>operators_to_quantize</code> will be quantized.`,name:"nodes_to_quantize"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.nodes_to_exclude",description:`<strong>nodes_to_exclude</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Specific nodes to exclude from quantization. The list of nodes in a model can be found loading the ONNX model through onnx.load, or through visual inspection with <a href="https://github.com/lutzroeder/netron" rel="nofollow">netron</a>.`,name:"nodes_to_exclude"},{anchor:"optimum.onnxruntime.AutoQuantizationConfig.tensorrt.operators_to_quantize",description:`<strong>operators_to_quantize</strong> (<code>Optional[List[str]]</code>, defaults to <code>None</code>) &#x2014;
Type of nodes to perform quantization on. By default, all the quantizable operators will be quantized. Quantizable operators can be found at <a href="https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py" rel="nofollow">https://github.com/microsoft/onnxruntime/blob/main/onnxruntime/python/tools/quantization/registry.py</a>.`,name:"operators_to_quantize"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L663"}}),ue=new Pe({props:{title:"CalibrationConfig",local:"optimum.onnxruntime.CalibrationConfig",headingTag:"h3"}}),le=new z({props:{name:"class optimum.onnxruntime.CalibrationConfig",anchor:"optimum.onnxruntime.CalibrationConfig",parameters:[{name:"dataset_name",val:": str"},{name:"dataset_config_name",val:": str"},{name:"dataset_split",val:": str"},{name:"dataset_num_samples",val:": int"},{name:"method",val:": CalibrationMethod"},{name:"num_bins",val:": int | None = None"},{name:"num_quantized_bins",val:": int | None = None"},{name:"percentile",val:": float | None = None"},{name:"moving_average",val:": bool | None = None"},{name:"averaging_constant",val:": float | None = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>) &#x2014;
The name of the calibration dataset.`,name:"dataset_name"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_config_name",description:`<strong>dataset_config_name</strong> (<code>str</code>) &#x2014;
The name of the calibration dataset configuration.`,name:"dataset_config_name"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_split",description:`<strong>dataset_split</strong> (<code>str</code>) &#x2014;
Which split of the dataset is used to perform the calibration step.`,name:"dataset_split"},{anchor:"optimum.onnxruntime.CalibrationConfig.dataset_num_samples",description:`<strong>dataset_num_samples</strong> (<code>int</code>) &#x2014;
The number of samples composing the calibration dataset.`,name:"dataset_num_samples"},{anchor:"optimum.onnxruntime.CalibrationConfig.method",description:`<strong>method</strong> (<code>CalibrationMethod</code>) &#x2014;
The method chosen to calculate the activations quantization parameters using the calibration dataset.`,name:"method"},{anchor:"optimum.onnxruntime.CalibrationConfig.num_bins",description:`<strong>num_bins</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
The number of bins to use when creating the histogram when performing the calibration step using the
Percentile or Entropy method.`,name:"num_bins"},{anchor:"optimum.onnxruntime.CalibrationConfig.num_quantized_bins",description:`<strong>num_quantized_bins</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
The number of quantized bins to use when performing the calibration step using the Entropy method.`,name:"num_quantized_bins"},{anchor:"optimum.onnxruntime.CalibrationConfig.percentile",description:`<strong>percentile</strong> (<code>Optional[float]</code>, defaults to <code>None</code>) &#x2014;
The percentile to use when computing the activations quantization ranges when performing the calibration
step using the Percentile method.`,name:"percentile"},{anchor:"optimum.onnxruntime.CalibrationConfig.moving_average",description:`<strong>moving_average</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to compute the moving average of the minimum and maximum values when performing the calibration step
using the MinMax method.`,name:"moving_average"},{anchor:"optimum.onnxruntime.CalibrationConfig.averaging_constant",description:`<strong>averaging_constant</strong> (<code>Optional[float]</code>, defaults to <code>None</code>) &#x2014;
The constant smoothing factor to use when computing the moving average of the minimum and maximum values.
Effective only when the MinMax calibration method is selected and <code>moving_average</code> is set to True.`,name:"averaging_constant"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L52"}}),de=new Pe({props:{title:"ORTConfig",local:"optimum.onnxruntime.ORTConfig",headingTag:"h2"}}),ce=new z({props:{name:"class optimum.onnxruntime.ORTConfig",anchor:"optimum.onnxruntime.ORTConfig",parameters:[{name:"opset",val:": int | None = None"},{name:"use_external_data_format",val:": bool = False"},{name:"one_external_file",val:": bool = True"},{name:"optimization",val:": OptimizationConfig | None = None"},{name:"quantization",val:": QuantizationConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTConfig.opset",description:`<strong>opset</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
ONNX opset version to export the model with.`,name:"opset"},{anchor:"optimum.onnxruntime.ORTConfig.use_external_data_format",description:`<strong>use_external_data_format</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Allow exporting model &gt;= than 2Gb.`,name:"use_external_data_format"},{anchor:"optimum.onnxruntime.ORTConfig.one_external_file",description:`<strong>one_external_file</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
When <code>use_external_data_format=True</code>, whether to save all tensors to one external file.
If false, save each tensor to a file named with the tensor name.
(Can not be set to <code>False</code> for the quantization)`,name:"one_external_file"},{anchor:"optimum.onnxruntime.ORTConfig.optimization",description:`<strong>optimization</strong> (<code>Optional[OptimizationConfig]</code>, defaults to <code>None</code>) &#x2014;
Specify a configuration to optimize ONNX Runtime model`,name:"optimization"},{anchor:"optimum.onnxruntime.ORTConfig.quantization",description:`<strong>quantization</strong> (<code>Optional[QuantizationConfig]</code>, defaults to <code>None</code>) &#x2014;
Specify a configuration to quantize ONNX Runtime model`,name:"quantization"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_85/optimum/onnxruntime/configuration.py#L945"}}),{c(){T=a("meta"),Ee=n(),We=a("p"),Ve=n(),l(V.$$.fragment),Re=n(),l(R.$$.fragment),Xe=n(),X=a("p"),X.textContent=Jt,He=n(),H=a("ol"),H.innerHTML=Yt,Se=n(),l(S.$$.fragment),Ue=n(),q=a("div"),l(U.$$.fragment),_t=n(),pe=a("p"),pe.textContent=Zt,ht=n(),ge=a("ol"),ge.innerHTML=en,Be=n(),_=a("div"),l(B.$$.fragment),xt=n(),fe=a("p"),fe.innerHTML=tn,bt=n(),k=a("div"),l(G.$$.fragment),zt=n(),_e=a("p"),_e.innerHTML=nn,vt=n(),F=a("div"),l(j.$$.fragment),Ct=n(),he=a("p"),he.innerHTML=on,yt=n(),L=a("div"),l(K.$$.fragment),wt=n(),xe=a("p"),xe.innerHTML=an,qt=n(),D=a("div"),l(J.$$.fragment),Ot=n(),be=a("p"),be.innerHTML=rn,$t=n(),M=a("div"),l(Y.$$.fragment),Tt=n(),ze=a("p"),ze.innerHTML=sn,Ge=n(),l(Z.$$.fragment),je=n(),N=a("div"),l(ee.$$.fragment),Nt=n(),ve=a("p"),ve.textContent=mn,Ke=n(),l(te.$$.fragment),Je=n(),h=a("div"),l(ne.$$.fragment),Qt=n(),P=a("div"),l(oe.$$.fragment),At=n(),Ce=a("p"),Ce.innerHTML=un,kt=n(),W=a("div"),l(ie.$$.fragment),Ft=n(),ye=a("p"),ye.innerHTML=ln,Lt=n(),I=a("div"),l(ae.$$.fragment),Dt=n(),we=a("p"),we.innerHTML=dn,Mt=n(),v=a("div"),l(re.$$.fragment),Pt=n(),qe=a("p"),qe.innerHTML=cn,Wt=n(),Oe=a("p"),Oe.textContent=pn,It=n(),$e=a("p"),$e.textContent=gn,Et=n(),Te=a("p"),Te.textContent=fn,Vt=n(),C=a("div"),l(se.$$.fragment),Rt=n(),Ne=a("p"),Ne.innerHTML=_n,Xt=n(),Qe=a("p"),Qe.textContent=hn,Ht=n(),Ae=a("p"),Ae.textContent=xn,St=n(),ke=a("p"),ke.textContent=bn,Ut=n(),E=a("div"),l(me.$$.fragment),Bt=n(),Fe=a("p"),Fe.innerHTML=zn,Ye=n(),l(ue.$$.fragment),Ze=n(),Q=a("div"),l(le.$$.fragment),Gt=n(),Le=a("p"),Le.textContent=vn,et=n(),l(de.$$.fragment),tt=n(),A=a("div"),l(ce.$$.fragment),jt=n(),De=a("p"),De.textContent=Cn,nt=n(),Ie=a("p"),this.h()},l(e){const s=Tn("svelte-u9bgzb",document.head);T=r(s,"META",{name:!0,content:!0}),s.forEach(i),Ee=o(e),We=r(e,"P",{}),x(We).forEach(i),Ve=o(e),d(V.$$.fragment,e),Re=o(e),d(R.$$.fragment,e),Xe=o(e),X=r(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1shhltv"&&(X.textContent=Jt),He=o(e),H=r(e,"OL",{"data-svelte-h":!0}),u(H)!=="svelte-1g3pkwt"&&(H.innerHTML=Yt),Se=o(e),d(S.$$.fragment,e),Ue=o(e),q=r(e,"DIV",{class:!0});var Me=x(q);d(U.$$.fragment,Me),_t=o(Me),pe=r(Me,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-kud8lz"&&(pe.textContent=Zt),ht=o(Me),ge=r(Me,"OL",{"data-svelte-h":!0}),u(ge)!=="svelte-1347rzr"&&(ge.innerHTML=en),Me.forEach(i),Be=o(e),_=r(e,"DIV",{class:!0});var y=x(_);d(B.$$.fragment,y),xt=o(y),fe=r(y,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-z99vag"&&(fe.innerHTML=tn),bt=o(y),k=r(y,"DIV",{class:!0});var it=x(k);d(G.$$.fragment,it),zt=o(it),_e=r(it,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-o9g052"&&(_e.innerHTML=nn),it.forEach(i),vt=o(y),F=r(y,"DIV",{class:!0});var at=x(F);d(j.$$.fragment,at),Ct=o(at),he=r(at,"P",{"data-svelte-h":!0}),u(he)!=="svelte-gkopyf"&&(he.innerHTML=on),at.forEach(i),yt=o(y),L=r(y,"DIV",{class:!0});var rt=x(L);d(K.$$.fragment,rt),wt=o(rt),xe=r(rt,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1b21ddg"&&(xe.innerHTML=an),rt.forEach(i),qt=o(y),D=r(y,"DIV",{class:!0});var st=x(D);d(J.$$.fragment,st),Ot=o(st),be=r(st,"P",{"data-svelte-h":!0}),u(be)!=="svelte-mclel1"&&(be.innerHTML=rn),st.forEach(i),$t=o(y),M=r(y,"DIV",{class:!0});var mt=x(M);d(Y.$$.fragment,mt),Tt=o(mt),ze=r(mt,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-cq6eru"&&(ze.innerHTML=sn),mt.forEach(i),y.forEach(i),Ge=o(e),d(Z.$$.fragment,e),je=o(e),N=r(e,"DIV",{class:!0});var ut=x(N);d(ee.$$.fragment,ut),Nt=o(ut),ve=r(ut,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-9xjx81"&&(ve.textContent=mn),ut.forEach(i),Ke=o(e),d(te.$$.fragment,e),Je=o(e),h=r(e,"DIV",{class:!0});var w=x(h);d(ne.$$.fragment,w),Qt=o(w),P=r(w,"DIV",{class:!0});var lt=x(P);d(oe.$$.fragment,lt),At=o(lt),Ce=r(lt,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1x3eqht"&&(Ce.innerHTML=un),lt.forEach(i),kt=o(w),W=r(w,"DIV",{class:!0});var dt=x(W);d(ie.$$.fragment,dt),Ft=o(dt),ye=r(dt,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1l2nhby"&&(ye.innerHTML=ln),dt.forEach(i),Lt=o(w),I=r(w,"DIV",{class:!0});var ct=x(I);d(ae.$$.fragment,ct),Dt=o(ct),we=r(ct,"P",{"data-svelte-h":!0}),u(we)!=="svelte-c50bxk"&&(we.innerHTML=dn),ct.forEach(i),Mt=o(w),v=r(w,"DIV",{class:!0});var O=x(v);d(re.$$.fragment,O),Pt=o(O),qe=r(O,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-v67fay"&&(qe.innerHTML=cn),Wt=o(O),Oe=r(O,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-pb6daa"&&(Oe.textContent=pn),It=o(O),$e=r(O,"P",{"data-svelte-h":!0}),u($e)!=="svelte-167rhrj"&&($e.textContent=gn),Et=o(O),Te=r(O,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-vqsk0u"&&(Te.textContent=fn),O.forEach(i),Vt=o(w),C=r(w,"DIV",{class:!0});var $=x(C);d(se.$$.fragment,$),Rt=o($),Ne=r($,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-1pfsmr5"&&(Ne.innerHTML=_n),Xt=o($),Qe=r($,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-1tqg4il"&&(Qe.textContent=hn),Ht=o($),Ae=r($,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-1ot8zix"&&(Ae.textContent=xn),St=o($),ke=r($,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-1mzhcvc"&&(ke.textContent=bn),$.forEach(i),Ut=o(w),E=r(w,"DIV",{class:!0});var pt=x(E);d(me.$$.fragment,pt),Bt=o(pt),Fe=r(pt,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-2b2keg"&&(Fe.innerHTML=zn),pt.forEach(i),w.forEach(i),Ye=o(e),d(ue.$$.fragment,e),Ze=o(e),Q=r(e,"DIV",{class:!0});var gt=x(Q);d(le.$$.fragment,gt),Gt=o(gt),Le=r(gt,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-12bp9yw"&&(Le.textContent=vn),gt.forEach(i),et=o(e),d(de.$$.fragment,e),tt=o(e),A=r(e,"DIV",{class:!0});var ft=x(A);d(ce.$$.fragment,ft),jt=o(ft),De=r(ft,"P",{"data-svelte-h":!0}),u(De)!=="svelte-10zam97"&&(De.textContent=Cn),ft.forEach(i),nt=o(e),Ie=r(e,"P",{}),x(Ie).forEach(i),this.h()},h(){b(T,"name","hf:doc:metadata"),b(T,"content",An),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,T),m(e,Ee,s),m(e,We,s),m(e,Ve,s),c(V,e,s),m(e,Re,s),c(R,e,s),m(e,Xe,s),m(e,X,s),m(e,He,s),m(e,H,s),m(e,Se,s),c(S,e,s),m(e,Ue,s),m(e,q,s),c(U,q,null),t(q,_t),t(q,pe),t(q,ht),t(q,ge),m(e,Be,s),m(e,_,s),c(B,_,null),t(_,xt),t(_,fe),t(_,bt),t(_,k),c(G,k,null),t(k,zt),t(k,_e),t(_,vt),t(_,F),c(j,F,null),t(F,Ct),t(F,he),t(_,yt),t(_,L),c(K,L,null),t(L,wt),t(L,xe),t(_,qt),t(_,D),c(J,D,null),t(D,Ot),t(D,be),t(_,$t),t(_,M),c(Y,M,null),t(M,Tt),t(M,ze),m(e,Ge,s),c(Z,e,s),m(e,je,s),m(e,N,s),c(ee,N,null),t(N,Nt),t(N,ve),m(e,Ke,s),c(te,e,s),m(e,Je,s),m(e,h,s),c(ne,h,null),t(h,Qt),t(h,P),c(oe,P,null),t(P,At),t(P,Ce),t(h,kt),t(h,W),c(ie,W,null),t(W,Ft),t(W,ye),t(h,Lt),t(h,I),c(ae,I,null),t(I,Dt),t(I,we),t(h,Mt),t(h,v),c(re,v,null),t(v,Pt),t(v,qe),t(v,Wt),t(v,Oe),t(v,It),t(v,$e),t(v,Et),t(v,Te),t(h,Vt),t(h,C),c(se,C,null),t(C,Rt),t(C,Ne),t(C,Xt),t(C,Qe),t(C,Ht),t(C,Ae),t(C,St),t(C,ke),t(h,Ut),t(h,E),c(me,E,null),t(E,Bt),t(E,Fe),m(e,Ye,s),c(ue,e,s),m(e,Ze,s),m(e,Q,s),c(le,Q,null),t(Q,Gt),t(Q,Le),m(e,et,s),c(de,e,s),m(e,tt,s),m(e,A,s),c(ce,A,null),t(A,jt),t(A,De),m(e,nt,s),m(e,Ie,s),ot=!0},p:wn,i(e){ot||(p(V.$$.fragment,e),p(R.$$.fragment,e),p(S.$$.fragment,e),p(U.$$.fragment,e),p(B.$$.fragment,e),p(G.$$.fragment,e),p(j.$$.fragment,e),p(K.$$.fragment,e),p(J.$$.fragment,e),p(Y.$$.fragment,e),p(Z.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(ne.$$.fragment,e),p(oe.$$.fragment,e),p(ie.$$.fragment,e),p(ae.$$.fragment,e),p(re.$$.fragment,e),p(se.$$.fragment,e),p(me.$$.fragment,e),p(ue.$$.fragment,e),p(le.$$.fragment,e),p(de.$$.fragment,e),p(ce.$$.fragment,e),ot=!0)},o(e){g(V.$$.fragment,e),g(R.$$.fragment,e),g(S.$$.fragment,e),g(U.$$.fragment,e),g(B.$$.fragment,e),g(G.$$.fragment,e),g(j.$$.fragment,e),g(K.$$.fragment,e),g(J.$$.fragment,e),g(Y.$$.fragment,e),g(Z.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(ie.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(se.$$.fragment,e),g(me.$$.fragment,e),g(ue.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),ot=!1},d(e){e&&(i(Ee),i(We),i(Ve),i(Re),i(Xe),i(X),i(He),i(H),i(Se),i(Ue),i(q),i(Be),i(_),i(Ge),i(je),i(N),i(Ke),i(Je),i(h),i(Ye),i(Ze),i(Q),i(et),i(tt),i(A),i(nt),i(Ie)),i(T),f(V,e),f(R,e),f(S,e),f(U),f(B),f(G),f(j),f(K),f(J),f(Y),f(Z,e),f(ee),f(te,e),f(ne),f(oe),f(ie),f(ae),f(re),f(se),f(me),f(ue,e),f(le),f(de,e),f(ce)}}}const An='{"title":"Configuration","local":"configuration","sections":[{"title":"OptimizationConfig","local":"optimum.onnxruntime.OptimizationConfig","sections":[],"depth":2},{"title":"QuantizationConfig","local":"optimum.onnxruntime.QuantizationConfig","sections":[],"depth":2},{"title":"AutoQuantizationConfig","local":"optimum.onnxruntime.AutoQuantizationConfig","sections":[{"title":"CalibrationConfig","local":"optimum.onnxruntime.CalibrationConfig","sections":[],"depth":3}],"depth":2},{"title":"ORTConfig","local":"optimum.onnxruntime.ORTConfig","sections":[],"depth":2}],"depth":1}';function kn(Kt){return qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends On{constructor(T){super(),$n(this,T,kn,Qn,yn,{})}}export{Pn as component};
