# Foundations

The Inference Endpoints dashboard is the central interface to manage, monitor, and deploy inference endpoints across
multiple organizations and accounts. Users can switch between organizations, view endpoint statuses, manage quotas, and
access deployment configurations. You can access the dashboard by logging in on [endpoints.huggingface.co](https://endpoints.huggingface.co)

## Managing Endpoints

### Creating New Endpoints
Click the + New button in the top section to create a new endpoint deployment. This will take you to the Model Catalog which
provides access to 100+ pre-configured models available for deployment as inference endpoints. Use this to browse,
filter, and deploy models directly.

![new](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/foundations/1-new.png)

If you cannot find a suitable model in the catalog you can click the "Deploy From Hugging Face" button which allows you to deploy from
any Hugging Face repository.

![catalog](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/foundations/2-catalog.png)

After this you will be directed to the configuration page. You can read [here](./configuration) more in detail about all the configuration options.

### Endpoint States
Endpoints can be in one of several states:
- **Running**: Endpoint is ready to serve requests
- **Initializing**: Endpoint is starting up 
- **Paused**: Endpoint has been stopped, which counts towards your quota
- **Scaled to Zero**: Endpoint is idle and consuming no compute resources
- **Failed**: Endpoint encountered an error and is not operational

### Managing existing endpoints

The endpoint details page provides information and lets you control the configuration of an individual endpoint.
Access this view by clicking on any endpoint from the main endpoints list.

The endpoint name displays with its current state. You can pause a running endpoint or wake up an endpoint scaled to zero.

- **Overview**: Current status and configuration summary
- **Analytics**: Performance metrics and usage statistics, for more in-depth reading please [visit here](./analytics)
- **Logs**: Runtime logs and debugging information, more in-depth docs can be found [here](./logs)
- **Usage & Cost**: Billing information and resource consumption
- **Settings**: Configuration and management options

The page displays the configuration options that are available for each endpoint. You'll find a more in-depth walk-through of all options under
the [configuration section](./configuration)

![endpoint](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/foundations/8-endpoint.png)

## Using the Dashboard

### Viewing Endpoint Information
The endpoints table displays critical information for each deployment. Click Edit Columns to show or hide specific
information columns. Available columns include State, Task, Instance, Vendor, Container, Access, Tags, URL, Created, and Updated timestamps

![list](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/foundations/3-list.png)

### Filtering and Search
Use the search bar to filter endpoints by name, provider, task, or tags.
The Status dropdown allows filtering by specific endpoint states.

![filter](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/foundations/4-filter.png)

### Account Management
Access account settings through the dropdown menu in the top-right corner. This provides access to organization switching,
billing information, and access token management.

![account](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/foundations/5-account.png)

## Quotas
The Quotas section displays your current resource usage and limits across different cloud providers and hardware types.
Access this view to monitor consumption and request additional capacity when needed.

Note that:
- *Paused* endpoints will not count against 'used' quota.
- *Scaled to Zero* endpoints will be counted as 'used' quota—simply pause the scaled-to-zero endpoint if you would like to unlock this quota. 

![quotas](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/foundations/6-quotas.png)

### Requesting Additional Quota
Use the Request More button to submit requests for increased limits when approaching quota thresholds. This allows you to
scale your inference deployments beyond current allocations. Or click the button below:

<a class="btn !rounded-full !text-smd" href="https://endpoints.huggingface.co/contact" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" class="mr-1.5" width="1em" height="1em" fill="currentColor" stroke="currentColor" viewBox="0 0 32 32"><path d="M16 21C14.8449 21.001 13.7075 20.7158 12.6896 20.1697C11.6717 19.6237 10.805 18.8339 10.167 17.871L11.833 16.764C12.2891 17.4517 12.9083 18.0159 13.6353 18.4062C14.3624 18.7964 15.1748 19.0007 16 19.0007C16.8252 19.0007 17.6376 18.7964 18.3647 18.4062C19.0917 18.0159 19.7109 17.4517 20.167 16.764L21.833 17.871C21.195 18.8339 20.3283 19.6237 19.3104 20.1697C18.2925 20.7158 17.1551 21.001 16 21ZM20 10C19.6044 10 19.2178 10.1173 18.8889 10.3371C18.56 10.5568 18.3036 10.8692 18.1522 11.2346C18.0009 11.6001 17.9613 12.0022 18.0384 12.3902C18.1156 12.7782 18.3061 13.1345 18.5858 13.4142C18.8655 13.6939 19.2219 13.8844 19.6098 13.9616C19.9978 14.0388 20.3999 13.9991 20.7654 13.8478C21.1308 13.6964 21.4432 13.44 21.6629 13.1112C21.8827 12.7823 22 12.3956 22 12C22.0027 11.7366 21.9528 11.4754 21.8532 11.2315C21.7536 10.9876 21.6064 10.7661 21.4202 10.5798C21.2339 10.3936 21.0124 10.2464 20.7685 10.1468C20.5247 10.0472 20.2634 9.99734 20 10ZM12 10C11.6044 10 11.2178 10.1173 10.8889 10.3371C10.56 10.5568 10.3036 10.8692 10.1522 11.2346C10.0009 11.6001 9.96126 12.0022 10.0384 12.3902C10.1156 12.7782 10.3061 13.1345 10.5858 13.4142C10.8655 13.6939 11.2219 13.8844 11.6098 13.9616C11.9978 14.0388 12.3999 13.9991 12.7654 13.8478C13.1308 13.6964 13.4432 13.44 13.6629 13.1112C13.8827 12.7823 14 12.3956 14 12C14.0027 11.7366 13.9528 11.4754 13.8532 11.2315C13.7536 10.9876 13.6064 10.7661 13.4202 10.5798C13.2339 10.3936 13.0124 10.2464 12.7685 10.1468C12.5247 10.0472 12.2634 9.99734 12 10Z" stroke-width="0.2"></path><path d="M17.736 32L16 31L20 24H26C26.2628 24.0004 26.523 23.9489 26.7658 23.8486C27.0087 23.7482 27.2293 23.6009 27.4151 23.4151C27.6009 23.2293 27.7482 23.0087 27.8486 22.7658C27.9489 22.523 28.0004 22.2628 28 22V8C28.0004 7.73725 27.9489 7.477 27.8486 7.23417C27.7482 6.99134 27.6009 6.7707 27.4151 6.58491C27.2293 6.39911 27.0087 6.25181 26.7658 6.15144C26.523 6.05107 26.2628 5.9996 26 6H6C5.73725 5.9996 5.477 6.05107 5.23417 6.15144C4.99134 6.25181 4.7707 6.39911 4.58491 6.58491C4.39911 6.7707 4.25181 6.99134 4.15144 7.23417C4.05107 7.477 3.9996 7.73725 4 8V22C3.9996 22.2628 4.05107 22.523 4.15144 22.7658C4.25181 23.0087 4.39911 23.2293 4.58491 23.4151C4.7707 23.6009 4.99134 23.7482 5.23417 23.8486C5.477 23.9489 5.73725 24.0004 6 24H15V26H6C4.93913 26 3.92172 25.5786 3.17157 24.8284C2.42143 24.0783 2 23.0609 2 22V8C2 6.93913 2.42143 5.92172 3.17157 5.17157C3.92172 4.42143 4.93913 4 6 4H26C27.0609 4 28.0783 4.42143 28.8284 5.17157C29.5786 5.92172 30 6.93913 30 8V22C30 23.0609 29.5786 24.0783 28.8284 24.8284C28.0783 25.5786 27.0609 26 26 26H21.165L17.736 32Z" stroke-width="0.2"></path></svg>Request More</a>

## Audit Logs
The Audit Logs section provides a chronological record of all actions performed on your inference endpoints. You can use this
to track changes, troubleshoot issues, and maintain security oversight of your deployments.

Use the All Endpoints dropdown to filter logs by specific endpoint instances. This allows you to focus on activity for particular
deployments.

![audit](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/foundations/7-audit.png)

### Log Entry Structure
Each audit log entry contains:
- **User Avatar and name**
- **Action Type**: Type of operation performed (resumed, updated etc.)
- **Endpoint Name**
- **Timestamp**
- **Action Details**:
    - Instance Changes: For example hardware scaling modifications
    - Configuration Updates: Parameter adjustments
    - State Changes: Operational status modifications
- **Request Metadata**: Technical details for troubleshooting:
    - IP Address: Source IP of the request
    - X-Request-Id: Unique identifier for tracking API calls


<EditOnGithub source="https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/guides/foundations.md" />