import{s as it,o as rt,n as pe}from"../chunks/scheduler.8c3d61f6.js";import{S as pt,i as ot,g as m,s as u,r as M,A as ut,h as d,f as s,c,j as lt,u as g,x as h,k as Re,y as ct,a as n,v as w,d as J,t as T,w as $}from"../chunks/index.da70eac4.js";import{T as Ee}from"../chunks/Tip.1d9b8c37.js";import{C as I}from"../chunks/CodeBlock.00a903b3.js";import{H as xe,E as mt}from"../chunks/EditOnGithub.1e64e623.js";import{H as dt,a as at}from"../chunks/HfOption.c1483eb1.js";function ft(Z){let l,f='We strongly recommend reading PyTorch’s <a href="https://pytorch.org/docs/stable/notes/randomness.html" rel="nofollow">statement about reproducibility</a>:',i,p,r="“Completely reproducible results are not guaranteed across PyTorch releases, individual commits, or different platforms. Furthermore, results may not be reproducible between CPU and GPU executions, even when using identical seeds.”";return{c(){l=m("p"),l.innerHTML=f,i=u(),p=m("p"),p.textContent=r},l(a){l=d(a,"P",{"data-svelte-h":!0}),h(l)!=="svelte-ccpr3c"&&(l.innerHTML=f),i=c(a),p=d(a,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1ci17z2"&&(p.textContent=r)},m(a,y){n(a,l,y),n(a,i,y),n(a,p,y)},p:pe,d(a){a&&(s(l),s(i),s(p))}}}function ht(Z){let l,f="It might seem unintuitive to pass <code>Generator</code> objects to a pipeline instead of the integer value representing the seed. However, this is the recommended design when working with probabilistic models in PyTorch because a <code>Generator</code> is a <em>random state</em> that can be passed to multiple pipelines in a sequence. As soon as the <code>Generator</code> is consumed, the <em>state</em> is changed in place which means even if you passed the same <code>Generator</code> to a different pipeline, it won’t produce the same result because the state is already changed.";return{c(){l=m("p"),l.innerHTML=f},l(i){l=d(i,"P",{"data-svelte-h":!0}),h(l)!=="svelte-1jpg0yb"&&(l.innerHTML=f)},m(i,p){n(i,l,p)},p:pe,d(i){i&&s(l)}}}function yt(Z){let l,f='To generate reproducible results on a CPU, you’ll need to use a PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">Generator</a> and set a seed. Now when you run the code, it always prints a value of <code>1491.1711</code> because the <code>Generator</code> object with the seed is passed to all the random functions in the pipeline. You should get a similar, if not the same, result on whatever hardware and PyTorch version you’re using.',i,p,r;return p=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwZGRpbShudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyUwQXByaW50KG5wLmFicyhpbWFnZSkuc3VtKCkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline

ddim = DDIMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),{c(){l=m("p"),l.innerHTML=f,i=u(),M(p.$$.fragment)},l(a){l=d(a,"P",{"data-svelte-h":!0}),h(l)!=="svelte-mi9bj0"&&(l.innerHTML=f),i=c(a),g(p.$$.fragment,a)},m(a,y){n(a,l,y),n(a,i,y),w(p,a,y),r=!0},p:pe,i(a){r||(J(p.$$.fragment,a),r=!0)},o(a){T(p.$$.fragment,a),r=!1},d(a){a&&(s(l),s(i)),$(p,a)}}}function bt(Z){let l,f="If reproducibility is important to your use case, we recommend always passing a CPU <code>Generator</code>. The performance loss is often negligible and you’ll generate more similar values than if the pipeline had been run on a GPU.";return{c(){l=m("p"),l.innerHTML=f},l(i){l=d(i,"P",{"data-svelte-h":!0}),h(l)!=="svelte-jred1k"&&(l.innerHTML=f)},m(i,p){n(i,l,p)},p:pe,d(i){i&&s(l)}}}function Mt(Z){let l,f="Writing a reproducible pipeline on a GPU is a bit trickier, and full reproducibility across different hardware is not guaranteed because matrix multiplication - which diffusion pipelines require a lot of - is less deterministic on a GPU than a CPU. For example, if you run the same code example from the CPU example, you’ll get a different result even though the seed is identical. This is because the GPU uses a different random number generator than the CPU.",i,p,r,a,y='To avoid this issue, Diffusers has a <a href="/docs/diffusers/pr_10123/en/api/utilities#diffusers.utils.torch_utils.randn_tensor">randn_tensor()</a> function for creating random noise on the CPU, and then moving the tensor to a GPU if necessary. The <a href="/docs/diffusers/pr_10123/en/api/utilities#diffusers.utils.torch_utils.randn_tensor">randn_tensor()</a> function is used everywhere inside the pipeline. Now you can call <a href="https://pytorch.org/docs/stable/generated/torch.manual_seed.html" rel="nofollow">torch.manual_seed</a> which automatically creates a CPU <code>Generator</code> that can be passed to the pipeline even if it is being run on a GPU.',W,U,G,_,C,j,x=`Finally, more complex pipelines such as <a href="/docs/diffusers/pr_10123/en/api/pipelines/unclip#diffusers.UnCLIPPipeline">UnCLIPPipeline</a>, are often extremely
susceptible to precision error propagation. You’ll need to use
exactly the same hardware and PyTorch version for full reproducibility.`,v;return p=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFkZGltLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBkZGltKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMiUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTBBcHJpbnQobnAuYWJzKGltYWdlKS5zdW0oKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline

ddim = DDIMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),U=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFkZGltLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMGRkaW0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDIlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlMEFwcmludChucC5hYnMoaW1hZ2UpLnN1bSgpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline

ddim = DDIMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),_=new Ee({props:{warning:!1,$$slots:{default:[bt]},$$scope:{ctx:Z}}}),{c(){l=m("p"),l.textContent=f,i=u(),M(p.$$.fragment),r=u(),a=m("p"),a.innerHTML=y,W=u(),M(U.$$.fragment),G=u(),M(_.$$.fragment),C=u(),j=m("p"),j.innerHTML=x},l(o){l=d(o,"P",{"data-svelte-h":!0}),h(l)!=="svelte-1v52ack"&&(l.textContent=f),i=c(o),g(p.$$.fragment,o),r=c(o),a=d(o,"P",{"data-svelte-h":!0}),h(a)!=="svelte-v5cdz"&&(a.innerHTML=y),W=c(o),g(U.$$.fragment,o),G=c(o),g(_.$$.fragment,o),C=c(o),j=d(o,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1h4j6b3"&&(j.innerHTML=x)},m(o,b){n(o,l,b),n(o,i,b),w(p,o,b),n(o,r,b),n(o,a,b),n(o,W,b),w(U,o,b),n(o,G,b),w(_,o,b),n(o,C,b),n(o,j,b),v=!0},p(o,b){const ie={};b&2&&(ie.$$scope={dirty:b,ctx:o}),_.$set(ie)},i(o){v||(J(p.$$.fragment,o),J(U.$$.fragment,o),J(_.$$.fragment,o),v=!0)},o(o){T(p.$$.fragment,o),T(U.$$.fragment,o),T(_.$$.fragment,o),v=!1},d(o){o&&(s(l),s(i),s(r),s(a),s(W),s(G),s(C),s(j)),$(p,o),$(U,o),$(_,o)}}}function gt(Z){let l,f,i,p;return l=new at({props:{id:"hardware",option:"CPU",$$slots:{default:[yt]},$$scope:{ctx:Z}}}),i=new at({props:{id:"hardware",option:"GPU",$$slots:{default:[Mt]},$$scope:{ctx:Z}}}),{c(){M(l.$$.fragment),f=u(),M(i.$$.fragment)},l(r){g(l.$$.fragment,r),f=c(r),g(i.$$.fragment,r)},m(r,a){w(l,r,a),n(r,f,a),w(i,r,a),p=!0},p(r,a){const y={};a&2&&(y.$$scope={dirty:a,ctx:r}),l.$set(y);const W={};a&2&&(W.$$scope={dirty:a,ctx:r}),i.$set(W)},i(r){p||(J(l.$$.fragment,r),J(i.$$.fragment,r),p=!0)},o(r){T(l.$$.fragment,r),T(i.$$.fragment,r),p=!1},d(r){r&&s(f),$(l,r),$(i,r)}}}function wt(Z){let l,f="Use a list comprehension that iterates over the batch size specified in <code>range()</code> to create a unique <code>Generator</code> object for each image in the batch. If you multiply the <code>Generator</code> by the batch size integer, it only creates <em>one</em> <code>Generator</code> object that is used sequentially for each image in the batch.",i,p,r;return p=new I({props:{code:"JTVCdG9yY2guR2VuZXJhdG9yKCkubWFudWFsX3NlZWQoc2VlZCklNUQlMjAqJTIwNA==",highlighted:'[torch.Generator().manual_seed(seed)] * <span class="hljs-number">4</span>',wrap:!1}}),{c(){l=m("p"),l.innerHTML=f,i=u(),M(p.$$.fragment)},l(a){l=d(a,"P",{"data-svelte-h":!0}),h(l)!=="svelte-9rxsgm"&&(l.innerHTML=f),i=c(a),g(p.$$.fragment,a)},m(a,y){n(a,l,y),n(a,i,y),w(p,a,y),r=!0},p:pe,i(a){r||(J(p.$$.fragment,a),r=!0)},o(a){T(p.$$.fragment,a),r=!1},d(a){a&&(s(l),s(i)),$(p,a)}}}function Jt(Z){let l,f,i,p,r,a,y,W='Diffusion models are inherently random which is what allows it to generate different outputs every time it is run. But there are certain times when you want to generate the same output every time, like when you’re testing, replicating results, and even <a href="#deterministic-batch-generation">improving image quality</a>. While you can’t expect to get identical results across platforms, you can expect reproducible results across releases and platforms within a certain tolerance range (though even this may vary).',U,G,_="This guide will show you how to control randomness for deterministic generation on a CPU and GPU.",C,j,x,v,o,b,ie=`During inference, pipelines rely heavily on random sampling operations which include creating the
Gaussian noise tensors to denoise and adding noise to the scheduling step.`,oe,E,ze='Take a look at the tensor values in the <a href="/docs/diffusers/pr_10123/en/api/pipelines/ddim#diffusers.DDIMPipeline">DDIMPipeline</a> after two inference steps.',ue,z,ce,H,He="Running the code above prints one value, but if you run it again you get a different value.",me,P,Pe='Each time the pipeline is run, <a href="https://pytorch.org/docs/stable/generated/torch.randn.html" rel="nofollow">torch.randn</a> uses a different random seed to create the Gaussian noise tensors. This leads to a different result each time it is run and enables the diffusion pipeline to generate a different random image each time.',de,S,Se="But if you need to reliably generate the same image, that depends on whether you’re running the pipeline on a CPU or GPU.",fe,B,he,V,ye,F,be,q,Fe="You can also configure PyTorch to use deterministic algorithms to create a reproducible pipeline. The downside is that deterministic algorithms may be slower than non-deterministic ones and you may observe a decrease in performance.",Me,L,qe='Non-deterministic behavior occurs when operations are launched in more than one CUDA stream. To avoid this, set the environment variable <a href="https://docs.nvidia.com/cuda/cublas/index.html#results-reproducibility" rel="nofollow">CUBLAS_WORKSPACE_CONFIG</a> to <code>:16:8</code> to only use one buffer size during runtime.',ge,Q,Le='PyTorch typically benchmarks multiple algorithms to select the fastest one, but if you want reproducibility, you should disable this feature because the benchmark may select different algorithms each time. Set Diffusers <a href="https://github.com/huggingface/diffusers/blob/142f353e1c638ff1d20bd798402b68f72c1ebbdd/src/diffusers/utils/testing_utils.py#L861" rel="nofollow">enable_full_determinism</a> to enable deterministic algorithms.',we,D,Je,N,Qe="Now when you run the same pipeline twice, you’ll get identical results.",Te,Y,$e,K,Ze,A,De='A practical application of creating reproducible pipelines is <em>deterministic batch generation</em>. You generate a batch of images and select one image to improve with a more detailed prompt. The main idea is to pass a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">Generator’s</a> to the pipeline and tie each <code>Generator</code> to a seed so you can reuse it.',je,O,Ne='Let’s use the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a> checkpoint and generate a batch of images.',Ue,ee,Ge,te,Ye="Define four different <code>Generator</code>s and assign each <code>Generator</code> a seed (<code>0</code> to <code>3</code>). Then generate a batch of images and pick one to iterate on.",ve,k,_e,se,We,X,Ke='<img src="https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/reusabe_seeds.jpg"/>',Ie,ne,Ae="Let’s improve the first image (you can choose any image you want) which corresponds to the <code>Generator</code> with seed <code>0</code>. Add some additional text to your prompt and then make sure you reuse the same <code>Generator</code> with seed <code>0</code>. All the generated images should resemble the first image.",Ce,le,Be,R,Oe='<img src="https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/reusabe_seeds_2.jpg"/>',Ve,ae,ke,re,Xe;return r=new xe({props:{title:"Reproducible pipelines",local:"reproducible-pipelines",headingTag:"h1"}}),j=new Ee({props:{warning:!1,$$slots:{default:[ft]},$$scope:{ctx:Z}}}),v=new xe({props:{title:"Control randomness",local:"control-randomness",headingTag:"h2"}}),z=new I({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1QaXBlbGluZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQWRkaW0lMjAlM0QlMjBERElNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkZGltKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2VzJTBBcHJpbnQobnAuYWJzKGltYWdlKS5zdW0oKSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

ddim = DDIMPipeline.from_pretrained( <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),B=new Ee({props:{warning:!1,$$slots:{default:[ht]},$$scope:{ctx:Z}}}),V=new dt({props:{id:"hardware",options:["CPU","GPU"],$$slots:{default:[gt]},$$scope:{ctx:Z}}}),F=new xe({props:{title:"Deterministic algorithms",local:"deterministic-algorithms",headingTag:"h2"}}),D=new I({props:{code:"ZW5hYmxlX2Z1bGxfZGV0ZXJtaW5pc20oKQ==",highlighted:"enable_full_determinism()",wrap:!1}}),Y=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBZyUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBiZWFyJTIwaXMlMjBwbGF5aW5nJTIwYSUyMGd1aXRhciUyMG9uJTIwVGltZXMlMjBTcXVhcmUlMjIlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MiUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFwcmludCglMjJMX2luZiUyMGRpc3QlMjAlM0QlMjIlMkMlMjBhYnMocmVzdWx0MSUyMC0lMjByZXN1bHQyKS5tYXgoKSklMEElMjJMX2luZiUyMGRpc3QlMjAlM0QlMjB0ZW5zb3IoMC4lMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnKSUyMg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
g = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A bear is playing a guitar on Times Square&quot;</span>

g.manual_seed(<span class="hljs-number">0</span>)
result1 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

g.manual_seed(<span class="hljs-number">0</span>)
result2 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L_inf dist =&quot;</span>, <span class="hljs-built_in">abs</span>(result1 - result2).<span class="hljs-built_in">max</span>())
<span class="hljs-string">&quot;L_inf dist = tensor(0., device=&#x27;cuda:0&#x27;)&quot;</span>`,wrap:!1}}),K=new xe({props:{title:"Deterministic batch generation",local:"deterministic-batch-generation",headingTag:"h2"}}),ee=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),k=new Ee({props:{warning:!0,$$slots:{default:[wt]},$$scope:{ctx:Z}}}),se=new I({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwJTVCdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKGkpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQlMEFwcm9tcHQlMjAlM0QlMjAlMjJMYWJyYWRvciUyMGluJTIwdGhlJTIwc3R5bGUlMjBvZiUyMFZlcm1lZXIlMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0Q0KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDIp",highlighted:`generator = [torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)]
prompt = <span class="hljs-string">&quot;Labrador in the style of Vermeer&quot;</span>
images = pipeline(prompt, generator=generator, num_images_per_prompt=<span class="hljs-number">4</span>).images[<span class="hljs-number">0</span>]
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),le=new I({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCcHJvbXB0JTIwJTJCJTIwdCUyMGZvciUyMHQlMjBpbiUyMCU1QiUyMiUyQyUyMGhpZ2hseSUyMHJlYWxpc3RpYyUyMiUyQyUyMCUyMiUyQyUyMGFydHN5JTIyJTJDJTIwJTIyJTJDJTIwdHJlbmRpbmclMjIlMkMlMjAlMjIlMkMlMjBjb2xvcmZ1bCUyMiU1RCU1RCUwQWdlbmVyYXRvciUyMCUzRCUyMCU1QnRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDQpJTVEJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlMEFtYWtlX2ltYWdlX2dyaWQoaW1hZ2VzJTJDJTIwcm93cyUzRDIlMkMlMjBjb2xzJTNEMik=",highlighted:`prompt = [prompt + t <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;, highly realistic&quot;</span>, <span class="hljs-string">&quot;, artsy&quot;</span>, <span class="hljs-string">&quot;, trending&quot;</span>, <span class="hljs-string">&quot;, colorful&quot;</span>]]
generator = [torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)]
images = pipeline(prompt, generator=generator).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ae=new mt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/reusing_seeds.md"}}),{c(){l=m("meta"),f=u(),i=m("p"),p=u(),M(r.$$.fragment),a=u(),y=m("p"),y.innerHTML=W,U=u(),G=m("p"),G.textContent=_,C=u(),M(j.$$.fragment),x=u(),M(v.$$.fragment),o=u(),b=m("p"),b.textContent=ie,oe=u(),E=m("p"),E.innerHTML=ze,ue=u(),M(z.$$.fragment),ce=u(),H=m("p"),H.textContent=He,me=u(),P=m("p"),P.innerHTML=Pe,de=u(),S=m("p"),S.textContent=Se,fe=u(),M(B.$$.fragment),he=u(),M(V.$$.fragment),ye=u(),M(F.$$.fragment),be=u(),q=m("p"),q.textContent=Fe,Me=u(),L=m("p"),L.innerHTML=qe,ge=u(),Q=m("p"),Q.innerHTML=Le,we=u(),M(D.$$.fragment),Je=u(),N=m("p"),N.textContent=Qe,Te=u(),M(Y.$$.fragment),$e=u(),M(K.$$.fragment),Ze=u(),A=m("p"),A.innerHTML=De,je=u(),O=m("p"),O.innerHTML=Ne,Ue=u(),M(ee.$$.fragment),Ge=u(),te=m("p"),te.innerHTML=Ye,ve=u(),M(k.$$.fragment),_e=u(),M(se.$$.fragment),We=u(),X=m("div"),X.innerHTML=Ke,Ie=u(),ne=m("p"),ne.innerHTML=Ae,Ce=u(),M(le.$$.fragment),Be=u(),R=m("div"),R.innerHTML=Oe,Ve=u(),M(ae.$$.fragment),ke=u(),re=m("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);l=d(t,"META",{name:!0,content:!0}),t.forEach(s),f=c(e),i=d(e,"P",{}),lt(i).forEach(s),p=c(e),g(r.$$.fragment,e),a=c(e),y=d(e,"P",{"data-svelte-h":!0}),h(y)!=="svelte-13kjkmn"&&(y.innerHTML=W),U=c(e),G=d(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-117kc42"&&(G.textContent=_),C=c(e),g(j.$$.fragment,e),x=c(e),g(v.$$.fragment,e),o=c(e),b=d(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1tn5oba"&&(b.textContent=ie),oe=c(e),E=d(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-lq7aq2"&&(E.innerHTML=ze),ue=c(e),g(z.$$.fragment,e),ce=c(e),H=d(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1oqpaak"&&(H.textContent=He),me=c(e),P=d(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-ppvtm"&&(P.innerHTML=Pe),de=c(e),S=d(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-uamouh"&&(S.textContent=Se),fe=c(e),g(B.$$.fragment,e),he=c(e),g(V.$$.fragment,e),ye=c(e),g(F.$$.fragment,e),be=c(e),q=d(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-gypex5"&&(q.textContent=Fe),Me=c(e),L=d(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-dxdx5v"&&(L.innerHTML=qe),ge=c(e),Q=d(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-180x72j"&&(Q.innerHTML=Le),we=c(e),g(D.$$.fragment,e),Je=c(e),N=d(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-b9yuf0"&&(N.textContent=Qe),Te=c(e),g(Y.$$.fragment,e),$e=c(e),g(K.$$.fragment,e),Ze=c(e),A=d(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1i3uu02"&&(A.innerHTML=De),je=c(e),O=d(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-dphlz8"&&(O.innerHTML=Ne),Ue=c(e),g(ee.$$.fragment,e),Ge=c(e),te=d(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-n4jqbl"&&(te.innerHTML=Ye),ve=c(e),g(k.$$.fragment,e),_e=c(e),g(se.$$.fragment,e),We=c(e),X=d(e,"DIV",{class:!0,"data-svelte-h":!0}),h(X)!=="svelte-1709zt"&&(X.innerHTML=Ke),Ie=c(e),ne=d(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-c26xxu"&&(ne.innerHTML=Ae),Ce=c(e),g(le.$$.fragment,e),Be=c(e),R=d(e,"DIV",{class:!0,"data-svelte-h":!0}),h(R)!=="svelte-cjmjeo"&&(R.innerHTML=Oe),Ve=c(e),g(ae.$$.fragment,e),ke=c(e),re=d(e,"P",{}),lt(re).forEach(s),this.h()},h(){Re(l,"name","hf:doc:metadata"),Re(l,"content",Tt),Re(X,"class","flex justify-center"),Re(R,"class","flex justify-center")},m(e,t){ct(document.head,l),n(e,f,t),n(e,i,t),n(e,p,t),w(r,e,t),n(e,a,t),n(e,y,t),n(e,U,t),n(e,G,t),n(e,C,t),w(j,e,t),n(e,x,t),w(v,e,t),n(e,o,t),n(e,b,t),n(e,oe,t),n(e,E,t),n(e,ue,t),w(z,e,t),n(e,ce,t),n(e,H,t),n(e,me,t),n(e,P,t),n(e,de,t),n(e,S,t),n(e,fe,t),w(B,e,t),n(e,he,t),w(V,e,t),n(e,ye,t),w(F,e,t),n(e,be,t),n(e,q,t),n(e,Me,t),n(e,L,t),n(e,ge,t),n(e,Q,t),n(e,we,t),w(D,e,t),n(e,Je,t),n(e,N,t),n(e,Te,t),w(Y,e,t),n(e,$e,t),w(K,e,t),n(e,Ze,t),n(e,A,t),n(e,je,t),n(e,O,t),n(e,Ue,t),w(ee,e,t),n(e,Ge,t),n(e,te,t),n(e,ve,t),w(k,e,t),n(e,_e,t),w(se,e,t),n(e,We,t),n(e,X,t),n(e,Ie,t),n(e,ne,t),n(e,Ce,t),w(le,e,t),n(e,Be,t),n(e,R,t),n(e,Ve,t),w(ae,e,t),n(e,ke,t),n(e,re,t),Xe=!0},p(e,[t]){const et={};t&2&&(et.$$scope={dirty:t,ctx:e}),j.$set(et);const tt={};t&2&&(tt.$$scope={dirty:t,ctx:e}),B.$set(tt);const st={};t&2&&(st.$$scope={dirty:t,ctx:e}),V.$set(st);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),k.$set(nt)},i(e){Xe||(J(r.$$.fragment,e),J(j.$$.fragment,e),J(v.$$.fragment,e),J(z.$$.fragment,e),J(B.$$.fragment,e),J(V.$$.fragment,e),J(F.$$.fragment,e),J(D.$$.fragment,e),J(Y.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(k.$$.fragment,e),J(se.$$.fragment,e),J(le.$$.fragment,e),J(ae.$$.fragment,e),Xe=!0)},o(e){T(r.$$.fragment,e),T(j.$$.fragment,e),T(v.$$.fragment,e),T(z.$$.fragment,e),T(B.$$.fragment,e),T(V.$$.fragment,e),T(F.$$.fragment,e),T(D.$$.fragment,e),T(Y.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(k.$$.fragment,e),T(se.$$.fragment,e),T(le.$$.fragment,e),T(ae.$$.fragment,e),Xe=!1},d(e){e&&(s(f),s(i),s(p),s(a),s(y),s(U),s(G),s(C),s(x),s(o),s(b),s(oe),s(E),s(ue),s(ce),s(H),s(me),s(P),s(de),s(S),s(fe),s(he),s(ye),s(be),s(q),s(Me),s(L),s(ge),s(Q),s(we),s(Je),s(N),s(Te),s($e),s(Ze),s(A),s(je),s(O),s(Ue),s(Ge),s(te),s(ve),s(_e),s(We),s(X),s(Ie),s(ne),s(Ce),s(Be),s(R),s(Ve),s(ke),s(re)),s(l),$(r,e),$(j,e),$(v,e),$(z,e),$(B,e),$(V,e),$(F,e),$(D,e),$(Y,e),$(K,e),$(ee,e),$(k,e),$(se,e),$(le,e),$(ae,e)}}}const Tt='{"title":"Reproducible pipelines","local":"reproducible-pipelines","sections":[{"title":"Control randomness","local":"control-randomness","sections":[],"depth":2},{"title":"Deterministic algorithms","local":"deterministic-algorithms","sections":[],"depth":2},{"title":"Deterministic batch generation","local":"deterministic-batch-generation","sections":[],"depth":2}],"depth":1}';function $t(Z){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends pt{constructor(l){super(),ot(this,l,$t,Jt,it,{})}}export{Wt as component};
