import{s as al,n as nl,o as il}from"../chunks/scheduler.b108d059.js";import{S as ol,i as rl,g as i,s as a,r as m,A as ml,h as o,f as s,c as n,j as sl,u as p,x as r,k as tl,y as pl,a as t,v as M,d as u,t as c,w as h}from"../chunks/index.008de539.js";import{C as Ie}from"../chunks/CodeBlock.3968c746.js";import{H as b,E as Ml}from"../chunks/EditOnGithub.d1c48e3d.js";function ul(Ne){let y,O,R,K,j,ee,U,Qe="This page explains how scores are normalized on the Open LLM Leaderboard for the six presented benchmarks. We can categorize all tasks into those with subtasks, those without subtasks, and generative evaluation.",le,f,Ee='<a href="https://colab.research.google.com/drive/1-aPrFJjwdifhVLxzJcsYXeebqNi_5vaw?usp=sharing" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',se,d,We="<strong>Note:</strong> Click the button above to explore the scores normalization process in an interactive notebook (make a copy to edit).",te,w,ae,J,Ge="Normalization is the process of adjusting values measured on different scales to a common scale, making it possible to compare scores across different tasks. For the Open LLM Leaderboard, we normalize scores to:",ne,C,Ze="<li>Account for the varying difficulty and random guess baselines of different tasks.</li> <li>Provide a consistent scale (0-100) for all tasks, enabling fair comparisons.</li> <li>Ensure that improvements over random guessing are appropriately reflected in the scores.</li>",ie,T,oe,v,Xe="The basic normalization process involves two steps:",re,z,Be="<li>Subtracting the random baseline score (lower bound).</li> <li>Scaling the result to a range of 0-100.</li>",me,g,qe="We use the following normalization function:",pe,_,Me,$,ue,k,Ye="For tasks without subtasks (e.g., GPQA, MMLU-PRO), the normalization process is straightforward:",ce,A,Le="<li>Determine the lower bound (random guess baseline).</li> <li>Apply the normalization function.</li> <li>Scale to a percentage.</li>",he,x,ye,S,Ve="GPQA has 4 <code>num_choices</code>, so the lower bound is 0.25 (1/<code>num_choices</code> = 1/4 = 0.25).",be,I,je,N,Ue,Q,Fe="For tasks with subtasks (e.g., MUSR, BBH), we follow these steps:",fe,E,He="<li>Calculate the lower bound for each subtask.</li> <li>Normalize each subtask score.</li> <li>Average the normalized subtask scores.</li>",de,W,we,G,Pe="MUSR has three subtasks with different numbers of choices:",Je,Z,Re="<li>MUSR murder mysteries, num_choices = 2, lower_bound = 0.5</li> <li>MUSR object placement, num_choices = 5, lower_bound = 0.2</li> <li>MUSR team allocation, num_choices = 3, lower_bound = 0.33</li>",Ce,X,Te,B,ve,q,De="Generative evaluations like MATH and IFEval require a different approach:",ze,Y,Oe="<li><strong>MATH:</strong> Uses exact match accuracy. The lower bound is effectively 0, as random guessing is unlikely to produce a correct answer.</li> <li><strong>IFEval:</strong><ul><li>For instance-level evaluation (<code>ifeval_inst</code>), we use strict accuracy.</li> <li>For prompt-level evaluation (<code>ifeval_prompt</code>), we also use strict accuracy.</li> <li>The lower bound for both is 0, as random generation is unlikely to produce correct answers.</li></ul></li>",ge,L,Ke="This approach ensures that even for generative tasks, we can provide normalized scores that are comparable across different evaluations.",_e,V,$e,F,el='For more detailed information and examples, please refer to our <a href="https://huggingface.co/spaces/open-llm-leaderboard/blog" rel="nofollow">blog post</a> on scores normalization.',ke,H,ll='If you have any questions or need clarification, please start a new discussion on <a href="https://huggingface.co/spaces/open-llm-leaderboard/open_llm_leaderboard/discussions" rel="nofollow">the Leaderboard page</a>.',Ae,P,xe,D,Se;return j=new b({props:{title:"Scores Normalization",local:"scores-normalization",headingTag:"h1"}}),w=new b({props:{title:"What is Normalization?",local:"what-is-normalization",headingTag:"h2"}}),T=new b({props:{title:"General Normalization Process",local:"general-normalization-process",headingTag:"h2"}}),_=new Ie({props:{code:"ZGVmJTIwbm9ybWFsaXplX3dpdGhpbl9yYW5nZSh2YWx1ZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCh2YWx1ZSUyMC0lMjBsb3dlcl9ib3VuZCklMjAlMkYlMjAoaGlnaGVyX2JvdW5kJTIwLSUyMGxvd2VyX2JvdW5kKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">normalize_within_range</span>(<span class="hljs-params">value, lower_bound, higher_bound</span>):
    <span class="hljs-keyword">return</span> (value - lower_bound) / (higher_bound - lower_bound)`,wrap:!1}}),$=new b({props:{title:"Normalizing Tasks without Subtasks",local:"normalizing-tasks-without-subtasks",headingTag:"h2"}}),x=new b({props:{title:"Example: Normalizing GPQA Scores",local:"example-normalizing-gpqa-scores",headingTag:"h3"}}),I=new Ie({props:{code:"cmF3X3Njb3JlJTIwJTNEJTIwMC42JTIwJTIwJTIzJTIwRXhhbXBsZSUyMHJhdyUyMHNjb3JlJTBBbG93ZXJfYm91bmQlMjAlM0QlMjAwLjI1JTBBaGlnaGVyX2JvdW5kJTIwJTNEJTIwMS4wJTBBJTBBaWYlMjByYXdfc2NvcmUlMjAlM0MlMjBsb3dlcl9ib3VuZCUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjAwJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjBub3JtYWxpemVfd2l0aGluX3JhbmdlKHJhd19zY29yZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUyMColMjAxMDAlMEElMEFwcmludChmJTIyTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMCU3Qm5vcm1hbGl6ZWRfc2NvcmUlM0EuMmYlN0QlMjIpJTBBJTIzJTIwT3V0cHV0JTNBJTIwTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMDQ2LjY3",highlighted:`raw_score = <span class="hljs-number">0.6</span>  <span class="hljs-comment"># Example raw score</span>
lower_bound = <span class="hljs-number">0.25</span>
higher_bound = <span class="hljs-number">1.0</span>

<span class="hljs-keyword">if</span> raw_score &lt; lower_bound:
    normalized_score = <span class="hljs-number">0</span>
<span class="hljs-keyword">else</span>:
    normalized_score = normalize_within_range(raw_score, lower_bound, higher_bound) * <span class="hljs-number">100</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Normalized GPQA score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-comment"># Output: Normalized GPQA score: 46.67</span>`,wrap:!1}}),N=new b({props:{title:"Normalizing Tasks with Subtasks",local:"normalizing-tasks-with-subtasks",headingTag:"h2"}}),W=new b({props:{title:"Example: Normalizing MUSR Scores",local:"example-normalizing-musr-scores",headingTag:"h3"}}),X=new Ie({props:{code:"c3VidGFza3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJuYW1lJTIyJTNBJTIwJTIybXVyZGVyX215c3RlcmllcyUyMiUyQyUyMCUyMnJhd19zY29yZSUyMiUzQSUyMDAuNyUyQyUyMCUyMmxvd2VyX2JvdW5kJTIyJTNBJTIwMC41JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMm9iamVjdF9wbGFjZW1lbnQlMjIlMkMlMjAlMjJyYXdfc2NvcmUlMjIlM0ElMjAwLjQlMkMlMjAlMjJsb3dlcl9ib3VuZCUyMiUzQSUyMDAuMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJ0ZWFtX2FsbG9jYXRpb24lMjIlMkMlMjAlMjJyYXdfc2NvcmUlMjIlM0ElMjAwLjYlMkMlMjAlMjJsb3dlcl9ib3VuZCUyMiUzQSUyMDAuMzMzJTdEJTBBJTVEJTBBJTBBbm9ybWFsaXplZF9zY29yZXMlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjBzdWJ0YXNrJTIwaW4lMjBzdWJ0YXNrcyUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwc3VidGFzayU1QiUyMnJhd19zY29yZSUyMiU1RCUyMCUzQyUyMHN1YnRhc2slNUIlMjJsb3dlcl9ib3VuZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjBub3JtYWxpemVfd2l0aGluX3JhbmdlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1YnRhc2slNUIlMjJyYXdfc2NvcmUlMjIlNUQlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdWJ0YXNrJTVCJTIybG93ZXJfYm91bmQlMjIlNUQlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAxLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTIwKiUyMDEwMCUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmVzLmFwcGVuZChub3JtYWxpemVkX3Njb3JlKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JzdWJ0YXNrJTVCJ25hbWUnJTVEJTdEJTIwbm9ybWFsaXplZCUyMHNjb3JlJTNBJTIwJTdCbm9ybWFsaXplZF9zY29yZSUzQS4yZiU3RCUyMiklMEElMEFvdmVyYWxsX25vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjBzdW0obm9ybWFsaXplZF9zY29yZXMpJTIwJTJGJTIwbGVuKG5vcm1hbGl6ZWRfc2NvcmVzKSUwQXByaW50KGYlMjJPdmVyYWxsJTIwbm9ybWFsaXplZCUyME1VU1IlMjBzY29yZSUzQSUyMCU3Qm92ZXJhbGxfbm9ybWFsaXplZF9zY29yZSUzQS4yZiU3RCUyMiklMEElMEElMjMlMjBPdXRwdXQlM0ElMEElMjMlMjBtdXJkZXJfbXlzdGVyaWVzJTIwbm9ybWFsaXplZCUyMHNjb3JlJTNBJTIwNDAuMDAlMEElMjMlMjBvYmplY3RfcGxhY2VtZW50JTIwbm9ybWFsaXplZCUyMHNjb3JlJTNBJTIwMjUuMDAlMEElMjMlMjB0ZWFtX2FsbG9jYXRpb24lMjBub3JtYWxpemVkJTIwc2NvcmUlM0ElMjA0MC4wMCUwQSUyMyUyME92ZXJhbGwlMjBub3JtYWxpemVkJTIwTVVTUiUyMHNjb3JlJTNBJTIwMzUuMDA=",highlighted:`subtasks = [
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;murder_mysteries&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.5</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;object_placement&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.4</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.2</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;team_allocation&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.6</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.333</span>}
]

normalized_scores = []

<span class="hljs-keyword">for</span> subtask <span class="hljs-keyword">in</span> subtasks:
    <span class="hljs-keyword">if</span> subtask[<span class="hljs-string">&quot;raw_score&quot;</span>] &lt; subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>]:
        normalized_score = <span class="hljs-number">0</span>
    <span class="hljs-keyword">else</span>:
        normalized_score = normalize_within_range(
            subtask[<span class="hljs-string">&quot;raw_score&quot;</span>], 
            subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>], 
            <span class="hljs-number">1.0</span>
        ) * <span class="hljs-number">100</span>
    normalized_scores.append(normalized_score)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{subtask[<span class="hljs-string">&#x27;name&#x27;</span>]}</span> normalized score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

overall_normalized_score = <span class="hljs-built_in">sum</span>(normalized_scores) / <span class="hljs-built_in">len</span>(normalized_scores)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Overall normalized MUSR score: <span class="hljs-subst">{overall_normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># murder_mysteries normalized score: 40.00</span>
<span class="hljs-comment"># object_placement normalized score: 25.00</span>
<span class="hljs-comment"># team_allocation normalized score: 40.00</span>
<span class="hljs-comment"># Overall normalized MUSR score: 35.00</span>`,wrap:!1}}),B=new b({props:{title:"Generative Evaluations",local:"generative-evaluations",headingTag:"h2"}}),V=new b({props:{title:"Further Information",local:"further-information",headingTag:"h2"}}),P=new Ml({props:{source:"https://github.com/huggingface/leaderboards/blob/main/docs/source/en/open_llm_leaderboard/normalization.md"}}),{c(){y=i("meta"),O=a(),R=i("p"),K=a(),m(j.$$.fragment),ee=a(),U=i("p"),U.textContent=Qe,le=a(),f=i("p"),f.innerHTML=Ee,se=a(),d=i("p"),d.innerHTML=We,te=a(),m(w.$$.fragment),ae=a(),J=i("p"),J.textContent=Ge,ne=a(),C=i("ol"),C.innerHTML=Ze,ie=a(),m(T.$$.fragment),oe=a(),v=i("p"),v.textContent=Xe,re=a(),z=i("ol"),z.innerHTML=Be,me=a(),g=i("p"),g.textContent=qe,pe=a(),m(_.$$.fragment),Me=a(),m($.$$.fragment),ue=a(),k=i("p"),k.textContent=Ye,ce=a(),A=i("ul"),A.innerHTML=Le,he=a(),m(x.$$.fragment),ye=a(),S=i("p"),S.innerHTML=Ve,be=a(),m(I.$$.fragment),je=a(),m(N.$$.fragment),Ue=a(),Q=i("p"),Q.textContent=Fe,fe=a(),E=i("ul"),E.innerHTML=He,de=a(),m(W.$$.fragment),we=a(),G=i("p"),G.textContent=Pe,Je=a(),Z=i("ul"),Z.innerHTML=Re,Ce=a(),m(X.$$.fragment),Te=a(),m(B.$$.fragment),ve=a(),q=i("p"),q.textContent=De,ze=a(),Y=i("ol"),Y.innerHTML=Oe,ge=a(),L=i("p"),L.textContent=Ke,_e=a(),m(V.$$.fragment),$e=a(),F=i("p"),F.innerHTML=el,ke=a(),H=i("p"),H.innerHTML=ll,Ae=a(),m(P.$$.fragment),xe=a(),D=i("p"),this.h()},l(e){const l=ml("svelte-u9bgzb",document.head);y=o(l,"META",{name:!0,content:!0}),l.forEach(s),O=n(e),R=o(e,"P",{}),sl(R).forEach(s),K=n(e),p(j.$$.fragment,e),ee=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1o7378m"&&(U.textContent=Qe),le=n(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1xbpa2x"&&(f.innerHTML=Ee),se=n(e),d=o(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-i1xl0s"&&(d.innerHTML=We),te=n(e),p(w.$$.fragment,e),ae=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1g21ee8"&&(J.textContent=Ge),ne=n(e),C=o(e,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-zj6h40"&&(C.innerHTML=Ze),ie=n(e),p(T.$$.fragment,e),oe=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1homifm"&&(v.textContent=Xe),re=n(e),z=o(e,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-1noqtti"&&(z.innerHTML=Be),me=n(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-uv3qwg"&&(g.textContent=qe),pe=n(e),p(_.$$.fragment,e),Me=n(e),p($.$$.fragment,e),ue=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ukmwwm"&&(k.textContent=Ye),ce=n(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-199eldc"&&(A.innerHTML=Le),he=n(e),p(x.$$.fragment,e),ye=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1n8wkts"&&(S.innerHTML=Ve),be=n(e),p(I.$$.fragment,e),je=n(e),p(N.$$.fragment,e),Ue=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-3f8l62"&&(Q.textContent=Fe),fe=n(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-cnj190"&&(E.innerHTML=He),de=n(e),p(W.$$.fragment,e),we=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-hgykxj"&&(G.textContent=Pe),Je=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-2hbeeh"&&(Z.innerHTML=Re),Ce=n(e),p(X.$$.fragment,e),Te=n(e),p(B.$$.fragment,e),ve=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1yp6rl7"&&(q.textContent=De),ze=n(e),Y=o(e,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-1lwzczp"&&(Y.innerHTML=Oe),ge=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1k8dio0"&&(L.textContent=Ke),_e=n(e),p(V.$$.fragment,e),$e=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-12yyx1q"&&(F.innerHTML=el),ke=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-n94pcj"&&(H.innerHTML=ll),Ae=n(e),p(P.$$.fragment,e),xe=n(e),D=o(e,"P",{}),sl(D).forEach(s),this.h()},h(){tl(y,"name","hf:doc:metadata"),tl(y,"content",cl)},m(e,l){pl(document.head,y),t(e,O,l),t(e,R,l),t(e,K,l),M(j,e,l),t(e,ee,l),t(e,U,l),t(e,le,l),t(e,f,l),t(e,se,l),t(e,d,l),t(e,te,l),M(w,e,l),t(e,ae,l),t(e,J,l),t(e,ne,l),t(e,C,l),t(e,ie,l),M(T,e,l),t(e,oe,l),t(e,v,l),t(e,re,l),t(e,z,l),t(e,me,l),t(e,g,l),t(e,pe,l),M(_,e,l),t(e,Me,l),M($,e,l),t(e,ue,l),t(e,k,l),t(e,ce,l),t(e,A,l),t(e,he,l),M(x,e,l),t(e,ye,l),t(e,S,l),t(e,be,l),M(I,e,l),t(e,je,l),M(N,e,l),t(e,Ue,l),t(e,Q,l),t(e,fe,l),t(e,E,l),t(e,de,l),M(W,e,l),t(e,we,l),t(e,G,l),t(e,Je,l),t(e,Z,l),t(e,Ce,l),M(X,e,l),t(e,Te,l),M(B,e,l),t(e,ve,l),t(e,q,l),t(e,ze,l),t(e,Y,l),t(e,ge,l),t(e,L,l),t(e,_e,l),M(V,e,l),t(e,$e,l),t(e,F,l),t(e,ke,l),t(e,H,l),t(e,Ae,l),M(P,e,l),t(e,xe,l),t(e,D,l),Se=!0},p:nl,i(e){Se||(u(j.$$.fragment,e),u(w.$$.fragment,e),u(T.$$.fragment,e),u(_.$$.fragment,e),u($.$$.fragment,e),u(x.$$.fragment,e),u(I.$$.fragment,e),u(N.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(B.$$.fragment,e),u(V.$$.fragment,e),u(P.$$.fragment,e),Se=!0)},o(e){c(j.$$.fragment,e),c(w.$$.fragment,e),c(T.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(x.$$.fragment,e),c(I.$$.fragment,e),c(N.$$.fragment,e),c(W.$$.fragment,e),c(X.$$.fragment,e),c(B.$$.fragment,e),c(V.$$.fragment,e),c(P.$$.fragment,e),Se=!1},d(e){e&&(s(O),s(R),s(K),s(ee),s(U),s(le),s(f),s(se),s(d),s(te),s(ae),s(J),s(ne),s(C),s(ie),s(oe),s(v),s(re),s(z),s(me),s(g),s(pe),s(Me),s(ue),s(k),s(ce),s(A),s(he),s(ye),s(S),s(be),s(je),s(Ue),s(Q),s(fe),s(E),s(de),s(we),s(G),s(Je),s(Z),s(Ce),s(Te),s(ve),s(q),s(ze),s(Y),s(ge),s(L),s(_e),s($e),s(F),s(ke),s(H),s(Ae),s(xe),s(D)),s(y),h(j,e),h(w,e),h(T,e),h(_,e),h($,e),h(x,e),h(I,e),h(N,e),h(W,e),h(X,e),h(B,e),h(V,e),h(P,e)}}}const cl='{"title":"Scores Normalization","local":"scores-normalization","sections":[{"title":"What is Normalization?","local":"what-is-normalization","sections":[],"depth":2},{"title":"General Normalization Process","local":"general-normalization-process","sections":[],"depth":2},{"title":"Normalizing Tasks without Subtasks","local":"normalizing-tasks-without-subtasks","sections":[{"title":"Example: Normalizing GPQA Scores","local":"example-normalizing-gpqa-scores","sections":[],"depth":3}],"depth":2},{"title":"Normalizing Tasks with Subtasks","local":"normalizing-tasks-with-subtasks","sections":[{"title":"Example: Normalizing MUSR Scores","local":"example-normalizing-musr-scores","sections":[],"depth":3}],"depth":2},{"title":"Generative Evaluations","local":"generative-evaluations","sections":[],"depth":2},{"title":"Further Information","local":"further-information","sections":[],"depth":2}],"depth":1}';function hl(Ne){return il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fl extends ol{constructor(y){super(),rl(this,y,hl,ul,al,{})}}export{fl as component};
