import{s as Zt,o as jt,n as ot}from"../chunks/scheduler.8c3d61f6.js";import{S as kt,i as $t,g as l,s as a,r as f,A as At,h as r,f as n,c as s,j as ge,u as g,x as p,k as he,y as c,a as i,v as h,d as _,t as b,w as y}from"../chunks/index.da70eac4.js";import{T as Ut}from"../chunks/Tip.1d9b8c37.js";import{D as ze}from"../chunks/Docstring.6b390b9a.js";import{C as st}from"../chunks/CodeBlock.00a903b3.js";import{E as Gt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as A,E as Ct}from"../chunks/EditOnGithub.1e64e623.js";function Wt(U){let o,v="If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the PIA checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){o=l("p"),o.innerHTML=v},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1a93myr"&&(o.innerHTML=v)},m(d,w){i(d,o,w)},p:ot,d(d){d&&n(o)}}}function Vt(U){let o,v="FreeInit is not really free - the improved quality comes at the cost of extra computation. It requires sampling a few extra times depending on the <code>num_iters</code> parameter that is set when enabling it. Setting the <code>use_fast_sampling</code> parameter to <code>True</code> can improve the overall performance (at the cost of lower quality compared to when <code>use_fast_sampling=False</code> but still better results than vanilla video generation models).";return{c(){o=l("p"),o.innerHTML=v},l(d){o=r(d,"P",{"data-svelte-h":!0}),p(o)!=="svelte-xxwpr5"&&(o.innerHTML=v)},m(d,w){i(d,o,w)},p:ot,d(d){d&&n(o)}}}function Bt(U){let o,v="Examples:",d,w,I;return w=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUyQyUyME1vdGlvbkFkYXB0ZXIlMkMlMjBQSUFQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTJDJTIwbG9hZF9pbWFnZSUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVubW1sYWIlMkZQSUEtY29uZGl0aW9uLWFkYXB0ZXIlMjIpJTBBcGlwZSUyMCUzRCUyMFBJQVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTRzE2MTIyMiUyRlJlYWxpc3RpY19WaXNpb25fVjYuMF9CMV9ub1ZBRSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGl4MnBpeCUyRmNhdF82LnBuZyUzRmRvd25sb2FkJTNEdHJ1ZSUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMGltYWdlLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFwcm9tcHQlMjAlM0QlMjAlMjJjYXQlMjBpbiUyMGElMjBoYXQlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3cm9uZyUyMHdoaXRlJTIwYmFsYW5jZSUyQyUyMGRhcmslMkMlMjBza2V0Y2hlcyUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMkMlMjBkZWZvcm1lZCUyQyUyMGRpc3RvcnRlZCUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBb3V0cHV0JTIwJTNEJTIwcGlwZShpbWFnZSUzRGltYWdlJTJDJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJwaWEtYW5pbWF0aW9uLmdpZiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler, MotionAdapter, PIAPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PIAPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = EulerDiscreteScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat in a hat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches, worst quality, low quality, deformed, distorted&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(image=image, prompt=prompt, negative_prompt=negative_prompt, generator=generator)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;pia-animation.gif&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=v,d=a(),f(w.$$.fragment)},l(m){o=r(m,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=s(m),g(w.$$.fragment,m)},m(m,T){i(m,o,T),i(m,d,T),h(w,m,T),I=!0},p:ot,i(m){I||(_(w.$$.fragment,m),I=!0)},o(m){b(w.$$.fragment,m),I=!1},d(m){m&&(n(o),n(d)),y(w,m)}}}function Xt(U){let o,v,d,w,I,m,T,be,G,lt='<a href="https://arxiv.org/abs/2312.13964" rel="nofollow">PIA: Your Personalized Image Animator via Plug-and-Play Modules in Text-to-Image Models</a> by Yiming Zhang, Zhening Xing, Yanhong Zeng, Youqing Fang, Kai Chen',ye,C,rt="Recent advancements in personalized text-to-image (T2I) models have revolutionized content creation, empowering non-experts to generate stunning images with unique styles. While promising, adding realistic motions into these personalized images by text poses significant challenges in preserving distinct styles, high-fidelity details, and achieving motion controllability by text. In this paper, we present PIA, a Personalized Image Animator that excels in aligning with condition images, achieving motion controllability by text, and the compatibility with various personalized T2I models without specific tuning. To achieve these goals, PIA builds upon a base T2I model with well-trained temporal alignment layers, allowing for the seamless transformation of any personalized T2I model into an image animation model. A key component of PIA is the introduction of the condition module, which utilizes the condition frame and inter-frame affinity as input to transfer appearance information guided by the affinity hint for individual frame synthesis in the latent space. This design mitigates the challenges of appearance-related image alignment within and allows for a stronger focus on aligning with motion-related guidance.",Me,W,pt='<a href="https://pi-animator.github.io/" rel="nofollow">Project page</a>',we,V,ve,B,dt='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py" rel="nofollow">PIAPipeline</a></td> <td><em>Image-to-Video Generation with PIA</em></td> <td align="center"></td></tr></tbody>',Ie,X,Te,R,ct='Motion Adapter checkpoints for PIA can be found under the <a href="https://huggingface.co/openmmlab/PIA-condition-adapter" rel="nofollow">OpenMMLab org</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.5',Je,N,Pe,L,mt="PIA works with a MotionAdapter checkpoint and a Stable Diffusion 1.5 model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in the Stable Diffusion UNet. In addition to the motion modules, PIA also replaces the input convolution layer of the SD 1.5 UNet model with a 9 channel input convolution layer.",xe,E,ut="The following example demonstrates how to use PIA to generate a video from a single image.",Ue,S,Ze,Y,ft="Here are some sample outputs:",je,F,gt=`<tbody><tr><td><center>cat in a field.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pia-default-output.gif" alt="cat in a field" style="width: 300px;"/></center></td></tr></tbody>`,ke,Z,$e,H,Ae,z,ht='<a href="https://arxiv.org/abs/2312.07537" rel="nofollow">FreeInit: Bridging Initialization Gap in Video Diffusion Models</a> by Tianxing Wu, Chenyang Si, Yuming Jiang, Ziqi Huang, Ziwei Liu.',Ge,D,_t="FreeInit is an effective method that improves temporal consistency and overall quality of videos generated using video-diffusion-models without any addition training. It can be applied to PIA, AnimateDiff, ModelScope, VideoCrafter and various other video generation models seamlessly at inference time, and works by iteratively refining the latent-initialization noise. More details can be found it the paper.",Ce,Q,bt="The following example demonstrates the usage of FreeInit.",We,q,Ve,O,yt=`<tbody><tr><td><center>cat in a field.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pia-freeinit-output-cat.gif" alt="cat in a field" style="width: 300px;"/></center></td></tr></tbody>`,Be,j,Xe,K,Re,u,ee,De,re,Mt="Pipeline for text-to-video generation.",Qe,pe,wt=`This model inherits from <a href="/docs/diffusers/pr_10033/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,qe,de,vt="The pipeline also inherits the following loading methods:",Oe,ce,It='<li><a href="/docs/diffusers/pr_10033/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/pr_10033/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/pr_10033/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/pr_10033/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Ke,J,te,et,me,Tt="The call function to the pipeline for generation.",tt,k,nt,$,ne,it,ue,Jt="Encodes the prompt into text encoder hidden states.",Ne,ie,Pt="<li>enable_freeu</li> <li>disable_freeu</li> <li>enable_free_init</li> <li>disable_free_init</li> <li>enable_vae_slicing</li> <li>disable_vae_slicing</li> <li>enable_vae_tiling</li> <li>disable_vae_tiling</li>",Le,ae,Ee,P,se,at,fe,xt="Output class for PIAPipeline.",Se,oe,Ye,_e,Fe;return I=new A({props:{title:"Image-to-Video Generation with PIA (Personalized Image Animator)",local:"image-to-video-generation-with-pia-personalized-image-animator",headingTag:"h1"}}),T=new A({props:{title:"Overview",local:"overview",headingTag:"h2"}}),V=new A({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),X=new A({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),N=new A({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),S=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBNb3Rpb25BZGFwdGVyJTJDJTBBJTIwJTIwJTIwJTIwUElBUGlwZWxpbmUlMkMlMEEpJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMkMlMjBsb2FkX2ltYWdlJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5tbWxhYiUyRlBJQS1jb25kaXRpb24tYWRhcHRlciUyMiklMEFwaXBlJTIwJTNEJTIwUElBUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpeDJwaXglMkZjYXRfNi5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIlMEEpJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwaW4lMjBhJTIwZmllbGQlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3cm9uZyUyMHdoaXRlJTIwYmFsYW5jZSUyQyUyMGRhcmslMkMlMjBza2V0Y2hlcyUyQ3dvcnN0JTIwcXVhbGl0eSUyQ2xvdyUyMHF1YWxpdHklMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQW91dHB1dCUyMCUzRCUyMHBpcGUoaW1hZ2UlM0RpbWFnZSUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciklMEFmcmFtZXMlMjAlM0QlMjBvdXRwdXQuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b19naWYoZnJhbWVzJTJDJTIwJTIycGlhLWFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    EulerDiscreteScheduler,
    MotionAdapter,
    PIAPipeline,
)
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.scheduler = EulerDiscreteScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()
pipe.enable_vae_slicing()

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
)
image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;cat in a field&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
output = pipe(image=image, prompt=prompt, generator=generator)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;pia-animation.gif&quot;</span>)`,wrap:!1}}),Z=new Ut({props:{$$slots:{default:[Wt]},$$scope:{ctx:U}}}),H=new A({props:{title:"Using FreeInit",local:"using-freeinit",headingTag:"h2"}}),q=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMERESU1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBNb3Rpb25BZGFwdGVyJTJDJTBBJTIwJTIwJTIwJTIwUElBUGlwZWxpbmUlMkMlMEEpJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMkMlMjBsb2FkX2ltYWdlJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5tbWxhYiUyRlBJQS1jb25kaXRpb24tYWRhcHRlciUyMiklMEFwaXBlJTIwJTNEJTIwUElBUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyKSUwQSUwQSUyMyUyMGVuYWJsZSUyMEZyZWVJbml0JTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMGVuYWJsZV9mcmVlX2luaXQlMjBkb2N1bWVudGF0aW9uJTIwZm9yJTIwYSUyMGZ1bGwlMjBsaXN0JTIwb2YlMjBjb25maWd1cmFibGUlMjBwYXJhbWV0ZXJzJTBBcGlwZS5lbmFibGVfZnJlZV9pbml0KG1ldGhvZCUzRCUyMmJ1dHRlcndvcnRoJTIyJTJDJTIwdXNlX2Zhc3Rfc2FtcGxpbmclM0RUcnVlKSUwQSUwQSUyMyUyME1lbW9yeSUyMHNhdmluZyUyMG9wdGlvbnMlMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXgycGl4JTJGY2F0XzYucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMGluJTIwYSUyMGZpZWxkJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyd3JvbmclMjB3aGl0ZSUyMGJhbGFuY2UlMkMlMjBkYXJrJTJDJTIwc2tldGNoZXMlMkN3b3JzdCUyMHF1YWxpdHklMkNsb3clMjBxdWFsaXR5JTIyJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlKGltYWdlJTNEaW1hZ2UlMkMlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMnBpYS1mcmVlaW5pdC1hbmltYXRpb24uZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDIMScheduler,
    MotionAdapter,
    PIAPipeline,
)
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter)

<span class="hljs-comment"># enable FreeInit</span>
<span class="hljs-comment"># Refer to the enable_free_init documentation for a full list of configurable parameters</span>
pipe.enable_free_init(method=<span class="hljs-string">&quot;butterworth&quot;</span>, use_fast_sampling=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Memory saving options</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_slicing()

pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
)
image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;cat in a field&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

output = pipe(image=image, prompt=prompt, generator=generator)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;pia-freeinit-animation.gif&quot;</span>)`,wrap:!1}}),j=new Ut({props:{warning:!0,$$slots:{default:[Vt]},$$scope:{ctx:U}}}),K=new A({props:{title:"PIAPipeline",local:"diffusers.PIAPipeline",headingTag:"h2"}}),ee=new ze({props:{name:"class diffusers.PIAPipeline",anchor:"diffusers.PIAPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": typing.Union[diffusers.models.unets.unet_2d_condition.UNet2DConditionModel, diffusers.models.unets.unet_motion_model.UNetMotionModel]"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler, diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler, diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler]"},{name:"motion_adapter",val:": typing.Optional[diffusers.models.unets.unet_motion_model.MotionAdapter] = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10033/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PIAPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.PIAPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.PIAPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/pr_10033/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/pr_10033/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.PIAPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.PIAPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10033/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/pr_10033/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/pr_10033/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/pr_10033/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10033/src/diffusers/pipelines/pia/pipeline_pia.py#L125"}}),te=new ze({props:{name:"__call__",anchor:"diffusers.PIAPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"strength",val:": float = 1.0"},{name:"num_frames",val:": typing.Optional[int] = 16"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"motion_scale",val:": int = 0"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to be used for video generation.`,name:"image"},{anchor:"diffusers.PIAPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.PIAPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1.`,name:"strength"},{anchor:"diffusers.PIAPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.PIAPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.PIAPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.PIAPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PIAPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.PIAPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PIAPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/pr_10033/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.PIAPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.PIAPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.PIAPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PIAPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PIAPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"diffusers.PIAPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.PIAPipeline.__call__.motion_scale",description:`<strong>motion_scale</strong> &#x2014; (<code>int</code>, <em>optional</em>, defaults to 0):
Parameter that controls the amount and type of motion that is added to the image. Increasing the value
increases the amount of motion, while specific ranges of values control the type of motion that is
added. Must be between 0 and 8. Set between 0-2 to only increase the amount of motion. Set between 3-5
to create looping motion. Set between 6-8 to perform motion with image style transfer.`,name:"motion_scale"},{anchor:"diffusers.PIAPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.Tensor</code>, <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PIAPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10033/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PIAPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.PIAPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.PIAPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.PIAPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10033/src/diffusers/pipelines/pia/pipeline_pia.py#L661",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_10033/en/api/pipelines/pia#diffusers.pipelines.pia.PIAPipelineOutput"
>PIAPipelineOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10033/en/api/pipelines/pia#diffusers.pipelines.pia.PIAPipelineOutput"
>PIAPipelineOutput</a> or <code>tuple</code></p>
`}}),k=new Gt({props:{anchor:"diffusers.PIAPipeline.__call__.example",$$slots:{default:[Bt]},$$scope:{ctx:U}}}),ne=new ze({props:{name:"encode_prompt",anchor:"diffusers.PIAPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.PIAPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PIAPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PIAPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PIAPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.PIAPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_10033/src/diffusers/pipelines/pia/pipeline_pia.py#L202"}}),ae=new A({props:{title:"PIAPipelineOutput",local:"diffusers.pipelines.pia.PIAPipelineOutput",headingTag:"h2"}}),se=new ze({props:{name:"class diffusers.pipelines.pia.PIAPipelineOutput",anchor:"diffusers.pipelines.pia.PIAPipelineOutput",parameters:[{name:"frames",val:": typing.Union[torch.Tensor, numpy.ndarray, typing.List[typing.List[PIL.Image.Image]]]"}],parametersDescription:[{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
Nested list of length <code>batch_size</code> with denoised PIL image sequences of length <code>num_frames</code>, NumPy array of
shape <code>(batch_size, num_frames, channels, height, width, Torch tensor of shape </code>(batch_size, num_frames,
channels, height, width)\`.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/vr_10033/src/diffusers/pipelines/pia/pipeline_pia.py#L110"}}),oe=new Ct({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/pia.md"}}),{c(){o=l("meta"),v=a(),d=l("p"),w=a(),f(I.$$.fragment),m=a(),f(T.$$.fragment),be=a(),G=l("p"),G.innerHTML=lt,ye=a(),C=l("p"),C.textContent=rt,Me=a(),W=l("p"),W.innerHTML=pt,we=a(),f(V.$$.fragment),ve=a(),B=l("table"),B.innerHTML=dt,Ie=a(),f(X.$$.fragment),Te=a(),R=l("p"),R.innerHTML=ct,Je=a(),f(N.$$.fragment),Pe=a(),L=l("p"),L.textContent=mt,xe=a(),E=l("p"),E.textContent=ut,Ue=a(),f(S.$$.fragment),Ze=a(),Y=l("p"),Y.textContent=ft,je=a(),F=l("table"),F.innerHTML=gt,ke=a(),f(Z.$$.fragment),$e=a(),f(H.$$.fragment),Ae=a(),z=l("p"),z.innerHTML=ht,Ge=a(),D=l("p"),D.textContent=_t,Ce=a(),Q=l("p"),Q.textContent=bt,We=a(),f(q.$$.fragment),Ve=a(),O=l("table"),O.innerHTML=yt,Be=a(),f(j.$$.fragment),Xe=a(),f(K.$$.fragment),Re=a(),u=l("div"),f(ee.$$.fragment),De=a(),re=l("p"),re.textContent=Mt,Qe=a(),pe=l("p"),pe.innerHTML=wt,qe=a(),de=l("p"),de.textContent=vt,Oe=a(),ce=l("ul"),ce.innerHTML=It,Ke=a(),J=l("div"),f(te.$$.fragment),et=a(),me=l("p"),me.textContent=Tt,tt=a(),f(k.$$.fragment),nt=a(),$=l("div"),f(ne.$$.fragment),it=a(),ue=l("p"),ue.textContent=Jt,Ne=a(),ie=l("ul"),ie.innerHTML=Pt,Le=a(),f(ae.$$.fragment),Ee=a(),P=l("div"),f(se.$$.fragment),at=a(),fe=l("p"),fe.textContent=xt,Se=a(),f(oe.$$.fragment),Ye=a(),_e=l("p"),this.h()},l(e){const t=At("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(n),v=s(e),d=r(e,"P",{}),ge(d).forEach(n),w=s(e),g(I.$$.fragment,e),m=s(e),g(T.$$.fragment,e),be=s(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-nano8w"&&(G.innerHTML=lt),ye=s(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1jcs7ly"&&(C.textContent=rt),Me=s(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-q609lx"&&(W.innerHTML=pt),we=s(e),g(V.$$.fragment,e),ve=s(e),B=r(e,"TABLE",{"data-svelte-h":!0}),p(B)!=="svelte-5p4fpx"&&(B.innerHTML=dt),Ie=s(e),g(X.$$.fragment,e),Te=s(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1bi1ry7"&&(R.innerHTML=ct),Je=s(e),g(N.$$.fragment,e),Pe=s(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-woui0n"&&(L.textContent=mt),xe=s(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-wwfxrb"&&(E.textContent=ut),Ue=s(e),g(S.$$.fragment,e),Ze=s(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1pxzje"&&(Y.textContent=ft),je=s(e),F=r(e,"TABLE",{"data-svelte-h":!0}),p(F)!=="svelte-7kzy88"&&(F.innerHTML=gt),ke=s(e),g(Z.$$.fragment,e),$e=s(e),g(H.$$.fragment,e),Ae=s(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-a52po1"&&(z.innerHTML=ht),Ge=s(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-bwalkj"&&(D.textContent=_t),Ce=s(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1qq4ux4"&&(Q.textContent=bt),We=s(e),g(q.$$.fragment,e),Ve=s(e),O=r(e,"TABLE",{"data-svelte-h":!0}),p(O)!=="svelte-fegy4a"&&(O.innerHTML=yt),Be=s(e),g(j.$$.fragment,e),Xe=s(e),g(K.$$.fragment,e),Re=s(e),u=r(e,"DIV",{class:!0});var M=ge(u);g(ee.$$.fragment,M),De=s(M),re=r(M,"P",{"data-svelte-h":!0}),p(re)!=="svelte-19ipoo4"&&(re.textContent=Mt),Qe=s(M),pe=r(M,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1j65hsb"&&(pe.innerHTML=wt),qe=s(M),de=r(M,"P",{"data-svelte-h":!0}),p(de)!=="svelte-14s6m4u"&&(de.textContent=vt),Oe=s(M),ce=r(M,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-oqms36"&&(ce.innerHTML=It),Ke=s(M),J=r(M,"DIV",{class:!0});var x=ge(J);g(te.$$.fragment,x),et=s(x),me=r(x,"P",{"data-svelte-h":!0}),p(me)!=="svelte-50j04k"&&(me.textContent=Tt),tt=s(x),g(k.$$.fragment,x),x.forEach(n),nt=s(M),$=r(M,"DIV",{class:!0});var le=ge($);g(ne.$$.fragment,le),it=s(le),ue=r(le,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-16q0ax1"&&(ue.textContent=Jt),le.forEach(n),M.forEach(n),Ne=s(e),ie=r(e,"UL",{"data-svelte-h":!0}),p(ie)!=="svelte-1piu0vk"&&(ie.innerHTML=Pt),Le=s(e),g(ae.$$.fragment,e),Ee=s(e),P=r(e,"DIV",{class:!0});var He=ge(P);g(se.$$.fragment,He),at=s(He),fe=r(He,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-6skj8c"&&(fe.textContent=xt),He.forEach(n),Se=s(e),g(oe.$$.fragment,e),Ye=s(e),_e=r(e,"P",{}),ge(_e).forEach(n),this.h()},h(){he(o,"name","hf:doc:metadata"),he(o,"content",Rt),he(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),he($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),he(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),he(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,o),i(e,v,t),i(e,d,t),i(e,w,t),h(I,e,t),i(e,m,t),h(T,e,t),i(e,be,t),i(e,G,t),i(e,ye,t),i(e,C,t),i(e,Me,t),i(e,W,t),i(e,we,t),h(V,e,t),i(e,ve,t),i(e,B,t),i(e,Ie,t),h(X,e,t),i(e,Te,t),i(e,R,t),i(e,Je,t),h(N,e,t),i(e,Pe,t),i(e,L,t),i(e,xe,t),i(e,E,t),i(e,Ue,t),h(S,e,t),i(e,Ze,t),i(e,Y,t),i(e,je,t),i(e,F,t),i(e,ke,t),h(Z,e,t),i(e,$e,t),h(H,e,t),i(e,Ae,t),i(e,z,t),i(e,Ge,t),i(e,D,t),i(e,Ce,t),i(e,Q,t),i(e,We,t),h(q,e,t),i(e,Ve,t),i(e,O,t),i(e,Be,t),h(j,e,t),i(e,Xe,t),h(K,e,t),i(e,Re,t),i(e,u,t),h(ee,u,null),c(u,De),c(u,re),c(u,Qe),c(u,pe),c(u,qe),c(u,de),c(u,Oe),c(u,ce),c(u,Ke),c(u,J),h(te,J,null),c(J,et),c(J,me),c(J,tt),h(k,J,null),c(u,nt),c(u,$),h(ne,$,null),c($,it),c($,ue),i(e,Ne,t),i(e,ie,t),i(e,Le,t),h(ae,e,t),i(e,Ee,t),i(e,P,t),h(se,P,null),c(P,at),c(P,fe),i(e,Se,t),h(oe,e,t),i(e,Ye,t),i(e,_e,t),Fe=!0},p(e,[t]){const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),Z.$set(M);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),j.$set(x);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),k.$set(le)},i(e){Fe||(_(I.$$.fragment,e),_(T.$$.fragment,e),_(V.$$.fragment,e),_(X.$$.fragment,e),_(N.$$.fragment,e),_(S.$$.fragment,e),_(Z.$$.fragment,e),_(H.$$.fragment,e),_(q.$$.fragment,e),_(j.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(k.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(oe.$$.fragment,e),Fe=!0)},o(e){b(I.$$.fragment,e),b(T.$$.fragment,e),b(V.$$.fragment,e),b(X.$$.fragment,e),b(N.$$.fragment,e),b(S.$$.fragment,e),b(Z.$$.fragment,e),b(H.$$.fragment,e),b(q.$$.fragment,e),b(j.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(k.$$.fragment,e),b(ne.$$.fragment,e),b(ae.$$.fragment,e),b(se.$$.fragment,e),b(oe.$$.fragment,e),Fe=!1},d(e){e&&(n(v),n(d),n(w),n(m),n(be),n(G),n(ye),n(C),n(Me),n(W),n(we),n(ve),n(B),n(Ie),n(Te),n(R),n(Je),n(Pe),n(L),n(xe),n(E),n(Ue),n(Ze),n(Y),n(je),n(F),n(ke),n($e),n(Ae),n(z),n(Ge),n(D),n(Ce),n(Q),n(We),n(Ve),n(O),n(Be),n(Xe),n(Re),n(u),n(Ne),n(ie),n(Le),n(Ee),n(P),n(Se),n(Ye),n(_e)),n(o),y(I,e),y(T,e),y(V,e),y(X,e),y(N,e),y(S,e),y(Z,e),y(H,e),y(q,e),y(j,e),y(K,e),y(ee),y(te),y(k),y(ne),y(ae,e),y(se),y(oe,e)}}}const Rt='{"title":"Image-to-Video Generation with PIA (Personalized Image Animator)","local":"image-to-video-generation-with-pia-personalized-image-animator","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Using FreeInit","local":"using-freeinit","sections":[],"depth":2},{"title":"PIAPipeline","local":"diffusers.PIAPipeline","sections":[],"depth":2},{"title":"PIAPipelineOutput","local":"diffusers.pipelines.pia.PIAPipelineOutput","sections":[],"depth":2}],"depth":1}';function Nt(U){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends kt{constructor(o){super(),$t(this,o,Nt,Xt,Zt,{})}}export{Dt as component};
