import{s as ul,f as M,n as Ml,o as Vl}from"../chunks/scheduler.048ce5c2.js";import{S as kl,i as yl,g as p,s as n,r as j,A as xl,h as U,f as a,c as l,j as Fl,u as i,x as o,k as u,y as Hl,a as e,v as s,d as c,t as K,w as R}from"../chunks/index.2633050f.js";import{C as r}from"../chunks/CodeBlock.b34ffc90.js";import{D as Sl}from"../chunks/DocNotebookDropdown.2a84b269.js";import{H as F,E as Pl}from"../chunks/EditOnGithub.336973dd.js";function Gl(ve){let V,Tt,bt,Bt,k,qt,y,zt,x,Le="This notebook is going to cover the basics of how to use Stable Diffusion to create and modify images using existing pipelines. We’ll also take a brief look at the key components within the pipeline, while leaving further exploration of them to the deep dive notebook. Specifically, we will cover:",It,H,Ee="<li>Generating images from text using the <code>StableDiffusionPipeline</code> and experimenting with the available arguments</li> <li>Seeing some of the key pipeline components in action<ul><li>The VAE that makes this a ‘latent diffusion model’</li> <li>The tokenizer and text encoder that process the text prompt</li> <li>The UNet itself</li> <li>The scheduler, and exploring different schedulers</li></ul></li> <li>Replicating the sampling loop with the pipeline components</li> <li>Editing existing images with the Img2Img pipeline</li> <li>Using inpainting and Depth2Img pipelines</li>",Ot,S,_e='❓If you have any questions, please post them on the <code>#diffusion-models-class</code> channel on the Hugging Face Discord server. If you haven’t signed up yet, you can do so here: <a href="https://huggingface.co/join/discord" rel="nofollow">https://huggingface.co/join/discord</a>',ft,P,Nt,G,Zt,m,Xt,g,ht,w,Dt,d,Yt,W,$e='Let’s load a Stable Diffusion pipeline and see what it can do. There are multiple different versions of Stable Diffusion, with the latest at the time of writing being version 2.1. If you’d like to explore an older version, simply replace the model ID with the appropriate model (for example, you could try “CompVis/stable-diffusion-v1-4” or pick a model from the <a href="https://huggingface.co/sd-dreambooth-library" rel="nofollow">dreambooth concepts library</a>).',Qt,b,Ct,J,An="If you’re running out of GPU memory, there are some things you can do to reduce the RAM usage:",vt,T,tn="<li><p>Load the FP16 version (not supported on all systems). With this you may also need to convert tensors to torch.float16 when experimenting with individual components of the pipeline:</p> <p><code>pipe = StableDiffusionPipeline.from_pretrained(model_id, revision=&quot;fp16&quot;, torch_dtype=torch.float16).to(device)</code></p></li> <li><p>Enable attention slicing. This reduces GPU memory usage at the cost of a small reduction in speed:</p> <p><code>pipe.enable_attention_slicing()</code></p></li> <li><p>Reduce the size of the images you’re generating</p></li>",Lt,B,an="Once the pipeline is loaded, we can generate an image based on a prompt with the following code:",Et,q,_t,xt,en,$t,z,nn="<strong>Exercise:</strong> Spend some time playing with the cell above, using your own prompts and tweaking settings to see how they affect the output. Use a different random seed or remove the <code>generator</code> argument to get different results each time.",Aa,I,ln="Key arguments to tweak:",ta,O,pn="<li>Width and height specify the size of the generated image. They must be divisible by <strong>8</strong> for the VAE to work (which we’ll see in a future section).</li> <li>The number of steps influences the generation quality. The default (50) works well, but in some cases you can get away with as few as 20 steps which is handy for experimentation.</li> <li>The negative prompt is used during the classifier-free guidance process, and can be a useful way to add additional control. You can leave it out, but many users find it useful to list some undesirable descriptions in the negative prompt as shown above.</li> <li>The <code>guidance_scale</code> argument determines how strong the classifier-free guidance (CFG) is. Higher scales push the generated images to better match the prompt, but if the scale is too high the results can become over-saturated and unpleasant.</li>",aa,f,Un='If you’re looking for prompt inspiration, the <a href="https://stability.ai/sdv2-prompt-book" rel="nofollow">Stable Diffusion Prompt Book</a> is a good place to start.',ea,N,on="You can see the effect of increasing the guidance scale in the following cell:",na,Z,la,Ht,jn,pa,X,sn="Tweak the values above to try different scales and prompts. Interpretation is subjective of course, but to my eye anything in the 8-12 range produces better results than values below or above this range.",Ua,h,oa,D,cn="The <code>StableDiffusionPipeline</code> we’re using is a little more complex than the <code>DDPMPipeline</code> we’ve explored in the previous units. In addition to the UNet and the scheduler, there are a number of other components included in the pipeline:",ja,Y,ia,Q,Kn=`['vae', 'text_encoder', 'tokenizer', 'unet', 'scheduler', 'safety_checker', 'feature_extractor', 'image_encoder']
`,sa,C,Rn="To better understand how the pipeline works, let’s briefly see each component in action individually and then put them all together to replicate the functionality of the pipeline for ourselves.",ca,v,Ka,L,rn='<img src="data:image/png;base64,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" alt="vae_diagram.png"/>',Ra,E,Fn="The VAE (variational autoencoder) is a type of model that can encode its input into a compressed representation and then decode this ‘latent’ representation back into something close to the original input. When generating images with Stable Diffusion, we first <strong>generate the latents</strong> by applying the diffusion process in the ‘latent space’ of the VAE, and then <strong>decode them at the end</strong> to view the resulting image.",ra,_,un="Here is some code that takes an input image, encodes it to a latent representation and then decodes it again using the VAE:",Fa,$,ua,AA,Mn=`Input images shape: torch.Size([1, 3, 512, 512])
Encoded latents shape: torch.Size([1, 4, 64, 64])
Decoded images shape: torch.Size([1, 3, 512, 512])
`,Ma,tA,Vn="As you can see, the 512x512 image is compressed to a 64x64 latent representation (with four channels). This 8x reduction in each spatial dimension is the reason the specified width and height need to be multiples of 8.",Va,aA,kn="Working with these information-rich 4x64x64 latents is more efficient than working with massive 512px images, allowing for faster diffusion models that take less resources to train and use. The VAE decoding process is not perfect, but it is good enough that the small quality tradeoff is generally worth it.",ka,eA,yn="NB: The code example above includes the scaling factor of 0.18215 required to match the processing used during SD’s training.",ya,nA,xa,lA,xn='<img src="data:image/png;base64,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" alt="text_encoder.png"/>',Ha,pA,Hn="The goal of the text encoder is to turn an input string (the prompt) into a numerical representation that can be fed to the UNet as conditioning. The text is first turned into a series of tokens using the pipeline’s tokenizer. The text encoder has a vocabulary of about 50k tokens - any word isn’t in this vocabulary is split into smaller sub-words. The tokens are then fed through the text encoder model itself - a transformer model that was originally trained as the text encoder for CLIP. The hope is that this pretrained transformer model has learnt rich representations of text that will be useful for the diffusion task too.",Sa,UA,Sn="Let’s test out this process by encoding an example prompt, first manually tokenizing and feeding it through the text encoder and then using the pipelines <code>encode_prompt</code> method to show the full process including padding/truncating the length to the maximum length of 77 tokens:",Pa,oA,Ga,jA,Pn=`Input ID -> decoded token
49406 -> <|startoftext|>
320 -> a
3086 -> painting
539 -> of
320 -> a
4062 -> floo
1059 -> ble
49407 -> <|endoftext|>
Text embeddings shape: torch.Size([1, 8, 1024])
`,ma,iA,ga,sA,Gn="These text embeddings (the so-called ‘hidden states’ of the last transformer block in the text encoder model) will be fed to the UNet as an additional argument to the <code>forward</code> method, which we’ll see in the next section.",wa,cA,da,KA,mn='<img src="data:image/png;base64,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" alt="unet.png"/>',Wa,RA,gn="The UNet takes a noisy input and predicts the noise, just like the UNets we’ve seen in previous units. Unlike those previous examples, the input is not an image but is instead a latent representation of an image. And in addition to the timestep conditioning, this UNet also takes in the text embeddings of the prompt as an additional input. Here it is making predictions on some dummy data:",ba,rA,Ja,FA,wn=`UNet output shape: torch.Size([1, 4, 64, 64])
`,Ta,uA,Ba,MA,dn="The scheduler stores the noise schedule and manages updating the noisy sample based on the model predictions. The default scheduler is a <code>PNDMScheduler</code>, but you can use others (such as <code>LMSDiscreteScheduler</code>) as long as they are initialized with the same configuration.",qa,VA,Wn="We can plot the noise schedule to see the noise level (based on $\\bar{\\alpha}$) over time:",za,kA,Ia,St,bn,Oa,yA,Jn="If you want to try out a different scheduler, you can swap in a new one as follows:",fa,xA,Na,HA,Tn=`Scheduler config: LMSDiscreteScheduler &#123;
  "_class_name": "LMSDiscreteScheduler",
  "_diffusers_version": "0.30.3",
  "beta_end": 0.012,
  "beta_schedule": "scaled_linear",
  "beta_start": 0.00085,
  "clip_sample": false,
  "num_train_timesteps": 1000,
  "prediction_type": "epsilon",
  "set_alpha_to_one": false,
  "skip_prk_steps": true,
  "steps_offset": 1,
  "timestep_spacing": "linspace",
  "trained_betas": null,
  "use_karras_sigmas": false
}
`,Za,SA,Bn='You can read more on using different schedulers <a href="https://huggingface.co/docs/diffusers/using-diffusers/schedulers" rel="nofollow">here</a>.',Xa,PA,ha,GA,qn="Now that we’ve seen all these components in action, we can put them together to replicate the functionality of the pipeline:",Da,mA,Ya,Pt,zn,Qa,gA,In='In most cases it will be easier to use the existing pipelines, but having this hackable sampling loop can be useful for understanding and modifying how each component works. If you’d like to see this code and all the different components explored and modified in depth, check out the ‘Stable Diffusion Deep Dive’ <a href="https://github.com/fastai/diffusion-nbs/blob/master/Stable%20Diffusion%20Deep%20Dive.ipynb" rel="nofollow">notebook</a> and <a href="https://m.youtube.com/watch?v=0_BBRNYInx8" rel="nofollow">video</a> for a more thorough exploration.',Ca,wA,va,dA,On="So what can we do besides just generating images from a prompt? Quite a lot! In this section we’ll demonstrate a few cool pipelines to give you a taste of some of the other tasks that Stable Diffusion can be used for. Several of these require downloading new models, so if you’re in a hurry you can skim through this section just looking at the existing outputs rather than downloading and running all of the models yourself.",La,WA,Ea,bA,fn="In the examples so far, we’ve generated images completely from scratch by starting from random latents and applying the full diffusion sampling loop. But we don’t have to start from scratch. The Img2Img pipeline first encodes an existing image into a set of latents, then adds some noise to the latents and uses that as the starting point. The amount of noise added and the number of denoising steps applied determine the ‘strength’ of the img2img process. Adding just a small amount of noise (low strength) will result in very little change, while adding the maximum amount of noise and running the full denoising process will give an image that hardly resembles the input apart from some similarities on overall structure.",_a,JA,Nn="To better understand the img2img process, let’s manually implement the pipeline. This approach will help clarify how latents are encoded, noise is added, and diffusion is applied. After manually constructing the pipeline, we’ll see how the diffusers library provides a ready-to-use StableDiffusionImg2ImgPipeline for simplicity and efficiency.",$a,TA,Zn="Here’s how you can manually implement the img2img pipeline:",Ae,BA,te,qA,ae,zA,ee,Gt,Xn,ne,IA,hn="Now that we’ve manually implemented the img2img process, let’s see how to achieve the same results more efficiently using the StableDiffusionImg2ImgPipeline provided by the diffusers library.",le,OA,Dn="This pipeline requires no special models, so as long as the model ID is the same as our text-to-image example above, no new files will need to be downloaded.",pe,fA,Ue,NA,oe,ZA,Yn="In the ‘Setup’ section we loaded an example <code>init_image</code> to use for this demo, but you can replace it with your own image if you’d prefer. Here’s the pipeline in  action:",je,XA,ie,mt,Qn,se,hA,Cn="<strong>Exercise:</strong> Experiment with this pipeline. Try your own images, or play with different strengths and prompts. You can use many of the same arguments as the text-to-image pipeline, so feel free to try different sizes, number of steps etc.",ce,DA,Ke,YA,vn="What if we wanted to keep some of the input image unchanged but generate something new in other parts? This is called ‘inpainting’. While it can be done with the same model as the previous demos (via the <code>StableDiffusionInpaintPipelineLegacy</code>), we can get better results by using a custom fine-tuned version of Stable Diffusion that takes a masked image and the mask itself as additional conditioning. The mask image should be the same shape as the input image, with white in the areas to be replaces and black in the areas to be kept unchanged.",Re,QA,Ln="To gain a deeper understanding of the inpainting process, let’s manually implement the logic behind the StableDiffusionInpaintPipelineLegacy. This approach will clarify how inpainting works at a lower level and provide insight into how Stable Diffusion processes inputs. Once we’ve completed this, we’ll explore the fine-tuned pipeline for comparison. Here’s how you can manually implement the inpainting pipeline and apply it to the example image and mask loaded in the ‘Setup’ section:",re,CA,En='<img src="inpaint_from_scratch.png" alt="inpainting from_scratch"/>',Fe,vA,ue,LA,Me,gt,_n,Ve,EA,$n="Write the denoising loop again.",ke,_A,ye,wt,Al,xe,$A,He,At,tl="Now that we’ve manually implemented the inpainting logic, let’s see how to use a fine-tuned pipeline designed specifically for inpainting tasks. Here’s how we load such a pipeline and apply it to the example image and mask loaded in the ‘Setup’ section:",Se,tt,al='<img src="inpaint_w_border.jpg" alt="inpainting unet"/>',Pe,at,Ge,et,me,dt,el,ge,nt,nl='This can be especially powerful when combined with another model to automatically generate masks. For example, <a href="https://huggingface.co/spaces/nielsr/text-based-inpainting" rel="nofollow">this demo space</a> uses a model called CLIPSeg to mask out an object to be replaced based on a text description.',we,lt,de,pt,ll="Exploring different pipelines and model variants can fill up your disk space. You can see which models are currently downloaded with:",We,Ut,be,ot,pl=`models--CompVis--stable-diffusion-v1-4
models--ddpm-bedroom-256
models--google--ddpm-bedroom-256
models--google--ddpm-celebahq-256
models--runwayml--stable-diffusion-inpainting
models--stabilityai--stable-diffusion-2-1-base
`,Je,jt,Ul='Check out <a href="https://huggingface.co/docs/huggingface_hub/main/en/how-to-cache" rel="nofollow">the docs on caching</a> to see how to view and manage your cache effectively.',Te,it,Be,st,ol='<img src="https://camo.githubusercontent.com/50c14634d9ff835abd36693cccbdb12fc153e56226414186012641ab75b70b6f/68747470733a2f2f68756767696e67666163652e636f2f73746162696c69747961692f737461626c652d646966667573696f6e2d322d64657074682f7265736f6c76652f6d61696e2f646570746832696d6167652e706e67" alt="depth to image examples"/> <em>Input image, depth image and generated examples (image source: StabilityAI)</em>',qe,ct,jl="Img2Img is great, but sometimes we want to create a new image with the composition of the original but completely different colours or textures. It can be difficult to find an Img2Img strength that preserves what we’d like of the layout without also keeping the input colors.",ze,Kt,il="Time for another fine-tuned model! This one takes in depth information as additional conditioning when generating. The pipeline uses a depth estimation model to create a depth map, which is then fed to the fine-tuned UNet when generating images to (hopefully) preserve the depth and structure of the initial image while filling in completely new content.",Ie,Rt,Oe,rt,fe,Wt,sl,Ne,Ft,cl='Note how the output compares to the img2img example - here there is much more color variation, but the overall structure is still faithful to the original. This is not ideal in this case since the man has been given some extremely weird anatomy to match the dog shape, but in some cases this is extraordinarily useful. For an example of the ‘killer app’ for this approach, check out <a href="https://twitter.com/CarsonKatri/status/1600248599254007810?s=20&amp;t=BlzSK26sfqi2336SN0gKpQ" rel="nofollow">this tweet</a> showing the depth model being used to texture a 3D scene!',Ze,ut,Xe,Mt,Kl="Hopefully, this has given you a taste of the many things that Stable Diffusion can do! Once you get tired of playing with the examples in this notebook, check out the <strong>DreamBooth hackathon</strong> notebook to see how to fine-tune your own version of Stable Diffusion which can be used with the text-to-image or img2img pipelines we’ve seen here.",he,Vt,Rl="If you’re curious to dig deeper into how the different components work, then check out the <strong>Stable Diffusion Deep Dive</strong> notebook which goes into much more detail and shows some additional tricks we can do.",De,kt,rl="Be sure to share your creations with us and the community!",Ye,yt,Qe,Jt,Ce;return k=new Sl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/diffusion-models-class/blob/unit3/implement_img2img_inpaint/unit3/01_stable_diffusion_introduction.ipynb"}]}}),y=new F({props:{title:"Introduction",local:"introduction",headingTag:"h1"}}),P=new F({props:{title:"Setup",local:"setup",headingTag:"h1"}}),G=new r({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1VcSUyMGRpZmZ1c2VycyUyMGZ0ZnklMjBhY2NlbGVyYXRl",highlighted:"%pip install -Uq diffusers ftfy accelerate",wrap:!1}}),m=new r({props:{code:"JTIzJTIwSW5zdGFsbGluZyUyMHRyYW5zZm9ybWVycyUyMGZyb20lMjBzb3VyY2UlMjBmb3IlMjBub3clMjBzaW5jZSUyMHdlJTIwbmVlZCUyMHRoZSUyMGxhdGVzdCUyMHZlcnNpb24lMjBmb3IlMjBEZXB0aDJJbWclMEElMjVwaXAlMjBpbnN0YWxsJTIwLVVxJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnM=",highlighted:`<span class="hljs-comment"># Installing transformers from source for now since we need the latest version for Depth2Img</span>
%pip install -Uq git+https://github.com/huggingface/transformers`,wrap:!1}}),g=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwbWF0cGxvdGxpYiUyMGltcG9ydCUyMHB5cGxvdCUyMGFzJTIwcGx0JTBBJTBBJTIzJTIwV2UnbGwlMjBiZSUyMGV4cGxvcmluZyUyMGElMjBudW1iZXIlMjBvZiUyMHBpcGVsaW5lcyUyMHRvZGF5ISUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25JbnBhaW50UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZSUyQyUwQSklMEElMEElMEElMjMlMjBXZSdsbCUyMHVzZSUyMGElMjBjb3VwbGUlMjBvZiUyMGRlbW8lMjBpbWFnZXMlMjBsYXRlciUyMGluJTIwdGhlJTIwbm90ZWJvb2slMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBpbWFnZXMlMjBmb3IlMjBpbnBhaW50aW5nJTIwZXhhbXBsZSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW1nX2hlaWdodCUyMCUzRCUyMDUxMiUwQWltZ193aWR0aCUyMCUzRCUyMDUxMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKGltZ19oZWlnaHQlMkMlMjBpbWdfd2lkdGgpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShtYXNrX3VybCkucmVzaXplKChpbWdfaGVpZ2h0JTJDJTIwaW1nX3dpZHRoKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> matplotlib <span class="hljs-keyword">import</span> pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-comment"># We&#x27;ll be exploring a number of pipelines today!</span>
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    StableDiffusionPipeline,
    StableDiffusionImg2ImgPipeline,
    StableDiffusionInpaintPipeline,
    StableDiffusionDepth2ImgPipeline,
)


<span class="hljs-comment"># We&#x27;ll use a couple of demo images later in the notebook</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-comment"># Download images for inpainting example</span>
img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

img_height = <span class="hljs-number">512</span>
img_width = <span class="hljs-number">512</span>

init_image = download_image(img_url).resize((img_height, img_width))
mask_image = download_image(mask_url).resize((img_height, img_width))`,wrap:!1}}),w=new r({props:{code:"JTIzJTIwU2V0JTIwZGV2aWNlJTBBZGV2aWNlJTIwJTNEJTIwJTIybXBzJTIyJTIwaWYlMjB0b3JjaC5iYWNrZW5kcy5tcHMuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjI=",highlighted:`<span class="hljs-comment"># Set device</span>
device = <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>`,wrap:!1}}),d=new F({props:{title:"Generating Images from Text",local:"generating-images-from-text",headingTag:"h1"}}),b=new r({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMHBpcGVsaW5lJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLWJhc2UlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2Up",highlighted:`<span class="hljs-comment"># Load the pipeline</span>
model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-base&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id).to(device)`,wrap:!1}}),q=new r({props:{code:"JTIzJTIwU2V0JTIwdXAlMjBhJTIwZ2VuZXJhdG9yJTIwZm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRGRldmljZSkubWFudWFsX3NlZWQoNDIpJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwcGlwZWxpbmUlMkMlMjBzaG93aW5nJTIwc29tZSUyMG9mJTIwdGhlJTIwYXZhaWxhYmxlJTIwYXJndW1lbnRzJTBBcGlwZV9vdXRwdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMlBhbGV0dGUlMjBrbmlmZSUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGF1dHVtbiUyMGNpdHlzY2FwZSUyMiUyQyUyMCUyMCUyMyUyMFdoYXQlMjB0byUyMGdlbmVyYXRlJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyT3ZlcnNhdHVyYXRlZCUyQyUyMGJsdXJyeSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMjAlMjAlMjMlMjBXaGF0JTIwTk9UJTIwdG8lMjBnZW5lcmF0ZSUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDQ4MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQwJTJDJTIwJTIwJTIzJTIwU3BlY2lmeSUyMHRoZSUyMGltYWdlJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOCUyQyUyMCUyMCUyMyUyMEhvdyUyMHN0cm9uZ2x5JTIwdG8lMjBmb2xsb3clMjB0aGUlMjBwcm9tcHQlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzUlMkMlMjAlMjAlMjMlMjBIb3clMjBtYW55JTIwc3RlcHMlMjB0byUyMHRha2UlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjAlMjAlMjMlMjBGaXhlZCUyMHJhbmRvbSUyMHNlZWQlMEEpJTBBJTBBJTIzJTIwVmlldyUyMHRoZSUyMHJlc3VsdGluZyUyMGltYWdlJTBBcGlwZV9vdXRwdXQuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set up a generator for reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the pipeline, showing some of the available arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_output = pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;Palette knife painting of an autumn cityscape&quot;</span>,  <span class="hljs-comment"># What to generate</span>
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;Oversaturated, blurry, low quality&quot;</span>,  <span class="hljs-comment"># What NOT to generate</span>
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">640</span>,  <span class="hljs-comment"># Specify the image size</span>
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">8</span>,  <span class="hljs-comment"># How strongly to follow the prompt</span>
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">35</span>,  <span class="hljs-comment"># How many steps to take</span>
<span class="hljs-meta">... </span>    generator=generator,  <span class="hljs-comment"># Fixed random seed</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the resulting image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_output.images[<span class="hljs-number">0</span>]`,wrap:!1}}),Z=new r({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBjb21wYXJpbmclMjBndWlkYW5jZSUyMHNjYWxlcyUzQSUwQWNmZ19zY2FsZXMlMjAlM0QlMjAlNUIxLjElMkMlMjA4JTJDJTIwMTIlNUQlMjAlMjAlMjMlMjAlNDBwYXJhbSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjb2xsaWUlMjB3aXRoJTIwYSUyMHBpbmslMjBoYXQlMjIlMjAlMjAlMjMlMjAlNDBwYXJhbSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwbGVuKGNmZ19zY2FsZXMpJTJDJTIwZmlnc2l6ZSUzRCgxNiUyQyUyMDUpKSUwQWZvciUyMGklMkMlMjBheCUyMGluJTIwZW51bWVyYXRlKGF4cyklM0ElMEElMjAlMjAlMjAlMjBpbSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGVpZ2h0JTNENDgwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRGNmZ19zY2FsZXMlNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDM1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRGRldmljZSkubWFudWFsX3NlZWQoNDIpJTJDJTBBJTIwJTIwJTIwJTIwKS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwYXguaW1zaG93KGltKSUwQSUyMCUyMCUyMCUyMGF4LnNldF90aXRsZShmJTIyQ0ZHJTIwU2NhbGUlMjAlN0JjZmdfc2NhbGVzJTVCaSU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown comparing guidance scales:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cfg_scales = [<span class="hljs-number">1.1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">12</span>]  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A collie with a pink hat&quot;</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(cfg_scales), figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, ax <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(axs):
<span class="hljs-meta">... </span>    im = pipe(
<span class="hljs-meta">... </span>        prompt,
<span class="hljs-meta">... </span>        height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>        width=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>        guidance_scale=cfg_scales[i],
<span class="hljs-meta">... </span>        num_inference_steps=<span class="hljs-number">35</span>,
<span class="hljs-meta">... </span>        generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>),
<span class="hljs-meta">... </span>    ).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    ax.imshow(im)
<span class="hljs-meta">... </span>    ax.set_title(<span class="hljs-string">f&quot;CFG Scale <span class="hljs-subst">{cfg_scales[i]}</span>&quot;</span>)`,wrap:!1}}),h=new F({props:{title:"Pipeline Components",local:"pipeline-components",headingTag:"h1"}}),Y=new r({props:{code:"cHJpbnQobGlzdChwaXBlLmNvbXBvbmVudHMua2V5cygpKSklMjAlMjAlMjMlMjBMaXN0JTIwY29tcG9uZW50cw==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(pipe.components.keys()))  <span class="hljs-comment"># List components</span>',wrap:!1}}),v=new F({props:{title:"The VAE",local:"the-vae",headingTag:"h3"}}),$=new r({props:{code:"JTIzJTIwQ3JlYXRlJTIwc29tZSUyMGZha2UlMjBkYXRhJTIwKGElMjByYW5kb20lMjBpbWFnZSUyQyUyMHJhbmdlJTIwKC0xJTJDJTIwMSkpJTBBaW1hZ2VzJTIwJTNEJTIwdG9yY2gucmFuZCgxJTJDJTIwMyUyQyUyMDUxMiUyQyUyMDUxMikudG8oZGV2aWNlKSUyMColMjAyJTIwLSUyMDElMEFwcmludCglMjJJbnB1dCUyMGltYWdlcyUyMHNoYXBlJTNBJTIyJTJDJTIwaW1hZ2VzLnNoYXBlKSUwQSUwQSUyMyUyMEVuY29kZSUyMHRvJTIwbGF0ZW50JTIwc3BhY2UlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbGF0ZW50cyUyMCUzRCUyMDAuMTgyMTUlMjAqJTIwcGlwZS52YWUuZW5jb2RlKGltYWdlcykubGF0ZW50X2Rpc3QubWVhbiUwQXByaW50KCUyMkVuY29kZWQlMjBsYXRlbnRzJTIwc2hhcGUlM0ElMjIlMkMlMjBsYXRlbnRzLnNoYXBlKSUwQSUwQSUyMyUyMERlY29kZSUyMGFnYWluJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGRlY29kZWRfaW1hZ2VzJTIwJTNEJTIwcGlwZS52YWUuZGVjb2RlKGxhdGVudHMlMjAlMkYlMjAwLjE4MjE1KS5zYW1wbGUlMEFwcmludCglMjJEZWNvZGVkJTIwaW1hZ2VzJTIwc2hhcGUlM0ElMjIlMkMlMjBkZWNvZGVkX2ltYWdlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create some fake data (a random image, range (-1, 1))</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.rand(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>).to(device) * <span class="hljs-number">2</span> - <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input images shape:&quot;</span>, images.shape)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Encode to latent space</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    latents = <span class="hljs-number">0.18215</span> * pipe.vae.encode(images).latent_dist.mean
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Encoded latents shape:&quot;</span>, latents.shape)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Decode again</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    decoded_images = pipe.vae.decode(latents / <span class="hljs-number">0.18215</span>).sample
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Decoded images shape:&quot;</span>, decoded_images.shape)`,wrap:!1}}),nA=new F({props:{title:"The Tokenizer and Text Encoder",local:"the-tokenizer-and-text-encoder",headingTag:"h3"}}),oA=new r({props:{code:"JTIzJTIwVG9rZW5pemluZyUyMGFuZCUyMGVuY29kaW5nJTIwYW4lMjBleGFtcGxlJTIwcHJvbXB0JTIwbWFudWFsbHklMEElMEElMjMlMjBUb2tlbml6ZSUwQWlucHV0X2lkcyUyMCUzRCUyMHBpcGUudG9rZW5pemVyKCU1QiUyMkElMjBwYWludGluZyUyMG9mJTIwYSUyMGZsb29ibGUlMjIlNUQpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBcHJpbnQoJTIySW5wdXQlMjBJRCUyMC0lM0UlMjBkZWNvZGVkJTIwdG9rZW4lMjIpJTBBZm9yJTIwaW5wdXRfaWQlMjBpbiUyMGlucHV0X2lkcyU1QjAlNUQlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCaW5wdXRfaWQlN0QlMjAtJTNFJTIwJTdCcGlwZS50b2tlbml6ZXIuZGVjb2RlKGlucHV0X2lkKSU3RCUyMiklMEElMEElMjMlMjBGZWVkJTIwdGhyb3VnaCUyMENMSVAlMjB0ZXh0JTIwZW5jb2RlciUwQWlucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnRlbnNvcihpbnB1dF9pZHMpLnRvKGRldmljZSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwcGlwZS50ZXh0X2VuY29kZXIoaW5wdXRfaWRzKSU1QiUyMmxhc3RfaGlkZGVuX3N0YXRlJTIyJTVEJTBBcHJpbnQoJTIyVGV4dCUyMGVtYmVkZGluZ3MlMjBzaGFwZSUzQSUyMiUyQyUyMHRleHRfZW1iZWRkaW5ncy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tokenizing and encoding an example prompt manually</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tokenize</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = pipe.tokenizer([<span class="hljs-string">&quot;A painting of a flooble&quot;</span>])[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input ID -&gt; decoded token&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> input_id <span class="hljs-keyword">in</span> input_ids[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{input_id}</span> -&gt; <span class="hljs-subst">{pipe.tokenizer.decode(input_id)}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Feed through CLIP text encoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor(input_ids).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = pipe.text_encoder(input_ids)[<span class="hljs-string">&quot;last_hidden_state&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Text embeddings shape:&quot;</span>, text_embeddings.shape)`,wrap:!1}}),iA=new r({props:{code:"JTIzJTIwR2V0JTIwdGhlJTIwZmluYWwlMjB0ZXh0JTIwZW1iZWRkaW5ncyUyMHVzaW5nJTIwdGhlJTIwcGlwZWxpbmUncyUyMGVuY29kZV9wcm9tcHQlMjBmdW5jdGlvbiUwQXRleHRfZW1iZWRkaW5ncyUyMCUzRCUyMHBpcGUuX2VuY29kZV9wcm9tcHQoJTIyQSUyMHBhaW50aW5nJTIwb2YlMjBhJTIwZmxvb2JsZSUyMiUyQyUyMGRldmljZSUyQyUyMDElMkMlMjBUcnVlJTJDJTIwJTIyJTIyKSUwQXRleHRfZW1iZWRkaW5ncy5zaGFwZQ==",highlighted:`<span class="hljs-comment"># Get the final text embeddings using the pipeline&#x27;s encode_prompt function</span>
text_embeddings = pipe._encode_prompt(<span class="hljs-string">&quot;A painting of a flooble&quot;</span>, device, <span class="hljs-number">1</span>, <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;&quot;</span>)
text_embeddings.shape`,wrap:!1}}),cA=new F({props:{title:"The UNet",local:"the-unet",headingTag:"h3"}}),rA=new r({props:{code:"JTIzJTIwRHVtbXklMjBpbnB1dHMlMEF0aW1lc3RlcCUyMCUzRCUyMHBpcGUuc2NoZWR1bGVyLnRpbWVzdGVwcyU1QjAlNUQlMEFsYXRlbnRzJTIwJTNEJTIwdG9yY2gucmFuZG4oMSUyQyUyMDQlMkMlMjA2NCUyQyUyMDY0KS50byhkZXZpY2UpJTBBdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gucmFuZG4oMSUyQyUyMDc3JTJDJTIwMTAyNCkudG8oZGV2aWNlKSUwQSUwQSUyMyUyME1vZGVsJTIwcHJlZGljdGlvbiUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjB1bmV0X291dHB1dCUyMCUzRCUyMHBpcGUudW5ldChsYXRlbnRzJTJDJTIwdGltZXN0ZXAlMkMlMjB0ZXh0X2VtYmVkZGluZ3MpLnNhbXBsZSUwQXByaW50KCUyMlVOZXQlMjBvdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHVuZXRfb3V0cHV0LnNoYXBlKSUyMCUyMCUyMyUyMFNhbWUlMjBzaGFwZSUyMGFzJTIwdGhlJTIwaW5wdXQlMjBsYXRlbnRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Dummy inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>timestep = pipe.scheduler.timesteps[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">77</span>, <span class="hljs-number">1024</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    unet_output = pipe.unet(latents, timestep, text_embeddings).sample
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;UNet output shape:&quot;</span>, unet_output.shape)  <span class="hljs-comment"># Same shape as the input latents</span>`,wrap:!1}}),uA=new F({props:{title:"The Scheduler",local:"the-scheduler",headingTag:"h3"}}),kA=new r({props:{code:"cGx0LnBsb3QocGlwZS5zY2hlZHVsZXIuYWxwaGFzX2N1bXByb2QlMkMlMjBsYWJlbCUzRHIlMjIlMjQlNUNiYXIlN0IlNUNhbHBoYSU3RCUyNCUyMiklMEFwbHQueGxhYmVsKCUyMlRpbWVzdGVwJTIwKGhpZ2glMjBub2lzZSUyMHRvJTIwbG93JTIwbm9pc2UlMjAtJTNFKSUyMiklMEFwbHQudGl0bGUoJTIyTm9pc2UlMjBzY2hlZHVsZSUyMiklMEFwbHQubGVnZW5kKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot(pipe.scheduler.alphas_cumprod, label=<span class="hljs-string">r&quot;$\\bar{\\alpha}$&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.xlabel(<span class="hljs-string">&quot;Timestep (high noise to low noise -&gt;)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Noise schedule&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.legend()`,wrap:!1}}),xA=new r({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTBBJTBBJTIzJTIwUmVwbGFjZSUyMHRoZSUyMHNjaGVkdWxlciUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTE1TRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQSUyMyUyMFByaW50JTIwdGhlJTIwY29uZmlnJTBBcHJpbnQoJTIyU2NoZWR1bGVyJTIwY29uZmlnJTNBJTIyJTJDJTIwcGlwZS5zY2hlZHVsZXIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwd2l0aCUyMHRoaXMlMjBuZXclMjBzY2hlZHVsZXIlMEFwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMlBhbGV0dGUlMjBrbmlmZSUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMHdpbnRlciUyMGNpdHlzY2FwZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDQ4MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENDgwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRGRldmljZSkubWFudWFsX3NlZWQoNDIpJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Replace the scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = LMSDiscreteScheduler.from_config(pipe.scheduler.config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print the config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Scheduler config:&quot;</span>, pipe.scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image with this new scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;Palette knife painting of an winter cityscape&quot;</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>),
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),PA=new F({props:{title:"A DIY Sampling Loop",local:"a-diy-sampling-loop",headingTag:"h3"}}),mA=new r({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">8</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">30</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Beautiful picture of a wave breaking&quot;</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;zoomed in, blurry, oversaturated, warped&quot;</span>  <span class="hljs-comment"># @param</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Encode the prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = pipe._encode_prompt(prompt, device, <span class="hljs-number">1</span>, <span class="hljs-literal">True</span>, negative_prompt)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create our random starting point</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=device, generator=generator)
<span class="hljs-meta">&gt;&gt;&gt; </span>latents *= pipe.scheduler.init_noise_sigma

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare the scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler.set_timesteps(num_inference_steps, device=device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loop through the sampling timesteps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pipe.scheduler.timesteps):

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Expand the latents if we are doing classifier free guidance</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Apply any scaling required by the scheduler</span>
<span class="hljs-meta">... </span>    latent_model_input = pipe.scheduler.scale_model_input(latent_model_input, t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Predict the noise residual with the UNet</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = pipe.unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = pipe.scheduler.step(noise_pred, t, latents).prev_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Decode the resulting latents into an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    image = pipe.decode_latents(latents.detach())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.numpy_to_pil(image)[<span class="hljs-number">0</span>]`,wrap:!1}}),wA=new F({props:{title:"Additonal Pipelines",local:"additonal-pipelines",headingTag:"h1"}}),WA=new F({props:{title:"Img2Img",local:"img2img",headingTag:"h2"}}),BA=new F({props:{title:"A DIY Img2Img Loop",local:"a-diy-img2img-loop",headingTag:"h3"}}),qA=new r({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwRW5jb2RlJTIwaW5pdF9pbWFnZSUwQWluaXRfaW1hZ2VfdGVuc29yJTIwJTNEJTIwdG9yY2guZnJvbV9udW1weShucC5hcnJheShpbml0X2ltYWdlKS50cmFuc3Bvc2UoMiUyQyUyMDAlMkMlMjAxKSkuZmxvYXQoKSUyMCUyRiUyMDI1NS4wJTIwJTIwJTIzJTIwMH4yNTUlMjAlM0QlM0UlMjAwfjElMEFpbml0X2ltYWdlX3RlbnNvciUyMCUzRCUyMDIuMCUyMColMjBpbml0X2ltYWdlX3RlbnNvciUyMC0lMjAxLjAlMjAlMjAlMjMlMjAwfjElMjAlM0QlM0UlMjAtMX4xJTBBaW5pdF9pbWFnZV90ZW5zb3IlMjAlM0QlMjBpbml0X2ltYWdlX3RlbnNvci51bnNxdWVlemUoMCkudG8oZGV2aWNlKSUyMCUyMCUyMyUyMGFkZCUyMGJhdGNoJTIwZGltLiUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbml0X2ltYWdlX2xhdGVudHMlMjAlM0QlMjBwaXBlLnZhZS5lbmNvZGUoaW5pdF9pbWFnZV90ZW5zb3IpLmxhdGVudF9kaXN0LnNhbXBsZSgpJTIwKiUyMHBpcGUudmFlLmNvbmZpZy5zY2FsaW5nX2ZhY3Rvcg==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># Encode init_image</span>
init_image_tensor = torch.from_numpy(np.array(init_image).transpose(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)).<span class="hljs-built_in">float</span>() / <span class="hljs-number">255.0</span>  <span class="hljs-comment"># 0~255 =&gt; 0~1</span>
init_image_tensor = <span class="hljs-number">2.0</span> * init_image_tensor - <span class="hljs-number">1.0</span>  <span class="hljs-comment"># 0~1 =&gt; -1~1</span>
init_image_tensor = init_image_tensor.unsqueeze(<span class="hljs-number">0</span>).to(device)  <span class="hljs-comment"># add batch dim.</span>

<span class="hljs-keyword">with</span> torch.no_grad():
    init_image_latents = pipe.vae.encode(init_image_tensor).latent_dist.sample() * pipe.vae.config.scaling_factor`,wrap:!1}}),zA=new r({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">7.5</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">30</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>strength = <span class="hljs-number">0.6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;An oil painting of a man on a bench&quot;</span>  <span class="hljs-comment"># @param</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Encode the prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = pipe._encode_prompt(prompt, device, <span class="hljs-number">1</span>, <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare the scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler.set_timesteps(num_inference_steps, device=device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare latent variables</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We don&#x27;t use all timesteps in the noise scheduler.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Calculate a subset of timesteps based on \`strength\` to apply to the initial image.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_timestep = <span class="hljs-built_in">min</span>(<span class="hljs-built_in">int</span>(num_inference_steps * strength), num_inference_steps)
<span class="hljs-meta">&gt;&gt;&gt; </span>t_start = <span class="hljs-built_in">max</span>(num_inference_steps - init_timestep, <span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = pipe.scheduler.timesteps[t_start:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The first timestep of the new timesteps will be the starting point for adding noise to the initial image.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>latent_timestep = timesteps[:<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Add noise to init_image_latents at the noise level specified by latent_timestep.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=device, generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>latents = pipe.scheduler.add_noise(init_image_latents, noise, latent_timestep)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loop through the sampling timesteps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(timesteps):

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Expand the latents if we are doing classifier free guidance</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Apply any scaling required by the scheduler</span>
<span class="hljs-meta">... </span>    latent_model_input = pipe.scheduler.scale_model_input(latent_model_input, t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Predict the noise residual with the UNet</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = pipe.unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = pipe.scheduler.step(noise_pred, t, latents).prev_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Decode latents</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>latents_norm = latents / pipe.vae.config.scaling_factor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    result_image = pipe.vae.decode(latents_norm).sample

<span class="hljs-meta">&gt;&gt;&gt; </span>result_image = (result_image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>result_image = (result_image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>result_image = Image.fromarray(result_image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(init_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input Image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(result_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Result&quot;</span>)`,wrap:!1}}),fA=new F({props:{title:"Img2Img Pipeline",local:"img2img-pipeline",headingTag:"h3"}}),NA=new r({props:{code:"JTIzJTIwTG9hZGluZyUyMGFuJTIwSW1nMkltZyUyMHBpcGVsaW5lJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLWJhc2UlMjIlMEFpbWcyaW1nX3BpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2Up",highlighted:`<span class="hljs-comment"># Loading an Img2Img pipeline</span>
model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-base&quot;</span>
img2img_pipe = StableDiffusionImg2ImgPipeline.from_pretrained(model_id).to(device)`,wrap:!1}}),XA=new r({props:{code:"JTIzJTIwQXBwbHklMjBJbWcySW1nJTBBcmVzdWx0X2ltYWdlJTIwJTNEJTIwaW1nMmltZ19waXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkFuJTIwb2lsJTIwcGFpbnRpbmclMjBvZiUyMGElMjBtYW4lMjBvbiUyMGElMjBiZW5jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMCUyMCUyMyUyMFRoZSUyMHN0YXJ0aW5nJTIwaW1hZ2UlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUyMCUyMCUyMyUyMDAlMjBmb3IlMjBubyUyMGNoYW5nZSUyQyUyMDEuMCUyMGZvciUyMG1heCUyMHN0cmVuZ3RoJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBJTIzJTIwVmlldyUyMHRoZSUyMHJlc3VsdCUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwMiUyQyUyMGZpZ3NpemUlM0QoMTIlMkMlMjA1KSklMEFheHMlNUIwJTVELmltc2hvdyhpbml0X2ltYWdlKSUwQWF4cyU1QjAlNUQuc2V0X3RpdGxlKCUyMklucHV0JTIwSW1hZ2UlMjIpJTBBYXhzJTVCMSU1RC5pbXNob3cocmVzdWx0X2ltYWdlKSUwQWF4cyU1QjElNUQuc2V0X3RpdGxlKCUyMlJlc3VsdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply Img2Img</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result_image = img2img_pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;An oil painting of a man on a bench&quot;</span>,
<span class="hljs-meta">... </span>    image=init_image,  <span class="hljs-comment"># The starting image</span>
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.6</span>,  <span class="hljs-comment"># 0 for no change, 1.0 for max strength</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(init_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input Image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(result_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Result&quot;</span>)`,wrap:!1}}),DA=new F({props:{title:"In-Painting",local:"in-painting",headingTag:"h2"}}),vA=new F({props:{title:"A DIY Inpainting Loop",local:"a-diy-inpainting-loop",headingTag:"h3"}}),LA=new r({props:{code:"JTIzJTIwUmVzaXplJTIwbWFzayUyMGltYWdlJTBBbWFza19pbWFnZV9sYXRlbnRfc2l6ZSUyMCUzRCUyMG1hc2tfaW1hZ2UucmVzaXplKCg2NCUyQyUyMDY0KSklMEFtYXNrX2ltYWdlX2xhdGVudF9zaXplJTIwJTNEJTIwdG9yY2gudGVuc29yKChucC5hcnJheShtYXNrX2ltYWdlX2xhdGVudF9zaXplKSU1Qi4uLiUyQyUyMDAlNUQlMjAlM0UlMjA1KS5hc3R5cGUobnAuZmxvYXQzMikpJTBBcGx0Lmltc2hvdyhtYXNrX2ltYWdlX2xhdGVudF9zaXplLm51bXB5KCklMkMlMjBjbWFwJTNEJTIyZ3JheSUyMiklMEElMEFtYXNrX2ltYWdlX2xhdGVudF9zaXplJTIwJTNEJTIwbWFza19pbWFnZV9sYXRlbnRfc2l6ZS50byhkZXZpY2UpJTBBbWFza19pbWFnZV9sYXRlbnRfc2l6ZS5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Resize mask image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image_latent_size = mask_image.resize((<span class="hljs-number">64</span>, <span class="hljs-number">64</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image_latent_size = torch.tensor((np.array(mask_image_latent_size)[..., <span class="hljs-number">0</span>] &gt; <span class="hljs-number">5</span>).astype(np.float32))
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(mask_image_latent_size.numpy(), cmap=<span class="hljs-string">&quot;gray&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image_latent_size = mask_image_latent_size.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image_latent_size.shape`,wrap:!1}}),_A=new r({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">8</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">30</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small robot, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;zoomed in, blurry, oversaturated, warped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Encode the prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = pipe._encode_prompt(prompt, device, <span class="hljs-number">1</span>, <span class="hljs-literal">True</span>, negative_prompt)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create our random starting point</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=device, generator=generator)
<span class="hljs-meta">&gt;&gt;&gt; </span>latents *= pipe.scheduler.init_noise_sigma

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare the scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler.set_timesteps(num_inference_steps, device=device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pipe.scheduler.timesteps):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Expand the latents if we are doing classifier free guidance</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Apply any scaling required by the scheduler</span>
<span class="hljs-meta">... </span>    latent_model_input = pipe.scheduler.scale_model_input(latent_model_input, t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Predict the noise residual with the UNet</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = pipe.unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = pipe.scheduler.step(noise_pred, t, latents, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Perform inpainting to fill in the masked areas</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> i &lt; <span class="hljs-built_in">len</span>(pipe.scheduler.timesteps) - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># Add noise to the original image&#x27;s latent at the previous timestep t-1</span>
<span class="hljs-meta">... </span>        noise = torch.randn(init_image_latents.shape, generator=generator, device=device, dtype=torch.float32)
<span class="hljs-meta">... </span>        background = pipe.scheduler.add_noise(
<span class="hljs-meta">... </span>            init_image_latents, noise, torch.tensor([pipe.scheduler.timesteps[i + <span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>        )

<span class="hljs-meta">... </span>        latents = latents * mask_image_latent_size  <span class="hljs-comment"># white in the areas</span>
<span class="hljs-meta">... </span>        background = background * (<span class="hljs-number">1</span> - mask_image_latent_size)  <span class="hljs-comment"># black in the areas</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Combine the generated and original image latents based on the mask</span>
<span class="hljs-meta">... </span>        latents += background

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Decode latents</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>latents_norm = latents / pipe.vae.config.scaling_factor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    inpainted_image = pipe.vae.decode(latents_norm).sample

<span class="hljs-meta">&gt;&gt;&gt; </span>inpainted_image = (inpainted_image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>inpainted_image = (inpainted_image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>inpainted_image = Image.fromarray(inpainted_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>inpainted_image`,wrap:!1}}),$A=new F({props:{title:"Inpainting Pipeline",local:"inpainting-pipeline",headingTag:"h3"}}),at=new r({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMGlucGFpbnRpbmclMjBwaXBlbGluZSUyMChyZXF1aXJlcyUyMGElMjBzdWl0YWJsZSUyMGlucGFpbnRpbmclMjBtb2RlbCklMEElMjMlMjBwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiklMEElMEElMjMlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyMGlzJTIwbm8lMjBsb25nZXIlMjBhdmFpbGFibGUuJTBBJTIzJTIwVGhlcmVmb3JlJTJDJTIwd2UlMjBhcmUlMjB1c2luZyUyMHRoZSUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yLWlucGFpbnRpbmclMjIlMjBtb2RlbCUyMGluc3RlYWQuJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItaW5wYWludGluZyUyMiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2Up",highlighted:`<span class="hljs-comment"># Load the inpainting pipeline (requires a suitable inpainting model)</span>
<span class="hljs-comment"># pipe = StableDiffusionInpaintPipeline.from_pretrained(&quot;runwayml/stable-diffusion-inpainting&quot;)</span>

<span class="hljs-comment"># &quot;runwayml/stable-diffusion-inpainting&quot; is no longer available.</span>
<span class="hljs-comment"># Therefore, we are using the &quot;stabilityai/stable-diffusion-2-inpainting&quot; model instead.</span>
pipe = StableDiffusionInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-inpainting&quot;</span>)
pipe = pipe.to(device)`,wrap:!1}}),et=new r({props:{code:"JTIzJTIwSW5wYWludCUyMHdpdGglMjBhJTIwcHJvbXB0JTIwZm9yJTIwd2hhdCUyMHdlJTIwd2FudCUyMHRoZSUyMHJlc3VsdCUyMHRvJTIwbG9vayUyMGxpa2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc21hbGwlMjByb2JvdCUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTJDJTIwc2l0dGluZyUyMG9uJTIwYSUyMHBhcmslMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQSUwQSUyMyUyMFZpZXclMjB0aGUlMjByZXN1bHQlMEFmaWclMkMlMjBheHMlMjAlM0QlMjBwbHQuc3VicGxvdHMoMSUyQyUyMDMlMkMlMjBmaWdzaXplJTNEKDE2JTJDJTIwNSkpJTBBYXhzJTVCMCU1RC5pbXNob3coaW5pdF9pbWFnZSklMEFheHMlNUIwJTVELnNldF90aXRsZSglMjJJbnB1dCUyMEltYWdlJTIyKSUwQWF4cyU1QjElNUQuaW1zaG93KG1hc2tfaW1hZ2UpJTBBYXhzJTVCMSU1RC5zZXRfdGl0bGUoJTIyTWFzayUyMiklMEFheHMlNUIyJTVELmltc2hvdyhpbWFnZSklMEFheHMlNUIyJTVELnNldF90aXRsZSglMjJSZXN1bHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Inpaint with a prompt for what we want the result to look like</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small robot, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(init_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input Image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(mask_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">2</span>].imshow(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">2</span>].set_title(<span class="hljs-string">&quot;Result&quot;</span>)`,wrap:!1}}),lt=new F({props:{title:"Aside: Managing Your Model Cache",local:"aside-managing-your-model-cache",headingTag:"h3"}}),Ut=new r({props:{code:"IWxzJTIwfiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGaHViJTJGJTIwJTIzJTIwTGlzdCUyMHRoZSUyMGNvbnRlbnRzJTIwb2YlMjB0aGUlMjBjYWNoZSUyMGRpcmVjdG9yeQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!ls ~/.cache/huggingface/hub/ <span class="hljs-comment"># List the contents of the cache directory</span>',wrap:!1}}),it=new F({props:{title:"Depth2Image",local:"depth2image",headingTag:"h2"}}),Rt=new r({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMERlcHRoMkltZyUyMHBpcGVsaW5lJTIwKHJlcXVpcmVzJTIwYSUyMHN1aXRhYmxlJTIwbW9kZWwpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkRlcHRoMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi1kZXB0aCUyMiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2Up",highlighted:`<span class="hljs-comment"># Load the Depth2Img pipeline (requires a suitable model)</span>
pipe = StableDiffusionDepth2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-depth&quot;</span>)
pipe = pipe.to(device)`,wrap:!1}}),rt=new r({props:{code:"JTIzJTIwSW5wYWludCUyMHdpdGglMjBhJTIwcHJvbXB0JTIwZm9yJTIwd2hhdCUyMHdlJTIwd2FudCUyMHRoZSUyMHJlc3VsdCUyMHRvJTIwbG9vayUyMGxpa2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJBbiUyMG9pbCUyMHBhaW50aW5nJTIwb2YlMjBhJTIwbWFuJTIwb24lMjBhJTIwYmVuY2glMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBJTBBJTIzJTIwVmlldyUyMHRoZSUyMHJlc3VsdCUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwMiUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA1KSklMEFheHMlNUIwJTVELmltc2hvdyhpbml0X2ltYWdlKSUwQWF4cyU1QjAlNUQuc2V0X3RpdGxlKCUyMklucHV0JTIwSW1hZ2UlMjIpJTBBYXhzJTVCMSU1RC5pbXNob3coaW1hZ2UpJTBBYXhzJTVCMSU1RC5zZXRfdGl0bGUoJTIyUmVzdWx0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Inpaint with a prompt for what we want the result to look like</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;An oil painting of a man on a bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">5</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].imshow(init_image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&quot;Input Image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].imshow(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">&quot;Result&quot;</span>)`,wrap:!1}}),ut=new F({props:{title:"Where Next?",local:"where-next",headingTag:"h1"}}),yt=new Pl({props:{source:"https://github.com/huggingface/diffusion-models-class/blob/main/unit3/01_stable_diffusion_introduction.md"}}),{c(){V=p("meta"),Tt=n(),bt=p("p"),Bt=n(),j(k.$$.fragment),qt=n(),j(y.$$.fragment),zt=n(),x=p("p"),x.textContent=Le,It=n(),H=p("ul"),H.innerHTML=Ee,Ot=n(),S=p("p"),S.innerHTML=_e,ft=n(),j(P.$$.fragment),Nt=n(),j(G.$$.fragment),Zt=n(),j(m.$$.fragment),Xt=n(),j(g.$$.fragment),ht=n(),j(w.$$.fragment),Dt=n(),j(d.$$.fragment),Yt=n(),W=p("p"),W.innerHTML=$e,Qt=n(),j(b.$$.fragment),Ct=n(),J=p("p"),J.textContent=An,vt=n(),T=p("ul"),T.innerHTML=tn,Lt=n(),B=p("p"),B.textContent=an,Et=n(),j(q.$$.fragment),_t=n(),xt=p("img"),$t=n(),z=p("p"),z.innerHTML=nn,Aa=n(),I=p("p"),I.textContent=ln,ta=n(),O=p("ul"),O.innerHTML=pn,aa=n(),f=p("p"),f.innerHTML=Un,ea=n(),N=p("p"),N.textContent=on,na=n(),j(Z.$$.fragment),la=n(),Ht=p("img"),pa=n(),X=p("p"),X.textContent=sn,Ua=n(),j(h.$$.fragment),oa=n(),D=p("p"),D.innerHTML=cn,ja=n(),j(Y.$$.fragment),ia=n(),Q=p("pre"),Q.textContent=Kn,sa=n(),C=p("p"),C.textContent=Rn,ca=n(),j(v.$$.fragment),Ka=n(),L=p("p"),L.innerHTML=rn,Ra=n(),E=p("p"),E.innerHTML=Fn,ra=n(),_=p("p"),_.textContent=un,Fa=n(),j($.$$.fragment),ua=n(),AA=p("pre"),AA.textContent=Mn,Ma=n(),tA=p("p"),tA.textContent=Vn,Va=n(),aA=p("p"),aA.textContent=kn,ka=n(),eA=p("p"),eA.textContent=yn,ya=n(),j(nA.$$.fragment),xa=n(),lA=p("p"),lA.innerHTML=xn,Ha=n(),pA=p("p"),pA.textContent=Hn,Sa=n(),UA=p("p"),UA.innerHTML=Sn,Pa=n(),j(oA.$$.fragment),Ga=n(),jA=p("pre"),jA.textContent=Pn,ma=n(),j(iA.$$.fragment),ga=n(),sA=p("p"),sA.innerHTML=Gn,wa=n(),j(cA.$$.fragment),da=n(),KA=p("p"),KA.innerHTML=mn,Wa=n(),RA=p("p"),RA.textContent=gn,ba=n(),j(rA.$$.fragment),Ja=n(),FA=p("pre"),FA.textContent=wn,Ta=n(),j(uA.$$.fragment),Ba=n(),MA=p("p"),MA.innerHTML=dn,qa=n(),VA=p("p"),VA.textContent=Wn,za=n(),j(kA.$$.fragment),Ia=n(),St=p("img"),Oa=n(),yA=p("p"),yA.textContent=Jn,fa=n(),j(xA.$$.fragment),Na=n(),HA=p("pre"),HA.textContent=Tn,Za=n(),SA=p("p"),SA.innerHTML=Bn,Xa=n(),j(PA.$$.fragment),ha=n(),GA=p("p"),GA.textContent=qn,Da=n(),j(mA.$$.fragment),Ya=n(),Pt=p("img"),Qa=n(),gA=p("p"),gA.innerHTML=In,Ca=n(),j(wA.$$.fragment),va=n(),dA=p("p"),dA.textContent=On,La=n(),j(WA.$$.fragment),Ea=n(),bA=p("p"),bA.textContent=fn,_a=n(),JA=p("p"),JA.textContent=Nn,$a=n(),TA=p("p"),TA.textContent=Zn,Ae=n(),j(BA.$$.fragment),te=n(),j(qA.$$.fragment),ae=n(),j(zA.$$.fragment),ee=n(),Gt=p("img"),ne=n(),IA=p("p"),IA.textContent=hn,le=n(),OA=p("p"),OA.textContent=Dn,pe=n(),j(fA.$$.fragment),Ue=n(),j(NA.$$.fragment),oe=n(),ZA=p("p"),ZA.innerHTML=Yn,je=n(),j(XA.$$.fragment),ie=n(),mt=p("img"),se=n(),hA=p("p"),hA.innerHTML=Cn,ce=n(),j(DA.$$.fragment),Ke=n(),YA=p("p"),YA.innerHTML=vn,Re=n(),QA=p("p"),QA.textContent=Ln,re=n(),CA=p("p"),CA.innerHTML=En,Fe=n(),j(vA.$$.fragment),ue=n(),j(LA.$$.fragment),Me=n(),gt=p("img"),Ve=n(),EA=p("p"),EA.textContent=$n,ke=n(),j(_A.$$.fragment),ye=n(),wt=p("img"),xe=n(),j($A.$$.fragment),He=n(),At=p("p"),At.textContent=tl,Se=n(),tt=p("p"),tt.innerHTML=al,Pe=n(),j(at.$$.fragment),Ge=n(),j(et.$$.fragment),me=n(),dt=p("img"),ge=n(),nt=p("p"),nt.innerHTML=nl,we=n(),j(lt.$$.fragment),de=n(),pt=p("p"),pt.textContent=ll,We=n(),j(Ut.$$.fragment),be=n(),ot=p("pre"),ot.textContent=pl,Je=n(),jt=p("p"),jt.innerHTML=Ul,Te=n(),j(it.$$.fragment),Be=n(),st=p("p"),st.innerHTML=ol,qe=n(),ct=p("p"),ct.textContent=jl,ze=n(),Kt=p("p"),Kt.textContent=il,Ie=n(),j(Rt.$$.fragment),Oe=n(),j(rt.$$.fragment),fe=n(),Wt=p("img"),Ne=n(),Ft=p("p"),Ft.innerHTML=cl,Ze=n(),j(ut.$$.fragment),Xe=n(),Mt=p("p"),Mt.innerHTML=Kl,he=n(),Vt=p("p"),Vt.innerHTML=Rl,De=n(),kt=p("p"),kt.textContent=rl,Ye=n(),j(yt.$$.fragment),Qe=n(),Jt=p("p"),this.h()},l(A){const t=xl("svelte-u9bgzb",document.head);V=U(t,"META",{name:!0,content:!0}),t.forEach(a),Tt=l(A),bt=U(A,"P",{}),Fl(bt).forEach(a),Bt=l(A),i(k.$$.fragment,A),qt=l(A),i(y.$$.fragment,A),zt=l(A),x=U(A,"P",{"data-svelte-h":!0}),o(x)!=="svelte-13zutmb"&&(x.textContent=Le),It=l(A),H=U(A,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-qxbwwf"&&(H.innerHTML=Ee),Ot=l(A),S=U(A,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1hvsyk8"&&(S.innerHTML=_e),ft=l(A),i(P.$$.fragment,A),Nt=l(A),i(G.$$.fragment,A),Zt=l(A),i(m.$$.fragment,A),Xt=l(A),i(g.$$.fragment,A),ht=l(A),i(w.$$.fragment,A),Dt=l(A),i(d.$$.fragment,A),Yt=l(A),W=U(A,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1ronjoi"&&(W.innerHTML=$e),Qt=l(A),i(b.$$.fragment,A),Ct=l(A),J=U(A,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1az4jf5"&&(J.textContent=An),vt=l(A),T=U(A,"UL",{"data-svelte-h":!0}),o(T)!=="svelte-17074yf"&&(T.innerHTML=tn),Lt=l(A),B=U(A,"P",{"data-svelte-h":!0}),o(B)!=="svelte-mm99mw"&&(B.textContent=an),Et=l(A),i(q.$$.fragment,A),_t=l(A),xt=U(A,"IMG",{src:!0}),$t=l(A),z=U(A,"P",{"data-svelte-h":!0}),o(z)!=="svelte-o3byjt"&&(z.innerHTML=nn),Aa=l(A),I=U(A,"P",{"data-svelte-h":!0}),o(I)!=="svelte-74qmfi"&&(I.textContent=ln),ta=l(A),O=U(A,"UL",{"data-svelte-h":!0}),o(O)!=="svelte-mvb8f2"&&(O.innerHTML=pn),aa=l(A),f=U(A,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1818j2u"&&(f.innerHTML=Un),ea=l(A),N=U(A,"P",{"data-svelte-h":!0}),o(N)!=="svelte-g3pzoo"&&(N.textContent=on),na=l(A),i(Z.$$.fragment,A),la=l(A),Ht=U(A,"IMG",{src:!0}),pa=l(A),X=U(A,"P",{"data-svelte-h":!0}),o(X)!=="svelte-k1sql4"&&(X.textContent=sn),Ua=l(A),i(h.$$.fragment,A),oa=l(A),D=U(A,"P",{"data-svelte-h":!0}),o(D)!=="svelte-o1245q"&&(D.innerHTML=cn),ja=l(A),i(Y.$$.fragment,A),ia=l(A),Q=U(A,"PRE",{"data-svelte-h":!0}),o(Q)!=="svelte-bpx4h5"&&(Q.textContent=Kn),sa=l(A),C=U(A,"P",{"data-svelte-h":!0}),o(C)!=="svelte-5jj8bj"&&(C.textContent=Rn),ca=l(A),i(v.$$.fragment,A),Ka=l(A),L=U(A,"P",{"data-svelte-h":!0}),o(L)!=="svelte-mzckjv"&&(L.innerHTML=rn),Ra=l(A),E=U(A,"P",{"data-svelte-h":!0}),o(E)!=="svelte-12e2em"&&(E.innerHTML=Fn),ra=l(A),_=U(A,"P",{"data-svelte-h":!0}),o(_)!=="svelte-17ucvne"&&(_.textContent=un),Fa=l(A),i($.$$.fragment,A),ua=l(A),AA=U(A,"PRE",{"data-svelte-h":!0}),o(AA)!=="svelte-1fyixd1"&&(AA.textContent=Mn),Ma=l(A),tA=U(A,"P",{"data-svelte-h":!0}),o(tA)!=="svelte-ug4iba"&&(tA.textContent=Vn),Va=l(A),aA=U(A,"P",{"data-svelte-h":!0}),o(aA)!=="svelte-q06icw"&&(aA.textContent=kn),ka=l(A),eA=U(A,"P",{"data-svelte-h":!0}),o(eA)!=="svelte-170ov19"&&(eA.textContent=yn),ya=l(A),i(nA.$$.fragment,A),xa=l(A),lA=U(A,"P",{"data-svelte-h":!0}),o(lA)!=="svelte-103o412"&&(lA.innerHTML=xn),Ha=l(A),pA=U(A,"P",{"data-svelte-h":!0}),o(pA)!=="svelte-1bma8kw"&&(pA.textContent=Hn),Sa=l(A),UA=U(A,"P",{"data-svelte-h":!0}),o(UA)!=="svelte-19bnu3h"&&(UA.innerHTML=Sn),Pa=l(A),i(oA.$$.fragment,A),Ga=l(A),jA=U(A,"PRE",{"data-svelte-h":!0}),o(jA)!=="svelte-is1nu0"&&(jA.textContent=Pn),ma=l(A),i(iA.$$.fragment,A),ga=l(A),sA=U(A,"P",{"data-svelte-h":!0}),o(sA)!=="svelte-1o6rzhm"&&(sA.innerHTML=Gn),wa=l(A),i(cA.$$.fragment,A),da=l(A),KA=U(A,"P",{"data-svelte-h":!0}),o(KA)!=="svelte-1486wvr"&&(KA.innerHTML=mn),Wa=l(A),RA=U(A,"P",{"data-svelte-h":!0}),o(RA)!=="svelte-108wwl3"&&(RA.textContent=gn),ba=l(A),i(rA.$$.fragment,A),Ja=l(A),FA=U(A,"PRE",{"data-svelte-h":!0}),o(FA)!=="svelte-miraq5"&&(FA.textContent=wn),Ta=l(A),i(uA.$$.fragment,A),Ba=l(A),MA=U(A,"P",{"data-svelte-h":!0}),o(MA)!=="svelte-7gn4yl"&&(MA.innerHTML=dn),qa=l(A),VA=U(A,"P",{"data-svelte-h":!0}),o(VA)!=="svelte-1j9dz3m"&&(VA.textContent=Wn),za=l(A),i(kA.$$.fragment,A),Ia=l(A),St=U(A,"IMG",{src:!0}),Oa=l(A),yA=U(A,"P",{"data-svelte-h":!0}),o(yA)!=="svelte-1n6po81"&&(yA.textContent=Jn),fa=l(A),i(xA.$$.fragment,A),Na=l(A),HA=U(A,"PRE",{"data-svelte-h":!0}),o(HA)!=="svelte-1xi6kyt"&&(HA.textContent=Tn),Za=l(A),SA=U(A,"P",{"data-svelte-h":!0}),o(SA)!=="svelte-jwef96"&&(SA.innerHTML=Bn),Xa=l(A),i(PA.$$.fragment,A),ha=l(A),GA=U(A,"P",{"data-svelte-h":!0}),o(GA)!=="svelte-arjt5a"&&(GA.textContent=qn),Da=l(A),i(mA.$$.fragment,A),Ya=l(A),Pt=U(A,"IMG",{src:!0}),Qa=l(A),gA=U(A,"P",{"data-svelte-h":!0}),o(gA)!=="svelte-1291a7h"&&(gA.innerHTML=In),Ca=l(A),i(wA.$$.fragment,A),va=l(A),dA=U(A,"P",{"data-svelte-h":!0}),o(dA)!=="svelte-18tb424"&&(dA.textContent=On),La=l(A),i(WA.$$.fragment,A),Ea=l(A),bA=U(A,"P",{"data-svelte-h":!0}),o(bA)!=="svelte-1bk6xm5"&&(bA.textContent=fn),_a=l(A),JA=U(A,"P",{"data-svelte-h":!0}),o(JA)!=="svelte-1goj83o"&&(JA.textContent=Nn),$a=l(A),TA=U(A,"P",{"data-svelte-h":!0}),o(TA)!=="svelte-ahicom"&&(TA.textContent=Zn),Ae=l(A),i(BA.$$.fragment,A),te=l(A),i(qA.$$.fragment,A),ae=l(A),i(zA.$$.fragment,A),ee=l(A),Gt=U(A,"IMG",{src:!0}),ne=l(A),IA=U(A,"P",{"data-svelte-h":!0}),o(IA)!=="svelte-114eutw"&&(IA.textContent=hn),le=l(A),OA=U(A,"P",{"data-svelte-h":!0}),o(OA)!=="svelte-1wn145j"&&(OA.textContent=Dn),pe=l(A),i(fA.$$.fragment,A),Ue=l(A),i(NA.$$.fragment,A),oe=l(A),ZA=U(A,"P",{"data-svelte-h":!0}),o(ZA)!=="svelte-18usfgq"&&(ZA.innerHTML=Yn),je=l(A),i(XA.$$.fragment,A),ie=l(A),mt=U(A,"IMG",{src:!0}),se=l(A),hA=U(A,"P",{"data-svelte-h":!0}),o(hA)!=="svelte-firey3"&&(hA.innerHTML=Cn),ce=l(A),i(DA.$$.fragment,A),Ke=l(A),YA=U(A,"P",{"data-svelte-h":!0}),o(YA)!=="svelte-1aggqg0"&&(YA.innerHTML=vn),Re=l(A),QA=U(A,"P",{"data-svelte-h":!0}),o(QA)!=="svelte-186gkf2"&&(QA.textContent=Ln),re=l(A),CA=U(A,"P",{"data-svelte-h":!0}),o(CA)!=="svelte-t3itdi"&&(CA.innerHTML=En),Fe=l(A),i(vA.$$.fragment,A),ue=l(A),i(LA.$$.fragment,A),Me=l(A),gt=U(A,"IMG",{src:!0}),Ve=l(A),EA=U(A,"P",{"data-svelte-h":!0}),o(EA)!=="svelte-1faw6rs"&&(EA.textContent=$n),ke=l(A),i(_A.$$.fragment,A),ye=l(A),wt=U(A,"IMG",{src:!0}),xe=l(A),i($A.$$.fragment,A),He=l(A),At=U(A,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1ksu0bf"&&(At.textContent=tl),Se=l(A),tt=U(A,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-zk4qj4"&&(tt.innerHTML=al),Pe=l(A),i(at.$$.fragment,A),Ge=l(A),i(et.$$.fragment,A),me=l(A),dt=U(A,"IMG",{src:!0}),ge=l(A),nt=U(A,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-2jx9z8"&&(nt.innerHTML=nl),we=l(A),i(lt.$$.fragment,A),de=l(A),pt=U(A,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1jscwmi"&&(pt.textContent=ll),We=l(A),i(Ut.$$.fragment,A),be=l(A),ot=U(A,"PRE",{"data-svelte-h":!0}),o(ot)!=="svelte-13oplq7"&&(ot.textContent=pl),Je=l(A),jt=U(A,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-4gkrqa"&&(jt.innerHTML=Ul),Te=l(A),i(it.$$.fragment,A),Be=l(A),st=U(A,"P",{"data-svelte-h":!0}),o(st)!=="svelte-9ydzih"&&(st.innerHTML=ol),qe=l(A),ct=U(A,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-18gz04m"&&(ct.textContent=jl),ze=l(A),Kt=U(A,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1aizwpt"&&(Kt.textContent=il),Ie=l(A),i(Rt.$$.fragment,A),Oe=l(A),i(rt.$$.fragment,A),fe=l(A),Wt=U(A,"IMG",{src:!0}),Ne=l(A),Ft=U(A,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-16u5tgv"&&(Ft.innerHTML=cl),Ze=l(A),i(ut.$$.fragment,A),Xe=l(A),Mt=U(A,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1buf019"&&(Mt.innerHTML=Kl),he=l(A),Vt=U(A,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-2u0326"&&(Vt.innerHTML=Rl),De=l(A),kt=U(A,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-1k7hq0r"&&(kt.textContent=rl),Ye=l(A),i(yt.$$.fragment,A),Qe=l(A),Jt=U(A,"P",{}),Fl(Jt).forEach(a),this.h()},h(){u(V,"name","hf:doc:metadata"),u(V,"content",ml),M(xt.src,en="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAHgAoADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDx6Hb9rmwCQR0Hare6JSNoIf1weKqxb2uHcRBieMY6VZ3OHOYtpPXGaJbnTBrlsyQTFVBUhcHH3v8AGo2unIYHJ5yB5wwP0octIT+7TAA7YGKiNuDlsJ8vGBU2AeZ3Cg55/wCu3/1qVJ2fgldo6AzDio1teuXQ56cini0wBgxZ9etArEwuWVChBIYYP7wEUi3TI5ZI3HzZBB7Y6VF5Kh9pZRjg8jn6VYitpJnWOCN7h2P3UUkj0+lJtW1KSIjd/JtVWDdSzMc5/Cm/bZB3x3+UVJIklu7QyxvFIhwysOaTc+3ocHr701YNSATuM7Q2QO1WLe92qEK7NxxuAJx68U5Q4UcMR2NGGQbnzn0xTGk11FEoGfm5PHApIwolxzIXBHXvjg/nTGEf8JOBkkHv+NOa4t1DCFShwApL5IPOfz/pQVcrxh1BkAGUYZHr+Fel2nha0sdCdLiSKW9uAJGAc7g2OFXHocV5+hKlyJAck5bGQfWt3w34hh0K8ee5jMkcgCHBJdR/eA7/AErzcfCrOF6T21t3OvDxhF+8RxeE9WRo5G0+5cH5nYMuDj26jNZd9p8ougEJYYLbV/5Ztnke4/xr2CwvLPVovtFlPFKoxuC5yvsw6ivJNatzZaleRSxlJUnY+xBOQawy/H1a85QqRs0RXw0FZp7jbOxvGl81oJvLRcucAAjI4JJ7+1T67LJc6gjmOFQoWNBGyhScHngn1qhvR33bdoAG1R9KhdSicKMHoSOteopNu7MZYeMVuaKaNqx2SmzlljkU5aIBwB2OR705LG4to2JE6+Y2wpImPTr/AIVVsL+bT3knhdo2cgMEOAR7j9a6a9sb+2sGnuJ5Db3G3LZLFgehx2A65HNc9aq4NJ212NcPRTZi2tlJDegzxSbEILIRsypP8q63WbLRri0YTA2t7HFuiU/KeOcMO+fzNaGn+F9PvooLuTUZrwoABg4Ugdj3rnvG0kkOu3R2od0EasrjlSOhFeYsTHE4lQg2nH5Ha4qFPltocoQwcsqnb0BPZu+KW3zFOJsldnOOuT7Uv9oP5QhaKMRg7tuO57/WpLeVp5Y4Y7SF5C2FxxnP417XPaPvHn+zd9Dop0ls9Gjv7i8t/OugAluiqWx7gdD/AI1c0NdNuNHVNQvIBKs4QgvjgYx+FZp8P31uk00toiRpjJEo4/HmsTUY47S5aGd9txDIAUxuwO4PHPavP5IV4uKn13R0Sc4JK2hqa5fWQ1C6jsx5kCHETKflLeuDyRjtkVzjyL5mZQCpOflHJHt7Uu9ZJQTOeQRzHjGfpVqESuZIoZoyjMAQGwTjpjNejT5acFFdDhlCc3exDDrF7aMptrqZY16Rudy/TB4Natt4mgIAvtOSViwZ3tzsLEHPK/dIrIuFbYIxEVCD77D7x/Dg1TMe+RUAjAY/wtg//rrS6Zk4NbncGLS9Wlimtrsb2kXzIdu1yM/3fbtg4r0ZI/MT93krtAH0ryrwlZobuW8YTRGKMxgMMqWPbP6/jXY2+uvpiOBmWNT/AKvnJ+nv1ryM4y6piKSqU3quh2YHGezqum+prz6HC8pl8rbPjiReDVP+zZ7RJJGJODnev3h71dsfGOkXJ2TSNaOOonH9RxWyklhqEZEEsU6sOdjBs/lXzuHzDHYCack7Lo9j1a1OFVNNHHR6j/ZyqkKK7DnhM/nz9aki1WWAtdzwv5LZ83pnkjJC+tSNeW1nJcWrRBrxG2LnkOvGG9sc1Xt7W4lZv3RaTOVkJ4WvscyzTCyw/K1fnWpw4DA1PauT91Rf3m9OhJRo3ypAdD1DA8inLOZfklQlhypA5o0y1mg0+G2mYyPGG2nH8JOalkWKFlXcftX3o4wMHHdj7V8E7ObjHVHuuaSs9yK4nNnIY7dFkvVAY+aP3cH1A+83oB0zzUH2q48gC7dpJCcmXAAb8B0pvlLAryKzNA7bizDlGPXPqDU4kVQee3Y5rWTUVZK6JpxXxPVlZhvcSOCx7Mp5FKVcvlAAoHAPO3txVgGCVwiSLk/w1DdXtrZhoQTcXRICwxMCf+BHoo+vNXBzm+VIuVRIrPEEVwQ4ZuG549vxqV70xw+RuTysE8csfb6+9QXUzTkMeg6gdFNQiFnEmxQ7EABR6+tbxWnvHR7NSiuYhtkMkzylVdcngjJOQB+A4q/cNb2WmvcSI7AH7irkv6//AK6fBAPKXPXHzEcZPrUNzbNJOW8zcqDCJu9+9NVFUqe89EZ1FzaIz73ULjUYPLihW3hkUbl3bmPPc9ulYlzYnzMSTpG7DKqBgEfXPNdQsJjlaEKd23OcdRUVzpaXqbZCPkGUJPSvVwGYxw9VKS91nFjcIqlO1PdHFyrDFMGUNuU/MUkOCPbjrXUaXbeREJVLyFwHIJ5xyRj86dpOgvcXJkuYgluj5CkcuR0/D+dbAswA5U7SGPfpXVnuZUmlQpO9t3+hzZNQalKpV0fQhZ47uMpJ+83jGMYz/wDX9q5m7tGtruSNk8qMjCknJcEjJz+ldJNAJ0IkGQSNwHG6sPUdbsbWeaFMXkgwAW/5ZkepHJxXLkOIqU61qcbp7r9TqzXD050rylZrYzr2VYlWCPK5Hzj0HpWbtMjbR07mpY1luZeFLSMeAOpq6sEcDIshLHIEnlnhB35719/KqoK8j5SFKU5csSOCIRrvbjH3RVqILGjTSEgAZJ/z3q/daRIg327eZFwSP4vw9RWaW+0ThEOYoep7M3/1qzw2OoYunz0XdfivUuvhalCXLURNGWcmaQEFh0/ujsKnghLkysD6qMdKYykhV9f1q2Mqw54QV0bGBc02NQXLdvlOazNWujcX32ZWzHEcn3ar9nJsgkJ5JbNZ3lZuXYL1JJalBe/dhJ+7YVItqgAcYqpqkuZDpit8qMHusfxMOifh39/pWpNcDSrWa5cjzocCJDghpjyqn6D5j9B61z9lbM43ZJlkJZye+T1/Gic/ay5FsiUuVXNSyjtyjbomxjgDhRx39TTIoHaN0WTcwbBYcnHTP1x+tadvahI0GMjGSv8Ae9amtNP+zwQzCIKYwQTk5ZiTkkexrKokmox6ii+5WliWOAiFWDYzsJ5J+vrWZb3SSxlgNrE8qTzitC8baWJJz2rL+TzjIqjeRgnHU1vCEqck4vTqNyUk1Ja9CwZNp4pYUNzOIhII0Cl5XJxhf8T0FQLl22gZJqvn7TerFHIxhB+Zozy3+SK6MRUtGy6mUY3LQm8y6Z0XgcIB0Qdv8am8lEXh+Cfm7n6mr39nSR2rOkaiKNdxJPQd6ryW/lxRSSggONyv2PsK8+Vei37HmXN66miTtzW0NDTIJLhpYw5dCucoAC3tkngDiumXSrYMzeSNzDBIJ6VxtjcvZ3UP2c4Ytyw/hP0zznvXVW3iKN5DC1jdO46mAo6HBwcEsK/PuIMLjIV+aLvF/I9rAV6bhy9S1dmNbReSpGBkdwTjFZN3auhEsAYHGHAAPfIIGKuT3slxMp8gRxRSbwjOCxI9QOAPxpDJcSNu3KgY5woyfxJrxqEpUopt69ep3NcxDE7Wc8YbzFRmBAABKt1xjuK5/wAWQxx6zBciKaP7bB5kiMOPMVtpb64rrljaXMzSBTGM7pAMKvc1w+r6idb1Zr6Nv9HjAigRjgso6t7Fjzive4fc5Y1VIaRW55uYNclupCWRYxnJYcYpphLhcOAec55GPStOOwjitILm8DxCY4ihxiSdv7oHX8aragwinmgEaRPHt3EHPJ7AevBH619ss0oVKvsYO7/A8j2E1HmaPOLcgLn73PParSXLLLG+0Ap93nj8aq24wiklCPQ9asRqWJGxmJ7rXlyO2D0NDTCl1ex+dGGijJkkVSBvUdvpmuhn8Q6Iow/hu2DL98iNMH6d657SWQXLRsCGZcL2yQe/tU2p2IlPmgFT1P0q/qMK8Od3uuzOGvi5U6/I9jcmutL1CC2lttHtLTeflkMYz6fqe9Rw6ZZwR/bJ4kkRWAMZIRCxzgkjniovDwCy2SucokvH55q74gItvCkrFCkjzQjYfX5q562GVHlhG9n5l4avKrzN9DSg1mxitjJFZ6TGB1JmAyfwWqVxcvcyz3WlyWaNMq/aIkl3YVRxk8Ac1555+SWA2nOSF6H6103hbDre5dSnkKWTH3vmxiqoZdQ9pZLfzNKuJqQg5JkdxD508zXFurXrMU4JCsw9h2x3p6WEUtqm+whjcjOWdiR9TnFVtW8xNWk+zOItoQ7QB6fdq8++yslkWQyGKPo/cen0rrhRirx6I56teS5XfVjTY2zxgLaQKxGW2SScfrWJMWt5pUdguCRjb2/z3rdgk+020UsbALMfmC/w9az9QjA1Is3PCg9+T2qa0IqN0Xhq0udxkyS0lis9NluPsdrcytKI4nlXeqADn5eh9ee9UrrWruQyMXjTIx5awoF9xgCr8WZ9KVCoSR5zhVAAJxWWbB3LsVICAk47GqcfdVhc15v1IFYEh1G1W+YoD0I6jmnpIr7pDtyWyFJy3404y3NhYxmF4mjkZlcPErlWH1HHGKhF9dzJtDRgD0hVf5CuOcWmelRqXijUsNRurXULeSxkkiuW+XdEMhv9nHf8am8Q6nPrWom6mghimKKjrHnLFf4iO1UdPuinlJLtBmLRLJH99Q3BHTA9j17VY1ay/sjUlgnv4VKkBl2liFK5B4H0GO1YqlF1FK2o6lRrcpQhXkVCwXccH2pX37yAp8sNgYyQPzrb0RtEl1KKzkledbhipkEWwRSHhHGeTgnp712TeDtXn1SY2ekubVYihkuLpRvfPDdPvD6VuoLqzF13tY8uJIlC8DjByDj6mu1mvkufDCRM+ZWt0jy3RMcV1MXw21qD7JK11YLIGLyI+5+SMdcc/Tp3rn/E/hG+sdQsREYmlupDGkiEhS+D8uDwCelYYmhGpytvZ3NKGJcW1bc5Rrqa3idYpXSZGALI5GR9AadrMtzNcpcXEjSSPEpJYdQKr3g8q+PmlhJEjCSN+CHU4wfWuq8SaRaReHtE1GPVFuLi6gCNG8gbyxjORjkAEkYNCo3amka/WLe6zh5juYNt2nvxjNdB4Mgin8QWsZXJQs+Qe+KqRW9onyvcyM38XydPp1rRtLXSGgmjS5uGdOfOiQK3I4AXPXPGc1NaDqU3Da5SqqL5jsfEF3Gbqx0lLmEl5TPcRq2TtQFhn64ryi7mkvbmW5mctLK7O59yc1u2VjLa6iZGlwqQMjSSL0LIRzjPr71kHTZY3VfOgbgfxkf0rDC4RYePItSnX9pqysqZwB1zwKvQw4YN5e9cHPHH51d8PaXZXutwWmpS7fN3Kqo33n7A8V6FZeEbPTZ3kiuJ5ExjyZACucYJ+tZ4vHU8O+We5vh6fPrE8wR3hAbc65yCqnj24pjuCV82KKTcRhXjwfxIxXoF/wCBhcwrJFcr5oXDF/lVz+HI+tcVqGgX9jKkVzA+WIRGHzKfo3+TWmGxlGtpCWosRRlH4loWp719LtIo4IRbyTKXYF95AzwOp+vbrTrTWbrZICc+Yc5KgkHvism8VY7uRVUrtOzldp4HpWhpFrNNOrRxkqgJJI4B7Z/Guuq7qz2DBRimnY79dNh1Syt7h4VXzYVb5R0NYz6amnXIDBgr5CyRHGPyrrtOSSXSLWPySkcaDJBzn/Ci7WVF3xaTFckcYMoXH518asTKFWUL6X7nsRqpLVXOet7JVfz2Ys/3WfPQduK6WxvYYoSLxRGoPEyrw319D79KoKJ55i0lpa20calBHCOWJ9T7GrNlC4Zl3EKRj6+1Z4mSn7sncqVnC70LN3rFjZ3dtZw3sK3N0OJSQY4R2Le57D161ILNRLJIM+a33pWJLMfX/PHpWVe2Fqt5DFAInZAxuUQYXaTkBu2fT6mm24v4GZbJhDBGwcxyt5iuSeQB/CMenftSdGn7NKErPrfqckFJPm3NlYjkKRhh3XgEe/vTJLRISD5Zwy8EjpUdzqm2S1hSMJLKSAX6Ljr9SR24p0cTCR2eUyF1A3FcHAzngcYrL2Mo0+eT328xxqv2nL95A6L/ABAEY6VVkhijgkCII/4/kUD/ACavyIc1DIilFU/xMB+XJ/lUUpu9jv6XIraCK6Cr3XDOrMCwJ9atCKG1TedsUYPLOQoH1NZ08amUB0Lo4Ytt4IK8/XpUDWFuyrKYI2z3bk/rW7jGTUm3YjlnLqXoLq2vllNs+9UcoSB09/oexphiU3UrKAGVRnPU+nH4VVFv+9MkMk1uxUAGFuuPXqDU0cSwoF3OxALO7nJb1Jqn7OLbg/kVGMloyF3M0+9m+YZAwSPzq7ZQLOpd3EhBORjHP0qpGmUVgPmbrntUjKU6EhsglgefzolK65b2NJQutC9d3MdlF8g3Tj/Vwg8/U+grFZtXtoCbWBb8ZLSq2VfcTltpHbkcdqnmIt1ZFXy2dgNwAJcn1zz+NZup6uIEaLTXMUMn3zG/U98fXue9eplmE9s/ZwhzJ73/AK0OCvL2Eedspalr91caebeO2a0kJIcs4ZgPQe/vWHaafGm1nALVbWE43t+C9cVZtoNvzNyxr7rBZfRwsOWkj57FYqpXleT0RrW+luli4syPPYZZs4ZvYVlm28mbynRmZfvRkdD6H2q08q2sf2rBZ4fmODjK8ZB9u9XdQuNNaO3fTn826l58uMZLj39DXnzrYjD41U6nvRns7beT8jtpKnVo3ho0SaZcxpasLmQRG3G4Ozfw/wD1ulc1f6zpsd6w0yKV7eQg7Su1Vbvj1FRa/dbv+JZGFZgwa4cdNw6AewqCz05RsJUA9evYdqxwWFjTxM69BtJ9On9djbFT54Rp1FsbFtMLhy2yRHABKsB0PoatMxBjizgykk59BWVaxl71QueGz19ua0dgaeSXkAfLGD1x6mvoqc217x4daCjLQsROoj254xnNNBdSGiUGaRgkSnoXJwoPt3+gNOjieOM/J977pPXFR30ZcW8FuZBcMreZuAwiE7SfYnGB6AmnOVtI7mfqUZk/tG5S3hfzba2ZgJD/AMtpCfnk/Ejj2ArodM0OR2VI4Wdj2Rc4+tWbKx0/RbD7Vqkws7NB95lw0h9EHVjWXqHia/1WJrTT430vS24JB/0icf7Tfwj2FKMuVclNXZjJuWrNO/1TTNAnW3iX+1dXU4FvE37qInoZG9vSmSXuYJY5ZYDPGxWYR8fNnOcenIH4Vh2llDbRqEQJGCMY/n9ahuHO9pYpCHeeWRGXrtzjn8uRTdGUZxk3dgmrMS/uPMcqKrQRs7pCnLuwAA7n0ptzhEaeTMaDq4Usn49x+v1pY7ldjQ6bIZ55FKveKpCQA9QmeSxHGa1lXS0W/YLaXNWxtbS8ivmhl3tC3lLjkO4wWAP5jmkjgttP3CUeSw+8CORn6VZ0A21g7aU8KpbzIEX+95gGc+xI565yO1XZbXzbSF9QVZZFJBmZiHVc8AjPpz+NfMVc3xWCxs6dePMna3kvL9TpeGhXoqUHYZa6hYTWt1Y3Mz28cijDyHO5T147dO/5VFqd/DdRx29nGPscX+rfHLnAA9wAKzZQouZUilZ4ZVIBbOTjkHn/ADxmrFuS8GQgZ0JVl9vUVrSwVFYh4t3u9bdF3ZFSpJQUCusI3ADl2OBir+lypLeW0EIBXyniTAxuU4YfXkVnT32nR7kuppxJ0URW+Rj/AGTVb+2JElhOjW073cabBNIoJUYxkR9M47msswr08VTlTivR9C6FOcKimjvodOlYBkjYr0zg1YeK3gOZ7mCIL1EkyL+nWvMbi41K9lc6jqF5KwGDG87bc/QHFOsdFt4pRc3MMTP1C7QQBXyssupwTc5/cj3rVLX2O/1a1udWj+yW11DBp5O64n375Jh6AdAv49qyYDoGhXPkQZ1K/I3IAwZQ3qWHC/zrFu9Mg1j97CEjePAb5cAn6dvrWvo0KiN4DDHHLExfbGPl+bHIH4VLXs6TXO7dYrT73uzHlTnqh9vHcIbjXdWnEs0asY1K/LCg7J9aw47m5mDX7NDmWTJkfGE9gCOSB+prb1iGS/u7fSY1bylAnunA+6v8I+pqPX4YLfw+6IvyGRURBjg9ePpjJrpwFflqQbXvSe3aJniKacWuiPKbKEywvsD/ACAscKMAeuanVZGBxwvvxmq1i8ywDy7iSMEkYRiKu5ucLm4c44XJr6eTPPpp2J7Esl3GuU5ODn37Vsf6wuGOHQkMP61nWVzMl9bmSQNlwo3KD1FaEwKSb0Uo65BY84+tehgX7rPJzRXqL0CykFncK+N4hfzCmMg+1bXjqYS+HVlEaxNJPFiJBgH5D0/CseQiNxt+YFN2D3OO/pWv4zElxotqqKS7Todp9o+v61y4+3tafzKy+7jNs84kIVUbaCDwQRiuj8JOWubmP5iXgGFB5PzDGKxksbhv+WTsVJ6c1qaEbyzvnaOEqzx+XuZOgyOf0qqU4xmmzprQc6bSJtZErajPI6APHCjHjBGMDB9+atllubFGcYWUhT7AjiqWpzlrmYglt8HO7qMAcfrWlb4m0S3iQfN5QYD3HI5/Cuij7zlY5sVHkUPkZmm7rW6lssfOh454qrrE7RXoV0OUUEEchvStZgq38F4oI8+PA4yMj1ql4hWP7ZFlVGYVOAeTzU1YWp2FSnerfuhDKBpHnYH/AB85IHTBXp9aYXV2LAEhxk5PXPrV24hEHhCE4cSTSByGGcDkdRwT/Ksq3mHl7CAFHOPQ1lJ2SOiNm20MntmK+WjhkTL7jxjr/hio9L0+4utQEVvbSzsP+WSLkt9cdPxrb0myt7u/ht7q8FtDICZpCR8oHUfjnFd5pGo6dcyz6P4ekSxjiTLzBP3kwzglc9fqfXpXj5hjXRuoxvpq+iPVwVHmSu7HLW/g4afYq+u6hFYoX8yOGM75mP4dPwzUPiy2t9SgTUrZLiUQAQSGWMqTGMYf/PqK9FtdLgs8OsYefnMz8uc+p61l+JNStNNs2S8UzvcRMkdvkgtngn2Ga8GhmtSpWSinJ/d+H+bPSq4OkqbcnqeOWbFdUCKPvZVfXJ+7+uK+kPAuo/2lpqyfOBPbxXBz90uchsfiv6ivnCO3uoZobhYJSVIYEKSPlOete6fCiK6g8PW9xKALeaJmi9QN3U9gOMY9ie9fXKSasfPSi0eihiXKtyMc1xfxLiaTwdczIDvtHSeNx1VlYc116zRlfNZgiN0LHFYXiSE6hpOpwKu6JoHi4/vbSf50pNJakpO54v4rnhurm11u3RC2oQB5kIyFccN+dei/Cm3sZNO1OMQQyCO4QgvGCygqOMn3zXl+maddajpxUuohRgoZ88E4yMjvXp/wrtpbGXXIJ1GQ0OGHRgAefrXLRnBS9mnqjrqQaipW0Z6J9ntlP/HvCN3X92Oa86+KMdtb21vOIlUpFIRsUL0K46e9ejbsNzXFeO7Z7+e2soovMaWBwFKbhyR1HpjNdtPWV2ckr2KFl4fs7bQLHUJLaP7ULZSwPzJKCPTpkZ7Vzt74Vt5zO1sRFkk+Wy7lH09DXUwxS2ei21otwhihwiq7BmKgYz7c9PyqsXVmkYEFc8e9eBm2LnTxCVN20PSwVNOk3I861HTbuylMdwxhljCmMA8beoZTWlp/xHmhVY7+0SfbgGWNtrEepHc0/wAaRF77bCjyv5CcKM8dTn0/wrh5LGZUiLRlXcZXI6+v5V1RpUcZQi66TbNb1KUm4HsGk+JtG1kmOCcJKR/qpflP4djUHi+cWnh97cKnnTyKkSvx0OSfbAFebaPpw1HUrWzQsmWzI55Cgd61b6yna5mmu7q5mt7aQokjKWwv16CvM/sujRxUZRnotbHdCrUq03dGVYwWz3bG7Zx85J2YYk9uvBroNKFxJZxQW0MhCyEkpwzq3Y+31qzo2m2Wptapa27rJCP9IlLZCjoMc9xzXdWdjDYwCGBdqdznJb61eY5nGj7iXvGlGKgu5Q0mG50aKSOfLQSLuY53Mpz+WOnA962Ibi1lTcsm7vyhH60MARyBULajc2KmOO2S5jByv7zYy+39fxr5ic/rEnJ/F9xcm7XSGXr2ivHd3DOkbts+WNmLnsuMdarF7u6SREElnBvyGOPOYfyT8OfpTLi8u9RvYnuo4IIYgzxxK+9t+MZLcds/nU9q7RokcqOPNOFYsOWycj8sfnXQ17ONlrL7/uHFSavL7iWOKKOIIkYVB0QDqe/51BEuwXAAIBmZue+cVdZPmwMCue8T66+hQwiO2jlnm3N+8YhVVcAkgck5NY4anUxE/Zw1bKqVI0o80tkWNStxcWJV41ePeGIwc4HXBHPAJOKvWzLcWdtMro4ZB8wOcn61x9pP431pEexhEaJKoIECJsJBIPzcngGtWXSfF+nhyLq2nuGKlLdIhtYkAsOQB/EBxX0f9h4mVBU3JXvff/gHlvMqSq8yTN5rm1XMd1D5KjGy4QEqev3v7vSpV0+OTEyTebwQGUggepGK5uLXdRtbxNP1LSFSSWVVZkkwFHQ5HP5Z7Vpvp8ZkYrETyQfJJTP1x1rycXgamGajV91vtrc9DD141rulLYvOkazBUwfLUhsds1BdW+1YmDlUZtjqOSSemPyqbTlX7OVEJiVGwEIxVybC24JGfnX+defzuFTlR0ObizKMQAChcY4wB0proFiboMfhVi4Zi+I8qc89+KoXYM/7jJWQjJPGVQdT6cnitaKc5as353YhM6tBuRGPlgZzxknHA9c9vwqyoyenU8ZqMli7A4CjDYHr6UhJUAM2AfvH9a2qcrdomkIySvJjbt4mja3KsWYZORxisW/s44QJFVQpHbHHYDFacK+cplIO6Q7jn8MCnTW/nWsjCMNKOU+UE5HTg16OX4uWErrlenUyxVCNWi4synsFjtvtE0scXyZ2kfpVWN1ki3xsGBOARxRPIbqARTyAzRk7AeAnTPHp1qWHE4Z442EaYAJAGB/iTn9K+3wOLqc/7+W79Eux89i8JGMU6aGIoDqWOQp5HY+1V5YxotkFsYGa/uiQZkX/AFS+3vzVmRct9DVt962G/LBNvIzwa9XFYeNeHI3Y86hWlRnzRVzl7OzWCJvMV/OLfx/zrRiQu5CA5HViarzkkZXkKRWtHCsMYA5yMgCphh1H3VsbSruWr3JdN00lD8yqoRzNM7YWNB1Yn+Q9qoXGrpdeVaaFbq6oQWuZxg3DDoQOiKf/ANdac11EnhzUY5EPzIvU8OC3Ss/SoFhtGkKhd/zEdB9KhU5Tm03axyVJvfudE9/4fhe4N1q9lHMqhlhjJk57j5c896x5tbtjeSzWkL6hIx/dZjKR7RlQXzzxwcfWplSGwtjqc8aNIuRArKMknuazbC5ud1xP5zK82Q/AKsD1GDnil7Cd7J3JTSWpJtuL66W81WY3F0g2oD9yIeijoPwqSJTJMGz07+lKC0sW8x7CTyoHA+lNdzFGQPvH9K6KUoxWgpwY24uRuCITtB6+ppfsZjtLVyybpEIUE8tg5JHtVdIwwLk4C8/4VHqTPdXdrHGm3y0CLk/d4yT9fWuTF4qpTs6e/mVGEWrMnlhdEUyOYzn7jDqKIYfMfy0uEgYKWRmGB16ex5roNMe8vrKKFoIZQSGUPxVLUNMEd+QIzsCbgCdwT1HH+RXDgOII1qzo1I8rXW91/wAAurhXCPNfQxCjRTwsybZ45QwmVs5Oa17iSWaaSWVyzsxbPp0GAPwqvdwSQ2wdggVsMrHgY7c1eCQSw+d+9dVJyE5bOeBtHJP0rTFY/CKoqu72TWvyCnTqctloipDaNd3ixq5TgnfjIU47/XirmnWskVz++ACIu9stjH09ayxrMrarFFHiC1EoRoyvzEHAOT+ArrodL+0RliuCTg/4V4eb5rUoK0o2Ul80dWHw8Z9djKudVto7ZktkNyQw3t0jX6n/AArJvLy+O52YwblA2xptZh256iuom0QBCjx5U8HHA/EVWvNFadnkk3MMZAHAJ4645xxXz+HxeHjovxPTp0oxaurnNW9r5pWZsAbflXtn1NWZH2LgcyHoT296sSqbYlXK5HUDsB7foBUQiyWkb7zfzrdz53zPY6G3Ir2kUy3G9GAPCgHkN9a6Oyug06jIhnTJCkdfceorKijWNDIUxjhR6ipIYfMlDODkZPHUHsR6VhWkpttmbgkvM1IbdbSG4lSJ765d97t5gQyE9Bz0ArlNUmvpLpZ7pHSbDKsW07Yl9F9ST39q66Fm+7JgZOAzD7x9/eoNT01760kVHxKqkxE/wnuPoearAYyNGteor36nLiKTlCyPGbMhYAevzHpVlWVmyBzVa1ysKkDIyeoq1EryMfLR3PoFr66W5wU9kWbNgb6DepYBixH0FbplXy1nbG1hyVOSMVj6dFJ9sQtsTeHQBz8xJXHStOB96uQp+Q+WRx2ArvwUrKx5WZRvJN9h105WzkkPBkXgHr9a6k6aniCyt7WWZoiMSK6rnOEAxXMRWbajIUNwY+ijI+7/APrrrtAl8v7LGQNy5TjudpH9BXm53OUYKUHZq5eVxV3Fmb/wgDdE1E49DDzn3INMPgS7hdvL1CEAjkMjdvXmu2E2HZQFI53ZcDnjtTHk8t2XsTwc5r5RZpi1Z834HtOhDojyPXV8vVHhbA2MUdu3AGa09KOLGE7gdoK9eKq+Kdw1u6YE4ExOR74qzpyCC2jRXL+b+8K4/UencV91gZuSUu6PDzJJRsMnUrcCIgbFkEsYPYHqPzqh4mQDU4wpIP2dcAn3NakojuL2BUdSQwBAPTvis3xIFbVoirjKwJjf65NbVvhfqc9B+/HvYdJJPLotvbiQu2SANnAxz68k5rIyBK+7bgsQVHBFa0UsxsYmiGFBYEoCCOcdfSpdW0x4BGGgVG2Dbgclegye5rjq1IKyb1Z3UoS1stDPh8uVY4XVmzwp2nHXIz+tR2NzLBcx4k8qWNzJHMo+dGFWAkdrPbu63EhwxIJ8sKe3Hfqc1VlRmuFeAYJyCp5GT1GfQ1hNRa1OyldbHoum+OFvtKA+zSNqudoRR+7f/bz2X1HWseeOe81Ax3uZncGSeYjnAI2qvoOwFJ4Y0nUoL9IJGMP2iHapKg54ycc+h/Gu9svDscMsk15sfJ+SMHP5mvmKtXCYCcnT6/1b0PTkqtWKjI5230ieSMeQp2Y53fcFaGjtcaHdx2iXLRpIh2gHIz6Adua6OVYbeB5JpFhgiGXc/dQetcnd6odSJu4IR9mTKwNgiRueWI7c+tcuHx2IxM3JaRRvToU0+S12zrEuLi4s4o92dgyB/e+tQt4g06GOOCSYpg52qMru9CfxrDfxLHDCsYs5Rkc/OOT/ADrAkuYGWRFhKxuxbYWJHPWuvD1qsW/aybB5ZVl8MUkHhu2NuNXjmjL2aTOW2EZ9sA12vgObE2rpLAIZ5GjlIDg5XbgH/PrXDaFc29vrlwbl2Fs2ACBkJwT29ga1NSvbSdhd6eJLed1KucMgK++evtiumnUlTxfO1o+pyVKLdP2a3R6ot/ao7pLNErIu4hpFBx9M1xvjq+gKI8z7dPwgmUHO8FiccewrOsrzw35UW6SP7Vt2bpi24jPQnGKw/E0kF00thHKWHmoI3/gCYIwo7kE/rXoYbMVKq4uLVlucdXAVPh8zorLWbTWrYz24YeSwjlG0Bc44I7dB2qZUJwCXI6nGOayvD1kLTS7lfPWZXuN4IXAAx0+tahyrDb15AxXz+Y1Y1cTKcdjvw9KVOmoS0aOT8T3Yt7y7dN+9I0y2OPYY9ea0dBvf7Y0pbmS3AkjYqwZRj6j61keLpUNzfqFHzJGDz9Oa5+xu7y1R5LaV1ePk4ORt/wB30r0p4T2+GjGOjVrfca0K/s567Hoeq3LaZpjvGIUuLjMUIJVcsQefoBXARamrGyg1Pe1kGaMtE24uueee/P41r69rV3Joq3M1sqTXqeTAD1SNfvvjsSSBXJWd3Gs0QuyxgDMXVDjBPUjv6dPSjBYR06L5tX/WwVcRer7ux6lCAdNU6JJFGqA7Si5VgPU4zWtp13O0KR3/AJAnZdytESA4+h6H2rjbHSruzNveaRcLd2kwJdEcqxH/AALj+tdCr291bwXKzsIA/C90Yf3vevExVGGqTuu/Vep2RXMtdGb00qW0D3DglYlLMAMk47Cs3Sr5NRs1SaSP7XkmRAMY56gHtU9rex3iyAqxZDtYHgj3x71j3qSNqhvI43AVcFYjhi2cZ+mOK46FGL5qUtH3IfMndG5eQJDZygAKzYAY+uemfzqxbLviYOcq7Z69q5ZZvt1zbytc3EzM5Do7fcIx90dumOfrXWEpZWfmNyEAUKvJY9lHqTU4ijKmowTu2Dm+W4qQySSSjfkRNsJI68Z/liuD+IFneLDa30wR7dC0GEQ7lLHIIP0GOe9dREJLiJ5pTLFPNIZJEjkICk9hjsOlVdY04ajpdzDvnZvLZkUzMRvAyOD9K6cDWjhcVGd9nroZ1qM6lFpnV+H7yK+sbHU4YWja5tBuZn3bgOOfcc81X8U38lg9mbWNv7QmfyYAVOGLFcn8MZrN+GV0Ljwls88zSwSshVmzsU8gD061u39rJJ4g0OfcWitzcScnhW2cfzr9Bvc+Ysk7HHazZJpet6YJC80LI8wnJJYydyR069PSrIlIMqLIyR43jB+96k/4Vpa1ZW+o68EnfdDDa7WUEj5nbI6H0FZ9vpUCSSf6xVT5SRIcn2r5HPK1N4jlb1SR9FlTUaWq3ZZs3KxqX6McjPeqOp6kJtQtbKCQYSUtM6nONo4TPr3pslpMsiWttJOm4MzMWBCAdAPesbQ7Qqk1xIrIdzIA3ZifmP8AKvMpUaaUqre23zO+UuaaSN+BvMKnoHYgsfWoNPMGrwy31pIjv5jRyLjDIFOF49CMn8abeYj0uVQ+1mXy156E8f41SsU+xlZLcmKRQFDA8kAcA56ilTjDkk3u9jocJyd4dDSlgaM4K4PpVO7ytu3yklgFwPc10FheQ6o/kzxrHOeF2jiQ+3ofaqGuQ21laSrPMPOdf3UCDMjHtx2HuailGftErDjibPkmrMy7G4tpi8CSAyKfuqOMY6Z7ntWtc3ttZPcTiVIYBhmKEHI2jp6HPFYmmypELWIwtHJzuc9CSMDAHQVW1eaa8uzErI9tAxLHH35D1/AV71KNGk3KOpy1adWtNRnojJlY3eoNMTxPIW25zj2J79q27PMhnhK2y4x8sJ4P+P1qDSbfbOZpAkYB2q5jyAe4FTtcW1vcrNGGbads8iqNoB9O5wcc1116c6mGbW+6M/rFOGJVO2ww23BAAyoyRg8f496yLu5mubtLCKQLGihn784zjj611jjCGbaSuOuO2Ov5Vyunx7Z5rraMyOSM+nb/AD9K9DIs1xGKUqdV35ba9TmzLBUqX7ymrNmhBo8ckDM8m1OgwOvvSSwfY2RXYSqy/u2A5YDHYZx1qb7Y0ZUvv+zoGeTAGB/X8K5yfxFLJqjXENoTbY+SMkAgHqc4Pp+ldFLFY/8AtB87/d9ululvM55UcMsMuX4v18zTv087RyrMBJNcogUf3Rlj/SrtjbLOyqzBYIxudj0H+eayoJPthtWUNiJM47hjwfx4q5q94La3/su3+8cG5Ze/cL+HevfUna/c8aSvIpajdtq+ofuwRbxnEYHp6/jWjZ2wSPzG4RR09ai0qwbH+0R6VuX2mXltBFGto4jYZMsjLGv5sRVxlGC952M5e8zO2l1yB1PQe3GaaLBp2kKdEIyTxnueT6DnFTN5bqyxXtq5UkLHA5lP/fQG39aSJJ5dyoGEWPmAbqfUe/J5+leDjsQ6cnOM0kelRjGcFGxk3JEcuxDlQePc/wCFRJmW7iUcFuCT/nrUn2cs8jRqdqdc/dPpzT9NIfVoycKVBYZHUivVjCM6SW9zzcRNwvLsdXZy2lnatKxcNGAp9B7D61zd0RcySyg73kYnCE8e2fWtqyC3PnOSCikFQemanuYSbgmJY43CYVtgGW9TXwsa9DAY2pFq/Z9j0YU6uIw8J3sylrU0As9PtfMmkaJVYq5BCkD0rGY3Ec29dxLcD5vWtGSxlg8yWZ0lLsA79SSSOg6Adse9V5rZnQsZEAVlDKD8wB4Jr08s+rqk9eZ7/qRXjUi0jHnsJY2TajNycBzjaR/tDqK7PRtUuIIYbgoD5iZljc5BPt6e1JJYMNqI6ui/d3DsetStCdwCRA8Y44zXh5lmVPGRUeXY7sNhZUtZO9zoV1nSTEpuZhaFuhnOEz/vdKW5m0tbf7Qt/ZrD1ZzcJ09ua5u804XGlzRSniRMYbpnNYp8K2SsHa0U44G1M15NHD4aSvJtM3nCad4ljU5rXUL2aSwkjnt3JCSIuMkck4/T8KjeIhemDzgfjV2NI4USSRHTypFIAGPl+6R+Rp81q0DeYyt5RPykjofSuyVRK0Y7G9NvlKTH94qN91QMj6irtvEzFZMEDt7+9V0AeWXJLcnc2OBUy3bQgH7yd1zjPSsqibXKjenQlUTn0NDZxjHUc1na1qY0KzDPiV5QRbxE/MG9c/3R61DqXiW1hQpZ7ri4K5BH3EPue+PauZnFzM4vLyQyGfjcRyF46egruyzKqlWSnWVo/izzMViYxTjHc5GJJ7dpEEjRiN3UgEBhzikUFiS0khz0yx4qvbwxSySh3lU+Yw2hxjGf1q19giTHzz89OQeK+pZwQTtsXNBhj/4SC0GQv3m3emFJq5hrfXLmIH5WIIH1GR/WqunW0dhfQ3X72QAtlG75GOO1Wbx0udQiuYm24VVZJODwAM56H/61dFGoo9epxYmlOU9tLFsXHkyNKuGAI3DPVc811mkSxrfRNCQYzOCOOxU4P61yUVvLKGRNm7GMsQAOwznoM1fv4praOCFk3lgceVnqABwfasswjTxCVNS3uZ4OFSk3Jo7qfyTMZDHGWPAZ8U6WWMqCxTK9eQK80ihuS5V4J9q99hBz2zTHsb9ZV327orHI3R4z9Mnp714/9hQtb2v4Hf8AWpfylvxKQNavcBWDSAkdQRjP9KbpD7bNyzAFWK49KotBc27K0sEvl5xkpkD3JGadbw3CgyRokiMc4Vx/LNe5h2qFot7I48TTlWhoixaq76xCg5iXOGH0yaq64sb69HGjYOxBySccZNXY71IL1bhkUyKm0J5gIz0zgc5qtqiz31zLe/Z3AG3Lsu1eOOrY64NaTrRceVGdKhNTUpdjrPB/h6R7GC8nGUAJt0PTBP3m9T6CumuNISeMpLCrgjHzD/OK850rxDrOlWdxPp11FNDbbXe2mG6Mhj/CeCDnAwPeuksfi3p7ArqOlXMTgcvbOJFz9Dgj9a+JzLCZhUrOrH3l0t0+R9FQrUaUORLcpa54Ru7fyZLXdKJHKxxHDNnHQZ+8K0tL8IXMUqz3FtHGyHMcefu8c5wcVhXOvXHiDUm1i2uFt47eRY7dGf8AeRA8ZAHXPU1Zj8SeIp7Nnj1HdHu++Y1Uk+ma6atLMHQjTcld733Ck6TnzxRua/qNrbxi2u43icDKmKT58evTgVT0PxRBpMF41/JeTwFg1oSu92HcD2PasK7uXvbZWuZWe5b50kcDOfYj8iDUvh6xS+e4ja4K8dF+Y5Y9Bmqw2W06lL2M/n/wB4vEODUiPXfEN7rN20MyGO3Qb0t4mB2nsX9T7dqy7X7Vc2Vz5czRAfNjeRgljn+teozaNp720NrcW1uJZo/Jkljjxg5yCOeCOOa8z09Ftb4xSNuaKcCRD0YKzA4HftXs08PToUuWEdEeX7WVWV2yrFJeW0Eshu512uEdFfJ9iATz7+laSjWEG3dHKfL8wZUNkd+fYdq7CFNO1MSwz28EgkUOjYGGAPb/AAps2nWg1yx+ybTCYpGlhZiQpGACPqTXmRxtCcnGcLNeR6LWIp/BN/ecavyX488mN2KI6MMbx6gjgV2fiKZE0ZY0gVzLtUFxnaf9msu/0/7TdhEOxkQtG2NxGOSMe2RT9Q1FtRsLa3LKs0ZBIC7Vc+oNc9Z+0qQlHpv+h24WDdpS1V9TLkePZFKYo2cvtfKg7/Tj07VH9utZJPJ1CaSNEn+RYjjyz6DP3RnHNad3pQtTbzPcRmAHedjBs57j154qLS9Ksb/xLHBKu5JEaR0YHc3pn0rsw0otu/YebVY8kZU31Flvm0zUJIIb3zY+GEcZxg9wa6PTNVt7+Dzrqe3tpM/MgG0AdtvrXP6p4fkkeCe2IVmQjy8AAkH19cY5rNsLWZJDBK7I6t92X+H6HvXBVjSqRunsbUYRrwSno+5o+JRFezzR2EiXMkqAEqOM54wfpWPD4T1UTLFJBPGHOGmBUrtxluPYA/Wut0fRg1/5jOs0MLeYDtK/PjoB39c1s61exWVp5st4ls+7AbGT74Hc81i8zqU5xo0lcxq4anGVk7nkWtXButQnYmfyowI4QBiMICecnnLfe7de9UW2LPGUdWRgHBx+mPavR5vF2kLbzqLW5vU8sod8aqg7Dr/hXntjbJNeWsU1zFbRMMNMU3KvJwSBz6CvZwtacoPnhy2OGcVGVr3O28Ka08Gmx2L2EkhVmeKRGAIXuD7A960rtZeLiRGDPjzUibkjPTPUmq+kaLcaDJPNJcx3MMi7S0YI298n2q/MJC0UhdHiOCpU5GT3NeFiJQ9s50tn1PZwlNON5EEd/HBft5E+DMNsnnNj6HnvWnbXdnNK0aTxNIM5ycYH4/0zWZDapaFZpYUk8vIC92B7Y55x/KrVibe0DytA25clAQMtn5QufUZ5qauHhUjzLf8Arcxq1uWbjb/gk9wkCSiVbjyr5AdghG4sD6gDp7mmS3M1xdG7MgbyEZVhAwEOD8x98gc9quW9sbddhYFjzI2Pvn3qSW3aW4ilUqrD/WZX76jkAn2PNcUa0FLl7dQcdLsmgIeGPAIwgBB9cVYjGOSB/hUUMmbqSEhdwjWQY7jkf0z+IqxnAHauGsnGZSd4nHeHNYh8H6/rFl5cciyXACIB8wQ8g57AAntXTyfEHwvLfadOb1gqq/mZQ4h3KOHH6VwXj6CK216G8kjLxzwASbBtPynB59cVzg0DUbK2h1FlVYiI94bqobIGR74Nfo+X141sNTnJ6tI+YxNJxqySPWbfxDp159rvWmjR571hHGFJcxqAqDAz1wT+NEt3ML47IJEhdSwMowxI9F9Dk81D4a8iLw1prpEkb4BcYHzEnaWB69wfwNa15bgssiqQUJ753Cvls1oqOInVt1fU9bBTShGLKUCSPfTuxUARIAFbPUsefQ9KbLHvl8oALGCCABjJJ5qWyRDJdyoeWmw2e2FFQakxmZdPgRmlkG6RlHMaH+p7fia8hXlV5V2PRjJQdzF1DUkmnSK2jknhgdt8iR5BbpxnrirIRVSORjjeM4x09sVdvLe3trZbVWVYkTPlrzx3H+frSpan5SedyKR7AiumpUhyLlVkb0azje7KGpDy9L2ozKZpFjVlYgrzkkEd8A1VggXBIA+YDJPJb6k9a1dStZZEtYiobBaQ4HTgAf1pLewfZkjgdfanGslSST3OqnOCjzvcqFEjt5ZZGKJGhdmz0AGTVcW8aQL9m2NEVBV853Z5zUWs6xafZrjTrSRbi5mHluYuViU9ST06cYFJBKsO1bckRPyY1HBAHUe/866Y0pqnd6NkKo5ybWyGvGVi/eNMWAICoTg//Wq5YW0jQ7I1DM64POAg77v8KfBby3cm2FgynlpOqgf1q08TlPslthbYH99IOsh9M/zrd4+caXsb2/Q5qmHg6nMtzFvFeYzQWE1yunDjYxBDHPO0nkL7U2KylERMKblUhfbJ6D3rZksXZcLnoeFHsarWhkNumHBGd+0LgZxjHrmu/K82hRu5LT+tzLG4R1IJUnqu437NCyxmEThXwskUhwCu0kn36dDXNXGgqZ55IJH2FWKxlcAH654FdRC8l9NIHmMSxfIzqCRux3/HP1rNuDOtw+EMxA+aN3+UZHTH9a7cVmM3NOk7W/E58LgIcsoz1f5Fe3kh0qxN2ArTD5beIdN3TJrIiEu5mbazk/efPzE9ScVrSrKtpGjLIdiEZZwFQVm2F1Zi5C3UrBRhfNwdm7jv6c4z7V7OBzBYnSTs1oeXjMDLD6rVM27S81lY2jhu4bGFxhjZwBHb6sxJ/KpoNGt5QslzvuZM5Ely5lbI75bNWUt8oeCNvA71ZjRlTgE56YHSvWVOF+bdnkykzN1HUnsitkkRMPlBwUfbgknkAd6zZtXmuIfs6IIIyANqHnHpn0qbX2tzdQpHNE8gTZKiOGK88ZxWWsa+aduQFOQD1NeHisNReIcmrsHia0PcvZEkak5Xc2zIJXPGfWoo5JU1IrCct9xT6VZjjkkiJjDMifM20cfnUNvDNBqKY+WSVgqBuxY45J454r0pV4RpqPMtNymnJXsdbbTWtqlukLqyrgMx7E9T7nPNX7iJmkbdjOevrRD4fa0R8HzJ9vLv2PfFX/sbYyq8eh6GvzLMcVh6tZyo/wDDnv4OjUp0rVHdmQYPl2lQQfWo/wCyp5Fd4o1AK43FCc4rVTypJfLEsXmqcPGD8yn0xTpYr2SQGCRlRWJVDnb9MfnXPTrzpvex0SjGSM3S1ZIRb3Ll3yRC5wCw7rj2rTW0boOKdb6U0VuvmOCI/myR0b1qC88R6ZpoY6ldNFOULpbwxFnlGcAjsPxxWU1LE1P3S1Ycypx12G3u60hNw6xiC3zLPJISFRMdvVicAUy11exv8RwyeVJzm2nXy3zx0z1/CuP1TWbnXb5IygtrGJvMitEbd8x6M5/ib+XagRkqImffFIwdlI6sOD9K9F4GEYKM3r3REZSk+bY7S+soZIJIy5iaSNlAl6g+o7cVlz+IJXs2VbJJEUKnnTMdrnABIUdfYnFYt1qF8liIPtDT2oYMwcZkUDqoY/w4x1qeFYJLKGVH3SOyh1ydqHrtwfp1rWlg4wp803fXQuD56nIjbh2vFJbPHGk0YDMqDAcH+Mf19DWRrEbRWMkaAHcP681oX12sQt7qLPmqxGAPvqRyD+Q/HFQ37/bbePyArliFAJxz3BrClCSnGrb3W/xPSjK8JUvI5a3gUu7FQUyqlFH3V6f5+lW7iINIkksubeM7sL3PY/QVrS2UcLBVTCRe/wB5u5rCuLxZLuWxTaFV/mOOQP7v1z/OvqcDjo1ZOKPncXg3TipPqeaEOtzKQTw5HHHc1eSdlRZCZGJ/iPTjtmq+oRSR6jcOI22NKzoxHBBJPFRF3chtpyB0xxXducMHY0mvZk3FSyBudpGRn6GoDqNw2Mlm2jA7fy7VFEskjh3R5MnAyODWnBpesbT5GnXAjboRAR/OlohuRXtr6/iY7JZY1PULyD+Henz3mo3CKLu4mkiXhRI2QBU82ga3GplfTrxUA5YISP51TS2uJOFjaRm+UAdqXu7gtRshdwQiGNMcqrE5+uaVjNIytMhn2jaMuScDtn0FSraXY2qkU7qOSRExyfyqy2mX8aBhp95tHU+Q2Cfyo549x8pTtp7uxk860uJrZ+qtFIVP4EVpL4s1EhTMthcPjHmT2SM2f97HJ+tUTbv5jeasmTx8yFT+Gaa8Ee4nZtUceoqtGK3Yvf8ACR6iXbZfGNTyy2sKxD9Bmqr3cMlw7TxzTu54M8hyPc9c1D9kx/q4ye5IbgVJHEPudRyTtBNGgWJrqRGhPkkIrOWEanIGOMduMetVkhygyylccAnk1aeP/QbdhAuTu3Mud3Xo3uP5GoTHGVJZiTyCMgURsD1Oh8O2zRWN3L5UqRiSPJCZO4nj6cc/h71cha2vLdWaIZUFNoJUE5OWI9Se1UtBdIdPvHWW4Z/MjCwxHhgATn1yMdK0tPc3Nr5hBUszZ4xnn9TUTipWTNaLa5miqYWjBaL5wvJVujD3qxpV5DcvLLDbRKjJ5c6mMM4APDAnnj1FT/Yw6O7g8DgA1g6gk0DRyxSxwSbgF+YZkPoBWcoJPmjuXJuUeWWx6ZaeK9PS2t7ue9jnmiXdJF5eSTjHA6lq4y4sfO8UGOaFY2lPnunoG+YD8sVf0TVbWVpGexj/ALRTH7vZyxHccfmOtM1m4mbxFfS/Z/JeJoofM8wfK+MAbRktkHtU1akpwairM5qUFTqrm2LTyLYTxyqP3TOY5Cw+VSeQcf5xWjYz293Pc3QVY2DJGoGccLuI59645ppp5mLOWMYbIzxjIzWxp+qW9kZtPLttlAa3kcbcNwApH9favJq4OapXWsn+R6vt4zlpsaWuxgaTJdRTSR3MMguIyPQ8Mp9u/wBKoJeQ6hpolih2yf8APNB/H6D39K6JoDeafaOYjmQtHKgX5x8vIx6e9ct4dgd2u4DD++tpQfLLbTgZVsnt259awjBOi1LeLN8NW9nWt0ZrWUUNzqsNw8SyJBAXmAQZkPZRxU9zcW8GuX12oeHyNNMhjcDcpxwCB64rV02whsE+b5nJyzH37Z9BXO6tLL9vvrPYz/a7m3tY3cdEXlgD/nrWuX4mNWpJLaKOPNIczVurNOytjHp1qtx8/lxIGycgEjJIH40SW8SM8BSLHQCQ/L0z/Krd0f8AW5UthvmCjgD/AArKMwE6TRzhxv8AM3rkFsdR7cV5Ub1JubdkerTbUUkdBpd9p4tkjt5IgwTBC9B649R71xOqTPqlzd38J3+UGS2Rl3DYvVse5z+JqfU57cJvMs5YgvGeM7SCQT68Zri4b+aFSsLSBs8lj26gY/H9TXo4DL0pyqR38zixVbktcuW94l1Iy3mnQXCHjzIF8qVfy4P0Ipt5pUFuIZ4J/tFtOSI3UYIb+6wre8MeFbDVbVbiTVXW4lTMkEJww56EnrW0fBsUdv5cGpMFBziZN+T25HNdNXMMPRqcl2vkzGnSqSjdlfw9pYv/AAvai5EgL5wplPygNyOnQ/jW39jgSNYo02RKNqjPHSl0y0XSdLhtJmjHlcPISVQ7mOOvSr88aM6uuw/Lzg5Br5vE15yqNp+7d2PXoy5YqPUzYdP2TKisCsQz5YkP5nPXioVN0byOwZo1KyB9rDhyOVOfXHbqcVqkW8bCa4UeSg/eyddg7Ej0rK1aG0m10C1WeYJETOIugPVct2PPXrXThKjnfm2a37HPiZe+a0sV3FNFGHhIkyzuoJ2qO/49KnCIrIWUlCfxrM0d5HvLuCR3lZYo5FkkXDbTkbTjjIrYdfyrzsV+7qciLhJyWpzegafH5+otdebJeQ3TwbpGI2oMFcc9wc10mR6fhVJoBDqH2pXJNwgjkUnjcoyp+pGRVpGPI60Yyq6s+fuOjDlhY5rx0mzR4r5DhoLhc5GQVbgj8eKr2yLr2k2tpIY2ileEOMkZVAcjjp3H4Zrc160N7oV9aquXeJig/wBocj+VcJ4I+0faFkaLeouBJId3RCMYAHcHnNe9lcnUwUlF+9Btr7jz8SlCvqtJKx6C6BVEUSqqLwqjoBUV5M9nZPcIrO64G3ftzk45PWrLMqZIZSpJxk1BewteWbIkqq7YKsozjac9K8OnK9ROptfU9GS5YWiJp10vlTxLE3ntMxwWBXOM/eHGO/rSWdtFeW8jzNLI0jbjl8ZfOCcjtxgexofS3kniSKZoY/KCzkN8xHPH1IPXtWqFRMLGgRAAqqB0A7VriKtOmv3e7/Awp8zepVjsocRwxoqjJZwB95R1z+JFaMNkGkUEHkZJA6D39KpT3iWM8M32VpWlYQAq4UqScjr2P9KZHqUmpXbwTRiO3kiEkKA53DHIY9yOOK5nSqTgqj2FKUnLlRU1LXkDy2ukRx3lxEx3zuSIUP8Ad45Y+w4965m6tr3VZRHf3krhcExIdkf/AHyP611ctgsZllgj+aTG5V6cDqKp/Zj8u1TubqcHn0/rXVRr04L90rfmd2Hp04xvLVnPw6bHCrKiKvb5RgVbjtgk4iK7FjjLBs9Cccf1q5HLE4c2+2cDowU4LdMD1qHU7i10+MG5nDzH78MQyQM5wT259a7IzqSdnudTqx0SFtL42ULAEmOQ4IX7yj+8P8K0ba70tbFHglby+QoVGLE59AMjmuej1Cae/ijgs4Ykk6SO28oME5yP5Vr2cH2SF4Wy1uHLpsHKk9Rj071GIoQXx7+u5lK0neOg3UtQujFi2ha3ib5WeTHmNn0A6D361lxTTw/KkihXIBG05+oJJqfUpk84KPMI64HGD+NVoJd0zIkIDAciUc8/SumjBKlZLQuEY3s9y3HezRRSLaiJdx4LJznuRUVupe38wsSWJyWGDnvmpDbuCH4AHQL2qGXMMmHldV4Lx7hubPoKnmdSPKjeMYRbcSO8kNvYTuACWXbg988VjWcGTHGFDEY4I4A9T+NaV3b3mqbTZwOYUJJLsBnHFR20DtC8UGBKQS7NxtIHT619XkdD6vTdSp/XY8LNa6m+SG5RvNTu2uPstndSxQxZVmjfBc9zn0HTFEyzXKxxXFxcyooy4kmY59Bj1qtYwlFY7WyCeWGO/pWmkLbQ7DGeQDXu4elde1qdfuR4k9HyxICEiG8IiA8KiqAMe9WrW2hTfe3mWjQAiNRjd7Y/pVZFE8hlJ/dpwue/vUwYuGyTtP8AD/WssVh3iPdTsvLcxnHVGho88+t3b2vEFogJaGID7vpmultdH+0NMZreIxsFCbuqY9K46yupdEuIb2GDekjFcE4Mgzz9B6fSvSbDVLGfTTfCeJbdAC5LY2+x9xX5/wAQ0quFrfuFaD2t36/M9DBVYTg1LdBJdppenm51Kb/RUYBrgrkx5IC7sdRnjNNuNc0KKIs+s2KqeqicE4+nWuU17VW8QSpBbKy6UjbyGGDO46Ej+6Ow79ajg8O2lyuZkQlupxzXkxwlNRUq7ak97f1uda5nqXL+Oy1O6kvLUO0MiBI2YYPHVuxFULmeXTLmNJLq8MbjI2XbfqOo6Gt7S7SN1Wycl57cAHaclo/4W/ofcVQ8TQQ28VnPFEEnEjRBXzgr15+h/ma68NUXtlSavH+rDm046Ghoc1rcWMs67zdK5jcyzNKecYOT2P0rO8WWRlt7SaGN3ERaObIyAp5BPtkH86Z4a1OMalPbOkMUcyj7xwWkHTH4GtPXdUeysmt7BlN5KhPmbAyxAckkngn2qZ06lPG+51/IE0o6nFQwkO27AMgyDjHyirMMLmZTg4XJ/wDrVt2XiK3vltotSs1klZfvQoDkepHUetXluNFlbFmIPtGCUXaR069eM8VrVrVYPllB/mjVNMwzb5cOIkUE5wB+QqSGN0snDAYFwFGBxjjn9avS4DEg5CHJx3PpUBtpF0toQ43tkkj+8Tn/AAFZqo3HXqzopL3vd6DHiSQlJEV424ZW5BpbNobK42zFRazyFUJH3HPQfQ9qat3AIPNncIBjzCVJ2E8c496ydavA1q1pCN6STLvfBGFB7e9deDo1pVPZNe69/wDMeJrU4xc76o2rpmX5ypGDk5rkYo5oNQ+1tsWOV3O8LyCe/wCPSp4L+8vreG3n+WNhy3cgdv061LcyCVBbIpeSTiNcencnsBXfhMNPCtp/0jmxlanWpxt/TOJmeZ7S3DLIojDImeFwGJPHtupEdcYA68EhuKlvGccSSlgsjkIxBIyQSc9OpPT3qkZIkwRsVjnoa9w8aElyou6fdXMF7G8AAmfEaPjOCT1Ge9aWsxNY+WDcXMnmMQ7u5JJHUj8TWXpd2p1exjUpgTL15wK6bU41uryCN1yU8xmUnqM11UF7rueZjKjVaNtrGRbXRuIFVWdJI2O5hIctkfpxVi2uG06CS5tHdZCVOZUGWz2HbGaxQjBnwdrbvmX+lbtraCTRjEzny2lQLnt82MZ+lZYpLl17mmGbUtGW4dRjubYPf69dxyED5Yifl9sCsy6vf9NU2eo3LWwbktcMDj+919e1emWfhvTYLIh7O1ZlcqH2A5XPX68/pWiukWUM7SR2NqjKcHbAoPtzXivFQhJ2V/uO1zbR41qOotdpEkklwXU8JK+8fUMecH0qrYyQJqK/adkkJI83b1C+gB7/AErrPiREj32nuCoY20igBMdH4FchpcLPqMK7vn81AQR6sOlepQmp0VK1jJyakdKLOW486TSPDxRCh/fzxkleOTzgAH8aU6br7qHN7FasEAZY+Mr/AMBFen3Uv+j3KsQSY3z7gZ4rCnRQqKOpUDI9K5I4lvZETmzz3UWm06GL7RKt0lwSu1l2Fdo4IPXP51nxpYXTBvtTQE8EXMZ2j/gaZzz/ALIroPGZC3ECyl9q5+7gFfSuPWRGcbT5W3uWLEiumlJzjc2hsmzrNIsLk2tz9hFtN5vMTQ3UbMuMg8Ehhn6DrXS6fYzabYrHf2zNLjkBc7efWvMQrRK4Vll3DlwM4HtXbaO95bWMb291Km6NosZ3KWGD0P1rmxlCtVh7j/r1O3CV4Up++rnQOsaREtCm1iMFZlGB64PP6VxniBJo70ww8jb80giJB9gSM/pXcQtdi4jsb2Yz3UqBpY1jUJChxjd6k9cVwuv6nrek+Jbi0l1G8H2eU7AjgMAQCOnHTHFTgqNaEf3juvvKxtanJWgjNtJ7tb9JGuU3x/PG4BDbh26AZ+tdRBd2mpXk82oTCGSWVZMNhQhx3IP6CsvS/EuovOkVwftsE0oQ+dGu5SSB94cjtXR6b4etdQu76G5tGcxTj94DtcDkYPY9u1dNempQsnb0OGnU5HzNXK73Onx6tdSrc27xyqEYbjhiPck/pUN+s13pcTxQ+YkT7Vlk2hRz04GT+NSan4c0/SdctEuLmeGynyqSjB2P6Ef1rpV8JNBbRxRXjmEkuNuGXJ71wVF7LllzXt3OlYiD0cdzA8N6nNdSNFdzFQSY4pS+M+qE9iccGtLStKe38Taq5J8rblHOcOx64J64xUk3g5YZyRdMRM2+UcjzW98ACsT+17yw8Qf2VNcedbuAFmx1U/d+mDwTWFf9/GapbtamtGcYyi5M7a51OytGjiuJF8114j7nj9K42BZZ/GUu+YCKCSScljjB+6MiukeJXjUXUMcgKbfLA2lvrXPWSzWmtale3AMkAna0lZ1BaPjO7PcZPNcWX04xp1eT4rf1Y6cWv3kL7XudW+C0gOGSQAMA2MjHrVFbS6JKrdxFtp2KygZ9Nx6txUypt2odkmFBAB4x9fSsx9VZtaRUERS2OzaCMySHkgH2Ax/+uuWhCo21A6XLlsLf6XFb6PcyyzkyQ27+UgG0KOp5/GsO28OaXNaJeXWoMBsBb51Vfoe/GcVuXd/JrllcW1vbCN2IUySHhVzzx+B/KuR1LQ7ywvjIIo5hgMskfKr+Hb6mvRwntGnTqVOWVzlrr7ajzItSvaahqVnFpsXkQxDy1myQfdx6dOK6yLVb2C2ij8uTUJlUAsEZCx9yRjNYvh631C0ii8nR4J5rlwqSTMBgnOAB16enpWvLZX900glvHEYBzHAhiXjqPX8a0xVFVGqbj7q6t6v7tTGnWUbyb1f4GHrE+tazOlpNHbQxbmbyVYtgjIyxHcHAx0rS0vUtSuNPkjs7izia0j8uS0nhO6I5wACDyO9aw0SC2sVu0RI0jI6kgbc8Ek5zkYOMjGfWse/tr6K7jvLM24uYgWl2c+cueFwepAonCEEqFSKS3XqRGTmnVpu7W5tlNdhMJibSHDxEszRuVOexGeazLbUdX8Om20pLKzvFnLGJYZShHcrlvrxVzQNVs7mybyHYxxqdxY9XzyP16e1Sa3p0moaU0cHl+ZCwnRuhDDOcH6cV50XGnW9hXilFvXp6M6J806ftIO7A+LhbxRrf6LqNqMkFtodV9eeK1NP1jT9WOy1uY3kC5MR4cfUGqOh38GraVHKJQs0GElUHneOpx2qpf+G7Kd0ayL2kgbcxQbQT6/8A1xXPWoYbndOcXBrruh051eVSi7oi8Ta4dOv9FTzRFG0/mXBK9YwdvX8Sa6JMiRycnsCBxiuC8TWGqSaPN5phnjt87LgE5xg5DL3JB6/Sut0nVln0G0vJ0fDQK0jKhI3Yx2+lVjMLGOFpyp67p2+80w9ZutKMtOpotn72Bx/erhNJaHRfEWoxm2K+VI7tMGyCvBC/TGeK7l5i6/u0YcbtzDGPTjvXGeIybDWBNIxxcWcjMVQDLBSpGMY6N3rTInarKjL7SsZ5kn7NTXRndCPzOSMemDxiqd8srWflwYN1LIEhOcYPUkn0ABplhNeHTLJ3ZNzW6FyV74HPWqcd7eDxUQbYXKWtuNxQ7CgkOdw9Tha82lRaqSs78t/w/wCCdMpPlXmakC/YI5jcXAkaRzI7+XtGfz4Aqq3iHT90ccbtPJIcKsYPP54qPWNYsZraaziZnuGP3CrLt9ya5fxPYrc6f9vDmOe0K44PzISBn2w2K6sLhYVqi+sXTbIqOUKTcOh1t1drcBLOSzZoZwQC0yA7hzjB6468Zqpb3Nvb3sdhOZMIcw3IAyG6/ieav6JpNnqOjWGoiW7zJHljvGUY8N26ZB9KxfEmg3Gmz2rJdzyJPcKqiZ9wUgggjHXOfbmvo55NRhScYOx5EMfUc7s6dLtYVU3uFQn/AF6IShHv3U/p71mXlxHeOY7EsLF8iSQZBlH91O4Hqe/b1qG+mne4is5ph5S4a58vKhj/AAp+PGQKtrEpbC/dHpxXybhGh73V/d/w57tKHNq3oZV0Ht7MNCjJ5k8USFeAgY4z7d6YwjjlbfGrkHkAdTj9as6tbCeS1tWX5TKJH5PCjOOh5PWnPYGMbnyiM5xkZbbiuuMkqcW3Zu500qic3fYqPOTMpEQU4yFbGD9a0IHW8gWWI8d/YjqDWTIGadYw6lSQdq84FalotxAGKQqwb+HdwoFRiIx5d9TZ7XQ66jEdnLIx5VMknsB9Ky5LEW8L3d3dSwxKo34A6noBWnqmRpoYkBnkRTkdfm5HPqBisLUpb68mM0iIYIyUjtwxPlg/xnsWq8Im4r3rf10IUpSdokct1MFiQlxHJhvLEnKj6/560sNm1yFuLdI1BJX/ABz7/jVSRlUDCsfZRzx6VPYvdRmSeK2zE7DdGxx+IPrXbJPkbjozqqJQWm5Ne211Z2Re1lEewfvQ438E9QDUVo6adpsE9w4VyxLgHJOeg+v+NW7u+tbgtbGGeKR12hpFOB6/Wud1Nlmu/Kh3LBD8qrngetevlU6teHsKm29/I8HMIwj7y3Zr295p95qSu0JSIkqS56k9z+HFbGr6NG+nuIB5ZUAHDYDD0Ga5XT4FfMj8RqcAfzNdVc6pY3sH2GIny9g3k+g7fj/jV5osRh6tOeGlKy3W6scdFQndTRz0loYUjb5VhI+QBgavabp32qITTjKZyqL1P19qzpbg3N2ZmzsBwi54A/zirtleeQ4TdhW6rmu7EYjGzwlqbtJ9u3b1OadKkp+Rd1uFpLK3m+zsXic8RnBQdB/Ouds7GW7vWidGCSNudi5IwD1I6E12dtLBcRPI5DJjBY9CPeudXy7W6nNrc70GMOOikZ9e1eTl+JnUw7oTjrHqc1eHsp+1i9Dbs7VInSNgxBG9dw6j1Na0flOpEbjevXmsd7xo9Oj85ImkMYjB+ZS/OfXA5PQU+z1OK3z5iL5smBux8or5zFYefM29z3cPGVWlzpaF3ULO4lszc2MrwX9uS8UiHG5B95D7HGQPUCuHTbc6s1xHLPInyjfcvuZ+Fy3t34rvbvW7HSrPzp5Yp2xuEUT5Z+2MDn8a89sxnfIp52nAHY8kflXdlntPZS5lotjJqLqabljAkcZxxkjtz611Hh+a5udLNoxil2AIx8oKFA9weSfpXMWaBpgG5UDnPP0rWsLx9LdNk3lJIpMoRM5YdMen61vXjzR5Ea8rfvLctPawpdzpFEAoIJRPugnt/X8aiZUV4VAYYk+TB+UH0pdEsmvZp7x7oMq5icKcMx65bHStJ7PyZo5ATJGgOVx9w/3h68dq4atSMKnI3dnTBc0UNfy4Yi6AO4U+XH2P+fWsu6vbux0+aZ7gTKMOYZIsFR3wR2q/IEI3mRSG7461i625l0XUSFYbIvl3DHQinhouU0mt2i69oQunqWNPgu7m1aWLy1WZQxhAyrKxxtYjnnn3Bqt4p0R9O0q1uxcNtZ9rFhgBiePoO35Vb8JXqnw2iyg4XfGSo5yDkfjV7Wry0v8ARFikneedoEdkLBkBDdcDnPvX1eChTjGXdNnz+JnVnOLWzsc00a2ESwTXIxEiiUp8wBx0Hqaks0kiVpJhiSQcnH3V7Afh1qOdWuL1bWRY1ht3MsoXoS3Qe/TrU+JEgecjMaZwq84PqfbtXn4mblalHd7npU4JNzfQ86ngV7ibzUYMshG08D0pyJbhdoiTGcbic0XAJ1C7UPvCzNlh069s045ABDd+MDFeyzyIrQdDJGk0YVQGDggoMHrXbWsRuXaaZgJCNoLdcD/CuMhAWWNhtfMgIHc89BV281y6v0ltIIRDGx+cjlyPTNbUnozgxsHKSsRXMiy3F/PEmY2kyh9getb+mES6TapJkr9tUHp13AiuZdfIhWFhnOd2D7cCtjTpzDFFL0hWWORgwzjDDNZYpXgisPZPQ9dl8sWssn3Y1+bAOMAH/wCtTjeQXcYa2kWTefvA+lQ3EkMtv5Ubo/2ldsfluGzzknjsB396ryOljqMk0ZIRsLJjqQOjfUfyr5hxb0O5LQ4j4jzJJLpshK7lSYYB77v55rkdEQtrllkYzcRg/wDfVdZ8QIjE+l+WQd6yHJ5ByQetcxoCj+37Bdyn/SY+n19q9zCf7qvmYy+M9lmAaK4IySYnzz05PT3rJuHihi89nGxQB05PoAPWtqHIhc5B3Icj86w5o0uLqOZ87UA2c8Z9SK89u1jNnB+NHYz2ry/LMd7N3C5xgfhXLRqZPmkyVH8SAEiuj8bXey+h2jc439egGcfnXLpdOBkopXoe1etQTVNXNYtWRM4SOTEUhdDwSRg/jXc6FdXEOmrcB2kYBdsG75GfGAcdM964m4mt3SNoFZD0ffzj8e9dnoTLHocJ8kqyyEBi2cj6VutUWleR0+jxSQxySzS75nJkkkPV2zXFePL20fxdqdvJYBds4xPDIUcjaOoOQa7RHH2SPbgMVGa4jx3FbS+ILi9huS9xK6+dCVxs+UAHPfpVTsmkgnexjWdpbNeKkF+kDSDJNyhjxjkYZcjqK9Gsrq6XWBdT3PnWlzGsMlxbzrKGkAGHyOg7ZxmvM9Jk8i53t8xWTaueTtIwa6bxRJJpuoWF5aRpbyGEFzH0bHAyOntjpWUlrYhLTU9A8QadLqGi3wgDXUjEGETIrPG4HQMMEgjPXNZ3gTVLq4s5tNcFo7YZQhRuweoOTzg+1P8ABmvWOpwhbqSKCYkb2U7dvvn0+vTpVXUrNvBfxAtbuGQDTL8HDZ+UBuGH4HB+hrir0rwcSoOzszt4wySBmjmO3oNoxXnnj+xLW8FzHGyGAmNyBjCOx5P0P869HaR0kGXiZR/EhyCKxteiW9iuLeRAVntWX3zk4/XmvHhXjRnGa6HRCDm3Huc3o2oQSWlpIbjHyeXIWOfn6EjP0qLRLw3k2r5nWbfebgwHDIeM498VQ8DT276bdWFyn/HvJukyPvZ4wfxBq94c0W/sLy7jdrZI9mF5yHySc8HjFdFSNKDrRbs9Lfmdcak37OdtFuPldoHbEpSIAsqnlVx7daybW4EOmrP9nk+0mQzk9mOQRVvxHDdI6xiAqZ/mXDcHB6D69f8A9VEOnERsYpsXMTgfM24OpXpz09PwqqSjCnzze5tWqqdTlprRL8SG51Q20Pn2YMTFs4bkOT61FH4muLiwlWS2gZ5CRK6/KePQc1n6nGVMShsgsSF9PapdNt0lmcGMusbDeQRxnGMn6muiWHotczXzM41p9GdNoc0kwiMd4skUeXVfKxtbaOpIySM4/Cuj0y3aXUIreRWaNgwYIvO3v/P9KytLsXVp45QYZEYq2G6fL6/lV5LqW0ljnjeZpIcFi3POORx61pTlD2qvseZVUtbHSaiq6fot5tjlIzjdv2jDHuO1cTJdS7Q0dsXdgQvlFcj33HtW9e6hNqEdu1xGEYPgrwR1OD94n9KzdnlyiJ4COw4OAfpUZjyVZJpXsaYLmp3T0uYtzYSQzw3Gmr5UwUPPEuMSHr8ue/8AOuj0/UY9SsVngeNT91lH8JHUc1G6TDbuiUL0Vupz7HtVKW0lsmW+hKhy37+IciVRjoP73fNfP1WsRH2c/iWz/R/oevBcj9pHZ7r9SWSys7bW7fU54o3EreS3yDEcjH5ZD+PGfcVuuuSfT0rm73xDoRd9Pvp/JEyKCJo2CsCM53DggHHNb9ncGWxikaVJm2j96nR/9r8a4cVCtyR9ommtNe3QuHs+ZuDVmQ31hBfWE1rMreU452HBB9R71yfhywvtF8Rvpf8AaJksikjvDJk7jgYIA4HB7Hsa7Z8+jflXJeLWuLHU9O1G1SMTL8u4nG4DJwfryOtdWWVZzUsN0knv3McTCMWqvb8jrlK4AGRjgZ7VyPj5GexsGRtrmdo/++l5/lXQ6bqkGpx7gFjkKhijd/cH+IfSuV+IN1G1pYwurRsZJJFkHTAXGPzNLLKFSGOjFqzV/wAgxlSE8NKSOyguLW0hgjurhIx5Sp8x9Bzj1/CqulK9xBcagwCPeS+Zgdo1G1B7cDP41VuFj1Pw6bhoY1FxFCYZpPmAY8cenfit2CFVCRIRtCgD0wOP89uRXNWgqcWo7t2fy/4P5GlN8zTeyRiC2lOr3ly8THOxImOMYUcsPfnFT3toJtKnhNp9oMyMhOSAvynHTk84q7NqWnW0hjurpFPTajbpCegGBmqP9oz3LzLJG9ukTlYFBw46fMxBx9B70R9q2qkla1vwNm+dciQfDi6MXhd7aIXVxILnypmdlPkA/MeOowSeOSTmp/FkdzcXdpGt1bTCI+eRE+QuDtC5PJPJJ+lc7HrcPg3VNSuJka7jkkBiRGG9cjPPoOetTNe23iZ9Q120R4EhaCJQzA5lLZLYH9Oc197KTqYb2i6r9D5eEOWty9mb0MLxo8a/MzMWLsOWJ71N5f2W2aVyxVTlj1J9B+fFFxcxaaxinJlk2AiOLqT3+g9zVBnurq4ikMamHJZYyx2oR3OeWPX27ivz5U5OXNUen5n1fM2rRIJZbsXllDI2+6eUyTLFFlgoHY9scADB6U7UdZhllmsLWOaW+jX5ncbUjH9evSiTULptRvhBFsuF227Tkg7McsR75OPqKijiEW0ldzDPLHJNdspxSXOtUgw1B1HzX0JLZAxCmM4ByzA9ann1VLa4eytoHmuUwGVzsRSefvdzjnAqezjEikAAd6yb7Thf6rfyhlLrKnllBg7lXGc//W7Vz0fZ1KjdTZGmIk+ZRiT3ETGMTyXBluGYKPlwqIeSFH4dTzzVGfEasSQF6nNWbyWRLdYRxchwCvbAHJPsN351Tt5FeJGl3FixDDqWOccfUV1qlJxU2aYaas0irLC8bKzCNwQW27s/L6Y7Vv29h9qVXiT5WwEGCAPYVlTwtGY3ePaHXI2gEBhwRWnpesQabbSebHKw3BotvXP9OtVVTqJJBiJS5OeGrLDaMjA72bBGCQ2D+FchPZCJ5Yo0bcrlWZug/GujOuzTqZbzZBbyghFXna2e57/hx+VUdTeGWxW3tCrTPJtXjheMk+nSuvLMRUwdZweqkcFejKrBORjooEYRTiNR17t/9ak2GQiM/dY8/Sr8cNvLahkkPmh8fcJBHTGenaqtzDJbXRjkZd4A4XnANfR0MbSxE+TqcdShKmrjiihjwMH24+lMkYIu2JAfXFEjhRjq3pTVH4sa9WVrHn8re426eY20G3DjzGYjoODjB/KqUd/JG/EJdN4OzqSew9xWzZWvmyxKuXUtgAfUZqbVbRY9TL5GWjAOPbjtXkwlyNQXW5zujzRlN9DFOtate3ltKVQhMjydmFOeTnng/SuhtnW6w6DawGSjDkf/AFveqVrbeY7t9lYbfvZ6Z9amkid5IzuZSnCkHBFeBmfJKpy7NHv5ZOVOmrbMqarYywJJd2iIsrcSFFGQvUnn8azrJAiZSRWUPgMDxjFdBPqMdqv+lxu0ZUqZo14BweGH09KxLK80/wDsS4+ZPNR/kHBO3BwQfXPWqwzqujaa26jxEaarXhu9zX0mwkntvNC7BL0d+3vzTbqPypioRyI1bDd8+pqpbavqqrCY7wyJ5YKpJEpUH0xjtVuHXEyx1C1YOWx5sQLKPqDyK55xqxqOW/kax5dmU5FvdNuE1O0mCTKn72Mj5ZV/usO/1612Wkapba9YC6tgFZPlkQ9Ub09x6HvWJK1nKqyrPCwOeQ4/XPSsbQdQGnapexWUse6Ji6AuWSeHrsPoQejdRWVSh9cpPS0o9fLsyZy9jNOOzOr1OJFvoXAVXlick9fu47fjWHqxU6TqUZHC277O3bJJ/EVprfNrF9G6Wz26W6ujF2+YsfQDqMCql7F5ukX3mJhxbygNjAxtzVUKdSlCCmtV/mc9aabZzehXRbw5dRjKsZsgZ6ZGTWtCrPF+6yfIQuWBwcY4GfesDw1E82nXccZKkuhLegxziu00ZbdTJZsw8yUZjZuA57j6+grtxtVUZycdXe50YKa+rKLMK0gRoty+c0rvnpjec/dNNuJo3naOGRlthnAJ4LD+mciuj1PQ7hraVIpfLkIyuODjuPriuZW3VwzIjrBAnLN1GAOAO5q8srUqsnWbu10Jrwajyx2PP7xy2pXJIUFpW5AwMZ9KtJbSPGjFW2ngMwwKk1BJ4rt2jj2qz5OcEk46g+npUCT3bttcybR0BfivdZ4cdEWrZVFzCVcK0bKeRjuKuXWoRpPKfsWwoWBfPqf1qtZxie6hUkqvmKMHjJJp7XAumaIgDaxGz+9zwR/hTjJrY58TG9mypNdxTlvkKLxjJ74rf0JPMForqjwmaIOrcgjdyDWBNaF/lRcNnoR2re8OKYHt0YBW89Cu/IB54zjtWeJnzU7k0ElKy7HrsdpbWM0i2ttbwoy5ZY4wufbIqqF23hd/4RgH6k0jTaiJNpTT1YsRxJKec/TGKClysgeWezIPG2MN1z1y1fN7q19TsUXc85+IKyQX1gF3pbusjIvZcnBIrD0Rx/bunMikLHOoU8etdL8RD50ultHltyygD0GRXL6Gx/texBII89DwK97CS5sIr9mYyVps9ojYR2rO2eVcgH05rmL67Wx057qUFpCAIkXqSeBx6V0OoXSWWnuTHKzbCg2puUH3PauL1EJdMheOVZVZQHCnGz0z0PNc0aE5SXNF2MeZNnOeK4SLm3MnzZh67c89a55F8v5ikTqD0Za6XxA3l3Shj5mY/mPbB/lXPOIn3DzMJ3Gcmu+n8KR2JKw64dZmRxbQW4yciIYH5V2GkKn9h2iNGVaQMeR3P/6q4eTepI3EhcY4xXf2RVNMslz8yjJ9M+3861igj8TZrWRBtlLHc3lkc9//AK9cl4n0u9vNYa6itJJI5AvlyJzuwOeO31rrbQ4K9jjA4689K4vV7phrF1GwJEcxdQDjB9qqTbLcU1qZtvpOoLOHWPytnzEysqge555rqPF6tKtnIR5gEZGQOo6Aj2/xrmDKs275AqnLYX19K9EjuPDV5Y2s+oXIe4MSqsI3NtbAB+Vce1ctet7NqXK36EqFtDzOKa4sLhZ4coVbPI/Pg9R7V6LPqFp4z8HzWfzJqVoA9rEZOGwMEKMc5HBycjAqS41Dwmf3EGivKw7uAuSPxJrOkOmXdytvFZ22nSSEeTcpcMFDdieMfj+dTGtKf2GiZU+p0fhTV5NU0oRyy7bm1kFu6vweOhI/z0ranXdeYMg3JCWyRhR83euLh1A+GfFS6Xq0SxXcgC3U3m5VyTlXORjv1HvXXyDfrP2fP+ttWBB9NwrwcfhnTqSa2audWHq3kjzzTJRpfju/s2wkMzun5/MpPt1/Oul0jUkvdQ1NoMNarIFjOMBiB835nkVyevQIPHZTzF8l9oadCdqAKcse+BjmtXwr59vDqtunlvMJ0YOrcA4xuHt3Fd2IoxnQ9u97IUKjjU9ktrsn1G5S41cOCZVtxgKc8HuMdiOlSXAji1dTbKI42i5B9j1qO5hkk8RakkXkR7UQMwYfM+OD7nrketT2H+mWq3MuDK+RtI6YOCM/Wsq0fZ04Ppbb1NqFRScu9zA1hZIdUkwAoI3LjBBJHUE1seELOO7lubSZzvaISgIepJwf51kawsIv41QLHCy7twP3SR0qKzuZVMar5iSQDyxJESDn/wCsCa3nBzw3LGVnbcqLXM0euQ6atqgwHwqgFn56dyTVS/n06WBI7ZvMk7mEZHB5BI4z/wDWrGsn23ERMZuQTt864lMq4PH3T7c59SKtx3gW4kjS3lULlokMYIXP07cA15+Dy1xqe1qVHJmOIqte5ykLW4do3ZZckkMfLyfpyKbMXiuVUmVlXlgUCsBjj61sB0aCBocOsRyXAzhj7dzUN5NBFExlcMx4CSLh930z/jXdXpyinOLMaNSLmotFZJS0TRxJiN8fLIMYx3xVWWKG2bzLqaCPcMeZLkEfTmnvBPJIxlmkK+kbbR+nJ/E1Lb2aIpZYUDkYyAM49zXzs6l5ay+496CjBWijDu9GtL20lUbpNLAxHxh7c45KZ5K+3es/wzdzeH9WfRb2RWtpseS/YMfulfZh+oru7ZWkQBOMKSdwyOK5TxHovm2itEfMuoyZIRGMGNf4hnvzyPpXqUMQsRD2FZaS2f5M82pS9nN1afTdHWqzO20lsDtms7XLE6jbfY/3ZZ4nfDdQVxtI/E1Ho+sfbtIS9mO14z5cwHZhwfz6/jSXUk0fiCBpFZEnheOIlweAd3GO/qK8elRqUazezjf71/Vzsco1ILszF8GSR33hx9Pfck1tcEI6H5oweRg+3Iqn48jnEdikyL5kUrRvtHysCAQw9Mjt61f8Motp4j16xXYqORIqDqFDZ5/BhVfx+sk2lRzIRgyhAwPYg17lKryZkn0lqvmjz5Q5sJJdty74cuL6TSrGzdRHp7zyLDIoyw2c7PQMf0FdE1jbmbcUMirwplYucenNYfhMEaAzK26GDUS6kDIw6Afhwf0Nb8F/Z30skVrcxSsiB2256Hp7GuDOIzjiJeyVlu7dzpy6UXSXPuVdSijfyFRVQfP8qgDt7fSoLOIwKiooKIMKG5z9auXsDH7M3pKcnHQFSPy6VM0LQqishU4wSRXmOb9nFHqqaUeVGXavGniy7VY1Ek+no7o4VgdrY471Q061urYapHbSRW9p/avmtGgH3QuQB6DJzTdXgubTxLp2riTbbOy2lwQM7Axwp+h7+mK0tOtVjuNUZ5lcnUHyMYH3V4Pv7V7Ptp08P7SEtHFL0a0Z5HJF1rSWt/wL9pZIkR2p8zkszE5Le5qWeZbC0kvZPuwHLAg59gPqfSoXTzJ5FMtwgcLjynwM8j61h6lZDUNVFpbG5keOJmm8yYsM5IU47fX6V5lCgq8+actN2dVWs4qyRqWEjx20ZkjSScgyTAdHLHJOe3sa00gtbuQpFJtfGTG/ysPfB6j3FYOhBjn7RLNM7RlWXGFj+bjPYnr0FaWoxQrbKJVVwzYVCeSfb3p4qjy1/Zy1b7BRquUE6bsW7hDoymWRcyFSIYj1kfsAP1z7VQsFMUZjeRDKjEsyn72ec1FcvDYRi5mHlnZgTSOWIGegzznvTLZYllAjdSj9ZCM7qz9lanZfebwvK8pvUbeWSveXcrNhWVQnPTgEn88VjJHILlstKyMhKbRgKfer8Ed5NDI9wI2AlC5APz4PJHPC4xxVny9iHMLDnjvntXa6kqWl77HRhnDkMLEoiZfnUAknaeOakKiBZdo8+6VfmibpGCR19z6VfuZYrNthkjjuh1ZxkW4P8RHc+g/GqlulvKrLBcw/i/JPua2jJ8vM0be0jUdlsK16syJ9qzGFztVQNq+wxVaa5WKVpo0ysUY8sDjLHIAP6n8attatCoY+U6swUqrbjz346VgSXLqHyxMIdivqT0rowtP2sicTKEafuk+napqKSPCs6GNQQI2iDKKJrye4nElyYA2zaohTaMCktrYrbqAuXfkipJY181GbGQCvP9K+iWGoUpKaik+5877WpUbTegkKZ+d2Hqa0P7PnFt5/lMVbO3A/z1qG2QCRCU8zac7Ox471txtd3OQ11MkYABRWAH0/CscwzCWGirLTua4fDe0luV7O2i0uOOe7kaKJl+QfxOx6hR65pl9HcSwvPLsiZ1/dW6gfKo7Me7GrFvDYWurqJpU87YTGsrktuz6npxWmiK0jzFQdn+rHUFumfwrwMRmlTmUo6df+AbxwVKCcdzNtEntHZGg82JmzhG+ZAPTPXimzXtt9oklFldeWse5QNp+f8/0rUjXyopJW5YLxn1qq1rHHAzSYWONS0jnoB3JNcM8X7afPNXbOnDYelCL6JHLajq9lPhYLa4AWUvLHKuBgHJA55xx1pL2xtpfLvNLnUQTK0chC4w+OCAenoau2tvG8klyUAklOQDztGcj+lF1YrJJHGrhXY/ME43855/nmvThWhCSUdLHHUXPJrcg0yEpYRLJgyIdjDuMVduY0OQOFHOKqEpZahmeUkXD4JJ4yTw305x9auXO0iMKTlm6VFeL9opLZ6jo3cbPdFJ9NjlKK0aMxXJJHrWLqUY0XVbO+2IEYlJI0AG0dwQPUEn8K6wRxi4zJIUWMAHbyTWJrNv8AatNumVN8sZMq5HJI5z78Z4rbCV/3ijLZ6GeJg5U21ujd06X7KWltMrcKch3G4MCOOPpWr9ss7zwpqk8aRxztFMRG7gyINuDnjqTnmuW8M6itxoizScNEBG5I4yPu/nkVBqNso06UTKsjxxPICeDk/St6E5Uqkqc9rmFSCqwVRb2MzwaAba7BfPKDHTtXSXdsJERFdiApHXv6j/GsLwary2V6RGC4dN+3r930rp7cwtKRvycZI7iuLMW44mTj0/yOnC/wUiTTfEslkgh1yGS6tl4W5jXdKv8AvD+ID161Q8V6xo9zHbDSPMXzXxLO6MgdBztAPXp1rTj0pbwM0zIkCncwLYP41yviC+h1TXEhUsbK3Vo4mU5yc8sPx4qMup062KUoxs1v2/4cWJ/dx0fyM3WngfWLmKEq0QRCxddhJVcZUdhzWORC7ckHjpVvW7xrzWJpnSOJ3Cr5ZGNoAwPxP61QeUbkVjEWLYV1P8/SvrZ02pM8mnNciRdsgov7YI2B5qEZPQ7hVS9gWC8njYFSHIBAwOtR2+1ZJEe5SJlyQ7dGHbpUp84yBluo+efllBz+dTG8ZXIrRU1oLbYeTEkjbfUdf/r1vxFbNkDvvjiVGZ9vbOeB61jRPLb3KyqysACF3FDz71LdXM9xHgOpYgbm3qvH07H3pVEppRsZ04ODbbO/bxz4bnUxeffFDxxbNzQ3jHwzcIIWu7jdkHJtmB46c1528F8qMI9TgPl/3bpRz3AGefrThaaq8QZbpXIHU3SH+tcn9n4dbJmvNPubnjPVLPWHsH06dZgiyhtilCmSCMg/Sud0qQw6lbvICojkV9xGBx6086ZrDSMC+d55PmKd360f2BqkkgDK20nAPmqM100qUadNU47ESu3dl+d9S0uA32nXNw2nzZcYkyY+cYarNp4knvHSCd1Jb+8CGB9MZxVeaW40TSF09ZUaSQFSwII2k5IFYcYmNuQssA2NkkOFbGeoJrpqKyXL1Macea/MaXiYoL5CCPljAAPI9x71hybDGWQKDnoKtTG8L4d0k25wQ4II780wxiJpIDGGlcZQltuzjP0rFKyOpbWKrOcsR7fyrvrTYNMiO5QyEbuvPpXHBLUB1dCSqg5SQYBI5z6gH09a66Dy304sj5RUTIJ5zjk/TpVIqG5tQSAghQM9c5xiuI13jXbrBPLgYFdXa3SLFubOCMEkdq5XUpUutSuLhGA3PxgYyKT0NGrlGKM+btJ45OTxxVy43W5gUEh9u5wRgn2/CoPLONzDsQOeTUcjRtNtAxhOPcn1qBpWCW4ZyMjBHcHmpFutg4HzsCGx3qJoCSqqAx9Q2MUhjVX2gYxzz3pWHqaOsaldavo1pDKrzTaepVJW5JhbqpPfa3T2PtXT+CNba7Fla3ZJuLUkWsjMP3qfxxHPcDlenp6Vxtor7pcAtlCm0HqCO9WfCulXF/cXaQSyx31tH9ptY1T/AFjKc8e+OnrWdSnGrBwkc81ySUka/iSNG8fRRmfy0PlhmPU89vU1Xl1OPQHvorfiSVh5JHIG1yQ2e4x/SpZdUi1vx5pl4qbFlltvP+U/u3yQyj8aqeNLy0m8bapGiv5UbsoVhjdKBjJ9s1WFo2pRhLoia1Tmm5I0fDlq0ml3l8ZPNaa56tjIHUtz7mtqxfbHbI7IqyK4JxhT6HjpVLT4orXw5YqtupZLcsztysjFcnI9ulaSSQxRWwcFYWjCkqDhQcZBFcObO8oxSOnAL3XIwLydLPWrSa5t470bcGMH5W/D/HjFb8ni5tVsZYLG0FtJGclpcNgdMYHvXL+J0kt5YxvDDy8Bl4zz3/CqOg3ghvTEVLLKvZuh7fhUSwdKpRjVau0tDeM/3tmekaLGXtQJwpO5lOOMY9MVbv0jitSJFlyqEDeBj2z7Vn6HHGqxn5wN+MBu9at3vlmZWV5ImXaQ5zUKVoNGNT+KzEt9Ykt4kRGhaLPy+ahJXPXle1XhdRzTDzZ/nx8qqrAAH0x/jVyG2jTIEUYyPmXGR+NTMix75XYLGvH3cknHSuWSlNcrbsb+3gpc0Y6lWCeCPEcpZNzfKXQgEfXoPxqW5nNuFaAhpCdoycAZ7msW40fWPtU89rfQ+TOu77K4Z4x7e31FCXhtnRb+zNtzkzRAywL9T95fx4rleCjGoqkdfI2WJ5ouL0Z01iEjhDO8iGQf8BIx0qox4IES8/xNz/kVA+pstnh2UxNLsilX5ldf7wI4qzOypFvYgAYzjn8qjMqyqcigti8JRceaUnucnIU8Na0sUjRtZXjBtuckc8nA6BT+h9q6a4t0vYLe4MM0YWTzIvMboRx0/hyKo32kwajFNLcbFnmUKGxnylHQD8eT9aNFvbmeym0m5kRLq1BjKZJLjHysAAePetpTjiaXNH447+ncycZUKiT+F7Ge8JsPHMN0zbRqFo8eT/fUDI/QGs7xN9ptvDsNvNL5qNMqBdgBUckc55NbuqyZsbHUdiO9vdxPz95Qcq3HpWP40maLSrUhQ2y5Qsx7tg1WFlKdWjdeT+WwVXyQqL5/eN8O6Xf3Gmx5nWOzuMuiDdn5TjqOOR2NayNc6TrEdyEWWB28tmC4EYY8ocds/MO3Wo/Dd8v9k2UIUgxNOhC8ch/5VtyNDOssTx4WVdskZ4JFVmdedLFNNXi1qLBx9ph7bNMv35QaPdNu3HaWDRHJXAOOD71k6ZLMLERNdST+Yu5N/Yf3j7nk+2abpzSLpN5Yhle/hcROZBkSRlfkJ+o4P0q95WFjjkRQVjA4PBNc2NqRp4dUo7N/gb4aPNVcpdDK1yKVNEuZVzIFAO0nnhgc8/zqXTboTXmqxiPaY77jAwW3RqQcUzXlSDR7mVZGRgFXLcg5PTmuf0/Upo4NcmwwlCROGHZiu3+lXhqDrYGVu6/GxGIqcmJXodqkwaeO4hdGAjKllwec85/L+dYtk0TrqWrhzAly7KFBOVVR6+hrG0u8Np4Yu4ll/fibyrbJwCzcZ57dTXQobWz0xIdMtkvPKGJLhl2RbhyeT97nPAp1sM8MpQSvdpfJakUZ+2mpvp+ZJ4bcSaSzjlFJJZiBj156EZzSXl+Lq8f7FNHJHHGRvaM/KfboTmrFrpIvybi8kecLKpWJxtjXPXao9OOvrU1zYgTzGHYFb5AWcAfQE9PpXNWlH2jmldv7jopOCfK3sc8IZPMiuJ98roQ25ju/D0Aq/bxSmdyyiKMsW+TqAegH+NWvsMwjJ2qqpw2W3Ag8dutPWySBgsRIiAwBknNYVa+lpHX7v2SpFJiGS3hhmOZGHnS8HHXp369RSTSPZpGlswa7lP7pD0XPVj6+1NNz9iW4NzM06x3Jwm7LMWHA49TUYWVDKkpSS+mGZ5Oot17KD2OK6lTXM6ktunmYpuVqUN3uVZrOIlokZJsHLzBTmRj1Iz6H+VQrprwmTdEpyOHfnJ+hzWlHEY9qRLn0IGQKnnhkEByjvjlgATmsHiZuR60FGnFRRixwC3s7ycDJCBNg4G88D8azXspVESvCyoACSTk8fSuhZVto47aTG4MZ7jnOGP3FP8/yqKa5iDEBgVI6Z6V3UMVKjNWVzmqUvbptbFFICQCuAR29qW6U7VG0bjknauSff2qa2G4qScAsTg/pWlHYJcwudrHbzlCOK762Nc66i9keaqCpwb6mAq+WpYAkD17VpW05ihwHwCCSfSm3UPkkKoLLt3E9TTBHGIss44H3MY/Ku2Xs68FzaoiF47CfZItRuhDIuBKrM2/kZwOfWuh0SNrnS7ZAAzIChKLgNtOM4/CsvTMSXjHuErMtnuZIZYmu7iOxEsg8iOTaD8xzyOcV4OMpe3qypp2SsdCuoprc6bUtX0zTt0E07S3X8Nrb4eQn3xwPxNc1Lqk+psHuQqWsbBltUJPPYue59ulU1sYop/Ltoyi7QcKME/X/AOvU/lpJbs0Qw4I+93Gcc0qWHpU17u/dk+99ovR3YaMMifvJD94jAyPT1p1tEJbgBhkgE5Pf2ppgN1Psk5iXnH930ArTtbNizSqoVB87gnov19KwqOMVpuzVU+XWRg3untqNgFjVdwJeMv6Dsfr/AIVW0e5N6ieZIPMgJQ5BHTgVrs9lf3stvZTiRoAcsucEHsOxqLUNOdWe8sgbd44h5+0bhKB3I9v6V1Uq3u+wqaX28v8AhznnH3vaw+ZDcS4XIBzI3XsPb86ZbahbW80aSvE4D4dB8xUdzj6Vl3drczLGHupHj4KlTgMCM9KLezWG5VjFsVTnaOtawpxhrfU25VONnoiG6sraz8SGGyvFk0u4lWRI0lyVIzhWHGD1/OtW8jSexujIHJMT4wcbcf1rJlsXfVY7vfGpikViW4JywGPriuiO1V1AMu87HVfyPNdOIq804SOJUPZQlDcxPBEip9tMTZZnQq3oNvOfeuvuVg/tBYkI3xw7yBjucZ9a4zwfepp8sqtHie42bEUf7P5D1zW9YyRy6z5437pI2R8tuBxjDA9vpXPmGGk61Sq9NPvOrATThCO5a1HT01Gw8iRmUq29G7A46H2PSuVhniilKKnlzAbCGXiM9+T2zg13PDHgZ7V57qupR3OuXVxDEpgJ8lOfvkcFvzpZNUqS5qb+Fal5jThdT6mD4mMU2sCWNdglhRiu8tg49fw6dqyPLbjAJP0ra0xh9kUuUfDkDIycf5NdGmklrcSfaLdF4+UyqD6dK+mq17TdkeXhMsVWkpudjg/JYYxGw/A0nlO3SJh/wGu2+yxkFWuYsg8fOAPzqsyoG2ecnOedwNZfWH2Ov+x4fznKCGTvG/120eRITxE2D/sV1YKAnfNGGPOA/QU0NCzSE3Cn+783aj277B/ZFO/xnLCFx/yxbgcZWk8ls58vAJ5+WuuCW7Jn7THkLn73WlFpbt968iHbO7gHNHtn2B5RDpM5QQuR8qEMf7oPFSC3uCxURS5HcZ/yK6F1t0mYefuxgHb39MVO91GOfPD5GAAOvHen7Z9if7LpreRgNCz6fgK4lWUbmPYnpj0qk9jc53mPjv06+9amp6ntvwts52vEEbK461qLFZsVEshjAXI4BJ+laSq+6tDipYKMqs4c2iZy32S4AGIW56EdKQWlz90xP611aRWnmqWnURqc4A6+lLHHAS7FgxyQoXjj1rNVfI7P7KX8xyiW0glUNG4UHBGOldG2qCEBI5GMfKklQM+nHpUkKpcRyE/K2w4P+e9W9O8Lw3tnbzy+czyYz5brnGT0B7e9E68YK8tDCWBlGSUNblWPU7YKEe4kwRkgL0+lUPOVG3AxNhs89/wrfvPA6xoxs3u2kHaZo8E/hz+dUD4Ovxk7QD12tKD/ACrD65Ql9tFLC11vAzjOhYFoSi9ucY+ldLp3gPXdRtIdRtLD7TbTR70aOdMj689ayG8NalCwcw7u2FkBqazXXdNJFqL639PJl2Y/I1cK9F/aX3mcsPXX2fwNCXwR4jhbdJod2Cp/gi3Z+u3NZ8+k6nay7Z7KZCCBte2fg9uorVh8UeMYl2/2jq4Hbcwf+dWR8QfGUR3G9mY9vMtlOPyFaKcH1QuWsvigcxPFLGH4UYBBIXH4c1NqbLoesaVqllOEb7NHOuCWXzAcMpz1B79ua3pPiDrskSJO1g4B4EtkDj865rxDqEurwwz3XkbovkCwoE+U+oFUkm12McReUdrFu7ukv/E2mX8dvHatLcR+dDHwu8Pzjv3+tZvje2Sx8ca1Ark7Ll2U5PcA9+auafN/ad74bhkwSbsKGVMHl1Jye/T9apeOGZ/G+tsGDEXbLwc4A/8A1VVONtEccm76noMNlKPDdpE4XzRbBj82Tgjk/wAqerWwwkkm2NgMOJAFriRrsu9Xn2zAgKUk5UjAwPYfSr412xnaJbtJYI1yQIUEig/w/KTyPxry6uEqVZOU5XuejSlGnFRRH4rjRbiIpKZI9jdT3/rWJpszf2lbMu3cGAYgcYrfuYdI1UKB4htYiCcLcQyJjJ56AijT/CEct8hg1/QTGCG2/bdjZ9MMM11U4uNHke4WXtVK+h31lpBbRo7lZcFiHKkgD/69XI4zu2EscnkiotKnjULZztbNcWm1SbaYSKoI4OR0z6VFqsKyXDQLO+MZaMP69On8q82pGUI3sOaTm0R3Wr2llN5MJ+1TZ/1cTcA+rN2/CpdMmuZWmkuSPNyVChNqqvbZ6+5PWqFrpiQSANEFA/hXBAz3xU16Lu1sGmtDGXVh8zrlcE4+tZwjKexnLlWhovKlpbSSlGkWNSxCjJOPSsmDXobuYMsEsO9GBRcZwMfzyOtadndw3KK8dwHVV+YquBu9Bmrltaq6zOyRqCAFCdSev5VnKUYL3yo6X0OVX7REZF02xEEKje8E5DRTH1Cj7rf7Q/KrGj6lp+p3QQyPHPChDWc7fdbPVf7w9K6M2ilWWSHcpU9TXO634Z+3wpcQyrBNa/NHIBls9h9Kxn7Kr7rdvP8AzOilVnDVGoXt5pGVJ4cg4ILjg1zus3ltb3VnfwGNmhl8u4+zy7hKnfpzkU/wjJBMs9lPbQR3EC7ZFlX76Z4P1B7+9SeJdI+y6O2qafHBFNb5WRI1x5kJHz5HsD1HPWpwuHhhsUoNv9P6ZeIrurSehW8TyyxWMvlwiOz1JfMtXz/qnA7+x6/WsHW9Ta+8MBnCmFblMDuOPpx1q7HewXnw7utMup1uLu2KfY9rZOM5TB6DjIxWLp8lvPol7psoaO7izcxpIMK+3BOTXuUqCjutU/6Z50qjlpfRo6vwrG39nxgAFvOn5P4ZNblxC7mNv4lXhl/ka5jwCEnhiKsQHnmJHsVBA/WutGXgQsBvVjnPQ15OdJ+2UvI7MBK1O19jF1i5vNISPUoSmWTyJtxOG53JnHTkHP1ro7eeK9toLiFw0UsSuhPcGqV3apd6fPH5aszRkKjHAdhyAaqaNqM+vaU7pAtgsEgtykfzYwoJwe35V51Wk6uFUrfA9/J7HVTqcldp9TVvXt7azklvmT7KFIbdg4/CuatLa21DXNfEkimybyNoU5BULkdfy5q3rmmNcW0sQYtLNGsaF346+9UdBt0kfXprSHyXiuBiIjd8yoDgdgOc5PSujBwUMHNwlq7fmicVrWjcbqKw/wDCQRxII0sYJEXyVj43scnH8vxrqmlhUmL7NK8KgFZAceWzdQFx2x29a4XTLOfUAjfZnPmlvOkmbKsSeePbk+/FdVY6qPsaQXDxLOnDLnGQOAR7npiunMqNowjF3aWq/UzwzbTb2bNayRSJczlAz5+V8biR6fkapSwx3bMLhIpVkBARhuUAHsPxzRaXduqzzKNscJEUm5tzux5+UewotVE0hC5KRIFJxxn2PfoK8+rzRhfsb0knUk2MW2hs3LwQxxM67Cy5AA+lSXF39iiXh5jkbgoztB7n2qY7DIEcAg5yOmfasuZkhjns4IVNzcuUaVpASq5znA7DnisqEFWleprY3qS5I+6iNpMXjXsVsrXG3KMRlE9SAOpx+VVoo4xcA/aTvbkjftJPqc4/SrclvcIkaldrJn96gJ49cdvxqSVBZukdxFJP5n3AwBz3z9K25/snXTUI6x3ZXKzyZQSuB0IDf1qK4SdJPNhurhG+6+2Q4PGBjNTJaRmVo4g6z43Dy5CuAelX7fT5gGgkkDrvBZ25wOuPr71N3HVM1nVha8kY5QKuzaXZzlmY5JPqT3pkkCLGzMmRxnHGBWiXsh5g892dSdu1M5qF5PtSiJYjFEfvbmG5/wAO1VDn505aF+2jKFoLQy1icSkJggncST0robVmkVUf5ExyFOMj0+lV4YkZ/lVUGQAoPTtgmtDyFS2kKtGVxyc4Ye4z2r3ZqFSJ4cptOzKV5GGLRogY7uH9BVG5Uwts2g4wxOKuT3MsSO4w+3p9az5b9rdi8uk/bJDypecqmPdRyf8A61c0Pa0n3R0U0p7I0tFhdo571sJGPmdiOFUCsLTLqzj08T3M6qJJGYQjl2BJI6dj/WqF/qOua8RaXEnkWat/qYE8uMexHVvxrStbKKDncoQEIQR1J9fasJRjBydR3cu3Q6IUZy96Wlh0EbTyvLOP9bzjParCxL5eduWZgAAPxzTxGlsAo2li2GKnjH1our/7EPKtF82Vjt81k+VT3x6muWUpzlaJUYq+hoSJbabbedcS7R2GMs59AOprLvbi710mObdb2aHK2ynh/TzD3+lRyxN9pS5aRriQkkiZcsv0PYe1WyfMtnYrtZ+QcY46UqcI0/eTu+/b0M8TzfaWhkmHZKCjeWkYG3yxj5h6fSor7UtSntPsi3itDtPmTNGVJA52ZAPGB1q5nl4gPmZSAPQ+tURb7rqPzVXYEO5Qcbvbiuyi1fmnrY5aivHlRR0a78+JbaaVmCMXh+bPy55X6jr9K23O9pG2ttQEuzDCgds1m6roNvpqQaxpMjGBSHuI2B3Rn+8p7jsRUr6tbqsMZuHZLhlcYAVTn+nauurTjVftKeqZy0ZyS5JPUNWkt5Y5JQFVNqn5T91xjk1pCVXjuGgx5bA4Y/3duaw747LeUbMh0YDcMgtyetS2Mjf2XLc8mMOdwX+HKHAqI0U6aa6M3rS5Zcr6o5yzkb+0oWimkFyEEnzdBgcAe/WvRdFgSfSYhEwwOSc4IPvXnOmET3kPkQs5SNcqoLEnnPT8fyrX8prOKaW6mks2V9pC8OAOgGeCT+ldePw08RanF2Fl9alQoucnZnReKL99D01o0lJvLhSkaIuSqnIZs/Tj8a5CzshbRJNKFJ2YCntz/Pmr+hWV1rOoPq1/MJWUExee339o79sCpNVRBcx225S0X7xtnTJ6D9a56UFh19Xi7vqypVXXl7R/I5jT0VrcHuXI/QVbEIYMxUZ4AOM4zRDAiQkq3zGVxnoMgD9easoq7UKs77yDs28g/WvWq/Gzoy+K+rRKESLwzLG2c5yKVYo/MB8tR8p+UDrwauiweO4aN1DbAdxVunHerWm6VI98beVSrfZ5XBicckISB9KyudDUVG5h+QvkjgBz3xTxGq3TZVCmDwelbEemLPBZSI6l5mYuSvCKvqc8+tPtrBZ0nVggvQu9UkGFZO5B9e/0o5mRyQtfsYnlFACFBBPapFG/ZG67cDDMFySetaE+mr5yRwyrIrdGVumOoP0/woiiMU8jwSABVIf5+COnWnfoX7PqjJfaI938QdcD2xUoUsXjwQvzbsduhzV1baMAs6IATgKGIyev5VMlpFAQPMXMuArB8gA9zxTuT7Kz1Od1JD9rt7lkPlyYUH3Bxx+lbQUhGkVN5Zh+Xeq2rxJDbx2zL++80bSDkADrz+IqzGbcSNveUr2z3I71d1ZXOClSarzUV2GS+UxymzPOQP0/GmqGBZWT5mwFUdQe1WIjbKnluCRk5IUZOfftWrpurafYqp+xMzqfmkAGWHTHOeCKVztlCUVorsx4WWKRo5flZCQf9n1/Guz8NQxtp8IjAVRlRz8w9eK4u4Ect5M0UZCSyblLfw+orY0y3hlsxPJHvdpSpZjjP0rjzCClRs3YWGU5VVFdDvHswsTBVb156mqYhIDAhmU8DIrJAL/LHM6kDgCZsU1VYKweWXpgjzDXzEcPbeR60ac1ozZlhJhVfLO4dwtUfsy/eKkA+xqi1qDHKWadti5/1jd/x/zmreZwvyXMpXHAD9K19mor4gjGSHm1LN8gAAHrTWgIH3SSenXg0IbnjNzNj/eH+FSKpf5vOkYdM5qXp1L95bkLWzFR8u1vU88VQ1jSftGlTRbcEIWyqDJI5/lWuWO4YlcEcdRSM0qqcXLDPY4IrSjXlTmmmY1qSqwcZLcxNDtVvPEXgiZ7jNtcwNsHlqDG8TMGXjr25PPNcJ4gkD+KNTdT8rXsv/oRxXSeG9eh0/xFo2nXYIWw1C4ZZQwwqyqF2/8AfQzn3Nczr0T2/iDUoHBHl3TkgnPOSetfaU3zO7PgJx5Xy9joNK8Opf6XBdC5lDyKdwABAwasv4POBtvH5PG6Lr+tWfCV+h0RI2UDy3ZenbOa6Tz0KZUqQeR2r5rFY3E0q0op6XPsMLgcPVw8JOO6OPfwjPGGK38WF4IMZH4VD/wiNyG+a7tMjnDB/wDCu3do5I2Cr94YxuzSeehdHP3kcNk9eO2azhmmI6/kaSyrD20izO8KaTd6LPcRPPbqs6hw8ZPG085BArqy+S5Lhyem7tUNndPq2pRDbGoSAxlQOW5HJ9KsXNj5M7RfM4BIJjHT2OK9nDynVoxqTWrPmsWlTrOC0sVoV3IR83JwWRulYN5d6vZSXFotitxCH3RyKpIYds810k0KpLD9nOI9vzkevpUOrO5kjZEMSMnzKG4zWmiV0jDd6lezneCNRcRRo5ALIp3AH2Iq7ayXMV0JIIEkt5Ww64Kkf7WT/Ks+1EgYK25lz0JrRhuJRKCOMH7hORXHWoqpFp9TeM7al/UDPLauIXaNgMgo2CQO341UivWWJ1uIWlQnBkRCR+IBz+NSy6nKoT9xEQwz1OPyFS27LcKxwod3ztUe3avJoZdiIwcKiVjoliKeljC1K286WG/0xR/aED7lULxOMYKMfp0NbFlcW+s2UU0ESSoVZGjZeQcYZG9+SMVRvydLusH+EA7s+pOR0OPy71TuxNpyHX9MC3TStuvLSM7lOBww6EH14zXVHBVZQ5X02f6Gc6sL3XU5nSVj8L/ED+zpomFuytCrIfmcNlk/HI28VU8aWbNotrfg4nhuHs2YcHZ1XOPT19DUvifVG1A2GswBPtFq6ZdeGIzuUn6MCMe/vVfx/rOXntIFSSyvZFugwb7pxgY+o6/SvUpxqSnCct7anHJxUWkXvh84FrBFISF8+Te31UV6GkB+3mJUkMRO7crfdXHfNeb+AHiWFZy5dUu3zjnGUHNehM9zNdzok6xgNtDY4yOQeelcuZwi3eS2N8M2l7rLMFu3lMTE23zAQ235gPUe9Ymmxiw8a6jZqRHZ3kIuoY1/hYHDA+p6mt2GW9DqGaMlR8xOcE+gwa5rxjdvouq6bq7hd8aysVVfvZGQvuOa86jGFSToR+0rfPobVHKPvy6GzqAtZ75bYtmWDLSRHqo6An86yrHU4dJs7/LA3sl4zQwqMNIWAUZ7AcVn+GENxdahqE8pL/ZoRO5OMMxLt9MdKa97bjVZkLqYLSRXDejPypJ78HOfetIYOMJSobpJMcqzmoy2bdjVs4msrTYpLFDkn+856gc+pxn2qpqumwQeH90zBmhmEkhUYLITh8H8evtWjbt5kZuONo+WMDpk9W/oKupteCSN41ZWQphh/eGOa8z61KniFOXdXPSdJOm4xKq+DNHS0dYreeVLlRJBNb3O8Kw7HHKgg9Tx/Ks+xS7stYu7ESySwW6I6eYOV3Dofb8K3/CM8P2SR7priTULSNrS4aONnfYMjOegBXGB321mfZxcapqd1Deh7aSZY05wzqqjHv36Gvqs09n9Uc7b2seFgudYjlvoriXUlwYmlNzGiJyxVentk0unW0c0H2j50lmwGHHyqOn5/wBapyXBvdRSGFYTZWpxLgZ3vn7vHXn+tasdxHuZ8xoc8gPyMdvpXzdSLp0lC2r39Oh7CfPJzWyJpIyh+eWUqTgbumfTNJNJBA/myhkTbt37cjpnH5Uakxj0+zliimJLF8vxk8dPzqxqDW8emWlrvJnIV2UKCMeufrXXLLIwpuU3sr+phTxcp1IxS3ZnkxXgaS3kUOpy3G1vQGp1Vng+y24JB+RyvOASMjPqSaosgV0k6FTw3cVdja3MyOSkTKC2c5O4Dtjp61wYeEZTT6I7sbenHTUWXTBLM0Y+URYjAQ8DHWlFlaxKxk4G0/P1I4qa2mATMkmxCdxIJy7HqeB0oKws/mSEmFclmkbpzx1qKkW3zNmKrVF7nRGbY2xe2VpTtiTLMzDGBnqat48xHk8pkDHCKRnA6bj796mEi3kiKYgsCndFGFx5hHdvYdhUpUl2UMdrDmqjX9nU55BUm5aGHPH84VRwxps8BRy7BeegrWktPKnIaQOSnyjuPU1ReJCyMAu08cHpXtRrxqWsTFWWhmSRnKn77852r09KZKEiDQMN8jckDov1NLqPmKo8tioZtu9Rzj0FPMcdpAqnLNjhR1J9TXFXSU9NW+h6dKTcPe2M2S7uuo8pwDnAGNlI7TXM4lU+SnmBtmc5Pc1IqqWYsMsx5p7uYJkBT5Txx2rocHGF0tTHnXtPdLWpX9vaxww2yrc3uwlmc4VR6n1+lU4rm6WzjmnCElW2BRt456/jWbKUu7y8uNpIDL83QHtxUE8bsQgdgnXbngmpp0IKKi9+pz1Kjb1eiNvS2aezWaRQWkYq2euBUuoRxWtuLlQquvGQBnB96yLK8ltYVEJR8nLBxx+Bp1/qrXRijcBYgxLJnhyKl4eftrrYjnXLbqW4rmR4BFC+3G8zDqNuP/r1z0WhxzaoLa4uRDvXfZu5+Q8/db8Og96nF/5LPuHl+YoXK+nofas+RUuQbUytGr/Mr4zj6eld+Fi6U7taMxxFLmhZb9DcSzeMPDc20ivGCGIJIPy8kfn+FVLCWQaVdS7o4wsIYhuAcoRx6nNUbXxJJDbi0nUb7ZtqTqCCRgj5vXI4qVnmh0jVk/dMnkIDhSSmTnI9Oa7nh1Cb5PhZ58sTKpC0/iiV9Bu4bV4xBbtPfMBtDfu44yPvFmHJGKjv9QOpaiseoTNJbebiWWFM5Az9wdh/Oq+i74Ib5YxvE1vtJJ6Ann86lli2SvGBtAAPXpW1aah7sVuXg8N7X3pPY6WXxJawReTptjIIliAjNxtAX3wOv0rKgPnTSTyttkJ3M2Mlie35VDZxQCFfOYhjj5du4Adz+Xan4hjZzyqueexx/n+deXyRi/dW57EacYp9yotwlxZbguHE7ZA+g5/nTGkdFUoSADkYPQ+tTmwl0rTVN7IkYkuWCMfTYpyceuahjuNKAxNqSxtkYCwM9enUi3J2RlgcTRhhoqckmWv7TmJUtGgxuyVGNxPUmrdrq23UorsDy/LYExqAcjGD/Xis7zNGJOzWY9vq0DjNAfSRFu/tSJyDgoI2z9fpWXK+x0/WsLa3MjbjurQSTwwsfsKr8xA2uwJOSoPQjjjviprm70+dLeKQs8VtCUjdE2vNzwMnhQK56O80dWy16SB0C27EZqKS/wBNfBN2/BwF8ggEU1GT6GXt8Pe6n+JoMnlhZcyPDkeYfT6ev1p2N0bOqgQNlQVwC/09B9elZ0Kw3Lt9nkMnHQKfl/On/wBl3jEskMwHTAYD+tCg+xUsbTX2l95pG0mS5KKQ80SrgEdR2ZfX/wCvQbVnc3b+XICgkljX5dq+pHb6Vnpp97kK0MmF9ZAG9uc00aTe/deB2BOcecBzR7N9jJ5hT/mRX8Qqd8ckcu5MHYcY4zwSPcVCL2Je5zt9O9XNQ0e5FmI1ibzppAq4kDZPPvxVqPw/qcZ8qSxyQoBAdR/WtORuOqOSni4qvKSktbGYt9Hgkbz/AMB60z7cobIjlI71qrpmoQtzbf7PLDj9abLZXUZ+aAgAZI3CmqMn0Z1PHRtrUQ7SjbXEri5LRxtF8rMMlWHTj+tdNo0Jnt08wxRqshI3ngiuchtbkhnmhZiBuXac/wCeorR0ySRYGDSIGWQMQRyD9a5MZG9K3Y2wU+avdPdHVW1vA8zyTO7JEyhlTgnOc4wO3WpotIaW3MaTR+a0u1SSPu+p9DWaNXliZ/s8MalvmJOCAcY49M8moYdSvktJLbzkVXJJJADHnPXrXjOFkei412207Gzf2L2ipAZ5XtpThXROGIGD/WqghRXB+0S7ScBivGain1W+u4EinEMik5VwPmBGOM9qrtczuuSI9o7Ak/Wsa0G37uxpQjUUffepdSJHG5ZWZenpmlYCKNiWDBRnB5rMSYo2RJngjaScVIl2pQbvJVccktmsXRle+50S06mmseUDHYOAeBRsDLnzGyPQAVTW8ZnyrAL3zj+VPaaWRwBMVXPJEf8A9es/ZSTMmzzvxXoV5plzJqDRKbG7mcRSAg8jqp9D1rBubue8vHubmTfNLhpG7k4Ar1LxjarP4FuZGVj5N2SSMccjGB2+9Xk+czMMcAkAV9thZc1KL8kfB4qPLWkvNne+EIy+jOADt+0NyD04FdAyOp4556NWF4Juvs2kArCJHFy7Ak8LwK7CXUhKkkb2aDeS2N+cZ7ZNfO4xJ1pNvqfX5dUqxw9NKN1Yz/M2grhVbHQdRSuGEW1o8ZGQahkglELPvIKgkjGQRUUF64iwXyp6ZGTXJ7NNXR66XNsW7TWLbQ7jzrnKllwoC7txzUv/AAsLTIy0S21zICSzE4GSe1cr4iR7q1iEb5bzOR0xXNtp03B3g4689TX0WCkvYRTPkszwlSWKk4rsehzfEK0TlNMmI7AuB/Kof7buvEDhLeySMQoAUdidzMeORyckHArgns7gSbS3zr8vDGtbRdYk0GKYGDz3uCh5ORhDuIIxx069q6lyNnm1MPVhFto7bT9YsI8Wt5dGzmhO2SOZcbT7Hmt62bTJM/ZtQgZGJIzMM/rjNeY3NlqfiS8n1G1tLmUMRkw/PjjPJPWsp7a9jHl7ipU7WU8MD70nGAoUaktI6nskunmWRpF1lEDn7iImMdsHOauWNjNZkmHVCS3LKEGPzz3rxJJL1F6L8q89M9amsdSkt7jzTLIHXBVegPPr6e1S4xsVLD1o7o77UA76tPHfI0u2TcXB2koTxkdP/wBXWtaDStJLQXGn7raYtkSLMcn1BXOK5zX7iaC0+1PdwfZyqkATrIZnJGeByFA4/SubHiu8Vx5VsUA67CAWPuQORVJdyI05TWhteJ/DLww3LybIZ5c7lQ4R8HO9fQ4H3fUVy/ifT7uHQtEvrkAQXMTJbjqwVSPvMOCeewruNH8aWmpqbDVogu6MxCaQlkyeBnHNea6rLfrFNplxO8kVnK/lxnohJwSPY8VpTuzCtBwdmjsPhtEWin2Kzotzk9/4K9B8QxQv4Z1IQRz7mtzIxI6HIJx7VxPw51Sz0DSbi8vLead2vBFHHBjOVTlua7A+MfDmpRXFtdWeoQwTKRKNu4MD1+6c1nOCcrs2owqWUlFtHl0Oo38IIhuLhcDqrkAUS6heapbKLl7m7MRXYhbJ9Mc9M+tdrP4e8FX2RY69PakfdWRuPphgP51jeIvD1v4dtobmz1mK/NxMIika7Sg65PJpKmk07HfXrQlBp3T9Dd8LW4m0WW9SMB7i7aUZ/hC8LkHvkHiuW1ANfvr0yLH5iX8Q3RjC7QSCfbJFbnhvU7kx29hE6JbWy4uGIyWbPIHpzu5PqKwvDokl8P8AiGaE8me3k56j94eDWeEwtSNepVn12POqVYuMIroegREoFiQA4UfeHCn+tWTMLNgu0vM4+Rf7x9Sewqr5pQGO1K+Zkl5W5VB/U1GGBZgCS3QyMcl+nJ/w6V8j9UblzT2PofaL4UZOpand6BqSXdtqJWe5SQTts+RnHcAdMZ4JzjHSp5JGs9CjNqkYluEAYhSGWVuWJzncSTxgYyayPFEEBTT189o3EzrIzLlRkcEY5rVtYg0kMik7YlB69/4QPp1r2ak74ak57Jt/dsefGCVafLu7FrR7VbTTETygsrDdIvq1XoY8ShhDDkDGGGc+3NVbq5eOa28uVkLZVkU43KOpNSvdkuFjj8wgZLhgqnH1rx5061eftV9o7eaEI8nYs3N6RpCWrBpp1cqBvHUcg7eq4xisnzZru785kZZmO533/wCePapLaSS9u5xFEfNWTGQATgjODj6nua0rTS5V3eYvlY53SHoPoK9XFTqztC3RHHh1Tpe9fUi2CO6G5WZAepbtjrTFUFyUjcu2evOPerRWFoyEYuV+UO3APP8ACKuW6JsCkgc53Ec15spcr5FqzoqVOb3pDYNiRSSGMxovy784yPQDvUDh9QmDzqqwqP3cf07n1PtVy4s5HinLrlF7BumO+Kox27oeC6jP8RxUThKnpLRkQkpNtbj9jrs2k/KcgjjFXDIsMBnIy+eF/vH/AApG+SVU3pcEDqB39j3qpdRyTu1wcoDwIw3CVnGlr7zLSc2rkjZIaZyNx6kd8+lVrrasO45556c4pVU+UAzY7DPNQXTOwdC/yoMH39q7qbSsaqPvFG+miNuIoxvZuDg4ArNDMsr7G+Y8M3Wrs0ID4ChRj8zVFkZGJI4I5FawndtnRypRsBdY3BZDgdqhu5fP3LuJAGeRxUuxpMx4yT90+1V3llgkaHbgsMZA7Vq6n2SFSu7k2lyQyI9tcBFMpykh4DH09sUt5pz28h3DBALLTbO3Hk5JyvPHt6VJcT3Is/KMu6LnaXGSnHOPbFcrl+991kzgrXKdvarPbxkLjPT6VXu9P33at0ROgX1FaNoFOnI7deCcdMD0pqBUkBZTk5b866lUkpMwirq5jNaJMXjdMjGVwcbaguiIJQUQsIwFJYf0rfMKFWdF4fJGD1/wqq+jzag5aA4Yp1k6bvT3q4V4p3m9CnrrFHKXtpJcuBHHsdj3Pat/wu9vIur2t2pV5NObadxCkoMg8dexqk8Mi3SRSLulhfEqZ4J7DNWL6wOn+HLDUoZhHODLa3Qj5yGyVJ9BjK/gK9bDzcvdPKxkIx95dTD0VmiU4dWaSLkHoDuNawhh8tpyGODjzC2SD6EelYOlneACOQpzjjFac8ToWUsAch/mfB+n1ortc+51YL+ENmJh/eoo+U5+ZcVPcXiXkCEqSxJO3Hfv+FZ000sknluxwpGVJyBmnQuViKlCzHjAb9aycFY6ozs3qXdfnW40O0LPudrmbdjpwFH5Vz7QBwqscjgDiui8QsDptkXkaZjJKSXUA4+XAU+g/rXOxSF5YwoPDDqa92ny21PkJ8w9bAiRgVBjxwD2pwsFAA3N9AelaFyriQFEPHtmmq8zHaUMIA/udTW3JBdDD2k2r3Kx05W/gcgdzUy2UKIPkBPvzUIkuDJtkklHPToKeqta27Slss/yopOfxpXj0iNqf8x0Ph3RpdVe5itNq+UillJxnJxitj/hAL7fkjOe2P8AE1H8OZyj3xc/N5Ccj/fr0y1P2lWlXhQSGB5H6c18fmma4yji3So2tpb7j1cPhKcqanI82Hw9vi2MMDjjBQYNL/wgt7HIHZJSgOP9eox+Ir02S2kWaPGVVlJyEJ6fWodQikEaqwcIxwmUwHb049u1ccs2zGKvOP4G6wlBvRnk2seHNStZYmFu6W7SLEsgkGAxPAz2HvWhceDdej4i2zuP7s/U+5JxXV+IfIt9PR5Z5IQs8JBcblAyM8diPU1rR3tjeKRa3UM2BkGJwSfernneLjSjNRXW+jD6nT5rXPNm8M+I4G/eWLqwGDiVWGT0IAOazJ7a6sJRFdI6XGRlH53A9wa9ZmHlwI6Evkjkjk5OMGvPfF+BqAI4JVcmvUybNq+Krck7WscmKw0Kcbo2tAk8nR1lk8sDLE5Iz1rn9TWM6pM0aFU4JPTccc4ro/DOH0VGO7925YEHnr2qQNHaai4awWd5fmG77yj37V47xDWNq+r/ADPrsDFQowaV3ZHKi3UbXAIJ7bsk11Ol+GItT0uO4WW4V3ZldFC4BB96sy3tskcivpfyv92Pb0PfnFa3hYTDREKqpUTvlCOoz0q1WcisdWmqSlH3dSjL4KYRNslc4Hy7gnNVU8Kz7hFFOhY8kZ6D3G0cV21xOPLIBChumW6fSqQMkVwu4KkbDeXHVvrWdetyz5YWZ5dPF1rNuR5n4g0mbS9UWFL2VkktxIdvQHJBAz71RVbp0ULdTn0B24/lWt43nlOtxeSQDHCqjPOOc1hJqFzblldImLc5BwwrvpqpOmpKx7GGlB006l79yeS7vLP5TPPnGWCleB+VImrExljeSBz23D5frUUUgup0DIUzkEZyT1phtVt0AZF5xg+vetLR2ktTZwSl7ux1Vg66h4D19LnfL991c44OwHv/ALteMhjvDMSSQMnHtXrFvfCDwvrpDbA8X3T0yVx0ryZj8y+wr08K/wB2fI5jHlxUkegeC4fN0otlAFmb5WbHpXU4XzAXEIVe+7rXIeDbdbrSpcxq7LOcbunQV22g6LazazAlzZoY23ZGcgnHWvnsbGLxEk31PqcJVlDBRl0SKZk/1y+ZEBt5+bqKzIwcDhT7V3uu+HtPTSJ7i3tUSVELKynAyOP5V588fllmKu+eenSs4QjHS5vg8d7aLlFEWo5NujDCkOCB2/CswRNIuIVO7O/eTgde1XJWMkEkIjd32ltrZ+XHesoyshCA5x0B6H0r18LFqmkZ1qqdRuxK65Ds33yMcVWSGabVbaCDBllIRAfc4FSNcDIbaVU8niiCULq1lcyKQiSLkhecA54rrh8SuefjrOi2j2iy08abpVnZ2VvhYmCtt+TCDqSPXPNcN8RYEh8TpLhszW6uenbj+ldG3jrTEspEtnlkMUoCbgSX78nryePXmvPNX1C71LVJLu8ADNwAinaoHQVvWnFxseVl1Oca3PLQoooYyNu4YkEd8U77K32dZCo24HPrmok2tKxzhcZx709HXAJfAA71zH0SakMiswyARRqWZuigZH+cUAIrlXQ8HBwcY/8ArVIrKpdUGTwAc44pZU2z7xIrkckj1oJUFFaIhFu4VtxVc9PQ8+lQTxt9oms4piLm4VZPNJ4baMgc+tWkQll+XKHue/1rJ1r5ZrV0cghSAT1GDW1GVpHl5rSTo8y7nRWN20nhm3Aj2ytdzyMV7sQowP1pl0ifbPIiU52jhW27mPWqekSuyRx7TsyWGDgc9/0qd7h11GWdMHDHoOMdPyoqK8isBphl6kgh1S3QuAGjUf6zAbA981nXk08kALgBEcEuMZ5Na32yKVtxnaJewIzj6etQ6m0c2nzGNF5UHqAQR1+tTfXU3xFNOlKz6G74diiaPVLgGUBCyhU+6cL1Y9fcVzuhXj2+hagsTFGlmhViO4AYmt/w9Mq+F9Vv1TlM4YngEr6dzWF4fVntLtHZT++TcMccL1rZScbtHiYaCq4iMXsXIPEepRkkXC47hkBz9atReJr2E+YWRi/Q7ckH19qbm2yQFRuuSU61DLbxjaYxtU5JAGMH0rmcFe9j6F4aKWpPd65JstLie1jmMM4ZUGRvPvXY6dOJ7KG5KJCssXmFR0XJOa4LUB5ek+YrKr+coAxyeDyK7JSrWllp+8DzUzK2eka8kD/eP9a8vMaXPCEIrds8+TVPES7WRJHG13O1zwEfAizyVT1+pNbml2VtKZjdLuGMIMCqiDy4du0sOpKDgZ7e2KjhUs5JaQhfXoBXPQrKE720XTyMqyc4tX3BIW0fWLyGzkaO2mRZR5iZJ7EA+lWpppJHa4kYsQnAYlu3vUdrcpfT6hsnlBi2xSxHO0A9CB6/X1rN1uU2lm0XnFDJhF+Uge/8q6sZGdWouXZ2IwzjGPLLc0ImBt4hICCyLkkdCa0raaSJWWVdoyCxUg5xXPW1/L9lQvCxidR8xOfxrWgkMrTxowBUDKgZ5PocVw0cJN1tfkb4iSUbs1p5baQjyn3M5zwc5HU4pZoUC7C58xiOvIweetZBmEccAjmWHEe0L0IwenrV+0uVvELseGIyMMcH3NdleCk25o5IqUbWZI9ptKuwCjGBz3pjxEAjduH1yMVYcnchGGK8gEdPeklwrMrcN6L1NebPDLdHRGu9mU50ijEfzK5I6A5qg0eVJX72Mn/CtD7EykyMq9cj1+lMjUSQyMQc5x9KGrbHRTqJLe5kXqukMU4IBVs5/oaoTTQTMSWOT14/rWxqlqZ7ZEjXIVwXyeorBnhaKUqVw3pWtKaiu5uoKsld2sLaSxws8rPwF44rPluBdXLSlMLtIUYzgVZMQIcHG4461WERTLkD584OeKqnBObn1ZrUnyKyJrS7aJhtQNHjkEd/WpbmeCe0k2ffGeDxjioGCfKoBYdDjjmop4X81VVCSF6jrSlShz36nO5O1+5LbZNtDCpzuXP5df50u7IIIYv6+n/1qbpUYuIQy5yBtGe9XvK8kytKi4xjbn9aU5KMmkKL01M+IlFKs3I64/zzWhBLMloZINrlhkITjn6npWc6Zcxrnf2yMcVTuLm4gCI0jbOjEcjPpVSp+10Qcyg7vYS52wXLPPvDyDO8c7DTJXefwbqscRTZEI5mLLlid4BPtnNULuSaVXWViXLAE5wMVo2sPm6ZrSgho207chXqNpBr1MGnGauzjx0lOnojmLS6EoaQQrE6jnyxjc2c5/WpLm9aRmCrhWO4sRn8Kp2JdbeXEir8wySev0q4F/dxoSMAcY967K1ua7ROCTdOydiO0jW5njR3MYY4LDkk1PdQm1dVBOCpw4BHT0zUUafLlQd3YdMe9TyF38uB33yIcAEkjB759Kwb97TY6ZK0CTXJHeyswVUDMhGzkHkc+xNc9KgJRRkHODg+tbmohDbWrISc7yd3+9WYq+ZdxKB96RR+te7CN4I+TcrSJdUsY49QeONdiALgAn0qSyjlgk+WWTacZUnINaGpw7tTm9iB+lWdD09tQ1SG1UH944BIxwO/6V0qnGPvM5PbSlBIpSSIZJVbCKg3Eev0rJupWkl8xgQCOAOgFbOooqX16sTFohIyLkYJANY7hWLbgcKO3rWc25Rua00oy0O0+HjstzeJzj7OGx/wKvUtLkD2E5BP7tyeuDnrXlXw/BN5dFeptjwP96vTtDP+iXYUBjk42/Svh83i1jm12R7mG1ofM3Y72znQO4lGMHlT8p9M9Kr3txHMLeKBt8wl3EupwDg0WuZLCJREcHgndgdO9MvSV+zeajARuxwOR93H5YrHEV6zoO9rNFQhHnRzviSTPh8lw2/7VAPQf63/AOtWvPlCm0IcucYH6fpWP4tlz4cV2jCO91B8vTA3+nrWpd/wN33EgHiuCov9mgul2bx/iMfIB9nhDBmJGSBxkV5n4ykDaoCAQNo6+nFeiQCWOK1WXzDnhmPQHtXm/iw+ZrAHYgflXq8Nxtin6HJmH8P5m3oM/l6PGSNqbn/nT5w9xqCkPyVwGH1wKTQQW0FCVy6yPt+tMkeS2v42MZ8wDhPU5rlrJfXKlt7s+ny+T9hC29v0L/8AZk23JGW/hBXGf1rd8OP5ejKGJRfOkDH156VlDVHwFms5hGWLcLmtXw/ubTAQRtNxIckcjn9KzbaWphjKk50rTXU07nymij54zkkHoKgEiyBQC0iRjPPf0GafebysX3Wxk9OvpT3KIiJgsxHzkjGPpXJKLi2rnnL4UebeJlWbVZPL3kqQM4ztwK59bcHLPjdn+6c11N0PJ8SN+8yJmZeD05rRELsBl2+ma9V432EYxt0PfoRTpo4uzAW8jUY4bjINOucl0LMSVfB3Cuo1OJkihRl4M6c596ydWDBlVSvBwNvStaWKVWSlY25W+pUuXC+F9ccHLKigfQkV5sxIbn0/SvUNTgRfAuuS7zuBjXPY/MK8ubO78K9vBT5qbt3Pk81/3mVz0HwGM6bPg4Pn8YPPQV3+hpIdahkfLYzz7Y7V574Khil0eQum5vtBA7fwiu+8MW6wazE4TBIYY3Z7V4GNaWIk13PosMn/AGevQ6bV5kFhep90lCCn5V5m6mJ2MbtGQfukZr0jWBE1pOCp3BTlieSD2rizp9vcbt8e7A6hiOPrWEq1pLmJylKNOXqYUKPcaiHAHmCJ+M43f59Kzy88pLmwlYd8HjPQ1vxWlraSRSqGUSsVLFsleP8AD+dRafMsVnccZeN22DPqM4r18HKM4troceaYqpQqJQdrjNC0yfVLS5lS0Q+TII8SSBSrYB4FTeINBu7XQZ7iWC3ji3puIkLtuLAZrf8AAzBl1UuiYN1uyD/sjjpTvHUif8IhPIcZaaIKFzkYbpkmtU37ayPJnjK0o2bMF/BVvZZa51YRRqQA/lkqSetR3Hh2GzvrcRX3mRTvsLAf6s4616U3zxgSsFkYDaCu7II6EVxus3KOLBxFGiJcqF8vjbyeoqZTnq7ip1ptpFA+DELAm9h+bjJTr70yXwOnmELcQnb/ALBGa7dI4rkJvIZmbGD0I7VbaziWAkJGSp6DqK8yOOrOHMeg68oytc87bwKwj3LLAeOgJ5/WoU8DyY5ubdRnglzx+teiyQRldkK72HAAGM+1U2tlZWElrHH68A803j6sfiHGvNrRnJ6D4Kt76O7F5LITDL5amNgA2MHNcL4+04aTrSacjmVI0DrIeDhucH6EV7N4fU28mopu2Oblvm4IIwOK8l+Kr7vFqnIP+jR4YHPc134HEOpW5X2OfHTm003poM0S1GsS21nDIsLiyDMzA4yCR+dXLnQ5rC4MEijlQ2Vbhh/jVfwHC51ISo2FEDZH1IrvdOiTUtQummiik2RhF3HnGe2K2xGJlDEcv2bHVhI2wXP2OIi0jeNwzjP8IzirttoyySLFtZg+UJKnvxXptir20ZEaxIp7eUP596rT60bUw2zxIzXMwjSVTkAjn+lXDFQnLlTOKriZWeh5w7rp3w0sYZgd15eyLIyHnCHGP0rG8OSRtbXRcgMZt2DxuGK0fiBPJZ6uukY/0SGeS8jYjHEoBZfpkH86r+HvCGqajYtcmzljWRBLA5Aw6+2a7ZSUY6nLg6jhWU0a4Ks5KgAdcZBH6VC4YyZI6knkYqf/AIQ+axERvBLEJeFJAGT+FS22j2Ucm1pWPYt5owB64xXK6sdrn0kMRKUbtK3qYuooF0qJ3Pyi5VSAeTwav/2lJbhJIE3SfLGC6gjbnP8Ah+taf9k6ddT29tNMrQGXDFWJKccEeuaoPpbPqN3FFlY4Jn2IfQYGK0cYypJs8erLmx1umhaj8TX/AJAU/Z3UDGDFz7810On36X1hDLMqxgEhlQAjHr/9auUbS7pFWSK3lZT8wyvWuysEs7fTreKeLYfLy+3BOTnnBrknQhLZWO7FTpRguVa+RRuI/wDifXF1aznyRFF5kyHqxO1c+v1pLy3a4MBdt2GwSxyAv+OaW7v4I31MSyxqTYIIViPysVYkAj15reg09Wt4fLCH5BnGcZPJoqUZNxa7Hmquowd1qc5a7Usmti6/aI2Mf1HUH8q2LAvLHKYisQJwU/rVOWKW3uXulSPMUjI4I6jqpq9pEoFndbvKUebnK9s1z1L07zjuac/OvUdFEdqh1LSLn5hzn3qxpU2yCJGiOGLHhsA5/lUd5cCO3fYeShwQOATwOatWyFAq7OECrnqOBXLTc3eUt2Oq1ZKxZDMoJZ9ig/wjOfxqXavlbkB3ZGe/40kYVYmDOflO7hu1ORY952Y9fm61tUpSaUk7nMpq9hCiuuFzu7Z/z1qv9nRUYISGA5LetWwW8wMu0jnoeRUbBNpLnJPIJP8ASn9XXI2yo1WnZGZNDsXAJyec5rInCrM4+/k9CM1sXUjFflAx1461mCzcu7HpngnvXnWUXds9KlLTUx7hV2kNuI9SOvNVrhULgLkKB09PSt27iWe1EQQA9cZyBWRPAQdrDBPX2qo1l03OylBT1kV1B8lRg9ecdaka9Fs25VODxyM01F3secqMHHTj0p15CHiVoOfm691NUoRcveMa83eyI9An8qJWLLsJY4A5HNdAttFdQ/KVLHncDzXK6ZGVskkQhlLEHIx3rYWaSDlG2gddpwSanE0rzvF6mcFzJD7mze33S3AV4kwCU4PJrAuAkrypHMkW5wMMeh9fpWut2bmR2nd3AHy5PU1jT2/nahcKzEgFTxwWOOcela0FZvm6FypyVr63KF7G0UeAqszZG8HccjpWnpUTW2kahiXG/T5d3Od2fT6GqdvCsF2I5S2GB2Mx5xT9YuWs9CnEajYy+VGSOzNk4/GvRw9S1WMEc+Lpt0JTZymnRvJHKdm4DDcjjGf5dvwq48Mlv8m0kKN2cHp/hVfQstNKpk2gjGfb0/Gti8lQqg87cAgCp1247fSuzETaqWMMHBum5J7ENnNJZXQcQK+4E4dc4BHvSW1vI+oJH5JCs46j2z/IVPGxlTzw25o8MykcH/Grn7oTQT7SpEhLEHgnHSuNztK1tWaa66mXrDwmK1aN9wETnpj+M/4VlW0hEkDoMujhsHpmr2opuFm4B2m3PJ74kYU20t1a5jUchUZz9QOK+poJukj5as0psY99dSs00m2XLc8Yrsvh6yXGvRzKpwqMSD1BrAttJnlhAEDnscCus8AWqadrEs00iRxmFwDI6qN3pzWtVNQdjlhKMpJWOO1Hb5wZM4kVnJPu7VjzgrBO3XpW7q0IhmjGNp8npkEfePpWJMGOnztnIXGT6Gs5/CaUtZfM7T4bopvrht3AtgTj/e616H4fdIo7sSFhk8jOOgxXn/wwUvc3Gcf8egP/AI+K9C02BlnvBHIeJCRjsfavh85lbGP0R9Bho/7P8zprIILGNQB7E/561T1WP95bmEruMhGD908dPzqvbTskQAc888VJNIB9na5bEfm7R22ntn61yzrqdBxUQpxtO5yXi1mbwtE53eYbyDcrDkHdzXQzq0rQHAPzHr34rE+IGV0FJF/dr9rh4HH8VbNtcxqYjNuRBzuK8E4rmr64WDXd/obR+Nli5AWGTcq4UjOK8r8TBF16IsTjaOD64Neo3d5azW83lTIxIO0E4LHFeWeL+dXidj1/xr0+G9MRL0OTHr92vU6Xwwpk0tlwNqzvjPf2qDUw/wDaMRyF+QnPTAqDw1cNDYy43MgnbOPpVq4kEuq26smFYAbG44965MRBxx9R+bPpcu/gRfkWE06a6t1e1kn3jqSxI/StTQPPjsCsifvI7xkfIPXg4rQiWF05iUsDg7ZMADtg+1VtOj8p77EgeP7c5PPJG1fXvU06jnp5nJiK0pwcWjVunMky5RFwu4ktnFQzbmAkkKhmAx/SmS+UZ8BGQbMlfXmklx5o2qBkYHOcVljX+8aOOC0RwXiApHrZdvlUMeQec4qsNSuEIP2iZt3PDDj2qbVboJ4tdzDvWPKgEccgcirU86Ts3mW3HYbQMV1yfJGKcb6H0mHvyLQzJbuaV41eWZ18xSVcg49xVO4bMoAfkngVZuNrTRgqqYkByFOW56VXWUrcgKAG34BA7elddNK10jo62DWtREXgfUrXZuaaaNA2OnOa84ON4HJ9QK9A8SlR4Nm+UFzeIN358V5+zEOPXtXr5fZ0m13Pj82VsVI77wTL5ejyBQrET59D0Fd7oEztq8JCkbgcDNedeEpzBprx+QJCZfvFyvYcV2nh2/e4163jWFI1YkDDEjgV4eOpN1pM+iwkk8Al5HZaqV+zXOSC3l54Oa5PaHTaWZM9QOAfrXU6zC0dpPLHgK0Z4HY1xv28ohAtpWY+o61w1actLEZW705epRmlc38SkblUg5K8D04rKleS0nneRyELAke5q8fNEnnTKAM7ioPI7VBq6xTeW8SBEZNmzdnoeM56172X2UeU8zO9akfQ6XwLHJcDU0aeSARzox8tQdxK+4qx4/smh8JySfaZ5h50eUkVR3POQBzVL4clpZNUAdvl8rcMZ7HFa/xAJbwbPk/IJ4sg9T81Xd+3seM7WNVILiW3VzeNkxr86IvAIHTOcGuS8QacmnPbGB5WLuoPmkEnB68cZruY1RYI1JWJBEpx+A61yHi35xE24NulGCPTNc8qk/acr2LpWckzo9ERzO5JBCn5QV5ArWmjILsqoGFY+kyiB5GZskgAEHpVya5jl+QAgmuClVgqDT3OytGTq3Q4iSd0XhdvzcHk06S0Y/xAunVs9M1DDOkUWC209GqZNQiiJOQRjuOT9a54qlKPvscudP3Uc9OHt572OF8MJsnjhjsUgV4144mlm8U3Im4dFRSPTjNe0SzrLfX0hAKtIpAxx90D+leKeOmJ8Z6l04dRx/uivSyq31iVuxWNb9jG5qeDZHh+de8G0DP+0a7/AMPFZtQuV8zBMYyV43c1554VQzW8igBtsPQ9juNdv4ZjlXV3YhEYxcqc4PPWuvGwTrN9Tswsv+E5r1/M7GODa7N5z9eQD/OsvVlP9s6EjxhYlumOQME/IT0rahWVZGmkSFwwzw/P8qqalHKdX0aWUIsbXeNwbPJRu2OOlTRoPni9Dx5y0Z558WLJIrvS7liD5sLxtzyAGyB+tdx4OilHhDS2mKmQW6hdjfwHOAa4v4v3kq6hYaYyr9kjhNwhGMlm4JJ/Cu78LFpvDukocBRZxkADGeK7a3uw1ORaom1C3juJ7OKRsr5uShwd3y1YNrHDHG4hiK9ASoBweCPyqOUrHPAdvIkJLHscVKZ7WRkkSeFguRgyc59SKyotNNltuyRzXi9Ht9NW7to2jltrmFoUjX5mJOBz6ZqXwk0d34bjaUFrh55XmYkZLFznP+FW/Gz7/Cs8kEqfLLbncG6fvBzUGiG2jssw8bnd3Y4O5ixyRjscV1K3JZCTs79TSe0gwVjSRG/2umayZtOmaUEIUX6ZNb9q0K4Juec8KTmpRbxSvgSkt3ORnFZOHY2jXs9Tgr2yed9QL2+zyNPEyuOq/MQTj1+tddo750qGaMu4MSnAbJBx1HrVG+ggt9Q1IJKUWTR25J4Yqx/SrvhmZJPDWnyKAG+zKGUdCa1UbRRnUqcw8aZLcRvOJG80nfGjDHzA9D9eQfrTdDhQvcMke21mVZoNwzwSQy4/2SCK2kcGMBky2cAE4/KudtBPa+Nbmwdh9lkVrmNeucj5hnsN3OPc1KpxTuhKpJpo0dRtwtuscUCMrSxLwOOXGasOgViQnc5z2/8ArVm3stzJ4lsLBZwkX7y5kCjltgwoP4mtQg7CrMWYDORxmsqlOMnoNTlbUQrgqwjXkYxSsz+YrnYmRgE896aoEiYy9QWSytbok6qsiOyuvuD3/CkqNkNT6lkBTNjzC3GMgYBpGiG0DoAeSOcmpZOR9wAqeCO1KqbVO0ZPqRUThdOJSl1KckKEOccnoWFV2tzIpGSfXFaUm4sVYBj3xUEiNkpsPABBHQV5FTDXnZnVGs0tDHns0VThW4Pasya3zIehz0ro5vMPfdtPYd6zmtS84G0hm5AJxXBUjyz0Z6WHxL5feMZ7cbmUqvvikS22ARttG9xtNaqWgWRFaPPOGPWluIGiaGRo1RRKoC+mTWlOUromrWjK6Of0WF5dMBCjIeQDI4OGP60ydG2n75IzkVPorKdMwX2IJ5t3P+2a1p7+GO3DCNGI6ALnPtWtWbjVaXcKUmop2OPmd1x5TOXzjA7n0qrFLcJfyK0SoREpKKvXrzmrV+ZIkaVy3zZOAMbfaqPnb713L9IVPPc16EFeL0CUnzJ3NZnhZBFNESRyM9s+tZHiCMQ+H2R2yVmTcc9BzgVPbSEySu7E7VyUB5bmoNWu2fw9dsqqxM8HJHIOWwKMHTkq67CxdRPDvuZWnaJdJpQ1Zhi1mm8mNcgM/v7CrRsXt3kc8gdMNnAqjpeq3MlvbaduPkwBgoHRjnIz+tdJCr3do6RJIQ4LfKu7B/oM13YybhNW2OLBNcjuZsYLRrEgChjyfWpzIf3Sq6sUAOCvQZx+tQQPsgCOD5oyQPT1oEoa78tXwgYNnGCeO/tmudxfP6HZKLcOaOzIb8f6HYYIO6GTn/to1QQzGzgubgEbkiCJn+8T/hmp78xiz08KSSbc5z2y7Gs+8JXSFGM+Zcc/8BX/AOyr6yl7uHTPj6vvVWiS0Q6k7PcaqInHUSyEZ+lLqa6ZZwm3tW+13Lj/AFpJ2x/T1NZccXmuqgdfWpLuAfa5EXGEwABx9aylP3bW1NFD399B1vcs0SxnccHO4/yqa4kb+zbhABjg/TmoEjITI64yMGlDZhMP8T8E560cz5bMGlfmR1/wumEWqXibs7rQ49sMK9KsZWE06/aDEpkI+VAxb39q8u+G6+X4icMMhoJR+o/wr1GxhDz3Rzz5nQcdq+IzuDjim12R7mEknRfqXUZRJhby6I/2Y1FQ6lYfa4CXmneNBuAZsYb1471oRxHABTBA7mo5VKW8hY9uh968dOqtW9DVONzkPHEyy+EEDvnFzB0PbdW7kybUAyBjC9M8d6yPHW5fCzYQEfaIMEAEn5vSt3DRyRlnGQORt4HHrW1R3w0PV/oUlabt5FO+kjkYxumCuAHPJB7Y9u1cB4xz9vjO5WY45HfpXbX8iKjOWGAwHueelcP4xwLzJIyMH9BXq8PXWI+RxY53pr1Nzwoqf2fdNKvyifj64qS7TzdRjjZ1BkKocdsk0zwcxexuQRgibOce1STOkepwzv8ANtZWIz9a5cVdY6pY+jyv+BFLsXj4ZdXKi7k2scA78ZH1rV0KH7NpksOxtkd3IHbuQuKrHXrRk8t1dYME4ZMdT7mljv3ttOlkRjLZy3zb5BzgNjt3NY03UdlLuc+JVV0+WSN8/wCsMq4KsgwuM5FE1rkEAgEjcFHpQTGVVoX3ZAGVPai6fEa4YlsYOOeO9FZU23KSbPMTknZHmesiWHxO+ChKvuyeAQRUwulAB8tSe+Gzms7xGzt4iuSshLFgeegHGKtQyybF81o14HyhQDXVVpxdOL8j63D601cdeXDXCRfu3jAkUg7e+e1U5pcSruJBEnVhVu5lUxKY2jY71woPPWsq7cuRuP8Ay05/E1dGN4pJWNJNRu2ReKGH/CIHBzm+TB9eDXBp88oHUnIxXZ+KZdvhVI92c6gMD6If8a422OblOo5/Kvcy+PLS+Z8dmzTxMrHY+Fdx0lkEZZjMSGzjBxXV6LG9nrVk0sbxgSDDe5965zwUIrmLE04jCSMVQcZIxXYS/upYpUkLMJAQM9a8XMKvLiJQXU+ky5c2CjHumdlqG2bT7hYxgLGwxv3buOp965S0j82ORCiu2zPIzg1cl1QlWV1LOVZW29cmqWnSXKhhbOwOAHIHYdK467UkrsxwdGdKE1sZ+o2jxws2NqrgMGXGSSOK52+R7i3Em4g+aykDsOOK6HXr65NpM0kjsSRuVscnOK5mKf8A4l/PLeecKO3Fe1lEb02+h5WcuSlFPexv+A4rg6hdNDctCixoWVefM+YgZrf8ayTHwtOzySP+8jzGQOfmrG8ByLHNeCRkTKoADxuOa2/GkzL4XuwPlUPGSAOvzdaVRv63bzPPj/DNKEyqsLmYzKyAHnp8vSsXxHC32eBc4ZpO/OBz0rRt2jtoBNLIDtjUsc8HI7VT1udZhbMjrJulXBGDj2pKN53CKaZbs1aC48szyOvlbmY4x161dMquSQ55HHzDpVBJP9MGcgGNh79aviBVG5YhvA6jHFfP1JqLfMezNLQcsW5MM0mSORmpBaqpCbn+YdmxTozkNkc5xVjAKhwuGA4JPWsY1WtzGTZhNEItRuooy+wJGdrNnkg5/lXinjRs+MNVPbz8fkBXt03OrXS99sQP5GvC/FMnneKdVYHIN24z9DX0GU615PyRzYx/uYpm54R8tYJnbOTFgD15Ndt4aZ/7WO5hzEc8/SuK8Hxm6tpoFRWdIdwB453Zzmux8Nf8hZTgktE3ygfSujMF78n6HpYCS/s9x9Tvongk2ggEH8Kq6rJGLrSWC526go+U9tjcVeSMRhcuULdF2VU1KJkm0tWf/l/TjH+w9Y4bn5o3PGq2s7Hk/wAV5VfxZBEsgby7JBj+7kk4NejeDpl/4RXSSWBItAMdcEZ4ryPx8rx+N9RRyxYOuCTnjHAFeh+Fp2j8L6cMlAIPwJyeteriHCFO83oclKnOo1GG51N1snjjTzBhnxzxmsBlW2lkh8tGU8bh1x7VcguHkvIzJKSMlsMM8+tVrtVScSFWYHoB169K5qE6VWDlT1RrWpVKEuWe5U8RrDF4FvChy5kgztGARvrX0exzpUObgZEEb4Cj5QV6D1FYvibfF4Eu1A25ngPPfkmul0JkudM00rEqRmwhwFPXAIJrvXL7NWMG3bUiSDOoLESdh9sHHoa144CjYIAAHb0qi/yXyMRx0q/uJcY4HTOazmhXOR8eBfsxlVSNtsxJU8/e9PTkVN4LnaXwzp5YgttZSfoaXxnLGtrMTDvb7DKFC87MkfOfpVD4eTiTw5HGw5hldQwPBzzVVL+yRa3O1jmTft+bPQZrMukz4j0mcDDeZLG2McgxnH8qvRbtxH8X86qXXyajpmCP+Pg9ByfkasKbldCa7EDoy+LLQMuQ1lP83vuFaocBiDgnGM9qypSw8VWbqwy1tPwT9K1QcshXB9s96VVO+w7iyOQwCEFiMEg1GC63rAqNroJAcenyn8elOYeW67ugOaCNs8LNuBIYY7etOm3y2YdS06gISAeR39aYI5CozvQgdFP86dBvIffztxj8akx85GSPak3e7KWg1NvlDgjjPTqaTC4JGeRUqggYJPGaQAbW65x3rm9k3eRfMUnRAhyWEh6jHA5qjPbyNMHPK59e1bIXcBuU88UeTzyAB2J4FcdfBOq+aOhrCtyo8w8ZeKNQ0m+t7DT7g26hElkuEUF2c5wCfQCtjQdcufEelhp9k1za3aRzSgY8xRyDgevTj0rh/H+oW934muoWuXmWJFSJ48beOxHsc8iu0+G8NvB4ad7acSvNcbnUYJi4wASPzr1K+FhHDJNbWORVWqnMtR+i6abnRnPmIpW5mAAXP/LQ9azbhPJZ42VlK/wg4AHrXR6PEkdtcfZ1ZUF9PuldufvZ6e9ZeoQ+dcSSmJgB8m0kc4NeLieVVD2MJOTVnscpeyvtcl9wQHH1qP7JvcT7eAiq4QdPz4q1fWhjimK5LKpbYRnC+lV2vilm1q24BhghR06H8/euqnL3PcNqkJSGvb+RdFdvlquNztxgH09azNXTyNKnBnVlku4xwfvARls/XmrwvpLuKSWXb5hOQ2T696x9cdZtETBy73kjMzH/AKZrXbhE/aanDiW1TsQ6TZ3MANzJbSovOCy46kAH+ddFZXACzKF+V2AcZ/KtPW9fsdV8H2Dw3OLiQQh4uN6Oi7WJ7bcDNYiWUikybTtOTuzgtx2q8dGLaTM8HJ8rKs+wQRFMfeb5vTB61BaFI7mUyguAw78kHt/KtbSNOj1K3ElyWCDMaBPX/wDXVOHT7j+2ri3gIkkiIZieOB149fasY1YNuHVHe4yjBS6Mi1aNVtbE/abdG+xofLJYMwyxz0x3rHe8E0Mdu7AoshcbBypIAP8AKtDXkhxpvlyGTFjHy3Y5P8ulY8UZdirEBcEj619LTbdJJHzEklNtl6F7eLDs5IUg424qOMgs8pzlmPX3rptW0IWuoQgLtilsYJVUdCSgz+vNUDpL2uVZSUUgkk9vWolJXRClFXRVlSCKDhZJCijzGTG1Ce2e5qojQLcKD9oUghvuhuPzrQjgV7C9VScrISM+/SqCR5mG4cEEn3q+VvUmMlqjovA7xr4ujEbkoYpApK47Zr1XSbu3+13ikkBJgCSOSdteU+D9o8T2z5wwVx+leo6IE+1X6sTzcZJ/4CK+Pz1Wr38ke1gXeizaaeJ52O/g9umaiu7iJo5FBBO0ACpFSMzJtIbzAeAOQR61DeputC5TYCVAGMd/0rxq1OqoXk9DaDjzWOb8fSBvCkpBAIuIQB/wLtW8Z41DsrCRQnDd81y3xAiLeHBKq7f9IjO7P3MnGcVr2thJGQingoQSTgMcDtUcsVhINvq/0NZN87t5GJcXo8ySS6jcW8jeWj9lPqRXM+I/3khIbKYyp6njArrb+2V4IwQW3SBCp5+tcp4lQwT+UCpG35SvpXu5LKLr6dmcOL/hmt4LnAFzHM2yJmGX6DpV2+UDUIhEpPK43detZfhFQ9rc7iGRZBlT34rQv4tt3GqkbD0VCeuelceOjbGzPpcqcfYx16G8i2UZKSWnmygH5ljyob6+n1q/YWUV3a3KypEY2nZii9OQOKzLYyQ/KtiRg9HPP0rZ08okNwwBVvOYkZwB8orhT11ObFJxg7MLWLylaKOVVihO1Q+AR6ClE7QsSApIBOVGKjWKSOY3QEbRhfmTOSfekdwVaRUBwMqCcAmlON3e5xct9TzrxRIP7cnlyodsDgdB6EVmxzsqgEIx9ga2NfZpNXn8qJQ7cszjkf5/pWalrO2A05x/spivZpOKpx5tD6OhzcishkLu0i/ugELDJAwetSXsbhQEXOXwGPSpIrRo5Q5kkf5hhDV/XbRoIrMxs5ZicDtn2/rSc4uaSKqO3uvqcf4rkI0axiPG65kdgfZVFcxaNtu1J9z+ldV4ziWCx05NzM/mSFty45IWuQjYq2epFezg/wCGj5HMf94kdl4WAbTxMyqYllbOe/Suz860KR+RgPkfKAf61xfgw77S4RELMkgY/Qjmur+ztFcLmNlOQQG/nXkZjCLqttn0+UyvhYm/dJGIWkVGDlchuxFRaYSFlZZCnA/E1sXtvD/Zcw2Btq8OCCOnb/61c/bW+8bSJHXg/J2rxWrw1NKNSNWEvUoasJbi2lUcspHPr8wrnIyfJK/LxO4zjHQda6nUVt/IkCsXAA4JwetctFKroeqgO35Y/nX0eTa05JHg578cH5HTeBfINxqEc2HUopwRwa1/Folg8K3PzNJCFDIH5ZMN0z3Fc/4LmWC9uUk4VovTuD610fiTULSfw7qNsJ0M727KqHg56jilWhJYq/S6PNg1yWH2WjWcdvbXUqGRzEG+dyy5ZeeOn+FVdVgED2ShkHmXi4VDxjHGPSrmharYSaTZpNcIjrBHuRzjBAwRk8fSo/EzB5rB1ZSGulwVOeMcVzxc1VtLzLjqyxBn7fFuAOVI+nNbMaSEMBGevHIFZNq7C6Tjjaeo7ZrZjuI4YvLZyuD17Y+lebToU6sn7ToenXnJJWKpuCrSL5RJH3uehpRduV4i7d2/pVaRTPOSjDDHkg849anitVjk2fMAR94nk1wThGLaFutSiXzq9xnGSkRz+deB6tIZdYvpCc77lzx/vGvcrljHqlyy5dREmRnHTNeDTtvu5f8Aakb9TX0mUQs5S8kcmNfuRR1XhAbpZVDlSLYnI7813GgCWLW4QQMlGBb04/lXEeCyVv5gnJNowAz0+Yc13Wm/J4gtuQuQ/wAo6V1Y+ne78jpwFZrDSh01O3huAHCybtw6H1qPVHV5dOKEn/Tk3Dv91qkMhbAfy+nDZ5P/ANeq18pB07YcEXsfHTPytXJQc1OKexxTStc8W8fHf441IqowrKMDsNoru/DjqvhHTju3DZke3vXD+PkWLxtfiN8pKVbcM4+6M12vhCF7rwxYRxgbkUkt9Ca9LF0nVouEVqzLCVI060ZSehs2kg+2I2M54IP4itg2cdzCMhWYH7oPIrNt7ZmnYOAgQ8n/AD61fW3wQYXkV+3eufKsPVp02pq2p0ZrVpzqJxfQ5fx5A1j4RliaQfPdxA4PoGOKv+C7sP4b07a3zJEYyenRjWL8TbyddKtrGVBuknEhcDj5Rj+tTfD6cHw8o6+XK4x9ea9RwbjY8xPQ7OYNK+7I4PerLSqUUgAN3qmkluy7ZHkUk/KFTNKs8Kth3fb3wtKVNtCMjXZ1Mt1llT/iVTHOM8ZrK+GnzeFxngGd8EfhU3itoHtrvynyyWbMm4bdw7jrVb4bNjw6/ZPtDMARjggcip5E0kaXaO5hkaB24Xn86z72Rjqdg20DM+SVPT5TUxlijl5GMnjmqt24Oo2JRgf3rHb64U1p7NpEJ6kdwrnxNZMn3RDKD2IzitnaQFC4Jxk1z95Kq69prSNguHX0zx0rcWCMssruwxz96q5V2FckZVBAJ5HPNNidpJoASMbmJHc/KaeGQyKQpZehweaSbbDe2pwfmkYAnt8hqJQW403csowVvlGOKkJO7qQcdAKhH3g52c8U85WQHGcjrWPs9TS4rOMA7utKG2k4wfXNHluz/MQAP0pxVVyG2jHQ+tZcqTsO5BLcJboZppFjjBwWJ4HOM15H8QtbM3iW4aG7ea2jiRYkSUhUJHPA6GvSfEUDHw5qL8sEiMmcgAFTmvBLmV7mUEnLS88124KmtZswxEnoiO1tTf3HlE4bYSufWtfwhf6npviGJbK5aFpJBHKvVGQckMKqIog1SBlHy7gOP1q/oca2/iSB3Xdh3ZsnrXXVpJxsznVS17dj1nQyslhemaI+b/aM2DjA5wc4/Glvba3aRgcck9+ATUPh+Znt9SBlcKl6SpbHdEOPrzUN3emLevygHklhya+IzFfvnFLqe7gruKaM7VLRf7PupYg2PIbcw9hXGXsTtLuKsVGFzjpwD+ddrPe+Zpl1btsWX7PIdu7grtOKqavFFDpSjyUjuTGjJsIOQV5yaMNOVOPzPRU7aNHJrEEihhILB2HmFRjHpzWTr8UiaOm5AFW5dfl5Gdq1tmZIoDGGJkdxgk9PrWfr0TL4WBwcfbmwfX5AK9fCN+01ODGtcit3KGnWksqQ3cYUwQqI5C3OXI6fqK6CV2W1KxQtKMcZfvjBx7Vl6D5n9g3AWQrm7jYIR8rfKa2YnjeFS0nlMjHDFCT/APqqsc0pIywmsWZ9jBN9nikWd1V8/Kj9APU1a0e5+z6xK5k25iK+ZjJwetVdMxJCqmbbGWZSo7deagiaZL1pEPz5U/L2GcVk488nFndNqNJWH6jZLcJaSfJFFHaqGdjgE5PI/wAKz0fTonWNZXnZhg+WmaXxFGf+JciEkNb5CkHn5yBmm6ZZmDaWIDswBP4jivp6FR+zUUvmfLVkk3Jv5HRaj4sh1JoRHpM4mtrZLfmQDhehxjrSSOssTSSLsfAOCc49qryxgSZ+UlpSfrzVu4EkSB0wqkjBeMESH2JrkcrsyUk3sZ0csEV5cpMSiSDPPHPeqjXNqglKOJAMFcD73P6VBc7pnMoKlSTwP4aoyKWAAGD/ADrfncVZDUE3c6/wjNbSa3bCKN1uFDkgjhxjrXpOmMsdzfZHHnAkn3UV5Z4OhP8AwkVpPnAIdR9Npr1NHhihe4kQZYqXwep6CvkOIJv2y0u2l+Z7mXpeyaN2N0dDkkfPwVIBHFQXL5tSd2RlcDPXms0axYQRIXimCuBjMY5/Wnf27o0fEu+ME5+e3fH5gV5lWWIlBw9kzZKPNpJFPxe2fCN4RFv+aFQMc/6wc10i+UqbWUbupHXmuC8b+ItLm8Om1sr2OSSS7hBEWQwRTlic9q0YNc02Pc0Wpnbj5CZTz+lZ/UK1XDRSVmm/0G60YzdzQk09mu1V12RoThgfX0rz7xYnl36rjA2YH0ziuwXXopAzDUIeOo+U7v61yHieZLu8Ro5FkypBI7f59q9fJMNWp4m81pY48ZUjKn7pb8EjC3mAGxMuQfpWxqU+3U4SwUuBnCDrz0rP8AtbIl+91IsUXm85xn7tQa1qb3GoI6gwhiQgIwcDv7DNaY3Dc+JlI9zKpe5G60sd1bXsVyvllIlI4y555/z2qxZGNGukkYFRNyvTJ2ivN7eK/vbgrHcSBwBxuJJz3yO1X7ex1S2WSMXERc8kybmyffivPWAl0ZdejFaN2ud0iwK7CPAHs/SoLgKrFYGAR+GUt0+lce1jrcClybXkYP7okgfXtVW403Xw21ZMMxzlIzg/StPqlRrVowhQinpIbqgEevSM+PuDoevFJvVVDBVOe5IqSOy1ONHDWyytn5t8O8n/AAqLfNaARvZ2IdjkB7fnB/GtXS0SuezRquMFFK4y5nBhco4DBQQFIzVGS5uLhwjSszK2FyeM1LqWo+dFHCILNQrbibeHa30+lVIbkfbY2Eex1mGBnit6dLlhdopzcpaopeOYZotP01rgFZDJJlc5HRec1xS969D+J06zR6eyqysZZGKlunA7V56hwc4r1ME+aimfKZi74iR2Hw/lWK+nU5+ZOPqK9Ck2TA5O7IyDXm/g90S5VflMzScL3A9f0r0YRHYCFK5PA9q8PO4KNaM+6PfyKalh2n0ZCiuj7X3bd2ANxx+VMg1+O0WS3NtKCcqWVuDWhcQO8iyocMOCAOK5W+A+2zRsDu8xulefh4xrtqR6/JGehqT6vYXNmYBFMkvO0kAg/wCea48lgY0cADzPmH1xzV5ZFWQZJDDOD6cVnQTW8p2sT5h7k8EfTtivpspoxpxkony/EEFCULeZ1HhGJv7WZEVWUxOrKa6LxLZ2sGhXQKFpPIJ8wfwegFYngYBtbVOQRE27H8/euo8WFY/C+oFUUbYsMccnkc1jin/taXoeRS/hspeGo/tXhiwUhHIhwUZAQ2Cai1q0gsoLLyFSM/alYop47/l9ParPgwoPC9lI8mF2tjsT8x6UzxIbdNNt3zGP9JViSeR15PqKw5n7ZxXdm8FexYs7lPOUMTvXJ/WrvmrvLMmCTnk1zdjqWnwXxd7yARhWBbf1Pbj3q3ca/pIk3NeROxGOG4H0rkjhJ3eh6lSLutDegKedkLtX73B61eYNLBv8kBScgiuT/wCEl02OIeVcwvtUbhuJ5/KrMfiuIo2y4tQmPu+af0rGeFnZ3iQ6U29EQ6pKYr65YKSRGoGOi/Ka8ILkXBccfPkV7Hq+oI8dzLFIjBkOCCOQBjOPqa8axufBHU16+V03CLv5HNmCtGCOv8GPs1t1wdzQPzjr3rpvEN5cWGpWV5ZSNAVQmN+/WuS8LTCPxDahmYB1dD9StdXq8QvpoAWUbVI4PAJrurJcybNctjzrlGp4110Ko+0RvgcbohVyDxVquo39rb3LwlDcRyYSMKdw461mxeGLuQAoEdM4yHyB9auR+Hb+2uopjAzLC6uSikEcjnml7l7o6q0aCjJK1znPHk5Pi+7UqCVUJn146V1XgfUja+HLYBTsyy579a5PxvD5nim/dX37GyT04wOPrXReEoxP4atmdljG6T5WOOAauq3GN4ni4eEZTszrbbUh5xlWIsGG3njgVeTVUWfDR8nnG7FU9M0h9Qi82K4jTb2fPStSPw+xkCi6hOO4UkVpRqxcfeZnXglPY4H4nXEVzb6cY/kP7wsCfpVn4ZLHNpNyGZV2TZHrkjtUXxP002EdgJJUkEiysGUYxjAqz8MLL7Vot7IJhGFmCjI6/L1zVynGKv0MowcnZHanTi5JSRyc9AvaoXtPvfvAQoycnFEsH2WbyBKsjPwdjY2/WoGVoJQnmShv9o8CpVaJp7Cp0OB8bumLxkkwYniQKT95SpyR+NbvgqbzPCtmFVQFVkbHqCetYHjWaKG4vVuY/OmnjT7OyuSEPQmtb4e/L4ZfLHIuWRQe3AJ/nTnV5IqQoQvJxe51KkkH7lVojO+oQMI1ZF3lmx0OMCtG1tDczCPgZ7jk1DqugXzN5CTvsK7N0JwSvXHPSnGvKa8hzhGDtfU5bW9Ysm1jTXgmWV4Zf3iKd209K7yByQVlibCjI46GvKrrwtJ9qP2e4Q7yeGG0j64r0DSku7TTba1nvWup4k+8q7Rt7c1q22Y2Nc3AdSAv7wdBjFZOs340q2t7iS3eWaN2kSMHPmnaR+YzV4FHIMhO/jC7uTVDxfaw3uhxxI5gZpgY2YYYnGNorKTutyo6NG4pEttFIArBow/B6ZFShU2h9xwOAO9UNOjMFhawhnGyFU3v0P0PemakwRDzLuK4TAyGOaJSUY8zEld2RpCSNnPlqMHnJfNHLDflCv15qtpsSR2SzhJOWO7d2PfAqw3lK2flj35GTxzWFSPOlJFp2djG8VW15feGr+G04maAlQMZIByR+QNeI2cH2i5edlOyMfL27V9Gu8C7PkZ5EU8jqfxry3xro1tpJF7Cpja+aRpEQgruHJYd+a6cFLknyS6nPiVePMjz7eUuASc7XBrQs5Wj1azuJCGQbnYeuccVkBhLFKwyDuBx7Vb83zbe2lUEgNtfFehN6M5uVHqvh+7jntNVmZF2Ndhsk/d/dr/hWPqF6sl5KIWYAHgN+tV9PJm025EMxBlnQ+WBncNoH61DcWs1tdESvuKtkAtyPavj8ZTi8TJtn02XRtSTIXneZJsHYfKdfUHAOa2L17d9Mg8xGaPyYxtXGeR94eg96x5SkXnGPc6tC2AOxIPWoZ78yW8CxgbViRWXt05HvWbptpcvc656T1J5rW2V1jVMbzhAcZBrG8REL4Yt4jIWZ7+Qg+oCgZ/OrNzMBMvlEryOQentVLxJbeX4a0W/MhKTyzL5eMbCGruwMGp3bPPx0lypI1NMtFi+GEN3v2NPqrfN/squB+tZ9zftbQ+Sm8M65yDwM9a6bSSknwdtNnD2ssrHjkESA/yNcNcSJLc4DJh2GMZ+Uds5rrxFNSkmzlw0nZk1tI8IBAfZt+dj/nrUtuN95INxCKm7cc5OCMD9agXIQorfM2QUJ79sUJM9tqSK5UttGSnIPpn8cVkldnbN8tOxY1OMSX2ncl/9DVgWPP3mNPtUDSQr335pt4Ab6FlYNiziGR64/SprZSZo8dhXu0tKNz5fEazsWyhMka9wN3Ws7VZ7i11BjA5KTRh3jflM9OnbjvWooLXWOwUCszViW1QcfKsaiuaEbysTTk02NsTDOJ1KCB/L2g/8sxx69iT68U2+sFsnWJlZZQAW7g8dQa2fDtjLcWmrtGuEFpntnG7tWX5slrDJCHYxMdxjYbhn+ldEY3uipPVM0PDqraXsNzHEZHUMSoPPPAxWtqniyOzmSHzIfMSUfuwuSOuc/gTWRaWVzcW8ptzsbKqBE+CDjPU1yt5Z3Udy8bIztuY+ZtI3YOM81zYnC0pNVZRuzqw1WWsVLQ7288WedEcTQSxnnCRkMAMDOD3HHp61g3d7CqP9m1O+VnJGJVYIPX5ue9U4LKKOSR2lt51KAA7igAOM+4PBFXLLSLsQuEuyFYcf6RuQL6n6VlyRWyOhPuY9zrN5PAYpkWQK4csEGQR6sOteqeHdft9Z0yPz4VjulIV49g+Yeo9q8paC3gu3iuZ5o9rkHKbj9RWz4Z1a0sNcikR5HDv5R808BDx09feuXE0VOHoUtz1c2FndB4mt7dnX7w8n5gOvoK4XxNaRWOoLHbKUhZQ4TORknmvQo51UyOWkRy/OBj/Irh/GQVtRR1BG5Oc9evpXHl7ccQia2sGUvDyjyLkAkgT9PwrQaJZru081BIruQwJ9Rn8ayvDtwlvcTs+SyuHAA+9xWrGzNNYswI/fAHI5zg1OY05RrTmvP8j6fK6qeFjD+tzfsoba13GKFV56AYziuggheWFrmSWRBJgBAwGR6n3Nc9wSzD8Kk0rUIrTzlMsXnM/y+achV9hXlZZXk5SjN3Rpj8O3HngtTf06Cym+1xzxb5Y5ipLEtngH+tWbiws/JOLcLtBYN2zj0NYWm+JII9S1JJ2jSF3VvMC5G4LggH8BVy48T6XDazNHeRmQoVEezO4kHjHb617cXFxPInRrKdrMr6Xqb3NoZBbgMOGbciDI9B1/SsnX7aLVNZsYGd4zJC6tjrxyBzW54ddF8O2qGAN8pJJPJOTxjFY/iy4A8RaCwAUguqqBtIycYNY1ItwujooTtiHFLuZL+F7aOJibq4RACWOxcjAzmuajhSW7hEUrMrsCC64Iwe+K7zUGUWdwrEk+S/PT+E15/AwiMRi5IGeT7Vy0akpRd2ezRvK7ZV+IcgZtP+Vl/wBafm+orix2HrXR+MLs3klkx5Ox+uc9e9c4vOM9BXs4SLjRSZ8xmDviZWNvw2WXW4Hj5YE4H4V6AniGRDhoFYdMg9K870fEOqQMzFOwb612P2TH3rlUHQfLXJmNGnNxc0evkLbjOK8jZfxMkagLau7H/ppjBrKv76K7uN5tRGxHJWQnP1qNbBFY5uWJPGQtNNqo4MmR1ye9edSoUKbvFH0CpyWo+1EQUqSwmLYVWxjH1rkS7LIcqRtYg7eDXRrmKeNgCCDneD0qu3hvVZ2aZIIhbvJkM0oXqep9K9vLnGMpJ+R8zn6clB+pP4YubhtUHlCdjsOPLGW+hrW1u4uG0edpXlIdOFL5zz3qPQfDV3Y3gkvJLf7O6soEcu4sc+1bviLQ0tvDt5cm5kLpAWVHHUbgOadfEUY4jke54EKc+S62MXQ2U6NbEZDFW3en3j0qbU4ITpshWVZOOg4YHPvU/h6ymk8O2k6PMI2DoxU/ICGP9KXVILmx0ye6tr3zZFxtUpnv70niKLk4J67GtOnUjNSa0Wpy7WRVjG4JPVQBgiiK1th8u0k/Wus0IalrNzK1zfAnhgRApJbvn6cVunwo9xukbVYixxlVgHOO/WsHNKThc95YymknJHnsUCR8pD8jY4A3Zq7HFC2R5UYPcFT/ACNdvH4SdnMSakrYGNotgM++M1XHhp4BhvOukz80aSLGPr7YqHUjbcv69S6HGTqo0+7kaNgq5UMo4JxnA/nXnC8uo969t8UW/wBl8OSxwWxt7UP5g+bdhipH4/X3rxIKWAC5yOePSunCtO7TPJx1Z1pKVrG1o0gj1Oyf+IS4OPSu0gt1mkRXbAZtgYnIrh9ClX+3bDdgj7THuDdCN1e5x6HaCYn7KAFLdAGKc9x3+opYqfLbzNsuxCpKV0M0d57C3+zwfZ2MbbX3oyHP0I6+9WNb1ebTdMurho4doTn5mYZPGORwDSyRSLKv2YMmR87q+3P+NYHjO6uToMttHC0quQCUIBPT169K5qU3KSSZNZJtyaPMfGFzJL4nvlZdqrNt2+mAK7LwhC03hy3kRmGJHDYXPeuG8U7l8U6gjqQfO5BHOcCvQPBF5bW/hqBZzIg8x+UiLAjPqOlbZjKcKN4b3MsAk6u3Q6Gya4jDFJZACepG3PvWil1dQTKssigyIzI0s5Xpyag8+31G6jtNNEzzSEEBomUADqcn2p2pFdBsJL25sbm5liLJHh9yZIIxx0GK4cFGrVV56HZi504LbU4Tx/ei8ns4vNSRo4nDFHLFST0Pofaj4f3scTXNmzOJHKtGirncR/h1rj72G5e5klZJlDktmVW6mpNJvprDUbe6l+dLWVZAAdoYZ5B7nivalBcnKeVCbjU5j2d4VByr/P0IEXIpnkxsjOHYFRnkAE/StJkjTV0eFMw3ChsJLgoDyMg84xiqF1e2Vjoc+oiJzKN/lYBZi2cD5fT3rjUW3yno/WIqNzh/Ftm1x5ktrAsv7vazq+NnttPf8j9an+G8ka2N7BKzGVHWQKRxg8E1yF9eT3tybm4jeOd+XO1l3N3OBxW14K1CW3163IDPEwaJkVMHkZ3ZI5ArunH91yp9DzVNurzdz1KGFgJDArFl5+U8in6gl9NhnldkYAgbwdp9K0dHFveWcsiiRRu+cSrt+mPbmmvZtGjiJ2ZDyqkAoD9R2rkhRaXNc0q4hOVrHnesQSx3ziJtrMcu4XAX3AFdPpMIMULG8W4wnzOCfmzWbqjbtQS31AfZ0b5VdG7sevuOK6ew0i7sbV4wIimMq8Y7Yx3q6fO2ROyWpKkMEbAB0LHgf/rpnjC0S40KLhMRzKB5mSFyMFqv20OYwzQMCFClm7morm8s7uzubG7mjikVNhV22/8AAhnrV94syV73G6eVXS7WMyrMqJgOONwqrrNkZIYpkLFEPzbWwcUulTwx6bGI5ImZc5HUHpz7dql1K5jS2DxfZznGUZsEe4NZ1/eotGkLxqXG6aji3MTP+6D7lYnke1SSq73EYYqYgwJC87qr2M9vJA3lEBwwBbkqB7VJK/MbssaHd99Qe3pU02/q6Y5L94zeJTYJGUL8wGCO2a8A8V3yMzeZO0hkmnZSegXdjA9uK9tkvz1UMwC5WTb0OPTvXzt43uGOtSQYRfL4KrwBkk4x25JNehh6qcnJdEctSDsosx4dQ8idx5IkjIxg8EitXSd7RToEyoG/Hdf/ANVYtrbbk85z8u4Ads1s6W0sN+OdoaThj0PtW8OZ/EZ1EktDrrfWbW20QtblRf7t5jQcSEnHHtj34rMm1uQuzPbAAZJ2tk/j60630qSezkktLcukbdB/EMnt3xTp9ElVsTKlsD2kmHHH6V5NSlQc3zbndTxNWEUoaIrQ38U0DPA7byjFg2OB/WmCSR0ToSEUZVcVZg0FrmPdBPbiHOQGmTd+VZ96LjT52gmG9dwYN1IHrx/KslTg9IHWsU5Wcy4R5LwLwztyR2GOlYXiGedzBbtKWt49xjQ/w7j8351tK0M0bSrMrALyR2/wqtqsEd5aX0uwiSGGFol6ZBOCferwyanZk4pqUE13Kel3twLSbT0mkSF3MroDwcDA/nzUQiZpd7YwqDc2cc07wzcQ23iOykuWK27SGOU452txUl3Mm+SCFMJGzFR364HPfArprX0McNbmaZJZXX2K9S6KoXUbosjIyOM4NR2oje9DTk4U5LDryRTI4fl2zA/KpOM8n6e9Os8NcF1YsuBuPoOKxitdDqr3UNUaerRmHUgqfLi1g7DvGDRaX628apJbLK4ydynBOe5p2s4GruA24eRAM/8AbJap42t1BGK9enTjOhFM+erTaqMsx6lIsjP5Sc5Jyf5U+d49QupJ13KhQcHqMcYqg4ywC8A+9WLdtjYOSrDawB7U5UlH3omaZ3vga3WKy1kPllNgCB7kk1xlyFEmCBygP4V6D4KZP7O1QhCxFgm4n2LVwd2RI0r8AiHCj9ajCybnIqsvdibOgNHa6HqN7JEJYoMOVYZBIXgfma4C78QX11KWuWjkIJwjpkKD2FdzBIYfhxqoMiqZJ9vuVAXgfjXnHlCZiS6oc4+apxFR3UV0OnD0klzPdl63lsZIBNOksUmSrMg3ofwJ4/8Ar1q6DJAt7EqXNmBnczSt5ZC+nPy5/WsE+UtgqjJl83J44AxgUy3ADybiCpHQ85rmcu50qNzS1FUl1C7eOcSJ57MAv3SPb0qkFRjgLjcMqV6gUO58lI1YD1xxn04pke5jjzOcYz0xmrtoI9t0Sa4uNItGYQMTChYkk5OMVzvixpDdRmQqwwQGHoD0qfTry5tbWKGO1kfairhe/HWq2rpe6rKhNjLFsXaFCdRXn4fDVKeJ55KyM51FKFkcxbXPlX+0E7DtzxweeldgWbzLNwBskulCkkZJwawE0XUYLlWEDcKSPMXH5/0q9Dc3V1cR2puIVKEEDOzDDpyf6UZnKM5cq6L8z3Mni1T53tc6KedEyu1+Mg4Ncpeylbh3iY53Hjv+FdCugX8mdpUgH5iJMj8xTR4RunAZYGkBbbtEo/rXh4OlGnKy1Z9BUr04rdHPRS3UgyMxELkAt1qwNzMjiZWYKBuB5/Stq68PTWCmWW3Yo7CNV+0DJOOc+gqvZ6UtwzhLZtij5t03Cnjrge9d/LKUuW2pisZQjHmbJbTxHqNrarawzw+VGMKpUE4qjqms3V7eafd3BQm3f5di475/HmrqaKEk2mJs5/gOfyOKoaqLbT7mCGVLp5XG5VQBtoz0PvWnsqu1jneIwSfMtzSm12S4t5EaJcSIyhiPUHv2rDhstm1g0fy8Hjgini5iaRSbDVFUHkmAYA9a0zYW50oX8F7bSW7MF8ortlGTjle3PasXhqlNbaG1PHYVu0Xuee+LwE1G3iEokCwAjtjLE1jQxl0B6Bj1ra8YxrDrKhWJBtkbkYIz7dvpWKtwYUQAZxyM+lethv4UT5jGvmrza7ltdyXSYIIUKefwxXocOm3l3IBHEP3mGB3AD/PauF0d47nxFpYkQLHJcRqynpjdj+Ve8waPEdxEEburFcmPOOvY8CufGx5kkjryzFSw/M11OITw5qfn7Das2c/8tB/Opm8K6miFjbrxjKvMBj36816Rpuixw2u8lMJnamwFQO/+e1TwappLP5iyQDK454J+ma544dWTk7HbUzis7qGp5nN4auFQ5NqAV/56HGK5bVdWudNvpLCGQNGqgZjwFOeSOlet6jbWTiSQamRIwLbNwYewHoK8Z8Ty/wDFQ3IK/KNvIHbFaUPdquK2OHGV516ac/yOt8J3q3C3Lz3E8kaRiNw6qqpn0xzWj4svIY/DN1+/dmkRYV/ebsgngc/SsPwKUIuT5cSA7QX80Zb8Cf6VseOGnHhqMw+Q0SzqGxwRjJFcs4ueOV+5zLSjoL4K1O7i0AokcTWkczJtI79cfrWx4mlg1TQJo8GGXCjGNpBBzgmsX4fmC40K5icMpkuWKsB8pO0d+mOK0vEUVyNMmW5CLHxynPf9frXJiocmMcoq2p04d80VGRT8NrZaezgTsu/kSbupx0z2rora7C20sqI1yVQlWdtxOO3auf0IIbqNVjQ5BC7gMD0/GuogSJrsb4n45VRg/N9PShSlKTbep14mnCDSSKOg65/bAlXULaJOQUdVHY9D6V0c1lBPHtTMY6gjnHv6VzXh6MLPqCGEyDzDuyCNvJx2rejMczhXRkGcnGRk0nO7aaucmJio1Pc0OL8d3kdpo1xbbS7SkkMDgEDGT+H9a8RgYxyA4wT7V6/45tZbqLVpncQRWUYVR1LHGcc9jn615ChO6PORxnmvYy7+G9dTlxKs16D7F/L1CBz2mQ8f7wr6I8xo7qRI3CqzlcnI68185QECcE9nBz+NfQ8jkySYdSeGw6+38qzzO/LFrua4LWTRqSNEsYjmIYHjJAx+XauG8fRpBpUMkdwdzyiN4ydqYx19j9K7VJNyF2EYJGQ2whT/AIVxPiy/g1HV10q48oLCBIcHqSQSD7AZ+tGDpSlUT7DxMlCDR5j4hbPiG8kZxIDLjKHIPA6Gu98Iyxr4btUVjyXyPxrzi8uFub64lRVEbvkBfTPFeheCr1LnQxbNBue1kCthM/Kx4JrTNIOVH0ZplNRQr69Udpod59i1SC4Icqm4Eg5wCPTvXVu9nr1nPCrSxfNkkAxsD9e1clpVrbyXyiRP3eDjAxz2z7V0U11Y2MckhumjYrsKs+z6cZriy6bhTatpc3zRRlWv1sedeIbOa11FbZ7QRRAFopiZHMq+uBkdfpRoB086giPpcci71BmuIM7WJx1J6Ve8Q6t5bxJEgmiKhT+8LKPy7+wrP0rWrZr2KFLawe5dxhGDnbz1yRwa9FNPVHm27ndSsz3V3I0luxSQBTEcnjjnioUuIpZHCW05AVonOcKCfSpl2hL6GAh5orkfJsO0kfTtz9ajhDxrMkiwJIZCSkQJUE/XmuHEc0U6nmdEEnocd4suntYYFt9zSsCCBy2BxnHc1V8JzXUesEyPMtuY90hMe1iemMfTNT+KDu1D7OfLEkihLdwgV956Akc7c5qn4ciX7dErXSwQ8rI4YiQnOMLnrzx+NdkKjVFJ9jn5V7S56tpa3cl1eSWrDy0mQPDMmCw2A/eHtjFOS8dJZUaGYKCxdAABH6geuP1q3oPyNfoGDZnQcNkgBBwfeoNRQLq0p3opG3Yo4J9qqU3CipRI5VKo00cjrk9rKsc2Gbau1N43EqT0Hoa6G1mzapseVF8sAxkkYOOfrWL4gDmy8yBSZFYkADrTvDt/9riWC8cJMf4QfuD69+n4Zrj9tJy5nodEqa5NDpYoiLfKsrH0Z+TWRq8T293E8s0cYki+cugPAPTPet2MW2wEyRoPQsKw/Ejx3LWZhZJMMwaMEMQMDnAPPTpXTiqS9g5X1OehL96lYn8PKvk3AmePywBtEfQ571Y1fctjFbQwqTK2GJUcKBnpVCwmjt72KSScx28iYWIpsII9ewOR0q5rk21LeRXCtuYA4PzccEVMKr+pNx3LlD/aNdjNhklVlEU0kZx8x2jJ9OK0t7+WqSESybgq5GDj3rItmF1MsiXEOGGGUdeD6dq0NzCYt528gggt/SubCVJOOrLqpXLgZmOyZMsAcEcZ/wABXnXivwJplzBcPpyeRfx5m8pZDIk3GSAOoPB5r0KQv5pEkSoitklh2NZrhTKW25VZv9Zj2I6+mOK0r4meHUZLqyY04zuj59j2ixljwdyMHXjoK1tKSNrlYp5FAdSULLlcnp+dQ3UCw6pdwgLtzKFIOQQCcVmRyu5RRwFzjntX0kXZJnmSjzXR1tnGZ7iS2dmgjDYbbKNqnGTx6GrMWlabdbjNdFUBwSpDs30J6ijw3dSpZyQy2rSJuEoyMlu2P61rXH2i+xFHZOjZ4JQZHsOleJXlJ1Wlou52U4pQu9Tl5tOtf7QFrb3ERj7TONqk++On4Vbj8NyJcII9R075+3m7tv1q1a+GftGAZplySu0pls+hGeKWfwy1rG8qMHRfvAQkM3PIGR171Mq0dlOz9A5JfymPcaNdafJJJFLbSSMcK0Lfe/A1qaLBLqOh65cXUZTy4hGMJjc+CcH8ulZNwoSX/Rjhh03Lgn2HpXc+E4Z5fAV3IjKvnS3DMF5YsEwBz6DPNdNG97vUly0seRW8rRXEMn+0rfQ5q7JcYneR8qwY4I568/jVAllcELkjsPrWhPa7SAFJcDc2DkNn0raUOYqFRwd0PtLgeYsjAsFbdjHBPOK0dKYpqcxmdYy8BViIwSQf4QPf+lYOSrbfmC45HTn1q1YzCOcTlyxXHGcH3z7Zx+dRCCU7mtWq507M09XuZDqk0ogLJtQFlHBIRRx+VUmvMru8tgMcDFdGyiY3KRvtRZiWDNgk+386pFprdHZZlJUEguccexr1KMX7JO/Q8mrKLqNW6mUbghiWhY45IxyKtWczyyHEZBx3BIxVKXWpmdmEmQ55ZTnP6VNB4huIiQs8qe4Gc/UGpck9Lleze9jZtPFl7p8DW9uzRK8flOMAh19OQfX9azxqcRVgY4lzwBlsipLfX90flyy7h1w8YwPxANSxajbyZkktoCvIB8tT+fIP6VMYxWqZXk0XLMy3fhLUy0eIoXygJ+Zmx+XQVxsiHAcYxuyVPGK7qO4Wz0fVrQ2i27umduOgwD+fNcR84XONxOAF6frXPVi1I6KTuie+niurOMw2MVrjg+W5O85+9gkn2qlGrRtlipGcfez364rcs9RitdH8iWzhEzSl45HYfjuHWqsWt3zb44orXdIzfL5AJYnk1i1Y1i32KsvmGQT+YJRg5wACv4CoIVBlDHGBgkE8UvmPudSNrFjvHTn0p1uyl+U3bTlMevpWmhGp6bFbQPuP2uf5VDsyEANkDpzzin/2bIh863vnBHJMtyUXb/j+ddFaWsd3bJL5rRo0KZCN1JHOc/yrjPE5nh8q32rsLFVYZw+Op9Mc9K8nDY2Vat7K5tVoRjG6RpPNLb3CK2qWkxkdQbcTGVmB98Yqy9iJNubeM57NwK5PREMmowSLb/v4d2cLhW4/LNdik17GodoU3dic8n2rz84UlWXK9kfR5IrYdt9WVP7MEDFoXkhcHOIpCuDW9ompyWkJt7q1ur+PrLNFGHbnpu/oazj9qYEskZc/Ngg4z7966HwhI0ZvkuI4gpjQ4R8knnGM49elRllSpKuouRrm0af1Vyt2GXmq2ut20doltL9phbPkyQeUGXGAef6VREk1pITaIIDtw6vFlSw9B9O9dB4h8vZa4LRKQV4G0575PpXN3V3cQReUsabcHDbmHQe6mnjZ1I4p8u5wYKEZUEmtDYsJb77BE8mmW7+b8ymMiP5T3xT5rS1GsWdzLbSW+2CVDuk5bOCSODjHPfnNa+joZ9CsFeMZWFcMiE8Y6VS1qSWwvrCQWxuFcvGBDGS78ZA9AffPSvYalGKfMeZzKVTlSKURhjDyTyhlHK7nVMDsSVJNc/efZWv7prdVV2b5thBByB0NdpDfQXVtNNGJoBEB5iumD7gZ64rmr+ysGvZMQNzGJvnOwSZ/u46fTg1hj7vD380deWyUK7uujPIfHTBtfYbNpW1i4/CuX6rk9hXSeOpEfxPMEJwkcSYz0wo4rnyCEUA5LY4rtwv8GPojhxTvWk13ZatpPJvrU7iPLaM5HB6g19I3kUGmxu0iSSktlVebkk9+tfNUjbrmVx2Bx7Yr6D+0HWLqAC43lo0I5xj5QfxrDHVVSgmlq9i8JDnlq9FuXbDWbmzhmWe3AjIOwI+dmR/KooDZfZsSSkSAdScZ/pR9hi8q4VJA77So3YOfbtWF9nIjWM7omI5BbHP16V4tarUkoqfQ9ajQoz5nF2NK5Nq4Z3kiJHBJcZPoK8o8Rb28R3RgwwyMEkdMfWvQpre4CczM2P8AaDAivP8AW4AdZkiMsgLMMlgBXZl6Sm3c58dT5aaSdzqPA+lywwXsl7Gojk2FFTBO7PXPatDxt4XuLx7G800ljJDMJYSxKAR85HoSOPypng+0tYtKeNZ1jDyjzHkLFwuQSBjpnHWvR7e3tWjQ5yoiaJR7MMsf5V1YZqeLk30POq+7SRwvw3A/4RZ55GGxrp0dMnaRgY9ga2/FOnMmgTzDdHGFDDDZBOe9Yfwi8q90DUtPkG6OK7yeexH/ANaug8VRXtnp9xFuk+wkBF2jJIzzuPb+VZY6i+fnSLwrfOkmcaLG4yHjV5s4+4ucHHT2rSj03UPtHlqlyjBQxDNtwT71paE0SWzKrbgHDsrjluMZB74rXme3JOCOcAnd1ryKtVw6HsVa0lLlsc9p4l+0tAlwyOoJdfMyGI9x1rXSC65DTsGxx87fnnFZVnKYNScIu6UluRjDHP8ATitiKLcWkaQnaMHc3BJ4wfWtKcYz3M8TJxktjhvHMLxeH9VM+Xk86IZLHByBz/SvKj/rUJOcjt2r1r4jExeHpwYzGWeEEj2J/wAK8kQkzJuz0Ne5l2lN+p5eMlzTT8iFWwxYDo39a+iL2b5UMLAiSNW378AcD6188YxHn1Jr3Kw33mi6VcmNSHsUG4HqcYP8qWYT5KdysAlKrZmzDc3jwEbVAf5d6gkfrXCeO9Au7rVzfWVuZcw7bjbwwK8ZA+mK7WHUtQRQnlRsi/Llsio0uzcatCbhRu52qg6tnnJrmwmJ/epc17nTi6L5G7JWPAxG7S+WFAweBkD9a9D+H1je29xeoGtmilUCVRKGZcdGGO3Ncpr9lHaeI9TtEjCiO4ZYwc9+RXa/DZLZNZuI4XMEq2uHd2Jyc8kYHFenXaVN6Hm0/jR3+lrCl7twkEqqrfvVOc45A9vpWn4g0yO5gS4l2uI8kGP5sD2FY2nvDHriBV37HJLZDcnpn610d9ZSC0lit2a2jjIlZVb5kwc/KR0+lcmGcZ09I2N8TdVNX2PO9fs4bJIY5WmtkIMsKxFU+b3461U0aLR59Rg33F+twzgZYpz7E9cVreOI7aee1bzeFTcDKRgE9x6n24rndDsLaHxFZgG5eRnGyVl2qD6nrkfjRGVoha6TZ6ZZQiS8mtd0oMz/AHgQD9Rx+ZqHV0l0nULWGG3e9e4LK0m5QwYDvx/9ao9Pmjs7iSUsHI1JIzIcAupH6EGtLX5LabVbCKUn/lozdsfLgZq5cs6d5Ij3oz0OB1/ToryWW9+1rHchMqsiEncPTHTFM0uC2guUKzwztKQAUjLKwzzkkZ61Pd2s2oXiyiON4NrBg7YVSRx05zmmaat3bSuIljjiWPBkXhVPbb65rllUSja2xtCF3e531jcyWMJEELEzvvZ5FbjAx2GT0qpNcPPcNdCAOWUMy7TgEcfLnnPtWjpF2kNpBayyBbhxtjZ+A5HYe9S3kEdtdxyMDiRee/zZ/rXUrTpqz0MX7s2mtTk9evfs4hm+yBnfcAq5DL09O9TWlrJe2MVwkdv94gB1Zm44OTnGKtaxbCeNMQATx3GSrDgHHBzWjpxWO1S3lVV3bg2OASOp/rXNSadaVN+pU3ampIz59Flivw0k8X2QDICQgkN+NUb2F47lFtZFMchPmEwop/4CVANdPbq0M8pY+bCFXYeu0+1ZOutGRAY1eHJIWTHLdyAa1xcLUHyomhLmqK5Bbac+q3K28l7Io27wGjUk4/n9at3fh+SKCWX7aTFECQDGD3z07VFo90tuYZCVZUJR2PLn3J/pW493Z3EcrpcLsKnBU5znissFCnVoOMtysTKcKmmxyMSxwX6FLxJQQeBHjd6kUzVbi8juUe0DN+75RSABz39atttF1Cv2TZtO3cGHTufqai1KCGaSMvEQVUgFWyV+vFZwvBW8y5O+pct7q4ni4RWbZkHc3y/nVPW7p7Pw7dXn7xCkZICtkBjx/X9aZaC0hY/aXkTZgn58KTUfiOe1vfDuoQQuyvJD8gU5PBH+c12KNOry87uznleN+VaHis7RxbjtfzA/BJ6qf5c0ySzFneGF2AxsbJ7qcE/pVywsptUv0s0zI0ok2Mw64qO9ck28rPvmaDBOOmCR/SvdtdM4b6noW+ONAyqjRFhjBwqjHH1qtqGoTxOHgWNQFAYCTce9TeXBPZRoZYsNCpxGcADHfIrAMcbHjPJIyx5r5inGLbuelJu2hoWV1DPqdu97NIYnBD4fAVu3b+VXtcc2JhNjcXCZVg26QuSB6DtWS+lSWluLh7eVlJDKwG0Y9c9qv+ILqb/R2c27AqThRkrkZwTSlFOvGSemt10G5NUpJ7nPy+Zcp995MyBcYwV47nsO2elep+BdIey8M2cU6FDJcPJslxnYT/8AWryl2hW5jJGxSVJ2nk89BXvWs3g0zwxqF5FF88NiXRjz/DwP1FejS0ehzfZuz5j1JlbVL9oB+7M0hTA4C7jit6O2gksklZyHKqeDyfoKwbaRLe1ulmUFplVAfT5gc/pWzcg+UZ4rZpIGHBI4B74IrsjSdRWTsZTny9LiPpcUoJVmXbknDBiB71QS0eJ3kjG6HgMSMH1HH4U8zqQRgrxwAcc0q3oZPnD5BHB7/XvUSpTi7qVxwn3RtTlbi8umkkhhbzyFQYDE/n0qlrEmkwxS2/nSXN2rYVos7cY/iz7/AMq1RBYvZmeX7M91LKdhlfaR7n0H41YudN0vz4gLO3lO0GV4X3gsVx8uT0BweRXVByVNJGEkudt3PPRbAoZRIFXPTmtC2M1mFktbtdzDO0oT+YIxW6bOMz5kKxxFvmym0Jxxge9XVu9HtLYpItnnsyLuf8exqYwS1KlPsiha383Lzx2JyckqADn3XpWrb28OpzhhLp+ScHK7WH4VkyXcV1MwtYFEbEHdIoyPfpWhLJZbXdbYR9SGY7skV0wvy36GM3rZbl+HRYZtP1G6llw8ayRwrGflG0c/WvPnJjUOGOMc8dD7V6jossH/AAibxGRHkeORgQenB4ryt2+QqC204796461r3R00b6pk0dojAyzThCqbgmQSxPSkhkeK7imRgrhsg9Np9aSQSpax+e0bxsxIQkFh/UUxcmfcgy2cheo//VXNLdHVBXTFuCDO7EuWY5JYUkRYPhRnOMEfWlmkaZgXVUKjaAoxSR8devQf41onoQ9D1+FPJgU6deeXGFUNFKc5OOSAa57xfdyLFbCe7bzi2VRoxhQO4x/Sup0a1862iBlG9VUb9oORj37VzvxDtJYdItXZItouSodVwSSDyfyr5/DX+sp+Z11bcljO0NEW5Mo1SOYsG/drlXz689q6tSdmZbwkADCjJAA6frXnfhtSdctzvy2SpVu/FegxQvJF5YUnJ+TA5x3rLNo/vtX0PdyeUXh7dmW2lmN4ZhdIOAue2Poas6Zpceq3rq95JH5Me4GOTYGAP8XrzQ2l3EVwI2MexoSyMXBzg9PrU9uNP0uTfcKGjkhCQhULZOepHYiubA2VeN9CsfUjKg1DVhPbyaeTHJLOySAlvOcsUGewIGDVeRLWCIASSMshwuZAcHFWdT1q0uWiK205NsCZHaPaGyOOvWq0s11JE26xKpjcdzAcfSqxsf37cXoY4Nv2S5kXtItY5LGFoIYp5SD5pE0qg88EY4/AUX8JimtEiLxlpCshE0hyNvbJ+WrugCf+x7RrWZPLDHaqgjjJyOKj8R/bStgl0ImIuT5T87gSOjcDPFdk0/Y3OFNe3t5sn/s37TaCaF5zHt5UXJ546Diue1mwxqMKw3FwUeBWJM28jr09q6RmlW1Dm4+ViHZ1Hyg9OFX+Vcvq0sP27bBMyiONVYcDkc4PJx1zWcqklRdm+hvhY81ZfM8c8TAr4lv1Z9zJMVLZznHFZ5kBeIgfdHQVseKlshrV40L3P2gzHzBIi7c98HOevtVPTbG2uiu/U7a1c8nz1YAD6gY//VXvUNacfRHi1tKkvUgiBEshPOQR+OK9h0iRn06zkRGBNvGwKrzkqK83i0yxRZXfXLVpI1LqkSMS5HYH171614WF3H4Z0u8jhMyG2XawGMkEgg+3H615+cRapJ+Z15ZVUKj80WbTUJVVgWkGeDxgim3NwMKu2aQnDDanJx2FaMF1cluUkJ7LKcgfjWUJDF5hd3M3nPtUt0O49MdBXiUqUZqUm9j1XU9/lSSbMma7vZFbZp13IME5b5R+FcfrFtLJfNJdQLBNL0VmwDjj9K9MisPtTyLHcpEued7nr6LXnniWW6/tWaCSBcwsUBUEjPrmvXwkWtlZHDip8ys2dN4FNuNPvI8rG8bKG2MWDH6n6fpXoX22HT9Nv5t0UjRQPJgffXC9x+R/GuC8CtcT2jebLBuZgEOAF6d8d65P4n6hd2/ju9iR8IsUcZWMsqupRTz6104NWr1JM4MQrwijf+C1w32zVLbcMyW6TAf7QbB/Q16N4ueeTQLhQEVAyqcnHGeTXhHg3xR/wjuppLBp7PM6NE7KxPykjnB4yK9p8Q3cGseGmmt0juF8pJUJXa4OcnrkAgEV0103B2DC2VWLfdFLR38q2i3xByS21APur61elaKeInyyrKRwByOenSsbT3lOmRbFZGUMGAIAI9R/hUUk83PmSyqC+4Kp5AHFfJ4iF3Znu/V3UqSkghBGp/uwysXYAsOK04Z7gO0WGQAZbK9PSudktZVugxmumRgG3b8Ng/Sr8emvkSvPORnacyE8e/FLn5dVI6KlFSs2cx8SbiYaOkU2d5ukUnGAQFz+HWvMIyXkJ6seBXoPxJCW1jZQrKWLXDsdzbjwAP61x+n2EbiGZLlDMXJESryMdck8e9fS5b/ATPnsdb2zXYz5U2KgznHWvafAo+2+EdNI+URxvGW3dcMcDFeMXII2Z9WGfXmvTPAjq3htGk8wRRzuCNxAP+NXj4p0tUZ4VtT0djv0imkwkqzbl43lQF/MfyrmPE8E9nbveW9xJbvCQ0bFeSe569hXRW8FrcIBGLqPacHc5AJ/EmsvxPp+dMkUmTmJipLZwVGcHtXl0ZU4VY2Vnc7aspODi2eea5DNq2otqcgCNPGsjF/lxgY989O1dD4IMVu7zfIs8kTBi5+UKvcjrk8YziuX1JjcW1j86eUIMbiOGbPOfU1o+GmgGoGJFaSPbuZo06nnr7elerOV6TucsYr2iSPRtHuZH86SBI3eG43OqA7iMccn6121tqdreyywosqzFMSRvGRtJHIz0Nc5bR2yTpIsUgLr96UVt6fMq6ejhG++d3p7VxYCrebhFaGmLS+JnJa7oUWpXtratKY4kj2jauSwz7+9ZUelx6DqllHGzsJmI3zsrbMD6f5zXX35jOs20rOYXVDsKgktzjGPxrO1aZbjWbO4nt5Z1ikBaOOMsehAYgelVNtNq/UiGtrmvoUNudOlaVSSbqMsCB8w8wZyP1rT1rS4opm1IKWmjBVeeMH1Hfms3SHH9k3k7HciqZmb1x8xrpdTxLYyv/DsJB9sZrujGLgtDlbakzzVDaO0wLLG7q7BsdwQelQ2d0jyujvbsjoRtQ5OM8ED0qzZy2z6wBLOE3RklF5zjH5ZzWPBq2LwLFARFNJt37sNnOOfUYrz6kWlzM66avdJHVz28lxpNlA5IJlTAZcEHPX6109xbJdFIGZhtGSVbDA+ua5sNHHLZgys8vnqpUHIGO9dGreVIkkpwHIGT65rswSTptnLiJPmSMnVCY1liK4ClWVzyccA8d8VDqUFwtrBHBMqplt7AcnpyP8ACk8RwzZnkQgFoSoOeF561PMnmafHISCihNq+mUHOe+SDXn4ySgq06ekkkdNLXkUtmw0i5WK1a2nmZ2Vt26T72PTj0qPVVlms4/IQ+Wr5MgIYLjviq+kvGupTFJlOUGVkBJPryOAPrUl6WaObyRmNzgruwOvWqpV+fBp1OqCVK1b3SoLTztP+0+eA0jEEDCg47HHesS32sZHEDu4YguH27D2GK3LdVOluzld3mkqij9TVSzVJpLmKSFVw4Ybe59TXFWqKlTUoaHXFczalqUkNws0JkJYMcY7D3yOtU/FKSTQ2xjd1Ic8Jkk/L3rXu4nF9DsjY5Qg4471heJijwWZjlfeZDhGGefaopVZVJRl3BxiixoEcbWpZ3Vo5AFwrfe/H1/KofFUyQeCtRazuW80BUJL8hd3T3p9pE4tVAk+xq3MhaEYZj6H/AAqDxEGTwxqVo9oC32dsPuBxgg8fzrswrTrLrqc1daNnNfDy0a51+SRmxDZWjvkn1OP6ms7xVp40rWtQtom3xxlTDu/hVxu/TNa3wwlVtWv4pSdr2al1zjIDDNc/4h8Qw+ItWvL0232YSRKqoDxheB+OK+npyfM77HlyWuh28g+zWYlE1q7lUXayg4G32Nc7dS25Zg7IoYkZjXBX3HautYlFMkf2hoCiCRlwy7tvGMjgdq4fVg5nbeJWTgq+zCk9xnp614dJXk0dr2R6Ba6hdN4cUlraRUtyVzASHReuMnIP4VzWs2z20cZkLxk/wsgwB2IHf8a6yx1PTtcs7UQS+Um0Kse4K2ccgDqenasHxPcRWuuSxsSGEYJMjksST1H+AryMDVarSp8nK9Wd2JjF0kzmrVJHuY3iaFnQnKlTlRj72MV6VDLPe/CC7F1Ozyi2mhDEbcgE7QAe38686ingOqWlxJ86K6xsDjLLnOP6V2Xirxlpkdlb2Onc284eGXERURjBIKhhjPsOOM19Dh5SlI82VuXQ8kul228KtjcY+cdN1af9pxQwGMRyZwAQoxwPWsy9ERkZLdw6g/KMY47VagCJbgPMd2O2Sp/GvRpu0tDnqRTWpCZJZ+Ut+pzwK6C21HS00gW8uiFbkDBlAyGb1z1rKhliKM5IBUZwf8atPPZJBCGmJDDLoUxj61opKOtzJx5tLG1dwad/ZMcjafJcXAjxgZQDvy3rk9BXJCMHCjMTKT/F19K6PWtRP9nxW4K+e6biI1w+M9CevTFc3tSU5DFW3BSpbsa5qbukdElZtmkYrx4VieWUxsPmVn3A/p0rI2RK/wByTqQ3XH4HsK3o7YMj+W7/ACjjD4/GstXvVu8xlS0fGDtPH0PWuisrJGFKV7mhpklhDKA8zRRZzmQBtv0xWtcRW13FttJ4nDoWXzHCDeOo5PHHQmsnz7+SMIZYjGSSyCBMk984/wAake8voJQoaznIXCjyF4GOh9acJTcLdCZqPPe+psL/AGWNOW2M9tDO0JLsIycMBwMZx+IFcE1vOy/NHwOOOfzx0rpJxOdThjSK3V7mKMOCo2ncAf4uB+FaDaJNHKbRJbUCVcyBowQF45B5554zXM4Pa50qaavY5O10HUbrY0Nm7I5IDEYGQM/yoi0y7kvRAIJN56g/KOnTPTtXo6tdWqLZQx2yE5LzSgBto6YwfzxWZqmqfYZFNvDaT/NtKFgwA6BcZ49azcJaM2hONmjiLi1e2l2jZgjOA4JHsajVC8iglVB7kjFdqL6V5BFJpVr5mMsSke1R6jnn6VS1afTpHaBYdObgBZYU2s3vwTjBzT0sTZ3N+01qK3Ej6aLgRpErAMPv4OD9DVXxXdvqelQBbkOyS79jLgdMfn7Vq2Ud4gWCJYXHlpu2g4PHBFYnjqO9j0yAuiLaecTuUfebHevEpwft04qx2Tty66mVounSW2prcO67o2yIwMlsfyr1i61WwurOKO1t5N/lBVYIAAw757HOa8n8MmY2lzI8hYbxhM4zx616Pp+hNNpUdxFf27ZXzNgY5B9Kzx1Vxm299j0sNRoqjGcm0Nu2UyLJcJEeeWIP58ir+mW7WWoQPK1v9nlG5EV+XyCOnbrUN1aXdtYySTQbohtxtdiWz1wOM4qXSI7O2vbWRAZsuMF2O76YPQcVy4JJVYt9zbFyUqMuV9DX1mys7O7tEMflK8ZPJxvK9ieneqd3LYLp8yQKhkb5o8kbs8cZz9a2PEatJpMUgjE22YDYRknIxx+lcs9utvYTGaDyJVT5dwwc+oJrozCChWb7nBhJc0Fd7G14We1TSUkeV0kBcFI5sYOf7tQ+KFmbToJBN5gM/IYjfGMH6E1X8P2Fhf2P2i8ijaYSFN+8LwBxxV/UrDTbWwmkt0gS4AARvNDFTnsO9a6vD9NhOSjieu5l6T5y2cokeaRv+WS8ttPfgEe3WsbxHrukaXukkti90uPNEK9x13ZHFbxubyyuYA3z2s77MnKgt245OOPeuW+IPhCa4S51aCR2ChTLGzBWIPGRgfP+JrHA0I1o81R3Rpiq86dS8NGec6kdP1C+luYL3Mkzl2E6FcfRhxVVNJmY/ulaQk8eWwkH6c/pSNpd5GWV7C4OPRf8KhEE0cmUjniIPVcjH6Zr346KyPIldu7LK2nkPh5MknB2RsuP++gK6nQb6fSIolt755RNIPOjkD+XGg9cgY+ormlv71FCl5ZFXtM+R+oq7FNdamwtzA0fmsFDRhQoJPGeBx+NKpFTi1LYcG4yTR6/a6vazyCES2xbaD94gH6E9amco9xJcCxHklzmUNnJwOVHtz9c1R0jSH0yHyJdKe7kSNYUXcpDkZyeM44x14rY09JXWW01LTJbC5C5VWOYn68KR+v1rylgYU4SnTldM7/rDlJKS1J9KNsksjOkfzp8oK4yM9s15L4oto4/E95GMrCZzyOQM45r02/he9jziWFlTG6MgeWAOwx0ryzVTDNcuoucLnkbMEn17ZrXDSajydia0bycn1Op8HRR2Vq+XdjI+A2MAgYx9PrVn4t6Za32m6ZdxW/+l/Z52eYDkpEgOD+J61J4ZvbC4tILWyfdIgEZ3KflOffjtXV+J7JZNY0izkwY5bXUIMHvmD/61PAucpzlNW1MsWopRUex4d4AsLfVvF1hp10u6CferckZ+UkdK93XSbbSPD1zDbQLHbJHIxUE/M3XGeuK8E8A3Js/G+jTBgP9JVSGPXdlf619D64scWlXiGQoywONmc4B/wAa7amib8jnpazS80eeS6w3ljybLYqrtUM+Cvr0FMbUZXj+eyUH+8suTmpAipIq+XvBGGHQCkSFtxITC57V8hOrGTvY+8hRhFbFZdXJKI1q4UEc+ZkYrfuIf7O0e81O7tlFtBh3LblbtwMeucVQs4I0v7ZnhEsazqzIDgtz0zU3xRv9WbRIbaLTr+GyMwkuLkgHaB0XcOcc554ruweFpYjV6WPIzXESoNRgt+p5z4z1Gy1w2EunTRhIon3xzSbWVi3Tnrxjua5yCzuYlYxzWoyDn/So+nf+Krgt9Ne8dbhrqLPO5l3k+9TCz0kzlE1F/JC53NEQS3pgV9JTpRpxUYbI+YnUc5c0tyl/Z88+3c9qFzgEXcf49WrofDernRUKNBbtKJAUdiGKtnPXpjgfrWK0MVqxVBBL3DocgD3FOhjjmlDJJhgQcbcEf41c6cZqzJjNxldHuGg6rb3VzLZMAZIyXkbJ7jJUH2PHbtWf4h1PTZFltWEpk8tlVcHAY+/r0rS8DeHYrew/ti5LJc30YVoZeNgzknnnJPNYPiywjtr64ENyyqHLIW5XPpwSa8upRhTlGy0PRpNVL8zOI1hYjplriZHlG5V+UBcDHWn6M84nt3t4QVziRYWbj3PtSapCp0ix3MsaGaUbwueWKngdcVsaFaPEkUdsHljRwWcghcE46e9XzpUnfXcTX73TyPQIbsSNFGpjLMuBvGCfb0zjNdHETCkUEx2MSWCBTj865G0sLbUL57aKOSMSMWVScYOMZGK7COOW1sooLiYSOjALIRgn/wCvWOApRV5Jbk4uWyMm9kiOrR5mih2pg+Z94D27VW1J7O4vUaW5s0Cja2JGA9fz5rW12BJJLF2g8wLKR5YUZYbemaw9et2lv9M8hdi/OSWQKRgZ29MVU4cs3oRTd0uhYsNQsoLe6tormGRZo5EZNxwAR+P+e1bdtq0Z8M26TyoJltgjBTn5gNv61i6Jp9m6yW5tkJ552FyV9ucD8qn0mBbnUNUsLywt444drwuhUlkzxuwTzn/9VdkebQwly6tGFYRCz1BpjJCN6fMBg7uOD7e+ay4NFMF7v+12xiVvNf5iCD7Z4BP5Vp+Io1PiG0tbWKNY1t8MqqOST1PrisoJNFqUuUgxEShk6+Z7Y/nXFXUVJwaudFJu14u1zp5DsiiktyrhW3jYQScdhUUPiO5a6+y6lCqQoyv5hk2bRj+6fvc9atpHFb2xHkLI0KAgrnv049qy/wCyvNBkeJZZU+/JKxGec4+lOeIhhIJdX0FGk68m3sjY1eJbopJb7pFWJtwUg8HpV0LHJoEe5SGMcZx3wBg4qlY7Ggmjk27ywVEz8o/Ksq/sbVC8sgmErE5CO5UewUdBWNSVKpByf/LxWKjGSkor7OpqaLdosmoqyeUjhNrEY3Y4AFULuyuhKkrRsmCythjyD2IFZ2i3tkupTRW6vJJ5OJBKSSQD0APTnvWlfNOy+U1lcBQpZcOp2nj1pSjGNCMNrFxlJVXJdR9nDPa2EqBGMpf5eQeOlQRXJtZJZJoxEXbgyP39MVDNPPbwlGsJ4Y8gbNwYk47Y9+1c688F1eqghkR0YFmG4n6EdMVx1IKdPl3sdEb3u+ps6jqRsr6K7ulZonXZGqjJDnviue1TU472NZrW3ZApYFi3PuNv/wCqrXiWSObS1n3+Y6SgFQduPb8aSS3k0fRbeS8Ahmj6SrhjlucHPDVGFjBU4yl8V7DqtqTj0K82tXVvb2oudOMcTrgSM2VI9sjiti58O3FzpUkqFw0tu4CJ8w+7wpOK5GTVPsjeSVEgOQs+QzZ+nQfh0rpdL8ZWum2aWV9HcgqFJZQMqMYzgda9inQdN8yiefUnzJRucj8OZseLI08sEvbOpHTJBHFcfdQyW1/d27phoXeMqeowcV13gWcJ41XGHT99hZOnPc/pWH4ueGbxhq8ts6NC077TENoJPXA+ua9hJtXOJO0mjqpZ7sWsLTXcpb92flG0Rgj0FZviQXUKvFJevJASNi7uCMZz+pro1i3WcKOPIxCgVH2tjjnJ9a5jxCJY4zvRJDnAnHcAHAAHFeHQletY7ZL3DP0m7vI3iAlYJuEY2r9xSeTxyfzqx4v0i+0fUAZxNIs5LQ3LNkOo6gemM9K6XwH4etNTtBPdyuVbehiDFflyPmHqe1W/FVlBc+DJElulbUdMkC7ZWIwoOPlOOcgg/gaVTHQjilCHTR/Pb8S1Rk6N38jzfTrzyb2OWfdJEp/eRh9pZe4B7cV794m0S0Pg6K90u3iubdokO2bDP5RwflkP3cZ54yfWvngkLL82Dg5Jr6G8A3P9s/CySzmwzRxTW2O+3BwfyNevGydzjk9LHg+tWS6dqk8Gxxsk5BPQHnip7C+uEsntVMTQjJ2yRhiB/OtDxojL4lm83JMkUTE9fmMYB/UVFDp7L4Sg1BQscn2h1ZmHLLRKcYSSfV2CzlFtERmVWEcgjHPIC1JcQ/aEhYxiTBZQBx/kc1V86NSFEf7wctI3IPsK1ECtp8bEsqiZgT74rqkkcycrli4utMOnQfaLG3Zyvy+YzqSoODyB61l3cGmSygwBIYzyESbfj8TSasFe0sliuvtB8lj6lTvPHIHFZsUfADW+X9zilQfMloaVVZvU2lhDqu14XAG0bsE4qG0W5gnC289tB2Z96p+GKnt9hjUeVg54wQKyZbSOG+JnRmQyfMoFdGLjGMUznw0nKTTOgtJnll2zSo4MmCRgk5759KuzWlsGnSSPyyYSY2UZ6VjWCxtMsifIpkGUDcewrrSivFiFZGKKdq5zj2NPCO8GYY33aiZxeq7obyCRpd4SGL5QcbhjoKcttLc3DIIFmZMs4TJUAjg+p96l1WINqaRsVt/3SKVdSTuyMgY6Co/EMQsNZuEtTKoQKVRSV2ZUZBrirzSqW9T0sPG9O68iJre/Efl3tpKIkTEaqhQZ68Z7dzisiR0TI2k9eq46+9bP2q+n8gC4leY/LHDJccpkepPeqk8LKM3M5Lug8uNHyin/AGvSsW10No3M14SsmyRhtADZz602LaJlJXbEz4bae3eleKVmf7u9QSfmHP0psSSEj5SVz6j1qXsUtz0G0OhLbuI0lAT7u24Iyv59a4zUr3z3MW+UqpIO6QsOvYduK3LwRQ6U0EUBjRWX99jG/wCntWDKlqIGRY5DOx+WTIA6+lctBKN3e5rU10NnwyY/s8okWWRg+Rtzt6fzr0fQvD8N/YfaBD+/DY5fhce/0x+dedeFHKW1ypkChWGRnkmvWPB6zrGhW7jdC3KBcbfUV52NV6nLeybPbpScMApxauQajay2Vsy3KTROfuBm+Rz6Z6YptqLq3n0iSO8aVLpQQWUBVJxyCBnHXr6V6HJbWcp/0mN5ofLKmInKtkeleb2sEn/CTT6VdzSNa2EZa0iU7QmWBGSOTgHFTOgsIvaXulqcqxSxC5GtTt9QzfaLGuGEzvHjjkEnqCPx5rktWtjZTyFpd6Og3BzkhiSCn4AD862LAi1v7G0hdlWacGQFy3ygE5GenbpVTxTZw2mrsyLLKskPnMWbOCSfy6U8TVjisMsTDRbGGETp1/ZM57SxagySTsrOpAiTGe3PHer+ozWM+k/uYkgugwLtt+9z90ccVl2Ez20kpj8rLsCDIuSBVm5v5ru1eCeaErjJAycgHtzXGpJKzPVlQlKoqi2Nuzu45rrT15fMgIB7df0qXx/ZSJ4V1qJ3hMH2bzIlcneACPlHtnOPrzVLwuVXVlygKwxO+SeSTgZx24rqvGVsLrwveRsmWa1fHA3Djt/nmvSyyHs6N+7PIzD+Nyo+YEnuIsCKeZT2KOakS/1GIn/SLkc55q/Zi1bKtZ28mFypkDrkdzwamj/slI2860tiw5/dzyZxXpe2V7WOP2Tte5lyatqL7S1zIQp46ZH6Vq6NPrOrXkEEFxcOomQsrOAMbhWfLJYec3kxJ5ROVzIcj8a1vDP2Ia1CWhtQRIrCVpHyhzwRjqfarqP3G12IiveSZ7f+6Dl9oM28MP8AZwa1752aBZVh8yQHJTPLYHb3rnor+CO3m2qhkUkMzowz39K0fEU9yujRXNvGSsVxHJcCM5byu5X6cV4+V83sJxkjuxSTqRZn3NwGjmJxDGUJ2bcSH2IryHXtXu49WkAMR2n5CYVLD2J9a9T1Rlka4uIXZyyl9rAHAPTqK8z1uO3UzFrWVbg5KEgspI/DAq8O1z6q5rUptQ00Oi8K6lJGmn3d5tffMCFjjCY7YOB1713viGTHiPwmWY4lnuE5/wBqA1xXhi0M01lCYvMHkiVoycKTjj9eBXXeLZiPFPg6Nk2sLuRyPRRGQa7sIrx5u7Zx4xJVOVdEj570eQ22uWEirzDdRsPqHFfRmr6vZy2V35VzbsZMhsMDt5HI7n0r5305PM8QWyqoZHuUU55By9e2a34etbKIX0CMq/aBgLJgbgcHAPUYHI9q6Kqj7Nt9mc9K/tI27oyri4t0hd7RLq4K5Hyw7F/NqopqkjRu6WL4XI5lAOfpWrMTJkxqWkOWz/8ArrJSHcZhtx85zjnn1r5CDpuLfL+Z9zCE3o5fkW7HVI4bm3N7ZXUauwCnKyIzdgccgV35vrOXTRFNfRhZw8Txuh8sxkcgA8/nXn90FCRERZKlS/zdTnIro7ySdoVBiaMFyFQHrxXVRxvsKacIbnlY/BurUXNI8O1W1jtLqSBEldY5CiyupCMO2PTjHFZ+yPdgRqreiE8/nXofinU9PmL2LXggkizGUa08xl6cF85Y8celYtrfWFtF5cl8krFdozZDcPfJcc19FCbcUz52UbOxyqNsJUMue+W5rV0B5rPWbKeO2efyrmOQpsLKxBzg47Vsx6rYNLh53UquE8iBMk+p+YjNOXWIhIkj3WoExuHwFRQcHODitbqxnrc98sdMWyaae5la4nuD5mGBwhOOFHYCuR8e2EEa2uoJb7rkH53jPG339D7+9dhp95dahZWt9CFijuYhII2+YqDyORXD/EXUbuwvLeCKSJRJAznfHkNg96yqWUblwUm7I4W7NjHYLDNYOdQBd4WEpCKD0LL3P4j6V1Oi2LDyfsOmTLEq+ZI0sxCjnA2k9u/PNeft4kvHjjWQRZUjaFXGAPf1rt38R3c1tDC8cAaPDkjJ5689jWVRQslPY2p87d4HaaYj2+qiEDy5nQ7SPmB7/e9vStu+Ef2NZghkkVsqAcnI9PfGa4aLVjcaxYyhXSQSoXKyZjJOB+I/Ku/nMQt0lbq0vCqpyTz0qcJOLTUdrhioSi05dUZeos8/2MJPhXkI3FBlht7elUNRCRXMDsucg7XSL734/hV6/aKW909POjjRQ77c/dAGOaoaidklr5nl7XUkOuQG5PT0GKwrNKpK/kOn8MfmPsrZntZLr7Q8ZZNkSHjBHOTW6YhLc21xLK0eLZoWC/xDrn37/nXOadJHvZzduyrhEiUEDJ/vfXsa6VbeR5LfEioyMc5GcqR2/SvQg/dRzS3OU1Zox4iC7Y4l+yDBj43DP865O7vUtdZmjR0SNX5VuT9fau31GxP9tozhPLEGC5GWXB9AK5TUdPtU1aS4lALBtxAxmQEen+FcVaEnJyt1OmnKKsvI6zTyzwyQTAPOEb50B+YjpxntVUaiYVkWHG11HyFuj9+Kv+H5x9rQkcFCcYwQP8apXO+31mceRH5QkbKg/MQR646iuTMaSdKFR+hrhJrnlH5kdlI5nHEaqerFyT+Ax161HqYJO9pZJAu5sHuSeuPpTrVGjkBjlEYHRsZOM+9T6nJeKybyGPOSyYz0x0rllph1bubp/v8A5HPaX9msdTSZYHjXymDyMPvd/m7mttWN2N+/BPIGMlgfesZZBb3is8jQwFmG9Yd3U845962IsfantoP3aqFLJjaxB7mt3Byhd9jKWkyfW44rbTh+6kk2yAEQD5snuM965O1ZJNRUoJAoBUAHazN15GcCur193g0zHktMTMisoYqQMcnPtXIae0kd2PJeG5kYsY5YmJXHQA89ea4KCboSfqdUbXSMzxK0sccg3Rtg9uQhB9+c/pW54knurvQ7eaIxSITGxjbDBsr1rB16AeRIDcKHDMCNgAJwTk/jxVidnufBti722/y7cNlSGGQQDnt+ddcYX9jNdH+ZhN+9ON+hzw06W5jOzy1O4naxCj+fX2rUg03TIrYFpJYXfBfeQpBx+ozWAdfldQnlRlFOAGHB98VPBq11qAKLbgmIZLwKdyqO5NexOFVveyOJSgulyroMFxN4ijghUiZiyh1baDxzzWPeQvb3l1bzYEiSMvJzyD6963bZ7TTtdspZp5/KyrspXcy9yeevNUtentLnXr64ssm1luN0LMm3A69K9NawRx3947uys7pEghgWOYtGigSpuyQO3pWBrsGoG4QR2MqwTOQv7o43EY4UZIxzx+Nb9lcvbyw3U15H5anJkEuM5GMgYrK8Vl4YNP1WDUJfK3FVt45T8uM7XBB4J5/KvCoJe21O6fwnV6Db3lp4RsPMt2t7qyBykild6lsYPp+NXPFUMiWcl5CoRLqH7Nc7F3bQeknTt0P1qp4Rvm1LwzZz6he3UsxLiR2lJzhiO/tVu0kv7uS6EWpSJHayvFswr/L2I6ZzXz804YqdS/wt332b/wAz0Un7KN+p5fb+H7aadYVkNxkksquI22g89R6V6TFreneAfD6rI8twL2TES7syKhBBY/Q8VweuSXK67OtxKWeNWEXlp5asxI7jkjGOM1qeKfBbad4MtNYS7eeb5fNV/uqr/wB36E19hh+acVO+541VxUnEwPF9/Z3+rx3NlIJImt0+8CCrY6H3q5D9nbwRFBMEaXzi6jJBzuPI6VzrWiRRWz+Y37xyhG37pGOSfQ1oXdvaJBbtbyEzsm6Zjnh89ACPSrlR9q462s7ijUVNPz0GskJBYv1HO1un51et7yFNM+zOiNJ5nm+aHJI4xjH/ANasuK1kSMOXRlzwDgE/hWjp9rNNaSELGPmJyQA24Y+768fpXZUi+W7OaDTdkYusNMq2Tsy8w5G3jIDsP6VUgdnlXJIB4IBq/qtjLGtn1y8DNhxgjErClttNa1YG48sg4IO7gj61NCMm0aVZJXFRY1j3kktuCgA5A+tRxhfOWTcoG/kDOatM1ushWAxjd1Ay+33HAqpC+nFx5uoShCfmItSf/ZhWmKT0SM8P1bNK0lEd2pGyRd+5cknn6ZrZF3cybpUuo1PzEfLkfnWLpa2D3kUUeoN5jNhM2p4P51sS2g0fTrh3u1dFYq+1Mgk+hq8Mmou+xjinByS6lO4LnUy3mRS4WNnlj5GCcYAPcV2Wp3Fr4fSGRLazmjuFLuLizErofpkZH8q86a9t2n3wvt4OFZdpPPFdV4tu5nGmTSFkdIBtmRgRz1AZSfyrysY5e3i09NT1sJFexae+hcsvGVjjz54dJhkI+VI9P3Yx0B9K7bw5pll4n8PR6tcwWyyXLbQi2qbU2MRz6/jXkQsRq2g6hqgbE9hLHwAADGRj8wR+Oa9e+E9w0ng5oyR8lzL06bW5BquXqzKTtojzm88T6VHqM1tceHrMOkjRTPFZpjaCQSoPfvzWS/iDSWni+xaLayRIfLUTW6q0i+p2nrUPjm3Nn43vk6A3LMR9cH+tY1lCsl8ik4VTkmicYpFRbudxqOoWVxoBd4IIXADxrEpwT/dH8qqKt22m3M0BsngwJBuh3FMjlSSMj61W1m5j07SVtYnJ82QMVBGBweR6dak0xY5tHnaKaYPjbJFu4bj0rz5QUKd13Oi/NMk8PX1xqNxLE0dttiXgJbhSTnHJFdho2o3GnO3+i7lMvLM4UE9ABj6VxXhBYp7y53mSJVQcIwXPPc11ttbu93BbvIJIWlK4I+bBwev1rmrKLr8r8j1qSvgrHUweK7+aZpUs7cpFkMTcHKEdQUx1rE1PULn/AISdb+NIEuLm22tGSzIwDcHPTOBnit+TRdOhl+zQwxx/aeHYZySvJ5JyPTGa569Urr8wwgjjYRKFXAAGT/UVeKm1TalqmceEpxqVPd6Gz4Ylku9dS4u3SSYlVwikKow3A/KtDxgoGpIGBYtbBSAMk8nsKq+HZI/7cXIC4aMjH/Ax/Wr3iPUbyy1iWOPTluEVUdJNw3DPGPpUNc+W6f1qRO9PHu2v/DHIaLPDp9xM15aiYsoVBgHYc853flWlqmox3OmSQJpywsxDK/y8YPbbzmsxb2STUprmawkndjvCJjaD6n1/xpn9oB4njudPnUO4ZBuwA3oPwrzrNvY9PlUpqbTua/hgH7fe+RJGZPsq7Q/+9yPb/wCvXdanNONImljUo/2c7MqCytj8uPWvLNM1SxstREoi1G2lQZR0QMT6hhzkV6Gl/c/2S890gmRIi5cAorqF6hSe/p0r2MJpRSseVjo3rOR85PDqLzyyW/nyDBDzRAtvz1J21SuLi6kjMM0jbAckSDHPTvzWzeT6PdalJMhutPic5Cpg7eT7g1q2Ou22k26RvqL6rBu+WK5gDYHoQck/h0rpUnFJqOvp+pztK9rnCFQrFdynHcGtTw9AsuvWUTtIA0yhfKIyOf5UuoayL6+86GxtLXGQEjiAXGeOvU1o6RDrzPJJBbbUjIcyJEgcE9NtdE23DszONudHs09mtnBcslxvLfLhwDnoPTrx+ldLZOn2bbtUsx8sHAOOORXHaHFLLo9tPqP2iS5KclxwrMccn1AP6111gPKikVwfmfKrg5HNcGW05QhLmd9Toxju1Y4Ga5sIXdft7eZGWSTdjsTxtPauF124tZWeWKZJTkjbsIOPWu11/SLqLxBei0szIhkMm8IP4hnjPXnNefa0q4G4ndls5GCp7g8VlRpqNVq/U7ZSTo3S6HpPguZf7RspFKuhtFJb0xjg074wtKttpl7bSbSPOCyLz/D/APrrm/DEV0Ly3hihNyrQ/wCrjkKj65x278fjWx41ikHh+G0uyY3jui6dcbXjYEDP8IJxXVhajhaD8zjxtNObkvL8jyfw4PM8RaYpHyteQ57/AMQr6B8RwzNbXEu5CVb5VkHyhd2eM9D7+1eAeEyf+Ep0le/2uHOP94V9IarIkNhe3V/dNGpV1Qs2Qq9BxXbVjeLRxU5WkmefvJKJ3kVYSCNpUbm/UcVnmVvPIATG7LDBG01q2V0scSrGkroFz8kZOfes57yP+05kbzdrMDt8s7zxzx2r5OMHr7p9vCqk1diIz70kkU7VYlOu18V2N15v2OB5GLIwLbmA3A964w38MkhTLBOdvyHIrbbxVbC3SGWVZtgAOwHnjtxWdWnUklyxM8TrKLR5x4pupxr19bukf3ypkCDePcn1rKt9Wv7OExROgBGCzRIePqRmu91Oyb7MdWiKG1kk6suSWPcA8ke/6VkWuv29sHD21tdE5Y77fgH8QK+npztBWXRHydWm1NnNNrF3LAYZHTy+TtVFH64p9nqM4k8olmQnaY+AGzxzXXvc2LYln0iJN/OEgUqc/jUzWulSIs0ekypvOYVFoyh/owJFOVWy1RMIc0tD1bwZfPL4atreZUFxbKIpEQ5wo4B/KuY+J9neK9k1i4LmF48nlsZB4960ND0m1hEN5dpe21+hwqRuSVH0A5H4d6d4/cPpVtJLvKF9q8Ybd78fLx+dJSk6SckVNRVVqDueH6ikIht5BNK7SqxfzFClGBxj371su9s0iwrLOiKP9YzDJ4Gcim6hpdldgTtqEkVupKgm2yAxPAyDyfatBLSzlljnN2IzhVU+QewA4Hvj61nOSlFcpvRXLJ8xraSzwTwRBHkxOkgYr/AWGD7ivUNVt2yWtruS1vmXLKrZVlB43KePx6ivP7bTI4Vt2ivW+yh0O8QuM4IOOa7WXXrHLB4bj58uCYTnHsawwycFJyLx0o1HBQ6HO6TNd3+r7p5C0yQlixUAL8+DgUa+dSXVIFjuf9CaMnymUDaADnnucZxTNOlEWpySSJcTRPHtCRx8g5/i9Kl1yb7dc20jWV6mGPy7QAcen9R7VjzVN0O0PaK+1jT0W1a4tmvYpA235NhXBwOefft2rqlAmW3kHp29SK4rSNWuftEttDp8jxSbnYs4Qk+hPTmtWXXJLMRxGNIDGhIEkvyk+hI/pXsQkuRNHmyjLm1DxCyx29vcTOyJHcBWZe69MfnXL3kiS3huIpFUMcBDEGIGccd+1aepeIEu4oILmywGxIAjnk57cfzrP1W9ksJ0ZbVIIpBvkMgwcE9BiorpOF3siqWjsbGisDqdtJJI2TvxGU2lh24rL1m/uI9euQ81uB5pAzGSQMCp9BvI59chVZFKY5kIIx7YPT61Fr8/k63dEwvsWQ/Ki5YDA55rixC5qEV5nXh2o1nzdip5t7AzzCS0dAMjERO7vgfNxWjqxv3tEkeezkVV3hjCy4ye3NUJ47drX7UZbgQ8bfk2ZP0rR1WaddJRzHE4ATCxZ6E45zXPXU4UI8ttzSDU61+hzsOoNLO8E9vcjyidqrsKnOCSPX/69Wv+EgT7PLNNDfb4SRuEaAAHoWOc/hWZbRR3Ny0QSNwx3N+8wB+I/pWldw/ZNOazltGWVEGZ+olTPUnuRXdGm/ZOduhjJrn5E+pb1bUp9X0Uwtp13CpYOJiyEAe4zk1h6ZFPbX8vk20ieSu5+VQDPTIH0PSt5kEvhW8QkeYq5Oe+CDXLyXH+kCLDRFACQcAnHPWvBw0vaU5RUVu11PRcEnqw1bTb25tpZPskix8uNzrnuc9earabDDLocVnsmnZt/mIrAqRj5c9s+g9a0Lq8Gp2ptocyzgAKoXqO+T+lcu8t5pxXyWPlq3zQEMuG9K7cOpSp8slZpnPUglO61uZFxYEzEqTGp4jWYbT7A44zxVywtmtwjwXCC4PJAcAJ9TUMGs6jYa7KIJQXkOxo7gB43z0GDx3qeVv9M3RwRwpImyRbZxs9cLnv/KvXcm0k+pwOO9uhl6qXlvcOUbauA6KwVvzqkmchSQRkc+mK0bu5uobhds0gik5Qtgn0/GmrqV5DMBJKpYdAUU/0rthZRWpzO92dlHqcVhbBzNFdmRVUByNqgD6HFQa/etqGg3EK2kiSblfIUfJgfy+lZ91YO2lW9w8wkac4aJYgpBPIIx1FSX8VzaWReR2jikhAVR8xOOMEdR1rylRpe0U4u7udPNLl1N3wFcTXWlTQbbLybaQkCZCWJbnr2H4VeTUbePUb+Gd0tGWbYCgCluBxkdcf16VneArKAaTc3jg+fLK0WFYj5Rjiq9/pNt/bUz3byQQmcqNgLLnAJAPr+NcFT2NfE1aSureXXqd6U4UISkY2t3bHU51S7e5tdvyCRfu/T8c813N/Ibr4PTwTzB7hLZJCp6pgjgfhXJz2mm6hI041yKJlJJWVFYk5wAQKpPqslvpL6csxIkUxFYl3ByTyeeOeK9fByi48sXt5Hm14vmuzmpx84BIYbRz7etbk/wBnjtUCebKAOSvCjp09TVa5gsxpFrNEZWvzkSggFQB7dR/KrDXllNZxxrayRuoIZ+QS3eu2k9dDmq7FNUViJCZPYucHHqBWjpSrczojyGMNlup5A57d+KzFJO4FwTt44zitHS782Ecs7oGzE8QCr1B69R/kZrXEuXs3y7k0UvaK50dzqVpG8M8aW4dY8jzcFQ/dge4/Dv61l6rAbqWIfuzHs8xPJZed3UjPQZ7VjTXIt2jaSNXcxjb5i5De+OnFPnvEWRSPsxZY8Fdvyn2AxiuijyqKuRV5r6GaIrQ3sYElwUPc43E/h2qpbWc0s27yJmXk/IhOamtk867aSKMqMFuGxt+ldp4Hvrq/tZ7WV2K26YARgGwfr2rgxldUoc9tDopQlJ8q3OXsbO6tpRO1tcAdf9UwI9K2bm5t28O3Su0r3IAOwvgcn0xz+YrrtYunsdKBuNwUkRrM4Z+SMbSBXFXlp9qtpQbyGKKP5CTBJ7d9tTg8f7SlJmVXCy505LYwLe7VZDshUICHw3zE49CelekePbFdP0rQbm32j7RbrK4flcjDD5RgYGf51xEOlWDumdWgjAOWYW8hwRWhrV3cGygi89bi3VP3D4OGGecA8iues02j0MPFydka3h17eXw34kCxSiKSNWJByASM/lnOK9G+EoVPDrIhcmQSA59UbGfyIryXRrl4PD9+V/1byLHKvTcB0FetfDEgaVaouCPMvFLdz86/zq0rownpJo83+K1okPjO5m3NuZkI44OUJP6qK53w7YSatqZtIJ1ikljLAs2Acdq7P4wqYfFlqxXEb+WTn23D+tcV4dujZatayIQuHKlupC1NZyVNuO5dFJySZp6/4evtNSF50jaNmKL5R3H8aj0+0uLfSriSa0dophiM5weh5Fb3jC4WeCw3XMmDK27aRwMcEf41ji1ltdHLNPKWLAbM4C56/pXnU8ROpRjztXb8zrVFRm7E/gjc2pSR+QXEkYUL6816TJ4enszBcWkSyTqPN+ZmGw5PBH9a8z8P6rJpWtxxxW8byzSLGjvyRnAxnt/nmvTrzU9btEuZ3jti+zacZ59x61x46TjWUtr7Hfh3UlSVODVupqWt1ZzWoNzMPtLvuYbseUR1AB59BnpXOTWsst3KxJUs7MN3B5rFWDVTqAlW7LSyfKjQqM/kfqauL/bSTsEvrp5U4cFVJU/SjFVfapJSSsb4bDvDuTZ0WjIYrrdJIDIqBiw/2Wz/ACzW/wCKJzbzrOke7z7WSPcO2MH+RNcRbr4iRkllkSSN1KsJI1RufpXTPqjataQreafCy2xBWRZcfMBgjB6jtVUqtGGDlRqTR5+IpVHi/bRV1ocwu1bkoZ5bZFAUbB8znn9Kj1dQ6xnc8gU8EryOKlu9TMesSqloIo4mGd0o6EDgevrUV/dpMVj8toiDuJEgPHbH1rz/AGUuaMktPU9ug9U2ipHGtyytGs6s0YDiTo+BXpm61k8NK3mkzPZnEfQAbMc/SvPTdTxvuXTHYMoHEynsPyrp9P1SE+Hvs8lpIWEZRm2FyB0znvXqYFTjzKR5+ZfvEpLozyQHVwgCyaVfW6gBTc2qMwHpkjNRtqGuiCSG2tNJtdwwXtbZVkx3AbkitO9t0srzyxceYmcbZE8s9M5GRiqEmpWgcCCVfM3Y4OPxrqU53+G/yPOdOF9X+Jz0mk3JkbzAqeo5HH0xmr9l4ZuJissN7CgBB3Dfx9TitTUtY/s3UCpuLW6l+6Xs2yuNv9/qfem6Z4kleeOysbaOOFpN5SaZnUH1redSry3RlGEOY9b8O3c18iWEiqqwwAAopYOBxkdMfjWxe6bFcxxxStKJSNqyRzlHU465Fcn4WvG/4SKPfOojlR4dkakA8A557cYrttqSyGXbvC8kIMkkdv8A61TgdaWu5eOjyVbR2scIhvtPv9TgvLu4n8vayXGzLOOozgcY/lXnOvSm4lm3zb3LkhiAvJ5Neq6oXOtajJHJbsHVFYlmBQbeFwD1ry/V4t2ptGGTHmH5zz/+uuVNfWZHdFXoL5HWeCMHXrdRO8QWA7NoB7DP1rW+JV0rQWpeS2iWUShFnO0MdvY9ucde9c7YSS6Trlo0F3BOsTYaXGBtPBrZ+I93aX2i297ZItyLWU5i8xWjClcHIHzcnGB261rhEnURhmUWpc1t0jzDw3ZXdv4i0y5eB2iS7h3vEVcLhh3Br2XxTHqN/bGOwObRJW85LiMHzT6Y54HsRXiF3FHbTTItultwjL5cvmAH+Jc/r7V6Z9g1HTtKmBvLmGyDoybZWZWDKMKVxzyCc+/au3Fc0Y6HDhlGU1d2Et7W9t7g2880+QvCqu0L7ZPOKpyRiO7mdGcPwSW6mpYNQUNsMrFycMwt5DkeoAFVpr2IXgLM7xgZyLdxu56YIr5xwqyk9D7ClOlFLmktCywCQySD/W7MA54J966yxazOnQSeUBcqqr0ypFcMdWty5QpIA2QpEDD8624tRhMiJMGZAmQTbsML7jHFYVKVXltYMR7OpazJ9c07+0NBNxJqkkCxBpliRRjOcA7evt1rz2LTJLkPBB4hjjhDHEM0jBevGR0r0rUQk/gO4U2kaq8TOny/OPm657Ajt2rlfD/hyfWo5pJboWUiR74oY4QFKAfex3r6Gc40aabdkreZ8o7zqSW+5wgtL17p7eGfzZB1CscGu68EW+pDUbOxvryYRTymMRLNkAbc8dQOalh+HrytbTQ6xZpGp3iRYWJJ92/pW1YWU3h/xHpS3HlzpJeIRKF6jBBFcs8bSqyVKLT76G9GlyqUndNLQ7NdH1B4ob1b3zFt9wVGG0senX6fTNV/Hdx9o8IrdLCHVZYmKuMqT/XFdK4lllndysVs/wB1MdMd65zxGVn8MmKHYbYOBvc5jznJDeld8+WEGcdNuU0eL3YY6JdZUxot0GZc8HJP3SfTp+VN8OCVtQhT7O9ym75EW48plOQc5wcdMfjXZaZpNvq0bqsdmAjFdqHc20fxMM4A/U1r2/h3TrKeWV/KWP5fmgBXPuOSP1rmjVtF6HXUinLVnXWFlB9lQoMFlVtjHO3jp7/WqviC1lt9Nae0dY7rcqhigIUe3G4E/Wn6SL+G2insIkuraQ/LPPLt3KOB07fhS+I4tUXRrye5Nn9mGGMUQdmPIH3jjv7V01LKi2lrY5Ka/fKMn1Mjwq05vrldRMbr5YLRxg4B3devXmmeKtRnstWjsbGyEoaDzcs+1upHf2FReFprttYbMwVTHtcsPvAEcVo+IxENRjbzIml2COMtknrnBH41y4V+0oeZ04tRp4h9ih4du2vLmKWa2+zgcpETk8cE/Tmuhe0juY5pWiVpImJ2EAg8ZGM1heHXha+If7PG0R6xggNntXRxtA00jybj823HPFd9KLUeVnBUd3eJy7GVtSgklUg78Enkrnvt9qoeJ5Nb+3MGeP8As4qvlOy4AUnkH371oXW3ziTdr5iMDsPJ257nsaTXryd7MSmKGSCNvm3Z5HTIH41dSClSa7DhJxqJog06KVbmFXucSEhN4GCfQk1TuNW1CzvJoHjAwMvyWDgn/wCtVqyjZWikeTzVjbiM8KPbP0qO/njj1FbhtsartcRPLlevYVyVaUHSV0dFOcnUaJr8TXumoIojzgqpIXafQ1oap9ph0u3hFviULukUtkHA5ANZGug3mjXF9CgSENuA3EZB+laPijT7fT4LSa287c0RTy3mLAjaDxnvyauVCjLDrmi7kupJVNGjl7N4RqscgLwwFt7GZdpB7r75zW7rt0btVcJNJGiZRYxu6DGDj+dc/Bb3sV/D5USPhgwZ3JX8eeD2revNxkxDHiPLZVWzjOMAeuK58VKccP7iv+h0UIwlV94kVoh4dv5nlIjePcpxyMgcH3rl9UaBhtKLIirhWPY1vxXDtpNzDbwySO6FUbyyUz6e5rm9RJhiaOSJw4A8wIPu+o5rxsNTcVfa7/yPYw7jean2NLw/LDDpYJx5sspMjn+I9smuZ1d2ivrrzFlZ2lOFyCg+hrotBnNxo7hbaGSDzCmD1Y9R75rj9UJ/tu4t5AYkLNtT+6TXVhoXxFTm3OObShFrYwbx2l1SR32qc8jHAq9bqbgmFEh3oWxt+U4Az+dUZYTJdO+6Rhxyi5J+g71cxGbsPFvjeOI8hcGQ4IyR2yOte7CKcUjyajak2T6rpkdr4f8AD96CRJexyk5PYPgVlMVnnmmeIDcNuV6D3rqPG1xb3UOlWGnDzY9PsVj3xDK7zywAHp/jXHxK0TsZI3+cY5Uit3sc8ddWd5qKxHRNOjjcxYlXMrNlhkdQew9qxtYcR25Ku0jdDMxy3Xr1rW1dNnh+xkUGSQzqNgXj7vQ+1Y2rRTnT0la3O52b5IonAjxjg5rzMPsr92dT2sjo/AyXF5plysVw6GGYFY40UlicEnceR3qvrF3NBqOowXF150xkKE8A4xwcfSpPh+V+z6kpcxuzR57Y69Kz/EcMces6hIIW8tShV/MyQT/ME1zUZf7fUi+3+R3Vk3hIMNMngvFWGSGKMRklmjRQxI4B5PPFVfEi6ZbqqWb3D3Wdx5ACj8KzYXl2TRjCh5QxcHDAEdPpT9c0saaLd1vUujMpLeWOFA969WG7dzy5DzqjNpcFgRGkce6Tccbsnknd17VI92Z0E5kD7SNoHAqgsakRl9uwR5G4cE+lWv3T2bAghiwzhcYrrwyS1OevuILu5tVJY7RJuIwo5Geakhu/9EufMVpAwUKUbBHOcfmM1VVnMf2dD8oGeRnJqG4UpbkMSrE5DYIGK3rNOLVyKStK9ixfzz/aEjcJuS3VflHygf41n3xU3KsgK/u1OPfHJpt5KHuWIPGMc9alhiimuFjcnbjqOe3T86yi+ZcqNpe77xd0yFBHIzbwGiY5Vu+K6T4bGNZr1mKFNqjDHkn/AArIhtZtPhMcsQQyAgtjcRyQB7ZOapeHmI1eCJXYRtIAyZ681yZtR9ph3C9jTA1LVeY9F8bTRf8ACKsVmKyJKjYU+/Qf41wsOu3l5Gy3N28ipC0aRsM5Xrz68gcmvR/FUdufCd6uxVlEOVKrgcGvK9GZC8iMdpMTEcH0rycks6LiujOvGv37mUxkMZ2ttCMTtye9aEV2ZNOigZf9SzFTns3/ANeqds0cd1G1yhkgJyyq2M1ZlRbad4kOY2O4YPb616VRJoWFk1M2NInRdDu4WQsJJlyQO205r1L4Wkx6bbL5wOL26UEdxtQ15TpBV9GvnDqHV12ITgtkEV6d8LvmsbdUOFN5dfX/AFSVqvgOaprJlL43xb3srhVOQ4UHHUH/AOuprzPQ2Qatbs0gQCRm3HpxzivXvjDDdHQbeeNN9uR5Ey4+627dG+ewyCPxrxvTLmOxuY5pgSqMCRjBJ781nNXg0h09JHbeLYYotNtJ4xGsRmLLGvDKCO47DjgVHNZM2nG6eZpLYsrrEvQOcfocmk8X31pNoMRiZC/nqwYYywwTn9awrXWE8kws+05HlruI28jnJ9q8inSqSpRa3TZ6PtEp2fUnjiMPjK0CWbW83mxtFbu21c54OT2NeuT3Ut5Zv9ptkhIzjZJu5x646f8A168jurhJ/GdtMtwZIvMizIz7yPYEV38V2zTlfNXytjEg9+DiubHpv2d10PQwVHnUpJ7Mn0aWMa3ZFztiMhLseAvynofWtyJrVda1Fky4byjvYggErjt/Wub0t4v7QsRIFaISoZNxwMf1rob9IJ9ZmP2V0LQIUXAxwSM1hFJ0JLzHj1/tHqixDbIkciqjIsmTwfXvVaEyxpjyDIF5+UgbqgM37hg1tLGoX5tqsQPfqRiqD3AVcR2jEZ+YeWwDfTn361x1Kd4pE4am3coamIrjVJ3dWQcfK/UnFSwwWcltlY0SVAcEAVUk3i+mEETPIW5DJkr7Gtu2E6+H7h5rODGGGJE2v9R6/T2rocJNJRZ605qnTiX7XQgIop7fTwzMoGWK7XPrz0/Or+kQxW+mrbvZqZVmdUPGQ24+natbRWRtBtVaQMfLUAt6Y6VQsBJbxyyqyTFJnCIpyzEt2HqBX0EaMYWZ8tOs58yfc8d8WbrjW71J2dPJuHRFRuAe5/GsC3trUyAzgtjPfGa7nx7oVzFeT6nEhktrv5yAhzC57Hv6HPvXH6fiOZVYp5mQCXxhRnlsfSlJuKdjqpuErO1zKvYBFeyx25doQRsxnGce1XvD8cL6zB5hlztx+66g+prZv7nQjOytp148u7/WxnaG9xzWj4asNGu9RBtbDUI7iP77SkAA+mPWnKo3Sd10MItRrX6HT2cfmXsKRtPHA7KmC/z89wexrqTa61p9q0C3UF9CV3w/aMxzDngBl4z7n2rDmsxZXsLqs8JjlXAkkUgn0zk8109kzXKtOsyNJE5Ro3OcNjkEj6jpXPlyaUot6m+Y1VPklHax5/rTXE1/dT7QsgwsqpHvEeOO/fpz9a4nUQTdqokVixPLjaBx3Fd9qQuXvbuO1ZYomlb5VKHJ/HBrjdUsbm4vkV7V5JgxU5UkZ+inNKlUlKs0/M7JwjHDqS8iVIYfLlVVjdkxg4PT061ZtLSyvvCmplre5N+uWiFtFuAUewp1hBNEk8khaPCqMm3Zl/PqOvHaqsLXTTJblpEiaUjZEdsm3ac4P1x17GtaDlGpdmeNcJ0XZnJGEO0uGMi+UJQx69cGvWPPgvPD1hJa6jw9tEz2kuWQOTtJDckH0HsfauAtPDOo3ce+0t5CSHVtrjkg8qFPOB613PhnwrqEekQWOoFbZWYvGPMXIz3PoeOM+pr0K8uaDUWeFSfLNSZECgcu7BV3bc7iMAHFVdRjjYbInyoAOQSDn8a07qGKx1G0guLnNqJNzzMoUtn6ccH+lTatHbSM01uU2uAMSSAggeh718zUpypzR9bQxcZOLtuc7aWz3CiIbnk3BV+Y9zXQQRi0RmnVsqrB+e4H8qpackD3yiRnQA5RYmwCfetmflLjehdnjYYfuT61z1ajc1E6q07aItabo14ulvDNcB7a4KtFIUyqqeWBHQnp1rhtU8WWtjqNxp0tjdKbeRo90c4AZR0wuMDgDpXpyWrw2YghugkJKuI3OF6fN9K8H8XDz/FF+6bQv2lgO44xn619W4p2T1Pi9dWjrofiBazsIBBqXllslUlX8fpVmPxJbLKGkg1ktFIJo2kUNjByB9MVw+iJbLf3HlyPsMZ2lh24zkCusttPmbTzLFdfaGkQDy/NI2nOMHPpXDiI0oz+BHp4Si6lLmcj16HWptQsbe9itmxJGX8sgg4P3enQ1nXkgubFpbaB4WlHMgj2jdwTyKk0y8/s4f2fPGIrlYVPllhliABkDt+foay73UFbT7hBulkaTaoZwVQA5yB6cY/GuqtKCg7s86lSlKVkjFW+FhM8sk0s8cRAO5eSG/hz7dfwqDUPE0WtT21v5Kxw28y4cHYWJ7Hn7tZsPiCManLDDpMQMG5TmU45zx6Dr1FYoEUUkkmGEazqcHOcZORzXJFOMOW+p6NKkpVVKSPbPBDq/g3Tow25omeNvqHNW/FWT4YvwSDtjyO3cVgeA5FXRRJAsiRuzO0UvJR/9kjrkc07xrrVzDpAs0hRGugQ0hOQqj29TXpTkvYty7Hkwg3iUo73Of8ADMSXWuCKQGRWiYlUPKcjBrQ8T6OUuRciSZYogB+74LHPHXgYz29a4yO81C1JfTby5gcrtMkK7cj0yRV3S7/U77VXjuL++vYY4yzQPIMsR2x3rhwCjy+z6nfmUJ8/tehveHbqaS/eC5tnkCoZFIfdu7dR3+tbsspUySeQwwnI8zknPcisDR5Y7a/Em9YNy7RvbZu56VrS36I8ijIB6Hj9PWvVUJLRnkSmnqYM1zHJegQ6UkkzEhx9pIDd8+wrLTXL2cXMc9uEieUheCWRf7o/KtYIBcMYjFGAxwzNgCq2oRWxt2UzwSMGAVEbBb1IPWrnBuLsxxmk9hlprEKfcCS5wPvcj/gPrUurXp3iaPyZA0BOJI1JHPSr+nQW8LqY7S3VeAN0eT+dUbuQy2shMURHzbNqgENnrnHI9uK5KkNLNmtKpFy0RJfJbz+GZFiZUlaMfulYbnPUVa1zXNP1nTbaO0Ile3GGjkjzj5QCw7cYrntWBS0iJyEYANtXHbnBqnpzGWW7mjikisxAf9ZwD0zg+prbGtxhaK0RpSpRXvN63EhUW3y2yK0Z5C+YAPyrZsy/ImSBVIwSkm1xu6BccHn196xI4rW4vEEkLyQv/wAs2fBT15HatdrSKwDMEKqqEBNwZdvsf61lJ89FvlvoOL5ZJX6lDw7a3SR6i9w95ELcOqKHKgHBOR/nvXOXJuTHFJNdTyK6g5aTp+FegNIHguBuCkQkt/tfKcfWuQtLJLu2STy97x7QV5I456dK8Kji5TUpy0Wn5Hq0KCcmt2bng3RrPU1uklurlZYHUwLC+FYdyRjk1i+PtKTSNWWKG1mmWSPzXeaU793Q8dhXQeHb0DV3tZFFpbzw5l8tNrsFbOFI6bqyfiNqci6mtpGzSP8AZiu5j8ygk8n1OOM17EJwlRjJLVnlzhUjipRb91HAC4gWYHyZNy/3JucfXFTx+XJdLLG9wH7kkFiMevcVmghZSRyNuCPWrNrut7iJlIZgNy7j8ozwM4roijCdy/eWc+n6iEzMkJAZZEO3eMYyp/E1FIka3kTPc3LEn5nxnH5mux12GeX4bSpclEk0++jEYTkYdcls+4IrinCs6DzYSqt8uCc49/etrJMwUuZGqzxwwxSSX1xFHJuQhskcc8VZ1GeWz0mOfT9fnmdzsZIpGCgEd89DXPaoG+z2QEhbCsR6feqd5W/soWzMdqtkgDnPqKco01dWHFy0dzS0G8lbUpfPuJTH5R3cj5iPWq/iSUjUJhHKxTy0I3Nlunf2pllcW8OqW80KTLH90rJj94Txz60niOQzatLJDHtYwqGVQeB9COK8nktib90es53wqXZmGJWKFFwOMZH/AOutXWlxFaKuAPJHYDJwD+NULWKRkaUKSgHzjy8gDI5z261f1xD5VuYpC8apg5GCDxx713RR5snqggvZILRA2QGBDBYwxOOfyzVl7xrt0l3K7KuCNuAP/r1mO8gs4FdmjGX3Fhj0/Snw3CrGIgQQOSR6Vph4xWpNaTextW2orBbuQsqREfMImC4H1IOai1DXLO8sfJmF40nVA7KVIHQnjOax550aEpExZRwee1VJ9xht8Z4Q9T79valVpxcrodKUlGzJbtTHdXMc4IZSccDk5qOC5KpsSPMrMPnUnd9K0dRn02e/mlePUBO0p3KJE4/SqiXNlFdBkgnePoUeQAn8hTjfQciaznuIp8SByDIAyMOp+lP08MniSNIsgJP16Vpw6jpsoiJ0ljgYG68bp+VU5r62TWTL9i8sqwwqykgfpzV4ik3StcijU/ebHpXiO7I8M36BJpIGg4JONp464rzLRl/0llCkboTtJGQRiugvPEMU+nm1uLeXyJFBwJRyPr/Oqtgum3NyIYLWXOwlt8xI6da8zK8NKjFqT3Z14upzO9jkIhvmCM5Rc8nGcfhWozgIsfkqI0H35FwZBngms/zHE52Qx7ozxhd2OfWul1QNJZadJJGPMNuSypGFB57jv9a3qySaXcMPdz0KunyRiwnjCIWkIKlUJZOemcf1r1P4XxOtnZeZIS32i7kOFIGCiLk56ZIIrzfRrp4LW8W3eaN25YCLfnHJz6D3ruvB+sahd/2JcTX8ri7vZILhNq4KD7vb1zn8KuM9LGdWPvM9J1qw/tXS7u0lCPDcKY2jIOcEcEe4OD+FfM15ZT2F7PDInnCF/mxxuweo719KxQLf212l0JJQtwylfMIOMcfTivnrUtcuoNVuIpxBcCGYrF50QYhVY4BPX8acbWM1cn8QWN3Ho1tcmWaa2lKnLRBVJI4xgnngjH+Nc1FI0jKHB2qc4Awfpmuu1PWJZ9Lh+16ZpbWwbcYo2Zdrn0APHAFY0Vzp9yP+QQgZeQy3Lrj881hSfuO501FaS07GlaWyW/jXTohbzCMyRMfN47Z/z616uxhaMDyTjJ+Y9eePyryuS5t7HxJa3TQFVi2F4vPJDkLwc9BXo2i6zDrMjfZ0KLEQJAJASxPTGB05rycwpzk4ztdJHqYVpc1u5DbwAPF8wjYSpskABKnOM4PBrZv472w1e3GoXe62eMxQz7doLKckEDoT+Rqrb2ckcvzRLuQ4DycgMPUHmp73WH1qxMVzYoNxZVkSXDB19Aemf8ajDRj7KcKjsGLnKdSMo6onurkLbSxxfvY5FIDIOmT3rL3yiLYbvG0YDPgmlgE88jjZbysF+YszA5PAH/6qb5Nykh229sW7KxY/j07V5U1K9m0d2GcIR0RkyR3LTylJQRu+aRSQCfwq9pqRT6deJNcS/bHUiCIMxV/r659Paqd8m2WUyonmJgMqMQBVvQ5YV1uw3QhFNyiHDZ5Nd2HleSVrnbiIc1Bu+2p01u9zBHam2eVlZMeUGMe1u/0FNikurbzZEhEhQnAzyhOOOvOc549K6NbKKRjuUcEjI471nBfJ1KQmMOolYLnt8oyfwFe/KEtLHyUKkXcpSaY2pWcdzc3EpnYb4xGdqxcccd+fWvG5752kaWaO3MisUUsuCxB7jHQ17wgLafDND1Cr+Iz0r571GCBbq5cRssokbdtY4xu7Crq04JLTUMPObkzrrLXtGtk+zXt3PHNEvzBbfIDgDA5HAz1qsPEdxcakyxAuyguHcMnmj/a5/WuVvp45NXedI8odpEcgzkbR1qTTgJ7xzNGzArwqdR/9auT2StdHdTp3rJPvY7C51+82QxS28MOMMCJCST1/yc12Wg3EccMwN4qyswJypIZsA8dcDpXnUSlmjRoZiF5B8sEjj6V6doMMtjFIpijVGwY4tu0sfp04p4WynY1zOEYQSicFq91dyX1xK0duX8xsv5hAJ9RzXO3d1LJJCu5FfzcBg5O31Pt+Fdj4utZbHVnDyOskp80BYd4UHsM1xlwwuHiR1YOJMAxxbWP/ANes4Rcaz0Omc1LDp+SNix1u6smmhjurgs5C/KxYMBwMZzV+PVtTNpBMLxBDLG7AGEMdoPPIHPTnHSueBuI2KmKWQod2ZASQOo78Us17NF4UhMBmtgwlRQJflbJ+bC9vc10YdN3TOLMVGKXKjffxRYtar5k1x9qhZjC6IoD9PlyTkdzV638TTTWzzrC6SmQLuZUPOMgHI9jx715lDLO1leqZ0WJlXfGUyW54we2K7aLUJbfT4HVrJ0aVGCsSWLhQN5A7AAfU1vVg+RuO55tFxdRKS0OqGnTXehR3wsobrIUhXXG4A4bnsOvAqpealH5hRdMtLZY1xsZvuj6ba1NI8QGx0SKzureVgdwR44/NjZOpIIPT61j+IPFMN/8A8S+1mihtCgUTyrkkYx8q8Yrzp04yhzJnp0XNVOVwul8jn1+zvPHiWPykIO1WwD+Jrdk1KwttJ85Y5pLkI37lVLAtnj2xjNYMemaW2BLdNMAMKAcD9K2o3igP7sjbt28enpXLOMXJPex6825RtsdppA/trR7OcrLDJcQeYuHLBAAcAfTrXl3iDwqlhe/ZNRnNtcMfMSaQ5SdSTgjP4fia9M8JiS70zTwt6ssSbwIkQoYwM9T61gfGUxrp+iW0kiSXXmu4JA4QAD8s/wAq9qSUoqUXY+ahJ06jptXOK0DSIrO7M63Pmo6lDDGAWY/y7Cumm021jlaWWOeOMhWZC/HOOGxwDmvO9Nif+1oXCFI84IDdePWuqOm28+12eXgjJ80kdepFeVioP2icp/gexhYOVKXLG1r9TutTjt21uKJYnwIfkWX5l4IyQ2eeTjGfSqOqW8OWhDRRy8FkkiAGDnBwDzVXWbaK11nTY7KSUwyJIHWSUsxC8jk8jP8AnpVbUltpH2iyLpt5w5BP0556104mcdIy3OPA056OOxzEGyHVL+GZmjKODti5y2eCOwpkk08F3+8mE0G8PvdwQcMeoFVnxFqVymXCcbUJwwHvUFwYzeOFRGXJG8ngc9femo3lr2OhycIpruz1zwfrtva6LFZ6gxgErs0chwcg+ozlRnuau+MNUggt7AJAl8xZlVVkx2yDj/IrP8BaX9p0YSK/lpkiRNquHbpnJ5U9O/bpV3xZocEGkRMAxYSBEMIAfntk9B7E101IJ0GpbHkwklitN7nJNryW7mSDSsRuuXQSA4PfpnHSstLmP+0Eu0VIIyQSySZfnn8vSoZrO0juUQQ7d43ZkbaQQcHofpV2wsZftKMqQTWJG9XDn1x0PJwc1hgaUedOmd+Olam1IuX6WGq+a965jNuC4YdSSfTv9K0NLhDWEEFvulVCUDP949889PpVJkjVJBGnzNg8jmqdxqMVjcoHi85mw7FpNobHv3/rXucqTuzwpJuNkb0tqr+cjuh3dSvNCWFt/ZPnfZ4zIuFDBBuXmqNtqJSQutkSpQna0nH0q/HKZdJLqNjOy5Utkkk9K35LU22jNX5tzZtnBIJUdfSuTvp4orS7U+aR5nUcKMnt6murtWjbYhwDvwcc856VyN+DJa3iFkws3yLnDZ3cmuN0lJ6odJ2ZVvsR+W0KhoyuNrfxDA7+vWmxiGG1u3dnTZEwXPfpj+tLc30kcaskaO+MMkPJX0xzVXVNVnGjP56x7nKRtFIgJwM/N0yDzjrRiI80W2j0qcrLR6C2AZREy+W+/AIQ9eOntXUGSVdMKzWG5irKr7wRgjnIHtXF6VcJalWjfzkAOYpFI59flrpodUSeNUBiKsTt8pXBBx6HrVUoJ0rNHNN+/oVJb+OW1SRmEYMJC5PGen5ACszTMG38xHZWV+CGxx3ptzFdiMtGwEGMbthwVJ5yOwzxVXT3eUPFGJFUMQZEGVWvAq4F06D9T18HiEqzv2Oh0+4WDxLau0rBNrcqMsPbHeuf8c3M13rbEOsyi2Kq2CMDOfrmq63U63kRlDFu6pndnp3rM8SM8epRlvPQqmR5jAtu/Dj8qMNTlGcU3sh4ypTleSWuhW/seb+yxqDuqRsVUKxw7e65HOO/pVWFBLcqrSMIywUEgA4qu0su0feCbj3baf8APpUsZbhZBlUUsNgPymvXitTxpnWa3cXQ0XVZzvhtbq+Xy1XlGQDG3HqABXIiZMfMxAzuU46H0xXoesRRm00jRLWTytsAlE/ljIYoGI/HJ5Poa8yWRk3IVzu5GV5rWd0ZU7NGhqfIswH42HO4Ywc9KnYebZSDAyo3fhwKzI5myC2WYZCjPINakAZkID7FKfMe340k76jtZWF3+TLBIpcIhBGMZxgevFN8QXvnawZY5mkj8pFBYD06YHFNuHIZN5XaFwec8+1UrxpJJxIIwMxgYVccDjOK41D3+Y9GtL90o+hreFbOXVL6a385I41hOTICeCQePxxzxV7V/Dd5He+Q01oRHGWMglxjB7547jpxz1rC0rWrrRpGeB90UhUSRMMq4ByMj8K19V16fULp7hGFuHO1I+CcHAIxj2zXUnGx57i2yVPCt7PdxW13cW6yJKEk+fdjIBGPU89DUWt6BFZiIWkjl2D7hI684IGVA6Dr1p3266n1BpYrueSdZEdTsx8qr36Yxxgd6Qve3VpMh1C2WKaMqRPMFY/Nkqc9PXApwcXogkpbnP3EUlsoWRlAfI+UdR+I6VGSRBDwCNpGB9a0dXs5ILe1lnvbW62jyUEU29lA5Ax6elZrjEELZPzKeo96llILqRvtsr9/MJGKrhiWBHXFT6gQuo3BiJ2iQ43cmq29mIJzSQM2bSQfY2PljIHLE1X1TMc7KP4gp57VBuBhKqCTnJPtTr9iyQSZ+9EOvtxXROfNCxjGPLO5JbXWcGVd6qDgdh/hWv4dZvt6lypBDEqR61gINkygE7COuPz4re8NKf7RXY5cYIwR2rnoL94jqryvR1MBpCsrhSVXzNwI65FdxqDNe+GNJu4ykgUGN35BU54z/wDWrhGbE7cdWOcfWu+hmhl+G1mhK7o7hlURn5857+3NceL05Wu5eGlyyMmzuBDYXLG+MLMCBDHuBbtgkcYrq/Ctz5Nj4aLqqhtTlIUKAxPfn0x29a4x7qw+zvENOcuc7XaUnH4V0vh+aEaLoX2lXf8A4mEgi2c5fIIz7ZxnFVTVk3YuraUj2XTp98l5k/P9rwQOCBtBwa+btZiM3iG+VcbjcSYyf9o19C6C7Pd6hKw3uLs/iNoHP5V4LIiz+LZ8scC4kbCezGtOZKLZzQV5KI7U4ZEtB9oeIsqKQFXG41jwhmwUlQFeiEnk/wAvzrV1S7eG3jtlkd8gmTjp3Az+P6VmW7IdyvEFZiCj45Xms6ClyXZ015KUzq9Mv7238VRlYoZZ3gWMLOgZdu36cH6V3EN/dJfQTyWNpEkRRHNuCN2DwSDj1rz2RzF4vtGjfzHKJtG7vtx1x/SutF1dRW2Xti4djyr55z6dTXmYtS5ouKR6eEcHCXNvc7oY8yS4lmiAPzlRwGIyBnP1/QVm6a8DWlwBA0tyZXZnwDGp7YPUn8KbDqBkiiuZTJDEg8vZhWkztPJHPy5AGBnGaXStStMXcN1cjiQ4VV+9npRXptx1OVNq9hljDEZJFYtEY3yqq2OvUirztHK+GaTIXav7wAnPJ/WqrX2ntM+ZmYqoK4Dcn/EVBcy2155TNOMAEE5x+FeBVjJyu7o9XDQ50ijfSndII5FGD1fBJx7kYqtDLLDLDOzozK6ORgDGGGMYqC6toRI8cUjMjLzk96YLeS2iHmRwgpGWDZycYI7fWu6ioxs0z1pQXs+XyPaYZYdjS+ZFtZsn5xxVAWlx/aEsgCfZ5JCQ27tj0rG0yxs59FP+gxP5sSZ3KDu4/wAa07yaXT9AMIcKwAUMp5G488+wr6uSVryPg7tTaiUr6W5tfDtzcWcDGa3VtpBPQdwPUc14ZqIkmlZ1kZtx3byCCx654r2+xvJ4/h/c3QxJJDDNksckkEgH/wCvXkt1qt021FCoXjXKZ4z159a58TKS5WjuwUYvmTMDU/NW/SV2y5RCeucY7+tWorhTqJYzsA8fLbcH6YqHVmk+1RmcfvmjCkDpilnlfzbd8BZCu0duKwWsUn2PTi1CcpLo0zpLWe2LoBM6gd2celd1ot3Zb4pZpyyxoFUM+7B6DJ5rzG1SRGXzgp+YYZQGyPXn27V0kcjrKjx3M/kqR8oiAJH5nn+XpUUpujLTUMdGOItfQ3PH8kIvbGWLbiWE/M7HkA9eD/SvOLhtlzFtIJ84bSHyBx16cVvarc3c/lLeC4k2cRquGAzzxWJdNcQ3NpnaJGmwFVACBjA6U7qdZyXUiP7vDKL6f5krK/k+b58bblO/axOMA/4VVYwy6Jb/AGlXjUylRKIeB3xuzzV0W0iFx8qKvysJJQu3j0/OoLiNrXTobYoJvKkZ/LBLxnJz16dvWujDQkm7o5sxrwqRjZnNBGWISbsp5hRgD0rfs7Z/7KN5C1u6hl3Ky/vIvmwuD68Z+lYywqUkklt50PJb5QAM+3+FadpD9iSKSBbwSMpXftU4B4yOo6Hoa7LaM8qMrSTR2WlnRY2ia4vV3DJYhjhgfpVK9t9FnlZrZ1K7jtBDAY9qxLfdLIcQlI4zwAMcY7/41aeC3uJVMHmRvgbgxz83qK8KdPklZtn1eHSnH2ifyNKz0+DDhSNqjOCSM+uM9a0ftVpHbKz3KbgoYIsOc+2R0qFY7qWMNNcbSmGKDBVfcc/pVe8WKZMxC4UtwdwAJ+hBrPlVrvUfM5y5XodN4U8QWWlAW1zHdmWRyxdFG1QT2zzXNfEa/e98Xzqm4xwRrBGXT5cY3ZHvzSWFvMlzFmN3KEMMnJHPUn0qr4+jFv4pucTvJ9oiicHqA23B/l1rupVXOHL2ODEYaFKupR1vcxtJwb4eZBCyqTyuc/hXR28IWRwcNFwcN3wehz2OK5zSVaC6lK/vGwT8xHOR16VqS3V/aruKxOWGDtGRmubExcp+6z0MNJKjZnW+Lm+0f2fczyOiGV1edo1QplQQgIAyABxnOPxrCnlhxtUxlW5U5ZRz0+lF1qOoyaS9pdKtysTK6vty2euF/Hgn0pkrTzQjzJbfzSuSnltke2TwRWlZKSUrnFhE6cnBrqYLNLHrN0BtYlQX5ypHpmqV2EWY4G3GTjOR1BqzKZTrF1EZEOYwWIGA3pVa9cpKPmRztOW2/h0raGkl6BUlF03fue1eAJoovDgWORTIzknqMevFXfFsD3Hhl5EuUKidCzFtuMcda4fw34mhgtYI9zLuPLtHuYcdMCum1bWNPvdIuInIJ8gqqBSuTnjK/XvmuySl7F+h4amli7ra5xtnZ2v2ry5z+73MJJQud3oB+NdFbDTlniK2czNbjzUVFIyvQjHQiuftr1o3Ty1yoYBtowT6gL/XNdG0yywiUXO0Rjj5cMcdz2AFceXTrczXQ9PN6dOykmR3xN5atJa20sRxlC+Bg5/u59K4nWVil1h457iTeVGPkUZ9AccAfSurvru9lgjliUbJF4O3G31JFc3qVvb/ANpiV5zBlUG0oXO7HqOgr1qt4wTuePRXvWsTWOqRmdRKPlVSGO8HFaOoTTL4eYxBUcyIcr12nnJ965jUCF02UIAXODux0IPA/nWrp8pvPBknmOc20ygt3PcU6eIqTjytjlSgp3S1MqNr1xIyXjoVOQfO9/T/ABq2ZJJdPnVzudwACJBnOevtSCExOZsQy5527atQr/o11uijRmiztQAqfau1U+XUyk0Zk8OoP/qJAnUF/MVc+30rPvrK/wDIMlxPCyIQNol3A59K0IPMSJd9quXk+QLj5B3LVPqFssyR2+FXJJDEce3SsakIuLkbwblKxkWNzLaxh7eaJckkk/eB/Gpzeatc/Obxh6E4X8BU7WlhZFTmRgf+WiqDyfY1TmidSZXVtnX5jis4L3bFTjyuxs6LdSXfhq7tZVupTbTlTGh+Xa3dj14I4FVrCZp3uUEMiIpD+VAvHpk1kaLdsurzxrIY45B97aW2ntwOc+lasDSpc3CW1zHuYjorZOfXsMc5/SuTFa0HY1wa/fW7ktzbeXdl4VSWMICpkkYBifU9RiuV1LVYbq6AnsEEsX7r5J2xx+ddE6M6LHO8rMXO5lJxj2/xribkbbh1UAgSHGK5MHK909bHRmNFU2mupqz3Vra3Kwy2r+ZFg8XJwePYV0On6RLqWjrqVvplu6lmK77lyWx1+UEHiuEmO6dsDgsTiuu8P+LhpWjPZtaGRlZnRgMYBGMfTNelSUW7SPIqc1rxNC38QboXj8mONDlg753bwCDjnHAOPXnmucuJIJZXkEMEhDHLDeC1aOmHFs8hWGYNJ/q2H3Djdu//AFVydzK5u5Dkglz9aqeiT7ihu0aBFufm+z4A67HP9anhmiU7fInJI6LIOR+VULSQfZ5OCMDoOjeufwp+luV1GBjlWV924DtUXNC/cSWbOyvDdo3BALoff0qu72tzKzK1yTz2XJ9e/vWfMwIAUHdyfpmoYTtcNg5H+FRp2Lcm1Zs0Atg7oPtEw5/54j+hp11G7XQVHeabIYHbh8isuLIkXjPIqe4d/tcjITnf170CNGfV9VgD28k8seVCumMFh78ZqFXZtOkbO7dksSAapTSu772Znc9Scmp4ebGQ4IIBxRTSTFJtlQSMAAcf1xU7v+4gHPCnH51VyelOMjsFDdBwBjpRcD//2Q==")||u(xt,"src",en),M(Ht.src,jn="data:image/jpeg;base64,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")||u(Ht,"src",jn),M(St.src,bn="data:image/jpeg;base64,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")||u(St,"src",bn),M(Pt.src,zn="data:image/jpeg;base64,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")||u(Pt,"src",zn),M(Gt.src,Xn="data:image/jpeg;base64,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")||u(Gt,"src",Xn),M(mt.src,Qn="data:image/jpeg;base64,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")||u(mt,"src",Qn),M(gt.src,_n="data:image/jpeg;base64,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")||u(gt,"src",_n),M(wt.src,Al="data:image/jpeg;base64,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")||u(wt,"src",Al),M(dt.src,el="data:image/jpeg;base64,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")||u(dt,"src",el),M(Wt.src,sl="data:image/jpeg;base64,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")||u(Wt,"src",sl)},m(A,t){Hl(document.head,V),e(A,Tt,t),e(A,bt,t),e(A,Bt,t),s(k,A,t),e(A,qt,t),s(y,A,t),e(A,zt,t),e(A,x,t),e(A,It,t),e(A,H,t),e(A,Ot,t),e(A,S,t),e(A,ft,t),s(P,A,t),e(A,Nt,t),s(G,A,t),e(A,Zt,t),s(m,A,t),e(A,Xt,t),s(g,A,t),e(A,ht,t),s(w,A,t),e(A,Dt,t),s(d,A,t),e(A,Yt,t),e(A,W,t),e(A,Qt,t),s(b,A,t),e(A,Ct,t),e(A,J,t),e(A,vt,t),e(A,T,t),e(A,Lt,t),e(A,B,t),e(A,Et,t),s(q,A,t),e(A,_t,t),e(A,xt,t),e(A,$t,t),e(A,z,t),e(A,Aa,t),e(A,I,t),e(A,ta,t),e(A,O,t),e(A,aa,t),e(A,f,t),e(A,ea,t),e(A,N,t),e(A,na,t),s(Z,A,t),e(A,la,t),e(A,Ht,t),e(A,pa,t),e(A,X,t),e(A,Ua,t),s(h,A,t),e(A,oa,t),e(A,D,t),e(A,ja,t),s(Y,A,t),e(A,ia,t),e(A,Q,t),e(A,sa,t),e(A,C,t),e(A,ca,t),s(v,A,t),e(A,Ka,t),e(A,L,t),e(A,Ra,t),e(A,E,t),e(A,ra,t),e(A,_,t),e(A,Fa,t),s($,A,t),e(A,ua,t),e(A,AA,t),e(A,Ma,t),e(A,tA,t),e(A,Va,t),e(A,aA,t),e(A,ka,t),e(A,eA,t),e(A,ya,t),s(nA,A,t),e(A,xa,t),e(A,lA,t),e(A,Ha,t),e(A,pA,t),e(A,Sa,t),e(A,UA,t),e(A,Pa,t),s(oA,A,t),e(A,Ga,t),e(A,jA,t),e(A,ma,t),s(iA,A,t),e(A,ga,t),e(A,sA,t),e(A,wa,t),s(cA,A,t),e(A,da,t),e(A,KA,t),e(A,Wa,t),e(A,RA,t),e(A,ba,t),s(rA,A,t),e(A,Ja,t),e(A,FA,t),e(A,Ta,t),s(uA,A,t),e(A,Ba,t),e(A,MA,t),e(A,qa,t),e(A,VA,t),e(A,za,t),s(kA,A,t),e(A,Ia,t),e(A,St,t),e(A,Oa,t),e(A,yA,t),e(A,fa,t),s(xA,A,t),e(A,Na,t),e(A,HA,t),e(A,Za,t),e(A,SA,t),e(A,Xa,t),s(PA,A,t),e(A,ha,t),e(A,GA,t),e(A,Da,t),s(mA,A,t),e(A,Ya,t),e(A,Pt,t),e(A,Qa,t),e(A,gA,t),e(A,Ca,t),s(wA,A,t),e(A,va,t),e(A,dA,t),e(A,La,t),s(WA,A,t),e(A,Ea,t),e(A,bA,t),e(A,_a,t),e(A,JA,t),e(A,$a,t),e(A,TA,t),e(A,Ae,t),s(BA,A,t),e(A,te,t),s(qA,A,t),e(A,ae,t),s(zA,A,t),e(A,ee,t),e(A,Gt,t),e(A,ne,t),e(A,IA,t),e(A,le,t),e(A,OA,t),e(A,pe,t),s(fA,A,t),e(A,Ue,t),s(NA,A,t),e(A,oe,t),e(A,ZA,t),e(A,je,t),s(XA,A,t),e(A,ie,t),e(A,mt,t),e(A,se,t),e(A,hA,t),e(A,ce,t),s(DA,A,t),e(A,Ke,t),e(A,YA,t),e(A,Re,t),e(A,QA,t),e(A,re,t),e(A,CA,t),e(A,Fe,t),s(vA,A,t),e(A,ue,t),s(LA,A,t),e(A,Me,t),e(A,gt,t),e(A,Ve,t),e(A,EA,t),e(A,ke,t),s(_A,A,t),e(A,ye,t),e(A,wt,t),e(A,xe,t),s($A,A,t),e(A,He,t),e(A,At,t),e(A,Se,t),e(A,tt,t),e(A,Pe,t),s(at,A,t),e(A,Ge,t),s(et,A,t),e(A,me,t),e(A,dt,t),e(A,ge,t),e(A,nt,t),e(A,we,t),s(lt,A,t),e(A,de,t),e(A,pt,t),e(A,We,t),s(Ut,A,t),e(A,be,t),e(A,ot,t),e(A,Je,t),e(A,jt,t),e(A,Te,t),s(it,A,t),e(A,Be,t),e(A,st,t),e(A,qe,t),e(A,ct,t),e(A,ze,t),e(A,Kt,t),e(A,Ie,t),s(Rt,A,t),e(A,Oe,t),s(rt,A,t),e(A,fe,t),e(A,Wt,t),e(A,Ne,t),e(A,Ft,t),e(A,Ze,t),s(ut,A,t),e(A,Xe,t),e(A,Mt,t),e(A,he,t),e(A,Vt,t),e(A,De,t),e(A,kt,t),e(A,Ye,t),s(yt,A,t),e(A,Qe,t),e(A,Jt,t),Ce=!0},p:Ml,i(A){Ce||(c(k.$$.fragment,A),c(y.$$.fragment,A),c(P.$$.fragment,A),c(G.$$.fragment,A),c(m.$$.fragment,A),c(g.$$.fragment,A),c(w.$$.fragment,A),c(d.$$.fragment,A),c(b.$$.fragment,A),c(q.$$.fragment,A),c(Z.$$.fragment,A),c(h.$$.fragment,A),c(Y.$$.fragment,A),c(v.$$.fragment,A),c($.$$.fragment,A),c(nA.$$.fragment,A),c(oA.$$.fragment,A),c(iA.$$.fragment,A),c(cA.$$.fragment,A),c(rA.$$.fragment,A),c(uA.$$.fragment,A),c(kA.$$.fragment,A),c(xA.$$.fragment,A),c(PA.$$.fragment,A),c(mA.$$.fragment,A),c(wA.$$.fragment,A),c(WA.$$.fragment,A),c(BA.$$.fragment,A),c(qA.$$.fragment,A),c(zA.$$.fragment,A),c(fA.$$.fragment,A),c(NA.$$.fragment,A),c(XA.$$.fragment,A),c(DA.$$.fragment,A),c(vA.$$.fragment,A),c(LA.$$.fragment,A),c(_A.$$.fragment,A),c($A.$$.fragment,A),c(at.$$.fragment,A),c(et.$$.fragment,A),c(lt.$$.fragment,A),c(Ut.$$.fragment,A),c(it.$$.fragment,A),c(Rt.$$.fragment,A),c(rt.$$.fragment,A),c(ut.$$.fragment,A),c(yt.$$.fragment,A),Ce=!0)},o(A){K(k.$$.fragment,A),K(y.$$.fragment,A),K(P.$$.fragment,A),K(G.$$.fragment,A),K(m.$$.fragment,A),K(g.$$.fragment,A),K(w.$$.fragment,A),K(d.$$.fragment,A),K(b.$$.fragment,A),K(q.$$.fragment,A),K(Z.$$.fragment,A),K(h.$$.fragment,A),K(Y.$$.fragment,A),K(v.$$.fragment,A),K($.$$.fragment,A),K(nA.$$.fragment,A),K(oA.$$.fragment,A),K(iA.$$.fragment,A),K(cA.$$.fragment,A),K(rA.$$.fragment,A),K(uA.$$.fragment,A),K(kA.$$.fragment,A),K(xA.$$.fragment,A),K(PA.$$.fragment,A),K(mA.$$.fragment,A),K(wA.$$.fragment,A),K(WA.$$.fragment,A),K(BA.$$.fragment,A),K(qA.$$.fragment,A),K(zA.$$.fragment,A),K(fA.$$.fragment,A),K(NA.$$.fragment,A),K(XA.$$.fragment,A),K(DA.$$.fragment,A),K(vA.$$.fragment,A),K(LA.$$.fragment,A),K(_A.$$.fragment,A),K($A.$$.fragment,A),K(at.$$.fragment,A),K(et.$$.fragment,A),K(lt.$$.fragment,A),K(Ut.$$.fragment,A),K(it.$$.fragment,A),K(Rt.$$.fragment,A),K(rt.$$.fragment,A),K(ut.$$.fragment,A),K(yt.$$.fragment,A),Ce=!1},d(A){A&&(a(Tt),a(bt),a(Bt),a(qt),a(zt),a(x),a(It),a(H),a(Ot),a(S),a(ft),a(Nt),a(Zt),a(Xt),a(ht),a(Dt),a(Yt),a(W),a(Qt),a(Ct),a(J),a(vt),a(T),a(Lt),a(B),a(Et),a(_t),a(xt),a($t),a(z),a(Aa),a(I),a(ta),a(O),a(aa),a(f),a(ea),a(N),a(na),a(la),a(Ht),a(pa),a(X),a(Ua),a(oa),a(D),a(ja),a(ia),a(Q),a(sa),a(C),a(ca),a(Ka),a(L),a(Ra),a(E),a(ra),a(_),a(Fa),a(ua),a(AA),a(Ma),a(tA),a(Va),a(aA),a(ka),a(eA),a(ya),a(xa),a(lA),a(Ha),a(pA),a(Sa),a(UA),a(Pa),a(Ga),a(jA),a(ma),a(ga),a(sA),a(wa),a(da),a(KA),a(Wa),a(RA),a(ba),a(Ja),a(FA),a(Ta),a(Ba),a(MA),a(qa),a(VA),a(za),a(Ia),a(St),a(Oa),a(yA),a(fa),a(Na),a(HA),a(Za),a(SA),a(Xa),a(ha),a(GA),a(Da),a(Ya),a(Pt),a(Qa),a(gA),a(Ca),a(va),a(dA),a(La),a(Ea),a(bA),a(_a),a(JA),a($a),a(TA),a(Ae),a(te),a(ae),a(ee),a(Gt),a(ne),a(IA),a(le),a(OA),a(pe),a(Ue),a(oe),a(ZA),a(je),a(ie),a(mt),a(se),a(hA),a(ce),a(Ke),a(YA),a(Re),a(QA),a(re),a(CA),a(Fe),a(ue),a(Me),a(gt),a(Ve),a(EA),a(ke),a(ye),a(wt),a(xe),a(He),a(At),a(Se),a(tt),a(Pe),a(Ge),a(me),a(dt),a(ge),a(nt),a(we),a(de),a(pt),a(We),a(be),a(ot),a(Je),a(jt),a(Te),a(Be),a(st),a(qe),a(ct),a(ze),a(Kt),a(Ie),a(Oe),a(fe),a(Wt),a(Ne),a(Ft),a(Ze),a(Xe),a(Mt),a(he),a(Vt),a(De),a(kt),a(Ye),a(Qe),a(Jt)),a(V),R(k,A),R(y,A),R(P,A),R(G,A),R(m,A),R(g,A),R(w,A),R(d,A),R(b,A),R(q,A),R(Z,A),R(h,A),R(Y,A),R(v,A),R($,A),R(nA,A),R(oA,A),R(iA,A),R(cA,A),R(rA,A),R(uA,A),R(kA,A),R(xA,A),R(PA,A),R(mA,A),R(wA,A),R(WA,A),R(BA,A),R(qA,A),R(zA,A),R(fA,A),R(NA,A),R(XA,A),R(DA,A),R(vA,A),R(LA,A),R(_A,A),R($A,A),R(at,A),R(et,A),R(lt,A),R(Ut,A),R(it,A),R(Rt,A),R(rt,A),R(ut,A),R(yt,A)}}}const ml='{"title":"Introduction","local":"introduction","sections":[],"depth":1}';function gl(ve){return Vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends kl{constructor(V){super(),yl(this,V,gl,Gl,ul,{})}}export{Tl as component};
