import{s as Tl,n as bl,o as gl}from"../chunks/scheduler.65852ee5.js";import{S as fl,i as Il,g as o,s as n,r,A as Cl,h as i,f as l,c as a,j as Ul,u as p,x as M,k as dl,y as Zl,a as s,v as y,d as c,t as u,w as m}from"../chunks/index.aa74147d.js";import{D as Bl,C as w}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as J,E as vl}from"../chunks/EditOnGithub.4eda6a96.js";function Gl(_t){let j,Ce,fe,Ze,h,Be,U,ve,d,Nt='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Ge,T,Vt='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow"><strong>Transformers Agents</strong></a> to build awesome <strong>agents</strong>!',We,b,Qt="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",Ae,g,St='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',ke,f,$t='What is <strong>Transformers Agents</strong>? it’s an extension of our <code>transformers</code> library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">documentation</a>.',Re,I,Et="Let’s see how to use it, and which use cases it can solve.",_e,C,Xt="We install transformers agents from source since it has not been released as of writing, but later this week when it gets release you can simply install it with <code>pip install transformers[agents]</code>.",Ne,Z,Ve,B,Qe,v,Se,G,qt="For this use case, we want to show an agent that browses the web and is able to generate image.",$e,W,xt="To build it, we simply need to have two tools ready: image generation and web search.",Ee,A,Yt="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we load a LangChain tool.</li>",Xe,k,qe,R,Ht='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',xe,_,Ye,N,zt="Quick definition: Retrieval-Augmented-Generation (RAG) is <strong><em>“using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”.</em></strong>",He,V,Ft="This method has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",ze,Q,Lt="<li><p>Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong></p></li> <li><p>A frequent failure case of RAG is when the retrieval based on the user query does not return any relevant supporting documents. <strong>Is there a way to iterate by re-calling the retriever with a modified query in case the previous results were not relevant?</strong></p></li>",Fe,S,Pt="🔧 Well, we can solve the points above in a simple way: we will <strong>give our agent control over the retriever’s parameters!</strong>",Le,$,Kt="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",Pe,E,Ke,X,Dt="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",De,q,Oe,x,Ot="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",et,Y,el="We want our system to select only from the most relevant sources of information, depending on the query.",tt,H,tl="Our documentation pages come from the following sources:",lt,z,st,F,ll=`['evaluate', 'course', 'deep-rl-class', 'peft', 'hf-endpoints-documentation', 'blog', 'gradio', 'datasets', 'datasets-server', 'transformers', 'optimum', 'hub-docs', 'pytorch-image-models', 'diffusers']
`,nt,L,at,P,ot,K,sl="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",it,D,nl="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",Mt,O,rt,ee,pt,te,yt,le,al=`Final output:
https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image_lora.py
`,ct,se,ol="What happened here? First, the agent launched the retriever with specific sources in mind (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>).",ut,ne,il=`But this retrieval did not yield enough results ⇒ no problem! The agent could iterate on previous results, so it just re-ran its retrieval with less restrictive search parameters.
Thus the research was successful!`,mt,ae,Ml="Note that <strong>using an LLM agent</strong> that calls a retriever as a tool and can dynamically modify the query and other retrieval parameters <strong>is a more general formulation of RAG</strong>, which also covers many RAG improvement techniques like iterative query refinement.",wt,oe,jt,ie,rl="Since the ReactCodeAgent has an built int Python code interpreter, we can use it to debug our faulty Python script!",Jt,Me,ht,re,pl="As you can see, the agent tried the given code, gets an error, analyses the error, corrects the code and returns it after veryfing that it works!",Ut,pe,yl="And the final code is the corrected code:",dt,ye,Tt,ce,cl=`list=[0, 1, 2]

for i in range(4):
    print(list(i))
`,bt,ue,gt,me,ul=`It’s really easy to set up your own LLM engine:
it only needs a <code>__call__</code> method with these criteria:`,ft,we,ml='<li>Takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#introduction" rel="nofollow">ChatML format</a> and outputs the answer.</li> <li>Accepts a <code>stop_sequences</code> arguments to pass sequences on which generation stops.</li> <li>Depending on which kind of message roles your LLM accepts, you may also need to convert some message roles.</li>',It,je,Ct,Je,Zt,he,wl=`my_list = [0, 1, 2]  # Renamed the list to avoid using the built-in name

for i in range(len(my_list)):  # Changed the range to be within the length of the list
    print(my_list[i])  # Corrected the list access syntax
`,Bt,Ue,vt,de,jl="The use cases above should give you a glimpse into the possibilities of our Agents framework!",Gt,Te,Jl='For more advanced usage, read the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>, and <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">this experiment</a> that allowed us to build our own agent based on Llama-3-70B that beats many GPT-4 agents on the very difficult <a href="https://huggingface.co/spaces/gaia-benchmark/leaderboard" rel="nofollow">GAIA Leaderboard</a>!',Wt,be,hl="All feedback is welcome, it will help us improve the framework! 🚀",At,ge,kt,Ie,Rt;return h=new Bl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/restore-broken-link/notebooks/en/agents.ipynb"}]}}),U=new J({props:{title:"Build an agent with tool-calling superpowers 🦸 using Transformers Agents",local:"build-an-agent-with-tool-calling-superpowers--using-transformers-agents",headingTag:"h1"}}),Z=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlMjNlZ2clM0R0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;git+https://github.com/huggingface/transformers.git#egg=transformers[agents]&quot;</span>',wrap:!1}}),B=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMHNlcnBhcGklMjBnb29nbGUtc2VhcmNoLXJlc3VsdHMlMjBvcGVuYWklMjAtcQ==",highlighted:"!pip install datasets huggingface_hub langchain sentence-transformers faiss-cpu serpapi google-search-results openai -q",wrap:!1}}),v=new J({props:{title:"1. 🏞️ Multimodal + 🌐 Web-browsing assistant",local:"1--multimodal---web-browsing-assistant",headingTag:"h2"}}),k=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBsb2FkX3Rvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmRW5naW5lJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwTGFuZ0NoYWluJTBBZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZSglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwYWdlbnQlMjB3aXRoJTIwYm90aCUyMHRvb2xzJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBJTIzJTIwUnVuJTIwaXQhJTBBcmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkdlbmVyYXRlJTIwbWUlMjBhJTIwcGhvdG8lMjBvZiUyMHRoZSUyMGNhciUyMHRoYXQlMjBKYW1lcyUyMGJvbmQlMjBkcm92ZSUyMGluJTIwdGhlJTIwbGF0ZXN0JTIwbW92aWUuJTIyJTJDJTBBKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, ReactCodeAgent, HfEngine

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

<span class="hljs-comment"># Import tool from LangChain</span>
<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])


llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-comment"># Initialize the agent with both tools</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
)
result`,wrap:!1}}),_=new J({props:{title:"2. 📚💬 RAG with Iterative query refinement & Source selection",local:"2--rag-with-iterative-query-refinement--source-selection",headingTag:"h2"}}),E=new w({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),q=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),z=new w({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),L=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][
            <span class="hljs-string">&quot;description&quot;</span>
        ] = <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),P=new J({props:{title:"Optional: Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),O=new w({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwRmFsc2UlMEElMEFpZiUyMHNoYXJlX3RvX2h1YiUzQSUwQSUyMCUyMCUyMCUyMGZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBsb2dpbiUwQSUyMCUyMCUyMCUyMGZyb20lMjByZXRyaWV2ZXIlMjBpbXBvcnQlMjBSZXRyaWV2ZXJUb29sJTBBJTBBJTIwJTIwJTIwJTIwbG9naW4oJTIyeW91cl90b2tlbiUyMiklMEElMEElMjAlMjAlMjAlMjB0b29sJTIwJTNEJTIwUmV0cmlldmVyVG9vbCh2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wucHVzaF90b19odWIocmVwb19pZCUzRCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIp",highlighted:`share_to_hub = <span class="hljs-literal">False</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)`,wrap:!1}}),ee=new J({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),te=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTJDJTIwbG9hZF90b29sJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmRW5naW5lKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUwQSUwQXJldHJpZXZlcl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIlMkMlMjB2ZWN0b3JkYiUzRHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMlM0RhbGxfc291cmNlcyklMEFhZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUyMHZlcmJvc2UlM0QwKSUwQSUwQWFnZW50X291dHB1dCUyMCUzRCUyMGFnZW50LnJ1biglMjJQbGVhc2UlMjBzaG93JTIwbWUlMjBhJTIwTE9SQSUyMGZpbmV0dW5pbmclMjBzY3JpcHQlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactJsonAgent, load_tool

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),oe=new J({props:{title:"3. 💻 Debug Python code",local:"3--debug-python-code",headingTag:"h2"}}),Me=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCklMEElMEFjb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBbGlzdCUzRCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKDQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobGlzdChpKSklMEElMjIlMjIlMjIlMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdmUlMjBzb21lJTIwY29kZSUyMHRoYXQlMjBjcmVhdGVzJTIwYSUyMGJ1ZyUzQSUyMHBsZWFzZSUyMGRlYnVnJTIwaXQlMjBhbmQlMjByZXR1cm4lMjB0aGUlMjBmaW5hbCUyMGNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBjb2RlJTNEY29kZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),ye=new w({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),ue=new J({props:{title:"4. Create your own LLM engine (OpenAI)",local:"4-create-your-own-llm-engine-openai",headingTag:"h2"}}),je=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: <span class="hljs-string">&quot;user&quot;</span>,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o-2024-05-13&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


openai_engine = OpenAIEngine()
agent = ReactCodeAgent(llm_engine=openai_engine, tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),Je=new w({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),Ue=new J({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),ge=new vl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){j=o("meta"),Ce=n(),fe=o("p"),Ze=n(),r(h.$$.fragment),Be=n(),r(U.$$.fragment),ve=n(),d=o("p"),d.innerHTML=Nt,Ge=n(),T=o("p"),T.innerHTML=Vt,We=n(),b=o("p"),b.innerHTML=Qt,Ae=n(),g=o("p"),g.innerHTML=St,ke=n(),f=o("p"),f.innerHTML=$t,Re=n(),I=o("p"),I.textContent=Et,_e=n(),C=o("p"),C.innerHTML=Xt,Ne=n(),r(Z.$$.fragment),Ve=n(),r(B.$$.fragment),Qe=n(),r(v.$$.fragment),Se=n(),G=o("p"),G.textContent=qt,$e=n(),W=o("p"),W.textContent=xt,Ee=n(),A=o("ul"),A.innerHTML=Yt,Xe=n(),r(k.$$.fragment),qe=n(),R=o("p"),R.innerHTML=Ht,xe=n(),r(_.$$.fragment),Ye=n(),N=o("p"),N.innerHTML=zt,He=n(),V=o("p"),V.textContent=Ft,ze=n(),Q=o("ul"),Q.innerHTML=Lt,Fe=n(),S=o("p"),S.innerHTML=Pt,Le=n(),$=o("p"),$.innerHTML=Kt,Pe=n(),r(E.$$.fragment),Ke=n(),X=o("p"),X.textContent=Dt,De=n(),r(q.$$.fragment),Oe=n(),x=o("p"),x.textContent=Ot,et=n(),Y=o("p"),Y.textContent=el,tt=n(),H=o("p"),H.textContent=tl,lt=n(),r(z.$$.fragment),st=n(),F=o("pre"),F.textContent=ll,nt=n(),r(L.$$.fragment),at=n(),r(P.$$.fragment),ot=n(),K=o("p"),K.innerHTML=sl,it=n(),D=o("p"),D.innerHTML=nl,Mt=n(),r(O.$$.fragment),rt=n(),r(ee.$$.fragment),pt=n(),r(te.$$.fragment),yt=n(),le=o("pre"),le.textContent=al,ct=n(),se=o("p"),se.innerHTML=ol,ut=n(),ne=o("p"),ne.textContent=il,mt=n(),ae=o("p"),ae.innerHTML=Ml,wt=n(),r(oe.$$.fragment),jt=n(),ie=o("p"),ie.textContent=rl,Jt=n(),r(Me.$$.fragment),ht=n(),re=o("p"),re.textContent=pl,Ut=n(),pe=o("p"),pe.textContent=yl,dt=n(),r(ye.$$.fragment),Tt=n(),ce=o("pre"),ce.textContent=cl,bt=n(),r(ue.$$.fragment),gt=n(),me=o("p"),me.innerHTML=ul,ft=n(),we=o("ol"),we.innerHTML=ml,It=n(),r(je.$$.fragment),Ct=n(),r(Je.$$.fragment),Zt=n(),he=o("pre"),he.textContent=wl,Bt=n(),r(Ue.$$.fragment),vt=n(),de=o("p"),de.textContent=jl,Gt=n(),Te=o("p"),Te.innerHTML=Jl,Wt=n(),be=o("p"),be.textContent=hl,At=n(),r(ge.$$.fragment),kt=n(),Ie=o("p"),this.h()},l(e){const t=Cl("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ce=a(e),fe=i(e,"P",{}),Ul(fe).forEach(l),Ze=a(e),p(h.$$.fragment,e),Be=a(e),p(U.$$.fragment,e),ve=a(e),d=i(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1xlqnsv"&&(d.innerHTML=Nt),Ge=a(e),T=i(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-qt5igr"&&(T.innerHTML=Vt),We=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1mh34dv"&&(b.innerHTML=Qt),Ae=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-mmy9qo"&&(g.innerHTML=St),ke=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-176yg59"&&(f.innerHTML=$t),Re=a(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-fc6q9b"&&(I.textContent=Et),_e=a(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-psgh4s"&&(C.innerHTML=Xt),Ne=a(e),p(Z.$$.fragment,e),Ve=a(e),p(B.$$.fragment,e),Qe=a(e),p(v.$$.fragment,e),Se=a(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1354tpb"&&(G.textContent=qt),$e=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1yb5yrl"&&(W.textContent=xt),Ee=a(e),A=i(e,"UL",{"data-svelte-h":!0}),M(A)!=="svelte-1dqrk95"&&(A.innerHTML=Yt),Xe=a(e),p(k.$$.fragment,e),qe=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1hg95q8"&&(R.innerHTML=Ht),xe=a(e),p(_.$$.fragment,e),Ye=a(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1wknlb6"&&(N.innerHTML=zt),He=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-19h5931"&&(V.textContent=Ft),ze=a(e),Q=i(e,"UL",{"data-svelte-h":!0}),M(Q)!=="svelte-5uub6"&&(Q.innerHTML=Lt),Fe=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1kfx2et"&&(S.innerHTML=Pt),Le=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1qw64fs"&&($.innerHTML=Kt),Pe=a(e),p(E.$$.fragment,e),Ke=a(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-jy4i2f"&&(X.textContent=Dt),De=a(e),p(q.$$.fragment,e),Oe=a(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-5pp8py"&&(x.textContent=Ot),et=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1cx88lu"&&(Y.textContent=el),tt=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1vgfwws"&&(H.textContent=tl),lt=a(e),p(z.$$.fragment,e),st=a(e),F=i(e,"PRE",{"data-svelte-h":!0}),M(F)!=="svelte-87x3d8"&&(F.textContent=ll),nt=a(e),p(L.$$.fragment,e),at=a(e),p(P.$$.fragment,e),ot=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-19hckuz"&&(K.innerHTML=sl),it=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1wpkyax"&&(D.innerHTML=nl),Mt=a(e),p(O.$$.fragment,e),rt=a(e),p(ee.$$.fragment,e),pt=a(e),p(te.$$.fragment,e),yt=a(e),le=i(e,"PRE",{"data-svelte-h":!0}),M(le)!=="svelte-l44zt6"&&(le.textContent=al),ct=a(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-6d9ubm"&&(se.innerHTML=ol),ut=a(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-ud3g55"&&(ne.textContent=il),mt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-3qqlok"&&(ae.innerHTML=Ml),wt=a(e),p(oe.$$.fragment,e),jt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-3y19vc"&&(ie.textContent=rl),Jt=a(e),p(Me.$$.fragment,e),ht=a(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-168ebuv"&&(re.textContent=pl),Ut=a(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-vscncs"&&(pe.textContent=yl),dt=a(e),p(ye.$$.fragment,e),Tt=a(e),ce=i(e,"PRE",{"data-svelte-h":!0}),M(ce)!=="svelte-1t45l4d"&&(ce.textContent=cl),bt=a(e),p(ue.$$.fragment,e),gt=a(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-6gn5q5"&&(me.innerHTML=ul),ft=a(e),we=i(e,"OL",{"data-svelte-h":!0}),M(we)!=="svelte-1o7lqh"&&(we.innerHTML=ml),It=a(e),p(je.$$.fragment,e),Ct=a(e),p(Je.$$.fragment,e),Zt=a(e),he=i(e,"PRE",{"data-svelte-h":!0}),M(he)!=="svelte-tgqz6q"&&(he.textContent=wl),Bt=a(e),p(Ue.$$.fragment,e),vt=a(e),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-hpfue3"&&(de.textContent=jl),Gt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1nxb7v"&&(Te.innerHTML=Jl),Wt=a(e),be=i(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1ctcozl"&&(be.textContent=hl),At=a(e),p(ge.$$.fragment,e),kt=a(e),Ie=i(e,"P",{}),Ul(Ie).forEach(l),this.h()},h(){dl(j,"name","hf:doc:metadata"),dl(j,"content",Wl)},m(e,t){Zl(document.head,j),s(e,Ce,t),s(e,fe,t),s(e,Ze,t),y(h,e,t),s(e,Be,t),y(U,e,t),s(e,ve,t),s(e,d,t),s(e,Ge,t),s(e,T,t),s(e,We,t),s(e,b,t),s(e,Ae,t),s(e,g,t),s(e,ke,t),s(e,f,t),s(e,Re,t),s(e,I,t),s(e,_e,t),s(e,C,t),s(e,Ne,t),y(Z,e,t),s(e,Ve,t),y(B,e,t),s(e,Qe,t),y(v,e,t),s(e,Se,t),s(e,G,t),s(e,$e,t),s(e,W,t),s(e,Ee,t),s(e,A,t),s(e,Xe,t),y(k,e,t),s(e,qe,t),s(e,R,t),s(e,xe,t),y(_,e,t),s(e,Ye,t),s(e,N,t),s(e,He,t),s(e,V,t),s(e,ze,t),s(e,Q,t),s(e,Fe,t),s(e,S,t),s(e,Le,t),s(e,$,t),s(e,Pe,t),y(E,e,t),s(e,Ke,t),s(e,X,t),s(e,De,t),y(q,e,t),s(e,Oe,t),s(e,x,t),s(e,et,t),s(e,Y,t),s(e,tt,t),s(e,H,t),s(e,lt,t),y(z,e,t),s(e,st,t),s(e,F,t),s(e,nt,t),y(L,e,t),s(e,at,t),y(P,e,t),s(e,ot,t),s(e,K,t),s(e,it,t),s(e,D,t),s(e,Mt,t),y(O,e,t),s(e,rt,t),y(ee,e,t),s(e,pt,t),y(te,e,t),s(e,yt,t),s(e,le,t),s(e,ct,t),s(e,se,t),s(e,ut,t),s(e,ne,t),s(e,mt,t),s(e,ae,t),s(e,wt,t),y(oe,e,t),s(e,jt,t),s(e,ie,t),s(e,Jt,t),y(Me,e,t),s(e,ht,t),s(e,re,t),s(e,Ut,t),s(e,pe,t),s(e,dt,t),y(ye,e,t),s(e,Tt,t),s(e,ce,t),s(e,bt,t),y(ue,e,t),s(e,gt,t),s(e,me,t),s(e,ft,t),s(e,we,t),s(e,It,t),y(je,e,t),s(e,Ct,t),y(Je,e,t),s(e,Zt,t),s(e,he,t),s(e,Bt,t),y(Ue,e,t),s(e,vt,t),s(e,de,t),s(e,Gt,t),s(e,Te,t),s(e,Wt,t),s(e,be,t),s(e,At,t),y(ge,e,t),s(e,kt,t),s(e,Ie,t),Rt=!0},p:bl,i(e){Rt||(c(h.$$.fragment,e),c(U.$$.fragment,e),c(Z.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(_.$$.fragment,e),c(E.$$.fragment,e),c(q.$$.fragment,e),c(z.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(ue.$$.fragment,e),c(je.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(ge.$$.fragment,e),Rt=!0)},o(e){u(h.$$.fragment,e),u(U.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(E.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(ue.$$.fragment,e),u(je.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(ge.$$.fragment,e),Rt=!1},d(e){e&&(l(Ce),l(fe),l(Ze),l(Be),l(ve),l(d),l(Ge),l(T),l(We),l(b),l(Ae),l(g),l(ke),l(f),l(Re),l(I),l(_e),l(C),l(Ne),l(Ve),l(Qe),l(Se),l(G),l($e),l(W),l(Ee),l(A),l(Xe),l(qe),l(R),l(xe),l(Ye),l(N),l(He),l(V),l(ze),l(Q),l(Fe),l(S),l(Le),l($),l(Pe),l(Ke),l(X),l(De),l(Oe),l(x),l(et),l(Y),l(tt),l(H),l(lt),l(st),l(F),l(nt),l(at),l(ot),l(K),l(it),l(D),l(Mt),l(rt),l(pt),l(yt),l(le),l(ct),l(se),l(ut),l(ne),l(mt),l(ae),l(wt),l(jt),l(ie),l(Jt),l(ht),l(re),l(Ut),l(pe),l(dt),l(Tt),l(ce),l(bt),l(gt),l(me),l(ft),l(we),l(It),l(Ct),l(Zt),l(he),l(Bt),l(vt),l(de),l(Gt),l(Te),l(Wt),l(be),l(At),l(kt),l(Ie)),l(j),m(h,e),m(U,e),m(Z,e),m(B,e),m(v,e),m(k,e),m(_,e),m(E,e),m(q,e),m(z,e),m(L,e),m(P,e),m(O,e),m(ee,e),m(te,e),m(oe,e),m(Me,e),m(ye,e),m(ue,e),m(je,e),m(Je,e),m(Ue,e),m(ge,e)}}}const Wl='{"title":"Build an agent with tool-calling superpowers 🦸 using Transformers Agents","local":"build-an-agent-with-tool-calling-superpowers--using-transformers-agents","sections":[{"title":"1. 🏞️ Multimodal + 🌐 Web-browsing assistant","local":"1--multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"2. 📚💬 RAG with Iterative query refinement & Source selection","local":"2--rag-with-iterative-query-refinement--source-selection","sections":[{"title":"Optional: Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Debug Python code","local":"3--debug-python-code","sections":[],"depth":2},{"title":"4. Create your own LLM engine (OpenAI)","local":"4-create-your-own-llm-engine-openai","sections":[],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function Al(_t){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends fl{constructor(j){super(),Il(this,j,Al,Gl,Tl,{})}}export{Vl as component};
