import{s as Wt,o as Zt,n as _t}from"../chunks/scheduler.37c15a92.js";import{S as Rt,i as Ct,g as i,s as n,r as d,A as Ht,h as o,f as l,c as s,j as kt,u as c,x as p,k as Ut,y as It,a,v as m,d as h,t as u,w as f}from"../chunks/index.2bf4358c.js";import{T as Gt}from"../chunks/Tip.363c041f.js";import{Y as Ft}from"../chunks/Youtube.1e50a667.js";import{C as w}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Et}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{F as xt}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as tt,E as zt}from"../chunks/EditOnGithub.8916dc7c.js";function Xt(j){let r,b='💡 If you want to automatically upload your model to the Hub during training, pass along <code>push_to_hub=True</code> in the <code>TrainingArguments</code>. We will learn more about this in <a href="/course/chapter4/3">Chapter 4</a>';return{c(){r=i("p"),r.innerHTML=b},l(M){r=o(M,"P",{"data-svelte-h":!0}),p(r)!=="svelte-zad74h"&&(r.innerHTML=b)},m(M,y){a(M,r,y)},p:_t,d(M){M&&l(r)}}}function Vt(j){let r,b="✏️ <strong>Try it out!</strong> Fine-tune a model on the GLUE SST-2 dataset, using the data processing you did in section 2.";return{c(){r=i("p"),r.innerHTML=b},l(M){r=o(M,"P",{"data-svelte-h":!0}),p(r)!=="svelte-l3p571"&&(r.innerHTML=b)},m(M,y){a(M,r,y)},p:_t,d(M){M&&l(r)}}}function Bt(j){let r,b,M,y,T,ce,J,me,v,he,k,ue,U,lt='🤗 Transformers provides a <code>Trainer</code> class to help you fine-tune any of the pretrained models it provides on your dataset. Once you’ve done all the data preprocessing work in the last section, you have just a few steps left to define the <code>Trainer</code>. The hardest part is likely to be preparing the environment to run <code>Trainer.train()</code>, as it will run very slowly on a CPU. If you don’t have a GPU set up, you can get access to free GPUs or TPUs on <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',fe,G,at="The code examples below assume you have already executed the examples in the previous section. Here is a short summary recapping what you need:",Me,_,we,W,be,Z,nt="The first step before we can define our <code>Trainer</code> is to define a <code>TrainingArguments</code> class that will contain all the hyperparameters the <code>Trainer</code> will use for training and evaluation. The only argument you have to provide is a directory where the trained model will be saved, as well as the checkpoints along the way. For all the rest, you can leave the defaults, which should work pretty well for a basic fine-tuning.",ye,R,Te,g,ge,C,st='The second step is to define our model. As in the <a href="/course/chapter2">previous chapter</a>, we will use the <code>AutoModelForSequenceClassification</code> class, with two labels:',$e,H,je,I,it='You will notice that unlike in <a href="/course/chapter2">Chapter 2</a>, you get a warning after instantiating this pretrained model. This is because BERT has not been pretrained on classifying pairs of sentences, so the head of the pretrained model has been discarded and a new head suitable for sequence classification has been added instead. The warnings indicate that some weights were not used (the ones corresponding to the dropped pretraining head) and that some others were randomly initialized (the ones for the new head). It concludes by encouraging you to train the model, which is exactly what we are going to do now.',Je,F,ot="Once we have our model, we can define a <code>Trainer</code> by passing it all the objects constructed up to now — the <code>model</code>, the <code>training_args</code>, the training and validation datasets, our <code>data_collator</code>, and our <code>tokenizer</code>:",ve,E,ke,x,rt="Note that when you pass the <code>tokenizer</code> as we did here, the default <code>data_collator</code> used by the <code>Trainer</code> will be a <code>DataCollatorWithPadding</code> as defined previously, so you can skip the line <code>data_collator=data_collator</code> in this call. It was still important to show you this part of the processing in section 2!",Ue,z,pt="To fine-tune the model on our dataset, we just have to call the <code>train()</code> method of our <code>Trainer</code>:",Ge,X,_e,V,dt="This will start the fine-tuning (which should take a couple of minutes on a GPU) and report the training loss every 500 steps. It won’t, however, tell you how well (or badly) your model is performing. This is because:",We,B,ct="<li>We didn’t tell the <code>Trainer</code> to evaluate during training by setting <code>evaluation_strategy</code> to either <code>&quot;steps&quot;</code> (evaluate every <code>eval_steps</code>) or <code>&quot;epoch&quot;</code> (evaluate at the end of each epoch).</li> <li>We didn’t provide the <code>Trainer</code> with a <code>compute_metrics()</code> function to calculate a metric during said evaluation (otherwise the evaluation would just have printed the loss, which is not a very intuitive number).</li>",Ze,Y,Re,A,mt="Let’s see how we can build a useful <code>compute_metrics()</code> function and use it the next time we train. The function must take an <code>EvalPrediction</code> object (which is a named tuple with a <code>predictions</code> field and a <code>label_ids</code> field) and will return a dictionary mapping strings to floats (the strings being the names of the metrics returned, and the floats their values). To get some predictions from our model, we can use the <code>Trainer.predict()</code> command:",Ce,N,He,L,Ie,Q,ht="The output of the <code>predict()</code> method is another named tuple with three fields: <code>predictions</code>, <code>label_ids</code>, and <code>metrics</code>. The <code>metrics</code> field will just contain the loss on the dataset passed, as well as some time metrics (how long it took to predict, in total and on average). Once we complete our <code>compute_metrics()</code> function and pass it to the <code>Trainer</code>, that field will also contain the metrics returned by <code>compute_metrics()</code>.",Fe,q,ut='As you can see, <code>predictions</code> is a two-dimensional array with shape 408 x 2 (408 being the number of elements in the dataset we used). Those are the logits for each element of the dataset we passed to <code>predict()</code> (as you saw in the <a href="/course/chapter2">previous chapter</a>, all Transformer models return logits). To transform them into predictions that we can compare to our labels, we need to take the index with the maximum value on the second axis:',Ee,P,xe,S,ft='We can now compare those <code>preds</code> to the labels. To build our <code>compute_metric()</code> function, we will rely on the metrics from the 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> library. We can load the metrics associated with the MRPC dataset as easily as we loaded the dataset, this time with the <code>evaluate.load()</code> function. The object returned has a <code>compute()</code> method we can use to do the metric calculation:',ze,K,Xe,D,Ve,O,Mt='The exact results you get may vary, as the random initialization of the model head might change the metrics it achieved. Here, we can see our model has an accuracy of 85.78% on the validation set and an F1 score of 89.97. Those are the two metrics used to evaluate results on the MRPC dataset for the GLUE benchmark. The table in the <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT paper</a> reported an F1 score of 88.9 for the base model. That was the <code>uncased</code> model while we are currently using the <code>cased</code> model, which explains the better result.',Be,ee,wt="Wrapping everything together, we get our <code>compute_metrics()</code> function:",Ye,te,Ae,le,bt="And to see it used in action to report metrics at the end of each epoch, here is how we define a new <code>Trainer</code> with this <code>compute_metrics()</code> function:",Ne,ae,Le,ne,yt="Note that we create a new <code>TrainingArguments</code> with its <code>evaluation_strategy</code> set to <code>&quot;epoch&quot;</code> and a new model — otherwise, we would just be continuing the training of the model we have already trained. To launch a new training run, we execute:",Qe,se,qe,ie,Tt="This time, it will report the validation loss and metrics at the end of each epoch on top of the training loss. Again, the exact accuracy/F1 score you reach might be a bit different from what we found, because of the random head initialization of the model, but it should be in the same ballpark.",Pe,oe,gt="The <code>Trainer</code> will work out of the box on multiple GPUs or TPUs and provides lots of options, like mixed-precision training (use <code>fp16 = True</code> in your training arguments). We will go over everything it supports in Chapter 10.",Se,re,$t='This concludes the introduction to fine-tuning using the <code>Trainer</code> API. An example of doing this for most common NLP tasks will be given in <a href="/course/chapter7">Chapter 7</a>, but for now let’s look at how to do the same thing in pure PyTorch.',Ke,$,De,pe,Oe,de,et;return T=new xt({props:{fw:j[0]}}),J=new tt({props:{title:"Fine-tuning a model with the Trainer API",local:"fine-tuning-a-model-with-the-trainer-api",headingTag:"h1"}}),v=new Et({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"}]}}),k=new Ft({props:{id:"nvBXf7s7vTI"}}),_=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),W=new tt({props:{title:"Training",local:"training",headingTag:"h3"}}),R=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),g=new Gt({props:{$$slots:{default:[Xt]},$$scope:{ctx:j}}}),H=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),X=new w({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),Y=new tt({props:{title:"Evaluation",local:"evaluation",headingTag:"h3"}}),N=new w({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),L=new w({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),P=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),K=new w({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),D=new w({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),te=new w({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),ae=new w({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),se=new w({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),$=new Gt({props:{$$slots:{default:[Vt]},$$scope:{ctx:j}}}),pe=new zt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter3/3.mdx"}}),{c(){r=i("meta"),b=n(),M=i("p"),y=n(),d(T.$$.fragment),ce=n(),d(J.$$.fragment),me=n(),d(v.$$.fragment),he=n(),d(k.$$.fragment),ue=n(),U=i("p"),U.innerHTML=lt,fe=n(),G=i("p"),G.textContent=at,Me=n(),d(_.$$.fragment),we=n(),d(W.$$.fragment),be=n(),Z=i("p"),Z.innerHTML=nt,ye=n(),d(R.$$.fragment),Te=n(),d(g.$$.fragment),ge=n(),C=i("p"),C.innerHTML=st,$e=n(),d(H.$$.fragment),je=n(),I=i("p"),I.innerHTML=it,Je=n(),F=i("p"),F.innerHTML=ot,ve=n(),d(E.$$.fragment),ke=n(),x=i("p"),x.innerHTML=rt,Ue=n(),z=i("p"),z.innerHTML=pt,Ge=n(),d(X.$$.fragment),_e=n(),V=i("p"),V.textContent=dt,We=n(),B=i("ol"),B.innerHTML=ct,Ze=n(),d(Y.$$.fragment),Re=n(),A=i("p"),A.innerHTML=mt,Ce=n(),d(N.$$.fragment),He=n(),d(L.$$.fragment),Ie=n(),Q=i("p"),Q.innerHTML=ht,Fe=n(),q=i("p"),q.innerHTML=ut,Ee=n(),d(P.$$.fragment),xe=n(),S=i("p"),S.innerHTML=ft,ze=n(),d(K.$$.fragment),Xe=n(),d(D.$$.fragment),Ve=n(),O=i("p"),O.innerHTML=Mt,Be=n(),ee=i("p"),ee.innerHTML=wt,Ye=n(),d(te.$$.fragment),Ae=n(),le=i("p"),le.innerHTML=bt,Ne=n(),d(ae.$$.fragment),Le=n(),ne=i("p"),ne.innerHTML=yt,Qe=n(),d(se.$$.fragment),qe=n(),ie=i("p"),ie.textContent=Tt,Pe=n(),oe=i("p"),oe.innerHTML=gt,Se=n(),re=i("p"),re.innerHTML=$t,Ke=n(),d($.$$.fragment),De=n(),d(pe.$$.fragment),Oe=n(),de=i("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),b=s(e),M=o(e,"P",{}),kt(M).forEach(l),y=s(e),c(T.$$.fragment,e),ce=s(e),c(J.$$.fragment,e),me=s(e),c(v.$$.fragment,e),he=s(e),c(k.$$.fragment,e),ue=s(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-fvu6dq"&&(U.innerHTML=lt),fe=s(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1r8y7hl"&&(G.textContent=at),Me=s(e),c(_.$$.fragment,e),we=s(e),c(W.$$.fragment,e),be=s(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-bcd3tt"&&(Z.innerHTML=nt),ye=s(e),c(R.$$.fragment,e),Te=s(e),c(g.$$.fragment,e),ge=s(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-14s2mi5"&&(C.innerHTML=st),$e=s(e),c(H.$$.fragment,e),je=s(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1q6lkxd"&&(I.innerHTML=it),Je=s(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-t218v5"&&(F.innerHTML=ot),ve=s(e),c(E.$$.fragment,e),ke=s(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1jzvhpj"&&(x.innerHTML=rt),Ue=s(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-2dkplj"&&(z.innerHTML=pt),Ge=s(e),c(X.$$.fragment,e),_e=s(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1u04gyz"&&(V.textContent=dt),We=s(e),B=o(e,"OL",{"data-svelte-h":!0}),p(B)!=="svelte-p9qxvg"&&(B.innerHTML=ct),Ze=s(e),c(Y.$$.fragment,e),Re=s(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-h6pdaj"&&(A.innerHTML=mt),Ce=s(e),c(N.$$.fragment,e),He=s(e),c(L.$$.fragment,e),Ie=s(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1jbqb9m"&&(Q.innerHTML=ht),Fe=s(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-w5buv0"&&(q.innerHTML=ut),Ee=s(e),c(P.$$.fragment,e),xe=s(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1xta58a"&&(S.innerHTML=ft),ze=s(e),c(K.$$.fragment,e),Xe=s(e),c(D.$$.fragment,e),Ve=s(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-59ywn7"&&(O.innerHTML=Mt),Be=s(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1ti0nhg"&&(ee.innerHTML=wt),Ye=s(e),c(te.$$.fragment,e),Ae=s(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-yza6x"&&(le.innerHTML=bt),Ne=s(e),c(ae.$$.fragment,e),Le=s(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-yel3jk"&&(ne.innerHTML=yt),Qe=s(e),c(se.$$.fragment,e),qe=s(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-18ebo35"&&(ie.textContent=Tt),Pe=s(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-ws0acz"&&(oe.innerHTML=gt),Se=s(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-10go40k"&&(re.innerHTML=$t),Ke=s(e),c($.$$.fragment,e),De=s(e),c(pe.$$.fragment,e),Oe=s(e),de=o(e,"P",{}),kt(de).forEach(l),this.h()},h(){Ut(r,"name","hf:doc:metadata"),Ut(r,"content",Yt)},m(e,t){It(document.head,r),a(e,b,t),a(e,M,t),a(e,y,t),m(T,e,t),a(e,ce,t),m(J,e,t),a(e,me,t),m(v,e,t),a(e,he,t),m(k,e,t),a(e,ue,t),a(e,U,t),a(e,fe,t),a(e,G,t),a(e,Me,t),m(_,e,t),a(e,we,t),m(W,e,t),a(e,be,t),a(e,Z,t),a(e,ye,t),m(R,e,t),a(e,Te,t),m(g,e,t),a(e,ge,t),a(e,C,t),a(e,$e,t),m(H,e,t),a(e,je,t),a(e,I,t),a(e,Je,t),a(e,F,t),a(e,ve,t),m(E,e,t),a(e,ke,t),a(e,x,t),a(e,Ue,t),a(e,z,t),a(e,Ge,t),m(X,e,t),a(e,_e,t),a(e,V,t),a(e,We,t),a(e,B,t),a(e,Ze,t),m(Y,e,t),a(e,Re,t),a(e,A,t),a(e,Ce,t),m(N,e,t),a(e,He,t),m(L,e,t),a(e,Ie,t),a(e,Q,t),a(e,Fe,t),a(e,q,t),a(e,Ee,t),m(P,e,t),a(e,xe,t),a(e,S,t),a(e,ze,t),m(K,e,t),a(e,Xe,t),m(D,e,t),a(e,Ve,t),a(e,O,t),a(e,Be,t),a(e,ee,t),a(e,Ye,t),m(te,e,t),a(e,Ae,t),a(e,le,t),a(e,Ne,t),m(ae,e,t),a(e,Le,t),a(e,ne,t),a(e,Qe,t),m(se,e,t),a(e,qe,t),a(e,ie,t),a(e,Pe,t),a(e,oe,t),a(e,Se,t),a(e,re,t),a(e,Ke,t),m($,e,t),a(e,De,t),m(pe,e,t),a(e,Oe,t),a(e,de,t),et=!0},p(e,[t]){const jt={};t&1&&(jt.fw=e[0]),T.$set(jt);const Jt={};t&2&&(Jt.$$scope={dirty:t,ctx:e}),g.$set(Jt);const vt={};t&2&&(vt.$$scope={dirty:t,ctx:e}),$.$set(vt)},i(e){et||(h(T.$$.fragment,e),h(J.$$.fragment,e),h(v.$$.fragment,e),h(k.$$.fragment,e),h(_.$$.fragment,e),h(W.$$.fragment,e),h(R.$$.fragment,e),h(g.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(L.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(D.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h($.$$.fragment,e),h(pe.$$.fragment,e),et=!0)},o(e){u(T.$$.fragment,e),u(J.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(g.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(N.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u($.$$.fragment,e),u(pe.$$.fragment,e),et=!1},d(e){e&&(l(b),l(M),l(y),l(ce),l(me),l(he),l(ue),l(U),l(fe),l(G),l(Me),l(we),l(be),l(Z),l(ye),l(Te),l(ge),l(C),l($e),l(je),l(I),l(Je),l(F),l(ve),l(ke),l(x),l(Ue),l(z),l(Ge),l(_e),l(V),l(We),l(B),l(Ze),l(Re),l(A),l(Ce),l(He),l(Ie),l(Q),l(Fe),l(q),l(Ee),l(xe),l(S),l(ze),l(Xe),l(Ve),l(O),l(Be),l(ee),l(Ye),l(Ae),l(le),l(Ne),l(Le),l(ne),l(Qe),l(qe),l(ie),l(Pe),l(oe),l(Se),l(re),l(Ke),l(De),l(Oe),l(de)),l(r),f(T,e),f(J,e),f(v,e),f(k,e),f(_,e),f(W,e),f(R,e),f(g,e),f(H,e),f(E,e),f(X,e),f(Y,e),f(N,e),f(L,e),f(P,e),f(K,e),f(D,e),f(te,e),f(ae,e),f(se,e),f($,e),f(pe,e)}}}const Yt='{"title":"Fine-tuning a model with the Trainer API","local":"fine-tuning-a-model-with-the-trainer-api","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Evaluation","local":"evaluation","sections":[],"depth":3}],"depth":1}';function At(j,r,b){let M="pt";return Zt(()=>{const y=new URLSearchParams(window.location.search);b(0,M=y.get("fw")||"pt")}),[M]}class Ot extends Rt{constructor(r){super(),Ct(this,r,At,Bt,Wt,{})}}export{Ot as component};
