import{s as Je,f as $e,o as _e,n as Ae}from"../chunks/scheduler.f6b352c8.js";import{S as Ie,i as ke,g as i,s as l,r as g,A as Se,h as o,f as n,c as a,j as je,u as y,x as r,k as st,y as Be,a as s,v as w,d as C,t as v,w as T,m as He,n as Ze}from"../chunks/index.7f38e934.js";import{T as Pe}from"../chunks/Tip.ae532637.js";import{C as be}from"../chunks/CodeBlock.2a338b68.js";import{H as zt}from"../chunks/Heading.333929c4.js";import{E as Le}from"../chunks/EditOnGithub.c3245a01.js";function Ee(at){let p,u,d="We’ll cover how actions are represented (using JSON or code), the importance of the stop and parse approach, and introduce different types of agents.";return{c(){p=He(`In this section, we explore the concrete steps an AI agent takes to interact with its environment. 
`),u=i("p"),u.textContent=d},l(c){p=Ze(c,`In this section, we explore the concrete steps an AI agent takes to interact with its environment. 
`),u=o(c,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1st7yzx"&&(u.textContent=d)},m(c,h){s(c,p,h),s(c,u,h)},p:Ae,d(c){c&&(n(p),n(u))}}}function Ge(at){let p,u,d,c,h,it,m,ot,x,Qt="Actions are the concrete steps an <strong>AI agent takes to interact with its environment</strong>.",rt,U,Xt="Whether it’s browsing the web for information or controlling a physical device, each action is a deliberate operation executed by the agent.",pt,j,Yt="For example, an agent assisting with customer service might retrieve customer data, offer support articles, or transfer issues to a human representative.",ut,b,ct,J,Ot="There is multiple types of Agents, that take actions differently:",ht,$,Dt="<thead><tr><th>Type of Agent</th> <th>Description</th></tr></thead> <tbody><tr><td>JSON Agent</td> <td>The Action to take is specified as in JSON format</td></tr> <tr><td>Code Agent</td> <td>The Agents writes a code bloc that is interpreted externally</td></tr> <tr><td>Function-calling Agent</td> <td>It is a subcategory of the JSON Agent which has been fine-tuned to generate a new message for each action</td></tr></tbody>",dt,_,Kt="Actions themselves can serve many purposes:",mt,A,te="<thead><tr><th>Type of Action</th> <th>Description</th></tr></thead> <tbody><tr><td>Information Gathering</td> <td>Performing web searches, querying databases, or retrieving documents.</td></tr> <tr><td>Tool Usage</td> <td>Making API calls, running calculations, and executing code.</td></tr> <tr><td>Environment Interaction</td> <td>Manipulating digital interfaces or controlling physical devices.</td></tr> <tr><td>Communication</td> <td>Engaging with users via chat or collaborating with other agents.</td></tr></tbody>",ft,I,ee="One crucial part of an agent is the <strong>ability to STOP generating new tokens when an action is complete</strong>, and that is true for all formats of Agent; JSON, code, or function-calling. This prevents unintended output and ensures that the agent’s response is clear and precise.",Mt,k,ne="The LLM only handles text, and uses it to describe the action it wants to take and the parameters to supply to the tool.",gt,S,yt,B,se="One key method for implementing actions is the <strong>stop and parse approach</strong>. This method ensures that the agent’s output is structured and predictable:",wt,H,le="<li><strong>Generation in a Structured Format</strong>:</li>",Ct,Z,ae="The agent outputs its intended action in a clear, predetermined format (JSON or code).",vt,f,ie="<li><strong>Halting Further Generation</strong>:</li>",Tt,P,oe="Once the action is complete, <strong>the agent stops generating additional tokens</strong>. This prevents extra or erroneous output.",xt,M,re="<li><strong>Parsing the Output</strong>:</li>",Ut,L,pe="An external parser reads the formatted action, determines which Tool to call, and extracts the required parameters.",jt,E,ue="For example, an agent needing to check the weather might output:",bt,G,Jt,q,ce="This clear, machine-readable format minimizes errors and enables external tools to accurately process the agent’s command.",$t,W,he=`Note: Function-calling agents operate similarly by structuring each action so that a designated function is invoked with the correct arguments.
We’ll dive deeper into that type of Agents in a future Unit.`,_t,F,At,N,de=`An alternative approach is using <em>Code Agents</em>.
The idea is: <strong>instead of outputting a simple JSON object</strong>, a Code Agent generates an <strong>executable code block—typically in a high-level language like Python</strong>.`,It,R,me,kt,V,fe="This approach offers several advantages:",St,z,Me="<li><strong>Expressiveness:</strong> Code can naturally represent complex logic, including loops, conditionals, and nested functions, providing greater flexibility than JSON.</li> <li><strong>Modularity and Reusability:</strong> Generated code can include functions and modules that are reusable across different actions or tasks.</li> <li><strong>Enhanced Debuggability:</strong> With a well-defined programming syntax, code errors are often easier to detect and correct.</li> <li><strong>Direct Integration:</strong> Code Agents can integrate directly with external libraries and APIs, enabling more complex operations such as data processing or real-time decision making.</li>",Bt,Q,ge="For example, a Code Agent tasked with fetching the weather might generate the following Python snippet:",Ht,X,Zt,Y,ye="In this example, the Code Agent:",Pt,O,we="<li>Retrieves weather data <strong>via an API call</strong>,</li> <li>Processes the response,</li> <li>And uses the print() function to output a final answer.</li>",Lt,D,Ce="This method <strong>also follows the stop and parse approach</strong> by clearly delimiting the code block and signaling when execution is complete (here, by printing the final_answer).",Et,Gt,qt,K,ve="We learned that Actions bridge an agent’s internal reasoning and its real-world interactions by executing clear, structured tasks—whether through JSON, code, or function calls.",Wt,tt,Te="This deliberate execution ensures that each action is precise and ready for external processing via the stop and parse approach. In the next section, we will explore Observations to see how agents capture and integrate feedback from their environment.",Ft,et,xe="After this, we will <strong>be finally ready to build our first Agent!</strong>",Nt,nt,Rt,lt,Vt;return h=new zt({props:{title:"Actions:  Enabling the Agent to Engage with Its Environment",local:"actions-enabling-the-agent-to-engage-with-its-environment",headingTag:"h1"}}),m=new Pe({props:{$$slots:{default:[Ee]},$$scope:{ctx:at}}}),b=new zt({props:{title:"Types of Agent Actions",local:"types-of-agent-actions",headingTag:"h2"}}),S=new zt({props:{title:"The Stop and Parse Approach",local:"the-stop-and-parse-approach",headingTag:"h2"}}),G=new be({props:{code:"JTdCJTBBJTIwJTIwJTIydGhvdWdodCUyMiUzQSUyMCUyMkklMjBuZWVkJTIwdG8lMjBjaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwZm9yJTIwTmV3JTIwWW9yay4lMjIlMkMlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;thought&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;I need to check the current weather for New York.&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),F=new zt({props:{title:"Code Agents",local:"code-agents",headingTag:"h2"}}),X=new be({props:{code:"JTIzJTIwQ29kZSUyMEFnZW50JTIwRXhhbXBsZSUzQSUyMFJldHJpZXZlJTIwV2VhdGhlciUyMEluZm9ybWF0aW9uJTBBZGVmJTIwZ2V0X3dlYXRoZXIoY2l0eSklM0ElMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlMjAlM0QlMjBmJTIyaHR0cHMlM0ElMkYlMkZhcGkud2VhdGhlci5jb20lMkZ2MSUyRmxvY2F0aW9uJTJGJTdCY2l0eSU3RCUzRmFwaUtleSUzRFlPVVJfQVBJX0tFWSUyMiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KGFwaV91cmwpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXNwb25zZS5zdGF0dXNfY29kZSUyMCUzRCUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjByZXNwb25zZS5qc29uKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhLmdldCglMjJ3ZWF0aGVyJTIyJTJDJTIwJTIyTm8lMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBhdmFpbGFibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycm9yJTNBJTIwVW5hYmxlJTIwdG8lMjBmZXRjaCUyMHdlYXRoZXIlMjBkYXRhLiUyMiUwQSUwQSUyMyUyMEV4ZWN1dGUlMjB0aGUlMjBmdW5jdGlvbiUyMGFuZCUyMHByZXBhcmUlMjB0aGUlMjBmaW5hbCUyMGFuc3dlciUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMlRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwaW4lMjBOZXclMjBZb3JrJTIwaXMlM0ElMjAlN0JyZXN1bHQlN0QlMjIlMEFwcmludChmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-comment"># Code Agent Example: Retrieve Weather Information</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No weather information available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: Unable to fetch weather data.&quot;</span>

<span class="hljs-comment"># Execute the function and prepare the final answer</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;The current weather in New York is: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),nt=new Le({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/actions.mdx"}}),{c(){p=i("meta"),u=l(),d=i("p"),c=l(),g(h.$$.fragment),it=l(),g(m.$$.fragment),ot=l(),x=i("p"),x.innerHTML=Qt,rt=l(),U=i("p"),U.textContent=Xt,pt=l(),j=i("p"),j.textContent=Yt,ut=l(),g(b.$$.fragment),ct=l(),J=i("p"),J.textContent=Ot,ht=l(),$=i("table"),$.innerHTML=Dt,dt=l(),_=i("p"),_.textContent=Kt,mt=l(),A=i("table"),A.innerHTML=te,ft=l(),I=i("p"),I.innerHTML=ee,Mt=l(),k=i("p"),k.textContent=ne,gt=l(),g(S.$$.fragment),yt=l(),B=i("p"),B.innerHTML=se,wt=l(),H=i("ol"),H.innerHTML=le,Ct=l(),Z=i("p"),Z.textContent=ae,vt=l(),f=i("ol"),f.innerHTML=ie,Tt=l(),P=i("p"),P.innerHTML=oe,xt=l(),M=i("ol"),M.innerHTML=re,Ut=l(),L=i("p"),L.textContent=pe,jt=l(),E=i("p"),E.textContent=ue,bt=l(),g(G.$$.fragment),Jt=l(),q=i("p"),q.textContent=ce,$t=l(),W=i("p"),W.textContent=he,_t=l(),g(F.$$.fragment),At=l(),N=i("p"),N.innerHTML=de,It=l(),R=i("img"),kt=l(),V=i("p"),V.textContent=fe,St=l(),z=i("ul"),z.innerHTML=Me,Bt=l(),Q=i("p"),Q.textContent=ge,Ht=l(),g(X.$$.fragment),Zt=l(),Y=i("p"),Y.textContent=ye,Pt=l(),O=i("ul"),O.innerHTML=we,Lt=l(),D=i("p"),D.innerHTML=Ce,Et=l(),Gt=i("hr"),qt=l(),K=i("p"),K.textContent=ve,Wt=l(),tt=i("p"),tt.textContent=Te,Ft=l(),et=i("p"),et.innerHTML=xe,Nt=l(),g(nt.$$.fragment),Rt=l(),lt=i("p"),this.h()},l(t){const e=Se("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(n),u=a(t),d=o(t,"P",{}),je(d).forEach(n),c=a(t),y(h.$$.fragment,t),it=a(t),y(m.$$.fragment,t),ot=a(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1d9hktj"&&(x.innerHTML=Qt),rt=a(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1tl5mip"&&(U.textContent=Xt),pt=a(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1ubetp8"&&(j.textContent=Yt),ut=a(t),y(b.$$.fragment,t),ct=a(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-8xbx7z"&&(J.textContent=Ot),ht=a(t),$=o(t,"TABLE",{"data-svelte-h":!0}),r($)!=="svelte-10vy6zf"&&($.innerHTML=Dt),dt=a(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1xp7kgk"&&(_.textContent=Kt),mt=a(t),A=o(t,"TABLE",{"data-svelte-h":!0}),r(A)!=="svelte-4604oy"&&(A.innerHTML=te),ft=a(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1j2zd7l"&&(I.innerHTML=ee),Mt=a(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-u4pk8z"&&(k.textContent=ne),gt=a(t),y(S.$$.fragment,t),yt=a(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-a9as0m"&&(B.innerHTML=se),wt=a(t),H=o(t,"OL",{"data-svelte-h":!0}),r(H)!=="svelte-1nmidra"&&(H.innerHTML=le),Ct=a(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-l3tk2o"&&(Z.textContent=ae),vt=a(t),f=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-j1mwkc"&&(f.innerHTML=ie),Tt=a(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1n64x39"&&(P.innerHTML=oe),xt=a(t),M=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(M)!=="svelte-w7r926"&&(M.innerHTML=re),Ut=a(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-191aaii"&&(L.textContent=pe),jt=a(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1exbnez"&&(E.textContent=ue),bt=a(t),y(G.$$.fragment,t),Jt=a(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1so9m39"&&(q.textContent=ce),$t=a(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-oeu6tn"&&(W.textContent=he),_t=a(t),y(F.$$.fragment,t),At=a(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-19f0lzf"&&(N.innerHTML=de),It=a(t),R=o(t,"IMG",{src:!0,alt:!0}),kt=a(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-rsd8hl"&&(V.textContent=fe),St=a(t),z=o(t,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1t80mrq"&&(z.innerHTML=Me),Bt=a(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qjq0mw"&&(Q.textContent=ge),Ht=a(t),y(X.$$.fragment,t),Zt=a(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-pfpi4"&&(Y.textContent=ye),Pt=a(t),O=o(t,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-b7upo8"&&(O.innerHTML=we),Lt=a(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1v0y8k3"&&(D.innerHTML=Ce),Et=a(t),Gt=o(t,"HR",{}),qt=a(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-b7m3f6"&&(K.textContent=ve),Wt=a(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-h8bvqv"&&(tt.textContent=Te),Ft=a(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-jt32z1"&&(et.innerHTML=xe),Nt=a(t),y(nt.$$.fragment,t),Rt=a(t),lt=o(t,"P",{}),je(lt).forEach(n),this.h()},h(){st(p,"name","hf:doc:metadata"),st(p,"content",qe),st(f,"start","2"),st(M,"start","3"),$e(R.src,me="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||st(R,"src",me),st(R,"alt","Code Agents")},m(t,e){Be(document.head,p),s(t,u,e),s(t,d,e),s(t,c,e),w(h,t,e),s(t,it,e),w(m,t,e),s(t,ot,e),s(t,x,e),s(t,rt,e),s(t,U,e),s(t,pt,e),s(t,j,e),s(t,ut,e),w(b,t,e),s(t,ct,e),s(t,J,e),s(t,ht,e),s(t,$,e),s(t,dt,e),s(t,_,e),s(t,mt,e),s(t,A,e),s(t,ft,e),s(t,I,e),s(t,Mt,e),s(t,k,e),s(t,gt,e),w(S,t,e),s(t,yt,e),s(t,B,e),s(t,wt,e),s(t,H,e),s(t,Ct,e),s(t,Z,e),s(t,vt,e),s(t,f,e),s(t,Tt,e),s(t,P,e),s(t,xt,e),s(t,M,e),s(t,Ut,e),s(t,L,e),s(t,jt,e),s(t,E,e),s(t,bt,e),w(G,t,e),s(t,Jt,e),s(t,q,e),s(t,$t,e),s(t,W,e),s(t,_t,e),w(F,t,e),s(t,At,e),s(t,N,e),s(t,It,e),s(t,R,e),s(t,kt,e),s(t,V,e),s(t,St,e),s(t,z,e),s(t,Bt,e),s(t,Q,e),s(t,Ht,e),w(X,t,e),s(t,Zt,e),s(t,Y,e),s(t,Pt,e),s(t,O,e),s(t,Lt,e),s(t,D,e),s(t,Et,e),s(t,Gt,e),s(t,qt,e),s(t,K,e),s(t,Wt,e),s(t,tt,e),s(t,Ft,e),s(t,et,e),s(t,Nt,e),w(nt,t,e),s(t,Rt,e),s(t,lt,e),Vt=!0},p(t,[e]){const Ue={};e&2&&(Ue.$$scope={dirty:e,ctx:t}),m.$set(Ue)},i(t){Vt||(C(h.$$.fragment,t),C(m.$$.fragment,t),C(b.$$.fragment,t),C(S.$$.fragment,t),C(G.$$.fragment,t),C(F.$$.fragment,t),C(X.$$.fragment,t),C(nt.$$.fragment,t),Vt=!0)},o(t){v(h.$$.fragment,t),v(m.$$.fragment,t),v(b.$$.fragment,t),v(S.$$.fragment,t),v(G.$$.fragment,t),v(F.$$.fragment,t),v(X.$$.fragment,t),v(nt.$$.fragment,t),Vt=!1},d(t){t&&(n(u),n(d),n(c),n(it),n(ot),n(x),n(rt),n(U),n(pt),n(j),n(ut),n(ct),n(J),n(ht),n($),n(dt),n(_),n(mt),n(A),n(ft),n(I),n(Mt),n(k),n(gt),n(yt),n(B),n(wt),n(H),n(Ct),n(Z),n(vt),n(f),n(Tt),n(P),n(xt),n(M),n(Ut),n(L),n(jt),n(E),n(bt),n(Jt),n(q),n($t),n(W),n(_t),n(At),n(N),n(It),n(R),n(kt),n(V),n(St),n(z),n(Bt),n(Q),n(Ht),n(Zt),n(Y),n(Pt),n(O),n(Lt),n(D),n(Et),n(Gt),n(qt),n(K),n(Wt),n(tt),n(Ft),n(et),n(Nt),n(Rt),n(lt)),n(p),T(h,t),T(m,t),T(b,t),T(S,t),T(G,t),T(F,t),T(X,t),T(nt,t)}}}const qe='{"title":"Actions:  Enabling the Agent to Engage with Its Environment","local":"actions-enabling-the-agent-to-engage-with-its-environment","sections":[{"title":"Types of Agent Actions","local":"types-of-agent-actions","sections":[],"depth":2},{"title":"The Stop and Parse Approach","local":"the-stop-and-parse-approach","sections":[],"depth":2},{"title":"Code Agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function We(at){return _e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends Ie{constructor(p){super(),ke(this,p,We,Ge,Je,{})}}export{Xe as component};
