import{s as Sa,n as Da,o as Ba}from"../chunks/scheduler.a2b4ca8e.js";import{S as Ha,i as Wa,g as i,s as n,r as m,A as Qa,h as s,f as a,c as o,j as v,u as p,x as d,k as b,y as l,a as r,v as h,d as g,t as u,w as _}from"../chunks/index.f6e1d51d.js";import{D as C}from"../chunks/Docstring.e7c4afb2.js";import{C as ra}from"../chunks/CodeBlock.9607aa3b.js";import{H as $,E as Za}from"../chunks/EditOnGithub.d27dc01b.js";function Ra(ia){let j,We,Be,Qe,N,Ze,q,sa=`Contrastive Preference Optimization (CPO) as introduced in the paper <a href="https://huggingface.co/papers/2401.08417" rel="nofollow">Contrastive Preference Optimization: Pushing the Boundaries of LLM Performance in Machine Translation</a> by Haoran Xu, Amr Sharaf, Yunmo Chen, Weiting Tan, Lingfeng Shen, Benjamin Van Durme, Kenton Murray, and Young Jin Kim. At a high-level, CPO  trains models to
avoid generating adequate, but not perfect translations in Machine Translation (MT) tasks. However, CPO is a general approximation to the DPO loss and can be applied to other domains like chat.`,Re,F,da="CPO aims to mitigate two fundamental shortcomings of SFT. First, SFT’s methodology of minimizing the discrepancy between predicted outputs and gold-standard references inherently caps model performance at the quality level of the training data. Secondly, SFT lacks a mechanism to prevent the model from rejecting mistakes in translations. The CPO objective is derived from the DPO objective.",Xe,L,Ge,E,ca='The <a href="https://arxiv.org/abs/2405.14734" rel="nofollow">SimPO</a> method is also implemented in the <code>CPOTrainer</code>. SimPO is an alternative loss that adds a reward margin, allows for length normalization, and does not use BC regularization. To use this loss, we can use SimPO easily by turning on <code>loss_type=&quot;simpo&quot;</code> and <code>cpo_alpha=0</code> in the <code>CPOConfig</code>.',Ve,z,Ye,S,ma='We also offer the combined use of CPO and SimPO, which enables more stable training and improved performance. Learn more details at <a href="https://github.com/fe1ixxu/CPO_SIMPO" rel="nofollow">CPO-SimPO Github</a>. To use this method, simply enable SimPO by setting <code>loss_type=&quot;simpo&quot;</code> and a non-zero <code>cpo_alpha</code> in the CPOConfig.',Ke,D,et,B,pa="The CPO trainer expects a format identical to the DPO trainer, which should include three entries. These entries should be named as follows:",tt,H,ha="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",at,W,ga="for example:",nt,Q,ot,Z,ua="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",lt,R,rt,X,_a="The CPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",it,G,st,V,fa="For a detailed example have a look at the <code>examples/scripts/cpo.py</code> script. At a high level we need to initialize the <code>CPOTrainer</code> with a <code>model</code> we wish to train. <strong>Note that CPOTrainer eliminates the need to use the reference model, simplifying the optimization process.</strong> The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above.",dt,Y,ct,K,va="After this one can then call:",mt,ee,pt,te,ht,ae,ba="Given the preference data, the <code>CPOTrainer</code> uses the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",gt,ne,Ma='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>CPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',ut,oe,Ca='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the CPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike CPO which is summed only).',_t,le,ft,re,ya="While training and evaluating we record the following reward metrics:",vt,ie,Ta="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li> <li><code>nll_loss</code>: the mean negative log likelihood loss of the policy model for the chosen responses</li>",bt,se,Mt,c,de,kt,Te,wa="Initialize CPOTrainer.",At,O,ce,Nt,we,$a=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,qt,T,me,Ft,$e,ja="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Lt,je,Oa="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Et,U,pe,zt,Oe,Ua="Concatenate the chosen and rejected inputs into a single tensor.",St,x,he,Dt,Ue,xa="Compute the CPO loss for a batch of policy and reference model log probabilities.",Bt,w,ge,Ht,xe,Pa=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Wt,Pe,Ja="Works both with or without labels.",Qt,P,ue,Zt,Je,Ia="Compute the log probabilities of the given labels under the given logits.",Rt,J,_e,Xt,Ie,ka="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",Gt,I,fe,Vt,ke,Aa="Generate samples from the model and reference model for the given batch of inputs.",Yt,k,ve,Kt,Ae,Na="Log <code>logs</code> on the various objects watching training, including stored metrics.",ea,M,be,ta,Ne,qa="Tokenize a single row from a CPO specific dataset.",aa,qe,Fa=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,na,Fe,La=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,Ct,Me,yt,y,Ce,oa,Le,Ea='CPOConfig collects all training arguments related to the <a href="/docs/trl/pr_1760/en/trainer#trl.CPOTrainer">CPOTrainer</a> class.',la,Ee,za=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Tt,ye,wt,He,$t;return N=new $({props:{title:"CPO Trainer",local:"cpo-trainer",headingTag:"h1"}}),L=new $({props:{title:"SimPO",local:"simpo",headingTag:"h2"}}),z=new $({props:{title:"CPO-SimPO",local:"cpo-simpo",headingTag:"h2"}}),D=new $({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),Q=new ra({props:{code:"Y3BvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`cpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),R=new $({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),G=new $({props:{title:"Using the CPOTrainer",local:"using-the-cpotrainer",headingTag:"h2"}}),Y=new ra({props:{code:"Y3BvX2NvbmZpZyUyMCUzRCUyMENQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWNwb190cmFpbmVyJTIwJTNEJTIwQ1BPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RjcG9fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`cpo_config = CPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

cpo_trainer = CPOTrainer(
    model,
    args=cpo_config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),ee=new ra({props:{code:"Y3BvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"cpo_trainer.train()",wrap:!1}}),te=new $({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),le=new $({props:{title:"Logging",local:"logging",headingTag:"h2"}}),se=new $({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),de=new C({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L55"}}),ce=new C({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L317"}}),me=new C({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L669"}}),pe=new C({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L518",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),he=new C({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L580",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ge=new C({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L865"}}),ue=new C({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),_e=new C({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L738"}}),fe=new C({props:{name:"get_batch_samples",anchor:"trl.CPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L800"}}),ve=new C({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L913"}}),be=new C({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_trainer.py#L367"}}),Me=new $({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),Ce=new C({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"cpo_alpha",val:": float = 1.0"},{name:"simpo_gamma",val:": float = 0.5"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in CPO loss.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>sigmoid</code>) &#x2014;
The type of loss to use. This argument is required if you want to use the default data collator.`,name:"loss_type"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.cpo_alpha",description:`<strong>cpo_alpha</strong> (<code>float</code>, defaults to <code>1.0</code>) &#x2014;
A hyperparameter that controls the strength of the BC regularizer in CPO training.`,name:"cpo_alpha"},{anchor:"trl.CPOConfig.simpo_gamma",description:`<strong>simpo_gamma</strong> (<code>float</code>, defaults to <code>0.5</code>) &#x2014;
A target reward margin for the SimPO loss, used only when the &#x201C;simpo&#x201D; option is enabled.`,name:"simpo_gamma"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/vr_1760/trl/trainer/cpo_config.py#L20"}}),ye=new Za({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/cpo_trainer.mdx"}}),{c(){j=i("meta"),We=n(),Be=i("p"),Qe=n(),m(N.$$.fragment),Ze=n(),q=i("p"),q.innerHTML=sa,Re=n(),F=i("p"),F.textContent=da,Xe=n(),m(L.$$.fragment),Ge=n(),E=i("p"),E.innerHTML=ca,Ve=n(),m(z.$$.fragment),Ye=n(),S=i("p"),S.innerHTML=ma,Ke=n(),m(D.$$.fragment),et=n(),B=i("p"),B.textContent=pa,tt=n(),H=i("ul"),H.innerHTML=ha,at=n(),W=i("p"),W.textContent=ga,nt=n(),m(Q.$$.fragment),ot=n(),Z=i("p"),Z.innerHTML=ua,lt=n(),m(R.$$.fragment),rt=n(),X=i("p"),X.innerHTML=_a,it=n(),m(G.$$.fragment),st=n(),V=i("p"),V.innerHTML=fa,dt=n(),m(Y.$$.fragment),ct=n(),K=i("p"),K.textContent=va,mt=n(),m(ee.$$.fragment),pt=n(),m(te.$$.fragment),ht=n(),ae=i("p"),ae.innerHTML=ba,gt=n(),ne=i("p"),ne.innerHTML=Ma,ut=n(),oe=i("p"),oe.innerHTML=Ca,_t=n(),m(le.$$.fragment),ft=n(),re=i("p"),re.textContent=ya,vt=n(),ie=i("ul"),ie.innerHTML=Ta,bt=n(),m(se.$$.fragment),Mt=n(),c=i("div"),m(de.$$.fragment),kt=n(),Te=i("p"),Te.textContent=wa,At=n(),O=i("div"),m(ce.$$.fragment),Nt=n(),we=i("p"),we.innerHTML=$a,qt=n(),T=i("div"),m(me.$$.fragment),Ft=n(),$e=i("p"),$e.textContent=ja,Lt=n(),je=i("p"),je.textContent=Oa,Et=n(),U=i("div"),m(pe.$$.fragment),zt=n(),Oe=i("p"),Oe.textContent=Ua,St=n(),x=i("div"),m(he.$$.fragment),Dt=n(),Ue=i("p"),Ue.textContent=xa,Bt=n(),w=i("div"),m(ge.$$.fragment),Ht=n(),xe=i("p"),xe.innerHTML=Pa,Wt=n(),Pe=i("p"),Pe.textContent=Ja,Qt=n(),P=i("div"),m(ue.$$.fragment),Zt=n(),Je=i("p"),Je.textContent=Ia,Rt=n(),J=i("div"),m(_e.$$.fragment),Xt=n(),Ie=i("p"),Ie.textContent=ka,Gt=n(),I=i("div"),m(fe.$$.fragment),Vt=n(),ke=i("p"),ke.textContent=Aa,Yt=n(),k=i("div"),m(ve.$$.fragment),Kt=n(),Ae=i("p"),Ae.innerHTML=Na,ea=n(),M=i("div"),m(be.$$.fragment),ta=n(),Ne=i("p"),Ne.textContent=qa,aa=n(),qe=i("p"),qe.textContent=Fa,na=n(),Fe=i("p"),Fe.textContent=La,Ct=n(),m(Me.$$.fragment),yt=n(),y=i("div"),m(Ce.$$.fragment),oa=n(),Le=i("p"),Le.innerHTML=Ea,la=n(),Ee=i("p"),Ee.innerHTML=za,Tt=n(),m(ye.$$.fragment),wt=n(),He=i("p"),this.h()},l(e){const t=Qa("svelte-u9bgzb",document.head);j=s(t,"META",{name:!0,content:!0}),t.forEach(a),We=o(e),Be=s(e,"P",{}),v(Be).forEach(a),Qe=o(e),p(N.$$.fragment,e),Ze=o(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1grcdr2"&&(q.innerHTML=sa),Re=o(e),F=s(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-10wbspk"&&(F.textContent=da),Xe=o(e),p(L.$$.fragment,e),Ge=o(e),E=s(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1uo8ahx"&&(E.innerHTML=ca),Ve=o(e),p(z.$$.fragment,e),Ye=o(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-fh1eo8"&&(S.innerHTML=ma),Ke=o(e),p(D.$$.fragment,e),et=o(e),B=s(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1t3enyx"&&(B.textContent=pa),tt=o(e),H=s(e,"UL",{"data-svelte-h":!0}),d(H)!=="svelte-17vxuta"&&(H.innerHTML=ha),at=o(e),W=s(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1gl9mvz"&&(W.textContent=ga),nt=o(e),p(Q.$$.fragment,e),ot=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1a8oxjk"&&(Z.innerHTML=ua),lt=o(e),p(R.$$.fragment,e),rt=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-187gqrp"&&(X.innerHTML=_a),it=o(e),p(G.$$.fragment,e),st=o(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1mkccty"&&(V.innerHTML=fa),dt=o(e),p(Y.$$.fragment,e),ct=o(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1lg6q1l"&&(K.textContent=va),mt=o(e),p(ee.$$.fragment,e),pt=o(e),p(te.$$.fragment,e),ht=o(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1nbvuj3"&&(ae.innerHTML=ba),gt=o(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-v1u5f4"&&(ne.innerHTML=Ma),ut=o(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-j24bt8"&&(oe.innerHTML=Ca),_t=o(e),p(le.$$.fragment,e),ft=o(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-132s7j9"&&(re.textContent=ya),vt=o(e),ie=s(e,"UL",{"data-svelte-h":!0}),d(ie)!=="svelte-yjg2sp"&&(ie.innerHTML=Ta),bt=o(e),p(se.$$.fragment,e),Mt=o(e),c=s(e,"DIV",{class:!0});var f=v(c);p(de.$$.fragment,f),kt=o(f),Te=s(f,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1qqtmoh"&&(Te.textContent=wa),At=o(f),O=s(f,"DIV",{class:!0});var jt=v(O);p(ce.$$.fragment,jt),Nt=o(jt),we=s(jt,"P",{"data-svelte-h":!0}),d(we)!=="svelte-mcz8nm"&&(we.innerHTML=$a),jt.forEach(a),qt=o(f),T=s(f,"DIV",{class:!0});var ze=v(T);p(me.$$.fragment,ze),Ft=o(ze),$e=s(ze,"P",{"data-svelte-h":!0}),d($e)!=="svelte-16i1nac"&&($e.textContent=ja),Lt=o(ze),je=s(ze,"P",{"data-svelte-h":!0}),d(je)!=="svelte-tgti68"&&(je.textContent=Oa),ze.forEach(a),Et=o(f),U=s(f,"DIV",{class:!0});var Ot=v(U);p(pe.$$.fragment,Ot),zt=o(Ot),Oe=s(Ot,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1cvsgkk"&&(Oe.textContent=Ua),Ot.forEach(a),St=o(f),x=s(f,"DIV",{class:!0});var Ut=v(x);p(he.$$.fragment,Ut),Dt=o(Ut),Ue=s(Ut,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1l2rxe2"&&(Ue.textContent=xa),Ut.forEach(a),Bt=o(f),w=s(f,"DIV",{class:!0});var Se=v(w);p(ge.$$.fragment,Se),Ht=o(Se),xe=s(Se,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-8qlty5"&&(xe.innerHTML=Pa),Wt=o(Se),Pe=s(Se,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1tyo99t"&&(Pe.textContent=Ja),Se.forEach(a),Qt=o(f),P=s(f,"DIV",{class:!0});var xt=v(P);p(ue.$$.fragment,xt),Zt=o(xt),Je=s(xt,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-4nmimv"&&(Je.textContent=Ia),xt.forEach(a),Rt=o(f),J=s(f,"DIV",{class:!0});var Pt=v(J);p(_e.$$.fragment,Pt),Xt=o(Pt),Ie=s(Pt,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-4kzfyw"&&(Ie.textContent=ka),Pt.forEach(a),Gt=o(f),I=s(f,"DIV",{class:!0});var Jt=v(I);p(fe.$$.fragment,Jt),Vt=o(Jt),ke=s(Jt,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-18uwvbi"&&(ke.textContent=Aa),Jt.forEach(a),Yt=o(f),k=s(f,"DIV",{class:!0});var It=v(k);p(ve.$$.fragment,It),Kt=o(It),Ae=s(It,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-nqksfz"&&(Ae.innerHTML=Na),It.forEach(a),ea=o(f),M=s(f,"DIV",{class:!0});var A=v(M);p(be.$$.fragment,A),ta=o(A),Ne=s(A,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1a53vwp"&&(Ne.textContent=qa),aa=o(A),qe=s(A,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1mn1gnw"&&(qe.textContent=Fa),na=o(A),Fe=s(A,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1xvpyih"&&(Fe.textContent=La),A.forEach(a),f.forEach(a),Ct=o(e),p(Me.$$.fragment,e),yt=o(e),y=s(e,"DIV",{class:!0});var De=v(y);p(Ce.$$.fragment,De),oa=o(De),Le=s(De,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-33d3lm"&&(Le.innerHTML=Ea),la=o(De),Ee=s(De,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1xl7jqc"&&(Ee.innerHTML=za),De.forEach(a),Tt=o(e),p(ye.$$.fragment,e),wt=o(e),He=s(e,"P",{}),v(He).forEach(a),this.h()},h(){b(j,"name","hf:doc:metadata"),b(j,"content",Xa),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,j),r(e,We,t),r(e,Be,t),r(e,Qe,t),h(N,e,t),r(e,Ze,t),r(e,q,t),r(e,Re,t),r(e,F,t),r(e,Xe,t),h(L,e,t),r(e,Ge,t),r(e,E,t),r(e,Ve,t),h(z,e,t),r(e,Ye,t),r(e,S,t),r(e,Ke,t),h(D,e,t),r(e,et,t),r(e,B,t),r(e,tt,t),r(e,H,t),r(e,at,t),r(e,W,t),r(e,nt,t),h(Q,e,t),r(e,ot,t),r(e,Z,t),r(e,lt,t),h(R,e,t),r(e,rt,t),r(e,X,t),r(e,it,t),h(G,e,t),r(e,st,t),r(e,V,t),r(e,dt,t),h(Y,e,t),r(e,ct,t),r(e,K,t),r(e,mt,t),h(ee,e,t),r(e,pt,t),h(te,e,t),r(e,ht,t),r(e,ae,t),r(e,gt,t),r(e,ne,t),r(e,ut,t),r(e,oe,t),r(e,_t,t),h(le,e,t),r(e,ft,t),r(e,re,t),r(e,vt,t),r(e,ie,t),r(e,bt,t),h(se,e,t),r(e,Mt,t),r(e,c,t),h(de,c,null),l(c,kt),l(c,Te),l(c,At),l(c,O),h(ce,O,null),l(O,Nt),l(O,we),l(c,qt),l(c,T),h(me,T,null),l(T,Ft),l(T,$e),l(T,Lt),l(T,je),l(c,Et),l(c,U),h(pe,U,null),l(U,zt),l(U,Oe),l(c,St),l(c,x),h(he,x,null),l(x,Dt),l(x,Ue),l(c,Bt),l(c,w),h(ge,w,null),l(w,Ht),l(w,xe),l(w,Wt),l(w,Pe),l(c,Qt),l(c,P),h(ue,P,null),l(P,Zt),l(P,Je),l(c,Rt),l(c,J),h(_e,J,null),l(J,Xt),l(J,Ie),l(c,Gt),l(c,I),h(fe,I,null),l(I,Vt),l(I,ke),l(c,Yt),l(c,k),h(ve,k,null),l(k,Kt),l(k,Ae),l(c,ea),l(c,M),h(be,M,null),l(M,ta),l(M,Ne),l(M,aa),l(M,qe),l(M,na),l(M,Fe),r(e,Ct,t),h(Me,e,t),r(e,yt,t),r(e,y,t),h(Ce,y,null),l(y,oa),l(y,Le),l(y,la),l(y,Ee),r(e,Tt,t),h(ye,e,t),r(e,wt,t),r(e,He,t),$t=!0},p:Da,i(e){$t||(g(N.$$.fragment,e),g(L.$$.fragment,e),g(z.$$.fragment,e),g(D.$$.fragment,e),g(Q.$$.fragment,e),g(R.$$.fragment,e),g(G.$$.fragment,e),g(Y.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(se.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(fe.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(Ce.$$.fragment,e),g(ye.$$.fragment,e),$t=!0)},o(e){u(N.$$.fragment,e),u(L.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(Q.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(fe.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(Ce.$$.fragment,e),u(ye.$$.fragment,e),$t=!1},d(e){e&&(a(We),a(Be),a(Qe),a(Ze),a(q),a(Re),a(F),a(Xe),a(Ge),a(E),a(Ve),a(Ye),a(S),a(Ke),a(et),a(B),a(tt),a(H),a(at),a(W),a(nt),a(ot),a(Z),a(lt),a(rt),a(X),a(it),a(st),a(V),a(dt),a(ct),a(K),a(mt),a(pt),a(ht),a(ae),a(gt),a(ne),a(ut),a(oe),a(_t),a(ft),a(re),a(vt),a(ie),a(bt),a(Mt),a(c),a(Ct),a(yt),a(y),a(Tt),a(wt),a(He)),a(j),_(N,e),_(L,e),_(z,e),_(D,e),_(Q,e),_(R,e),_(G,e),_(Y,e),_(ee,e),_(te,e),_(le,e),_(se,e),_(de),_(ce),_(me),_(pe),_(he),_(ge),_(ue),_(_e),_(fe),_(ve),_(be),_(Me,e),_(Ce),_(ye,e)}}}const Xa='{"title":"CPO Trainer","local":"cpo-trainer","sections":[{"title":"SimPO","local":"simpo","sections":[],"depth":2},{"title":"CPO-SimPO","local":"cpo-simpo","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the CPOTrainer","local":"using-the-cpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2}],"depth":1}';function Ga(ia){return Ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class an extends Ha{constructor(j){super(),Wa(this,j,Ga,Ra,Sa,{})}}export{an as component};
