import{s as st,o as ot,n as nt}from"../chunks/scheduler.8c3d61f6.js";import{S as it,i as at,g as a,s as o,r as g,A as lt,h as l,f as n,c as i,j as B,u as _,x as f,k as D,y as p,a as s,v as y,d as b,t as M,w as v}from"../chunks/index.da70eac4.js";import{T as rt}from"../chunks/Tip.1d9b8c37.js";import{D as ae}from"../chunks/Docstring.6b390b9a.js";import{C as pt}from"../chunks/CodeBlock.00a903b3.js";import{E as dt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Je,E as ct}from"../chunks/EditOnGithub.1e64e623.js";function mt(O){let r,I='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=a("p"),r.innerHTML=I},l(u){r=l(u,"P",{"data-svelte-h":!0}),f(r)!=="svelte-w7r39y"&&(r.innerHTML=I)},m(u,h){s(u,r,h)},p:nt,d(u){u&&n(r)}}}function ft(O){let r,I="Examples:",u,h,w;return h=new pt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ConsisIDPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.pipelines.consisid.consisid_utils <span class="hljs-keyword">import</span> prepare_face_models, process_face_embeddings_infer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, local_dir=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>face_helper_1, face_helper_2, face_clip_model, face_main_model, eva_transform_mean, eva_transform_std = (
<span class="hljs-meta">... </span>    prepare_face_models(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = ConsisIDPipeline.from_pretrained(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ConsisID works well with long and well-described prompts. Make sure the face in the image is clearly visible (e.g., preferably half-body or full-body).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#x27;s lost in contemplation. The film grain adds a textured, timeless quality to the image, evoking a sense of nostalgia. Around him, the cityscape is filled with vintage buildings, cobblestone sidewalks, and softly blurred figures passing by, their outlines faint and indistinct. Streetlights cast a gentle glow, while shadows play across the boy&#x27;s path, adding depth to the scene. The lighting highlights the boy&#x27;s subtle smile, hinting at a fleeting moment of curiosity. The overall cinematic atmosphere, complete with classic film still aesthetics and dramatic contrasts, gives the scene an evocative and introspective feel.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://github.com/PKU-YuanGroup/ConsisID/blob/main/asserts/example_images/2.png?raw=true&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>id_cond, id_vit_hidden, image, face_kps = process_face_embeddings_infer(
<span class="hljs-meta">... </span>    face_helper_1,
<span class="hljs-meta">... </span>    face_clip_model,
<span class="hljs-meta">... </span>    face_helper_2,
<span class="hljs-meta">... </span>    eva_transform_mean,
<span class="hljs-meta">... </span>    eva_transform_std,
<span class="hljs-meta">... </span>    face_main_model,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    torch.bfloat16,
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    is_align_face=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">6.0</span>,
<span class="hljs-meta">... </span>    use_dynamic_cfg=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    id_vit_hidden=id_vit_hidden,
<span class="hljs-meta">... </span>    id_cond=id_cond,
<span class="hljs-meta">... </span>    kps_cond=face_kps,
<span class="hljs-meta">... </span>    generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){r=a("p"),r.textContent=I,u=o(),g(h.$$.fragment)},l(d){r=l(d,"P",{"data-svelte-h":!0}),f(r)!=="svelte-kvfsh7"&&(r.textContent=I),u=i(d),_(h.$$.fragment,d)},m(d,T){s(d,r,T),s(d,u,T),y(h,d,T),w=!0},p:nt,i(d){w||(b(h.$$.fragment,d),w=!0)},o(d){M(h.$$.fragment,d),w=!1},d(d){d&&(n(r),n(u)),v(h,d)}}}function ut(O){let r,I,u,h,w,d,T,Ve='<a href="https://arxiv.org/abs/2411.17440" rel="nofollow">Identity-Preserving Text-to-Video Generation by Frequency Decomposition</a> from Peking University &amp; University of Rochester &amp; etc, by Shenghai Yuan, Jinfa Huang, Xianyi He, Yunyang Ge, Yujun Shi, Liuhan Chen, Jiebo Luo, Li Yuan.',re,W,ze="The abstract from the paper is:",pe,$,He='<em>Identity-preserving text-to-video (IPT2V) generation aims to create high-fidelity videos with consistent human identity. It is an important task in video generation but remains an open problem for generative models. This paper pushes the technical frontier of IPT2V in two directions that have not been resolved in the literature: (1) A tuning-free pipeline without tedious case-by-case finetuning, and (2) A frequency-aware heuristic identity-preserving Diffusion Transformer (DiT)-based control scheme. To achieve these goals, we propose <strong>ConsisID</strong>, a tuning-free DiT-based controllable IPT2V model to keep human-<strong>id</strong>entity <strong>consis</strong>tent in the generated video. Inspired by prior findings in frequency analysis of vision/diffusion transformers, it employs identity-control signals in the frequency domain, where facial features can be decomposed into low-frequency global features (e.g., profile, proportions) and high-frequency intrinsic features (e.g., identity markers that remain unaffected by pose changes). First, from a low-frequency perspective, we introduce a global facial extractor, which encodes the reference image and facial key points into a latent space, generating features enriched with low-frequency information. These features are then integrated into the shallow layers of the network to alleviate training challenges associated with DiT. Second, from a high-frequency perspective, we design a local facial extractor to capture high-frequency details and inject them into the transformer blocks, enhancing the model’s ability to preserve fine-grained features. To leverage the frequency information for identity preservation, we propose a hierarchical training strategy, transforming a vanilla pre-trained video generation model into an IPT2V model. Extensive experiments demonstrate that our frequency-aware heuristic scheme provides an optimal control solution for DiT-based models. Thanks to this scheme, our <strong>ConsisID</strong> achieves excellent results in generating high-quality, identity-preserving videos, making strides towards more effective IPT2V. The model weight of ConsID is publicly available at <a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">https://github.com/PKU-YuanGroup/ConsisID</a>.</em>',de,J,ce,P,Re='This pipeline was contributed by <a href="https://github.com/SHYuanBest" rel="nofollow">SHYuanBest</a>. The original codebase can be found <a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/BestWishYsh" rel="nofollow">hf.co/BestWishYsh</a>.',me,N,Se="There are two official ConsisID checkpoints for identity-preserving text-to-video.",fe,X,Fe='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/BestWishYsh/ConsisID-preview" rel="nofollow"><code>BestWishYsh/ConsisID-preview</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/BestWishYsh/ConsisID-preview" rel="nofollow"><code>BestWishYsh/ConsisID-1.5</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',ue,Y,he,V,Le='ConsisID requires about 44 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/SHYuanBest/bc4207c36f454f9e969adbb50eaf8258" rel="nofollow">this</a> script.',ge,z,Ee='<thead><tr><th align="left">Feature (overlay the previous)</th> <th align="left">Max Memory Allocated</th> <th align="left">Max Memory Reserved</th></tr></thead> <tbody><tr><td align="left">-</td> <td align="left">37 GB</td> <td align="left">44 GB</td></tr> <tr><td align="left">enable_model_cpu_offload</td> <td align="left">22 GB</td> <td align="left">25 GB</td></tr> <tr><td align="left">enable_sequential_cpu_offload</td> <td align="left">16 GB</td> <td align="left">22 GB</td></tr> <tr><td align="left">vae.enable_slicing</td> <td align="left">16 GB</td> <td align="left">22 GB</td></tr> <tr><td align="left">vae.enable_tiling</td> <td align="left">5 GB</td> <td align="left">7 GB</td></tr></tbody>',_e,H,ye,c,R,xe,K,qe="Pipeline for image-to-video generation using ConsisID.",Ze,ee,Qe=`This model inherits from <a href="/docs/diffusers/pr_10140/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ge,j,S,ke,te,Ae="Function invoked when calling the pipeline for generation.",Be,x,De,Z,F,We,ne,Oe="Encodes the prompt into text encoder hidden states.",$e,G,L,Pe,se,Ke="Enables fused QKV projections.",Ne,k,E,Xe,oe,et="Disable QKV projection fusion if enabled.",be,q,Me,C,Q,Ye,ie,tt="Output class for ConsisID pipelines.",ve,A,we,le,Te;return w=new Je({props:{title:"ConsisID",local:"consisid",headingTag:"h1"}}),J=new rt({props:{$$slots:{default:[mt]},$$scope:{ctx:O}}}),Y=new Je({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),H=new Je({props:{title:"ConsisIDPipeline",local:"diffusers.ConsisIDPipeline",headingTag:"h2"}}),R=new ae({props:{name:"class diffusers.ConsisIDPipeline",anchor:"diffusers.ConsisIDPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": ConsisIDTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10140/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.ConsisIDPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. ConsisID uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.ConsisIDPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.ConsisIDPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10140/en/api/models/consisid_transformer3d#diffusers.ConsisIDTransformer3DModel">ConsisIDTransformer3DModel</a>) &#x2014;
A text conditioned <code>ConsisIDTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.ConsisIDPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10140/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L244"}}),S=new ae({props:{name:"__call__",anchor:"diffusers.ConsisIDPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 720"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"},{name:"id_vit_hidden",val:": typing.Optional[torch.Tensor] = None"},{name:"id_cond",val:": typing.Optional[torch.Tensor] = None"},{name:"kps_cond",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.ConsisIDPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.ConsisIDPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>49</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because ConsisID is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 4. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.ConsisIDPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 6) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.ConsisIDPipeline.__call__.use_dynamic_cfg",description:`<strong>use_dynamic_cfg</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, dynamically adjusts the guidance scale during inference. This allows the model to use a
progressive guidance scale, improving the balance between text-guided generation and image quality over
the course of the inference steps. Typically, early inference steps use a higher guidance scale for
more faithful image generation, while later steps reduce it for more diverse and natural results.`,name:"use_dynamic_cfg"},{anchor:"diffusers.ConsisIDPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.ConsisIDPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.ConsisIDPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.ConsisIDPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.ConsisIDPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.ConsisIDPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.ConsisIDPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.ConsisIDPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L666",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10140/en/api/pipelines/consisid#diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput"
>ConsisIDPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10140/en/api/pipelines/consisid#diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput"
>ConsisIDPipelineOutput</a> or <code>tuple</code></p>
`}}),x=new dt({props:{anchor:"diffusers.ConsisIDPipeline.__call__.example",$$slots:{default:[ft]},$$scope:{ctx:O}}}),F=new ae({props:{name:"encode_prompt",anchor:"diffusers.ConsisIDPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.ConsisIDPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.ConsisIDPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L349"}}),L=new ae({props:{name:"fuse_qkv_projections",anchor:"diffusers.ConsisIDPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L615"}}),E=new ae({props:{name:"unfuse_qkv_projections",anchor:"diffusers.ConsisIDPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_consisid.py#L621"}}),q=new Je({props:{title:"ConsisIDPipelineOutput",local:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",headingTag:"h2"}}),Q=new ae({props:{name:"class diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",anchor:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/vr_10140/src/diffusers/pipelines/consisid/pipeline_output.py#L8"}}),A=new ct({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/consisid.md"}}),{c(){r=a("meta"),I=o(),u=a("p"),h=o(),g(w.$$.fragment),d=o(),T=a("p"),T.innerHTML=Ve,re=o(),W=a("p"),W.textContent=ze,pe=o(),$=a("p"),$.innerHTML=He,de=o(),g(J.$$.fragment),ce=o(),P=a("p"),P.innerHTML=Re,me=o(),N=a("p"),N.textContent=Se,fe=o(),X=a("table"),X.innerHTML=Fe,ue=o(),g(Y.$$.fragment),he=o(),V=a("p"),V.innerHTML=Le,ge=o(),z=a("table"),z.innerHTML=Ee,_e=o(),g(H.$$.fragment),ye=o(),c=a("div"),g(R.$$.fragment),xe=o(),K=a("p"),K.textContent=qe,Ze=o(),ee=a("p"),ee.innerHTML=Qe,Ge=o(),j=a("div"),g(S.$$.fragment),ke=o(),te=a("p"),te.textContent=Ae,Be=o(),g(x.$$.fragment),De=o(),Z=a("div"),g(F.$$.fragment),We=o(),ne=a("p"),ne.textContent=Oe,$e=o(),G=a("div"),g(L.$$.fragment),Pe=o(),se=a("p"),se.textContent=Ke,Ne=o(),k=a("div"),g(E.$$.fragment),Xe=o(),oe=a("p"),oe.textContent=et,be=o(),g(q.$$.fragment),Me=o(),C=a("div"),g(Q.$$.fragment),Ye=o(),ie=a("p"),ie.textContent=tt,ve=o(),g(A.$$.fragment),we=o(),le=a("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(n),I=i(e),u=l(e,"P",{}),B(u).forEach(n),h=i(e),_(w.$$.fragment,e),d=i(e),T=l(e,"P",{"data-svelte-h":!0}),f(T)!=="svelte-18faaze"&&(T.innerHTML=Ve),re=i(e),W=l(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-1cwsb16"&&(W.textContent=ze),pe=i(e),$=l(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-16o3b9f"&&($.innerHTML=He),de=i(e),_(J.$$.fragment,e),ce=i(e),P=l(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-508pas"&&(P.innerHTML=Re),me=i(e),N=l(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-10ua0j4"&&(N.textContent=Se),fe=i(e),X=l(e,"TABLE",{"data-svelte-h":!0}),f(X)!=="svelte-1g40pp0"&&(X.innerHTML=Fe),ue=i(e),_(Y.$$.fragment,e),he=i(e),V=l(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-l3wq5l"&&(V.innerHTML=Le),ge=i(e),z=l(e,"TABLE",{"data-svelte-h":!0}),f(z)!=="svelte-i2ot8w"&&(z.innerHTML=Ee),_e=i(e),_(H.$$.fragment,e),ye=i(e),c=l(e,"DIV",{class:!0});var m=B(c);_(R.$$.fragment,m),xe=i(m),K=l(m,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1ypyl48"&&(K.textContent=qe),Ze=i(m),ee=l(m,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-12lopph"&&(ee.innerHTML=Qe),Ge=i(m),j=l(m,"DIV",{class:!0});var U=B(j);_(S.$$.fragment,U),ke=i(U),te=l(U,"P",{"data-svelte-h":!0}),f(te)!=="svelte-v78lg8"&&(te.textContent=Ae),Be=i(U),_(x.$$.fragment,U),U.forEach(n),De=i(m),Z=l(m,"DIV",{class:!0});var Ie=B(Z);_(F.$$.fragment,Ie),We=i(Ie),ne=l(Ie,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-16q0ax1"&&(ne.textContent=Oe),Ie.forEach(n),$e=i(m),G=l(m,"DIV",{class:!0});var je=B(G);_(L.$$.fragment,je),Pe=i(je),se=l(je,"P",{"data-svelte-h":!0}),f(se)!=="svelte-1vadzv1"&&(se.textContent=Ke),je.forEach(n),Ne=i(m),k=l(m,"DIV",{class:!0});var Ce=B(k);_(E.$$.fragment,Ce),Xe=i(Ce),oe=l(Ce,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-fohozp"&&(oe.textContent=et),Ce.forEach(n),m.forEach(n),be=i(e),_(q.$$.fragment,e),Me=i(e),C=l(e,"DIV",{class:!0});var Ue=B(C);_(Q.$$.fragment,Ue),Ye=i(Ue),ie=l(Ue,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-ihv7pb"&&(ie.textContent=tt),Ue.forEach(n),ve=i(e),_(A.$$.fragment,e),we=i(e),le=l(e,"P",{}),B(le).forEach(n),this.h()},h(){D(r,"name","hf:doc:metadata"),D(r,"content",ht),D(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,r),s(e,I,t),s(e,u,t),s(e,h,t),y(w,e,t),s(e,d,t),s(e,T,t),s(e,re,t),s(e,W,t),s(e,pe,t),s(e,$,t),s(e,de,t),y(J,e,t),s(e,ce,t),s(e,P,t),s(e,me,t),s(e,N,t),s(e,fe,t),s(e,X,t),s(e,ue,t),y(Y,e,t),s(e,he,t),s(e,V,t),s(e,ge,t),s(e,z,t),s(e,_e,t),y(H,e,t),s(e,ye,t),s(e,c,t),y(R,c,null),p(c,xe),p(c,K),p(c,Ze),p(c,ee),p(c,Ge),p(c,j),y(S,j,null),p(j,ke),p(j,te),p(j,Be),y(x,j,null),p(c,De),p(c,Z),y(F,Z,null),p(Z,We),p(Z,ne),p(c,$e),p(c,G),y(L,G,null),p(G,Pe),p(G,se),p(c,Ne),p(c,k),y(E,k,null),p(k,Xe),p(k,oe),s(e,be,t),y(q,e,t),s(e,Me,t),s(e,C,t),y(Q,C,null),p(C,Ye),p(C,ie),s(e,ve,t),y(A,e,t),s(e,we,t),s(e,le,t),Te=!0},p(e,[t]){const m={};t&2&&(m.$$scope={dirty:t,ctx:e}),J.$set(m);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),x.$set(U)},i(e){Te||(b(w.$$.fragment,e),b(J.$$.fragment,e),b(Y.$$.fragment,e),b(H.$$.fragment,e),b(R.$$.fragment,e),b(S.$$.fragment,e),b(x.$$.fragment,e),b(F.$$.fragment,e),b(L.$$.fragment,e),b(E.$$.fragment,e),b(q.$$.fragment,e),b(Q.$$.fragment,e),b(A.$$.fragment,e),Te=!0)},o(e){M(w.$$.fragment,e),M(J.$$.fragment,e),M(Y.$$.fragment,e),M(H.$$.fragment,e),M(R.$$.fragment,e),M(S.$$.fragment,e),M(x.$$.fragment,e),M(F.$$.fragment,e),M(L.$$.fragment,e),M(E.$$.fragment,e),M(q.$$.fragment,e),M(Q.$$.fragment,e),M(A.$$.fragment,e),Te=!1},d(e){e&&(n(I),n(u),n(h),n(d),n(T),n(re),n(W),n(pe),n($),n(de),n(ce),n(P),n(me),n(N),n(fe),n(X),n(ue),n(he),n(V),n(ge),n(z),n(_e),n(ye),n(c),n(be),n(Me),n(C),n(ve),n(we),n(le)),n(r),v(w,e),v(J,e),v(Y,e),v(H,e),v(R),v(S),v(x),v(F),v(L),v(E),v(q,e),v(Q),v(A,e)}}}const ht='{"title":"ConsisID","local":"consisid","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3},{"title":"ConsisIDPipeline","local":"diffusers.ConsisIDPipeline","sections":[],"depth":2},{"title":"ConsisIDPipelineOutput","local":"diffusers.pipelines.consisid.pipeline_output.ConsisIDPipelineOutput","sections":[],"depth":2}],"depth":1}';function gt(O){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends it{constructor(r){super(),at(this,r,gt,ut,st,{})}}export{It as component};
