import{s as _j,o as bj,n as U}from"../chunks/scheduler.25b97de1.js";import{S as yj,i as Tj,g as a,s as n,r as p,A as vj,h as l,f as s,c as r,j as T,u as m,x as b,k as v,y as t,a as d,v as g,d as h,t as u,w as f}from"../chunks/index.d9030fc9.js";import{T as En}from"../chunks/Tip.baa67368.js";import{D as M}from"../chunks/Docstring.e257edda.js";import{C as Z}from"../chunks/CodeBlock.e6cd0d95.js";import{E as B}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as oe,E as Mj}from"../chunks/EditOnGithub.91d95064.js";function wj(j){let i,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){i=a("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),b(i)!=="svelte-nbt45a"&&(i.innerHTML=$)},m(y,_){d(y,i,_)},p:U,d(y){y&&s(i)}}}function kj(j){let i,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){i=a("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1uojnuk"&&(i.innerHTML=$)},m(y,_){d(y,i,_)},p:U,d(y){y&&s(i)}}}function $j(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function jj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function xj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Jj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Uj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Zj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Bj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Wj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function zj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Ij(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5hbGxjbG9zZSh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSUyQyUyMHRvcmNoLlRlbnNvcigoMS4wMDAlMkMpKSUyQyUyMHJ0b2wlM0QxZS00KSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guYWxsY2xvc2UodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSklMkMlMjB0b3JjaC5UZW5zb3IoKDEuMDAwJTJDKSklMkMlMjBydG9sJTNEMWUtNCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Cj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Vj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Lj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MG1pbl9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MG1pbl9wJTYwJTIwaW4lMjB0aGUlMjAwLjAxLTAuMiUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtaW5fcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`min_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`min_p\` in the 0.01-0.2 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, min_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Gj(j){let i,$=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),b(i)!=="svelte-15bvr1j"&&(i.innerHTML=$)},m(y,_){d(y,i,_)},p:U,d(y){y&&s(i)}}}function Fj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Xj(j){let i,$=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){i=a("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),b(i)!=="svelte-5zfsi9"&&(i.innerHTML=$)},m(y,_){d(y,i,_)},p:U,d(y){y&&s(i)}}}function Rj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Sj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity = tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">1</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">2</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Ej(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Nj(j){let i,$=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),b(i)!=="svelte-16cusgy"&&(i.innerHTML=$)},m(y,_){d(y,i,_)},p:U,d(y){y&&s(i)}}}function Hj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function qj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMCU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEJTVCMCUyQyUyMDUwMjU2JTVEKSUyMCUyMCUyMyUyMGluJTIwb3RoZXIlMjBwbGFjZXMlMjB3ZSUyMGNhbiUyMHNlZSUyMHNvbWUlMjBwcm9iYWJpbGl0eSUyMG1hc3MlMjBmb3IlMjBFT1MlMEElMEElMjMlMjBJZiUyMHdlJTIwZGlzYWJsZSUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyQyUyMHdlJTIwY2FuJTIwZ2VuZXJhdGUlMjBFT1MlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaXRlcmF0aW9uLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwYmVnaW5fc3VwcHJlc3NfdG9rZW5zJTNETm9uZSUwQSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjAlNUQlNUIwJTJDJTIwNTAyNTYlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Dj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">6.0678</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Qj(j){let i,$=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){i=a("p"),i.innerHTML=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1byeoum"&&(i.innerHTML=$)},m(y,_){d(y,i,_)},p:U,d(y){y&&s(i)}}}function Pj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is one of these companies that is going to take a&#x27;</span>,
<span class="hljs-string">&quot;Hugging Face Company is a brand created by Brian A. O&#x27;Neil&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Yj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E — S — O, P — R

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Aj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Oj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXZSUyMGNhbiUyMHNlZSUyMHRoYXQlMjBncmVlZHklMjBkZWNvZGluZyUyMHByb2R1Y2VzJTIwYSUyMHNlcXVlbmNlJTIwb2YlMjBudW1iZXJzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwRm9yJTIwdGhpcyUyMHBhcnRpY3VsYXIlMjBzZWVkJTJDJTIwd2UlMjBjYW4lMjBzZWUlMjB0aGF0JTIwc2FtcGxpbmclMjBwcm9kdWNlcyUyMG5lYXJseSUyMHRoZSUyMHNhbWUlMjBsb3ctaW5mb3JtYXRpb24lMjAoJTNEJTIwbG93JTIwZW50cm9weSklMEElMjMlMjBzZXF1ZW5jZSUwQXNldF9zZWVkKDE4KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdHlwaWNhbF9wJTYwJTIwc2V0JTJDJTIwdGhlJTIwbW9zdCUyMG9idmlvdXMlMjBzZXF1ZW5jZSUyMGlzJTIwbm8lMjBsb25nZXIlMjBwcm9kdWNlZCUyQyUyMHdoaWNoJTIwbWF5JTIwYmUlMjBnb29kJTIwZm9yJTIweW91ciUyMHByb2JsZW0lMEFzZXRfc2VlZCgxOCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdHlwaWNhbF9wJTNEMC4xJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUlMEEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzLnNlcXVlbmNlcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2UlMjBjYW4lMjBzZWUlMjB0aGF0JTIwdGhlJTIwdG9rZW4lMjBjb3JyZXNwb25kaW5nJTIwdG8lMjAlMjI0JTIyJTIwKHRva2VuJTIwOTM0KSUyMGluJTIwdGhlJTIwc2Vjb25kJTIwcG9zaXRpb24lMkMlMjB0aGUlMjBtb3N0JTIwbGlrZWx5JTIwdG9rZW4lMEElMjMlMjBhcyUyMHNlZW4lMjB3aXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3YXMlMjBlbnRpcmVseSUyMGJsb2NrZWQlMjBvdXQlMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwOTM0JTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function Kj(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function e0(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function t0(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya2luZ0NvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwbm9ybWFsJTIwZ2VuZXJhdGlvbiUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdhdGVybWFya2VkJTIwZ2VuZXJhdGlvbiUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMGNvbnRleHRfd2lkdGglM0QyJTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHRvJTIwZGV0ZWN0JTIwd2F0ZXJtYXJrZWQlMjB0ZXh0JTIwdXNlJTIwdGhlJTIwV2F0ZXJtYXJrRGV0ZWN0b3IlMjBjbGFzcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBXYXRlcm1hcmtEZXRlY3RvciUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRCUyMHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX3ByZWRzJTIwJTNEJTIwZGV0ZWN0b3Iob3V0KSUwQWRldGVjdGlvbl9wcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob are&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># normal generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both in the same room.\\n\\n&quot;I\\&#x27;m not sure if you\\&#x27;re&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># watermarked generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, context_width=<span class="hljs-number">2</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], watermarking_config=watermarking_config, max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both still alive and well and the story is pretty much a one-hour adventure&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to detect watermarked text use the WatermarkDetector class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WatermarkDetector
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config= watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds = detector(out)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds
array([ <span class="hljs-literal">True</span>])`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function s0(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBiaWdnZXN0JTIwc3RhdGVzJTIwaW4lMjB0aGUlMjBVU0ElMjBieSUyMGxhbmQlMjBhcmVhJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBQYXNzaW5nJTIwb25lJTIwb3IlMjBtb3JlJTIwc3RvcCUyMHN0cmluZ3MlMjB3aWxsJTIwaGFsdCUyMGdlbmVyYXRpb24lMjBhZnRlciUyMHRob3NlJTIwc3RyaW5ncyUyMGFyZSUyMGVtaXR0ZWQlMEElMjMlMjBOb3RlJTIwdGhhdCUyMGdlbmVyYXRpbmclMjB3aXRoJTIwc3RvcCUyMHN0cmluZ3MlMjByZXF1aXJlcyUyMHlvdSUyMHRvJTIwcGFzcyUyMHRoZSUyMHRva2VuaXplciUyMHRvbyUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHN0b3Bfc3RyaW5ncyUzRCU1QiUyMlRleGFzJTIyJTVEJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX291dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The biggest states in the USA by land area:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas
- California

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Passing one or more stop strings will halt generation after those strings are emitted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that generating with stop strings requires you to pass the tokenizer too</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, stop_strings=[<span class="hljs-string">&quot;Texas&quot;</span>], tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function n0(j){let i,$;return i=new Z({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){p(i.$$.fragment)},l(y){m(i.$$.fragment,y)},m(y,_){g(i,y,_),$=!0},p:U,i(y){$||(h(i.$$.fragment,y),$=!0)},o(y){u(i.$$.fragment,y),$=!1},d(y){f(i,y)}}}function r0(j){let i,$="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),b(i)!=="svelte-gv2g1g"&&(i.textContent=$)},m(y,_){d(y,i,_)},p:U,d(y){y&&s(i)}}}function o0(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function a0(j){let i,$="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=$},l(y){i=l(y,"P",{"data-svelte-h":!0}),b(i)!=="svelte-gv2g1g"&&(i.textContent=$)},m(y,_){d(y,i,_)},p:U,d(y){y&&s(i)}}}function l0(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function c0(j){let i,$="Examples:",y,_,w;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvay5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2suZW9zX3Rva2VuX2lkJTBBdG9rLnBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMmxlZnQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyVGhpcyUyMGlzJTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjBhJTIwbG9uZyUyMHN0b3J5JTIyJTJDJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjBhcmUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfbGVuJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlMEElMEElMjMlMjBmaXJzdCUyMGdlbmVyYXRlJTIwdGV4dCUyMHdpdGglMjB3YXRlcm1hcmslMjBhbmQlMjB3aXRob3V0JTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFdhdGVybWFya2luZ0NvbmZpZyhiaWFzJTNEMi41JTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbGVuZ3RoJTNEMjApJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9sZW5ndGglM0QyMCklMEElMEElMjMlMjBub3clMjB3ZSUyMGNhbiUyMGluc3RhbnRpYXRlJTIwdGhlJTIwZGV0ZWN0b3IlMjBhbmQlMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMEFkZXRlY3RvciUyMCUzRCUyMFdhdGVybWFya0RldGVjdG9yKG1vZGVsX2NvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMGRldmljZSUzRCUyMmNwdSUyMiUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnKSUwQWRldGVjdGlvbl9vdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3RvcihvdXRfd2F0ZXJtYXJrZWQlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0X3dhdGVybWFya2VkLnByZWRpY3Rpb24lMEElMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># first generate text with watermark and without</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_watermarked = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now we can instantiate the detector and check the generated text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked = detector(out_watermarked, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked.prediction
array([ <span class="hljs-literal">True</span>,  <span class="hljs-literal">True</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">False</span>,  <span class="hljs-literal">False</span>])`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,y=n(),p(_.$$.fragment)},l(o){i=l(o,"P",{"data-svelte-h":!0}),b(i)!=="svelte-kvfsh7"&&(i.textContent=$),y=r(o),m(_.$$.fragment,o)},m(o,k){d(o,i,k),d(o,y,k),g(_,o,k),w=!0},p:U,i(o){w||(h(_.$$.fragment,o),w=!0)},o(o){u(_.$$.fragment,o),w=!1},d(o){o&&(s(i),s(y)),f(_,o)}}}function i0(j){let i,$,y,_,w,o,k,JM='This page lists all the utility functions used by <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',ph,Nn,mh,Hn,UM=`The output of <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/pr_31155/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/pr_31155/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,gh,qn,ZM="Here’s an example:",hh,Dn,uh,Qn,BM=`The <code>generation_output</code> object is a <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,fh,Pn,WM="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",_h,Yn,zM=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,bh,An,IM=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,yh,On,CM=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Th,Kn,vh,er,VM="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",Mh,tr,LM=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,wh,sr,GM="We document here all output types.",kh,nr,$h,Xt,rr,v_,Bc,FM="Outputs of decoder-only generation models, when using non-beam methods.",jh,Rt,or,M_,Wc,XM="Outputs of encoder-decoder generation models, when using non-beam methods.",xh,St,ar,w_,zc,RM="Outputs of decoder-only generation models, when using beam methods.",Jh,Et,lr,k_,Ic,SM="Outputs of encoder-decoder generation models, when using beam methods.",Uh,cr,Zh,Nt,ir,$_,Cc,EM=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Bh,Ht,dr,j_,Vc,NM="Base class for outputs of decoder-only generation models using greedy search.",Wh,qt,pr,x_,Lc,HM=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,zh,Dt,mr,J_,Gc,qM="Base class for outputs of decoder-only generation models using sampling.",Ih,Qt,gr,U_,Fc,DM=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Ch,Pt,hr,Z_,Xc,QM="Base class for outputs of decoder-only generation models using beam search.",Vh,Yt,ur,B_,Rc,PM=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Lh,At,fr,W_,Sc,YM="Base class for outputs of decoder-only generation models using beam sample.",Gh,Ot,_r,z_,Ec,AM=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Fh,Kt,br,I_,Nc,OM="Base class for outputs of decoder-only generation models using contrastive search.",Xh,yr,Rh,Ce,Tr,C_,Hc,KM="Flax Base class for outputs of decoder-only generation models using sampling.",V_,is,vr,L_,qc,ew="“Returns a new object replacing the specified fields with new values.",Sh,Ve,Mr,G_,Dc,tw="Flax Base class for outputs of decoder-only generation models using greedy search.",F_,ds,wr,X_,Qc,sw="“Returns a new object replacing the specified fields with new values.",Eh,Le,kr,R_,Pc,nw="Flax Base class for outputs of decoder-only generation models using greedy search.",S_,ps,$r,E_,Yc,rw="“Returns a new object replacing the specified fields with new values.",Nh,jr,Hh,xr,ow=`A <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,qh,Jr,Dh,le,Ur,N_,Ac,aw='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',H_,ms,q_,Oc,Zr,Qh,V,Br,D_,Kc,lw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,Q_,ei,cw='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',P_,gs,Y_,hs,A_,ti,Wr,Ph,H,zr,O_,si,iw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,K_,ni,dw=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,eb,us,tb,ri,Ir,Yh,q,Cr,sb,oi,pw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,nb,ai,mw=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,rb,fs,ob,li,Vr,Ah,ce,Lr,ab,ci,gw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,lb,_s,cb,ii,Gr,Oh,ie,Fr,ib,di,hw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,db,bs,pb,pi,Xr,Kh,de,Rr,mb,mi,uw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,gb,ys,hb,gi,Sr,eu,pe,Er,ub,hi,fw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,fb,Ts,_b,ui,Nr,tu,me,Hr,bb,fi,_w='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',yb,vs,Tb,_i,qr,su,Ge,Dr,vb,bi,bw=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before generation. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,Mb,yi,Qr,nu,L,Pr,wb,Ti,yw='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',kb,vi,Tw=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,$b,Mi,vw=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,jb,Ms,xb,wi,Yr,ru,ge,Ar,Jb,ki,Mw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,Ub,$i,ww=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,Zb,ji,Or,ou,he,Kr,Bb,xi,kw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,Wb,ws,zb,Ji,eo,au,Fe,to,Ib,Ui,$w="Abstract base class for all logit processors that can be applied during generation.",Cb,Zi,so,lu,Xe,no,Vb,Bi,jw=`This class can be used to create a list of <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,Lb,Wi,ro,cu,Re,oo,Gb,zi,xw="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Fb,Ii,ao,iu,ue,lo,Xb,Ci,Jw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,Rb,ks,Sb,Vi,co,du,fe,io,Eb,Li,Uw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,Nb,$s,Hb,Gi,po,pu,G,mo,qb,Fi,Zw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs min-p, i.e. keeps all tokens that are above a minimum probability, scaled by the
probability of the most likely token. As a result, the filter becomes more agressive in the presence of
high-probability tokens, which is a sign of a confident output that we shouldn’t deviate from.`,Db,Xi,Bw=`Often used together with <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a>. Used as an alternative to <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,Qb,Ri,Ww='Created by @menhguin and @kalomaze (github handles). Code adapted from <a href="https://github.com/oobabooga/text-generation-webui/pull/4449/files" rel="nofollow">this external PR</a>',Pb,js,Yb,Si,go,mu,D,ho,Ab,Ei,zw='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',Ob,xs,Kb,Js,ey,Ni,uo,gu,Q,fo,ty,Hi,Iw=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,sy,Us,ny,Zs,ry,qi,_o,hu,_e,bo,oy,Di,Cw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,ay,Bs,ly,Qi,yo,uu,P,To,cy,Pi,Vw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,iy,Yi,Lw=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,dy,Ws,py,Ai,vo,fu,Y,Mo,my,Oi,Gw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,gy,zs,hy,Is,uy,Ki,wo,_u,be,ko,fy,ed,Fw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,_y,Cs,by,td,$o,bu,ye,jo,yy,sd,Xw=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,Ty,Vs,vy,nd,xo,yu,A,Jo,My,rd,Rw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,wy,Ls,ky,Gs,$y,od,Uo,Tu,Te,Zo,jy,ad,Sw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used together
with <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,xy,Fs,Jy,ld,Bo,vu,ve,Wo,Uy,cd,Ew=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off. Often
used together with <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,Zy,Xs,By,id,zo,Mu,O,Io,Wy,dd,Nw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens whose
log probability is close to the entropy of the token probability distribution. This means that the most likely
tokens may be discarded in the process.`,zy,pd,Hw='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',Iy,Rs,Cy,md,Co,wu,K,Vo,Vy,gd,qw=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,Ly,hd,Dw='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',Gy,Ss,Fy,ud,Lo,ku,ee,Go,Xy,fd,Qw=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,Ry,_d,Pw='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',Sy,Es,Ey,bd,Fo,$u,F,Xo,Ny,yd,Yw=`Logits processor for watermarking generated text. The processor modifies model output scores by adding a small bias to
randomized set of “green” tokens before generating the next token. “Green” tokens selection process depends on the
<code>seeding_scheme</code> used. The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,Hy,Td,Aw='The text generated by this <code>LogitsProcessor</code> can be detected using <code>WatermarkDetector</code>. See <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.WatermarkDetector.__call__"><strong>call</strong>()</a> for details,',qy,vd,Ow='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',Dy,Ns,Qy,Md,Ro,ju,So,xu,Se,Eo,Py,wd,Kw='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Yy,kd,No,Ju,Ee,Ho,Ay,$d,ek='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Oy,jd,qo,Uu,Ne,Do,Ky,xd,tk=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,eT,Jd,Qo,Zu,He,Po,tT,Ud,sk="Abstract base class for all logit processors that can be applied during generation.",sT,Hs,Yo,nT,Zd,nk="TF method for processing logits.",Bu,qe,Ao,rT,Bd,rk=`This class can be used to create a list of <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,oT,Wd,Oo,Wu,De,Ko,aT,zd,ok="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",lT,qs,ea,cT,Id,ak="TF method for warping logits.",zu,Qe,ta,iT,Cd,lk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',dT,Vd,sa,Iu,Pe,na,pT,Ld,ck='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',mT,Gd,ra,Cu,Ye,oa,gT,Fd,ik=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,hT,Xd,aa,Vu,Ae,la,uT,Rd,dk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',fT,Sd,ca,Lu,Oe,ia,_T,Ed,pk=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,bT,Nd,da,Gu,Ke,pa,yT,Hd,mk=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,TT,qd,ma,Fu,et,ga,vT,Dd,gk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',MT,Qd,ha,Xu,tt,ua,wT,Pd,hk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',kT,Yd,fa,Ru,st,_a,$T,Ad,uk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',jT,Od,ba,Su,ya,Eu,nt,Ta,xT,Kd,fk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',JT,ep,va,Nu,rt,Ma,UT,tp,_k='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',ZT,sp,wa,Hu,ot,ka,BT,np,bk=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,WT,rp,$a,qu,at,ja,zT,op,yk="Abstract base class for all logit processors that can be applied during generation.",IT,Ds,xa,CT,ap,Tk="Flax method for processing logits.",Du,lt,Ja,VT,lp,vk=`This class can be used to create a list of <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,LT,cp,Ua,Qu,ct,Za,GT,ip,Mk="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",FT,Qs,Ba,XT,dp,wk="Flax method for warping logits.",Pu,it,Wa,RT,pp,kk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',ST,mp,za,Yu,dt,Ia,ET,gp,$k=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,NT,hp,Ca,Au,pt,Va,HT,up,jk=`<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,qT,fp,La,Ou,mt,Ga,DT,_p,xk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',QT,bp,Fa,Ku,gt,Xa,PT,yp,Jk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',YT,Tp,Ra,ef,ht,Sa,AT,vp,Uk='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',OT,Mp,Ea,tf,ut,Na,KT,wp,Zk=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,ev,kp,Ha,sf,qa,nf,Da,Bk='A <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',rf,Me,Qa,tv,$p,Wk="Abstract base class for all stopping criteria that can be applied during generation.",sv,jp,zk="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",nv,xp,Pa,of,es,Ya,rv,Jp,Aa,af,ft,Oa,ov,Up,Ik=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,av,Zp,Ka,lf,_t,el,lv,Bp,Ck=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,cv,Wp,tl,cf,x,sl,iv,zp,Vk=`This class can be used to stop generation whenever specific string sequences are generated. It preprocesses
the strings together with the tokenizer vocab to find positions where tokens can validly complete the stop strings.`,dv,Ip,Lk=`Generation is stopped as soon as a token is generated that completes any of the stop strings.
We want to catch any instance in which the stop string would be present in the decoded output, which means
we must also catch cases with “overhangs” off one or both ends. To make this more concrete, for the stop string
“stop”, any of the following token sequences would trigger the match:`,pv,Cp,Gk="<li>[“st”, “op”]</li> <li>[“stop”]</li> <li>[“st”, “opera”]</li> <li>[“sto”, “pper”]</li> <li>[“las”, “topper”]</li> <li>[“s”, “to”, “pped”]</li>",mv,Vp,Fk=`Note that a match will only be triggered if the stop string is at the end of the generated sequence. In other
words, these sequences will not trigger a match:`,gv,Lp,Xk="<li>[“stop”, “at”]</li> <li>[“st”, “op”, “at”]</li> <li>[“st”, “opera”, “tion”]</li>",hv,Gp,Rk=`The reason these are not a match is that the stop string does not overlap with the final token. If you can remove
one or more tokens from the end of the sequence without destroying the stop string, then this criterion will not
match that stop string. This is by design; because this check is run after each token is generated, we can’t miss a
valid stop string if one is generated, but we don’t want to halt generation just because the stop string exists
somewhere in the past input_ids.`,uv,Fp,Sk=`How is the match actually performed, though? We do it in quite a confusing way, because we want the entire match
process to be compilable with Torch or XLA, which means we cannot use standard string methods. However, it is possible,
with some work, to do string matching with pure tensor operations. We’ll begin by describing the algorithm we use
with standard string operations, and then at the end we’ll explain how this is converted to pure tensor operations.`,fv,Xp,Ek=`The key to the algorithm is an observation: Because the stop string must overlap with the end of the token sequence, we can start at
the end of the sequence and work backwards. Specifically, we check that there is an overlap between the start of
the final token and the end of the stop_string, or to put it another way, stop_string[-i:] == token[:i] for
some i > 0. If you look at the positive examples above, you’ll see the last token in all of them fulfills this
property:`,_v,Rp,Nk="<li>[“st”, “op”] (overlap is “op”, overlap length == 2)</li> <li>[“stop”]  (overlap is “stop”, overlap length == 4)</li> <li>[“st”, “opera”]  (overlap is “op”, overlap length == 2)</li> <li>[“sto”, “pper”]  (overlap is “p”, overlap length == 1)</li> <li>[“las”, “topper”]  (overlap is “top”, overlap length == 3)</li> <li>[“s”, “to”, “pped”]  (overlap is “p”, overlap length == 1)</li>",bv,Sp,Hk=`It’s impossible to construct a matching sequence that does not have this property (feel free to verify this
yourself). However, although this overlap between the start of the final token and the end of the stop string is
necessary for a match, it is not sufficient. We also need to check that the rest of the token sequence is
consistent with the stop string.`,yv,Ep,qk=`How do we do that? Let’s use [“s”, “to”, “pped”] as an example. We know that the final token, “pped”, has an
overlap of 1 with the stop string, “stop”. We then go back to the previous token, “to”. Since we have already
matched 1 character from the stop string, the remainder to check is “sto”. We check that the next token “to”
matches the end of the remainder, which it does. We have now matched 3 characters from the stop string, and the
remainder to match is “s”. We go back to the previous token again, which is also “s”. This is a match, and so
we have matched the entire stop string.`,Tv,Np,Dk=`How does it work when the tokens run off the start of the stop string, though? Let’s consider the example of
[“las”, “topper”]. The final token, “topper”, has an overlap of 3 with the stop string, “stop”. Therefore,
the remaining stop string to match is “s”. We go back to the previous token, “las”. Because the remainder to
match is just “s”, with length 1, we consider only the final 1 character from the token, which is “s”. This
matches the stop string, and so the entire string is matched.`,vv,Hp,Qk=`How do we compute these matches with tensor operations, though? Simply: we efficiently precompute the necessary
information for all tokens! For every token, we compute:`,Mv,qp,Pk="<li>Its overlap with the end of the stop string, if any</li> <li>The positions inside the stop string where the token matches, including matches that run off the start.</li> <li>The total length of the token</li>",wv,Dp,Yk=`For example, for the token “pped”, we would compute an end overlap of 1, no internal matching positions,
and a length of 4. For the token “to”, we would compute no end overlap, a single internal matching position
of 1 (counting from the end), and a length of 2. For the token “s”, we would compute no end overlap,
a single internal matching position of 3 (again counting from the end) and a length of 1.`,kv,Qp,Ak=`As long as we have this information, we can execute the algorithm above without any string comparison
operations. We simply perform the following steps:`,$v,Pp,Ok="<li>Check if the final token has an end-overlap with the start string</li> <li>Continue backwards, keeping track of how much of the stop string we’ve matched so far</li> <li>At each point, check if the next token has the current position as one of its valid positions</li> <li>Continue until either a match fails, or we completely match the whole stop string</li>",jv,Yp,Kk=`Again, consider [“s”, “to”, “pped”] as an example. “pped” has an end overlap of 1, so we can begin a match.
We have matched 1 character so far, so we check that the next token “to”, has 1 as a valid position (again,
counting from the end). It does, so we add the length of “to” to our position tracker. We have now matched
3 characters, so we check that the next token “s” has 3 as a valid position. It does, so we add its length
to the position tracker. The position tracker is now 4, which is the length of the stop string. We have matched the
entire stop string.`,xv,Ap,e2=`In the second case, [“las”, “topper”], “topper” has an end overlap of 3, so we can begin a match. We have
matched 3 characters so far, so we check that the next token “las” has 3 as a valid position. It does, because we
allow tokens to match positions that run off the start of the stop string. We add its length to the position
tracker. The position tracker is now 6, which is greater than the length of the stop string! Don’t panic, though -
this also counts as a match of the stop string. We have matched the entire stop string.`,Jv,Ps,Uv,Op,nl,df,bt,rl,Zv,Kp,t2=`This class can be used to stop generation whenever the “end-of-sequence” token is generated.
By default, it uses the <code>model.generation_config.eos_token_id</code>.`,Bv,em,ol,pf,al,mf,ll,s2='A <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',gf,W,cl,Wv,tm,n2=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,zv,sm,r2="All classes that inherit Constraint must follow the requirement that",Iv,Ys,Cv,nm,o2="will always terminate (halt).",Vv,As,il,Lv,rm,a2="When called, returns the token that would take this constraint one step closer to being fulfilled.",Gv,Os,dl,Fv,om,l2="Creates a new instance of this constraint.",Xv,Ks,pl,Rv,am,c2="Reads in a token and returns whether it creates progress.",Sv,en,ml,Ev,lm,i2="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",Nv,tn,gl,Hv,cm,d2=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,qv,sn,hl,Dv,im,p2="Tests whether this constraint has been properly defined.",Qv,Jt,ul,Pv,dm,m2=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,Yv,pm,g2=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,hf,ts,fl,Av,mm,h2='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',uf,ss,_l,Ov,gm,u2='A special <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',ff,we,bl,Kv,hm,f2="A class for beam scorers to track its progress through a list of constraints.",e1,E,yl,t1,um,_2=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,s1,fm,b2=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,n1,_m,y2="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",r1,bm,T2=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,o1,ym,v2=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,a1,nn,Tl,l1,Tm,M2="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",_f,vl,bf,ke,Ml,c1,vm,w2=`Abstract base class for all beam scorers that are used for <code>~PreTrainedModel.beam_search</code> and
<code>~PreTrainedModel.beam_sample</code>.`,i1,Mm,wl,d1,wm,kl,yf,X,$l,p1,km,k2='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',m1,$m,$2=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,g1,jm,j2=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,h1,xm,jl,u1,Jm,xl,Tf,$e,Jl,f1,Um,x2='<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',_1,Zm,Ul,b1,Bm,Zl,vf,Bl,Mf,C,Wl,y1,Wm,J2="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",T1,rn,v1,on,M1,an,zl,w1,zm,U2="Flushes any remaining cache and prints a newline to stdout.",k1,ln,Il,$1,Im,Z2="Prints the new text to stdout. If the stream is ending, also prints a newline.",j1,cn,Cl,x1,Cm,B2="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",wf,te,Vl,J1,Vm,W2=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,U1,dn,Z1,pn,B1,mn,Ll,W1,Lm,z2="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",kf,Gl,$f,yt,Fl,z1,Gm,I2="Base, abstract class for all caches. The actual data structure is specific to each subclass.",I1,gn,Xl,C1,Fm,C2="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",jf,Tt,Rl,V1,Xm,V2="Base class for cache configs",L1,hn,Sl,G1,Rm,L2=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,xf,vt,El,F1,Sm,G2="Configuration class for quantized cache settings.",X1,un,Nl,R1,Em,F2="Validates if the arguments passed are correct",Jf,I,Hl,S1,Nm,X2="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",E1,Hm,R2=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,N1,fn,ql,H1,qm,S2="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",q1,_n,Dl,D1,Dm,E2="Returns the sequence length of the cached states. A layer index can be optionally passed.",Q1,bn,Ql,P1,Qm,N2="Reorders the cache for beam search, given the selected beam indices.",Y1,yn,Pl,A1,Pm,H2=`Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format. Used for
backward compatibility.`,O1,Tn,Yl,K1,Ym,q2=`Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>. Used for
backward compatibility.`,Uf,R,Al,eM,Am,D2=`A quantizer cache similar to what is described in the <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache paper</a>.
It allows the model to generate longer sequence length without allocating too much memory for Key and Value cache by applying quantization.`,tM,Om,Q2=`The cache has two types of storage, one for original precision and one for the quantized cache. A <code>residual length</code> is set as a maximum capacity for the
original precision cache. When the length goes beyond maximum capacity, the original precision cache is discarded and moved into the quantized cache. The
quantization is done per-channel with a set <code>q_group_size</code> for both Keys and Values, in contrast to what was described in the paper.`,sM,Km,P2=`It stores Keys and Values a list of quantized tensors (tuples in case we need to store metadata), one for each layer. Additionally, it stores the Key and
Value in original precision states as a list of tensors, one for each layer. The size of each tensor
is <code>[batch_size, num_heads, seq_len - residual_length, head_dim]</code>`,nM,eg,Ol,rM,vn,Kl,oM,tg,Y2="Returns the sequence length of the cached states. A layer index can be optionally passed.",Zf,ns,ec,aM,sg,A2="Quantized Cache class that uses <code>quanto</code> as a backend to perform quantization. Current implementation supports <code>int2</code> and <code>int4</code> dtypes only.",Bf,rs,tc,lM,ng,O2="Quantized Cache class that uses <code>HQQ</code> as a backend to perform quantization. Current implementation supports <code>int2</code>, <code>int4</code>, <code>int8</code> dtypes.",Wf,S,sc,cM,rg,K2=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,iM,og,e$=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,dM,Mn,nc,pM,ag,t$="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",mM,wn,rc,gM,lg,s$="Returns the sequence length of the cached states. A layer index can be optionally passed.",hM,kn,oc,uM,cg,n$="Reorders the cache for beam search, given the selected beam indices.",zf,se,ac,fM,ig,r$="Static Cache class to be used with <code>torch.compile(model)</code>.",_M,$n,lc,bM,dg,o$=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,yM,jn,cc,TM,pg,a$="Returns the sequence length of the cached states that were seen by the model.",vM,xn,ic,MM,mg,l$="Resets the cache values while preserving the objects",If,dc,Cf,ne,pc,wM,gg,c$=`Detector for detection of watermark generated text. The detector needs to be given the exact same settings that were
given during text generation to replicate the watermark greenlist generation and so detect the watermark. This includes
the correct device that was used during text generation, the correct watermarking arguments and the correct tokenizer vocab size.
The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,kM,hg,i$='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',$M,Jn,jM,Un,mc,xM,ug,d$="ma",Vf,gc,Lf,eh,Gf;return w=new oe({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),Nn=new oe({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Dn=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),Kn=new Z({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),nr=new oe({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),rr=new M({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/utils.py#L119"}}),or=new M({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/utils.py#L159"}}),ar=new M({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/utils.py#L211"}}),lr=new M({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/utils.py#L259"}}),cr=new oe({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),ir=new M({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L85"}}),dr=new M({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L57"}}),pr=new M({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L155"}}),mr=new M({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L127"}}),gr=new M({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L232"}}),hr=new M({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L197"}}),ur=new M({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L317"}}),fr=new M({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L282"}}),_r=new M({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L393"}}),br=new M({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_utils.py#L366"}}),yr=new oe({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),Tr=new M({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_utils.py#L69"}}),vr=new M({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/flax/struct.py#L111"}}),Mr=new M({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_utils.py#L55"}}),wr=new M({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/flax/struct.py#L111"}}),kr=new M({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_utils.py#L83"}}),$r=new M({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/flax/struct.py#L111"}}),jr=new oe({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Jr=new oe({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),Ur=new M({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L2126"}}),ms=new En({props:{warning:!0,$$slots:{default:[wj]},$$scope:{ctx:j}}}),Zr=new M({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L2155"}}),Br=new M({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L2062"}}),gs=new En({props:{warning:!0,$$slots:{default:[kj]},$$scope:{ctx:j}}}),hs=new B({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[$j]},$$scope:{ctx:j}}}),Wr=new M({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L2110",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zr=new M({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L975"}}),us=new B({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[jj]},$$scope:{ctx:j}}}),Ir=new M({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1024",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Cr=new M({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L356"}}),fs=new B({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[xj]},$$scope:{ctx:j}}}),Vr=new M({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L400",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Lr=new M({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L696"}}),_s=new B({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[Jj]},$$scope:{ctx:j}}}),Gr=new M({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L751",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Fr=new M({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"},{anchor:"transformers.EtaLogitsWarper.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L765"}}),bs=new B({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[Uj]},$$scope:{ctx:j}}}),Xr=new M({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L834",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Rr=new M({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": Tuple"},{name:"eos_token_id",val:": Union"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1610"}}),ys=new B({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[Zj]},$$scope:{ctx:j}}}),Sr=new M({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1696",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Er=new M({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1488"}}),Ts=new B({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[Bj]},$$scope:{ctx:j}}}),Nr=new M({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1523",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Hr=new M({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1533"}}),vs=new B({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[Wj]},$$scope:{ctx:j}}}),qr=new M({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Dr=new M({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"},{name:"_has_warned",val:": Optional = False"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1841"}}),Qr=new M({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Pr=new M({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1352"}}),Ms=new B({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[zj]},$$scope:{ctx:j}}}),Yr=new M({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1439",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ar=new M({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1589"}}),Or=new M({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1598",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Kr=new M({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1711"}}),ws=new B({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[Ij]},$$scope:{ctx:j}}}),eo=new M({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1742",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new M({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L45"}}),so=new M({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),no=new M({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L65"}}),ro=new M({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),oo=new M({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L55"}}),ao=new M({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L58",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new M({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L103"}}),ks=new B({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[Cj]},$$scope:{ctx:j}}}),co=new M({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L154",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new M({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": Union"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L164"}}),$s=new B({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[Vj]},$$scope:{ctx:j}}}),po=new M({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L224",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),mo=new M({props:{name:"class transformers.MinPLogitsWarper",anchor:"transformers.MinPLogitsWarper",parameters:[{name:"min_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.MinPLogitsWarper.min_p",description:`<strong>min_p</strong> (<code>float</code>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.MinPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.MinPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L531"}}),js=new B({props:{anchor:"transformers.MinPLogitsWarper.example",$$slots:{default:[Lj]},$$scope:{ctx:j}}}),go=new M({props:{name:"__call__",anchor:"transformers.MinPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L588"}}),ho=new M({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": Union = None"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>, <em>optional</em>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1192"}}),xs=new En({props:{$$slots:{default:[Gj]},$$scope:{ctx:j}}}),Js=new B({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[Fj]},$$scope:{ctx:j}}}),uo=new M({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fo=new M({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L916"}}),Us=new En({props:{$$slots:{default:[Xj]},$$scope:{ctx:j}}}),Zs=new B({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[Rj]},$$scope:{ctx:j}}}),_o=new M({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L963",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new M({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": Callable"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1283"}}),Bs=new B({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[Sj]},$$scope:{ctx:j}}}),yo=new M({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1334",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),To=new M({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L302"}}),Ws=new B({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[Ej]},$$scope:{ctx:j}}}),vo=new M({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L345",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mo=new M({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": Dict"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1044"}}),zs=new En({props:{$$slots:{default:[Nj]},$$scope:{ctx:j}}}),Is=new B({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[Hj]},$$scope:{ctx:j}}}),wo=new M({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ko=new M({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1748"}}),Cs=new B({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[qj]},$$scope:{ctx:j}}}),$o=new M({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1790",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),jo=new M({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1801"}}),Vs=new B({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[Dj]},$$scope:{ctx:j}}}),xo=new M({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1833",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Jo=new M({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L236"}}),Ls=new En({props:{$$slots:{default:[Qj]},$$scope:{ctx:j}}}),Gs=new B({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[Pj]},$$scope:{ctx:j}}}),Uo=new M({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L296",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zo=new M({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L478"}}),Fs=new B({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[Yj]},$$scope:{ctx:j}}}),Bo=new M({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L522",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wo=new M({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L411"}}),Xs=new B({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[Aj]},$$scope:{ctx:j}}}),zo=new M({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Io=new M({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L608"}}),Rs=new B({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[Oj]},$$scope:{ctx:j}}}),Co=new M({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vo=new M({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": Optional = None"},{name:"unconditional_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L2171"}}),Ss=new B({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Kj]},$$scope:{ctx:j}}}),Lo=new M({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L2277"}}),Go=new M({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": Optional = None"},{name:"_detect_timestamp_from_logprob",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1869"}}),Es=new B({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[e0]},$$scope:{ctx:j}}}),Fo=new M({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L1954",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xo=new M({props:{name:"class transformers.WatermarkLogitsProcessor",anchor:"transformers.WatermarkLogitsProcessor",parameters:[{name:"vocab_size",val:""},{name:"device",val:""},{name:"greenlist_ratio",val:": float = 0.25"},{name:"bias",val:": float = 2.0"},{name:"hashing_key",val:": int = 15485863"},{name:"seeding_scheme",val:": str = 'lefthash'"},{name:"context_width",val:": int = 1"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>) &#x2014;
The model tokenizer&#x2019;s vocab_size. Used to calculate &#x201C;green&#x201D; tokens ratio.`,name:"vocab_size"},{anchor:"transformers.WatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device where model is allocated.`,name:"device"},{anchor:"transformers.WatermarkLogitsProcessor.greenlist_ratio",description:`<strong>greenlist_ratio</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 0.25) &#x2014;
The ratio of &#x201C;green&#x201D; tokens used to the vocabulary size. Defaults to 0.25.`,name:"greenlist_ratio"},{anchor:"transformers.WatermarkLogitsProcessor.bias",description:`<strong>bias</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 2.0) &#x2014;
The bias added to the selected &#x201C;green&#x201D; tokens&#x2019; logits. Consider lowering the
<code>bias</code> if the text generation quality degrades. Recommended values are in the
range of [0.5, 2.0]. Defaults to 2.0.`,name:"bias"},{anchor:"transformers.WatermarkLogitsProcessor.hashing_key",description:`<strong>hashing_key</strong> (<code>int</code>, optional, <em>optional</em>, defaults to 15485863) &#x2014;
Key used for hashing. If you deploy this watermark, we advise using another private key.
Defaults to 15485863 (the millionth prime).`,name:"hashing_key"},{anchor:"transformers.WatermarkLogitsProcessor.seeding_scheme",description:`<strong>seeding_scheme</strong> (<code>str</code>, optional, <em>optional</em>, defaults to <code>&quot;lefthash&quot;</code>) &#x2014;
The seeding scheme used for selecting &#x201C;green&#x201D; tokens. Accepts values:<ul>
<li>&#x201C;lefthash&#x201D; (default): &#x201C;green&#x201D; tokens selection depend on the last token (Algorithm 2 from paper)</li>
<li>&#x201C;selfhash&#x201D;: &#x201C;green&#x201D; tokens selection depends on the current token itself (Algorithm 3 from paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than &#x201C;lefthash&#x201D;.
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>
</ul>`,name:"seeding_scheme"},{anchor:"transformers.WatermarkLogitsProcessor.context_width",description:`<strong>context_width</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of previous tokens to use when setting the seed.`,name:"context_width"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L2336"}}),Ns=new B({props:{anchor:"transformers.WatermarkLogitsProcessor.example",$$slots:{default:[t0]},$$scope:{ctx:j}}}),Ro=new M({props:{name:"__call__",anchor:"transformers.WatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/logits_process.py#L2458"}}),So=new oe({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Eo=new M({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L448"}}),No=new M({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L462"}}),Ho=new M({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L478"}}),qo=new M({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L495"}}),Do=new M({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L551"}}),Qo=new M({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L567"}}),Po=new M({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L53"}}),Yo=new M({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ao=new M({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L75"}}),Oo=new M({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ko=new M({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L64"}}),ea=new M({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ta=new M({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L202"}}),sa=new M({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L228"}}),na=new M({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L288"}}),ra=new M({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L367"}}),oa=new M({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L388"}}),aa=new M({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L427"}}),la=new M({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L238"}}),ca=new M({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L280"}}),ia=new M({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L511"}}),da=new M({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L522"}}),pa=new M({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L535"}}),ma=new M({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L542"}}),ga=new M({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L98"}}),ha=new M({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L113"}}),ua=new M({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L118"}}),fa=new M({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L138"}}),_a=new M({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L146"}}),ba=new M({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/tf_logits_process.py#L170"}}),ya=new oe({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Ta=new M({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L195"}}),va=new M({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L207"}}),Ma=new M({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L217"}}),wa=new M({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L232"}}),ka=new M({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L316"}}),$a=new M({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L338"}}),ja=new M({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L51"}}),xa=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L54",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ja=new M({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L73"}}),Ua=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Za=new M({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L62"}}),Ba=new M({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wa=new M({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L242"}}),za=new M({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L263"}}),Ia=new M({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L272"}}),Ca=new M({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L289"}}),Va=new M({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L297"}}),La=new M({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L310"}}),Ga=new M({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L96"}}),Fa=new M({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L111"}}),Xa=new M({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L160"}}),Ra=new M({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L180"}}),Sa=new M({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L116"}}),Ea=new M({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L140"}}),Na=new M({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L364"}}),Ha=new M({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/flax_logits_process.py#L398"}}),qa=new oe({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Qa=new M({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L45"}}),Pa=new M({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L52",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Ya=new M({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L503"}}),Aa=new M({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L504",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Oa=new M({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L57"}}),Ka=new M({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L73",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),el=new M({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L116"}}),tl=new M({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),sl=new M({props:{name:"class transformers.StopStringCriteria",anchor:"transformers.StopStringCriteria",parameters:[{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"stop_strings",val:": Union"}],parametersDescription:[{anchor:"transformers.StopStringCriteria.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The model&#x2019;s associated tokenizer (necessary to extract vocab and tokenize the termination sequences)`,name:"tokenizer"},{anchor:"transformers.StopStringCriteria.stop_strings",description:`<strong>stop_strings</strong> (<code>Union[str, List[str]]</code>) &#x2014;
A list of strings that should end generation. If a string is passed, it will be treated like a
list with a single element.`,name:"stop_strings"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L139"}}),Ps=new B({props:{anchor:"transformers.StopStringCriteria.example",$$slots:{default:[s0]},$$scope:{ctx:j}}}),nl=new M({props:{name:"__call__",anchor:"transformers.StopStringCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StopStringCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StopStringCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StopStringCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L409",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),rl=new M({props:{name:"class transformers.EosTokenCriteria",anchor:"transformers.EosTokenCriteria",parameters:[{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L468"}}),ol=new M({props:{name:"__call__",anchor:"transformers.EosTokenCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31155/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EosTokenCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.EosTokenCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/stopping_criteria.py#L485",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),al=new oe({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),cl=new M({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L5"}}),Ys=new B({props:{anchor:"transformers.Constraint.example",$$slots:{default:[n0]},$$scope:{ctx:j}}}),il=new M({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids(<code>torch.tensor</code>)</p>
`}}),dl=new M({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),pl=new M({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L60"}}),ml=new M({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L104"}}),gl=new M({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L94"}}),hl=new M({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L24"}}),ul=new M({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),fl=new M({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L129"}}),_l=new M({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L261"}}),bl=new M({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": List"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L351"}}),yl=new M({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L383"}}),Tl=new M({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": Optional"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_constraints.py#L418"}}),vl=new oe({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),Ml=new M({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L91"}}),wl=new M({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>~PreTrainedModel.group_beam_search</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),kl=new M({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),$l=new M({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L123"}}),jl=new M({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"group_index",val:": Optional = 0"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L215"}}),xl=new M({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L320"}}),Jl=new M({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": List"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/pr_31155/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L419"}}),Ul=new M({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_31155/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_31155/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Zl=new M({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Union = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/beam_search.py#L813"}}),Bl=new oe({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),Wl=new M({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/streamers.py#L38"}}),rn=new En({props:{warning:!0,$$slots:{default:[r0]},$$scope:{ctx:j}}}),on=new B({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[o0]},$$scope:{ctx:j}}}),zl=new M({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/streamers.py#L116"}}),Il=new M({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/streamers.py#L130"}}),Cl=new M({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/streamers.py#L82"}}),Vl=new M({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/streamers.py#L159"}}),dn=new En({props:{warning:!0,$$slots:{default:[a0]},$$scope:{ctx:j}}}),pn=new B({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[l0]},$$scope:{ctx:j}}}),Ll=new M({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/streamers.py#L213"}}),Gl=new oe({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),Fl=new M({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L26"}}),Xl=new M({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L32",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Rl=new M({props:{name:"class transformers.CacheConfig",anchor:"transformers.CacheConfig",parameters:[{name:"cache_implementation",val:": None"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L98"}}),Sl=new M({props:{name:"update",anchor:"transformers.CacheConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CacheConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L171",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),El=new M({props:{name:"class transformers.QuantizedCacheConfig",anchor:"transformers.QuantizedCacheConfig",parameters:[{name:"backend",val:": str = 'quanto'"},{name:"nbits",val:": Optional = 4"},{name:"axis_key",val:": Optional = 0"},{name:"axis_value",val:": Optional = 0"},{name:"q_group_size",val:": Optional = 64"},{name:"residual_length",val:": Optional = 128"},{name:"compute_dtype",val:": Optional = torch.float16"},{name:"device",val:": Optional = 'cpu'"}],parametersDescription:[{anchor:"transformers.QuantizedCacheConfig.backend",description:`<strong>backend</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quanto&quot;</code>) &#x2014;
Backend to use when performing quantization, Can be one of [<code>quanto</code>, <code>HQQ</code>]`,name:"backend"},{anchor:"transformers.QuantizedCacheConfig.nbits",description:`<strong>nbits</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of bits, can be 2 or 4 for the <code>quanto</code> backend and one of [1, 2, 3, 4, 8] for the <code>HQQ</code> backend. Defaults to 2.`,name:"nbits"},{anchor:"transformers.QuantizedCacheConfig.axis_key",description:`<strong>axis_key</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the key tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_key"},{anchor:"transformers.QuantizedCacheConfig.axis_value",description:`<strong>axis_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the value tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_value"},{anchor:"transformers.QuantizedCacheConfig.q_group_size",description:`<strong>q_group_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the quantization group, should be a divisor of the model&#x2019;s hidden dimension.
Defaults to 64.`,name:"q_group_size"},{anchor:"transformers.QuantizedCacheConfig.residual_length",description:`<strong>residual_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 128) &#x2014;
Length of the residual cache which will always be stored in original presicion.
Defaults to 128.`,name:"residual_length"},{anchor:"transformers.QuantizedCacheConfig.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The defualt dtype used for computations in the model. Keys and Values will be cast to this dtype after dequantization.`,name:"compute_dtype"},{anchor:"transformers.QuantizedCacheConfig.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
Device on which to perform computations, should be same as the model&#x2019;s device.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L194"}}),Nl=new M({props:{name:"validate",anchor:"transformers.QuantizedCacheConfig.validate",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L240"}}),Hl=new M({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L293"}}),ql=new M({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L331",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Dl=new M({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L368"}}),Ql=new M({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L78"}}),Pl=new M({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L379"}}),Yl=new M({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L387"}}),Al=new M({props:{name:"class transformers.QuantizedCache",anchor:"transformers.QuantizedCache",parameters:[{name:"cache_config",val:": QuantizedCacheConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L450"}}),Ol=new M({props:{name:"update",anchor:"transformers.QuantizedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L478"}}),Kl=new M({props:{name:"get_seq_length",anchor:"transformers.QuantizedCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L519"}}),ec=new M({props:{name:"class transformers.QuantoQuantizedCache",anchor:"transformers.QuantoQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.QuantoQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>,) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L537"}}),tc=new M({props:{name:"class transformers.HQQQuantizedCache",anchor:"transformers.HQQQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.HQQQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>,) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L578"}}),sc=new M({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L621"}}),nc=new M({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L693",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),rc=new M({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L681"}}),oc=new M({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L78"}}),ac=new M({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": int"},{name:"device",val:""},{name:"dtype",val:" = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.StaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L788"}}),lc=new M({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> needs the <code>cache_position</code> input
to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L832",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),cc=new M({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L866"}}),ic=new M({props:{name:"reset",anchor:"transformers.StaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/cache_utils.py#L877"}}),dc=new oe({props:{title:"Watermark Utils",local:"transformers.WatermarkDetector",headingTag:"h2"}}),pc=new M({props:{name:"class transformers.WatermarkDetector",anchor:"transformers.WatermarkDetector",parameters:[{name:"model_config",val:": PretrainedConfig"},{name:"device",val:": str"},{name:"watermarking_config",val:": Union"},{name:"ignore_repeated_ngrams",val:": bool = False"},{name:"max_cache_size",val:": int = 128"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to get model specific arguments used when generating.`,name:"model_config"},{anchor:"transformers.WatermarkDetector.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device which was used during watermarked text generation.`,name:"device"},{anchor:"transformers.WatermarkDetector.watermarking_config",description:`<strong>watermarking_config</strong> (Union[<code>WatermarkingConfig</code>, <code>Dict</code>]) &#x2014;
The exact same watermarking config and arguments used when generating text.`,name:"watermarking_config"},{anchor:"transformers.WatermarkDetector.ignore_repeated_ngrams",description:`<strong>ignore_repeated_ngrams</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to count every unique ngram only once or not.`,name:"ignore_repeated_ngrams"},{anchor:"transformers.WatermarkDetector.max_cache_size",description:`<strong>max_cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The max size to be used for LRU caching of seeding/sampling algorithms called for every token.`,name:"max_cache_size"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/watermarking.py#L70"}}),Jn=new B({props:{anchor:"transformers.WatermarkDetector.example",$$slots:{default:[c0]},$$scope:{ctx:j}}}),mc=new M({props:{name:"__call__",anchor:"transformers.WatermarkDetector.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"z_threshold",val:": float = 3.0"},{name:"return_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The watermark generated text. It is advised to remove the prompt, which can affect the detection.`,name:"input_ids"},{anchor:"transformers.WatermarkDetector.__call__.z_threshold",description:`<strong>z_threshold</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>3.0</code>) &#x2014;
Changing this threshold will change the sensitivity of the detector. Higher z threshold gives less
sensitivity and vice versa for lower z threshold.`,name:"z_threshold"},{anchor:"transformers.WatermarkDetector.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>,  <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return <code>~generation.WatermarkDetectorOutput</code> or not. If not it will return boolean predictions,`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31155/src/transformers/generation/watermarking.py#L190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>WatermarkDetectorOutput</code>
if <code>return_dict=True</code> otherwise a <code>np.array</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WatermarkDetectorOutput</code> or <code>np.array</code></p>
`}}),gc=new Mj({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/generation_utils.md"}}),{c(){i=a("meta"),$=n(),y=a("p"),_=n(),p(w.$$.fragment),o=n(),k=a("p"),k.innerHTML=JM,ph=n(),p(Nn.$$.fragment),mh=n(),Hn=a("p"),Hn.innerHTML=UM,gh=n(),qn=a("p"),qn.textContent=ZM,hh=n(),p(Dn.$$.fragment),uh=n(),Qn=a("p"),Qn.innerHTML=BM,fh=n(),Pn=a("ul"),Pn.innerHTML=WM,_h=n(),Yn=a("p"),Yn.innerHTML=zM,bh=n(),An=a("p"),An.innerHTML=IM,yh=n(),On=a("p"),On.innerHTML=CM,Th=n(),p(Kn.$$.fragment),vh=n(),er=a("p"),er.innerHTML=VM,Mh=n(),tr=a("p"),tr.innerHTML=LM,wh=n(),sr=a("p"),sr.textContent=GM,kh=n(),p(nr.$$.fragment),$h=n(),Xt=a("div"),p(rr.$$.fragment),v_=n(),Bc=a("p"),Bc.textContent=FM,jh=n(),Rt=a("div"),p(or.$$.fragment),M_=n(),Wc=a("p"),Wc.textContent=XM,xh=n(),St=a("div"),p(ar.$$.fragment),w_=n(),zc=a("p"),zc.textContent=RM,Jh=n(),Et=a("div"),p(lr.$$.fragment),k_=n(),Ic=a("p"),Ic.textContent=SM,Uh=n(),p(cr.$$.fragment),Zh=n(),Nt=a("div"),p(ir.$$.fragment),$_=n(),Cc=a("p"),Cc.textContent=EM,Bh=n(),Ht=a("div"),p(dr.$$.fragment),j_=n(),Vc=a("p"),Vc.textContent=NM,Wh=n(),qt=a("div"),p(pr.$$.fragment),x_=n(),Lc=a("p"),Lc.textContent=HM,zh=n(),Dt=a("div"),p(mr.$$.fragment),J_=n(),Gc=a("p"),Gc.textContent=qM,Ih=n(),Qt=a("div"),p(gr.$$.fragment),U_=n(),Fc=a("p"),Fc.textContent=DM,Ch=n(),Pt=a("div"),p(hr.$$.fragment),Z_=n(),Xc=a("p"),Xc.textContent=QM,Vh=n(),Yt=a("div"),p(ur.$$.fragment),B_=n(),Rc=a("p"),Rc.textContent=PM,Lh=n(),At=a("div"),p(fr.$$.fragment),W_=n(),Sc=a("p"),Sc.textContent=YM,Gh=n(),Ot=a("div"),p(_r.$$.fragment),z_=n(),Ec=a("p"),Ec.textContent=AM,Fh=n(),Kt=a("div"),p(br.$$.fragment),I_=n(),Nc=a("p"),Nc.textContent=OM,Xh=n(),p(yr.$$.fragment),Rh=n(),Ce=a("div"),p(Tr.$$.fragment),C_=n(),Hc=a("p"),Hc.textContent=KM,V_=n(),is=a("div"),p(vr.$$.fragment),L_=n(),qc=a("p"),qc.textContent=ew,Sh=n(),Ve=a("div"),p(Mr.$$.fragment),G_=n(),Dc=a("p"),Dc.textContent=tw,F_=n(),ds=a("div"),p(wr.$$.fragment),X_=n(),Qc=a("p"),Qc.textContent=sw,Eh=n(),Le=a("div"),p(kr.$$.fragment),R_=n(),Pc=a("p"),Pc.textContent=nw,S_=n(),ps=a("div"),p($r.$$.fragment),E_=n(),Yc=a("p"),Yc.textContent=rw,Nh=n(),p(jr.$$.fragment),Hh=n(),xr=a("p"),xr.innerHTML=ow,qh=n(),p(Jr.$$.fragment),Dh=n(),le=a("div"),p(Ur.$$.fragment),N_=n(),Ac=a("p"),Ac.innerHTML=aw,H_=n(),p(ms.$$.fragment),q_=n(),Oc=a("div"),p(Zr.$$.fragment),Qh=n(),V=a("div"),p(Br.$$.fragment),D_=n(),Kc=a("p"),Kc.innerHTML=lw,Q_=n(),ei=a("p"),ei.innerHTML=cw,P_=n(),p(gs.$$.fragment),Y_=n(),p(hs.$$.fragment),A_=n(),ti=a("div"),p(Wr.$$.fragment),Ph=n(),H=a("div"),p(zr.$$.fragment),O_=n(),si=a("p"),si.innerHTML=iw,K_=n(),ni=a("p"),ni.textContent=dw,eb=n(),p(us.$$.fragment),tb=n(),ri=a("div"),p(Ir.$$.fragment),Yh=n(),q=a("div"),p(Cr.$$.fragment),sb=n(),oi=a("p"),oi.innerHTML=pw,nb=n(),ai=a("p"),ai.textContent=mw,rb=n(),p(fs.$$.fragment),ob=n(),li=a("div"),p(Vr.$$.fragment),Ah=n(),ce=a("div"),p(Lr.$$.fragment),ab=n(),ci=a("p"),ci.innerHTML=gw,lb=n(),p(_s.$$.fragment),cb=n(),ii=a("div"),p(Gr.$$.fragment),Oh=n(),ie=a("div"),p(Fr.$$.fragment),ib=n(),di=a("p"),di.innerHTML=hw,db=n(),p(bs.$$.fragment),pb=n(),pi=a("div"),p(Xr.$$.fragment),Kh=n(),de=a("div"),p(Rr.$$.fragment),mb=n(),mi=a("p"),mi.innerHTML=uw,gb=n(),p(ys.$$.fragment),hb=n(),gi=a("div"),p(Sr.$$.fragment),eu=n(),pe=a("div"),p(Er.$$.fragment),ub=n(),hi=a("p"),hi.innerHTML=fw,fb=n(),p(Ts.$$.fragment),_b=n(),ui=a("div"),p(Nr.$$.fragment),tu=n(),me=a("div"),p(Hr.$$.fragment),bb=n(),fi=a("p"),fi.innerHTML=_w,yb=n(),p(vs.$$.fragment),Tb=n(),_i=a("div"),p(qr.$$.fragment),su=n(),Ge=a("div"),p(Dr.$$.fragment),vb=n(),bi=a("p"),bi.innerHTML=bw,Mb=n(),yi=a("div"),p(Qr.$$.fragment),nu=n(),L=a("div"),p(Pr.$$.fragment),wb=n(),Ti=a("p"),Ti.innerHTML=yw,kb=n(),vi=a("p"),vi.innerHTML=Tw,$b=n(),Mi=a("p"),Mi.innerHTML=vw,jb=n(),p(Ms.$$.fragment),xb=n(),wi=a("div"),p(Yr.$$.fragment),ru=n(),ge=a("div"),p(Ar.$$.fragment),Jb=n(),ki=a("p"),ki.innerHTML=Mw,Ub=n(),$i=a("p"),$i.innerHTML=ww,Zb=n(),ji=a("div"),p(Or.$$.fragment),ou=n(),he=a("div"),p(Kr.$$.fragment),Bb=n(),xi=a("p"),xi.innerHTML=kw,Wb=n(),p(ws.$$.fragment),zb=n(),Ji=a("div"),p(eo.$$.fragment),au=n(),Fe=a("div"),p(to.$$.fragment),Ib=n(),Ui=a("p"),Ui.textContent=$w,Cb=n(),Zi=a("div"),p(so.$$.fragment),lu=n(),Xe=a("div"),p(no.$$.fragment),Vb=n(),Bi=a("p"),Bi.innerHTML=jw,Lb=n(),Wi=a("div"),p(ro.$$.fragment),cu=n(),Re=a("div"),p(oo.$$.fragment),Gb=n(),zi=a("p"),zi.textContent=xw,Fb=n(),Ii=a("div"),p(ao.$$.fragment),iu=n(),ue=a("div"),p(lo.$$.fragment),Xb=n(),Ci=a("p"),Ci.innerHTML=Jw,Rb=n(),p(ks.$$.fragment),Sb=n(),Vi=a("div"),p(co.$$.fragment),du=n(),fe=a("div"),p(io.$$.fragment),Eb=n(),Li=a("p"),Li.innerHTML=Uw,Nb=n(),p($s.$$.fragment),Hb=n(),Gi=a("div"),p(po.$$.fragment),pu=n(),G=a("div"),p(mo.$$.fragment),qb=n(),Fi=a("p"),Fi.innerHTML=Zw,Db=n(),Xi=a("p"),Xi.innerHTML=Bw,Qb=n(),Ri=a("p"),Ri.innerHTML=Ww,Pb=n(),p(js.$$.fragment),Yb=n(),Si=a("div"),p(go.$$.fragment),mu=n(),D=a("div"),p(ho.$$.fragment),Ab=n(),Ei=a("p"),Ei.innerHTML=zw,Ob=n(),p(xs.$$.fragment),Kb=n(),p(Js.$$.fragment),ey=n(),Ni=a("div"),p(uo.$$.fragment),gu=n(),Q=a("div"),p(fo.$$.fragment),ty=n(),Hi=a("p"),Hi.innerHTML=Iw,sy=n(),p(Us.$$.fragment),ny=n(),p(Zs.$$.fragment),ry=n(),qi=a("div"),p(_o.$$.fragment),hu=n(),_e=a("div"),p(bo.$$.fragment),oy=n(),Di=a("p"),Di.innerHTML=Cw,ay=n(),p(Bs.$$.fragment),ly=n(),Qi=a("div"),p(yo.$$.fragment),uu=n(),P=a("div"),p(To.$$.fragment),cy=n(),Pi=a("p"),Pi.innerHTML=Vw,iy=n(),Yi=a("p"),Yi.innerHTML=Lw,dy=n(),p(Ws.$$.fragment),py=n(),Ai=a("div"),p(vo.$$.fragment),fu=n(),Y=a("div"),p(Mo.$$.fragment),my=n(),Oi=a("p"),Oi.innerHTML=Gw,gy=n(),p(zs.$$.fragment),hy=n(),p(Is.$$.fragment),uy=n(),Ki=a("div"),p(wo.$$.fragment),_u=n(),be=a("div"),p(ko.$$.fragment),fy=n(),ed=a("p"),ed.innerHTML=Fw,_y=n(),p(Cs.$$.fragment),by=n(),td=a("div"),p($o.$$.fragment),bu=n(),ye=a("div"),p(jo.$$.fragment),yy=n(),sd=a("p"),sd.innerHTML=Xw,Ty=n(),p(Vs.$$.fragment),vy=n(),nd=a("div"),p(xo.$$.fragment),yu=n(),A=a("div"),p(Jo.$$.fragment),My=n(),rd=a("p"),rd.innerHTML=Rw,wy=n(),p(Ls.$$.fragment),ky=n(),p(Gs.$$.fragment),$y=n(),od=a("div"),p(Uo.$$.fragment),Tu=n(),Te=a("div"),p(Zo.$$.fragment),jy=n(),ad=a("p"),ad.innerHTML=Sw,xy=n(),p(Fs.$$.fragment),Jy=n(),ld=a("div"),p(Bo.$$.fragment),vu=n(),ve=a("div"),p(Wo.$$.fragment),Uy=n(),cd=a("p"),cd.innerHTML=Ew,Zy=n(),p(Xs.$$.fragment),By=n(),id=a("div"),p(zo.$$.fragment),Mu=n(),O=a("div"),p(Io.$$.fragment),Wy=n(),dd=a("p"),dd.innerHTML=Nw,zy=n(),pd=a("p"),pd.innerHTML=Hw,Iy=n(),p(Rs.$$.fragment),Cy=n(),md=a("div"),p(Co.$$.fragment),wu=n(),K=a("div"),p(Vo.$$.fragment),Vy=n(),gd=a("p"),gd.innerHTML=qw,Ly=n(),hd=a("p"),hd.innerHTML=Dw,Gy=n(),p(Ss.$$.fragment),Fy=n(),ud=a("div"),p(Lo.$$.fragment),ku=n(),ee=a("div"),p(Go.$$.fragment),Xy=n(),fd=a("p"),fd.innerHTML=Qw,Ry=n(),_d=a("p"),_d.innerHTML=Pw,Sy=n(),p(Es.$$.fragment),Ey=n(),bd=a("div"),p(Fo.$$.fragment),$u=n(),F=a("div"),p(Xo.$$.fragment),Ny=n(),yd=a("p"),yd.innerHTML=Yw,Hy=n(),Td=a("p"),Td.innerHTML=Aw,qy=n(),vd=a("p"),vd.innerHTML=Ow,Dy=n(),p(Ns.$$.fragment),Qy=n(),Md=a("div"),p(Ro.$$.fragment),ju=n(),p(So.$$.fragment),xu=n(),Se=a("div"),p(Eo.$$.fragment),Py=n(),wd=a("p"),wd.innerHTML=Kw,Yy=n(),kd=a("div"),p(No.$$.fragment),Ju=n(),Ee=a("div"),p(Ho.$$.fragment),Ay=n(),$d=a("p"),$d.innerHTML=ek,Oy=n(),jd=a("div"),p(qo.$$.fragment),Uu=n(),Ne=a("div"),p(Do.$$.fragment),Ky=n(),xd=a("p"),xd.innerHTML=tk,eT=n(),Jd=a("div"),p(Qo.$$.fragment),Zu=n(),He=a("div"),p(Po.$$.fragment),tT=n(),Ud=a("p"),Ud.textContent=sk,sT=n(),Hs=a("div"),p(Yo.$$.fragment),nT=n(),Zd=a("p"),Zd.textContent=nk,Bu=n(),qe=a("div"),p(Ao.$$.fragment),rT=n(),Bd=a("p"),Bd.innerHTML=rk,oT=n(),Wd=a("div"),p(Oo.$$.fragment),Wu=n(),De=a("div"),p(Ko.$$.fragment),aT=n(),zd=a("p"),zd.textContent=ok,lT=n(),qs=a("div"),p(ea.$$.fragment),cT=n(),Id=a("p"),Id.textContent=ak,zu=n(),Qe=a("div"),p(ta.$$.fragment),iT=n(),Cd=a("p"),Cd.innerHTML=lk,dT=n(),Vd=a("div"),p(sa.$$.fragment),Iu=n(),Pe=a("div"),p(na.$$.fragment),pT=n(),Ld=a("p"),Ld.innerHTML=ck,mT=n(),Gd=a("div"),p(ra.$$.fragment),Cu=n(),Ye=a("div"),p(oa.$$.fragment),gT=n(),Fd=a("p"),Fd.innerHTML=ik,hT=n(),Xd=a("div"),p(aa.$$.fragment),Vu=n(),Ae=a("div"),p(la.$$.fragment),uT=n(),Rd=a("p"),Rd.innerHTML=dk,fT=n(),Sd=a("div"),p(ca.$$.fragment),Lu=n(),Oe=a("div"),p(ia.$$.fragment),_T=n(),Ed=a("p"),Ed.innerHTML=pk,bT=n(),Nd=a("div"),p(da.$$.fragment),Gu=n(),Ke=a("div"),p(pa.$$.fragment),yT=n(),Hd=a("p"),Hd.innerHTML=mk,TT=n(),qd=a("div"),p(ma.$$.fragment),Fu=n(),et=a("div"),p(ga.$$.fragment),vT=n(),Dd=a("p"),Dd.innerHTML=gk,MT=n(),Qd=a("div"),p(ha.$$.fragment),Xu=n(),tt=a("div"),p(ua.$$.fragment),wT=n(),Pd=a("p"),Pd.innerHTML=hk,kT=n(),Yd=a("div"),p(fa.$$.fragment),Ru=n(),st=a("div"),p(_a.$$.fragment),$T=n(),Ad=a("p"),Ad.innerHTML=uk,jT=n(),Od=a("div"),p(ba.$$.fragment),Su=n(),p(ya.$$.fragment),Eu=n(),nt=a("div"),p(Ta.$$.fragment),xT=n(),Kd=a("p"),Kd.innerHTML=fk,JT=n(),ep=a("div"),p(va.$$.fragment),Nu=n(),rt=a("div"),p(Ma.$$.fragment),UT=n(),tp=a("p"),tp.innerHTML=_k,ZT=n(),sp=a("div"),p(wa.$$.fragment),Hu=n(),ot=a("div"),p(ka.$$.fragment),BT=n(),np=a("p"),np.innerHTML=bk,WT=n(),rp=a("div"),p($a.$$.fragment),qu=n(),at=a("div"),p(ja.$$.fragment),zT=n(),op=a("p"),op.textContent=yk,IT=n(),Ds=a("div"),p(xa.$$.fragment),CT=n(),ap=a("p"),ap.textContent=Tk,Du=n(),lt=a("div"),p(Ja.$$.fragment),VT=n(),lp=a("p"),lp.innerHTML=vk,LT=n(),cp=a("div"),p(Ua.$$.fragment),Qu=n(),ct=a("div"),p(Za.$$.fragment),GT=n(),ip=a("p"),ip.textContent=Mk,FT=n(),Qs=a("div"),p(Ba.$$.fragment),XT=n(),dp=a("p"),dp.textContent=wk,Pu=n(),it=a("div"),p(Wa.$$.fragment),RT=n(),pp=a("p"),pp.innerHTML=kk,ST=n(),mp=a("div"),p(za.$$.fragment),Yu=n(),dt=a("div"),p(Ia.$$.fragment),ET=n(),gp=a("p"),gp.innerHTML=$k,NT=n(),hp=a("div"),p(Ca.$$.fragment),Au=n(),pt=a("div"),p(Va.$$.fragment),HT=n(),up=a("p"),up.innerHTML=jk,qT=n(),fp=a("div"),p(La.$$.fragment),Ou=n(),mt=a("div"),p(Ga.$$.fragment),DT=n(),_p=a("p"),_p.innerHTML=xk,QT=n(),bp=a("div"),p(Fa.$$.fragment),Ku=n(),gt=a("div"),p(Xa.$$.fragment),PT=n(),yp=a("p"),yp.innerHTML=Jk,YT=n(),Tp=a("div"),p(Ra.$$.fragment),ef=n(),ht=a("div"),p(Sa.$$.fragment),AT=n(),vp=a("p"),vp.innerHTML=Uk,OT=n(),Mp=a("div"),p(Ea.$$.fragment),tf=n(),ut=a("div"),p(Na.$$.fragment),KT=n(),wp=a("p"),wp.innerHTML=Zk,ev=n(),kp=a("div"),p(Ha.$$.fragment),sf=n(),p(qa.$$.fragment),nf=n(),Da=a("p"),Da.innerHTML=Bk,rf=n(),Me=a("div"),p(Qa.$$.fragment),tv=n(),$p=a("p"),$p.textContent=Wk,sv=n(),jp=a("p"),jp.innerHTML=zk,nv=n(),xp=a("div"),p(Pa.$$.fragment),of=n(),es=a("div"),p(Ya.$$.fragment),rv=n(),Jp=a("div"),p(Aa.$$.fragment),af=n(),ft=a("div"),p(Oa.$$.fragment),ov=n(),Up=a("p"),Up.innerHTML=Ik,av=n(),Zp=a("div"),p(Ka.$$.fragment),lf=n(),_t=a("div"),p(el.$$.fragment),lv=n(),Bp=a("p"),Bp.innerHTML=Ck,cv=n(),Wp=a("div"),p(tl.$$.fragment),cf=n(),x=a("div"),p(sl.$$.fragment),iv=n(),zp=a("p"),zp.textContent=Vk,dv=n(),Ip=a("p"),Ip.textContent=Lk,pv=n(),Cp=a("ul"),Cp.innerHTML=Gk,mv=n(),Vp=a("p"),Vp.textContent=Fk,gv=n(),Lp=a("ul"),Lp.innerHTML=Xk,hv=n(),Gp=a("p"),Gp.textContent=Rk,uv=n(),Fp=a("p"),Fp.textContent=Sk,fv=n(),Xp=a("p"),Xp.textContent=Ek,_v=n(),Rp=a("ul"),Rp.innerHTML=Nk,bv=n(),Sp=a("p"),Sp.textContent=Hk,yv=n(),Ep=a("p"),Ep.textContent=qk,Tv=n(),Np=a("p"),Np.textContent=Dk,vv=n(),Hp=a("p"),Hp.textContent=Qk,Mv=n(),qp=a("ul"),qp.innerHTML=Pk,wv=n(),Dp=a("p"),Dp.textContent=Yk,kv=n(),Qp=a("p"),Qp.textContent=Ak,$v=n(),Pp=a("ul"),Pp.innerHTML=Ok,jv=n(),Yp=a("p"),Yp.textContent=Kk,xv=n(),Ap=a("p"),Ap.textContent=e2,Jv=n(),p(Ps.$$.fragment),Uv=n(),Op=a("div"),p(nl.$$.fragment),df=n(),bt=a("div"),p(rl.$$.fragment),Zv=n(),Kp=a("p"),Kp.innerHTML=t2,Bv=n(),em=a("div"),p(ol.$$.fragment),pf=n(),p(al.$$.fragment),mf=n(),ll=a("p"),ll.innerHTML=s2,gf=n(),W=a("div"),p(cl.$$.fragment),Wv=n(),tm=a("p"),tm.textContent=n2,zv=n(),sm=a("p"),sm.textContent=r2,Iv=n(),p(Ys.$$.fragment),Cv=n(),nm=a("p"),nm.textContent=o2,Vv=n(),As=a("div"),p(il.$$.fragment),Lv=n(),rm=a("p"),rm.textContent=a2,Gv=n(),Os=a("div"),p(dl.$$.fragment),Fv=n(),om=a("p"),om.textContent=l2,Xv=n(),Ks=a("div"),p(pl.$$.fragment),Rv=n(),am=a("p"),am.textContent=c2,Sv=n(),en=a("div"),p(ml.$$.fragment),Ev=n(),lm=a("p"),lm.innerHTML=i2,Nv=n(),tn=a("div"),p(gl.$$.fragment),Hv=n(),cm=a("p"),cm.textContent=d2,qv=n(),sn=a("div"),p(hl.$$.fragment),Dv=n(),im=a("p"),im.textContent=p2,Qv=n(),Jt=a("div"),p(ul.$$.fragment),Pv=n(),dm=a("p"),dm.innerHTML=m2,Yv=n(),pm=a("p"),pm.textContent=g2,hf=n(),ts=a("div"),p(fl.$$.fragment),Av=n(),mm=a("p"),mm.innerHTML=h2,uf=n(),ss=a("div"),p(_l.$$.fragment),Ov=n(),gm=a("p"),gm.innerHTML=u2,ff=n(),we=a("div"),p(bl.$$.fragment),Kv=n(),hm=a("p"),hm.textContent=f2,e1=n(),E=a("div"),p(yl.$$.fragment),t1=n(),um=a("p"),um.textContent=_2,s1=n(),fm=a("p"),fm.innerHTML=b2,n1=n(),_m=a("p"),_m.innerHTML=y2,r1=n(),bm=a("p"),bm.innerHTML=T2,o1=n(),ym=a("p"),ym.textContent=v2,a1=n(),nn=a("div"),p(Tl.$$.fragment),l1=n(),Tm=a("p"),Tm.textContent=M2,_f=n(),p(vl.$$.fragment),bf=n(),ke=a("div"),p(Ml.$$.fragment),c1=n(),vm=a("p"),vm.innerHTML=w2,i1=n(),Mm=a("div"),p(wl.$$.fragment),d1=n(),wm=a("div"),p(kl.$$.fragment),yf=n(),X=a("div"),p($l.$$.fragment),p1=n(),km=a("p"),km.innerHTML=k2,m1=n(),$m=a("p"),$m.innerHTML=$2,g1=n(),jm=a("p"),jm.innerHTML=j2,h1=n(),xm=a("div"),p(jl.$$.fragment),u1=n(),Jm=a("div"),p(xl.$$.fragment),Tf=n(),$e=a("div"),p(Jl.$$.fragment),f1=n(),Um=a("p"),Um.innerHTML=x2,_1=n(),Zm=a("div"),p(Ul.$$.fragment),b1=n(),Bm=a("div"),p(Zl.$$.fragment),vf=n(),p(Bl.$$.fragment),Mf=n(),C=a("div"),p(Wl.$$.fragment),y1=n(),Wm=a("p"),Wm.textContent=J2,T1=n(),p(rn.$$.fragment),v1=n(),p(on.$$.fragment),M1=n(),an=a("div"),p(zl.$$.fragment),w1=n(),zm=a("p"),zm.textContent=U2,k1=n(),ln=a("div"),p(Il.$$.fragment),$1=n(),Im=a("p"),Im.textContent=Z2,j1=n(),cn=a("div"),p(Cl.$$.fragment),x1=n(),Cm=a("p"),Cm.textContent=B2,wf=n(),te=a("div"),p(Vl.$$.fragment),J1=n(),Vm=a("p"),Vm.textContent=W2,U1=n(),p(dn.$$.fragment),Z1=n(),p(pn.$$.fragment),B1=n(),mn=a("div"),p(Ll.$$.fragment),W1=n(),Lm=a("p"),Lm.textContent=z2,kf=n(),p(Gl.$$.fragment),$f=n(),yt=a("div"),p(Fl.$$.fragment),z1=n(),Gm=a("p"),Gm.textContent=I2,I1=n(),gn=a("div"),p(Xl.$$.fragment),C1=n(),Fm=a("p"),Fm.innerHTML=C2,jf=n(),Tt=a("div"),p(Rl.$$.fragment),V1=n(),Xm=a("p"),Xm.textContent=V2,L1=n(),hn=a("div"),p(Sl.$$.fragment),G1=n(),Rm=a("p"),Rm.innerHTML=L2,xf=n(),vt=a("div"),p(El.$$.fragment),F1=n(),Sm=a("p"),Sm.textContent=G2,X1=n(),un=a("div"),p(Nl.$$.fragment),R1=n(),Em=a("p"),Em.textContent=F2,Jf=n(),I=a("div"),p(Hl.$$.fragment),S1=n(),Nm=a("p"),Nm.textContent=X2,E1=n(),Hm=a("p"),Hm.innerHTML=R2,N1=n(),fn=a("div"),p(ql.$$.fragment),H1=n(),qm=a("p"),qm.innerHTML=S2,q1=n(),_n=a("div"),p(Dl.$$.fragment),D1=n(),Dm=a("p"),Dm.textContent=E2,Q1=n(),bn=a("div"),p(Ql.$$.fragment),P1=n(),Qm=a("p"),Qm.textContent=N2,Y1=n(),yn=a("div"),p(Pl.$$.fragment),A1=n(),Pm=a("p"),Pm.innerHTML=H2,O1=n(),Tn=a("div"),p(Yl.$$.fragment),K1=n(),Ym=a("p"),Ym.innerHTML=q2,Uf=n(),R=a("div"),p(Al.$$.fragment),eM=n(),Am=a("p"),Am.innerHTML=D2,tM=n(),Om=a("p"),Om.innerHTML=Q2,sM=n(),Km=a("p"),Km.innerHTML=P2,nM=n(),eg=a("div"),p(Ol.$$.fragment),rM=n(),vn=a("div"),p(Kl.$$.fragment),oM=n(),tg=a("p"),tg.textContent=Y2,Zf=n(),ns=a("div"),p(ec.$$.fragment),aM=n(),sg=a("p"),sg.innerHTML=A2,Bf=n(),rs=a("div"),p(tc.$$.fragment),lM=n(),ng=a("p"),ng.innerHTML=O2,Wf=n(),S=a("div"),p(sc.$$.fragment),cM=n(),rg=a("p"),rg.innerHTML=K2,iM=n(),og=a("p"),og.innerHTML=e$,dM=n(),Mn=a("div"),p(nc.$$.fragment),pM=n(),ag=a("p"),ag.innerHTML=t$,mM=n(),wn=a("div"),p(rc.$$.fragment),gM=n(),lg=a("p"),lg.textContent=s$,hM=n(),kn=a("div"),p(oc.$$.fragment),uM=n(),cg=a("p"),cg.textContent=n$,zf=n(),se=a("div"),p(ac.$$.fragment),fM=n(),ig=a("p"),ig.innerHTML=r$,_M=n(),$n=a("div"),p(lc.$$.fragment),bM=n(),dg=a("p"),dg.innerHTML=o$,yM=n(),jn=a("div"),p(cc.$$.fragment),TM=n(),pg=a("p"),pg.textContent=a$,vM=n(),xn=a("div"),p(ic.$$.fragment),MM=n(),mg=a("p"),mg.textContent=l$,If=n(),p(dc.$$.fragment),Cf=n(),ne=a("div"),p(pc.$$.fragment),wM=n(),gg=a("p"),gg.innerHTML=c$,kM=n(),hg=a("p"),hg.innerHTML=i$,$M=n(),p(Jn.$$.fragment),jM=n(),Un=a("div"),p(mc.$$.fragment),xM=n(),ug=a("p"),ug.textContent=d$,Vf=n(),p(gc.$$.fragment),Lf=n(),eh=a("p"),this.h()},l(e){const c=vj("svelte-u9bgzb",document.head);i=l(c,"META",{name:!0,content:!0}),c.forEach(s),$=r(e),y=l(e,"P",{}),T(y).forEach(s),_=r(e),m(w.$$.fragment,e),o=r(e),k=l(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-1fd3g6t"&&(k.innerHTML=JM),ph=r(e),m(Nn.$$.fragment,e),mh=r(e),Hn=l(e,"P",{"data-svelte-h":!0}),b(Hn)!=="svelte-1xgo8yb"&&(Hn.innerHTML=UM),gh=r(e),qn=l(e,"P",{"data-svelte-h":!0}),b(qn)!=="svelte-wwwyth"&&(qn.textContent=ZM),hh=r(e),m(Dn.$$.fragment,e),uh=r(e),Qn=l(e,"P",{"data-svelte-h":!0}),b(Qn)!=="svelte-1so6qsa"&&(Qn.innerHTML=BM),fh=r(e),Pn=l(e,"UL",{"data-svelte-h":!0}),b(Pn)!=="svelte-1arpy9m"&&(Pn.innerHTML=WM),_h=r(e),Yn=l(e,"P",{"data-svelte-h":!0}),b(Yn)!=="svelte-xh59rv"&&(Yn.innerHTML=zM),bh=r(e),An=l(e,"P",{"data-svelte-h":!0}),b(An)!=="svelte-rqavqw"&&(An.innerHTML=IM),yh=r(e),On=l(e,"P",{"data-svelte-h":!0}),b(On)!=="svelte-qr02he"&&(On.innerHTML=CM),Th=r(e),m(Kn.$$.fragment,e),vh=r(e),er=l(e,"P",{"data-svelte-h":!0}),b(er)!=="svelte-114v74y"&&(er.innerHTML=VM),Mh=r(e),tr=l(e,"P",{"data-svelte-h":!0}),b(tr)!=="svelte-13knclg"&&(tr.innerHTML=LM),wh=r(e),sr=l(e,"P",{"data-svelte-h":!0}),b(sr)!=="svelte-gz8gow"&&(sr.textContent=GM),kh=r(e),m(nr.$$.fragment,e),$h=r(e),Xt=l(e,"DIV",{class:!0});var hc=T(Xt);m(rr.$$.fragment,hc),v_=r(hc),Bc=l(hc,"P",{"data-svelte-h":!0}),b(Bc)!=="svelte-k7oes3"&&(Bc.textContent=FM),hc.forEach(s),jh=r(e),Rt=l(e,"DIV",{class:!0});var uc=T(Rt);m(or.$$.fragment,uc),M_=r(uc),Wc=l(uc,"P",{"data-svelte-h":!0}),b(Wc)!=="svelte-111f3sj"&&(Wc.textContent=XM),uc.forEach(s),xh=r(e),St=l(e,"DIV",{class:!0});var fc=T(St);m(ar.$$.fragment,fc),w_=r(fc),zc=l(fc,"P",{"data-svelte-h":!0}),b(zc)!=="svelte-1j3b9cp"&&(zc.textContent=RM),fc.forEach(s),Jh=r(e),Et=l(e,"DIV",{class:!0});var _c=T(Et);m(lr.$$.fragment,_c),k_=r(_c),Ic=l(_c,"P",{"data-svelte-h":!0}),b(Ic)!=="svelte-16r5px1"&&(Ic.textContent=SM),_c.forEach(s),Uh=r(e),m(cr.$$.fragment,e),Zh=r(e),Nt=l(e,"DIV",{class:!0});var bc=T(Nt);m(ir.$$.fragment,bc),$_=r(bc),Cc=l(bc,"P",{"data-svelte-h":!0}),b(Cc)!=="svelte-1bnrp61"&&(Cc.textContent=EM),bc.forEach(s),Bh=r(e),Ht=l(e,"DIV",{class:!0});var yc=T(Ht);m(dr.$$.fragment,yc),j_=r(yc),Vc=l(yc,"P",{"data-svelte-h":!0}),b(Vc)!=="svelte-fenhkk"&&(Vc.textContent=NM),yc.forEach(s),Wh=r(e),qt=l(e,"DIV",{class:!0});var Tc=T(qt);m(pr.$$.fragment,Tc),x_=r(Tc),Lc=l(Tc,"P",{"data-svelte-h":!0}),b(Lc)!=="svelte-1dqtgq4"&&(Lc.textContent=HM),Tc.forEach(s),zh=r(e),Dt=l(e,"DIV",{class:!0});var vc=T(Dt);m(mr.$$.fragment,vc),J_=r(vc),Gc=l(vc,"P",{"data-svelte-h":!0}),b(Gc)!=="svelte-10orfv5"&&(Gc.textContent=qM),vc.forEach(s),Ih=r(e),Qt=l(e,"DIV",{class:!0});var Mc=T(Qt);m(gr.$$.fragment,Mc),U_=r(Mc),Fc=l(Mc,"P",{"data-svelte-h":!0}),b(Fc)!=="svelte-jg8udg"&&(Fc.textContent=DM),Mc.forEach(s),Ch=r(e),Pt=l(e,"DIV",{class:!0});var wc=T(Pt);m(hr.$$.fragment,wc),Z_=r(wc),Xc=l(wc,"P",{"data-svelte-h":!0}),b(Xc)!=="svelte-1i40667"&&(Xc.textContent=QM),wc.forEach(s),Vh=r(e),Yt=l(e,"DIV",{class:!0});var kc=T(Yt);m(ur.$$.fragment,kc),B_=r(kc),Rc=l(kc,"P",{"data-svelte-h":!0}),b(Rc)!=="svelte-n5fi8x"&&(Rc.textContent=PM),kc.forEach(s),Lh=r(e),At=l(e,"DIV",{class:!0});var $c=T(At);m(fr.$$.fragment,$c),W_=r($c),Sc=l($c,"P",{"data-svelte-h":!0}),b(Sc)!=="svelte-h5pj3l"&&(Sc.textContent=YM),$c.forEach(s),Gh=r(e),Ot=l(e,"DIV",{class:!0});var jc=T(Ot);m(_r.$$.fragment,jc),z_=r(jc),Ec=l(jc,"P",{"data-svelte-h":!0}),b(Ec)!=="svelte-b9zq6n"&&(Ec.textContent=AM),jc.forEach(s),Fh=r(e),Kt=l(e,"DIV",{class:!0});var xc=T(Kt);m(br.$$.fragment,xc),I_=r(xc),Nc=l(xc,"P",{"data-svelte-h":!0}),b(Nc)!=="svelte-pru3ks"&&(Nc.textContent=OM),xc.forEach(s),Xh=r(e),m(yr.$$.fragment,e),Rh=r(e),Ce=l(e,"DIV",{class:!0});var os=T(Ce);m(Tr.$$.fragment,os),C_=r(os),Hc=l(os,"P",{"data-svelte-h":!0}),b(Hc)!=="svelte-qoov36"&&(Hc.textContent=KM),V_=r(os),is=l(os,"DIV",{class:!0});var Jc=T(is);m(vr.$$.fragment,Jc),L_=r(Jc),qc=l(Jc,"P",{"data-svelte-h":!0}),b(qc)!=="svelte-5ihtpa"&&(qc.textContent=ew),Jc.forEach(s),os.forEach(s),Sh=r(e),Ve=l(e,"DIV",{class:!0});var as=T(Ve);m(Mr.$$.fragment,as),G_=r(as),Dc=l(as,"P",{"data-svelte-h":!0}),b(Dc)!=="svelte-1tz7qrd"&&(Dc.textContent=tw),F_=r(as),ds=l(as,"DIV",{class:!0});var Uc=T(ds);m(wr.$$.fragment,Uc),X_=r(Uc),Qc=l(Uc,"P",{"data-svelte-h":!0}),b(Qc)!=="svelte-5ihtpa"&&(Qc.textContent=sw),Uc.forEach(s),as.forEach(s),Eh=r(e),Le=l(e,"DIV",{class:!0});var ls=T(Le);m(kr.$$.fragment,ls),R_=r(ls),Pc=l(ls,"P",{"data-svelte-h":!0}),b(Pc)!=="svelte-1tz7qrd"&&(Pc.textContent=nw),S_=r(ls),ps=l(ls,"DIV",{class:!0});var Zc=T(ps);m($r.$$.fragment,Zc),E_=r(Zc),Yc=l(Zc,"P",{"data-svelte-h":!0}),b(Yc)!=="svelte-5ihtpa"&&(Yc.textContent=rw),Zc.forEach(s),ls.forEach(s),Nh=r(e),m(jr.$$.fragment,e),Hh=r(e),xr=l(e,"P",{"data-svelte-h":!0}),b(xr)!=="svelte-1o3n6y2"&&(xr.innerHTML=ow),qh=r(e),m(Jr.$$.fragment,e),Dh=r(e),le=l(e,"DIV",{class:!0});var Mt=T(le);m(Ur.$$.fragment,Mt),N_=r(Mt),Ac=l(Mt,"P",{"data-svelte-h":!0}),b(Ac)!=="svelte-f7b5y9"&&(Ac.innerHTML=aw),H_=r(Mt),m(ms.$$.fragment,Mt),q_=r(Mt),Oc=l(Mt,"DIV",{class:!0});var th=T(Oc);m(Zr.$$.fragment,th),th.forEach(s),Mt.forEach(s),Qh=r(e),V=l(e,"DIV",{class:!0});var re=T(V);m(Br.$$.fragment,re),D_=r(re),Kc=l(re,"P",{"data-svelte-h":!0}),b(Kc)!=="svelte-zt94oi"&&(Kc.innerHTML=lw),Q_=r(re),ei=l(re,"P",{"data-svelte-h":!0}),b(ei)!=="svelte-lu7kru"&&(ei.innerHTML=cw),P_=r(re),m(gs.$$.fragment,re),Y_=r(re),m(hs.$$.fragment,re),A_=r(re),ti=l(re,"DIV",{class:!0});var sh=T(ti);m(Wr.$$.fragment,sh),sh.forEach(s),re.forEach(s),Ph=r(e),H=l(e,"DIV",{class:!0});var je=T(H);m(zr.$$.fragment,je),O_=r(je),si=l(je,"P",{"data-svelte-h":!0}),b(si)!=="svelte-vfor4r"&&(si.innerHTML=iw),K_=r(je),ni=l(je,"P",{"data-svelte-h":!0}),b(ni)!=="svelte-mpy00q"&&(ni.textContent=dw),eb=r(je),m(us.$$.fragment,je),tb=r(je),ri=l(je,"DIV",{class:!0});var nh=T(ri);m(Ir.$$.fragment,nh),nh.forEach(s),je.forEach(s),Yh=r(e),q=l(e,"DIV",{class:!0});var xe=T(q);m(Cr.$$.fragment,xe),sb=r(xe),oi=l(xe,"P",{"data-svelte-h":!0}),b(oi)!=="svelte-8zyz01"&&(oi.innerHTML=pw),nb=r(xe),ai=l(xe,"P",{"data-svelte-h":!0}),b(ai)!=="svelte-3qpgm7"&&(ai.textContent=mw),rb=r(xe),m(fs.$$.fragment,xe),ob=r(xe),li=l(xe,"DIV",{class:!0});var rh=T(li);m(Vr.$$.fragment,rh),rh.forEach(s),xe.forEach(s),Ah=r(e),ce=l(e,"DIV",{class:!0});var wt=T(ce);m(Lr.$$.fragment,wt),ab=r(wt),ci=l(wt,"P",{"data-svelte-h":!0}),b(ci)!=="svelte-fryzeb"&&(ci.innerHTML=gw),lb=r(wt),m(_s.$$.fragment,wt),cb=r(wt),ii=l(wt,"DIV",{class:!0});var oh=T(ii);m(Gr.$$.fragment,oh),oh.forEach(s),wt.forEach(s),Oh=r(e),ie=l(e,"DIV",{class:!0});var kt=T(ie);m(Fr.$$.fragment,kt),ib=r(kt),di=l(kt,"P",{"data-svelte-h":!0}),b(di)!=="svelte-54n45b"&&(di.innerHTML=hw),db=r(kt),m(bs.$$.fragment,kt),pb=r(kt),pi=l(kt,"DIV",{class:!0});var ah=T(pi);m(Xr.$$.fragment,ah),ah.forEach(s),kt.forEach(s),Kh=r(e),de=l(e,"DIV",{class:!0});var $t=T(de);m(Rr.$$.fragment,$t),mb=r($t),mi=l($t,"P",{"data-svelte-h":!0}),b(mi)!=="svelte-1l62fic"&&(mi.innerHTML=uw),gb=r($t),m(ys.$$.fragment,$t),hb=r($t),gi=l($t,"DIV",{class:!0});var lh=T(gi);m(Sr.$$.fragment,lh),lh.forEach(s),$t.forEach(s),eu=r(e),pe=l(e,"DIV",{class:!0});var jt=T(pe);m(Er.$$.fragment,jt),ub=r(jt),hi=l(jt,"P",{"data-svelte-h":!0}),b(hi)!=="svelte-1b9iq3c"&&(hi.innerHTML=fw),fb=r(jt),m(Ts.$$.fragment,jt),_b=r(jt),ui=l(jt,"DIV",{class:!0});var ch=T(ui);m(Nr.$$.fragment,ch),ch.forEach(s),jt.forEach(s),tu=r(e),me=l(e,"DIV",{class:!0});var xt=T(me);m(Hr.$$.fragment,xt),bb=r(xt),fi=l(xt,"P",{"data-svelte-h":!0}),b(fi)!=="svelte-1tct450"&&(fi.innerHTML=_w),yb=r(xt),m(vs.$$.fragment,xt),Tb=r(xt),_i=l(xt,"DIV",{class:!0});var ih=T(_i);m(qr.$$.fragment,ih),ih.forEach(s),xt.forEach(s),su=r(e),Ge=l(e,"DIV",{class:!0});var cs=T(Ge);m(Dr.$$.fragment,cs),vb=r(cs),bi=l(cs,"P",{"data-svelte-h":!0}),b(bi)!=="svelte-lpfxi8"&&(bi.innerHTML=bw),Mb=r(cs),yi=l(cs,"DIV",{class:!0});var dh=T(yi);m(Qr.$$.fragment,dh),dh.forEach(s),cs.forEach(s),nu=r(e),L=l(e,"DIV",{class:!0});var Je=T(L);m(Pr.$$.fragment,Je),wb=r(Je),Ti=l(Je,"P",{"data-svelte-h":!0}),b(Ti)!=="svelte-bnmr5i"&&(Ti.innerHTML=yw),kb=r(Je),vi=l(Je,"P",{"data-svelte-h":!0}),b(vi)!=="svelte-1b0c3nk"&&(vi.innerHTML=Tw),$b=r(Je),Mi=l(Je,"P",{"data-svelte-h":!0}),b(Mi)!=="svelte-2fpu88"&&(Mi.innerHTML=vw),jb=r(Je),m(Ms.$$.fragment,Je),xb=r(Je),wi=l(Je,"DIV",{class:!0});var p$=T(wi);m(Yr.$$.fragment,p$),p$.forEach(s),Je.forEach(s),ru=r(e),ge=l(e,"DIV",{class:!0});var Zn=T(ge);m(Ar.$$.fragment,Zn),Jb=r(Zn),ki=l(Zn,"P",{"data-svelte-h":!0}),b(ki)!=="svelte-znd9fz"&&(ki.innerHTML=Mw),Ub=r(Zn),$i=l(Zn,"P",{"data-svelte-h":!0}),b($i)!=="svelte-1v3r596"&&($i.innerHTML=ww),Zb=r(Zn),ji=l(Zn,"DIV",{class:!0});var m$=T(ji);m(Or.$$.fragment,m$),m$.forEach(s),Zn.forEach(s),ou=r(e),he=l(e,"DIV",{class:!0});var Bn=T(he);m(Kr.$$.fragment,Bn),Bb=r(Bn),xi=l(Bn,"P",{"data-svelte-h":!0}),b(xi)!=="svelte-1tr85cb"&&(xi.innerHTML=kw),Wb=r(Bn),m(ws.$$.fragment,Bn),zb=r(Bn),Ji=l(Bn,"DIV",{class:!0});var g$=T(Ji);m(eo.$$.fragment,g$),g$.forEach(s),Bn.forEach(s),au=r(e),Fe=l(e,"DIV",{class:!0});var fg=T(Fe);m(to.$$.fragment,fg),Ib=r(fg),Ui=l(fg,"P",{"data-svelte-h":!0}),b(Ui)!=="svelte-y1kta5"&&(Ui.textContent=$w),Cb=r(fg),Zi=l(fg,"DIV",{class:!0});var h$=T(Zi);m(so.$$.fragment,h$),h$.forEach(s),fg.forEach(s),lu=r(e),Xe=l(e,"DIV",{class:!0});var _g=T(Xe);m(no.$$.fragment,_g),Vb=r(_g),Bi=l(_g,"P",{"data-svelte-h":!0}),b(Bi)!=="svelte-1blkeu3"&&(Bi.innerHTML=jw),Lb=r(_g),Wi=l(_g,"DIV",{class:!0});var u$=T(Wi);m(ro.$$.fragment,u$),u$.forEach(s),_g.forEach(s),cu=r(e),Re=l(e,"DIV",{class:!0});var bg=T(Re);m(oo.$$.fragment,bg),Gb=r(bg),zi=l(bg,"P",{"data-svelte-h":!0}),b(zi)!=="svelte-th82mu"&&(zi.textContent=xw),Fb=r(bg),Ii=l(bg,"DIV",{class:!0});var f$=T(Ii);m(ao.$$.fragment,f$),f$.forEach(s),bg.forEach(s),iu=r(e),ue=l(e,"DIV",{class:!0});var Wn=T(ue);m(lo.$$.fragment,Wn),Xb=r(Wn),Ci=l(Wn,"P",{"data-svelte-h":!0}),b(Ci)!=="svelte-heqiqg"&&(Ci.innerHTML=Jw),Rb=r(Wn),m(ks.$$.fragment,Wn),Sb=r(Wn),Vi=l(Wn,"DIV",{class:!0});var _$=T(Vi);m(co.$$.fragment,_$),_$.forEach(s),Wn.forEach(s),du=r(e),fe=l(e,"DIV",{class:!0});var zn=T(fe);m(io.$$.fragment,zn),Eb=r(zn),Li=l(zn,"P",{"data-svelte-h":!0}),b(Li)!=="svelte-gffcbr"&&(Li.innerHTML=Uw),Nb=r(zn),m($s.$$.fragment,zn),Hb=r(zn),Gi=l(zn,"DIV",{class:!0});var b$=T(Gi);m(po.$$.fragment,b$),b$.forEach(s),zn.forEach(s),pu=r(e),G=l(e,"DIV",{class:!0});var Ue=T(G);m(mo.$$.fragment,Ue),qb=r(Ue),Fi=l(Ue,"P",{"data-svelte-h":!0}),b(Fi)!=="svelte-p61mmp"&&(Fi.innerHTML=Zw),Db=r(Ue),Xi=l(Ue,"P",{"data-svelte-h":!0}),b(Xi)!=="svelte-1ua2fup"&&(Xi.innerHTML=Bw),Qb=r(Ue),Ri=l(Ue,"P",{"data-svelte-h":!0}),b(Ri)!=="svelte-1fvwhfn"&&(Ri.innerHTML=Ww),Pb=r(Ue),m(js.$$.fragment,Ue),Yb=r(Ue),Si=l(Ue,"DIV",{class:!0});var y$=T(Si);m(go.$$.fragment,y$),y$.forEach(s),Ue.forEach(s),mu=r(e),D=l(e,"DIV",{class:!0});var Ut=T(D);m(ho.$$.fragment,Ut),Ab=r(Ut),Ei=l(Ut,"P",{"data-svelte-h":!0}),b(Ei)!=="svelte-b6mkk8"&&(Ei.innerHTML=zw),Ob=r(Ut),m(xs.$$.fragment,Ut),Kb=r(Ut),m(Js.$$.fragment,Ut),ey=r(Ut),Ni=l(Ut,"DIV",{class:!0});var T$=T(Ni);m(uo.$$.fragment,T$),T$.forEach(s),Ut.forEach(s),gu=r(e),Q=l(e,"DIV",{class:!0});var Zt=T(Q);m(fo.$$.fragment,Zt),ty=r(Zt),Hi=l(Zt,"P",{"data-svelte-h":!0}),b(Hi)!=="svelte-vltv23"&&(Hi.innerHTML=Iw),sy=r(Zt),m(Us.$$.fragment,Zt),ny=r(Zt),m(Zs.$$.fragment,Zt),ry=r(Zt),qi=l(Zt,"DIV",{class:!0});var v$=T(qi);m(_o.$$.fragment,v$),v$.forEach(s),Zt.forEach(s),hu=r(e),_e=l(e,"DIV",{class:!0});var In=T(_e);m(bo.$$.fragment,In),oy=r(In),Di=l(In,"P",{"data-svelte-h":!0}),b(Di)!=="svelte-1xme8jk"&&(Di.innerHTML=Cw),ay=r(In),m(Bs.$$.fragment,In),ly=r(In),Qi=l(In,"DIV",{class:!0});var M$=T(Qi);m(yo.$$.fragment,M$),M$.forEach(s),In.forEach(s),uu=r(e),P=l(e,"DIV",{class:!0});var Bt=T(P);m(To.$$.fragment,Bt),cy=r(Bt),Pi=l(Bt,"P",{"data-svelte-h":!0}),b(Pi)!=="svelte-x0yhkw"&&(Pi.innerHTML=Vw),iy=r(Bt),Yi=l(Bt,"P",{"data-svelte-h":!0}),b(Yi)!=="svelte-qhda5i"&&(Yi.innerHTML=Lw),dy=r(Bt),m(Ws.$$.fragment,Bt),py=r(Bt),Ai=l(Bt,"DIV",{class:!0});var w$=T(Ai);m(vo.$$.fragment,w$),w$.forEach(s),Bt.forEach(s),fu=r(e),Y=l(e,"DIV",{class:!0});var Wt=T(Y);m(Mo.$$.fragment,Wt),my=r(Wt),Oi=l(Wt,"P",{"data-svelte-h":!0}),b(Oi)!=="svelte-n9ecev"&&(Oi.innerHTML=Gw),gy=r(Wt),m(zs.$$.fragment,Wt),hy=r(Wt),m(Is.$$.fragment,Wt),uy=r(Wt),Ki=l(Wt,"DIV",{class:!0});var k$=T(Ki);m(wo.$$.fragment,k$),k$.forEach(s),Wt.forEach(s),_u=r(e),be=l(e,"DIV",{class:!0});var Cn=T(be);m(ko.$$.fragment,Cn),fy=r(Cn),ed=l(Cn,"P",{"data-svelte-h":!0}),b(ed)!=="svelte-84zhq3"&&(ed.innerHTML=Fw),_y=r(Cn),m(Cs.$$.fragment,Cn),by=r(Cn),td=l(Cn,"DIV",{class:!0});var $$=T(td);m($o.$$.fragment,$$),$$.forEach(s),Cn.forEach(s),bu=r(e),ye=l(e,"DIV",{class:!0});var Vn=T(ye);m(jo.$$.fragment,Vn),yy=r(Vn),sd=l(Vn,"P",{"data-svelte-h":!0}),b(sd)!=="svelte-kp6ubc"&&(sd.innerHTML=Xw),Ty=r(Vn),m(Vs.$$.fragment,Vn),vy=r(Vn),nd=l(Vn,"DIV",{class:!0});var j$=T(nd);m(xo.$$.fragment,j$),j$.forEach(s),Vn.forEach(s),yu=r(e),A=l(e,"DIV",{class:!0});var zt=T(A);m(Jo.$$.fragment,zt),My=r(zt),rd=l(zt,"P",{"data-svelte-h":!0}),b(rd)!=="svelte-lju2b2"&&(rd.innerHTML=Rw),wy=r(zt),m(Ls.$$.fragment,zt),ky=r(zt),m(Gs.$$.fragment,zt),$y=r(zt),od=l(zt,"DIV",{class:!0});var x$=T(od);m(Uo.$$.fragment,x$),x$.forEach(s),zt.forEach(s),Tu=r(e),Te=l(e,"DIV",{class:!0});var Ln=T(Te);m(Zo.$$.fragment,Ln),jy=r(Ln),ad=l(Ln,"P",{"data-svelte-h":!0}),b(ad)!=="svelte-o0aw84"&&(ad.innerHTML=Sw),xy=r(Ln),m(Fs.$$.fragment,Ln),Jy=r(Ln),ld=l(Ln,"DIV",{class:!0});var J$=T(ld);m(Bo.$$.fragment,J$),J$.forEach(s),Ln.forEach(s),vu=r(e),ve=l(e,"DIV",{class:!0});var Gn=T(ve);m(Wo.$$.fragment,Gn),Uy=r(Gn),cd=l(Gn,"P",{"data-svelte-h":!0}),b(cd)!=="svelte-1n15vqs"&&(cd.innerHTML=Ew),Zy=r(Gn),m(Xs.$$.fragment,Gn),By=r(Gn),id=l(Gn,"DIV",{class:!0});var U$=T(id);m(zo.$$.fragment,U$),U$.forEach(s),Gn.forEach(s),Mu=r(e),O=l(e,"DIV",{class:!0});var It=T(O);m(Io.$$.fragment,It),Wy=r(It),dd=l(It,"P",{"data-svelte-h":!0}),b(dd)!=="svelte-51gjkl"&&(dd.innerHTML=Nw),zy=r(It),pd=l(It,"P",{"data-svelte-h":!0}),b(pd)!=="svelte-1qmimno"&&(pd.innerHTML=Hw),Iy=r(It),m(Rs.$$.fragment,It),Cy=r(It),md=l(It,"DIV",{class:!0});var Z$=T(md);m(Co.$$.fragment,Z$),Z$.forEach(s),It.forEach(s),wu=r(e),K=l(e,"DIV",{class:!0});var Ct=T(K);m(Vo.$$.fragment,Ct),Vy=r(Ct),gd=l(Ct,"P",{"data-svelte-h":!0}),b(gd)!=="svelte-1dewsn6"&&(gd.innerHTML=qw),Ly=r(Ct),hd=l(Ct,"P",{"data-svelte-h":!0}),b(hd)!=="svelte-5qs7tv"&&(hd.innerHTML=Dw),Gy=r(Ct),m(Ss.$$.fragment,Ct),Fy=r(Ct),ud=l(Ct,"DIV",{class:!0});var B$=T(ud);m(Lo.$$.fragment,B$),B$.forEach(s),Ct.forEach(s),ku=r(e),ee=l(e,"DIV",{class:!0});var Vt=T(ee);m(Go.$$.fragment,Vt),Xy=r(Vt),fd=l(Vt,"P",{"data-svelte-h":!0}),b(fd)!=="svelte-go2qsu"&&(fd.innerHTML=Qw),Ry=r(Vt),_d=l(Vt,"P",{"data-svelte-h":!0}),b(_d)!=="svelte-qmmn5t"&&(_d.innerHTML=Pw),Sy=r(Vt),m(Es.$$.fragment,Vt),Ey=r(Vt),bd=l(Vt,"DIV",{class:!0});var W$=T(bd);m(Fo.$$.fragment,W$),W$.forEach(s),Vt.forEach(s),$u=r(e),F=l(e,"DIV",{class:!0});var Ze=T(F);m(Xo.$$.fragment,Ze),Ny=r(Ze),yd=l(Ze,"P",{"data-svelte-h":!0}),b(yd)!=="svelte-1722u08"&&(yd.innerHTML=Yw),Hy=r(Ze),Td=l(Ze,"P",{"data-svelte-h":!0}),b(Td)!=="svelte-1c4e5ee"&&(Td.innerHTML=Aw),qy=r(Ze),vd=l(Ze,"P",{"data-svelte-h":!0}),b(vd)!=="svelte-y9hsik"&&(vd.innerHTML=Ow),Dy=r(Ze),m(Ns.$$.fragment,Ze),Qy=r(Ze),Md=l(Ze,"DIV",{class:!0});var z$=T(Md);m(Ro.$$.fragment,z$),z$.forEach(s),Ze.forEach(s),ju=r(e),m(So.$$.fragment,e),xu=r(e),Se=l(e,"DIV",{class:!0});var yg=T(Se);m(Eo.$$.fragment,yg),Py=r(yg),wd=l(yg,"P",{"data-svelte-h":!0}),b(wd)!=="svelte-1apka74"&&(wd.innerHTML=Kw),Yy=r(yg),kd=l(yg,"DIV",{class:!0});var I$=T(kd);m(No.$$.fragment,I$),I$.forEach(s),yg.forEach(s),Ju=r(e),Ee=l(e,"DIV",{class:!0});var Tg=T(Ee);m(Ho.$$.fragment,Tg),Ay=r(Tg),$d=l(Tg,"P",{"data-svelte-h":!0}),b($d)!=="svelte-8xgbx0"&&($d.innerHTML=ek),Oy=r(Tg),jd=l(Tg,"DIV",{class:!0});var C$=T(jd);m(qo.$$.fragment,C$),C$.forEach(s),Tg.forEach(s),Uu=r(e),Ne=l(e,"DIV",{class:!0});var vg=T(Ne);m(Do.$$.fragment,vg),Ky=r(vg),xd=l(vg,"P",{"data-svelte-h":!0}),b(xd)!=="svelte-1557waw"&&(xd.innerHTML=tk),eT=r(vg),Jd=l(vg,"DIV",{class:!0});var V$=T(Jd);m(Qo.$$.fragment,V$),V$.forEach(s),vg.forEach(s),Zu=r(e),He=l(e,"DIV",{class:!0});var Mg=T(He);m(Po.$$.fragment,Mg),tT=r(Mg),Ud=l(Mg,"P",{"data-svelte-h":!0}),b(Ud)!=="svelte-y1kta5"&&(Ud.textContent=sk),sT=r(Mg),Hs=l(Mg,"DIV",{class:!0});var Ff=T(Hs);m(Yo.$$.fragment,Ff),nT=r(Ff),Zd=l(Ff,"P",{"data-svelte-h":!0}),b(Zd)!=="svelte-5aspnb"&&(Zd.textContent=nk),Ff.forEach(s),Mg.forEach(s),Bu=r(e),qe=l(e,"DIV",{class:!0});var wg=T(qe);m(Ao.$$.fragment,wg),rT=r(wg),Bd=l(wg,"P",{"data-svelte-h":!0}),b(Bd)!=="svelte-2lse7b"&&(Bd.innerHTML=rk),oT=r(wg),Wd=l(wg,"DIV",{class:!0});var L$=T(Wd);m(Oo.$$.fragment,L$),L$.forEach(s),wg.forEach(s),Wu=r(e),De=l(e,"DIV",{class:!0});var kg=T(De);m(Ko.$$.fragment,kg),aT=r(kg),zd=l(kg,"P",{"data-svelte-h":!0}),b(zd)!=="svelte-th82mu"&&(zd.textContent=ok),lT=r(kg),qs=l(kg,"DIV",{class:!0});var Xf=T(qs);m(ea.$$.fragment,Xf),cT=r(Xf),Id=l(Xf,"P",{"data-svelte-h":!0}),b(Id)!=="svelte-hcoglc"&&(Id.textContent=ak),Xf.forEach(s),kg.forEach(s),zu=r(e),Qe=l(e,"DIV",{class:!0});var $g=T(Qe);m(ta.$$.fragment,$g),iT=r($g),Cd=l($g,"P",{"data-svelte-h":!0}),b(Cd)!=="svelte-1eg39tk"&&(Cd.innerHTML=lk),dT=r($g),Vd=l($g,"DIV",{class:!0});var G$=T(Vd);m(sa.$$.fragment,G$),G$.forEach(s),$g.forEach(s),Iu=r(e),Pe=l(e,"DIV",{class:!0});var jg=T(Pe);m(na.$$.fragment,jg),pT=r(jg),Ld=l(jg,"P",{"data-svelte-h":!0}),b(Ld)!=="svelte-12mgsp5"&&(Ld.innerHTML=ck),mT=r(jg),Gd=l(jg,"DIV",{class:!0});var F$=T(Gd);m(ra.$$.fragment,F$),F$.forEach(s),jg.forEach(s),Cu=r(e),Ye=l(e,"DIV",{class:!0});var xg=T(Ye);m(oa.$$.fragment,xg),gT=r(xg),Fd=l(xg,"P",{"data-svelte-h":!0}),b(Fd)!=="svelte-o5wia1"&&(Fd.innerHTML=ik),hT=r(xg),Xd=l(xg,"DIV",{class:!0});var X$=T(Xd);m(aa.$$.fragment,X$),X$.forEach(s),xg.forEach(s),Vu=r(e),Ae=l(e,"DIV",{class:!0});var Jg=T(Ae);m(la.$$.fragment,Jg),uT=r(Jg),Rd=l(Jg,"P",{"data-svelte-h":!0}),b(Rd)!=="svelte-2hcot8"&&(Rd.innerHTML=dk),fT=r(Jg),Sd=l(Jg,"DIV",{class:!0});var R$=T(Sd);m(ca.$$.fragment,R$),R$.forEach(s),Jg.forEach(s),Lu=r(e),Oe=l(e,"DIV",{class:!0});var Ug=T(Oe);m(ia.$$.fragment,Ug),_T=r(Ug),Ed=l(Ug,"P",{"data-svelte-h":!0}),b(Ed)!=="svelte-e9s1z"&&(Ed.innerHTML=pk),bT=r(Ug),Nd=l(Ug,"DIV",{class:!0});var S$=T(Nd);m(da.$$.fragment,S$),S$.forEach(s),Ug.forEach(s),Gu=r(e),Ke=l(e,"DIV",{class:!0});var Zg=T(Ke);m(pa.$$.fragment,Zg),yT=r(Zg),Hd=l(Zg,"P",{"data-svelte-h":!0}),b(Hd)!=="svelte-a554sd"&&(Hd.innerHTML=mk),TT=r(Zg),qd=l(Zg,"DIV",{class:!0});var E$=T(qd);m(ma.$$.fragment,E$),E$.forEach(s),Zg.forEach(s),Fu=r(e),et=l(e,"DIV",{class:!0});var Bg=T(et);m(ga.$$.fragment,Bg),vT=r(Bg),Dd=l(Bg,"P",{"data-svelte-h":!0}),b(Dd)!=="svelte-1dboyr3"&&(Dd.innerHTML=gk),MT=r(Bg),Qd=l(Bg,"DIV",{class:!0});var N$=T(Qd);m(ha.$$.fragment,N$),N$.forEach(s),Bg.forEach(s),Xu=r(e),tt=l(e,"DIV",{class:!0});var Wg=T(tt);m(ua.$$.fragment,Wg),wT=r(Wg),Pd=l(Wg,"P",{"data-svelte-h":!0}),b(Pd)!=="svelte-175gk62"&&(Pd.innerHTML=hk),kT=r(Wg),Yd=l(Wg,"DIV",{class:!0});var H$=T(Yd);m(fa.$$.fragment,H$),H$.forEach(s),Wg.forEach(s),Ru=r(e),st=l(e,"DIV",{class:!0});var zg=T(st);m(_a.$$.fragment,zg),$T=r(zg),Ad=l(zg,"P",{"data-svelte-h":!0}),b(Ad)!=="svelte-yrdub4"&&(Ad.innerHTML=uk),jT=r(zg),Od=l(zg,"DIV",{class:!0});var q$=T(Od);m(ba.$$.fragment,q$),q$.forEach(s),zg.forEach(s),Su=r(e),m(ya.$$.fragment,e),Eu=r(e),nt=l(e,"DIV",{class:!0});var Ig=T(nt);m(Ta.$$.fragment,Ig),xT=r(Ig),Kd=l(Ig,"P",{"data-svelte-h":!0}),b(Kd)!=="svelte-ddn0e0"&&(Kd.innerHTML=fk),JT=r(Ig),ep=l(Ig,"DIV",{class:!0});var D$=T(ep);m(va.$$.fragment,D$),D$.forEach(s),Ig.forEach(s),Nu=r(e),rt=l(e,"DIV",{class:!0});var Cg=T(rt);m(Ma.$$.fragment,Cg),UT=r(Cg),tp=l(Cg,"P",{"data-svelte-h":!0}),b(tp)!=="svelte-kl7sqk"&&(tp.innerHTML=_k),ZT=r(Cg),sp=l(Cg,"DIV",{class:!0});var Q$=T(sp);m(wa.$$.fragment,Q$),Q$.forEach(s),Cg.forEach(s),Hu=r(e),ot=l(e,"DIV",{class:!0});var Vg=T(ot);m(ka.$$.fragment,Vg),BT=r(Vg),np=l(Vg,"P",{"data-svelte-h":!0}),b(np)!=="svelte-2jdzlp"&&(np.innerHTML=bk),WT=r(Vg),rp=l(Vg,"DIV",{class:!0});var P$=T(rp);m($a.$$.fragment,P$),P$.forEach(s),Vg.forEach(s),qu=r(e),at=l(e,"DIV",{class:!0});var Lg=T(at);m(ja.$$.fragment,Lg),zT=r(Lg),op=l(Lg,"P",{"data-svelte-h":!0}),b(op)!=="svelte-y1kta5"&&(op.textContent=yk),IT=r(Lg),Ds=l(Lg,"DIV",{class:!0});var Rf=T(Ds);m(xa.$$.fragment,Rf),CT=r(Rf),ap=l(Rf,"P",{"data-svelte-h":!0}),b(ap)!=="svelte-1l17mwc"&&(ap.textContent=Tk),Rf.forEach(s),Lg.forEach(s),Du=r(e),lt=l(e,"DIV",{class:!0});var Gg=T(lt);m(Ja.$$.fragment,Gg),VT=r(Gg),lp=l(Gg,"P",{"data-svelte-h":!0}),b(lp)!=="svelte-izhy4b"&&(lp.innerHTML=vk),LT=r(Gg),cp=l(Gg,"DIV",{class:!0});var Y$=T(cp);m(Ua.$$.fragment,Y$),Y$.forEach(s),Gg.forEach(s),Qu=r(e),ct=l(e,"DIV",{class:!0});var Fg=T(ct);m(Za.$$.fragment,Fg),GT=r(Fg),ip=l(Fg,"P",{"data-svelte-h":!0}),b(ip)!=="svelte-th82mu"&&(ip.textContent=Mk),FT=r(Fg),Qs=l(Fg,"DIV",{class:!0});var Sf=T(Qs);m(Ba.$$.fragment,Sf),XT=r(Sf),dp=l(Sf,"P",{"data-svelte-h":!0}),b(dp)!=="svelte-1tcb5cf"&&(dp.textContent=wk),Sf.forEach(s),Fg.forEach(s),Pu=r(e),it=l(e,"DIV",{class:!0});var Xg=T(it);m(Wa.$$.fragment,Xg),RT=r(Xg),pp=l(Xg,"P",{"data-svelte-h":!0}),b(pp)!=="svelte-1xfqfjk"&&(pp.innerHTML=kk),ST=r(Xg),mp=l(Xg,"DIV",{class:!0});var A$=T(mp);m(za.$$.fragment,A$),A$.forEach(s),Xg.forEach(s),Yu=r(e),dt=l(e,"DIV",{class:!0});var Rg=T(dt);m(Ia.$$.fragment,Rg),ET=r(Rg),gp=l(Rg,"P",{"data-svelte-h":!0}),b(gp)!=="svelte-15130b0"&&(gp.innerHTML=$k),NT=r(Rg),hp=l(Rg,"DIV",{class:!0});var O$=T(hp);m(Ca.$$.fragment,O$),O$.forEach(s),Rg.forEach(s),Au=r(e),pt=l(e,"DIV",{class:!0});var Sg=T(pt);m(Va.$$.fragment,Sg),HT=r(Sg),up=l(Sg,"P",{"data-svelte-h":!0}),b(up)!=="svelte-61bk7q"&&(up.innerHTML=jk),qT=r(Sg),fp=l(Sg,"DIV",{class:!0});var K$=T(fp);m(La.$$.fragment,K$),K$.forEach(s),Sg.forEach(s),Ou=r(e),mt=l(e,"DIV",{class:!0});var Eg=T(mt);m(Ga.$$.fragment,Eg),DT=r(Eg),_p=l(Eg,"P",{"data-svelte-h":!0}),b(_p)!=="svelte-3jxd1x"&&(_p.innerHTML=xk),QT=r(Eg),bp=l(Eg,"DIV",{class:!0});var ej=T(bp);m(Fa.$$.fragment,ej),ej.forEach(s),Eg.forEach(s),Ku=r(e),gt=l(e,"DIV",{class:!0});var Ng=T(gt);m(Xa.$$.fragment,Ng),PT=r(Ng),yp=l(Ng,"P",{"data-svelte-h":!0}),b(yp)!=="svelte-5009ec"&&(yp.innerHTML=Jk),YT=r(Ng),Tp=l(Ng,"DIV",{class:!0});var tj=T(Tp);m(Ra.$$.fragment,tj),tj.forEach(s),Ng.forEach(s),ef=r(e),ht=l(e,"DIV",{class:!0});var Hg=T(ht);m(Sa.$$.fragment,Hg),AT=r(Hg),vp=l(Hg,"P",{"data-svelte-h":!0}),b(vp)!=="svelte-1d59306"&&(vp.innerHTML=Uk),OT=r(Hg),Mp=l(Hg,"DIV",{class:!0});var sj=T(Mp);m(Ea.$$.fragment,sj),sj.forEach(s),Hg.forEach(s),tf=r(e),ut=l(e,"DIV",{class:!0});var qg=T(ut);m(Na.$$.fragment,qg),KT=r(qg),wp=l(qg,"P",{"data-svelte-h":!0}),b(wp)!=="svelte-1sygpwz"&&(wp.innerHTML=Zk),ev=r(qg),kp=l(qg,"DIV",{class:!0});var nj=T(kp);m(Ha.$$.fragment,nj),nj.forEach(s),qg.forEach(s),sf=r(e),m(qa.$$.fragment,e),nf=r(e),Da=l(e,"P",{"data-svelte-h":!0}),b(Da)!=="svelte-1nedis"&&(Da.innerHTML=Bk),rf=r(e),Me=l(e,"DIV",{class:!0});var Fn=T(Me);m(Qa.$$.fragment,Fn),tv=r(Fn),$p=l(Fn,"P",{"data-svelte-h":!0}),b($p)!=="svelte-rfvu1k"&&($p.textContent=Wk),sv=r(Fn),jp=l(Fn,"P",{"data-svelte-h":!0}),b(jp)!=="svelte-e1lytz"&&(jp.innerHTML=zk),nv=r(Fn),xp=l(Fn,"DIV",{class:!0});var rj=T(xp);m(Pa.$$.fragment,rj),rj.forEach(s),Fn.forEach(s),of=r(e),es=l(e,"DIV",{class:!0});var Ef=T(es);m(Ya.$$.fragment,Ef),rv=r(Ef),Jp=l(Ef,"DIV",{class:!0});var oj=T(Jp);m(Aa.$$.fragment,oj),oj.forEach(s),Ef.forEach(s),af=r(e),ft=l(e,"DIV",{class:!0});var Dg=T(ft);m(Oa.$$.fragment,Dg),ov=r(Dg),Up=l(Dg,"P",{"data-svelte-h":!0}),b(Up)!=="svelte-4hfu96"&&(Up.innerHTML=Ik),av=r(Dg),Zp=l(Dg,"DIV",{class:!0});var aj=T(Zp);m(Ka.$$.fragment,aj),aj.forEach(s),Dg.forEach(s),lf=r(e),_t=l(e,"DIV",{class:!0});var Qg=T(_t);m(el.$$.fragment,Qg),lv=r(Qg),Bp=l(Qg,"P",{"data-svelte-h":!0}),b(Bp)!=="svelte-q5v59n"&&(Bp.innerHTML=Ck),cv=r(Qg),Wp=l(Qg,"DIV",{class:!0});var lj=T(Wp);m(tl.$$.fragment,lj),lj.forEach(s),Qg.forEach(s),cf=r(e),x=l(e,"DIV",{class:!0});var J=T(x);m(sl.$$.fragment,J),iv=r(J),zp=l(J,"P",{"data-svelte-h":!0}),b(zp)!=="svelte-1rue44"&&(zp.textContent=Vk),dv=r(J),Ip=l(J,"P",{"data-svelte-h":!0}),b(Ip)!=="svelte-we1k7h"&&(Ip.textContent=Lk),pv=r(J),Cp=l(J,"UL",{"data-svelte-h":!0}),b(Cp)!=="svelte-1f6ppg"&&(Cp.innerHTML=Gk),mv=r(J),Vp=l(J,"P",{"data-svelte-h":!0}),b(Vp)!=="svelte-1uu68ip"&&(Vp.textContent=Fk),gv=r(J),Lp=l(J,"UL",{"data-svelte-h":!0}),b(Lp)!=="svelte-izl8df"&&(Lp.innerHTML=Xk),hv=r(J),Gp=l(J,"P",{"data-svelte-h":!0}),b(Gp)!=="svelte-hoqys0"&&(Gp.textContent=Rk),uv=r(J),Fp=l(J,"P",{"data-svelte-h":!0}),b(Fp)!=="svelte-1a9fclk"&&(Fp.textContent=Sk),fv=r(J),Xp=l(J,"P",{"data-svelte-h":!0}),b(Xp)!=="svelte-15ntb9y"&&(Xp.textContent=Ek),_v=r(J),Rp=l(J,"UL",{"data-svelte-h":!0}),b(Rp)!=="svelte-vv46ly"&&(Rp.innerHTML=Nk),bv=r(J),Sp=l(J,"P",{"data-svelte-h":!0}),b(Sp)!=="svelte-1owyk1q"&&(Sp.textContent=Hk),yv=r(J),Ep=l(J,"P",{"data-svelte-h":!0}),b(Ep)!=="svelte-wt8oc0"&&(Ep.textContent=qk),Tv=r(J),Np=l(J,"P",{"data-svelte-h":!0}),b(Np)!=="svelte-ws21yj"&&(Np.textContent=Dk),vv=r(J),Hp=l(J,"P",{"data-svelte-h":!0}),b(Hp)!=="svelte-l6qxzs"&&(Hp.textContent=Qk),Mv=r(J),qp=l(J,"UL",{"data-svelte-h":!0}),b(qp)!=="svelte-p67cyh"&&(qp.innerHTML=Pk),wv=r(J),Dp=l(J,"P",{"data-svelte-h":!0}),b(Dp)!=="svelte-1fg1xi2"&&(Dp.textContent=Yk),kv=r(J),Qp=l(J,"P",{"data-svelte-h":!0}),b(Qp)!=="svelte-1e0ripw"&&(Qp.textContent=Ak),$v=r(J),Pp=l(J,"UL",{"data-svelte-h":!0}),b(Pp)!=="svelte-1v088e0"&&(Pp.innerHTML=Ok),jv=r(J),Yp=l(J,"P",{"data-svelte-h":!0}),b(Yp)!=="svelte-be7vix"&&(Yp.textContent=Kk),xv=r(J),Ap=l(J,"P",{"data-svelte-h":!0}),b(Ap)!=="svelte-1xhdoom"&&(Ap.textContent=e2),Jv=r(J),m(Ps.$$.fragment,J),Uv=r(J),Op=l(J,"DIV",{class:!0});var cj=T(Op);m(nl.$$.fragment,cj),cj.forEach(s),J.forEach(s),df=r(e),bt=l(e,"DIV",{class:!0});var Pg=T(bt);m(rl.$$.fragment,Pg),Zv=r(Pg),Kp=l(Pg,"P",{"data-svelte-h":!0}),b(Kp)!=="svelte-1t19wr8"&&(Kp.innerHTML=t2),Bv=r(Pg),em=l(Pg,"DIV",{class:!0});var ij=T(em);m(ol.$$.fragment,ij),ij.forEach(s),Pg.forEach(s),pf=r(e),m(al.$$.fragment,e),mf=r(e),ll=l(e,"P",{"data-svelte-h":!0}),b(ll)!=="svelte-9ojdym"&&(ll.innerHTML=s2),gf=r(e),W=l(e,"DIV",{class:!0});var z=T(W);m(cl.$$.fragment,z),Wv=r(z),tm=l(z,"P",{"data-svelte-h":!0}),b(tm)!=="svelte-1kh5y5v"&&(tm.textContent=n2),zv=r(z),sm=l(z,"P",{"data-svelte-h":!0}),b(sm)!=="svelte-1ygkifj"&&(sm.textContent=r2),Iv=r(z),m(Ys.$$.fragment,z),Cv=r(z),nm=l(z,"P",{"data-svelte-h":!0}),b(nm)!=="svelte-7kbd1a"&&(nm.textContent=o2),Vv=r(z),As=l(z,"DIV",{class:!0});var Nf=T(As);m(il.$$.fragment,Nf),Lv=r(Nf),rm=l(Nf,"P",{"data-svelte-h":!0}),b(rm)!=="svelte-691079"&&(rm.textContent=a2),Nf.forEach(s),Gv=r(z),Os=l(z,"DIV",{class:!0});var Hf=T(Os);m(dl.$$.fragment,Hf),Fv=r(Hf),om=l(Hf,"P",{"data-svelte-h":!0}),b(om)!=="svelte-dtkk01"&&(om.textContent=l2),Hf.forEach(s),Xv=r(z),Ks=l(z,"DIV",{class:!0});var qf=T(Ks);m(pl.$$.fragment,qf),Rv=r(qf),am=l(qf,"P",{"data-svelte-h":!0}),b(am)!=="svelte-11pa7k0"&&(am.textContent=c2),qf.forEach(s),Sv=r(z),en=l(z,"DIV",{class:!0});var Df=T(en);m(ml.$$.fragment,Df),Ev=r(Df),lm=l(Df,"P",{"data-svelte-h":!0}),b(lm)!=="svelte-57vcuk"&&(lm.innerHTML=i2),Df.forEach(s),Nv=r(z),tn=l(z,"DIV",{class:!0});var Qf=T(tn);m(gl.$$.fragment,Qf),Hv=r(Qf),cm=l(Qf,"P",{"data-svelte-h":!0}),b(cm)!=="svelte-e342dt"&&(cm.textContent=d2),Qf.forEach(s),qv=r(z),sn=l(z,"DIV",{class:!0});var Pf=T(sn);m(hl.$$.fragment,Pf),Dv=r(Pf),im=l(Pf,"P",{"data-svelte-h":!0}),b(im)!=="svelte-vbd5xj"&&(im.textContent=p2),Pf.forEach(s),Qv=r(z),Jt=l(z,"DIV",{class:!0});var Yg=T(Jt);m(ul.$$.fragment,Yg),Pv=r(Yg),dm=l(Yg,"P",{"data-svelte-h":!0}),b(dm)!=="svelte-1c2dshy"&&(dm.innerHTML=m2),Yv=r(Yg),pm=l(Yg,"P",{"data-svelte-h":!0}),b(pm)!=="svelte-1qvu1un"&&(pm.textContent=g2),Yg.forEach(s),z.forEach(s),hf=r(e),ts=l(e,"DIV",{class:!0});var Yf=T(ts);m(fl.$$.fragment,Yf),Av=r(Yf),mm=l(Yf,"P",{"data-svelte-h":!0}),b(mm)!=="svelte-1fc897q"&&(mm.innerHTML=h2),Yf.forEach(s),uf=r(e),ss=l(e,"DIV",{class:!0});var Af=T(ss);m(_l.$$.fragment,Af),Ov=r(Af),gm=l(Af,"P",{"data-svelte-h":!0}),b(gm)!=="svelte-13uqqld"&&(gm.innerHTML=u2),Af.forEach(s),ff=r(e),we=l(e,"DIV",{class:!0});var Xn=T(we);m(bl.$$.fragment,Xn),Kv=r(Xn),hm=l(Xn,"P",{"data-svelte-h":!0}),b(hm)!=="svelte-rxlesw"&&(hm.textContent=f2),e1=r(Xn),E=l(Xn,"DIV",{class:!0});var Be=T(E);m(yl.$$.fragment,Be),t1=r(Be),um=l(Be,"P",{"data-svelte-h":!0}),b(um)!=="svelte-15hhlou"&&(um.textContent=_2),s1=r(Be),fm=l(Be,"P",{"data-svelte-h":!0}),b(fm)!=="svelte-e6h4hs"&&(fm.innerHTML=b2),n1=r(Be),_m=l(Be,"P",{"data-svelte-h":!0}),b(_m)!=="svelte-1w36vm3"&&(_m.innerHTML=y2),r1=r(Be),bm=l(Be,"P",{"data-svelte-h":!0}),b(bm)!=="svelte-1niq0qw"&&(bm.innerHTML=T2),o1=r(Be),ym=l(Be,"P",{"data-svelte-h":!0}),b(ym)!=="svelte-af4g6f"&&(ym.textContent=v2),Be.forEach(s),a1=r(Xn),nn=l(Xn,"DIV",{class:!0});var Of=T(nn);m(Tl.$$.fragment,Of),l1=r(Of),Tm=l(Of,"P",{"data-svelte-h":!0}),b(Tm)!=="svelte-eab6jp"&&(Tm.textContent=M2),Of.forEach(s),Xn.forEach(s),_f=r(e),m(vl.$$.fragment,e),bf=r(e),ke=l(e,"DIV",{class:!0});var Rn=T(ke);m(Ml.$$.fragment,Rn),c1=r(Rn),vm=l(Rn,"P",{"data-svelte-h":!0}),b(vm)!=="svelte-1fikjzl"&&(vm.innerHTML=w2),i1=r(Rn),Mm=l(Rn,"DIV",{class:!0});var dj=T(Mm);m(wl.$$.fragment,dj),dj.forEach(s),d1=r(Rn),wm=l(Rn,"DIV",{class:!0});var pj=T(wm);m(kl.$$.fragment,pj),pj.forEach(s),Rn.forEach(s),yf=r(e),X=l(e,"DIV",{class:!0});var We=T(X);m($l.$$.fragment,We),p1=r(We),km=l(We,"P",{"data-svelte-h":!0}),b(km)!=="svelte-129dis1"&&(km.innerHTML=k2),m1=r(We),$m=l(We,"P",{"data-svelte-h":!0}),b($m)!=="svelte-19qrwo1"&&($m.innerHTML=$2),g1=r(We),jm=l(We,"P",{"data-svelte-h":!0}),b(jm)!=="svelte-l79sbt"&&(jm.innerHTML=j2),h1=r(We),xm=l(We,"DIV",{class:!0});var mj=T(xm);m(jl.$$.fragment,mj),mj.forEach(s),u1=r(We),Jm=l(We,"DIV",{class:!0});var gj=T(Jm);m(xl.$$.fragment,gj),gj.forEach(s),We.forEach(s),Tf=r(e),$e=l(e,"DIV",{class:!0});var Sn=T($e);m(Jl.$$.fragment,Sn),f1=r(Sn),Um=l(Sn,"P",{"data-svelte-h":!0}),b(Um)!=="svelte-2i055i"&&(Um.innerHTML=x2),_1=r(Sn),Zm=l(Sn,"DIV",{class:!0});var hj=T(Zm);m(Ul.$$.fragment,hj),hj.forEach(s),b1=r(Sn),Bm=l(Sn,"DIV",{class:!0});var uj=T(Bm);m(Zl.$$.fragment,uj),uj.forEach(s),Sn.forEach(s),vf=r(e),m(Bl.$$.fragment,e),Mf=r(e),C=l(e,"DIV",{class:!0});var ae=T(C);m(Wl.$$.fragment,ae),y1=r(ae),Wm=l(ae,"P",{"data-svelte-h":!0}),b(Wm)!=="svelte-5jvlz5"&&(Wm.textContent=J2),T1=r(ae),m(rn.$$.fragment,ae),v1=r(ae),m(on.$$.fragment,ae),M1=r(ae),an=l(ae,"DIV",{class:!0});var Kf=T(an);m(zl.$$.fragment,Kf),w1=r(Kf),zm=l(Kf,"P",{"data-svelte-h":!0}),b(zm)!=="svelte-10d94rs"&&(zm.textContent=U2),Kf.forEach(s),k1=r(ae),ln=l(ae,"DIV",{class:!0});var e_=T(ln);m(Il.$$.fragment,e_),$1=r(e_),Im=l(e_,"P",{"data-svelte-h":!0}),b(Im)!=="svelte-tm945r"&&(Im.textContent=Z2),e_.forEach(s),j1=r(ae),cn=l(ae,"DIV",{class:!0});var t_=T(cn);m(Cl.$$.fragment,t_),x1=r(t_),Cm=l(t_,"P",{"data-svelte-h":!0}),b(Cm)!=="svelte-1i1356p"&&(Cm.textContent=B2),t_.forEach(s),ae.forEach(s),wf=r(e),te=l(e,"DIV",{class:!0});var Lt=T(te);m(Vl.$$.fragment,Lt),J1=r(Lt),Vm=l(Lt,"P",{"data-svelte-h":!0}),b(Vm)!=="svelte-190fodr"&&(Vm.textContent=W2),U1=r(Lt),m(dn.$$.fragment,Lt),Z1=r(Lt),m(pn.$$.fragment,Lt),B1=r(Lt),mn=l(Lt,"DIV",{class:!0});var s_=T(mn);m(Ll.$$.fragment,s_),W1=r(s_),Lm=l(s_,"P",{"data-svelte-h":!0}),b(Lm)!=="svelte-16i5iz"&&(Lm.textContent=z2),s_.forEach(s),Lt.forEach(s),kf=r(e),m(Gl.$$.fragment,e),$f=r(e),yt=l(e,"DIV",{class:!0});var Ag=T(yt);m(Fl.$$.fragment,Ag),z1=r(Ag),Gm=l(Ag,"P",{"data-svelte-h":!0}),b(Gm)!=="svelte-15qehu2"&&(Gm.textContent=I2),I1=r(Ag),gn=l(Ag,"DIV",{class:!0});var n_=T(gn);m(Xl.$$.fragment,n_),C1=r(n_),Fm=l(n_,"P",{"data-svelte-h":!0}),b(Fm)!=="svelte-dfcv5s"&&(Fm.innerHTML=C2),n_.forEach(s),Ag.forEach(s),jf=r(e),Tt=l(e,"DIV",{class:!0});var Og=T(Tt);m(Rl.$$.fragment,Og),V1=r(Og),Xm=l(Og,"P",{"data-svelte-h":!0}),b(Xm)!=="svelte-1sqibp"&&(Xm.textContent=V2),L1=r(Og),hn=l(Og,"DIV",{class:!0});var r_=T(hn);m(Sl.$$.fragment,r_),G1=r(r_),Rm=l(r_,"P",{"data-svelte-h":!0}),b(Rm)!=="svelte-n0rwld"&&(Rm.innerHTML=L2),r_.forEach(s),Og.forEach(s),xf=r(e),vt=l(e,"DIV",{class:!0});var Kg=T(vt);m(El.$$.fragment,Kg),F1=r(Kg),Sm=l(Kg,"P",{"data-svelte-h":!0}),b(Sm)!=="svelte-157zylv"&&(Sm.textContent=G2),X1=r(Kg),un=l(Kg,"DIV",{class:!0});var o_=T(un);m(Nl.$$.fragment,o_),R1=r(o_),Em=l(o_,"P",{"data-svelte-h":!0}),b(Em)!=="svelte-15juztn"&&(Em.textContent=F2),o_.forEach(s),Kg.forEach(s),Jf=r(e),I=l(e,"DIV",{class:!0});var N=T(I);m(Hl.$$.fragment,N),S1=r(N),Nm=l(N,"P",{"data-svelte-h":!0}),b(Nm)!=="svelte-11w7j52"&&(Nm.textContent=X2),E1=r(N),Hm=l(N,"P",{"data-svelte-h":!0}),b(Hm)!=="svelte-1f9j82e"&&(Hm.innerHTML=R2),N1=r(N),fn=l(N,"DIV",{class:!0});var a_=T(fn);m(ql.$$.fragment,a_),H1=r(a_),qm=l(a_,"P",{"data-svelte-h":!0}),b(qm)!=="svelte-dfcv5s"&&(qm.innerHTML=S2),a_.forEach(s),q1=r(N),_n=l(N,"DIV",{class:!0});var l_=T(_n);m(Dl.$$.fragment,l_),D1=r(l_),Dm=l(l_,"P",{"data-svelte-h":!0}),b(Dm)!=="svelte-1nftdf9"&&(Dm.textContent=E2),l_.forEach(s),Q1=r(N),bn=l(N,"DIV",{class:!0});var c_=T(bn);m(Ql.$$.fragment,c_),P1=r(c_),Qm=l(c_,"P",{"data-svelte-h":!0}),b(Qm)!=="svelte-114iuj0"&&(Qm.textContent=N2),c_.forEach(s),Y1=r(N),yn=l(N,"DIV",{class:!0});var i_=T(yn);m(Pl.$$.fragment,i_),A1=r(i_),Pm=l(i_,"P",{"data-svelte-h":!0}),b(Pm)!=="svelte-dst59w"&&(Pm.innerHTML=H2),i_.forEach(s),O1=r(N),Tn=l(N,"DIV",{class:!0});var d_=T(Tn);m(Yl.$$.fragment,d_),K1=r(d_),Ym=l(d_,"P",{"data-svelte-h":!0}),b(Ym)!=="svelte-15y4kd1"&&(Ym.innerHTML=q2),d_.forEach(s),N.forEach(s),Uf=r(e),R=l(e,"DIV",{class:!0});var ze=T(R);m(Al.$$.fragment,ze),eM=r(ze),Am=l(ze,"P",{"data-svelte-h":!0}),b(Am)!=="svelte-1x0oesy"&&(Am.innerHTML=D2),tM=r(ze),Om=l(ze,"P",{"data-svelte-h":!0}),b(Om)!=="svelte-2ai6qp"&&(Om.innerHTML=Q2),sM=r(ze),Km=l(ze,"P",{"data-svelte-h":!0}),b(Km)!=="svelte-18fduhd"&&(Km.innerHTML=P2),nM=r(ze),eg=l(ze,"DIV",{class:!0});var fj=T(eg);m(Ol.$$.fragment,fj),fj.forEach(s),rM=r(ze),vn=l(ze,"DIV",{class:!0});var p_=T(vn);m(Kl.$$.fragment,p_),oM=r(p_),tg=l(p_,"P",{"data-svelte-h":!0}),b(tg)!=="svelte-1nftdf9"&&(tg.textContent=Y2),p_.forEach(s),ze.forEach(s),Zf=r(e),ns=l(e,"DIV",{class:!0});var m_=T(ns);m(ec.$$.fragment,m_),aM=r(m_),sg=l(m_,"P",{"data-svelte-h":!0}),b(sg)!=="svelte-pjm1pe"&&(sg.innerHTML=A2),m_.forEach(s),Bf=r(e),rs=l(e,"DIV",{class:!0});var g_=T(rs);m(tc.$$.fragment,g_),lM=r(g_),ng=l(g_,"P",{"data-svelte-h":!0}),b(ng)!=="svelte-api7s7"&&(ng.innerHTML=O2),g_.forEach(s),Wf=r(e),S=l(e,"DIV",{class:!0});var Ie=T(S);m(sc.$$.fragment,Ie),cM=r(Ie),rg=l(Ie,"P",{"data-svelte-h":!0}),b(rg)!=="svelte-ldcea6"&&(rg.innerHTML=K2),iM=r(Ie),og=l(Ie,"P",{"data-svelte-h":!0}),b(og)!=="svelte-1f9j82e"&&(og.innerHTML=e$),dM=r(Ie),Mn=l(Ie,"DIV",{class:!0});var h_=T(Mn);m(nc.$$.fragment,h_),pM=r(h_),ag=l(h_,"P",{"data-svelte-h":!0}),b(ag)!=="svelte-dfcv5s"&&(ag.innerHTML=t$),h_.forEach(s),mM=r(Ie),wn=l(Ie,"DIV",{class:!0});var u_=T(wn);m(rc.$$.fragment,u_),gM=r(u_),lg=l(u_,"P",{"data-svelte-h":!0}),b(lg)!=="svelte-1nftdf9"&&(lg.textContent=s$),u_.forEach(s),hM=r(Ie),kn=l(Ie,"DIV",{class:!0});var f_=T(kn);m(oc.$$.fragment,f_),uM=r(f_),cg=l(f_,"P",{"data-svelte-h":!0}),b(cg)!=="svelte-114iuj0"&&(cg.textContent=n$),f_.forEach(s),Ie.forEach(s),zf=r(e),se=l(e,"DIV",{class:!0});var Gt=T(se);m(ac.$$.fragment,Gt),fM=r(Gt),ig=l(Gt,"P",{"data-svelte-h":!0}),b(ig)!=="svelte-109wkq1"&&(ig.innerHTML=r$),_M=r(Gt),$n=l(Gt,"DIV",{class:!0});var __=T($n);m(lc.$$.fragment,__),bM=r(__),dg=l(__,"P",{"data-svelte-h":!0}),b(dg)!=="svelte-vi6d54"&&(dg.innerHTML=o$),__.forEach(s),yM=r(Gt),jn=l(Gt,"DIV",{class:!0});var b_=T(jn);m(cc.$$.fragment,b_),TM=r(b_),pg=l(b_,"P",{"data-svelte-h":!0}),b(pg)!=="svelte-14hqs6n"&&(pg.textContent=a$),b_.forEach(s),vM=r(Gt),xn=l(Gt,"DIV",{class:!0});var y_=T(xn);m(ic.$$.fragment,y_),MM=r(y_),mg=l(y_,"P",{"data-svelte-h":!0}),b(mg)!=="svelte-135okg0"&&(mg.textContent=l$),y_.forEach(s),Gt.forEach(s),If=r(e),m(dc.$$.fragment,e),Cf=r(e),ne=l(e,"DIV",{class:!0});var Ft=T(ne);m(pc.$$.fragment,Ft),wM=r(Ft),gg=l(Ft,"P",{"data-svelte-h":!0}),b(gg)!=="svelte-17osgxw"&&(gg.innerHTML=c$),kM=r(Ft),hg=l(Ft,"P",{"data-svelte-h":!0}),b(hg)!=="svelte-y9hsik"&&(hg.innerHTML=i$),$M=r(Ft),m(Jn.$$.fragment,Ft),jM=r(Ft),Un=l(Ft,"DIV",{class:!0});var T_=T(Un);m(mc.$$.fragment,T_),xM=r(T_),ug=l(T_,"P",{"data-svelte-h":!0}),b(ug)!=="svelte-8xv78e"&&(ug.textContent=d$),T_.forEach(s),Ft.forEach(s),Vf=r(e),m(gc.$$.fragment,e),Lf=r(e),eh=l(e,"P",{}),T(eh).forEach(s),this.h()},h(){v(i,"name","hf:doc:metadata"),v(i,"content",d0),v(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(At,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ps,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ti,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ri,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ii,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ui,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Wi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ii,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Si,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ni,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ai,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ki,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ld,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(id,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(md,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ud,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Md,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(kd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Sd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Yd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ds,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Tp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(kp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(es,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Wp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Op,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(em,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(As,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Os,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Zm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Bm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(eg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,i),d(e,$,c),d(e,y,c),d(e,_,c),g(w,e,c),d(e,o,c),d(e,k,c),d(e,ph,c),g(Nn,e,c),d(e,mh,c),d(e,Hn,c),d(e,gh,c),d(e,qn,c),d(e,hh,c),g(Dn,e,c),d(e,uh,c),d(e,Qn,c),d(e,fh,c),d(e,Pn,c),d(e,_h,c),d(e,Yn,c),d(e,bh,c),d(e,An,c),d(e,yh,c),d(e,On,c),d(e,Th,c),g(Kn,e,c),d(e,vh,c),d(e,er,c),d(e,Mh,c),d(e,tr,c),d(e,wh,c),d(e,sr,c),d(e,kh,c),g(nr,e,c),d(e,$h,c),d(e,Xt,c),g(rr,Xt,null),t(Xt,v_),t(Xt,Bc),d(e,jh,c),d(e,Rt,c),g(or,Rt,null),t(Rt,M_),t(Rt,Wc),d(e,xh,c),d(e,St,c),g(ar,St,null),t(St,w_),t(St,zc),d(e,Jh,c),d(e,Et,c),g(lr,Et,null),t(Et,k_),t(Et,Ic),d(e,Uh,c),g(cr,e,c),d(e,Zh,c),d(e,Nt,c),g(ir,Nt,null),t(Nt,$_),t(Nt,Cc),d(e,Bh,c),d(e,Ht,c),g(dr,Ht,null),t(Ht,j_),t(Ht,Vc),d(e,Wh,c),d(e,qt,c),g(pr,qt,null),t(qt,x_),t(qt,Lc),d(e,zh,c),d(e,Dt,c),g(mr,Dt,null),t(Dt,J_),t(Dt,Gc),d(e,Ih,c),d(e,Qt,c),g(gr,Qt,null),t(Qt,U_),t(Qt,Fc),d(e,Ch,c),d(e,Pt,c),g(hr,Pt,null),t(Pt,Z_),t(Pt,Xc),d(e,Vh,c),d(e,Yt,c),g(ur,Yt,null),t(Yt,B_),t(Yt,Rc),d(e,Lh,c),d(e,At,c),g(fr,At,null),t(At,W_),t(At,Sc),d(e,Gh,c),d(e,Ot,c),g(_r,Ot,null),t(Ot,z_),t(Ot,Ec),d(e,Fh,c),d(e,Kt,c),g(br,Kt,null),t(Kt,I_),t(Kt,Nc),d(e,Xh,c),g(yr,e,c),d(e,Rh,c),d(e,Ce,c),g(Tr,Ce,null),t(Ce,C_),t(Ce,Hc),t(Ce,V_),t(Ce,is),g(vr,is,null),t(is,L_),t(is,qc),d(e,Sh,c),d(e,Ve,c),g(Mr,Ve,null),t(Ve,G_),t(Ve,Dc),t(Ve,F_),t(Ve,ds),g(wr,ds,null),t(ds,X_),t(ds,Qc),d(e,Eh,c),d(e,Le,c),g(kr,Le,null),t(Le,R_),t(Le,Pc),t(Le,S_),t(Le,ps),g($r,ps,null),t(ps,E_),t(ps,Yc),d(e,Nh,c),g(jr,e,c),d(e,Hh,c),d(e,xr,c),d(e,qh,c),g(Jr,e,c),d(e,Dh,c),d(e,le,c),g(Ur,le,null),t(le,N_),t(le,Ac),t(le,H_),g(ms,le,null),t(le,q_),t(le,Oc),g(Zr,Oc,null),d(e,Qh,c),d(e,V,c),g(Br,V,null),t(V,D_),t(V,Kc),t(V,Q_),t(V,ei),t(V,P_),g(gs,V,null),t(V,Y_),g(hs,V,null),t(V,A_),t(V,ti),g(Wr,ti,null),d(e,Ph,c),d(e,H,c),g(zr,H,null),t(H,O_),t(H,si),t(H,K_),t(H,ni),t(H,eb),g(us,H,null),t(H,tb),t(H,ri),g(Ir,ri,null),d(e,Yh,c),d(e,q,c),g(Cr,q,null),t(q,sb),t(q,oi),t(q,nb),t(q,ai),t(q,rb),g(fs,q,null),t(q,ob),t(q,li),g(Vr,li,null),d(e,Ah,c),d(e,ce,c),g(Lr,ce,null),t(ce,ab),t(ce,ci),t(ce,lb),g(_s,ce,null),t(ce,cb),t(ce,ii),g(Gr,ii,null),d(e,Oh,c),d(e,ie,c),g(Fr,ie,null),t(ie,ib),t(ie,di),t(ie,db),g(bs,ie,null),t(ie,pb),t(ie,pi),g(Xr,pi,null),d(e,Kh,c),d(e,de,c),g(Rr,de,null),t(de,mb),t(de,mi),t(de,gb),g(ys,de,null),t(de,hb),t(de,gi),g(Sr,gi,null),d(e,eu,c),d(e,pe,c),g(Er,pe,null),t(pe,ub),t(pe,hi),t(pe,fb),g(Ts,pe,null),t(pe,_b),t(pe,ui),g(Nr,ui,null),d(e,tu,c),d(e,me,c),g(Hr,me,null),t(me,bb),t(me,fi),t(me,yb),g(vs,me,null),t(me,Tb),t(me,_i),g(qr,_i,null),d(e,su,c),d(e,Ge,c),g(Dr,Ge,null),t(Ge,vb),t(Ge,bi),t(Ge,Mb),t(Ge,yi),g(Qr,yi,null),d(e,nu,c),d(e,L,c),g(Pr,L,null),t(L,wb),t(L,Ti),t(L,kb),t(L,vi),t(L,$b),t(L,Mi),t(L,jb),g(Ms,L,null),t(L,xb),t(L,wi),g(Yr,wi,null),d(e,ru,c),d(e,ge,c),g(Ar,ge,null),t(ge,Jb),t(ge,ki),t(ge,Ub),t(ge,$i),t(ge,Zb),t(ge,ji),g(Or,ji,null),d(e,ou,c),d(e,he,c),g(Kr,he,null),t(he,Bb),t(he,xi),t(he,Wb),g(ws,he,null),t(he,zb),t(he,Ji),g(eo,Ji,null),d(e,au,c),d(e,Fe,c),g(to,Fe,null),t(Fe,Ib),t(Fe,Ui),t(Fe,Cb),t(Fe,Zi),g(so,Zi,null),d(e,lu,c),d(e,Xe,c),g(no,Xe,null),t(Xe,Vb),t(Xe,Bi),t(Xe,Lb),t(Xe,Wi),g(ro,Wi,null),d(e,cu,c),d(e,Re,c),g(oo,Re,null),t(Re,Gb),t(Re,zi),t(Re,Fb),t(Re,Ii),g(ao,Ii,null),d(e,iu,c),d(e,ue,c),g(lo,ue,null),t(ue,Xb),t(ue,Ci),t(ue,Rb),g(ks,ue,null),t(ue,Sb),t(ue,Vi),g(co,Vi,null),d(e,du,c),d(e,fe,c),g(io,fe,null),t(fe,Eb),t(fe,Li),t(fe,Nb),g($s,fe,null),t(fe,Hb),t(fe,Gi),g(po,Gi,null),d(e,pu,c),d(e,G,c),g(mo,G,null),t(G,qb),t(G,Fi),t(G,Db),t(G,Xi),t(G,Qb),t(G,Ri),t(G,Pb),g(js,G,null),t(G,Yb),t(G,Si),g(go,Si,null),d(e,mu,c),d(e,D,c),g(ho,D,null),t(D,Ab),t(D,Ei),t(D,Ob),g(xs,D,null),t(D,Kb),g(Js,D,null),t(D,ey),t(D,Ni),g(uo,Ni,null),d(e,gu,c),d(e,Q,c),g(fo,Q,null),t(Q,ty),t(Q,Hi),t(Q,sy),g(Us,Q,null),t(Q,ny),g(Zs,Q,null),t(Q,ry),t(Q,qi),g(_o,qi,null),d(e,hu,c),d(e,_e,c),g(bo,_e,null),t(_e,oy),t(_e,Di),t(_e,ay),g(Bs,_e,null),t(_e,ly),t(_e,Qi),g(yo,Qi,null),d(e,uu,c),d(e,P,c),g(To,P,null),t(P,cy),t(P,Pi),t(P,iy),t(P,Yi),t(P,dy),g(Ws,P,null),t(P,py),t(P,Ai),g(vo,Ai,null),d(e,fu,c),d(e,Y,c),g(Mo,Y,null),t(Y,my),t(Y,Oi),t(Y,gy),g(zs,Y,null),t(Y,hy),g(Is,Y,null),t(Y,uy),t(Y,Ki),g(wo,Ki,null),d(e,_u,c),d(e,be,c),g(ko,be,null),t(be,fy),t(be,ed),t(be,_y),g(Cs,be,null),t(be,by),t(be,td),g($o,td,null),d(e,bu,c),d(e,ye,c),g(jo,ye,null),t(ye,yy),t(ye,sd),t(ye,Ty),g(Vs,ye,null),t(ye,vy),t(ye,nd),g(xo,nd,null),d(e,yu,c),d(e,A,c),g(Jo,A,null),t(A,My),t(A,rd),t(A,wy),g(Ls,A,null),t(A,ky),g(Gs,A,null),t(A,$y),t(A,od),g(Uo,od,null),d(e,Tu,c),d(e,Te,c),g(Zo,Te,null),t(Te,jy),t(Te,ad),t(Te,xy),g(Fs,Te,null),t(Te,Jy),t(Te,ld),g(Bo,ld,null),d(e,vu,c),d(e,ve,c),g(Wo,ve,null),t(ve,Uy),t(ve,cd),t(ve,Zy),g(Xs,ve,null),t(ve,By),t(ve,id),g(zo,id,null),d(e,Mu,c),d(e,O,c),g(Io,O,null),t(O,Wy),t(O,dd),t(O,zy),t(O,pd),t(O,Iy),g(Rs,O,null),t(O,Cy),t(O,md),g(Co,md,null),d(e,wu,c),d(e,K,c),g(Vo,K,null),t(K,Vy),t(K,gd),t(K,Ly),t(K,hd),t(K,Gy),g(Ss,K,null),t(K,Fy),t(K,ud),g(Lo,ud,null),d(e,ku,c),d(e,ee,c),g(Go,ee,null),t(ee,Xy),t(ee,fd),t(ee,Ry),t(ee,_d),t(ee,Sy),g(Es,ee,null),t(ee,Ey),t(ee,bd),g(Fo,bd,null),d(e,$u,c),d(e,F,c),g(Xo,F,null),t(F,Ny),t(F,yd),t(F,Hy),t(F,Td),t(F,qy),t(F,vd),t(F,Dy),g(Ns,F,null),t(F,Qy),t(F,Md),g(Ro,Md,null),d(e,ju,c),g(So,e,c),d(e,xu,c),d(e,Se,c),g(Eo,Se,null),t(Se,Py),t(Se,wd),t(Se,Yy),t(Se,kd),g(No,kd,null),d(e,Ju,c),d(e,Ee,c),g(Ho,Ee,null),t(Ee,Ay),t(Ee,$d),t(Ee,Oy),t(Ee,jd),g(qo,jd,null),d(e,Uu,c),d(e,Ne,c),g(Do,Ne,null),t(Ne,Ky),t(Ne,xd),t(Ne,eT),t(Ne,Jd),g(Qo,Jd,null),d(e,Zu,c),d(e,He,c),g(Po,He,null),t(He,tT),t(He,Ud),t(He,sT),t(He,Hs),g(Yo,Hs,null),t(Hs,nT),t(Hs,Zd),d(e,Bu,c),d(e,qe,c),g(Ao,qe,null),t(qe,rT),t(qe,Bd),t(qe,oT),t(qe,Wd),g(Oo,Wd,null),d(e,Wu,c),d(e,De,c),g(Ko,De,null),t(De,aT),t(De,zd),t(De,lT),t(De,qs),g(ea,qs,null),t(qs,cT),t(qs,Id),d(e,zu,c),d(e,Qe,c),g(ta,Qe,null),t(Qe,iT),t(Qe,Cd),t(Qe,dT),t(Qe,Vd),g(sa,Vd,null),d(e,Iu,c),d(e,Pe,c),g(na,Pe,null),t(Pe,pT),t(Pe,Ld),t(Pe,mT),t(Pe,Gd),g(ra,Gd,null),d(e,Cu,c),d(e,Ye,c),g(oa,Ye,null),t(Ye,gT),t(Ye,Fd),t(Ye,hT),t(Ye,Xd),g(aa,Xd,null),d(e,Vu,c),d(e,Ae,c),g(la,Ae,null),t(Ae,uT),t(Ae,Rd),t(Ae,fT),t(Ae,Sd),g(ca,Sd,null),d(e,Lu,c),d(e,Oe,c),g(ia,Oe,null),t(Oe,_T),t(Oe,Ed),t(Oe,bT),t(Oe,Nd),g(da,Nd,null),d(e,Gu,c),d(e,Ke,c),g(pa,Ke,null),t(Ke,yT),t(Ke,Hd),t(Ke,TT),t(Ke,qd),g(ma,qd,null),d(e,Fu,c),d(e,et,c),g(ga,et,null),t(et,vT),t(et,Dd),t(et,MT),t(et,Qd),g(ha,Qd,null),d(e,Xu,c),d(e,tt,c),g(ua,tt,null),t(tt,wT),t(tt,Pd),t(tt,kT),t(tt,Yd),g(fa,Yd,null),d(e,Ru,c),d(e,st,c),g(_a,st,null),t(st,$T),t(st,Ad),t(st,jT),t(st,Od),g(ba,Od,null),d(e,Su,c),g(ya,e,c),d(e,Eu,c),d(e,nt,c),g(Ta,nt,null),t(nt,xT),t(nt,Kd),t(nt,JT),t(nt,ep),g(va,ep,null),d(e,Nu,c),d(e,rt,c),g(Ma,rt,null),t(rt,UT),t(rt,tp),t(rt,ZT),t(rt,sp),g(wa,sp,null),d(e,Hu,c),d(e,ot,c),g(ka,ot,null),t(ot,BT),t(ot,np),t(ot,WT),t(ot,rp),g($a,rp,null),d(e,qu,c),d(e,at,c),g(ja,at,null),t(at,zT),t(at,op),t(at,IT),t(at,Ds),g(xa,Ds,null),t(Ds,CT),t(Ds,ap),d(e,Du,c),d(e,lt,c),g(Ja,lt,null),t(lt,VT),t(lt,lp),t(lt,LT),t(lt,cp),g(Ua,cp,null),d(e,Qu,c),d(e,ct,c),g(Za,ct,null),t(ct,GT),t(ct,ip),t(ct,FT),t(ct,Qs),g(Ba,Qs,null),t(Qs,XT),t(Qs,dp),d(e,Pu,c),d(e,it,c),g(Wa,it,null),t(it,RT),t(it,pp),t(it,ST),t(it,mp),g(za,mp,null),d(e,Yu,c),d(e,dt,c),g(Ia,dt,null),t(dt,ET),t(dt,gp),t(dt,NT),t(dt,hp),g(Ca,hp,null),d(e,Au,c),d(e,pt,c),g(Va,pt,null),t(pt,HT),t(pt,up),t(pt,qT),t(pt,fp),g(La,fp,null),d(e,Ou,c),d(e,mt,c),g(Ga,mt,null),t(mt,DT),t(mt,_p),t(mt,QT),t(mt,bp),g(Fa,bp,null),d(e,Ku,c),d(e,gt,c),g(Xa,gt,null),t(gt,PT),t(gt,yp),t(gt,YT),t(gt,Tp),g(Ra,Tp,null),d(e,ef,c),d(e,ht,c),g(Sa,ht,null),t(ht,AT),t(ht,vp),t(ht,OT),t(ht,Mp),g(Ea,Mp,null),d(e,tf,c),d(e,ut,c),g(Na,ut,null),t(ut,KT),t(ut,wp),t(ut,ev),t(ut,kp),g(Ha,kp,null),d(e,sf,c),g(qa,e,c),d(e,nf,c),d(e,Da,c),d(e,rf,c),d(e,Me,c),g(Qa,Me,null),t(Me,tv),t(Me,$p),t(Me,sv),t(Me,jp),t(Me,nv),t(Me,xp),g(Pa,xp,null),d(e,of,c),d(e,es,c),g(Ya,es,null),t(es,rv),t(es,Jp),g(Aa,Jp,null),d(e,af,c),d(e,ft,c),g(Oa,ft,null),t(ft,ov),t(ft,Up),t(ft,av),t(ft,Zp),g(Ka,Zp,null),d(e,lf,c),d(e,_t,c),g(el,_t,null),t(_t,lv),t(_t,Bp),t(_t,cv),t(_t,Wp),g(tl,Wp,null),d(e,cf,c),d(e,x,c),g(sl,x,null),t(x,iv),t(x,zp),t(x,dv),t(x,Ip),t(x,pv),t(x,Cp),t(x,mv),t(x,Vp),t(x,gv),t(x,Lp),t(x,hv),t(x,Gp),t(x,uv),t(x,Fp),t(x,fv),t(x,Xp),t(x,_v),t(x,Rp),t(x,bv),t(x,Sp),t(x,yv),t(x,Ep),t(x,Tv),t(x,Np),t(x,vv),t(x,Hp),t(x,Mv),t(x,qp),t(x,wv),t(x,Dp),t(x,kv),t(x,Qp),t(x,$v),t(x,Pp),t(x,jv),t(x,Yp),t(x,xv),t(x,Ap),t(x,Jv),g(Ps,x,null),t(x,Uv),t(x,Op),g(nl,Op,null),d(e,df,c),d(e,bt,c),g(rl,bt,null),t(bt,Zv),t(bt,Kp),t(bt,Bv),t(bt,em),g(ol,em,null),d(e,pf,c),g(al,e,c),d(e,mf,c),d(e,ll,c),d(e,gf,c),d(e,W,c),g(cl,W,null),t(W,Wv),t(W,tm),t(W,zv),t(W,sm),t(W,Iv),g(Ys,W,null),t(W,Cv),t(W,nm),t(W,Vv),t(W,As),g(il,As,null),t(As,Lv),t(As,rm),t(W,Gv),t(W,Os),g(dl,Os,null),t(Os,Fv),t(Os,om),t(W,Xv),t(W,Ks),g(pl,Ks,null),t(Ks,Rv),t(Ks,am),t(W,Sv),t(W,en),g(ml,en,null),t(en,Ev),t(en,lm),t(W,Nv),t(W,tn),g(gl,tn,null),t(tn,Hv),t(tn,cm),t(W,qv),t(W,sn),g(hl,sn,null),t(sn,Dv),t(sn,im),t(W,Qv),t(W,Jt),g(ul,Jt,null),t(Jt,Pv),t(Jt,dm),t(Jt,Yv),t(Jt,pm),d(e,hf,c),d(e,ts,c),g(fl,ts,null),t(ts,Av),t(ts,mm),d(e,uf,c),d(e,ss,c),g(_l,ss,null),t(ss,Ov),t(ss,gm),d(e,ff,c),d(e,we,c),g(bl,we,null),t(we,Kv),t(we,hm),t(we,e1),t(we,E),g(yl,E,null),t(E,t1),t(E,um),t(E,s1),t(E,fm),t(E,n1),t(E,_m),t(E,r1),t(E,bm),t(E,o1),t(E,ym),t(we,a1),t(we,nn),g(Tl,nn,null),t(nn,l1),t(nn,Tm),d(e,_f,c),g(vl,e,c),d(e,bf,c),d(e,ke,c),g(Ml,ke,null),t(ke,c1),t(ke,vm),t(ke,i1),t(ke,Mm),g(wl,Mm,null),t(ke,d1),t(ke,wm),g(kl,wm,null),d(e,yf,c),d(e,X,c),g($l,X,null),t(X,p1),t(X,km),t(X,m1),t(X,$m),t(X,g1),t(X,jm),t(X,h1),t(X,xm),g(jl,xm,null),t(X,u1),t(X,Jm),g(xl,Jm,null),d(e,Tf,c),d(e,$e,c),g(Jl,$e,null),t($e,f1),t($e,Um),t($e,_1),t($e,Zm),g(Ul,Zm,null),t($e,b1),t($e,Bm),g(Zl,Bm,null),d(e,vf,c),g(Bl,e,c),d(e,Mf,c),d(e,C,c),g(Wl,C,null),t(C,y1),t(C,Wm),t(C,T1),g(rn,C,null),t(C,v1),g(on,C,null),t(C,M1),t(C,an),g(zl,an,null),t(an,w1),t(an,zm),t(C,k1),t(C,ln),g(Il,ln,null),t(ln,$1),t(ln,Im),t(C,j1),t(C,cn),g(Cl,cn,null),t(cn,x1),t(cn,Cm),d(e,wf,c),d(e,te,c),g(Vl,te,null),t(te,J1),t(te,Vm),t(te,U1),g(dn,te,null),t(te,Z1),g(pn,te,null),t(te,B1),t(te,mn),g(Ll,mn,null),t(mn,W1),t(mn,Lm),d(e,kf,c),g(Gl,e,c),d(e,$f,c),d(e,yt,c),g(Fl,yt,null),t(yt,z1),t(yt,Gm),t(yt,I1),t(yt,gn),g(Xl,gn,null),t(gn,C1),t(gn,Fm),d(e,jf,c),d(e,Tt,c),g(Rl,Tt,null),t(Tt,V1),t(Tt,Xm),t(Tt,L1),t(Tt,hn),g(Sl,hn,null),t(hn,G1),t(hn,Rm),d(e,xf,c),d(e,vt,c),g(El,vt,null),t(vt,F1),t(vt,Sm),t(vt,X1),t(vt,un),g(Nl,un,null),t(un,R1),t(un,Em),d(e,Jf,c),d(e,I,c),g(Hl,I,null),t(I,S1),t(I,Nm),t(I,E1),t(I,Hm),t(I,N1),t(I,fn),g(ql,fn,null),t(fn,H1),t(fn,qm),t(I,q1),t(I,_n),g(Dl,_n,null),t(_n,D1),t(_n,Dm),t(I,Q1),t(I,bn),g(Ql,bn,null),t(bn,P1),t(bn,Qm),t(I,Y1),t(I,yn),g(Pl,yn,null),t(yn,A1),t(yn,Pm),t(I,O1),t(I,Tn),g(Yl,Tn,null),t(Tn,K1),t(Tn,Ym),d(e,Uf,c),d(e,R,c),g(Al,R,null),t(R,eM),t(R,Am),t(R,tM),t(R,Om),t(R,sM),t(R,Km),t(R,nM),t(R,eg),g(Ol,eg,null),t(R,rM),t(R,vn),g(Kl,vn,null),t(vn,oM),t(vn,tg),d(e,Zf,c),d(e,ns,c),g(ec,ns,null),t(ns,aM),t(ns,sg),d(e,Bf,c),d(e,rs,c),g(tc,rs,null),t(rs,lM),t(rs,ng),d(e,Wf,c),d(e,S,c),g(sc,S,null),t(S,cM),t(S,rg),t(S,iM),t(S,og),t(S,dM),t(S,Mn),g(nc,Mn,null),t(Mn,pM),t(Mn,ag),t(S,mM),t(S,wn),g(rc,wn,null),t(wn,gM),t(wn,lg),t(S,hM),t(S,kn),g(oc,kn,null),t(kn,uM),t(kn,cg),d(e,zf,c),d(e,se,c),g(ac,se,null),t(se,fM),t(se,ig),t(se,_M),t(se,$n),g(lc,$n,null),t($n,bM),t($n,dg),t(se,yM),t(se,jn),g(cc,jn,null),t(jn,TM),t(jn,pg),t(se,vM),t(se,xn),g(ic,xn,null),t(xn,MM),t(xn,mg),d(e,If,c),g(dc,e,c),d(e,Cf,c),d(e,ne,c),g(pc,ne,null),t(ne,wM),t(ne,gg),t(ne,kM),t(ne,hg),t(ne,$M),g(Jn,ne,null),t(ne,jM),t(ne,Un),g(mc,Un,null),t(Un,xM),t(Un,ug),d(e,Vf,c),g(gc,e,c),d(e,Lf,c),d(e,eh,c),Gf=!0},p(e,[c]){const hc={};c&2&&(hc.$$scope={dirty:c,ctx:e}),ms.$set(hc);const uc={};c&2&&(uc.$$scope={dirty:c,ctx:e}),gs.$set(uc);const fc={};c&2&&(fc.$$scope={dirty:c,ctx:e}),hs.$set(fc);const _c={};c&2&&(_c.$$scope={dirty:c,ctx:e}),us.$set(_c);const bc={};c&2&&(bc.$$scope={dirty:c,ctx:e}),fs.$set(bc);const yc={};c&2&&(yc.$$scope={dirty:c,ctx:e}),_s.$set(yc);const Tc={};c&2&&(Tc.$$scope={dirty:c,ctx:e}),bs.$set(Tc);const vc={};c&2&&(vc.$$scope={dirty:c,ctx:e}),ys.$set(vc);const Mc={};c&2&&(Mc.$$scope={dirty:c,ctx:e}),Ts.$set(Mc);const wc={};c&2&&(wc.$$scope={dirty:c,ctx:e}),vs.$set(wc);const kc={};c&2&&(kc.$$scope={dirty:c,ctx:e}),Ms.$set(kc);const $c={};c&2&&($c.$$scope={dirty:c,ctx:e}),ws.$set($c);const jc={};c&2&&(jc.$$scope={dirty:c,ctx:e}),ks.$set(jc);const xc={};c&2&&(xc.$$scope={dirty:c,ctx:e}),$s.$set(xc);const os={};c&2&&(os.$$scope={dirty:c,ctx:e}),js.$set(os);const Jc={};c&2&&(Jc.$$scope={dirty:c,ctx:e}),xs.$set(Jc);const as={};c&2&&(as.$$scope={dirty:c,ctx:e}),Js.$set(as);const Uc={};c&2&&(Uc.$$scope={dirty:c,ctx:e}),Us.$set(Uc);const ls={};c&2&&(ls.$$scope={dirty:c,ctx:e}),Zs.$set(ls);const Zc={};c&2&&(Zc.$$scope={dirty:c,ctx:e}),Bs.$set(Zc);const Mt={};c&2&&(Mt.$$scope={dirty:c,ctx:e}),Ws.$set(Mt);const th={};c&2&&(th.$$scope={dirty:c,ctx:e}),zs.$set(th);const re={};c&2&&(re.$$scope={dirty:c,ctx:e}),Is.$set(re);const sh={};c&2&&(sh.$$scope={dirty:c,ctx:e}),Cs.$set(sh);const je={};c&2&&(je.$$scope={dirty:c,ctx:e}),Vs.$set(je);const nh={};c&2&&(nh.$$scope={dirty:c,ctx:e}),Ls.$set(nh);const xe={};c&2&&(xe.$$scope={dirty:c,ctx:e}),Gs.$set(xe);const rh={};c&2&&(rh.$$scope={dirty:c,ctx:e}),Fs.$set(rh);const wt={};c&2&&(wt.$$scope={dirty:c,ctx:e}),Xs.$set(wt);const oh={};c&2&&(oh.$$scope={dirty:c,ctx:e}),Rs.$set(oh);const kt={};c&2&&(kt.$$scope={dirty:c,ctx:e}),Ss.$set(kt);const ah={};c&2&&(ah.$$scope={dirty:c,ctx:e}),Es.$set(ah);const $t={};c&2&&($t.$$scope={dirty:c,ctx:e}),Ns.$set($t);const lh={};c&2&&(lh.$$scope={dirty:c,ctx:e}),Ps.$set(lh);const jt={};c&2&&(jt.$$scope={dirty:c,ctx:e}),Ys.$set(jt);const ch={};c&2&&(ch.$$scope={dirty:c,ctx:e}),rn.$set(ch);const xt={};c&2&&(xt.$$scope={dirty:c,ctx:e}),on.$set(xt);const ih={};c&2&&(ih.$$scope={dirty:c,ctx:e}),dn.$set(ih);const cs={};c&2&&(cs.$$scope={dirty:c,ctx:e}),pn.$set(cs);const dh={};c&2&&(dh.$$scope={dirty:c,ctx:e}),Jn.$set(dh)},i(e){Gf||(h(w.$$.fragment,e),h(Nn.$$.fragment,e),h(Dn.$$.fragment,e),h(Kn.$$.fragment,e),h(nr.$$.fragment,e),h(rr.$$.fragment,e),h(or.$$.fragment,e),h(ar.$$.fragment,e),h(lr.$$.fragment,e),h(cr.$$.fragment,e),h(ir.$$.fragment,e),h(dr.$$.fragment,e),h(pr.$$.fragment,e),h(mr.$$.fragment,e),h(gr.$$.fragment,e),h(hr.$$.fragment,e),h(ur.$$.fragment,e),h(fr.$$.fragment,e),h(_r.$$.fragment,e),h(br.$$.fragment,e),h(yr.$$.fragment,e),h(Tr.$$.fragment,e),h(vr.$$.fragment,e),h(Mr.$$.fragment,e),h(wr.$$.fragment,e),h(kr.$$.fragment,e),h($r.$$.fragment,e),h(jr.$$.fragment,e),h(Jr.$$.fragment,e),h(Ur.$$.fragment,e),h(ms.$$.fragment,e),h(Zr.$$.fragment,e),h(Br.$$.fragment,e),h(gs.$$.fragment,e),h(hs.$$.fragment,e),h(Wr.$$.fragment,e),h(zr.$$.fragment,e),h(us.$$.fragment,e),h(Ir.$$.fragment,e),h(Cr.$$.fragment,e),h(fs.$$.fragment,e),h(Vr.$$.fragment,e),h(Lr.$$.fragment,e),h(_s.$$.fragment,e),h(Gr.$$.fragment,e),h(Fr.$$.fragment,e),h(bs.$$.fragment,e),h(Xr.$$.fragment,e),h(Rr.$$.fragment,e),h(ys.$$.fragment,e),h(Sr.$$.fragment,e),h(Er.$$.fragment,e),h(Ts.$$.fragment,e),h(Nr.$$.fragment,e),h(Hr.$$.fragment,e),h(vs.$$.fragment,e),h(qr.$$.fragment,e),h(Dr.$$.fragment,e),h(Qr.$$.fragment,e),h(Pr.$$.fragment,e),h(Ms.$$.fragment,e),h(Yr.$$.fragment,e),h(Ar.$$.fragment,e),h(Or.$$.fragment,e),h(Kr.$$.fragment,e),h(ws.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(so.$$.fragment,e),h(no.$$.fragment,e),h(ro.$$.fragment,e),h(oo.$$.fragment,e),h(ao.$$.fragment,e),h(lo.$$.fragment,e),h(ks.$$.fragment,e),h(co.$$.fragment,e),h(io.$$.fragment,e),h($s.$$.fragment,e),h(po.$$.fragment,e),h(mo.$$.fragment,e),h(js.$$.fragment,e),h(go.$$.fragment,e),h(ho.$$.fragment,e),h(xs.$$.fragment,e),h(Js.$$.fragment,e),h(uo.$$.fragment,e),h(fo.$$.fragment,e),h(Us.$$.fragment,e),h(Zs.$$.fragment,e),h(_o.$$.fragment,e),h(bo.$$.fragment,e),h(Bs.$$.fragment,e),h(yo.$$.fragment,e),h(To.$$.fragment,e),h(Ws.$$.fragment,e),h(vo.$$.fragment,e),h(Mo.$$.fragment,e),h(zs.$$.fragment,e),h(Is.$$.fragment,e),h(wo.$$.fragment,e),h(ko.$$.fragment,e),h(Cs.$$.fragment,e),h($o.$$.fragment,e),h(jo.$$.fragment,e),h(Vs.$$.fragment,e),h(xo.$$.fragment,e),h(Jo.$$.fragment,e),h(Ls.$$.fragment,e),h(Gs.$$.fragment,e),h(Uo.$$.fragment,e),h(Zo.$$.fragment,e),h(Fs.$$.fragment,e),h(Bo.$$.fragment,e),h(Wo.$$.fragment,e),h(Xs.$$.fragment,e),h(zo.$$.fragment,e),h(Io.$$.fragment,e),h(Rs.$$.fragment,e),h(Co.$$.fragment,e),h(Vo.$$.fragment,e),h(Ss.$$.fragment,e),h(Lo.$$.fragment,e),h(Go.$$.fragment,e),h(Es.$$.fragment,e),h(Fo.$$.fragment,e),h(Xo.$$.fragment,e),h(Ns.$$.fragment,e),h(Ro.$$.fragment,e),h(So.$$.fragment,e),h(Eo.$$.fragment,e),h(No.$$.fragment,e),h(Ho.$$.fragment,e),h(qo.$$.fragment,e),h(Do.$$.fragment,e),h(Qo.$$.fragment,e),h(Po.$$.fragment,e),h(Yo.$$.fragment,e),h(Ao.$$.fragment,e),h(Oo.$$.fragment,e),h(Ko.$$.fragment,e),h(ea.$$.fragment,e),h(ta.$$.fragment,e),h(sa.$$.fragment,e),h(na.$$.fragment,e),h(ra.$$.fragment,e),h(oa.$$.fragment,e),h(aa.$$.fragment,e),h(la.$$.fragment,e),h(ca.$$.fragment,e),h(ia.$$.fragment,e),h(da.$$.fragment,e),h(pa.$$.fragment,e),h(ma.$$.fragment,e),h(ga.$$.fragment,e),h(ha.$$.fragment,e),h(ua.$$.fragment,e),h(fa.$$.fragment,e),h(_a.$$.fragment,e),h(ba.$$.fragment,e),h(ya.$$.fragment,e),h(Ta.$$.fragment,e),h(va.$$.fragment,e),h(Ma.$$.fragment,e),h(wa.$$.fragment,e),h(ka.$$.fragment,e),h($a.$$.fragment,e),h(ja.$$.fragment,e),h(xa.$$.fragment,e),h(Ja.$$.fragment,e),h(Ua.$$.fragment,e),h(Za.$$.fragment,e),h(Ba.$$.fragment,e),h(Wa.$$.fragment,e),h(za.$$.fragment,e),h(Ia.$$.fragment,e),h(Ca.$$.fragment,e),h(Va.$$.fragment,e),h(La.$$.fragment,e),h(Ga.$$.fragment,e),h(Fa.$$.fragment,e),h(Xa.$$.fragment,e),h(Ra.$$.fragment,e),h(Sa.$$.fragment,e),h(Ea.$$.fragment,e),h(Na.$$.fragment,e),h(Ha.$$.fragment,e),h(qa.$$.fragment,e),h(Qa.$$.fragment,e),h(Pa.$$.fragment,e),h(Ya.$$.fragment,e),h(Aa.$$.fragment,e),h(Oa.$$.fragment,e),h(Ka.$$.fragment,e),h(el.$$.fragment,e),h(tl.$$.fragment,e),h(sl.$$.fragment,e),h(Ps.$$.fragment,e),h(nl.$$.fragment,e),h(rl.$$.fragment,e),h(ol.$$.fragment,e),h(al.$$.fragment,e),h(cl.$$.fragment,e),h(Ys.$$.fragment,e),h(il.$$.fragment,e),h(dl.$$.fragment,e),h(pl.$$.fragment,e),h(ml.$$.fragment,e),h(gl.$$.fragment,e),h(hl.$$.fragment,e),h(ul.$$.fragment,e),h(fl.$$.fragment,e),h(_l.$$.fragment,e),h(bl.$$.fragment,e),h(yl.$$.fragment,e),h(Tl.$$.fragment,e),h(vl.$$.fragment,e),h(Ml.$$.fragment,e),h(wl.$$.fragment,e),h(kl.$$.fragment,e),h($l.$$.fragment,e),h(jl.$$.fragment,e),h(xl.$$.fragment,e),h(Jl.$$.fragment,e),h(Ul.$$.fragment,e),h(Zl.$$.fragment,e),h(Bl.$$.fragment,e),h(Wl.$$.fragment,e),h(rn.$$.fragment,e),h(on.$$.fragment,e),h(zl.$$.fragment,e),h(Il.$$.fragment,e),h(Cl.$$.fragment,e),h(Vl.$$.fragment,e),h(dn.$$.fragment,e),h(pn.$$.fragment,e),h(Ll.$$.fragment,e),h(Gl.$$.fragment,e),h(Fl.$$.fragment,e),h(Xl.$$.fragment,e),h(Rl.$$.fragment,e),h(Sl.$$.fragment,e),h(El.$$.fragment,e),h(Nl.$$.fragment,e),h(Hl.$$.fragment,e),h(ql.$$.fragment,e),h(Dl.$$.fragment,e),h(Ql.$$.fragment,e),h(Pl.$$.fragment,e),h(Yl.$$.fragment,e),h(Al.$$.fragment,e),h(Ol.$$.fragment,e),h(Kl.$$.fragment,e),h(ec.$$.fragment,e),h(tc.$$.fragment,e),h(sc.$$.fragment,e),h(nc.$$.fragment,e),h(rc.$$.fragment,e),h(oc.$$.fragment,e),h(ac.$$.fragment,e),h(lc.$$.fragment,e),h(cc.$$.fragment,e),h(ic.$$.fragment,e),h(dc.$$.fragment,e),h(pc.$$.fragment,e),h(Jn.$$.fragment,e),h(mc.$$.fragment,e),h(gc.$$.fragment,e),Gf=!0)},o(e){u(w.$$.fragment,e),u(Nn.$$.fragment,e),u(Dn.$$.fragment,e),u(Kn.$$.fragment,e),u(nr.$$.fragment,e),u(rr.$$.fragment,e),u(or.$$.fragment,e),u(ar.$$.fragment,e),u(lr.$$.fragment,e),u(cr.$$.fragment,e),u(ir.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u(mr.$$.fragment,e),u(gr.$$.fragment,e),u(hr.$$.fragment,e),u(ur.$$.fragment,e),u(fr.$$.fragment,e),u(_r.$$.fragment,e),u(br.$$.fragment,e),u(yr.$$.fragment,e),u(Tr.$$.fragment,e),u(vr.$$.fragment,e),u(Mr.$$.fragment,e),u(wr.$$.fragment,e),u(kr.$$.fragment,e),u($r.$$.fragment,e),u(jr.$$.fragment,e),u(Jr.$$.fragment,e),u(Ur.$$.fragment,e),u(ms.$$.fragment,e),u(Zr.$$.fragment,e),u(Br.$$.fragment,e),u(gs.$$.fragment,e),u(hs.$$.fragment,e),u(Wr.$$.fragment,e),u(zr.$$.fragment,e),u(us.$$.fragment,e),u(Ir.$$.fragment,e),u(Cr.$$.fragment,e),u(fs.$$.fragment,e),u(Vr.$$.fragment,e),u(Lr.$$.fragment,e),u(_s.$$.fragment,e),u(Gr.$$.fragment,e),u(Fr.$$.fragment,e),u(bs.$$.fragment,e),u(Xr.$$.fragment,e),u(Rr.$$.fragment,e),u(ys.$$.fragment,e),u(Sr.$$.fragment,e),u(Er.$$.fragment,e),u(Ts.$$.fragment,e),u(Nr.$$.fragment,e),u(Hr.$$.fragment,e),u(vs.$$.fragment,e),u(qr.$$.fragment,e),u(Dr.$$.fragment,e),u(Qr.$$.fragment,e),u(Pr.$$.fragment,e),u(Ms.$$.fragment,e),u(Yr.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Kr.$$.fragment,e),u(ws.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(so.$$.fragment,e),u(no.$$.fragment,e),u(ro.$$.fragment,e),u(oo.$$.fragment,e),u(ao.$$.fragment,e),u(lo.$$.fragment,e),u(ks.$$.fragment,e),u(co.$$.fragment,e),u(io.$$.fragment,e),u($s.$$.fragment,e),u(po.$$.fragment,e),u(mo.$$.fragment,e),u(js.$$.fragment,e),u(go.$$.fragment,e),u(ho.$$.fragment,e),u(xs.$$.fragment,e),u(Js.$$.fragment,e),u(uo.$$.fragment,e),u(fo.$$.fragment,e),u(Us.$$.fragment,e),u(Zs.$$.fragment,e),u(_o.$$.fragment,e),u(bo.$$.fragment,e),u(Bs.$$.fragment,e),u(yo.$$.fragment,e),u(To.$$.fragment,e),u(Ws.$$.fragment,e),u(vo.$$.fragment,e),u(Mo.$$.fragment,e),u(zs.$$.fragment,e),u(Is.$$.fragment,e),u(wo.$$.fragment,e),u(ko.$$.fragment,e),u(Cs.$$.fragment,e),u($o.$$.fragment,e),u(jo.$$.fragment,e),u(Vs.$$.fragment,e),u(xo.$$.fragment,e),u(Jo.$$.fragment,e),u(Ls.$$.fragment,e),u(Gs.$$.fragment,e),u(Uo.$$.fragment,e),u(Zo.$$.fragment,e),u(Fs.$$.fragment,e),u(Bo.$$.fragment,e),u(Wo.$$.fragment,e),u(Xs.$$.fragment,e),u(zo.$$.fragment,e),u(Io.$$.fragment,e),u(Rs.$$.fragment,e),u(Co.$$.fragment,e),u(Vo.$$.fragment,e),u(Ss.$$.fragment,e),u(Lo.$$.fragment,e),u(Go.$$.fragment,e),u(Es.$$.fragment,e),u(Fo.$$.fragment,e),u(Xo.$$.fragment,e),u(Ns.$$.fragment,e),u(Ro.$$.fragment,e),u(So.$$.fragment,e),u(Eo.$$.fragment,e),u(No.$$.fragment,e),u(Ho.$$.fragment,e),u(qo.$$.fragment,e),u(Do.$$.fragment,e),u(Qo.$$.fragment,e),u(Po.$$.fragment,e),u(Yo.$$.fragment,e),u(Ao.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(ea.$$.fragment,e),u(ta.$$.fragment,e),u(sa.$$.fragment,e),u(na.$$.fragment,e),u(ra.$$.fragment,e),u(oa.$$.fragment,e),u(aa.$$.fragment,e),u(la.$$.fragment,e),u(ca.$$.fragment,e),u(ia.$$.fragment,e),u(da.$$.fragment,e),u(pa.$$.fragment,e),u(ma.$$.fragment,e),u(ga.$$.fragment,e),u(ha.$$.fragment,e),u(ua.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(ba.$$.fragment,e),u(ya.$$.fragment,e),u(Ta.$$.fragment,e),u(va.$$.fragment,e),u(Ma.$$.fragment,e),u(wa.$$.fragment,e),u(ka.$$.fragment,e),u($a.$$.fragment,e),u(ja.$$.fragment,e),u(xa.$$.fragment,e),u(Ja.$$.fragment,e),u(Ua.$$.fragment,e),u(Za.$$.fragment,e),u(Ba.$$.fragment,e),u(Wa.$$.fragment,e),u(za.$$.fragment,e),u(Ia.$$.fragment,e),u(Ca.$$.fragment,e),u(Va.$$.fragment,e),u(La.$$.fragment,e),u(Ga.$$.fragment,e),u(Fa.$$.fragment,e),u(Xa.$$.fragment,e),u(Ra.$$.fragment,e),u(Sa.$$.fragment,e),u(Ea.$$.fragment,e),u(Na.$$.fragment,e),u(Ha.$$.fragment,e),u(qa.$$.fragment,e),u(Qa.$$.fragment,e),u(Pa.$$.fragment,e),u(Ya.$$.fragment,e),u(Aa.$$.fragment,e),u(Oa.$$.fragment,e),u(Ka.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(Ps.$$.fragment,e),u(nl.$$.fragment,e),u(rl.$$.fragment,e),u(ol.$$.fragment,e),u(al.$$.fragment,e),u(cl.$$.fragment,e),u(Ys.$$.fragment,e),u(il.$$.fragment,e),u(dl.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(gl.$$.fragment,e),u(hl.$$.fragment,e),u(ul.$$.fragment,e),u(fl.$$.fragment,e),u(_l.$$.fragment,e),u(bl.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),u(vl.$$.fragment,e),u(Ml.$$.fragment,e),u(wl.$$.fragment,e),u(kl.$$.fragment,e),u($l.$$.fragment,e),u(jl.$$.fragment,e),u(xl.$$.fragment,e),u(Jl.$$.fragment,e),u(Ul.$$.fragment,e),u(Zl.$$.fragment,e),u(Bl.$$.fragment,e),u(Wl.$$.fragment,e),u(rn.$$.fragment,e),u(on.$$.fragment,e),u(zl.$$.fragment,e),u(Il.$$.fragment,e),u(Cl.$$.fragment,e),u(Vl.$$.fragment,e),u(dn.$$.fragment,e),u(pn.$$.fragment,e),u(Ll.$$.fragment,e),u(Gl.$$.fragment,e),u(Fl.$$.fragment,e),u(Xl.$$.fragment,e),u(Rl.$$.fragment,e),u(Sl.$$.fragment,e),u(El.$$.fragment,e),u(Nl.$$.fragment,e),u(Hl.$$.fragment,e),u(ql.$$.fragment,e),u(Dl.$$.fragment,e),u(Ql.$$.fragment,e),u(Pl.$$.fragment,e),u(Yl.$$.fragment,e),u(Al.$$.fragment,e),u(Ol.$$.fragment,e),u(Kl.$$.fragment,e),u(ec.$$.fragment,e),u(tc.$$.fragment,e),u(sc.$$.fragment,e),u(nc.$$.fragment,e),u(rc.$$.fragment,e),u(oc.$$.fragment,e),u(ac.$$.fragment,e),u(lc.$$.fragment,e),u(cc.$$.fragment,e),u(ic.$$.fragment,e),u(dc.$$.fragment,e),u(pc.$$.fragment,e),u(Jn.$$.fragment,e),u(mc.$$.fragment,e),u(gc.$$.fragment,e),Gf=!1},d(e){e&&(s($),s(y),s(_),s(o),s(k),s(ph),s(mh),s(Hn),s(gh),s(qn),s(hh),s(uh),s(Qn),s(fh),s(Pn),s(_h),s(Yn),s(bh),s(An),s(yh),s(On),s(Th),s(vh),s(er),s(Mh),s(tr),s(wh),s(sr),s(kh),s($h),s(Xt),s(jh),s(Rt),s(xh),s(St),s(Jh),s(Et),s(Uh),s(Zh),s(Nt),s(Bh),s(Ht),s(Wh),s(qt),s(zh),s(Dt),s(Ih),s(Qt),s(Ch),s(Pt),s(Vh),s(Yt),s(Lh),s(At),s(Gh),s(Ot),s(Fh),s(Kt),s(Xh),s(Rh),s(Ce),s(Sh),s(Ve),s(Eh),s(Le),s(Nh),s(Hh),s(xr),s(qh),s(Dh),s(le),s(Qh),s(V),s(Ph),s(H),s(Yh),s(q),s(Ah),s(ce),s(Oh),s(ie),s(Kh),s(de),s(eu),s(pe),s(tu),s(me),s(su),s(Ge),s(nu),s(L),s(ru),s(ge),s(ou),s(he),s(au),s(Fe),s(lu),s(Xe),s(cu),s(Re),s(iu),s(ue),s(du),s(fe),s(pu),s(G),s(mu),s(D),s(gu),s(Q),s(hu),s(_e),s(uu),s(P),s(fu),s(Y),s(_u),s(be),s(bu),s(ye),s(yu),s(A),s(Tu),s(Te),s(vu),s(ve),s(Mu),s(O),s(wu),s(K),s(ku),s(ee),s($u),s(F),s(ju),s(xu),s(Se),s(Ju),s(Ee),s(Uu),s(Ne),s(Zu),s(He),s(Bu),s(qe),s(Wu),s(De),s(zu),s(Qe),s(Iu),s(Pe),s(Cu),s(Ye),s(Vu),s(Ae),s(Lu),s(Oe),s(Gu),s(Ke),s(Fu),s(et),s(Xu),s(tt),s(Ru),s(st),s(Su),s(Eu),s(nt),s(Nu),s(rt),s(Hu),s(ot),s(qu),s(at),s(Du),s(lt),s(Qu),s(ct),s(Pu),s(it),s(Yu),s(dt),s(Au),s(pt),s(Ou),s(mt),s(Ku),s(gt),s(ef),s(ht),s(tf),s(ut),s(sf),s(nf),s(Da),s(rf),s(Me),s(of),s(es),s(af),s(ft),s(lf),s(_t),s(cf),s(x),s(df),s(bt),s(pf),s(mf),s(ll),s(gf),s(W),s(hf),s(ts),s(uf),s(ss),s(ff),s(we),s(_f),s(bf),s(ke),s(yf),s(X),s(Tf),s($e),s(vf),s(Mf),s(C),s(wf),s(te),s(kf),s($f),s(yt),s(jf),s(Tt),s(xf),s(vt),s(Jf),s(I),s(Uf),s(R),s(Zf),s(ns),s(Bf),s(rs),s(Wf),s(S),s(zf),s(se),s(If),s(Cf),s(ne),s(Vf),s(Lf),s(eh)),s(i),f(w,e),f(Nn,e),f(Dn,e),f(Kn,e),f(nr,e),f(rr),f(or),f(ar),f(lr),f(cr,e),f(ir),f(dr),f(pr),f(mr),f(gr),f(hr),f(ur),f(fr),f(_r),f(br),f(yr,e),f(Tr),f(vr),f(Mr),f(wr),f(kr),f($r),f(jr,e),f(Jr,e),f(Ur),f(ms),f(Zr),f(Br),f(gs),f(hs),f(Wr),f(zr),f(us),f(Ir),f(Cr),f(fs),f(Vr),f(Lr),f(_s),f(Gr),f(Fr),f(bs),f(Xr),f(Rr),f(ys),f(Sr),f(Er),f(Ts),f(Nr),f(Hr),f(vs),f(qr),f(Dr),f(Qr),f(Pr),f(Ms),f(Yr),f(Ar),f(Or),f(Kr),f(ws),f(eo),f(to),f(so),f(no),f(ro),f(oo),f(ao),f(lo),f(ks),f(co),f(io),f($s),f(po),f(mo),f(js),f(go),f(ho),f(xs),f(Js),f(uo),f(fo),f(Us),f(Zs),f(_o),f(bo),f(Bs),f(yo),f(To),f(Ws),f(vo),f(Mo),f(zs),f(Is),f(wo),f(ko),f(Cs),f($o),f(jo),f(Vs),f(xo),f(Jo),f(Ls),f(Gs),f(Uo),f(Zo),f(Fs),f(Bo),f(Wo),f(Xs),f(zo),f(Io),f(Rs),f(Co),f(Vo),f(Ss),f(Lo),f(Go),f(Es),f(Fo),f(Xo),f(Ns),f(Ro),f(So,e),f(Eo),f(No),f(Ho),f(qo),f(Do),f(Qo),f(Po),f(Yo),f(Ao),f(Oo),f(Ko),f(ea),f(ta),f(sa),f(na),f(ra),f(oa),f(aa),f(la),f(ca),f(ia),f(da),f(pa),f(ma),f(ga),f(ha),f(ua),f(fa),f(_a),f(ba),f(ya,e),f(Ta),f(va),f(Ma),f(wa),f(ka),f($a),f(ja),f(xa),f(Ja),f(Ua),f(Za),f(Ba),f(Wa),f(za),f(Ia),f(Ca),f(Va),f(La),f(Ga),f(Fa),f(Xa),f(Ra),f(Sa),f(Ea),f(Na),f(Ha),f(qa,e),f(Qa),f(Pa),f(Ya),f(Aa),f(Oa),f(Ka),f(el),f(tl),f(sl),f(Ps),f(nl),f(rl),f(ol),f(al,e),f(cl),f(Ys),f(il),f(dl),f(pl),f(ml),f(gl),f(hl),f(ul),f(fl),f(_l),f(bl),f(yl),f(Tl),f(vl,e),f(Ml),f(wl),f(kl),f($l),f(jl),f(xl),f(Jl),f(Ul),f(Zl),f(Bl,e),f(Wl),f(rn),f(on),f(zl),f(Il),f(Cl),f(Vl),f(dn),f(pn),f(Ll),f(Gl,e),f(Fl),f(Xl),f(Rl),f(Sl),f(El),f(Nl),f(Hl),f(ql),f(Dl),f(Ql),f(Pl),f(Yl),f(Al),f(Ol),f(Kl),f(ec),f(tc),f(sc),f(nc),f(rc),f(oc),f(ac),f(lc),f(cc),f(ic),f(dc,e),f(pc),f(Jn),f(mc),f(gc,e)}}}const d0='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2},{"title":"Watermark Utils","local":"transformers.WatermarkDetector","sections":[],"depth":2}],"depth":1}';function p0(j){return bj(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class y0 extends yj{constructor(i){super(),Tj(this,i,p0,i0,_j,{})}}export{y0 as component};
