import{s as Fl,o as Sl,n as Ye}from"../chunks/scheduler.25b97de1.js";import{S as Ll,i as ql,g as i,s as n,r as c,A as Pl,h as r,f as l,c as a,j as El,u as m,x as M,k as zl,y as Dl,a as s,v as d,d as y,t as u,w as f}from"../chunks/index.d9030fc9.js";import{T as xe}from"../chunks/Tip.baa67368.js";import{C as J}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Re,E as Kl}from"../chunks/EditOnGithub.91d95064.js";function Ol(j){let o,h=`Models in the <code>transformers</code> library itself generally follow the convention that they accept a <code>config</code> object
in their <code>__init__</code> method, and then pass the whole <code>config</code> to sub-layers in the model, rather than breaking the
config object into multiple arguments that are all passed individually to sub-layers. Writing your model in this
style results in simpler code with a clear “source of truth” for any hyperparameters, and also makes it easier
to reuse code from other models in <code>transformers</code>.`;return{c(){o=i("p"),o.innerHTML=h},l(p){o=r(p,"P",{"data-svelte-h":!0}),M(o)!=="svelte-1qp2x4n"&&(o.innerHTML=h)},m(p,w){s(p,o,w)},p:Ye,d(p){p&&l(o)}}}function es(j){let o,h="If your model is very similar to a model inside the library, you can re-use the same configuration as this model.";return{c(){o=i("p"),o.textContent=h},l(p){o=r(p,"P",{"data-svelte-h":!0}),M(o)!=="svelte-alg4p1"&&(o.textContent=h)},m(p,w){s(p,o,w)},p:Ye,d(p){p&&l(o)}}}function ts(j){let o,h="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){o=i("p"),o.textContent=h},l(p){o=r(p,"P",{"data-svelte-h":!0}),M(o)!=="svelte-15rpg4"&&(o.textContent=h)},m(p,w){s(p,o,w)},p:Ye,d(p){p&&l(o)}}}function ls(j){let o,h=`If copying a modeling files from the library, you will need to replace all the relative imports at the top of the file
to import from the <code>transformers</code> package.`;return{c(){o=i("p"),o.innerHTML=h},l(p){o=r(p,"P",{"data-svelte-h":!0}),M(o)!=="svelte-1816fmc"&&(o.innerHTML=h)},m(p,w){s(p,o,w)},p:Ye,d(p){p&&l(o)}}}function ss(j){let o,h=`Use <code>register_for_auto_class()</code> if you want the code files to be copied. If you instead prefer to use code on the Hub from another repo,
you don’t need to call it. In cases where there’s more than one auto class, you can modify the <code>config.json</code> directly using the
following structure:`,p,w,U;return w=new J({props:{code:"JTIyYXV0b19tYXAlMjIlM0ElMjAlN0IlMjAlMjAlMjAlMjAlMjAlMEElMDklMjJBdXRvQ29uZmlnJTIyJTNBJTIwJTIyJTNDeW91ci1yZXBvLW5hbWUlM0UtLSUzQ2NvbmZpZy1uYW1lJTNFJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTBBJTA5JTIyQXV0b01vZGVsJTIyJTNBJTIwJTIyJTNDeW91ci1yZXBvLW5hbWUlM0UtLSUzQ2NvbmZpZy1uYW1lJTNFJTIyJTJDJTBBJTA5JTIyQXV0b01vZGVsRm9yJTNDVGFzayUzRSUyMiUzQSUyMCUyMiUzQ3lvdXItcmVwby1uYW1lJTNFLS0lM0Njb25maWctbmFtZSUzRSUyMiUyQyUyMCUyMCUyMCUyMCUwQSU3RCUyQw==",highlighted:`<span class="hljs-attr">&quot;auto_map&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>     
	<span class="hljs-attr">&quot;AutoConfig&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>     
	<span class="hljs-attr">&quot;AutoModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;AutoModelFor&lt;Task&gt;&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>    
<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),{c(){o=i("p"),o.innerHTML=h,p=n(),c(w.$$.fragment)},l(T){o=r(T,"P",{"data-svelte-h":!0}),M(o)!=="svelte-1rexmhi"&&(o.innerHTML=h),p=a(T),m(w.$$.fragment,T)},m(T,b){s(T,o,b),s(T,p,b),d(w,T,b),U=!0},p:Ye,i(T){U||(y(w.$$.fragment,T),U=!0)},o(T){u(w.$$.fragment,T),U=!1},d(T){T&&(l(o),l(p)),f(w,T)}}}function ns(j){let o,h,p,w,U,T,b,el=`The 🤗 Transformers library is designed to be easily extensible. Every model is fully coded in a given subfolder
of the repository with no abstraction, so you can easily copy a modeling file and tweak it to your needs.`,Ge,$,tl=`If you are writing a brand new model, it might be easier to start from scratch. In this tutorial, we will show you
how to write a custom model and its configuration so it can be used inside Transformers, and how you can share it
with the community (with the code it relies on) so that anyone can use it, even if it’s not present in the 🤗
Transformers library. We’ll see how to build upon transformers and extend the framework with your hooks and
custom code.`,Ve,A,ll=`We will illustrate all of this on a ResNet model, by wrapping the ResNet class of the
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm library</a> into a <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.`,Qe,k,He,v,sl=`Before we dive into the model, let’s first write its configuration. The configuration of a model is an object that
will contain all the necessary information to build the model. As we will see in the next section, the model can only
take a <code>config</code> to be initialized, so we really need that object to be as complete as possible.`,Ee,C,ze,N,nl=`In our example, we will take a couple of arguments of the ResNet class that we might want to tweak. Different
configurations will then give us the different types of ResNets that are possible. We then just store those arguments,
after checking the validity of a few of them.`,Fe,W,Se,B,al="The three important things to remember when writing you own configuration are the following:",Le,R,ol="<li>you have to inherit from <code>PretrainedConfig</code>,</li> <li>the <code>__init__</code> of your <code>PretrainedConfig</code> must accept any kwargs,</li> <li>those <code>kwargs</code> need to be passed to the superclass <code>__init__</code>.</li>",qe,X,il=`The inheritance is to make sure you get all the functionality from the 🤗 Transformers library, while the two other
constraints come from the fact a <code>PretrainedConfig</code> has more fields than the ones you are setting. When reloading a
config with the <code>from_pretrained</code> method, those fields need to be accepted by your config and then sent to the
superclass.`,Pe,x,rl=`Defining a <code>model_type</code> for your configuration (here <code>model_type=&quot;resnet&quot;</code>) is not mandatory, unless you want to
register your model with the auto classes (see last section).`,De,Y,Ml=`With this done, you can easily create and save your configuration like you would do with any other model config of the
library. Here is how we can create a resnet50d config and save it:`,Ke,G,Oe,V,pl=`This will save a file named <code>config.json</code> inside the folder <code>custom-resnet</code>. You can then reload your config with the
<code>from_pretrained</code> method:`,et,Q,tt,H,cl=`You can also use any other method of the <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> class, like <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to
directly upload your config to the Hub.`,lt,E,st,z,ml=`Now that we have our ResNet configuration, we can go on writing the model. We will actually write two: one that
extracts the hidden features from a batch of images (like <a href="/docs/transformers/pr_31098/en/model_doc/bert#transformers.BertModel">BertModel</a>) and one that is suitable for image
classification (like <a href="/docs/transformers/pr_31098/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a>).`,nt,F,dl=`As we mentioned before, we’ll only write a loose wrapper of the model to keep it simple for this example. The only
thing we need to do before writing this class is a map between the block types and actual block classes. Then the
model is defined from the configuration by passing everything to the <code>ResNet</code> class:`,at,S,ot,L,yl="For the model that will classify images, we just change the forward method:",it,q,rt,P,ul=`In both cases, notice how we inherit from <code>PreTrainedModel</code> and call the superclass initialization with the <code>config</code>
(a bit like when you write a regular <code>torch.nn.Module</code>). The line that sets the <code>config_class</code> is not mandatory, unless
you want to register your model with the auto classes (see last section).`,Mt,g,pt,D,fl=`You can have your model return anything you want, but returning a dictionary like we did for
<code>ResnetModelForImageClassification</code>, with the loss included when labels are passed, will make your model directly
usable inside the <a href="/docs/transformers/pr_31098/en/main_classes/trainer#transformers.Trainer">Trainer</a> class. Using another output format is fine as long as you are planning on using your own
training loop or another library for training.`,ct,K,wl="Now that we have our model class, let’s create one:",mt,O,dt,ee,hl=`Again, you can use any of the methods of <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, like <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> or
<a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>. We will use the second in the next section, and see how to push the model weights
with the code of our model. But first, let’s load some pretrained weights inside our model.`,yt,te,Tl=`In your own use case, you will probably be training your custom model on your own data. To go fast for this tutorial,
we will use the pretrained version of the resnet50d. Since our model is just a wrapper around it, it’s going to be
easy to transfer those weights:`,ut,le,ft,se,Jl=`Now let’s see how to make sure that when we do <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> or <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>, the
code of the model is saved.`,wt,ne,ht,ae,jl=`If you are writing a library that extends 🤗 Transformers, you may want to extend the auto classes to include your own
model. This is different from pushing the code to the Hub in the sense that users will need to import your library to
get the custom models (contrarily to automatically downloading the model code from the Hub).`,Tt,oe,Ul=`As long as your config has a <code>model_type</code> attribute that is different from existing model types, and that your model
classes have the right <code>config_class</code> attributes, you can just add them to the auto classes like this:`,Jt,ie,jt,re,bl=`Note that the first argument used when registering your custom config to <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a> needs to match the <code>model_type</code>
of your custom config, and the first argument used when registering your custom models to any auto model class needs
to match the <code>config_class</code> of those models.`,Ut,Me,bt,I,Ct,pe,Cl=`First, make sure your model is fully defined in a <code>.py</code> file. It can rely on relative imports to some other files as
long as all the files are in the same directory (we don’t support submodules for this feature yet). For our example,
we’ll define a <code>modeling_resnet.py</code> file and a <code>configuration_resnet.py</code> file in a folder of the current working
directory named <code>resnet_model</code>. The configuration file contains the code for <code>ResnetConfig</code> and the modeling file
contains the code of <code>ResnetModel</code> and <code>ResnetModelForImageClassification</code>.`,gt,ce,It,me,gl="The <code>__init__.py</code> can be empty, it’s just there so that Python detects <code>resnet_model</code> can be use as a module.",_t,_,Zt,de,Il="Note that you can re-use (or subclass) an existing configuration/model.",$t,ye,_l=`To share your model with the community, follow those steps: first import the ResNet model and config from the newly
created files:`,At,ue,kt,fe,Zl=`Then you have to tell the library you want to copy the code files of those objects when using the <code>save_pretrained</code>
method and properly register them with a given Auto class (especially for models), just run:`,vt,we,Nt,he,$l=`Note that there is no need to specify an auto class for the configuration (there is only one auto class for them,
<a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>) but it’s different for models. Your custom model could be suitable for many different tasks, so you
have to specify which one of the auto classes is the correct one for your model.`,Wt,Z,Bt,Te,Al="Next, let’s create the config and models as we did before:",Rt,Je,Xt,je,kl="Now to send the model to the Hub, make sure you are logged in. Either run in your terminal:",xt,Ue,Yt,be,vl="or from a notebook:",Gt,Ce,Vt,ge,Nl="You can then push to your own namespace (or an organization you are a member of) like this:",Qt,Ie,Ht,_e,Wl=`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration <code>.py</code> files in the folder <code>custom-resnet50d</code> and uploaded the result to the Hub. You can check the result
in this <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.`,Et,Ze,Bl='See the <a href="model_sharing">sharing tutorial</a> for more information on the push to Hub method.',zt,$e,Ft,Ae,Rl=`You can use any configuration, model or tokenizer with custom code files in its repository with the auto-classes and
the <code>from_pretrained</code> method. All files and code uploaded to the Hub are scanned for malware (refer to the <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub security</a> documentation for more information), but you should still
review the model code and author to avoid executing malicious code on your machine. Set <code>trust_remote_code=True</code> to use
a model with custom code:`,St,ke,Lt,ve,Xl=`It is also strongly encouraged to pass a commit hash as a <code>revision</code> to make sure the author of the models did not
update the code with some malicious new lines (unless you fully trust the authors of the models).`,qt,Ne,Pt,We,xl=`Note that when browsing the commit history of the model repo on the Hub, there is a button to easily copy the commit
hash of any commit.`,Dt,Be,Kt,Xe,Ot;return U=new Re({props:{title:"Building custom models",local:"building-custom-models",headingTag:"h1"}}),k=new Re({props:{title:"Writing a custom configuration",local:"writing-a-custom-configuration",headingTag:"h2"}}),C=new xe({props:{$$slots:{default:[Ol]},$$scope:{ctx:j}}}),W=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZXRyYWluZWRDb25maWclMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwTGlzdCUwQSUwQSUwQWNsYXNzJTIwUmVzbmV0Q29uZmlnKFByZXRyYWluZWRDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWxfdHlwZSUyMCUzRCUyMCUyMnJlc25ldCUyMiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVycyUzQSUyMExpc3QlNUJpbnQlNUQlMjAlM0QlMjAlNUIzJTJDJTIwNCUyQyUyMDYlMkMlMjAzJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0ElMjBpbnQlMjAlM0QlMjAxMDAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfY2hhbm5lbHMlM0ElMjBpbnQlMjAlM0QlMjAzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0ElMjBpbnQlMjAlM0QlMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzQSUyMGludCUyMCUzRCUyMDY0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzQSUyMGludCUyMCUzRCUyMDY0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNBJTIwc3RyJTIwJTNEJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0ElMjBib29sJTIwJTNEJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKmt3YXJncyUyQyUwQSUyMCUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGJsb2NrX3R5cGUlMjBub3QlMjBpbiUyMCU1QiUyMmJhc2ljJTIyJTJDJTIwJTIyYm90dGxlbmVjayUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihmJTIyJTYwYmxvY2tfdHlwZSU2MCUyMG11c3QlMjBiZSUyMCdiYXNpYyclMjBvciUyMGJvdHRsZW5lY2snJTJDJTIwZ290JTIwJTdCYmxvY2tfdHlwZSU3RC4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzdGVtX3R5cGUlMjBub3QlMjBpbiUyMCU1QiUyMiUyMiUyQyUyMCUyMmRlZXAlMjIlMkMlMjAlMjJkZWVwLXRpZXJlZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihmJTIyJTYwc3RlbV90eXBlJTYwJTIwbXVzdCUyMGJlJTIwJyclMkMlMjAnZGVlcCclMjBvciUyMCdkZWVwLXRpZXJlZCclMkMlMjBnb3QlMjAlN0JzdGVtX3R5cGUlN0QuJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmxvY2tfdHlwZSUyMCUzRCUyMGJsb2NrX3R5cGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxheWVycyUyMCUzRCUyMGxheWVycyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubnVtX2NsYXNzZXMlMjAlM0QlMjBudW1fY2xhc3NlcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5wdXRfY2hhbm5lbHMlMjAlM0QlMjBpbnB1dF9jaGFubmVscyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2FyZGluYWxpdHklMjAlM0QlMjBjYXJkaW5hbGl0eSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmFzZV93aWR0aCUyMCUzRCUyMGJhc2Vfd2lkdGglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnN0ZW1fd2lkdGglMjAlM0QlMjBzdGVtX3dpZHRoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5zdGVtX3R5cGUlMjAlM0QlMjBzdGVtX3R5cGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmF2Z19kb3duJTIwJTNEJTIwYXZnX2Rvd24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCoqa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),G=new J({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),Q=new J({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),E=new Re({props:{title:"Writing a custom model",local:"writing-a-custom-model",headingTag:"h2"}}),S=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),q=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),g=new xe({props:{$$slots:{default:[es]},$$scope:{ctx:j}}}),O=new J({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),le=new J({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ne=new Re({props:{title:"Registering a model with custom code to the auto classes",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),ie=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),Me=new Re({props:{title:"Sending the code to the Hub",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),I=new xe({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:j}}}),ce=new J({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),_=new xe({props:{warning:!0,$$slots:{default:[ls]},$$scope:{ctx:j}}}),ue=new J({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),we=new J({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),Z=new xe({props:{$$slots:{default:[ss]},$$scope:{ctx:j}}}),Je=new J({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),Ue=new J({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Ce=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Ie=new J({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),$e=new Re({props:{title:"Using a model with custom code",local:"using-a-model-with-custom-code",headingTag:"h2"}}),ke=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ne=new J({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),Be=new Kl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/custom_models.md"}}),{c(){o=i("meta"),h=n(),p=i("p"),w=n(),c(U.$$.fragment),T=n(),b=i("p"),b.textContent=el,Ge=n(),$=i("p"),$.textContent=tl,Ve=n(),A=i("p"),A.innerHTML=ll,Qe=n(),c(k.$$.fragment),He=n(),v=i("p"),v.innerHTML=sl,Ee=n(),c(C.$$.fragment),ze=n(),N=i("p"),N.textContent=nl,Fe=n(),c(W.$$.fragment),Se=n(),B=i("p"),B.textContent=al,Le=n(),R=i("ul"),R.innerHTML=ol,qe=n(),X=i("p"),X.innerHTML=il,Pe=n(),x=i("p"),x.innerHTML=rl,De=n(),Y=i("p"),Y.textContent=Ml,Ke=n(),c(G.$$.fragment),Oe=n(),V=i("p"),V.innerHTML=pl,et=n(),c(Q.$$.fragment),tt=n(),H=i("p"),H.innerHTML=cl,lt=n(),c(E.$$.fragment),st=n(),z=i("p"),z.innerHTML=ml,nt=n(),F=i("p"),F.innerHTML=dl,at=n(),c(S.$$.fragment),ot=n(),L=i("p"),L.textContent=yl,it=n(),c(q.$$.fragment),rt=n(),P=i("p"),P.innerHTML=ul,Mt=n(),c(g.$$.fragment),pt=n(),D=i("p"),D.innerHTML=fl,ct=n(),K=i("p"),K.textContent=wl,mt=n(),c(O.$$.fragment),dt=n(),ee=i("p"),ee.innerHTML=hl,yt=n(),te=i("p"),te.textContent=Tl,ut=n(),c(le.$$.fragment),ft=n(),se=i("p"),se.innerHTML=Jl,wt=n(),c(ne.$$.fragment),ht=n(),ae=i("p"),ae.textContent=jl,Tt=n(),oe=i("p"),oe.innerHTML=Ul,Jt=n(),c(ie.$$.fragment),jt=n(),re=i("p"),re.innerHTML=bl,Ut=n(),c(Me.$$.fragment),bt=n(),c(I.$$.fragment),Ct=n(),pe=i("p"),pe.innerHTML=Cl,gt=n(),c(ce.$$.fragment),It=n(),me=i("p"),me.innerHTML=gl,_t=n(),c(_.$$.fragment),Zt=n(),de=i("p"),de.textContent=Il,$t=n(),ye=i("p"),ye.textContent=_l,At=n(),c(ue.$$.fragment),kt=n(),fe=i("p"),fe.innerHTML=Zl,vt=n(),c(we.$$.fragment),Nt=n(),he=i("p"),he.innerHTML=$l,Wt=n(),c(Z.$$.fragment),Bt=n(),Te=i("p"),Te.textContent=Al,Rt=n(),c(Je.$$.fragment),Xt=n(),je=i("p"),je.textContent=kl,xt=n(),c(Ue.$$.fragment),Yt=n(),be=i("p"),be.textContent=vl,Gt=n(),c(Ce.$$.fragment),Vt=n(),ge=i("p"),ge.textContent=Nl,Qt=n(),c(Ie.$$.fragment),Ht=n(),_e=i("p"),_e.innerHTML=Wl,Et=n(),Ze=i("p"),Ze.innerHTML=Bl,zt=n(),c($e.$$.fragment),Ft=n(),Ae=i("p"),Ae.innerHTML=Rl,St=n(),c(ke.$$.fragment),Lt=n(),ve=i("p"),ve.innerHTML=Xl,qt=n(),c(Ne.$$.fragment),Pt=n(),We=i("p"),We.textContent=xl,Dt=n(),c(Be.$$.fragment),Kt=n(),Xe=i("p"),this.h()},l(e){const t=Pl("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),p=r(e,"P",{}),El(p).forEach(l),w=a(e),m(U.$$.fragment,e),T=a(e),b=r(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1bvx2nz"&&(b.textContent=el),Ge=a(e),$=r(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-12q72ch"&&($.textContent=tl),Ve=a(e),A=r(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-viqtsz"&&(A.innerHTML=ll),Qe=a(e),m(k.$$.fragment,e),He=a(e),v=r(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-15o85x"&&(v.innerHTML=sl),Ee=a(e),m(C.$$.fragment,e),ze=a(e),N=r(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1u8fbq1"&&(N.textContent=nl),Fe=a(e),m(W.$$.fragment,e),Se=a(e),B=r(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-9tm0xv"&&(B.textContent=al),Le=a(e),R=r(e,"UL",{"data-svelte-h":!0}),M(R)!=="svelte-1l985bz"&&(R.innerHTML=ol),qe=a(e),X=r(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-ttxucl"&&(X.innerHTML=il),Pe=a(e),x=r(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-9uxjnq"&&(x.innerHTML=rl),De=a(e),Y=r(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1229zpx"&&(Y.textContent=Ml),Ke=a(e),m(G.$$.fragment,e),Oe=a(e),V=r(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1hshoid"&&(V.innerHTML=pl),et=a(e),m(Q.$$.fragment,e),tt=a(e),H=r(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-12dlj8b"&&(H.innerHTML=cl),lt=a(e),m(E.$$.fragment,e),st=a(e),z=r(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-4xg4yj"&&(z.innerHTML=ml),nt=a(e),F=r(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-13oyc7x"&&(F.innerHTML=dl),at=a(e),m(S.$$.fragment,e),ot=a(e),L=r(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-85b6xb"&&(L.textContent=yl),it=a(e),m(q.$$.fragment,e),rt=a(e),P=r(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1vktyut"&&(P.innerHTML=ul),Mt=a(e),m(g.$$.fragment,e),pt=a(e),D=r(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-7qoe2k"&&(D.innerHTML=fl),ct=a(e),K=r(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-zsjn9b"&&(K.textContent=wl),mt=a(e),m(O.$$.fragment,e),dt=a(e),ee=r(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1ti1gsf"&&(ee.innerHTML=hl),yt=a(e),te=r(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-kn8bw1"&&(te.textContent=Tl),ut=a(e),m(le.$$.fragment,e),ft=a(e),se=r(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-u2n15u"&&(se.innerHTML=Jl),wt=a(e),m(ne.$$.fragment,e),ht=a(e),ae=r(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-bccbz6"&&(ae.textContent=jl),Tt=a(e),oe=r(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-uijzdg"&&(oe.innerHTML=Ul),Jt=a(e),m(ie.$$.fragment,e),jt=a(e),re=r(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1f8w7nv"&&(re.innerHTML=bl),Ut=a(e),m(Me.$$.fragment,e),bt=a(e),m(I.$$.fragment,e),Ct=a(e),pe=r(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-w79o0g"&&(pe.innerHTML=Cl),gt=a(e),m(ce.$$.fragment,e),It=a(e),me=r(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1orsl60"&&(me.innerHTML=gl),_t=a(e),m(_.$$.fragment,e),Zt=a(e),de=r(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-miae0j"&&(de.textContent=Il),$t=a(e),ye=r(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-1kyhtnz"&&(ye.textContent=_l),At=a(e),m(ue.$$.fragment,e),kt=a(e),fe=r(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1ce24vd"&&(fe.innerHTML=Zl),vt=a(e),m(we.$$.fragment,e),Nt=a(e),he=r(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-mninpu"&&(he.innerHTML=$l),Wt=a(e),m(Z.$$.fragment,e),Bt=a(e),Te=r(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-19txhag"&&(Te.textContent=Al),Rt=a(e),m(Je.$$.fragment,e),Xt=a(e),je=r(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-1w2dqml"&&(je.textContent=kl),xt=a(e),m(Ue.$$.fragment,e),Yt=a(e),be=r(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-11lw65d"&&(be.textContent=vl),Gt=a(e),m(Ce.$$.fragment,e),Vt=a(e),ge=r(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1c2397x"&&(ge.textContent=Nl),Qt=a(e),m(Ie.$$.fragment,e),Ht=a(e),_e=r(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-djed3h"&&(_e.innerHTML=Wl),Et=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1sdq6eg"&&(Ze.innerHTML=Bl),zt=a(e),m($e.$$.fragment,e),Ft=a(e),Ae=r(e,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-nao5c0"&&(Ae.innerHTML=Rl),St=a(e),m(ke.$$.fragment,e),Lt=a(e),ve=r(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-1i8vto1"&&(ve.innerHTML=Xl),qt=a(e),m(Ne.$$.fragment,e),Pt=a(e),We=r(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1y2zx54"&&(We.textContent=xl),Dt=a(e),m(Be.$$.fragment,e),Kt=a(e),Xe=r(e,"P",{}),El(Xe).forEach(l),this.h()},h(){zl(o,"name","hf:doc:metadata"),zl(o,"content",as)},m(e,t){Dl(document.head,o),s(e,h,t),s(e,p,t),s(e,w,t),d(U,e,t),s(e,T,t),s(e,b,t),s(e,Ge,t),s(e,$,t),s(e,Ve,t),s(e,A,t),s(e,Qe,t),d(k,e,t),s(e,He,t),s(e,v,t),s(e,Ee,t),d(C,e,t),s(e,ze,t),s(e,N,t),s(e,Fe,t),d(W,e,t),s(e,Se,t),s(e,B,t),s(e,Le,t),s(e,R,t),s(e,qe,t),s(e,X,t),s(e,Pe,t),s(e,x,t),s(e,De,t),s(e,Y,t),s(e,Ke,t),d(G,e,t),s(e,Oe,t),s(e,V,t),s(e,et,t),d(Q,e,t),s(e,tt,t),s(e,H,t),s(e,lt,t),d(E,e,t),s(e,st,t),s(e,z,t),s(e,nt,t),s(e,F,t),s(e,at,t),d(S,e,t),s(e,ot,t),s(e,L,t),s(e,it,t),d(q,e,t),s(e,rt,t),s(e,P,t),s(e,Mt,t),d(g,e,t),s(e,pt,t),s(e,D,t),s(e,ct,t),s(e,K,t),s(e,mt,t),d(O,e,t),s(e,dt,t),s(e,ee,t),s(e,yt,t),s(e,te,t),s(e,ut,t),d(le,e,t),s(e,ft,t),s(e,se,t),s(e,wt,t),d(ne,e,t),s(e,ht,t),s(e,ae,t),s(e,Tt,t),s(e,oe,t),s(e,Jt,t),d(ie,e,t),s(e,jt,t),s(e,re,t),s(e,Ut,t),d(Me,e,t),s(e,bt,t),d(I,e,t),s(e,Ct,t),s(e,pe,t),s(e,gt,t),d(ce,e,t),s(e,It,t),s(e,me,t),s(e,_t,t),d(_,e,t),s(e,Zt,t),s(e,de,t),s(e,$t,t),s(e,ye,t),s(e,At,t),d(ue,e,t),s(e,kt,t),s(e,fe,t),s(e,vt,t),d(we,e,t),s(e,Nt,t),s(e,he,t),s(e,Wt,t),d(Z,e,t),s(e,Bt,t),s(e,Te,t),s(e,Rt,t),d(Je,e,t),s(e,Xt,t),s(e,je,t),s(e,xt,t),d(Ue,e,t),s(e,Yt,t),s(e,be,t),s(e,Gt,t),d(Ce,e,t),s(e,Vt,t),s(e,ge,t),s(e,Qt,t),d(Ie,e,t),s(e,Ht,t),s(e,_e,t),s(e,Et,t),s(e,Ze,t),s(e,zt,t),d($e,e,t),s(e,Ft,t),s(e,Ae,t),s(e,St,t),d(ke,e,t),s(e,Lt,t),s(e,ve,t),s(e,qt,t),d(Ne,e,t),s(e,Pt,t),s(e,We,t),s(e,Dt,t),d(Be,e,t),s(e,Kt,t),s(e,Xe,t),Ot=!0},p(e,[t]){const Yl={};t&2&&(Yl.$$scope={dirty:t,ctx:e}),C.$set(Yl);const Gl={};t&2&&(Gl.$$scope={dirty:t,ctx:e}),g.$set(Gl);const Vl={};t&2&&(Vl.$$scope={dirty:t,ctx:e}),I.$set(Vl);const Ql={};t&2&&(Ql.$$scope={dirty:t,ctx:e}),_.$set(Ql);const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),Z.$set(Hl)},i(e){Ot||(y(U.$$.fragment,e),y(k.$$.fragment,e),y(C.$$.fragment,e),y(W.$$.fragment,e),y(G.$$.fragment,e),y(Q.$$.fragment,e),y(E.$$.fragment,e),y(S.$$.fragment,e),y(q.$$.fragment,e),y(g.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(Me.$$.fragment,e),y(I.$$.fragment,e),y(ce.$$.fragment,e),y(_.$$.fragment,e),y(ue.$$.fragment,e),y(we.$$.fragment,e),y(Z.$$.fragment,e),y(Je.$$.fragment,e),y(Ue.$$.fragment,e),y(Ce.$$.fragment,e),y(Ie.$$.fragment,e),y($e.$$.fragment,e),y(ke.$$.fragment,e),y(Ne.$$.fragment,e),y(Be.$$.fragment,e),Ot=!0)},o(e){u(U.$$.fragment,e),u(k.$$.fragment,e),u(C.$$.fragment,e),u(W.$$.fragment,e),u(G.$$.fragment,e),u(Q.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(g.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(Me.$$.fragment,e),u(I.$$.fragment,e),u(ce.$$.fragment,e),u(_.$$.fragment,e),u(ue.$$.fragment,e),u(we.$$.fragment,e),u(Z.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u($e.$$.fragment,e),u(ke.$$.fragment,e),u(Ne.$$.fragment,e),u(Be.$$.fragment,e),Ot=!1},d(e){e&&(l(h),l(p),l(w),l(T),l(b),l(Ge),l($),l(Ve),l(A),l(Qe),l(He),l(v),l(Ee),l(ze),l(N),l(Fe),l(Se),l(B),l(Le),l(R),l(qe),l(X),l(Pe),l(x),l(De),l(Y),l(Ke),l(Oe),l(V),l(et),l(tt),l(H),l(lt),l(st),l(z),l(nt),l(F),l(at),l(ot),l(L),l(it),l(rt),l(P),l(Mt),l(pt),l(D),l(ct),l(K),l(mt),l(dt),l(ee),l(yt),l(te),l(ut),l(ft),l(se),l(wt),l(ht),l(ae),l(Tt),l(oe),l(Jt),l(jt),l(re),l(Ut),l(bt),l(Ct),l(pe),l(gt),l(It),l(me),l(_t),l(Zt),l(de),l($t),l(ye),l(At),l(kt),l(fe),l(vt),l(Nt),l(he),l(Wt),l(Bt),l(Te),l(Rt),l(Xt),l(je),l(xt),l(Yt),l(be),l(Gt),l(Vt),l(ge),l(Qt),l(Ht),l(_e),l(Et),l(Ze),l(zt),l(Ft),l(Ae),l(St),l(Lt),l(ve),l(qt),l(Pt),l(We),l(Dt),l(Kt),l(Xe)),l(o),f(U,e),f(k,e),f(C,e),f(W,e),f(G,e),f(Q,e),f(E,e),f(S,e),f(q,e),f(g,e),f(O,e),f(le,e),f(ne,e),f(ie,e),f(Me,e),f(I,e),f(ce,e),f(_,e),f(ue,e),f(we,e),f(Z,e),f(Je,e),f(Ue,e),f(Ce,e),f(Ie,e),f($e,e),f(ke,e),f(Ne,e),f(Be,e)}}}const as='{"title":"Building custom models","local":"building-custom-models","sections":[{"title":"Writing a custom configuration","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"Writing a custom model","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Registering a model with custom code to the auto classes","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2},{"title":"Sending the code to the Hub","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"Using a model with custom code","local":"using-a-model-with-custom-code","sections":[],"depth":2}],"depth":1}';function os(j){return Sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends Ll{constructor(o){super(),ql(this,o,os,ns,Fl,{})}}export{ms as component};
