import{s as Ja,f as xl,o as ba,n as ln}from"../chunks/scheduler.9039eef2.js";import{S as fa,i as ga,g as i,s as n,r as o,A as wa,h as p,f as t,c as a,j as ha,u as r,x as m,k as J,y as Ta,a as s,v as u,d as c,t as M,w as d}from"../chunks/index.cdcc3d35.js";import{T as en}from"../chunks/Tip.6f74db41.js";import{C as b}from"../chunks/CodeBlock.e3ac94d9.js";import{H as h}from"../chunks/Heading.96ce3702.js";function Ua(C){let y,T="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",f,g,j='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){y=i("p"),y.innerHTML=T,f=n(),g=i("p"),g.innerHTML=j},l(w){y=p(w,"P",{"data-svelte-h":!0}),m(y)!=="svelte-6bhicj"&&(y.innerHTML=T),f=a(w),g=p(w,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1dh7n4s"&&(g.innerHTML=j)},m(w,U){s(w,y,U),s(w,f,U),s(w,g,U)},p:ln,d(w){w&&(t(y),t(f),t(g))}}}function ja(C){let y,T="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){y=i("p"),y.textContent=T},l(f){y=p(f,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1323ut2"&&(y.textContent=T)},m(f,g){s(f,y,g)},p:ln,d(f){f&&t(y)}}}function Za(C){let y,T="Inf2 instances contain one or more Neuron devices, and each Neuron device includes 2 NeuronCore-v2. By default, we load the whole pipeline of LCM to both Neuron cores. It means that when the batch size is divisible by 2, you can fully leverage the compute power of both cores.";return{c(){y=i("p"),y.textContent=T},l(f){y=p(f,"P",{"data-svelte-h":!0}),m(y)!=="svelte-3zwean"&&(y.textContent=T)},m(f,g){s(f,y,g)},p:ln,d(f){f&&t(y)}}}function Wa(C){let y,T,f,g,j,w,U,Sl,N,tn='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-txt2img.ipynb" rel="nofollow">here</a></em>.',Yl,$,sn="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",Ql,R,nn='To get started, make sure you have <a href="../installation">configured your inf2 / trn1 instance</a>, and installed optimum:',El,x,Fl,k,Hl,S,an="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",zl,Y,pn="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",Ll,Q,mn="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionPipeline</code> class.",ql,E,on="<strong><em>Export via CLI</em></strong>",Al,F,rn="Here is an example of exporting stable diffusion components with <code>Optimum</code> CLI:",Dl,H,Pl,z,un="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Kl,L,cn="<strong><em>Export via Python API</em></strong>",Ol,q,Mn="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",et,V,lt,A,tt,D,st,P,dn="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",nt,K,yn="With pre-compiled Stable Diffusion models, now generate an image with a prompt on Neuron:",at,O,it,Z,hn,pt,ee,mt,le,Jn="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",ot,te,rt,se,bn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',ut,ne,ct,ae,fn="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",Mt,ie,dt,pe,gn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',yt,me,ht,oe,wn="With the <code>NeuronStableDiffusionInstructPix2PixPipeline</code> class, you can apply instruction-based image editing using both text guidance and image guidance.",Jt,re,bt,ue,Tn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Add a beautiful sunset</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/11-sd-ip2p.png" alt="drawing" width="250"/></td></tr></tbody>',ft,ce,gt,Me,Un='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-xl-txt2img.ipynb" rel="nofollow">here</a></em>.',wt,de,jn="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",Tt,ye,Ut,he,Zn="To deploy SDXL models, we will also start by compiling the models. We support the export of following components in the pipeline to boost the speed:",jt,Je,Wn="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",Zt,be,In="<strong><em>Export via CLI</em></strong>",Wt,fe,Gn="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",It,ge,Gt,we,Xn="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with Optimum CLI on a CPU-only instance (needs ~92 GB memory), and then run the pre-compiled models on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Xt,Te,Bn="<strong><em>Export via Python API</em></strong>",Bt,Ue,Cn="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",Ct,je,Vt,Ze,_t,We,Vn="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",vt,Ie,Nt,W,_n,$t,Ge,Rt,Xe,vn="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",xt,Be,kt,Ce,Nn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',St,Ve,Yt,_e,$n="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",Qt,ve,Et,Ne,Rn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',Ft,$e,Ht,Re,xn='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',zt,xe,kn="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",Lt,ke,qt,Se,At,I,Sn,Dt,Ye,Pt,Qe,Kt,Ee,Yn='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',Ot,_,es,Fe,ls,He,Qn='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',ts,ze,En="In <code>optimum-neuron</code>, you can:",ss,Le,Fn="<li>Use the class <code>NeuronLatentConsistencyModelPipeline</code> to compile and run inference of LCMs distilled from Stable Diffusion (SD) models.</li> <li>And continue to use the class <code>NeuronStableDiffusionXLPipeline</code> for LCMs distilled from SDXL models.</li>",ns,qe,Hn='Here are examples to compile the LCMs of Stable Diffusion ( <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> ) and Stable Diffusion XL( <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> ), and then run inference on AWS Inferentia 2 :',as,Ae,is,De,zn="<strong><em>LCM of Stable Diffusion</em></strong>",ps,Pe,ms,Ke,Ln="<strong><em>LCM of Stable Diffusion XL</em></strong>",os,Oe,rs,el,us,ll,qn="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",cs,tl,An="<strong><em>LCM of Stable Diffusion</em></strong>",Ms,sl,ds,nl,Dn="<strong><em>LCM of Stable Diffusion XL</em></strong>",ys,al,hs,il,Js,pl,Pn='SDXL Turbo is an adversarial time-distilled Stable Diffusion XL (SDXL) model capable of running inference in as little as 1 step (<a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl_turbo" rel="nofollow">check <code>🤗diffusers</code> for more details</a>).',bs,ml,Kn="In <code>optimum-neuron</code>, you can:",fs,ol,On="<li>Use the class <code>NeuronStableDiffusionXLPipeline</code> to compile and run inference.</li>",gs,rl,ea='Here we will compile the <a href="https://huggingface.co/stabilityai/sdxl-turbo" rel="nofollow"><code>stabilityai/sdxl-turbo</code></a> model with Optimum CLI.',ws,ul,Ts,cl,Us,Ml,js,dl,la="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Zs,yl,Ws,v,Is,hl,Gs,Jl,Xs,bl,ta="Low-Rank Adaptation is fast way to Stable Diffusion to adapt styles of generated images. In Optimum Neuron, we support using one or multiple LoRA adapters by fusing their parameters into the original parameters of the text encoder(s) and the unet during the compilation. Here below is an example of compiling stable diffusion models with LoRA adapters of your choice and using the compiled artifacts to generate styled images:",Bs,fl,Cs,G,sa,Vs,gl,_s,wl,na="ControlNet conditions the stable diffusion model with an additional input image. In Optimum Neuron, we support the compilation of one or multiple ControlNet(s) along with the stable diffusion checkpoint. The you can use the compiled artifacts to generate styled images.",vs,Tl,Ns,Ul,aa="We can either compile one or multiple ControlNet via the Optimum CLI or programatically via the <code>NeuronStableDiffusionControlNetPipeline</code> class by passing the <code>controlnet_ids</code>.",$s,jl,ia="<li>Export via the Optimum CLI</li>",Rs,Zl,xs,Wl,pa="<li>Export via Python API</li>",ks,Il,Ss,Gl,Ys,Xl,ma="For text-to-image, we can specify an additional conditioning input.",Qs,Bl,oa="Here is an example with a canny image, a white outline of an image on a black background. The ControlNet will use the canny image as a control to guide the model to generate an image with the same outline.",Es,Cl,Fs,X,ra,Hs,Vl,zs,_l,Ls,vl,qs,Nl,As,$l,Ds,B,ua,Ps,Rl,ca='Are there any other stable diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Ks,kl,Os;return j=new h({props:{title:"Generate images with Stable Diffusion models on AWS Inferentia",local:"generate-images-with-stable-diffusion-models-on-aws-inferentia",headingTag:"h1"}}),U=new h({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),x=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMm9wdGltdW0lNUJuZXVyb254JTJDJTIwZGlmZnVzZXJzJTVEJTIy",highlighted:'pip install <span class="hljs-string">&quot;optimum[neuronx, diffusers]&quot;</span>',wrap:!1}}),k=new h({props:{title:"Compile Stable Diffusion",local:"compile-stable-diffusion",headingTag:"h3"}}),H=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS1iYXNlJTIwJTVDJTBBJTIwJTIwLS1iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMC0taGVpZ2h0JTIwNTEyJTIwJTYwJTIzJTIwaGVpZ2h0JTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNTEyJTJDJTIwNzY4JTYwJTIwJTVDJTBBJTIwJTIwLS13aWR0aCUyMDUxMiUyMCU2MCUyMyUyMHdpZHRoJTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNTEyJTJDJTIwNzY4JTYwJTIwJTVDJTBBJTIwJTIwLS1udW1faW1hZ2VzX3Blcl9wcm9tcHQlMjA0JTIwJTYwJTIzJTIwbnVtYmVyJTIwb2YlMjBpbWFnZXMlMjB0byUyMGdlbmVyYXRlJTIwcGVyJTIwcHJvbXB0JTJDJTIwZGVmYXVsdHMlMjB0byUyMDElNjAlMjAlNUMlMEElMjAlMjAtLWF1dG9fY2FzdCUyMG1hdG11bCUyMCU2MCUyMyUyMGNhc3QlMjBvbmx5JTIwbWF0cml4JTIwbXVsdGlwbGljYXRpb24lMjBvcGVyYXRpb25zJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAlNjAlMjMlMjBjYXN0JTIwb3BlcmF0aW9ucyUyMGZyb20lMjBGUDMyJTIwdG8lMjBCRjE2JTYwJTIwJTVDJTBBJTIwJTIwc2RfbmV1cm9uJTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-2-1-base \\\n  --batch_size 1 \\\n  --height 512 `<span class="hljs-comment"># height in pixels of generated image, eg. 512, 768` \\</span>\n  --width 512 `<span class="hljs-comment"># width in pixels of generated image, eg. 512, 768` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron/',wrap:!1}}),V=new en({props:{$$slots:{default:[Ua]},$$scope:{ctx:C}}}),A=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),D=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),O=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbiUyRiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBzdGFibGVfZGlmZnVzaW9uKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ee=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),te=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBJTIzJTIwY29tcGlsZSUyMCUyNiUyMHNhdmUlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm5pdHJvc29ja2UlMkZHaGlibGktRGlmZnVzaW9uJTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfaW1nMmltZyUyRiUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZ2hpYmxpJTIwc3R5bGUlMkMlMjBhJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyMHdpdGglMjBzbm93Y2FwcGVkJTIwbW91bnRhaW5zJTJDJTIwdHJlZXMlMkMlMjBsYWtlJTIwd2l0aCUyMGRldGFpbGVkJTIwcmVmbGVjdGlvbi4lMjBzdW5saWdodCUyMGFuZCUyMGNsb3VkJTIwaW4lMjB0aGUlMjBza3klMkMlMjB3YXJtJTIwY29sb3JzJTJDJTIwOEslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

<span class="hljs-comment"># compile &amp; save</span>
model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),ne=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),ie=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),me=new h({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h3"}}),re=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBQSUwlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSklMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJzZF9pcDJwJTJGJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWRkJTIwYSUyMGJlYXV0aWZ1bCUyMHN1bnNldCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnN1bnNldF9tb3VudGFpbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInstructPix2PixPipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

pipe = NeuronStableDiffusionInstructPix2PixPipeline.from_pretrained(
  model_id, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">True</span>, **input_shapes,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_ip2p/&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Add a beautiful sunset&quot;</span>
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sunset_mountain.png&quot;</span>)`,wrap:!1}}),ce=new h({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),ye=new h({props:{title:"Compile Stable Diffusion XL",local:"compile-stable-diffusion-xl",headingTag:"h3"}}),ge=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS1iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMC0taGVpZ2h0JTIwMTAyNCUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLXdpZHRoJTIwMTAyNCUyMCU2MCUyMyUyMHdpZHRoJTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNzY4JTJDJTIwMTAyNCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwNCUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbl94bCUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),je=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ze=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Ie=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ge=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),Be=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ve=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),ve=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),$e=new h({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),ke=new h({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),Se=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHJlZmluZXIoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX3N0YXJ0JTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(
    prompt=prompt,
    num_images_per_prompt=num_images_per_prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ye=new h({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),Qe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_=new en({props:{$$slots:{default:[ja]},$$scope:{ctx:C}}}),Fe=new h({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),Ae=new h({props:{title:"Compile LCM",local:"compile-lcm",headingTag:"h3"}}),Pe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMEFudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAlM0QlMjAxJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA3NjglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDc2OCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZF9uZXVyb24lMkYlMjIlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSklMEElMEElMjMlMjBQdXNoJTIwdG8lMjBodWIlMEFzdGFibGVfZGlmZnVzaW9uLnB1c2hfdG9faHViKHNhdmVfZGlyZWN0b3J5JTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKSUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMHJlcG8lMjBpZCUyQyUyMGVnLiUyMCUyMkppbmd5YSUyRkxDTV9EcmVhbXNoYXBlcl92N19uZXVyb254JTIy",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronLatentConsistencyModelPipeline.from_pretrained(
    model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sd_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>`,wrap:!1}}),Oe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUpJTIwJTIwJTIwJTIzJTIwUmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwcmVwbyUyMGlkJTJDJTIwZWcuJTIwJTIySmluZ3lhJTJGbGNtLXNkeGwtbmV1cm9ueCUyMg==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)   <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/lcm-sdxl-neuronx&quot;</span>`,wrap:!1}}),el=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),sl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvbkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGTENNX0RyZWFtc2hhcGVyX3Y3X25ldXJvbnglMjIpJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMlNlbGYtcG9ydHJhaXQlMjBvaWwlMjBwYWludGluZyUyQyUyMGElMjBiZWF1dGlmdWwlMjBjeWJvcmclMjB3aXRoJTIwZ29sZGVuJTIwaGFpciUyQyUyMDhrJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

pipe = NeuronLatentConsistencyModelPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),al=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZsY20tc2R4bC1uZXVyb254JTIyKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJhJTIwY2xvc2UtdXAlMjBwaWN0dXJlJTIwb2YlMjBhbiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),il=new h({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h2"}}),ul=new h({props:{title:"Compile SDXL Turbo",local:"compile-sdxl-turbo",headingTag:"h3"}}),cl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIwLS1iYXRjaF9zaXplJTIwMSUyMC0taGVpZ2h0JTIwNTEyJTIwLS13aWR0aCUyMDUxMiUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjBzZHhsX3R1cmJvX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/sdxl-turbo --batch_size 1 --height 512 --width 512 --auto_cast matmul --auto_cast_type bf16 sdxl_turbo_neuron/',wrap:!1}}),Ml=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),yl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZHhsX3R1cmJvX25ldXJvbiUyRiUyMiUyQyUyMGRhdGFfcGFyYWxsZWxfbW9kZSUzRCUyMmFsbCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlNUIlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiU1RCUyMColMjAyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_turbo_neuron/&quot;</span>, data_parallel_mode=<span class="hljs-string">&quot;all&quot;</span>)
prompt = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images`,wrap:!1}}),v=new en({props:{$$slots:{default:[Za]},$$scope:{ctx:C}}}),hl=new h({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Jl=new h({props:{title:"LoRA",local:"lora",headingTag:"h3"}}),fl=new b({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJMeWtvbiUyRmRyZWFtc2hhcGVyLTclMjIlMEFhZGFwdGVyX2lkJTIwJTNEJTIwJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBJTBBJTIzJTIwQ29tcGlsZSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwaW5saW5lX3dlaWdodHNfdG9fbmVmZiUzRFRydWUlMkMlMjAlMjAlMjMlMjBjYXZlYXQlM0ElMjBwZXJmb3JtYW5jZSUyMGRyb3AlMjBpZiUyMG5lZmYlMkZ3ZWlnaHRzJTIwc2VwYXJhdGVkJTJDJTIwd2lsbCUyMGJlJTIwaW1wcm92ZWQlMjBieSUyMGElMjBmdXR1cmUlMjBOZXVyb24lMjBzZGslMjByZWxlYXNlLiUwQSUyMCUyMCUyMCUyMGxvcmFfbW9kZWxfaWRzJTNEYWRhcHRlcl9pZCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfd2VpZ2h0X25hbWVzJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FkYXB0ZXJfbmFtZXMlM0QlMjJsY20lMjIlMkMlMEElMjAlMjAlMjAlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBJTIzJTIwU2F2ZSUyMGxvY2FsbHklMjBvciUyMHVwbG9hZCUyMHRvJTIwdGhlJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJkcmVhbXNoYXBlcl83X2xjbV9sb3JhX25ldXJvbiUyRiUyMiklMEElMEElMEElMjMlMjBJbmZlcmVuY2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LCMScheduler
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline


model_id = <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>
adapter_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

<span class="hljs-comment"># Compile</span>
pipe = NeuronStableDiffusionPipeline.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    inline_weights_to_neff=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># caveat: performance drop if neff/weights separated, will be improved by a future Neuron sdk release.</span>
    lora_model_ids=adapter_id,
    lora_weight_names=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>,
    lora_adapter_names=<span class="hljs-string">&quot;lcm&quot;</span>,
    **input_shapes,
    **compiler_args,
)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
pipe.save_pretrained(<span class="hljs-string">&quot;dreamshaper_7_lcm_lora_neuron/&quot;</span>)


<span class="hljs-comment"># Inference</span>
prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),gl=new h({props:{title:"ControlNet",local:"controlnet",headingTag:"h2"}}),Tl=new h({props:{title:"Compile ControlNet",local:"compile-controlnet",headingTag:"h3"}}),Zl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS1iYXRjaF9zaXplJTIwMSUyMC0taGVpZ2h0JTIwNTEyJTIwLS13aWR0aCUyMDUxMiUyMC0tY29udHJvbG5ldF9pZHMlMjBsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMHNkX25ldXJvbl9jb250cm9sbmV0JTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m runwayml/stable-diffusion-v1-5 --batch_size 1 --height 512 --width 512 --controlnet_ids lllyasviel/sd-controlnet-canny --num_images_per_prompt 1 sd_neuron_controlnet/',wrap:!1}}),Il=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWNvbnRyb2xuZXRfaWQlMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUwQSUwQSUyMyUyMCU1Qk5ldXJvbiU1RCUyMHBpcGVsaW5lJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2lkcyUzRGNvbnRyb2xuZXRfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMlMkMlMEElMjAlMjAlMjAlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMEEpJTBBcGlwZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfbmV1cm9uX2NvbnRyb2xuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
controlnet_id = <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>

<span class="hljs-comment"># [Neuron] pipeline</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(
    model_id,
    controlnet_ids=controlnet_id,
    export=<span class="hljs-literal">True</span>,
    **input_shapes,
    **compiler_args,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)`,wrap:!1}}),Gl=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Cl=new b({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUlMEElMEElMEElMjMlMjBwcmVwYXJlJTIwY2FubnklMjBpbWFnZSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnB1dF9pbWFnZV92ZXJtZWVyLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEElMjMlMjBsb2FkJTIwcHJlLWNvbXBpbGVkJTIwbmV1cm9uJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25fY29udHJvbG5ldCUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUyMnRoZSUyMG1vbmElMjBsaXNhJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWNvbXBhcmUlMjAlM0QlMjBtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMpJTBBY29tcGFyZS5zYXZlKCUyMmNvbXBhcmUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># prepare canny image</span>
original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

<span class="hljs-comment"># load pre-compiled neuron model</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># inference</span>
output = pipe(<span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image).images[<span class="hljs-number">0</span>]
compare = make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)
compare.save(<span class="hljs-string">&quot;compare.png&quot;</span>)`,wrap:!1}}),Vl=new h({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h2"}}),_l=new h({props:{title:"Compile",local:"compile",headingTag:"h3"}}),vl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMC0tdGFzayUyMHN0YWJsZS1kaWZmdXNpb24teGwlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1oZWlnaHQlMjAxMDI0JTIwLS13aWR0aCUyMDEwMjQlMjAtLWNvbnRyb2xuZXRfaWRzJTIwZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMC1zbWFsbCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMHNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m stabilityai/stable-diffusion-xl-base-1.0 --task stable-diffusion-xl --batch_size 1 --height 1024 --width 1024 --controlnet_ids diffusers/controlnet-canny-sdxl-1.0-small --num_images_per_prompt 1 sdxl_neuron_controlnet/',wrap:!1}}),Nl=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),$l=new b({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZSUwQSUwQSUyMyUyMElucHV0cyUwQXByb21wdCUyMCUzRCUyMCUyMmFlcmlhbCUyMHZpZXclMkMlMjBhJTIwZnV0dXJpc3RpYyUyMHJlc2VhcmNoJTIwY29tcGxleCUyMGluJTIwYSUyMGJyaWdodCUyMGZvZ2d5JTIwanVuZ2xlJTJDJTIwaGFyZCUyMGxpZ2h0aW5nJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2RfY29udHJvbG5ldCUyRmhmLWxvZ28ucG5nJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUwQWNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTIwJTNEJTIwMC41JTIwJTIwJTIzJTIwcmVjb21tZW5kZWQlMjBmb3IlMjBnb29kJTIwZ2VuZXJhbGl6YXRpb24lMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMjIpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmh1Z19sYWIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLControlNetPipeline

<span class="hljs-comment"># Inputs</span>
prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)
image = np.array(image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
image = Image.fromarray(image)

controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>

pipe = NeuronStableDiffusionXLControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_neuron_controlnet&quot;</span>)

images = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=image,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;hug_lab.png&quot;</span>)`,wrap:!1}}),{c(){y=i("meta"),T=n(),f=i("p"),g=n(),o(j.$$.fragment),w=n(),o(U.$$.fragment),Sl=n(),N=i("p"),N.innerHTML=tn,Yl=n(),$=i("p"),$.innerHTML=sn,Ql=n(),R=i("p"),R.innerHTML=nn,El=n(),o(x.$$.fragment),Fl=n(),o(k.$$.fragment),Hl=n(),S=i("p"),S.innerHTML=an,zl=n(),Y=i("ul"),Y.innerHTML=pn,Ll=n(),Q=i("p"),Q.innerHTML=mn,ql=n(),E=i("p"),E.innerHTML=on,Al=n(),F=i("p"),F.innerHTML=rn,Dl=n(),o(H.$$.fragment),Pl=n(),z=i("p"),z.innerHTML=un,Kl=n(),L=i("p"),L.innerHTML=cn,Ol=n(),q=i("p"),q.innerHTML=Mn,et=n(),o(V.$$.fragment),lt=n(),o(A.$$.fragment),tt=n(),o(D.$$.fragment),st=n(),P=i("p"),P.innerHTML=dn,nt=n(),K=i("p"),K.textContent=yn,at=n(),o(O.$$.fragment),it=n(),Z=i("img"),pt=n(),o(ee.$$.fragment),mt=n(),le=i("p"),le.innerHTML=Jn,ot=n(),o(te.$$.fragment),rt=n(),se=i("table"),se.innerHTML=bn,ut=n(),o(ne.$$.fragment),ct=n(),ae=i("p"),ae.innerHTML=fn,Mt=n(),o(ie.$$.fragment),dt=n(),pe=i("table"),pe.innerHTML=gn,yt=n(),o(me.$$.fragment),ht=n(),oe=i("p"),oe.innerHTML=wn,Jt=n(),o(re.$$.fragment),bt=n(),ue=i("table"),ue.innerHTML=Tn,ft=n(),o(ce.$$.fragment),gt=n(),Me=i("p"),Me.innerHTML=Un,wt=n(),de=i("p"),de.textContent=jn,Tt=n(),o(ye.$$.fragment),Ut=n(),he=i("p"),he.textContent=Zn,jt=n(),Je=i("ul"),Je.innerHTML=Wn,Zt=n(),be=i("p"),be.innerHTML=In,Wt=n(),fe=i("p"),fe.innerHTML=Gn,It=n(),o(ge.$$.fragment),Gt=n(),we=i("p"),we.innerHTML=Xn,Xt=n(),Te=i("p"),Te.innerHTML=Bn,Bt=n(),Ue=i("p"),Ue.innerHTML=Cn,Ct=n(),o(je.$$.fragment),Vt=n(),o(Ze.$$.fragment),_t=n(),We=i("p"),We.textContent=Vn,vt=n(),o(Ie.$$.fragment),Nt=n(),W=i("img"),$t=n(),o(Ge.$$.fragment),Rt=n(),Xe=i("p"),Xe.innerHTML=vn,xt=n(),o(Be.$$.fragment),kt=n(),Ce=i("table"),Ce.innerHTML=Nn,St=n(),o(Ve.$$.fragment),Yt=n(),_e=i("p"),_e.innerHTML=$n,Qt=n(),o(ve.$$.fragment),Et=n(),Ne=i("table"),Ne.innerHTML=Rn,Ft=n(),o($e.$$.fragment),Ht=n(),Re=i("p"),Re.innerHTML=xn,zt=n(),xe=i("ol"),xe.innerHTML=kn,Lt=n(),o(ke.$$.fragment),qt=n(),o(Se.$$.fragment),At=n(),I=i("img"),Dt=n(),o(Ye.$$.fragment),Pt=n(),o(Qe.$$.fragment),Kt=n(),Ee=i("table"),Ee.innerHTML=Yn,Ot=n(),o(_.$$.fragment),es=n(),o(Fe.$$.fragment),ls=n(),He=i("p"),He.innerHTML=Qn,ts=n(),ze=i("p"),ze.innerHTML=En,ss=n(),Le=i("ul"),Le.innerHTML=Fn,ns=n(),qe=i("p"),qe.innerHTML=Hn,as=n(),o(Ae.$$.fragment),is=n(),De=i("p"),De.innerHTML=zn,ps=n(),o(Pe.$$.fragment),ms=n(),Ke=i("p"),Ke.innerHTML=Ln,os=n(),o(Oe.$$.fragment),rs=n(),o(el.$$.fragment),us=n(),ll=i("p"),ll.textContent=qn,cs=n(),tl=i("p"),tl.innerHTML=An,Ms=n(),o(sl.$$.fragment),ds=n(),nl=i("p"),nl.innerHTML=Dn,ys=n(),o(al.$$.fragment),hs=n(),o(il.$$.fragment),Js=n(),pl=i("p"),pl.innerHTML=Pn,bs=n(),ml=i("p"),ml.innerHTML=Kn,fs=n(),ol=i("ul"),ol.innerHTML=On,gs=n(),rl=i("p"),rl.innerHTML=ea,ws=n(),o(ul.$$.fragment),Ts=n(),o(cl.$$.fragment),Us=n(),o(Ml.$$.fragment),js=n(),dl=i("p"),dl.textContent=la,Zs=n(),o(yl.$$.fragment),Ws=n(),o(v.$$.fragment),Is=n(),o(hl.$$.fragment),Gs=n(),o(Jl.$$.fragment),Xs=n(),bl=i("p"),bl.textContent=ta,Bs=n(),o(fl.$$.fragment),Cs=n(),G=i("img"),Vs=n(),o(gl.$$.fragment),_s=n(),wl=i("p"),wl.textContent=na,vs=n(),o(Tl.$$.fragment),Ns=n(),Ul=i("p"),Ul.innerHTML=aa,$s=n(),jl=i("ul"),jl.innerHTML=ia,Rs=n(),o(Zl.$$.fragment),xs=n(),Wl=i("ul"),Wl.innerHTML=pa,ks=n(),o(Il.$$.fragment),Ss=n(),o(Gl.$$.fragment),Ys=n(),Xl=i("p"),Xl.textContent=ma,Qs=n(),Bl=i("p"),Bl.textContent=oa,Es=n(),o(Cl.$$.fragment),Fs=n(),X=i("img"),Hs=n(),o(Vl.$$.fragment),zs=n(),o(_l.$$.fragment),Ls=n(),o(vl.$$.fragment),qs=n(),o(Nl.$$.fragment),As=n(),o($l.$$.fragment),Ds=n(),B=i("img"),Ps=n(),Rl=i("p"),Rl.innerHTML=ca,Ks=n(),kl=i("p"),this.h()},l(e){const l=wa("svelte-u9bgzb",document.head);y=p(l,"META",{name:!0,content:!0}),l.forEach(t),T=a(e),f=p(e,"P",{}),ha(f).forEach(t),g=a(e),r(j.$$.fragment,e),w=a(e),r(U.$$.fragment,e),Sl=a(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-140c11v"&&(N.innerHTML=tn),Yl=a(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1g87d8z"&&($.innerHTML=sn),Ql=a(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1u4t7n7"&&(R.innerHTML=nn),El=a(e),r(x.$$.fragment,e),Fl=a(e),r(k.$$.fragment,e),Hl=a(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-3qllio"&&(S.innerHTML=an),zl=a(e),Y=p(e,"UL",{"data-svelte-h":!0}),m(Y)!=="svelte-1c1t3y0"&&(Y.innerHTML=pn),Ll=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-15y00oa"&&(Q.innerHTML=mn),ql=a(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1a2m8iq"&&(E.innerHTML=on),Al=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-ktaj8q"&&(F.innerHTML=rn),Dl=a(e),r(H.$$.fragment,e),Pl=a(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-jz092x"&&(z.innerHTML=un),Kl=a(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-kxhd34"&&(L.innerHTML=cn),Ol=a(e),q=p(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1bahy14"&&(q.innerHTML=Mn),et=a(e),r(V.$$.fragment,e),lt=a(e),r(A.$$.fragment,e),tt=a(e),r(D.$$.fragment,e),st=a(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1r61oa5"&&(P.innerHTML=dn),nt=a(e),K=p(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1q8fgqb"&&(K.textContent=yn),at=a(e),r(O.$$.fragment,e),it=a(e),Z=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),pt=a(e),r(ee.$$.fragment,e),mt=a(e),le=p(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-kqnotf"&&(le.innerHTML=Jn),ot=a(e),r(te.$$.fragment,e),rt=a(e),se=p(e,"TABLE",{"data-svelte-h":!0}),m(se)!=="svelte-i6e2ex"&&(se.innerHTML=bn),ut=a(e),r(ne.$$.fragment,e),ct=a(e),ae=p(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-vhijyl"&&(ae.innerHTML=fn),Mt=a(e),r(ie.$$.fragment,e),dt=a(e),pe=p(e,"TABLE",{"data-svelte-h":!0}),m(pe)!=="svelte-v8z5s8"&&(pe.innerHTML=gn),yt=a(e),r(me.$$.fragment,e),ht=a(e),oe=p(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1836mxv"&&(oe.innerHTML=wn),Jt=a(e),r(re.$$.fragment,e),bt=a(e),ue=p(e,"TABLE",{"data-svelte-h":!0}),m(ue)!=="svelte-w6yzym"&&(ue.innerHTML=Tn),ft=a(e),r(ce.$$.fragment,e),gt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1q6nuso"&&(Me.innerHTML=Un),wt=a(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-7xctqf"&&(de.textContent=jn),Tt=a(e),r(ye.$$.fragment,e),Ut=a(e),he=p(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-u4wwem"&&(he.textContent=Zn),jt=a(e),Je=p(e,"UL",{"data-svelte-h":!0}),m(Je)!=="svelte-17e9k9s"&&(Je.innerHTML=Wn),Zt=a(e),be=p(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1a2m8iq"&&(be.innerHTML=In),Wt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-9niqj3"&&(fe.innerHTML=Gn),It=a(e),r(ge.$$.fragment,e),Gt=a(e),we=p(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-eias7g"&&(we.innerHTML=Xn),Xt=a(e),Te=p(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-kxhd34"&&(Te.innerHTML=Bn),Bt=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-17tzr0c"&&(Ue.innerHTML=Cn),Ct=a(e),r(je.$$.fragment,e),Vt=a(e),r(Ze.$$.fragment,e),_t=a(e),We=p(e,"P",{"data-svelte-h":!0}),m(We)!=="svelte-8q3qyn"&&(We.textContent=Vn),vt=a(e),r(Ie.$$.fragment,e),Nt=a(e),W=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),$t=a(e),r(Ge.$$.fragment,e),Rt=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-luub4o"&&(Xe.innerHTML=vn),xt=a(e),r(Be.$$.fragment,e),kt=a(e),Ce=p(e,"TABLE",{"data-svelte-h":!0}),m(Ce)!=="svelte-1s0d0pv"&&(Ce.innerHTML=Nn),St=a(e),r(Ve.$$.fragment,e),Yt=a(e),_e=p(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-11fbw00"&&(_e.innerHTML=$n),Qt=a(e),r(ve.$$.fragment,e),Et=a(e),Ne=p(e,"TABLE",{"data-svelte-h":!0}),m(Ne)!=="svelte-18741xe"&&(Ne.innerHTML=Rn),Ft=a(e),r($e.$$.fragment,e),Ht=a(e),Re=p(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1usq821"&&(Re.innerHTML=xn),zt=a(e),xe=p(e,"OL",{"data-svelte-h":!0}),m(xe)!=="svelte-6p4eqi"&&(xe.innerHTML=kn),Lt=a(e),r(ke.$$.fragment,e),qt=a(e),r(Se.$$.fragment,e),At=a(e),I=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Dt=a(e),r(Ye.$$.fragment,e),Pt=a(e),r(Qe.$$.fragment,e),Kt=a(e),Ee=p(e,"TABLE",{"data-svelte-h":!0}),m(Ee)!=="svelte-1s7g03c"&&(Ee.innerHTML=Yn),Ot=a(e),r(_.$$.fragment,e),es=a(e),r(Fe.$$.fragment,e),ls=a(e),He=p(e,"P",{"data-svelte-h":!0}),m(He)!=="svelte-1ud6a8q"&&(He.innerHTML=Qn),ts=a(e),ze=p(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1ayizu6"&&(ze.innerHTML=En),ss=a(e),Le=p(e,"UL",{"data-svelte-h":!0}),m(Le)!=="svelte-r4tdj0"&&(Le.innerHTML=Fn),ns=a(e),qe=p(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-c4lhmw"&&(qe.innerHTML=Hn),as=a(e),r(Ae.$$.fragment,e),is=a(e),De=p(e,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1s0vvjb"&&(De.innerHTML=zn),ps=a(e),r(Pe.$$.fragment,e),ms=a(e),Ke=p(e,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-51zp7x"&&(Ke.innerHTML=Ln),os=a(e),r(Oe.$$.fragment,e),rs=a(e),r(el.$$.fragment,e),us=a(e),ll=p(e,"P",{"data-svelte-h":!0}),m(ll)!=="svelte-1ebkvay"&&(ll.textContent=qn),cs=a(e),tl=p(e,"P",{"data-svelte-h":!0}),m(tl)!=="svelte-1s0vvjb"&&(tl.innerHTML=An),Ms=a(e),r(sl.$$.fragment,e),ds=a(e),nl=p(e,"P",{"data-svelte-h":!0}),m(nl)!=="svelte-51zp7x"&&(nl.innerHTML=Dn),ys=a(e),r(al.$$.fragment,e),hs=a(e),r(il.$$.fragment,e),Js=a(e),pl=p(e,"P",{"data-svelte-h":!0}),m(pl)!=="svelte-10h80ju"&&(pl.innerHTML=Pn),bs=a(e),ml=p(e,"P",{"data-svelte-h":!0}),m(ml)!=="svelte-1ayizu6"&&(ml.innerHTML=Kn),fs=a(e),ol=p(e,"UL",{"data-svelte-h":!0}),m(ol)!=="svelte-t7g18i"&&(ol.innerHTML=On),gs=a(e),rl=p(e,"P",{"data-svelte-h":!0}),m(rl)!=="svelte-ohwj0a"&&(rl.innerHTML=ea),ws=a(e),r(ul.$$.fragment,e),Ts=a(e),r(cl.$$.fragment,e),Us=a(e),r(Ml.$$.fragment,e),js=a(e),dl=p(e,"P",{"data-svelte-h":!0}),m(dl)!=="svelte-1ebkvay"&&(dl.textContent=la),Zs=a(e),r(yl.$$.fragment,e),Ws=a(e),r(v.$$.fragment,e),Is=a(e),r(hl.$$.fragment,e),Gs=a(e),r(Jl.$$.fragment,e),Xs=a(e),bl=p(e,"P",{"data-svelte-h":!0}),m(bl)!=="svelte-k1lsm0"&&(bl.textContent=ta),Bs=a(e),r(fl.$$.fragment,e),Cs=a(e),G=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Vs=a(e),r(gl.$$.fragment,e),_s=a(e),wl=p(e,"P",{"data-svelte-h":!0}),m(wl)!=="svelte-15r2htw"&&(wl.textContent=na),vs=a(e),r(Tl.$$.fragment,e),Ns=a(e),Ul=p(e,"P",{"data-svelte-h":!0}),m(Ul)!=="svelte-clsbw5"&&(Ul.innerHTML=aa),$s=a(e),jl=p(e,"UL",{"data-svelte-h":!0}),m(jl)!=="svelte-127fndl"&&(jl.innerHTML=ia),Rs=a(e),r(Zl.$$.fragment,e),xs=a(e),Wl=p(e,"UL",{"data-svelte-h":!0}),m(Wl)!=="svelte-zxjvv9"&&(Wl.innerHTML=pa),ks=a(e),r(Il.$$.fragment,e),Ss=a(e),r(Gl.$$.fragment,e),Ys=a(e),Xl=p(e,"P",{"data-svelte-h":!0}),m(Xl)!=="svelte-92hvy2"&&(Xl.textContent=ma),Qs=a(e),Bl=p(e,"P",{"data-svelte-h":!0}),m(Bl)!=="svelte-e5xot3"&&(Bl.textContent=oa),Es=a(e),r(Cl.$$.fragment,e),Fs=a(e),X=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Hs=a(e),r(Vl.$$.fragment,e),zs=a(e),r(_l.$$.fragment,e),Ls=a(e),r(vl.$$.fragment,e),qs=a(e),r(Nl.$$.fragment,e),As=a(e),r($l.$$.fragment,e),Ds=a(e),B=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Ps=a(e),Rl=p(e,"P",{"data-svelte-h":!0}),m(Rl)!=="svelte-xbi604"&&(Rl.innerHTML=ca),Ks=a(e),kl=p(e,"P",{}),ha(kl).forEach(t),this.h()},h(){J(y,"name","hf:doc:metadata"),J(y,"content",Ia),xl(Z.src,hn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||J(Z,"src",hn),J(Z,"width","256"),J(Z,"height","256"),J(Z,"alt","stable diffusion generated image"),xl(W.src,_n="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||J(W,"src",_n),J(W,"width","256"),J(W,"height","256"),J(W,"alt","sdxl generated image"),xl(I.src,Sn="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||J(I,"src",Sn),J(I,"width","256"),J(I,"height","256"),J(I,"alt","sdxl base + refiner"),xl(G.src,sa="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/03-sd-lora.png")||J(G,"src",sa),J(G,"width","256"),J(G,"height","256"),J(G,"alt","stable diffusion generated image with LoRA adapter."),xl(X.src,ra="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/10-sd-text2img-controlnet.png?download=true")||J(X,"src",ra),J(X,"width","768"),J(X,"height","256"),J(X,"alt","stable diffusion 1.5 generated image with controlnet."),xl(B.src,ua="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/12-sdxl-text2img-controlnet.png?download=true")||J(B,"src",ua),J(B,"width","768"),J(B,"height","256"),J(B,"alt","stable diffusion xl generated image with controlnet.")},m(e,l){Ta(document.head,y),s(e,T,l),s(e,f,l),s(e,g,l),u(j,e,l),s(e,w,l),u(U,e,l),s(e,Sl,l),s(e,N,l),s(e,Yl,l),s(e,$,l),s(e,Ql,l),s(e,R,l),s(e,El,l),u(x,e,l),s(e,Fl,l),u(k,e,l),s(e,Hl,l),s(e,S,l),s(e,zl,l),s(e,Y,l),s(e,Ll,l),s(e,Q,l),s(e,ql,l),s(e,E,l),s(e,Al,l),s(e,F,l),s(e,Dl,l),u(H,e,l),s(e,Pl,l),s(e,z,l),s(e,Kl,l),s(e,L,l),s(e,Ol,l),s(e,q,l),s(e,et,l),u(V,e,l),s(e,lt,l),u(A,e,l),s(e,tt,l),u(D,e,l),s(e,st,l),s(e,P,l),s(e,nt,l),s(e,K,l),s(e,at,l),u(O,e,l),s(e,it,l),s(e,Z,l),s(e,pt,l),u(ee,e,l),s(e,mt,l),s(e,le,l),s(e,ot,l),u(te,e,l),s(e,rt,l),s(e,se,l),s(e,ut,l),u(ne,e,l),s(e,ct,l),s(e,ae,l),s(e,Mt,l),u(ie,e,l),s(e,dt,l),s(e,pe,l),s(e,yt,l),u(me,e,l),s(e,ht,l),s(e,oe,l),s(e,Jt,l),u(re,e,l),s(e,bt,l),s(e,ue,l),s(e,ft,l),u(ce,e,l),s(e,gt,l),s(e,Me,l),s(e,wt,l),s(e,de,l),s(e,Tt,l),u(ye,e,l),s(e,Ut,l),s(e,he,l),s(e,jt,l),s(e,Je,l),s(e,Zt,l),s(e,be,l),s(e,Wt,l),s(e,fe,l),s(e,It,l),u(ge,e,l),s(e,Gt,l),s(e,we,l),s(e,Xt,l),s(e,Te,l),s(e,Bt,l),s(e,Ue,l),s(e,Ct,l),u(je,e,l),s(e,Vt,l),u(Ze,e,l),s(e,_t,l),s(e,We,l),s(e,vt,l),u(Ie,e,l),s(e,Nt,l),s(e,W,l),s(e,$t,l),u(Ge,e,l),s(e,Rt,l),s(e,Xe,l),s(e,xt,l),u(Be,e,l),s(e,kt,l),s(e,Ce,l),s(e,St,l),u(Ve,e,l),s(e,Yt,l),s(e,_e,l),s(e,Qt,l),u(ve,e,l),s(e,Et,l),s(e,Ne,l),s(e,Ft,l),u($e,e,l),s(e,Ht,l),s(e,Re,l),s(e,zt,l),s(e,xe,l),s(e,Lt,l),u(ke,e,l),s(e,qt,l),u(Se,e,l),s(e,At,l),s(e,I,l),s(e,Dt,l),u(Ye,e,l),s(e,Pt,l),u(Qe,e,l),s(e,Kt,l),s(e,Ee,l),s(e,Ot,l),u(_,e,l),s(e,es,l),u(Fe,e,l),s(e,ls,l),s(e,He,l),s(e,ts,l),s(e,ze,l),s(e,ss,l),s(e,Le,l),s(e,ns,l),s(e,qe,l),s(e,as,l),u(Ae,e,l),s(e,is,l),s(e,De,l),s(e,ps,l),u(Pe,e,l),s(e,ms,l),s(e,Ke,l),s(e,os,l),u(Oe,e,l),s(e,rs,l),u(el,e,l),s(e,us,l),s(e,ll,l),s(e,cs,l),s(e,tl,l),s(e,Ms,l),u(sl,e,l),s(e,ds,l),s(e,nl,l),s(e,ys,l),u(al,e,l),s(e,hs,l),u(il,e,l),s(e,Js,l),s(e,pl,l),s(e,bs,l),s(e,ml,l),s(e,fs,l),s(e,ol,l),s(e,gs,l),s(e,rl,l),s(e,ws,l),u(ul,e,l),s(e,Ts,l),u(cl,e,l),s(e,Us,l),u(Ml,e,l),s(e,js,l),s(e,dl,l),s(e,Zs,l),u(yl,e,l),s(e,Ws,l),u(v,e,l),s(e,Is,l),u(hl,e,l),s(e,Gs,l),u(Jl,e,l),s(e,Xs,l),s(e,bl,l),s(e,Bs,l),u(fl,e,l),s(e,Cs,l),s(e,G,l),s(e,Vs,l),u(gl,e,l),s(e,_s,l),s(e,wl,l),s(e,vs,l),u(Tl,e,l),s(e,Ns,l),s(e,Ul,l),s(e,$s,l),s(e,jl,l),s(e,Rs,l),u(Zl,e,l),s(e,xs,l),s(e,Wl,l),s(e,ks,l),u(Il,e,l),s(e,Ss,l),u(Gl,e,l),s(e,Ys,l),s(e,Xl,l),s(e,Qs,l),s(e,Bl,l),s(e,Es,l),u(Cl,e,l),s(e,Fs,l),s(e,X,l),s(e,Hs,l),u(Vl,e,l),s(e,zs,l),u(_l,e,l),s(e,Ls,l),u(vl,e,l),s(e,qs,l),u(Nl,e,l),s(e,As,l),u($l,e,l),s(e,Ds,l),s(e,B,l),s(e,Ps,l),s(e,Rl,l),s(e,Ks,l),s(e,kl,l),Os=!0},p(e,[l]){const Ma={};l&2&&(Ma.$$scope={dirty:l,ctx:e}),V.$set(Ma);const da={};l&2&&(da.$$scope={dirty:l,ctx:e}),_.$set(da);const ya={};l&2&&(ya.$$scope={dirty:l,ctx:e}),v.$set(ya)},i(e){Os||(c(j.$$.fragment,e),c(U.$$.fragment,e),c(x.$$.fragment,e),c(k.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(A.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(me.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(ge.$$.fragment,e),c(je.$$.fragment,e),c(Ze.$$.fragment,e),c(Ie.$$.fragment,e),c(Ge.$$.fragment,e),c(Be.$$.fragment,e),c(Ve.$$.fragment,e),c(ve.$$.fragment,e),c($e.$$.fragment,e),c(ke.$$.fragment,e),c(Se.$$.fragment,e),c(Ye.$$.fragment,e),c(Qe.$$.fragment,e),c(_.$$.fragment,e),c(Fe.$$.fragment,e),c(Ae.$$.fragment,e),c(Pe.$$.fragment,e),c(Oe.$$.fragment,e),c(el.$$.fragment,e),c(sl.$$.fragment,e),c(al.$$.fragment,e),c(il.$$.fragment,e),c(ul.$$.fragment,e),c(cl.$$.fragment,e),c(Ml.$$.fragment,e),c(yl.$$.fragment,e),c(v.$$.fragment,e),c(hl.$$.fragment,e),c(Jl.$$.fragment,e),c(fl.$$.fragment,e),c(gl.$$.fragment,e),c(Tl.$$.fragment,e),c(Zl.$$.fragment,e),c(Il.$$.fragment,e),c(Gl.$$.fragment,e),c(Cl.$$.fragment,e),c(Vl.$$.fragment,e),c(_l.$$.fragment,e),c(vl.$$.fragment,e),c(Nl.$$.fragment,e),c($l.$$.fragment,e),Os=!0)},o(e){M(j.$$.fragment,e),M(U.$$.fragment,e),M(x.$$.fragment,e),M(k.$$.fragment,e),M(H.$$.fragment,e),M(V.$$.fragment,e),M(A.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(me.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(ye.$$.fragment,e),M(ge.$$.fragment,e),M(je.$$.fragment,e),M(Ze.$$.fragment,e),M(Ie.$$.fragment,e),M(Ge.$$.fragment,e),M(Be.$$.fragment,e),M(Ve.$$.fragment,e),M(ve.$$.fragment,e),M($e.$$.fragment,e),M(ke.$$.fragment,e),M(Se.$$.fragment,e),M(Ye.$$.fragment,e),M(Qe.$$.fragment,e),M(_.$$.fragment,e),M(Fe.$$.fragment,e),M(Ae.$$.fragment,e),M(Pe.$$.fragment,e),M(Oe.$$.fragment,e),M(el.$$.fragment,e),M(sl.$$.fragment,e),M(al.$$.fragment,e),M(il.$$.fragment,e),M(ul.$$.fragment,e),M(cl.$$.fragment,e),M(Ml.$$.fragment,e),M(yl.$$.fragment,e),M(v.$$.fragment,e),M(hl.$$.fragment,e),M(Jl.$$.fragment,e),M(fl.$$.fragment,e),M(gl.$$.fragment,e),M(Tl.$$.fragment,e),M(Zl.$$.fragment,e),M(Il.$$.fragment,e),M(Gl.$$.fragment,e),M(Cl.$$.fragment,e),M(Vl.$$.fragment,e),M(_l.$$.fragment,e),M(vl.$$.fragment,e),M(Nl.$$.fragment,e),M($l.$$.fragment,e),Os=!1},d(e){e&&(t(T),t(f),t(g),t(w),t(Sl),t(N),t(Yl),t($),t(Ql),t(R),t(El),t(Fl),t(Hl),t(S),t(zl),t(Y),t(Ll),t(Q),t(ql),t(E),t(Al),t(F),t(Dl),t(Pl),t(z),t(Kl),t(L),t(Ol),t(q),t(et),t(lt),t(tt),t(st),t(P),t(nt),t(K),t(at),t(it),t(Z),t(pt),t(mt),t(le),t(ot),t(rt),t(se),t(ut),t(ct),t(ae),t(Mt),t(dt),t(pe),t(yt),t(ht),t(oe),t(Jt),t(bt),t(ue),t(ft),t(gt),t(Me),t(wt),t(de),t(Tt),t(Ut),t(he),t(jt),t(Je),t(Zt),t(be),t(Wt),t(fe),t(It),t(Gt),t(we),t(Xt),t(Te),t(Bt),t(Ue),t(Ct),t(Vt),t(_t),t(We),t(vt),t(Nt),t(W),t($t),t(Rt),t(Xe),t(xt),t(kt),t(Ce),t(St),t(Yt),t(_e),t(Qt),t(Et),t(Ne),t(Ft),t(Ht),t(Re),t(zt),t(xe),t(Lt),t(qt),t(At),t(I),t(Dt),t(Pt),t(Kt),t(Ee),t(Ot),t(es),t(ls),t(He),t(ts),t(ze),t(ss),t(Le),t(ns),t(qe),t(as),t(is),t(De),t(ps),t(ms),t(Ke),t(os),t(rs),t(us),t(ll),t(cs),t(tl),t(Ms),t(ds),t(nl),t(ys),t(hs),t(Js),t(pl),t(bs),t(ml),t(fs),t(ol),t(gs),t(rl),t(ws),t(Ts),t(Us),t(js),t(dl),t(Zs),t(Ws),t(Is),t(Gs),t(Xs),t(bl),t(Bs),t(Cs),t(G),t(Vs),t(_s),t(wl),t(vs),t(Ns),t(Ul),t($s),t(jl),t(Rs),t(xs),t(Wl),t(ks),t(Ss),t(Ys),t(Xl),t(Qs),t(Bl),t(Es),t(Fs),t(X),t(Hs),t(zs),t(Ls),t(qs),t(As),t(Ds),t(B),t(Ps),t(Rl),t(Ks),t(kl)),t(y),d(j,e),d(U,e),d(x,e),d(k,e),d(H,e),d(V,e),d(A,e),d(D,e),d(O,e),d(ee,e),d(te,e),d(ne,e),d(ie,e),d(me,e),d(re,e),d(ce,e),d(ye,e),d(ge,e),d(je,e),d(Ze,e),d(Ie,e),d(Ge,e),d(Be,e),d(Ve,e),d(ve,e),d($e,e),d(ke,e),d(Se,e),d(Ye,e),d(Qe,e),d(_,e),d(Fe,e),d(Ae,e),d(Pe,e),d(Oe,e),d(el,e),d(sl,e),d(al,e),d(il,e),d(ul,e),d(cl,e),d(Ml,e),d(yl,e),d(v,e),d(hl,e),d(Jl,e),d(fl,e),d(gl,e),d(Tl,e),d(Zl,e),d(Il,e),d(Gl,e),d(Cl,e),d(Vl,e),d(_l,e),d(vl,e),d(Nl,e),d($l,e)}}}const Ia='{"title":"Generate images with Stable Diffusion models on AWS Inferentia","local":"generate-images-with-stable-diffusion-models-on-aws-inferentia","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Compile Stable Diffusion","local":"compile-stable-diffusion","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Compile Stable Diffusion XL","local":"compile-stable-diffusion-xl","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Compile LCM","local":"compile-lcm","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Compile SDXL Turbo","local":"compile-sdxl-turbo","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[{"title":"LoRA","local":"lora","sections":[],"depth":3}],"depth":2},{"title":"ControlNet","local":"controlnet","sections":[{"title":"Compile ControlNet","local":"compile-controlnet","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[{"title":"Compile","local":"compile","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ga(C){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class va extends fa{constructor(y){super(),ga(this,y,Ga,Wa,Ja,{})}}export{va as component};
