import{s as ke,o as ve,n as ze}from"../chunks/scheduler.a2b4ca8e.js";import{S as Ne,i as Re,g as M,s as l,r as i,A as Ge,h as y,f as t,c as a,j as Se,u as m,x as b,k as Xe,y as He,a as s,v as c,d as p,t as d,w as u}from"../chunks/index.d2f673cc.js";import{T as Qe}from"../chunks/Tip.a902c250.js";import{C as A}from"../chunks/CodeBlock.792343a6.js";import{H as j}from"../chunks/Heading.675d4c1e.js";function xe(D){let r,Z="<strong>Caveat</strong>",T,h,J="Since compiled models with dynamic batching enabled only accept input tensors with the same batch size, we cannot set <code>dynamic_batch_size=True</code> if the input texts and images have different batch sizes. And as <code>NeuronModelForSentenceTransformers</code> class pads the inputs to the batch sizes (<code>text_batch_size</code> and <code>image_batch_size</code>) used during the compilation, you could use relatively larger batch sizes during the compilation for flexibility with the trade-off of compute.",w,f,g="eg. if you want to encode 3 or 4 or 5 texts and 1 image, you could set <code>text_batch_size = 5 = max(3, 4, 5)</code> and <code>image_batch_size = 1</code> during the compilation.";return{c(){r=M("p"),r.innerHTML=Z,T=l(),h=M("p"),h.innerHTML=J,w=l(),f=M("p"),f.innerHTML=g},l(o){r=y(o,"P",{"data-svelte-h":!0}),b(r)!=="svelte-6rj1id"&&(r.innerHTML=Z),T=a(o),h=y(o,"P",{"data-svelte-h":!0}),b(h)!=="svelte-1nmpr7n"&&(h.innerHTML=J),w=a(o),f=y(o,"P",{"data-svelte-h":!0}),b(f)!=="svelte-7gdj48"&&(f.innerHTML=g)},m(o,U){s(o,r,U),s(o,T,U),s(o,h,U),s(o,w,U),s(o,f,U)},p:ze,d(o){o&&(t(r),t(T),t(h),t(w),t(f))}}}function Ye(D){let r,Z,T,h,J,w,f,g,o,U='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/sentence-transformers/getting-started.ipynb" rel="nofollow">here</a>.</em>',K,I,We='This guide explains how to compile, load, and use <a href="https://www.sbert.net/" rel="nofollow">Sentence Transformers (SBERT)</a> models on AWS Inferentia2 with Optimum Neuron, enabling efficient calculation of embeddings. Sentence Transformers are powerful models for generating sentence embeddings. You can use this Sentence Transformers to compute sentence / text embeddings for more than 100 languages. These embeddings can then be compared e.g. with cosine-similarity to find sentences with a similar meaning. This can be useful for semantic textual similarity, semantic search, or paraphrase mining.',O,B,ee,_,je="First, you need to convert your Sentence Transformers model to a format compatible with AWS Inferentia2. You can compile Sentence Transformers models with Optimum Neuron using the <code>optimum-cli</code> or <code>NeuronModelForSentenceTransformers</code> class. Below you will find an example for both approaches. We have to make sure <code>sentence-transformers</code> is installed. Thats only needed for exporting the model.",ne,$,te,V,Ze="Here we will use the <code>NeuronModelForSentenceTransformers</code>, which can be used to convert any Sntence Transformers model to a format compatible with AWS Inferentia2 or load already converted models. When exporting models with the <code>NeuronModelForSentenceTransformers</code> you need to set <code>export=True</code> and define the input shape and batch size. The input shape is defined by the <code>sequence_length</code> and the batch size by <code>batch_size</code>.",se,C,le,S,ge="Here we will use the <code>optimum-cli</code> to convert the model. Similar to the <code>NeuronModelForSentenceTransformers</code> we need to define our input shape and batch size. The input shape is defined by the <code>sequence_length</code> and the batch size by <code>batch_size</code>. The <code>optimum-cli</code> will automatically convert the model to a format compatible with AWS Inferentia2 and save it to the specified output directory.",ae,X,oe,k,re,v,Ie="Once we have a compiled Sentence Transformers model, which we either exported ourselves or is available on the Hugging Face Hub, we can load it and run inference. For loading the model we can use the <code>NeuronModelForSentenceTransformers</code> class, which is an abstraction layer for the <code>SentenceTransformer</code> class. The <code>NeuronModelForSentenceTransformers</code> class will automatically pad the input to the specified <code>sequence_length</code> and run inference on AWS Inferentia2.",ie,z,me,N,ce,R,Be='For deploying these models in a production environment, refer to the <a href="https://www.philschmid.de/inferentia2-embeddings" rel="nofollow">Amazon SageMaker Blog</a>.',pe,G,de,H,ue,Q,_e="You can compile CLIP models with Optimum Neuron either by using the <code>optimum-cli</code> or <code>NeuronModelForSentenceTransformers</code> class. Adopt one approach that you prefer:",Me,x,$e="<li>With the Optimum CLI</li>",ye,Y,fe,F,Ve="<li>With the <code>NeuronModelForSentenceTransformers</code> class</li>",be,E,he,L,Te,q,Je,W,we,P,Ue;return J=new j({props:{title:"Sentence Transformers on AWS Inferentia with Optimum Neuron",local:"sentence-transformers-on-aws-inferentia-with-optimum-neuron",headingTag:"h1"}}),f=new j({props:{title:"Text Models",local:"text-models",headingTag:"h2"}}),B=new j({props:{title:"Convert Sentence Transformers model to AWS Inferentia2",local:"convert-sentence-transformers-model-to-aws-inferentia2",headingTag:"h3"}}),$=new A({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycw==",highlighted:"pip install sentence-transformers",wrap:!1}}),C=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQSUwQSUyMyUyMFNlbnRlbmNlJTIwVHJhbnNmb3JtZXJzJTIwbW9kZWwlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMzg0JTdEJTIwJTIwJTIzJTIwbWFuZGF0b3J5JTIwc2hhcGVzJTBBJTBBJTIzJTIwTG9hZCUyMFRyYW5zZm9ybWVycyUyMG1vZGVsJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMEFXUyUyMEluZmVyZW50aWEyJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEElMjMlMjBTYXZlJTIwbW9kZWwlMjB0byUyMGRpc2slMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyYmdlX2VtYl9pbmYyJTJGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-comment"># Sentence Transformers model from HuggingFace</span>
model_id = <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">384</span>}  <span class="hljs-comment"># mandatory shapes</span>

<span class="hljs-comment"># Load Transformers model and export it to AWS Inferentia2</span>
model = NeuronModelForSentenceTransformers.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)

<span class="hljs-comment"># Save model to disk</span>
model.save_pretrained(<span class="hljs-string">&quot;bge_emb_inf2/&quot;</span>)`,wrap:!1}}),X=new A({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMEJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMC0tbGlicmFyeS1uYW1lJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwLS1zZXF1ZW5jZV9sZW5ndGglMjAzODQlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS10YXNrJTIwZmVhdHVyZS1leHRyYWN0aW9uJTIwYmdlX2VtYl9pbmYyJTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m BAAI/bge-small-en-v1.5 --library-name sentence_transformers --sequence_length 384 --batch_size 1 --task feature-extraction bge_emb_inf2/',wrap:!1}}),k=new j({props:{title:"Load compiled Sentence Transformers model and run inference",local:"load-compiled-sentence-transformers-model-and-run-inference",headingTag:"h3"}}),z=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWRfb3JfcGF0aCUyMCUzRCUyMCUyMmJnZV9lbWJfaW5mMiUyRiUyMiUwQXRva2VuaXplcl9pZCUyMCUzRCUyMCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCh0b2tlbml6ZXJfaWQpJTBBJTBBJTIzJTIwUnVuJTIwaW5mZXJlbmNlJTBBcHJvbXB0JTIwJTNEJTIwJTIySSUyMGxpa2UlMjB0byUyMGVhdCUyMGFwcGxlcyUyMiUwQWVuY29kZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QncHQnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kZWRfaW5wdXQpJTBBJTBBdG9rZW5fZW1iZWRkaW5ncyUyMCUzRCUyMG91dHB1dHMudG9rZW5fZW1iZWRkaW5ncyUwQXNlbnRlbmNlX2VtYmVkZGluZyUyMCUzRCUyMG91dHB1dHMuc2VudGVuY2VfZW1iZWRkaW5nJTBBJTBBcHJpbnQoZiUyMnRva2VuJTIwZW1iZWRkaW5ncyUzQSUyMCU3QnRva2VuX2VtYmVkZGluZ3Muc2hhcGUlN0QlMjIpJTIwJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwNyUyQyUyMDM4NCU1RCklMEFwcmludChmJTIyc2VudGVuY2VfZW1iZWRkaW5nJTNBJTIwJTdCc2VudGVuY2VfZW1iZWRkaW5nLnNoYXBlJTdEJTIyKSUyMCUyMyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDM4NCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

model_id_or_path = <span class="hljs-string">&quot;bge_emb_inf2/&quot;</span>
tokenizer_id = <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>

<span class="hljs-comment"># Load model and tokenizer</span>
model = NeuronModelForSentenceTransformers.from_pretrained(model_id_or_path)
tokenizer = AutoTokenizer.from_pretrained(tokenizer_id)

<span class="hljs-comment"># Run inference</span>
prompt = <span class="hljs-string">&quot;I like to eat apples&quot;</span>
encoded_input = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>)
outputs = model(**encoded_input)

token_embeddings = outputs.token_embeddings
sentence_embedding = outputs.sentence_embedding

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;token embeddings: <span class="hljs-subst">{token_embeddings.shape}</span>&quot;</span>) <span class="hljs-comment"># torch.Size([1, 7, 384])</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sentence_embedding: <span class="hljs-subst">{sentence_embedding.shape}</span>&quot;</span>) <span class="hljs-comment"># torch.Size([1, 384])</span>`,wrap:!1}}),N=new j({props:{title:"Production Usage",local:"production-usage",headingTag:"h3"}}),G=new j({props:{title:"CLIP",local:"clip",headingTag:"h2"}}),H=new j({props:{title:"Compile CLIP for AWS Inferentia2",local:"compile-clip-for-aws-inferentia2",headingTag:"h3"}}),Y=new A({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmNsaXAtVmlULUItMzIlMjAtLXNlcXVlbmNlX2xlbmd0aCUyMDY0JTIwLS10ZXh0X2JhdGNoX3NpemUlMjAzJTIwLS1pbWFnZV9iYXRjaF9zaXplJTIwMSUyMC0tbnVtX2NoYW5uZWxzJTIwMyUyMC0taGVpZ2h0JTIwMjI0JTIwLS13aWR0aCUyMDIyNCUyMC0tdGFzayUyMGZlYXR1cmUtZXh0cmFjdGlvbiUyMC0tbGlicmFyeS1uYW1lJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwLS1zdWJmb2xkZXIlMjAwX0NMSVBNb2RlbCUyMGNsaXBfZW1iJTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m sentence-transformers/clip-ViT-B-32 --sequence_length 64 --text_batch_size 3 --image_batch_size 1 --num_channels 3 --height 224 --width 224 --task feature-extraction --library-name sentence_transformers --subfolder 0_CLIPModel clip_emb/',wrap:!1}}),E=new A({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGY2xpcC1WaVQtQi0zMiUyMiUwQSUwQSUyMyUyMGNvbmZpZ3MlMjBmb3IlMjBjb21waWxpbmclMjBtb2RlbCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm51bV9jaGFubmVscyUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjJoZWlnaHQlMjIlM0ElMjAyMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJ3aWR0aCUyMiUzQSUyMDIyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRleHRfYmF0Y2hfc2l6ZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjJpbWFnZV9iYXRjaF9zaXplJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMnNlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDY0JTJDJTBBJTdEJTBBJTBBZW1iX21vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjIwX0NMSVBNb2RlbCUyMiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjBsaWJyYXJ5X25hbWUlM0QlMjJzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMjIlMkMlMjBkeW5hbWljX2JhdGNoX3NpemUlM0RGYWxzZSUyQyUyMCoqaW5wdXRfc2hhcGVzJTBBKSUwQSUwQSUyMyUyMFNhdmUlMjBsb2NhbGx5JTIwb3IlMjB1cGxvYWQlMjB0byUyMHRoZSUyMEh1Z2dpbmdGYWNlJTIwSHViJTBBc2F2ZV9kaXJlY3RvcnklMjAlM0QlMjAlMjJjbGlwX2VtYiUyRiUyMiUwQWVtYl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3Rvcnkp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

model_id = <span class="hljs-string">&quot;sentence-transformers/clip-ViT-B-32&quot;</span>

<span class="hljs-comment"># configs for compiling model</span>
input_shapes = {
    <span class="hljs-string">&quot;num_channels&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">224</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">224</span>,
    <span class="hljs-string">&quot;text_batch_size&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;image_batch_size&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">64</span>,
}

emb_model = NeuronModelForSentenceTransformers.from_pretrained(
    model_id, subfolder=<span class="hljs-string">&quot;0_CLIPModel&quot;</span>, export=<span class="hljs-literal">True</span>, library_name=<span class="hljs-string">&quot;sentence_transformers&quot;</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, **input_shapes
)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
save_directory = <span class="hljs-string">&quot;clip_emb/&quot;</span>
emb_model.save_pretrained(save_directory)`,wrap:!1}}),L=new j({props:{title:"Load compiled Sentence Transformers model and run inference",local:"load-compiled-sentence-transformers-model-and-run-inference",headingTag:"h3"}}),q=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMHV0aWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFByb2Nlc3NvciUwQSUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMlMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmNsaXBfZW1iJTIyJTBBZW1iX21vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ0xJUFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjJUd28lMjBkb2dzJTIwaW4lMjB0aGUlMjBzbm93JTIyJTJDJTIwJ0ElMjBjYXQlMjBvbiUyMGElMjB0YWJsZSclMkMlMjAnQSUyMHBpY3R1cmUlMjBvZiUyMExvbmRvbiUyMGF0JTIwbmlnaHQnJTVEJTJDJTIwaW1hZ2VzJTNESW1hZ2Uub3BlbiglMjJ0d29fZG9nc19pbl9zbm93LmpwZyUyMiklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTIwJTIwJTBBJTBBb3V0cHV0cyUyMCUzRCUyMGVtYl9tb2RlbCgqKmlucHV0cyklMEElMEElMEElMjMlMjBDb21wdXRlJTIwY29zaW5lJTIwc2ltaWxhcml0aWVzJTBBY29zX3Njb3JlcyUyMCUzRCUyMHV0aWwuY29zX3NpbShvdXRwdXRzLmltYWdlX2VtYmVkcyUyQyUyMG91dHB1dHMudGV4dF9lbWJlZHMpJTBBcHJpbnQoY29zX3Njb3JlcyklMEElMEElMjMlMjB0ZW5zb3IoJTVCJTVCMC4zMDcyJTJDJTIwMC4xMDE2JTJDJTIwMC4xMDk1JTVEJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> util
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPProcessor

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

save_directory = <span class="hljs-string">&quot;clip_emb&quot;</span>
emb_model = NeuronModelForSentenceTransformers.from_pretrained(save_directory)

processor = CLIPProcessor.from_pretrained(save_directory)
inputs = processor(
    text=[<span class="hljs-string">&quot;Two dogs in the snow&quot;</span>, <span class="hljs-string">&#x27;A cat on a table&#x27;</span>, <span class="hljs-string">&#x27;A picture of London at night&#x27;</span>], images=Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
)  

outputs = emb_model(**inputs)


<span class="hljs-comment"># Compute cosine similarities</span>
cos_scores = util.cos_sim(outputs.image_embeds, outputs.text_embeds)
<span class="hljs-built_in">print</span>(cos_scores)

<span class="hljs-comment"># tensor([[0.3072, 0.1016, 0.1095]])</span>`,wrap:!1}}),W=new Qe({props:{$$slots:{default:[xe]},$$scope:{ctx:D}}}),{c(){r=M("meta"),Z=l(),T=M("p"),h=l(),i(J.$$.fragment),w=l(),i(f.$$.fragment),g=l(),o=M("p"),o.innerHTML=U,K=l(),I=M("p"),I.innerHTML=We,O=l(),i(B.$$.fragment),ee=l(),_=M("p"),_.innerHTML=je,ne=l(),i($.$$.fragment),te=l(),V=M("p"),V.innerHTML=Ze,se=l(),i(C.$$.fragment),le=l(),S=M("p"),S.innerHTML=ge,ae=l(),i(X.$$.fragment),oe=l(),i(k.$$.fragment),re=l(),v=M("p"),v.innerHTML=Ie,ie=l(),i(z.$$.fragment),me=l(),i(N.$$.fragment),ce=l(),R=M("p"),R.innerHTML=Be,pe=l(),i(G.$$.fragment),de=l(),i(H.$$.fragment),ue=l(),Q=M("p"),Q.innerHTML=_e,Me=l(),x=M("ul"),x.innerHTML=$e,ye=l(),i(Y.$$.fragment),fe=l(),F=M("ul"),F.innerHTML=Ve,be=l(),i(E.$$.fragment),he=l(),i(L.$$.fragment),Te=l(),i(q.$$.fragment),Je=l(),i(W.$$.fragment),we=l(),P=M("p"),this.h()},l(e){const n=Ge("svelte-u9bgzb",document.head);r=y(n,"META",{name:!0,content:!0}),n.forEach(t),Z=a(e),T=y(e,"P",{}),Se(T).forEach(t),h=a(e),m(J.$$.fragment,e),w=a(e),m(f.$$.fragment,e),g=a(e),o=y(e,"P",{"data-svelte-h":!0}),b(o)!=="svelte-z9n49l"&&(o.innerHTML=U),K=a(e),I=y(e,"P",{"data-svelte-h":!0}),b(I)!=="svelte-12xwboz"&&(I.innerHTML=We),O=a(e),m(B.$$.fragment,e),ee=a(e),_=y(e,"P",{"data-svelte-h":!0}),b(_)!=="svelte-3c4dyj"&&(_.innerHTML=je),ne=a(e),m($.$$.fragment,e),te=a(e),V=y(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-h22i3c"&&(V.innerHTML=Ze),se=a(e),m(C.$$.fragment,e),le=a(e),S=y(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-reiugv"&&(S.innerHTML=ge),ae=a(e),m(X.$$.fragment,e),oe=a(e),m(k.$$.fragment,e),re=a(e),v=y(e,"P",{"data-svelte-h":!0}),b(v)!=="svelte-4dcngh"&&(v.innerHTML=Ie),ie=a(e),m(z.$$.fragment,e),me=a(e),m(N.$$.fragment,e),ce=a(e),R=y(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-qum7z"&&(R.innerHTML=Be),pe=a(e),m(G.$$.fragment,e),de=a(e),m(H.$$.fragment,e),ue=a(e),Q=y(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-1op5j1e"&&(Q.innerHTML=_e),Me=a(e),x=y(e,"UL",{"data-svelte-h":!0}),b(x)!=="svelte-1f07ihj"&&(x.innerHTML=$e),ye=a(e),m(Y.$$.fragment,e),fe=a(e),F=y(e,"UL",{"data-svelte-h":!0}),b(F)!=="svelte-676unf"&&(F.innerHTML=Ve),be=a(e),m(E.$$.fragment,e),he=a(e),m(L.$$.fragment,e),Te=a(e),m(q.$$.fragment,e),Je=a(e),m(W.$$.fragment,e),we=a(e),P=y(e,"P",{}),Se(P).forEach(t),this.h()},h(){Xe(r,"name","hf:doc:metadata"),Xe(r,"content",Fe)},m(e,n){He(document.head,r),s(e,Z,n),s(e,T,n),s(e,h,n),c(J,e,n),s(e,w,n),c(f,e,n),s(e,g,n),s(e,o,n),s(e,K,n),s(e,I,n),s(e,O,n),c(B,e,n),s(e,ee,n),s(e,_,n),s(e,ne,n),c($,e,n),s(e,te,n),s(e,V,n),s(e,se,n),c(C,e,n),s(e,le,n),s(e,S,n),s(e,ae,n),c(X,e,n),s(e,oe,n),c(k,e,n),s(e,re,n),s(e,v,n),s(e,ie,n),c(z,e,n),s(e,me,n),c(N,e,n),s(e,ce,n),s(e,R,n),s(e,pe,n),c(G,e,n),s(e,de,n),c(H,e,n),s(e,ue,n),s(e,Q,n),s(e,Me,n),s(e,x,n),s(e,ye,n),c(Y,e,n),s(e,fe,n),s(e,F,n),s(e,be,n),c(E,e,n),s(e,he,n),c(L,e,n),s(e,Te,n),c(q,e,n),s(e,Je,n),c(W,e,n),s(e,we,n),s(e,P,n),Ue=!0},p(e,[n]){const Ce={};n&2&&(Ce.$$scope={dirty:n,ctx:e}),W.$set(Ce)},i(e){Ue||(p(J.$$.fragment,e),p(f.$$.fragment,e),p(B.$$.fragment,e),p($.$$.fragment,e),p(C.$$.fragment,e),p(X.$$.fragment,e),p(k.$$.fragment,e),p(z.$$.fragment,e),p(N.$$.fragment,e),p(G.$$.fragment,e),p(H.$$.fragment,e),p(Y.$$.fragment,e),p(E.$$.fragment,e),p(L.$$.fragment,e),p(q.$$.fragment,e),p(W.$$.fragment,e),Ue=!0)},o(e){d(J.$$.fragment,e),d(f.$$.fragment,e),d(B.$$.fragment,e),d($.$$.fragment,e),d(C.$$.fragment,e),d(X.$$.fragment,e),d(k.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(G.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(E.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(W.$$.fragment,e),Ue=!1},d(e){e&&(t(Z),t(T),t(h),t(w),t(g),t(o),t(K),t(I),t(O),t(ee),t(_),t(ne),t(te),t(V),t(se),t(le),t(S),t(ae),t(oe),t(re),t(v),t(ie),t(me),t(ce),t(R),t(pe),t(de),t(ue),t(Q),t(Me),t(x),t(ye),t(fe),t(F),t(be),t(he),t(Te),t(Je),t(we),t(P)),t(r),u(J,e),u(f,e),u(B,e),u($,e),u(C,e),u(X,e),u(k,e),u(z,e),u(N,e),u(G,e),u(H,e),u(Y,e),u(E,e),u(L,e),u(q,e),u(W,e)}}}const Fe='{"title":"Sentence Transformers on AWS Inferentia with Optimum Neuron","local":"sentence-transformers-on-aws-inferentia-with-optimum-neuron","sections":[{"title":"Text Models","local":"text-models","sections":[{"title":"Convert Sentence Transformers model to AWS Inferentia2","local":"convert-sentence-transformers-model-to-aws-inferentia2","sections":[],"depth":3},{"title":"Load compiled Sentence Transformers model and run inference","local":"load-compiled-sentence-transformers-model-and-run-inference","sections":[],"depth":3},{"title":"Production Usage","local":"production-usage","sections":[],"depth":3}],"depth":2},{"title":"CLIP","local":"clip","sections":[{"title":"Compile CLIP for AWS Inferentia2","local":"compile-clip-for-aws-inferentia2","sections":[],"depth":3},{"title":"Load compiled Sentence Transformers model and run inference","local":"load-compiled-sentence-transformers-model-and-run-inference","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ee(D){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Ne{constructor(r){super(),Re(this,r,Ee,Ye,ke,{})}}export{Ke as component};
