import{s as en,o as tn,n as yt}from"../chunks/scheduler.8c3d61f6.js";import{S as nn,i as sn,g as r,s as l,r as m,A as ln,h as p,f as n,c as o,j as Z,u as d,x as b,k as I,y as c,a as s,v as M,d as h,t as u,w as f,m as $t,n as At}from"../chunks/index.da70eac4.js";import{T as Xe}from"../chunks/Tip.1d9b8c37.js";import{D as Q}from"../chunks/Docstring.6b390b9a.js";import{C as Ue}from"../chunks/CodeBlock.00a903b3.js";import{E as on}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as G,E as an}from"../chunks/EditOnGithub.1e64e623.js";function rn(T){let a,i="Only a research preview of the model weights is available at the moment.";return{c(){a=r("p"),a.textContent=i},l(y){a=p(y,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fweliv"&&(a.textContent=i)},m(y,g){s(y,a,g)},p:yt,d(y){y&&n(a)}}}function pn(T){let a,i='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=r("p"),a.innerHTML=i},l(y){a=p(y,"P",{"data-svelte-h":!0}),b(a)!=="svelte-o0z228"&&(a.innerHTML=i)},m(y,g){s(y,a,g)},p:yt,d(y){y&&n(a)}}}function cn(T){let a,i,y="When enabling <code>force_zeros_for_empty_prompt</code>, it is recommended to run the text encoding step outside the autocast context in full precision.";return{c(){a=$t(`The original Mochi implementation zeros out empty prompts. However, enabling this option and placing the entire pipeline under autocast can lead to numerical overflows with the T5 text encoder.
`),i=r("p"),i.innerHTML=y},l(g){a=At(g,`The original Mochi implementation zeros out empty prompts. However, enabling this option and placing the entire pipeline under autocast can lead to numerical overflows with the T5 text encoder.
`),i=p(g,"P",{"data-svelte-h":!0}),b(i)!=="svelte-16wuz5"&&(i.innerHTML=y)},m(g,J){s(g,a,J),s(g,i,J)},p:yt,d(g){g&&(n(a),n(i))}}}function mn(T){let a;return{c(){a=$t("Decoding the latents in full precision is very memory intensive. You will need at least 70GB VRAM to generate the 163 frames in this example. To reduce memory, either reduce the number of frames or run the decoding step in `torch.bfloat16`.")},l(i){a=At(i,"Decoding the latents in full precision is very memory intensive. You will need at least 70GB VRAM to generate the 163 frames in this example. To reduce memory, either reduce the number of frames or run the decoding step in `torch.bfloat16`.")},m(i,y){s(i,a,y)},d(i){i&&n(a)}}}function dn(T){let a;return{c(){a=$t("Diffusers currently doesn't support using the FP8 scaled versions of the Mochi single file checkpoints.")},l(i){a=At(i,"Diffusers currently doesn't support using the FP8 scaled versions of the Mochi single file checkpoints.")},m(i,y){s(i,a,y)},d(i){i&&n(a)}}}function Mn(T){let a,i="Examples:",y,g,J;return g=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQWZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8oZnJhbWVzJTJDJTIwJTIybW9jaGkubXA0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_vae_tiling()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = pipe(prompt, num_inference_steps=<span class="hljs-number">28</span>, guidance_scale=<span class="hljs-number">3.5</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>)`,wrap:!1}}),{c(){a=r("p"),a.textContent=i,y=l(),m(g.$$.fragment)},l(j){a=p(j,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=i),y=o(j),d(g.$$.fragment,j)},m(j,U){s(j,a,U),s(j,y,U),M(g,j,U),J=!0},p:yt,i(j){J||(h(g.$$.fragment,j),J=!0)},o(j){u(g.$$.fragment,j),J=!1},d(j){j&&(n(a),n(y)),f(g,j)}}}function hn(T){let a,i,y,g,J,j,U,Ee,Y,Xt='<a href="https://huggingface.co/genmo/mochi-1-preview" rel="nofollow">Mochi 1</a> is a video generation model by Genmo with a strong focus on prompt adherence and motion quality. The model features a 10B parameter Asmmetric Diffusion Transformer (AsymmDiT) architecture, and uses non-square QKV and output projection layers to reduce inference memory requirements. A single T5-XXL model is used to encode prompts.',Ve,z,Et="<em>Mochi 1 preview is an open state-of-the-art video generation model with high-fidelity motion and strong prompt adherence in preliminary evaluation. This model dramatically closes the gap between closed and open video generation systems. The model is released under a permissive Apache 2.0 license.</em>",Re,k,xe,F,Ne,H,Vt="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Qe,S,Rt='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/pr_10011/en/api/pipelines/mochi#diffusers.MochiPipeline">MochiPipeline</a> for inference with bitsandbytes.',Ye,q,ze,P,Fe,L,xt="The following example will download the full precision <code>mochi-1-preview</code> weights and produce the highest quality results but will require at least 42GB VRAM to run.",He,D,Se,K,qe,O,Nt="The following example will use the <code>bfloat16</code> variant of the model and requires 22GB VRAM to run. There is a slight drop in the quality of the generated video as a result.",Pe,ee,Le,te,De,ne,Qt='The <a href="https://github.com/genmoai/mochi/tree/main" rel="nofollow">Genmo Mochi implementation</a> uses different precision values for each stage in the inference process. The text encoder and VAE use <code>torch.float32</code>, while the DiT uses <code>torch.bfloat16</code> with the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html#torch.nn.attention.sdpa_kernel" rel="nofollow">attention kernel</a> set to <code>EFFICIENT_ATTENTION</code>. Diffusers pipelines currently do not support setting different <code>dtypes</code> for different stages of the pipeline. In order to run inference in the same way as the the original implementation, please refer to the following example.',Ke,B,Oe,$,et,se,tt,le,nt,oe,Yt="It is possible to split the large Mochi transformer across multiple GPUs using the <code>device_map</code> and <code>max_memory</code> options in <code>from_pretrained</code>. In the following example we split the model across two GPUs, each with 24GB of VRAM.",st,ae,lt,ie,ot,re,zt="You can use <code>from_single_file</code> to load the Mochi transformer in its original format.",at,A,it,pe,rt,ce,pt,w,me,gt,ve,Ft="The mochi pipeline for text-to-video generation.",wt,Ze,Ht='Reference: <a href="https://github.com/genmoai/models" rel="nofollow">https://github.com/genmoai/models</a>',bt,v,de,_t,Ie,St="Function invoked when calling the pipeline for generation.",jt,X,Jt,E,Me,Tt,Ce,qt=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ut,V,he,vt,We,Pt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Zt,R,ue,It,Ge,Lt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ct,x,fe,Wt,ke,Dt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Gt,N,ye,kt,Be,Kt="Encodes the prompt into text encoder hidden states.",ct,ge,mt,C,we,Bt,$e,Ot="Output class for Mochi pipelines.",dt,be,Mt,Ae,ht;return J=new G({props:{title:"Mochi 1 Preview",local:"mochi-1-preview",headingTag:"h1"}}),U=new Xe({props:{warning:!1,$$slots:{default:[rn]},$$scope:{ctx:T}}}),k=new Xe({props:{warning:!1,$$slots:{default:[pn]},$$scope:{ctx:T}}}),F=new G({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),q=new Ue({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, MochiTransformer3DModel, MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = MochiTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = MochiPipeline.from_pretrained(
    <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

video = pipeline(
  <span class="hljs-string">&quot;Close-up of a cats eye, with the galaxy reflected in the cats eye. Ultra high resolution 4k.&quot;</span>,
  num_inference_steps=<span class="hljs-number">28</span>,
  guidance_scale=<span class="hljs-number">3.5</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;cat.mp4&quot;</span>)`,wrap:!1}}),P=new G({props:{title:"Generating videos with Mochi-1 Preview",local:"generating-videos-with-mochi-1-preview",headingTag:"h2"}}),D=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIpJTBBJTBBJTIzJTIwRW5hYmxlJTIwbWVtb3J5JTIwc2F2aW5ncyUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQSUwQXdpdGglMjB0b3JjaC5hdXRvY2FzdCglMjJjdWRhJTIyJTJDJTIwdG9yY2guYmZsb2F0MTYlMkMlMjBjYWNoZV9lbmFibGVkJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNEODUpLmZyYW1lcyU1QjAlNUQlMEElMEFleHBvcnRfdG9fdmlkZW8oZnJhbWVzJTJDJTIwJTIybW9jaGkubXA0JTIyJTJDJTIwZnBzJTNEMzAp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>)

<span class="hljs-comment"># Enable memory savings</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>

<span class="hljs-keyword">with</span> torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
      frames = pipe(prompt, num_frames=<span class="hljs-number">85</span>).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),K=new G({props:{title:"Using a lower precision variant to save memory",local:"using-a-lower-precision-variant-to-save-memory",headingTag:"h2"}}),ee=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIlMkMlMjB2YXJpYW50JTNEJTIyYmYxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBJTBBJTIzJTIwRW5hYmxlJTIwbWVtb3J5JTIwc2F2aW5ncyUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQWZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDg1KS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMm1vY2hpLm1wNCUyMiUyQyUyMGZwcyUzRDMwKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, variant=<span class="hljs-string">&quot;bf16&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-comment"># Enable memory savings</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>
frames = pipe(prompt, num_frames=<span class="hljs-number">85</span>).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),te=new G({props:{title:"Reproducing the results from the Genmo Mochi repo",local:"reproducing-the-results-from-the-genmo-mochi-repo",headingTag:"h2"}}),B=new Xe({props:{$$slots:{default:[cn]},$$scope:{ctx:T}}}),$=new Xe({props:{$$slots:{default:[mn]},$$scope:{ctx:T}}}),se=new Ue({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers.video_processor <span class="hljs-keyword">import</span> VideoProcessor

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, force_zeros_for_empty_prompt=<span class="hljs-literal">True</span>)
pipe.enable_vae_tiling()
pipe.enable_model_cpu_offload()

prompt =  <span class="hljs-string">&quot;An aerial shot of a parade of elephants walking across the African savannah. The camera showcases the herd and the surrounding landscape.&quot;</span>

<span class="hljs-keyword">with</span> torch.no_grad():
    prompt_embeds, prompt_attention_mask, negative_prompt_embeds, negative_prompt_attention_mask = (
        pipe.encode_prompt(prompt=prompt)
    )

<span class="hljs-keyword">with</span> torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16):
    <span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.EFFICIENT_ATTENTION):
        frames = pipe(
            prompt_embeds=prompt_embeds,
            prompt_attention_mask=prompt_attention_mask,
            negative_prompt_embeds=negative_prompt_embeds,
            negative_prompt_attention_mask=negative_prompt_attention_mask,
            guidance_scale=<span class="hljs-number">4.5</span>,
            num_inference_steps=<span class="hljs-number">64</span>,
            height=<span class="hljs-number">480</span>,
            width=<span class="hljs-number">848</span>,
            num_frames=<span class="hljs-number">163</span>,
            generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
            output_type=<span class="hljs-string">&quot;latent&quot;</span>,
            return_dict=<span class="hljs-literal">False</span>,
        )[<span class="hljs-number">0</span>]

video_processor = VideoProcessor(vae_scale_factor=<span class="hljs-number">8</span>)
has_latents_mean = <span class="hljs-built_in">hasattr</span>(pipe.vae.config, <span class="hljs-string">&quot;latents_mean&quot;</span>) <span class="hljs-keyword">and</span> pipe.vae.config.latents_mean <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>
has_latents_std = <span class="hljs-built_in">hasattr</span>(pipe.vae.config, <span class="hljs-string">&quot;latents_std&quot;</span>) <span class="hljs-keyword">and</span> pipe.vae.config.latents_std <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> has_latents_mean <span class="hljs-keyword">and</span> has_latents_std:
    latents_mean = (
        torch.tensor(pipe.vae.config.latents_mean).view(<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>).to(frames.device, frames.dtype)
    )
    latents_std = (
        torch.tensor(pipe.vae.config.latents_std).view(<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>).to(frames.device, frames.dtype)
    )
    frames = frames * latents_std / pipe.vae.config.scaling_factor + latents_mean
<span class="hljs-keyword">else</span>:
    frames = frames / pipe.vae.config.scaling_factor

<span class="hljs-keyword">with</span> torch.no_grad():
    video = pipe.vae.decode(frames.to(pipe.vae.dtype), return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]

video = video_processor.postprocess_video(video)[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),le=new G({props:{title:"Running inference with multiple GPUs",local:"running-inference-with-multiple-gpus",headingTag:"h2"}}),ae=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUyQyUyME1vY2hpVHJhbnNmb3JtZXIzRE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b192aWRlbyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIlMEF0cmFuc2Zvcm1lciUyMCUzRCUyME1vY2hpVHJhbnNmb3JtZXIzRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbWVtb3J5JTNEJTdCMCUzQSUyMCUyMjI0R0IlMjIlMkMlMjAxJTNBJTIwJTIyMjRHQiUyMiU3RCUwQSklMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjAlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMEF3aXRoJTIwdG9yY2guYXV0b2Nhc3QoZGV2aWNlX3R5cGUlM0QlMjJjdWRhJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGNhY2hlX2VuYWJsZWQlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjBmcmFtZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkNsb3NlLXVwJTIwb2YlMjBhJTIwY2hhbWVsZW9uJ3MlMjBleWUlMkMlMjB3aXRoJTIwaXRzJTIwc2NhbHklMjBza2luJTIwY2hhbmdpbmclMjBjb2xvci4lMjBVbHRyYSUyMGhpZ2glMjByZXNvbHV0aW9uJTIwNGsuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGVpZ2h0JTNENDgwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q4NDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEODUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDQuNSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV92aWRlb3NfcGVyX3Byb21wdCUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNEMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIlMkMlMEElMjAlMjAlMjAlMjApLmZyYW1lcyU1QjAlNUQlMEElMEFleHBvcnRfdG9fdmlkZW8oZnJhbWVzJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDMwKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline, MochiTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>
transformer = MochiTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;24GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;24GB&quot;</span>}
)

pipe = MochiPipeline.from_pretrained(model_id,  transformer=transformer)
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

<span class="hljs-keyword">with</span> torch.autocast(device_type=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
    frames = pipe(
        prompt=<span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>,
        negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
        height=<span class="hljs-number">480</span>,
        width=<span class="hljs-number">848</span>,
        num_frames=<span class="hljs-number">85</span>,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">4.5</span>,
        num_videos_per_prompt=<span class="hljs-number">1</span>,
        generator=torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
        max_sequence_length=<span class="hljs-number">256</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    ).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),ie=new G({props:{title:"Using single file loading with the Mochi Transformer",local:"using-single-file-loading-with-the-mochi-transformer",headingTag:"h2"}}),A=new Xe({props:{$$slots:{default:[dn]},$$scope:{ctx:T}}}),pe=new Ue({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline, MochiTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/Comfy-Org/mochi_preview_repackaged/blob/main/split_files/diffusion_models/mochi_preview_bf16.safetensors&quot;</span>

transformer = MochiTransformer3DModel.from_pretrained(ckpt_path, torch_dtype=torch.bfloat16)

pipe = MochiPipeline.from_pretrained(model_id,  transformer=transformer)
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

<span class="hljs-keyword">with</span> torch.autocast(device_type=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
    frames = pipe(
        prompt=<span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>,
        negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
        height=<span class="hljs-number">480</span>,
        width=<span class="hljs-number">848</span>,
        num_frames=<span class="hljs-number">85</span>,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">4.5</span>,
        num_videos_per_prompt=<span class="hljs-number">1</span>,
        generator=torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
        max_sequence_length=<span class="hljs-number">256</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    ).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),ce=new G({props:{title:"MochiPipeline",local:"diffusers.MochiPipeline",headingTag:"h2"}}),me=new Q({props:{name:"class diffusers.MochiPipeline",anchor:"diffusers.MochiPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": MochiTransformer3DModel"},{name:"force_zeros_for_empty_prompt",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10011/en/api/models/mochi_transformer3d#diffusers.MochiTransformer3DModel">MochiTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.MochiPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10011/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.MochiPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10011/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.MochiPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.MochiPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.MochiPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/mochi/pipeline_mochi.py#L156"}}),de=new Q({props:{name:"__call__",anchor:"diffusers.MochiPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 19"},{name:"num_inference_steps",val:": int = 64"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.MochiPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.default_height</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.MochiPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.default_width</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.MochiPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>19</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.MochiPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.MochiPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.MochiPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>4.5</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.MochiPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.MochiPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.MochiPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.MochiPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MochiPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.MochiPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MochiPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.MochiPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.MochiPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.mochi.MochiPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.MochiPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.MochiPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.MochiPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.MochiPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>256</code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/mochi/pipeline_mochi.py#L487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.mochi.MochiPipelineOutput</code> is returned, otherwise a <code>tuple</code>
is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.mochi.MochiPipelineOutput</code> or <code>tuple</code></p>
`}}),X=new on({props:{anchor:"diffusers.MochiPipeline.__call__.example",$$slots:{default:[Mn]},$$scope:{ctx:T}}}),Me=new Q({props:{name:"disable_vae_slicing",anchor:"diffusers.MochiPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/mochi/pipeline_mochi.py#L415"}}),he=new Q({props:{name:"disable_vae_tiling",anchor:"diffusers.MochiPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/mochi/pipeline_mochi.py#L430"}}),ue=new Q({props:{name:"enable_vae_slicing",anchor:"diffusers.MochiPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/mochi/pipeline_mochi.py#L408"}}),fe=new Q({props:{name:"enable_vae_tiling",anchor:"diffusers.MochiPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/mochi/pipeline_mochi.py#L422"}}),ye=new Q({props:{name:"encode_prompt",anchor:"diffusers.MochiPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.MochiPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MochiPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MochiPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.MochiPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/mochi/pipeline_mochi.py#L272"}}),ge=new G({props:{title:"MochiPipelineOutput",local:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",headingTag:"h2"}}),we=new Q({props:{name:"class diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",anchor:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/vr_10011/src/diffusers/pipelines/mochi/pipeline_output.py#L8"}}),be=new an({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/mochi.md"}}),{c(){a=r("meta"),i=l(),y=r("p"),g=l(),m(J.$$.fragment),j=l(),m(U.$$.fragment),Ee=l(),Y=r("p"),Y.innerHTML=Xt,Ve=l(),z=r("p"),z.innerHTML=Et,Re=l(),m(k.$$.fragment),xe=l(),m(F.$$.fragment),Ne=l(),H=r("p"),H.textContent=Vt,Qe=l(),S=r("p"),S.innerHTML=Rt,Ye=l(),m(q.$$.fragment),ze=l(),m(P.$$.fragment),Fe=l(),L=r("p"),L.innerHTML=xt,He=l(),m(D.$$.fragment),Se=l(),m(K.$$.fragment),qe=l(),O=r("p"),O.innerHTML=Nt,Pe=l(),m(ee.$$.fragment),Le=l(),m(te.$$.fragment),De=l(),ne=r("p"),ne.innerHTML=Qt,Ke=l(),m(B.$$.fragment),Oe=l(),m($.$$.fragment),et=l(),m(se.$$.fragment),tt=l(),m(le.$$.fragment),nt=l(),oe=r("p"),oe.innerHTML=Yt,st=l(),m(ae.$$.fragment),lt=l(),m(ie.$$.fragment),ot=l(),re=r("p"),re.innerHTML=zt,at=l(),m(A.$$.fragment),it=l(),m(pe.$$.fragment),rt=l(),m(ce.$$.fragment),pt=l(),w=r("div"),m(me.$$.fragment),gt=l(),ve=r("p"),ve.textContent=Ft,wt=l(),Ze=r("p"),Ze.innerHTML=Ht,bt=l(),v=r("div"),m(de.$$.fragment),_t=l(),Ie=r("p"),Ie.textContent=St,jt=l(),m(X.$$.fragment),Jt=l(),E=r("div"),m(Me.$$.fragment),Tt=l(),Ce=r("p"),Ce.innerHTML=qt,Ut=l(),V=r("div"),m(he.$$.fragment),vt=l(),We=r("p"),We.innerHTML=Pt,Zt=l(),R=r("div"),m(ue.$$.fragment),It=l(),Ge=r("p"),Ge.textContent=Lt,Ct=l(),x=r("div"),m(fe.$$.fragment),Wt=l(),ke=r("p"),ke.textContent=Dt,Gt=l(),N=r("div"),m(ye.$$.fragment),kt=l(),Be=r("p"),Be.textContent=Kt,ct=l(),m(ge.$$.fragment),mt=l(),C=r("div"),m(we.$$.fragment),Bt=l(),$e=r("p"),$e.textContent=Ot,dt=l(),m(be.$$.fragment),Mt=l(),Ae=r("p"),this.h()},l(e){const t=ln("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(n),i=o(e),y=p(e,"P",{}),Z(y).forEach(n),g=o(e),d(J.$$.fragment,e),j=o(e),d(U.$$.fragment,e),Ee=o(e),Y=p(e,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-19k93hq"&&(Y.innerHTML=Xt),Ve=o(e),z=p(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-16aanyn"&&(z.innerHTML=Et),Re=o(e),d(k.$$.fragment,e),xe=o(e),d(F.$$.fragment,e),Ne=o(e),H=p(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1ou2pxc"&&(H.textContent=Vt),Qe=o(e),S=p(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-zovocr"&&(S.innerHTML=Rt),Ye=o(e),d(q.$$.fragment,e),ze=o(e),d(P.$$.fragment,e),Fe=o(e),L=p(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-w0d3wt"&&(L.innerHTML=xt),He=o(e),d(D.$$.fragment,e),Se=o(e),d(K.$$.fragment,e),qe=o(e),O=p(e,"P",{"data-svelte-h":!0}),b(O)!=="svelte-gdmfoq"&&(O.innerHTML=Nt),Pe=o(e),d(ee.$$.fragment,e),Le=o(e),d(te.$$.fragment,e),De=o(e),ne=p(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-qbredq"&&(ne.innerHTML=Qt),Ke=o(e),d(B.$$.fragment,e),Oe=o(e),d($.$$.fragment,e),et=o(e),d(se.$$.fragment,e),tt=o(e),d(le.$$.fragment,e),nt=o(e),oe=p(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-14s0l4"&&(oe.innerHTML=Yt),st=o(e),d(ae.$$.fragment,e),lt=o(e),d(ie.$$.fragment,e),ot=o(e),re=p(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-14rhs7p"&&(re.innerHTML=zt),at=o(e),d(A.$$.fragment,e),it=o(e),d(pe.$$.fragment,e),rt=o(e),d(ce.$$.fragment,e),pt=o(e),w=p(e,"DIV",{class:!0});var _=Z(w);d(me.$$.fragment,_),gt=o(_),ve=p(_,"P",{"data-svelte-h":!0}),b(ve)!=="svelte-11luvqp"&&(ve.textContent=Ft),wt=o(_),Ze=p(_,"P",{"data-svelte-h":!0}),b(Ze)!=="svelte-1br2zew"&&(Ze.innerHTML=Ht),bt=o(_),v=p(_,"DIV",{class:!0});var W=Z(v);d(de.$$.fragment,W),_t=o(W),Ie=p(W,"P",{"data-svelte-h":!0}),b(Ie)!=="svelte-v78lg8"&&(Ie.textContent=St),jt=o(W),d(X.$$.fragment,W),W.forEach(n),Jt=o(_),E=p(_,"DIV",{class:!0});var _e=Z(E);d(Me.$$.fragment,_e),Tt=o(_e),Ce=p(_e,"P",{"data-svelte-h":!0}),b(Ce)!=="svelte-1s3c06i"&&(Ce.innerHTML=qt),_e.forEach(n),Ut=o(_),V=p(_,"DIV",{class:!0});var je=Z(V);d(he.$$.fragment,je),vt=o(je),We=p(je,"P",{"data-svelte-h":!0}),b(We)!=="svelte-pkn4ui"&&(We.innerHTML=Pt),je.forEach(n),Zt=o(_),R=p(_,"DIV",{class:!0});var Je=Z(R);d(ue.$$.fragment,Je),It=o(Je),Ge=p(Je,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-14bnrb6"&&(Ge.textContent=Lt),Je.forEach(n),Ct=o(_),x=p(_,"DIV",{class:!0});var Te=Z(x);d(fe.$$.fragment,Te),Wt=o(Te),ke=p(Te,"P",{"data-svelte-h":!0}),b(ke)!=="svelte-1xwrf7t"&&(ke.textContent=Dt),Te.forEach(n),Gt=o(_),N=p(_,"DIV",{class:!0});var ut=Z(N);d(ye.$$.fragment,ut),kt=o(ut),Be=p(ut,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-16q0ax1"&&(Be.textContent=Kt),ut.forEach(n),_.forEach(n),ct=o(e),d(ge.$$.fragment,e),mt=o(e),C=p(e,"DIV",{class:!0});var ft=Z(C);d(we.$$.fragment,ft),Bt=o(ft),$e=p(ft,"P",{"data-svelte-h":!0}),b($e)!=="svelte-srx61f"&&($e.textContent=Ot),ft.forEach(n),dt=o(e),d(be.$$.fragment,e),Mt=o(e),Ae=p(e,"P",{}),Z(Ae).forEach(n),this.h()},h(){I(a,"name","hf:doc:metadata"),I(a,"content",un),I(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,a),s(e,i,t),s(e,y,t),s(e,g,t),M(J,e,t),s(e,j,t),M(U,e,t),s(e,Ee,t),s(e,Y,t),s(e,Ve,t),s(e,z,t),s(e,Re,t),M(k,e,t),s(e,xe,t),M(F,e,t),s(e,Ne,t),s(e,H,t),s(e,Qe,t),s(e,S,t),s(e,Ye,t),M(q,e,t),s(e,ze,t),M(P,e,t),s(e,Fe,t),s(e,L,t),s(e,He,t),M(D,e,t),s(e,Se,t),M(K,e,t),s(e,qe,t),s(e,O,t),s(e,Pe,t),M(ee,e,t),s(e,Le,t),M(te,e,t),s(e,De,t),s(e,ne,t),s(e,Ke,t),M(B,e,t),s(e,Oe,t),M($,e,t),s(e,et,t),M(se,e,t),s(e,tt,t),M(le,e,t),s(e,nt,t),s(e,oe,t),s(e,st,t),M(ae,e,t),s(e,lt,t),M(ie,e,t),s(e,ot,t),s(e,re,t),s(e,at,t),M(A,e,t),s(e,it,t),M(pe,e,t),s(e,rt,t),M(ce,e,t),s(e,pt,t),s(e,w,t),M(me,w,null),c(w,gt),c(w,ve),c(w,wt),c(w,Ze),c(w,bt),c(w,v),M(de,v,null),c(v,_t),c(v,Ie),c(v,jt),M(X,v,null),c(w,Jt),c(w,E),M(Me,E,null),c(E,Tt),c(E,Ce),c(w,Ut),c(w,V),M(he,V,null),c(V,vt),c(V,We),c(w,Zt),c(w,R),M(ue,R,null),c(R,It),c(R,Ge),c(w,Ct),c(w,x),M(fe,x,null),c(x,Wt),c(x,ke),c(w,Gt),c(w,N),M(ye,N,null),c(N,kt),c(N,Be),s(e,ct,t),M(ge,e,t),s(e,mt,t),s(e,C,t),M(we,C,null),c(C,Bt),c(C,$e),s(e,dt,t),M(be,e,t),s(e,Mt,t),s(e,Ae,t),ht=!0},p(e,[t]){const _={};t&2&&(_.$$scope={dirty:t,ctx:e}),U.$set(_);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),k.$set(W);const _e={};t&2&&(_e.$$scope={dirty:t,ctx:e}),B.$set(_e);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),$.$set(je);const Je={};t&2&&(Je.$$scope={dirty:t,ctx:e}),A.$set(Je);const Te={};t&2&&(Te.$$scope={dirty:t,ctx:e}),X.$set(Te)},i(e){ht||(h(J.$$.fragment,e),h(U.$$.fragment,e),h(k.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(B.$$.fragment,e),h($.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(A.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(de.$$.fragment,e),h(X.$$.fragment,e),h(Me.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(ye.$$.fragment,e),h(ge.$$.fragment,e),h(we.$$.fragment,e),h(be.$$.fragment,e),ht=!0)},o(e){u(J.$$.fragment,e),u(U.$$.fragment,e),u(k.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(B.$$.fragment,e),u($.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(A.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(X.$$.fragment,e),u(Me.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),ht=!1},d(e){e&&(n(i),n(y),n(g),n(j),n(Ee),n(Y),n(Ve),n(z),n(Re),n(xe),n(Ne),n(H),n(Qe),n(S),n(Ye),n(ze),n(Fe),n(L),n(He),n(Se),n(qe),n(O),n(Pe),n(Le),n(De),n(ne),n(Ke),n(Oe),n(et),n(tt),n(nt),n(oe),n(st),n(lt),n(ot),n(re),n(at),n(it),n(rt),n(pt),n(w),n(ct),n(mt),n(C),n(dt),n(Mt),n(Ae)),n(a),f(J,e),f(U,e),f(k,e),f(F,e),f(q,e),f(P,e),f(D,e),f(K,e),f(ee,e),f(te,e),f(B,e),f($,e),f(se,e),f(le,e),f(ae,e),f(ie,e),f(A,e),f(pe,e),f(ce,e),f(me),f(de),f(X),f(Me),f(he),f(ue),f(fe),f(ye),f(ge,e),f(we),f(be,e)}}}const un='{"title":"Mochi 1 Preview","local":"mochi-1-preview","sections":[{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"Generating videos with Mochi-1 Preview","local":"generating-videos-with-mochi-1-preview","sections":[],"depth":2},{"title":"Using a lower precision variant to save memory","local":"using-a-lower-precision-variant-to-save-memory","sections":[],"depth":2},{"title":"Reproducing the results from the Genmo Mochi repo","local":"reproducing-the-results-from-the-genmo-mochi-repo","sections":[],"depth":2},{"title":"Running inference with multiple GPUs","local":"running-inference-with-multiple-gpus","sections":[],"depth":2},{"title":"Using single file loading with the Mochi Transformer","local":"using-single-file-loading-with-the-mochi-transformer","sections":[],"depth":2},{"title":"MochiPipeline","local":"diffusers.MochiPipeline","sections":[],"depth":2},{"title":"MochiPipelineOutput","local":"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput","sections":[],"depth":2}],"depth":1}';function fn(T){return tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tn extends nn{constructor(a){super(),sn(this,a,fn,hn,en,{})}}export{Tn as component};
