import{s as Ce,o as me,n as ue}from"../chunks/scheduler.f6319a2a.js";import{S as he,i as be,g as a,s as n,r as p,A as Je,h as y,f as t,c as M,j as we,u as U,x as o,k as de,y as Te,a as s,v as r,d as j,t as c,w}from"../chunks/index.85aa684c.js";import{T as ge}from"../chunks/Tip.3d397a88.js";import{C}from"../chunks/CodeBlock.3400fc53.js";import{D as fe}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as Yl,E as Ae}from"../chunks/getInferenceSnippets.01396882.js";function Ie(Ml){let i,u='Inference Providers give access to hundreds of models, powered by serverless inference partners. A list of supported providers can be found <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">here</a>.';return{c(){i=a("p"),i.innerHTML=u},l(d){i=y(d,"P",{"data-svelte-h":!0}),o(i)!=="svelte-k0ft1t"&&(i.innerHTML=u)},m(d,sl){s(d,i,sl)},p:ue,d(d){d&&t(i)}}}function Be(Ml){let i,u,d,sl,h,al,b,yl,J,Ll="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",ol,T,zl="It will be a simple hierarchy:",il,g,pl,f,Fl="Let’s set up this system.",Ul,A,ql="Run the line below to install the required dependencies:",rl,I,jl,B,Pl="Let’s login to HF in order to call Inference Providers:",cl,k,wl,Z,Dl='⚡️ Our agent will be powered by <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a> using <code>InferenceClientModel</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',dl,m,Cl,G,ml,v,ul,W,Kl='For web browsing, we can already use our native <a href="/docs/smolagents/pr_1442/en/reference/tools#smolagents.WebSearchTool">WebSearchTool</a> tool to provide a Google search equivalent.',hl,$,Ol=`But then we will also need to be able to peak into the page found by the <code>WebSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,bl,S,le="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",Jl,V,Tl,E,ee="Ok, now let’s initialize and test our tool!",gl,_,fl,Q,Al,H,te="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Il,x,se="Which configuration to choose for this agent?",Bl,R,ne="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>ToolCallingAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_steps</code> to 10.</li>",kl,X,Zl,N,Me="Note that we gave this agent attributes <code>name</code> and <code>description</code>, mandatory attributes to make this agent callable by its manager agent.",Gl,Y,ae="Then we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",vl,L,ye="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>CodeAgent</code> will work well.",Wl,z,oe="Also, we want to ask a question that involves the current year and does additional data calculations: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;numpy&quot;, &quot;pandas&quot;]</code>, just in case the agent needs these packages.",$l,F,Sl,q,ie="That’s all! Now let’s run our system! We select a question that requires both some calculation and research:",Vl,P,El,D,pe="We get this report as the answer:",_l,K,Ql,O,Ue='Seems like we’ll need some sizeable powerplants if the <a href="https://gwern.net/scaling-hypothesis" rel="nofollow">scaling hypothesis</a> continues to hold true.',Hl,ll,re="Our agents managed to efficiently collaborate towards solving the task! ✅",xl,el,je="💡 You can easily extend this orchestration to more agents: one does the code execution, one the web search, one handles file loadings…",Rl,tl,Xl,nl,Nl;return h=new Yl({props:{title:"Orchestrate a multi-agent system 🤖🤝🤖",local:"orchestrate-a-multi-agent-system-",headingTag:"h1"}}),b=new fe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"}]}}),g=new C({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJCLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyME1hbmFnZXIlMjBhZ2VudCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0lMkIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfX19fX19fX19fX19fX18lN0NfX19fX19fX19fX19fXyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQUNvZGUlMjBJbnRlcnByZXRlciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBXZWIlMjBTZWFyY2glMjBhZ2VudCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFdlYiUyMFNlYXJjaCUyMHRvb2wlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBWaXNpdCUyMHdlYnBhZ2UlMjB0b29s",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
Code Interpreter            +------------------+
    tool                    |<span class="hljs-string"> Web Search agent </span>|
                            +------------------+
                               |<span class="hljs-string">            </span>|
                        Web Search tool     |<span class="hljs-string">
                                   Visit webpage tool</span>`,wrap:!1}}),I=new C({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTVCdG9vbGtpdCU1RCUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install smolagents[toolkit] --upgrade -q",wrap:!1}}),k=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),m=new ge({props:{warning:!1,$$slots:{default:[Ie]},$$scope:{ctx:Ml}}}),G=new C({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjI=",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>',wrap:!1}}),v=new Yl({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h2"}}),V=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = markdownify(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),_=new C({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),Q=new Yl({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),X=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwV2ViU2VhcmNoVG9vbCUyQyUwQSUyMCUyMCUyMCUyMExpdGVMTE1Nb2RlbCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QldlYlNlYXJjaFRvb2woKSUyQyUyMHZpc2l0X3dlYnBhZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyd2ViX3NlYXJjaF9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyUnVucyUyMHdlYiUyMHNlYXJjaGVzJTIwZm9yJTIweW91LiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    InferenceClientModel,
    WebSearchTool,
    LiteLLMModel,
)

model = InferenceClientModel(model_id=model_id)

web_agent = ToolCallingAgent(
    tools=[WebSearchTool(), visit_webpage],
    model=model,
    max_steps=<span class="hljs-number">10</span>,
    name=<span class="hljs-string">&quot;web_search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you.&quot;</span>,
)`,wrap:!1}}),F=new C({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1QndlYl9hZ2VudCU1RCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIydGltZSUyMiUyQyUyMCUyMm51bXB5JTIyJTJDJTIwJTIycGFuZGFzJTIyJTVEJTJDJTBBKQ==",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;numpy&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>],
)`,wrap:!1}}),P=new C({props:{code:"YW5zd2VyJTIwJTNEJTIwbWFuYWdlcl9hZ2VudC5ydW4oJTIySWYlMjBMTE0lMjB0cmFpbmluZyUyMGNvbnRpbnVlcyUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUyQyUyMHdoYXQlMjB3b3VsZCUyMGJlJTIwdGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMGluJTIwR1clMjByZXF1aXJlZCUyMHRvJTIwcG93ZXIlMjB0aGUlMjBiaWdnZXN0JTIwdHJhaW5pbmclMjBydW5zJTIwYnklMjAyMDMwJTNGJTIwV2hhdCUyMHdvdWxkJTIwdGhhdCUyMGNvcnJlc3BvbmQlMjB0byUyQyUyMGNvbXBhcmVkJTIwdG8lMjBzb21lJTIwY291bnRyaWVzJTNGJTIwUGxlYXNlJTIwcHJvdmlkZSUyMGElMjBzb3VyY2UlMjBmb3IlMjBhbnklMjBudW1iZXJzJTIwdXNlZC4lMjIp",highlighted:'answer = manager_agent.run(<span class="hljs-string">&quot;If LLM training continues to scale up at the current rhythm until 2030, what would be the electric power in GW required to power the biggest training runs by 2030? What would that correspond to, compared to some countries? Please provide a source for any numbers used.&quot;</span>)',wrap:!1}}),K=new C({props:{code:"QmFzZWQlMjBvbiUyMGN1cnJlbnQlMjBncm93dGglMjBwcm9qZWN0aW9ucyUyMGFuZCUyMGVuZXJneSUyMGNvbnN1bXB0aW9uJTIwZXN0aW1hdGVzJTJDJTIwaWYlMjBMTE0lMjB0cmFpbmluZ3MlMjBjb250aW51ZSUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwJTBBY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUzQSUwQSUwQTEuJTIwVGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMHJlcXVpcmVkJTIwdG8lMjBwb3dlciUyMHRoZSUyMGJpZ2dlc3QlMjB0cmFpbmluZyUyMHJ1bnMlMjBieSUyMDIwMzAlMjB3b3VsZCUyMGJlJTIwYXBwcm94aW1hdGVseSUyMDMwMy43NCUyMEdXJTJDJTIwd2hpY2glMjAlMEF0cmFuc2xhdGVzJTIwdG8lMjBhYm91dCUyMDIlMkM2NjAlMkM3NjIlMjBHV2glMkZ5ZWFyLiUwQSUwQTIuJTIwQ29tcGFyaW5nJTIwdGhpcyUyMHRvJTIwY291bnRyaWVzJyUyMGVsZWN0cmljaXR5JTIwY29uc3VtcHRpb24lM0ElMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwZXF1aXZhbGVudCUyMHRvJTIwYWJvdXQlMjAzNCUyNSUyMG9mJTIwQ2hpbmEncyUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbi4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGV4Y2VlZCUyMHRoZSUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwSW5kaWElMjAoMTg0JTI1KSUyQyUyMFJ1c3NpYSUyMCgyNjclMjUpJTJDJTIwYW5kJTIwSmFwYW4lMjAoMjkxJTI1KS4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwbmVhcmx5JTIwOSUyMHRpbWVzJTIwdGhlJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwY291bnRyaWVzJTIwbGlrZSUyMEl0YWx5JTIwb3IlMjBNZXhpY28uJTBBJTBBMy4lMjBTb3VyY2UlMjBvZiUyMG51bWJlcnMlM0ElMEElMjAlMjAlMjAtJTIwVGhlJTIwaW5pdGlhbCUyMGVzdGltYXRlJTIwb2YlMjA1JTIwR1clMjBmb3IlMjBmdXR1cmUlMjBMTE0lMjB0cmFpbmluZyUyMGNvbWVzJTIwZnJvbSUyMEFXUyUyMENFTyUyME1hdHQlMjBHYXJtYW4uJTBBJTIwJTIwJTIwLSUyMFRoZSUyMGdyb3d0aCUyMHByb2plY3Rpb24lMjB1c2VkJTIwYSUyMENBR1IlMjBvZiUyMDc5LjgwJTI1JTIwZnJvbSUyMG1hcmtldCUyMHJlc2VhcmNoJTIwYnklMjBTcHJpbmdzLiUwQSUyMCUyMCUyMC0lMjBDb3VudHJ5JTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMGRhdGElMjBpcyUyMGZyb20lMjB0aGUlMjBVLlMuJTIwRW5lcmd5JTIwSW5mb3JtYXRpb24lMjBBZG1pbmlzdHJhdGlvbiUyQyUyMHByaW1hcmlseSUyMGZvciUyMHRoZSUyMHllYXIlMjAlMEEyMDIxLg==",highlighted:`Based <span class="hljs-keyword">on</span> current growth projections <span class="hljs-keyword">and</span> energy consumption estimates, <span class="hljs-keyword">if</span> LLM trainings <span class="hljs-keyword">continue</span> <span class="hljs-keyword">to</span> scale up <span class="hljs-keyword">at</span> <span class="hljs-keyword">the</span> 
current rhythm <span class="hljs-keyword">until</span> <span class="hljs-number">2030</span>:

<span class="hljs-number">1.</span> The electric power required <span class="hljs-keyword">to</span> power <span class="hljs-keyword">the</span> biggest training runs <span class="hljs-keyword">by</span> <span class="hljs-number">2030</span> would be approximately <span class="hljs-number">303.74</span> GW, which 
translates <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">2</span>,<span class="hljs-number">660</span>,<span class="hljs-number">762</span> GWh/<span class="hljs-built_in">year</span>.

<span class="hljs-number">2.</span> Comparing this <span class="hljs-keyword">to</span> countries&#x27; electricity consumption:
   - It would be equivalent <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">34</span>% <span class="hljs-keyword">of</span> China&#x27;s total electricity consumption.
   - It would exceed <span class="hljs-keyword">the</span> total electricity consumption <span class="hljs-keyword">of</span> India (<span class="hljs-number">184</span>%), Russia (<span class="hljs-number">267</span>%), <span class="hljs-keyword">and</span> Japan (<span class="hljs-number">291</span>%).
   - It would be nearly <span class="hljs-number">9</span> <span class="hljs-keyword">times</span> <span class="hljs-keyword">the</span> electricity consumption <span class="hljs-keyword">of</span> countries like Italy <span class="hljs-keyword">or</span> Mexico.

<span class="hljs-number">3.</span> Source <span class="hljs-keyword">of</span> numbers:
   - The initial estimate <span class="hljs-keyword">of</span> <span class="hljs-number">5</span> GW <span class="hljs-keyword">for</span> future LLM training comes <span class="hljs-keyword">from</span> AWS CEO Matt Garman.
   - The growth projection used a CAGR <span class="hljs-keyword">of</span> <span class="hljs-number">79.80</span>% <span class="hljs-keyword">from</span> market research <span class="hljs-keyword">by</span> Springs.
   - Country electricity consumption data <span class="hljs-keyword">is</span> <span class="hljs-keyword">from</span> <span class="hljs-keyword">the</span> U.S. Energy Information Administration, primarily <span class="hljs-keyword">for</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span> 
<span class="hljs-number">2021.</span>`,wrap:!1}}),tl=new Ae({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/multiagents.mdx"}}),{c(){i=a("meta"),u=n(),d=a("p"),sl=n(),p(h.$$.fragment),al=n(),p(b.$$.fragment),yl=n(),J=a("p"),J.innerHTML=Ll,ol=n(),T=a("p"),T.textContent=zl,il=n(),p(g.$$.fragment),pl=n(),f=a("p"),f.textContent=Fl,Ul=n(),A=a("p"),A.textContent=ql,rl=n(),p(I.$$.fragment),jl=n(),B=a("p"),B.textContent=Pl,cl=n(),p(k.$$.fragment),wl=n(),Z=a("p"),Z.innerHTML=Dl,dl=n(),p(m.$$.fragment),Cl=n(),p(G.$$.fragment),ml=n(),p(v.$$.fragment),ul=n(),W=a("p"),W.innerHTML=Kl,hl=n(),$=a("p"),$.innerHTML=Ol,bl=n(),S=a("p"),S.innerHTML=le,Jl=n(),p(V.$$.fragment),Tl=n(),E=a("p"),E.textContent=ee,gl=n(),p(_.$$.fragment),fl=n(),p(Q.$$.fragment),Al=n(),H=a("p"),H.innerHTML=te,Il=n(),x=a("p"),x.textContent=se,Bl=n(),R=a("ul"),R.innerHTML=ne,kl=n(),p(X.$$.fragment),Zl=n(),N=a("p"),N.innerHTML=Me,Gl=n(),Y=a("p"),Y.innerHTML=ae,vl=n(),L=a("p"),L.innerHTML=ye,Wl=n(),z=a("p"),z.innerHTML=oe,$l=n(),p(F.$$.fragment),Sl=n(),q=a("p"),q.textContent=ie,Vl=n(),p(P.$$.fragment),El=n(),D=a("p"),D.textContent=pe,_l=n(),p(K.$$.fragment),Ql=n(),O=a("p"),O.innerHTML=Ue,Hl=n(),ll=a("p"),ll.textContent=re,xl=n(),el=a("p"),el.textContent=je,Rl=n(),p(tl.$$.fragment),Xl=n(),nl=a("p"),this.h()},l(l){const e=Je("svelte-u9bgzb",document.head);i=y(e,"META",{name:!0,content:!0}),e.forEach(t),u=M(l),d=y(l,"P",{}),we(d).forEach(t),sl=M(l),U(h.$$.fragment,l),al=M(l),U(b.$$.fragment,l),yl=M(l),J=y(l,"P",{"data-svelte-h":!0}),o(J)!=="svelte-45abwn"&&(J.innerHTML=Ll),ol=M(l),T=y(l,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1f6nia6"&&(T.textContent=zl),il=M(l),U(g.$$.fragment,l),pl=M(l),f=y(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1occiln"&&(f.textContent=Fl),Ul=M(l),A=y(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-ofrdjq"&&(A.textContent=ql),rl=M(l),U(I.$$.fragment,l),jl=M(l),B=y(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-gkovew"&&(B.textContent=Pl),cl=M(l),U(k.$$.fragment,l),wl=M(l),Z=y(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-16hajs3"&&(Z.innerHTML=Dl),dl=M(l),U(m.$$.fragment,l),Cl=M(l),U(G.$$.fragment,l),ml=M(l),U(v.$$.fragment,l),ul=M(l),W=y(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1c3gu6o"&&(W.innerHTML=Kl),hl=M(l),$=y(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-128rf40"&&($.innerHTML=Ol),bl=M(l),S=y(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1ms2uj2"&&(S.innerHTML=le),Jl=M(l),U(V.$$.fragment,l),Tl=M(l),E=y(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-hbvg5t"&&(E.textContent=ee),gl=M(l),U(_.$$.fragment,l),fl=M(l),U(Q.$$.fragment,l),Al=M(l),H=y(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-5768lo"&&(H.innerHTML=te),Il=M(l),x=y(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-noa5rw"&&(x.textContent=se),Bl=M(l),R=y(l,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-cg2xmz"&&(R.innerHTML=ne),kl=M(l),U(X.$$.fragment,l),Zl=M(l),N=y(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-fbxoqx"&&(N.innerHTML=Me),Gl=M(l),Y=y(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-wtigy3"&&(Y.innerHTML=ae),vl=M(l),L=y(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1lmitd7"&&(L.innerHTML=ye),Wl=M(l),z=y(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1ezr7oa"&&(z.innerHTML=oe),$l=M(l),U(F.$$.fragment,l),Sl=M(l),q=y(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-90lagx"&&(q.textContent=ie),Vl=M(l),U(P.$$.fragment,l),El=M(l),D=y(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-tvhx1x"&&(D.textContent=pe),_l=M(l),U(K.$$.fragment,l),Ql=M(l),O=y(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-19s7crl"&&(O.innerHTML=Ue),Hl=M(l),ll=y(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-ollz3q"&&(ll.textContent=re),xl=M(l),el=y(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-rvy62f"&&(el.textContent=je),Rl=M(l),U(tl.$$.fragment,l),Xl=M(l),nl=y(l,"P",{}),we(nl).forEach(t),this.h()},h(){de(i,"name","hf:doc:metadata"),de(i,"content",ke)},m(l,e){Te(document.head,i),s(l,u,e),s(l,d,e),s(l,sl,e),r(h,l,e),s(l,al,e),r(b,l,e),s(l,yl,e),s(l,J,e),s(l,ol,e),s(l,T,e),s(l,il,e),r(g,l,e),s(l,pl,e),s(l,f,e),s(l,Ul,e),s(l,A,e),s(l,rl,e),r(I,l,e),s(l,jl,e),s(l,B,e),s(l,cl,e),r(k,l,e),s(l,wl,e),s(l,Z,e),s(l,dl,e),r(m,l,e),s(l,Cl,e),r(G,l,e),s(l,ml,e),r(v,l,e),s(l,ul,e),s(l,W,e),s(l,hl,e),s(l,$,e),s(l,bl,e),s(l,S,e),s(l,Jl,e),r(V,l,e),s(l,Tl,e),s(l,E,e),s(l,gl,e),r(_,l,e),s(l,fl,e),r(Q,l,e),s(l,Al,e),s(l,H,e),s(l,Il,e),s(l,x,e),s(l,Bl,e),s(l,R,e),s(l,kl,e),r(X,l,e),s(l,Zl,e),s(l,N,e),s(l,Gl,e),s(l,Y,e),s(l,vl,e),s(l,L,e),s(l,Wl,e),s(l,z,e),s(l,$l,e),r(F,l,e),s(l,Sl,e),s(l,q,e),s(l,Vl,e),r(P,l,e),s(l,El,e),s(l,D,e),s(l,_l,e),r(K,l,e),s(l,Ql,e),s(l,O,e),s(l,Hl,e),s(l,ll,e),s(l,xl,e),s(l,el,e),s(l,Rl,e),r(tl,l,e),s(l,Xl,e),s(l,nl,e),Nl=!0},p(l,[e]){const ce={};e&2&&(ce.$$scope={dirty:e,ctx:l}),m.$set(ce)},i(l){Nl||(j(h.$$.fragment,l),j(b.$$.fragment,l),j(g.$$.fragment,l),j(I.$$.fragment,l),j(k.$$.fragment,l),j(m.$$.fragment,l),j(G.$$.fragment,l),j(v.$$.fragment,l),j(V.$$.fragment,l),j(_.$$.fragment,l),j(Q.$$.fragment,l),j(X.$$.fragment,l),j(F.$$.fragment,l),j(P.$$.fragment,l),j(K.$$.fragment,l),j(tl.$$.fragment,l),Nl=!0)},o(l){c(h.$$.fragment,l),c(b.$$.fragment,l),c(g.$$.fragment,l),c(I.$$.fragment,l),c(k.$$.fragment,l),c(m.$$.fragment,l),c(G.$$.fragment,l),c(v.$$.fragment,l),c(V.$$.fragment,l),c(_.$$.fragment,l),c(Q.$$.fragment,l),c(X.$$.fragment,l),c(F.$$.fragment,l),c(P.$$.fragment,l),c(K.$$.fragment,l),c(tl.$$.fragment,l),Nl=!1},d(l){l&&(t(u),t(d),t(sl),t(al),t(yl),t(J),t(ol),t(T),t(il),t(pl),t(f),t(Ul),t(A),t(rl),t(jl),t(B),t(cl),t(wl),t(Z),t(dl),t(Cl),t(ml),t(ul),t(W),t(hl),t($),t(bl),t(S),t(Jl),t(Tl),t(E),t(gl),t(fl),t(Al),t(H),t(Il),t(x),t(Bl),t(R),t(kl),t(Zl),t(N),t(Gl),t(Y),t(vl),t(L),t(Wl),t(z),t($l),t(Sl),t(q),t(Vl),t(El),t(D),t(_l),t(Ql),t(O),t(Hl),t(ll),t(xl),t(el),t(Rl),t(Xl),t(nl)),t(i),w(h,l),w(b,l),w(g,l),w(I,l),w(k,l),w(m,l),w(G,l),w(v,l),w(V,l),w(_,l),w(Q,l),w(X,l),w(F,l),w(P,l),w(K,l),w(tl,l)}}}const ke='{"title":"Orchestrate a multi-agent system 🤖🤝🤖","local":"orchestrate-a-multi-agent-system-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":2},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function Ze(Ml){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends he{constructor(i){super(),be(this,i,Ze,Be,Ce,{})}}export{Ee as component};
