import{s as ps,f as rs,o as us,n as yl}from"../chunks/scheduler.f6319a2a.js";import{S as cs,i as ds,g as a,s as o,r as p,A as ms,h as i,f as l,c as n,j as Ms,u,x as r,k as dl,y as ys,a as s,v as c,d,t as m,w as y}from"../chunks/index.85aa684c.js";import{T as ml}from"../chunks/Tip.3d397a88.js";import{C as T}from"../chunks/CodeBlock.3400fc53.js";import{D as hs}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as g,E as bs}from"../chunks/index.c8a0819f.js";function ws(J){let M,U='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){M=a("p"),M.innerHTML=U},l(h){M=i(h,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1p1d9vw"&&(M.innerHTML=U)},m(h,w){s(h,M,w)},p:yl,d(h){h&&l(M)}}}function Us(J){let M,U="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){M=a("p"),M.textContent=U},l(h){M=i(h,"P",{"data-svelte-h":!0}),r(M)!=="svelte-h9mzfm"&&(M.textContent=U)},m(h,w){s(h,M,w)},p:yl,d(h){h&&l(M)}}}function Ts(J){let M,U="<strong>Security Warning:</strong> Using MCP servers comes with security risks:",h,w,j="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>SSE-based MCP servers</strong> while the remote MCP servers will not be able to execute code on your machine, still proceed with caution.</li>",C,f,_="Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.";return{c(){M=a("p"),M.innerHTML=U,h=o(),w=a("ul"),w.innerHTML=j,C=o(),f=a("p"),f.textContent=_},l(b){M=i(b,"P",{"data-svelte-h":!0}),r(M)!=="svelte-936g9o"&&(M.innerHTML=U),h=n(b),w=i(b,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-13es5en"&&(w.innerHTML=j),C=n(b),f=i(b,"P",{"data-svelte-h":!0}),r(f)!=="svelte-57pqg4"&&(f.textContent=_)},m(b,v){s(b,M,v),s(b,h,v),s(b,w,v),s(b,C,v),s(b,f,v)},p:yl,d(b){b&&(l(M),l(h),l(w),l(C),l(f))}}}function fs(J){let M,U="<strong>Security Warning:</strong> The same security warnings mentioned for <code>ToolCollection.from_mcp</code> apply when using <code>MCPClient</code> directly.";return{c(){M=a("p"),M.innerHTML=U},l(h){M=i(h,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1dxey55"&&(M.innerHTML=U)},m(h,w){s(h,M,w)},p:yl,d(h){h&&l(M)}}}function Js(J){let M,U,h,w,j,C,f,_,b,v="Here, we’re going to see advanced tool usage.",ze,I,Fe,W,hl='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',Le,G,Pe,Q,bl="A tool is mostly a function that an LLM can use in an agentic system.",De,k,wl="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Ke,H,Ul="So it cannot be only a function. It should be a class.",Oe,x,Tl="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",et,V,fl="Here’s how it looks:",tt,R,lt,N,Jl='The custom tool subclasses <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',st,E,jl='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',ot,S,gl="And that’s all it needs to be used in an agent!",nt,A,Cl='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',at,X,vl='In this case, you can build your tool by subclassing <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.Tool">Tool</a> as described above.',it,q,rt,Y,Il='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Mt,z,pt,F,Zl="For the push to Hub to work, your tool will need to respect some rules:",ut,L,$l='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',ct,P,Bl='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',dt,D,_l='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',mt,K,Wl=`Then you can load the tool with <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,yt,O,ht,ee,bt,te,Gl='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',wt,le,Ql='You only need to provide the id of the Space on the Hub, its name, and a description that will help your agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',Ut,se,kl='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',Tt,oe,ft,ne,Hl="And voilà, here’s your image! 🏖️",Jt,Xe,xl,jt,ae,Vl="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",gt,ie,Ct,re,vt,qe,Rl,It,Me,Nl="How cool is this? 🤩",Zt,pe,$t,ue,El=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,Bt,ce,Sl=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,_t,de,Wt,me,Gt,ye,Al="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",Qt,he,Xl="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",kt,be,Ht,we,ql="Now we can leverage the new tool:",xt,Ue,Vt,Z,Rt,Te,Nt,fe,Yl='You can leverage tool collections by using <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',Et,Je,St,je,zl=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,At,ge,Xt,Ce,Fl="To speed up the start, tools are loaded only if called by the agent.",qt,ve,Yt,Ie,Ll='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',zt,$,Ft,Ze,Pl='The MCP servers tools can be loaded with <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',Lt,$e,Dl="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Pt,Be,Dt,_e,Kl="For SSE-based MCP servers, simply pass a dict with parameters to <code>mcp.client.sse.sse_client</code>:",Kt,We,Ot,Ge,el,Qe,Ol="You can also work with MCP tools by using the <code>MCPClient</code> directly, which gives you more control over the connection and tool management:",tl,ke,es="For stdio-based MCP servers:",ll,He,sl,xe,ts="For SSE-based MCP servers:",ol,Ve,nl,Re,ls="You can also manually manage the connection lifecycle with the try…finally pattern:",al,Ne,il,Ee,ss="You can also connect to multiple MCP servers at once by passing a list of server parameters:",rl,Se,Ml,B,pl,Ae,ul,Ye,cl;return j=new g({props:{title:"Tools",local:"tools",headingTag:"h1"}}),f=new hs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),I=new ml({props:{warning:!1,$$slots:{default:[ws]},$$scope:{ctx:J}}}),G=new g({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),R=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),q=new g({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),z=new T({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),O=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),ee=new g({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),oe=new T({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ie=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),re=new T({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),pe=new g({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),de=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),me=new g({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),be=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),Ue=new T({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),Z=new ml({props:{warning:!1,$$slots:{default:[Us]},$$scope:{ctx:J}}}),Te=new g({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),Je=new g({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),ge=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),ve=new g({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),$=new ml({props:{warning:!0,$$slots:{default:[Ts]},$$scope:{ctx:J}}}),Be=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),We=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ge=new g({props:{title:"Use MCP tools with MCPClient directly",local:"use-mcp-tools-with-mcpclient-directly",headingTag:"h3"}}),He=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTIwJTIwJTIzJTIwVXNpbmclMjB1dnglMjBlbnN1cmVzJTIwZGVwZW5kZW5jaWVzJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyME1DUENsaWVudChzZXJ2ZXJfcGFyYW1ldGVycyklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMG9uJTIwQ09WSUQtMTklMjB0cmVhdG1lbnQuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,  <span class="hljs-comment"># Using uvx ensures dependencies are available</span>
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find the latest research on COVID-19 treatment.&quot;</span>)`,wrap:!1}}),Ve=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEF3aXRoJTIwTUNQQ2xpZW50KCU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGc3NlJTIyJTdEKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRHRvb2xzJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-keyword">with</span> MCPClient({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ne=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEElMjMlMjBJbml0aWFsaXplJTIwc2VydmVyJTIwcGFyYW1ldGVycyUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKCUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ1dnglMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEElMjMlMjBNYW51YWxseSUyMG1hbmFnZSUyMHRoZSUyMGNvbm5lY3Rpb24lMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50JTIwJTNEJTIwTUNQQ2xpZW50KHNlcnZlcl9wYXJhbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMHRvb2xzJTIwJTNEJTIwbWNwX2NsaWVudC5nZXRfdG9vbHMoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHRvb2xzJTIwd2l0aCUyMHlvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwYXJlJTIwdGhlJTIwcmVjZW50JTIwdGhlcmFwZXV0aWMlMjBhcHByb2FjaGVzJTIwZm9yJTIwQWx6aGVpbWVyJ3MlMjBkaXNlYXNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjByZXN1bHQlMjBhcyUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBZ2VudCUyMHJlc3BvbnNlJTNBJTIwJTdCcmVzdWx0JTdEJTIyKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBlbnN1cmUlMjB0aGUlMjBjb25uZWN0aW9uJTIwaXMlMjBwcm9wZXJseSUyMGNsb3NlZCUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQuZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Initialize server parameters</span>
server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-comment"># Manually manage the connection</span>
<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(server_parameters)
    tools = mcp_client.get_tools()

    <span class="hljs-comment"># Use the tools with your agent</span>
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    result = agent.run(<span class="hljs-string">&quot;What are the recent therapeutic approaches for Alzheimer&#x27;s disease?&quot;</span>)

    <span class="hljs-comment"># Process the result as needed</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Agent response: <span class="hljs-subst">{result}</span>&quot;</span>)
<span class="hljs-keyword">finally</span>:
    <span class="hljs-comment"># Always ensure the connection is properly closed</span>
    mcp_client.disconnect()`,wrap:!1}}),Se=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1zMSUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBc2VydmVyX3BhcmFtczIlMjAlM0QlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTVCc2VydmVyX3BhcmFtczElMkMlMjBzZXJ2ZXJfcGFyYW1zMiU1RCklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGFuYWx5emUlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMGFuZCUyMHN1Z2dlc3QlMjByZW1lZGllcyUyMGZvciUyMGhlYWRhY2hlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_params1 = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

server_params2 = {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}

<span class="hljs-keyword">with</span> MCPClient([server_params1, server_params2]) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please analyze the latest research and suggest remedies for headaches.&quot;</span>)`,wrap:!1}}),B=new ml({props:{warning:!0,$$slots:{default:[fs]},$$scope:{ctx:J}}}),Ae=new bs({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.mdx"}}),{c(){M=a("meta"),U=o(),h=a("p"),w=o(),p(j.$$.fragment),C=o(),p(f.$$.fragment),_=o(),b=a("p"),b.textContent=v,ze=o(),p(I.$$.fragment),Fe=o(),W=a("ul"),W.innerHTML=hl,Le=o(),p(G.$$.fragment),Pe=o(),Q=a("p"),Q.textContent=bl,De=o(),k=a("p"),k.textContent=wl,Ke=o(),H=a("p"),H.textContent=Ul,Oe=o(),x=a("p"),x.textContent=Tl,et=o(),V=a("p"),V.textContent=fl,tt=o(),p(R.$$.fragment),lt=o(),N=a("p"),N.innerHTML=Jl,st=o(),E=a("ul"),E.innerHTML=jl,ot=o(),S=a("p"),S.textContent=gl,nt=o(),A=a("p"),A.innerHTML=Cl,at=o(),X=a("p"),X.innerHTML=vl,it=o(),p(q.$$.fragment),rt=o(),Y=a("p"),Y.innerHTML=Il,Mt=o(),p(z.$$.fragment),pt=o(),F=a("p"),F.textContent=Zl,ut=o(),L=a("ul"),L.innerHTML=$l,ct=o(),P=a("p"),P.innerHTML=Bl,dt=o(),D=a("p"),D.innerHTML=_l,mt=o(),K=a("p"),K.innerHTML=Wl,yt=o(),p(O.$$.fragment),ht=o(),p(ee.$$.fragment),bt=o(),te=a("p"),te.innerHTML=Gl,wt=o(),le=a("p"),le.innerHTML=Ql,Ut=o(),se=a("p"),se.innerHTML=kl,Tt=o(),p(oe.$$.fragment),ft=o(),ne=a("p"),ne.textContent=Hl,Jt=o(),Xe=a("img"),jt=o(),ae=a("p"),ae.innerHTML=Vl,gt=o(),p(ie.$$.fragment),Ct=o(),p(re.$$.fragment),vt=o(),qe=a("img"),It=o(),Me=a("p"),Me.textContent=Nl,Zt=o(),p(pe.$$.fragment),$t=o(),ue=a("p"),ue.innerHTML=El,Bt=o(),ce=a("p"),ce.innerHTML=Sl,_t=o(),p(de.$$.fragment),Wt=o(),p(me.$$.fragment),Gt=o(),ye=a("p"),ye.innerHTML=Al,Qt=o(),he=a("p"),he.innerHTML=Xl,kt=o(),p(be.$$.fragment),Ht=o(),we=a("p"),we.textContent=ql,xt=o(),p(Ue.$$.fragment),Vt=o(),p(Z.$$.fragment),Rt=o(),p(Te.$$.fragment),Nt=o(),fe=a("p"),fe.innerHTML=Yl,Et=o(),p(Je.$$.fragment),St=o(),je=a("p"),je.textContent=zl,At=o(),p(ge.$$.fragment),Xt=o(),Ce=a("p"),Ce.textContent=Fl,qt=o(),p(ve.$$.fragment),Yt=o(),Ie=a("p"),Ie.innerHTML=Ll,zt=o(),p($.$$.fragment),Ft=o(),Ze=a("p"),Ze.innerHTML=Pl,Lt=o(),$e=a("p"),$e.innerHTML=Dl,Pt=o(),p(Be.$$.fragment),Dt=o(),_e=a("p"),_e.innerHTML=Kl,Kt=o(),p(We.$$.fragment),Ot=o(),p(Ge.$$.fragment),el=o(),Qe=a("p"),Qe.innerHTML=Ol,tl=o(),ke=a("p"),ke.textContent=es,ll=o(),p(He.$$.fragment),sl=o(),xe=a("p"),xe.textContent=ts,ol=o(),p(Ve.$$.fragment),nl=o(),Re=a("p"),Re.textContent=ls,al=o(),p(Ne.$$.fragment),il=o(),Ee=a("p"),Ee.textContent=ss,rl=o(),p(Se.$$.fragment),Ml=o(),p(B.$$.fragment),pl=o(),p(Ae.$$.fragment),ul=o(),Ye=a("p"),this.h()},l(e){const t=ms("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),U=n(e),h=i(e,"P",{}),Ms(h).forEach(l),w=n(e),u(j.$$.fragment,e),C=n(e),u(f.$$.fragment,e),_=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-8951oz"&&(b.textContent=v),ze=n(e),u(I.$$.fragment,e),Fe=n(e),W=i(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-gdosxb"&&(W.innerHTML=hl),Le=n(e),u(G.$$.fragment,e),Pe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-50z9h0"&&(Q.textContent=bl),De=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1llqfcr"&&(k.textContent=wl),Ke=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-eilpgu"&&(H.textContent=Ul),Oe=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-suz7fy"&&(x.textContent=Tl),et=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-x18ywb"&&(V.textContent=fl),tt=n(e),u(R.$$.fragment,e),lt=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-4lhn51"&&(N.innerHTML=Jl),st=n(e),E=i(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-xqgwuf"&&(E.innerHTML=jl),ot=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-220ayw"&&(S.textContent=gl),nt=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-iifhpf"&&(A.innerHTML=Cl),at=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-2h7kxn"&&(X.innerHTML=vl),it=n(e),u(q.$$.fragment,e),rt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-jgry5u"&&(Y.innerHTML=Il),Mt=n(e),u(z.$$.fragment,e),pt=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-hoocvd"&&(F.textContent=Zl),ut=n(e),L=i(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-did73t"&&(L.innerHTML=$l),ct=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-4n5s3c"&&(P.innerHTML=Bl),dt=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1knl8v8"&&(D.innerHTML=_l),mt=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-9i3mzs"&&(K.innerHTML=Wl),yt=n(e),u(O.$$.fragment,e),ht=n(e),u(ee.$$.fragment,e),bt=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1hzjfav"&&(te.innerHTML=Gl),wt=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-17wa58l"&&(le.innerHTML=Ql),Ut=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1gucs20"&&(se.innerHTML=kl),Tt=n(e),u(oe.$$.fragment,e),ft=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-sgspwr"&&(ne.textContent=Hl),Jt=n(e),Xe=i(e,"IMG",{src:!0}),jt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1y8rl57"&&(ae.innerHTML=Vl),gt=n(e),u(ie.$$.fragment,e),Ct=n(e),u(re.$$.fragment,e),vt=n(e),qe=i(e,"IMG",{src:!0}),It=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-i5dtbz"&&(Me.textContent=Nl),Zt=n(e),u(pe.$$.fragment,e),$t=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1rq40pf"&&(ue.innerHTML=El),Bt=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1g7jkvd"&&(ce.innerHTML=Sl),_t=n(e),u(de.$$.fragment,e),Wt=n(e),u(me.$$.fragment,e),Gt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-69p3x"&&(ye.innerHTML=Al),Qt=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-ocb8u2"&&(he.innerHTML=Xl),kt=n(e),u(be.$$.fragment,e),Ht=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-o3ledg"&&(we.textContent=ql),xt=n(e),u(Ue.$$.fragment,e),Vt=n(e),u(Z.$$.fragment,e),Rt=n(e),u(Te.$$.fragment,e),Nt=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-qgqsug"&&(fe.innerHTML=Yl),Et=n(e),u(Je.$$.fragment,e),St=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-qubpc6"&&(je.textContent=zl),At=n(e),u(ge.$$.fragment,e),Xt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-6r1jgt"&&(Ce.textContent=Fl),qt=n(e),u(ve.$$.fragment,e),Yt=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1q39vf"&&(Ie.innerHTML=Ll),zt=n(e),u($.$$.fragment,e),Ft=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-oygrs6"&&(Ze.innerHTML=Pl),Lt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-s0gh2b"&&($e.innerHTML=Dl),Pt=n(e),u(Be.$$.fragment,e),Dt=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1skatdh"&&(_e.innerHTML=Kl),Kt=n(e),u(We.$$.fragment,e),Ot=n(e),u(Ge.$$.fragment,e),el=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-9674bn"&&(Qe.innerHTML=Ol),tl=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1en3ihe"&&(ke.textContent=es),ll=n(e),u(He.$$.fragment,e),sl=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-qn94oi"&&(xe.textContent=ts),ol=n(e),u(Ve.$$.fragment,e),nl=n(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1and4a8"&&(Re.textContent=ls),al=n(e),u(Ne.$$.fragment,e),il=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-7q6kbi"&&(Ee.textContent=ss),rl=n(e),u(Se.$$.fragment,e),Ml=n(e),u(B.$$.fragment,e),pl=n(e),u(Ae.$$.fragment,e),ul=n(e),Ye=i(e,"P",{}),Ms(Ye).forEach(l),this.h()},h(){dl(M,"name","hf:doc:metadata"),dl(M,"content",js),rs(Xe.src,xl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||dl(Xe,"src",xl),rs(qe.src,Rl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||dl(qe,"src",Rl)},m(e,t){ys(document.head,M),s(e,U,t),s(e,h,t),s(e,w,t),c(j,e,t),s(e,C,t),c(f,e,t),s(e,_,t),s(e,b,t),s(e,ze,t),c(I,e,t),s(e,Fe,t),s(e,W,t),s(e,Le,t),c(G,e,t),s(e,Pe,t),s(e,Q,t),s(e,De,t),s(e,k,t),s(e,Ke,t),s(e,H,t),s(e,Oe,t),s(e,x,t),s(e,et,t),s(e,V,t),s(e,tt,t),c(R,e,t),s(e,lt,t),s(e,N,t),s(e,st,t),s(e,E,t),s(e,ot,t),s(e,S,t),s(e,nt,t),s(e,A,t),s(e,at,t),s(e,X,t),s(e,it,t),c(q,e,t),s(e,rt,t),s(e,Y,t),s(e,Mt,t),c(z,e,t),s(e,pt,t),s(e,F,t),s(e,ut,t),s(e,L,t),s(e,ct,t),s(e,P,t),s(e,dt,t),s(e,D,t),s(e,mt,t),s(e,K,t),s(e,yt,t),c(O,e,t),s(e,ht,t),c(ee,e,t),s(e,bt,t),s(e,te,t),s(e,wt,t),s(e,le,t),s(e,Ut,t),s(e,se,t),s(e,Tt,t),c(oe,e,t),s(e,ft,t),s(e,ne,t),s(e,Jt,t),s(e,Xe,t),s(e,jt,t),s(e,ae,t),s(e,gt,t),c(ie,e,t),s(e,Ct,t),c(re,e,t),s(e,vt,t),s(e,qe,t),s(e,It,t),s(e,Me,t),s(e,Zt,t),c(pe,e,t),s(e,$t,t),s(e,ue,t),s(e,Bt,t),s(e,ce,t),s(e,_t,t),c(de,e,t),s(e,Wt,t),c(me,e,t),s(e,Gt,t),s(e,ye,t),s(e,Qt,t),s(e,he,t),s(e,kt,t),c(be,e,t),s(e,Ht,t),s(e,we,t),s(e,xt,t),c(Ue,e,t),s(e,Vt,t),c(Z,e,t),s(e,Rt,t),c(Te,e,t),s(e,Nt,t),s(e,fe,t),s(e,Et,t),c(Je,e,t),s(e,St,t),s(e,je,t),s(e,At,t),c(ge,e,t),s(e,Xt,t),s(e,Ce,t),s(e,qt,t),c(ve,e,t),s(e,Yt,t),s(e,Ie,t),s(e,zt,t),c($,e,t),s(e,Ft,t),s(e,Ze,t),s(e,Lt,t),s(e,$e,t),s(e,Pt,t),c(Be,e,t),s(e,Dt,t),s(e,_e,t),s(e,Kt,t),c(We,e,t),s(e,Ot,t),c(Ge,e,t),s(e,el,t),s(e,Qe,t),s(e,tl,t),s(e,ke,t),s(e,ll,t),c(He,e,t),s(e,sl,t),s(e,xe,t),s(e,ol,t),c(Ve,e,t),s(e,nl,t),s(e,Re,t),s(e,al,t),c(Ne,e,t),s(e,il,t),s(e,Ee,t),s(e,rl,t),c(Se,e,t),s(e,Ml,t),c(B,e,t),s(e,pl,t),c(Ae,e,t),s(e,ul,t),s(e,Ye,t),cl=!0},p(e,[t]){const os={};t&2&&(os.$$scope={dirty:t,ctx:e}),I.$set(os);const ns={};t&2&&(ns.$$scope={dirty:t,ctx:e}),Z.$set(ns);const as={};t&2&&(as.$$scope={dirty:t,ctx:e}),$.$set(as);const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),B.$set(is)},i(e){cl||(d(j.$$.fragment,e),d(f.$$.fragment,e),d(I.$$.fragment,e),d(G.$$.fragment,e),d(R.$$.fragment,e),d(q.$$.fragment,e),d(z.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(oe.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(be.$$.fragment,e),d(Ue.$$.fragment,e),d(Z.$$.fragment,e),d(Te.$$.fragment,e),d(Je.$$.fragment,e),d(ge.$$.fragment,e),d(ve.$$.fragment,e),d($.$$.fragment,e),d(Be.$$.fragment,e),d(We.$$.fragment,e),d(Ge.$$.fragment,e),d(He.$$.fragment,e),d(Ve.$$.fragment,e),d(Ne.$$.fragment,e),d(Se.$$.fragment,e),d(B.$$.fragment,e),d(Ae.$$.fragment,e),cl=!0)},o(e){m(j.$$.fragment,e),m(f.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(R.$$.fragment,e),m(q.$$.fragment,e),m(z.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(oe.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(be.$$.fragment,e),m(Ue.$$.fragment,e),m(Z.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m($.$$.fragment,e),m(Be.$$.fragment,e),m(We.$$.fragment,e),m(Ge.$$.fragment,e),m(He.$$.fragment,e),m(Ve.$$.fragment,e),m(Ne.$$.fragment,e),m(Se.$$.fragment,e),m(B.$$.fragment,e),m(Ae.$$.fragment,e),cl=!1},d(e){e&&(l(U),l(h),l(w),l(C),l(_),l(b),l(ze),l(Fe),l(W),l(Le),l(Pe),l(Q),l(De),l(k),l(Ke),l(H),l(Oe),l(x),l(et),l(V),l(tt),l(lt),l(N),l(st),l(E),l(ot),l(S),l(nt),l(A),l(at),l(X),l(it),l(rt),l(Y),l(Mt),l(pt),l(F),l(ut),l(L),l(ct),l(P),l(dt),l(D),l(mt),l(K),l(yt),l(ht),l(bt),l(te),l(wt),l(le),l(Ut),l(se),l(Tt),l(ft),l(ne),l(Jt),l(Xe),l(jt),l(ae),l(gt),l(Ct),l(vt),l(qe),l(It),l(Me),l(Zt),l($t),l(ue),l(Bt),l(ce),l(_t),l(Wt),l(Gt),l(ye),l(Qt),l(he),l(kt),l(Ht),l(we),l(xt),l(Vt),l(Rt),l(Nt),l(fe),l(Et),l(St),l(je),l(At),l(Xt),l(Ce),l(qt),l(Yt),l(Ie),l(zt),l(Ft),l(Ze),l(Lt),l($e),l(Pt),l(Dt),l(_e),l(Kt),l(Ot),l(el),l(Qe),l(tl),l(ke),l(ll),l(sl),l(xe),l(ol),l(nl),l(Re),l(al),l(il),l(Ee),l(rl),l(Ml),l(pl),l(ul),l(Ye)),l(M),y(j,e),y(f,e),y(I,e),y(G,e),y(R,e),y(q,e),y(z,e),y(O,e),y(ee,e),y(oe,e),y(ie,e),y(re,e),y(pe,e),y(de,e),y(me,e),y(be,e),y(Ue,e),y(Z,e),y(Te,e),y(Je,e),y(ge,e),y(ve,e),y($,e),y(Be,e),y(We,e),y(Ge,e),y(He,e),y(Ve,e),y(Ne,e),y(Se,e),y(B,e),y(Ae,e)}}}const js='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4},{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4}],"depth":3},{"title":"Use MCP tools with MCPClient directly","local":"use-mcp-tools-with-mcpclient-directly","sections":[],"depth":3}],"depth":1}';function gs(J){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends cs{constructor(M){super(),ds(this,M,gs,Js,ps,{})}}export{_s as component};
