import{s as Rn,f as Gn,o as Sn,n as Al}from"../chunks/scheduler.f6319a2a.js";import{S as _n,i as Nn,g as i,s,r,A as Qn,h as o,f as l,c as a,j as Vn,u,x as p,k as nt,y as Hn,a as n,v as c,d as y,t as w,w as J}from"../chunks/index.85aa684c.js";import{T as Wl}from"../chunks/Tip.3d397a88.js";import{C}from"../chunks/CodeBlock.3400fc53.js";import{D as Yn}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as T,E as Xn}from"../chunks/getInferenceSnippets.bcbc4a43.js";function qn(j){let M,h='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){M=i("p"),M.innerHTML=h},l(d){M=o(d,"P",{"data-svelte-h":!0}),p(M)!=="svelte-1p1d9vw"&&(M.innerHTML=h)},m(d,U){n(d,M,U)},p:Al,d(d){d&&l(M)}}}function Fn(j){let M,h="It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.",d,U,I="For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.",f,b,k="Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.";return{c(){M=i("p"),M.textContent=h,d=s(),U=i("p"),U.innerHTML=I,f=s(),b=i("p"),b.textContent=k},l(m){M=o(m,"P",{"data-svelte-h":!0}),p(M)!=="svelte-13ohzr"&&(M.textContent=h),d=a(m),U=o(m,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1wfid17"&&(U.innerHTML=I),f=a(m),b=o(m,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1zo76k"&&(b.textContent=k)},m(m,g){n(m,M,g),n(m,d,g),n(m,U,g),n(m,f,g),n(m,b,g)},p:Al,d(m){m&&(l(M),l(d),l(U),l(f),l(b))}}}function zn(j){let M,h=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the E2B sandbox is cleaned up immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=h},l(d){M=o(d,"P",{"data-svelte-h":!0}),p(M)!=="svelte-h2lp0n"&&(M.innerHTML=h)},m(d,U){n(d,M,U)},p:Al,d(d){d&&l(M)}}}function Ln(j){let M,h=`Using the agent as a context manager (with the <code>with</code> statement) ensures that the Docker container is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.`;return{c(){M=i("p"),M.innerHTML=h},l(d){M=o(d,"P",{"data-svelte-h":!0}),p(M)!=="svelte-hvigp3"&&(M.innerHTML=h)},m(d,U){n(d,M,U)},p:Al,d(d){d&&l(M)}}}function Pn(j){let M,h,d,U,I,f,b,k,m,g,$,st,W,El='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',at,A,Gl="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",it,E,Vl="Code is just a better way to express actions on a computer. It has better:",ot,G,Rl="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",pt,V,Sl='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',Mt,et,_l,rt,R,Nl="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",ut,S,ct,_,Ql="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",yt,N,Hl="This is inherently risky, LLM-generated code could be harmful to your environment.",wt,Q,Yl="Malicious code execution can occur in several ways:",Jt,H,Xl=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,dt,Y,ql='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',mt,X,Fl="So you need to be very mindful of security.",Tt,q,zl="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",Ut,F,Ll="We advise you to keep in mind that no solution will be 100% safe.",ht,tt,Pl,bt,z,jt,L,Dl=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,It,P,Kl="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",gt,D,Ol="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",ft,K,en="You could try these safeguards as follows:",Ct,O,xt,ee,tn=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,vt,x,Bt,te,ln=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,Zt,le,kt,ne,nn="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",$t,se,sn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/remote_execution.png" alt="Sandbox approaches comparison"/>',Wt,ae,an="<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>",At,ie,on="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",Et,oe,Gt,pe,Vt,Me,pn='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Rt,re,St,ue,_t,ce,Mn="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",Nt,ye,Qt,v,Ht,we,rn=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,Yt,Je,un="This is illustrated in the figure below.",Xt,B,cn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',qt,de,yn=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,Ft,me,zt,Te,wn="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",Lt,Ue,Jn="Here is how to do it:",Pt,he,Dt,be,Kt,je,Ot,Ie,dn='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',el,ge,tl,fe,ll,Ce,mn="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",nl,xe,sl,Z,al,ve,il,Be,Tn="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",ol,Ze,Un="Here is how to setup the a Dockerfile:",pl,ke,Ml,$e,hn="Create a sandbox manager to run code:",rl,We,ul,Ae,cl,Ee,bn=`WebAssembly (Wasm) is a binary instruction format that allows code to be run in a safe, sandboxed environment.
It is designed to be fast, efficient, and secure, making it an excellent choice for executing potentially untrusted code.`,yl,Ge,jn='The <code>WasmExecutor</code> uses <a href="https://pyodide.org/" rel="nofollow">Pyodide</a> and <a href="https://docs.deno.com/" rel="nofollow">Deno</a>.',wl,Ve,Jl,Re,In='<li><a href="https://docs.deno.com/runtime/getting_started/installation/" rel="nofollow">Install Deno on your system</a></li>',dl,Se,ml,_e,gn="Simply pass <code>executor_type=&quot;wasm&quot;</code> to the agent initialization, like:",Tl,Ne,Ul,Qe,hl,He,fn="These key practices apply to both E2B and Docker sandboxes:",bl,Ye,Cn="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",jl,Xe,xn="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",Il,qe,gl,Fe,vn="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",fl,ze,Cl,Le,Bn="<li><strong>Pros</strong>: <ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>",xl,Pe,vl,De,Zn="<li><strong>Pros</strong>:<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>",Bl,Ke,kn="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",Zl,Oe,kl,lt,$l;return I=new T({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),b=new Yn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),m=new Wl({props:{warning:!1,$$slots:{default:[qn]},$$scope:{ctx:j}}}),$=new T({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),S=new T({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),z=new T({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),O=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&quot;</span>echo Bad command<span class="hljs-string">&quot;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),x=new Wl({props:{warning:!0,$$slots:{default:[Fn]},$$scope:{ctx:j}}}),le=new T({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),oe=new T({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),pe=new T({props:{title:"Installation",local:"installation",headingTag:"h4"}}),re=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),ue=new T({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),ye=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMmUyYiUyMiklMEElMEF3aXRoJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>)

<span class="hljs-keyword">with</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),v=new Wl({props:{warning:!1,$$slots:{default:[zn]},$$scope:{ctx:j}}}),me=new T({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),he=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),be=new T({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),je=new T({props:{title:"Installation",local:"installation",headingTag:"h4"}}),ge=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),fe=new T({props:{title:"Running your agent in Docker: quick start",local:"running-your-agent-in-docker-quick-start",headingTag:"h4"}}),xe=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMmRvY2tlciUyMiklMEElMEF3aXRoJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>)

<span class="hljs-keyword">with</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Z=new Wl({props:{warning:!1,$$slots:{default:[Ln]},$$scope:{ctx:j}}}),ve=new T({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),ke=new C({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),We=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),Ae=new T({props:{title:"WebAssembly setup",local:"webassembly-setup",headingTag:"h3"}}),Ve=new T({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Se=new T({props:{title:"Running your agent in WebAssembly: quick start",local:"running-your-agent-in-webassembly-quick-start",headingTag:"h4"}}),Ne=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMndhc20lMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;wasm&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Qe=new T({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),qe=new T({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),ze=new T({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),Pe=new T({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),Oe=new Xn({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.md"}}),{c(){M=i("meta"),h=s(),d=i("p"),U=s(),r(I.$$.fragment),f=s(),r(b.$$.fragment),k=s(),r(m.$$.fragment),g=s(),r($.$$.fragment),st=s(),W=i("p"),W.innerHTML=El,at=s(),A=i("p"),A.textContent=Gl,it=s(),E=i("p"),E.textContent=Vl,ot=s(),G=i("ul"),G.innerHTML=Rl,pt=s(),V=i("p"),V.innerHTML=Sl,Mt=s(),et=i("img"),rt=s(),R=i("p"),R.textContent=Nl,ut=s(),r(S.$$.fragment),ct=s(),_=i("p"),_.innerHTML=Ql,yt=s(),N=i("p"),N.textContent=Hl,wt=s(),Q=i("p"),Q.textContent=Yl,Jt=s(),H=i("ul"),H.innerHTML=Xl,dt=s(),Y=i("p"),Y.innerHTML=ql,mt=s(),X=i("p"),X.textContent=Fl,Tt=s(),q=i("p"),q.textContent=zl,Ut=s(),F=i("p"),F.textContent=Ll,ht=s(),tt=i("img"),bt=s(),r(z.$$.fragment),jt=s(),L=i("p"),L.innerHTML=Dl,It=s(),P=i("p"),P.textContent=Kl,gt=s(),D=i("ul"),D.innerHTML=Ol,ft=s(),K=i("p"),K.textContent=en,Ct=s(),r(O.$$.fragment),xt=s(),ee=i("p"),ee.textContent=tn,vt=s(),r(x.$$.fragment),Bt=s(),te=i("p"),te.textContent=ln,Zt=s(),r(le.$$.fragment),kt=s(),ne=i("p"),ne.textContent=nn,$t=s(),se=i("p"),se.innerHTML=sn,Wt=s(),ae=i("ol"),ae.innerHTML=an,At=s(),ie=i("p"),ie.textContent=on,Et=s(),r(oe.$$.fragment),Gt=s(),r(pe.$$.fragment),Vt=s(),Me=i("ol"),Me.innerHTML=pn,Rt=s(),r(re.$$.fragment),St=s(),r(ue.$$.fragment),_t=s(),ce=i("p"),ce.innerHTML=Mn,Nt=s(),r(ye.$$.fragment),Qt=s(),r(v.$$.fragment),Ht=s(),we=i("p"),we.innerHTML=rn,Yt=s(),Je=i("p"),Je.textContent=un,Xt=s(),B=i("p"),B.innerHTML=cn,qt=s(),de=i("p"),de.innerHTML=yn,Ft=s(),r(me.$$.fragment),zt=s(),Te=i("p"),Te.textContent=wn,Lt=s(),Ue=i("p"),Ue.textContent=Jn,Pt=s(),r(he.$$.fragment),Dt=s(),r(be.$$.fragment),Kt=s(),r(je.$$.fragment),Ot=s(),Ie=i("ol"),Ie.innerHTML=dn,el=s(),r(ge.$$.fragment),tl=s(),r(fe.$$.fragment),ll=s(),Ce=i("p"),Ce.innerHTML=mn,nl=s(),r(xe.$$.fragment),sl=s(),r(Z.$$.fragment),al=s(),r(ve.$$.fragment),il=s(),Be=i("p"),Be.textContent=Tn,ol=s(),Ze=i("p"),Ze.textContent=Un,pl=s(),r(ke.$$.fragment),Ml=s(),$e=i("p"),$e.textContent=hn,rl=s(),r(We.$$.fragment),ul=s(),r(Ae.$$.fragment),cl=s(),Ee=i("p"),Ee.textContent=bn,yl=s(),Ge=i("p"),Ge.innerHTML=jn,wl=s(),r(Ve.$$.fragment),Jl=s(),Re=i("ol"),Re.innerHTML=In,dl=s(),r(Se.$$.fragment),ml=s(),_e=i("p"),_e.innerHTML=gn,Tl=s(),r(Ne.$$.fragment),Ul=s(),r(Qe.$$.fragment),hl=s(),He=i("p"),He.textContent=fn,bl=s(),Ye=i("ul"),Ye.innerHTML=Cn,jl=s(),Xe=i("p"),Xe.textContent=xn,Il=s(),r(qe.$$.fragment),gl=s(),Fe=i("p"),Fe.textContent=vn,fl=s(),r(ze.$$.fragment),Cl=s(),Le=i("ul"),Le.innerHTML=Bn,xl=s(),r(Pe.$$.fragment),vl=s(),De=i("ul"),De.innerHTML=Zn,Bl=s(),Ke=i("p"),Ke.textContent=kn,Zl=s(),r(Oe.$$.fragment),kl=s(),lt=i("p"),this.h()},l(e){const t=Qn("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),d=o(e,"P",{}),Vn(d).forEach(l),U=a(e),u(I.$$.fragment,e),f=a(e),u(b.$$.fragment,e),k=a(e),u(m.$$.fragment,e),g=a(e),u($.$$.fragment,e),st=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1nor5c0"&&(W.innerHTML=El),at=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1b2f48c"&&(A.textContent=Gl),it=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1jp5kiv"&&(E.textContent=Vl),ot=a(e),G=o(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-a7ou7n"&&(G.innerHTML=Rl),pt=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ugtxvn"&&(V.innerHTML=Sl),Mt=a(e),et=o(e,"IMG",{src:!0}),rt=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1lbgv3o"&&(R.textContent=Nl),ut=a(e),u(S.$$.fragment,e),ct=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-19p3p3d"&&(_.innerHTML=Ql),yt=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-y55i8i"&&(N.textContent=Hl),wt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-y4kupg"&&(Q.textContent=Yl),Jt=a(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-1b6z7ic"&&(H.innerHTML=Xl),dt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-uopq3c"&&(Y.innerHTML=ql),mt=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-gfolx1"&&(X.textContent=Fl),Tt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1j1i1cv"&&(q.textContent=zl),Ut=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1ghwkh9"&&(F.textContent=Ll),ht=a(e),tt=o(e,"IMG",{src:!0}),bt=a(e),u(z.$$.fragment,e),jt=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-845rka"&&(L.innerHTML=Dl),It=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-180snho"&&(P.textContent=Kl),gt=a(e),D=o(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-19qb8ke"&&(D.innerHTML=Ol),ft=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1wz8jbt"&&(K.textContent=en),Ct=a(e),u(O.$$.fragment,e),xt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1gk7uki"&&(ee.textContent=tn),vt=a(e),u(x.$$.fragment,e),Bt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-whkli4"&&(te.textContent=ln),Zt=a(e),u(le.$$.fragment,e),kt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-grnb59"&&(ne.textContent=nn),$t=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-ahtq0i"&&(se.innerHTML=sn),Wt=a(e),ae=o(e,"OL",{"data-svelte-h":!0}),p(ae)!=="svelte-1vlvy45"&&(ae.innerHTML=an),At=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1h3g1zs"&&(ie.textContent=on),Et=a(e),u(oe.$$.fragment,e),Gt=a(e),u(pe.$$.fragment,e),Vt=a(e),Me=o(e,"OL",{"data-svelte-h":!0}),p(Me)!=="svelte-uvtwg2"&&(Me.innerHTML=pn),Rt=a(e),u(re.$$.fragment,e),St=a(e),u(ue.$$.fragment,e),_t=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-r3242t"&&(ce.innerHTML=Mn),Nt=a(e),u(ye.$$.fragment,e),Qt=a(e),u(v.$$.fragment,e),Ht=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-jrgx8f"&&(we.innerHTML=rn),Yt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-8sir7q"&&(Je.textContent=un),Xt=a(e),B=o(e,"P",{align:!0,"data-svelte-h":!0}),p(B)!=="svelte-11rtdvt"&&(B.innerHTML=cn),qt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-ofpo9r"&&(de.innerHTML=yn),Ft=a(e),u(me.$$.fragment,e),zt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-geglm0"&&(Te.textContent=wn),Lt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1iycphr"&&(Ue.textContent=Jn),Pt=a(e),u(he.$$.fragment,e),Dt=a(e),u(be.$$.fragment,e),Kt=a(e),u(je.$$.fragment,e),Ot=a(e),Ie=o(e,"OL",{"data-svelte-h":!0}),p(Ie)!=="svelte-19h0avy"&&(Ie.innerHTML=dn),el=a(e),u(ge.$$.fragment,e),tl=a(e),u(fe.$$.fragment,e),ll=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1j9zoi1"&&(Ce.innerHTML=mn),nl=a(e),u(xe.$$.fragment,e),sl=a(e),u(Z.$$.fragment,e),al=a(e),u(ve.$$.fragment,e),il=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-t1it0d"&&(Be.textContent=Tn),ol=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1lygj8"&&(Ze.textContent=Un),pl=a(e),u(ke.$$.fragment,e),Ml=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-8mtm8c"&&($e.textContent=hn),rl=a(e),u(We.$$.fragment,e),ul=a(e),u(Ae.$$.fragment,e),cl=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-ozg6k5"&&(Ee.textContent=bn),yl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1f0518g"&&(Ge.innerHTML=jn),wl=a(e),u(Ve.$$.fragment,e),Jl=a(e),Re=o(e,"OL",{"data-svelte-h":!0}),p(Re)!=="svelte-18eum27"&&(Re.innerHTML=In),dl=a(e),u(Se.$$.fragment,e),ml=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-zmyq9d"&&(_e.innerHTML=gn),Tl=a(e),u(Ne.$$.fragment,e),Ul=a(e),u(Qe.$$.fragment,e),hl=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-5fyo5r"&&(He.textContent=fn),bl=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-162p62u"&&(Ye.innerHTML=Cn),jl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1hbg2e4"&&(Xe.textContent=xn),Il=a(e),u(qe.$$.fragment,e),gl=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-i4top7"&&(Fe.textContent=vn),fl=a(e),u(ze.$$.fragment,e),Cl=a(e),Le=o(e,"UL",{"data-svelte-h":!0}),p(Le)!=="svelte-8oe7h4"&&(Le.innerHTML=Bn),xl=a(e),u(Pe.$$.fragment,e),vl=a(e),De=o(e,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-1nt0hab"&&(De.innerHTML=Zn),Bl=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-l1ns7z"&&(Ke.textContent=kn),Zl=a(e),u(Oe.$$.fragment,e),kl=a(e),lt=o(e,"P",{}),Vn(lt).forEach(l),this.h()},h(){nt(M,"name","hf:doc:metadata"),nt(M,"content",Dn),Gn(et.src,_l="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||nt(et,"src",_l),Gn(tt.src,Pl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||nt(tt,"src",Pl),nt(B,"align","center")},m(e,t){Hn(document.head,M),n(e,h,t),n(e,d,t),n(e,U,t),c(I,e,t),n(e,f,t),c(b,e,t),n(e,k,t),c(m,e,t),n(e,g,t),c($,e,t),n(e,st,t),n(e,W,t),n(e,at,t),n(e,A,t),n(e,it,t),n(e,E,t),n(e,ot,t),n(e,G,t),n(e,pt,t),n(e,V,t),n(e,Mt,t),n(e,et,t),n(e,rt,t),n(e,R,t),n(e,ut,t),c(S,e,t),n(e,ct,t),n(e,_,t),n(e,yt,t),n(e,N,t),n(e,wt,t),n(e,Q,t),n(e,Jt,t),n(e,H,t),n(e,dt,t),n(e,Y,t),n(e,mt,t),n(e,X,t),n(e,Tt,t),n(e,q,t),n(e,Ut,t),n(e,F,t),n(e,ht,t),n(e,tt,t),n(e,bt,t),c(z,e,t),n(e,jt,t),n(e,L,t),n(e,It,t),n(e,P,t),n(e,gt,t),n(e,D,t),n(e,ft,t),n(e,K,t),n(e,Ct,t),c(O,e,t),n(e,xt,t),n(e,ee,t),n(e,vt,t),c(x,e,t),n(e,Bt,t),n(e,te,t),n(e,Zt,t),c(le,e,t),n(e,kt,t),n(e,ne,t),n(e,$t,t),n(e,se,t),n(e,Wt,t),n(e,ae,t),n(e,At,t),n(e,ie,t),n(e,Et,t),c(oe,e,t),n(e,Gt,t),c(pe,e,t),n(e,Vt,t),n(e,Me,t),n(e,Rt,t),c(re,e,t),n(e,St,t),c(ue,e,t),n(e,_t,t),n(e,ce,t),n(e,Nt,t),c(ye,e,t),n(e,Qt,t),c(v,e,t),n(e,Ht,t),n(e,we,t),n(e,Yt,t),n(e,Je,t),n(e,Xt,t),n(e,B,t),n(e,qt,t),n(e,de,t),n(e,Ft,t),c(me,e,t),n(e,zt,t),n(e,Te,t),n(e,Lt,t),n(e,Ue,t),n(e,Pt,t),c(he,e,t),n(e,Dt,t),c(be,e,t),n(e,Kt,t),c(je,e,t),n(e,Ot,t),n(e,Ie,t),n(e,el,t),c(ge,e,t),n(e,tl,t),c(fe,e,t),n(e,ll,t),n(e,Ce,t),n(e,nl,t),c(xe,e,t),n(e,sl,t),c(Z,e,t),n(e,al,t),c(ve,e,t),n(e,il,t),n(e,Be,t),n(e,ol,t),n(e,Ze,t),n(e,pl,t),c(ke,e,t),n(e,Ml,t),n(e,$e,t),n(e,rl,t),c(We,e,t),n(e,ul,t),c(Ae,e,t),n(e,cl,t),n(e,Ee,t),n(e,yl,t),n(e,Ge,t),n(e,wl,t),c(Ve,e,t),n(e,Jl,t),n(e,Re,t),n(e,dl,t),c(Se,e,t),n(e,ml,t),n(e,_e,t),n(e,Tl,t),c(Ne,e,t),n(e,Ul,t),c(Qe,e,t),n(e,hl,t),n(e,He,t),n(e,bl,t),n(e,Ye,t),n(e,jl,t),n(e,Xe,t),n(e,Il,t),c(qe,e,t),n(e,gl,t),n(e,Fe,t),n(e,fl,t),c(ze,e,t),n(e,Cl,t),n(e,Le,t),n(e,xl,t),c(Pe,e,t),n(e,vl,t),n(e,De,t),n(e,Bl,t),n(e,Ke,t),n(e,Zl,t),c(Oe,e,t),n(e,kl,t),n(e,lt,t),$l=!0},p(e,[t]){const $n={};t&2&&($n.$$scope={dirty:t,ctx:e}),m.$set($n);const Wn={};t&2&&(Wn.$$scope={dirty:t,ctx:e}),x.$set(Wn);const An={};t&2&&(An.$$scope={dirty:t,ctx:e}),v.$set(An);const En={};t&2&&(En.$$scope={dirty:t,ctx:e}),Z.$set(En)},i(e){$l||(y(I.$$.fragment,e),y(b.$$.fragment,e),y(m.$$.fragment,e),y($.$$.fragment,e),y(S.$$.fragment,e),y(z.$$.fragment,e),y(O.$$.fragment,e),y(x.$$.fragment,e),y(le.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(ue.$$.fragment,e),y(ye.$$.fragment,e),y(v.$$.fragment,e),y(me.$$.fragment,e),y(he.$$.fragment,e),y(be.$$.fragment,e),y(je.$$.fragment,e),y(ge.$$.fragment,e),y(fe.$$.fragment,e),y(xe.$$.fragment,e),y(Z.$$.fragment,e),y(ve.$$.fragment,e),y(ke.$$.fragment,e),y(We.$$.fragment,e),y(Ae.$$.fragment,e),y(Ve.$$.fragment,e),y(Se.$$.fragment,e),y(Ne.$$.fragment,e),y(Qe.$$.fragment,e),y(qe.$$.fragment,e),y(ze.$$.fragment,e),y(Pe.$$.fragment,e),y(Oe.$$.fragment,e),$l=!0)},o(e){w(I.$$.fragment,e),w(b.$$.fragment,e),w(m.$$.fragment,e),w($.$$.fragment,e),w(S.$$.fragment,e),w(z.$$.fragment,e),w(O.$$.fragment,e),w(x.$$.fragment,e),w(le.$$.fragment,e),w(oe.$$.fragment,e),w(pe.$$.fragment,e),w(re.$$.fragment,e),w(ue.$$.fragment,e),w(ye.$$.fragment,e),w(v.$$.fragment,e),w(me.$$.fragment,e),w(he.$$.fragment,e),w(be.$$.fragment,e),w(je.$$.fragment,e),w(ge.$$.fragment,e),w(fe.$$.fragment,e),w(xe.$$.fragment,e),w(Z.$$.fragment,e),w(ve.$$.fragment,e),w(ke.$$.fragment,e),w(We.$$.fragment,e),w(Ae.$$.fragment,e),w(Ve.$$.fragment,e),w(Se.$$.fragment,e),w(Ne.$$.fragment,e),w(Qe.$$.fragment,e),w(qe.$$.fragment,e),w(ze.$$.fragment,e),w(Pe.$$.fragment,e),w(Oe.$$.fragment,e),$l=!1},d(e){e&&(l(h),l(d),l(U),l(f),l(k),l(g),l(st),l(W),l(at),l(A),l(it),l(E),l(ot),l(G),l(pt),l(V),l(Mt),l(et),l(rt),l(R),l(ut),l(ct),l(_),l(yt),l(N),l(wt),l(Q),l(Jt),l(H),l(dt),l(Y),l(mt),l(X),l(Tt),l(q),l(Ut),l(F),l(ht),l(tt),l(bt),l(jt),l(L),l(It),l(P),l(gt),l(D),l(ft),l(K),l(Ct),l(xt),l(ee),l(vt),l(Bt),l(te),l(Zt),l(kt),l(ne),l($t),l(se),l(Wt),l(ae),l(At),l(ie),l(Et),l(Gt),l(Vt),l(Me),l(Rt),l(St),l(_t),l(ce),l(Nt),l(Qt),l(Ht),l(we),l(Yt),l(Je),l(Xt),l(B),l(qt),l(de),l(Ft),l(zt),l(Te),l(Lt),l(Ue),l(Pt),l(Dt),l(Kt),l(Ot),l(Ie),l(el),l(tl),l(ll),l(Ce),l(nl),l(sl),l(al),l(il),l(Be),l(ol),l(Ze),l(pl),l(Ml),l($e),l(rl),l(ul),l(cl),l(Ee),l(yl),l(Ge),l(wl),l(Jl),l(Re),l(dl),l(ml),l(_e),l(Tl),l(Ul),l(hl),l(He),l(bl),l(Ye),l(jl),l(Xe),l(Il),l(gl),l(Fe),l(fl),l(Cl),l(Le),l(xl),l(vl),l(De),l(Bl),l(Ke),l(Zl),l(kl),l(lt)),l(M),J(I,e),J(b,e),J(m,e),J($,e),J(S,e),J(z,e),J(O,e),J(x,e),J(le,e),J(oe,e),J(pe,e),J(re,e),J(ue,e),J(ye,e),J(v,e),J(me,e),J(he,e),J(be,e),J(je,e),J(ge,e),J(fe,e),J(xe,e),J(Z,e),J(ve,e),J(ke,e),J(We,e),J(Ae,e),J(Ve,e),J(Se,e),J(Ne,e),J(Qe,e),J(qe,e),J(ze,e),J(Pe,e),J(Oe,e)}}}const Dn='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Docker: quick start","local":"running-your-agent-in-docker-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"WebAssembly setup","local":"webassembly-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in WebAssembly: quick start","local":"running-your-agent-in-webassembly-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function Kn(j){return Sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends _n{constructor(M){super(),Nn(this,M,Kn,Pn,Rn,{})}}export{as as component};
