import{s as aa,n as ta,o as sa}from"../chunks/scheduler.71ff668b.js";import{S as la,i as na,g as o,s as l,r as d,A as oa,h as i,f as t,c as n,j as Ke,u as p,x as r,k as ea,y as ia,a as s,v as m,d as c,t as u,w as f}from"../chunks/index.e0973da1.js";import{C as Ee}from"../chunks/CodeBlock.0c9622a3.js";import{C as ra}from"../chunks/CourseFloatingBanner.69eb4e28.js";import{H as M,E as da}from"../chunks/getInferenceSnippets.9b061786.js";function pa(Fe){let y,O,Y,K,b,ee,T,ae,J,ke="LoRA (Low-Rank Adaptation) se ha convertido en el método PEFT más utilizado. Su funcionamiento se basa en añadir matrices de descomposición de rango reducido a los pesos de atención, lo que suele reducir los parámetros entrenables en un 90%.",te,w,se,g,Le='LoRA es una técnica de fine-tuning eficiente en parámetros que congela los pesos del modelo preentrenado e inyecta matrices entrenables de descomposición de rango reducido en las capas del modelo. En lugar de entrenar todos los parámetros del modelo durante el fine-tuning, LoRA descompone las actualizaciones de los pesos en matrices más pequeñas mediante descomposición de rango, reduciendo significativamente la cantidad de parámetros entrenables mientras mantiene el rendimiento del modelo. Por ejemplo, se ha aplicado a GPT-3 175B. LoRA redujo los parámetros entrenables 10 000 veces y los requerimientos de memoria de GPU 3 veces en comparación con el fine-tuning completo. Puedes leer más sobre LoRA en el <a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">paper de LoRA</a>.',le,U,Ae="LoRA funciona añadiendo pares de matrices de descomposición de rango reducido a las capas del transformador, normalmente enfocándose en los pesos de atención. Durante la inferencia, estos pesos adaptadores pueden fusionarse con el modelo base, lo que elimina la sobrecarga de latencia adicional. LoRA es especialmente útil para adaptar modelos de lenguaje grandes a tareas o dominios específicos mientras se mantienen requisitos de recursos manejables.",ne,v,oe,$,Ve="Se pueden cargar adaptadores en un modelo preentrenado utilizando <code>load_adapter()</code>, lo cual es útil para probar diferentes adaptadores cuyos pesos no están fusionados. Se pueden establecer los pesos de los adaptadores activos con la función <code>set_adapter()</code>. Para devolver el modelo base, se puede usar <code>unload()</code> para descargar todos los módulos de LoRA. Esto permite cambiar fácilmente entre diferentes pesos específicos de tareas.",ie,h,re,j,xe='<img src="./images/lora_adapter.png" alt="lora_load_adapter"/>',de,Z,pe,C,Qe="Después de entrenar con LoRA, podrías querer fusionar los pesos del adaptador de vuelta en el modelo base para facilitar su implementación. Esto crea un único modelo con los pesos combinados, eliminando la necesidad de cargar adaptadores por separado durante la inferencia.",me,_,We="El proceso de fusión requiere atención al manejo de memoria y precisión. Como necesitarás cargar tanto el modelo base como los pesos del adaptador simultáneamente, asegúrate de tener suficiente memoria GPU/CPU disponible. Usar <code>device_map=&quot;auto&quot;</code> en <code>transformers</code> ayudará con el manejo automático de memoria. Mantén una precisión consistente (por ejemplo, <code>float16</code>) durante todo el proceso, y guarda el modelo fusionado en el mismo formato para su implementación. Antes de implementar, siempre valida el modelo fusionado comparando sus salidas y métricas de rendimiento con la versión basada en adaptadores.",ce,G,Xe="Los adaptadores también son convenientes para cambiar entre diferentes tareas o dominios. Puedes cargar el modelo base y los pesos del adaptador por separado, permitiendo un cambio rápido entre diferentes pesos específicos de tareas.",ue,R,fe,B,ze="El directorio <code>notebooks/</code> contiene tutoriales prácticos y ejercicios para implementar diferentes métodos PEFT. Comienza con <code>load_lora_adapter_example.ipynb</code> para una introducción básica, y luego explora <code>lora_finetuning.ipynb</code> para un análisis más detallado de cómo realizar fine-tuning en un modelo con LoRA y SFT.",Me,I,Ne="Cuando implementes métodos PEFT, comienza con valores de rango pequeños (4-8) para LoRA y monitoriza la pérdida durante el entrenamiento. Utiliza conjuntos de validación para evitar el sobreajuste y compara los resultados con los baselines del fine-tuning completo cuando sea posible. La efectividad de los diferentes métodos puede variar según la tarea, por lo que la experimentación es clave.",ye,E,be,F,qe='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utiliza descomposición QR para inicializar los adaptadores LoRA. OLoRA traduce los pesos base del modelo por un factor de sus descomposiciones QR, es decir, muta los pesos antes de realizar cualquier entrenamiento sobre ellos. Este enfoque mejora significativamente la estabilidad, acelera la velocidad de convergencia y logra un rendimiento superior.',Te,k,Je,L,Pe="Los métodos PEFT pueden combinarse con TRL (Transformers Reinforcement Learning) para un fine-tuning eficiente. Esta integración es particularmente útil para RLHF (Reinforcement Learning from Human Feedback), ya que reduce los requisitos de memoria.",we,A,ge,V,Se="Aquí, usamos <code>device_map=&quot;auto&quot;</code> para asignar automáticamente el modelo al dispositivo correcto. También puedes asignar manualmente el modelo a un dispositivo específico usando <code>device_map={&quot;&quot;: device_index}</code>. Además, podrías escalar el entrenamiento en múltiples GPUs mientras mantienes un uso eficiente de memoria.",Ue,x,ve,Q,He="Después de entrenar un adaptador LoRA, puedes fusionar los pesos del adaptador de vuelta en el modelo base. Aquí tienes cómo hacerlo:",$e,W,he,X,Ye="Si encuentras discrepancias de tamaño en el modelo guardado, asegúrate de guardar también el tokenizer:",je,z,Ze,N,Ce,q,De=`⏩ Pasa al <a href="prompt_tuning.md">Prompt Tuning</a> para aprender a realizar fine-tuning en un modelo con prompt tuning.<br/>
⏩ Revisa el <a href="../../../notebooks/es/3_parameter_efficient_finetuning/load_lora_adapter.ipynb">Tutorial de Carga de Adaptadores LoRA</a> para aprender a cargar adaptadores LoRA.`,_e,P,Ge,S,Oe='<li><a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LORA: ADAPTACIÓN DE BAJO RANGO PARA MODELOS DE LENGUAJE DE GRAN TAMAÑO</a></li> <li><a href="https://huggingface.co/docs/peft" rel="nofollow">Documentación de PEFT</a></li> <li><a href="https://huggingface.co/blog/peft" rel="nofollow">Publicación en el blog de Hugging Face sobre PEFT</a></li>',Re,H,Be,D,Ie;return b=new M({props:{title:"LoRA (Adaptación de Bajo Rango)",local:"lora-adaptación-de-bajo-rango",headingTag:"h1"}}),T=new ra({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/es/3_parameter_efficient_finetuning/finetune_sft_peft.ipynb"}]}}),w=new M({props:{title:"Entendiendo LoRA",local:"entendiendo-lora",headingTag:"h2"}}),v=new M({props:{title:"Cargando adaptadores LoRA",local:"cargando-adaptadores-lora",headingTag:"h2"}}),h=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ2Jhc2VfbW9kZWxfbmFtZSUzRSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDcGVmdF9hZGFwdGVyX2lkJTNFJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;&lt;base_model_name&gt;&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;&lt;peft_adapter_id&gt;&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),Z=new M({props:{title:"Fusionando adaptadores LoRA",local:"fusionando-adaptadores-lora",headingTag:"h2"}}),R=new M({props:{title:"Guía de implementación",local:"guía-de-implementación",headingTag:"h2"}}),E=new M({props:{title:"OLoRA",local:"olora",headingTag:"h2"}}),k=new M({props:{title:"Usando TRL con PEFT",local:"usando-trl-con-peft",headingTag:"h2"}}),A=new Ee({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwQ2FyZ2ElMjBlbCUyMG1vZGVsbyUyMGNvbiUyMGNvbmZpZ3VyYWNpJUMzJUIzbiUyMFBFRlQlMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQSUyMyUyMENhcmdhJTIwZWwlMjBtb2RlbG8lMjBlbiUyMHVuJTIwZGlzcG9zaXRpdm8lMjBlc3BlYyVDMyVBRGZpY28lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ5b3VyLW1vZGVsLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwJTIwJTIzJTIwT3BjaW9uYWwlM0ElMjB1c2ElMjBsYSUyMHByZWNpc2klQzMlQjNuJTIwZGUlMjA4JTIwYml0cyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Carga el modelo con configuración PEFT</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

<span class="hljs-comment"># Carga el modelo en un dispositivo específico</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;your-model-name&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Opcional: usa la precisión de 8 bits</span>
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    peft_config=lora_config
)`,wrap:!1}}),x=new M({props:{title:"Implementación básica de fusión",local:"implementación-básica-de-fusión",headingTag:"h2"}}),W=new Ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQSUwQSUyMyUyMDEuJTIwQ2FyZ2ElMjBlbCUyMG1vZGVsbyUyMGJhc2UlMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJhc2VfbW9kZWxfbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKSUwQSUwQSUyMyUyMDIuJTIwQ2FyZ2ElMjBlbCUyMG1vZGVsbyUyMFBFRlQlMjBjb24lMjBhZGFwdGFkb3IlMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBiYXNlX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyRnRvJTJGYWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEElMjMlMjAzLiUyMEZ1c2lvbmElMjBsb3MlMjBwZXNvcyUyMGRlbCUyMGFkYXB0YWRvciUyMGNvbiUyMGVsJTIwbW9kZWxvJTIwYmFzZSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMG1lcmdlZF9tb2RlbCUyMCUzRCUyMHBlZnRfbW9kZWwubWVyZ2VfYW5kX3VubG9hZCgpJTBBZXhjZXB0JTIwUnVudGltZUVycm9yJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkZ1c2klQzMlQjNuJTIwZmFsbGlkYSUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW1wbGVtZW50YSUyMGVzdHJhdGVnaWElMjBkZSUyMHJlc3BhbGRvJTIwdSUyMG9wdGltaXphY2klQzMlQjNuJTIwZGUlMjBtZW1vcmlhJTBBJTBBJTIzJTIwNC4lMjBHdWFyZGElMjBlbCUyMG1vZGVsbyUyMGZ1c2lvbmFkbyUwQW1lcmdlZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZSUyRm1lcmdlZF9tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-comment"># 1. Carga el modelo base</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;base_model_name&quot;</span>,
    dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># 2. Carga el modelo PEFT con adaptador</span>
peft_model = PeftModel.from_pretrained(
    base_model,
    <span class="hljs-string">&quot;path/to/adapter&quot;</span>,
    dtype=torch.float16
)

<span class="hljs-comment"># 3. Fusiona los pesos del adaptador con el modelo base</span>
<span class="hljs-keyword">try</span>:
    merged_model = peft_model.merge_and_unload()
<span class="hljs-keyword">except</span> RuntimeError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Fusión fallida: <span class="hljs-subst">{e}</span>&quot;</span>)
    <span class="hljs-comment"># Implementa estrategia de respaldo u optimización de memoria</span>

<span class="hljs-comment"># 4. Guarda el modelo fusionado</span>
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),z=new Ee({props:{code:"JTIzJTIwR3VhcmRhJTIwdGFudG8lMjBlbCUyMG1vZGVsbyUyMGNvbW8lMjBlbCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJhc2VfbW9kZWxfbmFtZSUyMiklMEFtZXJnZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlJTJGbWVyZ2VkX21vZGVsJTIyKQ==",highlighted:`<span class="hljs-comment"># Guarda tanto el modelo como el tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;base_model_name&quot;</span>)
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),N=new M({props:{title:"Próximos pasos",local:"próximos-pasos",headingTag:"h2"}}),P=new M({props:{title:"Recursos",local:"recursos",headingTag:"h1"}}),H=new da({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/es/unit3/1.md"}}),{c(){y=o("meta"),O=l(),Y=o("p"),K=l(),d(b.$$.fragment),ee=l(),d(T.$$.fragment),ae=l(),J=o("p"),J.textContent=ke,te=l(),d(w.$$.fragment),se=l(),g=o("p"),g.innerHTML=Le,le=l(),U=o("p"),U.textContent=Ae,ne=l(),d(v.$$.fragment),oe=l(),$=o("p"),$.innerHTML=Ve,ie=l(),d(h.$$.fragment),re=l(),j=o("p"),j.innerHTML=xe,de=l(),d(Z.$$.fragment),pe=l(),C=o("p"),C.textContent=Qe,me=l(),_=o("p"),_.innerHTML=We,ce=l(),G=o("p"),G.textContent=Xe,ue=l(),d(R.$$.fragment),fe=l(),B=o("p"),B.innerHTML=ze,Me=l(),I=o("p"),I.textContent=Ne,ye=l(),d(E.$$.fragment),be=l(),F=o("p"),F.innerHTML=qe,Te=l(),d(k.$$.fragment),Je=l(),L=o("p"),L.textContent=Pe,we=l(),d(A.$$.fragment),ge=l(),V=o("p"),V.innerHTML=Se,Ue=l(),d(x.$$.fragment),ve=l(),Q=o("p"),Q.textContent=He,$e=l(),d(W.$$.fragment),he=l(),X=o("p"),X.textContent=Ye,je=l(),d(z.$$.fragment),Ze=l(),d(N.$$.fragment),Ce=l(),q=o("p"),q.innerHTML=De,_e=l(),d(P.$$.fragment),Ge=l(),S=o("ul"),S.innerHTML=Oe,Re=l(),d(H.$$.fragment),Be=l(),D=o("p"),this.h()},l(e){const a=oa("svelte-u9bgzb",document.head);y=i(a,"META",{name:!0,content:!0}),a.forEach(t),O=n(e),Y=i(e,"P",{}),Ke(Y).forEach(t),K=n(e),p(b.$$.fragment,e),ee=n(e),p(T.$$.fragment,e),ae=n(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-g9m6d2"&&(J.textContent=ke),te=n(e),p(w.$$.fragment,e),se=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1a5i4hw"&&(g.innerHTML=Le),le=n(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-jv6h67"&&(U.textContent=Ae),ne=n(e),p(v.$$.fragment,e),oe=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1v5199z"&&($.innerHTML=Ve),ie=n(e),p(h.$$.fragment,e),re=n(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1ljdidi"&&(j.innerHTML=xe),de=n(e),p(Z.$$.fragment,e),pe=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-17e0k6j"&&(C.textContent=Qe),me=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-q5zzho"&&(_.innerHTML=We),ce=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-3tl0uu"&&(G.textContent=Xe),ue=n(e),p(R.$$.fragment,e),fe=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-j906k1"&&(B.innerHTML=ze),Me=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-5xxsyd"&&(I.textContent=Ne),ye=n(e),p(E.$$.fragment,e),be=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ofladb"&&(F.innerHTML=qe),Te=n(e),p(k.$$.fragment,e),Je=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-hbin6i"&&(L.textContent=Pe),we=n(e),p(A.$$.fragment,e),ge=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1i29fjo"&&(V.innerHTML=Se),Ue=n(e),p(x.$$.fragment,e),ve=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-o1h1i1"&&(Q.textContent=He),$e=n(e),p(W.$$.fragment,e),he=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-7gwx0l"&&(X.textContent=Ye),je=n(e),p(z.$$.fragment,e),Ze=n(e),p(N.$$.fragment,e),Ce=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1mijf4e"&&(q.innerHTML=De),_e=n(e),p(P.$$.fragment,e),Ge=n(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-ula8i1"&&(S.innerHTML=Oe),Re=n(e),p(H.$$.fragment,e),Be=n(e),D=i(e,"P",{}),Ke(D).forEach(t),this.h()},h(){ea(y,"name","hf:doc:metadata"),ea(y,"content",ma)},m(e,a){ia(document.head,y),s(e,O,a),s(e,Y,a),s(e,K,a),m(b,e,a),s(e,ee,a),m(T,e,a),s(e,ae,a),s(e,J,a),s(e,te,a),m(w,e,a),s(e,se,a),s(e,g,a),s(e,le,a),s(e,U,a),s(e,ne,a),m(v,e,a),s(e,oe,a),s(e,$,a),s(e,ie,a),m(h,e,a),s(e,re,a),s(e,j,a),s(e,de,a),m(Z,e,a),s(e,pe,a),s(e,C,a),s(e,me,a),s(e,_,a),s(e,ce,a),s(e,G,a),s(e,ue,a),m(R,e,a),s(e,fe,a),s(e,B,a),s(e,Me,a),s(e,I,a),s(e,ye,a),m(E,e,a),s(e,be,a),s(e,F,a),s(e,Te,a),m(k,e,a),s(e,Je,a),s(e,L,a),s(e,we,a),m(A,e,a),s(e,ge,a),s(e,V,a),s(e,Ue,a),m(x,e,a),s(e,ve,a),s(e,Q,a),s(e,$e,a),m(W,e,a),s(e,he,a),s(e,X,a),s(e,je,a),m(z,e,a),s(e,Ze,a),m(N,e,a),s(e,Ce,a),s(e,q,a),s(e,_e,a),m(P,e,a),s(e,Ge,a),s(e,S,a),s(e,Re,a),m(H,e,a),s(e,Be,a),s(e,D,a),Ie=!0},p:ta,i(e){Ie||(c(b.$$.fragment,e),c(T.$$.fragment,e),c(w.$$.fragment,e),c(v.$$.fragment,e),c(h.$$.fragment,e),c(Z.$$.fragment,e),c(R.$$.fragment,e),c(E.$$.fragment,e),c(k.$$.fragment,e),c(A.$$.fragment,e),c(x.$$.fragment,e),c(W.$$.fragment,e),c(z.$$.fragment,e),c(N.$$.fragment,e),c(P.$$.fragment,e),c(H.$$.fragment,e),Ie=!0)},o(e){u(b.$$.fragment,e),u(T.$$.fragment,e),u(w.$$.fragment,e),u(v.$$.fragment,e),u(h.$$.fragment,e),u(Z.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(k.$$.fragment,e),u(A.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(P.$$.fragment,e),u(H.$$.fragment,e),Ie=!1},d(e){e&&(t(O),t(Y),t(K),t(ee),t(ae),t(J),t(te),t(se),t(g),t(le),t(U),t(ne),t(oe),t($),t(ie),t(re),t(j),t(de),t(pe),t(C),t(me),t(_),t(ce),t(G),t(ue),t(fe),t(B),t(Me),t(I),t(ye),t(be),t(F),t(Te),t(Je),t(L),t(we),t(ge),t(V),t(Ue),t(ve),t(Q),t($e),t(he),t(X),t(je),t(Ze),t(Ce),t(q),t(_e),t(Ge),t(S),t(Re),t(Be),t(D)),t(y),f(b,e),f(T,e),f(w,e),f(v,e),f(h,e),f(Z,e),f(R,e),f(E,e),f(k,e),f(A,e),f(x,e),f(W,e),f(z,e),f(N,e),f(P,e),f(H,e)}}}const ma='{"title":"LoRA (Adaptación de Bajo Rango)","local":"lora-adaptación-de-bajo-rango","sections":[{"title":"Entendiendo LoRA","local":"entendiendo-lora","sections":[],"depth":2},{"title":"Cargando adaptadores LoRA","local":"cargando-adaptadores-lora","sections":[],"depth":2},{"title":"Fusionando adaptadores LoRA","local":"fusionando-adaptadores-lora","sections":[],"depth":2},{"title":"Guía de implementación","local":"guía-de-implementación","sections":[],"depth":2},{"title":"OLoRA","local":"olora","sections":[],"depth":2},{"title":"Usando TRL con PEFT","local":"usando-trl-con-peft","sections":[],"depth":2},{"title":"Implementación básica de fusión","local":"implementación-básica-de-fusión","sections":[],"depth":2},{"title":"Próximos pasos","local":"próximos-pasos","sections":[],"depth":2}],"depth":1}';function ca(Fe){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends la{constructor(y){super(),na(this,y,ca,pa,aa,{})}}export{Ta as component};
