import{s as ot,n as rt,o as pt}from"../chunks/scheduler.3e4cb221.js";import{S as mt,i as dt,g as i,s as n,r as p,A as Mt,h as o,f as l,c as s,j as it,u as m,x as r,k as Ge,y as ft,a,v as d,d as M,t as f,w as h}from"../chunks/index.e1c70545.js";import{C as ee}from"../chunks/CodeBlock.72e9ab19.js";import{H as c,E as ht}from"../chunks/getInferenceSnippets.62bbd402.js";function ct(Qe){let u,te,K,le,w,ae,g,Ve="Parameter-Efficient Fine-Tuning (PEFT) lets you adapt large models by training a small number of additional parameters while keeping the base model frozen. The most widely used PEFT method is LoRA (Low-Rank Adaptation), which injects trainable low-rank updates into linear layers. This often reduces trainable parameters by ~90% while preserving performance.",ne,T,se,b,Xe="<li>You have limited compute or memory budget</li> <li>You need to quickly adapt a base model to multiple tasks/domains</li> <li>You want fast iteration and small artifacts (adapter weights are usually a few MB)</li>",ie,j,oe,J,xe="LoRA has become the most widely adopted PEFT method. It works by adding small rank decomposition matrices to the attention weights, typically reducing trainable parameters by about 90%.",re,U,qe='LoRA (Low-Rank Adaptation) is a parameter-efficient fine-tuning technique that freezes the pre-trained model weights and injects trainable rank decomposition matrices into the model’s layers. Instead of training all model parameters during fine-tuning, LoRA decomposes the weight updates into smaller matrices through low-rank decomposition, significantly reducing the number of trainable parameters while maintaining model performance. For example, when applied to GPT-3 175B, LoRA reduced trainable parameters by 10,000x and GPU memory requirements by 3x compared to full fine-tuning. You can read more about LoRA in the <a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LoRA paper</a>.',pe,Z,He="LoRA works by adding pairs of rank decomposition matrices to transformer layers, typically focusing on attention weights. During inference, these adapter weights can be merged with the base model, resulting in no additional latency overhead. LoRA is particularly useful for adapting large language models to specific tasks or domains while keeping resource requirements manageable.",me,R,de,v,Se="Adapters can be loaded onto a pretrained model with load_adapter(), which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the set_adapter() function. To return the base model, you could use unload() to unload all of the LoRA modules. This makes it easy to switch between different task-specific weights.",Me,$,fe,k,Ye='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/lora_adapter.png" alt="lora_load_adapter"/>',he,C,ce,B,Pe="After training with LoRA, you might want to merge the adapter weights back into the base model for easier deployment. This creates a single model with the combined weights, eliminating the need to load adapters separately during inference.",ue,F,ze="The merging process requires attention to memory management and precision. Since you’ll need to load both the base model and adapter weights simultaneously, ensure sufficient GPU/CPU memory is available. Using <code>device_map=&quot;auto&quot;</code> in <code>transformers</code> will help with automatic memory management. Maintain consistent precision (e.g., float16) throughout the process, matching the precision used during training and saving the merged model in the same format for deployment. Before deploying, always validate the merged model by comparing its outputs and performance metrics with the adapter-based version.",ye,E,Ne="Adapters are also be convenient for switching between different tasks or domains. You can load the base model and adapter weights separately. This allows for quick switching between different task-specific weights.",we,y,De="<p>When implementing PEFT methods, start with small rank values (4-8) for LoRA and monitor training loss. Use validation sets to prevent overfitting and compare results with full fine-tuning baselines when possible. The effectiveness of different methods can vary by task, so experimentation is key.</p>",ge,_,Te,A,Ke='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',be,I,je,L,Oe="PEFT methods can be combined with TRL (Transformers Reinforcement Learning) for efficient fine-tuning. This integration is particularly useful for RLHF (Reinforcement Learning from Human Feedback) as it reduces memory requirements.",Je,W,Ue,G,Ze,Q,et="After training a LoRA adapter, you can merge the adapter weights back into the base model. Here’s how to do it:",Re,V,ve,X,tt="If you encounter size discrepancies in the saved model, ensure you’re also saving the tokenizer:",$e,x,ke,q,Ce,H,lt="The TRL <code>SFTTrainer</code> integrates natively with PEFT. Define a <code>LoraConfig</code>, pass it to the trainer, and train only the adapter weights.",Be,S,Fe,Y,at="After training, you can either:",Ee,P,nt="<li>Load adapters at inference time alongside the base model, or</li> <li>Merge adapters into the base model for simplified deployment.</li>",_e,z,Ae,N,st='<li><a href="https://huggingface.co/papers/2106.09685" rel="nofollow">LoRA: Low-Rank Adaptation of Large Language Models</a></li> <li><a href="https://huggingface.co/docs/peft" rel="nofollow">PEFT Documentation</a></li> <li><a href="https://huggingface.co/blog/peft" rel="nofollow">Hugging Face blog post on PEFT</a></li>',Ie,D,Le,O,We;return w=new c({props:{title:"LoRA and PEFT: Efficient Fine-Tuning",local:"lora-and-peft-efficient-fine-tuning",headingTag:"h1"}}),T=new c({props:{title:"When to use PEFT",local:"when-to-use-peft",headingTag:"h2"}}),j=new c({props:{title:"Understanding LoRA",local:"understanding-lora",headingTag:"h2"}}),R=new c({props:{title:"Loading LoRA Adapters",local:"loading-lora-adapters",headingTag:"h2"}}),$=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ2Jhc2VfbW9kZWxfbmFtZSUzRSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDcGVmdF9hZGFwdGVyX2lkJTNFJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;&lt;base_model_name&gt;&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;&lt;peft_adapter_id&gt;&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),C=new c({props:{title:"Merging LoRA Adapters",local:"merging-lora-adapters",headingTag:"h2"}}),_=new c({props:{title:"OLoRA",local:"olora",headingTag:"h2"}}),I=new c({props:{title:"Using TRL with PEFT",local:"using-trl-with-peft",headingTag:"h2"}}),W=new ee({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMjB3aXRoJTIwUEVGVCUyMGNvbmZpZyUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ5b3VyLW1vZGVsLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

<span class="hljs-comment"># Load model with PEFT config</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

trainer = SFTTrainer(
    model=<span class="hljs-string">&quot;your-model-name&quot;</span>,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>]
    peft_config=lora_config
)`,wrap:!1}}),G=new c({props:{title:"Basic Merging Implementation",local:"basic-merging-implementation",headingTag:"h2"}}),V=new ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQSUwQSUyMyUyMDEuJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbF9uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKSUwQSUwQSUyMyUyMDIuJTIwTG9hZCUyMHRoZSUyMFBFRlQlMjBtb2RlbCUyMHdpdGglMjBhZGFwdGVyJTBBcGVmdF9tb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwYmFzZV9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRmFkYXB0ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQSUyMyUyMDMuJTIwTWVyZ2UlMjBhZGFwdGVyJTIwd2VpZ2h0cyUyMHdpdGglMjBiYXNlJTIwbW9kZWwlMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtZXJnZWRfbW9kZWwlMjAlM0QlMjBwZWZ0X21vZGVsLm1lcmdlX2FuZF91bmxvYWQoKSUwQWV4Y2VwdCUyMFJ1bnRpbWVFcnJvciUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJNZXJnaW5nJTIwZmFpbGVkJTNBJTIwJTdCZSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjMlMjBJbXBsZW1lbnQlMjBmYWxsYmFjayUyMHN0cmF0ZWd5JTIwb3IlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEElMEElMjMlMjA0LiUyMFNhdmUlMjB0aGUlMjBtZXJnZWQlMjBtb2RlbCUwQW1lcmdlZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZSUyRm1lcmdlZF9tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-comment"># 1. Load the base model</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;base_model_name&quot;</span>,
    dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># 2. Load the PEFT model with adapter</span>
peft_model = PeftModel.from_pretrained(
    base_model,
    <span class="hljs-string">&quot;path/to/adapter&quot;</span>,
    dtype=torch.bfloat16
)

<span class="hljs-comment"># 3. Merge adapter weights with base model</span>
<span class="hljs-keyword">try</span>:
    merged_model = peft_model.merge_and_unload()
<span class="hljs-keyword">except</span> RuntimeError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Merging failed: <span class="hljs-subst">{e}</span>&quot;</span>)
    <span class="hljs-comment"># Implement fallback strategy or memory optimization</span>

<span class="hljs-comment"># 4. Save the merged model</span>
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),x=new ee({props:{code:"JTIzJTIwU2F2ZSUyMGJvdGglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJhc2VfbW9kZWxfbmFtZSUyMiklMEFtZXJnZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlJTJGbWVyZ2VkX21vZGVsJTIyKQ==",highlighted:`<span class="hljs-comment"># Save both model and tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;base_model_name&quot;</span>)
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),q=new c({props:{title:"Quick start with TRL + LoRA",local:"quick-start-with-trl--lora",headingTag:"h2"}}),S=new ee({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMkMlMjBTRlRDb25maWclMEElMEElMjMlMjAxKSUyMENvbmZpZ3VyZSUyMExvUkElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBJTIzJTIwMiklMjBDcmVhdGUlMjB0cmFpbmVyJTIwKGV4YW1wbGUpJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcob3V0cHV0X2RpciUzRCUyMmxvcmEtYWRhcHRlciUyMiUyQyUyMG51bV90cmFpbl9lcG9jaHMlM0QxJTJDJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEMiUyQyUyMHBhY2tpbmclM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRHBlZnRfY29uZmlnJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig

<span class="hljs-comment"># 1) Configure LoRA</span>
peft_config = LoraConfig(
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># 2) Create trainer (example)</span>
trainer = SFTTrainer(
    model=model,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;lora-adapter&quot;</span>, num_train_epochs=<span class="hljs-number">1</span>, per_device_train_batch_size=<span class="hljs-number">2</span>, packing=<span class="hljs-literal">True</span>),
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    peft_config=peft_config,
)
trainer.train()`,wrap:!1}}),z=new c({props:{title:"Resources",local:"resources",headingTag:"h1"}}),D=new ht({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/3a.md"}}),{c(){u=i("meta"),te=n(),K=i("p"),le=n(),p(w.$$.fragment),ae=n(),g=i("p"),g.textContent=Ve,ne=n(),p(T.$$.fragment),se=n(),b=i("ul"),b.innerHTML=Xe,ie=n(),p(j.$$.fragment),oe=n(),J=i("p"),J.textContent=xe,re=n(),U=i("p"),U.innerHTML=qe,pe=n(),Z=i("p"),Z.textContent=He,me=n(),p(R.$$.fragment),de=n(),v=i("p"),v.textContent=Se,Me=n(),p($.$$.fragment),fe=n(),k=i("p"),k.innerHTML=Ye,he=n(),p(C.$$.fragment),ce=n(),B=i("p"),B.textContent=Pe,ue=n(),F=i("p"),F.innerHTML=ze,ye=n(),E=i("p"),E.textContent=Ne,we=n(),y=i("blockquote"),y.innerHTML=De,ge=n(),p(_.$$.fragment),Te=n(),A=i("p"),A.innerHTML=Ke,be=n(),p(I.$$.fragment),je=n(),L=i("p"),L.textContent=Oe,Je=n(),p(W.$$.fragment),Ue=n(),p(G.$$.fragment),Ze=n(),Q=i("p"),Q.textContent=et,Re=n(),p(V.$$.fragment),ve=n(),X=i("p"),X.textContent=tt,$e=n(),p(x.$$.fragment),ke=n(),p(q.$$.fragment),Ce=n(),H=i("p"),H.innerHTML=lt,Be=n(),p(S.$$.fragment),Fe=n(),Y=i("p"),Y.textContent=at,Ee=n(),P=i("ul"),P.innerHTML=nt,_e=n(),p(z.$$.fragment),Ae=n(),N=i("ul"),N.innerHTML=st,Ie=n(),p(D.$$.fragment),Le=n(),O=i("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),te=s(e),K=o(e,"P",{}),it(K).forEach(l),le=s(e),m(w.$$.fragment,e),ae=s(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-dj8rbr"&&(g.textContent=Ve),ne=s(e),m(T.$$.fragment,e),se=s(e),b=o(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-1mvsu7l"&&(b.innerHTML=Xe),ie=s(e),m(j.$$.fragment,e),oe=s(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-jvnjlq"&&(J.textContent=xe),re=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1nturj5"&&(U.innerHTML=qe),pe=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ore9lv"&&(Z.textContent=He),me=s(e),m(R.$$.fragment,e),de=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ykjqgo"&&(v.textContent=Se),Me=s(e),m($.$$.fragment,e),fe=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-vth2ay"&&(k.innerHTML=Ye),he=s(e),m(C.$$.fragment,e),ce=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-159k8bc"&&(B.textContent=Pe),ue=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-8mb6ny"&&(F.innerHTML=ze),ye=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-q31ewq"&&(E.textContent=Ne),we=s(e),y=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1lcqkpy"&&(y.innerHTML=De),ge=s(e),m(_.$$.fragment,e),Te=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-17kc0j8"&&(A.innerHTML=Ke),be=s(e),m(I.$$.fragment,e),je=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-6e2mqf"&&(L.textContent=Oe),Je=s(e),m(W.$$.fragment,e),Ue=s(e),m(G.$$.fragment,e),Ze=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1h2v14z"&&(Q.textContent=et),Re=s(e),m(V.$$.fragment,e),ve=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-j2a68t"&&(X.textContent=tt),$e=s(e),m(x.$$.fragment,e),ke=s(e),m(q.$$.fragment,e),Ce=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1o3osh"&&(H.innerHTML=lt),Be=s(e),m(S.$$.fragment,e),Fe=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-lzynm4"&&(Y.textContent=at),Ee=s(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-9cs1te"&&(P.innerHTML=nt),_e=s(e),m(z.$$.fragment,e),Ae=s(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1pr7vnp"&&(N.innerHTML=st),Ie=s(e),m(D.$$.fragment,e),Le=s(e),O=o(e,"P",{}),it(O).forEach(l),this.h()},h(){Ge(u,"name","hf:doc:metadata"),Ge(u,"content",ut),Ge(y,"class","tip")},m(e,t){ft(document.head,u),a(e,te,t),a(e,K,t),a(e,le,t),d(w,e,t),a(e,ae,t),a(e,g,t),a(e,ne,t),d(T,e,t),a(e,se,t),a(e,b,t),a(e,ie,t),d(j,e,t),a(e,oe,t),a(e,J,t),a(e,re,t),a(e,U,t),a(e,pe,t),a(e,Z,t),a(e,me,t),d(R,e,t),a(e,de,t),a(e,v,t),a(e,Me,t),d($,e,t),a(e,fe,t),a(e,k,t),a(e,he,t),d(C,e,t),a(e,ce,t),a(e,B,t),a(e,ue,t),a(e,F,t),a(e,ye,t),a(e,E,t),a(e,we,t),a(e,y,t),a(e,ge,t),d(_,e,t),a(e,Te,t),a(e,A,t),a(e,be,t),d(I,e,t),a(e,je,t),a(e,L,t),a(e,Je,t),d(W,e,t),a(e,Ue,t),d(G,e,t),a(e,Ze,t),a(e,Q,t),a(e,Re,t),d(V,e,t),a(e,ve,t),a(e,X,t),a(e,$e,t),d(x,e,t),a(e,ke,t),d(q,e,t),a(e,Ce,t),a(e,H,t),a(e,Be,t),d(S,e,t),a(e,Fe,t),a(e,Y,t),a(e,Ee,t),a(e,P,t),a(e,_e,t),d(z,e,t),a(e,Ae,t),a(e,N,t),a(e,Ie,t),d(D,e,t),a(e,Le,t),a(e,O,t),We=!0},p:rt,i(e){We||(M(w.$$.fragment,e),M(T.$$.fragment,e),M(j.$$.fragment,e),M(R.$$.fragment,e),M($.$$.fragment,e),M(C.$$.fragment,e),M(_.$$.fragment,e),M(I.$$.fragment,e),M(W.$$.fragment,e),M(G.$$.fragment,e),M(V.$$.fragment,e),M(x.$$.fragment,e),M(q.$$.fragment,e),M(S.$$.fragment,e),M(z.$$.fragment,e),M(D.$$.fragment,e),We=!0)},o(e){f(w.$$.fragment,e),f(T.$$.fragment,e),f(j.$$.fragment,e),f(R.$$.fragment,e),f($.$$.fragment,e),f(C.$$.fragment,e),f(_.$$.fragment,e),f(I.$$.fragment,e),f(W.$$.fragment,e),f(G.$$.fragment,e),f(V.$$.fragment,e),f(x.$$.fragment,e),f(q.$$.fragment,e),f(S.$$.fragment,e),f(z.$$.fragment,e),f(D.$$.fragment,e),We=!1},d(e){e&&(l(te),l(K),l(le),l(ae),l(g),l(ne),l(se),l(b),l(ie),l(oe),l(J),l(re),l(U),l(pe),l(Z),l(me),l(de),l(v),l(Me),l(fe),l(k),l(he),l(ce),l(B),l(ue),l(F),l(ye),l(E),l(we),l(y),l(ge),l(Te),l(A),l(be),l(je),l(L),l(Je),l(Ue),l(Ze),l(Q),l(Re),l(ve),l(X),l($e),l(ke),l(Ce),l(H),l(Be),l(Fe),l(Y),l(Ee),l(P),l(_e),l(Ae),l(N),l(Ie),l(Le),l(O)),l(u),h(w,e),h(T,e),h(j,e),h(R,e),h($,e),h(C,e),h(_,e),h(I,e),h(W,e),h(G,e),h(V,e),h(x,e),h(q,e),h(S,e),h(z,e),h(D,e)}}}const ut='{"title":"LoRA and PEFT: Efficient Fine-Tuning","local":"lora-and-peft-efficient-fine-tuning","sections":[{"title":"When to use PEFT","local":"when-to-use-peft","sections":[],"depth":2},{"title":"Understanding LoRA","local":"understanding-lora","sections":[],"depth":2},{"title":"Loading LoRA Adapters","local":"loading-lora-adapters","sections":[],"depth":2},{"title":"Merging LoRA Adapters","local":"merging-lora-adapters","sections":[],"depth":2},{"title":"OLoRA","local":"olora","sections":[],"depth":2},{"title":"Using TRL with PEFT","local":"using-trl-with-peft","sections":[],"depth":2},{"title":"Basic Merging Implementation","local":"basic-merging-implementation","sections":[],"depth":2},{"title":"Quick start with TRL + LoRA","local":"quick-start-with-trl--lora","sections":[],"depth":2}],"depth":1}';function yt(Qe){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends mt{constructor(u){super(),dt(this,u,yt,ct,ot,{})}}export{jt as component};
