import{s as gn,f as Un,n as fn,o as In}from"../chunks/scheduler.3e4cb221.js";import{S as jn,i as bn,g as i,s as n,r as M,A as Cn,h as o,f as l,c as a,j as ct,u as p,x as r,k as j,y as pt,a as s,v as m,d as u,t as d,w as c}from"../chunks/index.e1c70545.js";import{C as w}from"../chunks/CodeBlock.72e9ab19.js";import{C as $n}from"../chunks/CourseFloatingBanner.baa6815f.js";import{H as T,E as vn}from"../chunks/getInferenceSnippets.62bbd402.js";function Bn(ws){let J,yt,Tt,Jt,b,ht,C,gt,$,ys=`Welcome to the practical section! Here you’ll put into practice everything you’ve learned about vision language models (VLMs) using <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong>.<br/>
The exercises progress from foundational concepts to advanced techniques, helping you gain real-world, hands-on experience.`,Ut,v,ft,B,Js="By the end of these exercises, you will be able to:",It,_,hs="<li><strong>Work with VLM datasets</strong>: Explore and prepare <strong>HuggingFaceM4/ChartQA</strong>.</li> <li><strong>Optimize training</strong>: Apply <strong>quantization</strong> and <strong>PEFT</strong> for efficient fine-tuning.</li> <li><strong>Fine-tune models in practice</strong>: Train <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong> using both Python APIs and CLI tools.</li> <li><strong>Adapt datasets for TRL</strong>: Prepare VLM datasets to integrate seamlessly with TRL workflows.</li> <li><strong>Move to production</strong>: Understand how to scale and manage <strong>production-ready fine-tuning workflows</strong> for VLMs.</li>",jt,Z,bt,A,gs="<strong>Objective:</strong> Get familiar with the <code>SmolVLM2-2.2B-Instruct</code> model and evaluate the model using a sample from the dataset.",Ct,W,$t,h,Us="<ul><li>You need a GPU with at least 8GB VRAM for training. CPU/MPS can run formatting and dataset exploration, but training larger models will likely fail.</li> <li>First run will download several GB of model weights; ensure 15GB+ free disk and a stable connection.</li> <li>If you need access to private repos, authenticate with Hugging Face Hub via <code>login()</code>.</li></ul>",vt,H,fs=`First, install the required libraries: <code>transformers</code>, <code>datasets</code>, <code>trl</code>,<code>huggingface_hub</code>, and <code>trackio</code>.<br/>
These packages provide the tools for working with the model, datasets, and Hugging Face Hub.`,Bt,x,_t,R,Zt,F,Is="Now, import the main dependencies we’ll use:",At,L,Wt,k,Ht,G,xt,E,js="We start by selecting the device where the model will run. It can be a GPU (<code>cuda</code>), Apple Silicon (<code>mps</code>), or the CPU as a fallback.",Rt,Q,Ft,V,Lt,X,bs="To work with private models or to <strong>push your fine-tuned model to the Hub</strong> (as we’ll do in this exercise), you need to authenticate with your Hugging Face account.",kt,g,Cs='<p>You can create and copy your access token from the <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face tokens page</a> in your profile.</p>',Gt,N,Et,S,Qt,Y,$s=`Finally, we load the <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong> model.
The <code>AutoProcessor</code> is also initialized here — it ensures that both text and images are preprocessed correctly before being passed to the model.`,Vt,q,Xt,z,Nt,P,vs="In this step, we load a small subset of the <strong>ChartQA</strong> dataset — just 10% of the training and validation splits — to keep the exercises fast and manageable for learning purposes.",St,D,Bs=`We then display one of the chart images using <code>matplotlib</code> to get a visual sense of the model’s input.<br/>
Additionally, we print the corresponding query and label so you can fully understand the dataset structure and the type of tasks the model will handle.`,Yt,y,_s,qt,K,zt,U,mt,Zs="Output",ds,O,Pt,ee,Dt,te,As='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/model_output.png" alt="Model output"/>',Kt,le,Ot,se,Ws="We create a <strong>chat message list</strong> that includes a user query along with the image.",el,ne,Hs="Using <code>processor.apply_chat_template</code>, we transform this into the exact input format the model expects.",tl,ae,ll,f,ut,xs="Output",cs,ie,sl,oe,nl,re,Rs=`We tokenize the chat prompt and image into tensors, then generate a response with the model.
Finally, we decode the output tokens back into text.`,al,Me,il,I,dt,Fs="Output",Ts,pe,ol,me,Ls="The model generates a reponse, but it’s not exactly correct. It could be improved with some fine-tuning. Now that we’ve seen how to build prompts and generate responses with <strong>SmolVLM2-2.2B-Instruct</strong>, it’s time to learn how to adapt and <strong>fine-tune</strong> the model efficiently using <strong>LoRA (Low-Rank Adaptation)</strong>. This approach allows training large models with fewer resources and prepares the model for specific downstream tasks.",rl,ue,Ml,de,ks="In this exercise, we’ll apply <strong>LoRA (Low-Rank Adaptation)</strong> to fine-tune our Vision-Language Model efficiently.",pl,ce,Gs=`LoRA works by injecting <strong>trainable low-rank matrices</strong> into existing model layers, enabling <strong>large models to be fine-tuned with significantly fewer trainable parameters</strong>.<br/>
This approach reduces memory usage and speeds up training while maintaining high performance.`,ml,Te,ul,we,Es="We’ll format the dataset into a <strong>chatbot-style structure</strong>, where each example includes:",dl,ye,Qs="<li>A <strong>system message</strong> defining the assistant’s role</li> <li>The <strong>chart image</strong></li> <li>The <strong>user query</strong></li> <li>The <strong>expected answer</strong></li>",cl,Je,Vs=`This is the format expected by the <code>SFTTrainer</code>, including the <code>images</code> and <code>messages</code> columns.<br/>
You can learn more about preparing datasets for VLM post-training in the <a href="https://huggingface.co/docs/trl/en/sft_trainer#training-vision-language-models" rel="nofollow">documentation</a>.`,Tl,wl,yl,he,Jl,ge,Xs=`The first step is to structure the dataset for VLM training.<br/>
We’ll define a <strong>system message</strong> that instructs the model to act as a <strong>chart analysis expert</strong>, providing <strong>concise, accurate answers</strong> about chart images.`,hl,Ue,gl,fe,Ns="Now, let’s format the data using the chatbot structure. This will set up the interactions for the model.",Ul,Ie,fl,je,Il,be,Ss="Here we define a <code>LoraConfig</code>:",jl,Ce,Ys="<li><code>r</code> and <code>lora_alpha</code> control the rank and scaling of the adaptation matrices.</li> <li><code>target_modules</code> specifies which parts of the model to adapt.</li> <li><code>task_type</code> is set for causal language modeling.</li>",bl,$e,qs="We then apply LoRA to the base model using <code>get_peft_model</code> and print out the trainable parameters to verify the adaptation.",Cl,ve,$l,Be,vl,_e,zs="We configure the <strong>SFTTrainer</strong> from <code>trl</code> with <code>SFTConfig</code>:",Bl,Ze,Ps="<li><code>num_train_epochs</code>, <code>batch_size</code>, and <code>gradient_accumulation_steps</code> control the training loop.</li> <li><code>gradient_checkpointing</code>, and <code>bf16</code> optimize memory and speed.</li> <li><code>learning_rate</code> manages optimization.</li> <li><code>train_dataset</code> and <code>eval_dataset</code> are aligned with your dataset.</li>",_l,Ae,Ds="This prepares the trainer to handle fine-tuning with PEFT/LoRA.",Zl,We,Al,He,Wl,xe,Ks="Now we run the training loop:",Hl,Re,Os="<li><code>trainer.train()</code> starts fine-tuning with LoRA.</li> <li><code>trainer.save_model()</code> stores the locally trained model.</li>",xl,Fe,en="This step ensures the model is ready for downstream tasks with minimal additional parameters.",Rl,Le,Fl,ke,tn="With the foundations of Python-based fine-tuning and LoRA in place, we can now move this workflow to a <strong>production environment</strong> using the <strong>TRL CLI</strong>. This approach lets you automate fine-tuning and create reproducible pipelines without writing full Python scripts.",Ll,Ge,kl,Ee,ln="In the previous exercises, we focused on using the Python API to fine-tune <strong>SmolVLM2-2.2B-Instruct</strong>, exploring dataset preparation and generating chat-style prompts.",Gl,Qe,sn='In this exercise, we’ll demonstrate how to perform fine-tuning using the <strong>TRL CLI</strong>, a common workflow in production environments. The CLI allows you to run experiments and manage training without writing Python scripts. If you want a refresher, we previously introduced this tool <a href="../unit1/4#exercise-4-production-workflow-with-trl-cli">here</a>, and the same concepts and troubleshooting tips apply.',El,Ve,nn="The TRL CLI leverages the same logic and configuration options as the Python API but presents them through a simple command-line interface. This means you can define everything—from the model and dataset to training hyperparameters and output location—in a single command.",Ql,Xe,an="The example below shows how to fine-tune <strong>SmolVLM2-2.2B-Instruct</strong> on the <strong>trl-lib/llava-instruct-mix</strong> dataset, using LoRA for parameter-efficient fine-tuning, mixed precision for faster training, and optional push-to-Hub for sharing your model. The dataset now is different.",Vl,Ne,on="We are using a different dataset here because it already comes formatted in the expected VLM structure, as discussed earlier.",Xl,Se,rn="<li><code>--model_name_or_path</code> specifies the base model to fine-tune.</li> <li><code>--dataset_name</code> and <code>--dataset_config</code> define the dataset and subset.</li> <li><code>--output_dir</code> sets the local directory for saving the fine-tuned model.</li> <li><code>--per_device_train_batch_size</code> and <code>--gradient_accumulation_steps</code> control effective batch size and memory usage.</li> <li><code>--learning_rate</code>, <code>--num_train_epochs</code>, and <code>--max_length</code> define the core training hyperparameters.</li> <li><code>--bf16</code> enables mixed precision for faster and more memory-efficient training on compatible GPUs.</li> <li><code>--push_to_hub</code> and <code>--hub_model_id</code> allow automatic upload of the trained model to your Hugging Face Hub repository.</li>",Nl,Ye,Mn="Using the TRL CLI is functionally equivalent to writing a full Python training script, but it’s faster to configure, easier to reproduce, and ideal for production pipelines or automated training workflows.",Sl,qe,Yl,ze,ql,Pe,pn=`In <a href="../unit1/5">Unit 1</a>, we introduced <strong>Hugging Face Jobs (HF Jobs)</strong> and demonstrated how to fine-tune a model using this managed cloud service.<br/>
HF Jobs provides a <strong>fully managed infrastructure</strong> for training models, eliminating the need to set up GPUs, manage dependencies, or configure environments locally. This is especially useful for <strong>SFT training</strong>, which can be both resource-intensive and time-consuming.`,zl,De,mn=`Following the same approach, we can use HF Jobs to fine-tune our Vision-Language Model (VLM).<br/>
If needed, refer back to Unit 1 to refresh your understanding of HF Jobs and their workflow.`,Pl,Ke,un="Here’s an example of how to launch a training job using <strong>TRL’s maintained SFT script</strong>:",Dl,Oe,Kl,et,dn="After launching the job, HF Jobs will handle the <strong>entire training process</strong> in the cloud. You can monitor progress, view logs, and track metrics directly from the Hugging Face Hub.",Ol,tt,cn="Once the job completes:",es,lt,Tn="<li>The <strong>fine-tuned model</strong> will be available in the <code>output_dir</code> you specified.</li> <li>If <code>--push_to_hub</code> was used, the model will also be <strong>accessible from your Hugging Face account</strong>, ready for inference or further fine-tuning.</li> <li>You can <strong>resume, replicate, or scale</strong> training easily by re-running or modifying the job configuration.</li>",ts,st,wn="This workflow removes the overhead of managing local resources, allowing you to focus on <strong>model experimentation and evaluation</strong>.",ls,nt,ss,at,yn=`You’ve completed the unit — great work!
Now put your learning to the test by taking the <a href="https://huggingface.co/spaces/smol-course/unit_4_quiz" rel="nofollow">quiz</a>.`,ns,it,as,ot,Jn="Here are some helpful resources to deepen your understanding and continue experimenting with vision language models and TRL workflows:",is,rt,hn='<li><strong><a href="https://huggingface.co/docs/trl/" rel="nofollow">TRL Documentation</a></strong> – Complete reference for using TRL, including Python API and CLI.</li> <li><strong><a href="https://huggingface.co/HuggingFaceTB/SmolVLM2-2.2B-Instruct" rel="nofollow">HuggingFaceTB/SmolVLM2-2.2B-Instruct Model Card</a></strong> – Detailed information about the model architecture, training, and usage.</li> <li><strong><a href="https://huggingface.co/datasets/HuggingFaceM4/ChartQA" rel="nofollow">HuggingFaceM4/ChartQA Dataset</a></strong> – Dataset used for training and fine-tuning VLMs.</li> <li><strong><a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a></strong> – Platform to share your fine-tuned models and discover community models.</li> <li><strong><a href="https://discord.gg/huggingface" rel="nofollow">Hugging Face Discord Community</a></strong> – Join the community for discussions, support, and troubleshooting.</li>',os,Mt,rs,wt,Ms;return b=new T({props:{title:"Hands-On Exercises: Fine-Tuning SmolVLM2-2.2B-Instruct",local:"hands-on-exercises-fine-tuning-smolvlm2-22b-instruct",headingTag:"h1"}}),C=new $n({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/4/4.ipynb"}]}}),v=new T({props:{title:"Learning Objectives",local:"learning-objectives",headingTag:"h2"}}),Z=new T({props:{title:"Exercise 1: Explore SmolVLM2-2.2B-Instruct",local:"exercise-1-explore-smolvlm2-22b-instruct",headingTag:"h3"}}),W=new T({props:{title:"Environment Setup",local:"environment-setup",headingTag:"h3"}}),x=new w({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjAocnVuJTIwaW4lMjBDb2xhYiUyMG9yJTIweW91ciUyMGVudmlyb25tZW50KSUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMHRybCUyMGh1Z2dpbmdmYWNlX2h1YiUyMHRyYWNraW8lMjBudW0yd29yZHMlM0QlM0QwLjUuMTQ=",highlighted:`<span class="hljs-comment"># Install required packages (run in Colab or your environment)</span>
pip install transformers datasets trl huggingface_hub trackio num2words==0.5.14`,wrap:!1}}),R=new T({props:{title:"Import dependencies",local:"import-dependencies",headingTag:"h3"}}),L=new w({props:{code:"JTIzJTIwSW1wb3J0JTIwZGVwZW5kZW5jaWVzJTBBJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBvcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0JTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5pbWFnZV91dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2U=",highlighted:`<span class="hljs-comment"># Import dependencies</span>

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText, BitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image`,wrap:!1}}),k=new T({props:{title:"Load the model and processor",local:"load-the-model-and-processor",headingTag:"h3"}}),G=new T({props:{title:"1. Select the device",local:"1-select-the-device",headingTag:"h4"}}),Q=new w({props:{code:"ZGV2aWNlJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlMEElMjAlMjAlMjAlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMEElMjAlMjAlMjAlMjBlbHNlJTIwJTIybXBzJTIyJTIwaWYlMjB0b3JjaC5iYWNrZW5kcy5tcHMuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBKQ==",highlighted:`device = (
    <span class="hljs-string">&quot;cuda&quot;</span>
    <span class="hljs-keyword">if</span> torch.cuda.is_available()
    <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
)`,wrap:!1}}),V=new T({props:{title:"2. Authenticate with Hugging Face",local:"2-authenticate-with-hugging-face",headingTag:"h4"}}),N=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
login()`,wrap:!1}}),S=new T({props:{title:"3. Load the model and processor",local:"3-load-the-model-and-processor",headingTag:"h4"}}),q=new w({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNMi0yLjJCLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKS50byhkZXZpY2UpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>
model = AutoModelForImageTextToText.from_pretrained(
    model_name,
    dtype=torch.bfloat16,
).to(device)

processor = AutoProcessor.from_pretrained(model_name)`,wrap:!1}}),z=new T({props:{title:"Explore the dataset",local:"explore-the-dataset",headingTag:"h3"}}),K=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXRyYWluX2RhdGFzZXQlMkMlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIySHVnZ2luZ0ZhY2VNNCUyRkNoYXJ0UUElMjIlMkMlMjBzcGxpdCUzRCU1QiUyMnRyYWluJTVCJTNBMTAlMjUlNUQlMjIlMkMlMjAlMjJ2YWwlNUIlM0ExMCUyNSU1RCUyMiU1RCklMEFleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QjElNUQlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoZXhhbXBsZSU1QiUyMmltYWdlJTIyJTVEKSUwQSUwQXByaW50KGV4YW1wbGUlNUIlMjJxdWVyeSUyMiU1RCklMEFwcmludChleGFtcGxlJTVCJTIybGFiZWwlMjIlNUQlNUIwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

train_dataset, eval_dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceM4/ChartQA&quot;</span>, split=[<span class="hljs-string">&quot;train[:10%]&quot;</span>, <span class="hljs-string">&quot;val[:10%]&quot;</span>])
example = train_dataset[<span class="hljs-number">1</span>]
image = load_image(example[<span class="hljs-string">&quot;image&quot;</span>])

<span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;query&quot;</span>])
<span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),O=new w({props:{code:"SG93JTIwbWFueSUyMHZhbHVlcyUyMGFyZSUyMGJlbG93JTIwNDAlMjBpbiUyMFVuZmF2b3JhYmxlJTIwZ3JhcGglM0YlMEE2",highlighted:`How many values are below 40 in Unfavorable graph?
6`,wrap:!1}}),ee=new w({props:{code:"cGx0Lmltc2hvdyhpbWFnZSklMEFwbHQuYXhpcyglMjJvZmYlMjIpJTBBcGx0LnRpdGxlKCUyMlNhbXBsZSUyMENoYXJ0JTIwSW1hZ2UlMjIpJTBBcGx0LnNob3coKQ==",highlighted:`plt.imshow(image)
plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.title(<span class="hljs-string">&quot;Sample Chart Image&quot;</span>)
plt.show()`,wrap:!1}}),le=new T({props:{title:"Build a chat-style prompt",local:"build-a-chat-style-prompt",headingTag:"h3"}}),ae=new w({props:{code:"JTIzJTIwRGVmaW5lJTIwYSUyMGNoYXQtc3R5bGUlMjBwcm9tcHQlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUyMCUyMmltYWdlJTIyJTNBJTIwaW1hZ2UlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycXVlcnklMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlN0QlMEElNUQlMEElMEElMjMlMjBBcHBseSUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUwQWNoYXRfcHJvbXB0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTVDJTBBKSUwQXByaW50KGNoYXRfcHJvbXB0KQ==",highlighted:`<span class="hljs-comment"># Define a chat-style prompt</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: image},
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;query&quot;</span>]},
    ]}
]

<span class="hljs-comment"># Apply the chat template</span>
chat_prompt = processor.apply_chat_template(
      messages, add_generation_prompt=<span class="hljs-literal">True</span>\\
)
<span class="hljs-built_in">print</span>(chat_prompt)`,wrap:!1}}),ie=new w({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VVc2VyJTNBJTNDaW1hZ2UlM0VIb3clMjBtYW55JTIwdmFsdWVzJTIwYXJlJTIwYmVsb3clMjA0MCUyMGluJTIwVW5mYXZvcmFibGUlMjBncmFwaCUzRiUzQ2VuZF9vZl91dHRlcmFuY2UlM0UlMEFBc3Npc3RhbnQlM0E=",highlighted:`&lt;|im_start|&gt;User:&lt;image&gt;How many values are below 40 in Unfavorable graph?&lt;end_of_utterance&gt;
Assistant:`,wrap:!1}}),oe=new T({props:{title:"Run inference",local:"run-inference",headingTag:"h3"}}),Me=new w({props:{code:"JTIzJTIwVG9rZW5pemUlMjBpbnB1dCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0QlNUJpbWFnZSU1RCUyQyUyMHRleHQlM0RjaGF0X3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEElMEElMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwb3V0cHV0JTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEElMEElMjMlMjBUcmltJTIwdGhlJTIwZ2VuZXJhdGVkJTIwaWRzJTIwdG8lMjByZW1vdmUlMjB0aGUlMjBpbnB1dCUyMGlkcyUwQXRyaW1tZWRfZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMCU1Qm91dF9pZHMlNUJsZW4oaW5faWRzKSUyMCUzQSU1RCUyMGZvciUyMGluX2lkcyUyQyUyMG91dF9pZHMlMjBpbiUyMHppcChpbnB1dHMuaW5wdXRfaWRzJTJDJTIwb3V0cHV0KSU1RCUwQSUwQSUyMyUyMERlY29kZSUyMHRoZSUyMG91dHB1dCUyMHRleHQlMEFvdXRwdXRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwdHJpbW1lZF9nZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UlMEEpJTBBcHJpbnQob3V0cHV0X3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-comment"># Tokenize input</span>
inputs = processor(images=[image], text=chat_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate model output</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>)

<span class="hljs-comment"># Trim the generated ids to remove the input ids</span>
trimmed_generated_ids = [out_ids[<span class="hljs-built_in">len</span>(in_ids) :] <span class="hljs-keyword">for</span> in_ids, out_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output)]

<span class="hljs-comment"># Decode the output text</span>
output_text = processor.batch_decode(
    trimmed_generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>
)
<span class="hljs-built_in">print</span>(output_text[<span class="hljs-number">0</span>])`,wrap:!1}}),pe=new w({props:{code:"JTIwMy4=",highlighted:" 3.",wrap:!1}}),ue=new T({props:{title:"Exercise 2: Fine-Tune the Model Using LoRA",local:"exercise-2-fine-tune-the-model-using-lora",headingTag:"h2"}}),Te=new w({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlMjIlMjIlMjJZb3UlMjBhcmUlMjBhJTIwVmlzaW9uJTIwTGFuZ3VhZ2UlMjBNb2RlbCUyMHNwZWNpYWxpemVkJTIwaW4lMjBpbnRlcnByZXRpbmclMjB2aXN1YWwlMjBkYXRhJTIwZnJvbSUyMGNoYXJ0JTIwaW1hZ2VzLiUwQVlvdXIlMjB0YXNrJTIwaXMlMjB0byUyMGFuYWx5emUlMjB0aGUlMjBwcm92aWRlZCUyMGNoYXJ0JTIwaW1hZ2UlMjBhbmQlMjByZXNwb25kJTIwdG8lMjBxdWVyaWVzJTIwd2l0aCUyMGNvbmNpc2UlMjBhbnN3ZXJzJTJDJTIwdXN1YWxseSUyMGElMjBzaW5nbGUlMjB3b3JkJTJDJTIwbnVtYmVyJTJDJTIwb3IlMjBzaG9ydCUyMHBocmFzZS4lMEFUaGUlMjBjaGFydHMlMjBpbmNsdWRlJTIwYSUyMHZhcmlldHklMjBvZiUyMHR5cGVzJTIwKGUuZy4lMkMlMjBsaW5lJTIwY2hhcnRzJTJDJTIwYmFyJTIwY2hhcnRzKSUyMGFuZCUyMGNvbnRhaW4lMjBjb2xvcnMlMkMlMjBsYWJlbHMlMkMlMjBhbmQlMjB0ZXh0LiUwQUZvY3VzJTIwb24lMjBkZWxpdmVyaW5nJTIwYWNjdXJhdGUlMkMlMjBzdWNjaW5jdCUyMGFuc3dlcnMlMjBiYXNlZCUyMG9uJTIwdGhlJTIwdmlzdWFsJTIwaW5mb3JtYXRpb24uJTIwQXZvaWQlMjBhZGRpdGlvbmFsJTIwZXhwbGFuYXRpb24lMjB1bmxlc3MlMjBhYnNvbHV0ZWx5JTIwbmVjZXNzYXJ5LiUyMiUyMiUyMg==",highlighted:`system_message = <span class="hljs-string">&quot;&quot;&quot;You are a Vision Language Model specialized in interpreting visual data from chart images.
Your task is to analyze the provided chart image and respond to queries with concise answers, usually a single word, number, or short phrase.
The charts include a variety of types (e.g., line charts, bar charts) and contain colors, labels, and text.
Focus on delivering accurate, succinct answers based on the visual information. Avoid additional explanation unless absolutely necessary.&quot;&quot;&quot;</span>`,wrap:!1}}),he=new T({props:{title:"Format the Dataset",local:"format-the-dataset",headingTag:"h3"}}),Ue=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_data</span>(<span class="hljs-params">sample</span>):
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;images&quot;</span>: [sample[<span class="hljs-string">&quot;image&quot;</span>]],
        <span class="hljs-string">&quot;messages&quot;</span>: [
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: system_message}],
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                        <span class="hljs-string">&quot;image&quot;</span>: sample[<span class="hljs-string">&quot;image&quot;</span>],
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;query&quot;</span>],
                    },
                ],
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-number">0</span>]}],
            },
        ],
    }`,wrap:!1}}),Ie=new w({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMCU1QmZvcm1hdF9kYXRhKHNhbXBsZSklMjBmb3IlMjBzYW1wbGUlMjBpbiUyMHRyYWluX2RhdGFzZXQlNUQlMEFldmFsX2RhdGFzZXQlMjAlM0QlMjAlNUJmb3JtYXRfZGF0YShzYW1wbGUpJTIwZm9yJTIwc2FtcGxlJTIwaW4lMjBldmFsX2RhdGFzZXQlNUQ=",highlighted:`train_dataset = [format_data(sample) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> train_dataset]
eval_dataset = [format_data(sample) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> eval_dataset]`,wrap:!1}}),je=new T({props:{title:"Configure LoRA",local:"configure-lora",headingTag:"h3"}}),ve=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEElMjMlMjBDb25maWd1cmUlMjBMb1JBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjByJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKSUwQSUwQSUyMyUyMEFwcGx5JTIwUEVGVCUyMG1vZGVsJTIwYWRhcHRhdGlvbiUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQSUwQSUyMyUyMFByaW50JTIwdHJhaW5hYmxlJTIwcGFyYW1ldGVycyUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

<span class="hljs-comment"># Configure LoRA</span>
peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    r=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># Apply PEFT model adaptation</span>
peft_model = get_peft_model(model, peft_config)

<span class="hljs-comment"># Print trainable parameters</span>
peft_model.print_trainable_parameters()`,wrap:!1}}),Be=new T({props:{title:"Set up the Trainer",local:"set-up-the-trainer",headingTag:"h3"}}),We=new w({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEElMjMlMjBDb25maWd1cmUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUyMHVzaW5nJTIwU0ZUQ29uZmlnJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyc21vbC1jb3Vyc2Utc21vbHZsbTItMi4yYi1pbnN0cnVjdC10cmwtc2Z0LUNoYXJ0UUElMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTQlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMmFkYW13X3RvcmNoX2Z1c2VkJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmYxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ0cmFja2lvJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRE5vbmUlMkMlMEEpJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMFRyYWluZXIlMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMkMlMEEpJTBBJTBBJTIzJTIwQWxpZ24lMjB0aGUlMjBTRlRUcmFpbmVyJTIwcGFyYW1zJTIwd2l0aCUyMHlvdXIlMjBjaG9zZW4lMjBkYXRhc2V0Lg==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

<span class="hljs-comment"># Configure training arguments using SFTConfig</span>
training_args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;smol-course-smolvlm2-2.2b-instruct-trl-sft-ChartQA&quot;</span>,
    num_train_epochs=<span class="hljs-number">1</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">1e-4</span>,
    logging_steps=<span class="hljs-number">25</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_steps=<span class="hljs-number">25</span>,
    optim=<span class="hljs-string">&quot;adamw_torch_fused&quot;</span>,
    bf16=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    report_to=<span class="hljs-string">&quot;trackio&quot;</span>,
    max_length=<span class="hljs-literal">None</span>,
)

<span class="hljs-comment"># Initialize the Trainer</span>
trainer = SFTTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    peft_config=peft_config,
)

<span class="hljs-comment"># Align the SFTTrainer params with your chosen dataset.</span>`,wrap:!1}}),He=new T({props:{title:"Train and Save the Model",local:"train-and-save-the-model",headingTag:"h3"}}),Le=new w({props:{code:"JTIzJTIwVHJhaW4lMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIuc2F2ZV9tb2RlbCh0cmFpbmluZ19hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-comment"># Train the model</span>
trainer.train()

<span class="hljs-comment"># Save the model</span>
trainer.save_model(training_args.output_dir)`,wrap:!1}}),Ge=new T({props:{title:"Exercise 3: Production Workflow with TRL CLI",local:"exercise-3-production-workflow-with-trl-cli",headingTag:"h2"}}),qe=new w({props:{code:"dHJsJTIwc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbFZMTTItMi4yQi1JbnN0cnVjdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRmxsYXZhLWluc3RydWN0LW1peCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMC4lMkZzbW9sdmxuLWluc3RydWN0LXNmdC1jbGklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwMmUtNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9sZW5ndGglMjAtMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbG9nZ2luZ19zdGVwcyUyMDUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNhdmVfc3RlcHMlMjAxMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdhcm11cF9zdGVwcyUyMDUwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWh1Yl9tb2RlbF9pZCUyMHlvdXItdXNlcm5hbWUlMkZzbW9sdmxtMi0yLjJiLWluc3RydWN0LXNmdC1jbGk=",highlighted:`trl sft \\
    --model_name_or_path HuggingFaceTB/SmolVLM2-2.2B-Instruct \\
    --dataset_name trl-lib/llava-instruct-mix \\
    --output_dir ./smolvln-instruct-sft-cli \\
    --per_device_train_batch_size 1 \\
    --gradient_accumulation_steps 16 \\
    --learning_rate 2e-4 \\
    --num_train_epochs 3 \\
    --max_length -1 \\
    --logging_steps 5 \\
    --save_steps 100 \\
    --warmup_steps 50 \\
    --bf16 True \\
    --push_to_hub \\
    --hub_model_id your-username/smolvlm2-2.2b-instruct-sft-cli`,wrap:!1}}),ze=new T({props:{title:"Exercise 4: Training with Hugging Face Jobs",local:"exercise-4-training-with-hugging-face-jobs",headingTag:"h2"}}),Oe=new w({props:{code:"JTIzJTIwVXNlJTIwVFJMJ3MlMjBtYWludGFpbmVkJTIwU0ZUJTIwc2NyaXB0JTIwZGlyZWN0bHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdpdGglMjBudW0yd29yZHMlM0QlM0QwLjUuMTQlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbFZMTTItMi4yQi1JbnN0cnVjdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRmxsYXZhLWluc3RydWN0LW1peCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9sZW5ndGglMjAtMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X3N0ZXBzJTIwMTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHNtb2x2bG0yLTIuMmItaW5zdHJ1Y3Qtc2Z0LWpvYnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1odWJfbW9kZWxfaWQlMjB5b3VyLXVzZXJuYW1lJTJGc21vbHZsbTItMi4yYi1pbnN0cnVjdC1zZnQtam9icyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwb3J0X3RvJTIwdHJhY2tpbw==",highlighted:`<span class="hljs-comment"># Use TRL&#x27;s maintained SFT script directly</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    --with num2words==0.5.14 \\
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
    --model_name_or_path HuggingFaceTB/SmolVLM2-2.2B-Instruct \\
    --dataset_name trl-lib/llava-instruct-mix\\
    --learning_rate 5e-5 \\
    --per_device_train_batch_size 4 \\
    --max_length -1 \\
    --max_steps 1000 \\
    --output_dir smolvlm2-2.2b-instruct-sft-jobs \\
    --push_to_hub \\
    --hub_model_id your-username/smolvlm2-2.2b-instruct-sft-jobs \\
    --report_to trackio`,wrap:!1}}),nt=new T({props:{title:"Test your knowledge",local:"test-your-knowledge",headingTag:"h2"}}),it=new T({props:{title:"Resources for Further Learning",local:"resources-for-further-learning",headingTag:"h2"}}),Mt=new vn({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit3/4.md"}}),{c(){J=i("meta"),yt=n(),Tt=i("p"),Jt=n(),M(b.$$.fragment),ht=n(),M(C.$$.fragment),gt=n(),$=i("p"),$.innerHTML=ys,Ut=n(),M(v.$$.fragment),ft=n(),B=i("p"),B.textContent=Js,It=n(),_=i("ul"),_.innerHTML=hs,jt=n(),M(Z.$$.fragment),bt=n(),A=i("p"),A.innerHTML=gs,Ct=n(),M(W.$$.fragment),$t=n(),h=i("blockquote"),h.innerHTML=Us,vt=n(),H=i("p"),H.innerHTML=fs,Bt=n(),M(x.$$.fragment),_t=n(),M(R.$$.fragment),Zt=n(),F=i("p"),F.textContent=Is,At=n(),M(L.$$.fragment),Wt=n(),M(k.$$.fragment),Ht=n(),M(G.$$.fragment),xt=n(),E=i("p"),E.innerHTML=js,Rt=n(),M(Q.$$.fragment),Ft=n(),M(V.$$.fragment),Lt=n(),X=i("p"),X.innerHTML=bs,kt=n(),g=i("blockquote"),g.innerHTML=Cs,Gt=n(),M(N.$$.fragment),Et=n(),M(S.$$.fragment),Qt=n(),Y=i("p"),Y.innerHTML=$s,Vt=n(),M(q.$$.fragment),Xt=n(),M(z.$$.fragment),Nt=n(),P=i("p"),P.innerHTML=vs,St=n(),D=i("p"),D.innerHTML=Bs,Yt=n(),y=i("iframe"),qt=n(),M(K.$$.fragment),zt=n(),U=i("details"),mt=i("summary"),mt.textContent=Zs,ds=n(),M(O.$$.fragment),Pt=n(),M(ee.$$.fragment),Dt=n(),te=i("p"),te.innerHTML=As,Kt=n(),M(le.$$.fragment),Ot=n(),se=i("p"),se.innerHTML=Ws,el=n(),ne=i("p"),ne.innerHTML=Hs,tl=n(),M(ae.$$.fragment),ll=n(),f=i("details"),ut=i("summary"),ut.textContent=xs,cs=n(),M(ie.$$.fragment),sl=n(),M(oe.$$.fragment),nl=n(),re=i("p"),re.textContent=Rs,al=n(),M(Me.$$.fragment),il=n(),I=i("details"),dt=i("summary"),dt.textContent=Fs,Ts=n(),M(pe.$$.fragment),ol=n(),me=i("p"),me.innerHTML=Ls,rl=n(),M(ue.$$.fragment),Ml=n(),de=i("p"),de.innerHTML=ks,pl=n(),ce=i("p"),ce.innerHTML=Gs,ml=n(),M(Te.$$.fragment),ul=n(),we=i("p"),we.innerHTML=Es,dl=n(),ye=i("ul"),ye.innerHTML=Qs,cl=n(),Je=i("p"),Je.innerHTML=Vs,Tl=n(),wl=i("hr"),yl=n(),M(he.$$.fragment),Jl=n(),ge=i("p"),ge.innerHTML=Xs,hl=n(),M(Ue.$$.fragment),gl=n(),fe=i("p"),fe.textContent=Ns,Ul=n(),M(Ie.$$.fragment),fl=n(),M(je.$$.fragment),Il=n(),be=i("p"),be.innerHTML=Ss,jl=n(),Ce=i("ul"),Ce.innerHTML=Ys,bl=n(),$e=i("p"),$e.innerHTML=qs,Cl=n(),M(ve.$$.fragment),$l=n(),M(Be.$$.fragment),vl=n(),_e=i("p"),_e.innerHTML=zs,Bl=n(),Ze=i("ul"),Ze.innerHTML=Ps,_l=n(),Ae=i("p"),Ae.textContent=Ds,Zl=n(),M(We.$$.fragment),Al=n(),M(He.$$.fragment),Wl=n(),xe=i("p"),xe.textContent=Ks,Hl=n(),Re=i("ol"),Re.innerHTML=Os,xl=n(),Fe=i("p"),Fe.textContent=en,Rl=n(),M(Le.$$.fragment),Fl=n(),ke=i("p"),ke.innerHTML=tn,Ll=n(),M(Ge.$$.fragment),kl=n(),Ee=i("p"),Ee.innerHTML=ln,Gl=n(),Qe=i("p"),Qe.innerHTML=sn,El=n(),Ve=i("p"),Ve.textContent=nn,Ql=n(),Xe=i("p"),Xe.innerHTML=an,Vl=n(),Ne=i("p"),Ne.textContent=on,Xl=n(),Se=i("ul"),Se.innerHTML=rn,Nl=n(),Ye=i("p"),Ye.textContent=Mn,Sl=n(),M(qe.$$.fragment),Yl=n(),M(ze.$$.fragment),ql=n(),Pe=i("p"),Pe.innerHTML=pn,zl=n(),De=i("p"),De.innerHTML=mn,Pl=n(),Ke=i("p"),Ke.innerHTML=un,Dl=n(),M(Oe.$$.fragment),Kl=n(),et=i("p"),et.innerHTML=dn,Ol=n(),tt=i("p"),tt.textContent=cn,es=n(),lt=i("ul"),lt.innerHTML=Tn,ts=n(),st=i("p"),st.innerHTML=wn,ls=n(),M(nt.$$.fragment),ss=n(),at=i("p"),at.innerHTML=yn,ns=n(),M(it.$$.fragment),as=n(),ot=i("p"),ot.textContent=Jn,is=n(),rt=i("ul"),rt.innerHTML=hn,os=n(),M(Mt.$$.fragment),rs=n(),wt=i("p"),this.h()},l(e){const t=Cn("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(l),yt=a(e),Tt=o(e,"P",{}),ct(Tt).forEach(l),Jt=a(e),p(b.$$.fragment,e),ht=a(e),p(C.$$.fragment,e),gt=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1a5nqhq"&&($.innerHTML=ys),Ut=a(e),p(v.$$.fragment,e),ft=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1l3bdg3"&&(B.textContent=Js),It=a(e),_=o(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-od3cka"&&(_.innerHTML=hs),jt=a(e),p(Z.$$.fragment,e),bt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-bijktq"&&(A.innerHTML=gs),Ct=a(e),p(W.$$.fragment,e),$t=a(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-2reic0"&&(h.innerHTML=Us),vt=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-qqkglq"&&(H.innerHTML=fs),Bt=a(e),p(x.$$.fragment,e),_t=a(e),p(R.$$.fragment,e),Zt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-zl3b16"&&(F.textContent=Is),At=a(e),p(L.$$.fragment,e),Wt=a(e),p(k.$$.fragment,e),Ht=a(e),p(G.$$.fragment,e),xt=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-7eoqdg"&&(E.innerHTML=js),Rt=a(e),p(Q.$$.fragment,e),Ft=a(e),p(V.$$.fragment,e),Lt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-tskkwt"&&(X.innerHTML=bs),kt=a(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-9q1nng"&&(g.innerHTML=Cs),Gt=a(e),p(N.$$.fragment,e),Et=a(e),p(S.$$.fragment,e),Qt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1b4foh6"&&(Y.innerHTML=$s),Vt=a(e),p(q.$$.fragment,e),Xt=a(e),p(z.$$.fragment,e),Nt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-er66b7"&&(P.innerHTML=vs),St=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-yemwqz"&&(D.innerHTML=Bs),Yt=a(e),y=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ct(y).forEach(l),qt=a(e),p(K.$$.fragment,e),zt=a(e),U=o(e,"DETAILS",{});var ps=ct(U);mt=o(ps,"SUMMARY",{"data-svelte-h":!0}),r(mt)!=="svelte-nfzy3j"&&(mt.textContent=Zs),ds=a(ps),p(O.$$.fragment,ps),ps.forEach(l),Pt=a(e),p(ee.$$.fragment,e),Dt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-12h2lj2"&&(te.innerHTML=As),Kt=a(e),p(le.$$.fragment,e),Ot=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-jpokh4"&&(se.innerHTML=Ws),el=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-17uxmem"&&(ne.innerHTML=Hs),tl=a(e),p(ae.$$.fragment,e),ll=a(e),f=o(e,"DETAILS",{});var ms=ct(f);ut=o(ms,"SUMMARY",{"data-svelte-h":!0}),r(ut)!=="svelte-nfzy3j"&&(ut.textContent=xs),cs=a(ms),p(ie.$$.fragment,ms),ms.forEach(l),sl=a(e),p(oe.$$.fragment,e),nl=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1qdjv1p"&&(re.textContent=Rs),al=a(e),p(Me.$$.fragment,e),il=a(e),I=o(e,"DETAILS",{});var us=ct(I);dt=o(us,"SUMMARY",{"data-svelte-h":!0}),r(dt)!=="svelte-nfzy3j"&&(dt.textContent=Fs),Ts=a(us),p(pe.$$.fragment,us),us.forEach(l),ol=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-luk36"&&(me.innerHTML=Ls),rl=a(e),p(ue.$$.fragment,e),Ml=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-5z70n4"&&(de.innerHTML=ks),pl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-dkenf7"&&(ce.innerHTML=Gs),ml=a(e),p(Te.$$.fragment,e),ul=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-ejreso"&&(we.innerHTML=Es),dl=a(e),ye=o(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-wqfgg1"&&(ye.innerHTML=Qs),cl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1w4jpzn"&&(Je.innerHTML=Vs),Tl=a(e),wl=o(e,"HR",{}),yl=a(e),p(he.$$.fragment,e),Jl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-41v40k"&&(ge.innerHTML=Xs),hl=a(e),p(Ue.$$.fragment,e),gl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-ximgze"&&(fe.textContent=Ns),Ul=a(e),p(Ie.$$.fragment,e),fl=a(e),p(je.$$.fragment,e),Il=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1h7mh3h"&&(be.innerHTML=Ss),jl=a(e),Ce=o(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-2ch3wm"&&(Ce.innerHTML=Ys),bl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1n114ah"&&($e.innerHTML=qs),Cl=a(e),p(ve.$$.fragment,e),$l=a(e),p(Be.$$.fragment,e),vl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-8dwavv"&&(_e.innerHTML=zs),Bl=a(e),Ze=o(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-1kixzkm"&&(Ze.innerHTML=Ps),_l=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-170mf7l"&&(Ae.textContent=Ds),Zl=a(e),p(We.$$.fragment,e),Al=a(e),p(He.$$.fragment,e),Wl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-kxzbug"&&(xe.textContent=Ks),Hl=a(e),Re=o(e,"OL",{"data-svelte-h":!0}),r(Re)!=="svelte-pbze45"&&(Re.innerHTML=Os),xl=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-tqjfkj"&&(Fe.textContent=en),Rl=a(e),p(Le.$$.fragment,e),Fl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1eg4wzk"&&(ke.innerHTML=tn),Ll=a(e),p(Ge.$$.fragment,e),kl=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-idq95d"&&(Ee.innerHTML=ln),Gl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1b32icm"&&(Qe.innerHTML=sn),El=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-97m84n"&&(Ve.textContent=nn),Ql=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1smtf1g"&&(Xe.innerHTML=an),Vl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-hiqun9"&&(Ne.textContent=on),Xl=a(e),Se=o(e,"UL",{"data-svelte-h":!0}),r(Se)!=="svelte-1ajz8o2"&&(Se.innerHTML=rn),Nl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-16jnk0c"&&(Ye.textContent=Mn),Sl=a(e),p(qe.$$.fragment,e),Yl=a(e),p(ze.$$.fragment,e),ql=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-38jf8e"&&(Pe.innerHTML=pn),zl=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-nf31ng"&&(De.innerHTML=mn),Pl=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-14o8e9l"&&(Ke.innerHTML=un),Dl=a(e),p(Oe.$$.fragment,e),Kl=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1lncu3d"&&(et.innerHTML=dn),Ol=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-aqr5u9"&&(tt.textContent=cn),es=a(e),lt=o(e,"UL",{"data-svelte-h":!0}),r(lt)!=="svelte-16pbkoa"&&(lt.innerHTML=Tn),ts=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1r3yd65"&&(st.innerHTML=wn),ls=a(e),p(nt.$$.fragment,e),ss=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-42sriz"&&(at.innerHTML=yn),ns=a(e),p(it.$$.fragment,e),as=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-nf8xdu"&&(ot.textContent=Jn),is=a(e),rt=o(e,"UL",{"data-svelte-h":!0}),r(rt)!=="svelte-b7ldte"&&(rt.innerHTML=hn),os=a(e),p(Mt.$$.fragment,e),rs=a(e),wt=o(e,"P",{}),ct(wt).forEach(l),this.h()},h(){j(J,"name","hf:doc:metadata"),j(J,"content",_n),j(h,"class","warning"),j(g,"class","tip"),Un(y.src,_s="https://huggingface.co/datasets/HuggingFaceM4/ChartQA/embed/viewer/default/train")||j(y,"src",_s),j(y,"frameborder","0"),j(y,"width","100%"),j(y,"height","560px")},m(e,t){pt(document.head,J),s(e,yt,t),s(e,Tt,t),s(e,Jt,t),m(b,e,t),s(e,ht,t),m(C,e,t),s(e,gt,t),s(e,$,t),s(e,Ut,t),m(v,e,t),s(e,ft,t),s(e,B,t),s(e,It,t),s(e,_,t),s(e,jt,t),m(Z,e,t),s(e,bt,t),s(e,A,t),s(e,Ct,t),m(W,e,t),s(e,$t,t),s(e,h,t),s(e,vt,t),s(e,H,t),s(e,Bt,t),m(x,e,t),s(e,_t,t),m(R,e,t),s(e,Zt,t),s(e,F,t),s(e,At,t),m(L,e,t),s(e,Wt,t),m(k,e,t),s(e,Ht,t),m(G,e,t),s(e,xt,t),s(e,E,t),s(e,Rt,t),m(Q,e,t),s(e,Ft,t),m(V,e,t),s(e,Lt,t),s(e,X,t),s(e,kt,t),s(e,g,t),s(e,Gt,t),m(N,e,t),s(e,Et,t),m(S,e,t),s(e,Qt,t),s(e,Y,t),s(e,Vt,t),m(q,e,t),s(e,Xt,t),m(z,e,t),s(e,Nt,t),s(e,P,t),s(e,St,t),s(e,D,t),s(e,Yt,t),s(e,y,t),s(e,qt,t),m(K,e,t),s(e,zt,t),s(e,U,t),pt(U,mt),pt(U,ds),m(O,U,null),s(e,Pt,t),m(ee,e,t),s(e,Dt,t),s(e,te,t),s(e,Kt,t),m(le,e,t),s(e,Ot,t),s(e,se,t),s(e,el,t),s(e,ne,t),s(e,tl,t),m(ae,e,t),s(e,ll,t),s(e,f,t),pt(f,ut),pt(f,cs),m(ie,f,null),s(e,sl,t),m(oe,e,t),s(e,nl,t),s(e,re,t),s(e,al,t),m(Me,e,t),s(e,il,t),s(e,I,t),pt(I,dt),pt(I,Ts),m(pe,I,null),s(e,ol,t),s(e,me,t),s(e,rl,t),m(ue,e,t),s(e,Ml,t),s(e,de,t),s(e,pl,t),s(e,ce,t),s(e,ml,t),m(Te,e,t),s(e,ul,t),s(e,we,t),s(e,dl,t),s(e,ye,t),s(e,cl,t),s(e,Je,t),s(e,Tl,t),s(e,wl,t),s(e,yl,t),m(he,e,t),s(e,Jl,t),s(e,ge,t),s(e,hl,t),m(Ue,e,t),s(e,gl,t),s(e,fe,t),s(e,Ul,t),m(Ie,e,t),s(e,fl,t),m(je,e,t),s(e,Il,t),s(e,be,t),s(e,jl,t),s(e,Ce,t),s(e,bl,t),s(e,$e,t),s(e,Cl,t),m(ve,e,t),s(e,$l,t),m(Be,e,t),s(e,vl,t),s(e,_e,t),s(e,Bl,t),s(e,Ze,t),s(e,_l,t),s(e,Ae,t),s(e,Zl,t),m(We,e,t),s(e,Al,t),m(He,e,t),s(e,Wl,t),s(e,xe,t),s(e,Hl,t),s(e,Re,t),s(e,xl,t),s(e,Fe,t),s(e,Rl,t),m(Le,e,t),s(e,Fl,t),s(e,ke,t),s(e,Ll,t),m(Ge,e,t),s(e,kl,t),s(e,Ee,t),s(e,Gl,t),s(e,Qe,t),s(e,El,t),s(e,Ve,t),s(e,Ql,t),s(e,Xe,t),s(e,Vl,t),s(e,Ne,t),s(e,Xl,t),s(e,Se,t),s(e,Nl,t),s(e,Ye,t),s(e,Sl,t),m(qe,e,t),s(e,Yl,t),m(ze,e,t),s(e,ql,t),s(e,Pe,t),s(e,zl,t),s(e,De,t),s(e,Pl,t),s(e,Ke,t),s(e,Dl,t),m(Oe,e,t),s(e,Kl,t),s(e,et,t),s(e,Ol,t),s(e,tt,t),s(e,es,t),s(e,lt,t),s(e,ts,t),s(e,st,t),s(e,ls,t),m(nt,e,t),s(e,ss,t),s(e,at,t),s(e,ns,t),m(it,e,t),s(e,as,t),s(e,ot,t),s(e,is,t),s(e,rt,t),s(e,os,t),m(Mt,e,t),s(e,rs,t),s(e,wt,t),Ms=!0},p:fn,i(e){Ms||(u(b.$$.fragment,e),u(C.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(x.$$.fragment,e),u(R.$$.fragment,e),u(L.$$.fragment,e),u(k.$$.fragment,e),u(G.$$.fragment,e),u(Q.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(Me.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(Te.$$.fragment,e),u(he.$$.fragment,e),u(Ue.$$.fragment,e),u(Ie.$$.fragment,e),u(je.$$.fragment,e),u(ve.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u(He.$$.fragment,e),u(Le.$$.fragment,e),u(Ge.$$.fragment,e),u(qe.$$.fragment,e),u(ze.$$.fragment,e),u(Oe.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(Mt.$$.fragment,e),Ms=!0)},o(e){d(b.$$.fragment,e),d(C.$$.fragment,e),d(v.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(L.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(Q.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(z.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(Me.$$.fragment,e),d(pe.$$.fragment,e),d(ue.$$.fragment,e),d(Te.$$.fragment,e),d(he.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d(je.$$.fragment,e),d(ve.$$.fragment,e),d(Be.$$.fragment,e),d(We.$$.fragment,e),d(He.$$.fragment,e),d(Le.$$.fragment,e),d(Ge.$$.fragment,e),d(qe.$$.fragment,e),d(ze.$$.fragment,e),d(Oe.$$.fragment,e),d(nt.$$.fragment,e),d(it.$$.fragment,e),d(Mt.$$.fragment,e),Ms=!1},d(e){e&&(l(yt),l(Tt),l(Jt),l(ht),l(gt),l($),l(Ut),l(ft),l(B),l(It),l(_),l(jt),l(bt),l(A),l(Ct),l($t),l(h),l(vt),l(H),l(Bt),l(_t),l(Zt),l(F),l(At),l(Wt),l(Ht),l(xt),l(E),l(Rt),l(Ft),l(Lt),l(X),l(kt),l(g),l(Gt),l(Et),l(Qt),l(Y),l(Vt),l(Xt),l(Nt),l(P),l(St),l(D),l(Yt),l(y),l(qt),l(zt),l(U),l(Pt),l(Dt),l(te),l(Kt),l(Ot),l(se),l(el),l(ne),l(tl),l(ll),l(f),l(sl),l(nl),l(re),l(al),l(il),l(I),l(ol),l(me),l(rl),l(Ml),l(de),l(pl),l(ce),l(ml),l(ul),l(we),l(dl),l(ye),l(cl),l(Je),l(Tl),l(wl),l(yl),l(Jl),l(ge),l(hl),l(gl),l(fe),l(Ul),l(fl),l(Il),l(be),l(jl),l(Ce),l(bl),l($e),l(Cl),l($l),l(vl),l(_e),l(Bl),l(Ze),l(_l),l(Ae),l(Zl),l(Al),l(Wl),l(xe),l(Hl),l(Re),l(xl),l(Fe),l(Rl),l(Fl),l(ke),l(Ll),l(kl),l(Ee),l(Gl),l(Qe),l(El),l(Ve),l(Ql),l(Xe),l(Vl),l(Ne),l(Xl),l(Se),l(Nl),l(Ye),l(Sl),l(Yl),l(ql),l(Pe),l(zl),l(De),l(Pl),l(Ke),l(Dl),l(Kl),l(et),l(Ol),l(tt),l(es),l(lt),l(ts),l(st),l(ls),l(ss),l(at),l(ns),l(as),l(ot),l(is),l(rt),l(os),l(rs),l(wt)),l(J),c(b,e),c(C,e),c(v,e),c(Z,e),c(W,e),c(x,e),c(R,e),c(L,e),c(k,e),c(G,e),c(Q,e),c(V,e),c(N,e),c(S,e),c(q,e),c(z,e),c(K,e),c(O),c(ee,e),c(le,e),c(ae,e),c(ie),c(oe,e),c(Me,e),c(pe),c(ue,e),c(Te,e),c(he,e),c(Ue,e),c(Ie,e),c(je,e),c(ve,e),c(Be,e),c(We,e),c(He,e),c(Le,e),c(Ge,e),c(qe,e),c(ze,e),c(Oe,e),c(nt,e),c(it,e),c(Mt,e)}}}const _n='{"title":"Hands-On Exercises: Fine-Tuning SmolVLM2-2.2B-Instruct","local":"hands-on-exercises-fine-tuning-smolvlm2-22b-instruct","sections":[{"title":"Learning Objectives","local":"learning-objectives","sections":[{"title":"Exercise 1: Explore SmolVLM2-2.2B-Instruct","local":"exercise-1-explore-smolvlm2-22b-instruct","sections":[],"depth":3},{"title":"Environment Setup","local":"environment-setup","sections":[],"depth":3},{"title":"Import dependencies","local":"import-dependencies","sections":[],"depth":3},{"title":"Load the model and processor","local":"load-the-model-and-processor","sections":[{"title":"1. Select the device","local":"1-select-the-device","sections":[],"depth":4},{"title":"2. Authenticate with Hugging Face","local":"2-authenticate-with-hugging-face","sections":[],"depth":4},{"title":"3. Load the model and processor","local":"3-load-the-model-and-processor","sections":[],"depth":4}],"depth":3},{"title":"Explore the dataset","local":"explore-the-dataset","sections":[],"depth":3},{"title":"Build a chat-style prompt","local":"build-a-chat-style-prompt","sections":[],"depth":3},{"title":"Run inference","local":"run-inference","sections":[],"depth":3}],"depth":2},{"title":"Exercise 2: Fine-Tune the Model Using LoRA","local":"exercise-2-fine-tune-the-model-using-lora","sections":[{"title":"Format the Dataset","local":"format-the-dataset","sections":[],"depth":3},{"title":"Configure LoRA","local":"configure-lora","sections":[],"depth":3},{"title":"Set up the Trainer","local":"set-up-the-trainer","sections":[],"depth":3},{"title":"Train and Save the Model","local":"train-and-save-the-model","sections":[],"depth":3}],"depth":2},{"title":"Exercise 3: Production Workflow with TRL CLI","local":"exercise-3-production-workflow-with-trl-cli","sections":[],"depth":2},{"title":"Exercise 4: Training with Hugging Face Jobs","local":"exercise-4-training-with-hugging-face-jobs","sections":[],"depth":2},{"title":"Test your knowledge","local":"test-your-knowledge","sections":[],"depth":2},{"title":"Resources for Further Learning","local":"resources-for-further-learning","sections":[],"depth":2}],"depth":1}';function Zn(ws){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fn extends jn{constructor(J){super(),bn(this,J,Zn,Bn,gn,{})}}export{Fn as component};
