import{s as jt,n as dt,o as gt}from"../chunks/scheduler.3e4cb221.js";import{S as wt,i as Ct,g as i,s as a,r as o,A as It,h as p,f as l,c as n,j as zs,u,x as M,k as As,y as ns,a as e,v as r,d as c,t as y,w as U}from"../chunks/index.e1c70545.js";import{C as ls}from"../chunks/CodeBlock.72e9ab19.js";import{H as j,E as ft}from"../chunks/getInferenceSnippets.62bbd402.js";function bt(Ps){let m,is,es,ps,d,Ms,g,Ds="Visual Language Models (VLMs) process <strong>images and text simultaneously</strong>, enabling advanced tasks like generating captions, answering visual questions, or reasoning across modalities. In this section, we focus on <strong>how VLMs work and how to use them practically</strong>.",os,w,us,C,Ks='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/VLM_Architecture.png" alt="VLM Architecture"/>',rs,I,Os="VLMs combine image-processing and text-generation components for a unified multimodal understanding. The main elements are:",cs,f,st="<li><strong>Image/Vision Encoder</strong>: Converts images into compact numerical representations. Examples: CLIP, SigLIP.</li> <li><strong>Embedding Projector</strong>: Aligns image features with text embeddings (often a small MLP or linear layer fine-tuned for the multimodal task).</li> <li><strong>Multimodal Projector / Fusion Module</strong>: Fuses and enhances connections between visual and textual representations. This step goes beyond alignment, enabling rich cross-modal interaction.representations.</li> <li><strong>Text Decoder</strong>: Generates text (or other outputs) from the fused multimodal representations.</li>",ys,b,tt="Most VLMs leverage <strong>pretrained image encoders and text decoders</strong>, then fine-tune on paired image-text datasets for efficient training and generalization.",Us,Z,ms,B,lt="VLMs can be applied to tasks such as:",hs,v,et="<li><strong>Image Captioning:</strong> generating descriptions for images</li> <li><strong>Visual Question Answering (VQA):</strong> answering questions about an image</li> <li><strong>Cross-Modal Retrieval:</strong> matching images with text and vice versa</li> <li><strong>Creative Applications:</strong> design, art generation, multimedia content</li>",Js,G,at="High-quality paired datasets are key, and 🤗 transformers provide pretrained models and streamlined fine-tuning workflows.",Ts,W,nt='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/VLM_Usage.png" alt="VLM Usage"/>',js,q,ds,R,it="Many VLMs support <strong>chat-like interactions</strong>, with messages structured as:",gs,V,pt="<li><strong>System message:</strong> sets context: <code>&quot;You are an assistant analyzing visual data.&quot;</code></li> <li><strong>User queries:</strong> combine text and images.</li> <li><strong>Assistant responses:</strong> generated text based on multimodal analysis.</li>",ws,$,Mt="Example:",Cs,Q,Is,x,ot="VLMs can also handle <strong>multiple images or video frames</strong> as input by passing sequences of images through the same chat template.",fs,N,bs,H,ut='As we saw in <a href="../unit1/2">Unit 1</a>, the easiest way to use a VLM is through the 🤗 <code>pipeline</code> abstraction:',Zs,S,Bs,h,ss,rt="Output",Ls,k,vs,E,Gs,X,ct=`For advanced use, you can access a VLM directly via 🤗 Transformers, giving you <strong>full control over each component</strong>.<br/>
To reduce memory usage and speed up inference, we can apply <strong>4-bit quantization</strong> using <code>bitsandbytes</code>.`,Ws,Y,yt="Unlike standard LLM usage, VLMs require a <strong>processor</strong> instead of just a tokenizer. The processor handles both <strong>text tokenization</strong> and <strong>image preprocessing</strong>, streamlining the workflow for multimodal inputs.",qs,F,Rs,z,Vs,L,Ut="We can use the <strong>chat template</strong> to describe images. Each image is represented as <code>{&quot;type&quot;: &quot;image&quot;}</code> in the message, and the actual image data is passed to the processor via the <code>images</code> argument. The processor handles both text and visual inputs seamlessly.",$s,_,Qs,J,ts,mt="Output",_s,A,xs,P,ht="The processor combines the text and image inputs, so the model can generate coherent multimodal outputs.",Ns,T,Jt="<p>Similar templates can handle multiple images, OCR tasks, or even video frames, making VLMs highly versatile.</p>",Hs,D,Ss,K,Tt='<li><a href="https://huggingface.co/blog/vlms-2025" rel="nofollow">Vision Language Models (Better, Faster, Stronger)</a></li> <li><a href="https://huggingface.co/blog/vlms" rel="nofollow">Vision Language Models Explained</a></li> <li><a href="https://huggingface.co/blog/smolvlm" rel="nofollow">SmolVLM - small yet mighty Vision Language Model</a></li>',ks,O,Es,as,Xs;return d=new j({props:{title:"Using Pretrained VLMs",local:"using-pretrained-vlms",headingTag:"h1"}}),w=new j({props:{title:"Architecture Overview",local:"architecture-overview",headingTag:"h2"}}),Z=new j({props:{title:"Practical Usage",local:"practical-usage",headingTag:"h2"}}),q=new j({props:{title:"Chat Format",local:"chat-format",headingTag:"h3"}}),Q=new ls({props:{code:"JTVCJTBBJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwVkxNJTIwc3BlY2lhbGl6ZWQlMjBpbiUyMGNoYXJ0cy4lMjIlN0QlNUQlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJpbWFnZSUyMiUzQSUyMCUyMiUzQ2ltYWdlX2RhdGElM0UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBoaWdoZXN0JTIwdmFsdWUlMjBpbiUyMHRoaXMlMjBjaGFydCUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyNDIlMjIlN0QlNUQlMEElMjAlMjAlN0QlMEElNUQ=",highlighted:`<span class="hljs-punctuation">[</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are a VLM specialized in charts.&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
      <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;image&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;image_data&gt;&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is the highest value in this chart?&quot;</span><span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;text&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;42&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">]</span>`,wrap:!1}}),N=new j({props:{title:"Using a VLM via pipeline",local:"using-a-vlm-via-pipeline",headingTag:"h2"}}),S=new ls({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHBpcGVsaW5lJTIwd2l0aCUyMGElMjBWTE0lMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2UtdGV4dC10by10ZXh0JTIyJTJDJTIwJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xWTE0yLTIuMkItSW5zdHJ1Y3QlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEElMEElMjMlMjBEZWZpbmUlMjB5b3VyJTIwY29udmVyc2F0aW9uJTIwd2l0aCUyMGFuJTIwaW1hZ2UlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCU1RCUwQSUwQW91dHB1dHMlMjAlM0QlMjBwaXBlKHRleHQlM0RtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjAlMkMlMjByZXR1cm5fZnVsbF90ZXh0JTNERmFsc2UpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjByZXNwb25zZSUyMC0lMjBwaXBlbGluZSUyMGhhbmRsZXMlMjBtdWx0aW1vZGFsJTIwaW5wdXRzJTIwYXV0b21hdGljYWxseSUwQXJlc3BvbnNlJTIwJTNEJTIwcGlwZShtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTIwdGVtcGVyYXR1cmUlM0QwLjcpJTBBJTBBcHJpbnQocmVzcG9uc2UlNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEJTVCJ2NvbnRlbnQnJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwbW9kZWwncyUyMGRlc2NyaXB0aW9u",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Initialize the pipeline with a VLM</span>
pipe = pipeline(<span class="hljs-string">&quot;image-text-to-text&quot;</span>, <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

<span class="hljs-comment"># Define your conversation with an image</span>
messages = [
     {
         <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
         <span class="hljs-string">&quot;content&quot;</span>: [
             {
                 <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                 <span class="hljs-string">&quot;image&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>,
             },
             {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image.&quot;</span>},
         ],
     }
 ]

outputs = pipe(text=messages, max_new_tokens=<span class="hljs-number">60</span>, return_full_text=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Generate response - pipeline handles multimodal inputs automatically</span>
response = pipe(messages, max_new_tokens=<span class="hljs-number">128</span>, temperature=<span class="hljs-number">0.7</span>)

<span class="hljs-built_in">print</span>(response[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>][<span class="hljs-string">&#x27;content&#x27;</span>])  <span class="hljs-comment"># Print the model&#x27;s description</span>`,wrap:!1}}),k=new ls({props:{code:"VGhlJTIwaW1hZ2UlMjBkZXBpY3RzJTIwYSUyMGNsb3NlLXVwJTIwdmlldyUyMG9mJTIwYSUyMGZsb3dlciUyMGdhcmRlbiUyQyUyMHNwZWNpZmljYWxseSUyMGZvY3VzaW5nJTIwb24lMjBhJTIwcGluayUyMGZsb3dlci4lMjBUaGUlMjBmbG93ZXIlMjBpcyUyMHRoZSUyMGNlbnRyYWwlMjBzdWJqZWN0JTIwb2YlMjB0aGUlMjBpbWFnZSUyQyUyMGFuZCUyMGl0JTIwaXMlMjBhJTIwcHJvbWluZW50JTIwZmVhdHVyZSUyMGR1ZSUyMHRvJTIwaXRzJTIwdmlicmFudCUyMGNvbG9yJTIwYW5kJTIwaW50cmljYXRlJTIwZGV0YWlscy4lMjBUaGUlMjBmbG93ZXIlMjBoYXMlMjBhJTIwY2lyY3VsYXIlMjBzaGFwZSUyQyUyMHdpdGglMjBwZXRhbHMlMjB0aGF0JTIwYXJlJTIwc2xpZ2h0bHklMjBjdXJsZWQlMjBhbmQlMjBoYXZlJTIwYSUyMGdyYWRpZW50JTIwZnJvbSUyMGxpZ2h0JTIwdG8lMjBkYXJrJTIwcGluay4lMjBUaGUlMjBwZXRhbHMlMjBhcmUlMjBhcnJhbmdlZCUyMHN5bW1ldHJpY2FsbHklMjBhcm91bmQlMjB0aGUlMjBjZW50cmFsJTIwcGlzdGlsJTJDJTIwd2hpY2glMjBpcyUyMHZpc2libGUlMjBpbiUyMHRoZSUyMGNlbnRlciUyMG9mJTIwdGhlJTIwZmxvd2VyLiUyMFRoZSUyMHBpc3RpbCUyMGlzJTIwYSUyMHNtYWxsJTJDJTIweWVsbG93JTIwc3RydWN0dXJlJTIwdGhhdCUyMGlzJTIwc3Vycm91bmRlZCUyMGJ5JTIwYSUyMGNsdXN0ZXIlMjBvZiUyMHN0YW1lbnMlMkMlMjB3aGljaCUyMGFyZSUyMHZpc2libGUlMjBhcyUyMHNtYWxsJTJDJTIweWVsbG93JTIwc3RydWN0dXJlcy4lMjBUaGUlMjBmbG93ZXIlMjBhbHNvJTIwaGFzJTIwYSUyMHNtYWxsJTJDJTIwYmxhY2s=",highlighted:"The image depicts a close-up view of a flower garden, specifically focusing on a pink flower. The flower is the central subject of the image, and it is a prominent feature due to its vibrant color and intricate details. The flower has a circular shape, with petals that are slightly curled and have a gradient from light to dark pink. The petals are arranged symmetrically around the central pistil, which is visible in the center of the flower. The pistil is a small, yellow structure that is surrounded by a cluster of stamens, which are visible as small, yellow structures. The flower also has a small, black",wrap:!1}}),E=new j({props:{title:"Using a VLM via Transformers (Full Control)",local:"using-a-vlm-via-transformers-full-control",headingTag:"h2"}}),F=new ls({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMuaW1hZ2VfdXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEElMjMlMjBRdWFudGl6YXRpb24lMjBmb3IlMjBlZmZpY2llbmN5JTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNMi0yLjJCLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText, BitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

<span class="hljs-comment"># Quantization for efficiency</span>
quant_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)
model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>
model = AutoModelForImageTextToText.from_pretrained(model_name, quantization_config=quant_config).to(device)
processor = AutoProcessor.from_pretrained(model_name)`,wrap:!1}}),z=new j({props:{title:"Example: Describe an Image",local:"example-describe-an-image",headingTag:"h3"}}),_=new ls({props:{code:"JTIzJTIwTG9hZCUyMGltYWdlJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwaW5wdXQlMjBtZXNzYWdlcyUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyQ2FuJTIweW91JTIwZGVzY3JpYmUlMjB0aGUlMjBpbWFnZSUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RCUwQSUwQSUyMyUyMFByZXBhcmUlMjBpbnB1dHMlMEFwcm9tcHQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjBpbWFnZXMlM0QlNUJpbWFnZSU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwaW5wdXRzLnRvKGRldmljZSklMEElMEElMjMlMjBHZW5lcmF0ZSUyMG91dHB1dHMlMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwMCklMEFnZW5lcmF0ZWRfdGV4dHMlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9pZHMlMkMlMEElMjAlMjAlMjAlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUwQSklNUIwJTVEJTBBJTBBJTIzJTIwRXh0cmFjdCUyMG9ubHklMjB0aGUlMjBhc3Npc3RhbnQlMjByZXNwb25zZSUwQWFzc2lzdGFudF9yZXNwb25zZSUyMCUzRCUyMGdlbmVyYXRlZF90ZXh0cy5zcGxpdCglMjJBc3Npc3RhbnQlM0ElMjIpJTVCLTElNUQuc3RyaXAoKSUwQSUwQXByaW50KGFzc2lzdGFudF9yZXNwb25zZSk=",highlighted:`<span class="hljs-comment"># Load image</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
image = load_image(image_url)

<span class="hljs-comment"># Create input messages</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Can you describe the image?&quot;</span>}
        ]
    },
]

<span class="hljs-comment"># Prepare inputs</span>
prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(text=prompt, images=[image], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = inputs.to(device)

<span class="hljs-comment"># Generate outputs</span>
generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">500</span>)
generated_texts = processor.batch_decode(
    generated_ids,
    skip_special_tokens=<span class="hljs-literal">True</span>,
)[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Extract only the assistant response</span>
assistant_response = generated_texts.split(<span class="hljs-string">&quot;Assistant:&quot;</span>)[-<span class="hljs-number">1</span>].strip()

<span class="hljs-built_in">print</span>(assistant_response)`,wrap:!1}}),A=new ls({props:{code:"VGhlJTIwaW1hZ2UlMjBpcyUyMG9mJTIwYSUyMGJlZSUyMG9uJTIwYSUyMGZsb3dlci4=",highlighted:"The image is of a bee on a flower.",wrap:!1}}),D=new j({props:{title:"Resources",local:"resources",headingTag:"h2"}}),O=new ft({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit3/2.md"}}),{c(){m=i("meta"),is=a(),es=i("p"),ps=a(),o(d.$$.fragment),Ms=a(),g=i("p"),g.innerHTML=Ds,os=a(),o(w.$$.fragment),us=a(),C=i("p"),C.innerHTML=Ks,rs=a(),I=i("p"),I.textContent=Os,cs=a(),f=i("ul"),f.innerHTML=st,ys=a(),b=i("p"),b.innerHTML=tt,Us=a(),o(Z.$$.fragment),ms=a(),B=i("p"),B.textContent=lt,hs=a(),v=i("ul"),v.innerHTML=et,Js=a(),G=i("p"),G.textContent=at,Ts=a(),W=i("p"),W.innerHTML=nt,js=a(),o(q.$$.fragment),ds=a(),R=i("p"),R.innerHTML=it,gs=a(),V=i("ol"),V.innerHTML=pt,ws=a(),$=i("p"),$.textContent=Mt,Cs=a(),o(Q.$$.fragment),Is=a(),x=i("p"),x.innerHTML=ot,fs=a(),o(N.$$.fragment),bs=a(),H=i("p"),H.innerHTML=ut,Zs=a(),o(S.$$.fragment),Bs=a(),h=i("details"),ss=i("summary"),ss.textContent=rt,Ls=a(),o(k.$$.fragment),vs=a(),o(E.$$.fragment),Gs=a(),X=i("p"),X.innerHTML=ct,Ws=a(),Y=i("p"),Y.innerHTML=yt,qs=a(),o(F.$$.fragment),Rs=a(),o(z.$$.fragment),Vs=a(),L=i("p"),L.innerHTML=Ut,$s=a(),o(_.$$.fragment),Qs=a(),J=i("details"),ts=i("summary"),ts.textContent=mt,_s=a(),o(A.$$.fragment),xs=a(),P=i("p"),P.textContent=ht,Ns=a(),T=i("blockquote"),T.innerHTML=Jt,Hs=a(),o(D.$$.fragment),Ss=a(),K=i("ul"),K.innerHTML=Tt,ks=a(),o(O.$$.fragment),Es=a(),as=i("p"),this.h()},l(s){const t=It("svelte-u9bgzb",document.head);m=p(t,"META",{name:!0,content:!0}),t.forEach(l),is=n(s),es=p(s,"P",{}),zs(es).forEach(l),ps=n(s),u(d.$$.fragment,s),Ms=n(s),g=p(s,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1x3y1qf"&&(g.innerHTML=Ds),os=n(s),u(w.$$.fragment,s),us=n(s),C=p(s,"P",{"data-svelte-h":!0}),M(C)!=="svelte-vvc5qe"&&(C.innerHTML=Ks),rs=n(s),I=p(s,"P",{"data-svelte-h":!0}),M(I)!=="svelte-adkga0"&&(I.textContent=Os),cs=n(s),f=p(s,"UL",{"data-svelte-h":!0}),M(f)!=="svelte-1s27o17"&&(f.innerHTML=st),ys=n(s),b=p(s,"P",{"data-svelte-h":!0}),M(b)!=="svelte-unkaqn"&&(b.innerHTML=tt),Us=n(s),u(Z.$$.fragment,s),ms=n(s),B=p(s,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1jrkij4"&&(B.textContent=lt),hs=n(s),v=p(s,"UL",{"data-svelte-h":!0}),M(v)!=="svelte-d0zug6"&&(v.innerHTML=et),Js=n(s),G=p(s,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1pcr0l7"&&(G.textContent=at),Ts=n(s),W=p(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1s12bgo"&&(W.innerHTML=nt),js=n(s),u(q.$$.fragment,s),ds=n(s),R=p(s,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1qfbv65"&&(R.innerHTML=it),gs=n(s),V=p(s,"OL",{"data-svelte-h":!0}),M(V)!=="svelte-1i8rfc0"&&(V.innerHTML=pt),ws=n(s),$=p(s,"P",{"data-svelte-h":!0}),M($)!=="svelte-11lpom8"&&($.textContent=Mt),Cs=n(s),u(Q.$$.fragment,s),Is=n(s),x=p(s,"P",{"data-svelte-h":!0}),M(x)!=="svelte-wso7db"&&(x.innerHTML=ot),fs=n(s),u(N.$$.fragment,s),bs=n(s),H=p(s,"P",{"data-svelte-h":!0}),M(H)!=="svelte-siuzhz"&&(H.innerHTML=ut),Zs=n(s),u(S.$$.fragment,s),Bs=n(s),h=p(s,"DETAILS",{});var Ys=zs(h);ss=p(Ys,"SUMMARY",{"data-svelte-h":!0}),M(ss)!=="svelte-nfzy3j"&&(ss.textContent=rt),Ls=n(Ys),u(k.$$.fragment,Ys),Ys.forEach(l),vs=n(s),u(E.$$.fragment,s),Gs=n(s),X=p(s,"P",{"data-svelte-h":!0}),M(X)!=="svelte-5cbqik"&&(X.innerHTML=ct),Ws=n(s),Y=p(s,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-imt3e1"&&(Y.innerHTML=yt),qs=n(s),u(F.$$.fragment,s),Rs=n(s),u(z.$$.fragment,s),Vs=n(s),L=p(s,"P",{"data-svelte-h":!0}),M(L)!=="svelte-q4e8ot"&&(L.innerHTML=Ut),$s=n(s),u(_.$$.fragment,s),Qs=n(s),J=p(s,"DETAILS",{});var Fs=zs(J);ts=p(Fs,"SUMMARY",{"data-svelte-h":!0}),M(ts)!=="svelte-nfzy3j"&&(ts.textContent=mt),_s=n(Fs),u(A.$$.fragment,Fs),Fs.forEach(l),xs=n(s),P=p(s,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1v039s9"&&(P.textContent=ht),Ns=n(s),T=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-hq4ukg"&&(T.innerHTML=Jt),Hs=n(s),u(D.$$.fragment,s),Ss=n(s),K=p(s,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-uziv6c"&&(K.innerHTML=Tt),ks=n(s),u(O.$$.fragment,s),Es=n(s),as=p(s,"P",{}),zs(as).forEach(l),this.h()},h(){As(m,"name","hf:doc:metadata"),As(m,"content",Zt),As(T,"class","tip")},m(s,t){ns(document.head,m),e(s,is,t),e(s,es,t),e(s,ps,t),r(d,s,t),e(s,Ms,t),e(s,g,t),e(s,os,t),r(w,s,t),e(s,us,t),e(s,C,t),e(s,rs,t),e(s,I,t),e(s,cs,t),e(s,f,t),e(s,ys,t),e(s,b,t),e(s,Us,t),r(Z,s,t),e(s,ms,t),e(s,B,t),e(s,hs,t),e(s,v,t),e(s,Js,t),e(s,G,t),e(s,Ts,t),e(s,W,t),e(s,js,t),r(q,s,t),e(s,ds,t),e(s,R,t),e(s,gs,t),e(s,V,t),e(s,ws,t),e(s,$,t),e(s,Cs,t),r(Q,s,t),e(s,Is,t),e(s,x,t),e(s,fs,t),r(N,s,t),e(s,bs,t),e(s,H,t),e(s,Zs,t),r(S,s,t),e(s,Bs,t),e(s,h,t),ns(h,ss),ns(h,Ls),r(k,h,null),e(s,vs,t),r(E,s,t),e(s,Gs,t),e(s,X,t),e(s,Ws,t),e(s,Y,t),e(s,qs,t),r(F,s,t),e(s,Rs,t),r(z,s,t),e(s,Vs,t),e(s,L,t),e(s,$s,t),r(_,s,t),e(s,Qs,t),e(s,J,t),ns(J,ts),ns(J,_s),r(A,J,null),e(s,xs,t),e(s,P,t),e(s,Ns,t),e(s,T,t),e(s,Hs,t),r(D,s,t),e(s,Ss,t),e(s,K,t),e(s,ks,t),r(O,s,t),e(s,Es,t),e(s,as,t),Xs=!0},p:dt,i(s){Xs||(c(d.$$.fragment,s),c(w.$$.fragment,s),c(Z.$$.fragment,s),c(q.$$.fragment,s),c(Q.$$.fragment,s),c(N.$$.fragment,s),c(S.$$.fragment,s),c(k.$$.fragment,s),c(E.$$.fragment,s),c(F.$$.fragment,s),c(z.$$.fragment,s),c(_.$$.fragment,s),c(A.$$.fragment,s),c(D.$$.fragment,s),c(O.$$.fragment,s),Xs=!0)},o(s){y(d.$$.fragment,s),y(w.$$.fragment,s),y(Z.$$.fragment,s),y(q.$$.fragment,s),y(Q.$$.fragment,s),y(N.$$.fragment,s),y(S.$$.fragment,s),y(k.$$.fragment,s),y(E.$$.fragment,s),y(F.$$.fragment,s),y(z.$$.fragment,s),y(_.$$.fragment,s),y(A.$$.fragment,s),y(D.$$.fragment,s),y(O.$$.fragment,s),Xs=!1},d(s){s&&(l(is),l(es),l(ps),l(Ms),l(g),l(os),l(us),l(C),l(rs),l(I),l(cs),l(f),l(ys),l(b),l(Us),l(ms),l(B),l(hs),l(v),l(Js),l(G),l(Ts),l(W),l(js),l(ds),l(R),l(gs),l(V),l(ws),l($),l(Cs),l(Is),l(x),l(fs),l(bs),l(H),l(Zs),l(Bs),l(h),l(vs),l(Gs),l(X),l(Ws),l(Y),l(qs),l(Rs),l(Vs),l(L),l($s),l(Qs),l(J),l(xs),l(P),l(Ns),l(T),l(Hs),l(Ss),l(K),l(ks),l(Es),l(as)),l(m),U(d,s),U(w,s),U(Z,s),U(q,s),U(Q,s),U(N,s),U(S,s),U(k),U(E,s),U(F,s),U(z,s),U(_,s),U(A),U(D,s),U(O,s)}}}const Zt='{"title":"Using Pretrained VLMs","local":"using-pretrained-vlms","sections":[{"title":"Architecture Overview","local":"architecture-overview","sections":[],"depth":2},{"title":"Practical Usage","local":"practical-usage","sections":[{"title":"Chat Format","local":"chat-format","sections":[],"depth":3}],"depth":2},{"title":"Using a VLM via pipeline","local":"using-a-vlm-via-pipeline","sections":[],"depth":2},{"title":"Using a VLM via Transformers (Full Control)","local":"using-a-vlm-via-transformers-full-control","sections":[{"title":"Example: Describe an Image","local":"example-describe-an-image","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Bt(Ps){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends wt{constructor(m){super(),Ct(this,m,Bt,bt,jt,{})}}export{Rt as component};
