import{s as gn,f as fn,o as Un,n as hn}from"../chunks/scheduler.3e4cb221.js";import{S as In,i as jn,g as i,s as n,r as M,A as bn,h as o,f as l,c as a,j as ht,u as p,x as r,k as gt,y as ct,a as s,v as m,d as u,t as d,w as c}from"../chunks/index.e1c70545.js";import{T as Jn}from"../chunks/Tip.31fd538c.js";import{C as y}from"../chunks/CodeBlock.72e9ab19.js";import{C as Cn}from"../chunks/CourseFloatingBanner.baa6815f.js";import{H as w,E as $n}from"../chunks/getInferenceSnippets.25162521.js";function vn(Tt){let T,h="<li>You need a GPU with at least 8GB VRAM for training. CPU/MPS can run formatting and dataset exploration, but training larger models will likely fail.</li> <li>First run will download several GB of model weights; ensure 15GB+ free disk and a stable connection.</li> <li>If you need access to private repos, authenticate with Hugging Face Hub via <code>login()</code>.</li>";return{c(){T=i("ul"),T.innerHTML=h},l(J){T=o(J,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-dj9x0w"&&(T.innerHTML=h)},m(J,f){s(J,T,f)},p:hn,d(J){J&&l(T)}}}function Bn(Tt){let T,h='You can create and copy your access token from the <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face tokens page</a> in your profile.';return{c(){T=i("p"),T.innerHTML=h},l(J){T=o(J,"P",{"data-svelte-h":!0}),r(T)!=="svelte-104d433"&&(T.innerHTML=h)},m(J,f){s(J,T,f)},p:hn,d(J){J&&l(T)}}}function _n(Tt){let T,h,J,f,$,Ut,v,It,B,ys=`Welcome to the practical section! Here you’ll put into practice everything you’ve learned about vision language models (VLMs) using <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong>.<br/>
The exercises progress from foundational concepts to advanced techniques, helping you gain real-world, hands-on experience.`,jt,_,bt,Z,Js="By the end of these exercises, you will be able to:",Ct,A,hs="<li><strong>Work with VLM datasets</strong>: Explore and prepare <strong>HuggingFaceM4/ChartQA</strong>.</li> <li><strong>Optimize training</strong>: Apply <strong>quantization</strong> and <strong>PEFT</strong> for efficient fine-tuning.</li> <li><strong>Fine-tune models in practice</strong>: Train <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong> using both Python APIs and CLI tools.</li> <li><strong>Adapt datasets for TRL</strong>: Prepare VLM datasets to integrate seamlessly with TRL workflows.</li> <li><strong>Move to production</strong>: Understand how to scale and manage <strong>production-ready fine-tuning workflows</strong> for VLMs.</li>",$t,W,vt,H,gs="<strong>Objective:</strong> Get familiar with the <code>SmolVLM2-2.2B-Instruct</code> model and evaluate the model using a sample from the dataset.",Bt,x,_t,U,Zt,R,fs=`First, install the required libraries: <code>transformers</code>, <code>datasets</code>, <code>trl</code>,<code>huggingface_hub</code>, and <code>trackio</code>.<br/>
These packages provide the tools for working with the model, datasets, and Hugging Face Hub.`,At,F,Wt,L,Ht,G,Us="Now, import the main dependencies we’ll use:",xt,k,Rt,V,Ft,E,Lt,Q,Is="We start by selecting the device where the model will run. It can be a GPU (<code>cuda</code>), Apple Silicon (<code>mps</code>), or the CPU as a fallback.",Gt,X,kt,N,Vt,S,js="To work with private models or to <strong>push your fine-tuned model to the Hub</strong> (as we’ll do in this exercise), you need to authenticate with your Hugging Face account.",Et,I,Qt,Y,Xt,z,Nt,q,bs=`Finally, we load the <strong>HuggingFaceTB/SmolVLM2-2.2B-Instruct</strong> model.
The <code>AutoProcessor</code> is also initialized here — it ensures that both text and images are preprocessed correctly before being passed to the model.`,St,P,Yt,D,zt,K,Cs="In this step, we load a small subset of the <strong>ChartQA</strong> dataset — just 10% of the training and validation splits — to keep the exercises fast and manageable for learning purposes.",qt,O,$s=`We then display one of the chart images using <code>matplotlib</code> to get a visual sense of the model’s input.<br/>
Additionally, we print the corresponding query and label so you can fully understand the dataset structure and the type of tasks the model will handle.`,Pt,g,vs,Dt,ee,Kt,j,wt,Bs="Output",cs,te,Ot,le,el,se,_s='<img src="https://huggingface.co/datasets/smol-course/images/resolve/main/model_output.png" alt="Model output"/>',tl,ne,ll,ae,Zs="We create a <strong>chat message list</strong> that includes a user query along with the image.",sl,ie,As="Using <code>processor.apply_chat_template</code>, we transform this into the exact input format the model expects.",nl,oe,al,b,yt,Ws="Output",Ts,re,il,Me,ol,pe,Hs=`We tokenize the chat prompt and image into tensors, then generate a response with the model.
Finally, we decode the output tokens back into text.`,rl,me,Ml,C,Jt,xs="Output",ws,ue,pl,de,Rs="The model generates a reponse, but it’s not exactly correct. It could be improved with some fine-tuning. Now that we’ve seen how to build prompts and generate responses with <strong>SmolVLM2-2.2B-Instruct</strong>, it’s time to learn how to adapt and <strong>fine-tune</strong> the model efficiently using <strong>LoRA (Low-Rank Adaptation)</strong>. This approach allows training large models with fewer resources and prepares the model for specific downstream tasks.",ml,ce,ul,Te,Fs="In this exercise, we’ll apply <strong>LoRA (Low-Rank Adaptation)</strong> to fine-tune our Vision-Language Model efficiently.",dl,we,Ls=`LoRA works by injecting <strong>trainable low-rank matrices</strong> into existing model layers, enabling <strong>large models to be fine-tuned with significantly fewer trainable parameters</strong>.<br/>
This approach reduces memory usage and speeds up training while maintaining high performance.`,cl,ye,Tl,Je,Gs="We’ll format the dataset into a <strong>chatbot-style structure</strong>, where each example includes:",wl,he,ks="<li>A <strong>system message</strong> defining the assistant’s role</li> <li>The <strong>chart image</strong></li> <li>The <strong>user query</strong></li> <li>The <strong>expected answer</strong></li>",yl,ge,Vs=`This is the format expected by the <code>SFTTrainer</code>, including the <code>images</code> and <code>messages</code> columns.<br/>
You can learn more about preparing datasets for VLM post-training in the <a href="https://huggingface.co/docs/trl/en/sft_trainer#training-vision-language-models" rel="nofollow">documentation</a>.`,Jl,hl,gl,fe,fl,Ue,Es=`The first step is to structure the dataset for VLM training.<br/>
We’ll define a <strong>system message</strong> that instructs the model to act as a <strong>chart analysis expert</strong>, providing <strong>concise, accurate answers</strong> about chart images.`,Ul,Ie,Il,je,Qs="Now, let’s format the data using the chatbot structure. This will set up the interactions for the model.",jl,be,bl,Ce,Cl,$e,Xs="Here we define a <code>LoraConfig</code>:",$l,ve,Ns="<li><code>r</code> and <code>lora_alpha</code> control the rank and scaling of the adaptation matrices.</li> <li><code>target_modules</code> specifies which parts of the model to adapt.</li> <li><code>task_type</code> is set for causal language modeling.</li>",vl,Be,Ss="We then apply LoRA to the base model using <code>get_peft_model</code> and print out the trainable parameters to verify the adaptation.",Bl,_e,_l,Ze,Zl,Ae,Ys="We configure the <strong>SFTTrainer</strong> from <code>trl</code> with <code>SFTConfig</code>:",Al,We,zs="<li><code>num_train_epochs</code>, <code>batch_size</code>, and <code>gradient_accumulation_steps</code> control the training loop.</li> <li><code>gradient_checkpointing</code>, and <code>bf16</code> optimize memory and speed.</li> <li><code>learning_rate</code> manages optimization.</li> <li><code>train_dataset</code> and <code>eval_dataset</code> are aligned with your dataset.</li>",Wl,He,qs="This prepares the trainer to handle fine-tuning with PEFT/LoRA.",Hl,xe,xl,Re,Rl,Fe,Ps="Now we run the training loop:",Fl,Le,Ds="<li><code>trainer.train()</code> starts fine-tuning with LoRA.</li> <li><code>trainer.save_model()</code> stores the locally trained model.</li>",Ll,Ge,Ks="This step ensures the model is ready for downstream tasks with minimal additional parameters.",Gl,ke,kl,Ve,Os="With the foundations of Python-based fine-tuning and LoRA in place, we can now move this workflow to a <strong>production environment</strong> using the <strong>TRL CLI</strong>. This approach lets you automate fine-tuning and create reproducible pipelines without writing full Python scripts.",Vl,Ee,El,Qe,en="In the previous exercises, we focused on using the Python API to fine-tune <strong>SmolVLM2-2.2B-Instruct</strong>, exploring dataset preparation and generating chat-style prompts.",Ql,Xe,tn='In this exercise, we’ll demonstrate how to perform fine-tuning using the <strong>TRL CLI</strong>, a common workflow in production environments. The CLI allows you to run experiments and manage training without writing Python scripts. If you want a refresher, we previously introduced this tool <a href="../unit1/4#exercise-4-production-workflow-with-trl-cli">here</a>, and the same concepts and troubleshooting tips apply.',Xl,Ne,ln="The TRL CLI leverages the same logic and configuration options as the Python API but presents them through a simple command-line interface. This means you can define everything—from the model and dataset to training hyperparameters and output location—in a single command.",Nl,Se,sn="The example below shows how to fine-tune <strong>SmolVLM2-2.2B-Instruct</strong> on the <strong>trl-lib/llava-instruct-mix</strong> dataset, using LoRA for parameter-efficient fine-tuning, mixed precision for faster training, and optional push-to-Hub for sharing your model. The dataset now is different.",Sl,Ye,nn="We are using a different dataset here because it already comes formatted in the expected VLM structure, as discussed earlier.",Yl,ze,an="<li><code>--model_name_or_path</code> specifies the base model to fine-tune.</li> <li><code>--dataset_name</code> and <code>--dataset_config</code> define the dataset and subset.</li> <li><code>--output_dir</code> sets the local directory for saving the fine-tuned model.</li> <li><code>--per_device_train_batch_size</code> and <code>--gradient_accumulation_steps</code> control effective batch size and memory usage.</li> <li><code>--learning_rate</code>, <code>--num_train_epochs</code>, and <code>--max_length</code> define the core training hyperparameters.</li> <li><code>--bf16</code> enables mixed precision for faster and more memory-efficient training on compatible GPUs.</li> <li><code>--push_to_hub</code> and <code>--hub_model_id</code> allow automatic upload of the trained model to your Hugging Face Hub repository.</li>",zl,qe,on="Using the TRL CLI is functionally equivalent to writing a full Python training script, but it’s faster to configure, easier to reproduce, and ideal for production pipelines or automated training workflows.",ql,Pe,Pl,De,Dl,Ke,rn=`In <a href="../unit1/5">Unit 1</a>, we introduced <strong>Hugging Face Jobs (HF Jobs)</strong> and demonstrated how to fine-tune a model using this managed cloud service.<br/>
HF Jobs provides a <strong>fully managed infrastructure</strong> for training models, eliminating the need to set up GPUs, manage dependencies, or configure environments locally. This is especially useful for <strong>SFT training</strong>, which can be both resource-intensive and time-consuming.`,Kl,Oe,Mn=`Following the same approach, we can use HF Jobs to fine-tune our Vision-Language Model (VLM).<br/>
If needed, refer back to Unit 1 to refresh your understanding of HF Jobs and their workflow.`,Ol,et,pn="Here’s an example of how to launch a training job using <strong>TRL’s maintained SFT script</strong>:",es,tt,ts,lt,mn="After launching the job, HF Jobs will handle the <strong>entire training process</strong> in the cloud. You can monitor progress, view logs, and track metrics directly from the Hugging Face Hub.",ls,st,un="Once the job completes:",ss,nt,dn="<li>The <strong>fine-tuned model</strong> will be available in the <code>output_dir</code> you specified.</li> <li>If <code>--push_to_hub</code> was used, the model will also be <strong>accessible from your Hugging Face account</strong>, ready for inference or further fine-tuning.</li> <li>You can <strong>resume, replicate, or scale</strong> training easily by re-running or modifying the job configuration.</li>",ns,at,cn="This workflow removes the overhead of managing local resources, allowing you to focus on <strong>model experimentation and evaluation</strong>.",as,it,is,ot,Tn=`You’ve completed the unit — great work!
Now put your learning to the test by taking the <a href="https://huggingface.co/spaces/smol-course/unit_4_quiz" rel="nofollow">quiz</a>.`,os,rt,rs,Mt,wn="Here are some helpful resources to deepen your understanding and continue experimenting with vision language models and TRL workflows:",Ms,pt,yn='<li><strong><a href="https://huggingface.co/docs/trl/" rel="nofollow">TRL Documentation</a></strong> – Complete reference for using TRL, including Python API and CLI.</li> <li><strong><a href="https://huggingface.co/HuggingFaceTB/SmolVLM2-2.2B-Instruct" rel="nofollow">HuggingFaceTB/SmolVLM2-2.2B-Instruct Model Card</a></strong> – Detailed information about the model architecture, training, and usage.</li> <li><strong><a href="https://huggingface.co/datasets/HuggingFaceM4/ChartQA" rel="nofollow">HuggingFaceM4/ChartQA Dataset</a></strong> – Dataset used for training and fine-tuning VLMs.</li> <li><strong><a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a></strong> – Platform to share your fine-tuned models and discover community models.</li> <li><strong><a href="https://discord.gg/huggingface" rel="nofollow">Hugging Face Discord Community</a></strong> – Join the community for discussions, support, and troubleshooting.</li>',ps,mt,ms,ft,us;return $=new w({props:{title:"Hands-On Exercises: Fine-Tuning SmolVLM2-2.2B-Instruct",local:"hands-on-exercises-fine-tuning-smolvlm2-22b-instruct",headingTag:"h1"}}),v=new Cn({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/4/4.ipynb"}]}}),_=new w({props:{title:"Learning Objectives",local:"learning-objectives",headingTag:"h2"}}),W=new w({props:{title:"Exercise 1: Explore SmolVLM2-2.2B-Instruct",local:"exercise-1-explore-smolvlm2-22b-instruct",headingTag:"h3"}}),x=new w({props:{title:"Environment Setup",local:"environment-setup",headingTag:"h3"}}),U=new Jn({props:{warning:!0,$$slots:{default:[vn]},$$scope:{ctx:Tt}}}),F=new y({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjAocnVuJTIwaW4lMjBDb2xhYiUyMG9yJTIweW91ciUyMGVudmlyb25tZW50KSUwQXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMHRybCUyMGh1Z2dpbmdmYWNlX2h1YiUyMHRyYWNraW8lMjBudW0yd29yZHMlM0QlM0QwLjUuMTQ=",highlighted:`<span class="hljs-comment"># Install required packages (run in Colab or your environment)</span>
pip install transformers datasets trl huggingface_hub trackio num2words==0.5.14`,wrap:!1}}),L=new w({props:{title:"Import dependencies",local:"import-dependencies",headingTag:"h3"}}),k=new y({props:{code:"JTIzJTIwSW1wb3J0JTIwZGVwZW5kZW5jaWVzJTBBJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBvcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0JTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5pbWFnZV91dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2U=",highlighted:`<span class="hljs-comment"># Import dependencies</span>

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText, BitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image`,wrap:!1}}),V=new w({props:{title:"Load the model and processor",local:"load-the-model-and-processor",headingTag:"h3"}}),E=new w({props:{title:"1. Select the device",local:"1-select-the-device",headingTag:"h4"}}),X=new y({props:{code:"ZGV2aWNlJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlMEElMjAlMjAlMjAlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMEElMjAlMjAlMjAlMjBlbHNlJTIwJTIybXBzJTIyJTIwaWYlMjB0b3JjaC5iYWNrZW5kcy5tcHMuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBKQ==",highlighted:`device = (
    <span class="hljs-string">&quot;cuda&quot;</span>
    <span class="hljs-keyword">if</span> torch.cuda.is_available()
    <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
)`,wrap:!1}}),N=new w({props:{title:"2. Authenticate with Hugging Face",local:"2-authenticate-with-hugging-face",headingTag:"h4"}}),I=new Jn({props:{$$slots:{default:[Bn]},$$scope:{ctx:Tt}}}),Y=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
login()`,wrap:!1}}),z=new w({props:{title:"3. Load the model and processor",local:"3-load-the-model-and-processor",headingTag:"h4"}}),P=new y({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNMi0yLjJCLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKS50byhkZXZpY2UpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM2-2.2B-Instruct&quot;</span>
model = AutoModelForImageTextToText.from_pretrained(
    model_name,
    dtype=torch.bfloat16,
).to(device)

processor = AutoProcessor.from_pretrained(model_name)`,wrap:!1}}),D=new w({props:{title:"Explore the dataset",local:"explore-the-dataset",headingTag:"h3"}}),ee=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXRyYWluX2RhdGFzZXQlMkMlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIySHVnZ2luZ0ZhY2VNNCUyRkNoYXJ0UUElMjIlMkMlMjBzcGxpdCUzRCU1QiUyMnRyYWluJTVCJTNBMTAlMjUlNUQlMjIlMkMlMjAlMjJ2YWwlNUIlM0ExMCUyNSU1RCUyMiU1RCklMEFleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QjElNUQlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoZXhhbXBsZSU1QiUyMmltYWdlJTIyJTVEKSUwQSUwQXByaW50KGV4YW1wbGUlNUIlMjJxdWVyeSUyMiU1RCklMEFwcmludChleGFtcGxlJTVCJTIybGFiZWwlMjIlNUQlNUIwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

train_dataset, eval_dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceM4/ChartQA&quot;</span>, split=[<span class="hljs-string">&quot;train[:10%]&quot;</span>, <span class="hljs-string">&quot;val[:10%]&quot;</span>])
example = train_dataset[<span class="hljs-number">1</span>]
image = load_image(example[<span class="hljs-string">&quot;image&quot;</span>])

<span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;query&quot;</span>])
<span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),te=new y({props:{code:"SG93JTIwbWFueSUyMHZhbHVlcyUyMGFyZSUyMGJlbG93JTIwNDAlMjBpbiUyMFVuZmF2b3JhYmxlJTIwZ3JhcGglM0YlMEE2",highlighted:`How many values are below 40 in Unfavorable graph?
6`,wrap:!1}}),le=new y({props:{code:"cGx0Lmltc2hvdyhpbWFnZSklMEFwbHQuYXhpcyglMjJvZmYlMjIpJTBBcGx0LnRpdGxlKCUyMlNhbXBsZSUyMENoYXJ0JTIwSW1hZ2UlMjIpJTBBcGx0LnNob3coKQ==",highlighted:`plt.imshow(image)
plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.title(<span class="hljs-string">&quot;Sample Chart Image&quot;</span>)
plt.show()`,wrap:!1}}),ne=new w({props:{title:"Build a chat-style prompt",local:"build-a-chat-style-prompt",headingTag:"h3"}}),oe=new y({props:{code:"JTIzJTIwRGVmaW5lJTIwYSUyMGNoYXQtc3R5bGUlMjBwcm9tcHQlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUyMCUyMmltYWdlJTIyJTNBJTIwaW1hZ2UlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycXVlcnklMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlN0QlMEElNUQlMEElMEElMjMlMjBBcHBseSUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUwQWNoYXRfcHJvbXB0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTVDJTBBKSUwQXByaW50KGNoYXRfcHJvbXB0KQ==",highlighted:`<span class="hljs-comment"># Define a chat-style prompt</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;image&quot;</span>: image},
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;query&quot;</span>]},
    ]}
]

<span class="hljs-comment"># Apply the chat template</span>
chat_prompt = processor.apply_chat_template(
      messages, add_generation_prompt=<span class="hljs-literal">True</span>\\
)
<span class="hljs-built_in">print</span>(chat_prompt)`,wrap:!1}}),re=new y({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VVc2VyJTNBJTNDaW1hZ2UlM0VIb3clMjBtYW55JTIwdmFsdWVzJTIwYXJlJTIwYmVsb3clMjA0MCUyMGluJTIwVW5mYXZvcmFibGUlMjBncmFwaCUzRiUzQ2VuZF9vZl91dHRlcmFuY2UlM0UlMEFBc3Npc3RhbnQlM0E=",highlighted:`&lt;|im_start|&gt;User:&lt;image&gt;How many values are below 40 in Unfavorable graph?&lt;end_of_utterance&gt;
Assistant:`,wrap:!1}}),Me=new w({props:{title:"Run inference",local:"run-inference",headingTag:"h3"}}),me=new y({props:{code:"JTIzJTIwVG9rZW5pemUlMjBpbnB1dCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0QlNUJpbWFnZSU1RCUyQyUyMHRleHQlM0RjaGF0X3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEElMEElMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwb3V0cHV0JTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEElMEElMjMlMjBUcmltJTIwdGhlJTIwZ2VuZXJhdGVkJTIwaWRzJTIwdG8lMjByZW1vdmUlMjB0aGUlMjBpbnB1dCUyMGlkcyUwQXRyaW1tZWRfZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMCU1Qm91dF9pZHMlNUJsZW4oaW5faWRzKSUyMCUzQSU1RCUyMGZvciUyMGluX2lkcyUyQyUyMG91dF9pZHMlMjBpbiUyMHppcChpbnB1dHMuaW5wdXRfaWRzJTJDJTIwb3V0cHV0KSU1RCUwQSUwQSUyMyUyMERlY29kZSUyMHRoZSUyMG91dHB1dCUyMHRleHQlMEFvdXRwdXRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwdHJpbW1lZF9nZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UlMEEpJTBBcHJpbnQob3V0cHV0X3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-comment"># Tokenize input</span>
inputs = processor(images=[image], text=chat_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate model output</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>)

<span class="hljs-comment"># Trim the generated ids to remove the input ids</span>
trimmed_generated_ids = [out_ids[<span class="hljs-built_in">len</span>(in_ids) :] <span class="hljs-keyword">for</span> in_ids, out_ids <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(inputs.input_ids, output)]

<span class="hljs-comment"># Decode the output text</span>
output_text = processor.batch_decode(
    trimmed_generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>
)
<span class="hljs-built_in">print</span>(output_text[<span class="hljs-number">0</span>])`,wrap:!1}}),ue=new y({props:{code:"JTIwMy4=",highlighted:" 3.",wrap:!1}}),ce=new w({props:{title:"Exercise 2: Fine-Tune the Model Using LoRA",local:"exercise-2-fine-tune-the-model-using-lora",headingTag:"h2"}}),ye=new y({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlMjIlMjIlMjJZb3UlMjBhcmUlMjBhJTIwVmlzaW9uJTIwTGFuZ3VhZ2UlMjBNb2RlbCUyMHNwZWNpYWxpemVkJTIwaW4lMjBpbnRlcnByZXRpbmclMjB2aXN1YWwlMjBkYXRhJTIwZnJvbSUyMGNoYXJ0JTIwaW1hZ2VzLiUwQVlvdXIlMjB0YXNrJTIwaXMlMjB0byUyMGFuYWx5emUlMjB0aGUlMjBwcm92aWRlZCUyMGNoYXJ0JTIwaW1hZ2UlMjBhbmQlMjByZXNwb25kJTIwdG8lMjBxdWVyaWVzJTIwd2l0aCUyMGNvbmNpc2UlMjBhbnN3ZXJzJTJDJTIwdXN1YWxseSUyMGElMjBzaW5nbGUlMjB3b3JkJTJDJTIwbnVtYmVyJTJDJTIwb3IlMjBzaG9ydCUyMHBocmFzZS4lMEFUaGUlMjBjaGFydHMlMjBpbmNsdWRlJTIwYSUyMHZhcmlldHklMjBvZiUyMHR5cGVzJTIwKGUuZy4lMkMlMjBsaW5lJTIwY2hhcnRzJTJDJTIwYmFyJTIwY2hhcnRzKSUyMGFuZCUyMGNvbnRhaW4lMjBjb2xvcnMlMkMlMjBsYWJlbHMlMkMlMjBhbmQlMjB0ZXh0LiUwQUZvY3VzJTIwb24lMjBkZWxpdmVyaW5nJTIwYWNjdXJhdGUlMkMlMjBzdWNjaW5jdCUyMGFuc3dlcnMlMjBiYXNlZCUyMG9uJTIwdGhlJTIwdmlzdWFsJTIwaW5mb3JtYXRpb24uJTIwQXZvaWQlMjBhZGRpdGlvbmFsJTIwZXhwbGFuYXRpb24lMjB1bmxlc3MlMjBhYnNvbHV0ZWx5JTIwbmVjZXNzYXJ5LiUyMiUyMiUyMg==",highlighted:`system_message = <span class="hljs-string">&quot;&quot;&quot;You are a Vision Language Model specialized in interpreting visual data from chart images.
Your task is to analyze the provided chart image and respond to queries with concise answers, usually a single word, number, or short phrase.
The charts include a variety of types (e.g., line charts, bar charts) and contain colors, labels, and text.
Focus on delivering accurate, succinct answers based on the visual information. Avoid additional explanation unless absolutely necessary.&quot;&quot;&quot;</span>`,wrap:!1}}),fe=new w({props:{title:"Format the Dataset",local:"format-the-dataset",headingTag:"h3"}}),Ie=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_data</span>(<span class="hljs-params">sample</span>):
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;images&quot;</span>: [sample[<span class="hljs-string">&quot;image&quot;</span>]],
        <span class="hljs-string">&quot;messages&quot;</span>: [
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: system_message}],
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                        <span class="hljs-string">&quot;image&quot;</span>: sample[<span class="hljs-string">&quot;image&quot;</span>],
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;query&quot;</span>],
                    },
                ],
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: sample[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-number">0</span>]}],
            },
        ],
    }`,wrap:!1}}),be=new y({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMCU1QmZvcm1hdF9kYXRhKHNhbXBsZSklMjBmb3IlMjBzYW1wbGUlMjBpbiUyMHRyYWluX2RhdGFzZXQlNUQlMEFldmFsX2RhdGFzZXQlMjAlM0QlMjAlNUJmb3JtYXRfZGF0YShzYW1wbGUpJTIwZm9yJTIwc2FtcGxlJTIwaW4lMjBldmFsX2RhdGFzZXQlNUQ=",highlighted:`train_dataset = [format_data(sample) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> train_dataset]
eval_dataset = [format_data(sample) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> eval_dataset]`,wrap:!1}}),Ce=new w({props:{title:"Configure LoRA",local:"configure-lora",headingTag:"h3"}}),_e=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEElMjMlMjBDb25maWd1cmUlMjBMb1JBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjByJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKSUwQSUwQSUyMyUyMEFwcGx5JTIwUEVGVCUyMG1vZGVsJTIwYWRhcHRhdGlvbiUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMHBlZnRfY29uZmlnKSUwQSUwQSUyMyUyMFByaW50JTIwdHJhaW5hYmxlJTIwcGFyYW1ldGVycyUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

<span class="hljs-comment"># Configure LoRA</span>
peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    r=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># Apply PEFT model adaptation</span>
peft_model = get_peft_model(model, peft_config)

<span class="hljs-comment"># Print trainable parameters</span>
peft_model.print_trainable_parameters()`,wrap:!1}}),Ze=new w({props:{title:"Set up the Trainer",local:"set-up-the-trainer",headingTag:"h3"}}),xe=new y({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEElMjMlMjBDb25maWd1cmUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUyMHVzaW5nJTIwU0ZUQ29uZmlnJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyc21vbC1jb3Vyc2Utc21vbHZsbTItMi4yYi1pbnN0cnVjdC10cmwtc2Z0LUNoYXJ0UUElMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTQlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMmFkYW13X3RvcmNoX2Z1c2VkJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmYxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ0cmFja2lvJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRE5vbmUlMkMlMEEpJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMFRyYWluZXIlMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMkMlMEEpJTBBJTBBJTIzJTIwQWxpZ24lMjB0aGUlMjBTRlRUcmFpbmVyJTIwcGFyYW1zJTIwd2l0aCUyMHlvdXIlMjBjaG9zZW4lMjBkYXRhc2V0Lg==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

<span class="hljs-comment"># Configure training arguments using SFTConfig</span>
training_args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;smol-course-smolvlm2-2.2b-instruct-trl-sft-ChartQA&quot;</span>,
    num_train_epochs=<span class="hljs-number">1</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">1e-4</span>,
    logging_steps=<span class="hljs-number">25</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_steps=<span class="hljs-number">25</span>,
    optim=<span class="hljs-string">&quot;adamw_torch_fused&quot;</span>,
    bf16=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    report_to=<span class="hljs-string">&quot;trackio&quot;</span>,
    max_length=<span class="hljs-literal">None</span>,
)

<span class="hljs-comment"># Initialize the Trainer</span>
trainer = SFTTrainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    peft_config=peft_config,
)

<span class="hljs-comment"># Align the SFTTrainer params with your chosen dataset.</span>`,wrap:!1}}),Re=new w({props:{title:"Train and Save the Model",local:"train-and-save-the-model",headingTag:"h3"}}),ke=new y({props:{code:"JTIzJTIwVHJhaW4lMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIuc2F2ZV9tb2RlbCh0cmFpbmluZ19hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-comment"># Train the model</span>
trainer.train()

<span class="hljs-comment"># Save the model</span>
trainer.save_model(training_args.output_dir)`,wrap:!1}}),Ee=new w({props:{title:"Exercise 3: Production Workflow with TRL CLI",local:"exercise-3-production-workflow-with-trl-cli",headingTag:"h2"}}),Pe=new y({props:{code:"dHJsJTIwc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbFZMTTItMi4yQi1JbnN0cnVjdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRmxsYXZhLWluc3RydWN0LW1peCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMC4lMkZzbW9sdmxuLWluc3RydWN0LXNmdC1jbGklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwMmUtNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9sZW5ndGglMjAtMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbG9nZ2luZ19zdGVwcyUyMDUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNhdmVfc3RlcHMlMjAxMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdhcm11cF9zdGVwcyUyMDUwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWh1Yl9tb2RlbF9pZCUyMHlvdXItdXNlcm5hbWUlMkZzbW9sdmxtMi0yLjJiLWluc3RydWN0LXNmdC1jbGk=",highlighted:`trl sft \\
    --model_name_or_path HuggingFaceTB/SmolVLM2-2.2B-Instruct \\
    --dataset_name trl-lib/llava-instruct-mix \\
    --output_dir ./smolvln-instruct-sft-cli \\
    --per_device_train_batch_size 1 \\
    --gradient_accumulation_steps 16 \\
    --learning_rate 2e-4 \\
    --num_train_epochs 3 \\
    --max_length -1 \\
    --logging_steps 5 \\
    --save_steps 100 \\
    --warmup_steps 50 \\
    --bf16 True \\
    --push_to_hub \\
    --hub_model_id your-username/smolvlm2-2.2b-instruct-sft-cli`,wrap:!1}}),De=new w({props:{title:"Exercise 4: Training with Hugging Face Jobs",local:"exercise-4-training-with-hugging-face-jobs",headingTag:"h2"}}),tt=new y({props:{code:"JTIzJTIwVXNlJTIwVFJMJ3MlMjBtYWludGFpbmVkJTIwU0ZUJTIwc2NyaXB0JTIwZGlyZWN0bHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdpdGglMjBudW0yd29yZHMlM0QlM0QwLjUuMTQlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbFZMTTItMi4yQi1JbnN0cnVjdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWxpYiUyRmxsYXZhLWluc3RydWN0LW1peCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9sZW5ndGglMjAtMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X3N0ZXBzJTIwMTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHNtb2x2bG0yLTIuMmItaW5zdHJ1Y3Qtc2Z0LWpvYnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1odWJfbW9kZWxfaWQlMjB5b3VyLXVzZXJuYW1lJTJGc21vbHZsbTItMi4yYi1pbnN0cnVjdC1zZnQtam9icyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwb3J0X3RvJTIwdHJhY2tpbw==",highlighted:`<span class="hljs-comment"># Use TRL&#x27;s maintained SFT script directly</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    --with num2words==0.5.14 \\
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
    --model_name_or_path HuggingFaceTB/SmolVLM2-2.2B-Instruct \\
    --dataset_name trl-lib/llava-instruct-mix\\
    --learning_rate 5e-5 \\
    --per_device_train_batch_size 4 \\
    --max_length -1 \\
    --max_steps 1000 \\
    --output_dir smolvlm2-2.2b-instruct-sft-jobs \\
    --push_to_hub \\
    --hub_model_id your-username/smolvlm2-2.2b-instruct-sft-jobs \\
    --report_to trackio`,wrap:!1}}),it=new w({props:{title:"Test your knowledge",local:"test-your-knowledge",headingTag:"h2"}}),rt=new w({props:{title:"Resources for Further Learning",local:"resources-for-further-learning",headingTag:"h2"}}),mt=new $n({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit3/4.md"}}),{c(){T=i("meta"),h=n(),J=i("p"),f=n(),M($.$$.fragment),Ut=n(),M(v.$$.fragment),It=n(),B=i("p"),B.innerHTML=ys,jt=n(),M(_.$$.fragment),bt=n(),Z=i("p"),Z.textContent=Js,Ct=n(),A=i("ul"),A.innerHTML=hs,$t=n(),M(W.$$.fragment),vt=n(),H=i("p"),H.innerHTML=gs,Bt=n(),M(x.$$.fragment),_t=n(),M(U.$$.fragment),Zt=n(),R=i("p"),R.innerHTML=fs,At=n(),M(F.$$.fragment),Wt=n(),M(L.$$.fragment),Ht=n(),G=i("p"),G.textContent=Us,xt=n(),M(k.$$.fragment),Rt=n(),M(V.$$.fragment),Ft=n(),M(E.$$.fragment),Lt=n(),Q=i("p"),Q.innerHTML=Is,Gt=n(),M(X.$$.fragment),kt=n(),M(N.$$.fragment),Vt=n(),S=i("p"),S.innerHTML=js,Et=n(),M(I.$$.fragment),Qt=n(),M(Y.$$.fragment),Xt=n(),M(z.$$.fragment),Nt=n(),q=i("p"),q.innerHTML=bs,St=n(),M(P.$$.fragment),Yt=n(),M(D.$$.fragment),zt=n(),K=i("p"),K.innerHTML=Cs,qt=n(),O=i("p"),O.innerHTML=$s,Pt=n(),g=i("iframe"),Dt=n(),M(ee.$$.fragment),Kt=n(),j=i("details"),wt=i("summary"),wt.textContent=Bs,cs=n(),M(te.$$.fragment),Ot=n(),M(le.$$.fragment),el=n(),se=i("p"),se.innerHTML=_s,tl=n(),M(ne.$$.fragment),ll=n(),ae=i("p"),ae.innerHTML=Zs,sl=n(),ie=i("p"),ie.innerHTML=As,nl=n(),M(oe.$$.fragment),al=n(),b=i("details"),yt=i("summary"),yt.textContent=Ws,Ts=n(),M(re.$$.fragment),il=n(),M(Me.$$.fragment),ol=n(),pe=i("p"),pe.textContent=Hs,rl=n(),M(me.$$.fragment),Ml=n(),C=i("details"),Jt=i("summary"),Jt.textContent=xs,ws=n(),M(ue.$$.fragment),pl=n(),de=i("p"),de.innerHTML=Rs,ml=n(),M(ce.$$.fragment),ul=n(),Te=i("p"),Te.innerHTML=Fs,dl=n(),we=i("p"),we.innerHTML=Ls,cl=n(),M(ye.$$.fragment),Tl=n(),Je=i("p"),Je.innerHTML=Gs,wl=n(),he=i("ul"),he.innerHTML=ks,yl=n(),ge=i("p"),ge.innerHTML=Vs,Jl=n(),hl=i("hr"),gl=n(),M(fe.$$.fragment),fl=n(),Ue=i("p"),Ue.innerHTML=Es,Ul=n(),M(Ie.$$.fragment),Il=n(),je=i("p"),je.textContent=Qs,jl=n(),M(be.$$.fragment),bl=n(),M(Ce.$$.fragment),Cl=n(),$e=i("p"),$e.innerHTML=Xs,$l=n(),ve=i("ul"),ve.innerHTML=Ns,vl=n(),Be=i("p"),Be.innerHTML=Ss,Bl=n(),M(_e.$$.fragment),_l=n(),M(Ze.$$.fragment),Zl=n(),Ae=i("p"),Ae.innerHTML=Ys,Al=n(),We=i("ul"),We.innerHTML=zs,Wl=n(),He=i("p"),He.textContent=qs,Hl=n(),M(xe.$$.fragment),xl=n(),M(Re.$$.fragment),Rl=n(),Fe=i("p"),Fe.textContent=Ps,Fl=n(),Le=i("ol"),Le.innerHTML=Ds,Ll=n(),Ge=i("p"),Ge.textContent=Ks,Gl=n(),M(ke.$$.fragment),kl=n(),Ve=i("p"),Ve.innerHTML=Os,Vl=n(),M(Ee.$$.fragment),El=n(),Qe=i("p"),Qe.innerHTML=en,Ql=n(),Xe=i("p"),Xe.innerHTML=tn,Xl=n(),Ne=i("p"),Ne.textContent=ln,Nl=n(),Se=i("p"),Se.innerHTML=sn,Sl=n(),Ye=i("p"),Ye.textContent=nn,Yl=n(),ze=i("ul"),ze.innerHTML=an,zl=n(),qe=i("p"),qe.textContent=on,ql=n(),M(Pe.$$.fragment),Pl=n(),M(De.$$.fragment),Dl=n(),Ke=i("p"),Ke.innerHTML=rn,Kl=n(),Oe=i("p"),Oe.innerHTML=Mn,Ol=n(),et=i("p"),et.innerHTML=pn,es=n(),M(tt.$$.fragment),ts=n(),lt=i("p"),lt.innerHTML=mn,ls=n(),st=i("p"),st.textContent=un,ss=n(),nt=i("ul"),nt.innerHTML=dn,ns=n(),at=i("p"),at.innerHTML=cn,as=n(),M(it.$$.fragment),is=n(),ot=i("p"),ot.innerHTML=Tn,os=n(),M(rt.$$.fragment),rs=n(),Mt=i("p"),Mt.textContent=wn,Ms=n(),pt=i("ul"),pt.innerHTML=yn,ps=n(),M(mt.$$.fragment),ms=n(),ft=i("p"),this.h()},l(e){const t=bn("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),J=o(e,"P",{}),ht(J).forEach(l),f=a(e),p($.$$.fragment,e),Ut=a(e),p(v.$$.fragment,e),It=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1a5nqhq"&&(B.innerHTML=ys),jt=a(e),p(_.$$.fragment,e),bt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1l3bdg3"&&(Z.textContent=Js),Ct=a(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-od3cka"&&(A.innerHTML=hs),$t=a(e),p(W.$$.fragment,e),vt=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-bijktq"&&(H.innerHTML=gs),Bt=a(e),p(x.$$.fragment,e),_t=a(e),p(U.$$.fragment,e),Zt=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-qqkglq"&&(R.innerHTML=fs),At=a(e),p(F.$$.fragment,e),Wt=a(e),p(L.$$.fragment,e),Ht=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-zl3b16"&&(G.textContent=Us),xt=a(e),p(k.$$.fragment,e),Rt=a(e),p(V.$$.fragment,e),Ft=a(e),p(E.$$.fragment,e),Lt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-7eoqdg"&&(Q.innerHTML=Is),Gt=a(e),p(X.$$.fragment,e),kt=a(e),p(N.$$.fragment,e),Vt=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-tskkwt"&&(S.innerHTML=js),Et=a(e),p(I.$$.fragment,e),Qt=a(e),p(Y.$$.fragment,e),Xt=a(e),p(z.$$.fragment,e),Nt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1b4foh6"&&(q.innerHTML=bs),St=a(e),p(P.$$.fragment,e),Yt=a(e),p(D.$$.fragment,e),zt=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-er66b7"&&(K.innerHTML=Cs),qt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-yemwqz"&&(O.innerHTML=$s),Pt=a(e),g=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ht(g).forEach(l),Dt=a(e),p(ee.$$.fragment,e),Kt=a(e),j=o(e,"DETAILS",{});var ut=ht(j);wt=o(ut,"SUMMARY",{"data-svelte-h":!0}),r(wt)!=="svelte-nfzy3j"&&(wt.textContent=Bs),cs=a(ut),p(te.$$.fragment,ut),ut.forEach(l),Ot=a(e),p(le.$$.fragment,e),el=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-12h2lj2"&&(se.innerHTML=_s),tl=a(e),p(ne.$$.fragment,e),ll=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-jpokh4"&&(ae.innerHTML=Zs),sl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-17uxmem"&&(ie.innerHTML=As),nl=a(e),p(oe.$$.fragment,e),al=a(e),b=o(e,"DETAILS",{});var dt=ht(b);yt=o(dt,"SUMMARY",{"data-svelte-h":!0}),r(yt)!=="svelte-nfzy3j"&&(yt.textContent=Ws),Ts=a(dt),p(re.$$.fragment,dt),dt.forEach(l),il=a(e),p(Me.$$.fragment,e),ol=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1qdjv1p"&&(pe.textContent=Hs),rl=a(e),p(me.$$.fragment,e),Ml=a(e),C=o(e,"DETAILS",{});var ds=ht(C);Jt=o(ds,"SUMMARY",{"data-svelte-h":!0}),r(Jt)!=="svelte-nfzy3j"&&(Jt.textContent=xs),ws=a(ds),p(ue.$$.fragment,ds),ds.forEach(l),pl=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-luk36"&&(de.innerHTML=Rs),ml=a(e),p(ce.$$.fragment,e),ul=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-5z70n4"&&(Te.innerHTML=Fs),dl=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-dkenf7"&&(we.innerHTML=Ls),cl=a(e),p(ye.$$.fragment,e),Tl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-ejreso"&&(Je.innerHTML=Gs),wl=a(e),he=o(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-wqfgg1"&&(he.innerHTML=ks),yl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1w4jpzn"&&(ge.innerHTML=Vs),Jl=a(e),hl=o(e,"HR",{}),gl=a(e),p(fe.$$.fragment,e),fl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-41v40k"&&(Ue.innerHTML=Es),Ul=a(e),p(Ie.$$.fragment,e),Il=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-ximgze"&&(je.textContent=Qs),jl=a(e),p(be.$$.fragment,e),bl=a(e),p(Ce.$$.fragment,e),Cl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1h7mh3h"&&($e.innerHTML=Xs),$l=a(e),ve=o(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-2ch3wm"&&(ve.innerHTML=Ns),vl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1n114ah"&&(Be.innerHTML=Ss),Bl=a(e),p(_e.$$.fragment,e),_l=a(e),p(Ze.$$.fragment,e),Zl=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-8dwavv"&&(Ae.innerHTML=Ys),Al=a(e),We=o(e,"UL",{"data-svelte-h":!0}),r(We)!=="svelte-1kixzkm"&&(We.innerHTML=zs),Wl=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-170mf7l"&&(He.textContent=qs),Hl=a(e),p(xe.$$.fragment,e),xl=a(e),p(Re.$$.fragment,e),Rl=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-kxzbug"&&(Fe.textContent=Ps),Fl=a(e),Le=o(e,"OL",{"data-svelte-h":!0}),r(Le)!=="svelte-pbze45"&&(Le.innerHTML=Ds),Ll=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-tqjfkj"&&(Ge.textContent=Ks),Gl=a(e),p(ke.$$.fragment,e),kl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1eg4wzk"&&(Ve.innerHTML=Os),Vl=a(e),p(Ee.$$.fragment,e),El=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-idq95d"&&(Qe.innerHTML=en),Ql=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1b32icm"&&(Xe.innerHTML=tn),Xl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-97m84n"&&(Ne.textContent=ln),Nl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1smtf1g"&&(Se.innerHTML=sn),Sl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-hiqun9"&&(Ye.textContent=nn),Yl=a(e),ze=o(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-1ajz8o2"&&(ze.innerHTML=an),zl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-16jnk0c"&&(qe.textContent=on),ql=a(e),p(Pe.$$.fragment,e),Pl=a(e),p(De.$$.fragment,e),Dl=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-38jf8e"&&(Ke.innerHTML=rn),Kl=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-nf31ng"&&(Oe.innerHTML=Mn),Ol=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-14o8e9l"&&(et.innerHTML=pn),es=a(e),p(tt.$$.fragment,e),ts=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1lncu3d"&&(lt.innerHTML=mn),ls=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-aqr5u9"&&(st.textContent=un),ss=a(e),nt=o(e,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-16pbkoa"&&(nt.innerHTML=dn),ns=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1r3yd65"&&(at.innerHTML=cn),as=a(e),p(it.$$.fragment,e),is=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-42sriz"&&(ot.innerHTML=Tn),os=a(e),p(rt.$$.fragment,e),rs=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-nf8xdu"&&(Mt.textContent=wn),Ms=a(e),pt=o(e,"UL",{"data-svelte-h":!0}),r(pt)!=="svelte-b7ldte"&&(pt.innerHTML=yn),ps=a(e),p(mt.$$.fragment,e),ms=a(e),ft=o(e,"P",{}),ht(ft).forEach(l),this.h()},h(){gt(T,"name","hf:doc:metadata"),gt(T,"content",Zn),fn(g.src,vs="https://huggingface.co/datasets/HuggingFaceM4/ChartQA/embed/viewer/default/train")||gt(g,"src",vs),gt(g,"frameborder","0"),gt(g,"width","100%"),gt(g,"height","560px")},m(e,t){ct(document.head,T),s(e,h,t),s(e,J,t),s(e,f,t),m($,e,t),s(e,Ut,t),m(v,e,t),s(e,It,t),s(e,B,t),s(e,jt,t),m(_,e,t),s(e,bt,t),s(e,Z,t),s(e,Ct,t),s(e,A,t),s(e,$t,t),m(W,e,t),s(e,vt,t),s(e,H,t),s(e,Bt,t),m(x,e,t),s(e,_t,t),m(U,e,t),s(e,Zt,t),s(e,R,t),s(e,At,t),m(F,e,t),s(e,Wt,t),m(L,e,t),s(e,Ht,t),s(e,G,t),s(e,xt,t),m(k,e,t),s(e,Rt,t),m(V,e,t),s(e,Ft,t),m(E,e,t),s(e,Lt,t),s(e,Q,t),s(e,Gt,t),m(X,e,t),s(e,kt,t),m(N,e,t),s(e,Vt,t),s(e,S,t),s(e,Et,t),m(I,e,t),s(e,Qt,t),m(Y,e,t),s(e,Xt,t),m(z,e,t),s(e,Nt,t),s(e,q,t),s(e,St,t),m(P,e,t),s(e,Yt,t),m(D,e,t),s(e,zt,t),s(e,K,t),s(e,qt,t),s(e,O,t),s(e,Pt,t),s(e,g,t),s(e,Dt,t),m(ee,e,t),s(e,Kt,t),s(e,j,t),ct(j,wt),ct(j,cs),m(te,j,null),s(e,Ot,t),m(le,e,t),s(e,el,t),s(e,se,t),s(e,tl,t),m(ne,e,t),s(e,ll,t),s(e,ae,t),s(e,sl,t),s(e,ie,t),s(e,nl,t),m(oe,e,t),s(e,al,t),s(e,b,t),ct(b,yt),ct(b,Ts),m(re,b,null),s(e,il,t),m(Me,e,t),s(e,ol,t),s(e,pe,t),s(e,rl,t),m(me,e,t),s(e,Ml,t),s(e,C,t),ct(C,Jt),ct(C,ws),m(ue,C,null),s(e,pl,t),s(e,de,t),s(e,ml,t),m(ce,e,t),s(e,ul,t),s(e,Te,t),s(e,dl,t),s(e,we,t),s(e,cl,t),m(ye,e,t),s(e,Tl,t),s(e,Je,t),s(e,wl,t),s(e,he,t),s(e,yl,t),s(e,ge,t),s(e,Jl,t),s(e,hl,t),s(e,gl,t),m(fe,e,t),s(e,fl,t),s(e,Ue,t),s(e,Ul,t),m(Ie,e,t),s(e,Il,t),s(e,je,t),s(e,jl,t),m(be,e,t),s(e,bl,t),m(Ce,e,t),s(e,Cl,t),s(e,$e,t),s(e,$l,t),s(e,ve,t),s(e,vl,t),s(e,Be,t),s(e,Bl,t),m(_e,e,t),s(e,_l,t),m(Ze,e,t),s(e,Zl,t),s(e,Ae,t),s(e,Al,t),s(e,We,t),s(e,Wl,t),s(e,He,t),s(e,Hl,t),m(xe,e,t),s(e,xl,t),m(Re,e,t),s(e,Rl,t),s(e,Fe,t),s(e,Fl,t),s(e,Le,t),s(e,Ll,t),s(e,Ge,t),s(e,Gl,t),m(ke,e,t),s(e,kl,t),s(e,Ve,t),s(e,Vl,t),m(Ee,e,t),s(e,El,t),s(e,Qe,t),s(e,Ql,t),s(e,Xe,t),s(e,Xl,t),s(e,Ne,t),s(e,Nl,t),s(e,Se,t),s(e,Sl,t),s(e,Ye,t),s(e,Yl,t),s(e,ze,t),s(e,zl,t),s(e,qe,t),s(e,ql,t),m(Pe,e,t),s(e,Pl,t),m(De,e,t),s(e,Dl,t),s(e,Ke,t),s(e,Kl,t),s(e,Oe,t),s(e,Ol,t),s(e,et,t),s(e,es,t),m(tt,e,t),s(e,ts,t),s(e,lt,t),s(e,ls,t),s(e,st,t),s(e,ss,t),s(e,nt,t),s(e,ns,t),s(e,at,t),s(e,as,t),m(it,e,t),s(e,is,t),s(e,ot,t),s(e,os,t),m(rt,e,t),s(e,rs,t),s(e,Mt,t),s(e,Ms,t),s(e,pt,t),s(e,ps,t),m(mt,e,t),s(e,ms,t),s(e,ft,t),us=!0},p(e,[t]){const ut={};t&2&&(ut.$$scope={dirty:t,ctx:e}),U.$set(ut);const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),I.$set(dt)},i(e){us||(u($.$$.fragment,e),u(v.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(x.$$.fragment,e),u(U.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(k.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(X.$$.fragment,e),u(N.$$.fragment,e),u(I.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(Me.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(Ie.$$.fragment,e),u(be.$$.fragment,e),u(Ce.$$.fragment,e),u(_e.$$.fragment,e),u(Ze.$$.fragment,e),u(xe.$$.fragment,e),u(Re.$$.fragment,e),u(ke.$$.fragment,e),u(Ee.$$.fragment,e),u(Pe.$$.fragment,e),u(De.$$.fragment,e),u(tt.$$.fragment,e),u(it.$$.fragment,e),u(rt.$$.fragment,e),u(mt.$$.fragment,e),us=!0)},o(e){d($.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d(W.$$.fragment,e),d(x.$$.fragment,e),d(U.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),d(k.$$.fragment,e),d(V.$$.fragment,e),d(E.$$.fragment,e),d(X.$$.fragment,e),d(N.$$.fragment,e),d(I.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(Me.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(ce.$$.fragment,e),d(ye.$$.fragment,e),d(fe.$$.fragment,e),d(Ie.$$.fragment,e),d(be.$$.fragment,e),d(Ce.$$.fragment,e),d(_e.$$.fragment,e),d(Ze.$$.fragment,e),d(xe.$$.fragment,e),d(Re.$$.fragment,e),d(ke.$$.fragment,e),d(Ee.$$.fragment,e),d(Pe.$$.fragment,e),d(De.$$.fragment,e),d(tt.$$.fragment,e),d(it.$$.fragment,e),d(rt.$$.fragment,e),d(mt.$$.fragment,e),us=!1},d(e){e&&(l(h),l(J),l(f),l(Ut),l(It),l(B),l(jt),l(bt),l(Z),l(Ct),l(A),l($t),l(vt),l(H),l(Bt),l(_t),l(Zt),l(R),l(At),l(Wt),l(Ht),l(G),l(xt),l(Rt),l(Ft),l(Lt),l(Q),l(Gt),l(kt),l(Vt),l(S),l(Et),l(Qt),l(Xt),l(Nt),l(q),l(St),l(Yt),l(zt),l(K),l(qt),l(O),l(Pt),l(g),l(Dt),l(Kt),l(j),l(Ot),l(el),l(se),l(tl),l(ll),l(ae),l(sl),l(ie),l(nl),l(al),l(b),l(il),l(ol),l(pe),l(rl),l(Ml),l(C),l(pl),l(de),l(ml),l(ul),l(Te),l(dl),l(we),l(cl),l(Tl),l(Je),l(wl),l(he),l(yl),l(ge),l(Jl),l(hl),l(gl),l(fl),l(Ue),l(Ul),l(Il),l(je),l(jl),l(bl),l(Cl),l($e),l($l),l(ve),l(vl),l(Be),l(Bl),l(_l),l(Zl),l(Ae),l(Al),l(We),l(Wl),l(He),l(Hl),l(xl),l(Rl),l(Fe),l(Fl),l(Le),l(Ll),l(Ge),l(Gl),l(kl),l(Ve),l(Vl),l(El),l(Qe),l(Ql),l(Xe),l(Xl),l(Ne),l(Nl),l(Se),l(Sl),l(Ye),l(Yl),l(ze),l(zl),l(qe),l(ql),l(Pl),l(Dl),l(Ke),l(Kl),l(Oe),l(Ol),l(et),l(es),l(ts),l(lt),l(ls),l(st),l(ss),l(nt),l(ns),l(at),l(as),l(is),l(ot),l(os),l(rs),l(Mt),l(Ms),l(pt),l(ps),l(ms),l(ft)),l(T),c($,e),c(v,e),c(_,e),c(W,e),c(x,e),c(U,e),c(F,e),c(L,e),c(k,e),c(V,e),c(E,e),c(X,e),c(N,e),c(I,e),c(Y,e),c(z,e),c(P,e),c(D,e),c(ee,e),c(te),c(le,e),c(ne,e),c(oe,e),c(re),c(Me,e),c(me,e),c(ue),c(ce,e),c(ye,e),c(fe,e),c(Ie,e),c(be,e),c(Ce,e),c(_e,e),c(Ze,e),c(xe,e),c(Re,e),c(ke,e),c(Ee,e),c(Pe,e),c(De,e),c(tt,e),c(it,e),c(rt,e),c(mt,e)}}}const Zn='{"title":"Hands-On Exercises: Fine-Tuning SmolVLM2-2.2B-Instruct","local":"hands-on-exercises-fine-tuning-smolvlm2-22b-instruct","sections":[{"title":"Learning Objectives","local":"learning-objectives","sections":[{"title":"Exercise 1: Explore SmolVLM2-2.2B-Instruct","local":"exercise-1-explore-smolvlm2-22b-instruct","sections":[],"depth":3},{"title":"Environment Setup","local":"environment-setup","sections":[],"depth":3},{"title":"Import dependencies","local":"import-dependencies","sections":[],"depth":3},{"title":"Load the model and processor","local":"load-the-model-and-processor","sections":[{"title":"1. Select the device","local":"1-select-the-device","sections":[],"depth":4},{"title":"2. Authenticate with Hugging Face","local":"2-authenticate-with-hugging-face","sections":[],"depth":4},{"title":"3. Load the model and processor","local":"3-load-the-model-and-processor","sections":[],"depth":4}],"depth":3},{"title":"Explore the dataset","local":"explore-the-dataset","sections":[],"depth":3},{"title":"Build a chat-style prompt","local":"build-a-chat-style-prompt","sections":[],"depth":3},{"title":"Run inference","local":"run-inference","sections":[],"depth":3}],"depth":2},{"title":"Exercise 2: Fine-Tune the Model Using LoRA","local":"exercise-2-fine-tune-the-model-using-lora","sections":[{"title":"Format the Dataset","local":"format-the-dataset","sections":[],"depth":3},{"title":"Configure LoRA","local":"configure-lora","sections":[],"depth":3},{"title":"Set up the Trainer","local":"set-up-the-trainer","sections":[],"depth":3},{"title":"Train and Save the Model","local":"train-and-save-the-model","sections":[],"depth":3}],"depth":2},{"title":"Exercise 3: Production Workflow with TRL CLI","local":"exercise-3-production-workflow-with-trl-cli","sections":[],"depth":2},{"title":"Exercise 4: Training with Hugging Face Jobs","local":"exercise-4-training-with-hugging-face-jobs","sections":[],"depth":2},{"title":"Test your knowledge","local":"test-your-knowledge","sections":[],"depth":2},{"title":"Resources for Further Learning","local":"resources-for-further-learning","sections":[],"depth":2}],"depth":1}';function An(Tt){return Un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gn extends In{constructor(T){super(),jn(this,T,An,_n,gn,{})}}export{Gn as component};
