import{s as ot,o as rt,n as pt}from"../chunks/scheduler.3e4cb221.js";import{S as mt,i as dt,g as i,s as n,r as m,A as Mt,h as o,f as l,c as s,j as st,u as d,x as r,k as it,y as ft,a,v as M,d as f,t as h,w as c}from"../chunks/index.bc693fcb.js";import{H as y,T as ht,E as ct}from"../chunks/getInferenceSnippets.65765a9b.js";import{C as le}from"../chunks/CodeBlock.4d312707.js";function ut(ae){let p,g="When implementing PEFT methods, start with small rank values (4-8) for LoRA and monitor training loss. Use validation sets to prevent overfitting and compare results with full fine-tuning baselines when possible. The effectiveness of different methods can vary by task, so experimentation is key.";return{c(){p=i("p"),p.textContent=g},l(u){p=o(u,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1co8mut"&&(p.textContent=g)},m(u,ee){a(u,p,ee)},p:pt,d(u){u&&l(p)}}}function yt(ae){let p,g,u,ee,T,ne,b,Ve="Parameter-Efficient Fine-Tuning (PEFT) lets you adapt large models by training a small number of additional parameters while keeping the base model frozen. The most widely used PEFT method is LoRA (Low-Rank Adaptation), which injects trainable low-rank updates into linear layers. This often reduces trainable parameters by ~90% while preserving performance.",se,j,ie,J,Qe="<li>You have limited compute or memory budget</li> <li>You need to quickly adapt a base model to multiple tasks/domains</li> <li>You want fast iteration and small artifacts (adapter weights are usually a few MB)</li>",oe,U,re,$,Xe="LoRA has become the most widely adopted PEFT method. It works by adding small rank decomposition matrices to the attention weights, typically reducing trainable parameters by about 90%.",pe,Z,xe='LoRA (Low-Rank Adaptation) is a parameter-efficient fine-tuning technique that freezes the pre-trained model weights and injects trainable rank decomposition matrices into the model’s layers. Instead of training all model parameters during fine-tuning, LoRA decomposes the weight updates into smaller matrices through low-rank decomposition, significantly reducing the number of trainable parameters while maintaining model performance. For example, when applied to GPT-3 175B, LoRA reduced trainable parameters by 10,000x and GPU memory requirements by 3x compared to full fine-tuning. You can read more about LoRA in the <a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LoRA paper</a>.',me,R,qe="LoRA works by adding pairs of rank decomposition matrices to transformer layers, typically focusing on attention weights. During inference, these adapter weights can be merged with the base model, resulting in no additional latency overhead. LoRA is particularly useful for adapting large language models to specific tasks or domains while keeping resource requirements manageable.",de,v,Me,k,Se="Adapters can be loaded onto a pretrained model with load_adapter(), which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the set_adapter() function. To return the base model, you could use unload() to unload all of the LoRA modules. This makes it easy to switch between different task-specific weights.",fe,C,he,B,He='<img src="./images/lora_adapter.png" alt="lora_load_adapter"/>',ce,F,ue,_,Ye="After training with LoRA, you might want to merge the adapter weights back into the base model for easier deployment. This creates a single model with the combined weights, eliminating the need to load adapters separately during inference.",ye,E,Pe="The merging process requires attention to memory management and precision. Since you’ll need to load both the base model and adapter weights simultaneously, ensure sufficient GPU/CPU memory is available. Using <code>device_map=&quot;auto&quot;</code> in <code>transformers</code> will help with automatic memory management. Maintain consistent precision (e.g., float16) throughout the process, matching the precision used during training and saving the merged model in the same format for deployment. Before deploying, always validate the merged model by comparing its outputs and performance metrics with the adapter-based version.",we,A,ze="Adapters are also be convenient for switching between different tasks or domains. You can load the base model and adapter weights separately. This allows for quick switching between different task-specific weights.",ge,w,Te,I,be,W,Ne='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',je,L,Je,G,De="PEFT methods can be combined with TRL (Transformers Reinforcement Learning) for efficient fine-tuning. This integration is particularly useful for RLHF (Reinforcement Learning from Human Feedback) as it reduces memory requirements.",Ue,V,$e,Q,Ze,X,Ke="After training a LoRA adapter, you can merge the adapter weights back into the base model. Here’s how to do it:",Re,x,ve,q,Oe="If you encounter size discrepancies in the saved model, ensure you’re also saving the tokenizer:",ke,S,Ce,H,Be,Y,et="The TRL <code>SFTTrainer</code> integrates natively with PEFT. Define a <code>LoraConfig</code>, pass it to the trainer, and train only the adapter weights.",Fe,P,_e,z,tt="After training, you can either:",Ee,N,lt="<li>Load adapters at inference time alongside the base model, or</li> <li>Merge adapters into the base model for simplified deployment.</li>",Ae,D,Ie,K,at='<li><a href="https://huggingface.co/papers/2106.09685" rel="nofollow">LoRA: Low-Rank Adaptation of Large Language Models</a></li> <li><a href="https://huggingface.co/docs/peft" rel="nofollow">PEFT Documentation</a></li> <li><a href="https://huggingface.co/blog/peft" rel="nofollow">Hugging Face blog post on PEFT</a></li>',We,O,Le,te,Ge;return T=new y({props:{title:"LoRA and PEFT: Efficient Fine-Tuning",local:"lora-and-peft-efficient-fine-tuning",headingTag:"h1"}}),j=new y({props:{title:"When to use PEFT",local:"when-to-use-peft",headingTag:"h2"}}),U=new y({props:{title:"Understanding LoRA",local:"understanding-lora",headingTag:"h2"}}),v=new y({props:{title:"Loading LoRA Adapters",local:"loading-lora-adapters",headingTag:"h2"}}),C=new le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ2Jhc2VfbW9kZWxfbmFtZSUzRSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDcGVmdF9hZGFwdGVyX2lkJTNFJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;&lt;base_model_name&gt;&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;&lt;peft_adapter_id&gt;&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),F=new y({props:{title:"Merging LoRA Adapters",local:"merging-lora-adapters",headingTag:"h2"}}),w=new ht({props:{$$slots:{default:[ut]},$$scope:{ctx:ae}}}),I=new y({props:{title:"OLoRA",local:"olora",headingTag:"h2"}}),L=new y({props:{title:"Using TRL with PEFT",local:"using-trl-with-peft",headingTag:"h2"}}),V=new le({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMjB3aXRoJTIwUEVGVCUyMGNvbmZpZyUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ5b3VyLW1vZGVsLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

<span class="hljs-comment"># Load model with PEFT config</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

trainer = SFTTrainer(
    model=<span class="hljs-string">&quot;your-model-name&quot;</span>,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>]
    peft_config=lora_config
)`,wrap:!1}}),Q=new y({props:{title:"Basic Merging Implementation",local:"basic-merging-implementation",headingTag:"h2"}}),x=new le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQSUwQSUyMyUyMDEuJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbF9uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKSUwQSUwQSUyMyUyMDIuJTIwTG9hZCUyMHRoZSUyMFBFRlQlMjBtb2RlbCUyMHdpdGglMjBhZGFwdGVyJTBBcGVmdF9tb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwYmFzZV9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRmFkYXB0ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQSUyMyUyMDMuJTIwTWVyZ2UlMjBhZGFwdGVyJTIwd2VpZ2h0cyUyMHdpdGglMjBiYXNlJTIwbW9kZWwlMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtZXJnZWRfbW9kZWwlMjAlM0QlMjBwZWZ0X21vZGVsLm1lcmdlX2FuZF91bmxvYWQoKSUwQWV4Y2VwdCUyMFJ1bnRpbWVFcnJvciUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJNZXJnaW5nJTIwZmFpbGVkJTNBJTIwJTdCZSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjMlMjBJbXBsZW1lbnQlMjBmYWxsYmFjayUyMHN0cmF0ZWd5JTIwb3IlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEElMEElMjMlMjA0LiUyMFNhdmUlMjB0aGUlMjBtZXJnZWQlMjBtb2RlbCUwQW1lcmdlZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZSUyRm1lcmdlZF9tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-comment"># 1. Load the base model</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;base_model_name&quot;</span>,
    dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># 2. Load the PEFT model with adapter</span>
peft_model = PeftModel.from_pretrained(
    base_model,
    <span class="hljs-string">&quot;path/to/adapter&quot;</span>,
    dtype=torch.bfloat16
)

<span class="hljs-comment"># 3. Merge adapter weights with base model</span>
<span class="hljs-keyword">try</span>:
    merged_model = peft_model.merge_and_unload()
<span class="hljs-keyword">except</span> RuntimeError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Merging failed: <span class="hljs-subst">{e}</span>&quot;</span>)
    <span class="hljs-comment"># Implement fallback strategy or memory optimization</span>

<span class="hljs-comment"># 4. Save the merged model</span>
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),S=new le({props:{code:"JTIzJTIwU2F2ZSUyMGJvdGglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJhc2VfbW9kZWxfbmFtZSUyMiklMEFtZXJnZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlJTJGbWVyZ2VkX21vZGVsJTIyKQ==",highlighted:`<span class="hljs-comment"># Save both model and tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;base_model_name&quot;</span>)
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),H=new y({props:{title:"Quick start with TRL + LoRA",local:"quick-start-with-trl--lora",headingTag:"h2"}}),P=new le({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMkMlMjBTRlRDb25maWclMEElMEElMjMlMjAxKSUyMENvbmZpZ3VyZSUyMExvUkElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBJTIzJTIwMiklMjBDcmVhdGUlMjB0cmFpbmVyJTIwKGV4YW1wbGUpJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcob3V0cHV0X2RpciUzRCUyMmxvcmEtYWRhcHRlciUyMiUyQyUyMG51bV90cmFpbl9lcG9jaHMlM0QxJTJDJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEMiUyQyUyMHBhY2tpbmclM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRHBlZnRfY29uZmlnJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig

<span class="hljs-comment"># 1) Configure LoRA</span>
peft_config = LoraConfig(
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># 2) Create trainer (example)</span>
trainer = SFTTrainer(
    model=model,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;lora-adapter&quot;</span>, num_train_epochs=<span class="hljs-number">1</span>, per_device_train_batch_size=<span class="hljs-number">2</span>, packing=<span class="hljs-literal">True</span>),
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    peft_config=peft_config,
)
trainer.train()`,wrap:!1}}),D=new y({props:{title:"Resources",local:"resources",headingTag:"h1"}}),O=new ct({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/3a.md"}}),{c(){p=i("meta"),g=n(),u=i("p"),ee=n(),m(T.$$.fragment),ne=n(),b=i("p"),b.textContent=Ve,se=n(),m(j.$$.fragment),ie=n(),J=i("ul"),J.innerHTML=Qe,oe=n(),m(U.$$.fragment),re=n(),$=i("p"),$.textContent=Xe,pe=n(),Z=i("p"),Z.innerHTML=xe,me=n(),R=i("p"),R.textContent=qe,de=n(),m(v.$$.fragment),Me=n(),k=i("p"),k.textContent=Se,fe=n(),m(C.$$.fragment),he=n(),B=i("p"),B.innerHTML=He,ce=n(),m(F.$$.fragment),ue=n(),_=i("p"),_.textContent=Ye,ye=n(),E=i("p"),E.innerHTML=Pe,we=n(),A=i("p"),A.textContent=ze,ge=n(),m(w.$$.fragment),Te=n(),m(I.$$.fragment),be=n(),W=i("p"),W.innerHTML=Ne,je=n(),m(L.$$.fragment),Je=n(),G=i("p"),G.textContent=De,Ue=n(),m(V.$$.fragment),$e=n(),m(Q.$$.fragment),Ze=n(),X=i("p"),X.textContent=Ke,Re=n(),m(x.$$.fragment),ve=n(),q=i("p"),q.textContent=Oe,ke=n(),m(S.$$.fragment),Ce=n(),m(H.$$.fragment),Be=n(),Y=i("p"),Y.innerHTML=et,Fe=n(),m(P.$$.fragment),_e=n(),z=i("p"),z.textContent=tt,Ee=n(),N=i("ul"),N.innerHTML=lt,Ae=n(),m(D.$$.fragment),Ie=n(),K=i("ul"),K.innerHTML=at,We=n(),m(O.$$.fragment),Le=n(),te=i("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),g=s(e),u=o(e,"P",{}),st(u).forEach(l),ee=s(e),d(T.$$.fragment,e),ne=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-dj8rbr"&&(b.textContent=Ve),se=s(e),d(j.$$.fragment,e),ie=s(e),J=o(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-1mvsu7l"&&(J.innerHTML=Qe),oe=s(e),d(U.$$.fragment,e),re=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-jvnjlq"&&($.textContent=Xe),pe=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1nturj5"&&(Z.innerHTML=xe),me=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1ore9lv"&&(R.textContent=qe),de=s(e),d(v.$$.fragment,e),Me=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ykjqgo"&&(k.textContent=Se),fe=s(e),d(C.$$.fragment,e),he=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ljdidi"&&(B.innerHTML=He),ce=s(e),d(F.$$.fragment,e),ue=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-159k8bc"&&(_.textContent=Ye),ye=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-8mb6ny"&&(E.innerHTML=Pe),we=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-q31ewq"&&(A.textContent=ze),ge=s(e),d(w.$$.fragment,e),Te=s(e),d(I.$$.fragment,e),be=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-17kc0j8"&&(W.innerHTML=Ne),je=s(e),d(L.$$.fragment,e),Je=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-6e2mqf"&&(G.textContent=De),Ue=s(e),d(V.$$.fragment,e),$e=s(e),d(Q.$$.fragment,e),Ze=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1h2v14z"&&(X.textContent=Ke),Re=s(e),d(x.$$.fragment,e),ve=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-j2a68t"&&(q.textContent=Oe),ke=s(e),d(S.$$.fragment,e),Ce=s(e),d(H.$$.fragment,e),Be=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1o3osh"&&(Y.innerHTML=et),Fe=s(e),d(P.$$.fragment,e),_e=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-lzynm4"&&(z.textContent=tt),Ee=s(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-9cs1te"&&(N.innerHTML=lt),Ae=s(e),d(D.$$.fragment,e),Ie=s(e),K=o(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-1pr7vnp"&&(K.innerHTML=at),We=s(e),d(O.$$.fragment,e),Le=s(e),te=o(e,"P",{}),st(te).forEach(l),this.h()},h(){it(p,"name","hf:doc:metadata"),it(p,"content",wt)},m(e,t){ft(document.head,p),a(e,g,t),a(e,u,t),a(e,ee,t),M(T,e,t),a(e,ne,t),a(e,b,t),a(e,se,t),M(j,e,t),a(e,ie,t),a(e,J,t),a(e,oe,t),M(U,e,t),a(e,re,t),a(e,$,t),a(e,pe,t),a(e,Z,t),a(e,me,t),a(e,R,t),a(e,de,t),M(v,e,t),a(e,Me,t),a(e,k,t),a(e,fe,t),M(C,e,t),a(e,he,t),a(e,B,t),a(e,ce,t),M(F,e,t),a(e,ue,t),a(e,_,t),a(e,ye,t),a(e,E,t),a(e,we,t),a(e,A,t),a(e,ge,t),M(w,e,t),a(e,Te,t),M(I,e,t),a(e,be,t),a(e,W,t),a(e,je,t),M(L,e,t),a(e,Je,t),a(e,G,t),a(e,Ue,t),M(V,e,t),a(e,$e,t),M(Q,e,t),a(e,Ze,t),a(e,X,t),a(e,Re,t),M(x,e,t),a(e,ve,t),a(e,q,t),a(e,ke,t),M(S,e,t),a(e,Ce,t),M(H,e,t),a(e,Be,t),a(e,Y,t),a(e,Fe,t),M(P,e,t),a(e,_e,t),a(e,z,t),a(e,Ee,t),a(e,N,t),a(e,Ae,t),M(D,e,t),a(e,Ie,t),a(e,K,t),a(e,We,t),M(O,e,t),a(e,Le,t),a(e,te,t),Ge=!0},p(e,[t]){const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),w.$set(nt)},i(e){Ge||(f(T.$$.fragment,e),f(j.$$.fragment,e),f(U.$$.fragment,e),f(v.$$.fragment,e),f(C.$$.fragment,e),f(F.$$.fragment,e),f(w.$$.fragment,e),f(I.$$.fragment,e),f(L.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(x.$$.fragment,e),f(S.$$.fragment,e),f(H.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),Ge=!0)},o(e){h(T.$$.fragment,e),h(j.$$.fragment,e),h(U.$$.fragment,e),h(v.$$.fragment,e),h(C.$$.fragment,e),h(F.$$.fragment,e),h(w.$$.fragment,e),h(I.$$.fragment,e),h(L.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),h(x.$$.fragment,e),h(S.$$.fragment,e),h(H.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),Ge=!1},d(e){e&&(l(g),l(u),l(ee),l(ne),l(b),l(se),l(ie),l(J),l(oe),l(re),l($),l(pe),l(Z),l(me),l(R),l(de),l(Me),l(k),l(fe),l(he),l(B),l(ce),l(ue),l(_),l(ye),l(E),l(we),l(A),l(ge),l(Te),l(be),l(W),l(je),l(Je),l(G),l(Ue),l($e),l(Ze),l(X),l(Re),l(ve),l(q),l(ke),l(Ce),l(Be),l(Y),l(Fe),l(_e),l(z),l(Ee),l(N),l(Ae),l(Ie),l(K),l(We),l(Le),l(te)),l(p),c(T,e),c(j,e),c(U,e),c(v,e),c(C,e),c(F,e),c(w,e),c(I,e),c(L,e),c(V,e),c(Q,e),c(x,e),c(S,e),c(H,e),c(P,e),c(D,e),c(O,e)}}}const wt='{"title":"LoRA and PEFT: Efficient Fine-Tuning","local":"lora-and-peft-efficient-fine-tuning","sections":[{"title":"When to use PEFT","local":"when-to-use-peft","sections":[],"depth":2},{"title":"Understanding LoRA","local":"understanding-lora","sections":[],"depth":2},{"title":"Loading LoRA Adapters","local":"loading-lora-adapters","sections":[],"depth":2},{"title":"Merging LoRA Adapters","local":"merging-lora-adapters","sections":[],"depth":2},{"title":"OLoRA","local":"olora","sections":[],"depth":2},{"title":"Using TRL with PEFT","local":"using-trl-with-peft","sections":[],"depth":2},{"title":"Basic Merging Implementation","local":"basic-merging-implementation","sections":[],"depth":2},{"title":"Quick start with TRL + LoRA","local":"quick-start-with-trl--lora","sections":[],"depth":2}],"depth":1}';function gt(ae){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ut extends mt{constructor(p){super(),dt(this,p,gt,yt,ot,{})}}export{Ut as component};
