# Understanding Robot Kinematics

In this section, we'll build intuition for robot kinematics through a concrete, worked example. Kinematics describes the mathematical relationship between joint angles and end-effector positions - given the joint configuration, where does the robot's hand end up? We'll explore this fundamental concept by walking through a simplified but representative case.

Let's examine how traditional robotics approaches robot control using a specific example you can follow step by step.

## From Complex to Simple: The SO-100 Example

We'll start with a familiar robot platform and systematically simplify it to isolate the core kinematic principles without unnecessary complexity.

<img src="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-so100-to-planar-manipulator.png" alt="SO-100 to Planar Manipulator" style="width: 70%;" />

The SO-100 arm simplified to a 2D planar manipulator by constraining some joints.

The SO-100 is a 6-degree-of-freedom (6-DOF) robot arm. To understand the principles, let's simplify it to a **2-DOF planar manipulator** by constraining some joints.

## The Simplified Robot

<!-- TODO: Reimplement this in vanilla python -->

To keep the math clear, our simplified robot has:
- **Two joints** with angles θ₁ and θ₂  
- **Two links** of equal length *l*
- **Configuration** q = [θ₁, θ₂] ∈ [-π, +π]²

## Forward Kinematics: From Joints to Position

**Question:** Given joint angles θ₁ and θ₂, where is the end-effector?

**Answer:** We can calculate the end-effector position mathematically:

$$p(q) = \begin{pmatrix} l \cos(\theta_1) + l \cos(\theta_1 + \theta_2) \\ l \sin(\theta_1) + l \sin(\theta_1 + \theta_2) \end{pmatrix}$$

This is called **Forward Kinematics (FK)** - mapping from joint space to task space.

<!-- TODO: Small diagram: two-link arm in the plane with angles θ₁, θ₂ and link length l, showing how the two vector contributions add head-to-tail to reach p(q). -->

> [!TIP]
> **Understanding the Math:** This equation comes from basic trigonometry! 
> - First link: endpoint at $(l \cos(\theta_1), l \sin(\theta_1))$
> - Second link: starts from first link's end, rotated by $\theta_1 + \theta_2$
> - Final position: sum of both link contributions
>
> **Why it matters:** For a simple robot, FK is relatively easy - given joint angles, we can always compute where the robot's hand is. More complex robots - for instance, dexterous hands, are more challenging to model.

## Inverse Kinematics: From Position to Joints

Now let’s try to invert the mapping: given a desired hand position, what joint configuration achieves it?

**Question:** Given a desired end-effector position p*, what joint angles should we use?

**Answer:** This is **Inverse Kinematics (IK)** - typically more intricate to solve, as it deals with the Jacobian matrix of the forward kinematics function!

We need to solve: $p(q) = p^*$

In general, this becomes an optimization problem:
$$\min_{q \in \mathcal{Q}} \|p(q) - p^*\|_2^2$$

<!-- TODO: Workspace sketch: a reachable annulus for a 2‑link arm (inner radius |l₁−l₂|, outer radius l₁+l₂), with an in‑workspace and out‑of‑workspace target p*. -->

> [!WARNING]
> **Why IK is Hard:**
> - **Multiple solutions** - Same end position can be reached with different joint angles
>
> - **Nonlinear equations** - Some functions make analytical solutions difficult
> - **Constraints** - Joint limits and obstacles further complicate the problem
>
> This is why robotics engineers spend so much time on IK algorithms!

## The Challenge of Constraints

<img src="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-planar-manipulator-free.png" alt="Free Motion" style="width: 100%; max-width: 200px;" />

*Free to move*

<img src="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-planar-manipulator-floor.png" alt="Floor Constraint" style="width: 100%; max-width: 200px;" />

*Constrained by floor*

<img src="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-planar-manipulator-floor-shelf.png" alt="Multiple Constraints" style="width: 100%; max-width: 200px;" />

*Multiple obstacles*

Real robots face **constraints**:
- **Physical limits** - Can't move through the floor
- **Obstacles** - Must avoid collisions  
- **Joint limits** - Finite range of motion

These constraints make the feasible configuration space $\mathcal{Q}$ much more complex!

## Key Insight

Even for this **simple 2-DOF robot**, solving IK with constraints is non-trivial. Real robots have:
- **6+ degrees of freedom**
- **Complex geometries**  
- **Dynamic environments**
- **Uncertain models**

Traditional approaches require **extensive mathematical modeling** and **expert knowledge** for each specific case.

> [!TIP]
> Mental model: FK is a direct calculator (q → p) and is usually easy; IK is a search (p → q) and becomes hard as soon as you add workspace limits, obstacles, or joint constraints. When IK gets brittle, we'll switch to differential reasoning (velocities) in the next step.


<EditOnGithub source="https://github.com/huggingface/robotics-course/blob/main/units/en/unit2/3.mdx" />