import{s as _e,o as Se,n as jt}from"../chunks/scheduler.4048030c.js";import{S as Ye,i as Xe,e as $,s as r,c as d,h as Ne,a as y,d as s,b as p,f as Ze,g as f,j as w,k as be,l as Qe,m as n,n as h,t as u,o as g,p as M}from"../chunks/index.30ed9803.js";import{C as Fe,H as U,E as ze}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.dd450cc7.js";import{C as yt}from"../chunks/CodeBlock.0b3c6118.js";import{Q as J}from"../chunks/Question.99129fcf.js";import{H as Ee,a as Ut}from"../chunks/HfOption.ebe1243c.js";function Ae(j){let o,b="<strong>Basic Behavioral Cloning</strong> (learn current action from current observation):",c,m,i;return m=new yt({props:{code:"JTIzJTIwU2ltcGxlJTNBJTIwY3VycmVudCUyMG9ic2VydmF0aW9uJTIwJUUyJTg2JTkyJTIwY3VycmVudCUyMGFjdGlvbiUwQWRlbHRhX3RpbWVzdGFtcHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMud3Jpc3RfY2FtZXJhJTIyJTNBJTIwJTVCMC4wJTVEJTJDJTIwJTIwJTIzJTIwSnVzdCUyMGN1cnJlbnQlMjBmcmFtZSUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbiUyMiUzQSUyMCU1QjAuMCU1RCUyMCUyMCUyMyUyMEp1c3QlMjBjdXJyZW50JTIwYWN0aW9uJTBBJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMExlUm9ib3REYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmxlcm9ib3QlMkZzdmxhX3NvMTAxX3BpY2twbGFjZSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMGRlbHRhX3RpbWVzdGFtcHMlM0RkZWx0YV90aW1lc3RhbXBzJTBBKQ==",highlighted:`<span class="hljs-comment"># Simple: current observation → current action</span>
delta_timestamps = {
    <span class="hljs-string">&quot;observation.images.wrist_camera&quot;</span>: [<span class="hljs-number">0.0</span>],  <span class="hljs-comment"># Just current frame</span>
    <span class="hljs-string">&quot;action&quot;</span>: [<span class="hljs-number">0.0</span>]  <span class="hljs-comment"># Just current action</span>
}

dataset = LeRobotDataset(
    <span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>, 
    delta_timestamps=delta_timestamps
)`,wrap:!1}}),{c(){o=$("p"),o.innerHTML=b,c=r(),d(m.$$.fragment)},l(a){o=y(a,"P",{"data-svelte-h":!0}),w(o)!=="svelte-1fjvi9j"&&(o.innerHTML=b),c=p(a),f(m.$$.fragment,a)},m(a,l){n(a,o,l),n(a,c,l),h(m,a,l),i=!0},p:jt,i(a){i||(u(m.$$.fragment,a),i=!0)},o(a){g(m.$$.fragment,a),i=!1},d(a){a&&(s(o),s(c)),M(m,a)}}}function He(j){let o,b="<strong>History-Based BC</strong> (use observation history for better decisions):",c,m,i;return m=new yt({props:{code:"JTIzJTIwVXNlJTIwb2JzZXJ2YXRpb24lMjBoaXN0b3J5JTIwZm9yJTIwY29udGV4dCUwQWRlbHRhX3RpbWVzdGFtcHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMud3Jpc3RfY2FtZXJhJTIyJTNBJTIwJTVCLTAuMiUyQyUyMC0wLjElMkMlMjAwLjAlNUQlMkMlMjAlMjAlMjMlMjAyMDBtcyUyMGhpc3RvcnklMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlNUIwLjAlNUQlMjAlMjAlMjMlMjBDdXJyZW50JTIwYWN0aW9uJTBBJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMExlUm9ib3REYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmxlcm9ib3QlMkZzdmxhX3NvMTAxX3BpY2twbGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlbHRhX3RpbWVzdGFtcHMlM0RkZWx0YV90aW1lc3RhbXBzJTBBKSUwQSUwQXNhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIxMDAlNUQlMEElMjMlMjBJbWFnZXMlMjBzaGFwZSUzQSUyMCU1QjMlMkMlMjBDJTJDJTIwSCUyQyUyMFclNUQlMjAtJTIwMyUyMGhpc3RvcmljYWwlMjBmcmFtZXMlMEElMjMlMjBBY3Rpb24lMjBzaGFwZSUzQSUyMCU1QmFjdGlvbl9kaW0lNUQlMjAtJTIwc2luZ2xlJTIwY3VycmVudCUyMGFjdGlvbg==",highlighted:`<span class="hljs-comment"># Use observation history for context</span>
delta_timestamps = {
    <span class="hljs-string">&quot;observation.images.wrist_camera&quot;</span>: [-<span class="hljs-number">0.2</span>, -<span class="hljs-number">0.1</span>, <span class="hljs-number">0.0</span>],  <span class="hljs-comment"># 200ms history</span>
    <span class="hljs-string">&quot;action&quot;</span>: [<span class="hljs-number">0.0</span>]  <span class="hljs-comment"># Current action</span>
}

dataset = LeRobotDataset(
    <span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>,
    delta_timestamps=delta_timestamps
)

sample = dataset[<span class="hljs-number">100</span>]
<span class="hljs-comment"># Images shape: [3, C, H, W] - 3 historical frames</span>
<span class="hljs-comment"># Action shape: [action_dim] - single current action</span>`,wrap:!1}}),{c(){o=$("p"),o.innerHTML=b,c=r(),d(m.$$.fragment)},l(a){o=y(a,"P",{"data-svelte-h":!0}),w(o)!=="svelte-1vzsa0u"&&(o.innerHTML=b),c=p(a),f(m.$$.fragment,a)},m(a,l){n(a,o,l),n(a,c,l),h(m,a,l),i=!0},p:jt,i(a){i||(u(m.$$.fragment,a),i=!0)},o(a){g(m.$$.fragment,a),i=!1},d(a){a&&(s(o),s(c)),M(m,a)}}}function Ve(j){let o,b="<strong>Action Chunking</strong> (predict action sequences for smoother control):",c,m,i;return m=new yt({props:{code:"JTIzJTIwUHJlZGljdCUyMG11bHRpcGxlJTIwZnV0dXJlJTIwYWN0aW9ucyUyMGF0JTIwb25jZSUwQWRlbHRhX3RpbWVzdGFtcHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMud3Jpc3RfY2FtZXJhJTIyJTNBJTIwJTVCLTAuMSUyQyUyMDAuMCU1RCUyQyUyMCUyMCUyMyUyMFJlY2VudCUyMCUyQiUyMGN1cnJlbnQlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlNUIwLjAlMkMlMjAwLjElMkMlMjAwLjIlMkMlMjAwLjMlNUQlMjAlMjAlMjMlMjBDdXJyZW50JTIwJTJCJTIwMyUyMGZ1dHVyZSUyMGFjdGlvbnMlMEElN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwTGVSb2JvdERhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybGVyb2JvdCUyRnN2bGFfc28xMDFfcGlja3BsYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVsdGFfdGltZXN0YW1wcyUzRGRlbHRhX3RpbWVzdGFtcHMlMEEpJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjEwMCU1RCUyMCUwQSUyMyUyMEltYWdlcyUyMHNoYXBlJTNBJTIwJTVCMiUyQyUyMEMlMkMlMjBIJTJDJTIwVyU1RCUyMC0lMjAyJTIwb2JzZXJ2YXRpb24lMjBmcmFtZXMlMEElMjMlMjBBY3Rpb24lMjBzaGFwZSUzQSUyMCU1QjQlMkMlMjBhY3Rpb25fZGltJTVEJTIwLSUyMDQlMjBhY3Rpb24lMjBwcmVkaWN0aW9ucw==",highlighted:`<span class="hljs-comment"># Predict multiple future actions at once</span>
delta_timestamps = {
    <span class="hljs-string">&quot;observation.images.wrist_camera&quot;</span>: [-<span class="hljs-number">0.1</span>, <span class="hljs-number">0.0</span>],  <span class="hljs-comment"># Recent + current</span>
    <span class="hljs-string">&quot;action&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">0.3</span>]  <span class="hljs-comment"># Current + 3 future actions</span>
}

dataset = LeRobotDataset(
    <span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>,
    delta_timestamps=delta_timestamps
)

sample = dataset[<span class="hljs-number">100</span>] 
<span class="hljs-comment"># Images shape: [2, C, H, W] - 2 observation frames</span>
<span class="hljs-comment"># Action shape: [4, action_dim] - 4 action predictions</span>`,wrap:!1}}),{c(){o=$("p"),o.innerHTML=b,c=r(),d(m.$$.fragment)},l(a){o=y(a,"P",{"data-svelte-h":!0}),w(o)!=="svelte-euuptz"&&(o.innerHTML=b),c=p(a),f(m.$$.fragment,a)},m(a,l){n(a,o,l),n(a,c,l),h(m,a,l),i=!0},p:jt,i(a){i||(u(m.$$.fragment,a),i=!0)},o(a){g(m.$$.fragment,a),i=!1},d(a){a&&(s(o),s(c)),M(m,a)}}}function qe(j){let o,b,c,m,i,a;return o=new Ut({props:{id:"temporal-windows",option:"basic-bc",$$slots:{default:[Ae]},$$scope:{ctx:j}}}),c=new Ut({props:{id:"temporal-windows",option:"history-bc",$$slots:{default:[He]},$$scope:{ctx:j}}}),i=new Ut({props:{id:"temporal-windows",option:"action-chunking",$$slots:{default:[Ve]},$$scope:{ctx:j}}}),{c(){d(o.$$.fragment),b=r(),d(c.$$.fragment),m=r(),d(i.$$.fragment)},l(l){f(o.$$.fragment,l),b=p(l),f(c.$$.fragment,l),m=p(l),f(i.$$.fragment,l)},m(l,T){h(o,l,T),n(l,b,T),h(c,l,T),n(l,m,T),h(i,l,T),a=!0},p(l,T){const x={};T&2&&(x.$$scope={dirty:T,ctx:l}),o.$set(x);const wt={};T&2&&(wt.$$scope={dirty:T,ctx:l}),c.$set(wt);const k={};T&2&&(k.$$scope={dirty:T,ctx:l}),i.$set(k)},i(l){a||(u(o.$$.fragment,l),u(c.$$.fragment,l),u(i.$$.fragment,l),a=!0)},o(l){g(o.$$.fragment,l),g(c.$$.fragment,l),g(i.$$.fragment,l),a=!1},d(l){l&&(s(b),s(m)),M(o,l),M(c,l),M(i,l)}}}function De(j){let o,b="<strong>Download Dataset</strong> (faster training, requires storage):",c,m,i;return m=new yt({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMubGVyb2JvdF9kYXRhc2V0JTIwaW1wb3J0JTIwTGVSb2JvdERhdGFzZXQlMEElMEElMjMlMjBEb3dubG9hZHMlMjBkYXRhc2V0JTIwdG8lMjBsb2NhbCUyMGNhY2hlJTBBZGF0YXNldCUyMCUzRCUyMExlUm9ib3REYXRhc2V0KCUyMmxlcm9ib3QlMkZzdmxhX3NvMTAxX3BpY2twbGFjZSUyMiklMEElMEElMjMlMjBGYXN0ZXN0JTIwYWNjZXNzJTIwYWZ0ZXIlMjBkb3dubG9hZCUwQXNhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIxMDAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset

<span class="hljs-comment"># Downloads dataset to local cache</span>
dataset = LeRobotDataset(<span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>)

<span class="hljs-comment"># Fastest access after download</span>
sample = dataset[<span class="hljs-number">100</span>]`,wrap:!1}}),{c(){o=$("p"),o.innerHTML=b,c=r(),d(m.$$.fragment)},l(a){o=y(a,"P",{"data-svelte-h":!0}),w(o)!=="svelte-15sgzp4"&&(o.innerHTML=b),c=p(a),f(m.$$.fragment,a)},m(a,l){n(a,o,l),n(a,c,l),h(m,a,l),i=!0},p:jt,i(a){i||(u(m.$$.fragment,a),i=!0)},o(a){g(m.$$.fragment,a),i=!1},d(a){a&&(s(o),s(c)),M(m,a)}}}function Pe(j){let o,b="<strong>Stream Dataset</strong> (no storage needed, requires internet):",c,m,i;return m=new yt({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMuc3RyZWFtaW5nX2RhdGFzZXQlMjBpbXBvcnQlMjBTdHJlYW1pbmdMZVJvYm90RGF0YXNldCUwQSUwQSUyMyUyMFN0cmVhbSUyMGRhdGElMjB3aXRob3V0JTIwZG93bmxvYWRpbmclMEFzdHJlYW1pbmdfZGF0YXNldCUyMCUzRCUyMFN0cmVhbWluZ0xlUm9ib3REYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmxlcm9ib3QlMkZzdmxhX3NvMTAxX3BpY2twbGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlbHRhX3RpbWVzdGFtcHMlM0RkZWx0YV90aW1lc3RhbXBzJTBBKSUwQSUwQSUyMyUyMFdvcmtzJTIwZXhhY3RseSUyMGxpa2UlMjByZWd1bGFyJTIwZGF0YXNldCUwQXNhbXBsZSUyMCUzRCUyMHN0cmVhbWluZ19kYXRhc2V0JTVCMTAwJTVE",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.streaming_dataset <span class="hljs-keyword">import</span> StreamingLeRobotDataset

<span class="hljs-comment"># Stream data without downloading</span>
streaming_dataset = StreamingLeRobotDataset(
    <span class="hljs-string">&quot;lerobot/svla_so101_pickplace&quot;</span>,
    delta_timestamps=delta_timestamps
)

<span class="hljs-comment"># Works exactly like regular dataset</span>
sample = streaming_dataset[<span class="hljs-number">100</span>]`,wrap:!1}}),{c(){o=$("p"),o.innerHTML=b,c=r(),d(m.$$.fragment)},l(a){o=y(a,"P",{"data-svelte-h":!0}),w(o)!=="svelte-yrm5vi"&&(o.innerHTML=b),c=p(a),f(m.$$.fragment,a)},m(a,l){n(a,o,l),n(a,c,l),h(m,a,l),i=!0},p:jt,i(a){i||(u(m.$$.fragment,a),i=!0)},o(a){g(m.$$.fragment,a),i=!1},d(a){a&&(s(o),s(c)),M(m,a)}}}function Ke(j){let o,b,c,m;return o=new Ut({props:{id:"dataset-loading",option:"download",$$slots:{default:[De]},$$scope:{ctx:j}}}),c=new Ut({props:{id:"dataset-loading",option:"streaming",$$slots:{default:[Pe]},$$scope:{ctx:j}}}),{c(){d(o.$$.fragment),b=r(),d(c.$$.fragment)},l(i){f(o.$$.fragment,i),b=p(i),f(c.$$.fragment,i)},m(i,a){h(o,i,a),n(i,b,a),h(c,i,a),m=!0},p(i,a){const l={};a&2&&(l.$$scope={dirty:a,ctx:i}),o.$set(l);const T={};a&2&&(T.$$scope={dirty:a,ctx:i}),c.$set(T)},i(i){m||(u(o.$$.fragment,i),u(c.$$.fragment,i),m=!0)},o(i){g(o.$$.fragment,i),g(c.$$.fragment,i),m=!1},d(i){i&&s(b),M(o,i),M(c,i)}}}function Oe(j){let o,b,c,m,i,a,l,T,x,wt="This section shows you how to work with robotics datasets from Hugging Face using the LeRobotDataset class. We’ll start with simple examples and gradually add complexity, so you can copy and adapt the approach that best fits your project.",k,G,$e="The key thing to understand is that any dataset on the Hub that follows LeRobot’s format (with tabular data, visual data, and metadata included) can be loaded with just one line of code.",Jt,B,ye="When working with robotics data, you often need to look at multiple time steps at once rather than single data points. Why? Most robot learning algorithms need to see how things change over time. For example, to pick up an object, a robot might need to see what happened in the last few moments to understand the current situation better. Similarly, many algorithms work better when they can plan several actions ahead rather than just deciding what to do right now.",xt,L,we="LeRobotDataset makes this easy with “temporal windowing.” You simply declare which time offsets you want (i.e. current frame plus the two previous ones), and it automatically handles the complexity of getting those frames, even when some might be missing at the beginning or end of an episode.",vt,W,Te='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobotdataset-v3/streaming-multiple-frames.png" alt="streaming-multiple-frames"/>',Ct,v,Ue="<p><strong>Temporal Windows Explained:</strong></p> <ul><li><strong>Observation history</strong>: <code>[-0.2, -0.1, 0.0]</code> gives you 200ms, 100ms, and current observations</li> <li><strong>Action sequences</strong>: <code>[0.0, 0.1, 0.2]</code> provides current and next 2 actions (100ms apart)</li> <li><strong>Automatic padding</strong>: Missing frames at episode boundaries are handled automatically. The datasets always returns the requested number of frames, and it applies padding where necessary.</li> <li><strong>Mask included</strong>: Know which frames are real vs. padded for proper training</li></ul>",Rt,Z,je="Conveniently, by using LeRobotDataset with a PyTorch <code>DataLoader</code> one can automatically collate the individual sample dictionaries from the dataset into a single dictionary of batched tensors for downstream training or inference. LeRobotDataset also natively supports streaming mode for datasets. Users can stream data of a large dataset hosted on the Hugging Face Hub, with a one-line change in their implementation. Streaming datasets supports high-performance batch processing (ca. 80-100 it/s, varying on connectivity) and high levels of frames randomization, key features for practical BC algorithms which otherwise may be slow or operating on highly non-i.i.d. data. This feature is designed to improve on accessibility so that large datasets can be processed by users without requiring large amounts of memory and storage.",It,E,Je="Here are different ways to set up temporal windows depending on your use case. Skim the options and pick one to start—switching later is just a change to the dictionary.",kt,C,Gt,_,Bt,R,xe="<p><strong>When to use streaming:</strong></p> <ul><li><strong>Dataset &gt; available storage</strong> - Stream datasets that don’t fit on your disk</li> <li><strong>Experimentation</strong> - Quickly try different datasets without downloading</li> <li><strong>Cloud training</strong> - Reduce startup time by streaming from Hugging Face Hub</li> <li><strong>Network available</strong> - Requires stable internet connection during training</li></ul> <p><strong>Performance:</strong> Streaming achieves 80-100 it/s with good connectivity! That is (on average) comparable with locally-stored datasets, factoring out initialization overhead.</p>",Lt,I,Wt,S,Zt,Y,ve="You can easily integrate regular and streaming datasets with torch data loaders. This makes integrating any LeRobotDataset with your own (<code>torch</code>) training loop rather convenient. Because we fetch all frames from the datasets as a tensor, wrapping iterating over a dataset with training is particularly straightforward.",Et,X,_t,N,St,Q,Yt,F,Ce="This simple API hides significant complexity:",Xt,z,Re="<li>✅ <strong>Multi-modal synchronization</strong> - Images and sensors perfectly aligned</li> <li>✅ <strong>Efficient storage</strong> - Compressed videos, memory-mapped arrays</li> <li>✅ <strong>Temporal handling</strong> - Easy access to observation/action sequences</li> <li>✅ <strong>Scalability</strong> - Same code works for small and massive datasets</li>",Nt,A,Ie="Compare this to traditional robotics data handling, which often requires:",Qt,H,ke="<li>Custom parsers for each data format</li> <li>Manual synchronization across modalities</li> <li>Complex buffering for temporal windows</li> <li>Platform-specific loading code</li>",Ft,V,Ge="LeRobotDataset <strong>standardizes and simplifies</strong> all of this!",zt,q,At,D,Be="Test your understanding of LeRobot and its role in robot learning:",Ht,P,Vt,K,qt,O,Dt,tt,Pt,et,Kt,at,Ot,st,te,nt,ee,ot,ae,it,se,lt,ne,rt,oe,pt,ie,mt,le,ct,re,dt,pe,ft,me,ht,ce,ut,de,gt,fe,Mt,he,bt,ue,$t,ge,Tt,Me;return i=new Fe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),l=new U({props:{title:"Code Example: Datasets, in practice",local:"code-example-datasets-in-practice",headingTag:"h1"}}),C=new Ee({props:{id:"temporal-windows",options:["basic-bc","history-bc","action-chunking"],$$slots:{default:[qe]},$$scope:{ctx:j}}}),_=new U({props:{title:"Streaming Large Datasets",local:"streaming-large-datasets",headingTag:"h3"}}),I=new Ee({props:{id:"dataset-loading",options:["download","streaming"],$$slots:{default:[Ke]},$$scope:{ctx:j}}}),S=new U({props:{title:"Training Integration",local:"training-integration",headingTag:"h2"}}),X=new U({props:{title:"PyTorch DataLoader",local:"pytorch-dataloader",headingTag:"h3"}}),N=new yt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEElMjMlMjBDcmVhdGUlMjBEYXRhTG9hZGVyJTIwZm9yJTIwdHJhaW5pbmclMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBudW1fd29ya2VycyUzRDQlMEEpJTBBJTBBJTIzJTIwVHJhaW5pbmclMjBsb29wJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTW92ZSUyMHRvJTIwZGV2aWNlJTBBJTIwJTIwJTIwJTIwb2JzZXJ2YXRpb25zJTIwJTNEJTIwYmF0Y2glNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiU1RC50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwYWN0aW9ucyUyMCUzRCUyMGJhdGNoJTVCJTIyYWN0aW9uJTIyJTVELnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBiYXRjaCU1QiUyMm9ic2VydmF0aW9uLmltYWdlcy53cmlzdF9jYW1lcmElMjIlNUQudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFlvdXIlMjBtb2RlbCUyMHRyYWluaW5nJTIwaGVyZSUwQSUyMCUyMCUyMCUyMCUyMyUyMGxvc3MlMjAlM0QlMjBtb2RlbChvYnNlcnZhdGlvbnMlMkMlMjBpbWFnZXMlMkMlMjBhY3Rpb25zKSUwQSUyMCUyMCUyMCUyMCUyMyUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMCUyMyUyMG9wdGltaXplci5zdGVwKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-comment"># Create DataLoader for training</span>
dataloader = DataLoader(
    dataset,
    batch_size=<span class="hljs-number">16</span>,
    shuffle=<span class="hljs-literal">True</span>,
    num_workers=<span class="hljs-number">4</span>
)

<span class="hljs-comment"># Training loop</span>
device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-comment"># Move to device</span>
    observations = batch[<span class="hljs-string">&quot;observation.state&quot;</span>].to(device)
    actions = batch[<span class="hljs-string">&quot;action&quot;</span>].to(device)
    images = batch[<span class="hljs-string">&quot;observation.images.wrist_camera&quot;</span>].to(device)
    
    <span class="hljs-comment"># Your model training here</span>
    <span class="hljs-comment"># loss = model(observations, images, actions)</span>
    <span class="hljs-comment"># loss.backward()</span>
    <span class="hljs-comment"># optimizer.step()</span>`,wrap:!1}}),Q=new U({props:{title:"Why This Matters",local:"why-this-matters",headingTag:"h2"}}),q=new U({props:{title:"Section Quiz",local:"section-quiz",headingTag:"h2"}}),P=new U({props:{title:"1. What makes LeRobot different from traditional robotics libraries?",local:"1-what-makes-lerobot-different-from-traditional-robotics-libraries",headingTag:"h3"}}),K=new J({props:{choices:[{text:"It only works with simulation environments.",explain:"LeRobot actually focuses on real-world robots and supports many physical platforms."},{text:"It provides end-to-end integration across the entire robotics stack with state-of-the-art learning algorithms.",explain:"LeRobot's key innovation is combining hardware control, data handling, and learning algorithms in one unified library.",correct:!0},{text:"It requires expensive industrial robots to function.",explain:"LeRobot focuses on accessible, low-cost robots to democratize robotics."},{text:"It only supports classical control methods.",explain:"LeRobot specifically focuses on learning-based approaches, not classical control."}]}}),O=new U({props:{title:"2. Which of the following is NOT a key component of LeRobot’s approach?",local:"2-which-of-the-following-is-not-a-key-component-of-lerobots-approach",headingTag:"h3"}}),tt=new J({props:{choices:[{text:"Unified low-level robot configuration handling",explain:"This is indeed a key component that enables cross-platform compatibility."},{text:"Native robotics dataset format (LeRobotDataset)",explain:"LeRobotDataset is a central innovation of the library."},{text:"Requiring expert knowledge for each new robot platform",explain:"This is actually what LeRobot aims to eliminate - it reduces the expertise barrier.",correct:!0},{text:"State-of-the-art learning algorithms with PyTorch implementations",explain:"SOTA algorithms are a core feature of LeRobot."}]}}),et=new U({props:{title:"3. What is the main advantage of LeRobot’s optimized inference stack?",local:"3-what-is-the-main-advantage-of-lerobots-optimized-inference-stack",headingTag:"h3"}}),at=new J({props:{choices:[{text:"It makes training faster on GPUs.",explain:"The inference stack is about deployment, not training speed."},{text:"It reduces the memory requirements for storing datasets.",explain:"Memory reduction is handled by the dataset format, not the inference stack."},{text:"It decouples action planning from action execution for better real-time performance.",explain:"This separation is crucial for real-time robot control where millisecond delays matter.",correct:!0},{text:"It automatically generates training data from robot interactions.",explain:"Data generation is not handled by the inference stack."}]}}),st=new U({props:{title:"4. Which types of robotic platforms does LeRobot support?",local:"4-which-types-of-robotic-platforms-does-lerobot-support",headingTag:"h3"}}),nt=new J({props:{choices:[{text:"Only manipulation robots like robotic arms.",explain:"LeRobot supports much more than just manipulation platforms."},{text:"Manipulation, locomotion, and whole-body control platforms.",explain:"LeRobot supports the full spectrum of robotic platforms, from simple arms to complex humanoids.",correct:!0},{text:"Only robots that cost more than $10,000.",explain:"LeRobot focuses on accessible, low-cost platforms to democratize robotics."},{text:"Only robots manufactured by specific companies.",explain:"LeRobot supports open-source and accessible robots from various sources."}]}}),ot=new U({props:{title:"5. What does “end-to-end integration with the robotics stack” mean in the context of LeRobot?",local:"5-what-does-end-to-end-integration-with-the-robotics-stack-mean-in-the-context-of-lerobot",headingTag:"h3"}}),it=new J({props:{choices:[{text:"It only handles high-level planning, not low-level control.",explain:"End-to-end means it covers everything from low-level control to high-level algorithms."},{text:"It covers everything from low-level hardware control to high-level learning algorithms.",explain:"This comprehensive coverage eliminates the need to integrate multiple separate tools.",correct:!0},{text:"It requires separate tools for data handling and model training.",explain:"End-to-end integration means you don't need separate tools - everything is unified."},{text:"It only works with specific operating systems.",explain:"Platform integration refers to robotics components, not operating systems."}]}}),lt=new U({props:{title:"6. What is the primary purpose of the delta_timestamps parameter in LeRobotDataset?",local:"6-what-is-the-primary-purpose-of-the-deltatimestamps-parameter-in-lerobotdataset",headingTag:"h3"}}),rt=new J({props:{choices:[{text:"It sets the frame rate for video recording.",explain:"Frame rates are stored in metadata, not controlled by delta_timestamps."},{text:"It defines temporal windows to access observation histories and action sequences.",explain:"delta_timestamps allows you to specify which time offsets to include, enabling access to past observations and future actions.",correct:!0},{text:"It synchronizes data across different robots.",explain:"Synchronization across robots is not handled by delta_timestamps."},{text:"It compresses video data for storage efficiency.",explain:"Video compression is handled separately in the dataset storage format."}]}}),pt=new U({props:{title:"7. Which of the following best describes the three main components of LeRobotDataset?",local:"7-which-of-the-following-best-describes-the-three-main-components-of-lerobotdataset",headingTag:"h3"}}),mt=new J({props:{choices:[{text:"Images, Actions, and Rewards",explain:"While these are important data types, they don't describe the architectural components."},{text:"Tabular Data, Visual Data, and Metadata",explain:"These are the three architectural pillars: efficient storage for sensor data, compressed videos, and JSON metadata files.",correct:!0},{text:"Training, Validation, and Test sets",explain:"These are data splits, not the architectural components of the format."},{text:"Simulation, Real Robot, and Hybrid data",explain:"These describe data sources, not the storage architecture."}]}}),ct=new U({props:{title:"8. What happens when you use StreamingLeRobotDataset instead of LeRobotDataset ?",local:"8-what-happens-when-you-use-streaminglerobotdataset-instead-of-lerobotdataset-",headingTag:"h3"}}),dt=new J({props:{choices:[{text:"The data is automatically augmented for better training.",explain:"Streaming doesn't involve data augmentation - that's a separate preprocessing step."},{text:"The dataset is downloaded faster to your local machine.",explain:"Streaming actually avoids downloading the dataset entirely."},{text:"Data is streamed from the Hugging Face Hub without downloading, saving storage space.",explain:"StreamingLeRobotDataset allows you to process large datasets without downloading them locally.",correct:!0},{text:"The dataset is automatically split into train/validation sets.",explain:"Data splitting is independent of the streaming vs download choice."}]}}),ft=new U({props:{title:"9. In the context of robot learning, what does “temporal windowing” refer to?",local:"9-in-the-context-of-robot-learning-what-does-temporal-windowing-refer-to",headingTag:"h3"}}),ht=new J({props:{choices:[{text:"The time it takes to train a robot learning model.",explain:"Training time is not what temporal windowing refers to."},{text:"Accessing multiple time steps of observations and actions around a given frame.",explain:"Temporal windowing allows algorithms to use observation history and action sequences, crucial for robot learning.",correct:!0},{text:"The frequency at which robot sensors collect data.",explain:"Sensor frequency is separate from temporal windowing in datasets."},{text:"The duration of each robot episode or trajectory.",explain:"Episode duration is different from temporal windowing within episodes."}]}}),ut=new U({props:{title:"10. What is the main advantage of LeRobotDataset’s approach to storing video data?",local:"10-what-is-the-main-advantage-of-lerobotdatasets-approach-to-storing-video-data",headingTag:"h3"}}),gt=new J({props:{choices:[{text:"Videos are stored in the highest possible quality.",explain:"Quality isn't the main focus - efficiency and scalability are."},{text:"Each frame is stored as a separate file for easy access.",explain:"This would actually be inefficient - LeRobotDataset does the opposite."},{text:"Multiple episodes are concatenated into larger MP4 files to reduce file system stress.",explain:"This approach dramatically reduces the number of files, making storage more efficient for large datasets.",correct:!0},{text:"Videos are automatically compressed using AI algorithms.",explain:"Standard video compression is used, not AI-based compression."}]}}),Mt=new U({props:{title:"11. Which statement about LeRobotDataset’s compatibility is correct?",local:"11-which-statement-about-lerobotdatasets-compatibility-is-correct",headingTag:"h3"}}),bt=new J({props:{choices:[{text:"It only works with specific robot brands like SO-100.",explain:"LeRobotDataset is designed to work across many different robot platforms."},{text:"It requires custom code for each new robot platform.",explain:"The unified format reduces the need for custom code per platform."},{text:"It integrates seamlessly with PyTorch DataLoader and Hugging Face ecosystems.",explain:"This integration makes it easy to use robotics data with existing ML workflows.",correct:!0},{text:"It only supports simulation data, not real robot data.",explain:"LeRobotDataset supports both simulation and real robot data."}]}}),$t=new ze({props:{source:"https://github.com/huggingface/robotics-course/blob/main/units/en/unit1/4.mdx"}}),{c(){o=$("meta"),b=r(),c=$("p"),m=r(),d(i.$$.fragment),a=r(),d(l.$$.fragment),T=r(),x=$("p"),x.textContent=wt,k=r(),G=$("p"),G.textContent=$e,Jt=r(),B=$("p"),B.textContent=ye,xt=r(),L=$("p"),L.textContent=we,vt=r(),W=$("p"),W.innerHTML=Te,Ct=r(),v=$("blockquote"),v.innerHTML=Ue,Rt=r(),Z=$("p"),Z.innerHTML=je,It=r(),E=$("p"),E.textContent=Je,kt=r(),d(C.$$.fragment),Gt=r(),d(_.$$.fragment),Bt=r(),R=$("blockquote"),R.innerHTML=xe,Lt=r(),d(I.$$.fragment),Wt=r(),d(S.$$.fragment),Zt=r(),Y=$("p"),Y.innerHTML=ve,Et=r(),d(X.$$.fragment),_t=r(),d(N.$$.fragment),St=r(),d(Q.$$.fragment),Yt=r(),F=$("p"),F.textContent=Ce,Xt=r(),z=$("ul"),z.innerHTML=Re,Nt=r(),A=$("p"),A.textContent=Ie,Qt=r(),H=$("ul"),H.innerHTML=ke,Ft=r(),V=$("p"),V.innerHTML=Ge,zt=r(),d(q.$$.fragment),At=r(),D=$("p"),D.textContent=Be,Ht=r(),d(P.$$.fragment),Vt=r(),d(K.$$.fragment),qt=r(),d(O.$$.fragment),Dt=r(),d(tt.$$.fragment),Pt=r(),d(et.$$.fragment),Kt=r(),d(at.$$.fragment),Ot=r(),d(st.$$.fragment),te=r(),d(nt.$$.fragment),ee=r(),d(ot.$$.fragment),ae=r(),d(it.$$.fragment),se=r(),d(lt.$$.fragment),ne=r(),d(rt.$$.fragment),oe=r(),d(pt.$$.fragment),ie=r(),d(mt.$$.fragment),le=r(),d(ct.$$.fragment),re=r(),d(dt.$$.fragment),pe=r(),d(ft.$$.fragment),me=r(),d(ht.$$.fragment),ce=r(),d(ut.$$.fragment),de=r(),d(gt.$$.fragment),fe=r(),d(Mt.$$.fragment),he=r(),d(bt.$$.fragment),ue=r(),d($t.$$.fragment),ge=r(),Tt=$("p"),this.h()},l(t){const e=Ne("svelte-u9bgzb",document.head);o=y(e,"META",{name:!0,content:!0}),e.forEach(s),b=p(t),c=y(t,"P",{}),Ze(c).forEach(s),m=p(t),f(i.$$.fragment,t),a=p(t),f(l.$$.fragment,t),T=p(t),x=y(t,"P",{"data-svelte-h":!0}),w(x)!=="svelte-smct06"&&(x.textContent=wt),k=p(t),G=y(t,"P",{"data-svelte-h":!0}),w(G)!=="svelte-1bbrj1q"&&(G.textContent=$e),Jt=p(t),B=y(t,"P",{"data-svelte-h":!0}),w(B)!=="svelte-kt18oi"&&(B.textContent=ye),xt=p(t),L=y(t,"P",{"data-svelte-h":!0}),w(L)!=="svelte-1ub581g"&&(L.textContent=we),vt=p(t),W=y(t,"P",{"data-svelte-h":!0}),w(W)!=="svelte-9hadu7"&&(W.innerHTML=Te),Ct=p(t),v=y(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),w(v)!=="svelte-1j6ce3e"&&(v.innerHTML=Ue),Rt=p(t),Z=y(t,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-it421t"&&(Z.innerHTML=je),It=p(t),E=y(t,"P",{"data-svelte-h":!0}),w(E)!=="svelte-12j5tg"&&(E.textContent=Je),kt=p(t),f(C.$$.fragment,t),Gt=p(t),f(_.$$.fragment,t),Bt=p(t),R=y(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),w(R)!=="svelte-2bao43"&&(R.innerHTML=xe),Lt=p(t),f(I.$$.fragment,t),Wt=p(t),f(S.$$.fragment,t),Zt=p(t),Y=y(t,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-dsjor9"&&(Y.innerHTML=ve),Et=p(t),f(X.$$.fragment,t),_t=p(t),f(N.$$.fragment,t),St=p(t),f(Q.$$.fragment,t),Yt=p(t),F=y(t,"P",{"data-svelte-h":!0}),w(F)!=="svelte-13g30ke"&&(F.textContent=Ce),Xt=p(t),z=y(t,"UL",{"data-svelte-h":!0}),w(z)!=="svelte-grkgdm"&&(z.innerHTML=Re),Nt=p(t),A=y(t,"P",{"data-svelte-h":!0}),w(A)!=="svelte-b73vro"&&(A.textContent=Ie),Qt=p(t),H=y(t,"UL",{"data-svelte-h":!0}),w(H)!=="svelte-11xetiz"&&(H.innerHTML=ke),Ft=p(t),V=y(t,"P",{"data-svelte-h":!0}),w(V)!=="svelte-1dusnnt"&&(V.innerHTML=Ge),zt=p(t),f(q.$$.fragment,t),At=p(t),D=y(t,"P",{"data-svelte-h":!0}),w(D)!=="svelte-1drt45h"&&(D.textContent=Be),Ht=p(t),f(P.$$.fragment,t),Vt=p(t),f(K.$$.fragment,t),qt=p(t),f(O.$$.fragment,t),Dt=p(t),f(tt.$$.fragment,t),Pt=p(t),f(et.$$.fragment,t),Kt=p(t),f(at.$$.fragment,t),Ot=p(t),f(st.$$.fragment,t),te=p(t),f(nt.$$.fragment,t),ee=p(t),f(ot.$$.fragment,t),ae=p(t),f(it.$$.fragment,t),se=p(t),f(lt.$$.fragment,t),ne=p(t),f(rt.$$.fragment,t),oe=p(t),f(pt.$$.fragment,t),ie=p(t),f(mt.$$.fragment,t),le=p(t),f(ct.$$.fragment,t),re=p(t),f(dt.$$.fragment,t),pe=p(t),f(ft.$$.fragment,t),me=p(t),f(ht.$$.fragment,t),ce=p(t),f(ut.$$.fragment,t),de=p(t),f(gt.$$.fragment,t),fe=p(t),f(Mt.$$.fragment,t),he=p(t),f(bt.$$.fragment,t),ue=p(t),f($t.$$.fragment,t),ge=p(t),Tt=y(t,"P",{}),Ze(Tt).forEach(s),this.h()},h(){be(o,"name","hf:doc:metadata"),be(o,"content",ta),be(v,"class","tip"),be(R,"class","tip")},m(t,e){Qe(document.head,o),n(t,b,e),n(t,c,e),n(t,m,e),h(i,t,e),n(t,a,e),h(l,t,e),n(t,T,e),n(t,x,e),n(t,k,e),n(t,G,e),n(t,Jt,e),n(t,B,e),n(t,xt,e),n(t,L,e),n(t,vt,e),n(t,W,e),n(t,Ct,e),n(t,v,e),n(t,Rt,e),n(t,Z,e),n(t,It,e),n(t,E,e),n(t,kt,e),h(C,t,e),n(t,Gt,e),h(_,t,e),n(t,Bt,e),n(t,R,e),n(t,Lt,e),h(I,t,e),n(t,Wt,e),h(S,t,e),n(t,Zt,e),n(t,Y,e),n(t,Et,e),h(X,t,e),n(t,_t,e),h(N,t,e),n(t,St,e),h(Q,t,e),n(t,Yt,e),n(t,F,e),n(t,Xt,e),n(t,z,e),n(t,Nt,e),n(t,A,e),n(t,Qt,e),n(t,H,e),n(t,Ft,e),n(t,V,e),n(t,zt,e),h(q,t,e),n(t,At,e),n(t,D,e),n(t,Ht,e),h(P,t,e),n(t,Vt,e),h(K,t,e),n(t,qt,e),h(O,t,e),n(t,Dt,e),h(tt,t,e),n(t,Pt,e),h(et,t,e),n(t,Kt,e),h(at,t,e),n(t,Ot,e),h(st,t,e),n(t,te,e),h(nt,t,e),n(t,ee,e),h(ot,t,e),n(t,ae,e),h(it,t,e),n(t,se,e),h(lt,t,e),n(t,ne,e),h(rt,t,e),n(t,oe,e),h(pt,t,e),n(t,ie,e),h(mt,t,e),n(t,le,e),h(ct,t,e),n(t,re,e),h(dt,t,e),n(t,pe,e),h(ft,t,e),n(t,me,e),h(ht,t,e),n(t,ce,e),h(ut,t,e),n(t,de,e),h(gt,t,e),n(t,fe,e),h(Mt,t,e),n(t,he,e),h(bt,t,e),n(t,ue,e),h($t,t,e),n(t,ge,e),n(t,Tt,e),Me=!0},p(t,[e]){const Le={};e&2&&(Le.$$scope={dirty:e,ctx:t}),C.$set(Le);const We={};e&2&&(We.$$scope={dirty:e,ctx:t}),I.$set(We)},i(t){Me||(u(i.$$.fragment,t),u(l.$$.fragment,t),u(C.$$.fragment,t),u(_.$$.fragment,t),u(I.$$.fragment,t),u(S.$$.fragment,t),u(X.$$.fragment,t),u(N.$$.fragment,t),u(Q.$$.fragment,t),u(q.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(et.$$.fragment,t),u(at.$$.fragment,t),u(st.$$.fragment,t),u(nt.$$.fragment,t),u(ot.$$.fragment,t),u(it.$$.fragment,t),u(lt.$$.fragment,t),u(rt.$$.fragment,t),u(pt.$$.fragment,t),u(mt.$$.fragment,t),u(ct.$$.fragment,t),u(dt.$$.fragment,t),u(ft.$$.fragment,t),u(ht.$$.fragment,t),u(ut.$$.fragment,t),u(gt.$$.fragment,t),u(Mt.$$.fragment,t),u(bt.$$.fragment,t),u($t.$$.fragment,t),Me=!0)},o(t){g(i.$$.fragment,t),g(l.$$.fragment,t),g(C.$$.fragment,t),g(_.$$.fragment,t),g(I.$$.fragment,t),g(S.$$.fragment,t),g(X.$$.fragment,t),g(N.$$.fragment,t),g(Q.$$.fragment,t),g(q.$$.fragment,t),g(P.$$.fragment,t),g(K.$$.fragment,t),g(O.$$.fragment,t),g(tt.$$.fragment,t),g(et.$$.fragment,t),g(at.$$.fragment,t),g(st.$$.fragment,t),g(nt.$$.fragment,t),g(ot.$$.fragment,t),g(it.$$.fragment,t),g(lt.$$.fragment,t),g(rt.$$.fragment,t),g(pt.$$.fragment,t),g(mt.$$.fragment,t),g(ct.$$.fragment,t),g(dt.$$.fragment,t),g(ft.$$.fragment,t),g(ht.$$.fragment,t),g(ut.$$.fragment,t),g(gt.$$.fragment,t),g(Mt.$$.fragment,t),g(bt.$$.fragment,t),g($t.$$.fragment,t),Me=!1},d(t){t&&(s(b),s(c),s(m),s(a),s(T),s(x),s(k),s(G),s(Jt),s(B),s(xt),s(L),s(vt),s(W),s(Ct),s(v),s(Rt),s(Z),s(It),s(E),s(kt),s(Gt),s(Bt),s(R),s(Lt),s(Wt),s(Zt),s(Y),s(Et),s(_t),s(St),s(Yt),s(F),s(Xt),s(z),s(Nt),s(A),s(Qt),s(H),s(Ft),s(V),s(zt),s(At),s(D),s(Ht),s(Vt),s(qt),s(Dt),s(Pt),s(Kt),s(Ot),s(te),s(ee),s(ae),s(se),s(ne),s(oe),s(ie),s(le),s(re),s(pe),s(me),s(ce),s(de),s(fe),s(he),s(ue),s(ge),s(Tt)),s(o),M(i,t),M(l,t),M(C,t),M(_,t),M(I,t),M(S,t),M(X,t),M(N,t),M(Q,t),M(q,t),M(P,t),M(K,t),M(O,t),M(tt,t),M(et,t),M(at,t),M(st,t),M(nt,t),M(ot,t),M(it,t),M(lt,t),M(rt,t),M(pt,t),M(mt,t),M(ct,t),M(dt,t),M(ft,t),M(ht,t),M(ut,t),M(gt,t),M(Mt,t),M(bt,t),M($t,t)}}}const ta='{"title":"Code Example: Datasets, in practice","local":"code-example-datasets-in-practice","sections":[{"title":"Streaming Large Datasets","local":"streaming-large-datasets","sections":[],"depth":3},{"title":"Training Integration","local":"training-integration","sections":[{"title":"PyTorch DataLoader","local":"pytorch-dataloader","sections":[],"depth":3}],"depth":2},{"title":"Why This Matters","local":"why-this-matters","sections":[],"depth":2},{"title":"Section Quiz","local":"section-quiz","sections":[{"title":"1. What makes LeRobot different from traditional robotics libraries?","local":"1-what-makes-lerobot-different-from-traditional-robotics-libraries","sections":[],"depth":3},{"title":"2. Which of the following is NOT a key component of LeRobot’s approach?","local":"2-which-of-the-following-is-not-a-key-component-of-lerobots-approach","sections":[],"depth":3},{"title":"3. What is the main advantage of LeRobot’s optimized inference stack?","local":"3-what-is-the-main-advantage-of-lerobots-optimized-inference-stack","sections":[],"depth":3},{"title":"4. Which types of robotic platforms does LeRobot support?","local":"4-which-types-of-robotic-platforms-does-lerobot-support","sections":[],"depth":3},{"title":"5. What does “end-to-end integration with the robotics stack” mean in the context of LeRobot?","local":"5-what-does-end-to-end-integration-with-the-robotics-stack-mean-in-the-context-of-lerobot","sections":[],"depth":3},{"title":"6. What is the primary purpose of the delta_timestamps parameter in LeRobotDataset?","local":"6-what-is-the-primary-purpose-of-the-deltatimestamps-parameter-in-lerobotdataset","sections":[],"depth":3},{"title":"7. Which of the following best describes the three main components of LeRobotDataset?","local":"7-which-of-the-following-best-describes-the-three-main-components-of-lerobotdataset","sections":[],"depth":3},{"title":"8. What happens when you use StreamingLeRobotDataset instead of LeRobotDataset ?","local":"8-what-happens-when-you-use-streaminglerobotdataset-instead-of-lerobotdataset-","sections":[],"depth":3},{"title":"9. In the context of robot learning, what does “temporal windowing” refer to?","local":"9-in-the-context-of-robot-learning-what-does-temporal-windowing-refer-to","sections":[],"depth":3},{"title":"10. What is the main advantage of LeRobotDataset’s approach to storing video data?","local":"10-what-is-the-main-advantage-of-lerobotdatasets-approach-to-storing-video-data","sections":[],"depth":3},{"title":"11. Which statement about LeRobotDataset’s compatibility is correct?","local":"11-which-statement-about-lerobotdatasets-compatibility-is-correct","sections":[],"depth":3}],"depth":2}],"depth":1}';function ea(j){return Se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ra extends Ye{constructor(o){super(),Xe(this,o,ea,Oe,_e,{})}}export{ra as component};
