import{s as su,o as iu,n as $}from"../chunks/scheduler.7da89386.js";import{S as ru,i as lu,g as m,s as i,r as u,A as pu,h as c,f as l,c as r,j as x,u as f,x as M,k as I,y as s,a as g,v as _,d as h,t as b,w as y}from"../chunks/index.20910acc.js";import{T as Z}from"../chunks/Tip.53e22153.js";import{D as k}from"../chunks/Docstring.95501267.js";import{C as j}from"../chunks/CodeBlock.143bd81e.js";import{E as J}from"../chunks/ExampleCodeBlock.457e33ac.js";import{H as R}from"../chunks/getInferenceSnippets.eb0ed38b.js";function mu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function cu(v){let n,T="Example of text generation:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function du(v){let n,T="Example using <code>transformers.pipelines</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function gu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function uu(v){let n,T="Example of feature extraction:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-12vwt80"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function fu(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function _u(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function hu(v){let n,T="Example of text generation:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function bu(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function yu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Tu(v){let n,T="Example of single-label classification:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-ykxpe4"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function wu(v){let n,T="Example using <code>transformers.pipelines</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Mu(v){let n,T="Example using zero-shot-classification <code>transformers.pipelines</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1vtj8d2"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function vu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function xu(v){let n,T="Example of token classification:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-rtgw80"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Iu(v){let n,T="Example using <code>transformers.pipelines</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function ku(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function $u(v){let n,T="Example of mutliple choice:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-lfckvi"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Ju(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function ju(v){let n,T="Example of question answering:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1ml1brl"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Ru(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Nu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Uu(v){let n,T="Example of image classification:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1nh3zco"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Zu(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Cu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Su(v){let n,T="Example of semantic segmentation:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1wzzaup"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Wu(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Lu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Xu(v){let n,T="Example of audio classification:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1mp8f15"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Gu(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Pu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Ou(v){let n,T="Example of audio frame classification:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-12boqdm"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Fu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function zu(v){let n,T="Example of CTC:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-mdyxnj"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Vu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Bu(v){let n,T="Example of text generation:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Du(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function qu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Eu(v){let n,T="Example of Audio XVector:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1kzdm5c"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Hu(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Qu(v){let n,T="Example of text generation:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Yu(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Au(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function Ku(v){let n,T="Example of pix2struct:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-11ikyn3"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function ef(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function tf(v){let n,T="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-6kynse"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function nf(v){let n,T="Example using <code>transformers.pipelines</code>(only if the task is supported):",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-xxeb0k"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function of(v){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=c(a,"P",{"data-svelte-h":!0}),M(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,o){g(a,n,o)},p:$,d(a){a&&l(n)}}}function af(v){let n,T="Example of feature extraction:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-12vwt80"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function sf(v){let n,T="Example using <code>transformers.pipeline</code>:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function rf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function lf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKGRldmljZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDc2OCUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjc1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id_or_path = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionImg2ImgPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function pf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBbWFza19pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRmFjZSUyMG9mJTIwYSUyMHllbGxvdyUyMGNhdCUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTJDJTIwc2l0dGluZyUyMG9uJTIwYSUyMHBhcmslMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInpaintPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function mf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function cf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLXJlZmluZXItMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGcGF0cmlja3ZvbnBsYXRlbiUyRmltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYWFfeGwlMkYwMDAwMDAwMDkucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/aa_xl/000000009.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function df(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTElucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwbWFqZXN0aWMlMjB0aWdlciUyMHNpdHRpbmclMjBvbiUyMGElMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMHN0cmVuZ3RoJTNEMC44MCUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">50</span>, strength=<span class="hljs-number">0.80</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function gf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLXJlZmluZXItMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGcGF0cmlja3ZvbnBsYXRlbiUyRmltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYWFfeGwlMkYwMDAwMDAwMDkucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/aa_xl/000000009.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function uf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNpbWlhbkx1byUyRkxDTV9EcmVhbXNoYXBlcl92NyUyMiklMEElMjMlMjBUbyUyMHNhdmUlMjBHUFUlMjBtZW1vcnklMkMlMjB0b3JjaC5mbG9hdDE2JTIwY2FuJTIwYmUlMjB1c2VkJTJDJTIwYnV0JTIwaXQlMjBtYXklMjBjb21wcm9taXNlJTIwaW1hZ2UlMjBxdWFsaXR5LiUwQXBpcGUudG8odG9yY2hfZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMENhbiUyMGJlJTIwc2V0JTIwdG8lMjAxfjUwJTIwc3RlcHMuJTIwTENNJTIwc3VwcG9ydCUyMGZhc3QlMjBpbmZlcmVuY2UlMjBldmVuJTIwJTNDJTNEJTIwNCUyMHN0ZXBzLiUyMFJlY29tbWVuZCUzQSUyMDF+OCUyMHN0ZXBzLiUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjA0JTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To save GPU memory, torch.float16 can be used, but it may compromise image quality.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(torch_device=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.float32)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Can be set to 1~50 steps. LCM support fast inference even &lt;= 4 steps. Recommend: 1~8 steps.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, num_inference_steps=num_inference_steps, guidance_scale=<span class="hljs-number">8.0</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function ff(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBQSUwlMEElMEFwaXBlJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMlNpbWlhbkx1byUyRkxDTV9EcmVhbXNoYXBlcl92NyUyMiklMEElMjMlMjBUbyUyMHNhdmUlMjBHUFUlMjBtZW1vcnklMkMlMjB0b3JjaC5mbG9hdDE2JTIwY2FuJTIwYmUlMjB1c2VkJTJDJTIwYnV0JTIwaXQlMjBtYXklMjBjb21wcm9taXNlJTIwaW1hZ2UlMjBxdWFsaXR5LiUwQXBpcGUudG8odG9yY2hfZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIaWdoJTIwYWx0aXR1ZGUlMjBzbm93eSUyMG1vdW50YWlucyUyMiUwQWltYWdlJTIwJTNEJTIwUElMLkltYWdlLm9wZW4oJTIyLiUyRnNub3d5X21vdW50YWlucy5wbmclMjIpJTBBJTBBJTIzJTIwQ2FuJTIwYmUlMjBzZXQlMjB0byUyMDF+NTAlMjBzdGVwcy4lMjBMQ00lMjBzdXBwb3J0JTIwZmFzdCUyMGluZmVyZW5jZSUyMGV2ZW4lMjAlM0MlM0QlMjA0JTIwc3RlcHMuJTIwUmVjb21tZW5kJTNBJTIwMX44JTIwc3RlcHMuJTBBbnVtX2luZmVyZW5jZV9zdGVwcyUyMCUzRCUyMDQlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wJTBBKS5pbWFnZXMlMEElMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To save GPU memory, torch.float16 can be used, but it may compromise image quality.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(torch_device=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.float32)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;High altitude snowy mountains&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = PIL.Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;./snowy_mountains.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Can be set to 1~50 steps. LCM support fast inference even &lt;= 4 steps. Recommend: 1~8 steps.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, image=image, num_inference_steps=num_inference_steps, guidance_scale=<span class="hljs-number">8.0</span>
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function _f(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function hf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2UpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMHdpemFyZCUyQyUyMGdhbmRhbGYlMkMlMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGRldGFpbGVkJTJDJTIwZmFudGFzeSUyQyUyMGN1dGUlMkMlMjBhZG9yYWJsZSUyQyUyMFBpeGFyJTJDJTIwRGlzbmV5JTJDJTIwOGslMjIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC45NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id_or_path = <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AutoPipelineForImage2Image.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.95</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function bf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM0lucGFpbnRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNJbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkZhY2UlMjBvZiUyMGElMjB5ZWxsb3clMjBjYXQlMkMlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHNpdHRpbmclMjBvbiUyMGElMjBwYXJrJTIwYmVuY2glMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQXNvdXJjZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rzb3VyY2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFzaykuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2QzX2lucGFpbnRpbmcucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3InpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3InpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=source, mask_image=mask).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function yf(v){let n,T="Examples:",a,o,d;return o=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEElMjMlMjBEZXBlbmRpbmclMjBvbiUyMHRoZSUyMHZhcmlhbnQlMjBiZWluZyUyMHVzZWQlMkMlMjB0aGUlMjBwaXBlbGluZSUyMGNhbGwlMjB3aWxsJTIwc2xpZ2h0bHklMjB2YXJ5LiUwQSUyMyUyMFJlZmVyJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMGRvY3VtZW50YXRpb24lMjBmb3IlMjBtb3JlJTIwZGV0YWlscy4lMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0.0</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=i(),u(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=T),a=r(t),f(o.$$.fragment,t)},m(t,w){g(t,n,w),g(t,a,w),_(o,t,w),d=!0},p:$,i(t){d||(h(o.$$.fragment,t),d=!0)},o(t){b(o.$$.fragment,t),d=!1},d(t){t&&(l(n),l(a)),y(o,t)}}}function Tf(v){let n,T,a,o,d,t,w,lr,ro,cd="The following ORT classes are available for instantiating a base model class without a specific head.",pr,lo,mr,N,po,Cl,fs,dd="Base class for implementing models using ONNX Runtime.",Sl,_s,gd=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,Wl,hs,ud="Class attributes:",Ll,bs,fd=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,Xl,Ht,mo,Gl,ys,_d="Returns whether this model can generate sequences with <code>.generate()</code>.",Pl,U,co,Ol,Ts,hd="Instantiate a pretrained model from a pre-trained model configuration.",Fl,ws,bd=`provider (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>):
ONNX Runtime provider to use for loading the model.
See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for possible providers.
providers (<code>Optional[Sequence[str]]</code>, defaults to <code>None</code>):
List of execution providers to use for loading the model.
This argument takes precedence over the <code>provider</code> argument.
provider_options (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>):
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .
session_options (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>),:
ONNX Runtime session options to use for loading the model.
use_io_binding (<code>Optional[bool]</code>, defaults to <code>None</code>):
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.
kwargs (<code>Dict[str, Any]</code>):
Will be passed to the underlying model loading methods.`,zl,Ms,yd="<p>Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)</p>",Vl,vs,Td=`use_cache (<code>Optional[bool]</code>, defaults to <code>True</code>):
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,Bl,xs,wd="<p>Parameters for ORTModelForCausalLM</p>",Dl,Is,Md=`use_merged (<code>Optional[bool]</code>, defaults to <code>None</code>):
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,cr,go,dr,uo,vd="The following ORT classes are available for the following natural language processing tasks.",gr,fo,ur,ee,_o,ql,ks,xd=`ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt-bigcode, gpt_neo, gpt_neox, gptj, llama.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,El,$s,Id='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Hl,F,ho,Ql,Js,kd="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",Yl,Qt,Al,Yt,Kl,At,fr,bo,_r,te,yo,ep,js,$d=`ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,tp,Rs,Jd='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',np,z,To,op,Ns,jd="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",ap,Kt,sp,en,ip,tn,hr,wo,br,ne,Mo,rp,Us,Rd=`Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot-small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,lp,Zs,Nd="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",pp,V,vo,mp,Cs,Ud="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",cp,nn,dp,on,gp,an,yr,xo,Tr,L,Io,up,Ss,Zd=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,fp,Ws,Cd=`This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,_p,Ls,Sd='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',hp,W,ko,bp,Xs,Wd="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",yp,sn,Tp,rn,wp,ln,Mp,pn,wr,$o,Mr,X,Jo,vp,Gs,Ld=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,xp,Ps,Xd=`This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ip,Os,Gd='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',kp,B,jo,$p,Fs,Pd="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",Jp,mn,jp,cn,Rp,dn,vr,Ro,xr,G,No,Np,zs,Od=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Up,Vs,Fd=`This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Zp,Bs,zd='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Cp,Re,Uo,Sp,Ds,Vd="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",Wp,gn,Lp,un,Ir,Zo,kr,oe,Co,Xp,qs,Bd=`ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Gp,Es,Dd='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Pp,D,So,Op,Hs,qd="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",Fp,fn,zp,_n,Vp,hn,$r,Wo,Jr,Lo,Ed="The following ORT classes are available for the following computer vision tasks.",jr,Xo,Rr,ae,Go,Bp,Qs,Hd=`ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec-vision, deit, dinov2, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, swinv2, vit.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Dp,Ys,Qd='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',qp,q,Po,Ep,As,Yd="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",Hp,bn,Qp,yn,Yp,Tn,Nr,Oo,Ur,se,Fo,Ap,Ks,Ad=`ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports maskformer, segformer.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Kp,ei,Kd='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',em,E,zo,tm,ti,eg="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",nm,wn,om,Mn,am,vn,Zr,Vo,Cr,Bo,tg="The following ORT classes are available for the following audio tasks.",Sr,Do,Wr,P,qo,sm,ni,ng=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,im,oi,og=`This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,rm,ai,ag='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',lm,H,Eo,pm,si,sg="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",mm,xn,cm,In,dm,kn,Lr,Ho,Xr,ie,Qo,gm,ii,ig=`ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,um,ri,rg='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',fm,Ne,Yo,_m,li,lg="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",hm,$n,bm,Jn,Gr,Ao,Pr,re,Ko,ym,pi,pg=`ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Tm,mi,mg='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',wm,Ue,ea,Mm,ci,cg="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",vm,jn,xm,Rn,Or,ta,Fr,le,na,Im,di,dg=`Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,km,gi,gg="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",$m,Q,oa,Jm,ui,ug="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",jm,Nn,Rm,Un,Nm,Zn,zr,aa,Vr,pe,sa,Um,fi,fg=`ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Zm,_i,_g='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Cm,Ze,ia,Sm,hi,hg="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",Wm,Cn,Lm,Sn,Br,ra,Dr,la,bg="The following ORT classes are available for the following multimodal tasks.",qr,pa,Er,me,ma,Xm,bi,yg=`VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Gm,yi,Tg="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",Pm,Y,ca,Om,Ti,wg="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",Fm,Wn,zm,Ln,Vm,Xn,Hr,da,Qr,ce,ga,Bm,wi,Mg=`Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Dm,Mi,vg="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",qm,Ce,ua,Em,vi,xg="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",Hm,Gn,Qm,Pn,Yr,fa,Ar,_a,Ig="The following ORT classes are available for the following custom tasks.",Kr,ha,el,de,ba,Ym,xi,kg=`ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Am,Ii,$g='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Km,A,ya,ec,ki,Jg="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",tc,On,nc,Fn,oc,zn,tl,Ta,nl,ge,wa,ac,$i,jg=`ONNX Model for feature-extraction task.
This model inherits from <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,sc,Ji,Rg='This class should be initialized using the <a href="/docs/optimum/pr_pr_41/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ic,K,Ma,rc,ji,Ng="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",lc,Vn,pc,Bn,mc,Dn,ol,va,al,xa,sl,kt,Ia,cc,qn,ka,dc,Ri,Ug="Call self as a function.",il,$a,rl,Se,Ja,gc,Ni,Zg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline" rel="nofollow">diffusers.StableDiffusionPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,uc,gt,ja,fc,Ui,Cg="The call function to the pipeline for generation.",_c,En,ll,Ra,pl,We,Na,hc,Zi,Sg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionImg2ImgPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,bc,ut,Ua,yc,Ci,Wg="The call function to the pipeline for generation.",Tc,Hn,ml,Za,cl,Le,Ca,wc,Si,Lg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline" rel="nofollow">diffusers.StableDiffusionInpaintPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Mc,ft,Sa,vc,Wi,Xg="The call function to the pipeline for generation.",xc,Qn,dl,Wa,gl,Xe,La,Ic,Li,Gg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline" rel="nofollow">diffusers.StableDiffusionXLPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,kc,_t,Xa,$c,Xi,Pg="Function invoked when calling the pipeline for generation.",Jc,Yn,ul,Ga,fl,Ge,Pa,jc,Gi,Og=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionXLImg2ImgPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Rc,ht,Oa,Nc,Pi,Fg="Function invoked when calling the pipeline for generation.",Uc,An,_l,Fa,hl,Pe,za,Zc,Oi,zg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline" rel="nofollow">diffusers.StableDiffusionXLInpaintPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Cc,bt,Va,Sc,Fi,Vg="Function invoked when calling the pipeline for generation.",Wc,Kn,bl,Ba,yl,Oe,Da,Lc,zi,Bg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionXLImg2ImgPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Xc,yt,qa,Gc,Vi,Dg="Function invoked when calling the pipeline for generation.",Pc,eo,Tl,Ea,wl,Fe,Ha,Oc,Bi,qg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/latent_consistency#diffusers.LatentConsistencyModelPipeline" rel="nofollow">diffusers.LatentConsistencyModelPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Fc,Tt,Qa,zc,Di,Eg="The call function to the pipeline for generation.",Vc,to,Ml,Ya,vl,ze,Aa,Bc,qi,Hg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/latent_consistency_img2img#diffusers.LatentConsistencyModelImg2ImgPipeline" rel="nofollow">diffusers.LatentConsistencyModelImg2ImgPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Dc,wt,Ka,qc,Ei,Qg="The call function to the pipeline for generation.",Ec,no,xl,es,Il,Ve,ts,Hc,Hi,Yg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusion3Pipeline" rel="nofollow">diffusers.StableDiffusion3Pipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,Qc,Mt,ns,Yc,Qi,Ag="Function invoked when calling the pipeline for generation.",Ac,oo,kl,os,$l,Be,as,Kc,Yi,Kg=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusion3Img2ImgPipeline" rel="nofollow">diffusers.StableDiffusion3Img2ImgPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,ed,vt,ss,td,Ai,eu="Function invoked when calling the pipeline for generation.",nd,ao,Jl,is,jl,De,rs,od,Ki,tu=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusion3InpaintPipeline" rel="nofollow">diffusers.StableDiffusion3InpaintPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,ad,xt,ls,sd,er,nu="Function invoked when calling the pipeline for generation.",id,so,Rl,ps,Nl,qe,ms,rd,tr,ou=`ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/flux/text2img#diffusers.FluxPipeline" rel="nofollow">diffusers.FluxPipeline</a>.
This Pipeline inherits from <code>ORTDiffusionPipeline</code> and is used to run inference with the ONNX Runtime.
The pipeline can be loaded from a pretrained pipeline using the <code>ORTDiffusionPipeline.from_pretrained</code> method.`,ld,It,cs,pd,nr,au="Function invoked when calling the pipeline for generation.",md,io,Ul,rr,Zl;return d=new R({props:{title:"Models",local:"models",headingTag:"h1"}}),w=new R({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),lo=new R({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),po=new k({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.-",description:'<strong>-</strong> config (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> &#x2014; The configuration of the model. &#x2014;',name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> session (<code>~onnxruntime.InferenceSession</code>) &#x2014; The ONNX Runtime InferenceSession that is running the model. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to use I/O bindings with **ONNX Runtime &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.with",description:"<strong>with</strong> the CUDAExecutionProvider**, this can significantly speedup inference depending on the task. &#x2014;",name:"with"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> model_save_dir (<code>Path</code>) &#x2014; The directory where the model exported to ONNX is saved. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.By",description:"<strong>By</strong> defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the &#x2014;",name:"By"},{anchor:"optimum.onnxruntime.ORTModel.cache",description:"<strong>cache</strong> directory is used. &#x2014;",name:"cache"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L129"}}),mo=new k({props:{name:"can_generate",anchor:"optimum.onnxruntime.ORTModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L570"}}),co=new k({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": str | Path"},{name:"config",val:": PretrainedConfig | None = None"},{name:"export",val:": bool = False"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": str = 'main'"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"trust_remote_code",val:": bool = False"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": bool | str | None = None"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"providers",val:": Sequence[str] | None = None"},{name:"provider_options",val:": Sequence[dict[str, Any]] | dict[str, Any] | None = None"},{name:"session_options",val:": SessionOptions | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.export",description:`<strong>export</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> needs to be exported to the targeted format.`,name:"export"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
Deprecated. Please use the <code>token</code> argument instead.`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L442",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`}}),go=new R({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),fo=new R({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),_o=new k({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"generation_config",val:": GenerationConfig | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_decoder.py#L125"}}),ho=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": torch.LongTensor"},{name:"attention_mask",val:": torch.LongTensor | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"position_ids",val:": torch.LongTensor | None = None"},{name:"use_cache",val:": bool | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_decoder.py#L258"}}),Qt=new Z({props:{$$slots:{default:[mu]},$$scope:{ctx:v}}}),Yt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[cu]},$$scope:{ctx:v}}}),At=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[du]},$$scope:{ctx:v}}}),bo=new R({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),yo=new k({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L757"}}),To=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L763"}}),Kt=new Z({props:{$$slots:{default:[gu]},$$scope:{ctx:v}}}),en=new J({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[uu]},$$scope:{ctx:v}}}),tn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[fu]},$$scope:{ctx:v}}}),wo=new R({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),Mo=new k({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": InferenceSession | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"generation_config",val:": GenerationConfig | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_seq2seq.py#L1289"}}),vo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": torch.LongTensor = None"},{name:"attention_mask",val:": torch.FloatTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_seq2seq.py#L1295"}}),nn=new Z({props:{$$slots:{default:[_u]},$$scope:{ctx:v}}}),on=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[hu]},$$scope:{ctx:v}}}),an=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[bu]},$$scope:{ctx:v}}}),xo=new R({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),Io=new k({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L975"}}),ko=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L983"}}),sn=new Z({props:{$$slots:{default:[yu]},$$scope:{ctx:v}}}),rn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[Tu]},$$scope:{ctx:v}}}),ln=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[wu]},$$scope:{ctx:v}}}),pn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[Mu]},$$scope:{ctx:v}}}),$o=new R({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),Jo=new k({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1077"}}),jo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1086"}}),mn=new Z({props:{$$slots:{default:[vu]},$$scope:{ctx:v}}}),cn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[xu]},$$scope:{ctx:v}}}),dn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[Iu]},$$scope:{ctx:v}}}),Ro=new R({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),No=new k({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1174"}}),Uo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1182"}}),gn=new Z({props:{$$slots:{default:[ku]},$$scope:{ctx:v}}}),un=new J({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[$u]},$$scope:{ctx:v}}}),Zo=new R({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Co=new k({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L858"}}),So=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L864"}}),fn=new Z({props:{$$slots:{default:[Ju]},$$scope:{ctx:v}}}),_n=new J({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[ju]},$$scope:{ctx:v}}}),hn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[Ru]},$$scope:{ctx:v}}}),Wo=new R({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),Xo=new R({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),Go=new k({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1280"}}),Po=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": torch.Tensor | np.ndarray"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1285"}}),bn=new Z({props:{$$slots:{default:[Nu]},$$scope:{ctx:v}}}),yn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[Uu]},$$scope:{ctx:v}}}),Tn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[Zu]},$$scope:{ctx:v}}}),Oo=new R({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),Fo=new k({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1376"}}),zo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": torch.Tensor | np.ndarray"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1390"}}),wn=new Z({props:{$$slots:{default:[Cu]},$$scope:{ctx:v}}}),Mn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[Su]},$$scope:{ctx:v}}}),vn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[Wu]},$$scope:{ctx:v}}}),Vo=new R({props:{title:"Audio",local:"audio",headingTag:"h2"}}),Do=new R({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),qo=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1497"}}),Eo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"input_features",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1505"}}),xn=new Z({props:{$$slots:{default:[Lu]},$$scope:{ctx:v}}}),In=new J({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[Xu]},$$scope:{ctx:v}}}),kn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[Gu]},$$scope:{ctx:v}}}),Ho=new R({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),Qo=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1787"}}),Yo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1793"}}),$n=new Z({props:{$$slots:{default:[Pu]},$$scope:{ctx:v}}}),Jn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[Ou]},$$scope:{ctx:v}}}),Ao=new R({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),Ko=new k({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1596"}}),ea=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1602"}}),jn=new Z({props:{$$slots:{default:[Fu]},$$scope:{ctx:v}}}),Rn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[zu]},$$scope:{ctx:v}}}),ta=new R({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),na=new k({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_seq2seq.py#L1384"}}),oa=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": torch.FloatTensor | None = None"},{name:"attention_mask",val:": torch.LongTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"cache_position",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_seq2seq.py#L1404"}}),Nn=new Z({props:{$$slots:{default:[Vu]},$$scope:{ctx:v}}}),Un=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[Bu]},$$scope:{ctx:v}}}),Zn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[Du]},$$scope:{ctx:v}}}),aa=new R({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),sa=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1699"}}),ia=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1705"}}),Cn=new Z({props:{$$slots:{default:[qu]},$$scope:{ctx:v}}}),Sn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[Eu]},$$scope:{ctx:v}}}),ra=new R({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),pa=new R({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),ma=new k({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": InferenceSession | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"generation_config",val:": GenerationConfig | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_seq2seq.py#L1516"}}),ca=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": torch.FloatTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_seq2seq.py#L1524"}}),Wn=new Z({props:{$$slots:{default:[Hu]},$$scope:{ctx:v}}}),Ln=new J({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[Qu]},$$scope:{ctx:v}}}),Xn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[Yu]},$$scope:{ctx:v}}}),da=new R({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),ga=new k({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": InferenceSession | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"generation_config",val:": GenerationConfig | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_seq2seq.py#L1610"}}),ua=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": torch.FloatTensor | None = None"},{name:"attention_mask",val:": torch.LongTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"decoder_attention_mask",val:": torch.BoolTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"past_key_values",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_seq2seq.py#L1619"}}),Gn=new Z({props:{$$slots:{default:[Au]},$$scope:{ctx:v}}}),Pn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[Ku]},$$scope:{ctx:v}}}),fa=new R({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),ha=new R({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),ba=new k({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1968"}}),ya=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**model_inputs",val:": torch.Tensor | np.ndarray"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L1971"}}),On=new Z({props:{$$slots:{default:[ef]},$$scope:{ctx:v}}}),Fn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[tf]},$$scope:{ctx:v}}}),zn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[nf]},$$scope:{ctx:v}}}),Ta=new R({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),wa=new k({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L624"}}),Ma=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"position_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"pixel_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"visual_embeds",val:": torch.Tensor | np.ndarray | None = None"},{name:"visual_attention_mask",val:": torch.Tensor | np.ndarray | None = None"},{name:"visual_token_type_ids",val:": torch.Tensor | np.ndarray | None = None"},{name:"input_features",val:": torch.Tensor | np.ndarray | None = None"},{name:"input_values",val:": torch.Tensor | np.ndarray | None = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_ort.py#L630"}}),Vn=new Z({props:{$$slots:{default:[of]},$$scope:{ctx:v}}}),Bn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[af]},$$scope:{ctx:v}}}),Dn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[sf]},$$scope:{ctx:v}}}),va=new R({props:{title:"Diffusion Pipelines",local:"diffusion-pipelines",headingTag:"h2"}}),xa=new R({props:{title:"ORTDiffusionPipeline",local:"optimum.onnxruntime.ORTDiffusionPipeline",headingTag:"h4"}}),Ia=new k({props:{name:"class optimum.onnxruntime.ORTDiffusionPipeline",anchor:"optimum.onnxruntime.ORTDiffusionPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L87"}}),ka=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),$a=new R({props:{title:"ORTStableDiffusionPipeline",local:"optimum.onnxruntime.ORTStableDiffusionPipeline",headingTag:"h4"}}),Ja=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L846"}}),ja=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <code>~schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L778",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),En=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.example",$$slots:{default:[rf]},$$scope:{ctx:v}}}),Ra=new R({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Na=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L855"}}),Ua=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": typing.Optional[int] = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": typing.Optional[float] = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": typing.Optional[float] = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <code>~schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Hn=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[lf]},$$scope:{ctx:v}}}),Za=new R({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Ca=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L864"}}),Sa=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": Tensor = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be inpainted (which parts of the image to
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>). For both numpy array and pytorch
tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list or tensors, the
expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a list of arrays, the
expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image latents as <code>image</code>, but
if passing latents directly it is not encoded again.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <code>~schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py#L880",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Qn=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.example",$$slots:{default:[pf]},$$scope:{ctx:v}}}),Wa=new R({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),La=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L873"}}),Xa=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl.py#L836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Yn=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.example",$$slots:{default:[mf]},$$scope:{ctx:v}}}),Ga=new R({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),Pa=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L894"}}),Oa=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_start",val:": typing.Optional[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.Tensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>. Note that in the case of
<code>denoising_start</code> being declared as an integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_start"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_img2img.py#L986",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
\`tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),An=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.example",$$slots:{default:[cf]},$$scope:{ctx:v}}}),Fa=new R({props:{title:"ORTStableDiffusionXLInpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline",headingTag:"h4"}}),za=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L930"}}),Va=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": Tensor = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.9999"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_start",val:": typing.Optional[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be
repainted, while black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted
to a single channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L)
instead of 3, so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.
Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9999) &#x2014;
Conceptually, indicates how much to transform the masked portion of the reference <code>image</code>. Must be
between 0 and 1. <code>image</code> will be used as a starting point, adding more noise to it the larger the
<code>strength</code>. The number of denoising steps depends on the amount of noise initially added. When
<code>strength</code> is 1, added noise will be maximum and the denoising process will run for the full number of
iterations specified in <code>num_inference_steps</code>. A value of 1, therefore, essentially ignores the masked
portion of the reference <code>image</code>. Note that in the case of <code>denoising_start</code> being declared as an
integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_start"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_inpaint.py#L1091",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple. </code>tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Kn=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline.__call__.example",$$slots:{default:[df]},$$scope:{ctx:v}}}),Ba=new R({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),Da=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L894"}}),qa=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_start",val:": typing.Optional[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.Tensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>. Note that in the case of
<code>denoising_start</code> being declared as an integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_start"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl#refine-image-quality" rel="nofollow"><strong>Refine Image
Quality</strong></a>.`,name:"denoising_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_img2img.py#L986",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
\`tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),eo=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.example",$$slots:{default:[gf]},$$scope:{ctx:v}}}),Ea=new R({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),Ha=new k({props:{name:"class optimum.onnxruntime.ORTLatentConsistencyModelPipeline",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L966"}}),Qa=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 4"},{name:"original_inference_steps",val:": int = None"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 8.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.original_inference_steps",description:`<strong>original_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The original number of inference steps use to generate a linearly-spaced timestep schedule, from which
we will draw <code>num_inference_steps</code> evenly spaced timesteps from as our final timestep schedule,
following the Skipping-Step method in the paper (see Section 4.3). If not set this will default to the
scheduler&#x2019;s <code>original_inference_steps</code> attribute.`,name:"original_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps on the original LCM training/distillation timestep schedule are used. Must be in descending
order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.
Note that the original latent consistency models paper uses a different CFG formulation where the
guidance scales are decreased by 1 (so in the paper formulation CFG is enabled when <code>guidance_scale &gt; 0</code>).`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/latent_consistency_models/pipeline_latent_consistency_text2img.py#L640",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),to=new J({props:{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.example",$$slots:{default:[uf]},$$scope:{ctx:v}}}),Ya=new R({props:{title:"ORTLatentConsistencyModelImg2ImgPipeline",local:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline",headingTag:"h4"}}),Aa=new k({props:{name:"class optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L975"}}),Ka=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 4"},{name:"strength",val:": float = 0.8"},{name:"original_inference_steps",val:": int = None"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 8.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.original_inference_steps",description:`<strong>original_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The original number of inference steps use to generate a linearly-spaced timestep schedule, from which
we will draw <code>num_inference_steps</code> evenly spaced timesteps from as our final timestep schedule,
following the Skipping-Step method in the paper (see Section 4.3). If not set this will default to the
scheduler&#x2019;s <code>original_inference_steps</code> attribute.`,name:"original_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps on the original LCM training/distillation timestep schedule are used. Must be in descending
order.`,name:"timesteps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.
Note that the original latent consistency models paper uses a different CFG formulation where the
guidance scales are decreased by 1 (so in the paper formulation CFG is enabled when <code>guidance_scale &gt; 0</code>).`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/latent_consistency_models/pipeline_latent_consistency_img2img.py#L709",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),no=new J({props:{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline.__call__.example",$$slots:{default:[ff]},$$scope:{ctx:v}}}),es=new R({props:{title:"ORTStableDiffusion3Pipeline",local:"optimum.onnxruntime.ORTStableDiffusion3Pipeline",headingTag:"h4"}}),ts=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusion3Pipeline",anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L996"}}),ns=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"skip_guidance_layers",val:": typing.List[int] = None"},{name:"skip_layer_guidance_scale",val:": float = 2.8"},{name:"skip_layer_guidance_stop",val:": float = 0.2"},{name:"skip_layer_guidance_start",val:": float = 0.01"},{name:"mu",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.skip_guidance_layers",description:`<strong>skip_guidance_layers</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of integers that specify layers to skip during guidance. If not provided, all layers will be
used for guidance. If provided, the guidance will only be applied to the layers specified in the list.
Recommended value by StabiltyAI for Stable Diffusion 3.5 Medium is [7, 8, 9].`,name:"skip_guidance_layers"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.skip_layer_guidance_scale",description:`<strong>skip_layer_guidance_scale</strong> (<code>int</code>, <em>optional</em>) &#x2014; The scale of the guidance for the layers specified in
<code>skip_guidance_layers</code>. The guidance will be applied to the layers specified in <code>skip_guidance_layers</code>
with a scale of <code>skip_layer_guidance_scale</code>. The guidance will be applied to the rest of the layers
with a scale of <code>1</code>.`,name:"skip_layer_guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.skip_layer_guidance_stop",description:`<strong>skip_layer_guidance_stop</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will stop. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> until the fraction specified in <code>skip_layer_guidance_stop</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.2.`,name:"skip_layer_guidance_stop"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.skip_layer_guidance_start",description:`<strong>skip_layer_guidance_start</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will start. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> from the fraction specified in <code>skip_layer_guidance_start</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.01.`,name:"skip_layer_guidance_start"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.mu",description:"<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014; <code>mu</code> value used for <code>dynamic_shifting</code>.",name:"mu"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L772",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),oo=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusion3Pipeline.__call__.example",$$slots:{default:[_f]},$$scope:{ctx:v}}}),os=new R({props:{title:"ORTStableDiffusion3Img2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline",headingTag:"h4"}}),as=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L1004"}}),ss=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"mu",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.mu",description:"<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014; <code>mu</code> value used for <code>dynamic_shifting</code>.",name:"mu"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3_img2img.py#L829",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),ao=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline.__call__.example",$$slots:{default:[hf]},$$scope:{ctx:v}}}),is=new R({props:{title:"ORTStableDiffusion3InpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline",headingTag:"h4"}}),rs=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L1023"}}),ls=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": int = None"},{name:"width",val:": int = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"mu",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.mu",description:"<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014; <code>mu</code> value used for <code>dynamic_shifting</code>.",name:"mu"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3_inpaint.py#L921",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),so=new J({props:{anchor:"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline.__call__.example",$$slots:{default:[bf]},$$scope:{ctx:v}}}),ps=new R({props:{title:"ORTFluxPipeline",local:"optimum.onnxruntime.ORTFluxPipeline",headingTag:"h4"}}),ms=new k({props:{name:"class optimum.onnxruntime.ORTFluxPipeline",anchor:"optimum.onnxruntime.ORTFluxPipeline",parameters:[{name:"unet_session",val:": InferenceSession | None = None"},{name:"transformer_session",val:": InferenceSession | None = None"},{name:"vae_decoder_session",val:": InferenceSession | None = None"},{name:"vae_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_session",val:": InferenceSession | None = None"},{name:"text_encoder_2_session",val:": InferenceSession | None = None"},{name:"text_encoder_3_session",val:": InferenceSession | None = None"},{name:"scheduler",val:": SchedulerMixin | None = None"},{name:"tokenizer",val:": CLIPTokenizer | None = None"},{name:"tokenizer_2",val:": CLIPTokenizer | None = None"},{name:"tokenizer_3",val:": CLIPTokenizer | None = None"},{name:"feature_extractor",val:": CLIPFeatureExtractor | None = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"add_watermarker",val:": bool | None = None"},{name:"use_io_binding",val:": bool | None = None"},{name:"model_save_dir",val:": str | Path | TemporaryDirectory | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/optimum/onnxruntime/modeling_diffusion.py#L1031"}}),cs=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"true_cfg_scale",val:": float = 1.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 3.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"negative_ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead.`,name:"prompt_2"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
True classifier-free guidance (guidance scale) is enabled when <code>true_cfg_scale</code> &gt; 1 and
<code>negative_prompt</code> is provided.`,name:"true_cfg_scale"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
Embedded guiddance scale is enabled by setting <code>guidance_scale</code> &gt; 1. Higher <code>guidance_scale</code> encourages
a model to generate images more aligned with <code>prompt</code> at the expense of lower image quality.</p>
<p>Guidance-distilled models approximates true classifer-free guidance for <code>guidance_scale</code> &gt; 1. Refer to
the <a href="https://huggingface.co/papers/2210.03142" rel="nofollow">paper</a> to learn more.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_ip_adapter_image",description:`<strong>negative_ip_adapter_image</strong> &#x2014;
(<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_ip_adapter_image"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_ip_adapter_image_embeds",description:`<strong>negative_ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"negative_ip_adapter_image_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_pr_41/diffusers/pipelines/flux/pipeline_flux.py#L627",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),io=new J({props:{anchor:"optimum.onnxruntime.ORTFluxPipeline.__call__.example",$$slots:{default:[yf]},$$scope:{ctx:v}}}),{c(){n=m("meta"),T=i(),a=m("p"),o=i(),u(d.$$.fragment),t=i(),u(w.$$.fragment),lr=i(),ro=m("p"),ro.textContent=cd,pr=i(),u(lo.$$.fragment),mr=i(),N=m("div"),u(po.$$.fragment),Cl=i(),fs=m("p"),fs.textContent=dd,Sl=i(),_s=m("p"),_s.innerHTML=gd,Wl=i(),hs=m("p"),hs.textContent=ud,Ll=i(),bs=m("ul"),bs.innerHTML=fd,Xl=i(),Ht=m("div"),u(mo.$$.fragment),Gl=i(),ys=m("p"),ys.innerHTML=_d,Pl=i(),U=m("div"),u(co.$$.fragment),Ol=i(),Ts=m("p"),Ts.textContent=hd,Fl=i(),ws=m("p"),ws.innerHTML=bd,zl=i(),Ms=m("blockquote"),Ms.innerHTML=yd,Vl=i(),vs=m("p"),vs.innerHTML=Td,Bl=i(),xs=m("blockquote"),xs.innerHTML=wd,Dl=i(),Is=m("p"),Is.innerHTML=Md,cr=i(),u(go.$$.fragment),dr=i(),uo=m("p"),uo.textContent=vd,gr=i(),u(fo.$$.fragment),ur=i(),ee=m("div"),u(_o.$$.fragment),ql=i(),ks=m("p"),ks.innerHTML=xd,El=i(),$s=m("p"),$s.innerHTML=Id,Hl=i(),F=m("div"),u(ho.$$.fragment),Ql=i(),Js=m("p"),Js.innerHTML=kd,Yl=i(),u(Qt.$$.fragment),Al=i(),u(Yt.$$.fragment),Kl=i(),u(At.$$.fragment),fr=i(),u(bo.$$.fragment),_r=i(),te=m("div"),u(yo.$$.fragment),ep=i(),js=m("p"),js.innerHTML=$d,tp=i(),Rs=m("p"),Rs.innerHTML=Jd,np=i(),z=m("div"),u(To.$$.fragment),op=i(),Ns=m("p"),Ns.innerHTML=jd,ap=i(),u(Kt.$$.fragment),sp=i(),u(en.$$.fragment),ip=i(),u(tn.$$.fragment),hr=i(),u(wo.$$.fragment),br=i(),ne=m("div"),u(Mo.$$.fragment),rp=i(),Us=m("p"),Us.innerHTML=Rd,lp=i(),Zs=m("p"),Zs.innerHTML=Nd,pp=i(),V=m("div"),u(vo.$$.fragment),mp=i(),Cs=m("p"),Cs.innerHTML=Ud,cp=i(),u(nn.$$.fragment),dp=i(),u(on.$$.fragment),gp=i(),u(an.$$.fragment),yr=i(),u(xo.$$.fragment),Tr=i(),L=m("div"),u(Io.$$.fragment),up=i(),Ss=m("p"),Ss.textContent=Zd,fp=i(),Ws=m("p"),Ws.innerHTML=Cd,_p=i(),Ls=m("p"),Ls.innerHTML=Sd,hp=i(),W=m("div"),u(ko.$$.fragment),bp=i(),Xs=m("p"),Xs.innerHTML=Wd,yp=i(),u(sn.$$.fragment),Tp=i(),u(rn.$$.fragment),wp=i(),u(ln.$$.fragment),Mp=i(),u(pn.$$.fragment),wr=i(),u($o.$$.fragment),Mr=i(),X=m("div"),u(Jo.$$.fragment),vp=i(),Gs=m("p"),Gs.textContent=Ld,xp=i(),Ps=m("p"),Ps.innerHTML=Xd,Ip=i(),Os=m("p"),Os.innerHTML=Gd,kp=i(),B=m("div"),u(jo.$$.fragment),$p=i(),Fs=m("p"),Fs.innerHTML=Pd,Jp=i(),u(mn.$$.fragment),jp=i(),u(cn.$$.fragment),Rp=i(),u(dn.$$.fragment),vr=i(),u(Ro.$$.fragment),xr=i(),G=m("div"),u(No.$$.fragment),Np=i(),zs=m("p"),zs.textContent=Od,Up=i(),Vs=m("p"),Vs.innerHTML=Fd,Zp=i(),Bs=m("p"),Bs.innerHTML=zd,Cp=i(),Re=m("div"),u(Uo.$$.fragment),Sp=i(),Ds=m("p"),Ds.innerHTML=Vd,Wp=i(),u(gn.$$.fragment),Lp=i(),u(un.$$.fragment),Ir=i(),u(Zo.$$.fragment),kr=i(),oe=m("div"),u(Co.$$.fragment),Xp=i(),qs=m("p"),qs.innerHTML=Bd,Gp=i(),Es=m("p"),Es.innerHTML=Dd,Pp=i(),D=m("div"),u(So.$$.fragment),Op=i(),Hs=m("p"),Hs.innerHTML=qd,Fp=i(),u(fn.$$.fragment),zp=i(),u(_n.$$.fragment),Vp=i(),u(hn.$$.fragment),$r=i(),u(Wo.$$.fragment),Jr=i(),Lo=m("p"),Lo.textContent=Ed,jr=i(),u(Xo.$$.fragment),Rr=i(),ae=m("div"),u(Go.$$.fragment),Bp=i(),Qs=m("p"),Qs.innerHTML=Hd,Dp=i(),Ys=m("p"),Ys.innerHTML=Qd,qp=i(),q=m("div"),u(Po.$$.fragment),Ep=i(),As=m("p"),As.innerHTML=Yd,Hp=i(),u(bn.$$.fragment),Qp=i(),u(yn.$$.fragment),Yp=i(),u(Tn.$$.fragment),Nr=i(),u(Oo.$$.fragment),Ur=i(),se=m("div"),u(Fo.$$.fragment),Ap=i(),Ks=m("p"),Ks.innerHTML=Ad,Kp=i(),ei=m("p"),ei.innerHTML=Kd,em=i(),E=m("div"),u(zo.$$.fragment),tm=i(),ti=m("p"),ti.innerHTML=eg,nm=i(),u(wn.$$.fragment),om=i(),u(Mn.$$.fragment),am=i(),u(vn.$$.fragment),Zr=i(),u(Vo.$$.fragment),Cr=i(),Bo=m("p"),Bo.textContent=tg,Sr=i(),u(Do.$$.fragment),Wr=i(),P=m("div"),u(qo.$$.fragment),sm=i(),ni=m("p"),ni.textContent=ng,im=i(),oi=m("p"),oi.innerHTML=og,rm=i(),ai=m("p"),ai.innerHTML=ag,lm=i(),H=m("div"),u(Eo.$$.fragment),pm=i(),si=m("p"),si.innerHTML=sg,mm=i(),u(xn.$$.fragment),cm=i(),u(In.$$.fragment),dm=i(),u(kn.$$.fragment),Lr=i(),u(Ho.$$.fragment),Xr=i(),ie=m("div"),u(Qo.$$.fragment),gm=i(),ii=m("p"),ii.innerHTML=ig,um=i(),ri=m("p"),ri.innerHTML=rg,fm=i(),Ne=m("div"),u(Yo.$$.fragment),_m=i(),li=m("p"),li.innerHTML=lg,hm=i(),u($n.$$.fragment),bm=i(),u(Jn.$$.fragment),Gr=i(),u(Ao.$$.fragment),Pr=i(),re=m("div"),u(Ko.$$.fragment),ym=i(),pi=m("p"),pi.innerHTML=pg,Tm=i(),mi=m("p"),mi.innerHTML=mg,wm=i(),Ue=m("div"),u(ea.$$.fragment),Mm=i(),ci=m("p"),ci.innerHTML=cg,vm=i(),u(jn.$$.fragment),xm=i(),u(Rn.$$.fragment),Or=i(),u(ta.$$.fragment),Fr=i(),le=m("div"),u(na.$$.fragment),Im=i(),di=m("p"),di.innerHTML=dg,km=i(),gi=m("p"),gi.innerHTML=gg,$m=i(),Q=m("div"),u(oa.$$.fragment),Jm=i(),ui=m("p"),ui.innerHTML=ug,jm=i(),u(Nn.$$.fragment),Rm=i(),u(Un.$$.fragment),Nm=i(),u(Zn.$$.fragment),zr=i(),u(aa.$$.fragment),Vr=i(),pe=m("div"),u(sa.$$.fragment),Um=i(),fi=m("p"),fi.innerHTML=fg,Zm=i(),_i=m("p"),_i.innerHTML=_g,Cm=i(),Ze=m("div"),u(ia.$$.fragment),Sm=i(),hi=m("p"),hi.innerHTML=hg,Wm=i(),u(Cn.$$.fragment),Lm=i(),u(Sn.$$.fragment),Br=i(),u(ra.$$.fragment),Dr=i(),la=m("p"),la.textContent=bg,qr=i(),u(pa.$$.fragment),Er=i(),me=m("div"),u(ma.$$.fragment),Xm=i(),bi=m("p"),bi.innerHTML=yg,Gm=i(),yi=m("p"),yi.innerHTML=Tg,Pm=i(),Y=m("div"),u(ca.$$.fragment),Om=i(),Ti=m("p"),Ti.innerHTML=wg,Fm=i(),u(Wn.$$.fragment),zm=i(),u(Ln.$$.fragment),Vm=i(),u(Xn.$$.fragment),Hr=i(),u(da.$$.fragment),Qr=i(),ce=m("div"),u(ga.$$.fragment),Bm=i(),wi=m("p"),wi.innerHTML=Mg,Dm=i(),Mi=m("p"),Mi.innerHTML=vg,qm=i(),Ce=m("div"),u(ua.$$.fragment),Em=i(),vi=m("p"),vi.innerHTML=xg,Hm=i(),u(Gn.$$.fragment),Qm=i(),u(Pn.$$.fragment),Yr=i(),u(fa.$$.fragment),Ar=i(),_a=m("p"),_a.textContent=Ig,Kr=i(),u(ha.$$.fragment),el=i(),de=m("div"),u(ba.$$.fragment),Ym=i(),xi=m("p"),xi.innerHTML=kg,Am=i(),Ii=m("p"),Ii.innerHTML=$g,Km=i(),A=m("div"),u(ya.$$.fragment),ec=i(),ki=m("p"),ki.innerHTML=Jg,tc=i(),u(On.$$.fragment),nc=i(),u(Fn.$$.fragment),oc=i(),u(zn.$$.fragment),tl=i(),u(Ta.$$.fragment),nl=i(),ge=m("div"),u(wa.$$.fragment),ac=i(),$i=m("p"),$i.innerHTML=jg,sc=i(),Ji=m("p"),Ji.innerHTML=Rg,ic=i(),K=m("div"),u(Ma.$$.fragment),rc=i(),ji=m("p"),ji.innerHTML=Ng,lc=i(),u(Vn.$$.fragment),pc=i(),u(Bn.$$.fragment),mc=i(),u(Dn.$$.fragment),ol=i(),u(va.$$.fragment),al=i(),u(xa.$$.fragment),sl=i(),kt=m("div"),u(Ia.$$.fragment),cc=i(),qn=m("div"),u(ka.$$.fragment),dc=i(),Ri=m("p"),Ri.textContent=Ug,il=i(),u($a.$$.fragment),rl=i(),Se=m("div"),u(Ja.$$.fragment),gc=i(),Ni=m("p"),Ni.innerHTML=Zg,uc=i(),gt=m("div"),u(ja.$$.fragment),fc=i(),Ui=m("p"),Ui.textContent=Cg,_c=i(),u(En.$$.fragment),ll=i(),u(Ra.$$.fragment),pl=i(),We=m("div"),u(Na.$$.fragment),hc=i(),Zi=m("p"),Zi.innerHTML=Sg,bc=i(),ut=m("div"),u(Ua.$$.fragment),yc=i(),Ci=m("p"),Ci.textContent=Wg,Tc=i(),u(Hn.$$.fragment),ml=i(),u(Za.$$.fragment),cl=i(),Le=m("div"),u(Ca.$$.fragment),wc=i(),Si=m("p"),Si.innerHTML=Lg,Mc=i(),ft=m("div"),u(Sa.$$.fragment),vc=i(),Wi=m("p"),Wi.textContent=Xg,xc=i(),u(Qn.$$.fragment),dl=i(),u(Wa.$$.fragment),gl=i(),Xe=m("div"),u(La.$$.fragment),Ic=i(),Li=m("p"),Li.innerHTML=Gg,kc=i(),_t=m("div"),u(Xa.$$.fragment),$c=i(),Xi=m("p"),Xi.textContent=Pg,Jc=i(),u(Yn.$$.fragment),ul=i(),u(Ga.$$.fragment),fl=i(),Ge=m("div"),u(Pa.$$.fragment),jc=i(),Gi=m("p"),Gi.innerHTML=Og,Rc=i(),ht=m("div"),u(Oa.$$.fragment),Nc=i(),Pi=m("p"),Pi.textContent=Fg,Uc=i(),u(An.$$.fragment),_l=i(),u(Fa.$$.fragment),hl=i(),Pe=m("div"),u(za.$$.fragment),Zc=i(),Oi=m("p"),Oi.innerHTML=zg,Cc=i(),bt=m("div"),u(Va.$$.fragment),Sc=i(),Fi=m("p"),Fi.textContent=Vg,Wc=i(),u(Kn.$$.fragment),bl=i(),u(Ba.$$.fragment),yl=i(),Oe=m("div"),u(Da.$$.fragment),Lc=i(),zi=m("p"),zi.innerHTML=Bg,Xc=i(),yt=m("div"),u(qa.$$.fragment),Gc=i(),Vi=m("p"),Vi.textContent=Dg,Pc=i(),u(eo.$$.fragment),Tl=i(),u(Ea.$$.fragment),wl=i(),Fe=m("div"),u(Ha.$$.fragment),Oc=i(),Bi=m("p"),Bi.innerHTML=qg,Fc=i(),Tt=m("div"),u(Qa.$$.fragment),zc=i(),Di=m("p"),Di.textContent=Eg,Vc=i(),u(to.$$.fragment),Ml=i(),u(Ya.$$.fragment),vl=i(),ze=m("div"),u(Aa.$$.fragment),Bc=i(),qi=m("p"),qi.innerHTML=Hg,Dc=i(),wt=m("div"),u(Ka.$$.fragment),qc=i(),Ei=m("p"),Ei.textContent=Qg,Ec=i(),u(no.$$.fragment),xl=i(),u(es.$$.fragment),Il=i(),Ve=m("div"),u(ts.$$.fragment),Hc=i(),Hi=m("p"),Hi.innerHTML=Yg,Qc=i(),Mt=m("div"),u(ns.$$.fragment),Yc=i(),Qi=m("p"),Qi.textContent=Ag,Ac=i(),u(oo.$$.fragment),kl=i(),u(os.$$.fragment),$l=i(),Be=m("div"),u(as.$$.fragment),Kc=i(),Yi=m("p"),Yi.innerHTML=Kg,ed=i(),vt=m("div"),u(ss.$$.fragment),td=i(),Ai=m("p"),Ai.textContent=eu,nd=i(),u(ao.$$.fragment),Jl=i(),u(is.$$.fragment),jl=i(),De=m("div"),u(rs.$$.fragment),od=i(),Ki=m("p"),Ki.innerHTML=tu,ad=i(),xt=m("div"),u(ls.$$.fragment),sd=i(),er=m("p"),er.textContent=nu,id=i(),u(so.$$.fragment),Rl=i(),u(ps.$$.fragment),Nl=i(),qe=m("div"),u(ms.$$.fragment),rd=i(),tr=m("p"),tr.innerHTML=ou,ld=i(),It=m("div"),u(cs.$$.fragment),pd=i(),nr=m("p"),nr.textContent=au,md=i(),u(io.$$.fragment),Ul=i(),rr=m("p"),this.h()},l(e){const p=pu("svelte-u9bgzb",document.head);n=c(p,"META",{name:!0,content:!0}),p.forEach(l),T=r(e),a=c(e,"P",{}),x(a).forEach(l),o=r(e),f(d.$$.fragment,e),t=r(e),f(w.$$.fragment,e),lr=r(e),ro=c(e,"P",{"data-svelte-h":!0}),M(ro)!=="svelte-uyecg"&&(ro.textContent=cd),pr=r(e),f(lo.$$.fragment,e),mr=r(e),N=c(e,"DIV",{class:!0});var C=x(N);f(po.$$.fragment,C),Cl=r(C),fs=c(C,"P",{"data-svelte-h":!0}),M(fs)!=="svelte-12yueui"&&(fs.textContent=dd),Sl=r(C),_s=c(C,"P",{"data-svelte-h":!0}),M(_s)!=="svelte-zarm0s"&&(_s.innerHTML=gd),Wl=r(C),hs=c(C,"P",{"data-svelte-h":!0}),M(hs)!=="svelte-wz8va1"&&(hs.textContent=ud),Ll=r(C),bs=c(C,"UL",{"data-svelte-h":!0}),M(bs)!=="svelte-qpxha0"&&(bs.innerHTML=fd),Xl=r(C),Ht=c(C,"DIV",{class:!0});var ds=x(Ht);f(mo.$$.fragment,ds),Gl=r(ds),ys=c(ds,"P",{"data-svelte-h":!0}),M(ys)!=="svelte-1r2xt0l"&&(ys.innerHTML=_d),ds.forEach(l),Pl=r(C),U=c(C,"DIV",{class:!0});var S=x(U);f(co.$$.fragment,S),Ol=r(S),Ts=c(S,"P",{"data-svelte-h":!0}),M(Ts)!=="svelte-18vxhwp"&&(Ts.textContent=hd),Fl=r(S),ws=c(S,"P",{"data-svelte-h":!0}),M(ws)!=="svelte-1mrbn81"&&(ws.innerHTML=bd),zl=r(S),Ms=c(S,"BLOCKQUOTE",{"data-svelte-h":!0}),M(Ms)!=="svelte-1uv5y3f"&&(Ms.innerHTML=yd),Vl=r(S),vs=c(S,"P",{"data-svelte-h":!0}),M(vs)!=="svelte-vzi3zk"&&(vs.innerHTML=Td),Bl=r(S),xs=c(S,"BLOCKQUOTE",{"data-svelte-h":!0}),M(xs)!=="svelte-xq6lc5"&&(xs.innerHTML=wd),Dl=r(S),Is=c(S,"P",{"data-svelte-h":!0}),M(Is)!=="svelte-111jrpf"&&(Is.innerHTML=Md),S.forEach(l),C.forEach(l),cr=r(e),f(go.$$.fragment,e),dr=r(e),uo=c(e,"P",{"data-svelte-h":!0}),M(uo)!=="svelte-1tlroh"&&(uo.textContent=vd),gr=r(e),f(fo.$$.fragment,e),ur=r(e),ee=c(e,"DIV",{class:!0});var Ee=x(ee);f(_o.$$.fragment,Ee),ql=r(Ee),ks=c(Ee,"P",{"data-svelte-h":!0}),M(ks)!=="svelte-lnbw04"&&(ks.innerHTML=xd),El=r(Ee),$s=c(Ee,"P",{"data-svelte-h":!0}),M($s)!=="svelte-x6f2b0"&&($s.innerHTML=Id),Hl=r(Ee),F=c(Ee,"DIV",{class:!0});var ue=x(F);f(ho.$$.fragment,ue),Ql=r(ue),Js=c(ue,"P",{"data-svelte-h":!0}),M(Js)!=="svelte-1ox9av6"&&(Js.innerHTML=kd),Yl=r(ue),f(Qt.$$.fragment,ue),Al=r(ue),f(Yt.$$.fragment,ue),Kl=r(ue),f(At.$$.fragment,ue),ue.forEach(l),Ee.forEach(l),fr=r(e),f(bo.$$.fragment,e),_r=r(e),te=c(e,"DIV",{class:!0});var He=x(te);f(yo.$$.fragment,He),ep=r(He),js=c(He,"P",{"data-svelte-h":!0}),M(js)!=="svelte-2s3jx3"&&(js.innerHTML=$d),tp=r(He),Rs=c(He,"P",{"data-svelte-h":!0}),M(Rs)!=="svelte-x6f2b0"&&(Rs.innerHTML=Jd),np=r(He),z=c(He,"DIV",{class:!0});var fe=x(z);f(To.$$.fragment,fe),op=r(fe),Ns=c(fe,"P",{"data-svelte-h":!0}),M(Ns)!=="svelte-1xqof9m"&&(Ns.innerHTML=jd),ap=r(fe),f(Kt.$$.fragment,fe),sp=r(fe),f(en.$$.fragment,fe),ip=r(fe),f(tn.$$.fragment,fe),fe.forEach(l),He.forEach(l),hr=r(e),f(wo.$$.fragment,e),br=r(e),ne=c(e,"DIV",{class:!0});var Qe=x(ne);f(Mo.$$.fragment,Qe),rp=r(Qe),Us=c(Qe,"P",{"data-svelte-h":!0}),M(Us)!=="svelte-1r520uu"&&(Us.innerHTML=Rd),lp=r(Qe),Zs=c(Qe,"P",{"data-svelte-h":!0}),M(Zs)!=="svelte-10uuk2l"&&(Zs.innerHTML=Nd),pp=r(Qe),V=c(Qe,"DIV",{class:!0});var _e=x(V);f(vo.$$.fragment,_e),mp=r(_e),Cs=c(_e,"P",{"data-svelte-h":!0}),M(Cs)!=="svelte-n65k7h"&&(Cs.innerHTML=Ud),cp=r(_e),f(nn.$$.fragment,_e),dp=r(_e),f(on.$$.fragment,_e),gp=r(_e),f(an.$$.fragment,_e),_e.forEach(l),Qe.forEach(l),yr=r(e),f(xo.$$.fragment,e),Tr=r(e),L=c(e,"DIV",{class:!0});var he=x(L);f(Io.$$.fragment,he),up=r(he),Ss=c(he,"P",{"data-svelte-h":!0}),M(Ss)!=="svelte-1fcejq5"&&(Ss.textContent=Zd),fp=r(he),Ws=c(he,"P",{"data-svelte-h":!0}),M(Ws)!=="svelte-1bzil0z"&&(Ws.innerHTML=Cd),_p=r(he),Ls=c(he,"P",{"data-svelte-h":!0}),M(Ls)!=="svelte-x6f2b0"&&(Ls.innerHTML=Sd),hp=r(he),W=c(he,"DIV",{class:!0});var O=x(W);f(ko.$$.fragment,O),bp=r(O),Xs=c(O,"P",{"data-svelte-h":!0}),M(Xs)!=="svelte-1plx9t"&&(Xs.innerHTML=Wd),yp=r(O),f(sn.$$.fragment,O),Tp=r(O),f(rn.$$.fragment,O),wp=r(O),f(ln.$$.fragment,O),Mp=r(O),f(pn.$$.fragment,O),O.forEach(l),he.forEach(l),wr=r(e),f($o.$$.fragment,e),Mr=r(e),X=c(e,"DIV",{class:!0});var be=x(X);f(Jo.$$.fragment,be),vp=r(be),Gs=c(be,"P",{"data-svelte-h":!0}),M(Gs)!=="svelte-1uwjkkt"&&(Gs.textContent=Ld),xp=r(be),Ps=c(be,"P",{"data-svelte-h":!0}),M(Ps)!=="svelte-1bzil0z"&&(Ps.innerHTML=Xd),Ip=r(be),Os=c(be,"P",{"data-svelte-h":!0}),M(Os)!=="svelte-x6f2b0"&&(Os.innerHTML=Gd),kp=r(be),B=c(be,"DIV",{class:!0});var ye=x(B);f(jo.$$.fragment,ye),$p=r(ye),Fs=c(ye,"P",{"data-svelte-h":!0}),M(Fs)!=="svelte-xk2xch"&&(Fs.innerHTML=Pd),Jp=r(ye),f(mn.$$.fragment,ye),jp=r(ye),f(cn.$$.fragment,ye),Rp=r(ye),f(dn.$$.fragment,ye),ye.forEach(l),be.forEach(l),vr=r(e),f(Ro.$$.fragment,e),xr=r(e),G=c(e,"DIV",{class:!0});var Te=x(G);f(No.$$.fragment,Te),Np=r(Te),zs=c(Te,"P",{"data-svelte-h":!0}),M(zs)!=="svelte-dcahwi"&&(zs.textContent=Od),Up=r(Te),Vs=c(Te,"P",{"data-svelte-h":!0}),M(Vs)!=="svelte-1bzil0z"&&(Vs.innerHTML=Fd),Zp=r(Te),Bs=c(Te,"P",{"data-svelte-h":!0}),M(Bs)!=="svelte-x6f2b0"&&(Bs.innerHTML=zd),Cp=r(Te),Re=c(Te,"DIV",{class:!0});var Ye=x(Re);f(Uo.$$.fragment,Ye),Sp=r(Ye),Ds=c(Ye,"P",{"data-svelte-h":!0}),M(Ds)!=="svelte-qesv8n"&&(Ds.innerHTML=Vd),Wp=r(Ye),f(gn.$$.fragment,Ye),Lp=r(Ye),f(un.$$.fragment,Ye),Ye.forEach(l),Te.forEach(l),Ir=r(e),f(Zo.$$.fragment,e),kr=r(e),oe=c(e,"DIV",{class:!0});var Ae=x(oe);f(Co.$$.fragment,Ae),Xp=r(Ae),qs=c(Ae,"P",{"data-svelte-h":!0}),M(qs)!=="svelte-1qkscfo"&&(qs.innerHTML=Bd),Gp=r(Ae),Es=c(Ae,"P",{"data-svelte-h":!0}),M(Es)!=="svelte-x6f2b0"&&(Es.innerHTML=Dd),Pp=r(Ae),D=c(Ae,"DIV",{class:!0});var we=x(D);f(So.$$.fragment,we),Op=r(we),Hs=c(we,"P",{"data-svelte-h":!0}),M(Hs)!=="svelte-1dng7rw"&&(Hs.innerHTML=qd),Fp=r(we),f(fn.$$.fragment,we),zp=r(we),f(_n.$$.fragment,we),Vp=r(we),f(hn.$$.fragment,we),we.forEach(l),Ae.forEach(l),$r=r(e),f(Wo.$$.fragment,e),Jr=r(e),Lo=c(e,"P",{"data-svelte-h":!0}),M(Lo)!=="svelte-1h2y3wu"&&(Lo.textContent=Ed),jr=r(e),f(Xo.$$.fragment,e),Rr=r(e),ae=c(e,"DIV",{class:!0});var Ke=x(ae);f(Go.$$.fragment,Ke),Bp=r(Ke),Qs=c(Ke,"P",{"data-svelte-h":!0}),M(Qs)!=="svelte-zfhxto"&&(Qs.innerHTML=Hd),Dp=r(Ke),Ys=c(Ke,"P",{"data-svelte-h":!0}),M(Ys)!=="svelte-x6f2b0"&&(Ys.innerHTML=Qd),qp=r(Ke),q=c(Ke,"DIV",{class:!0});var Me=x(q);f(Po.$$.fragment,Me),Ep=r(Me),As=c(Me,"P",{"data-svelte-h":!0}),M(As)!=="svelte-1azuqx"&&(As.innerHTML=Yd),Hp=r(Me),f(bn.$$.fragment,Me),Qp=r(Me),f(yn.$$.fragment,Me),Yp=r(Me),f(Tn.$$.fragment,Me),Me.forEach(l),Ke.forEach(l),Nr=r(e),f(Oo.$$.fragment,e),Ur=r(e),se=c(e,"DIV",{class:!0});var et=x(se);f(Fo.$$.fragment,et),Ap=r(et),Ks=c(et,"P",{"data-svelte-h":!0}),M(Ks)!=="svelte-dk655q"&&(Ks.innerHTML=Ad),Kp=r(et),ei=c(et,"P",{"data-svelte-h":!0}),M(ei)!=="svelte-x6f2b0"&&(ei.innerHTML=Kd),em=r(et),E=c(et,"DIV",{class:!0});var ve=x(E);f(zo.$$.fragment,ve),tm=r(ve),ti=c(ve,"P",{"data-svelte-h":!0}),M(ti)!=="svelte-1s27jle"&&(ti.innerHTML=eg),nm=r(ve),f(wn.$$.fragment,ve),om=r(ve),f(Mn.$$.fragment,ve),am=r(ve),f(vn.$$.fragment,ve),ve.forEach(l),et.forEach(l),Zr=r(e),f(Vo.$$.fragment,e),Cr=r(e),Bo=c(e,"P",{"data-svelte-h":!0}),M(Bo)!=="svelte-liyjdz"&&(Bo.textContent=tg),Sr=r(e),f(Do.$$.fragment,e),Wr=r(e),P=c(e,"DIV",{class:!0});var xe=x(P);f(qo.$$.fragment,xe),sm=r(xe),ni=c(xe,"P",{"data-svelte-h":!0}),M(ni)!=="svelte-1uwrr47"&&(ni.textContent=ng),im=r(xe),oi=c(xe,"P",{"data-svelte-h":!0}),M(oi)!=="svelte-1bzil0z"&&(oi.innerHTML=og),rm=r(xe),ai=c(xe,"P",{"data-svelte-h":!0}),M(ai)!=="svelte-x6f2b0"&&(ai.innerHTML=ag),lm=r(xe),H=c(xe,"DIV",{class:!0});var Ie=x(H);f(Eo.$$.fragment,Ie),pm=r(Ie),si=c(Ie,"P",{"data-svelte-h":!0}),M(si)!=="svelte-p67kxo"&&(si.innerHTML=sg),mm=r(Ie),f(xn.$$.fragment,Ie),cm=r(Ie),f(In.$$.fragment,Ie),dm=r(Ie),f(kn.$$.fragment,Ie),Ie.forEach(l),xe.forEach(l),Lr=r(e),f(Ho.$$.fragment,e),Xr=r(e),ie=c(e,"DIV",{class:!0});var tt=x(ie);f(Qo.$$.fragment,tt),gm=r(tt),ii=c(tt,"P",{"data-svelte-h":!0}),M(ii)!=="svelte-1o1ktq3"&&(ii.innerHTML=ig),um=r(tt),ri=c(tt,"P",{"data-svelte-h":!0}),M(ri)!=="svelte-x6f2b0"&&(ri.innerHTML=rg),fm=r(tt),Ne=c(tt,"DIV",{class:!0});var nt=x(Ne);f(Yo.$$.fragment,nt),_m=r(nt),li=c(nt,"P",{"data-svelte-h":!0}),M(li)!=="svelte-18aced7"&&(li.innerHTML=lg),hm=r(nt),f($n.$$.fragment,nt),bm=r(nt),f(Jn.$$.fragment,nt),nt.forEach(l),tt.forEach(l),Gr=r(e),f(Ao.$$.fragment,e),Pr=r(e),re=c(e,"DIV",{class:!0});var ot=x(re);f(Ko.$$.fragment,ot),ym=r(ot),pi=c(ot,"P",{"data-svelte-h":!0}),M(pi)!=="svelte-1qb3ro7"&&(pi.innerHTML=pg),Tm=r(ot),mi=c(ot,"P",{"data-svelte-h":!0}),M(mi)!=="svelte-x6f2b0"&&(mi.innerHTML=mg),wm=r(ot),Ue=c(ot,"DIV",{class:!0});var at=x(Ue);f(ea.$$.fragment,at),Mm=r(at),ci=c(at,"P",{"data-svelte-h":!0}),M(ci)!=="svelte-1szjv6u"&&(ci.innerHTML=cg),vm=r(at),f(jn.$$.fragment,at),xm=r(at),f(Rn.$$.fragment,at),at.forEach(l),ot.forEach(l),Or=r(e),f(ta.$$.fragment,e),Fr=r(e),le=c(e,"DIV",{class:!0});var st=x(le);f(na.$$.fragment,st),Im=r(st),di=c(st,"P",{"data-svelte-h":!0}),M(di)!=="svelte-1ermegf"&&(di.innerHTML=dg),km=r(st),gi=c(st,"P",{"data-svelte-h":!0}),M(gi)!=="svelte-10uuk2l"&&(gi.innerHTML=gg),$m=r(st),Q=c(st,"DIV",{class:!0});var ke=x(Q);f(oa.$$.fragment,ke),Jm=r(ke),ui=c(ke,"P",{"data-svelte-h":!0}),M(ui)!=="svelte-1e3zkhy"&&(ui.innerHTML=ug),jm=r(ke),f(Nn.$$.fragment,ke),Rm=r(ke),f(Un.$$.fragment,ke),Nm=r(ke),f(Zn.$$.fragment,ke),ke.forEach(l),st.forEach(l),zr=r(e),f(aa.$$.fragment,e),Vr=r(e),pe=c(e,"DIV",{class:!0});var it=x(pe);f(sa.$$.fragment,it),Um=r(it),fi=c(it,"P",{"data-svelte-h":!0}),M(fi)!=="svelte-1cx6grv"&&(fi.innerHTML=fg),Zm=r(it),_i=c(it,"P",{"data-svelte-h":!0}),M(_i)!=="svelte-x6f2b0"&&(_i.innerHTML=_g),Cm=r(it),Ze=c(it,"DIV",{class:!0});var rt=x(Ze);f(ia.$$.fragment,rt),Sm=r(rt),hi=c(rt,"P",{"data-svelte-h":!0}),M(hi)!=="svelte-1fuxgrl"&&(hi.innerHTML=hg),Wm=r(rt),f(Cn.$$.fragment,rt),Lm=r(rt),f(Sn.$$.fragment,rt),rt.forEach(l),it.forEach(l),Br=r(e),f(ra.$$.fragment,e),Dr=r(e),la=c(e,"P",{"data-svelte-h":!0}),M(la)!=="svelte-1gk58z"&&(la.textContent=bg),qr=r(e),f(pa.$$.fragment,e),Er=r(e),me=c(e,"DIV",{class:!0});var lt=x(me);f(ma.$$.fragment,lt),Xm=r(lt),bi=c(lt,"P",{"data-svelte-h":!0}),M(bi)!=="svelte-1yey1ie"&&(bi.innerHTML=yg),Gm=r(lt),yi=c(lt,"P",{"data-svelte-h":!0}),M(yi)!=="svelte-10uuk2l"&&(yi.innerHTML=Tg),Pm=r(lt),Y=c(lt,"DIV",{class:!0});var $e=x(Y);f(ca.$$.fragment,$e),Om=r($e),Ti=c($e,"P",{"data-svelte-h":!0}),M(Ti)!=="svelte-11xalzp"&&(Ti.innerHTML=wg),Fm=r($e),f(Wn.$$.fragment,$e),zm=r($e),f(Ln.$$.fragment,$e),Vm=r($e),f(Xn.$$.fragment,$e),$e.forEach(l),lt.forEach(l),Hr=r(e),f(da.$$.fragment,e),Qr=r(e),ce=c(e,"DIV",{class:!0});var pt=x(ce);f(ga.$$.fragment,pt),Bm=r(pt),wi=c(pt,"P",{"data-svelte-h":!0}),M(wi)!=="svelte-1eubaty"&&(wi.innerHTML=Mg),Dm=r(pt),Mi=c(pt,"P",{"data-svelte-h":!0}),M(Mi)!=="svelte-10uuk2l"&&(Mi.innerHTML=vg),qm=r(pt),Ce=c(pt,"DIV",{class:!0});var mt=x(Ce);f(ua.$$.fragment,mt),Em=r(mt),vi=c(mt,"P",{"data-svelte-h":!0}),M(vi)!=="svelte-eywb10"&&(vi.innerHTML=xg),Hm=r(mt),f(Gn.$$.fragment,mt),Qm=r(mt),f(Pn.$$.fragment,mt),mt.forEach(l),pt.forEach(l),Yr=r(e),f(fa.$$.fragment,e),Ar=r(e),_a=c(e,"P",{"data-svelte-h":!0}),M(_a)!=="svelte-1n8n3ms"&&(_a.textContent=Ig),Kr=r(e),f(ha.$$.fragment,e),el=r(e),de=c(e,"DIV",{class:!0});var ct=x(de);f(ba.$$.fragment,ct),Ym=r(ct),xi=c(ct,"P",{"data-svelte-h":!0}),M(xi)!=="svelte-1a1l178"&&(xi.innerHTML=kg),Am=r(ct),Ii=c(ct,"P",{"data-svelte-h":!0}),M(Ii)!=="svelte-x6f2b0"&&(Ii.innerHTML=$g),Km=r(ct),A=c(ct,"DIV",{class:!0});var Je=x(A);f(ya.$$.fragment,Je),ec=r(Je),ki=c(Je,"P",{"data-svelte-h":!0}),M(ki)!=="svelte-1usnw5b"&&(ki.innerHTML=Jg),tc=r(Je),f(On.$$.fragment,Je),nc=r(Je),f(Fn.$$.fragment,Je),oc=r(Je),f(zn.$$.fragment,Je),Je.forEach(l),ct.forEach(l),tl=r(e),f(Ta.$$.fragment,e),nl=r(e),ge=c(e,"DIV",{class:!0});var dt=x(ge);f(wa.$$.fragment,dt),ac=r(dt),$i=c(dt,"P",{"data-svelte-h":!0}),M($i)!=="svelte-poono3"&&($i.innerHTML=jg),sc=r(dt),Ji=c(dt,"P",{"data-svelte-h":!0}),M(Ji)!=="svelte-x6f2b0"&&(Ji.innerHTML=Rg),ic=r(dt),K=c(dt,"DIV",{class:!0});var je=x(K);f(Ma.$$.fragment,je),rc=r(je),ji=c(je,"P",{"data-svelte-h":!0}),M(ji)!=="svelte-iqwqsz"&&(ji.innerHTML=Ng),lc=r(je),f(Vn.$$.fragment,je),pc=r(je),f(Bn.$$.fragment,je),mc=r(je),f(Dn.$$.fragment,je),je.forEach(l),dt.forEach(l),ol=r(e),f(va.$$.fragment,e),al=r(e),f(xa.$$.fragment,e),sl=r(e),kt=c(e,"DIV",{class:!0});var gs=x(kt);f(Ia.$$.fragment,gs),cc=r(gs),qn=c(gs,"DIV",{class:!0});var us=x(qn);f(ka.$$.fragment,us),dc=r(us),Ri=c(us,"P",{"data-svelte-h":!0}),M(Ri)!=="svelte-1eed40t"&&(Ri.textContent=Ug),us.forEach(l),gs.forEach(l),il=r(e),f($a.$$.fragment,e),rl=r(e),Se=c(e,"DIV",{class:!0});var $t=x(Se);f(Ja.$$.fragment,$t),gc=r($t),Ni=c($t,"P",{"data-svelte-h":!0}),M(Ni)!=="svelte-9w09yl"&&(Ni.innerHTML=Zg),uc=r($t),gt=c($t,"DIV",{class:!0});var Jt=x(gt);f(ja.$$.fragment,Jt),fc=r(Jt),Ui=c(Jt,"P",{"data-svelte-h":!0}),M(Ui)!=="svelte-50j04k"&&(Ui.textContent=Cg),_c=r(Jt),f(En.$$.fragment,Jt),Jt.forEach(l),$t.forEach(l),ll=r(e),f(Ra.$$.fragment,e),pl=r(e),We=c(e,"DIV",{class:!0});var jt=x(We);f(Na.$$.fragment,jt),hc=r(jt),Zi=c(jt,"P",{"data-svelte-h":!0}),M(Zi)!=="svelte-x41vl5"&&(Zi.innerHTML=Sg),bc=r(jt),ut=c(jt,"DIV",{class:!0});var Rt=x(ut);f(Ua.$$.fragment,Rt),yc=r(Rt),Ci=c(Rt,"P",{"data-svelte-h":!0}),M(Ci)!=="svelte-50j04k"&&(Ci.textContent=Wg),Tc=r(Rt),f(Hn.$$.fragment,Rt),Rt.forEach(l),jt.forEach(l),ml=r(e),f(Za.$$.fragment,e),cl=r(e),Le=c(e,"DIV",{class:!0});var Nt=x(Le);f(Ca.$$.fragment,Nt),wc=r(Nt),Si=c(Nt,"P",{"data-svelte-h":!0}),M(Si)!=="svelte-1h7cfmq"&&(Si.innerHTML=Lg),Mc=r(Nt),ft=c(Nt,"DIV",{class:!0});var Ut=x(ft);f(Sa.$$.fragment,Ut),vc=r(Ut),Wi=c(Ut,"P",{"data-svelte-h":!0}),M(Wi)!=="svelte-50j04k"&&(Wi.textContent=Xg),xc=r(Ut),f(Qn.$$.fragment,Ut),Ut.forEach(l),Nt.forEach(l),dl=r(e),f(Wa.$$.fragment,e),gl=r(e),Xe=c(e,"DIV",{class:!0});var Zt=x(Xe);f(La.$$.fragment,Zt),Ic=r(Zt),Li=c(Zt,"P",{"data-svelte-h":!0}),M(Li)!=="svelte-1vep3h5"&&(Li.innerHTML=Gg),kc=r(Zt),_t=c(Zt,"DIV",{class:!0});var Ct=x(_t);f(Xa.$$.fragment,Ct),$c=r(Ct),Xi=c(Ct,"P",{"data-svelte-h":!0}),M(Xi)!=="svelte-v78lg8"&&(Xi.textContent=Pg),Jc=r(Ct),f(Yn.$$.fragment,Ct),Ct.forEach(l),Zt.forEach(l),ul=r(e),f(Ga.$$.fragment,e),fl=r(e),Ge=c(e,"DIV",{class:!0});var St=x(Ge);f(Pa.$$.fragment,St),jc=r(St),Gi=c(St,"P",{"data-svelte-h":!0}),M(Gi)!=="svelte-12te3gv"&&(Gi.innerHTML=Og),Rc=r(St),ht=c(St,"DIV",{class:!0});var Wt=x(ht);f(Oa.$$.fragment,Wt),Nc=r(Wt),Pi=c(Wt,"P",{"data-svelte-h":!0}),M(Pi)!=="svelte-v78lg8"&&(Pi.textContent=Fg),Uc=r(Wt),f(An.$$.fragment,Wt),Wt.forEach(l),St.forEach(l),_l=r(e),f(Fa.$$.fragment,e),hl=r(e),Pe=c(e,"DIV",{class:!0});var Lt=x(Pe);f(za.$$.fragment,Lt),Zc=r(Lt),Oi=c(Lt,"P",{"data-svelte-h":!0}),M(Oi)!=="svelte-1n56jy7"&&(Oi.innerHTML=zg),Cc=r(Lt),bt=c(Lt,"DIV",{class:!0});var Xt=x(bt);f(Va.$$.fragment,Xt),Sc=r(Xt),Fi=c(Xt,"P",{"data-svelte-h":!0}),M(Fi)!=="svelte-v78lg8"&&(Fi.textContent=Vg),Wc=r(Xt),f(Kn.$$.fragment,Xt),Xt.forEach(l),Lt.forEach(l),bl=r(e),f(Ba.$$.fragment,e),yl=r(e),Oe=c(e,"DIV",{class:!0});var Gt=x(Oe);f(Da.$$.fragment,Gt),Lc=r(Gt),zi=c(Gt,"P",{"data-svelte-h":!0}),M(zi)!=="svelte-12te3gv"&&(zi.innerHTML=Bg),Xc=r(Gt),yt=c(Gt,"DIV",{class:!0});var Pt=x(yt);f(qa.$$.fragment,Pt),Gc=r(Pt),Vi=c(Pt,"P",{"data-svelte-h":!0}),M(Vi)!=="svelte-v78lg8"&&(Vi.textContent=Dg),Pc=r(Pt),f(eo.$$.fragment,Pt),Pt.forEach(l),Gt.forEach(l),Tl=r(e),f(Ea.$$.fragment,e),wl=r(e),Fe=c(e,"DIV",{class:!0});var Ot=x(Fe);f(Ha.$$.fragment,Ot),Oc=r(Ot),Bi=c(Ot,"P",{"data-svelte-h":!0}),M(Bi)!=="svelte-1eztc8u"&&(Bi.innerHTML=qg),Fc=r(Ot),Tt=c(Ot,"DIV",{class:!0});var Ft=x(Tt);f(Qa.$$.fragment,Ft),zc=r(Ft),Di=c(Ft,"P",{"data-svelte-h":!0}),M(Di)!=="svelte-50j04k"&&(Di.textContent=Eg),Vc=r(Ft),f(to.$$.fragment,Ft),Ft.forEach(l),Ot.forEach(l),Ml=r(e),f(Ya.$$.fragment,e),vl=r(e),ze=c(e,"DIV",{class:!0});var zt=x(ze);f(Aa.$$.fragment,zt),Bc=r(zt),qi=c(zt,"P",{"data-svelte-h":!0}),M(qi)!=="svelte-1nj3mbd"&&(qi.innerHTML=Hg),Dc=r(zt),wt=c(zt,"DIV",{class:!0});var Vt=x(wt);f(Ka.$$.fragment,Vt),qc=r(Vt),Ei=c(Vt,"P",{"data-svelte-h":!0}),M(Ei)!=="svelte-50j04k"&&(Ei.textContent=Qg),Ec=r(Vt),f(no.$$.fragment,Vt),Vt.forEach(l),zt.forEach(l),xl=r(e),f(es.$$.fragment,e),Il=r(e),Ve=c(e,"DIV",{class:!0});var Bt=x(Ve);f(ts.$$.fragment,Bt),Hc=r(Bt),Hi=c(Bt,"P",{"data-svelte-h":!0}),M(Hi)!=="svelte-3ko11v"&&(Hi.innerHTML=Yg),Qc=r(Bt),Mt=c(Bt,"DIV",{class:!0});var Dt=x(Mt);f(ns.$$.fragment,Dt),Yc=r(Dt),Qi=c(Dt,"P",{"data-svelte-h":!0}),M(Qi)!=="svelte-v78lg8"&&(Qi.textContent=Ag),Ac=r(Dt),f(oo.$$.fragment,Dt),Dt.forEach(l),Bt.forEach(l),kl=r(e),f(os.$$.fragment,e),$l=r(e),Be=c(e,"DIV",{class:!0});var qt=x(Be);f(as.$$.fragment,qt),Kc=r(qt),Yi=c(qt,"P",{"data-svelte-h":!0}),M(Yi)!=="svelte-o05a51"&&(Yi.innerHTML=Kg),ed=r(qt),vt=c(qt,"DIV",{class:!0});var Et=x(vt);f(ss.$$.fragment,Et),td=r(Et),Ai=c(Et,"P",{"data-svelte-h":!0}),M(Ai)!=="svelte-v78lg8"&&(Ai.textContent=eu),nd=r(Et),f(ao.$$.fragment,Et),Et.forEach(l),qt.forEach(l),Jl=r(e),f(is.$$.fragment,e),jl=r(e),De=c(e,"DIV",{class:!0});var or=x(De);f(rs.$$.fragment,or),od=r(or),Ki=c(or,"P",{"data-svelte-h":!0}),M(Ki)!=="svelte-15aynhs"&&(Ki.innerHTML=tu),ad=r(or),xt=c(or,"DIV",{class:!0});var ar=x(xt);f(ls.$$.fragment,ar),sd=r(ar),er=c(ar,"P",{"data-svelte-h":!0}),M(er)!=="svelte-v78lg8"&&(er.textContent=nu),id=r(ar),f(so.$$.fragment,ar),ar.forEach(l),or.forEach(l),Rl=r(e),f(ps.$$.fragment,e),Nl=r(e),qe=c(e,"DIV",{class:!0});var sr=x(qe);f(ms.$$.fragment,sr),rd=r(sr),tr=c(sr,"P",{"data-svelte-h":!0}),M(tr)!=="svelte-vj6xj"&&(tr.innerHTML=ou),ld=r(sr),It=c(sr,"DIV",{class:!0});var ir=x(It);f(cs.$$.fragment,ir),pd=r(ir),nr=c(ir,"P",{"data-svelte-h":!0}),M(nr)!=="svelte-v78lg8"&&(nr.textContent=au),md=r(ir),f(io.$$.fragment,ir),ir.forEach(l),sr.forEach(l),Ul=r(e),rr=c(e,"P",{}),x(rr).forEach(l),this.h()},h(){I(n,"name","hf:doc:metadata"),I(n,"content",wf),I(Ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){s(document.head,n),g(e,T,p),g(e,a,p),g(e,o,p),_(d,e,p),g(e,t,p),_(w,e,p),g(e,lr,p),g(e,ro,p),g(e,pr,p),_(lo,e,p),g(e,mr,p),g(e,N,p),_(po,N,null),s(N,Cl),s(N,fs),s(N,Sl),s(N,_s),s(N,Wl),s(N,hs),s(N,Ll),s(N,bs),s(N,Xl),s(N,Ht),_(mo,Ht,null),s(Ht,Gl),s(Ht,ys),s(N,Pl),s(N,U),_(co,U,null),s(U,Ol),s(U,Ts),s(U,Fl),s(U,ws),s(U,zl),s(U,Ms),s(U,Vl),s(U,vs),s(U,Bl),s(U,xs),s(U,Dl),s(U,Is),g(e,cr,p),_(go,e,p),g(e,dr,p),g(e,uo,p),g(e,gr,p),_(fo,e,p),g(e,ur,p),g(e,ee,p),_(_o,ee,null),s(ee,ql),s(ee,ks),s(ee,El),s(ee,$s),s(ee,Hl),s(ee,F),_(ho,F,null),s(F,Ql),s(F,Js),s(F,Yl),_(Qt,F,null),s(F,Al),_(Yt,F,null),s(F,Kl),_(At,F,null),g(e,fr,p),_(bo,e,p),g(e,_r,p),g(e,te,p),_(yo,te,null),s(te,ep),s(te,js),s(te,tp),s(te,Rs),s(te,np),s(te,z),_(To,z,null),s(z,op),s(z,Ns),s(z,ap),_(Kt,z,null),s(z,sp),_(en,z,null),s(z,ip),_(tn,z,null),g(e,hr,p),_(wo,e,p),g(e,br,p),g(e,ne,p),_(Mo,ne,null),s(ne,rp),s(ne,Us),s(ne,lp),s(ne,Zs),s(ne,pp),s(ne,V),_(vo,V,null),s(V,mp),s(V,Cs),s(V,cp),_(nn,V,null),s(V,dp),_(on,V,null),s(V,gp),_(an,V,null),g(e,yr,p),_(xo,e,p),g(e,Tr,p),g(e,L,p),_(Io,L,null),s(L,up),s(L,Ss),s(L,fp),s(L,Ws),s(L,_p),s(L,Ls),s(L,hp),s(L,W),_(ko,W,null),s(W,bp),s(W,Xs),s(W,yp),_(sn,W,null),s(W,Tp),_(rn,W,null),s(W,wp),_(ln,W,null),s(W,Mp),_(pn,W,null),g(e,wr,p),_($o,e,p),g(e,Mr,p),g(e,X,p),_(Jo,X,null),s(X,vp),s(X,Gs),s(X,xp),s(X,Ps),s(X,Ip),s(X,Os),s(X,kp),s(X,B),_(jo,B,null),s(B,$p),s(B,Fs),s(B,Jp),_(mn,B,null),s(B,jp),_(cn,B,null),s(B,Rp),_(dn,B,null),g(e,vr,p),_(Ro,e,p),g(e,xr,p),g(e,G,p),_(No,G,null),s(G,Np),s(G,zs),s(G,Up),s(G,Vs),s(G,Zp),s(G,Bs),s(G,Cp),s(G,Re),_(Uo,Re,null),s(Re,Sp),s(Re,Ds),s(Re,Wp),_(gn,Re,null),s(Re,Lp),_(un,Re,null),g(e,Ir,p),_(Zo,e,p),g(e,kr,p),g(e,oe,p),_(Co,oe,null),s(oe,Xp),s(oe,qs),s(oe,Gp),s(oe,Es),s(oe,Pp),s(oe,D),_(So,D,null),s(D,Op),s(D,Hs),s(D,Fp),_(fn,D,null),s(D,zp),_(_n,D,null),s(D,Vp),_(hn,D,null),g(e,$r,p),_(Wo,e,p),g(e,Jr,p),g(e,Lo,p),g(e,jr,p),_(Xo,e,p),g(e,Rr,p),g(e,ae,p),_(Go,ae,null),s(ae,Bp),s(ae,Qs),s(ae,Dp),s(ae,Ys),s(ae,qp),s(ae,q),_(Po,q,null),s(q,Ep),s(q,As),s(q,Hp),_(bn,q,null),s(q,Qp),_(yn,q,null),s(q,Yp),_(Tn,q,null),g(e,Nr,p),_(Oo,e,p),g(e,Ur,p),g(e,se,p),_(Fo,se,null),s(se,Ap),s(se,Ks),s(se,Kp),s(se,ei),s(se,em),s(se,E),_(zo,E,null),s(E,tm),s(E,ti),s(E,nm),_(wn,E,null),s(E,om),_(Mn,E,null),s(E,am),_(vn,E,null),g(e,Zr,p),_(Vo,e,p),g(e,Cr,p),g(e,Bo,p),g(e,Sr,p),_(Do,e,p),g(e,Wr,p),g(e,P,p),_(qo,P,null),s(P,sm),s(P,ni),s(P,im),s(P,oi),s(P,rm),s(P,ai),s(P,lm),s(P,H),_(Eo,H,null),s(H,pm),s(H,si),s(H,mm),_(xn,H,null),s(H,cm),_(In,H,null),s(H,dm),_(kn,H,null),g(e,Lr,p),_(Ho,e,p),g(e,Xr,p),g(e,ie,p),_(Qo,ie,null),s(ie,gm),s(ie,ii),s(ie,um),s(ie,ri),s(ie,fm),s(ie,Ne),_(Yo,Ne,null),s(Ne,_m),s(Ne,li),s(Ne,hm),_($n,Ne,null),s(Ne,bm),_(Jn,Ne,null),g(e,Gr,p),_(Ao,e,p),g(e,Pr,p),g(e,re,p),_(Ko,re,null),s(re,ym),s(re,pi),s(re,Tm),s(re,mi),s(re,wm),s(re,Ue),_(ea,Ue,null),s(Ue,Mm),s(Ue,ci),s(Ue,vm),_(jn,Ue,null),s(Ue,xm),_(Rn,Ue,null),g(e,Or,p),_(ta,e,p),g(e,Fr,p),g(e,le,p),_(na,le,null),s(le,Im),s(le,di),s(le,km),s(le,gi),s(le,$m),s(le,Q),_(oa,Q,null),s(Q,Jm),s(Q,ui),s(Q,jm),_(Nn,Q,null),s(Q,Rm),_(Un,Q,null),s(Q,Nm),_(Zn,Q,null),g(e,zr,p),_(aa,e,p),g(e,Vr,p),g(e,pe,p),_(sa,pe,null),s(pe,Um),s(pe,fi),s(pe,Zm),s(pe,_i),s(pe,Cm),s(pe,Ze),_(ia,Ze,null),s(Ze,Sm),s(Ze,hi),s(Ze,Wm),_(Cn,Ze,null),s(Ze,Lm),_(Sn,Ze,null),g(e,Br,p),_(ra,e,p),g(e,Dr,p),g(e,la,p),g(e,qr,p),_(pa,e,p),g(e,Er,p),g(e,me,p),_(ma,me,null),s(me,Xm),s(me,bi),s(me,Gm),s(me,yi),s(me,Pm),s(me,Y),_(ca,Y,null),s(Y,Om),s(Y,Ti),s(Y,Fm),_(Wn,Y,null),s(Y,zm),_(Ln,Y,null),s(Y,Vm),_(Xn,Y,null),g(e,Hr,p),_(da,e,p),g(e,Qr,p),g(e,ce,p),_(ga,ce,null),s(ce,Bm),s(ce,wi),s(ce,Dm),s(ce,Mi),s(ce,qm),s(ce,Ce),_(ua,Ce,null),s(Ce,Em),s(Ce,vi),s(Ce,Hm),_(Gn,Ce,null),s(Ce,Qm),_(Pn,Ce,null),g(e,Yr,p),_(fa,e,p),g(e,Ar,p),g(e,_a,p),g(e,Kr,p),_(ha,e,p),g(e,el,p),g(e,de,p),_(ba,de,null),s(de,Ym),s(de,xi),s(de,Am),s(de,Ii),s(de,Km),s(de,A),_(ya,A,null),s(A,ec),s(A,ki),s(A,tc),_(On,A,null),s(A,nc),_(Fn,A,null),s(A,oc),_(zn,A,null),g(e,tl,p),_(Ta,e,p),g(e,nl,p),g(e,ge,p),_(wa,ge,null),s(ge,ac),s(ge,$i),s(ge,sc),s(ge,Ji),s(ge,ic),s(ge,K),_(Ma,K,null),s(K,rc),s(K,ji),s(K,lc),_(Vn,K,null),s(K,pc),_(Bn,K,null),s(K,mc),_(Dn,K,null),g(e,ol,p),_(va,e,p),g(e,al,p),_(xa,e,p),g(e,sl,p),g(e,kt,p),_(Ia,kt,null),s(kt,cc),s(kt,qn),_(ka,qn,null),s(qn,dc),s(qn,Ri),g(e,il,p),_($a,e,p),g(e,rl,p),g(e,Se,p),_(Ja,Se,null),s(Se,gc),s(Se,Ni),s(Se,uc),s(Se,gt),_(ja,gt,null),s(gt,fc),s(gt,Ui),s(gt,_c),_(En,gt,null),g(e,ll,p),_(Ra,e,p),g(e,pl,p),g(e,We,p),_(Na,We,null),s(We,hc),s(We,Zi),s(We,bc),s(We,ut),_(Ua,ut,null),s(ut,yc),s(ut,Ci),s(ut,Tc),_(Hn,ut,null),g(e,ml,p),_(Za,e,p),g(e,cl,p),g(e,Le,p),_(Ca,Le,null),s(Le,wc),s(Le,Si),s(Le,Mc),s(Le,ft),_(Sa,ft,null),s(ft,vc),s(ft,Wi),s(ft,xc),_(Qn,ft,null),g(e,dl,p),_(Wa,e,p),g(e,gl,p),g(e,Xe,p),_(La,Xe,null),s(Xe,Ic),s(Xe,Li),s(Xe,kc),s(Xe,_t),_(Xa,_t,null),s(_t,$c),s(_t,Xi),s(_t,Jc),_(Yn,_t,null),g(e,ul,p),_(Ga,e,p),g(e,fl,p),g(e,Ge,p),_(Pa,Ge,null),s(Ge,jc),s(Ge,Gi),s(Ge,Rc),s(Ge,ht),_(Oa,ht,null),s(ht,Nc),s(ht,Pi),s(ht,Uc),_(An,ht,null),g(e,_l,p),_(Fa,e,p),g(e,hl,p),g(e,Pe,p),_(za,Pe,null),s(Pe,Zc),s(Pe,Oi),s(Pe,Cc),s(Pe,bt),_(Va,bt,null),s(bt,Sc),s(bt,Fi),s(bt,Wc),_(Kn,bt,null),g(e,bl,p),_(Ba,e,p),g(e,yl,p),g(e,Oe,p),_(Da,Oe,null),s(Oe,Lc),s(Oe,zi),s(Oe,Xc),s(Oe,yt),_(qa,yt,null),s(yt,Gc),s(yt,Vi),s(yt,Pc),_(eo,yt,null),g(e,Tl,p),_(Ea,e,p),g(e,wl,p),g(e,Fe,p),_(Ha,Fe,null),s(Fe,Oc),s(Fe,Bi),s(Fe,Fc),s(Fe,Tt),_(Qa,Tt,null),s(Tt,zc),s(Tt,Di),s(Tt,Vc),_(to,Tt,null),g(e,Ml,p),_(Ya,e,p),g(e,vl,p),g(e,ze,p),_(Aa,ze,null),s(ze,Bc),s(ze,qi),s(ze,Dc),s(ze,wt),_(Ka,wt,null),s(wt,qc),s(wt,Ei),s(wt,Ec),_(no,wt,null),g(e,xl,p),_(es,e,p),g(e,Il,p),g(e,Ve,p),_(ts,Ve,null),s(Ve,Hc),s(Ve,Hi),s(Ve,Qc),s(Ve,Mt),_(ns,Mt,null),s(Mt,Yc),s(Mt,Qi),s(Mt,Ac),_(oo,Mt,null),g(e,kl,p),_(os,e,p),g(e,$l,p),g(e,Be,p),_(as,Be,null),s(Be,Kc),s(Be,Yi),s(Be,ed),s(Be,vt),_(ss,vt,null),s(vt,td),s(vt,Ai),s(vt,nd),_(ao,vt,null),g(e,Jl,p),_(is,e,p),g(e,jl,p),g(e,De,p),_(rs,De,null),s(De,od),s(De,Ki),s(De,ad),s(De,xt),_(ls,xt,null),s(xt,sd),s(xt,er),s(xt,id),_(so,xt,null),g(e,Rl,p),_(ps,e,p),g(e,Nl,p),g(e,qe,p),_(ms,qe,null),s(qe,rd),s(qe,tr),s(qe,ld),s(qe,It),_(cs,It,null),s(It,pd),s(It,nr),s(It,md),_(io,It,null),g(e,Ul,p),g(e,rr,p),Zl=!0},p(e,[p]){const C={};p&2&&(C.$$scope={dirty:p,ctx:e}),Qt.$set(C);const ds={};p&2&&(ds.$$scope={dirty:p,ctx:e}),Yt.$set(ds);const S={};p&2&&(S.$$scope={dirty:p,ctx:e}),At.$set(S);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:e}),Kt.$set(Ee);const ue={};p&2&&(ue.$$scope={dirty:p,ctx:e}),en.$set(ue);const He={};p&2&&(He.$$scope={dirty:p,ctx:e}),tn.$set(He);const fe={};p&2&&(fe.$$scope={dirty:p,ctx:e}),nn.$set(fe);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),on.$set(Qe);const _e={};p&2&&(_e.$$scope={dirty:p,ctx:e}),an.$set(_e);const he={};p&2&&(he.$$scope={dirty:p,ctx:e}),sn.$set(he);const O={};p&2&&(O.$$scope={dirty:p,ctx:e}),rn.$set(O);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),ln.$set(be);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),pn.$set(ye);const Te={};p&2&&(Te.$$scope={dirty:p,ctx:e}),mn.$set(Te);const Ye={};p&2&&(Ye.$$scope={dirty:p,ctx:e}),cn.$set(Ye);const Ae={};p&2&&(Ae.$$scope={dirty:p,ctx:e}),dn.$set(Ae);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),gn.$set(we);const Ke={};p&2&&(Ke.$$scope={dirty:p,ctx:e}),un.$set(Ke);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),fn.$set(Me);const et={};p&2&&(et.$$scope={dirty:p,ctx:e}),_n.$set(et);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),hn.$set(ve);const xe={};p&2&&(xe.$$scope={dirty:p,ctx:e}),bn.$set(xe);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:e}),yn.$set(Ie);const tt={};p&2&&(tt.$$scope={dirty:p,ctx:e}),Tn.$set(tt);const nt={};p&2&&(nt.$$scope={dirty:p,ctx:e}),wn.$set(nt);const ot={};p&2&&(ot.$$scope={dirty:p,ctx:e}),Mn.$set(ot);const at={};p&2&&(at.$$scope={dirty:p,ctx:e}),vn.$set(at);const st={};p&2&&(st.$$scope={dirty:p,ctx:e}),xn.$set(st);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),In.$set(ke);const it={};p&2&&(it.$$scope={dirty:p,ctx:e}),kn.$set(it);const rt={};p&2&&(rt.$$scope={dirty:p,ctx:e}),$n.$set(rt);const lt={};p&2&&(lt.$$scope={dirty:p,ctx:e}),Jn.$set(lt);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),jn.$set($e);const pt={};p&2&&(pt.$$scope={dirty:p,ctx:e}),Rn.$set(pt);const mt={};p&2&&(mt.$$scope={dirty:p,ctx:e}),Nn.$set(mt);const ct={};p&2&&(ct.$$scope={dirty:p,ctx:e}),Un.$set(ct);const Je={};p&2&&(Je.$$scope={dirty:p,ctx:e}),Zn.$set(Je);const dt={};p&2&&(dt.$$scope={dirty:p,ctx:e}),Cn.$set(dt);const je={};p&2&&(je.$$scope={dirty:p,ctx:e}),Sn.$set(je);const gs={};p&2&&(gs.$$scope={dirty:p,ctx:e}),Wn.$set(gs);const us={};p&2&&(us.$$scope={dirty:p,ctx:e}),Ln.$set(us);const $t={};p&2&&($t.$$scope={dirty:p,ctx:e}),Xn.$set($t);const Jt={};p&2&&(Jt.$$scope={dirty:p,ctx:e}),Gn.$set(Jt);const jt={};p&2&&(jt.$$scope={dirty:p,ctx:e}),Pn.$set(jt);const Rt={};p&2&&(Rt.$$scope={dirty:p,ctx:e}),On.$set(Rt);const Nt={};p&2&&(Nt.$$scope={dirty:p,ctx:e}),Fn.$set(Nt);const Ut={};p&2&&(Ut.$$scope={dirty:p,ctx:e}),zn.$set(Ut);const Zt={};p&2&&(Zt.$$scope={dirty:p,ctx:e}),Vn.$set(Zt);const Ct={};p&2&&(Ct.$$scope={dirty:p,ctx:e}),Bn.$set(Ct);const St={};p&2&&(St.$$scope={dirty:p,ctx:e}),Dn.$set(St);const Wt={};p&2&&(Wt.$$scope={dirty:p,ctx:e}),En.$set(Wt);const Lt={};p&2&&(Lt.$$scope={dirty:p,ctx:e}),Hn.$set(Lt);const Xt={};p&2&&(Xt.$$scope={dirty:p,ctx:e}),Qn.$set(Xt);const Gt={};p&2&&(Gt.$$scope={dirty:p,ctx:e}),Yn.$set(Gt);const Pt={};p&2&&(Pt.$$scope={dirty:p,ctx:e}),An.$set(Pt);const Ot={};p&2&&(Ot.$$scope={dirty:p,ctx:e}),Kn.$set(Ot);const Ft={};p&2&&(Ft.$$scope={dirty:p,ctx:e}),eo.$set(Ft);const zt={};p&2&&(zt.$$scope={dirty:p,ctx:e}),to.$set(zt);const Vt={};p&2&&(Vt.$$scope={dirty:p,ctx:e}),no.$set(Vt);const Bt={};p&2&&(Bt.$$scope={dirty:p,ctx:e}),oo.$set(Bt);const Dt={};p&2&&(Dt.$$scope={dirty:p,ctx:e}),ao.$set(Dt);const qt={};p&2&&(qt.$$scope={dirty:p,ctx:e}),so.$set(qt);const Et={};p&2&&(Et.$$scope={dirty:p,ctx:e}),io.$set(Et)},i(e){Zl||(h(d.$$.fragment,e),h(w.$$.fragment,e),h(lo.$$.fragment,e),h(po.$$.fragment,e),h(mo.$$.fragment,e),h(co.$$.fragment,e),h(go.$$.fragment,e),h(fo.$$.fragment,e),h(_o.$$.fragment,e),h(ho.$$.fragment,e),h(Qt.$$.fragment,e),h(Yt.$$.fragment,e),h(At.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(To.$$.fragment,e),h(Kt.$$.fragment,e),h(en.$$.fragment,e),h(tn.$$.fragment,e),h(wo.$$.fragment,e),h(Mo.$$.fragment,e),h(vo.$$.fragment,e),h(nn.$$.fragment,e),h(on.$$.fragment,e),h(an.$$.fragment,e),h(xo.$$.fragment,e),h(Io.$$.fragment,e),h(ko.$$.fragment,e),h(sn.$$.fragment,e),h(rn.$$.fragment,e),h(ln.$$.fragment,e),h(pn.$$.fragment,e),h($o.$$.fragment,e),h(Jo.$$.fragment,e),h(jo.$$.fragment,e),h(mn.$$.fragment,e),h(cn.$$.fragment,e),h(dn.$$.fragment,e),h(Ro.$$.fragment,e),h(No.$$.fragment,e),h(Uo.$$.fragment,e),h(gn.$$.fragment,e),h(un.$$.fragment,e),h(Zo.$$.fragment,e),h(Co.$$.fragment,e),h(So.$$.fragment,e),h(fn.$$.fragment,e),h(_n.$$.fragment,e),h(hn.$$.fragment,e),h(Wo.$$.fragment,e),h(Xo.$$.fragment,e),h(Go.$$.fragment,e),h(Po.$$.fragment,e),h(bn.$$.fragment,e),h(yn.$$.fragment,e),h(Tn.$$.fragment,e),h(Oo.$$.fragment,e),h(Fo.$$.fragment,e),h(zo.$$.fragment,e),h(wn.$$.fragment,e),h(Mn.$$.fragment,e),h(vn.$$.fragment,e),h(Vo.$$.fragment,e),h(Do.$$.fragment,e),h(qo.$$.fragment,e),h(Eo.$$.fragment,e),h(xn.$$.fragment,e),h(In.$$.fragment,e),h(kn.$$.fragment,e),h(Ho.$$.fragment,e),h(Qo.$$.fragment,e),h(Yo.$$.fragment,e),h($n.$$.fragment,e),h(Jn.$$.fragment,e),h(Ao.$$.fragment,e),h(Ko.$$.fragment,e),h(ea.$$.fragment,e),h(jn.$$.fragment,e),h(Rn.$$.fragment,e),h(ta.$$.fragment,e),h(na.$$.fragment,e),h(oa.$$.fragment,e),h(Nn.$$.fragment,e),h(Un.$$.fragment,e),h(Zn.$$.fragment,e),h(aa.$$.fragment,e),h(sa.$$.fragment,e),h(ia.$$.fragment,e),h(Cn.$$.fragment,e),h(Sn.$$.fragment,e),h(ra.$$.fragment,e),h(pa.$$.fragment,e),h(ma.$$.fragment,e),h(ca.$$.fragment,e),h(Wn.$$.fragment,e),h(Ln.$$.fragment,e),h(Xn.$$.fragment,e),h(da.$$.fragment,e),h(ga.$$.fragment,e),h(ua.$$.fragment,e),h(Gn.$$.fragment,e),h(Pn.$$.fragment,e),h(fa.$$.fragment,e),h(ha.$$.fragment,e),h(ba.$$.fragment,e),h(ya.$$.fragment,e),h(On.$$.fragment,e),h(Fn.$$.fragment,e),h(zn.$$.fragment,e),h(Ta.$$.fragment,e),h(wa.$$.fragment,e),h(Ma.$$.fragment,e),h(Vn.$$.fragment,e),h(Bn.$$.fragment,e),h(Dn.$$.fragment,e),h(va.$$.fragment,e),h(xa.$$.fragment,e),h(Ia.$$.fragment,e),h(ka.$$.fragment,e),h($a.$$.fragment,e),h(Ja.$$.fragment,e),h(ja.$$.fragment,e),h(En.$$.fragment,e),h(Ra.$$.fragment,e),h(Na.$$.fragment,e),h(Ua.$$.fragment,e),h(Hn.$$.fragment,e),h(Za.$$.fragment,e),h(Ca.$$.fragment,e),h(Sa.$$.fragment,e),h(Qn.$$.fragment,e),h(Wa.$$.fragment,e),h(La.$$.fragment,e),h(Xa.$$.fragment,e),h(Yn.$$.fragment,e),h(Ga.$$.fragment,e),h(Pa.$$.fragment,e),h(Oa.$$.fragment,e),h(An.$$.fragment,e),h(Fa.$$.fragment,e),h(za.$$.fragment,e),h(Va.$$.fragment,e),h(Kn.$$.fragment,e),h(Ba.$$.fragment,e),h(Da.$$.fragment,e),h(qa.$$.fragment,e),h(eo.$$.fragment,e),h(Ea.$$.fragment,e),h(Ha.$$.fragment,e),h(Qa.$$.fragment,e),h(to.$$.fragment,e),h(Ya.$$.fragment,e),h(Aa.$$.fragment,e),h(Ka.$$.fragment,e),h(no.$$.fragment,e),h(es.$$.fragment,e),h(ts.$$.fragment,e),h(ns.$$.fragment,e),h(oo.$$.fragment,e),h(os.$$.fragment,e),h(as.$$.fragment,e),h(ss.$$.fragment,e),h(ao.$$.fragment,e),h(is.$$.fragment,e),h(rs.$$.fragment,e),h(ls.$$.fragment,e),h(so.$$.fragment,e),h(ps.$$.fragment,e),h(ms.$$.fragment,e),h(cs.$$.fragment,e),h(io.$$.fragment,e),Zl=!0)},o(e){b(d.$$.fragment,e),b(w.$$.fragment,e),b(lo.$$.fragment,e),b(po.$$.fragment,e),b(mo.$$.fragment,e),b(co.$$.fragment,e),b(go.$$.fragment,e),b(fo.$$.fragment,e),b(_o.$$.fragment,e),b(ho.$$.fragment,e),b(Qt.$$.fragment,e),b(Yt.$$.fragment,e),b(At.$$.fragment,e),b(bo.$$.fragment,e),b(yo.$$.fragment,e),b(To.$$.fragment,e),b(Kt.$$.fragment,e),b(en.$$.fragment,e),b(tn.$$.fragment,e),b(wo.$$.fragment,e),b(Mo.$$.fragment,e),b(vo.$$.fragment,e),b(nn.$$.fragment,e),b(on.$$.fragment,e),b(an.$$.fragment,e),b(xo.$$.fragment,e),b(Io.$$.fragment,e),b(ko.$$.fragment,e),b(sn.$$.fragment,e),b(rn.$$.fragment,e),b(ln.$$.fragment,e),b(pn.$$.fragment,e),b($o.$$.fragment,e),b(Jo.$$.fragment,e),b(jo.$$.fragment,e),b(mn.$$.fragment,e),b(cn.$$.fragment,e),b(dn.$$.fragment,e),b(Ro.$$.fragment,e),b(No.$$.fragment,e),b(Uo.$$.fragment,e),b(gn.$$.fragment,e),b(un.$$.fragment,e),b(Zo.$$.fragment,e),b(Co.$$.fragment,e),b(So.$$.fragment,e),b(fn.$$.fragment,e),b(_n.$$.fragment,e),b(hn.$$.fragment,e),b(Wo.$$.fragment,e),b(Xo.$$.fragment,e),b(Go.$$.fragment,e),b(Po.$$.fragment,e),b(bn.$$.fragment,e),b(yn.$$.fragment,e),b(Tn.$$.fragment,e),b(Oo.$$.fragment,e),b(Fo.$$.fragment,e),b(zo.$$.fragment,e),b(wn.$$.fragment,e),b(Mn.$$.fragment,e),b(vn.$$.fragment,e),b(Vo.$$.fragment,e),b(Do.$$.fragment,e),b(qo.$$.fragment,e),b(Eo.$$.fragment,e),b(xn.$$.fragment,e),b(In.$$.fragment,e),b(kn.$$.fragment,e),b(Ho.$$.fragment,e),b(Qo.$$.fragment,e),b(Yo.$$.fragment,e),b($n.$$.fragment,e),b(Jn.$$.fragment,e),b(Ao.$$.fragment,e),b(Ko.$$.fragment,e),b(ea.$$.fragment,e),b(jn.$$.fragment,e),b(Rn.$$.fragment,e),b(ta.$$.fragment,e),b(na.$$.fragment,e),b(oa.$$.fragment,e),b(Nn.$$.fragment,e),b(Un.$$.fragment,e),b(Zn.$$.fragment,e),b(aa.$$.fragment,e),b(sa.$$.fragment,e),b(ia.$$.fragment,e),b(Cn.$$.fragment,e),b(Sn.$$.fragment,e),b(ra.$$.fragment,e),b(pa.$$.fragment,e),b(ma.$$.fragment,e),b(ca.$$.fragment,e),b(Wn.$$.fragment,e),b(Ln.$$.fragment,e),b(Xn.$$.fragment,e),b(da.$$.fragment,e),b(ga.$$.fragment,e),b(ua.$$.fragment,e),b(Gn.$$.fragment,e),b(Pn.$$.fragment,e),b(fa.$$.fragment,e),b(ha.$$.fragment,e),b(ba.$$.fragment,e),b(ya.$$.fragment,e),b(On.$$.fragment,e),b(Fn.$$.fragment,e),b(zn.$$.fragment,e),b(Ta.$$.fragment,e),b(wa.$$.fragment,e),b(Ma.$$.fragment,e),b(Vn.$$.fragment,e),b(Bn.$$.fragment,e),b(Dn.$$.fragment,e),b(va.$$.fragment,e),b(xa.$$.fragment,e),b(Ia.$$.fragment,e),b(ka.$$.fragment,e),b($a.$$.fragment,e),b(Ja.$$.fragment,e),b(ja.$$.fragment,e),b(En.$$.fragment,e),b(Ra.$$.fragment,e),b(Na.$$.fragment,e),b(Ua.$$.fragment,e),b(Hn.$$.fragment,e),b(Za.$$.fragment,e),b(Ca.$$.fragment,e),b(Sa.$$.fragment,e),b(Qn.$$.fragment,e),b(Wa.$$.fragment,e),b(La.$$.fragment,e),b(Xa.$$.fragment,e),b(Yn.$$.fragment,e),b(Ga.$$.fragment,e),b(Pa.$$.fragment,e),b(Oa.$$.fragment,e),b(An.$$.fragment,e),b(Fa.$$.fragment,e),b(za.$$.fragment,e),b(Va.$$.fragment,e),b(Kn.$$.fragment,e),b(Ba.$$.fragment,e),b(Da.$$.fragment,e),b(qa.$$.fragment,e),b(eo.$$.fragment,e),b(Ea.$$.fragment,e),b(Ha.$$.fragment,e),b(Qa.$$.fragment,e),b(to.$$.fragment,e),b(Ya.$$.fragment,e),b(Aa.$$.fragment,e),b(Ka.$$.fragment,e),b(no.$$.fragment,e),b(es.$$.fragment,e),b(ts.$$.fragment,e),b(ns.$$.fragment,e),b(oo.$$.fragment,e),b(os.$$.fragment,e),b(as.$$.fragment,e),b(ss.$$.fragment,e),b(ao.$$.fragment,e),b(is.$$.fragment,e),b(rs.$$.fragment,e),b(ls.$$.fragment,e),b(so.$$.fragment,e),b(ps.$$.fragment,e),b(ms.$$.fragment,e),b(cs.$$.fragment,e),b(io.$$.fragment,e),Zl=!1},d(e){e&&(l(T),l(a),l(o),l(t),l(lr),l(ro),l(pr),l(mr),l(N),l(cr),l(dr),l(uo),l(gr),l(ur),l(ee),l(fr),l(_r),l(te),l(hr),l(br),l(ne),l(yr),l(Tr),l(L),l(wr),l(Mr),l(X),l(vr),l(xr),l(G),l(Ir),l(kr),l(oe),l($r),l(Jr),l(Lo),l(jr),l(Rr),l(ae),l(Nr),l(Ur),l(se),l(Zr),l(Cr),l(Bo),l(Sr),l(Wr),l(P),l(Lr),l(Xr),l(ie),l(Gr),l(Pr),l(re),l(Or),l(Fr),l(le),l(zr),l(Vr),l(pe),l(Br),l(Dr),l(la),l(qr),l(Er),l(me),l(Hr),l(Qr),l(ce),l(Yr),l(Ar),l(_a),l(Kr),l(el),l(de),l(tl),l(nl),l(ge),l(ol),l(al),l(sl),l(kt),l(il),l(rl),l(Se),l(ll),l(pl),l(We),l(ml),l(cl),l(Le),l(dl),l(gl),l(Xe),l(ul),l(fl),l(Ge),l(_l),l(hl),l(Pe),l(bl),l(yl),l(Oe),l(Tl),l(wl),l(Fe),l(Ml),l(vl),l(ze),l(xl),l(Il),l(Ve),l(kl),l($l),l(Be),l(Jl),l(jl),l(De),l(Rl),l(Nl),l(qe),l(Ul),l(rr)),l(n),y(d,e),y(w,e),y(lo,e),y(po),y(mo),y(co),y(go,e),y(fo,e),y(_o),y(ho),y(Qt),y(Yt),y(At),y(bo,e),y(yo),y(To),y(Kt),y(en),y(tn),y(wo,e),y(Mo),y(vo),y(nn),y(on),y(an),y(xo,e),y(Io),y(ko),y(sn),y(rn),y(ln),y(pn),y($o,e),y(Jo),y(jo),y(mn),y(cn),y(dn),y(Ro,e),y(No),y(Uo),y(gn),y(un),y(Zo,e),y(Co),y(So),y(fn),y(_n),y(hn),y(Wo,e),y(Xo,e),y(Go),y(Po),y(bn),y(yn),y(Tn),y(Oo,e),y(Fo),y(zo),y(wn),y(Mn),y(vn),y(Vo,e),y(Do,e),y(qo),y(Eo),y(xn),y(In),y(kn),y(Ho,e),y(Qo),y(Yo),y($n),y(Jn),y(Ao,e),y(Ko),y(ea),y(jn),y(Rn),y(ta,e),y(na),y(oa),y(Nn),y(Un),y(Zn),y(aa,e),y(sa),y(ia),y(Cn),y(Sn),y(ra,e),y(pa,e),y(ma),y(ca),y(Wn),y(Ln),y(Xn),y(da,e),y(ga),y(ua),y(Gn),y(Pn),y(fa,e),y(ha,e),y(ba),y(ya),y(On),y(Fn),y(zn),y(Ta,e),y(wa),y(Ma),y(Vn),y(Bn),y(Dn),y(va,e),y(xa,e),y(Ia),y(ka),y($a,e),y(Ja),y(ja),y(En),y(Ra,e),y(Na),y(Ua),y(Hn),y(Za,e),y(Ca),y(Sa),y(Qn),y(Wa,e),y(La),y(Xa),y(Yn),y(Ga,e),y(Pa),y(Oa),y(An),y(Fa,e),y(za),y(Va),y(Kn),y(Ba,e),y(Da),y(qa),y(eo),y(Ea,e),y(Ha),y(Qa),y(to),y(Ya,e),y(Aa),y(Ka),y(no),y(es,e),y(ts),y(ns),y(oo),y(os,e),y(as),y(ss),y(ao),y(is,e),y(rs),y(ls),y(so),y(ps,e),y(ms),y(cs),y(io)}}}const wf='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Diffusion Pipelines","local":"diffusion-pipelines","sections":[{"title":"ORTDiffusionPipeline","local":"optimum.onnxruntime.ORTDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionPipeline","local":"optimum.onnxruntime.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLInpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.onnxruntime.ORTLatentConsistencyModelPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelImg2ImgPipeline","local":"optimum.onnxruntime.ORTLatentConsistencyModelImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusion3Pipeline","local":"optimum.onnxruntime.ORTStableDiffusion3Pipeline","sections":[],"depth":4},{"title":"ORTStableDiffusion3Img2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusion3Img2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusion3InpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusion3InpaintPipeline","sections":[],"depth":4},{"title":"ORTFluxPipeline","local":"optimum.onnxruntime.ORTFluxPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function Mf(v){return iu(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rf extends ru{constructor(n){super(),lu(this,n,Mf,Tf,su,{})}}export{Rf as component};
