import{s as ut,o as dt,n as ct}from"../chunks/scheduler.5f3e6389.js";import{S as gt,i as ht,e as o,s as l,c as u,h as Mt,a as m,d as s,b as a,f as mt,g as d,j as r,k as Qe,l as yt,m as n,n as g,t as h,o as M,p as y}from"../chunks/index.373ab25c.js";import{T as rt}from"../chunks/Tip.3e202241.js";import{C as Tt,H as ne}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.21d1d78a.js";import{C as j}from"../chunks/CodeBlock.7080b8cf.js";function bt(le){let p,J=`You can also use the
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#pipelines" rel="nofollow">pipeline()</a> function from
Transformers and provide your Optimum model and tokenizer/feature-extractor to it.`,T,c,b;return c=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiklMEFvbm54X3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBb25ueF9waXBlbGluZSglMjJJJTIwbG92ZSUyMHlvdSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_pipeline(<span class="hljs-string">&quot;I love you&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999870002746582</span>}]`,wrap:!1}}),{c(){p=o("p"),p.innerHTML=J,T=l(),u(c.$$.fragment)},l(i){p=m(i,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1dcu0b8"&&(p.innerHTML=J),T=a(i),d(c.$$.fragment,i)},m(i,f){n(i,p,f),n(i,T,f),g(c,i,f),b=!0},p:ct,i(i){b||(h(c.$$.fragment,i),b=!0)},o(i){M(c.$$.fragment,i),b=!1},d(i){i&&(s(p),s(T)),y(c,i)}}}function ft(le){let p,J="To be able to load the model with the ONNX Runtime backend, the export to ONNX needs to be supported for the considered architecture.",T,c,b='You can check the list of supported architectures <a href="https://huggingface.co/docs/optimum/exporters/onnx/overview#overview" rel="nofollow">here</a>.';return{c(){p=o("p"),p.textContent=J,T=l(),c=o("p"),c.innerHTML=b},l(i){p=m(i,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1mw84js"&&(p.textContent=J),T=a(i),c=m(i,"P",{"data-svelte-h":!0}),r(c)!=="svelte-e7f34u"&&(c.innerHTML=b)},m(i,f){n(i,p,f),n(i,T,f),n(i,c,f)},p:ct,d(i){i&&(s(p),s(T),s(c))}}}function Jt(le){let p,J,T,c,b,i,f,ie,W,Se=`The <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> function makes it simple to use models from the <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>
for accelerated inference on a variety of tasks such as text classification, question answering and image classification.`,pe,G,Fe=`ONNX Runtime pipelines are a drop-in replacement for <a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">Transformers pipelines</a> that automatically use ONNX/ONNX Runtime as the backend for model inference.
This means you get:`,oe,B,He="<li><strong>Faster inference</strong>: ONNX Runtime’s optimized execution engine provides significant speedups</li> <li><strong>Cross-platform support</strong>: Works across different hardware accelerators (CPU, GPU, etc.)</li> <li><strong>Same API</strong>: Identical interface to transformers pipelines - no code changes needed</li> <li><strong>Automatic model loading</strong>: Seamlessly loads or exports ONNX models</li>",me,w,re,x,Ee="Currently the supported tasks are:",ce,I,Ye="<li><code>audio-classification</code>: Classify audio inputs into predefined categories.</li> <li><code>automatic-speech-recognition</code>: Convert spoken language into text.</li> <li><code>feature-extraction</code>: Extract features from text or images using pre-trained models.</li> <li><code>fill-mask</code>: Predict missing words in a sentence.</li> <li><code>image-classification</code>: Classify images into predefined categories.</li> <li><code>image-segmentation</code>: Segment images into different regions based on their content.</li> <li><code>image-to-image</code>: Transform images from one domain to another (e.g., style transfer).</li> <li><code>image-to-text</code>: Generate textual descriptions for images.</li> <li><code>question-answering</code>: Answer questions based on a given context.</li> <li><code>summarization</code>: Generate concise summaries of longer text documents.</li> <li><code>text2text-generation</code>: Generate text based on a given input text.</li> <li><code>text-classification</code>: Classify text into predefined categories (e.g., sentiment analysis).</li> <li><code>text-generation</code>: Generate text based on a given prompt.</li> <li><code>token-classification</code>: Classify individual tokens in a text (e.g., named entity recognition).</li> <li><code>translation</code>: Translate text from one language to another.</li> <li><code>zero-shot-classification</code>: Classify text into categories without prior training on those categories.</li>",ue,X,de,R,Oe=`While each task has an associated pipeline class, it is simpler to use the general <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> function which wraps all the task-specific pipelines in one object.
The <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> function automatically loads a default model and tokenizer/feature-extractor capable of performing inference for your task.`,ge,v,Le="<li>Start by creating a pipeline by specifying an inference task:</li>",he,k,Me,U,Ae='<li>Pass your input text/image to the <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> function:</li>',ye,z,Te,V,Pe='<em>Note: The default models used in the <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> function are not optimized for inference or quantized, so there won’t be a performance improvement compared to their PyTorch counterparts.</em>',be,C,fe,$,Ke=`The <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> function accepts any supported model from the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a>.
There are tags on the Model Hub that allow you to filter for a model you’d like to use for your task.`,Je,Z,je,_,De='Once you have picked an appropriate model, you can create the <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> by specifying the model repo:',we,N,Ue,q,et=`It is also possible to load it with the <code>from_pretrained(model_name_or_path, export=True)</code>
method associated with the <code>ORTModelForXXX</code> class.`,Ze,Q,tt='For example, here is how you can load the <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/modeling#optimum.onnxruntime.ORTModelForQuestionAnswering">ORTModelForQuestionAnswering</a> class for question answering:',We,S,Ge,F,Be,H,st='The <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> function is tightly integrated with the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a> and can load ONNX models directly.',xe,E,Ie,Y,nt=`It is also possible to load it with the <code>from_pretrained(model_name_or_path)</code>
method associated with the <code>ORTModelForXXX</code> class.`,Xe,O,lt='For example, here is how you can load the <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/modeling#optimum.onnxruntime.ORTModelForQuestionAnswering">ORTModelForQuestionAnswering</a> class for question answering:',Re,L,ve,A,ke,P,at=`The <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/pipelines#optimum.onnxruntime.pipeline">pipeline()</a> function can not only run inference on vanilla ONNX Runtime checkpoints - you can also use
checkpoints optimized with the <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> and the <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a>.`,ze,K,it=`Below you can find two examples of how you could use the <a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a> and the
<a href="/docs/optimum/pr_80/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> to optimize/quantize your model and use it for inference afterwards.`,Ve,D,Ce,ee,$e,te,_e,se,Ne,ae,qe;return b=new Tt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new ne({props:{title:"Inference pipelines with the ONNX Runtime accelerator",local:"inference-pipelines-with-the-onnx-runtime-accelerator",headingTag:"h1"}}),w=new rt({props:{$$slots:{default:[bt]},$$scope:{ctx:le}}}),X=new ne({props:{title:"ONNX Runtime pipeline usage",local:"onnx-runtime-pipeline-usage",headingTag:"h2"}}),k=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQWNsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;text-classification&quot;</span>)`,wrap:!1}}),z=new j({props:{code:"Y2xhc3NpZmllciglMjJJJTIwbGlrZSUyMHlvdS4lMjBJJTIwbG92ZSUyMHlvdS4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(<span class="hljs-string">&quot;I like you. I love you.&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9998838901519775</span>}]`,wrap:!1}}),C=new ne({props:{title:"Using vanilla Transformers model and converting to ONNX",local:"using-vanilla-transformers-model-and-converting-to-onnx",headingTag:"h3"}}),Z=new rt({props:{$$slots:{default:[ft]},$$scope:{ctx:le}}}),N=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQW9ubnhfcWElMjAlM0QlMjBwaXBlbGluZSglMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMmRlZXBzZXQlMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTBBY29udGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIyJTBBJTBBcHJlZCUyMCUzRCUyMG9ubnhfcWEocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># The model will be loaded to an ORTModelForQuestionAnswering.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;My name is Philipp and I live in Nuremberg.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question=question, context=context)`,wrap:!1}}),S=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcHNldCUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMHRoZSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwYW5kJTIwY29udmVydGluZyUyMHRvJTIwdGhlJTIwT05OWCUyMGZvcm1hdCUyMGJ5JTIwcHJvdmlkaW5nJTBBJTIzJTIwZXhwb3J0JTNEVHJ1ZSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGVlcHNldCUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTBBKSUwQSUwQW9ubnhfcWElMjAlM0QlMjBwaXBlbGluZSglMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTBBY29udGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIyJTBBJTBBcHJlZCUyMCUzRCUyMG9ubnhfcWEocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading the PyTorch checkpoint and converting to the ONNX format by providing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># export=True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;My name is Philipp and I live in Nuremberg.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question=question, context=context)`,wrap:!1}}),F=new ne({props:{title:"Using Optimum models",local:"using-optimum-models",headingTag:"h3"}}),E=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQW9ubnhfcWElMjAlM0QlMjBwaXBlbGluZSglMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTBBY29udGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIyJTBBJTBBcHJlZCUyMCUzRCUyMG9ubnhfcWEocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;My name is Philipp and I live in Nuremberg.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question=question, context=context)`,wrap:!1}}),L=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGRpcmVjdGx5JTIwYW4lMjBPTk5YJTIwbW9kZWwlMjBmcm9tJTIwYSUyMG1vZGVsJTIwcmVwby4lMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQSUwQW9ubnhfcWElMjAlM0QlMjBwaXBlbGluZSglMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXF1ZXN0aW9uJTIwJTNEJTIwJTIyV2hhdCdzJTIwbXklMjBuYW1lJTNGJTIyJTBBY29udGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBOdXJlbWJlcmcuJTIyJTBBJTBBcHJlZCUyMCUzRCUyMG9ubnhfcWEocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbnRleHQlM0Rjb250ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading directly an ONNX model from a model repo.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;My name is Philipp and I live in Nuremberg.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question=question, context=context)`,wrap:!1}}),A=new ne({props:{title:"Optimizing and quantizing in pipelines",local:"optimizing-and-quantizing-in-pipelines",headingTag:"h2"}}),D=new ne({props:{title:"Quantizing with the ORTQuantizer",local:"quantizing-with-the-ortquantizer",headingTag:"h3"}}),ee=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoQuantizationConfig,
<span class="hljs-meta">... </span>    ORTModelForSequenceClassification,
<span class="hljs-meta">... </span>    ORTQuantizer
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the tokenizer and export the model to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_dir = <span class="hljs-string">&quot;distilbert_quantized&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the quantization configuration detailing the quantization we wish to apply</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.avx512_vnni(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization and save the resulting model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_dir, quantization_config=qconfig)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the quantized model from a local repository</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_dir)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the transformers pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_clx = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I like the new ORT pipeline&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_clx(text)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9974810481071472}]</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save and push the model to the hub (in practice save_dir could be used here instead)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>, repository_id=<span class="hljs-string">&quot;my-onnx-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),te=new ne({props:{title:"Optimizing with ORTOptimizer",local:"optimizing-with-ortoptimizer",headingTag:"h3"}}),se=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoOptimizationConfig,
<span class="hljs-meta">... </span>    ORTModelForSequenceClassification,
<span class="hljs-meta">... </span>    ORTOptimizer
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> OptimizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the tokenizer and export the model to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_dir = <span class="hljs-string">&quot;distilbert_optimized&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the optimization configuration detailing the optimization we wish to apply</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = AutoOptimizationConfig.O3()
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(model)

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.optimize(save_dir=save_dir, optimization_config=optimization_config)
<span class="hljs-comment"># Load the optimized model from a local repository</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_dir)

<span class="hljs-comment"># Create the transformers pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_clx = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I like the new ORT pipeline&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_clx(text)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9973127245903015}]</span>

<span class="hljs-comment"># Save and push the model to the hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;new_path_for_directory&quot;</span>, repository_id=<span class="hljs-string">&quot;my-onnx-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){p=o("meta"),J=l(),T=o("p"),c=l(),u(b.$$.fragment),i=l(),u(f.$$.fragment),ie=l(),W=o("p"),W.innerHTML=Se,pe=l(),G=o("p"),G.innerHTML=Fe,oe=l(),B=o("ul"),B.innerHTML=He,me=l(),u(w.$$.fragment),re=l(),x=o("p"),x.textContent=Ee,ce=l(),I=o("ul"),I.innerHTML=Ye,ue=l(),u(X.$$.fragment),de=l(),R=o("p"),R.innerHTML=Oe,ge=l(),v=o("ol"),v.innerHTML=Le,he=l(),u(k.$$.fragment),Me=l(),U=o("ol"),U.innerHTML=Ae,ye=l(),u(z.$$.fragment),Te=l(),V=o("p"),V.innerHTML=Pe,be=l(),u(C.$$.fragment),fe=l(),$=o("p"),$.innerHTML=Ke,Je=l(),u(Z.$$.fragment),je=l(),_=o("p"),_.innerHTML=De,we=l(),u(N.$$.fragment),Ue=l(),q=o("p"),q.innerHTML=et,Ze=l(),Q=o("p"),Q.innerHTML=tt,We=l(),u(S.$$.fragment),Ge=l(),u(F.$$.fragment),Be=l(),H=o("p"),H.innerHTML=st,xe=l(),u(E.$$.fragment),Ie=l(),Y=o("p"),Y.innerHTML=nt,Xe=l(),O=o("p"),O.innerHTML=lt,Re=l(),u(L.$$.fragment),ve=l(),u(A.$$.fragment),ke=l(),P=o("p"),P.innerHTML=at,ze=l(),K=o("p"),K.innerHTML=it,Ve=l(),u(D.$$.fragment),Ce=l(),u(ee.$$.fragment),$e=l(),u(te.$$.fragment),_e=l(),u(se.$$.fragment),Ne=l(),ae=o("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);p=m(t,"META",{name:!0,content:!0}),t.forEach(s),J=a(e),T=m(e,"P",{}),mt(T).forEach(s),c=a(e),d(b.$$.fragment,e),i=a(e),d(f.$$.fragment,e),ie=a(e),W=m(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1hff8gn"&&(W.innerHTML=Se),pe=a(e),G=m(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1e1vrhl"&&(G.innerHTML=Fe),oe=a(e),B=m(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-173ymmr"&&(B.innerHTML=He),me=a(e),d(w.$$.fragment,e),re=a(e),x=m(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1rl24tl"&&(x.textContent=Ee),ce=a(e),I=m(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-3onfz"&&(I.innerHTML=Ye),ue=a(e),d(X.$$.fragment,e),de=a(e),R=m(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1189taj"&&(R.innerHTML=Oe),ge=a(e),v=m(e,"OL",{"data-svelte-h":!0}),r(v)!=="svelte-khfcvb"&&(v.innerHTML=Le),he=a(e),d(k.$$.fragment,e),Me=a(e),U=m(e,"OL",{start:!0,"data-svelte-h":!0}),r(U)!=="svelte-1vbf5s3"&&(U.innerHTML=Ae),ye=a(e),d(z.$$.fragment,e),Te=a(e),V=m(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1fny2tq"&&(V.innerHTML=Pe),be=a(e),d(C.$$.fragment,e),fe=a(e),$=m(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1gxbqo4"&&($.innerHTML=Ke),Je=a(e),d(Z.$$.fragment,e),je=a(e),_=m(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-154q6yr"&&(_.innerHTML=De),we=a(e),d(N.$$.fragment,e),Ue=a(e),q=m(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-5dusol"&&(q.innerHTML=et),Ze=a(e),Q=m(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1hat9zt"&&(Q.innerHTML=tt),We=a(e),d(S.$$.fragment,e),Ge=a(e),d(F.$$.fragment,e),Be=a(e),H=m(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-15on4fw"&&(H.innerHTML=st),xe=a(e),d(E.$$.fragment,e),Ie=a(e),Y=m(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-uqjek2"&&(Y.innerHTML=nt),Xe=a(e),O=m(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1hat9zt"&&(O.innerHTML=lt),Re=a(e),d(L.$$.fragment,e),ve=a(e),d(A.$$.fragment,e),ke=a(e),P=m(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-gpdbpz"&&(P.innerHTML=at),ze=a(e),K=m(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1xvhc3j"&&(K.innerHTML=it),Ve=a(e),d(D.$$.fragment,e),Ce=a(e),d(ee.$$.fragment,e),$e=a(e),d(te.$$.fragment,e),_e=a(e),d(se.$$.fragment,e),Ne=a(e),ae=m(e,"P",{}),mt(ae).forEach(s),this.h()},h(){Qe(p,"name","hf:doc:metadata"),Qe(p,"content",jt),Qe(U,"start","2")},m(e,t){yt(document.head,p),n(e,J,t),n(e,T,t),n(e,c,t),g(b,e,t),n(e,i,t),g(f,e,t),n(e,ie,t),n(e,W,t),n(e,pe,t),n(e,G,t),n(e,oe,t),n(e,B,t),n(e,me,t),g(w,e,t),n(e,re,t),n(e,x,t),n(e,ce,t),n(e,I,t),n(e,ue,t),g(X,e,t),n(e,de,t),n(e,R,t),n(e,ge,t),n(e,v,t),n(e,he,t),g(k,e,t),n(e,Me,t),n(e,U,t),n(e,ye,t),g(z,e,t),n(e,Te,t),n(e,V,t),n(e,be,t),g(C,e,t),n(e,fe,t),n(e,$,t),n(e,Je,t),g(Z,e,t),n(e,je,t),n(e,_,t),n(e,we,t),g(N,e,t),n(e,Ue,t),n(e,q,t),n(e,Ze,t),n(e,Q,t),n(e,We,t),g(S,e,t),n(e,Ge,t),g(F,e,t),n(e,Be,t),n(e,H,t),n(e,xe,t),g(E,e,t),n(e,Ie,t),n(e,Y,t),n(e,Xe,t),n(e,O,t),n(e,Re,t),g(L,e,t),n(e,ve,t),g(A,e,t),n(e,ke,t),n(e,P,t),n(e,ze,t),n(e,K,t),n(e,Ve,t),g(D,e,t),n(e,Ce,t),g(ee,e,t),n(e,$e,t),g(te,e,t),n(e,_e,t),g(se,e,t),n(e,Ne,t),n(e,ae,t),qe=!0},p(e,[t]){const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),w.$set(pt);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),Z.$set(ot)},i(e){qe||(h(b.$$.fragment,e),h(f.$$.fragment,e),h(w.$$.fragment,e),h(X.$$.fragment,e),h(k.$$.fragment,e),h(z.$$.fragment,e),h(C.$$.fragment,e),h(Z.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),qe=!0)},o(e){M(b.$$.fragment,e),M(f.$$.fragment,e),M(w.$$.fragment,e),M(X.$$.fragment,e),M(k.$$.fragment,e),M(z.$$.fragment,e),M(C.$$.fragment,e),M(Z.$$.fragment,e),M(N.$$.fragment,e),M(S.$$.fragment,e),M(F.$$.fragment,e),M(E.$$.fragment,e),M(L.$$.fragment,e),M(A.$$.fragment,e),M(D.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),qe=!1},d(e){e&&(s(J),s(T),s(c),s(i),s(ie),s(W),s(pe),s(G),s(oe),s(B),s(me),s(re),s(x),s(ce),s(I),s(ue),s(de),s(R),s(ge),s(v),s(he),s(Me),s(U),s(ye),s(Te),s(V),s(be),s(fe),s($),s(Je),s(je),s(_),s(we),s(Ue),s(q),s(Ze),s(Q),s(We),s(Ge),s(Be),s(H),s(xe),s(Ie),s(Y),s(Xe),s(O),s(Re),s(ve),s(ke),s(P),s(ze),s(K),s(Ve),s(Ce),s($e),s(_e),s(Ne),s(ae)),s(p),y(b,e),y(f,e),y(w,e),y(X,e),y(k,e),y(z,e),y(C,e),y(Z,e),y(N,e),y(S,e),y(F,e),y(E,e),y(L,e),y(A,e),y(D,e),y(ee,e),y(te,e),y(se,e)}}}const jt='{"title":"Inference pipelines with the ONNX Runtime accelerator","local":"inference-pipelines-with-the-onnx-runtime-accelerator","sections":[{"title":"ONNX Runtime pipeline usage","local":"onnx-runtime-pipeline-usage","sections":[{"title":"Using vanilla Transformers model and converting to ONNX","local":"using-vanilla-transformers-model-and-converting-to-onnx","sections":[],"depth":3},{"title":"Using Optimum models","local":"using-optimum-models","sections":[],"depth":3}],"depth":2},{"title":"Optimizing and quantizing in pipelines","local":"optimizing-and-quantizing-in-pipelines","sections":[{"title":"Quantizing with the ORTQuantizer","local":"quantizing-with-the-ortquantizer","sections":[],"depth":3},{"title":"Optimizing with ORTOptimizer","local":"optimizing-with-ortoptimizer","sections":[],"depth":3}],"depth":2}],"depth":1}';function wt(le){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends gt{constructor(p){super(),ht(this,p,wt,Jt,ut,{})}}export{xt as component};
