import{s as Sn,o as Gn,n as vn}from"../chunks/scheduler.22bf70d2.js";import{S as Vn,i as An,g as p,s as a,r as M,m as Yn,A as zn,h as i,f as t,c as n,j as xl,u as o,x as c,n as Rn,k as Zl,y as J,a as e,v as u,d as r,t as y,w as j}from"../chunks/index.59178e06.js";import{T as xn}from"../chunks/Tip.75d940ba.js";import{C as d}from"../chunks/CodeBlock.f7047b13.js";import{H as Ql,E as En}from"../chunks/EditOnGithub.86314611.js";function Qn(kl){let T,X='For those interested in the similarities and differences between FSDP and DeepSpeed, please check out the <a href="../concept_guides/fsdp_and_deepspeed.md">concept guide here</a>!';return{c(){T=p("p"),T.innerHTML=X},l(f){T=i(f,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1lgdao9"&&(T.innerHTML=X)},m(f,Cl){e(f,T,Cl)},p:vn,d(f){f&&t(T)}}}function kn(kl){let T,X,f,Cl,N,Fl,S,na='<a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> implements everything described in the <a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO paper</a>. Some of the salient optimizations are:',ql,G,pa="<li>Optimizer state partitioning (ZeRO stage 1)</li> <li>Gradient partitioning (ZeRO stage 2)</li> <li>Parameter partitioning (ZeRO stage 3)</li> <li>Custom mixed precision training handling</li> <li>A range of fast CUDA-extension-based optimizers</li> <li>ZeRO-Offload to CPU and Disk/NVMe</li> <li>Hierarchical partitioning of model parameters (ZeRO++)</li>",Hl,v,ia=`ZeRO-Offload has its own dedicated paper: <a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a>. And NVMe-support is described in the paper <a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU
Memory Wall for Extreme Scale Deep Learning</a>.`,$l,V,ca="DeepSpeed ZeRO-2 is primarily used only for training, as its features are of no use to inference.",Ll,A,Ma=`DeepSpeed ZeRO-3 can be used for inference as well since it allows huge models to be loaded on multiple GPUs, which
won’t be possible on a single GPU.`,Dl,Y,oa='🤗 Accelerate integrates <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> via 2 options:',Pl,z,ua=`<li>Integration of the DeepSpeed features via <code>deepspeed config file</code> specification in <code>accelerate config</code> . You just supply your custom config file or use our template. Most of
this document is focused on this feature. This supports all the core features of DeepSpeed and gives user a lot of flexibility.
User may have to change a few lines of code depending on the config.</li> <li>Integration via <code>deepspeed_plugin</code>.This supports subset of the DeepSpeed features and uses default options for the rest of the configurations.
User need not change any code and is good for those who are fine with most of the default settings of DeepSpeed.</li>`,Ol,R,Kl,x,ra="Training:",st,E,ya=`<li>🤗 Accelerate integrates all features of DeepSpeed ZeRO. This includes all the ZeRO stages 1, 2 and 3 as well as ZeRO-Offload, ZeRO-Infinity (which can offload to disk/NVMe) and ZeRO++.
Below is a short description of Data Parallelism using ZeRO - Zero Redundancy Optimizer along with diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="ZeRO Data Parallelism"/></li>`,lt,Q,ja='(Source: <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">link</a>)',tt,k,Ja="a. <strong>Stage 1</strong> : Shards optimizer states across data parallel workers/GPUs",et,F,da="b. <strong>Stage 2</strong> : Shards optimizer states + gradients across data parallel workers/GPUs",at,q,ha="c. <strong>Stage 3</strong>: Shards optimizer states + gradients + model parameters across data parallel workers/GPUs",nt,H,wa="d. <strong>Optimizer Offload</strong>: Offloads the gradients + optimizer states to CPU/Disk building on top of ZERO Stage 2",pt,$,Ta="e. <strong>Param Offload</strong>: Offloads the model parameters to CPU/Disk building on top of ZERO Stage 3",it,L,Ua="f. <strong>Hierarchical Partitioning</strong>: Enables efficient multi-node training with data-parallel training across nodes and ZeRO-3 sharding within a node, built on top of ZeRO Stage 3.",ct,D,ma="Note",Mt,P,fa="Inference:",ot,O,ba=`<li>DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity. It uses the same ZeRO protocol as training, but
it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant. For more details see:
<a href="#deepspeed-zero-inference">deepspeed-zero-inference</a>.</li>`,ut,K,rt,ss,Ia=`<strong>Pre-Requisites</strong>: Install DeepSpeed version &gt;=0.6.5. Please refer to the <a href="https://github.com/microsoft/DeepSpeed#installation" rel="nofollow">DeepSpeed Installation details</a>
for more information.`,yt,ls,Za=`We will first look at easy to use integration via <code>accelerate config</code>.
Followed by more flexible and feature rich <code>deepspeed config file</code> integration.`,jt,ts,Jt,es,Ca="On your machine(s) just run:",dt,as,ht,ns,_a=`and answer the questions asked. It will ask whether you want to use a config file for DeepSpeed to which you should answer no. Then answer the following questions to generate a basic DeepSpeed config.
This will generate a config file that will be used automatically to properly set the
default options when doing`,wt,ps,Tt,is,Ba="For instance, here is how you would run the NLP example <code>examples/nlp_example.py</code> (from the root of the repo) with DeepSpeed Plugin:",Ut,cs,ga="<strong>ZeRO Stage-2 DeepSpeed Plugin Example</strong>",mt,Ms,ft,os,bt,us,Wa="<strong>ZeRO Stage-3 with CPU Offload DeepSpeed Plugin Example</strong>",It,rs,Zt,ys,Ct,js,Xa="Currently, <code>Accelerate</code> supports following config through the CLI:",_t,Js,Bt,ds,Na="To be able to tweak more options, you will need to use a DeepSpeed config file.",gt,hs,Wt,ws,Sa="On your machine(s) just run:",Xt,Ts,Nt,Us,Ga=`and answer the questions asked. It will ask whether you want to use a config file for deepspeed to which you answer yes
and provide the path to the deepspeed config file.
This will generate a config file that will be used automatically to properly set the
default options when doing`,St,ms,Gt,fs,va="For instance, here is how you would run the NLP example <code>examples/by_feature/deepspeed_with_config_support.py</code> (from the root of the repo) with DeepSpeed Config File:",vt,bs,Va="<strong>ZeRO Stage-2 DeepSpeed Config File Example</strong>",Vt,Is,At,Zs,Aa="with the contents of <code>zero_stage2_config.json</code> being:",Yt,Cs,zt,_s,Rt,Bs,Ya="<strong>ZeRO Stage-3 with CPU offload DeepSpeed Config File Example</strong>",xt,gs,Et,Ws,za="with the contents of <code>zero_stage3_offload_config.json</code> being:",Qt,Xs,kt,Ns,Ft,Ss,Ra=`<strong>ZeRO++ Config Example</strong>
You can use the features of ZeRO++ by using the appropriate config parameters. Note that ZeRO++ is an extension for ZeRO Stage 3. Here is how the config file can be modified, from <a href="https://www.deepspeed.ai/tutorials/zeropp/" rel="nofollow">DeepSpeed’s ZeRO++ tutorial</a>:`,qt,Gs,Ht,vs,xa="For hierarchical partitioning, the partition size <code>zero_hpz_partition_size</code> should ideally be set to the number of GPUs per node. (For example, the above config file assumes 8 GPUs per node)",$t,Vs,Ea="<strong>Important code changes when using DeepSpeed Config File</strong>",Lt,b,U,_l,Qa=`DeepSpeed Optimizers and Schedulers. For more information on these,
see the <a href="https://deepspeed.readthedocs.io/en/latest/optimizers.html" rel="nofollow">DeepSpeed Optimizers</a> and <a href="https://deepspeed.readthedocs.io/en/latest/schedulers.html" rel="nofollow">DeepSpeed Schedulers</a> documentation.
We will look at the changes needed in the code when using these.`,xe,Bl,ka=`a. DS Optim + DS Scheduler: The case when both <code>optimizer</code> and <code>scheduler</code> keys are present in the DeepSpeed config file.
In this situation, those will be used and the user has to use <code>accelerate.utils.DummyOptim</code> and <code>accelerate.utils.DummyScheduler</code> to replace the PyTorch/Custom optimizers and schedulers in their code.
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,Ee,As,Qe,gl,Fa=`b. Custom Optim + Custom Scheduler: The case when both <code>optimizer</code> and <code>scheduler</code> keys are absent in the DeepSpeed config file.
In this situation, no code changes are needed from the user and this is the case when using integration via DeepSpeed Plugin.
In the above example we can see that the code remains unchanged if the <code>optimizer</code> and <code>scheduler</code> keys are absent in the DeepSpeed config file.`,ke,Wl,qa=`c. Custom Optim + DS Scheduler: The case when only <code>scheduler</code> key is present in the DeepSpeed config file.
In this situation, the user has to use <code>accelerate.utils.DummyScheduler</code> to replace the PyTorch/Custom scheduler in their code.`,Fe,Xl,Ha=`d. DS Optim + Custom Scheduler: The case when only <code>optimizer</code> key is present in the DeepSpeed config file.
This will result in an error because you can only use DS Scheduler when using DS Optim.`,qe,Nl,$a=`<p>Notice the <code>auto</code> values in the above example DeepSpeed config files. These are automatically handled by <code>prepare</code> method
based on model, dataloaders, dummy optimizer and dummy schedulers provided to <code>prepare</code> method.
Only the <code>auto</code> fields specified in above examples are handled by <code>prepare</code> method and the rest have to be explicitly specified by the user.</p>`,Dt,Ys,La="The <code>auto</code> values are calculated as:",Pt,zs,Da="<li><code>reduce_bucket_size</code>: <code>hidden_size * hidden_size</code></li> <li><code>stage3_prefetch_bucket_size</code>: <code>int(0.9 * hidden_size * hidden_size)</code></li> <li><code>stage3_param_persistence_threshold</code>: <code>10 * hidden_size</code></li>",Ot,Rs,Pa="For the <code>auto</code> feature to work for these 3 config entries - Accelerate will use <code>model.config.hidden_size</code> or <code>max(model.config.hidden_sizes)</code> as <code>hidden_size</code>. If neither of these is available, the launching will fail and you will have to set these 3 config entries manually. Remember the first 2 config entries are the communication buffers - the larger they are the more efficient the comms will be, and the larger they are the more GPU memory they will consume, so it’s a tunable performance trade-off.",Kt,xs,Oa="<strong>Things to note when using DeepSpeed Config File</strong>",se,Es,Ka="Below is a sample script using <code>deepspeed_config_file</code> in different scenarios.",le,Qs,sn="Code <code>test.py</code>:",te,ks,ee,Fs,ln="<strong>Scenario 1</strong>: Manually tampered accelerate config file having <code>deepspeed_config_file</code> along with other entries.",ae,qs,tn="<li>Content of the <code>accelerate</code> config:</li>",ne,Hs,pe,I,en="<li><code>ds_config.json</code>:</li>",ie,$s,ce,Z,an="<li>Output of <code>accelerate launch test.py</code>:</li>",Me,Ls,oe,Ds,nn="<strong>Scenario 2</strong>: Use the solution of the error to create new accelerate config and check that no ambiguity error is now thrown.",ue,Ps,pn="<li>Run <code>accelerate config</code>:</li>",re,Os,ye,C,cn="<li>Content of the <code>accelerate</code> config:</li>",je,Ks,Je,_,Mn="<li>Output of <code>accelerate launch test.py</code>:</li>",de,sl,he,ll,on="<strong>Scenario 3</strong>: Setting the <code>accelerate launch</code> command arguments related to DeepSpeed as <code>&quot;auto&quot;</code> in the DeepSpeed` configuration file and check that things work as expected.",we,tl,un="<li>New <code>ds_config.json</code> with <code>&quot;auto&quot;</code> for the <code>accelerate launch</code> DeepSpeed command arguments:</li>",Te,el,Ue,B,rn="<li>Output of <code>accelerate launch --mixed_precision=&quot;fp16&quot; --zero_stage=3 --gradient_accumulation_steps=5 --gradient_clipping=1.0 --offload_param_device=&quot;cpu&quot; --offload_optimizer_device=&quot;nvme&quot; --zero3_save_16bit_model=&quot;true&quot; test.py</code>:</li>",me,al,fe,nl,yn="<strong>Note</strong>:",be,pl,jn=`<li>Remaining <code>&quot;auto&quot;</code> values are handled in <code>accelerator.prepare()</code> call as explained in point 2 of
<code>Important code changes when using DeepSpeed Config File</code>.</li> <li>Only when <code>gradient_accumulation_steps</code> is <code>auto</code>, the value passed while creating <code>Accelerator</code> object via <code>Accelerator(gradient_accumulation_steps=k)</code> will be used. When using DeepSpeed Plugin, the value from it will be used and it will overwrite the value passed while creating Accelerator object.</li>`,Ie,il,Jn="## Saving and loading",Ze,g,Sl,dn="<p>Saving and loading of models is unchanged for ZeRO Stage-1 and Stage-2.</p>",He,h,Gl,hn=`under ZeRO Stage-3, <code>state_dict</code> contains just the placeholders since the model weights are partitioned across multiple GPUs.
ZeRO Stage-3 has 2 options:`,$e,vl,wn=`a. Saving the entire 16bit model weights to directly load later on using <code>model.load_state_dict(torch.load(pytorch_model.bin))</code>.
For this, either set <code>zero_optimization.stage3_gather_16bit_weights_on_model_save</code> to True in DeepSpeed Config file or set
<code>zero3_save_16bit_model</code> to True in DeepSpeed Plugin.
<strong>Note that this option requires consolidation of the weights on one GPU it can be slow and memory demanding, so only use this feature when needed.</strong>
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,Le,cl,De,Vl,Tn=`b. To get 32bit weights, first save the model using <code>model.save_checkpoint()</code>.
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,Pe,Ml,Oe,Al,Un=`This will create ZeRO model and optimizer partitions along with <code>zero_to_fp32.py</code> script in checkpoint directory.
You can use this script to do offline consolidation.
It requires no configuration files or GPUs. Here is an example of its usage:`,Ke,ol,sa,Yl,mn="To get 32bit model for saving/inference, you can perform:",la,ul,ta,zl,fn="If you are only interested in the <code>state_dict</code>, you can do the following:",ea,rl,aa,Rl,bn="Note that all these functions require ~2x memory (general RAM) of the size of the final checkpoint.",Ce,yl,In=`## ZeRO Inference
DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity.
It uses the same ZeRO protocol as training, but it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant.
With accelerate integration, you just need to prepare the model and dataloader as shown below:`,_e,jl,Be,Jl,Zn="## Few caveats to be aware of",ge,dl,Cn="<li>Current integration doesn’t support Pipeline Parallelism of DeepSpeed.</li> <li>Current integration doesn’t support <code>mpu</code>, limiting the tensor parallelism which is supported in Megatron-LM.</li> <li>Current integration doesn’t support multiple models.</li>",We,hl,_n="## DeepSpeed Resources",Xe,wl,Bn='The documentation for the internals related to deepspeed can be found <a href="../package_reference/deepspeed">here</a>.',Ne,Tl,gn='<li><a href="https://github.com/microsoft/deepspeed" rel="nofollow">Project’s github</a></li> <li><a href="https://www.deepspeed.ai/getting-started/" rel="nofollow">Usage docs</a></li> <li><a href="https://deepspeed.readthedocs.io/en/latest/index.html" rel="nofollow">API docs</a></li> <li><a href="https://www.microsoft.com/en-us/research/search/?q=deepspeed" rel="nofollow">Blog posts</a></li>',Se,Ul,Wn="Papers:",Ge,ml,Xn='<li><a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion Parameter Models</a></li> <li><a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a></li> <li><a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU Memory Wall for Extreme Scale Deep Learning</a></li> <li><a href="https://arxiv.org/abs/2306.10209" rel="nofollow">ZeRO++: Extremely Efficient Collective Communication for Giant Model Training</a></li>',ve,fl,Nn=`Finally, please, remember that 🤗 <code>Accelerate</code> only integrates DeepSpeed, therefore if you
have any problems or questions with regards to DeepSpeed usage, please, file an issue with <a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">DeepSpeed GitHub</a>.`,Ve,W,Ae,bl,Ye,El,ze;return N=new Ql({props:{title:"DeepSpeed",local:"deepspeed",headingTag:"h1"}}),R=new Ql({props:{title:"What is integrated?",local:"what-is-integrated",headingTag:"h2"}}),K=new Ql({props:{title:"How it works?",local:"how-it-works",headingTag:"h2"}}),ts=new Ql({props:{title:"Accelerate DeepSpeed Plugin",local:"accelerate-deepspeed-plugin",headingTag:"h3"}}),as=new d({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),ps=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),Ms=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwMSUwQSUyMGdyYWRpZW50X2NsaXBwaW5nJTNBJTIwMS4wJTBBJTIwb2ZmbG9hZF9vcHRpbWl6ZXJfZGV2aWNlJTNBJTIwbm9uZSUwQSUyMG9mZmxvYWRfcGFyYW1fZGV2aWNlJTNBJTIwbm9uZSUwQSUyMHplcm8zX2luaXRfZmxhZyUzQSUyMHRydWUlMEElMjB6ZXJvX3N0YWdlJTNBJTIwMiUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 gradient_accumulation_steps: 1
 gradient_clipping: 1.0
 offload_optimizer_device: none
 offload_param_device: none
 zero3_init_flag: <span class="hljs-literal">true</span>
 zero_stage: 2
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),os=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHklMjAtLW1peGVkX3ByZWNpc2lvbiUyMGZwMTY=",highlighted:"accelerate launch examples/nlp_example.py --mixed_precision fp16",wrap:!1}}),rs=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwMSUwQSUyMCUyMGdyYWRpZW50X2NsaXBwaW5nJTNBJTIwMS4wJTBBJTIwJTIwb2ZmbG9hZF9vcHRpbWl6ZXJfZGV2aWNlJTNBJTIwY3B1JTBBJTIwJTIwb2ZmbG9hZF9wYXJhbV9kZXZpY2UlM0ElMjBjcHUlMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBJTIwJTIwemVybzNfc2F2ZV8xNmJpdF9tb2RlbCUzQSUyMHRydWUlMEElMjAlMjB6ZXJvX3N0YWdlJTNBJTIwMyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
  gradient_accumulation_steps: 1
  gradient_clipping: 1.0
  offload_optimizer_device: cpu
  offload_param_device: cpu
  zero3_init_flag: <span class="hljs-literal">true</span>
  zero3_save_16bit_model: <span class="hljs-literal">true</span>
  zero_stage: 3
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),ys=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHklMjAtLW1peGVkX3ByZWNpc2lvbiUyMGZwMTY=",highlighted:"accelerate launch examples/nlp_example.py --mixed_precision fp16",wrap:!1}}),Js=new d({props:{code:"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",highlighted:'`zero_stage`: [0] Disabled, [1] optimizer state partitioning, [2] optimizer+gradient state partitioning and [3] optimizer+gradient+parameter partitioning\n`gradient_accumulation_steps`: Number of training steps to accumulate gradients before averaging and applying them.\n`gradient_clipping`: Enable gradient clipping with value.\n`offload_optimizer_device`: [none] Disable optimizer offloading, [cpu] offload optimizer to CPU, [nvme] offload optimizer to NVMe SSD. Only applicable with ZeRO &gt;= Stage-2.\n`offload_optimizer_nvme_path`: Decides Nvme Path to offload optimizer states. If unspecified, will default to <span class="hljs-string">&#x27;none&#x27;</span>.\n`offload_param_device`: [none] Disable parameter offloading, [cpu] offload parameters to CPU, [nvme] offload parameters to NVMe SSD. Only applicable with ZeRO Stage-3.\n`offload_param_nvme_path`: Decides Nvme Path to offload parameters. If unspecified, will default to <span class="hljs-string">&#x27;none&#x27;</span>.\n`zero3_init_flag`: Decides whether to <span class="hljs-built_in">enable</span> `deepspeed.zero.Init` <span class="hljs-keyword">for</span> constructing massive models. Only applicable with ZeRO Stage-3.\n`zero3_save_16bit_model`: Decides whether to save 16-bit model weights when using ZeRO Stage-3.\n`mixed_precision`: `no` <span class="hljs-keyword">for</span> FP32 training, `fp16` <span class="hljs-keyword">for</span> FP16 mixed-precision training and `bf16` <span class="hljs-keyword">for</span> BF16 mixed-precision training.\n`deepspeed_moe_layer_cls_names`: Comma-separated list of transformer Mixture-of-Experts (MoE) layer class names (case-sensitive) to wrap ,e.g, `MixtralSparseMoeBlock`, `Qwen2MoeSparseMoeBlock`, `JetMoEAttention,JetMoEBlock` ...\n`deepspeed_hostfile`: DeepSpeed hostfile <span class="hljs-keyword">for</span> configuring multi-node compute resources.\n`deepspeed_exclusion_filter`: DeepSpeed exclusion filter string when using mutli-node setup.\n`deepspeed_inclusion_filter`: DeepSpeed inclusion filter string when using mutli-node setup.\n`deepspeed_multinode_launcher`: DeepSpeed multi-node launcher to use. If unspecified, will default to `pdsh`.\n`deepspeed_config_file`: path to the DeepSpeed config file <span class="hljs-keyword">in</span> `json` format. See the next section <span class="hljs-keyword">for</span> more details on this.',wrap:!1}}),hs=new Ql({props:{title:"DeepSpeed Config File",local:"deepspeed-config-file",headingTag:"h3"}}),Ts=new d({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),ms=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),Is=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJTJGaG9tZSUyRnVidW50dSUyRmFjY2VsZXJhdGUlMkZleGFtcGxlcyUyRmNvbmZpZ3MlMkZkZWVwc3BlZWRfY29uZmlnX3RlbXBsYXRlcyUyRnplcm9fc3RhZ2UyX2NvbmZpZy5qc29uJTBBJTIwemVybzNfaW5pdF9mbGFnJTNBJTIwdHJ1ZSUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 deepspeed_config_file: /home/ubuntu/accelerate/examples/configs/deepspeed_config_templates/zero_stage2_config.json
 zero3_init_flag: <span class="hljs-literal">true</span>
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),Cs=new d({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;torch_adam&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adam_w_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_s=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGYnlfZmVhdHVyZSUyRmRlZXBzcGVlZF93aXRoX2NvbmZpZ19zdXBwb3J0LnB5JTIwJTVDJTBBLS1jb25maWdfbmFtZSUyMCUyMmdwdDItbGFyZ2UlMjIlMjAlNUMlMEEtLXRva2VuaXplcl9uYW1lJTIwJTIyZ3B0Mi1sYXJnZSUyMiUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwJTIyd2lraXRleHQlMjIlMjAlNUMlMEEtLWRhdGFzZXRfY29uZmlnX25hbWUlMjAlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyMCU1QyUwQS0tYmxvY2tfc2l6ZSUyMDEyOCUyMCU1QyUwQS0tb3V0cHV0X2RpciUyMCUyMi4lMkZjbG0lMkZjbG1fZGVlcHNwZWVkX3N0YWdlMl9hY2NlbGVyYXRlJTIyJTIwJTVDJTBBLS1sZWFybmluZ19yYXRlJTIwNWUtNCUyMCU1QyUwQS0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMjQlMjAlNUMlMEEtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwMjQlMjAlNUMlMEEtLW51bV90cmFpbl9lcG9jaHMlMjAzJTIwJTVDJTBBLS13aXRoX3RyYWNraW5nJTIwJTVDJTBBLS1yZXBvcnRfdG8lMjAlMjJ3YW5kYiUyMiU1Qw==",highlighted:`accelerate launch examples/by_feature/deepspeed_with_config_support.py \\
--config_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--dataset_name <span class="hljs-string">&quot;wikitext&quot;</span> \\
--dataset_config_name <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span> \\
--block_size 128 \\
--output_dir <span class="hljs-string">&quot;./clm/clm_deepspeed_stage2_accelerate&quot;</span> \\
--learning_rate 5e-4 \\
--per_device_train_batch_size 24 \\
--per_device_eval_batch_size 24 \\
--num_train_epochs 3 \\
--with_tracking \\
--report_to <span class="hljs-string">&quot;wandb&quot;</span>\\`,wrap:!1}}),gs=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJTJGaG9tZSUyRnVidW50dSUyRmFjY2VsZXJhdGUlMkZleGFtcGxlcyUyRmNvbmZpZ3MlMkZkZWVwc3BlZWRfY29uZmlnX3RlbXBsYXRlcyUyRnplcm9fc3RhZ2UzX29mZmxvYWRfY29uZmlnLmpzb24lMEElMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMERFRVBTUEVFRCUwQWZzZHBfY29uZmlnJTNBJTIwJTdCJTdEJTBBbWFjaGluZV9yYW5rJTNBJTIwMCUwQW1haW5fcHJvY2Vzc19pcCUzQSUyMG51bGwlMEFtYWluX3Byb2Nlc3NfcG9ydCUzQSUyMG51bGwlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGZwMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 deepspeed_config_file: /home/ubuntu/accelerate/examples/configs/deepspeed_config_templates/zero_stage3_offload_config.json
 zero3_init_flag: <span class="hljs-literal">true</span>
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),Xs=new d({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ns=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGYnlfZmVhdHVyZSUyRmRlZXBzcGVlZF93aXRoX2NvbmZpZ19zdXBwb3J0LnB5JTIwJTVDJTBBLS1jb25maWdfbmFtZSUyMCUyMmdwdDItbGFyZ2UlMjIlMjAlNUMlMEEtLXRva2VuaXplcl9uYW1lJTIwJTIyZ3B0Mi1sYXJnZSUyMiUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwJTIyd2lraXRleHQlMjIlMjAlNUMlMEEtLWRhdGFzZXRfY29uZmlnX25hbWUlMjAlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyMCU1QyUwQS0tYmxvY2tfc2l6ZSUyMDEyOCUyMCU1QyUwQS0tb3V0cHV0X2RpciUyMCUyMi4lMkZjbG0lMkZjbG1fZGVlcHNwZWVkX3N0YWdlM19vZmZsb2FkX2FjY2VsZXJhdGUlMjIlMjAlNUMlMEEtLWxlYXJuaW5nX3JhdGUlMjA1ZS00JTIwJTVDJTBBLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAzMiUyMCU1QyUwQS0tcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlMjAzMiUyMCU1QyUwQS0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEEtLXdpdGhfdHJhY2tpbmclMjAlNUMlMEEtLXJlcG9ydF90byUyMCUyMndhbmRiJTIyJTVD",highlighted:`accelerate launch examples/by_feature/deepspeed_with_config_support.py \\
--config_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--dataset_name <span class="hljs-string">&quot;wikitext&quot;</span> \\
--dataset_config_name <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span> \\
--block_size 128 \\
--output_dir <span class="hljs-string">&quot;./clm/clm_deepspeed_stage3_offload_accelerate&quot;</span> \\
--learning_rate 5e-4 \\
--per_device_train_batch_size 32 \\
--per_device_eval_batch_size 32 \\
--num_train_epochs 3 \\
--with_tracking \\
--report_to <span class="hljs-string">&quot;wandb&quot;</span>\\`,wrap:!1}}),Gs=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZWR1Y2VfYnVja2V0X3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyemVyb19xdWFudGl6ZWRfd2VpZ2h0cyUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ6ZXJvX2hwel9wYXJ0aXRpb25fc2l6ZSUyMiUzQSUyMDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ6ZXJvX3F1YW50aXplZF9ncmFkaWVudHMlMjIlM0ElMjB0cnVlJTJDJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGlndW91c19ncmFkaWVudHMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>

        <span class="hljs-attr">&quot;zero_quantized_weights&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;zero_hpz_partition_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;zero_quantized_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>

        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),As=new d({props:{code:"JTIwJTIzJTIwQ3JlYXRlcyUyMER1bW15JTIwT3B0aW1pemVyJTIwaWYlMjAlNjBvcHRpbWl6ZXIlNjAlMjB3YXMlMjBzcGVjaWZpZWQlMjBpbiUyMHRoZSUyMGNvbmZpZyUyMGZpbGUlMjBlbHNlJTIwY3JlYXRlcyUyMEFkYW0lMjBPcHRpbWl6ZXIlMEElMjBvcHRpbWl6ZXJfY2xzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMHRvcmNoLm9wdGltLkFkYW1XJTBBJTIwJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5zdGF0ZS5kZWVwc3BlZWRfcGx1Z2luJTIwaXMlMjBOb25lJTBBJTIwJTIwJTIwJTIwJTIwb3IlMjAlMjJvcHRpbWl6ZXIlMjIlMjBub3QlMjBpbiUyMGFjY2VsZXJhdG9yLnN0YXRlLmRlZXBzcGVlZF9wbHVnaW4uZGVlcHNwZWVkX2NvbmZpZyUwQSUyMCUyMCUyMCUyMCUyMGVsc2UlMjBEdW1teU9wdGltJTBBJTIwKSUwQSUyMG9wdGltaXplciUyMCUzRCUyMG9wdGltaXplcl9jbHMob3B0aW1pemVyX2dyb3VwZWRfcGFyYW1ldGVycyUyQyUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlKSUwQSUwQSUyMCUyMyUyMENyZWF0ZXMlMjBEdW1teSUyMFNjaGVkdWxlciUyMGlmJTIwJTYwc2NoZWR1bGVyJTYwJTIwd2FzJTIwc3BlY2lmaWVkJTIwaW4lMjB0aGUlMjBjb25maWclMjBmaWxlJTIwZWxzZSUyMGNyZWF0ZXMlMjAlNjBhcmdzLmxyX3NjaGVkdWxlcl90eXBlJTYwJTIwU2NoZWR1bGVyJTBBJTIwaWYlMjAoJTBBJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc3RhdGUuZGVlcHNwZWVkX3BsdWdpbiUyMGlzJTIwTm9uZSUwQSUyMCUyMCUyMCUyMCUyMG9yJTIwJTIyc2NoZWR1bGVyJTIyJTIwbm90JTIwaW4lMjBhY2NlbGVyYXRvci5zdGF0ZS5kZWVwc3BlZWRfcGx1Z2luLmRlZXBzcGVlZF9jb25maWclMEElMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEYXJncy5scl9zY2hlZHVsZXJfdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0RhcmdzLm51bV93YXJtdXBfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RhcmdzLm1heF90cmFpbl9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCklMEElMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwRHVtbXlTY2hlZHVsZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTJDJTIwdG90YWxfbnVtX3N0ZXBzJTNEYXJncy5tYXhfdHJhaW5fc3RlcHMlMkMlMjB3YXJtdXBfbnVtX3N0ZXBzJTNEYXJncy5udW1fd2FybXVwX3N0ZXBzJTBBJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:` <span class="hljs-comment"># Creates Dummy Optimizer if \`optimizer\` was specified in the config file else creates Adam Optimizer</span>
 optimizer_cls = (
     torch.optim.AdamW
     <span class="hljs-keyword">if</span> accelerator.state.deepspeed_plugin <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
     <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;optimizer&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> accelerator.state.deepspeed_plugin.deepspeed_config
     <span class="hljs-keyword">else</span> DummyOptim
 )
 optimizer = optimizer_cls(optimizer_grouped_parameters, lr=args.learning_rate)

 <span class="hljs-comment"># Creates Dummy Scheduler if \`scheduler\` was specified in the config file else creates \`args.lr_scheduler_type\` Scheduler</span>
 <span class="hljs-keyword">if</span> (
     accelerator.state.deepspeed_plugin <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
     <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;scheduler&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> accelerator.state.deepspeed_plugin.deepspeed_config
 ):
     lr_scheduler = get_scheduler(
         name=args.lr_scheduler_type,
         optimizer=optimizer,
         num_warmup_steps=args.num_warmup_steps,
         num_training_steps=args.max_train_steps,
     )
 <span class="hljs-keyword">else</span>:
     lr_scheduler = DummyScheduler(
         optimizer, total_num_steps=args.max_train_steps, warmup_num_steps=args.num_warmup_steps
     )`,wrap:!1}}),ks=new d({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnN0YXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3JTdGF0ZSUwQSUwQSUwQWRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnByaW50KGYlMjIlN0JBY2NlbGVyYXRvclN0YXRlKCklN0QlMjIpJTBBJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwbWFpbigp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> AcceleratorState


<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    accelerator = Accelerator()
    accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{AcceleratorState()}</span>&quot;</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),Hs=new d({props:{code:"Y29tbWFuZF9maWxlJTNBJTIwbnVsbCUwQWNvbW1hbmRzJTNBJTIwbnVsbCUwQWNvbXB1dGVfZW52aXJvbm1lbnQlM0ElMjBMT0NBTF9NQUNISU5FJTBBZGVlcHNwZWVkX2NvbmZpZyUzQSUwQSUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzQSUyMDElMEElMjAlMjBncmFkaWVudF9jbGlwcGluZyUzQSUyMDEuMCUwQSUyMCUyMG9mZmxvYWRfb3B0aW1pemVyX2RldmljZSUzQSUyMCdjcHUnJTBBJTIwJTIwb2ZmbG9hZF9wYXJhbV9kZXZpY2UlM0ElMjAnY3B1JyUwQSUyMCUyMHplcm8zX2luaXRfZmxhZyUzQSUyMHRydWUlMEElMjAlMjB6ZXJvM19zYXZlXzE2Yml0X21vZGVsJTNBJTIwdHJ1ZSUwQSUyMCUyMHplcm9fc3RhZ2UlM0ElMjAzJTBBJTIwJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJ2RzX2NvbmZpZy5qc29uJyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWR5bmFtb19iYWNrZW5kJTNBJTIwJ05PJyUwQWZzZHBfY29uZmlnJTNBJTIwJTdCJTdEJTBBZ3B1X2lkcyUzQSUyMG51bGwlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl9wcm9jZXNzX2lwJTNBJTIwbnVsbCUwQW1haW5fcHJvY2Vzc19wb3J0JTNBJTIwbnVsbCUwQW1haW5fdHJhaW5pbmdfZnVuY3Rpb24lM0ElMjBtYWluJTBBbWVnYXRyb25fbG1fY29uZmlnJTNBJTIwJTdCJTdEJTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9uYW1lJTNBJTIwbnVsbCUwQXRwdV96b25lJTNBJTIwbnVsbCUwQXVzZV9jcHUlM0ElMjBmYWxzZQ==",highlighted:`<span class="hljs-attr">command_file:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">commands:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">gradient_accumulation_steps:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">gradient_clipping:</span> <span class="hljs-number">1.0</span>
  <span class="hljs-attr">offload_optimizer_device:</span> <span class="hljs-string">&#x27;cpu&#x27;</span>
  <span class="hljs-attr">offload_param_device:</span> <span class="hljs-string">&#x27;cpu&#x27;</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">zero3_save_16bit_model:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">zero_stage:</span> <span class="hljs-number">3</span>
  <span class="hljs-attr">deepspeed_config_file:</span> <span class="hljs-string">&#x27;ds_config.json&#x27;</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">dynamo_backend:</span> <span class="hljs-string">&#x27;NO&#x27;</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">gpu_ids:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_process_ip:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_process_port:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">megatron_lm_config:</span> {}
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_name:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">tpu_zone:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),$s=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMGZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9vcHRpbWl6ZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJub25lJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9wYXJhbSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMm5vbmUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJncmFkaWVudF9jbGlwcGluZyUyMiUzQSUyMDEuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYWluX2JhdGNoX3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RlcHNfcGVyX3ByaW50JTIyJTNBJTIwMjAwMDAwMCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000000</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ls=new d({props:{code:"VmFsdWVFcnJvciUzQSUyMFdoZW4lMjB1c2luZyUyMCU2MGRlZXBzcGVlZF9jb25maWdfZmlsZSU2MCUyQyUyMHRoZSUyMGZvbGxvd2luZyUyMGFjY2VsZXJhdGUlMjBjb25maWclMjB2YXJpYWJsZXMlMjB3aWxsJTIwYmUlMjBpZ25vcmVkJTNBJTBBJTVCJ2dyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyclMkMlMjAnZ3JhZGllbnRfY2xpcHBpbmcnJTJDJTIwJ3plcm9fc3RhZ2UnJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyX2RldmljZSclMkMlMjAnb2ZmbG9hZF9wYXJhbV9kZXZpY2UnJTJDJTBBJ3plcm8zX3NhdmVfMTZiaXRfbW9kZWwnJTJDJTIwJ21peGVkX3ByZWNpc2lvbiclNUQuJTBBUGxlYXNlJTIwc3BlY2lmeSUyMHRoZW0lMjBhcHByb3ByaWF0ZWx5JTIwaW4lMjB0aGUlMjBEZWVwU3BlZWQlMjBjb25maWclMjBmaWxlLiUwQUlmJTIweW91JTIwYXJlJTIwdXNpbmclMjBhbiUyMGFjY2VsZXJhdGUlMjBjb25maWclMjBmaWxlJTJDJTIwcmVtb3ZlJTIwb3RoZXIlMjBjb25maWclMjB2YXJpYWJsZXMlMjBtZW50aW9uZWQlMjBpbiUyMHRoZSUyMGFib3ZlJTIwc3BlY2lmaWVkJTIwbGlzdC4lMEFUaGUlMjBlYXNpZXN0JTIwbWV0aG9kJTIwaXMlMjB0byUyMGNyZWF0ZSUyMGElMjBuZXclMjBjb25maWclMjBmb2xsb3dpbmclMjB0aGUlMjBxdWVzdGlvbm5haXJlJTIwdmlhJTIwJTYwYWNjZWxlcmF0ZSUyMGNvbmZpZyU2MC4lMEFJdCUyMHdpbGwlMjBvbmx5JTIwYXNrJTIwZm9yJTIwdGhlJTIwbmVjZXNzYXJ5JTIwY29uZmlnJTIwdmFyaWFibGVzJTIwd2hlbiUyMHVzaW5nJTIwJTYwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTYwLg==",highlighted:'ValueError: When using `deepspeed_config_file`, the following accelerate config variables will be ignored:\n[<span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>, <span class="hljs-string">&#x27;zero_stage&#x27;</span>, <span class="hljs-string">&#x27;offload_optimizer_device&#x27;</span>, <span class="hljs-string">&#x27;offload_param_device&#x27;</span>,\n<span class="hljs-string">&#x27;zero3_save_16bit_model&#x27;</span>, <span class="hljs-string">&#x27;mixed_precision&#x27;</span>].\nPlease specify them appropriately <span class="hljs-keyword">in</span> the DeepSpeed config file.\nIf you are using an accelerate config file, remove other config variables mentioned <span class="hljs-keyword">in</span> the above specified list.\nThe easiest method is to create a new config following the questionnaire via `accelerate config`.\nIt will only ask <span class="hljs-keyword">for</span> the necessary config variables when using `deepspeed_config_file`.',wrap:!1}}),Os=new d({props:{code:"JTI0JTIwYWNjZWxlcmF0ZSUyMGNvbmZpZyUwQS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMEFJbiUyMHdoaWNoJTIwY29tcHV0ZSUyMGVudmlyb25tZW50JTIwYXJlJTIweW91JTIwcnVubmluZyUzRiUwQVRoaXMlMjBtYWNoaW5lJTBBLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUwQVdoaWNoJTIwdHlwZSUyMG9mJTIwbWFjaGluZSUyMGFyZSUyMHlvdSUyMHVzaW5nJTNGJTBBbXVsdGktR1BVJTBBSG93JTIwbWFueSUyMGRpZmZlcmVudCUyMG1hY2hpbmVzJTIwd2lsbCUyMHlvdSUyMHVzZSUyMCh1c2UlMjBtb3JlJTIwdGhhbiUyMDElMjBmb3IlMjBtdWx0aS1ub2RlJTIwdHJhaW5pbmcpJTNGJTIwJTVCMSU1RCUzQSUwQURvJTIweW91JTIwd2lzaCUyMHRvJTIwb3B0aW1pemUlMjB5b3VyJTIwc2NyaXB0JTIwd2l0aCUyMHRvcmNoJTIwZHluYW1vJTNGJTVCeWVzJTJGTk8lNUQlM0ElMEFEbyUyMHlvdSUyMHdhbnQlMjB0byUyMHVzZSUyMERlZXBTcGVlZCUzRiUyMCU1QnllcyUyRk5PJTVEJTNBJTIweWVzJTBBRG8lMjB5b3UlMjB3YW50JTIwdG8lMjBzcGVjaWZ5JTIwYSUyMGpzb24lMjBmaWxlJTIwdG8lMjBhJTIwRGVlcFNwZWVkJTIwY29uZmlnJTNGJTIwJTVCeWVzJTJGTk8lNUQlM0ElMjB5ZXMlMEFQbGVhc2UlMjBlbnRlciUyMHRoZSUyMHBhdGglMjB0byUyMHRoZSUyMGpzb24lMjBEZWVwU3BlZWQlMjBjb25maWclMjBmaWxlJTNBJTIwZHNfY29uZmlnLmpzb24lMEFEbyUyMHlvdSUyMHdhbnQlMjB0byUyMGVuYWJsZSUyMCU2MGRlZXBzcGVlZC56ZXJvLkluaXQlNjAlMjB3aGVuJTIwdXNpbmclMjBaZVJPJTIwU3RhZ2UtMyUyMGZvciUyMGNvbnN0cnVjdGluZyUyMG1hc3NpdmUlMjBtb2RlbHMlM0YlMjAlNUJ5ZXMlMkZOTyU1RCUzQSUyMHllcyUwQUhvdyUyMG1hbnklMjBHUFUocyklMjBzaG91bGQlMjBiZSUyMHVzZWQlMjBmb3IlMjBkaXN0cmlidXRlZCUyMHRyYWluaW5nJTNGJTIwJTVCMSU1RCUzQTQlMEFhY2NlbGVyYXRlJTIwY29uZmlndXJhdGlvbiUyMHNhdmVkJTIwYXQlMjBkc19jb25maWdfc2FtcGxlLnlhbWw=",highlighted:`$ accelerate config
-------------------------------------------------------------------------------------------------------------------------------
In <span class="hljs-built_in">which</span> compute environment are you running?
This machine
-------------------------------------------------------------------------------------------------------------------------------
Which <span class="hljs-built_in">type</span> of machine are you using?
multi-GPU
How many different machines will you use (use more than 1 <span class="hljs-keyword">for</span> multi-node training)? [1]:
Do you wish to optimize your script with torch dynamo?[<span class="hljs-built_in">yes</span>/NO]:
Do you want to use DeepSpeed? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
Do you want to specify a json file to a DeepSpeed config? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
Please enter the path to the json DeepSpeed config file: ds_config.json
Do you want to <span class="hljs-built_in">enable</span> \`deepspeed.zero.Init\` when using ZeRO Stage-3 <span class="hljs-keyword">for</span> constructing massive models? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
How many GPU(s) should be used <span class="hljs-keyword">for</span> distributed training? [1]:4
accelerate configuration saved at ds_config_sample.yaml`,wrap:!1}}),Ks=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwZHNfY29uZmlnLmpzb24lMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMERFRVBTUEVFRCUwQWRvd25jYXN0X2JmMTYlM0ElMjAnbm8nJTBBZHluYW1vX2JhY2tlbmQlM0ElMjAnTk8nJTBBZnNkcF9jb25maWclM0ElMjAlN0IlN0QlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtZWdhdHJvbl9sbV9jb25maWclM0ElMjAlN0IlN0QlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDQlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">deepspeed_config_file:</span> <span class="hljs-string">ds_config.json</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">dynamo_backend:</span> <span class="hljs-string">&#x27;NO&#x27;</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">megatron_lm_config:</span> {}
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),sl=new d({props:{code:"RGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUzQSUyMERFRVBTUEVFRCUyMCUyMEJhY2tlbmQlM0ElMjBuY2NsJTBBTnVtJTIwcHJvY2Vzc2VzJTNBJTIwNCUwQVByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFMb2NhbCUyMHByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFEZXZpY2UlM0ElMjBjdWRhJTNBMCUwQU1peGVkJTIwcHJlY2lzaW9uJTIwdHlwZSUzQSUyMGJmMTYlMEFkc19jb25maWclM0ElMjAlN0InYmYxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBUcnVlJTdEJTJDJTIwJ3plcm9fb3B0aW1pemF0aW9uJyUzQSUyMCU3QidzdGFnZSclM0ElMjAzJTJDJTIwJ3N0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJyUzQSUyMEZhbHNlJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyJyUzQSUyMCU3QidkZXZpY2UnJTNBJTIwJ25vbmUnJTdEJTJDJTIwJ29mZmxvYWRfcGFyYW0nJTNBJTIwJTdCJ2RldmljZSclM0ElMjAnbm9uZSclN0QlN0QlMkMlMjAnZ3JhZGllbnRfY2xpcHBpbmcnJTNBJTIwMS4wJTJDJTIwJ3RyYWluX2JhdGNoX3NpemUnJTNBJTIwJ2F1dG8nJTJDJTIwJ3RyYWluX21pY3JvX2JhdGNoX3NpemVfcGVyX2dwdSclM0ElMjAnYXV0byclMkMlMjAnZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJyUzQSUyMDEwJTJDJTIwJ3N0ZXBzX3Blcl9wcmludCclM0ElMjBpbmYlMkMlMjAnZnAxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBGYWxzZSU3RCU3RA==",highlighted:`Distributed environment: DEEPSPEED  Backend: nccl
Num processes: 4
Process index: 0
Local process index: 0
Device: cuda:0
Mixed precision <span class="hljs-built_in">type</span>: bf16
ds_config: {<span class="hljs-string">&#x27;bf16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: True}, <span class="hljs-string">&#x27;zero_optimization&#x27;</span>: {<span class="hljs-string">&#x27;stage&#x27;</span>: 3, <span class="hljs-string">&#x27;stage3_gather_16bit_weights_on_model_save&#x27;</span>: False, <span class="hljs-string">&#x27;offload_optimizer&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;none&#x27;</span>}, <span class="hljs-string">&#x27;offload_param&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;none&#x27;</span>}}, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>: 1.0, <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;train_micro_batch_size_per_gpu&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>: 10, <span class="hljs-string">&#x27;steps_per_print&#x27;</span>: inf, <span class="hljs-string">&#x27;fp16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: False}}`,wrap:!1}}),el=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX3BhcmFtJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGV2aWNlJTIyJTNBJTIwJTIyYXV0byUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2NsaXBwaW5nJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYWluX2JhdGNoX3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGVwc19wZXJfcHJpbnQlMjIlM0ElMjAyMDAwMDAwJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000000</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),al=new d({props:{code:"RGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUzQSUyMERFRVBTUEVFRCUyMCUyMEJhY2tlbmQlM0ElMjBuY2NsJTBBTnVtJTIwcHJvY2Vzc2VzJTNBJTIwNCUwQVByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFMb2NhbCUyMHByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFEZXZpY2UlM0ElMjBjdWRhJTNBMCUwQU1peGVkJTIwcHJlY2lzaW9uJTIwdHlwZSUzQSUyMGZwMTYlMEFkc19jb25maWclM0ElMjAlN0InYmYxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBGYWxzZSU3RCUyQyUyMCd6ZXJvX29wdGltaXphdGlvbiclM0ElMjAlN0Inc3RhZ2UnJTNBJTIwMyUyQyUyMCdzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSclM0ElMjBUcnVlJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyJyUzQSUyMCU3QidkZXZpY2UnJTNBJTIwJ252bWUnJTdEJTJDJTIwJ29mZmxvYWRfcGFyYW0nJTNBJTIwJTdCJ2RldmljZSclM0ElMjAnY3B1JyU3RCU3RCUyQyUyMCdncmFkaWVudF9jbGlwcGluZyclM0ElMjAxLjAlMkMlMjAndHJhaW5fYmF0Y2hfc2l6ZSclM0ElMjAnYXV0byclMkMlMjAndHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JyUzQSUyMCdhdXRvJyUyQyUyMCdncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMnJTNBJTIwNSUyQyUyMCdzdGVwc19wZXJfcHJpbnQnJTNBJTIwaW5mJTJDJTIwJ2ZwMTYnJTNBJTIwJTdCJ2VuYWJsZWQnJTNBJTIwVHJ1ZSUyQyUyMCdhdXRvX2Nhc3QnJTNBJTIwVHJ1ZSU3RCU3RA==",highlighted:`Distributed environment: DEEPSPEED  Backend: nccl
Num processes: 4
Process index: 0
Local process index: 0
Device: cuda:0
Mixed precision <span class="hljs-built_in">type</span>: fp16
ds_config: {<span class="hljs-string">&#x27;bf16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: False}, <span class="hljs-string">&#x27;zero_optimization&#x27;</span>: {<span class="hljs-string">&#x27;stage&#x27;</span>: 3, <span class="hljs-string">&#x27;stage3_gather_16bit_weights_on_model_save&#x27;</span>: True, <span class="hljs-string">&#x27;offload_optimizer&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;nvme&#x27;</span>}, <span class="hljs-string">&#x27;offload_param&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>}}, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>: 1.0, <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;train_micro_batch_size_per_gpu&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>: 5, <span class="hljs-string">&#x27;steps_per_print&#x27;</span>: inf, <span class="hljs-string">&#x27;fp16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: True, <span class="hljs-string">&#x27;auto_cast&#x27;</span>: True}}`,wrap:!1}}),cl=new d({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQSUwQSUyMyUyME5ldyUyMENvZGUlMjAlMjMlMEElMjMlMjBTYXZlcyUyMHRoZSUyMHdob2xlJTJGdW5wYXJ0aXRpb25lZCUyMGZwMTYlMjBtb2RlbCUyMHdoZW4lMjBpbiUyMFplUk8lMjBTdGFnZS0zJTIwdG8lMjB0aGUlMjBvdXRwdXQlMjBkaXJlY3RvcnklMjBpZiUwQSUyMyUyMCU2MHN0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJTYwJTIwaXMlMjBUcnVlJTIwaW4lMjBEZWVwU3BlZWQlMjBDb25maWclMjBmaWxlJTIwb3IlMEElMjMlMjAlNjB6ZXJvM19zYXZlXzE2Yml0X21vZGVsJTYwJTIwaXMlMjBUcnVlJTIwaW4lMjBEZWVwU3BlZWQlMjBQbHVnaW4uJTBBJTIzJTIwRm9yJTIwWmVybyUyMFN0YWdlcyUyMDElMjBhbmQlMjAyJTJDJTIwbW9kZWxzJTIwYXJlJTIwc2F2ZWQlMjBhcyUyMHVzdWFsJTIwaW4lMjB0aGUlMjBvdXRwdXQlMjBkaXJlY3RvcnkuJTBBJTIzJTIwVGhlJTIwbW9kZWwlMjBuYW1lJTIwc2F2ZWQlMjBpcyUyMCU2MHB5dG9yY2hfbW9kZWwuYmluJTYwJTBBdW53cmFwcGVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBhcmdzLm91dHB1dF9kaXIlMkMlMEElMjAlMjAlMjAlMjBpc19tYWluX3Byb2Nlc3MlM0RhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlMkMlMEElMjAlMjAlMjAlMjBzYXZlX2Z1bmN0aW9uJTNEYWNjZWxlcmF0b3Iuc2F2ZSUyQyUwQSUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlM0RhY2NlbGVyYXRvci5nZXRfc3RhdGVfZGljdChtb2RlbCklMkMlMEEp",highlighted:`unwrapped_model = accelerator.unwrap_model(model)

<span class="hljs-comment"># New Code #</span>
<span class="hljs-comment"># Saves the whole/unpartitioned fp16 model when in ZeRO Stage-3 to the output directory if</span>
<span class="hljs-comment"># \`stage3_gather_16bit_weights_on_model_save\` is True in DeepSpeed Config file or</span>
<span class="hljs-comment"># \`zero3_save_16bit_model\` is True in DeepSpeed Plugin.</span>
<span class="hljs-comment"># For Zero Stages 1 and 2, models are saved as usual in the output directory.</span>
<span class="hljs-comment"># The model name saved is \`pytorch_model.bin\`</span>
unwrapped_model.save_pretrained(
    args.output_dir,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
    state_dict=accelerator.get_state_dict(model),
)`,wrap:!1}}),Ml=new d({props:{code:"c3VjY2VzcyUyMCUzRCUyMG1vZGVsLnNhdmVfY2hlY2twb2ludChQQVRIJTJDJTIwY2twdF9pZCUyQyUyMGNoZWNrcG9pbnRfc3RhdGVfZGljdCklMEFzdGF0dXNfbXNnJTIwJTNEJTIwZiUyMmNoZWNrcG9pbnRpbmclM0ElMjBQQVRIJTNEJTdCUEFUSCU3RCUyQyUyMGNrcHRfaWQlM0QlN0Jja3B0X2lkJTdEJTIyJTBBaWYlMjBzdWNjZXNzJTNBJTBBJTIwJTIwJTIwJTIwbG9nZ2luZy5pbmZvKGYlMjJTdWNjZXNzJTIwJTdCc3RhdHVzX21zZyU3RCUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwbG9nZ2luZy53YXJuaW5nKGYlMjJGYWlsdXJlJTIwJTdCc3RhdHVzX21zZyU3RCUyMik=",highlighted:`success = model.save_checkpoint(PATH, ckpt_id, checkpoint_state_dict)
status_msg = <span class="hljs-string">f&quot;checkpointing: PATH=<span class="hljs-subst">{PATH}</span>, ckpt_id=<span class="hljs-subst">{ckpt_id}</span>&quot;</span>
<span class="hljs-keyword">if</span> success:
    logging.info(<span class="hljs-string">f&quot;Success <span class="hljs-subst">{status_msg}</span>&quot;</span>)
<span class="hljs-keyword">else</span>:
    logging.warning(<span class="hljs-string">f&quot;Failure <span class="hljs-subst">{status_msg}</span>&quot;</span>)`,wrap:!1}}),ol=new d({props:{code:"JTI0JTIwY2QlMjAlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50X2RpciUwQSUyNCUyMC4lMkZ6ZXJvX3RvX2ZwMzIucHklMjAuJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEFQcm9jZXNzaW5nJTIwemVybyUyMGNoZWNrcG9pbnQlMjBhdCUyMGdsb2JhbF9zdGVwMSUwQURldGVjdGVkJTIwY2hlY2twb2ludCUyMG9mJTIwdHlwZSUyMHplcm8lMjBzdGFnZSUyMDMlMkMlMjB3b3JsZF9zaXplJTNBJTIwMiUwQVNhdmluZyUyMGZwMzIlMjBzdGF0ZSUyMGRpY3QlMjB0byUyMHB5dG9yY2hfbW9kZWwuYmluJTIwKHRvdGFsX251bWVsJTNENjA1MDY2MjQp",highlighted:`$ <span class="hljs-built_in">cd</span> /path/to/checkpoint_dir
$ ./zero_to_fp32.py . pytorch_model.bin
Processing zero checkpoint at global_step1
Detected checkpoint of <span class="hljs-built_in">type</span> zero stage 3, world_size: 2
Saving fp32 state dict to pytorch_model.bin (total_numel=60506624)`,wrap:!1}}),ul=new d({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQlMEElMEF1bndyYXBwZWRfbW9kZWwlMjAlM0QlMjBhY2NlbGVyYXRvci51bndyYXBfbW9kZWwobW9kZWwpJTBBZnAzMl9tb2RlbCUyMCUzRCUyMGxvYWRfc3RhdGVfZGljdF9mcm9tX3plcm9fY2hlY2twb2ludCh1bndyYXBwZWRfbW9kZWwlMkMlMjBjaGVja3BvaW50X2Rpcik=",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

unwrapped_model = accelerator.unwrap_model(model)
fp32_model = load_state_dict_from_zero_checkpoint(unwrapped_model, checkpoint_dir)`,wrap:!1}}),rl=new d({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBnZXRfZnAzMl9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBc3RhdGVfZGljdCUyMCUzRCUyMGdldF9mcDMyX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQoY2hlY2twb2ludF9kaXIp",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> get_fp32_state_dict_from_zero_checkpoint

state_dict = get_fp32_state_dict_from_zero_checkpoint(checkpoint_dir)`,wrap:!1}}),jl=new d({props:{code:"bW9kZWwlMkMlMjBldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwZXZhbF9kYXRhbG9hZGVyKQ==",highlighted:"model, eval_dataloader = accelerator.prepare(model, eval_dataloader)",wrap:!1}}),W=new xn({props:{$$slots:{default:[Qn]},$$scope:{ctx:kl}}}),bl=new En({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/deepspeed.md"}}),{c(){T=p("meta"),X=a(),f=p("p"),Cl=a(),M(N.$$.fragment),Fl=a(),S=p("p"),S.innerHTML=na,ql=a(),G=p("ol"),G.innerHTML=pa,Hl=a(),v=p("p"),v.innerHTML=ia,$l=a(),V=p("p"),V.textContent=ca,Ll=a(),A=p("p"),A.textContent=Ma,Dl=a(),Y=p("p"),Y.innerHTML=oa,Pl=a(),z=p("ol"),z.innerHTML=ua,Ol=a(),M(R.$$.fragment),Kl=a(),x=p("p"),x.textContent=ra,st=a(),E=p("ol"),E.innerHTML=ya,lt=a(),Q=p("p"),Q.innerHTML=ja,tt=a(),k=p("p"),k.innerHTML=Ja,et=a(),F=p("p"),F.innerHTML=da,at=a(),q=p("p"),q.innerHTML=ha,nt=a(),H=p("p"),H.innerHTML=wa,pt=a(),$=p("p"),$.innerHTML=Ta,it=a(),L=p("p"),L.innerHTML=Ua,ct=a(),D=p("u"),D.textContent=ma,Mt=Yn(`: With respect to Disk Offload, the disk should be an NVME for decent speed but it technically works on any Disk
`),P=p("p"),P.textContent=fa,ot=a(),O=p("ol"),O.innerHTML=ba,ut=a(),M(K.$$.fragment),rt=a(),ss=p("p"),ss.innerHTML=Ia,yt=a(),ls=p("p"),ls.innerHTML=Za,jt=a(),M(ts.$$.fragment),Jt=a(),es=p("p"),es.textContent=Ca,dt=a(),M(as.$$.fragment),ht=a(),ns=p("p"),ns.textContent=_a,wt=a(),M(ps.$$.fragment),Tt=a(),is=p("p"),is.innerHTML=Ba,Ut=a(),cs=p("p"),cs.innerHTML=ga,mt=a(),M(Ms.$$.fragment),ft=a(),M(os.$$.fragment),bt=a(),us=p("p"),us.innerHTML=Wa,It=a(),M(rs.$$.fragment),Zt=a(),M(ys.$$.fragment),Ct=a(),js=p("p"),js.innerHTML=Xa,_t=a(),M(Js.$$.fragment),Bt=a(),ds=p("p"),ds.textContent=Na,gt=a(),M(hs.$$.fragment),Wt=a(),ws=p("p"),ws.textContent=Sa,Xt=a(),M(Ts.$$.fragment),Nt=a(),Us=p("p"),Us.textContent=Ga,St=a(),M(ms.$$.fragment),Gt=a(),fs=p("p"),fs.innerHTML=va,vt=a(),bs=p("p"),bs.innerHTML=Va,Vt=a(),M(Is.$$.fragment),At=a(),Zs=p("p"),Zs.innerHTML=Aa,Yt=a(),M(Cs.$$.fragment),zt=a(),M(_s.$$.fragment),Rt=a(),Bs=p("p"),Bs.innerHTML=Ya,xt=a(),M(gs.$$.fragment),Et=a(),Ws=p("p"),Ws.innerHTML=za,Qt=a(),M(Xs.$$.fragment),kt=a(),M(Ns.$$.fragment),Ft=a(),Ss=p("p"),Ss.innerHTML=Ra,qt=a(),M(Gs.$$.fragment),Ht=a(),vs=p("p"),vs.innerHTML=xa,$t=a(),Vs=p("p"),Vs.innerHTML=Ea,Lt=a(),b=p("ol"),U=p("li"),_l=p("p"),_l.innerHTML=Qa,xe=a(),Bl=p("p"),Bl.innerHTML=ka,Ee=a(),M(As.$$.fragment),Qe=a(),gl=p("p"),gl.innerHTML=Fa,ke=a(),Wl=p("p"),Wl.innerHTML=qa,Fe=a(),Xl=p("p"),Xl.innerHTML=Ha,qe=a(),Nl=p("li"),Nl.innerHTML=$a,Dt=a(),Ys=p("p"),Ys.innerHTML=La,Pt=a(),zs=p("ul"),zs.innerHTML=Da,Ot=a(),Rs=p("p"),Rs.innerHTML=Pa,Kt=a(),xs=p("p"),xs.innerHTML=Oa,se=a(),Es=p("p"),Es.innerHTML=Ka,le=a(),Qs=p("p"),Qs.innerHTML=sn,te=a(),M(ks.$$.fragment),ee=a(),Fs=p("p"),Fs.innerHTML=ln,ae=a(),qs=p("ol"),qs.innerHTML=tn,ne=a(),M(Hs.$$.fragment),pe=a(),I=p("ol"),I.innerHTML=en,ie=a(),M($s.$$.fragment),ce=a(),Z=p("ol"),Z.innerHTML=an,Me=a(),M(Ls.$$.fragment),oe=a(),Ds=p("p"),Ds.innerHTML=nn,ue=a(),Ps=p("ol"),Ps.innerHTML=pn,re=a(),M(Os.$$.fragment),ye=a(),C=p("ol"),C.innerHTML=cn,je=a(),M(Ks.$$.fragment),Je=a(),_=p("ol"),_.innerHTML=Mn,de=a(),M(sl.$$.fragment),he=a(),ll=p("p"),ll.innerHTML=on,we=a(),tl=p("ol"),tl.innerHTML=un,Te=a(),M(el.$$.fragment),Ue=a(),B=p("ol"),B.innerHTML=rn,me=a(),M(al.$$.fragment),fe=a(),nl=p("p"),nl.innerHTML=yn,be=a(),pl=p("ol"),pl.innerHTML=jn,Ie=a(),il=p("p"),il.textContent=Jn,Ze=a(),g=p("ol"),Sl=p("li"),Sl.innerHTML=dn,He=a(),h=p("li"),Gl=p("p"),Gl.innerHTML=hn,$e=a(),vl=p("p"),vl.innerHTML=wn,Le=a(),M(cl.$$.fragment),De=a(),Vl=p("p"),Vl.innerHTML=Tn,Pe=a(),M(Ml.$$.fragment),Oe=a(),Al=p("p"),Al.innerHTML=Un,Ke=a(),M(ol.$$.fragment),sa=a(),Yl=p("p"),Yl.textContent=mn,la=a(),M(ul.$$.fragment),ta=a(),zl=p("p"),zl.innerHTML=fn,ea=a(),M(rl.$$.fragment),aa=a(),Rl=p("p"),Rl.textContent=bn,Ce=a(),yl=p("p"),yl.textContent=In,_e=a(),M(jl.$$.fragment),Be=a(),Jl=p("p"),Jl.textContent=Zn,ge=a(),dl=p("ol"),dl.innerHTML=Cn,We=a(),hl=p("p"),hl.textContent=_n,Xe=a(),wl=p("p"),wl.innerHTML=Bn,Ne=a(),Tl=p("ul"),Tl.innerHTML=gn,Se=a(),Ul=p("p"),Ul.textContent=Wn,Ge=a(),ml=p("ul"),ml.innerHTML=Xn,ve=a(),fl=p("p"),fl.innerHTML=Nn,Ve=a(),M(W.$$.fragment),Ae=a(),M(bl.$$.fragment),Ye=a(),El=p("p"),this.h()},l(s){const l=zn("svelte-u9bgzb",document.head);T=i(l,"META",{name:!0,content:!0}),l.forEach(t),X=n(s),f=i(s,"P",{}),xl(f).forEach(t),Cl=n(s),o(N.$$.fragment,s),Fl=n(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1ittrjc"&&(S.innerHTML=na),ql=n(s),G=i(s,"OL",{"data-svelte-h":!0}),c(G)!=="svelte-3z90ra"&&(G.innerHTML=pa),Hl=n(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1ipy5tt"&&(v.innerHTML=ia),$l=n(s),V=i(s,"P",{"data-svelte-h":!0}),c(V)!=="svelte-iaccrf"&&(V.textContent=ca),Ll=n(s),A=i(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-l1xxpu"&&(A.textContent=Ma),Dl=n(s),Y=i(s,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1j8gyyc"&&(Y.innerHTML=oa),Pl=n(s),z=i(s,"OL",{"data-svelte-h":!0}),c(z)!=="svelte-15nzigp"&&(z.innerHTML=ua),Ol=n(s),o(R.$$.fragment,s),Kl=n(s),x=i(s,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1igpel8"&&(x.textContent=ra),st=n(s),E=i(s,"OL",{"data-svelte-h":!0}),c(E)!=="svelte-1nija55"&&(E.innerHTML=ya),lt=n(s),Q=i(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-134sd43"&&(Q.innerHTML=ja),tt=n(s),k=i(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1d4qqra"&&(k.innerHTML=Ja),et=n(s),F=i(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-n0e1lo"&&(F.innerHTML=da),at=n(s),q=i(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1ob4qwq"&&(q.innerHTML=ha),nt=n(s),H=i(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-f1y4d9"&&(H.innerHTML=wa),pt=n(s),$=i(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-1sgbcs5"&&($.innerHTML=Ta),it=n(s),L=i(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-yiw0au"&&(L.innerHTML=Ua),ct=n(s),D=i(s,"U",{"data-svelte-h":!0}),c(D)!=="svelte-248d1k"&&(D.textContent=ma),Mt=Rn(s,`: With respect to Disk Offload, the disk should be an NVME for decent speed but it technically works on any Disk
`),P=i(s,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1i9b1jx"&&(P.textContent=fa),ot=n(s),O=i(s,"OL",{"data-svelte-h":!0}),c(O)!=="svelte-yjfbl7"&&(O.innerHTML=ba),ut=n(s),o(K.$$.fragment,s),rt=n(s),ss=i(s,"P",{"data-svelte-h":!0}),c(ss)!=="svelte-1wpffgu"&&(ss.innerHTML=Ia),yt=n(s),ls=i(s,"P",{"data-svelte-h":!0}),c(ls)!=="svelte-yplg2o"&&(ls.innerHTML=Za),jt=n(s),o(ts.$$.fragment,s),Jt=n(s),es=i(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-3pof6s"&&(es.textContent=Ca),dt=n(s),o(as.$$.fragment,s),ht=n(s),ns=i(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-1ik26hy"&&(ns.textContent=_a),wt=n(s),o(ps.$$.fragment,s),Tt=n(s),is=i(s,"P",{"data-svelte-h":!0}),c(is)!=="svelte-10u1bf7"&&(is.innerHTML=Ba),Ut=n(s),cs=i(s,"P",{"data-svelte-h":!0}),c(cs)!=="svelte-vp1nym"&&(cs.innerHTML=ga),mt=n(s),o(Ms.$$.fragment,s),ft=n(s),o(os.$$.fragment,s),bt=n(s),us=i(s,"P",{"data-svelte-h":!0}),c(us)!=="svelte-12x21g8"&&(us.innerHTML=Wa),It=n(s),o(rs.$$.fragment,s),Zt=n(s),o(ys.$$.fragment,s),Ct=n(s),js=i(s,"P",{"data-svelte-h":!0}),c(js)!=="svelte-lh95an"&&(js.innerHTML=Xa),_t=n(s),o(Js.$$.fragment,s),Bt=n(s),ds=i(s,"P",{"data-svelte-h":!0}),c(ds)!=="svelte-1spmm13"&&(ds.textContent=Na),gt=n(s),o(hs.$$.fragment,s),Wt=n(s),ws=i(s,"P",{"data-svelte-h":!0}),c(ws)!=="svelte-3pof6s"&&(ws.textContent=Sa),Xt=n(s),o(Ts.$$.fragment,s),Nt=n(s),Us=i(s,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-1vp75xs"&&(Us.textContent=Ga),St=n(s),o(ms.$$.fragment,s),Gt=n(s),fs=i(s,"P",{"data-svelte-h":!0}),c(fs)!=="svelte-17th5u9"&&(fs.innerHTML=va),vt=n(s),bs=i(s,"P",{"data-svelte-h":!0}),c(bs)!=="svelte-1l59g75"&&(bs.innerHTML=Va),Vt=n(s),o(Is.$$.fragment,s),At=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),c(Zs)!=="svelte-1iv8u1c"&&(Zs.innerHTML=Aa),Yt=n(s),o(Cs.$$.fragment,s),zt=n(s),o(_s.$$.fragment,s),Rt=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),c(Bs)!=="svelte-3yuze5"&&(Bs.innerHTML=Ya),xt=n(s),o(gs.$$.fragment,s),Et=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),c(Ws)!=="svelte-15nfwtv"&&(Ws.innerHTML=za),Qt=n(s),o(Xs.$$.fragment,s),kt=n(s),o(Ns.$$.fragment,s),Ft=n(s),Ss=i(s,"P",{"data-svelte-h":!0}),c(Ss)!=="svelte-1cyo8oc"&&(Ss.innerHTML=Ra),qt=n(s),o(Gs.$$.fragment,s),Ht=n(s),vs=i(s,"P",{"data-svelte-h":!0}),c(vs)!=="svelte-14gqfge"&&(vs.innerHTML=xa),$t=n(s),Vs=i(s,"P",{"data-svelte-h":!0}),c(Vs)!=="svelte-1y80l2"&&(Vs.innerHTML=Ea),Lt=n(s),b=i(s,"OL",{});var Il=xl(b);U=i(Il,"LI",{});var m=xl(U);_l=i(m,"P",{"data-svelte-h":!0}),c(_l)!=="svelte-19wri7m"&&(_l.innerHTML=Qa),xe=n(m),Bl=i(m,"P",{"data-svelte-h":!0}),c(Bl)!=="svelte-1w1lp0n"&&(Bl.innerHTML=ka),Ee=n(m),o(As.$$.fragment,m),Qe=n(m),gl=i(m,"P",{"data-svelte-h":!0}),c(gl)!=="svelte-ce0g29"&&(gl.innerHTML=Fa),ke=n(m),Wl=i(m,"P",{"data-svelte-h":!0}),c(Wl)!=="svelte-fgwfk1"&&(Wl.innerHTML=qa),Fe=n(m),Xl=i(m,"P",{"data-svelte-h":!0}),c(Xl)!=="svelte-jof0o2"&&(Xl.innerHTML=Ha),m.forEach(t),qe=n(Il),Nl=i(Il,"LI",{"data-svelte-h":!0}),c(Nl)!=="svelte-1k2nlfe"&&(Nl.innerHTML=$a),Il.forEach(t),Dt=n(s),Ys=i(s,"P",{"data-svelte-h":!0}),c(Ys)!=="svelte-1nruzcp"&&(Ys.innerHTML=La),Pt=n(s),zs=i(s,"UL",{"data-svelte-h":!0}),c(zs)!=="svelte-12xd0n5"&&(zs.innerHTML=Da),Ot=n(s),Rs=i(s,"P",{"data-svelte-h":!0}),c(Rs)!=="svelte-1d6bbd1"&&(Rs.innerHTML=Pa),Kt=n(s),xs=i(s,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-nnfxti"&&(xs.innerHTML=Oa),se=n(s),Es=i(s,"P",{"data-svelte-h":!0}),c(Es)!=="svelte-2eh81g"&&(Es.innerHTML=Ka),le=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-1r2ikm1"&&(Qs.innerHTML=sn),te=n(s),o(ks.$$.fragment,s),ee=n(s),Fs=i(s,"P",{"data-svelte-h":!0}),c(Fs)!=="svelte-23a28o"&&(Fs.innerHTML=ln),ae=n(s),qs=i(s,"OL",{"data-svelte-h":!0}),c(qs)!=="svelte-835v9i"&&(qs.innerHTML=tn),ne=n(s),o(Hs.$$.fragment,s),pe=n(s),I=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(I)!=="svelte-1f7op2x"&&(I.innerHTML=en),ie=n(s),o($s.$$.fragment,s),ce=n(s),Z=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(Z)!=="svelte-czp5cr"&&(Z.innerHTML=an),Me=n(s),o(Ls.$$.fragment,s),oe=n(s),Ds=i(s,"P",{"data-svelte-h":!0}),c(Ds)!=="svelte-57upna"&&(Ds.innerHTML=nn),ue=n(s),Ps=i(s,"OL",{"data-svelte-h":!0}),c(Ps)!=="svelte-jop1mq"&&(Ps.innerHTML=pn),re=n(s),o(Os.$$.fragment,s),ye=n(s),C=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(C)!=="svelte-w41hdb"&&(C.innerHTML=cn),je=n(s),o(Ks.$$.fragment,s),Je=n(s),_=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(_)!=="svelte-czp5cr"&&(_.innerHTML=Mn),de=n(s),o(sl.$$.fragment,s),he=n(s),ll=i(s,"P",{"data-svelte-h":!0}),c(ll)!=="svelte-s6le15"&&(ll.innerHTML=on),we=n(s),tl=i(s,"OL",{"data-svelte-h":!0}),c(tl)!=="svelte-q77lu7"&&(tl.innerHTML=un),Te=n(s),o(el.$$.fragment,s),Ue=n(s),B=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(B)!=="svelte-18b0p9"&&(B.innerHTML=rn),me=n(s),o(al.$$.fragment,s),fe=n(s),nl=i(s,"P",{"data-svelte-h":!0}),c(nl)!=="svelte-pxb0rv"&&(nl.innerHTML=yn),be=n(s),pl=i(s,"OL",{"data-svelte-h":!0}),c(pl)!=="svelte-1x5f67y"&&(pl.innerHTML=jn),Ie=n(s),il=i(s,"P",{"data-svelte-h":!0}),c(il)!=="svelte-zlzk05"&&(il.textContent=Jn),Ze=n(s),g=i(s,"OL",{});var Re=xl(g);Sl=i(Re,"LI",{"data-svelte-h":!0}),c(Sl)!=="svelte-1ix3dy3"&&(Sl.innerHTML=dn),He=n(Re),h=i(Re,"LI",{});var w=xl(h);Gl=i(w,"P",{"data-svelte-h":!0}),c(Gl)!=="svelte-1vo2i9p"&&(Gl.innerHTML=hn),$e=n(w),vl=i(w,"P",{"data-svelte-h":!0}),c(vl)!=="svelte-hk8fhr"&&(vl.innerHTML=wn),Le=n(w),o(cl.$$.fragment,w),De=n(w),Vl=i(w,"P",{"data-svelte-h":!0}),c(Vl)!=="svelte-1ddq7v6"&&(Vl.innerHTML=Tn),Pe=n(w),o(Ml.$$.fragment,w),Oe=n(w),Al=i(w,"P",{"data-svelte-h":!0}),c(Al)!=="svelte-hmvopk"&&(Al.innerHTML=Un),Ke=n(w),o(ol.$$.fragment,w),sa=n(w),Yl=i(w,"P",{"data-svelte-h":!0}),c(Yl)!=="svelte-1hbu42f"&&(Yl.textContent=mn),la=n(w),o(ul.$$.fragment,w),ta=n(w),zl=i(w,"P",{"data-svelte-h":!0}),c(zl)!=="svelte-h6u0m6"&&(zl.innerHTML=fn),ea=n(w),o(rl.$$.fragment,w),aa=n(w),Rl=i(w,"P",{"data-svelte-h":!0}),c(Rl)!=="svelte-13dj8kw"&&(Rl.textContent=bn),w.forEach(t),Re.forEach(t),Ce=n(s),yl=i(s,"P",{"data-svelte-h":!0}),c(yl)!=="svelte-goe3ae"&&(yl.textContent=In),_e=n(s),o(jl.$$.fragment,s),Be=n(s),Jl=i(s,"P",{"data-svelte-h":!0}),c(Jl)!=="svelte-1ka9ilq"&&(Jl.textContent=Zn),ge=n(s),dl=i(s,"OL",{"data-svelte-h":!0}),c(dl)!=="svelte-rz68fo"&&(dl.innerHTML=Cn),We=n(s),hl=i(s,"P",{"data-svelte-h":!0}),c(hl)!=="svelte-dt51zu"&&(hl.textContent=_n),Xe=n(s),wl=i(s,"P",{"data-svelte-h":!0}),c(wl)!=="svelte-1aiu2sl"&&(wl.innerHTML=Bn),Ne=n(s),Tl=i(s,"UL",{"data-svelte-h":!0}),c(Tl)!=="svelte-qibs9v"&&(Tl.innerHTML=gn),Se=n(s),Ul=i(s,"P",{"data-svelte-h":!0}),c(Ul)!=="svelte-1pnpyer"&&(Ul.textContent=Wn),Ge=n(s),ml=i(s,"UL",{"data-svelte-h":!0}),c(ml)!=="svelte-b1iyxy"&&(ml.innerHTML=Xn),ve=n(s),fl=i(s,"P",{"data-svelte-h":!0}),c(fl)!=="svelte-kyi5s0"&&(fl.innerHTML=Nn),Ve=n(s),o(W.$$.fragment,s),Ae=n(s),o(bl.$$.fragment,s),Ye=n(s),El=i(s,"P",{}),xl(El).forEach(t),this.h()},h(){Zl(T,"name","hf:doc:metadata"),Zl(T,"content",Fn),Zl(I,"start","2"),Zl(Z,"start","3"),Zl(C,"start","2"),Zl(_,"start","3"),Zl(B,"start","2")},m(s,l){J(document.head,T),e(s,X,l),e(s,f,l),e(s,Cl,l),u(N,s,l),e(s,Fl,l),e(s,S,l),e(s,ql,l),e(s,G,l),e(s,Hl,l),e(s,v,l),e(s,$l,l),e(s,V,l),e(s,Ll,l),e(s,A,l),e(s,Dl,l),e(s,Y,l),e(s,Pl,l),e(s,z,l),e(s,Ol,l),u(R,s,l),e(s,Kl,l),e(s,x,l),e(s,st,l),e(s,E,l),e(s,lt,l),e(s,Q,l),e(s,tt,l),e(s,k,l),e(s,et,l),e(s,F,l),e(s,at,l),e(s,q,l),e(s,nt,l),e(s,H,l),e(s,pt,l),e(s,$,l),e(s,it,l),e(s,L,l),e(s,ct,l),e(s,D,l),e(s,Mt,l),e(s,P,l),e(s,ot,l),e(s,O,l),e(s,ut,l),u(K,s,l),e(s,rt,l),e(s,ss,l),e(s,yt,l),e(s,ls,l),e(s,jt,l),u(ts,s,l),e(s,Jt,l),e(s,es,l),e(s,dt,l),u(as,s,l),e(s,ht,l),e(s,ns,l),e(s,wt,l),u(ps,s,l),e(s,Tt,l),e(s,is,l),e(s,Ut,l),e(s,cs,l),e(s,mt,l),u(Ms,s,l),e(s,ft,l),u(os,s,l),e(s,bt,l),e(s,us,l),e(s,It,l),u(rs,s,l),e(s,Zt,l),u(ys,s,l),e(s,Ct,l),e(s,js,l),e(s,_t,l),u(Js,s,l),e(s,Bt,l),e(s,ds,l),e(s,gt,l),u(hs,s,l),e(s,Wt,l),e(s,ws,l),e(s,Xt,l),u(Ts,s,l),e(s,Nt,l),e(s,Us,l),e(s,St,l),u(ms,s,l),e(s,Gt,l),e(s,fs,l),e(s,vt,l),e(s,bs,l),e(s,Vt,l),u(Is,s,l),e(s,At,l),e(s,Zs,l),e(s,Yt,l),u(Cs,s,l),e(s,zt,l),u(_s,s,l),e(s,Rt,l),e(s,Bs,l),e(s,xt,l),u(gs,s,l),e(s,Et,l),e(s,Ws,l),e(s,Qt,l),u(Xs,s,l),e(s,kt,l),u(Ns,s,l),e(s,Ft,l),e(s,Ss,l),e(s,qt,l),u(Gs,s,l),e(s,Ht,l),e(s,vs,l),e(s,$t,l),e(s,Vs,l),e(s,Lt,l),e(s,b,l),J(b,U),J(U,_l),J(U,xe),J(U,Bl),J(U,Ee),u(As,U,null),J(U,Qe),J(U,gl),J(U,ke),J(U,Wl),J(U,Fe),J(U,Xl),J(b,qe),J(b,Nl),e(s,Dt,l),e(s,Ys,l),e(s,Pt,l),e(s,zs,l),e(s,Ot,l),e(s,Rs,l),e(s,Kt,l),e(s,xs,l),e(s,se,l),e(s,Es,l),e(s,le,l),e(s,Qs,l),e(s,te,l),u(ks,s,l),e(s,ee,l),e(s,Fs,l),e(s,ae,l),e(s,qs,l),e(s,ne,l),u(Hs,s,l),e(s,pe,l),e(s,I,l),e(s,ie,l),u($s,s,l),e(s,ce,l),e(s,Z,l),e(s,Me,l),u(Ls,s,l),e(s,oe,l),e(s,Ds,l),e(s,ue,l),e(s,Ps,l),e(s,re,l),u(Os,s,l),e(s,ye,l),e(s,C,l),e(s,je,l),u(Ks,s,l),e(s,Je,l),e(s,_,l),e(s,de,l),u(sl,s,l),e(s,he,l),e(s,ll,l),e(s,we,l),e(s,tl,l),e(s,Te,l),u(el,s,l),e(s,Ue,l),e(s,B,l),e(s,me,l),u(al,s,l),e(s,fe,l),e(s,nl,l),e(s,be,l),e(s,pl,l),e(s,Ie,l),e(s,il,l),e(s,Ze,l),e(s,g,l),J(g,Sl),J(g,He),J(g,h),J(h,Gl),J(h,$e),J(h,vl),J(h,Le),u(cl,h,null),J(h,De),J(h,Vl),J(h,Pe),u(Ml,h,null),J(h,Oe),J(h,Al),J(h,Ke),u(ol,h,null),J(h,sa),J(h,Yl),J(h,la),u(ul,h,null),J(h,ta),J(h,zl),J(h,ea),u(rl,h,null),J(h,aa),J(h,Rl),e(s,Ce,l),e(s,yl,l),e(s,_e,l),u(jl,s,l),e(s,Be,l),e(s,Jl,l),e(s,ge,l),e(s,dl,l),e(s,We,l),e(s,hl,l),e(s,Xe,l),e(s,wl,l),e(s,Ne,l),e(s,Tl,l),e(s,Se,l),e(s,Ul,l),e(s,Ge,l),e(s,ml,l),e(s,ve,l),e(s,fl,l),e(s,Ve,l),u(W,s,l),e(s,Ae,l),u(bl,s,l),e(s,Ye,l),e(s,El,l),ze=!0},p(s,[l]){const Il={};l&2&&(Il.$$scope={dirty:l,ctx:s}),W.$set(Il)},i(s){ze||(r(N.$$.fragment,s),r(R.$$.fragment,s),r(K.$$.fragment,s),r(ts.$$.fragment,s),r(as.$$.fragment,s),r(ps.$$.fragment,s),r(Ms.$$.fragment,s),r(os.$$.fragment,s),r(rs.$$.fragment,s),r(ys.$$.fragment,s),r(Js.$$.fragment,s),r(hs.$$.fragment,s),r(Ts.$$.fragment,s),r(ms.$$.fragment,s),r(Is.$$.fragment,s),r(Cs.$$.fragment,s),r(_s.$$.fragment,s),r(gs.$$.fragment,s),r(Xs.$$.fragment,s),r(Ns.$$.fragment,s),r(Gs.$$.fragment,s),r(As.$$.fragment,s),r(ks.$$.fragment,s),r(Hs.$$.fragment,s),r($s.$$.fragment,s),r(Ls.$$.fragment,s),r(Os.$$.fragment,s),r(Ks.$$.fragment,s),r(sl.$$.fragment,s),r(el.$$.fragment,s),r(al.$$.fragment,s),r(cl.$$.fragment,s),r(Ml.$$.fragment,s),r(ol.$$.fragment,s),r(ul.$$.fragment,s),r(rl.$$.fragment,s),r(jl.$$.fragment,s),r(W.$$.fragment,s),r(bl.$$.fragment,s),ze=!0)},o(s){y(N.$$.fragment,s),y(R.$$.fragment,s),y(K.$$.fragment,s),y(ts.$$.fragment,s),y(as.$$.fragment,s),y(ps.$$.fragment,s),y(Ms.$$.fragment,s),y(os.$$.fragment,s),y(rs.$$.fragment,s),y(ys.$$.fragment,s),y(Js.$$.fragment,s),y(hs.$$.fragment,s),y(Ts.$$.fragment,s),y(ms.$$.fragment,s),y(Is.$$.fragment,s),y(Cs.$$.fragment,s),y(_s.$$.fragment,s),y(gs.$$.fragment,s),y(Xs.$$.fragment,s),y(Ns.$$.fragment,s),y(Gs.$$.fragment,s),y(As.$$.fragment,s),y(ks.$$.fragment,s),y(Hs.$$.fragment,s),y($s.$$.fragment,s),y(Ls.$$.fragment,s),y(Os.$$.fragment,s),y(Ks.$$.fragment,s),y(sl.$$.fragment,s),y(el.$$.fragment,s),y(al.$$.fragment,s),y(cl.$$.fragment,s),y(Ml.$$.fragment,s),y(ol.$$.fragment,s),y(ul.$$.fragment,s),y(rl.$$.fragment,s),y(jl.$$.fragment,s),y(W.$$.fragment,s),y(bl.$$.fragment,s),ze=!1},d(s){s&&(t(X),t(f),t(Cl),t(Fl),t(S),t(ql),t(G),t(Hl),t(v),t($l),t(V),t(Ll),t(A),t(Dl),t(Y),t(Pl),t(z),t(Ol),t(Kl),t(x),t(st),t(E),t(lt),t(Q),t(tt),t(k),t(et),t(F),t(at),t(q),t(nt),t(H),t(pt),t($),t(it),t(L),t(ct),t(D),t(Mt),t(P),t(ot),t(O),t(ut),t(rt),t(ss),t(yt),t(ls),t(jt),t(Jt),t(es),t(dt),t(ht),t(ns),t(wt),t(Tt),t(is),t(Ut),t(cs),t(mt),t(ft),t(bt),t(us),t(It),t(Zt),t(Ct),t(js),t(_t),t(Bt),t(ds),t(gt),t(Wt),t(ws),t(Xt),t(Nt),t(Us),t(St),t(Gt),t(fs),t(vt),t(bs),t(Vt),t(At),t(Zs),t(Yt),t(zt),t(Rt),t(Bs),t(xt),t(Et),t(Ws),t(Qt),t(kt),t(Ft),t(Ss),t(qt),t(Ht),t(vs),t($t),t(Vs),t(Lt),t(b),t(Dt),t(Ys),t(Pt),t(zs),t(Ot),t(Rs),t(Kt),t(xs),t(se),t(Es),t(le),t(Qs),t(te),t(ee),t(Fs),t(ae),t(qs),t(ne),t(pe),t(I),t(ie),t(ce),t(Z),t(Me),t(oe),t(Ds),t(ue),t(Ps),t(re),t(ye),t(C),t(je),t(Je),t(_),t(de),t(he),t(ll),t(we),t(tl),t(Te),t(Ue),t(B),t(me),t(fe),t(nl),t(be),t(pl),t(Ie),t(il),t(Ze),t(g),t(Ce),t(yl),t(_e),t(Be),t(Jl),t(ge),t(dl),t(We),t(hl),t(Xe),t(wl),t(Ne),t(Tl),t(Se),t(Ul),t(Ge),t(ml),t(ve),t(fl),t(Ve),t(Ae),t(Ye),t(El)),t(T),j(N,s),j(R,s),j(K,s),j(ts,s),j(as,s),j(ps,s),j(Ms,s),j(os,s),j(rs,s),j(ys,s),j(Js,s),j(hs,s),j(Ts,s),j(ms,s),j(Is,s),j(Cs,s),j(_s,s),j(gs,s),j(Xs,s),j(Ns,s),j(Gs,s),j(As),j(ks,s),j(Hs,s),j($s,s),j(Ls,s),j(Os,s),j(Ks,s),j(sl,s),j(el,s),j(al,s),j(cl),j(Ml),j(ol),j(ul),j(rl),j(jl,s),j(W,s),j(bl,s)}}}const Fn='{"title":"DeepSpeed","local":"deepspeed","sections":[{"title":"What is integrated?","local":"what-is-integrated","sections":[],"depth":2},{"title":"How it works?","local":"how-it-works","sections":[{"title":"Accelerate DeepSpeed Plugin","local":"accelerate-deepspeed-plugin","sections":[],"depth":3},{"title":"DeepSpeed Config File","local":"deepspeed-config-file","sections":[],"depth":3}],"depth":2}],"depth":1}';function qn(kl){return Gn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class On extends Vn{constructor(T){super(),An(this,T,qn,kn,Sn,{})}}export{On as component};
