import{s as $n,f as zn,o as In,n as Ke}from"../chunks/scheduler.25b97de1.js";import{S as xn,i as Wn,g as l,s as n,r as h,A as jn,h as d,f as t,c as a,j as I,u as p,x as b,k as w,y as i,a as s,v as u,d as f,t as g,w as _}from"../chunks/index.d9030fc9.js";import{T as mt}from"../chunks/Tip.baa67368.js";import{D as U}from"../chunks/Docstring.ffac8efa.js";import{C as Oe}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Yt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as J,E as Un}from"../chunks/EditOnGithub.91d95064.js";function Gn(C){let r,T='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',c,y,v='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){r=l("p"),r.innerHTML=T,c=n(),y=l("p"),y.innerHTML=v},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-nz63kd"&&(r.innerHTML=T),c=a(m),y=d(m,"P",{"data-svelte-h":!0}),b(y)!=="svelte-aze40l"&&(y.innerHTML=v)},m(m,M){s(m,r,M),s(m,c,M),s(m,y,M)},p:Ke,d(m){m&&(t(r),t(c),t(y))}}}function Zn(C){let r,T;return r=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbk1vZGVsJTJDJTIwQ2hhbWVsZW9uQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMGNoYW1lbGVvbiUyMGNoYW1lbGVvbi03YiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDaGFtZWxlb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjaGFtZWxlb24tN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonModel, ChameleonConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a chameleon chameleon-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ChameleonConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the chameleon-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ChameleonModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(r.$$.fragment)},l(c){p(r.$$.fragment,c)},m(c,y){u(r,c,y),T=!0},p:Ke,i(c){T||(f(r.$$.fragment,c),T=!0)},o(c){g(r.$$.fragment,c),T=!1},d(c){_(r,c)}}}function Vn(C){let r,T=`Although the recipe for forward pass needs to be defined within
this function, one should call the <code>Module</code> instance afterwards
instead of this since the former takes care of running the
registered hooks while the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=T},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-rqqap8"&&(r.innerHTML=T)},m(c,y){s(c,r,y)},p:Ke,d(c){c&&t(r)}}}function Bn(C){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=T},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(c,y){s(c,r,y)},p:Ke,d(c){c&&t(r)}}}function Nn(C){let r,T="Example:",c,y,v;return y=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDaGFtZWxlb25Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YSUyRmNoYW1lbGVvbi03YiUyMiklMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtZXRhJTJGY2hhbWVsZW9uLTdiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ChameleonModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta/chameleon-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ChameleonModel.from_pretrained(<span class="hljs-string">&quot;meta/chameleon-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){r=l("p"),r.textContent=T,c=n(),h(y.$$.fragment)},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-11lpom8"&&(r.textContent=T),c=a(m),p(y.$$.fragment,m)},m(m,M){s(m,r,M),s(m,c,M),u(y,m,M),v=!0},p:Ke,i(m){v||(f(y.$$.fragment,m),v=!0)},o(m){g(y.$$.fragment,m),v=!1},d(m){m&&(t(r),t(c)),_(y,m)}}}function Fn(C){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=T},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(c,y){s(c,r,y)},p:Ke,d(c){c&&t(r)}}}function Rn(C){let r,T="Example:",c,y,v;return y=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvblByb2Nlc3NvciUyQyUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXByb2Nlc3NvciUyMCUzRCUyMENoYW1lbGVvblByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySSUyMHVzZWQlMjB0byUyMGtub3clMjBhJTIwbG90JTIwYWJvdXQlMjBjb25zdGVsbGF0aW9ucyUyMHdoZW4lMjBJJTIwd2FzJTIweW91bmdlciUyQyUyMGJ1dCUyMGFzJTIwSSUyMGdyZXclMjBvbGRlciUyQyUyMEklMjBmb3Jnb3QlMjBtb3N0JTIwb2YlMjB3aGF0JTIwSSUyMGtuZXcuJTIwVGhlc2UlMjBhcmUlMjB0aGUlMjBvbmx5JTIwdHdvJTIwY29uc3RlbGxhdGlvbnMlMjB0aGF0JTIwSSUyMHJlYWxseSUyMHJlbWVtYmVyJTIwbm93LiUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0VJJTIwd291bGQlMjBsaWtlJTIwZm9yJTIweW91JTIwdG8lMjB0ZWxsJTIwbWUlMjBhYm91dCUyMDMlMjBtb3JlJTIwY29uc3RlbGxhdGlvbnMlMjBhbmQlMjBnaXZlJTIwbWUlMjBhJTIwbGl0dGxlJTIwYml0JTIwb2YlMjBoaXN0b3J5JTIwYWJvdXQlMjB0aGUlMjBjb25zdGVsbGF0aW9uLiUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoJTIyaHR0cHMlM0ElMkYlMkZuaW5lcGxhbmV0cy5vcmclMkZ3cC1jb250ZW50JTJGdXBsb2FkcyUyRjIwMjAlMkYxMiUyRnRoZS1iaWctZGlwcGVyLTEuanBnJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCglMjJodHRwcyUzQSUyRiUyRnd3dy5reGFuLmNvbSUyRndwLWNvbnRlbnQlMkZ1cGxvYWRzJTJGc2l0ZXMlMkY0MCUyRjIwMjAlMkYxMCUyRk9SSU9OLmpwZyUyMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0JTJDJTIwaW1hZ2VzJTNEJTVCaW1hZ2UlMkMlMjBpbWFnZV8yJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlJTJDJTIwdG9yY2guYmZsb2F0MTYpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMDAlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSklMEFwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;I used to know a lot about constellations when I was younger, but as I grew older, I forgot most of what I knew. These are the only two constellations that I really remember now.&lt;image&gt;&lt;image&gt;I would like for you to tell me about 3 more constellations and give me a little bit of history about the constellation.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(<span class="hljs-string">&quot;https://nineplanets.org/wp-content/uploads/2020/12/the-big-dipper-1.jpg&quot;</span>, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(<span class="hljs-string">&quot;https://www.kxan.com/wp-content/uploads/sites/40/2020/10/ORION.jpg&quot;</span>, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, images=[image, image_2], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=T,c=n(),h(y.$$.fragment)},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-11lpom8"&&(r.textContent=T),c=a(m),p(y.$$.fragment,m)},m(m,M){s(m,r,M),s(m,c,M),u(y,m,M),v=!0},p:Ke,i(m){v||(f(y.$$.fragment,m),v=!0)},o(m){g(y.$$.fragment,m),v=!1},d(m){m&&(t(r),t(c)),_(y,m)}}}function Pn(C){let r,T,c,y,v,m,M,wo,ae,Lt='The Chameleon model was proposed in <a href="https://arxiv.org/abs/2405.09818v1" rel="nofollow">Chameleon: Mixed-Modal Early-Fusion Foundation Models</a> by META AI Chameleon Team. Chameleon is a Vision-Language Model that use vector quantization to tokenize images which enables the model to generate multimodal output. The model takes images and texts as input, including an interleaved format, and generates textual response. Image generation module is not released yet.',Co,se,Xt="The abstract from the paper is the following:",Jo,re,Qt=`<em>We present Chameleon, a family of early-fusion token-based mixed-modal models capable of understanding and generating images and text in any arbitrary sequence. We outline a stable training
approach from inception, an alignment recipe, and an architectural parameterization tailored for the
early-fusion, token-based, mixed-modal setting. The models are evaluated on a comprehensive range
of tasks, including visual question answering, image captioning, text generation, image generation, and
long-form mixed modal generation. Chameleon demonstrates broad and general capabilities, including
state-of-the-art performance in image captioning tasks, outperforms Llama-2 in text-only tasks while
being competitive with models such as Mixtral 8x7B and Gemini-Pro, and performs non-trivial image
generation, all in a single model. It also matches or exceeds the performance of much larger models,
including Gemini Pro and GPT-4V, according to human judgments on a new long-form mixed-modal
generation evaluation, where either the prompt or outputs contain mixed sequences of both images and
text. Chameleon marks a significant step forward in unified modeling of full multimodal documents</em>`,ko,q,St,$o,ie,At='Chameleon incorporates a vector quantizer module to transform images into discrete tokens. That also enables image generation using an auto-regressive transformer. Taken from the <a href="https://arxiv.org/abs/2405.09818v1">original paper.</a>',zo,le,Dt=`This model was contributed by <a href="https://huggingface.co/joaogante" rel="nofollow">joaogante</a> and <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/facebookresearch/chameleon" rel="nofollow">here</a>.`,Io,de,xo,ce,Ot="<li><p>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to set <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</p></li> <li><p>Note that Chameleon was tuned for safety alignment. If the model is refusing to answer, consider asking a more concrete question, instead of an open question.</p></li> <li><p>Chameleon generates in chat format which means that the generated text will always be the “assistant’s turn”. You can enable a text completion generation by passing <code>return_for_text_completion=True</code> when calling the processor.</p></li>",Wo,me,Kt=`<p>[!NOTE]
Chameleon implementation in Transformers uses a special image token to indicate where to merge image embeddings. For special image token we didn’t add a new one but used one of the reserved tokens: <code>&lt;reserved08707&gt;</code>. You have to add <code>&lt;image&gt;</code> to your prompt in the place where the image should be embedded for correct generation.</p>`,jo,he,Uo,pe,Go,ue,en=`Chameleon is a gated model so make sure to have access and login to Hugging Face Hub using a token.
Here’s how to load the model and perform inference in half-precision (<code>torch.bfloat16</code>):`,Zo,fe,Vo,ge,Bo,_e,on="Chameleon can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). Here is how you can do it:",No,be,Fo,ye,Ro,Te,Po,ve,tn="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code> and to have access to a GPU/accelerator that is supported by the library.",Ho,E,qo,Me,nn="Simply change the snippet above with:",Eo,we,Yo,Ce,Lo,Je,an='The models supports both, Flash-Attention 2 and PyTorch’s <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> which can be enables for optimization. SDPA is the default options when you load the model, If you want to switch for Flash Attention 2, first make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository</a> regarding that package installation. Simply change the snippet above with:',Xo,ke,Qo,$e,So,x,ze,ht,eo,sn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a>. It is used to instantiate a
chameleon model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/meta/chameleon-7B" rel="nofollow">meta/chameleon-7B</a>.`,pt,oo,rn=`Configuration objects inherit from <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ut,Y,Ao,Ie,Do,P,xe,ft,to,ln=`This is the configuration class to store the configuration of a <code>ChameleonVQModel</code>. It is used to instantiate a
<code>ChameleonVQModel</code> according to the specified arguments, defining the model architecture.
Configuration objects inherit from <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a
configuration with the defaults will yield a similar configuration to the VQModel of the
<a href="https://huggingface.co/meta/chameleon-7B" rel="nofollow">meta/chameleon-7B</a>.`,Oo,We,Ko,k,je,gt,no,dn=`Constructs a Chameleon processor which wraps a Chameleon image processor and a Chameleon tokenizer into a single
processor.`,_t,ao,cn=`<a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonProcessor">ChameleonProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonImageProcessor">ChameleonImageProcessor</a> and <a href="/docs/transformers/pr_31098/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>.
See the <code>__call__()</code> and <a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonProcessor.decode">decode()</a> for more information.`,bt,L,Ue,yt,so,mn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Tt,X,Ge,vt,ro,hn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,et,Ze,ot,B,Ve,Mt,io,pn="Constructs a Chameleon image processor.",wt,Q,Be,Ct,lo,un="Preprocess an image or batch of images.",tt,Ne,nt,$,Fe,Jt,co,fn=`The VQ-VAE model used in Chameleon for encoding/decoding images into discrete tokens.
This model follows the “Make-a-scene: Scene-based text-to-image generation with human priors” paper from
<a href="https://arxiv.org/abs/2203.13131" rel="nofollow">Oran Gafni, Adam Polyak, Oron Ashual, Shelly Sheynin, Devi Parikh, and Yaniv Taigman</a>.`,kt,mo,gn=`This model inherits from <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,$t,ho,_n=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zt,G,Re,It,po,bn="Define the computation performed at every call.",xt,uo,yn="Should be overridden by all subclasses.",Wt,S,at,Pe,st,z,He,jt,fo,Tn=`The bare chameleon Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ut,go,vn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Gt,_o,Mn="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>ChameleonDecoderLayer</code>",Zt,Z,qe,Vt,bo,wn='The <a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a> forward method, overrides the <code>__call__</code> special method.',Bt,A,Nt,D,rt,Ee,it,W,Ye,Ft,yo,Cn=`Chameleon Model with a head on top used for outputting logits for next token prediction.
This model inherits from <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Rt,To,Jn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pt,V,Le,Ht,vo,kn='The <a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonForConditionalGeneration">ChameleonForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',qt,O,Et,K,lt,Xe,dt,Mo,ct;return v=new J({props:{title:"Chameleon",local:"chameleon",headingTag:"h1"}}),M=new J({props:{title:"Overview",local:"overview",headingTag:"h2"}}),de=new J({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),he=new J({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),pe=new J({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),fe=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvblByb2Nlc3NvciUyQyUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBDaGFtZWxlb25Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGY2hhbWVsZW9uLTdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ2hhbWVsZW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmNoYW1lbGVvbi03YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiklMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMjBhbmQlMjB0ZXh0JTIwcHJvbXB0JTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyV2hhdCUyMGRvJTIweW91JTIwc2VlJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlM0NpbWFnZSUzRSUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjBpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBJTBBJTIzJTIwYXV0b3JlZ3Jlc3NpdmVseSUyMGNvbXBsZXRlJTIwcHJvbXB0JTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwKSUwQXByaW50KHByb2Nlc3Nvci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)
model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt</span>
url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;What do you see in this image?&lt;image&gt;&quot;</span>

inputs = processor(prompt, image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, dtype=torch.bfloat16)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ge=new J({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),be=new Oe({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)

model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batched prompt, where the first one is a multi-image prompt and the second is not</span>
prompts = [
    <span class="hljs-string">&quot;What do these images have in common?&lt;image&gt;&lt;image&gt;&quot;</span>,
    <span class="hljs-string">&quot;&lt;image&gt;What is shown in this image?&quot;</span>
]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
<span class="hljs-comment"># Each &quot;&lt;image&gt;&quot; token uses one image leaving the next for the subsequent &quot;&lt;image&gt;&quot; tokens</span>
inputs = processor(text=prompts, images=[image_stop, image_cats, image_snowman], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)`,wrap:!1}}),ye=new J({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),Te=new J({props:{title:"Quantization using Bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),E=new mt({props:{$$slots:{default:[Gn]},$$scope:{ctx:C}}}),we=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQSUyMyUyMHNwZWNpZnklMjBob3clMjB0byUyMHF1YW50aXplJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQ2hhbWVsZW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmNoYW1lbGVvbi03YiUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)

model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ce=new J({props:{title:"Use Flash-Attention 2 and SDPA to further speed-up generation",local:"use-flash-attention-2-and-sdpa-to-further-speed-up-generation",headingTag:"h3"}}),ke=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIlMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwbG93X2NwdV9tZW1fdXNhZ2UlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonForConditionalGeneration

model_id = <span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>
model = ChameleonForConditionalGeneration.from_pretrained(
    model_id, 
    torch_dtype=torch.bfloat16, 
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),$e=new J({props:{title:"ChameleonConfig",local:"transformers.ChameleonConfig",headingTag:"h2"}}),ze=new U({props:{name:"class transformers.ChameleonConfig",anchor:"transformers.ChameleonConfig",parameters:[{name:"vocab_size",val:" = 65536"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = 32"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"model_parallel_size",val:" = 1"},{name:"swin_norm",val:" = False"},{name:"vq_config",val:" = None"},{name:"vocabulary_map",val:" = None"},{name:"mlp_bias",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65536) &#x2014;
Vocabulary size of the chameleon model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a>; this includes text and image tokens.`,name:"vocab_size"},{anchor:"transformers.ChameleonConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.ChameleonConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.ChameleonConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.ChameleonConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.ChameleonConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.ChameleonConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.ChameleonConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Chameleon supports up to 4096 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.ChameleonConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ChameleonConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.ChameleonConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.ChameleonConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.ChameleonConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.ChameleonConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.ChameleonConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.ChameleonConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.ChameleonConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/Localchameleon/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/Localchameleon/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.ChameleonConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.ChameleonConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.ChameleonConfig.model_parallel_size",description:`<strong>model_parallel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of shards used when training the model. This will be used in qk layernorm because the original Chameleon inference
doesn&#x2019;t do reduction in those layers and each rank has its own biases.`,name:"model_parallel_size"},{anchor:"transformers.ChameleonConfig.swin_norm",description:`<strong>swin_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Use Swin Transformer normalization.`,name:"swin_norm"},{anchor:"transformers.ChameleonConfig.vq_config",description:`<strong>vq_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
ChameleonVQConfig instance containing the configuration for the VQ-VAE model.`,name:"vq_config"},{anchor:"transformers.ChameleonConfig.vocabulary_map",description:`<strong>vocabulary_map</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary containing the vocabulary map from the tokenizer. Used to obtain tokens from the image inputs.`,name:"vocabulary_map"},{anchor:"transformers.ChameleonConfig.mlp_bias",description:`<strong>mlp_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in up_proj, down_proj and gate_proj layers in the MLP layers.`,name:"mlp_bias"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/configuration_chameleon.py#L99"}}),Y=new Yt({props:{anchor:"transformers.ChameleonConfig.example",$$slots:{default:[Zn]},$$scope:{ctx:C}}}),Ie=new J({props:{title:"ChameleonVQVAEConfig",local:"transformers.ChameleonVQVAEConfig",headingTag:"h2"}}),xe=new U({props:{name:"class transformers.ChameleonVQVAEConfig",anchor:"transformers.ChameleonVQVAEConfig",parameters:[{name:"embed_dim",val:": int = 256"},{name:"num_embeddings",val:": int = 8192"},{name:"double_latent",val:": bool = False"},{name:"latent_channels",val:": int = 256"},{name:"resolution",val:": int = 512"},{name:"in_channels",val:": int = 3"},{name:"base_channels",val:": int = 128"},{name:"channel_multiplier",val:": List = [1, 1, 2, 2, 4]"},{name:"num_res_blocks",val:": int = 2"},{name:"attn_resolutions",val:": List = None"},{name:"dropout",val:": float = 0.0"},{name:"attn_type",val:": str = 'vanilla'"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonVQVAEConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of each embedding vector.`,name:"embed_dim"},{anchor:"transformers.ChameleonVQVAEConfig.num_embeddings",description:`<strong>num_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Number of codebook embeddings.`,name:"num_embeddings"},{anchor:"transformers.ChameleonVQVAEConfig.double_latent",description:`<strong>double_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use double z channels.`,name:"double_latent"},{anchor:"transformers.ChameleonVQVAEConfig.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Number of channels for the latent space.`,name:"latent_channels"},{anchor:"transformers.ChameleonVQVAEConfig.resolution",description:`<strong>resolution</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Resolution of the input images.`,name:"resolution"},{anchor:"transformers.ChameleonVQVAEConfig.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of input channels.`,name:"in_channels"},{anchor:"transformers.ChameleonVQVAEConfig.base_channels",description:`<strong>base_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Base channel count.`,name:"base_channels"},{anchor:"transformers.ChameleonVQVAEConfig.channel_multiplier",description:`<strong>channel_multiplier</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 1, 2, 2, 4]</code>) &#x2014;
Channel multipliers for each resolution.`,name:"channel_multiplier"},{anchor:"transformers.ChameleonVQVAEConfig.num_res_blocks",description:`<strong>num_res_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of residual blocks.`,name:"num_res_blocks"},{anchor:"transformers.ChameleonVQVAEConfig.attn_resolutions",description:`<strong>attn_resolutions</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Resolutions to apply attention.`,name:"attn_resolutions"},{anchor:"transformers.ChameleonVQVAEConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout rate.`,name:"dropout"},{anchor:"transformers.ChameleonVQVAEConfig.attn_type",description:`<strong>attn_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;vanilla&quot;</code>) &#x2014;
Attention type used in VQ-GAN encoder. Can be &#x201C;vanilla&#x201D; or None.`,name:"attn_type"},{anchor:"transformers.ChameleonVQVAEConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/configuration_chameleon.py#L26"}}),We=new J({props:{title:"ChameleonProcessor",local:"transformers.ChameleonProcessor",headingTag:"h2"}}),je=new U({props:{name:"class transformers.ChameleonProcessor",anchor:"transformers.ChameleonProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"image_seq_length",val:": int = 1024"},{name:"image_token",val:": str = '<image>'"}],parametersDescription:[{anchor:"transformers.ChameleonProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonImageProcessor">ChameleonImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.ChameleonProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_31098/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.ChameleonProcessor.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.ChameleonProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
The special token used to indicate image in the text.`,name:"image_token"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/processing_chameleon.py#L28"}}),Ue=new U({props:{name:"batch_decode",anchor:"transformers.ChameleonProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/processing_chameleon.py#L142"}}),Ge=new U({props:{name:"decode",anchor:"transformers.ChameleonProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/processing_chameleon.py#L150"}}),Ze=new J({props:{title:"ChameleonImageProcessor",local:"transformers.ChameleonImageProcessor",headingTag:"h2"}}),Ve=new U({props:{name:"class transformers.ChameleonImageProcessor",anchor:"transformers.ChameleonImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = 1"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.0078"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.ChameleonImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 512}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.ChameleonImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to 1) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.ChameleonImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.ChameleonImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to {&#x201C;height&#x201D; &#x2014; 512, &#x201C;width&#x201D;: 512}):
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.ChameleonImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.ChameleonImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to 0.0078) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.ChameleonImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.ChameleonImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[1.0, 1.0, 1.0]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.ChameleonImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[1.0, 1.0, 1.0]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.ChameleonImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/image_processing_chameleon.py#L70"}}),Be=new U({props:{name:"preprocess",anchor:"transformers.ChameleonImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.ChameleonImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.ChameleonImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.ChameleonImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.ChameleonImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.ChameleonImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.ChameleonImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.ChameleonImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.ChameleonImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.ChameleonImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.ChameleonImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/image_processing_chameleon.py#L194"}}),Ne=new J({props:{title:"ChameleonVQVAE",local:"transformers.ChameleonVQVAE",headingTag:"h2"}}),Fe=new U({props:{name:"class transformers.ChameleonVQVAE",anchor:"transformers.ChameleonVQVAE",parameters:[{name:"config",val:": ChameleonVQVAEConfig"}],parametersDescription:[{anchor:"transformers.ChameleonVQVAE.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonVQVAEConfig">ChameleonVQVAEConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/modeling_chameleon.py#L1045"}}),Re=new U({props:{name:"_forward_unimplemented",anchor:"transformers.ChameleonVQVAE.forward",parameters:[{name:"*input",val:": Any"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/torch/nn/modules/module.py#L341"}}),S=new mt({props:{$$slots:{default:[Vn]},$$scope:{ctx:C}}}),Pe=new J({props:{title:"ChameleonModel",local:"transformers.ChameleonModel",headingTag:"h2"}}),He=new U({props:{name:"class transformers.ChameleonModel",anchor:"transformers.ChameleonModel",parameters:[{name:"config",val:": ChameleonConfig"}],parametersDescription:[{anchor:"transformers.ChameleonModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonConfig">ChameleonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; ChameleonConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/modeling_chameleon.py#L1248"}}),qe=new U({props:{name:"forward",anchor:"transformers.ChameleonModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ChameleonModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ChameleonModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_31098/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor.__call__">ChameleonImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.ChameleonModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ChameleonModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ChameleonModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Should always be a <a href="/docs/transformers/pr_31098/en/internal/generation_utils#transformers.Cache">Cache</a> instance and the model will output the same cache instance.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ChameleonModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ChameleonModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ChameleonModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ChameleonModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ChameleonModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31098/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ChameleonModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/modeling_chameleon.py#L1300",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31098/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonConfig"
>ChameleonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31098/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new mt({props:{$$slots:{default:[Bn]},$$scope:{ctx:C}}}),D=new Yt({props:{anchor:"transformers.ChameleonModel.forward.example",$$slots:{default:[Nn]},$$scope:{ctx:C}}}),Ee=new J({props:{title:"ChameleonForConditionalGeneration",local:"transformers.ChameleonForConditionalGeneration",headingTag:"h2"}}),Ye=new U({props:{name:"class transformers.ChameleonForConditionalGeneration",anchor:"transformers.ChameleonForConditionalGeneration",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ChameleonForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonConfig">ChameleonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/modeling_chameleon.py#L1496"}}),Le=new U({props:{name:"forward",anchor:"transformers.ChameleonForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"cache_position",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ChameleonForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_31098/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor.__call__">ChameleonImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_31098/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Should always be a <a href="/docs/transformers/pr_31098/en/internal/generation_utils#transformers.Cache">Cache</a> instance and the model will output the same cache instance.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31098/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/chameleon/modeling_chameleon.py#L1530",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_31098/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_31098/en/model_doc/chameleon#transformers.ChameleonConfig"
>ChameleonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_31098/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new mt({props:{$$slots:{default:[Fn]},$$scope:{ctx:C}}}),K=new Yt({props:{anchor:"transformers.ChameleonForConditionalGeneration.forward.example",$$slots:{default:[Rn]},$$scope:{ctx:C}}}),Xe=new Un({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/chameleon.md"}}),{c(){r=l("meta"),T=n(),c=l("p"),y=n(),h(v.$$.fragment),m=n(),h(M.$$.fragment),wo=n(),ae=l("p"),ae.innerHTML=Lt,Co=n(),se=l("p"),se.textContent=Xt,Jo=n(),re=l("p"),re.innerHTML=Qt,ko=n(),q=l("img"),$o=n(),ie=l("small"),ie.innerHTML=At,zo=n(),le=l("p"),le.innerHTML=Dt,Io=n(),h(de.$$.fragment),xo=n(),ce=l("ul"),ce.innerHTML=Ot,Wo=n(),me=l("blockquote"),me.innerHTML=Kt,jo=n(),h(he.$$.fragment),Uo=n(),h(pe.$$.fragment),Go=n(),ue=l("p"),ue.innerHTML=en,Zo=n(),h(fe.$$.fragment),Vo=n(),h(ge.$$.fragment),Bo=n(),_e=l("p"),_e.textContent=on,No=n(),h(be.$$.fragment),Fo=n(),h(ye.$$.fragment),Ro=n(),h(Te.$$.fragment),Po=n(),ve=l("p"),ve.innerHTML=tn,Ho=n(),h(E.$$.fragment),qo=n(),Me=l("p"),Me.textContent=nn,Eo=n(),h(we.$$.fragment),Yo=n(),h(Ce.$$.fragment),Lo=n(),Je=l("p"),Je.innerHTML=an,Xo=n(),h(ke.$$.fragment),Qo=n(),h($e.$$.fragment),So=n(),x=l("div"),h(ze.$$.fragment),ht=n(),eo=l("p"),eo.innerHTML=sn,pt=n(),oo=l("p"),oo.innerHTML=rn,ut=n(),h(Y.$$.fragment),Ao=n(),h(Ie.$$.fragment),Do=n(),P=l("div"),h(xe.$$.fragment),ft=n(),to=l("p"),to.innerHTML=ln,Oo=n(),h(We.$$.fragment),Ko=n(),k=l("div"),h(je.$$.fragment),gt=n(),no=l("p"),no.textContent=dn,_t=n(),ao=l("p"),ao.innerHTML=cn,bt=n(),L=l("div"),h(Ue.$$.fragment),yt=n(),so=l("p"),so.innerHTML=mn,Tt=n(),X=l("div"),h(Ge.$$.fragment),vt=n(),ro=l("p"),ro.innerHTML=hn,et=n(),h(Ze.$$.fragment),ot=n(),B=l("div"),h(Ve.$$.fragment),Mt=n(),io=l("p"),io.textContent=pn,wt=n(),Q=l("div"),h(Be.$$.fragment),Ct=n(),lo=l("p"),lo.textContent=un,tt=n(),h(Ne.$$.fragment),nt=n(),$=l("div"),h(Fe.$$.fragment),Jt=n(),co=l("p"),co.innerHTML=fn,kt=n(),mo=l("p"),mo.innerHTML=gn,$t=n(),ho=l("p"),ho.innerHTML=_n,zt=n(),G=l("div"),h(Re.$$.fragment),It=n(),po=l("p"),po.textContent=bn,xt=n(),uo=l("p"),uo.textContent=yn,Wt=n(),h(S.$$.fragment),at=n(),h(Pe.$$.fragment),st=n(),z=l("div"),h(He.$$.fragment),jt=n(),fo=l("p"),fo.innerHTML=Tn,Ut=n(),go=l("p"),go.innerHTML=vn,Gt=n(),_o=l("p"),_o.innerHTML=Mn,Zt=n(),Z=l("div"),h(qe.$$.fragment),Vt=n(),bo=l("p"),bo.innerHTML=wn,Bt=n(),h(A.$$.fragment),Nt=n(),h(D.$$.fragment),rt=n(),h(Ee.$$.fragment),it=n(),W=l("div"),h(Ye.$$.fragment),Ft=n(),yo=l("p"),yo.innerHTML=Cn,Rt=n(),To=l("p"),To.innerHTML=Jn,Pt=n(),V=l("div"),h(Le.$$.fragment),Ht=n(),vo=l("p"),vo.innerHTML=kn,qt=n(),h(O.$$.fragment),Et=n(),h(K.$$.fragment),lt=n(),h(Xe.$$.fragment),dt=n(),Mo=l("p"),this.h()},l(e){const o=jn("svelte-u9bgzb",document.head);r=d(o,"META",{name:!0,content:!0}),o.forEach(t),T=a(e),c=d(e,"P",{}),I(c).forEach(t),y=a(e),p(v.$$.fragment,e),m=a(e),p(M.$$.fragment,e),wo=a(e),ae=d(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-nqrocv"&&(ae.innerHTML=Lt),Co=a(e),se=d(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-vfdo9a"&&(se.textContent=Xt),Jo=a(e),re=d(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-b403ub"&&(re.innerHTML=Qt),ko=a(e),q=d(e,"IMG",{src:!0,alt:!0,width:!0}),$o=a(e),ie=d(e,"SMALL",{"data-svelte-h":!0}),b(ie)!=="svelte-tuggwl"&&(ie.innerHTML=At),zo=a(e),le=d(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-18is37e"&&(le.innerHTML=Dt),Io=a(e),p(de.$$.fragment,e),xo=a(e),ce=d(e,"UL",{"data-svelte-h":!0}),b(ce)!=="svelte-1xww0u5"&&(ce.innerHTML=Ot),Wo=a(e),me=d(e,"BLOCKQUOTE",{"data-svelte-h":!0}),b(me)!=="svelte-1buypb9"&&(me.innerHTML=Kt),jo=a(e),p(he.$$.fragment,e),Uo=a(e),p(pe.$$.fragment,e),Go=a(e),ue=d(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-1mp252t"&&(ue.innerHTML=en),Zo=a(e),p(fe.$$.fragment,e),Vo=a(e),p(ge.$$.fragment,e),Bo=a(e),_e=d(e,"P",{"data-svelte-h":!0}),b(_e)!=="svelte-55qtep"&&(_e.textContent=on),No=a(e),p(be.$$.fragment,e),Fo=a(e),p(ye.$$.fragment,e),Ro=a(e),p(Te.$$.fragment,e),Po=a(e),ve=d(e,"P",{"data-svelte-h":!0}),b(ve)!=="svelte-1y3bqqy"&&(ve.innerHTML=tn),Ho=a(e),p(E.$$.fragment,e),qo=a(e),Me=d(e,"P",{"data-svelte-h":!0}),b(Me)!=="svelte-gwf9h7"&&(Me.textContent=nn),Eo=a(e),p(we.$$.fragment,e),Yo=a(e),p(Ce.$$.fragment,e),Lo=a(e),Je=d(e,"P",{"data-svelte-h":!0}),b(Je)!=="svelte-131jlth"&&(Je.innerHTML=an),Xo=a(e),p(ke.$$.fragment,e),Qo=a(e),p($e.$$.fragment,e),So=a(e),x=d(e,"DIV",{class:!0});var N=I(x);p(ze.$$.fragment,N),ht=a(N),eo=d(N,"P",{"data-svelte-h":!0}),b(eo)!=="svelte-18r67nv"&&(eo.innerHTML=sn),pt=a(N),oo=d(N,"P",{"data-svelte-h":!0}),b(oo)!=="svelte-1eopo2z"&&(oo.innerHTML=rn),ut=a(N),p(Y.$$.fragment,N),N.forEach(t),Ao=a(e),p(Ie.$$.fragment,e),Do=a(e),P=d(e,"DIV",{class:!0});var Qe=I(P);p(xe.$$.fragment,Qe),ft=a(Qe),to=d(Qe,"P",{"data-svelte-h":!0}),b(to)!=="svelte-1jgteev"&&(to.innerHTML=ln),Qe.forEach(t),Oo=a(e),p(We.$$.fragment,e),Ko=a(e),k=d(e,"DIV",{class:!0});var j=I(k);p(je.$$.fragment,j),gt=a(j),no=d(j,"P",{"data-svelte-h":!0}),b(no)!=="svelte-8u0vzv"&&(no.textContent=dn),_t=a(j),ao=d(j,"P",{"data-svelte-h":!0}),b(ao)!=="svelte-7ol4cn"&&(ao.innerHTML=cn),bt=a(j),L=d(j,"DIV",{class:!0});var Se=I(L);p(Ue.$$.fragment,Se),yt=a(Se),so=d(Se,"P",{"data-svelte-h":!0}),b(so)!=="svelte-1xebko3"&&(so.innerHTML=mn),Se.forEach(t),Tt=a(j),X=d(j,"DIV",{class:!0});var Ae=I(X);p(Ge.$$.fragment,Ae),vt=a(Ae),ro=d(Ae,"P",{"data-svelte-h":!0}),b(ro)!=="svelte-1w1zri5"&&(ro.innerHTML=hn),Ae.forEach(t),j.forEach(t),et=a(e),p(Ze.$$.fragment,e),ot=a(e),B=d(e,"DIV",{class:!0});var H=I(B);p(Ve.$$.fragment,H),Mt=a(H),io=d(H,"P",{"data-svelte-h":!0}),b(io)!=="svelte-p2ya4c"&&(io.textContent=pn),wt=a(H),Q=d(H,"DIV",{class:!0});var De=I(Q);p(Be.$$.fragment,De),Ct=a(De),lo=d(De,"P",{"data-svelte-h":!0}),b(lo)!=="svelte-1x3yxsa"&&(lo.textContent=un),De.forEach(t),H.forEach(t),tt=a(e),p(Ne.$$.fragment,e),nt=a(e),$=d(e,"DIV",{class:!0});var F=I($);p(Fe.$$.fragment,F),Jt=a(F),co=d(F,"P",{"data-svelte-h":!0}),b(co)!=="svelte-1yzmrhf"&&(co.innerHTML=fn),kt=a(F),mo=d(F,"P",{"data-svelte-h":!0}),b(mo)!=="svelte-1b312h9"&&(mo.innerHTML=gn),$t=a(F),ho=d(F,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-hswkmf"&&(ho.innerHTML=_n),zt=a(F),G=d(F,"DIV",{class:!0});var ee=I(G);p(Re.$$.fragment,ee),It=a(ee),po=d(ee,"P",{"data-svelte-h":!0}),b(po)!=="svelte-1q5ym45"&&(po.textContent=bn),xt=a(ee),uo=d(ee,"P",{"data-svelte-h":!0}),b(uo)!=="svelte-w8wo9i"&&(uo.textContent=yn),Wt=a(ee),p(S.$$.fragment,ee),ee.forEach(t),F.forEach(t),at=a(e),p(Pe.$$.fragment,e),st=a(e),z=d(e,"DIV",{class:!0});var R=I(z);p(He.$$.fragment,R),jt=a(R),fo=d(R,"P",{"data-svelte-h":!0}),b(fo)!=="svelte-dnfd0z"&&(fo.innerHTML=Tn),Ut=a(R),go=d(R,"P",{"data-svelte-h":!0}),b(go)!=="svelte-hswkmf"&&(go.innerHTML=vn),Gt=a(R),_o=d(R,"P",{"data-svelte-h":!0}),b(_o)!=="svelte-18w1z2r"&&(_o.innerHTML=Mn),Zt=a(R),Z=d(R,"DIV",{class:!0});var oe=I(Z);p(qe.$$.fragment,oe),Vt=a(oe),bo=d(oe,"P",{"data-svelte-h":!0}),b(bo)!=="svelte-18qr4rs"&&(bo.innerHTML=wn),Bt=a(oe),p(A.$$.fragment,oe),Nt=a(oe),p(D.$$.fragment,oe),oe.forEach(t),R.forEach(t),rt=a(e),p(Ee.$$.fragment,e),it=a(e),W=d(e,"DIV",{class:!0});var te=I(W);p(Ye.$$.fragment,te),Ft=a(te),yo=d(te,"P",{"data-svelte-h":!0}),b(yo)!=="svelte-ovfhsa"&&(yo.innerHTML=Cn),Rt=a(te),To=d(te,"P",{"data-svelte-h":!0}),b(To)!=="svelte-hswkmf"&&(To.innerHTML=Jn),Pt=a(te),V=d(te,"DIV",{class:!0});var ne=I(V);p(Le.$$.fragment,ne),Ht=a(ne),vo=d(ne,"P",{"data-svelte-h":!0}),b(vo)!=="svelte-1uqxh5i"&&(vo.innerHTML=kn),qt=a(ne),p(O.$$.fragment,ne),Et=a(ne),p(K.$$.fragment,ne),ne.forEach(t),te.forEach(t),lt=a(e),p(Xe.$$.fragment,e),dt=a(e),Mo=d(e,"P",{}),I(Mo).forEach(t),this.h()},h(){w(r,"name","hf:doc:metadata"),w(r,"content",Hn),zn(q.src,St="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/chameleon_arch.png")||w(q,"src",St),w(q,"alt","drawing"),w(q,"width","600"),w(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,r),s(e,T,o),s(e,c,o),s(e,y,o),u(v,e,o),s(e,m,o),u(M,e,o),s(e,wo,o),s(e,ae,o),s(e,Co,o),s(e,se,o),s(e,Jo,o),s(e,re,o),s(e,ko,o),s(e,q,o),s(e,$o,o),s(e,ie,o),s(e,zo,o),s(e,le,o),s(e,Io,o),u(de,e,o),s(e,xo,o),s(e,ce,o),s(e,Wo,o),s(e,me,o),s(e,jo,o),u(he,e,o),s(e,Uo,o),u(pe,e,o),s(e,Go,o),s(e,ue,o),s(e,Zo,o),u(fe,e,o),s(e,Vo,o),u(ge,e,o),s(e,Bo,o),s(e,_e,o),s(e,No,o),u(be,e,o),s(e,Fo,o),u(ye,e,o),s(e,Ro,o),u(Te,e,o),s(e,Po,o),s(e,ve,o),s(e,Ho,o),u(E,e,o),s(e,qo,o),s(e,Me,o),s(e,Eo,o),u(we,e,o),s(e,Yo,o),u(Ce,e,o),s(e,Lo,o),s(e,Je,o),s(e,Xo,o),u(ke,e,o),s(e,Qo,o),u($e,e,o),s(e,So,o),s(e,x,o),u(ze,x,null),i(x,ht),i(x,eo),i(x,pt),i(x,oo),i(x,ut),u(Y,x,null),s(e,Ao,o),u(Ie,e,o),s(e,Do,o),s(e,P,o),u(xe,P,null),i(P,ft),i(P,to),s(e,Oo,o),u(We,e,o),s(e,Ko,o),s(e,k,o),u(je,k,null),i(k,gt),i(k,no),i(k,_t),i(k,ao),i(k,bt),i(k,L),u(Ue,L,null),i(L,yt),i(L,so),i(k,Tt),i(k,X),u(Ge,X,null),i(X,vt),i(X,ro),s(e,et,o),u(Ze,e,o),s(e,ot,o),s(e,B,o),u(Ve,B,null),i(B,Mt),i(B,io),i(B,wt),i(B,Q),u(Be,Q,null),i(Q,Ct),i(Q,lo),s(e,tt,o),u(Ne,e,o),s(e,nt,o),s(e,$,o),u(Fe,$,null),i($,Jt),i($,co),i($,kt),i($,mo),i($,$t),i($,ho),i($,zt),i($,G),u(Re,G,null),i(G,It),i(G,po),i(G,xt),i(G,uo),i(G,Wt),u(S,G,null),s(e,at,o),u(Pe,e,o),s(e,st,o),s(e,z,o),u(He,z,null),i(z,jt),i(z,fo),i(z,Ut),i(z,go),i(z,Gt),i(z,_o),i(z,Zt),i(z,Z),u(qe,Z,null),i(Z,Vt),i(Z,bo),i(Z,Bt),u(A,Z,null),i(Z,Nt),u(D,Z,null),s(e,rt,o),u(Ee,e,o),s(e,it,o),s(e,W,o),u(Ye,W,null),i(W,Ft),i(W,yo),i(W,Rt),i(W,To),i(W,Pt),i(W,V),u(Le,V,null),i(V,Ht),i(V,vo),i(V,qt),u(O,V,null),i(V,Et),u(K,V,null),s(e,lt,o),u(Xe,e,o),s(e,dt,o),s(e,Mo,o),ct=!0},p(e,[o]){const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),E.$set(N);const Qe={};o&2&&(Qe.$$scope={dirty:o,ctx:e}),Y.$set(Qe);const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),S.$set(j);const Se={};o&2&&(Se.$$scope={dirty:o,ctx:e}),A.$set(Se);const Ae={};o&2&&(Ae.$$scope={dirty:o,ctx:e}),D.$set(Ae);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),O.$set(H);const De={};o&2&&(De.$$scope={dirty:o,ctx:e}),K.$set(De)},i(e){ct||(f(v.$$.fragment,e),f(M.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(Te.$$.fragment,e),f(E.$$.fragment,e),f(we.$$.fragment,e),f(Ce.$$.fragment,e),f(ke.$$.fragment,e),f($e.$$.fragment,e),f(ze.$$.fragment,e),f(Y.$$.fragment,e),f(Ie.$$.fragment,e),f(xe.$$.fragment,e),f(We.$$.fragment,e),f(je.$$.fragment,e),f(Ue.$$.fragment,e),f(Ge.$$.fragment,e),f(Ze.$$.fragment,e),f(Ve.$$.fragment,e),f(Be.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Re.$$.fragment,e),f(S.$$.fragment,e),f(Pe.$$.fragment,e),f(He.$$.fragment,e),f(qe.$$.fragment,e),f(A.$$.fragment,e),f(D.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(Le.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(Xe.$$.fragment,e),ct=!0)},o(e){g(v.$$.fragment,e),g(M.$$.fragment,e),g(de.$$.fragment,e),g(he.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(E.$$.fragment,e),g(we.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g($e.$$.fragment,e),g(ze.$$.fragment,e),g(Y.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g(We.$$.fragment,e),g(je.$$.fragment,e),g(Ue.$$.fragment,e),g(Ge.$$.fragment,e),g(Ze.$$.fragment,e),g(Ve.$$.fragment,e),g(Be.$$.fragment,e),g(Ne.$$.fragment,e),g(Fe.$$.fragment,e),g(Re.$$.fragment,e),g(S.$$.fragment,e),g(Pe.$$.fragment,e),g(He.$$.fragment,e),g(qe.$$.fragment,e),g(A.$$.fragment,e),g(D.$$.fragment,e),g(Ee.$$.fragment,e),g(Ye.$$.fragment,e),g(Le.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(Xe.$$.fragment,e),ct=!1},d(e){e&&(t(T),t(c),t(y),t(m),t(wo),t(ae),t(Co),t(se),t(Jo),t(re),t(ko),t(q),t($o),t(ie),t(zo),t(le),t(Io),t(xo),t(ce),t(Wo),t(me),t(jo),t(Uo),t(Go),t(ue),t(Zo),t(Vo),t(Bo),t(_e),t(No),t(Fo),t(Ro),t(Po),t(ve),t(Ho),t(qo),t(Me),t(Eo),t(Yo),t(Lo),t(Je),t(Xo),t(Qo),t(So),t(x),t(Ao),t(Do),t(P),t(Oo),t(Ko),t(k),t(et),t(ot),t(B),t(tt),t(nt),t($),t(at),t(st),t(z),t(rt),t(it),t(W),t(lt),t(dt),t(Mo)),t(r),_(v,e),_(M,e),_(de,e),_(he,e),_(pe,e),_(fe,e),_(ge,e),_(be,e),_(ye,e),_(Te,e),_(E,e),_(we,e),_(Ce,e),_(ke,e),_($e,e),_(ze),_(Y),_(Ie,e),_(xe),_(We,e),_(je),_(Ue),_(Ge),_(Ze,e),_(Ve),_(Be),_(Ne,e),_(Fe),_(Re),_(S),_(Pe,e),_(He),_(qe),_(A),_(D),_(Ee,e),_(Ye),_(Le),_(O),_(K),_(Xe,e)}}}const Hn='{"title":"Chameleon","local":"chameleon","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 and SDPA to further speed-up generation","local":"use-flash-attention-2-and-sdpa-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"ChameleonConfig","local":"transformers.ChameleonConfig","sections":[],"depth":2},{"title":"ChameleonVQVAEConfig","local":"transformers.ChameleonVQVAEConfig","sections":[],"depth":2},{"title":"ChameleonProcessor","local":"transformers.ChameleonProcessor","sections":[],"depth":2},{"title":"ChameleonImageProcessor","local":"transformers.ChameleonImageProcessor","sections":[],"depth":2},{"title":"ChameleonVQVAE","local":"transformers.ChameleonVQVAE","sections":[],"depth":2},{"title":"ChameleonModel","local":"transformers.ChameleonModel","sections":[],"depth":2},{"title":"ChameleonForConditionalGeneration","local":"transformers.ChameleonForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function qn(C){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dn extends xn{constructor(r){super(),Wn(this,r,qn,Pn,$n,{})}}export{Dn as component};
