import{s as Dt,f as Nt,o as Ht,n as Gt}from"../chunks/scheduler.25b97de1.js";import{S as Bt,i as Ft,g as a,s as r,r as p,A as qt,h as i,f as o,c as s,j as Z,u as m,x as d,k as S,y as c,a as n,v as u,d as f,t as h,w as g}from"../chunks/index.d9030fc9.js";import{T as Et}from"../chunks/Tip.baa67368.js";import{D as Te}from"../chunks/Docstring.ffac8efa.js";import{C as ot}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Lt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as me,E as Xt}from"../chunks/EditOnGithub.91d95064.js";function Yt(ue){let l,U="Example:",_,b,T;return b=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN1cGVyUG9pbnRDb25maWclMkMlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3VwZXJQb2ludCUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3VwZXJQb2ludENvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbihjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SuperPointConfig, SuperPointForKeypointDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SuperPoint superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SuperPointConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperPointForKeypointDetection(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=a("p"),l.textContent=U,_=r(),p(b.$$.fragment)},l(y){l=i(y,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=U),_=s(y),m(b.$$.fragment,y)},m(y,$){n(y,l,$),n(y,_,$),u(b,y,$),T=!0},p:Gt,i(y){T||(f(b.$$.fragment,y),T=!0)},o(y){h(b.$$.fragment,y),T=!1},d(y){y&&(o(l),o(_)),g(b,y)}}}function At(ue){let l,U=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=a("p"),l.innerHTML=U},l(_){l=i(_,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=U)},m(_,b){n(_,l,b)},p:Gt,d(_){_&&o(l)}}}function Qt(ue){let l,U,_,b,T,y,$,Ce,R,gt=`The SuperPoint model was proposed
in <a href="https://arxiv.org/abs/1712.07629" rel="nofollow">SuperPoint: Self-Supervised Interest Point Detection and Description</a> by Daniel
DeTone, Tomasz Malisiewicz and Andrew Rabinovich.`,Pe,V,yt=`This model is the result of a self-supervised training of a fully-convolutional network for interest point detection and
description. The model is able to detect interest points that are repeatable under homographic transformations and
provide a descriptor for each point. The use of the model in its own is limited, but it can be used as a feature
extractor for other tasks such as homography estimation, image matching, etc.`,Se,G,_t="The abstract from the paper is the following:",Ue,D,bt=`<em>This paper presents a self-supervised framework for training interest point detectors and descriptors suitable for a
large number of multiple-view geometry problems in computer vision. As opposed to patch-based neural networks, our
fully-convolutional model operates on full-sized images and jointly computes pixel-level interest point locations and
associated descriptors in one forward pass. We introduce Homographic Adaptation, a multi-scale, multi-homography
approach for boosting interest point detection repeatability and performing cross-domain adaptation (e.g.,
synthetic-to-real). Our model, when trained on the MS-COCO generic image dataset using Homographic Adaptation, is able
to repeatedly detect a much richer set of interest points than the initial pre-adapted deep model and any other
traditional corner detector. The final system gives rise to state-of-the-art homography estimation results on HPatches
when compared to LIFT, SIFT and ORB.</em>`,Je,j,Mt,je,N,wt='SuperPoint overview. Taken from the <a href="https://arxiv.org/abs/1712.07629v4">original paper.</a>',xe,H,Ie,B,vt="Here is a quick example of using the model to detect interest points in an image:",ze,F,ke,q,Tt="The outputs contain the list of keypoint coordinates with their respective score and description (a 256-long vector).",We,E,$t=`You can also feed multiple images to the model. Due to the nature of SuperPoint, to output a dynamic number of keypoints,
you will need to use the mask attribute to retrieve the respective information :`,Ze,L,Re,X,Ct="You can then print the keypoints on the image to visualize the result :",Ve,Y,Ge,A,Pt=`This model was contributed by <a href="https://huggingface.co/stevenbucaille" rel="nofollow">stevenbucaille</a>.
The original code can be found <a href="https://github.com/magicleap/SuperPointPretrainedNetwork" rel="nofollow">here</a>.`,De,Q,Ne,K,St="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with SuperPoint. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",He,O,Ut='<li>A notebook showcasing inference and visualization with SuperPoint can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/SuperPoint/Inference_with_SuperPoint_to_detect_interest_points_in_an_image.ipynb" rel="nofollow">here</a>. 🌎</li>',Be,ee,Fe,M,te,nt,fe,Jt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_31098/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a>. It is used to instantiate a
SuperPoint model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SuperPoint
<a href="https://huggingface.co/magic-leap-community/superpoint" rel="nofollow">magic-leap-community/superpoint</a> architecture.`,rt,he,jt=`Configuration objects inherit from <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_31098/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,st,x,qe,oe,Ee,w,ne,at,ge,xt="Constructs a SuperPoint image processor.",it,I,re,lt,ye,It="Preprocess an image or batch of images.",ct,z,se,dt,_e,zt="Resize an image.",Le,ae,kt="<li>preprocess</li>",Xe,ie,Ye,v,le,pt,be,Wt=`SuperPoint model outputting keypoints and descriptors.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,mt,Me,Zt=`SuperPoint model. It consists of a SuperPointEncoder, a SuperPointInterestPointDecoder and a
SuperPointDescriptorDecoder. SuperPoint was proposed in <code>SuperPoint: Self-Supervised Interest Point Detection and Description &lt;https://arxiv.org/abs/1712.07629&gt;</code>__ by Daniel DeTone, Tomasz Malisiewicz, and Andrew Rabinovich. It
is a fully convolutional neural network that extracts keypoints and descriptors from an image. It is trained in a
self-supervised manner, using a combination of a photometric loss and a loss based on the homographic adaptation of
keypoints. It is made of a convolutional encoder and two decoders: one for keypoints and one for descriptors.`,ut,J,ce,ft,we,Rt='The <a href="/docs/transformers/pr_31098/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a> forward method, overrides the <code>__call__</code> special method.',ht,k,Ae,de,Vt="<li>forward</li>",Qe,pe,Ke,$e,Oe;return T=new me({props:{title:"SuperPoint",local:"superpoint",headingTag:"h1"}}),$=new me({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new me({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),F=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJwb2ludCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)`,wrap:!1}}),L=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmxfaW1hZ2VfMSUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZV8xJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsX2ltYWdlXzElMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdXJsX2ltYWdlXzIlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnRlc3Qtc3R1ZmYyMDE3JTJGMDAwMDAwMDAwNTY4LmpwZyUyMiUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfaW1hZ2VfMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZV8xJTJDJTIwaW1hZ2VfMiU1RCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWFnaWMtbGVhcC1jb21tdW5pdHklMkZzdXBlcnBvaW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3VwZXJQb2ludEZvcktleXBvaW50RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihpbWFnZXMpKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX21hc2slMjAlM0QlMjBvdXRwdXRzLm1hc2slNUJpJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2VfaW5kaWNlcyUyMCUzRCUyMHRvcmNoLm5vbnplcm8oaW1hZ2VfbWFzaykuc3F1ZWV6ZSgpJTBBJTIwJTIwJTIwJTIwaW1hZ2Vfa2V5cG9pbnRzJTIwJTNEJTIwb3V0cHV0cy5rZXlwb2ludHMlNUJpJTVEJTVCaW1hZ2VfaW5kaWNlcyU1RCUwQSUyMCUyMCUyMCUyMGltYWdlX3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuc2NvcmVzJTVCaSU1RCU1QmltYWdlX2luZGljZXMlNUQlMEElMjAlMjAlMjAlMjBpbWFnZV9kZXNjcmlwdG9ycyUyMCUzRCUyMG91dHB1dHMuZGVzY3JpcHRvcnMlNUJpJTVEJTVCaW1hZ2VfaW5kaWNlcyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url_image_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_1, stream=<span class="hljs-literal">True</span>).raw)
url_image_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/test-stuff2017/000000000568.jpg&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_2, stream=<span class="hljs-literal">True</span>).raw)

images = [image_1, image_2]

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(images)):
    image_mask = outputs.mask[i]
    image_indices = torch.nonzero(image_mask).squeeze()
    image_keypoints = outputs.keypoints[i][image_indices]
    image_scores = outputs.scores[i][image_indices]
    image_descriptors = outputs.descriptors[i][image_indices]`,wrap:!1}}),Y=new ot({props:{code:"aW1wb3J0JTIwY3YyJTBBZm9yJTIwa2V5cG9pbnQlMkMlMjBzY29yZSUyMGluJTIwemlwKGltYWdlX2tleXBvaW50cyUyQyUyMGltYWdlX3Njb3JlcyklM0ElMEElMjAlMjAlMjAlMjBrZXlwb2ludF94JTJDJTIwa2V5cG9pbnRfeSUyMCUzRCUyMGludChrZXlwb2ludCU1QjAlNUQuaXRlbSgpKSUyQyUyMGludChrZXlwb2ludCU1QjElNUQuaXRlbSgpKSUwQSUyMCUyMCUyMCUyMGNvbG9yJTIwJTNEJTIwdHVwbGUoJTVCc2NvcmUuaXRlbSgpJTIwKiUyMDI1NSU1RCUyMColMjAzKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwY3YyLmNpcmNsZShpbWFnZSUyQyUyMChrZXlwb2ludF94JTJDJTIwa2V5cG9pbnRfeSklMkMlMjAyJTJDJTIwY29sb3IpJTBBY3YyLmltd3JpdGUoJTIyb3V0cHV0X2ltYWdlLnBuZyUyMiUyQyUyMGltYWdlKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">for</span> keypoint, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_keypoints, image_scores):
    keypoint_x, keypoint_y = <span class="hljs-built_in">int</span>(keypoint[<span class="hljs-number">0</span>].item()), <span class="hljs-built_in">int</span>(keypoint[<span class="hljs-number">1</span>].item())
    color = <span class="hljs-built_in">tuple</span>([score.item() * <span class="hljs-number">255</span>] * <span class="hljs-number">3</span>)
    image = cv2.circle(image, (keypoint_x, keypoint_y), <span class="hljs-number">2</span>, color)
cv2.imwrite(<span class="hljs-string">&quot;output_image.png&quot;</span>, image)`,wrap:!1}}),Q=new me({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ee=new me({props:{title:"SuperPointConfig",local:"transformers.SuperPointConfig",headingTag:"h2"}}),te=new Te({props:{name:"class transformers.SuperPointConfig",anchor:"transformers.SuperPointConfig",parameters:[{name:"encoder_hidden_sizes",val:": List = [64, 64, 128, 128]"},{name:"decoder_hidden_size",val:": int = 256"},{name:"keypoint_decoder_dim",val:": int = 65"},{name:"descriptor_decoder_dim",val:": int = 256"},{name:"keypoint_threshold",val:": float = 0.005"},{name:"max_keypoints",val:": int = -1"},{name:"nms_radius",val:": int = 4"},{name:"border_removal_distance",val:": int = 4"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointConfig.encoder_hidden_sizes",description:`<strong>encoder_hidden_sizes</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[64, 64, 128, 128]</code>) &#x2014;
The number of channels in each convolutional layer in the encoder.`,name:"encoder_hidden_sizes"},{anchor:"transformers.SuperPointConfig.decoder_hidden_size",description:"<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The hidden size of the decoder.",name:"decoder_hidden_size"},{anchor:"transformers.SuperPointConfig.keypoint_decoder_dim",description:"<strong>keypoint_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 65) &#x2014; The output dimension of the keypoint decoder.",name:"keypoint_decoder_dim"},{anchor:"transformers.SuperPointConfig.descriptor_decoder_dim",description:"<strong>descriptor_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The output dimension of the descriptor decoder.",name:"descriptor_decoder_dim"},{anchor:"transformers.SuperPointConfig.keypoint_threshold",description:`<strong>keypoint_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.005) &#x2014;
The threshold to use for extracting keypoints.`,name:"keypoint_threshold"},{anchor:"transformers.SuperPointConfig.max_keypoints",description:`<strong>max_keypoints</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The maximum number of keypoints to extract. If <code>-1</code>, will extract all keypoints.`,name:"max_keypoints"},{anchor:"transformers.SuperPointConfig.nms_radius",description:`<strong>nms_radius</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The radius for non-maximum suppression.`,name:"nms_radius"},{anchor:"transformers.SuperPointConfig.border_removal_distance",description:`<strong>border_removal_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The distance from the border to remove keypoints.`,name:"border_removal_distance"},{anchor:"transformers.SuperPointConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/superpoint/configuration_superpoint.py#L23"}}),x=new Lt({props:{anchor:"transformers.SuperPointConfig.example",$$slots:{default:[Yt]},$$scope:{ctx:ue}}}),oe=new me({props:{title:"SuperPointImageProcessor",local:"transformers.SuperPointImageProcessor",headingTag:"h2"}}),ne=new Te({props:{name:"class transformers.SuperPointImageProcessor",anchor:"transformers.SuperPointImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overriden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 480, &quot;width&quot;: 640}</code>):
Resolution of the output image after <code>resize</code> is applied. Only has an effect if <code>do_resize</code> is set to
<code>True</code>. Can be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overriden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/superpoint/image_processing_superpoint.py#L87"}}),re=new Te({props:{name:"preprocess",anchor:"transformers.SuperPointImageProcessor.preprocess",parameters:[{name:"images",val:""},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after <code>resize</code> has been applied. If <code>size[&quot;shortest_edge&quot;]</code> &gt;= 384, the image
is resized to <code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Otherwise, the smaller edge of the
image will be matched to <code>int(size[&quot;shortest_edge&quot;]/ crop_pct)</code>, after which the image is cropped to
<code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SuperPointImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SuperPointImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/superpoint/image_processing_superpoint.py#L164"}}),se=new Te({props:{name:"resize",anchor:"transformers.SuperPointImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": Dict"},{name:"data_format",val:": Union = None"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SuperPointImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary of the form <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>, specifying the size of the output image.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the output image. If not provided, it will be inferred from the input
image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/superpoint/image_processing_superpoint.py#L125"}}),ie=new me({props:{title:"SuperPointForKeypointDetection",local:"transformers.SuperPointForKeypointDetection",headingTag:"h2"}}),le=new Te({props:{name:"class transformers.SuperPointForKeypointDetection",anchor:"transformers.SuperPointForKeypointDetection",parameters:[{name:"config",val:": SuperPointConfig"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_31098/en/model_doc/superpoint#transformers.SuperPointConfig">SuperPointConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_31098/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/superpoint/modeling_superpoint.py#L388"}}),ce=new Te({props:{name:"forward",anchor:"transformers.SuperPointForKeypointDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_31098/en/model_doc/superpoint#transformers.SuperPointImageProcessor">SuperPointImageProcessor</a>. See
<a href="/docs/transformers/pr_31098/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor.__call__">SuperPointImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SuperPointForKeypointDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for more
detail.`,name:"output_hidden_states"},{anchor:"transformers.SuperPointForKeypointDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_31098/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Examples:`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_31098/src/transformers/models/superpoint/modeling_superpoint.py#L413"}}),k=new Et({props:{$$slots:{default:[At]},$$scope:{ctx:ue}}}),pe=new Xt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/superpoint.md"}}),{c(){l=a("meta"),U=r(),_=a("p"),b=r(),p(T.$$.fragment),y=r(),p($.$$.fragment),Ce=r(),R=a("p"),R.innerHTML=gt,Pe=r(),V=a("p"),V.textContent=yt,Se=r(),G=a("p"),G.textContent=_t,Ue=r(),D=a("p"),D.innerHTML=bt,Je=r(),j=a("img"),je=r(),N=a("small"),N.innerHTML=wt,xe=r(),p(H.$$.fragment),Ie=r(),B=a("p"),B.textContent=vt,ze=r(),p(F.$$.fragment),ke=r(),q=a("p"),q.textContent=Tt,We=r(),E=a("p"),E.textContent=$t,Ze=r(),p(L.$$.fragment),Re=r(),X=a("p"),X.textContent=Ct,Ve=r(),p(Y.$$.fragment),Ge=r(),A=a("p"),A.innerHTML=Pt,De=r(),p(Q.$$.fragment),Ne=r(),K=a("p"),K.textContent=St,He=r(),O=a("ul"),O.innerHTML=Ut,Be=r(),p(ee.$$.fragment),Fe=r(),M=a("div"),p(te.$$.fragment),nt=r(),fe=a("p"),fe.innerHTML=Jt,rt=r(),he=a("p"),he.innerHTML=jt,st=r(),p(x.$$.fragment),qe=r(),p(oe.$$.fragment),Ee=r(),w=a("div"),p(ne.$$.fragment),at=r(),ge=a("p"),ge.textContent=xt,it=r(),I=a("div"),p(re.$$.fragment),lt=r(),ye=a("p"),ye.textContent=It,ct=r(),z=a("div"),p(se.$$.fragment),dt=r(),_e=a("p"),_e.textContent=zt,Le=r(),ae=a("ul"),ae.innerHTML=kt,Xe=r(),p(ie.$$.fragment),Ye=r(),v=a("div"),p(le.$$.fragment),pt=r(),be=a("p"),be.innerHTML=Wt,mt=r(),Me=a("p"),Me.innerHTML=Zt,ut=r(),J=a("div"),p(ce.$$.fragment),ft=r(),we=a("p"),we.innerHTML=Rt,ht=r(),p(k.$$.fragment),Ae=r(),de=a("ul"),de.innerHTML=Vt,Qe=r(),p(pe.$$.fragment),Ke=r(),$e=a("p"),this.h()},l(e){const t=qt("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),U=s(e),_=i(e,"P",{}),Z(_).forEach(o),b=s(e),m(T.$$.fragment,e),y=s(e),m($.$$.fragment,e),Ce=s(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-3y1k2h"&&(R.innerHTML=gt),Pe=s(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-113tmz"&&(V.textContent=yt),Se=s(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-vfdo9a"&&(G.textContent=_t),Ue=s(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-110fra1"&&(D.innerHTML=bt),Je=s(e),j=i(e,"IMG",{src:!0,alt:!0,width:!0}),je=s(e),N=i(e,"SMALL",{"data-svelte-h":!0}),d(N)!=="svelte-1md4ofy"&&(N.innerHTML=wt),xe=s(e),m(H.$$.fragment,e),Ie=s(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-u2cob9"&&(B.textContent=vt),ze=s(e),m(F.$$.fragment,e),ke=s(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-qs9qlh"&&(q.textContent=Tt),We=s(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-g88i9e"&&(E.textContent=$t),Ze=s(e),m(L.$$.fragment,e),Re=s(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1ma1uoo"&&(X.textContent=Ct),Ve=s(e),m(Y.$$.fragment,e),Ge=s(e),A=i(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1s32sqj"&&(A.innerHTML=Pt),De=s(e),m(Q.$$.fragment,e),Ne=s(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1tjytfm"&&(K.textContent=St),He=s(e),O=i(e,"UL",{"data-svelte-h":!0}),d(O)!=="svelte-1w6ygh7"&&(O.innerHTML=Ut),Be=s(e),m(ee.$$.fragment,e),Fe=s(e),M=i(e,"DIV",{class:!0});var C=Z(M);m(te.$$.fragment,C),nt=s(C),fe=i(C,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-10kx40r"&&(fe.innerHTML=Jt),rt=s(C),he=i(C,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1eopo2z"&&(he.innerHTML=jt),st=s(C),m(x.$$.fragment,C),C.forEach(o),qe=s(e),m(oe.$$.fragment,e),Ee=s(e),w=i(e,"DIV",{class:!0});var P=Z(w);m(ne.$$.fragment,P),at=s(P),ge=i(P,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-bn94yj"&&(ge.textContent=xt),it=s(P),I=i(P,"DIV",{class:!0});var et=Z(I);m(re.$$.fragment,et),lt=s(et),ye=i(et,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1x3yxsa"&&(ye.textContent=It),et.forEach(o),ct=s(P),z=i(P,"DIV",{class:!0});var tt=Z(z);m(se.$$.fragment,tt),dt=s(tt),_e=i(tt,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1eb2h1k"&&(_e.textContent=zt),tt.forEach(o),P.forEach(o),Le=s(e),ae=i(e,"UL",{"data-svelte-h":!0}),d(ae)!=="svelte-j0c82d"&&(ae.innerHTML=kt),Xe=s(e),m(ie.$$.fragment,e),Ye=s(e),v=i(e,"DIV",{class:!0});var W=Z(v);m(le.$$.fragment,W),pt=s(W),be=i(W,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1jukl7g"&&(be.innerHTML=Wt),mt=s(W),Me=i(W,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1177mku"&&(Me.innerHTML=Zt),ut=s(W),J=i(W,"DIV",{class:!0});var ve=Z(J);m(ce.$$.fragment,ve),ft=s(ve),we=i(ve,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1jx51v1"&&(we.innerHTML=Rt),ht=s(ve),m(k.$$.fragment,ve),ve.forEach(o),W.forEach(o),Ae=s(e),de=i(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-n3ow4o"&&(de.innerHTML=Vt),Qe=s(e),m(pe.$$.fragment,e),Ke=s(e),$e=i(e,"P",{}),Z($e).forEach(o),this.h()},h(){S(l,"name","hf:doc:metadata"),S(l,"content",Kt),Nt(j.src,Mt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/superpoint_architecture.png")||S(j,"src",Mt),S(j,"alt","drawing"),S(j,"width","500"),S(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,l),n(e,U,t),n(e,_,t),n(e,b,t),u(T,e,t),n(e,y,t),u($,e,t),n(e,Ce,t),n(e,R,t),n(e,Pe,t),n(e,V,t),n(e,Se,t),n(e,G,t),n(e,Ue,t),n(e,D,t),n(e,Je,t),n(e,j,t),n(e,je,t),n(e,N,t),n(e,xe,t),u(H,e,t),n(e,Ie,t),n(e,B,t),n(e,ze,t),u(F,e,t),n(e,ke,t),n(e,q,t),n(e,We,t),n(e,E,t),n(e,Ze,t),u(L,e,t),n(e,Re,t),n(e,X,t),n(e,Ve,t),u(Y,e,t),n(e,Ge,t),n(e,A,t),n(e,De,t),u(Q,e,t),n(e,Ne,t),n(e,K,t),n(e,He,t),n(e,O,t),n(e,Be,t),u(ee,e,t),n(e,Fe,t),n(e,M,t),u(te,M,null),c(M,nt),c(M,fe),c(M,rt),c(M,he),c(M,st),u(x,M,null),n(e,qe,t),u(oe,e,t),n(e,Ee,t),n(e,w,t),u(ne,w,null),c(w,at),c(w,ge),c(w,it),c(w,I),u(re,I,null),c(I,lt),c(I,ye),c(w,ct),c(w,z),u(se,z,null),c(z,dt),c(z,_e),n(e,Le,t),n(e,ae,t),n(e,Xe,t),u(ie,e,t),n(e,Ye,t),n(e,v,t),u(le,v,null),c(v,pt),c(v,be),c(v,mt),c(v,Me),c(v,ut),c(v,J),u(ce,J,null),c(J,ft),c(J,we),c(J,ht),u(k,J,null),n(e,Ae,t),n(e,de,t),n(e,Qe,t),u(pe,e,t),n(e,Ke,t),n(e,$e,t),Oe=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),x.$set(C);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),k.$set(P)},i(e){Oe||(f(T.$$.fragment,e),f($.$$.fragment,e),f(H.$$.fragment,e),f(F.$$.fragment,e),f(L.$$.fragment,e),f(Y.$$.fragment,e),f(Q.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(x.$$.fragment,e),f(oe.$$.fragment,e),f(ne.$$.fragment,e),f(re.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(k.$$.fragment,e),f(pe.$$.fragment,e),Oe=!0)},o(e){h(T.$$.fragment,e),h($.$$.fragment,e),h(H.$$.fragment,e),h(F.$$.fragment,e),h(L.$$.fragment,e),h(Y.$$.fragment,e),h(Q.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(x.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(le.$$.fragment,e),h(ce.$$.fragment,e),h(k.$$.fragment,e),h(pe.$$.fragment,e),Oe=!1},d(e){e&&(o(U),o(_),o(b),o(y),o(Ce),o(R),o(Pe),o(V),o(Se),o(G),o(Ue),o(D),o(Je),o(j),o(je),o(N),o(xe),o(Ie),o(B),o(ze),o(ke),o(q),o(We),o(E),o(Ze),o(Re),o(X),o(Ve),o(Ge),o(A),o(De),o(Ne),o(K),o(He),o(O),o(Be),o(Fe),o(M),o(qe),o(Ee),o(w),o(Le),o(ae),o(Xe),o(Ye),o(v),o(Ae),o(de),o(Qe),o(Ke),o($e)),o(l),g(T,e),g($,e),g(H,e),g(F,e),g(L,e),g(Y,e),g(Q,e),g(ee,e),g(te),g(x),g(oe,e),g(ne),g(re),g(se),g(ie,e),g(le),g(ce),g(k),g(pe,e)}}}const Kt='{"title":"SuperPoint","local":"superpoint","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SuperPointConfig","local":"transformers.SuperPointConfig","sections":[],"depth":2},{"title":"SuperPointImageProcessor","local":"transformers.SuperPointImageProcessor","sections":[],"depth":2},{"title":"SuperPointForKeypointDetection","local":"transformers.SuperPointForKeypointDetection","sections":[],"depth":2}],"depth":1}';function Ot(ue){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class io extends Bt{constructor(l){super(),Ft(this,l,Ot,Qt,Dt,{})}}export{io as component};
