import{s as Oe,n as et,o as tt}from"../chunks/scheduler.25b97de1.js";import{S as lt,i as nt,g as a,s,r as m,A as st,h as o,f as l,c as i,j as De,u as p,x as r,k as qe,y as it,a as n,v as h,d as c,t as M,w as f}from"../chunks/index.d9030fc9.js";import{C as Ke}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Q,E as at}from"../chunks/EditOnGithub.91d95064.js";function ot(Ce){let d,P,F,D,w,q,T,_e='<code>transformers</code> is an opinionated framework; our philosophy is defined in the following <a href="./philosophy">conceptual guide</a>.',K,y,Be=`The core of that philosophy is exemplified by the <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">single model, single file</a>
aspect of the library. This component’s downside is that it limits the inheritance and importability of components from
files to others in the toolkit.`,O,u,ke=`As a result, model components tend to be repeated across many files. There are as many attention layers defined
in <code>transformers</code> as there are models, and a significant number of those are identical to each other.
The unfortunate consequence is that independent implementations tend to diverge as fixes and changes get applied
to specific parts of the code.`,ee,J,We=`In order to balance this issue, we introduced the concept of “copies” across the library. By adding a comment indicating
that code is a copy of another, we can enforce through CI and local commands that copies do not diverge. However,
while the complexity is low, this is often quite tedious to do.`,te,b,xe=`And, finally, this contributes to adding a significant overhead to contributing models which we would like to remove.
This approach often requires model contributions to add modeling code (~1k lines), processor (~500 lines), tests, docs,
etc. Model contribution PRs rarely add less than 3-5k lines of code, with much of this code being boilerplate.`,le,j,$e=`This raises the bar for contributions, and with Modular Transformers, we’re aiming to lower the bar to a much more
acceptable point.`,ne,I,se,Z,Ge=`Modular Transformers introduces the concept of a “modular” file to a model folder. This modular file accepts code
that isn’t typically accepted in modeling/processing files, as it allows importing from neighbouring models as well
as inheritance from classes to others.`,ie,U,Re=`This modular file defines models, processors, and the configuration class that would otherwise be defined in their
respective modules.`,ae,g,Ae=`Finally, this feature introduces a new <code>linter</code> which will “unravel” the modular file into the “single model, single
file” directory structure. These files will get auto-generated every time the script is run; reducing the required
contributions to the modular file, and therefore only to the changes between the contributed model and others.`,oe,v,Ee=`Model users will end up importing and using the single-file interface, so no change is expected here. Doing this, we
hope to combine the best of both worlds: enabling simple contributions while sticking to our philosophy.`,re,C,Ve=`This is therefore a replacement for the <code># Copied from</code> markers, and previously contributed models can be expected to
be moved to the new Modular Transformers format in the coming months.`,de,_,me,B,He=`The “linter”, which unravels the inheritance and creates all single-files from the modular file, will flatten the
inheritance while trying to be invisible to Python users. At this time, the linter flattens a <strong>single</strong> level of
inheritance.`,pe,k,Xe="For example:",he,W,Ye=`<li>If a configuration class inherits from another and adds/deletes an argument, the generated file will either directly
reference it (in case of addition) or completely remove it (in case of deletion).</li> <li>If a class inherits from another, for example: class GemmaModel(LlamaModel):, dependencies are automatically
inferred. All submodules will be automatically inferred from the superclass.</li>`,ce,x,Le=`You should be able to write everything (the tokenizer, the image processor, the model, the config) in this <code>modular</code>
file, and the corresponding files will be created for you.`,Me,$,fe,G,Se="[TODO] We are introducing a new test, that makes sure the generated content matches what is present in the <code>modular_xxxx.py</code>",we,R,Te,A,Ne=`Here is a quick example with BERT and RoBERTa. The two models are intimately related: their modeling implementation
differs solely by a change in the embedding layer.`,ye,E,Qe=`Instead of redefining the model entirely, here is what the <code>modular_roberta.py</code> file looks like for the modeling &amp;
configuration classes (for the sake of the example, the tokenizer is ignored at this time as very different).`,ue,V,Je,H,Fe="Note that if you do not use the dependency that you defined, you will have the following error:",be,X,je,Y,ze="Additionally, you may find a list of examples here:",Ie,L,Ze,S,Pe="It is not a replacement for the modeling code (yet?), and if your model is not based on anything else that ever existed, then you can add a <code>modeling</code> file as usual.",Ue,N,ge,z,ve;return w=new Q({props:{title:"Modular transformers",local:"modular-transformers",headingTag:"h1"}}),I=new Q({props:{title:"What is it?",local:"what-is-it",headingTag:"h2"}}),_=new Q({props:{title:"Details",local:"details",headingTag:"h3"}}),$=new Q({props:{title:"Enforcement",local:"enforcement",headingTag:"h3"}}),R=new Q({props:{title:"Examples",local:"examples",headingTag:"h3"}}),V=new Ke({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> ..bert.configuration_bert <span class="hljs-keyword">import</span> BertConfig
<span class="hljs-keyword">from</span> ..bert.modeling_bert <span class="hljs-keyword">import</span> (
    BertModel,
    BertEmbeddings,
    BertForMaskedLM
)

<span class="hljs-comment"># The RoBERTa config is identical to BERT&#x27;s config</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaConfig</span>(<span class="hljs-title class_ inherited__">BertConfig</span>):
  model_type = <span class="hljs-string">&#x27;roberta&#x27;</span>

<span class="hljs-comment"># We redefine the embeddings here to highlight the padding ID difference, and we redefine the position embeddings</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaEmbeddings</span>(<span class="hljs-title class_ inherited__">BertEmbeddings</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config())

        self.padding_idx = config.pad_token_id
        self.position_embeddings = nn.Embedding(
            config.max_position_embeddings, config.hidden_size, padding_idx=self.padding_idx
        )

<span class="hljs-comment"># The RoBERTa model is identical to the BERT model, except for the embedding layer. </span>
<span class="hljs-comment"># We redefine the embeddings above, so here there is no need to do additional work</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaModel</span>(<span class="hljs-title class_ inherited__">BertModel</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.embeddings = RobertaEmbeddings(config)

      
<span class="hljs-comment"># The heads now only need to redefine the model inside to the correct \`RobertaModel\`</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaForMaskedLM</span>(<span class="hljs-title class_ inherited__">BertForMaskedLM</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.model = RobertaModel(config)`,wrap:!1}}),X=new Ke({props:{code:"VmFsdWVFcnJvciUzQSUyMFlvdSUyMGRlZmluZWQlMjAlNjBSb2JlcnRhRW1iZWRkaW5ncyU2MCUyMGluJTIwdGhlJTIwbW9kdWxhcl9yb2JlcnRhLnB5JTJDJTIwaXQlMjBzaG91bGQlMjBiZSUyMHVzZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGVuJTIweW91JTIwZGVmaW5lJTIwJTYwQmVydE1vZGVsJTYwJTJDJTIwYXMlMjBpdCUyMGlzJTIwb25lJTIwb2YlMjBpdCdzJTIwZGlyZWN0JTIwZGVwZW5kZW5jaWVzLiUyME1ha2UlMjBzdXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweW91JTIwdXNlJTIwaXQlMjBpbiUyMHRoZSUyMCU2MF9faW5pdF9fJTYwJTIwZnVuY3Rpb24u",highlighted:'ValueError: You defined `RobertaEmbeddings` <span class="hljs-keyword">in</span> the modular_roberta.py, it should be used\n                                    when you define `BertModel`, as it is one of it<span class="hljs-string">&#x27;s direct dependencies. Make sure\n                                    you use it in the `__init__` function.</span>',wrap:!1}}),L=new Q({props:{title:"What it is not",local:"what-it-is-not",headingTag:"h2"}}),N=new at({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/modular_transformers.md"}}),{c(){d=a("meta"),P=s(),F=a("p"),D=s(),m(w.$$.fragment),q=s(),T=a("p"),T.innerHTML=_e,K=s(),y=a("p"),y.innerHTML=Be,O=s(),u=a("p"),u.innerHTML=ke,ee=s(),J=a("p"),J.textContent=We,te=s(),b=a("p"),b.textContent=xe,le=s(),j=a("p"),j.textContent=$e,ne=s(),m(I.$$.fragment),se=s(),Z=a("p"),Z.textContent=Ge,ie=s(),U=a("p"),U.textContent=Re,ae=s(),g=a("p"),g.innerHTML=Ae,oe=s(),v=a("p"),v.textContent=Ee,re=s(),C=a("p"),C.innerHTML=Ve,de=s(),m(_.$$.fragment),me=s(),B=a("p"),B.innerHTML=He,pe=s(),k=a("p"),k.textContent=Xe,he=s(),W=a("ul"),W.innerHTML=Ye,ce=s(),x=a("p"),x.innerHTML=Le,Me=s(),m($.$$.fragment),fe=s(),G=a("p"),G.innerHTML=Se,we=s(),m(R.$$.fragment),Te=s(),A=a("p"),A.textContent=Ne,ye=s(),E=a("p"),E.innerHTML=Qe,ue=s(),m(V.$$.fragment),Je=s(),H=a("p"),H.textContent=Fe,be=s(),m(X.$$.fragment),je=s(),Y=a("p"),Y.textContent=ze,Ie=s(),m(L.$$.fragment),Ze=s(),S=a("p"),S.innerHTML=Pe,Ue=s(),m(N.$$.fragment),ge=s(),z=a("p"),this.h()},l(e){const t=st("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(l),P=i(e),F=o(e,"P",{}),De(F).forEach(l),D=i(e),p(w.$$.fragment,e),q=i(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1qsl2az"&&(T.innerHTML=_e),K=i(e),y=o(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1qcwnc7"&&(y.innerHTML=Be),O=i(e),u=o(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-hcbv0p"&&(u.innerHTML=ke),ee=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-14lpvvv"&&(J.textContent=We),te=i(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1tehds2"&&(b.textContent=xe),le=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-5u9x31"&&(j.textContent=$e),ne=i(e),p(I.$$.fragment,e),se=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1qqnnub"&&(Z.textContent=Ge),ie=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-huwsbv"&&(U.textContent=Re),ae=i(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-dk7wye"&&(g.innerHTML=Ae),oe=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-12pm85e"&&(v.textContent=Ee),re=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-ah1dr9"&&(C.innerHTML=Ve),de=i(e),p(_.$$.fragment,e),me=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-xkvkhs"&&(B.innerHTML=He),pe=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1gkqha7"&&(k.textContent=Xe),he=i(e),W=o(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1ajvdmd"&&(W.innerHTML=Ye),ce=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-12b6859"&&(x.innerHTML=Le),Me=i(e),p($.$$.fragment,e),fe=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-drmr0e"&&(G.innerHTML=Se),we=i(e),p(R.$$.fragment,e),Te=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1o8u693"&&(A.textContent=Ne),ye=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-si4m91"&&(E.innerHTML=Qe),ue=i(e),p(V.$$.fragment,e),Je=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-tpa7s6"&&(H.textContent=Fe),be=i(e),p(X.$$.fragment,e),je=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-834mi0"&&(Y.textContent=ze),Ie=i(e),p(L.$$.fragment,e),Ze=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1cj74u8"&&(S.innerHTML=Pe),Ue=i(e),p(N.$$.fragment,e),ge=i(e),z=o(e,"P",{}),De(z).forEach(l),this.h()},h(){qe(d,"name","hf:doc:metadata"),qe(d,"content",rt)},m(e,t){it(document.head,d),n(e,P,t),n(e,F,t),n(e,D,t),h(w,e,t),n(e,q,t),n(e,T,t),n(e,K,t),n(e,y,t),n(e,O,t),n(e,u,t),n(e,ee,t),n(e,J,t),n(e,te,t),n(e,b,t),n(e,le,t),n(e,j,t),n(e,ne,t),h(I,e,t),n(e,se,t),n(e,Z,t),n(e,ie,t),n(e,U,t),n(e,ae,t),n(e,g,t),n(e,oe,t),n(e,v,t),n(e,re,t),n(e,C,t),n(e,de,t),h(_,e,t),n(e,me,t),n(e,B,t),n(e,pe,t),n(e,k,t),n(e,he,t),n(e,W,t),n(e,ce,t),n(e,x,t),n(e,Me,t),h($,e,t),n(e,fe,t),n(e,G,t),n(e,we,t),h(R,e,t),n(e,Te,t),n(e,A,t),n(e,ye,t),n(e,E,t),n(e,ue,t),h(V,e,t),n(e,Je,t),n(e,H,t),n(e,be,t),h(X,e,t),n(e,je,t),n(e,Y,t),n(e,Ie,t),h(L,e,t),n(e,Ze,t),n(e,S,t),n(e,Ue,t),h(N,e,t),n(e,ge,t),n(e,z,t),ve=!0},p:et,i(e){ve||(c(w.$$.fragment,e),c(I.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(R.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(L.$$.fragment,e),c(N.$$.fragment,e),ve=!0)},o(e){M(w.$$.fragment,e),M(I.$$.fragment,e),M(_.$$.fragment,e),M($.$$.fragment,e),M(R.$$.fragment,e),M(V.$$.fragment,e),M(X.$$.fragment,e),M(L.$$.fragment,e),M(N.$$.fragment,e),ve=!1},d(e){e&&(l(P),l(F),l(D),l(q),l(T),l(K),l(y),l(O),l(u),l(ee),l(J),l(te),l(b),l(le),l(j),l(ne),l(se),l(Z),l(ie),l(U),l(ae),l(g),l(oe),l(v),l(re),l(C),l(de),l(me),l(B),l(pe),l(k),l(he),l(W),l(ce),l(x),l(Me),l(fe),l(G),l(we),l(Te),l(A),l(ye),l(E),l(ue),l(Je),l(H),l(be),l(je),l(Y),l(Ie),l(Ze),l(S),l(Ue),l(ge),l(z)),l(d),f(w,e),f(I,e),f(_,e),f($,e),f(R,e),f(V,e),f(X,e),f(L,e),f(N,e)}}}const rt='{"title":"Modular transformers","local":"modular-transformers","sections":[{"title":"What is it?","local":"what-is-it","sections":[{"title":"Details","local":"details","sections":[],"depth":3},{"title":"Enforcement","local":"enforcement","sections":[],"depth":3},{"title":"Examples","local":"examples","sections":[],"depth":3}],"depth":2},{"title":"What it is not","local":"what-it-is-not","sections":[],"depth":2}],"depth":1}';function dt(Ce){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends lt{constructor(d){super(),nt(this,d,dt,ot,Oe,{})}}export{Mt as component};
