import{s as Qt,o as qt}from"../chunks/scheduler.6062bdaf.js";import{S as Wt,i as Ht,g as p,s as a,r as M,A as xt,h as i,f as t,c as n,j as Vt,u as c,x as r,k as Ks,y as zt,a as l,v as o,d as y,t as u,w as m,m as et,n as st}from"../chunks/index.4bca734e.js";import{T as Os}from"../chunks/Tip.b9ac1f03.js";import{C as d}from"../chunks/CodeBlock.fa01571c.js";import{H as Se,E as Lt}from"../chunks/EditOnGithub.74ab2baa.js";function Dt(J){let j;return{c(){j=et(`From within your Space, secrets are available as environment variables (or
Streamlit Secrets Management if using Streamlit). No need to fetch them via the API!`)},l(h){j=st(h,`From within your Space, secrets are available as environment variables (or
Streamlit Secrets Management if using Streamlit). No need to fetch them via the API!`)},m(h,w){l(h,j,w)},d(h){h&&t(j)}}}function Pt(J){let j;return{c(){j=et("Any change in your Space configuration (secrets or hardware) will trigger a restart of your app.")},l(h){j=st(h,"Any change in your Space configuration (secrets or hardware) will trigger a restart of your app.")},m(h,w){l(h,j,w)},d(h){h&&t(j)}}}function Kt(J){let j;return{c(){j=et(`Such a workflow does not support concurrent access as normal demos.
In particular, the interface will be disabled when training occurs.
It is preferable to set your repo as private to ensure you are the only user.`)},l(h){j=st(h,`Such a workflow does not support concurrent access as normal demos.
In particular, the interface will be disabled when training occurs.
It is preferable to set your repo as private to ensure you are the only user.`)},m(h,w){l(h,j,w)},d(h){h&&t(j)}}}function Ot(J){let j,h,w,Ee,I,Ne,_,tt=`In this guide, we will see how to manage your Space runtime
(<a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">secrets</a>,
<a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">hardware</a>, and <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">storage</a>) using <code>huggingface_hub</code>.`,ve,k,Re,C,lt="Here is an end-to-end example to create and setup a Space on the Hub.",Fe,B,at="<strong>1. Create a Space on the Hub.</strong>",Ye,Z,Ve,$,nt="<strong>1. (bis) Duplicate a Space.</strong>",Qe,G,pt=`This can prove useful if you want to build up from an existing Space instead of starting from scratch.
It is also useful is you want control over the configuration/settings of a public Space. See <a href="/docs/huggingface_hub/pr_2256/en/package_reference/hf_api#huggingface_hub.HfApi.duplicate_space">duplicate_space()</a> for more details.`,qe,b,We,X,it="<strong>2. Upload your code using your preferred solution.</strong>",He,A,rt="Here is an example to upload the local folder <code>src/</code> from your machine to your Space:",xe,S,ze,E,Mt=`At this step, your app should already be running on the Hub for free !
However, you might want to configure it further with secrets and upgraded hardware.`,Le,N,ct="<strong>3. Configure secrets and variables</strong>",De,v,ot=`Your Space might require some secret keys, token or variables to work.
See <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">docs</a> for more details.
For example, an HF token to upload an image dataset to the Hub once generated from your Space.`,Pe,R,Ke,F,yt="Secrets and variables can be deleted as well:",Oe,Y,es,T,ss,U,ts,V,ut="<strong>Bonus: set secrets and variables when creating or duplicating the Space!</strong>",ls,Q,mt="Secrets and variables can be set when creating or duplicating a space:",as,q,ns,W,ps,H,jt="<strong>4. Configure the hardware</strong>",is,x,ht=`By default, your Space will run on a CPU environment for free. You can upgrade the hardware
to run it on GPUs. A payment card or a community grant is required to access upgrade your
Space. See <a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">docs</a> for more details.`,rs,z,Ms,L,dt=`Hardware updates are not done immediately as your Space has to be reloaded on our servers.
At any time, you can check on which hardware your Space is running to see if your request
has been met.`,cs,D,os,P,wt=`You now have a Space fully configured. Make sure to downgrade your Space back to “cpu-classic”
when you are done using it.`,ys,K,Jt="<strong>Bonus: request hardware when creating or duplicating the Space!</strong>",us,O,Tt="Upgraded hardware will be automatically assigned to your Space once it’s built.",ms,ee,js,se,hs,te,Ut="<strong>5. Pause and restart your Space</strong>",ds,le,ft=`By default if your Space is running on an upgraded hardware, it will never be stopped. However to avoid getting billed,
you might want to pause it when you are not using it. This is possible using <a href="/docs/huggingface_hub/pr_2256/en/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>. A paused Space will be
inactive until the owner of the Space restarts it, either with the UI or via API using <a href="/docs/huggingface_hub/pr_2256/en/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a>.
For more details about paused mode, please refer to <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">this section</a>`,ws,ae,Js,ne,gt=`Another possibility is to set a timeout for your Space. If your Space is inactive for more than the timeout duration,
it will go to sleep. Any visitor landing on your Space will start it back up. You can set a timeout using
<a href="/docs/huggingface_hub/pr_2256/en/package_reference/hf_api#huggingface_hub.HfApi.set_space_sleep_time">set_space_sleep_time()</a>. For more details about sleeping mode, please refer to <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">this section</a>.`,Ts,pe,Us,ie,It=`Note: if you are using a ‘cpu-basic’ hardware, you cannot configure a custom sleep time. Your Space will automatically
be paused after 48h of inactivity.`,fs,re,_t="<strong>Bonus: set a sleep time while requesting hardware</strong>",gs,Me,kt="Upgraded hardware will be automatically assigned to your Space once it’s built.",Is,ce,_s,oe,Ct="<strong>Bonus: set a sleep time when creating or duplicating the Space!</strong>",ks,ye,Cs,ue,Bs,me,Bt="<strong>6. Add persistent storage to your Space</strong>",Zs,je,Zt='You can choose the storage tier of your choice to access disk space that persists across restarts of your Space. This means you can read and write from disk like you would with a traditional hard drive. See <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">docs</a> for more details.',$s,he,Gs,de,$t="You can also delete your storage, losing all the data permanently.",bs,we,Xs,Je,Gt=`Note: You cannot decrease the storage tier of your space once it’s been granted. To do so,
you must delete the storage first then request the new desired tier.`,As,Te,bt="<strong>Bonus: request storage when creating or duplicating the Space!</strong>",Ss,Ue,Es,fe,Ns,ge,vs,Ie,Xt=`Spaces allow for a lot of different use cases. Sometimes, you might want
to temporarily run a Space on a specific hardware, do something and then shut it down. In
this section, we will explore how to benefit from Spaces to finetune a model on demand.
This is only one way of solving this particular problem. It has to be taken as a suggestion
and adapted to your use case.`,Rs,_e,At=`Let’s assume we have a Space to finetune a model. It is a Gradio app that takes as input
a model id and a dataset id. The workflow is as follows:`,Fs,f,St="<li>(Prompt the user for a model and a dataset)</li> <li>Load the model from the Hub.</li> <li>Load the dataset from the Hub.</li> <li>Finetune the model on the dataset.</li> <li>Upload the new model to the Hub.</li>",Ys,ke,Et=`Step 3. requires a custom hardware but you don’t want your Space to be running all the time on a paid
GPU. A solution is to dynamically request hardware for the training and shut it
down afterwards. Since requesting hardware restarts your Space, your app must somehow “remember”
the current task it is performing. There are multiple ways of doing this. In this guide
we will see one solution using a Dataset as “task scheduler”.`,Vs,Ce,Qs,Be,Nt=`Here is what your app would look like. On startup, check if a task is scheduled and if yes,
run it on the correct hardware. Once done, set back hardware to the free-plan CPU and
prompt the user for a new task.`,qs,g,Ws,Ze,Hs,$e,xs,Ge,vt=`Scheduling tasks can be done in many ways. Here is an example how it could be done using
a simple CSV stored as a Dataset.`,zs,be,Ls,Xe,Ds,Ae,Ps;return I=new Se({props:{title:"Manage your Space",local:"manage-your-space",headingTag:"h1"}}),k=new Se({props:{title:"A simple example: configure secrets and hardware.",local:"a-simple-example-configure-secrets-and-hardware",headingTag:"h2"}}),Z=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBcmVwb19pZCUyMCUzRCUyMCUyMldhdXBsaW4lMkZteS1jb29sLXRyYWluaW5nLXNwYWNlJTIyJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwc3BhY2Vfc2RrJTNEJTIyZ3JhZGlvJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;Wauplin/my-cool-training-space&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># For example with a Gradio SDK</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>)`,wrap:!1}}),b=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)',wrap:!1}}),S=new d({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyc3JjJTJGJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, folder_path=<span class="hljs-string">&quot;src/&quot;</span>)',wrap:!1}}),R=new d({props:{code:"YXBpLmFkZF9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiUyQyUyMHZhbHVlJTNEJTIyaGZfYXBpXyoqKiUyMiklMEFhcGkuYWRkX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMiUyQyUyMHZhbHVlJTNEJTIydXNlciUyRnJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, value=<span class="hljs-string">&quot;hf_api_***&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, value=<span class="hljs-string">&quot;user/repo&quot;</span>)`,wrap:!1}}),Y=new d({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiklMEFhcGkuZGVsZXRlX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>)`,wrap:!1}}),T=new Os({props:{$$slots:{default:[Dt]},$$scope:{ctx:J}}}),U=new Os({props:{warning:!0,$$slots:{default:[Pt]},$$scope:{ctx:J}}}),q=new d({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZWNyZXRzJTNEJTVCJTdCJTIya2V5JTIyJTNEJTIySEZfVE9LRU4lMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMmhmX2FwaV8qKiolMjIlN0QlMkMlMjAuLi4lNUQlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV92YXJpYWJsZXMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJNT0RFTF9SRVBPX0lEJTIyJTJDJTIwJTIydmFsdWUlMjIlM0QlMjJ1c2VyJTJGcmVwbyUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>,
<span class="hljs-meta">... </span>    space_secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    space_variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldHMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJIRl9UT0tFTiUyMiUyQyUyMCUyMnZhbHVlJTIyJTNEJTIyaGZfYXBpXyoqKiUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhYmxlcyUzRCU1QiU3QiUyMmtleSUyMiUzRCUyMk1PREVMX1JFUE9fSUQlMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMnVzZXIlMkZyZXBvJTIyJTdEJTJDJTIwLi4uJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`,wrap:!1}}),z=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlSGFyZHdhcmUlMEFhcGkucmVxdWVzdF9zcGFjZV9oYXJkd2FyZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGhhcmR3YXJlJTNEU3BhY2VIYXJkd2FyZS5UNF9NRURJVU0pJTBBJTBBYXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMik=",highlighted:`<span class="hljs-comment"># Use \`SpaceHardware\` enum</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceHardware
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM)

<span class="hljs-comment"># Or simply pass a string value</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>)`,wrap:!1}}),D=new d({props:{code:"cnVudGltZSUyMCUzRCUyMGFwaS5nZXRfc3BhY2VfcnVudGltZShyZXBvX2lkJTNEcmVwb19pZCklMEFydW50aW1lLnN0YWdlJTBBcnVudGltZS5oYXJkd2FyZSUwQXJ1bnRpbWUucmVxdWVzdGVkX2hhcmR3YXJl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>runtime = api.get_space_runtime(repo_id=repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.stage
<span class="hljs-string">&quot;RUNNING_BUILDING&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.hardware
<span class="hljs-string">&quot;cpu-basic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.requested_hardware
<span class="hljs-string">&quot;t4-medium&quot;</span>`,wrap:!1}}),ee=new d({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMmNwdS11cGdyYWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc3RvcmFnZSUzRCUyMnNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc2xlZXBfdGltZSUzRCUyMjcyMDAlMjIlMkMlMjAlMjMlMjAyJTIwaG91cnMlMjBpbiUyMHNlY3MlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),se=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIyY3B1LXVwZ3JhZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBzdG9yYWdlJTNEJTIyc21hbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBzbGVlcF90aW1lJTNEJTIyNzIwMCUyMiUyQyUyMCUyMyUyMDIlMjBob3VycyUyMGluJTIwc2VjcyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ae=new d({props:{code:"YXBpLnBhdXNlX3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKSUwQWFwaS5yZXN0YXJ0X3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-comment"># Pause your Space to avoid getting billed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.pause_space(repo_id=repo_id)
<span class="hljs-comment"># (...)</span>
<span class="hljs-comment"># Restart it when you need it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.restart_space(repo_id=repo_id)`,wrap:!1}}),pe=new d({props:{code:"YXBpLnNldF9zcGFjZV9zbGVlcF90aW1lKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:`<span class="hljs-comment"># Put your Space to sleep after 1h of inactivity</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.set_space_sleep_time(repo_id=repo_id, sleep_time=<span class="hljs-number">3600</span>)`,wrap:!1}}),ce=new d({props:{code:"YXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRFNwYWNlSGFyZHdhcmUuVDRfTUVESVVNJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM, sleep_time=<span class="hljs-number">3600</span>)',wrap:!1}}),ye=new d({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwYWNlX3NsZWVwX3RpbWUlM0QlMjIzNjAwJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ue=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIydDQtbWVkaXVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2xlZXBfdGltZSUzRCUyMjM2MDAlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),he=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlU3RvcmFnZSUwQWFwaS5yZXF1ZXN0X3NwYWNlX3N0b3JhZ2UocmVwb19pZCUzRHJlcG9faWQlMkMlMjBzdG9yYWdlJTNEU3BhY2VTdG9yYWdlLkxBUkdFKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceStorage
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_storage(repo_id=repo_id, storage=SpaceStorage.LARGE)`,wrap:!1}}),we=new d({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zdG9yYWdlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_storage(repo_id=repo_id)',wrap:!1}}),Ue=new d({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9zdG9yYWdlJTNEJTIybGFyZ2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),fe=new d({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2UlM0QlMjJsYXJnZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ge=new Se({props:{title:"More advanced: temporarily upgrade your Space !",local:"more-advanced-temporarily-upgrade-your-space-",headingTag:"h2"}}),Ce=new Se({props:{title:"App skeleton",local:"app-skeleton",headingTag:"h3"}}),g=new Os({props:{warning:!0,$$slots:{default:[Kt]},$$scope:{ctx:J}}}),Ze=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># Space will need your token to request hardware: set it as a Secret !</span>
HF_TOKEN = os.environ.get(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Space own repo_id</span>
TRAINING_SPACE_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-training&quot;</span>

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, SpaceHardware
api = HfApi(token=HF_TOKEN)

<span class="hljs-comment"># On Space startup, check if a task is scheduled. If yes, finetune the model. If not,</span>
<span class="hljs-comment"># display an interface to request a new task.</span>
task = get_task()
<span class="hljs-keyword">if</span> task <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># Start Gradio app</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">gradio_fn</span>(<span class="hljs-params">task</span>):
        <span class="hljs-comment"># On user request, add task and request hardware</span>
        add_task(task)
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)

    gr.Interface(fn=gradio_fn, ...).launch()
<span class="hljs-keyword">else</span>:
    runtime = api.get_space_runtime(repo_id=TRAINING_SPACE_ID)
    <span class="hljs-comment"># Check if Space is loaded with a GPU.</span>
    <span class="hljs-keyword">if</span> runtime.hardware == SpaceHardware.T4_MEDIUM:
        <span class="hljs-comment"># If yes, finetune base model on dataset !</span>
        train_and_upload(task)

        <span class="hljs-comment"># Then, mark the task as &quot;DONE&quot;</span>
        mark_as_done(task)

        <span class="hljs-comment"># DO NOT FORGET: set back CPU hardware</span>
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.CPU_BASIC)
    <span class="hljs-keyword">else</span>:
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)`,wrap:!1}}),$e=new Se({props:{title:"Task scheduler",local:"task-scheduler",headingTag:"h3"}}),be=new d({props:{code:"JTIzJTIwRGF0YXNldCUyMElEJTIwaW4lMjB3aGljaCUyMGElMjAlNjB0YXNrcy5jc3YlNjAlMjBmaWxlJTIwY29udGFpbnMlMjB0aGUlMjB0YXNrcyUyMHRvJTIwcGVyZm9ybS4lMEElMjMlMjBIZXJlJTIwaXMlMjBhJTIwYmFzaWMlMjBleGFtcGxlJTIwZm9yJTIwJTYwdGFza3MuY3N2JTYwJTIwY29udGFpbmluZyUyMGlucHV0cyUyMChiYXNlJTIwbW9kZWwlMjBhbmQlMjBkYXRhc2V0KSUwQSUyMyUyMGFuZCUyMHN0YXR1cyUyMChQRU5ESU5HJTIwb3IlMjBET05FKS4lMEElMjMlMjAlMjAlMjAlMjAlMjBtdWx0aW1vZGFsYXJ0JTJGc2QtZmluZS10dW5hYmxlJTJDV2F1cGxpbiUyRmNvbmNlcHQtMSUyQ0RPTkUlMEElMjMlMjAlMjAlMjAlMjAlMjBtdWx0aW1vZGFsYXJ0JTJGc2QtZmluZS10dW5hYmxlJTJDV2F1cGxpbiUyRmNvbmNlcHQtMiUyQ1BFTkRJTkclMEFUQVNLX0RBVEFTRVRfSUQlMjAlM0QlMjAlMjJXYXVwbGluJTJGZHJlYW1ib290aC10YXNrLXNjaGVkdWxlciUyMiUwQSUwQWRlZiUyMF9nZXRfY3N2X2ZpbGUoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEVEFTS19EQVRBU0VUX0lEJTJDJTIwZmlsZW5hbWUlM0QlMjJ0YXNrcy5jc3YlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTJDJTIwdG9rZW4lM0RIRl9UT0tFTiklMEElMEFkZWYlMjBnZXRfdGFzaygpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oX2dldF9jc3ZfZmlsZSgpKSUyMGFzJTIwY3N2X2ZpbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjc3ZfcmVhZGVyJTIwJTNEJTIwY3N2LnJlYWRlcihjc3ZfZmlsZSUyQyUyMGRlbGltaXRlciUzRCclMkMnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwY3N2X3JlYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwcm93JTVCMiU1RCUyMCUzRCUzRCUyMCUyMlBFTkRJTkclMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjByb3clNUIwJTVEJTJDJTIwcm93JTVCMSU1RCUyMCUyMyUyMG1vZGVsX2lkJTJDJTIwZGF0YXNldF9pZCUwQSUwQWRlZiUyMGFkZF90YXNrKHRhc2spJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjBkYXRhc2V0X2lkJTIwJTNEJTIwdGFzayUwQSUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKF9nZXRfY3N2X2ZpbGUoKSklMjBhcyUyMGNzdl9maWxlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oY3N2X2ZpbGUlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwZi5yZWFkKCklMEElMEElMjAlMjAlMjAlMjBhcGkudXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX3R5cGUlM0RyZXBvX3R5cGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJ0YXNrcy5jc3YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBRdWljayUyMGFuZCUyMGRpcnR5JTIwd2F5JTIwdG8lMjBhZGQlMjBhJTIwdGFzayUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhdGhfb3JfZmlsZW9iaiUzRCh0YXNrcyUyMCUyQiUyMGYlMjIlNUNuJTdCbW9kZWxfaWQlN0QlMkMlN0JkYXRhc2V0X2lkJTdEJTJDUEVORElORyUyMikuZW5jb2RlKCklMEElMjAlMjAlMjAlMjApJTBBJTBBZGVmJTIwbWFya19hc19kb25lKHRhc2spJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjBkYXRhc2V0X2lkJTIwJTNEJTIwdGFzayUwQSUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKF9nZXRfY3N2X2ZpbGUoKSklMjBhcyUyMGNzdl9maWxlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oY3N2X2ZpbGUlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwZi5yZWFkKCklMEElMEElMjAlMjAlMjAlMjBhcGkudXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX3R5cGUlM0RyZXBvX3R5cGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjJ0YXNrcy5jc3YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBRdWljayUyMGFuZCUyMGRpcnR5JTIwd2F5JTIwdG8lMjBzZXQlMjB0aGUlMjB0YXNrJTIwYXMlMjBET05FJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEdGFza3MucmVwbGFjZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTdCbW9kZWxfaWQlN0QlMkMlN0JkYXRhc2V0X2lkJTdEJTJDUEVORElORyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlN0Jtb2RlbF9pZCU3RCUyQyU3QmRhdGFzZXRfaWQlN0QlMkNET05FJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5lbmNvZGUoKSUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-comment"># Dataset ID in which a \`tasks.csv\` file contains the tasks to perform.</span>
<span class="hljs-comment"># Here is a basic example for \`tasks.csv\` containing inputs (base model and dataset)</span>
<span class="hljs-comment"># and status (PENDING or DONE).</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-1,DONE</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-2,PENDING</span>
TASK_DATASET_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-task-scheduler&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">_get_csv_file</span>():
    <span class="hljs-keyword">return</span> hf_hub_download(repo_id=TASK_DATASET_ID, filename=<span class="hljs-string">&quot;tasks.csv&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, token=HF_TOKEN)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_task</span>():
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        csv_reader = csv.reader(csv_file, delimiter=<span class="hljs-string">&#x27;,&#x27;</span>)
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> csv_reader:
            <span class="hljs-keyword">if</span> row[<span class="hljs-number">2</span>] == <span class="hljs-string">&quot;PENDING&quot;</span>:
                <span class="hljs-keyword">return</span> row[<span class="hljs-number">0</span>], row[<span class="hljs-number">1</span>] <span class="hljs-comment"># model_id, dataset_id</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_task</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Quick and dirty way to add a task</span>
        path_or_fileobj=(tasks + <span class="hljs-string">f&quot;\\n<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>).encode()
    )

<span class="hljs-keyword">def</span> <span class="hljs-title function_">mark_as_done</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Quick and dirty way to set the task as DONE</span>
        path_or_fileobj=tasks.replace(
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>,
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,DONE&quot;</span>
        ).encode()
    )`,wrap:!1}}),Xe=new Lt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/manage-spaces.md"}}),{c(){j=p("meta"),h=a(),w=p("p"),Ee=a(),M(I.$$.fragment),Ne=a(),_=p("p"),_.innerHTML=tt,ve=a(),M(k.$$.fragment),Re=a(),C=p("p"),C.textContent=lt,Fe=a(),B=p("p"),B.innerHTML=at,Ye=a(),M(Z.$$.fragment),Ve=a(),$=p("p"),$.innerHTML=nt,Qe=a(),G=p("p"),G.innerHTML=pt,qe=a(),M(b.$$.fragment),We=a(),X=p("p"),X.innerHTML=it,He=a(),A=p("p"),A.innerHTML=rt,xe=a(),M(S.$$.fragment),ze=a(),E=p("p"),E.textContent=Mt,Le=a(),N=p("p"),N.innerHTML=ct,De=a(),v=p("p"),v.innerHTML=ot,Pe=a(),M(R.$$.fragment),Ke=a(),F=p("p"),F.textContent=yt,Oe=a(),M(Y.$$.fragment),es=a(),M(T.$$.fragment),ss=a(),M(U.$$.fragment),ts=a(),V=p("p"),V.innerHTML=ut,ls=a(),Q=p("p"),Q.textContent=mt,as=a(),M(q.$$.fragment),ns=a(),M(W.$$.fragment),ps=a(),H=p("p"),H.innerHTML=jt,is=a(),x=p("p"),x.innerHTML=ht,rs=a(),M(z.$$.fragment),Ms=a(),L=p("p"),L.textContent=dt,cs=a(),M(D.$$.fragment),os=a(),P=p("p"),P.textContent=wt,ys=a(),K=p("p"),K.innerHTML=Jt,us=a(),O=p("p"),O.textContent=Tt,ms=a(),M(ee.$$.fragment),js=a(),M(se.$$.fragment),hs=a(),te=p("p"),te.innerHTML=Ut,ds=a(),le=p("p"),le.innerHTML=ft,ws=a(),M(ae.$$.fragment),Js=a(),ne=p("p"),ne.innerHTML=gt,Ts=a(),M(pe.$$.fragment),Us=a(),ie=p("p"),ie.textContent=It,fs=a(),re=p("p"),re.innerHTML=_t,gs=a(),Me=p("p"),Me.textContent=kt,Is=a(),M(ce.$$.fragment),_s=a(),oe=p("p"),oe.innerHTML=Ct,ks=a(),M(ye.$$.fragment),Cs=a(),M(ue.$$.fragment),Bs=a(),me=p("p"),me.innerHTML=Bt,Zs=a(),je=p("p"),je.innerHTML=Zt,$s=a(),M(he.$$.fragment),Gs=a(),de=p("p"),de.textContent=$t,bs=a(),M(we.$$.fragment),Xs=a(),Je=p("p"),Je.textContent=Gt,As=a(),Te=p("p"),Te.innerHTML=bt,Ss=a(),M(Ue.$$.fragment),Es=a(),M(fe.$$.fragment),Ns=a(),M(ge.$$.fragment),vs=a(),Ie=p("p"),Ie.textContent=Xt,Rs=a(),_e=p("p"),_e.textContent=At,Fs=a(),f=p("ol"),f.innerHTML=St,Ys=a(),ke=p("p"),ke.textContent=Et,Vs=a(),M(Ce.$$.fragment),Qs=a(),Be=p("p"),Be.textContent=Nt,qs=a(),M(g.$$.fragment),Ws=a(),M(Ze.$$.fragment),Hs=a(),M($e.$$.fragment),xs=a(),Ge=p("p"),Ge.textContent=vt,zs=a(),M(be.$$.fragment),Ls=a(),M(Xe.$$.fragment),Ds=a(),Ae=p("p"),this.h()},l(e){const s=xt("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(t),h=n(e),w=i(e,"P",{}),Vt(w).forEach(t),Ee=n(e),c(I.$$.fragment,e),Ne=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1ppnonz"&&(_.innerHTML=tt),ve=n(e),c(k.$$.fragment,e),Re=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-16uv4iz"&&(C.textContent=lt),Fe=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-ntfke8"&&(B.innerHTML=at),Ye=n(e),c(Z.$$.fragment,e),Ve=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-18k6wu9"&&($.innerHTML=nt),Qe=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-mp38tc"&&(G.innerHTML=pt),qe=n(e),c(b.$$.fragment,e),We=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-hnqkcz"&&(X.innerHTML=it),He=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-8mheo9"&&(A.innerHTML=rt),xe=n(e),c(S.$$.fragment,e),ze=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1z3goh"&&(E.textContent=Mt),Le=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1sfgan5"&&(N.innerHTML=ct),De=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1704hn0"&&(v.innerHTML=ot),Pe=n(e),c(R.$$.fragment,e),Ke=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-65kjzl"&&(F.textContent=yt),Oe=n(e),c(Y.$$.fragment,e),es=n(e),c(T.$$.fragment,e),ss=n(e),c(U.$$.fragment,e),ts=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-poxyid"&&(V.innerHTML=ut),ls=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1rmjpll"&&(Q.textContent=mt),as=n(e),c(q.$$.fragment,e),ns=n(e),c(W.$$.fragment,e),ps=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-vobpqe"&&(H.innerHTML=jt),is=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1ctsnq4"&&(x.innerHTML=ht),rs=n(e),c(z.$$.fragment,e),Ms=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-aczhvz"&&(L.textContent=dt),cs=n(e),c(D.$$.fragment,e),os=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-c540cm"&&(P.textContent=wt),ys=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-jbzoo9"&&(K.innerHTML=Jt),us=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-4tl7ie"&&(O.textContent=Tt),ms=n(e),c(ee.$$.fragment,e),js=n(e),c(se.$$.fragment,e),hs=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1i0f4op"&&(te.innerHTML=Ut),ds=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-zxcpuq"&&(le.innerHTML=ft),ws=n(e),c(ae.$$.fragment,e),Js=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1or2yes"&&(ne.innerHTML=gt),Ts=n(e),c(pe.$$.fragment,e),Us=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-97ry2r"&&(ie.textContent=It),fs=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1lxv1bl"&&(re.innerHTML=_t),gs=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-4tl7ie"&&(Me.textContent=kt),Is=n(e),c(ce.$$.fragment,e),_s=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-5hjx5j"&&(oe.innerHTML=Ct),ks=n(e),c(ye.$$.fragment,e),Cs=n(e),c(ue.$$.fragment,e),Bs=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-pvw90y"&&(me.innerHTML=Bt),Zs=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-2qrjmq"&&(je.innerHTML=Zt),$s=n(e),c(he.$$.fragment,e),Gs=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1u6d0ko"&&(de.textContent=$t),bs=n(e),c(we.$$.fragment,e),Xs=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-m35g6d"&&(Je.textContent=Gt),As=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1mxuks2"&&(Te.innerHTML=bt),Ss=n(e),c(Ue.$$.fragment,e),Es=n(e),c(fe.$$.fragment,e),Ns=n(e),c(ge.$$.fragment,e),vs=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1gmpxen"&&(Ie.textContent=Xt),Rs=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-10q1pgf"&&(_e.textContent=At),Fs=n(e),f=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-1guz9nt"&&(f.innerHTML=St),Ys=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-14y67eb"&&(ke.textContent=Et),Vs=n(e),c(Ce.$$.fragment,e),Qs=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-16rgffk"&&(Be.textContent=Nt),qs=n(e),c(g.$$.fragment,e),Ws=n(e),c(Ze.$$.fragment,e),Hs=n(e),c($e.$$.fragment,e),xs=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1fps41q"&&(Ge.textContent=vt),zs=n(e),c(be.$$.fragment,e),Ls=n(e),c(Xe.$$.fragment,e),Ds=n(e),Ae=i(e,"P",{}),Vt(Ae).forEach(t),this.h()},h(){Ks(j,"name","hf:doc:metadata"),Ks(j,"content",el),Ks(f,"start","0")},m(e,s){zt(document.head,j),l(e,h,s),l(e,w,s),l(e,Ee,s),o(I,e,s),l(e,Ne,s),l(e,_,s),l(e,ve,s),o(k,e,s),l(e,Re,s),l(e,C,s),l(e,Fe,s),l(e,B,s),l(e,Ye,s),o(Z,e,s),l(e,Ve,s),l(e,$,s),l(e,Qe,s),l(e,G,s),l(e,qe,s),o(b,e,s),l(e,We,s),l(e,X,s),l(e,He,s),l(e,A,s),l(e,xe,s),o(S,e,s),l(e,ze,s),l(e,E,s),l(e,Le,s),l(e,N,s),l(e,De,s),l(e,v,s),l(e,Pe,s),o(R,e,s),l(e,Ke,s),l(e,F,s),l(e,Oe,s),o(Y,e,s),l(e,es,s),o(T,e,s),l(e,ss,s),o(U,e,s),l(e,ts,s),l(e,V,s),l(e,ls,s),l(e,Q,s),l(e,as,s),o(q,e,s),l(e,ns,s),o(W,e,s),l(e,ps,s),l(e,H,s),l(e,is,s),l(e,x,s),l(e,rs,s),o(z,e,s),l(e,Ms,s),l(e,L,s),l(e,cs,s),o(D,e,s),l(e,os,s),l(e,P,s),l(e,ys,s),l(e,K,s),l(e,us,s),l(e,O,s),l(e,ms,s),o(ee,e,s),l(e,js,s),o(se,e,s),l(e,hs,s),l(e,te,s),l(e,ds,s),l(e,le,s),l(e,ws,s),o(ae,e,s),l(e,Js,s),l(e,ne,s),l(e,Ts,s),o(pe,e,s),l(e,Us,s),l(e,ie,s),l(e,fs,s),l(e,re,s),l(e,gs,s),l(e,Me,s),l(e,Is,s),o(ce,e,s),l(e,_s,s),l(e,oe,s),l(e,ks,s),o(ye,e,s),l(e,Cs,s),o(ue,e,s),l(e,Bs,s),l(e,me,s),l(e,Zs,s),l(e,je,s),l(e,$s,s),o(he,e,s),l(e,Gs,s),l(e,de,s),l(e,bs,s),o(we,e,s),l(e,Xs,s),l(e,Je,s),l(e,As,s),l(e,Te,s),l(e,Ss,s),o(Ue,e,s),l(e,Es,s),o(fe,e,s),l(e,Ns,s),o(ge,e,s),l(e,vs,s),l(e,Ie,s),l(e,Rs,s),l(e,_e,s),l(e,Fs,s),l(e,f,s),l(e,Ys,s),l(e,ke,s),l(e,Vs,s),o(Ce,e,s),l(e,Qs,s),l(e,Be,s),l(e,qs,s),o(g,e,s),l(e,Ws,s),o(Ze,e,s),l(e,Hs,s),o($e,e,s),l(e,xs,s),l(e,Ge,s),l(e,zs,s),o(be,e,s),l(e,Ls,s),o(Xe,e,s),l(e,Ds,s),l(e,Ae,s),Ps=!0},p(e,[s]){const Rt={};s&2&&(Rt.$$scope={dirty:s,ctx:e}),T.$set(Rt);const Ft={};s&2&&(Ft.$$scope={dirty:s,ctx:e}),U.$set(Ft);const Yt={};s&2&&(Yt.$$scope={dirty:s,ctx:e}),g.$set(Yt)},i(e){Ps||(y(I.$$.fragment,e),y(k.$$.fragment,e),y(Z.$$.fragment,e),y(b.$$.fragment,e),y(S.$$.fragment,e),y(R.$$.fragment,e),y(Y.$$.fragment,e),y(T.$$.fragment,e),y(U.$$.fragment,e),y(q.$$.fragment,e),y(W.$$.fragment,e),y(z.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(ue.$$.fragment,e),y(he.$$.fragment,e),y(we.$$.fragment,e),y(Ue.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(g.$$.fragment,e),y(Ze.$$.fragment,e),y($e.$$.fragment,e),y(be.$$.fragment,e),y(Xe.$$.fragment,e),Ps=!0)},o(e){u(I.$$.fragment,e),u(k.$$.fragment,e),u(Z.$$.fragment,e),u(b.$$.fragment,e),u(S.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(T.$$.fragment,e),u(U.$$.fragment,e),u(q.$$.fragment,e),u(W.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(Ce.$$.fragment,e),u(g.$$.fragment,e),u(Ze.$$.fragment,e),u($e.$$.fragment,e),u(be.$$.fragment,e),u(Xe.$$.fragment,e),Ps=!1},d(e){e&&(t(h),t(w),t(Ee),t(Ne),t(_),t(ve),t(Re),t(C),t(Fe),t(B),t(Ye),t(Ve),t($),t(Qe),t(G),t(qe),t(We),t(X),t(He),t(A),t(xe),t(ze),t(E),t(Le),t(N),t(De),t(v),t(Pe),t(Ke),t(F),t(Oe),t(es),t(ss),t(ts),t(V),t(ls),t(Q),t(as),t(ns),t(ps),t(H),t(is),t(x),t(rs),t(Ms),t(L),t(cs),t(os),t(P),t(ys),t(K),t(us),t(O),t(ms),t(js),t(hs),t(te),t(ds),t(le),t(ws),t(Js),t(ne),t(Ts),t(Us),t(ie),t(fs),t(re),t(gs),t(Me),t(Is),t(_s),t(oe),t(ks),t(Cs),t(Bs),t(me),t(Zs),t(je),t($s),t(Gs),t(de),t(bs),t(Xs),t(Je),t(As),t(Te),t(Ss),t(Es),t(Ns),t(vs),t(Ie),t(Rs),t(_e),t(Fs),t(f),t(Ys),t(ke),t(Vs),t(Qs),t(Be),t(qs),t(Ws),t(Hs),t(xs),t(Ge),t(zs),t(Ls),t(Ds),t(Ae)),t(j),m(I,e),m(k,e),m(Z,e),m(b,e),m(S,e),m(R,e),m(Y,e),m(T,e),m(U,e),m(q,e),m(W,e),m(z,e),m(D,e),m(ee,e),m(se,e),m(ae,e),m(pe,e),m(ce,e),m(ye,e),m(ue,e),m(he,e),m(we,e),m(Ue,e),m(fe,e),m(ge,e),m(Ce,e),m(g,e),m(Ze,e),m($e,e),m(be,e),m(Xe,e)}}}const el='{"title":"Manage your Space","local":"manage-your-space","sections":[{"title":"A simple example: configure secrets and hardware.","local":"a-simple-example-configure-secrets-and-hardware","sections":[],"depth":2},{"title":"More advanced: temporarily upgrade your Space !","local":"more-advanced-temporarily-upgrade-your-space-","sections":[{"title":"App skeleton","local":"app-skeleton","sections":[],"depth":3},{"title":"Task scheduler","local":"task-scheduler","sections":[],"depth":3}],"depth":2}],"depth":1}';function sl(J){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Wt{constructor(j){super(),Ht(this,j,sl,Ot,Qt,{})}}export{il as component};
