import{s as wa,o as ja,n as Oe}from"../chunks/scheduler.6062bdaf.js";import{S as Ca,i as Ia,g as c,s,r as p,A as Ua,h as r,f as n,c as l,j as ba,u as g,x as m,k as _a,y as $a,a,v as f,d as u,t as h,w as d}from"../chunks/index.4bca734e.js";import{T as Ke}from"../chunks/Tip.b9ac1f03.js";import{C as b}from"../chunks/CodeBlock.fa01571c.js";import{H as _,E as Ta}from"../chunks/EditOnGithub.74ab2baa.js";function Ja(w){let i,y=`<a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,o,M,I=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){i=c("p"),i.innerHTML=y,o=s(),M=c("p"),M.innerHTML=I},l(j){i=r(j,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1dxl7jb"&&(i.innerHTML=y),o=l(j),M=r(j,"P",{"data-svelte-h":!0}),m(M)!=="svelte-22w7rm"&&(M.innerHTML=I)},m(j,C){a(j,i,C),a(j,o,C),a(j,M,C)},p:Oe,d(j){j&&(n(i),n(o),n(M))}}}function Za(w){let i,y=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){i=c("p"),i.innerHTML=y},l(o){i=r(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1o4uc5e"&&(i.innerHTML=y)},m(o,M){a(o,i,M)},p:Oe,d(o){o&&n(i)}}}function ka(w){let i,y=`There are more than 200k models on the Hugging Face Hub! Each task in the <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> comes with a recommended
model. Be aware that the HF recommendation can change over time without prior notice. Therefore it is best to explicitly
set a model once you are decided. Also, in most cases you’ll be interested in finding a model specific to <em>your</em> needs.
Visit the <a href="https://huggingface.co/models" rel="nofollow">Models</a> page on the Hub to explore your possibilities.`;return{c(){i=c("p"),i.innerHTML=y},l(o){i=r(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1d515eu"&&(i.innerHTML=y)},m(o,M){a(o,i,M)},p:Oe,d(o){o&&n(i)}}}function Wa(w){let i,y=`Authentication is NOT mandatory when using the Inference API. However, authenticated users get a higher free-tier to
play with the service. Token is also mandatory if you want to run inference on your private models or on private
endpoints.`;return{c(){i=c("p"),i.textContent=y},l(o){i=r(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-7vtkgf"&&(i.textContent=y)},m(o,M){a(o,i,M)},p:Oe,d(o){o&&n(i)}}}function xa(w){let i,y='<code>InferenceClient.chat.completions.create</code> is simply an alias for <code>InferenceClient.chat_completion</code>. Check out the package reference of <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> for more details. <code>base_url</code> and <code>api_key</code> parameters when instantiating the client are also aliases for <code>model</code> and <code>token</code>. These aliases have been defined to reduce friction when switching from <code>OpenAI</code> to <code>InferenceClient</code>.';return{c(){i=c("p"),i.innerHTML=y},l(o){i=r(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-sd3u2o"&&(i.innerHTML=y)},m(o,M){a(o,i,M)},p:Oe,d(o){o&&n(i)}}}function va(w){let i,y=`Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task, how to use them, and the
most popular models for each task.`;return{c(){i=c("p"),i.innerHTML=y},l(o){i=r(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1u4hr1j"&&(i.innerHTML=y)},m(o,M){a(o,i,M)},p:Oe,d(o){o&&n(i)}}}function Ga(w){let i,y=`This is the recommended way to adapt your code to <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. It lets you benefit from the task-specific
methods like <code>feature_extraction</code>.`;return{c(){i=c("p"),i.innerHTML=y},l(o){i=r(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1dpcj7n"&&(i.innerHTML=y)},m(o,M){a(o,i,M)},p:Oe,d(o){o&&n(i)}}}function Va(w){let i,y,o,M,I,j,C,Zn=`Inference is the process of using a trained model to make predictions on new data. As this process can be compute-intensive,
running on a dedicated server can be an interesting option. The <code>huggingface_hub</code> library provides an easy way to call a
service that runs inference for hosted models. There are several services you can connect to:`,et,x,kn=`<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a service that allows you to run accelerated inference
on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and
prototype AI products.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production.
Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>`,tt,v,Wn=`These services can be called with the <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and handling inference on both
<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,nt,U,at,G,st,V,xn="Let’s get started with a text-to-image task:",lt,q,it,N,vn='In the example above, we initialized an <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with the default parameters. The only thing you need to know is the <a href="#supported-tasks">task</a> you want to perform. By default, the client will connect to the Inference API and select a model to complete the task. In our example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a file. For more details, check out the <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a> documentation.',ct,B,Gn="Let’s now see an example using the [~<code>InferenceClient.chat_completion</code>] API. This task uses an LLM to generate a response from a list of messages:",rt,S,ot,Q,Vn='In this example, we specified which model we want to use (<code>&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</code>). You can find a list of compatible models <a href="https://huggingface.co/models?other=conversational&amp;sort=likes" rel="nofollow">on this page</a>. We then gave a list of messages to complete (here, a single question) and passed an additional parameter to API (<code>max_token=100</code>). The output is a <code>ChatCompletionOutput</code> object that follows the OpenAI specification. The generated content can be access with <code>output.choices[0].message.content</code>. For more details, check out the <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> documentation.',pt,$,gt,E,ft,Y,qn="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",ut,H,ht,T,dt,L,mt,z,Nn=`The examples we saw above use the Serverless Inference API. This proves to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,yt,A,Mt,R,bt,X,Bn=`Calls made with the <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> can be authenticated using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>.
By default, it will use the token saved on your machine if you are logged in (check out
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">how to authenticate</a>). If you are not logged in, you can pass
your token as an instance parameter:`,_t,F,wt,J,jt,P,Ct,K,Sn='The <code>chat_completion</code> task follows <a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI’s Python client</a> syntax. What does it mean for you? It means that if you are used to play with <code>OpenAI</code>’s APIs you will be able to switch to <code>huggingface_hub.InferenceClient</code> to work with open-source models by updating just 2 line of code!',It,O,Ut,D,Qn='And that’s it! The only required changes are to replace <code>from openai import OpenAI</code> by <code>from huggingface_hub import InferenceClient</code> and <code>client = OpenAI(...)</code> by <code>client = InferenceClient(...)</code>. You can chose any LLM model from the Hugging Face Hub by passing its model id as <code>model</code> parameter. <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;other=conversational,text-generation-inference&amp;sort=trending" rel="nofollow">Here is a list</a> of supported models. For authentication, you should pass a valid <a href="https://huggingface.co/settings/tokens" rel="nofollow">User Access Token</a> as <code>api_key</code> or authenticate using <code>huggingface_hub</code> (see the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">authentication guide</a>).',$t,ee,En='All input parameters and output format are strictly the same. In particular, you can pass <code>stream=True</code> to receive tokens as they are generated. You can also use the <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> to run inference using <code>asyncio</code>:',Tt,te,Jt,ne,Yn='You might wonder why using <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> instead of OpenAI’s client? There are a few reasons for that:',Zt,ae,Hn='<li><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is configured for Hugging Face services. You don’t need to provide a <code>base_url</code> to run models on the serverless Inference API. You also don’t need to provide a <code>token</code> or <code>api_key</code> if you machine is already correctly logged in.</li> <li><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is tailored for both Text-Generation-Inference (TGI) and <code>transformers</code> frameworks, meaning you are assured it will always be on-par with the latest updates.</li> <li><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is integrated with our Inference Endpoints service, making it easier to launch an Inference Endpoint, check its status and run inference on it. Check out the <a href="./inference_endpoints.md">Inference Endpoints</a> guide for more details.</li>',kt,Z,Wt,se,xt,le,Ln=`<a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models. It
has a simple API that supports the most common tasks. Here is a list of the currently supported tasks:`,vt,ie,zn='<thead><tr><th>Domain</th> <th>Task</th> <th>Supported</th> <th>Documentation</th></tr></thead> <tbody><tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td></tr> <tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-to-audio" rel="nofollow">Audio-to-Audio</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_to_audio">audio_to_audio()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td></tr> <tr><td>Computer Vision</td> <td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot-Image-Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td></tr> <tr><td>Multimodal</td> <td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Documentation Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td></tr> <tr><td>NLP</td> <td>Conversational</td> <td></td> <td><em>deprecated</em>, use Chat Completion</td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Chat Completion</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill Mask</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Text Generation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero Shot Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td></tr> <tr><td>Tabular</td> <td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td></tr></tbody>',Gt,k,Vt,ce,qt,re,An=`However, it is not always possible to cover all use cases. For custom requests, the <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> method
gives you the flexibility to send any request to the Inference API. For example, you can specify how to parse the inputs
and outputs. In the example below, the generated image is returned as raw bytes instead of parsing it as a <code>PIL Image</code>.
This can be helpful if you don’t have <code>Pillow</code> installed in your setup and just care about the binary content of the
image. <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> is also useful to handle tasks that are not yet officially supported.`,Nt,oe,Bt,pe,St,ge,Rn=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,Qt,fe,Et,ue,Xn=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,Yt,he,Ht,de,Fn='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',Lt,me,zt,ye,Pn='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',At,Me,Rt,be,Kn="When doing inference, there are two main causes for a timeout:",Xt,_e,On="<li>The inference process takes a long time to complete.</li> <li>The model is not available, for example when Inference API is loading it for the first time.</li>",Ft,we,Dn=`<a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> has a global <code>timeout</code> parameter to handle those two aspects. By default, it is set to <code>None</code>,
meaning that the client will wait indefinitely for the inference to complete. If you want more control in your workflow,
you can set it to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised.
You can catch it and handle it in your code:`,Pt,je,Kt,Ce,Ot,Ie,ea=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,Dt,Ue,ta=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
sending it to the Inference API.</li>`,en,$e,tn,Te,nn,Je,na=`<a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> acts as a replacement for the legacy <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client. It adds specific support for tasks and
handles inference on both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.`,an,Ze,aa='Here is a short guide to help you migrate from <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> to <a href="/docs/huggingface_hub/pr_2413/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.',sn,ke,ln,We,sa="Change from",cn,xe,rn,ve,la="to",on,Ge,pn,Ve,gn,qe,ia="Change from",fn,Ne,un,Be,ca="to",hn,Se,dn,W,mn,Qe,yn,Ee,ra="Change from",Mn,Ye,bn,He,oa="to",_n,Le,wn,ze,jn,Ae,pa="Change from",Cn,Re,In,Xe,ga="to",Un,Fe,$n,Pe,Tn,De,Jn;return I=new _({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),U=new Ke({props:{$$slots:{default:[Ja]},$$scope:{ctx:w}}}),G=new _({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),q=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUyMCUyMCUyMyUyMCdpbWFnZSclMjBpcyUyMGElMjBQSUwuSW1hZ2UlMjBvYmplY3Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)  <span class="hljs-comment"># &#x27;image&#x27; is a PIL.Image object</span>`,wrap:!1}}),S=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),$=new Ke({props:{warning:!0,$$slots:{default:[Za]},$$scope:{ctx:w}}}),E=new _({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),H=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`,wrap:!1}}),T=new Ke({props:{$$slots:{default:[ka]},$$scope:{ctx:w}}}),L=new _({props:{title:"Using a specific URL",local:"using-a-specific-url",headingTag:"h3"}}),A=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),R=new _({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),F=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`,wrap:!1}}),J=new Ke({props:{$$slots:{default:[Wa]},$$scope:{ctx:w}}}),P=new _({props:{title:"OpenAI compatibility",local:"openai-compatibility",headingTag:"h2"}}),O=new b({props:{code:"LSUyMGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBLSUyMGNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMkIlMjBjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNELi4uJTJDJTBBKSUwQSUwQSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-deletion">- from openai import OpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import InferenceClient</span>

<span class="hljs-deletion">- client = OpenAI(</span>
<span class="hljs-addition">+ client = InferenceClient(</span>
    base_url=...,
    api_key=...,
)


output = client.chat.completions.create(
    model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
    messages=[
        {&quot;role&quot;: &quot;system&quot;, &quot;content&quot;: &quot;You are a helpful assistant.&quot;},
        {&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Count to 10&quot;},
    ],
    stream=True,
    max_tokens=1024,
)

for chunk in output:
    print(chunk.choices[0].delta.content)`,wrap:!1}}),te=new b({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQS0lMjBmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwQXN5bmNPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEEtJTIwY2xpZW50JTIwJTNEJTIwQXN5bmNPcGVuQUkoKSUwQSUyQiUyMGNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCklMEElMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkp",highlighted:`import asyncio
<span class="hljs-deletion">- from openai import AsyncOpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import AsyncInferenceClient</span>

<span class="hljs-deletion">- client = AsyncOpenAI()</span>
<span class="hljs-addition">+ client = AsyncInferenceClient()</span>

async def main():
    stream = await client.chat.completions.create(
        model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
        messages=[{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Say this is a test&quot;}],
        stream=True,
    )
    async for chunk in stream:
        print(chunk.choices[0].delta.content or &quot;&quot;, end=&quot;&quot;)

asyncio.run(main())`,wrap:!1}}),Z=new Ke({props:{$$slots:{default:[xa]},$$scope:{ctx:w}}}),se=new _({props:{title:"Supported tasks",local:"supported-tasks",headingTag:"h2"}}),k=new Ke({props:{$$slots:{default:[va]},$$scope:{ctx:w}}}),ce=new _({props:{title:"Custom requests",local:"custom-requests",headingTag:"h2"}}),oe=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTdEJTJDJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyKSUwQXJlc3BvbnNlLmNvbnRlbnQlMjAlMjMlMjByYXclMjBieXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>}, model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes</span>
<span class="hljs-string">b&#x27;...&#x27;</span>`,wrap:!1}}),pe=new _({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),fe=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),he=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in a asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),me=new _({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),Me=new _({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),je=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),Ce=new _({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),$e=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),Te=new _({props:{title:"Legacy InferenceAPI client",local:"legacy-inferenceapi-client",headingTag:"h2"}}),ke=new _({props:{title:"Initialization",local:"initialization",headingTag:"h3"}}),xe=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjB0b2tlbiUzREFQSV9UT0tFTik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Ge=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwdG9rZW4lM0RBUElfVE9LRU4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Ve=new _({props:{title:"Run on a specific task",local:"run-on-a-specific-task",headingTag:"h3"}}),Ne=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIycGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjElMjIlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQWluZmVyZW5jZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(...)`,wrap:!1}}),Se=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5mZXJlbmNlLmZlYXR1cmVfZXh0cmFjdGlvbiguLi4lMkMlMjBtb2RlbCUzRCUyMnBhcmFwaHJhc2UteGxtLXItbXVsdGlsaW5ndWFsLXYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inference.feature_extraction(..., model=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>)`,wrap:!1}}),W=new Ke({props:{$$slots:{default:[Ga]},$$scope:{ctx:w}}}),Qe=new _({props:{title:"Run custom request",local:"run-custom-request",headingTag:"h3"}}),Ye=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBaW5mZXJlbmNlKGlucHV0cyUzRCUyMlRoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMCU1Qk1BU0slNUQuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),Le=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlN0QlMkMlMjBtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXJlc3BvbnNlLmpzb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>}, model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),ze=new _({props:{title:"Run with parameters",local:"run-with-parameters",headingTag:"h3"}}),Re=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIydHlwZWZvcm0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQWlucHV0cyUyMCUzRCUyMCUyMkhpJTJDJTIwSSUyMHJlY2VudGx5JTIwYm91Z2h0JTIwYSUyMGRldmljZSUyMGZyb20lMjB5b3VyJTIwY29tcGFueSUyMGJ1dCUyMGl0JTIwaXMlMjBub3QlMjB3b3JraW5nJTIwYXMlMjBhZHZlcnRpc2VkJTIwYW5kJTIwSSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwZ2V0JTIwcmVpbWJ1cnNlZCElMjIlMEFwYXJhbXMlMjAlM0QlMjAlN0IlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlN0QlMEFpbmZlcmVuY2UoaW5wdXRzJTJDJTIwcGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),Fe=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5wdXRzJTIwJTNEJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUwQXBhcmFtcyUyMCUzRCUyMCU3QiUyMmNhbmRpZGF0ZV9sYWJlbHMlMjIlM0ElNUIlMjJyZWZ1bmQlMjIlMkMlMjAlMjJsZWdhbCUyMiUyQyUyMCUyMmZhcSUyMiU1RCU3RCUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGlucHV0cyUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjBwYXJhbXMlN0QlMkMlMjBtb2RlbCUzRCUyMnR5cGVmb3JtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtbW5saSUyMiklMEFyZXNwb25zZS5qc29uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: inputs, <span class="hljs-string">&quot;parameters&quot;</span>: params}, model=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),Pe=new Ta({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference.md"}}),{c(){i=c("meta"),y=s(),o=c("p"),M=s(),p(I.$$.fragment),j=s(),C=c("p"),C.innerHTML=Zn,et=s(),x=c("ul"),x.innerHTML=kn,tt=s(),v=c("p"),v.innerHTML=Wn,nt=s(),p(U.$$.fragment),at=s(),p(G.$$.fragment),st=s(),V=c("p"),V.textContent=xn,lt=s(),p(q.$$.fragment),it=s(),N=c("p"),N.innerHTML=vn,ct=s(),B=c("p"),B.innerHTML=Gn,rt=s(),p(S.$$.fragment),ot=s(),Q=c("p"),Q.innerHTML=Vn,pt=s(),p($.$$.fragment),gt=s(),p(E.$$.fragment),ft=s(),Y=c("p"),Y.textContent=qn,ut=s(),p(H.$$.fragment),ht=s(),p(T.$$.fragment),dt=s(),p(L.$$.fragment),mt=s(),z=c("p"),z.innerHTML=Nn,yt=s(),p(A.$$.fragment),Mt=s(),p(R.$$.fragment),bt=s(),X=c("p"),X.innerHTML=Bn,_t=s(),p(F.$$.fragment),wt=s(),p(J.$$.fragment),jt=s(),p(P.$$.fragment),Ct=s(),K=c("p"),K.innerHTML=Sn,It=s(),p(O.$$.fragment),Ut=s(),D=c("p"),D.innerHTML=Qn,$t=s(),ee=c("p"),ee.innerHTML=En,Tt=s(),p(te.$$.fragment),Jt=s(),ne=c("p"),ne.innerHTML=Yn,Zt=s(),ae=c("ol"),ae.innerHTML=Hn,kt=s(),p(Z.$$.fragment),Wt=s(),p(se.$$.fragment),xt=s(),le=c("p"),le.innerHTML=Ln,vt=s(),ie=c("table"),ie.innerHTML=zn,Gt=s(),p(k.$$.fragment),Vt=s(),p(ce.$$.fragment),qt=s(),re=c("p"),re.innerHTML=An,Nt=s(),p(oe.$$.fragment),Bt=s(),p(pe.$$.fragment),St=s(),ge=c("p"),ge.innerHTML=Rn,Qt=s(),p(fe.$$.fragment),Et=s(),ue=c("p"),ue.innerHTML=Xn,Yt=s(),p(he.$$.fragment),Ht=s(),de=c("p"),de.innerHTML=Fn,Lt=s(),p(me.$$.fragment),zt=s(),ye=c("p"),ye.innerHTML=Pn,At=s(),p(Me.$$.fragment),Rt=s(),be=c("p"),be.textContent=Kn,Xt=s(),_e=c("ul"),_e.innerHTML=On,Ft=s(),we=c("p"),we.innerHTML=Dn,Pt=s(),p(je.$$.fragment),Kt=s(),p(Ce.$$.fragment),Ot=s(),Ie=c("p"),Ie.innerHTML=ea,Dt=s(),Ue=c("ul"),Ue.innerHTML=ta,en=s(),p($e.$$.fragment),tn=s(),p(Te.$$.fragment),nn=s(),Je=c("p"),Je.innerHTML=na,an=s(),Ze=c("p"),Ze.innerHTML=aa,sn=s(),p(ke.$$.fragment),ln=s(),We=c("p"),We.textContent=sa,cn=s(),p(xe.$$.fragment),rn=s(),ve=c("p"),ve.textContent=la,on=s(),p(Ge.$$.fragment),pn=s(),p(Ve.$$.fragment),gn=s(),qe=c("p"),qe.textContent=ia,fn=s(),p(Ne.$$.fragment),un=s(),Be=c("p"),Be.textContent=ca,hn=s(),p(Se.$$.fragment),dn=s(),p(W.$$.fragment),mn=s(),p(Qe.$$.fragment),yn=s(),Ee=c("p"),Ee.textContent=ra,Mn=s(),p(Ye.$$.fragment),bn=s(),He=c("p"),He.textContent=oa,_n=s(),p(Le.$$.fragment),wn=s(),p(ze.$$.fragment),jn=s(),Ae=c("p"),Ae.textContent=pa,Cn=s(),p(Re.$$.fragment),In=s(),Xe=c("p"),Xe.textContent=ga,Un=s(),p(Fe.$$.fragment),$n=s(),p(Pe.$$.fragment),Tn=s(),De=c("p"),this.h()},l(e){const t=Ua("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(n),y=l(e),o=r(e,"P",{}),ba(o).forEach(n),M=l(e),g(I.$$.fragment,e),j=l(e),C=r(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-411gzg"&&(C.innerHTML=Zn),et=l(e),x=r(e,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-lzzf1y"&&(x.innerHTML=kn),tt=l(e),v=r(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-8vqzwx"&&(v.innerHTML=Wn),nt=l(e),g(U.$$.fragment,e),at=l(e),g(G.$$.fragment,e),st=l(e),V=r(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-8lplub"&&(V.textContent=xn),lt=l(e),g(q.$$.fragment,e),it=l(e),N=r(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-zlnbin"&&(N.innerHTML=vn),ct=l(e),B=r(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1duwzc7"&&(B.innerHTML=Gn),rt=l(e),g(S.$$.fragment,e),ot=l(e),Q=r(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-18pu7mk"&&(Q.innerHTML=Vn),pt=l(e),g($.$$.fragment,e),gt=l(e),g(E.$$.fragment,e),ft=l(e),Y=r(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1npu22n"&&(Y.textContent=qn),ut=l(e),g(H.$$.fragment,e),ht=l(e),g(T.$$.fragment,e),dt=l(e),g(L.$$.fragment,e),mt=l(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-cp0irx"&&(z.innerHTML=Nn),yt=l(e),g(A.$$.fragment,e),Mt=l(e),g(R.$$.fragment,e),bt=l(e),X=r(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-16ezz9i"&&(X.innerHTML=Bn),_t=l(e),g(F.$$.fragment,e),wt=l(e),g(J.$$.fragment,e),jt=l(e),g(P.$$.fragment,e),Ct=l(e),K=r(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-bmxago"&&(K.innerHTML=Sn),It=l(e),g(O.$$.fragment,e),Ut=l(e),D=r(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-qk1tfe"&&(D.innerHTML=Qn),$t=l(e),ee=r(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-pilp6s"&&(ee.innerHTML=En),Tt=l(e),g(te.$$.fragment,e),Jt=l(e),ne=r(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1qxb1fg"&&(ne.innerHTML=Yn),Zt=l(e),ae=r(e,"OL",{"data-svelte-h":!0}),m(ae)!=="svelte-4ur4nn"&&(ae.innerHTML=Hn),kt=l(e),g(Z.$$.fragment,e),Wt=l(e),g(se.$$.fragment,e),xt=l(e),le=r(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1cs2zny"&&(le.innerHTML=Ln),vt=l(e),ie=r(e,"TABLE",{"data-svelte-h":!0}),m(ie)!=="svelte-1crur8d"&&(ie.innerHTML=zn),Gt=l(e),g(k.$$.fragment,e),Vt=l(e),g(ce.$$.fragment,e),qt=l(e),re=r(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1qo8j8q"&&(re.innerHTML=An),Nt=l(e),g(oe.$$.fragment,e),Bt=l(e),g(pe.$$.fragment,e),St=l(e),ge=r(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1gqwj00"&&(ge.innerHTML=Rn),Qt=l(e),g(fe.$$.fragment,e),Et=l(e),ue=r(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1mfo4s0"&&(ue.innerHTML=Xn),Yt=l(e),g(he.$$.fragment,e),Ht=l(e),de=r(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-q492az"&&(de.innerHTML=Fn),Lt=l(e),g(me.$$.fragment,e),zt=l(e),ye=r(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-unl4rd"&&(ye.innerHTML=Pn),At=l(e),g(Me.$$.fragment,e),Rt=l(e),be=r(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-8gznjs"&&(be.textContent=Kn),Xt=l(e),_e=r(e,"UL",{"data-svelte-h":!0}),m(_e)!=="svelte-ovc80h"&&(_e.innerHTML=On),Ft=l(e),we=r(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1s1bl1c"&&(we.innerHTML=Dn),Pt=l(e),g(je.$$.fragment,e),Kt=l(e),g(Ce.$$.fragment,e),Ot=l(e),Ie=r(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-3fqvqv"&&(Ie.innerHTML=ea),Dt=l(e),Ue=r(e,"UL",{"data-svelte-h":!0}),m(Ue)!=="svelte-vaeuct"&&(Ue.innerHTML=ta),en=l(e),g($e.$$.fragment,e),tn=l(e),g(Te.$$.fragment,e),nn=l(e),Je=r(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-asubsz"&&(Je.innerHTML=na),an=l(e),Ze=r(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1upop6q"&&(Ze.innerHTML=aa),sn=l(e),g(ke.$$.fragment,e),ln=l(e),We=r(e,"P",{"data-svelte-h":!0}),m(We)!=="svelte-ft9vbs"&&(We.textContent=sa),cn=l(e),g(xe.$$.fragment,e),rn=l(e),ve=r(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-8wg17z"&&(ve.textContent=la),on=l(e),g(Ge.$$.fragment,e),pn=l(e),g(Ve.$$.fragment,e),gn=l(e),qe=r(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-ft9vbs"&&(qe.textContent=ia),fn=l(e),g(Ne.$$.fragment,e),un=l(e),Be=r(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-8wg17z"&&(Be.textContent=ca),hn=l(e),g(Se.$$.fragment,e),dn=l(e),g(W.$$.fragment,e),mn=l(e),g(Qe.$$.fragment,e),yn=l(e),Ee=r(e,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-ft9vbs"&&(Ee.textContent=ra),Mn=l(e),g(Ye.$$.fragment,e),bn=l(e),He=r(e,"P",{"data-svelte-h":!0}),m(He)!=="svelte-8wg17z"&&(He.textContent=oa),_n=l(e),g(Le.$$.fragment,e),wn=l(e),g(ze.$$.fragment,e),jn=l(e),Ae=r(e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-ft9vbs"&&(Ae.textContent=pa),Cn=l(e),g(Re.$$.fragment,e),In=l(e),Xe=r(e,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-8wg17z"&&(Xe.textContent=ga),Un=l(e),g(Fe.$$.fragment,e),$n=l(e),g(Pe.$$.fragment,e),Tn=l(e),De=r(e,"P",{}),ba(De).forEach(n),this.h()},h(){_a(i,"name","hf:doc:metadata"),_a(i,"content",qa)},m(e,t){$a(document.head,i),a(e,y,t),a(e,o,t),a(e,M,t),f(I,e,t),a(e,j,t),a(e,C,t),a(e,et,t),a(e,x,t),a(e,tt,t),a(e,v,t),a(e,nt,t),f(U,e,t),a(e,at,t),f(G,e,t),a(e,st,t),a(e,V,t),a(e,lt,t),f(q,e,t),a(e,it,t),a(e,N,t),a(e,ct,t),a(e,B,t),a(e,rt,t),f(S,e,t),a(e,ot,t),a(e,Q,t),a(e,pt,t),f($,e,t),a(e,gt,t),f(E,e,t),a(e,ft,t),a(e,Y,t),a(e,ut,t),f(H,e,t),a(e,ht,t),f(T,e,t),a(e,dt,t),f(L,e,t),a(e,mt,t),a(e,z,t),a(e,yt,t),f(A,e,t),a(e,Mt,t),f(R,e,t),a(e,bt,t),a(e,X,t),a(e,_t,t),f(F,e,t),a(e,wt,t),f(J,e,t),a(e,jt,t),f(P,e,t),a(e,Ct,t),a(e,K,t),a(e,It,t),f(O,e,t),a(e,Ut,t),a(e,D,t),a(e,$t,t),a(e,ee,t),a(e,Tt,t),f(te,e,t),a(e,Jt,t),a(e,ne,t),a(e,Zt,t),a(e,ae,t),a(e,kt,t),f(Z,e,t),a(e,Wt,t),f(se,e,t),a(e,xt,t),a(e,le,t),a(e,vt,t),a(e,ie,t),a(e,Gt,t),f(k,e,t),a(e,Vt,t),f(ce,e,t),a(e,qt,t),a(e,re,t),a(e,Nt,t),f(oe,e,t),a(e,Bt,t),f(pe,e,t),a(e,St,t),a(e,ge,t),a(e,Qt,t),f(fe,e,t),a(e,Et,t),a(e,ue,t),a(e,Yt,t),f(he,e,t),a(e,Ht,t),a(e,de,t),a(e,Lt,t),f(me,e,t),a(e,zt,t),a(e,ye,t),a(e,At,t),f(Me,e,t),a(e,Rt,t),a(e,be,t),a(e,Xt,t),a(e,_e,t),a(e,Ft,t),a(e,we,t),a(e,Pt,t),f(je,e,t),a(e,Kt,t),f(Ce,e,t),a(e,Ot,t),a(e,Ie,t),a(e,Dt,t),a(e,Ue,t),a(e,en,t),f($e,e,t),a(e,tn,t),f(Te,e,t),a(e,nn,t),a(e,Je,t),a(e,an,t),a(e,Ze,t),a(e,sn,t),f(ke,e,t),a(e,ln,t),a(e,We,t),a(e,cn,t),f(xe,e,t),a(e,rn,t),a(e,ve,t),a(e,on,t),f(Ge,e,t),a(e,pn,t),f(Ve,e,t),a(e,gn,t),a(e,qe,t),a(e,fn,t),f(Ne,e,t),a(e,un,t),a(e,Be,t),a(e,hn,t),f(Se,e,t),a(e,dn,t),f(W,e,t),a(e,mn,t),f(Qe,e,t),a(e,yn,t),a(e,Ee,t),a(e,Mn,t),f(Ye,e,t),a(e,bn,t),a(e,He,t),a(e,_n,t),f(Le,e,t),a(e,wn,t),f(ze,e,t),a(e,jn,t),a(e,Ae,t),a(e,Cn,t),f(Re,e,t),a(e,In,t),a(e,Xe,t),a(e,Un,t),f(Fe,e,t),a(e,$n,t),f(Pe,e,t),a(e,Tn,t),a(e,De,t),Jn=!0},p(e,[t]){const fa={};t&2&&(fa.$$scope={dirty:t,ctx:e}),U.$set(fa);const ua={};t&2&&(ua.$$scope={dirty:t,ctx:e}),$.$set(ua);const ha={};t&2&&(ha.$$scope={dirty:t,ctx:e}),T.$set(ha);const da={};t&2&&(da.$$scope={dirty:t,ctx:e}),J.$set(da);const ma={};t&2&&(ma.$$scope={dirty:t,ctx:e}),Z.$set(ma);const ya={};t&2&&(ya.$$scope={dirty:t,ctx:e}),k.$set(ya);const Ma={};t&2&&(Ma.$$scope={dirty:t,ctx:e}),W.$set(Ma)},i(e){Jn||(u(I.$$.fragment,e),u(U.$$.fragment,e),u(G.$$.fragment,e),u(q.$$.fragment,e),u(S.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(H.$$.fragment,e),u(T.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(R.$$.fragment,e),u(F.$$.fragment,e),u(J.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(Z.$$.fragment,e),u(se.$$.fragment,e),u(k.$$.fragment,e),u(ce.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u($e.$$.fragment,e),u(Te.$$.fragment,e),u(ke.$$.fragment,e),u(xe.$$.fragment,e),u(Ge.$$.fragment,e),u(Ve.$$.fragment,e),u(Ne.$$.fragment,e),u(Se.$$.fragment,e),u(W.$$.fragment,e),u(Qe.$$.fragment,e),u(Ye.$$.fragment,e),u(Le.$$.fragment,e),u(ze.$$.fragment,e),u(Re.$$.fragment,e),u(Fe.$$.fragment,e),u(Pe.$$.fragment,e),Jn=!0)},o(e){h(I.$$.fragment,e),h(U.$$.fragment,e),h(G.$$.fragment,e),h(q.$$.fragment,e),h(S.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(T.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(R.$$.fragment,e),h(F.$$.fragment,e),h(J.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(Z.$$.fragment,e),h(se.$$.fragment,e),h(k.$$.fragment,e),h(ce.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),h(me.$$.fragment,e),h(Me.$$.fragment,e),h(je.$$.fragment,e),h(Ce.$$.fragment,e),h($e.$$.fragment,e),h(Te.$$.fragment,e),h(ke.$$.fragment,e),h(xe.$$.fragment,e),h(Ge.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(Se.$$.fragment,e),h(W.$$.fragment,e),h(Qe.$$.fragment,e),h(Ye.$$.fragment,e),h(Le.$$.fragment,e),h(ze.$$.fragment,e),h(Re.$$.fragment,e),h(Fe.$$.fragment,e),h(Pe.$$.fragment,e),Jn=!1},d(e){e&&(n(y),n(o),n(M),n(j),n(C),n(et),n(x),n(tt),n(v),n(nt),n(at),n(st),n(V),n(lt),n(it),n(N),n(ct),n(B),n(rt),n(ot),n(Q),n(pt),n(gt),n(ft),n(Y),n(ut),n(ht),n(dt),n(mt),n(z),n(yt),n(Mt),n(bt),n(X),n(_t),n(wt),n(jt),n(Ct),n(K),n(It),n(Ut),n(D),n($t),n(ee),n(Tt),n(Jt),n(ne),n(Zt),n(ae),n(kt),n(Wt),n(xt),n(le),n(vt),n(ie),n(Gt),n(Vt),n(qt),n(re),n(Nt),n(Bt),n(St),n(ge),n(Qt),n(Et),n(ue),n(Yt),n(Ht),n(de),n(Lt),n(zt),n(ye),n(At),n(Rt),n(be),n(Xt),n(_e),n(Ft),n(we),n(Pt),n(Kt),n(Ot),n(Ie),n(Dt),n(Ue),n(en),n(tn),n(nn),n(Je),n(an),n(Ze),n(sn),n(ln),n(We),n(cn),n(rn),n(ve),n(on),n(pn),n(gn),n(qe),n(fn),n(un),n(Be),n(hn),n(dn),n(mn),n(yn),n(Ee),n(Mn),n(bn),n(He),n(_n),n(wn),n(jn),n(Ae),n(Cn),n(In),n(Xe),n(Un),n($n),n(Tn),n(De)),n(i),d(I,e),d(U,e),d(G,e),d(q,e),d(S,e),d($,e),d(E,e),d(H,e),d(T,e),d(L,e),d(A,e),d(R,e),d(F,e),d(J,e),d(P,e),d(O,e),d(te,e),d(Z,e),d(se,e),d(k,e),d(ce,e),d(oe,e),d(pe,e),d(fe,e),d(he,e),d(me,e),d(Me,e),d(je,e),d(Ce,e),d($e,e),d(Te,e),d(ke,e),d(xe,e),d(Ge,e),d(Ve,e),d(Ne,e),d(Se,e),d(W,e),d(Qe,e),d(Ye,e),d(Le,e),d(ze,e),d(Re,e),d(Fe,e),d(Pe,e)}}}const qa='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using a specific URL","local":"using-a-specific-url","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"OpenAI compatibility","local":"openai-compatibility","sections":[],"depth":2},{"title":"Supported tasks","local":"supported-tasks","sections":[],"depth":2},{"title":"Custom requests","local":"custom-requests","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2},{"title":"Legacy InferenceAPI client","local":"legacy-inferenceapi-client","sections":[{"title":"Initialization","local":"initialization","sections":[],"depth":3},{"title":"Run on a specific task","local":"run-on-a-specific-task","sections":[],"depth":3},{"title":"Run custom request","local":"run-custom-request","sections":[],"depth":3},{"title":"Run with parameters","local":"run-with-parameters","sections":[],"depth":3}],"depth":2}],"depth":1}';function Na(w){return ja(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ha extends Ca{constructor(i){super(),Ia(this,i,Na,Va,wa,{})}}export{Ha as component};
