import{s as ls,n as cs,o as is}from"../chunks/scheduler.0219f8bd.js";import{S as as,i as ds,g as c,s as r,r as p,A as ps,h as i,f as s,c as l,j as n,u as m,x as a,k as d,y as ns,a as o,v as f,d as u,t as _,w as h}from"../chunks/index.f61edf3b.js";import{C as ms}from"../chunks/CodeBlock.38e566ae.js";import{H as T,E as fs}from"../chunks/EditOnGithub.48fa589f.js";function us(At){let P,_e,fe,he,M,Te,y,Pe,$,Ut="Processors are used to prepare inputs (e.g., text, image or audio) for a model.",Me,b,Et="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",ye,g,$e,w,It='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.Processor">.Processor</a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(config, components)</code></a></li> <li><em>instance</em><ul><li><a href="#module_processors.Processor+image_processor"><code>.image_processor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+tokenizer"><code>.tokenizer</code></a> ⇒ <code>PreTrainedTokenizer</code> | <code>undefined</code></li> <li><a href="#module_processors.Processor+feature_extractor"><code>.feature_extractor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+apply_chat_template"><code>.apply_chat_template(messages, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+batch_decode"><code>.batch_decode(...args)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_processors.Processor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..PreTrainedTokenizer"><code>~PreTrainedTokenizer</code></a> : <code>Object</code></li></ul></li></ul></li>',be,ge,we,x,xe,v,ve,j,Rt="Represents a Processor that extracts features from an input.",je,J,Nt='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Je,k,Bt='<li><a href="#module_processors.Processor">.Processor</a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(config, components)</code></a></li> <li><em>instance</em><ul><li><a href="#module_processors.Processor+image_processor"><code>.image_processor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+tokenizer"><code>.tokenizer</code></a> ⇒ <code>PreTrainedTokenizer</code> | <code>undefined</code></li> <li><a href="#module_processors.Processor+feature_extractor"><code>.feature_extractor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+apply_chat_template"><code>.apply_chat_template(messages, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+batch_decode"><code>.batch_decode(...args)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_processors.Processor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li>',ke,He,Ce,H,Le,C,ze,L,Qt="Creates a new Processor with the given components",Ae,z,Dt="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td> </tr><tr><td>components</td><td><code>Record.&lt;string, Object&gt;</code></td></tr></tbody>",Ue,Ee,Ie,A,Re,U,Ne,E,Zt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image processor of the processor, if it exists.',Be,Qe,De,I,Ze,R,Ye,N,Yt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>PreTrainedTokenizer</code> | <code>undefined</code> - The tokenizer of the processor, if it exists.',Xe,Ge,We,B,Fe,Q,Ke,D,Xt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The feature extractor of the processor, if it exists.',Oe,Se,Ve,Z,qe,Y,et,X,Gt='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a>',tt,G,Wt="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>messages</td><td><code>*</code></td> </tr><tr><td>options</td><td><code>*</code></td></tr></tbody>",st,ot,rt,W,lt,F,ct,K,Ft='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a>',it,O,Kt="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",at,dt,pt,S,nt,V,mt,q,Ot="Calls the feature_extractor function with the given input.",ft,ee,St='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',ut,te,Vt="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",_t,ht,Tt,se,Pt,oe,Mt,re,qt="Instantiate one of the processor classes of the library from a pretrained model.",yt,le,es=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,$t,ce,ts='<strong>Kind</strong>: static method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',bt,ie,ss=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>PretrainedProcessorOptions</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,gt,wt,xt,ae,vt,de,jt,pe,os="Additional processor-specific properties.",Jt,ne,rs='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',kt,Ht,Ct,me,Lt,ue,zt;return y=new T({props:{title:"processors",local:"processors",headingTag:"h1"}}),g=new ms({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNvbnN0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFjb25zdCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWNvbnN0JTIwJTdCJTIwaW5wdXRfZmVhdHVyZXMlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMHByb2Nlc3NvcihhdWRpbyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDI0MDAwMCklMjAlNUIwLjQ3NTI5ODQ2NDI5ODI0ODMlMkMlMjAwLjU1OTcyNTg4MDYyMjg2MzglMkMlMjAwLjU2NDM0MTY2NDMxNDI3JTJDJTIwLi4uJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QjElMkMlMjA4MCUyQyUyMDMwMDAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2l6ZSUzQSUyMDI0MDAwMCUyQyUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">const</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">const</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">const</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),v=new T({props:{title:"processors.Processor",local:"processorsprocessor",headingTag:"h2"}}),C=new T({props:{title:"new Processor(config, components)",local:"new-processorconfig-components",headingTag:"h3"}}),U=new T({props:{title:"processor.image_processor ⇒ <code> * </code>",local:"processorimageprocessor--code--code",headingTag:"h3"}}),R=new T({props:{title:"processor.tokenizer ⇒ <code> PreTrainedTokenizer </code> | <code> undefined </code>",local:"processortokenizer--code-pretrainedtokenizer-code--code-undefined-code",headingTag:"h3"}}),Q=new T({props:{title:"processor.feature_extractor ⇒ <code> * </code>",local:"processorfeatureextractor--code--code",headingTag:"h3"}}),Y=new T({props:{title:"processor.apply_chat_template(messages, options) ⇒ <code> * </code>",local:"processorapplychattemplatemessages-options--code--code",headingTag:"h3"}}),F=new T({props:{title:"processor.batch_decode(...args) ⇒ <code> * </code>",local:"processorbatchdecodeargs--code--code",headingTag:"h3"}}),V=new T({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),oe=new T({props:{title:"Processor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"processorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),de=new T({props:{title:"processors~PreTrainedTokenizer : <code> Object </code>",local:"processorspretrainedtokenizer--code-object-code",headingTag:"h2"}}),me=new fs({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/processors.md"}}),{c(){P=c("meta"),_e=r(),fe=c("p"),he=r(),M=c("a"),Te=r(),p(y.$$.fragment),Pe=r(),$=c("p"),$.textContent=Ut,Me=r(),b=c("p"),b.innerHTML=Et,ye=r(),p(g.$$.fragment),$e=r(),w=c("ul"),w.innerHTML=It,be=r(),ge=c("hr"),we=r(),x=c("a"),xe=r(),p(v.$$.fragment),ve=r(),j=c("p"),j.textContent=Rt,je=r(),J=c("p"),J.innerHTML=Nt,Je=r(),k=c("ul"),k.innerHTML=Bt,ke=r(),He=c("hr"),Ce=r(),H=c("a"),Le=r(),p(C.$$.fragment),ze=r(),L=c("p"),L.textContent=Qt,Ae=r(),z=c("table"),z.innerHTML=Dt,Ue=r(),Ee=c("hr"),Ie=r(),A=c("a"),Re=r(),p(U.$$.fragment),Ne=r(),E=c("p"),E.innerHTML=Zt,Be=r(),Qe=c("hr"),De=r(),I=c("a"),Ze=r(),p(R.$$.fragment),Ye=r(),N=c("p"),N.innerHTML=Yt,Xe=r(),Ge=c("hr"),We=r(),B=c("a"),Fe=r(),p(Q.$$.fragment),Ke=r(),D=c("p"),D.innerHTML=Xt,Oe=r(),Se=c("hr"),Ve=r(),Z=c("a"),qe=r(),p(Y.$$.fragment),et=r(),X=c("p"),X.innerHTML=Gt,tt=r(),G=c("table"),G.innerHTML=Wt,st=r(),ot=c("hr"),rt=r(),W=c("a"),lt=r(),p(F.$$.fragment),ct=r(),K=c("p"),K.innerHTML=Ft,it=r(),O=c("table"),O.innerHTML=Kt,at=r(),dt=c("hr"),pt=r(),S=c("a"),nt=r(),p(V.$$.fragment),mt=r(),q=c("p"),q.textContent=Ot,ft=r(),ee=c("p"),ee.innerHTML=St,ut=r(),te=c("table"),te.innerHTML=Vt,_t=r(),ht=c("hr"),Tt=r(),se=c("a"),Pt=r(),p(oe.$$.fragment),Mt=r(),re=c("p"),re.textContent=qt,yt=r(),le=c("p"),le.innerHTML=es,$t=r(),ce=c("p"),ce.innerHTML=ts,bt=r(),ie=c("table"),ie.innerHTML=ss,gt=r(),wt=c("hr"),xt=r(),ae=c("a"),vt=r(),p(de.$$.fragment),jt=r(),pe=c("p"),pe.textContent=os,Jt=r(),ne=c("p"),ne.innerHTML=rs,kt=r(),Ht=c("hr"),Ct=r(),p(me.$$.fragment),Lt=r(),ue=c("p"),this.h()},l(e){const t=ps("svelte-u9bgzb",document.head);P=i(t,"META",{name:!0,content:!0}),t.forEach(s),_e=l(e),fe=i(e,"P",{}),n(fe).forEach(s),he=l(e),M=i(e,"A",{id:!0,class:!0}),n(M).forEach(s),Te=l(e),m(y.$$.fragment,e),Pe=l(e),$=i(e,"P",{"data-svelte-h":!0}),a($)!=="svelte-199vh5q"&&($.textContent=Ut),Me=l(e),b=i(e,"P",{"data-svelte-h":!0}),a(b)!=="svelte-1olsie5"&&(b.innerHTML=Et),ye=l(e),m(g.$$.fragment,e),$e=l(e),w=i(e,"UL",{"data-svelte-h":!0}),a(w)!=="svelte-194f3yo"&&(w.innerHTML=It),be=l(e),ge=i(e,"HR",{}),we=l(e),x=i(e,"A",{id:!0,class:!0}),n(x).forEach(s),xe=l(e),m(v.$$.fragment,e),ve=l(e),j=i(e,"P",{"data-svelte-h":!0}),a(j)!=="svelte-o9f953"&&(j.textContent=Rt),je=l(e),J=i(e,"P",{"data-svelte-h":!0}),a(J)!=="svelte-wmyz1o"&&(J.innerHTML=Nt),Je=l(e),k=i(e,"UL",{"data-svelte-h":!0}),a(k)!=="svelte-il7upz"&&(k.innerHTML=Bt),ke=l(e),He=i(e,"HR",{}),Ce=l(e),H=i(e,"A",{id:!0,class:!0}),n(H).forEach(s),Le=l(e),m(C.$$.fragment,e),ze=l(e),L=i(e,"P",{"data-svelte-h":!0}),a(L)!=="svelte-rj7jmq"&&(L.textContent=Qt),Ae=l(e),z=i(e,"TABLE",{"data-svelte-h":!0}),a(z)!=="svelte-4j8lfj"&&(z.innerHTML=Dt),Ue=l(e),Ee=i(e,"HR",{}),Ie=l(e),A=i(e,"A",{id:!0,class:!0}),n(A).forEach(s),Re=l(e),m(U.$$.fragment,e),Ne=l(e),E=i(e,"P",{"data-svelte-h":!0}),a(E)!=="svelte-gyqxdz"&&(E.innerHTML=Zt),Be=l(e),Qe=i(e,"HR",{}),De=l(e),I=i(e,"A",{id:!0,class:!0}),n(I).forEach(s),Ze=l(e),m(R.$$.fragment,e),Ye=l(e),N=i(e,"P",{"data-svelte-h":!0}),a(N)!=="svelte-ao82kh"&&(N.innerHTML=Yt),Xe=l(e),Ge=i(e,"HR",{}),We=l(e),B=i(e,"A",{id:!0,class:!0}),n(B).forEach(s),Fe=l(e),m(Q.$$.fragment,e),Ke=l(e),D=i(e,"P",{"data-svelte-h":!0}),a(D)!=="svelte-iz9woy"&&(D.innerHTML=Xt),Oe=l(e),Se=i(e,"HR",{}),Ve=l(e),Z=i(e,"A",{id:!0,class:!0}),n(Z).forEach(s),qe=l(e),m(Y.$$.fragment,e),et=l(e),X=i(e,"P",{"data-svelte-h":!0}),a(X)!=="svelte-jg083b"&&(X.innerHTML=Gt),tt=l(e),G=i(e,"TABLE",{"data-svelte-h":!0}),a(G)!=="svelte-1dyy5ym"&&(G.innerHTML=Wt),st=l(e),ot=i(e,"HR",{}),rt=l(e),W=i(e,"A",{id:!0,class:!0}),n(W).forEach(s),lt=l(e),m(F.$$.fragment,e),ct=l(e),K=i(e,"P",{"data-svelte-h":!0}),a(K)!=="svelte-jg083b"&&(K.innerHTML=Ft),it=l(e),O=i(e,"TABLE",{"data-svelte-h":!0}),a(O)!=="svelte-ee7emz"&&(O.innerHTML=Kt),at=l(e),dt=i(e,"HR",{}),pt=l(e),S=i(e,"A",{id:!0,class:!0}),n(S).forEach(s),nt=l(e),m(V.$$.fragment,e),mt=l(e),q=i(e,"P",{"data-svelte-h":!0}),a(q)!=="svelte-zbbm3j"&&(q.textContent=Ot),ft=l(e),ee=i(e,"P",{"data-svelte-h":!0}),a(ee)!=="svelte-kflsb2"&&(ee.innerHTML=St),ut=l(e),te=i(e,"TABLE",{"data-svelte-h":!0}),a(te)!=="svelte-pm1u9z"&&(te.innerHTML=Vt),_t=l(e),ht=i(e,"HR",{}),Tt=l(e),se=i(e,"A",{id:!0,class:!0}),n(se).forEach(s),Pt=l(e),m(oe.$$.fragment,e),Mt=l(e),re=i(e,"P",{"data-svelte-h":!0}),a(re)!=="svelte-jwfdp9"&&(re.textContent=qt),yt=l(e),le=i(e,"P",{"data-svelte-h":!0}),a(le)!=="svelte-t85gxq"&&(le.innerHTML=es),$t=l(e),ce=i(e,"P",{"data-svelte-h":!0}),a(ce)!=="svelte-vp40qx"&&(ce.innerHTML=ts),bt=l(e),ie=i(e,"TABLE",{"data-svelte-h":!0}),a(ie)!=="svelte-fupyjd"&&(ie.innerHTML=ss),gt=l(e),wt=i(e,"HR",{}),xt=l(e),ae=i(e,"A",{id:!0,class:!0}),n(ae).forEach(s),vt=l(e),m(de.$$.fragment,e),jt=l(e),pe=i(e,"P",{"data-svelte-h":!0}),a(pe)!=="svelte-ivm759"&&(pe.textContent=os),Jt=l(e),ne=i(e,"P",{"data-svelte-h":!0}),a(ne)!=="svelte-3xndnt"&&(ne.innerHTML=rs),kt=l(e),Ht=i(e,"HR",{}),Ct=l(e),m(me.$$.fragment,e),Lt=l(e),ue=i(e,"P",{}),n(ue).forEach(s),this.h()},h(){d(P,"name","hf:doc:metadata"),d(P,"content",_s),d(M,"id","module_processors"),d(M,"class","group"),d(x,"id","module_processors.Processor"),d(x,"class","group"),d(H,"id","new_module_processors.Processor_new"),d(H,"class","group"),d(A,"id","module_processors.Processor+image_processor"),d(A,"class","group"),d(I,"id","module_processors.Processor+tokenizer"),d(I,"class","group"),d(B,"id","module_processors.Processor+feature_extractor"),d(B,"class","group"),d(Z,"id","module_processors.Processor+apply_chat_template"),d(Z,"class","group"),d(W,"id","module_processors.Processor+batch_decode"),d(W,"class","group"),d(S,"id","module_processors.Processor+_call"),d(S,"class","group"),d(se,"id","module_processors.Processor.from_pretrained"),d(se,"class","group"),d(ae,"id","module_processors..PreTrainedTokenizer"),d(ae,"class","group")},m(e,t){ns(document.head,P),o(e,_e,t),o(e,fe,t),o(e,he,t),o(e,M,t),o(e,Te,t),f(y,e,t),o(e,Pe,t),o(e,$,t),o(e,Me,t),o(e,b,t),o(e,ye,t),f(g,e,t),o(e,$e,t),o(e,w,t),o(e,be,t),o(e,ge,t),o(e,we,t),o(e,x,t),o(e,xe,t),f(v,e,t),o(e,ve,t),o(e,j,t),o(e,je,t),o(e,J,t),o(e,Je,t),o(e,k,t),o(e,ke,t),o(e,He,t),o(e,Ce,t),o(e,H,t),o(e,Le,t),f(C,e,t),o(e,ze,t),o(e,L,t),o(e,Ae,t),o(e,z,t),o(e,Ue,t),o(e,Ee,t),o(e,Ie,t),o(e,A,t),o(e,Re,t),f(U,e,t),o(e,Ne,t),o(e,E,t),o(e,Be,t),o(e,Qe,t),o(e,De,t),o(e,I,t),o(e,Ze,t),f(R,e,t),o(e,Ye,t),o(e,N,t),o(e,Xe,t),o(e,Ge,t),o(e,We,t),o(e,B,t),o(e,Fe,t),f(Q,e,t),o(e,Ke,t),o(e,D,t),o(e,Oe,t),o(e,Se,t),o(e,Ve,t),o(e,Z,t),o(e,qe,t),f(Y,e,t),o(e,et,t),o(e,X,t),o(e,tt,t),o(e,G,t),o(e,st,t),o(e,ot,t),o(e,rt,t),o(e,W,t),o(e,lt,t),f(F,e,t),o(e,ct,t),o(e,K,t),o(e,it,t),o(e,O,t),o(e,at,t),o(e,dt,t),o(e,pt,t),o(e,S,t),o(e,nt,t),f(V,e,t),o(e,mt,t),o(e,q,t),o(e,ft,t),o(e,ee,t),o(e,ut,t),o(e,te,t),o(e,_t,t),o(e,ht,t),o(e,Tt,t),o(e,se,t),o(e,Pt,t),f(oe,e,t),o(e,Mt,t),o(e,re,t),o(e,yt,t),o(e,le,t),o(e,$t,t),o(e,ce,t),o(e,bt,t),o(e,ie,t),o(e,gt,t),o(e,wt,t),o(e,xt,t),o(e,ae,t),o(e,vt,t),f(de,e,t),o(e,jt,t),o(e,pe,t),o(e,Jt,t),o(e,ne,t),o(e,kt,t),o(e,Ht,t),o(e,Ct,t),f(me,e,t),o(e,Lt,t),o(e,ue,t),zt=!0},p:cs,i(e){zt||(u(y.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(U.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(V.$$.fragment,e),u(oe.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),zt=!0)},o(e){_(y.$$.fragment,e),_(g.$$.fragment,e),_(v.$$.fragment,e),_(C.$$.fragment,e),_(U.$$.fragment,e),_(R.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(F.$$.fragment,e),_(V.$$.fragment,e),_(oe.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),zt=!1},d(e){e&&(s(_e),s(fe),s(he),s(M),s(Te),s(Pe),s($),s(Me),s(b),s(ye),s($e),s(w),s(be),s(ge),s(we),s(x),s(xe),s(ve),s(j),s(je),s(J),s(Je),s(k),s(ke),s(He),s(Ce),s(H),s(Le),s(ze),s(L),s(Ae),s(z),s(Ue),s(Ee),s(Ie),s(A),s(Re),s(Ne),s(E),s(Be),s(Qe),s(De),s(I),s(Ze),s(Ye),s(N),s(Xe),s(Ge),s(We),s(B),s(Fe),s(Ke),s(D),s(Oe),s(Se),s(Ve),s(Z),s(qe),s(et),s(X),s(tt),s(G),s(st),s(ot),s(rt),s(W),s(lt),s(ct),s(K),s(it),s(O),s(at),s(dt),s(pt),s(S),s(nt),s(mt),s(q),s(ft),s(ee),s(ut),s(te),s(_t),s(ht),s(Tt),s(se),s(Pt),s(Mt),s(re),s(yt),s(le),s($t),s(ce),s(bt),s(ie),s(gt),s(wt),s(xt),s(ae),s(vt),s(jt),s(pe),s(Jt),s(ne),s(kt),s(Ht),s(Ct),s(Lt),s(ue)),s(P),h(y,e),h(g,e),h(v,e),h(C,e),h(U,e),h(R,e),h(Q,e),h(Y,e),h(F,e),h(V,e),h(oe,e),h(de,e),h(me,e)}}}const _s='{"title":"processors","local":"processors","sections":[{"title":"processors.Processor","local":"processorsprocessor","sections":[{"title":"new Processor(config, components)","local":"new-processorconfig-components","sections":[],"depth":3},{"title":"processor.image_processor ⇒ <code> * </code>","local":"processorimageprocessor--code--code","sections":[],"depth":3},{"title":"processor.tokenizer ⇒ <code> PreTrainedTokenizer </code> | <code> undefined </code>","local":"processortokenizer--code-pretrainedtokenizer-code--code-undefined-code","sections":[],"depth":3},{"title":"processor.feature_extractor ⇒ <code> * </code>","local":"processorfeatureextractor--code--code","sections":[],"depth":3},{"title":"processor.apply_chat_template(messages, options) ⇒ <code> * </code>","local":"processorapplychattemplatemessages-options--code--code","sections":[],"depth":3},{"title":"processor.batch_decode(...args) ⇒ <code> * </code>","local":"processorbatchdecodeargs--code--code","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3},{"title":"Processor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"processorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~PreTrainedTokenizer : <code> Object </code>","local":"processorspretrainedtokenizer--code-object-code","sections":[],"depth":2}],"depth":1}';function hs(At){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends as{constructor(P){super(),ds(this,P,hs,us,ls,{})}}export{$s as component};
