import{s as ke,n as ve,o as Re}from"../chunks/scheduler.f6319a2a.js";import{S as Be,i as Ie,g as c,s,r as i,A as Ze,h as m,f as n,c as a,j as je,u as p,x as E,k as Ce,y as Ae,a as l,v as o,d as r,t as d,w as u}from"../chunks/index.85aa684c.js";import{C as Q}from"../chunks/CodeBlock.3400fc53.js";import{H as y,E as Ge}from"../chunks/getInferenceSnippets.f5cbfd41.js";function He(Me){let h,V,x,X,g,q,M,fe=`This guide demonstrates how to integrate a synchronous agent from the <code>smolagents</code> library into an asynchronous Python web application using Starlette.
The example is designed to help users new to async Python and agent integration understand best practices for combining synchronous agent logic with async web servers.`,L,f,F,$,$e="<li><strong>Starlette</strong>: A lightweight ASGI framework for building asynchronous web applications in Python.</li> <li><strong>anyio.to_thread.run_sync</strong>: Utility to run blocking (synchronous) code in a background thread, preventing it from blocking the async event loop.</li> <li><strong>CodeAgent</strong>: An agent from the <code>smolagents</code> library capable of programmatically solving tasks.</li>",Y,w,z,T,we="<code>CodeAgent.run()</code> executes Python code synchronously. If called directly in an async endpoint, it would block Starlette’s event loop, reducing performance and scalability. By offloading this operation to a background thread with <code>anyio.to_thread.run_sync</code>, you keep the app responsive and efficient, even under high concurrency.",P,U,O,b,Te="<li>The Starlette app exposes a <code>/run-agent</code> endpoint that accepts a JSON payload with a <code>task</code> string.</li> <li>When a request is received, the agent is run in a background thread using <code>anyio.to_thread.run_sync</code>.</li> <li>The result is returned as a JSON response.</li>",D,J,K,j,ee,C,te,k,ne,v,le,R,se,B,ae,I,ie,Z,pe,A,Ue="<strong>Expected Response:</strong>",oe,G,re,H,de,_,be='<li><a href="https://www.starlette.io/" rel="nofollow">Starlette Documentation</a></li> <li><a href="https://anyio.readthedocs.io/" rel="nofollow">anyio Documentation</a></li>',ue,ce,me,S,Je='For the full code, see <a href="https://github.com/huggingface/smolagents/tree/main/examples/async_agent" rel="nofollow"><code>examples/async_agent</code></a>.',ye,W,he,N,ge;return g=new y({props:{title:"Async Applications with Agents",local:"async-applications-with-agents",headingTag:"h1"}}),f=new y({props:{title:"Overview",local:"overview",headingTag:"h2"}}),w=new y({props:{title:"Why Use a Background Thread?",local:"why-use-a-background-thread",headingTag:"h2"}}),U=new y({props:{title:"Example Workflow",local:"example-workflow",headingTag:"h2"}}),J=new y({props:{title:"Building a Starlette App with a CodeAgent",local:"building-a-starlette-app-with-a-codeagent",headingTag:"h2"}}),j=new y({props:{title:"1. Install Dependencies",local:"1-install-dependencies",headingTag:"h3"}}),C=new Q({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBzdGFybGV0dGUlMjBhbnlpbyUyMHV2aWNvcm4=",highlighted:"pip install smolagents starlette anyio uvicorn",wrap:!1}}),k=new y({props:{title:"2. Application Code ( main.py )",local:"2-application-code--mainpy-",headingTag:"h3"}}),v=new Q({props:{code:"aW1wb3J0JTIwYW55aW8udG9fdGhyZWFkJTBBZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBzdGFybGV0dGUucmVzcG9uc2VzJTIwaW1wb3J0JTIwSlNPTlJlc3BvbnNlJTBBZnJvbSUyMHN0YXJsZXR0ZS5yb3V0aW5nJTIwaW1wb3J0JTIwUm91dGUlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbChtb2RlbF9pZCUzRCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSklMEElMEFhc3luYyUyMGRlZiUyMHJ1bl9hZ2VudChyZXF1ZXN0JTNBJTIwUmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0Lmpzb24oKSUwQSUyMCUyMCUyMCUyMHRhc2slMjAlM0QlMjBkYXRhLmdldCglMjJ0YXNrJTIyJTJDJTIwJTIyJTIyKSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJ1biUyMHRoZSUyMGFnZW50JTIwc3luY2hyb25vdXNseSUyMGluJTIwYSUyMGJhY2tncm91bmQlMjB0aHJlYWQlMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGFueWlvLnRvX3RocmVhZC5ydW5fc3luYyhhZ2VudC5ydW4lMkMlMjB0YXNrKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEpTT05SZXNwb25zZSglN0IlMjJyZXN1bHQlMjIlM0ElMjByZXN1bHQlN0QpJTBBJTBBYXBwJTIwJTNEJTIwU3RhcmxldHRlKHJvdXRlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMFJvdXRlKCUyMiUyRnJ1bi1hZ2VudCUyMiUyQyUyMHJ1bl9hZ2VudCUyQyUyMG1ldGhvZHMlM0QlNUIlMjJQT1NUJTIyJTVEKSUyQyUwQSU1RCk=",highlighted:`<span class="hljs-keyword">import</span> anyio.to_thread
<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.requests <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
    tools=[],
)

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_agent</span>(<span class="hljs-params">request: Request</span>):
    data = <span class="hljs-keyword">await</span> request.json()
    task = data.get(<span class="hljs-string">&quot;task&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)
    <span class="hljs-comment"># Run the agent synchronously in a background thread</span>
    result = <span class="hljs-keyword">await</span> anyio.to_thread.run_sync(agent.run, task)
    <span class="hljs-keyword">return</span> JSONResponse({<span class="hljs-string">&quot;result&quot;</span>: result})

app = Starlette(routes=[
    Route(<span class="hljs-string">&quot;/run-agent&quot;</span>, run_agent, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
])`,wrap:!1}}),R=new y({props:{title:"3. Run the App",local:"3-run-the-app",headingTag:"h3"}}),B=new Q({props:{code:"dXZpY29ybiUyMGFzeW5jX2FnZW50Lm1haW4lM0FhcHAlMjAtLXJlbG9hZA==",highlighted:"uvicorn async_agent.main:app --reload",wrap:!1}}),I=new y({props:{title:"4. Test the Endpoint",local:"4-test-the-endpoint",headingTag:"h3"}}),Z=new Q({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDAwJTJGcnVuLWFnZW50JTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUyMC1kJTIwJyU3QiUyMnRhc2slMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjAyJTJCMiUzRiUyMiU3RCc=",highlighted:'curl -X POST http://localhost:8000/run-agent -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> -d <span class="hljs-string">&#x27;{&quot;task&quot;: &quot;What is 2+2?&quot;}&#x27;</span>',wrap:!1}}),G=new Q({props:{code:"JTdCJTIycmVzdWx0JTIyJTNBJTIwJTIyNCUyMiU3RA==",highlighted:'<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;result&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;4&quot;</span><span class="hljs-punctuation">}</span>',wrap:!1}}),H=new y({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),W=new Ge({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/async_agent.md"}}),{c(){h=c("meta"),V=s(),x=c("p"),X=s(),i(g.$$.fragment),q=s(),M=c("p"),M.innerHTML=fe,L=s(),i(f.$$.fragment),F=s(),$=c("ul"),$.innerHTML=$e,Y=s(),i(w.$$.fragment),z=s(),T=c("p"),T.innerHTML=we,P=s(),i(U.$$.fragment),O=s(),b=c("ul"),b.innerHTML=Te,D=s(),i(J.$$.fragment),K=s(),i(j.$$.fragment),ee=s(),i(C.$$.fragment),te=s(),i(k.$$.fragment),ne=s(),i(v.$$.fragment),le=s(),i(R.$$.fragment),se=s(),i(B.$$.fragment),ae=s(),i(I.$$.fragment),ie=s(),i(Z.$$.fragment),pe=s(),A=c("p"),A.innerHTML=Ue,oe=s(),i(G.$$.fragment),re=s(),i(H.$$.fragment),de=s(),_=c("ul"),_.innerHTML=be,ue=s(),ce=c("hr"),me=s(),S=c("p"),S.innerHTML=Je,ye=s(),i(W.$$.fragment),he=s(),N=c("p"),this.h()},l(e){const t=Ze("svelte-u9bgzb",document.head);h=m(t,"META",{name:!0,content:!0}),t.forEach(n),V=a(e),x=m(e,"P",{}),je(x).forEach(n),X=a(e),p(g.$$.fragment,e),q=a(e),M=m(e,"P",{"data-svelte-h":!0}),E(M)!=="svelte-1sp3xbb"&&(M.innerHTML=fe),L=a(e),p(f.$$.fragment,e),F=a(e),$=m(e,"UL",{"data-svelte-h":!0}),E($)!=="svelte-jb7c4l"&&($.innerHTML=$e),Y=a(e),p(w.$$.fragment,e),z=a(e),T=m(e,"P",{"data-svelte-h":!0}),E(T)!=="svelte-nzal2x"&&(T.innerHTML=we),P=a(e),p(U.$$.fragment,e),O=a(e),b=m(e,"UL",{"data-svelte-h":!0}),E(b)!=="svelte-14mqlu7"&&(b.innerHTML=Te),D=a(e),p(J.$$.fragment,e),K=a(e),p(j.$$.fragment,e),ee=a(e),p(C.$$.fragment,e),te=a(e),p(k.$$.fragment,e),ne=a(e),p(v.$$.fragment,e),le=a(e),p(R.$$.fragment,e),se=a(e),p(B.$$.fragment,e),ae=a(e),p(I.$$.fragment,e),ie=a(e),p(Z.$$.fragment,e),pe=a(e),A=m(e,"P",{"data-svelte-h":!0}),E(A)!=="svelte-txxf38"&&(A.innerHTML=Ue),oe=a(e),p(G.$$.fragment,e),re=a(e),p(H.$$.fragment,e),de=a(e),_=m(e,"UL",{"data-svelte-h":!0}),E(_)!=="svelte-1ned3mp"&&(_.innerHTML=be),ue=a(e),ce=m(e,"HR",{}),me=a(e),S=m(e,"P",{"data-svelte-h":!0}),E(S)!=="svelte-bfduaj"&&(S.innerHTML=Je),ye=a(e),p(W.$$.fragment,e),he=a(e),N=m(e,"P",{}),je(N).forEach(n),this.h()},h(){Ce(h,"name","hf:doc:metadata"),Ce(h,"content",_e)},m(e,t){Ae(document.head,h),l(e,V,t),l(e,x,t),l(e,X,t),o(g,e,t),l(e,q,t),l(e,M,t),l(e,L,t),o(f,e,t),l(e,F,t),l(e,$,t),l(e,Y,t),o(w,e,t),l(e,z,t),l(e,T,t),l(e,P,t),o(U,e,t),l(e,O,t),l(e,b,t),l(e,D,t),o(J,e,t),l(e,K,t),o(j,e,t),l(e,ee,t),o(C,e,t),l(e,te,t),o(k,e,t),l(e,ne,t),o(v,e,t),l(e,le,t),o(R,e,t),l(e,se,t),o(B,e,t),l(e,ae,t),o(I,e,t),l(e,ie,t),o(Z,e,t),l(e,pe,t),l(e,A,t),l(e,oe,t),o(G,e,t),l(e,re,t),o(H,e,t),l(e,de,t),l(e,_,t),l(e,ue,t),l(e,ce,t),l(e,me,t),l(e,S,t),l(e,ye,t),o(W,e,t),l(e,he,t),l(e,N,t),ge=!0},p:ve,i(e){ge||(r(g.$$.fragment,e),r(f.$$.fragment,e),r(w.$$.fragment,e),r(U.$$.fragment,e),r(J.$$.fragment,e),r(j.$$.fragment,e),r(C.$$.fragment,e),r(k.$$.fragment,e),r(v.$$.fragment,e),r(R.$$.fragment,e),r(B.$$.fragment,e),r(I.$$.fragment,e),r(Z.$$.fragment,e),r(G.$$.fragment,e),r(H.$$.fragment,e),r(W.$$.fragment,e),ge=!0)},o(e){d(g.$$.fragment,e),d(f.$$.fragment,e),d(w.$$.fragment,e),d(U.$$.fragment,e),d(J.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(R.$$.fragment,e),d(B.$$.fragment,e),d(I.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(H.$$.fragment,e),d(W.$$.fragment,e),ge=!1},d(e){e&&(n(V),n(x),n(X),n(q),n(M),n(L),n(F),n($),n(Y),n(z),n(T),n(P),n(O),n(b),n(D),n(K),n(ee),n(te),n(ne),n(le),n(se),n(ae),n(ie),n(pe),n(A),n(oe),n(re),n(de),n(_),n(ue),n(ce),n(me),n(S),n(ye),n(he),n(N)),n(h),u(g,e),u(f,e),u(w,e),u(U,e),u(J,e),u(j,e),u(C,e),u(k,e),u(v,e),u(R,e),u(B,e),u(I,e),u(Z,e),u(G,e),u(H,e),u(W,e)}}}const _e='{"title":"Async Applications with Agents","local":"async-applications-with-agents","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Why Use a Background Thread?","local":"why-use-a-background-thread","sections":[],"depth":2},{"title":"Example Workflow","local":"example-workflow","sections":[],"depth":2},{"title":"Building a Starlette App with a CodeAgent","local":"building-a-starlette-app-with-a-codeagent","sections":[{"title":"1. Install Dependencies","local":"1-install-dependencies","sections":[],"depth":3},{"title":"2. Application Code ( main.py )","local":"2-application-code--mainpy-","sections":[],"depth":3},{"title":"3. Run the App","local":"3-run-the-app","sections":[],"depth":3},{"title":"4. Test the Endpoint","local":"4-test-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Se(Me){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qe extends Be{constructor(h){super(),Ie(this,h,Se,He,ke,{})}}export{Qe as component};
