import{s as fl,o as gl,n as Jl}from"../chunks/scheduler.3e4cb221.js";import{S as hl,i as yl,g as a,s,r as M,A as dl,h as o,f as l,c as i,j as Le,u as m,x as r,k as Tl,y as bt,a as n,v as p,d as u,t as c,w as T}from"../chunks/index.bc693fcb.js";import{H as J,T as jl,E as wl}from"../chunks/getInferenceSnippets.65765a9b.js";import{C as Ct}from"../chunks/CodeBlock.4d312707.js";function Ul(vt){let f,j='For a detailed comparison of the different hardware flavors, you can check out the <a href="https://huggingface.co/pricing" rel="nofollow">Pricing Page</a> page.';return{c(){f=a("p"),f.innerHTML=j},l(h){f=o(h,"P",{"data-svelte-h":!0}),r(f)!=="svelte-qkmz10"&&(f.innerHTML=j)},m(h,jt){n(h,f,jt)},p:Jl,d(h){h&&l(f)}}}function bl(vt){let f,j,h,jt,w,$t,U,Ee="<strong>Hugging Face Jobs</strong> provides fully managed cloud infrastructure for training models without the hassle of setting up GPUs, managing dependencies, or configuring environments locally. This is particularly valuable for SFT training, which can be resource-intensive and time-consuming.",_t,b,Bt,C,Ze="<li><strong>Scalable Infrastructure</strong>: Access to high-end GPUs (A100, L4, etc.) without hardware investment</li> <li><strong>Zero Setup</strong>: No need to manage CUDA drivers, Docker containers, or environment configurations</li> <li><strong>Cost Effective</strong>: Pay only for compute time used, with automatic shutdown after completion</li> <li><strong>Integrated Workflow</strong>: Seamless integration with Hugging Face Hub for model storage and sharing</li> <li><strong>Monitoring</strong>: Built-in logging and progress tracking through the Hub interface</li>",Lt,I,Et,v,Ae="To use Hugging Face Jobs, you need:",Zt,$,Fe='<li>A <strong>Pro, Team, or Enterprise</strong> Hugging Face plan which you can get <a href="https://huggingface.co/pricing" rel="nofollow">here</a></li> <li>Authentication via <code>hf auth login</code></li>',At,_,Ft,B,He="The best way to run TRL with HF jobs is using the built-in scripts. They take advantage of <code>uv</code> to manage dependencies and <code>hf jobs</code> to run the training job.",Ht,L,ke="This guide will walk you through using TRL’s built-in scripts to train a model with Hugging Face Jobs. If you want to use a custom script, you can implement <code>uv</code> dependencies and run the script with <code>hf jobs run</code>.",kt,g,wt,Re="Create a custom training script with inline dependencies",$e,E,_e,Ut,Ge="Then run with the Jobs CLI:",Be,Z,Rt,A,Gt,F,Ve="Choose the right hardware flavor based on your model size and training requirements:",Vt,H,Se="<strong>For SmolLM3-3B (Recommended)</strong>:",St,k,Xe="<li><code>a10g-large</code>: 24GB GPU memory, cost-effective for most SFT tasks</li> <li><code>a100-large</code>: 40GB GPU memory, fastest training with larger batch sizes</li> <li><code>l4x1</code>: 24GB GPU memory, multi-GPU setup for distributed training</li>",Xt,R,We="<strong>For Larger Models (7B+)</strong>:",Wt,G,xe="<li><code>a100-large</code>: Required for 7B+ models</li> <li><code>l4x4</code>: Multi-GPU setup for distributed training</li>",xt,V,Ye="<strong>Budget Options</strong>:",Yt,S,Ne="<li><code>t4-small</code>: 16GB GPU memory, slower but economical for experimentation</li> <li><code>l4x1</code>: 24GB GPU memory, good balance of cost and performance</li>",Nt,d,zt,X,Qt,W,Pt,x,ze="<strong>Environment Variables and Secrets</strong>:",qt,Y,Qe="If you’re working with a custom script, you can use the <code>--secrets</code> flag to pass in environment variables.",Dt,N,Ot,z,Kt,Q,Pe='To check you training job, you can use the <code>hf jobs</code> command or you can go to <a href="https://huggingface.co/settings/jobs" rel="nofollow">Job Settings</a> on the Hub.',te,P,qe="<strong>Check Job Status</strong>:",ee,q,le,D,ne,O,De="Enable LoRA when using TRL’s maintained SFT script by passing PEFT flags. See the script for authoritative flags and defaults: <code>https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py</code>.",se,K,ie,tt,Oe="Notes:",ae,et,Ke="<li>Confirm flag names in the TRL SFT script before running: <code>https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py</code>.</li> <li>LoRA trains small adapters, which you can keep separate or merge later for deployment.</li>",oe,lt,re,nt,tl="You can monitor your training job with Trackio.",Me,st,el='<img src="https://github.com/user-attachments/assets/f3eac49e-d8ee-4fc0-b1ca-aedfc6d6fae1" alt="Trackio Monitoring"/>',me,it,pe,at,ll="Approximate costs for SmolLM3-3B SFT training (1000 steps):",ue,ot,nl="<li>l4x1: ~$3-4 per hour (24GB GPU memory)</li> <li>a10g-large: ~$4-6 per hour (24GB GPU memory)</li> <li>a100-large: ~$8-12 per hour (40GB GPU memory)</li>",ce,rt,sl="Training typically takes 30-90 minutes for 1000 steps depending on hardware and configuration, making Jobs cost-effective compared to local GPU rental or cloud instances.",Te,Mt,il="<strong>Cost-Saving Tips</strong>:",fe,mt,al="<li>Use smaller batch sizes with gradient accumulation to fit on cheaper GPUs</li> <li>Start with shorter training runs (500 steps) to validate your setup</li> <li>Use <code>l4x1</code> for initial experiments, then scale to faster GPUs for production</li> <li>Set appropriate timeouts to avoid unexpected charges</li>",ge,pt,Je,ut,ol="<strong>Out of Memory Errors</strong>:",he,ct,rl="<li>Reduce <code>per_device_train_batch_size</code></li> <li>Enable gradient checkpointing</li> <li>Use smaller <code>max_seq_length</code></li>",ye,Tt,Ml="<strong>Timeout Issues</strong>:",de,ft,ml="<li>Increase timeout parameter</li> <li>Reduce training steps or use more powerful hardware</li> <li>Optimize data loading and preprocessing</li>",je,gt,pl="<strong>Authentication Errors</strong>:",we,Jt,ul="<li>Ensure HF_TOKEN is correctly set as a secret</li> <li>Verify your Hugging Face account has the required plan</li> <li>Check token permissions for model uploads</li>",Ue,ht,be,yt,cl='<li><a href="https://huggingface.co/docs/huggingface_hub/guides/jobs" rel="nofollow">Hugging Face Jobs Documentation</a> - Complete Jobs guide</li> <li><a href="https://huggingface.co/docs/trl/main/en/jobs_training" rel="nofollow">TRL Jobs Training Guide</a> - TRL-specific Jobs examples</li> <li><a href="https://huggingface.co/pricing" rel="nofollow">Jobs Pricing</a> - Current pricing for different hardware flavors</li> <li><a href="https://huggingface.co/docs/huggingface_hub/guides/cli#hf-jobs" rel="nofollow">Jobs CLI Reference</a> - Command-line interface details</li>',Ce,dt,Ie,It,ve;return w=new J({props:{title:"Training with Hugging Face Jobs",local:"training-with-hugging-face-jobs",headingTag:"h1"}}),b=new J({props:{title:"Why Use Jobs for SFT Training?",local:"why-use-jobs-for-sft-training",headingTag:"h2"}}),I=new J({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),_=new J({props:{title:"Running SFT with Jobs: Two Approaches",local:"running-sft-with-jobs-two-approaches",headingTag:"h2"}}),E=new Ct({props:{code:"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",highlighted:`<span class="hljs-comment"># sft_training.py</span>
<span class="hljs-comment"># /// script</span>
<span class="hljs-comment"># dependencies = [</span>
<span class="hljs-comment">#     &quot;trl[sft]&gt;=0.7.0&quot;,</span>
<span class="hljs-comment">#     &quot;transformers&gt;=4.36.0&quot;, </span>
<span class="hljs-comment">#     &quot;datasets&gt;=2.14.0&quot;,</span>
<span class="hljs-comment">#     &quot;accelerate&gt;=0.24.0&quot;,</span>
<span class="hljs-comment">#     &quot;peft&gt;=0.7.0&quot;</span>
<span class="hljs-comment"># ]</span>
<span class="hljs-comment"># ///</span>

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Base&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Base&quot;</span>)

<span class="hljs-comment"># Load dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceTB/smoltalk2&quot;</span>, <span class="hljs-string">&quot;SFT&quot;</span>)

<span class="hljs-comment"># Configure training</span>
config = SFTConfig(
    output_dir=<span class="hljs-string">&quot;./smollm3-jobs-sft&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">5e-5</span>,
    max_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">50</span>,
    save_steps=<span class="hljs-number">200</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_model_id=<span class="hljs-string">&quot;your-username/smollm3-jobs-sft&quot;</span>
)

<span class="hljs-comment"># Train</span>
trainer = SFTTrainer(
    model=model,
    tokenizer=tokenizer,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    args=config,
)
trainer.train()`,wrap:!1}}),Z=new Ct({props:{code:"JTIzJTIwUnVuJTIwdGhlJTIwVVYlMjBzY3JpcHQlMjBvbiUyMEpvYnMlMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjBzZnRfdHJhaW5pbmcucHk=",highlighted:`<span class="hljs-comment"># Run the UV script on Jobs</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    sft_training.py`,wrap:!1}}),A=new J({props:{title:"Hardware Selection for SFT",local:"hardware-selection-for-sft",headingTag:"h2"}}),d=new jl({props:{$$slots:{default:[Ul]},$$scope:{ctx:vt}}}),X=new J({props:{title:"Advanced Jobs Configuration",local:"advanced-jobs-configuration",headingTag:"h2"}}),W=new Ct({props:{code:"JTIzJTIwVXNlJTIwVFJMJ3MlMjBtYWludGFpbmVkJTIwU0ZUJTIwc2NyaXB0JTIwZGlyZWN0bHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZmxhdm9yJTIwYTEwZy1sYXJnZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGltZW91dCUyMDJoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZWNyZXRzJTIwSEZfVE9LRU4lMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRnRybCUyRm1haW4lMkZ0cmwlMkZzY3JpcHRzJTJGc2Z0LnB5JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQi1CYXNlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjBIdWdnaW5nRmFjZVRCJTJGc21vbHRhbGsyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZyUyMFNGVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9zdGVwcyUyMDEwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjBzbW9sbG0zLXNmdC1qb2JzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1YiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taHViX21vZGVsX2lkJTIweW91ci11c2VybmFtZSUyRnNtb2xsbTMtc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXBvcnRfdG8lMjB0cmFja2lv",highlighted:`<span class="hljs-comment"># Use TRL&#x27;s maintained SFT script directly</span>
hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 2h \\
    --secrets HF_TOKEN \\
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
    --model_name_or_path HuggingFaceTB/SmolLM3-3B-Base \\
    --dataset_name HuggingFaceTB/smoltalk2 \\
    --dataset_config SFT \\
    --learning_rate 5e-5 \\
    --per_device_train_batch_size 4 \\
    --max_steps 1000 \\
    --output_dir smollm3-sft-jobs \\
    --push_to_hub \\
    --hub_model_id your-username/smollm3-sft \\
    --report_to trackio`,wrap:!1}}),N=new Ct({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLWZsYXZvciUyMGExMGctbGFyZ2UlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRpbWVvdXQlMjAzaCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VjcmV0cyUyMEhGX1RPS0VOJTNEeW91cl90b2tlbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VjcmV0cyUyMFdBTkRCX0FQSV9LRVklM0R5b3VyX3dhbmRiX2tleSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW52JTIwV0FOREJfUFJPSkVDVCUzRHNtb2xsbTMtc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1lbnYlMjBDVURBX1ZJU0lCTEVfREVWSUNFUyUzRDAlMjAlNUMlMEElMjAlMjAlMjAlMjBteV9zZnRfdHJhaW5pbmcucHk=",highlighted:`hf <span class="hljs-built_in">jobs</span> uv run \\
    --flavor a10g-large \\
    --<span class="hljs-built_in">timeout</span> 3h \\
    --secrets HF_TOKEN=your_token \\
    --secrets WANDB_API_KEY=your_wandb_key \\
    --<span class="hljs-built_in">env</span> WANDB_PROJECT=smollm3-sft \\
    --<span class="hljs-built_in">env</span> CUDA_VISIBLE_DEVICES=0 \\
    my_sft_training.py`,wrap:!1}}),z=new J({props:{title:"Monitoring Your Training Job",local:"monitoring-your-training-job",headingTag:"h2"}}),q=new Ct({props:{code:"JTIzJTIwTGlzdCUyMGFsbCUyMGpvYnMlMEFoZiUyMGpvYnMlMjBwcyUyMC1hJTBBJTBBJTIzJTIwR2V0JTIwZGV0YWlsZWQlMjBqb2IlMjBpbmZvcm1hdGlvbiUyMCUyMCUwQWhmJTIwam9icyUyMGluc3BlY3QlMjAlM0Nqb2JfaWQlM0UlMEElMEElMjMlMjBTdHJlYW0lMjBqb2IlMjBsb2dzJTIwaW4lMjByZWFsLXRpbWUlMEFoZiUyMGpvYnMlMjBsb2dzJTIwJTNDam9iX2lkJTNFJTIwLS1mb2xsb3clMEElMEElMjMlMjBDYW5jZWwlMjBhJTIwcnVubmluZyUyMGpvYiUyMGlmJTIwbmVlZGVkJTBBaGYlMjBqb2JzJTIwY2FuY2VsJTIwJTNDam9iX2lkJTNF",highlighted:`<span class="hljs-comment"># List all jobs</span>
hf <span class="hljs-built_in">jobs</span> ps -a

<span class="hljs-comment"># Get detailed job information  </span>
hf <span class="hljs-built_in">jobs</span> inspect &lt;job_id&gt;

<span class="hljs-comment"># Stream job logs in real-time</span>
hf <span class="hljs-built_in">jobs</span> logs &lt;job_id&gt; --follow

<span class="hljs-comment"># Cancel a running job if needed</span>
hf <span class="hljs-built_in">jobs</span> cancel &lt;job_id&gt;`,wrap:!1}}),D=new J({props:{title:"LoRA/PEFT on Jobs (optional)",local:"lorapeft-on-jobs-optional",headingTag:"h2"}}),K=new Ct({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAlMjAtLWZsYXZvciUyMGExMGctbGFyZ2UlMjAlNUMlMEElMjAlMjAtLXRpbWVvdXQlMjAyaCUyMCU1QyUwQSUyMCUyMC0tc2VjcmV0cyUyMEhGX1RPS0VOJTIwJTVDJTBBJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmwlMkZtYWluJTJGdHJsJTJGc2NyaXB0cyUyRnNmdC5weSUyMiUyMCU1QyUwQSUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwSHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0ItQmFzZSUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldF9uYW1lJTIwSHVnZ2luZ0ZhY2VUQiUyRnNtb2x0YWxrMiUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldF9jb25maWclMjBTRlQlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlMjBzbW9sbG0zLWxvcmEtc2Z0LWpvYnMlMjAlNUMlMEElMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlMjA1ZS01JTIwJTVDJTBBJTIwJTIwLS1tYXhfc3RlcHMlMjAxMDAwJTIwJTVDJTBBJTIwJTIwLS1yZXBvcnRfdG8lMjB0cmFja2lvJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1YiUyMCU1QyUwQSUyMCUyMC0taHViX21vZGVsX2lkJTIweW91ci11c2VybmFtZSUyRnNtb2xsbTMtbG9yYS1zZnQlMjAlNUMlMEElMjAlMjAtLXVzZV9wZWZ0JTIwJTVDJTBBJTIwJTIwLS1sb3JhX3IlMjA4JTIwJTVDJTBBJTIwJTIwLS1sb3JhX2FscGhhJTIwMTYlMjAlNUMlMEElMjAlMjAtLWxvcmFfZHJvcG91dCUyMDAuMDUlMjAlNUMlMEElMjAlMjAtLWxvcmFfdGFyZ2V0X21vZHVsZXMlMjBhbGwtbGluZWFy",highlighted:`hf <span class="hljs-built_in">jobs</span> uv run \\
  --flavor a10g-large \\
  --<span class="hljs-built_in">timeout</span> 2h \\
  --secrets HF_TOKEN \\
  <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> \\
  --model_name_or_path HuggingFaceTB/SmolLM3-3B-Base \\
  --dataset_name HuggingFaceTB/smoltalk2 \\
  --dataset_config SFT \\
  --output_dir smollm3-lora-sft-jobs \\
  --per_device_train_batch_size 4 \\
  --learning_rate 5e-5 \\
  --max_steps 1000 \\
  --report_to trackio \\
  --push_to_hub \\
  --hub_model_id your-username/smollm3-lora-sft \\
  --use_peft \\
  --lora_r 8 \\
  --lora_alpha 16 \\
  --lora_dropout 0.05 \\
  --lora_target_modules all-linear`,wrap:!1}}),lt=new J({props:{title:"Monitoring with Trackio",local:"monitoring-with-trackio",headingTag:"h2"}}),it=new J({props:{title:"Cost Estimation",local:"cost-estimation",headingTag:"h2"}}),pt=new J({props:{title:"Troubleshooting Common Issues",local:"troubleshooting-common-issues",headingTag:"h2"}}),ht=new J({props:{title:"Resources and Further Reading",local:"resources-and-further-reading",headingTag:"h2"}}),dt=new wl({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/5.md"}}),{c(){f=a("meta"),j=s(),h=a("p"),jt=s(),M(w.$$.fragment),$t=s(),U=a("p"),U.innerHTML=Ee,_t=s(),M(b.$$.fragment),Bt=s(),C=a("ul"),C.innerHTML=Ze,Lt=s(),M(I.$$.fragment),Et=s(),v=a("p"),v.textContent=Ae,Zt=s(),$=a("ul"),$.innerHTML=Fe,At=s(),M(_.$$.fragment),Ft=s(),B=a("p"),B.innerHTML=He,Ht=s(),L=a("p"),L.innerHTML=ke,kt=s(),g=a("details"),wt=a("summary"),wt.textContent=Re,$e=s(),M(E.$$.fragment),_e=s(),Ut=a("p"),Ut.textContent=Ge,Be=s(),M(Z.$$.fragment),Rt=s(),M(A.$$.fragment),Gt=s(),F=a("p"),F.textContent=Ve,Vt=s(),H=a("p"),H.innerHTML=Se,St=s(),k=a("ul"),k.innerHTML=Xe,Xt=s(),R=a("p"),R.innerHTML=We,Wt=s(),G=a("ul"),G.innerHTML=xe,xt=s(),V=a("p"),V.innerHTML=Ye,Yt=s(),S=a("ul"),S.innerHTML=Ne,Nt=s(),M(d.$$.fragment),zt=s(),M(X.$$.fragment),Qt=s(),M(W.$$.fragment),Pt=s(),x=a("p"),x.innerHTML=ze,qt=s(),Y=a("p"),Y.innerHTML=Qe,Dt=s(),M(N.$$.fragment),Ot=s(),M(z.$$.fragment),Kt=s(),Q=a("p"),Q.innerHTML=Pe,te=s(),P=a("p"),P.innerHTML=qe,ee=s(),M(q.$$.fragment),le=s(),M(D.$$.fragment),ne=s(),O=a("p"),O.innerHTML=De,se=s(),M(K.$$.fragment),ie=s(),tt=a("p"),tt.textContent=Oe,ae=s(),et=a("ul"),et.innerHTML=Ke,oe=s(),M(lt.$$.fragment),re=s(),nt=a("p"),nt.textContent=tl,Me=s(),st=a("p"),st.innerHTML=el,me=s(),M(it.$$.fragment),pe=s(),at=a("p"),at.textContent=ll,ue=s(),ot=a("ul"),ot.innerHTML=nl,ce=s(),rt=a("p"),rt.textContent=sl,Te=s(),Mt=a("p"),Mt.innerHTML=il,fe=s(),mt=a("ul"),mt.innerHTML=al,ge=s(),M(pt.$$.fragment),Je=s(),ut=a("p"),ut.innerHTML=ol,he=s(),ct=a("ul"),ct.innerHTML=rl,ye=s(),Tt=a("p"),Tt.innerHTML=Ml,de=s(),ft=a("ul"),ft.innerHTML=ml,je=s(),gt=a("p"),gt.innerHTML=pl,we=s(),Jt=a("ul"),Jt.innerHTML=ul,Ue=s(),M(ht.$$.fragment),be=s(),yt=a("ul"),yt.innerHTML=cl,Ce=s(),M(dt.$$.fragment),Ie=s(),It=a("p"),this.h()},l(t){const e=dl("svelte-u9bgzb",document.head);f=o(e,"META",{name:!0,content:!0}),e.forEach(l),j=i(t),h=o(t,"P",{}),Le(h).forEach(l),jt=i(t),m(w.$$.fragment,t),$t=i(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1romi1a"&&(U.innerHTML=Ee),_t=i(t),m(b.$$.fragment,t),Bt=i(t),C=o(t,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-hq0r4s"&&(C.innerHTML=Ze),Lt=i(t),m(I.$$.fragment,t),Et=i(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1m87417"&&(v.textContent=Ae),Zt=i(t),$=o(t,"UL",{"data-svelte-h":!0}),r($)!=="svelte-jk9mxc"&&($.innerHTML=Fe),At=i(t),m(_.$$.fragment,t),Ft=i(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1md3sw3"&&(B.innerHTML=He),Ht=i(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-186flx0"&&(L.innerHTML=ke),kt=i(t),g=o(t,"DETAILS",{});var y=Le(g);wt=o(y,"SUMMARY",{"data-svelte-h":!0}),r(wt)!=="svelte-3ojvyd"&&(wt.textContent=Re),$e=i(y),m(E.$$.fragment,y),_e=i(y),Ut=o(y,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-14xyf0t"&&(Ut.textContent=Ge),Be=i(y),m(Z.$$.fragment,y),y.forEach(l),Rt=i(t),m(A.$$.fragment,t),Gt=i(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-uvhb8e"&&(F.textContent=Ve),Vt=i(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1wmskg9"&&(H.innerHTML=Se),St=i(t),k=o(t,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1sswzc8"&&(k.innerHTML=Xe),Xt=i(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1dojeau"&&(R.innerHTML=We),Wt=i(t),G=o(t,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-v8ek3l"&&(G.innerHTML=xe),xt=i(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-rwb6vm"&&(V.innerHTML=Ye),Yt=i(t),S=o(t,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1gcm4iq"&&(S.innerHTML=Ne),Nt=i(t),m(d.$$.fragment,t),zt=i(t),m(X.$$.fragment,t),Qt=i(t),m(W.$$.fragment,t),Pt=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-9exkfb"&&(x.innerHTML=ze),qt=i(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1t7coxe"&&(Y.innerHTML=Qe),Dt=i(t),m(N.$$.fragment,t),Ot=i(t),m(z.$$.fragment,t),Kt=i(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-z7hljb"&&(Q.innerHTML=Pe),te=i(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1gp7ih6"&&(P.innerHTML=qe),ee=i(t),m(q.$$.fragment,t),le=i(t),m(D.$$.fragment,t),ne=i(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-w7eu5t"&&(O.innerHTML=De),se=i(t),m(K.$$.fragment,t),ie=i(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1biq3pv"&&(tt.textContent=Oe),ae=i(t),et=o(t,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-1cfpqte"&&(et.innerHTML=Ke),oe=i(t),m(lt.$$.fragment,t),re=i(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-dlsnzk"&&(nt.textContent=tl),Me=i(t),st=o(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1qwosyu"&&(st.innerHTML=el),me=i(t),m(it.$$.fragment,t),pe=i(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-bqeor6"&&(at.textContent=ll),ue=i(t),ot=o(t,"UL",{"data-svelte-h":!0}),r(ot)!=="svelte-1keptmg"&&(ot.innerHTML=nl),ce=i(t),rt=o(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-15zzqy3"&&(rt.textContent=sl),Te=i(t),Mt=o(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-10khssf"&&(Mt.innerHTML=il),fe=i(t),mt=o(t,"UL",{"data-svelte-h":!0}),r(mt)!=="svelte-16wbhfu"&&(mt.innerHTML=al),ge=i(t),m(pt.$$.fragment,t),Je=i(t),ut=o(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-gw1iva"&&(ut.innerHTML=ol),he=i(t),ct=o(t,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-10z34e4"&&(ct.innerHTML=rl),ye=i(t),Tt=o(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1mihp6k"&&(Tt.innerHTML=Ml),de=i(t),ft=o(t,"UL",{"data-svelte-h":!0}),r(ft)!=="svelte-6iw3pz"&&(ft.innerHTML=ml),je=i(t),gt=o(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-ah43vs"&&(gt.innerHTML=pl),we=i(t),Jt=o(t,"UL",{"data-svelte-h":!0}),r(Jt)!=="svelte-1f6kf7m"&&(Jt.innerHTML=ul),Ue=i(t),m(ht.$$.fragment,t),be=i(t),yt=o(t,"UL",{"data-svelte-h":!0}),r(yt)!=="svelte-1y75b5h"&&(yt.innerHTML=cl),Ce=i(t),m(dt.$$.fragment,t),Ie=i(t),It=o(t,"P",{}),Le(It).forEach(l),this.h()},h(){Tl(f,"name","hf:doc:metadata"),Tl(f,"content",Cl)},m(t,e){bt(document.head,f),n(t,j,e),n(t,h,e),n(t,jt,e),p(w,t,e),n(t,$t,e),n(t,U,e),n(t,_t,e),p(b,t,e),n(t,Bt,e),n(t,C,e),n(t,Lt,e),p(I,t,e),n(t,Et,e),n(t,v,e),n(t,Zt,e),n(t,$,e),n(t,At,e),p(_,t,e),n(t,Ft,e),n(t,B,e),n(t,Ht,e),n(t,L,e),n(t,kt,e),n(t,g,e),bt(g,wt),bt(g,$e),p(E,g,null),bt(g,_e),bt(g,Ut),bt(g,Be),p(Z,g,null),n(t,Rt,e),p(A,t,e),n(t,Gt,e),n(t,F,e),n(t,Vt,e),n(t,H,e),n(t,St,e),n(t,k,e),n(t,Xt,e),n(t,R,e),n(t,Wt,e),n(t,G,e),n(t,xt,e),n(t,V,e),n(t,Yt,e),n(t,S,e),n(t,Nt,e),p(d,t,e),n(t,zt,e),p(X,t,e),n(t,Qt,e),p(W,t,e),n(t,Pt,e),n(t,x,e),n(t,qt,e),n(t,Y,e),n(t,Dt,e),p(N,t,e),n(t,Ot,e),p(z,t,e),n(t,Kt,e),n(t,Q,e),n(t,te,e),n(t,P,e),n(t,ee,e),p(q,t,e),n(t,le,e),p(D,t,e),n(t,ne,e),n(t,O,e),n(t,se,e),p(K,t,e),n(t,ie,e),n(t,tt,e),n(t,ae,e),n(t,et,e),n(t,oe,e),p(lt,t,e),n(t,re,e),n(t,nt,e),n(t,Me,e),n(t,st,e),n(t,me,e),p(it,t,e),n(t,pe,e),n(t,at,e),n(t,ue,e),n(t,ot,e),n(t,ce,e),n(t,rt,e),n(t,Te,e),n(t,Mt,e),n(t,fe,e),n(t,mt,e),n(t,ge,e),p(pt,t,e),n(t,Je,e),n(t,ut,e),n(t,he,e),n(t,ct,e),n(t,ye,e),n(t,Tt,e),n(t,de,e),n(t,ft,e),n(t,je,e),n(t,gt,e),n(t,we,e),n(t,Jt,e),n(t,Ue,e),p(ht,t,e),n(t,be,e),n(t,yt,e),n(t,Ce,e),p(dt,t,e),n(t,Ie,e),n(t,It,e),ve=!0},p(t,[e]){const y={};e&2&&(y.$$scope={dirty:e,ctx:t}),d.$set(y)},i(t){ve||(u(w.$$.fragment,t),u(b.$$.fragment,t),u(I.$$.fragment,t),u(_.$$.fragment,t),u(E.$$.fragment,t),u(Z.$$.fragment,t),u(A.$$.fragment,t),u(d.$$.fragment,t),u(X.$$.fragment,t),u(W.$$.fragment,t),u(N.$$.fragment,t),u(z.$$.fragment,t),u(q.$$.fragment,t),u(D.$$.fragment,t),u(K.$$.fragment,t),u(lt.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(ht.$$.fragment,t),u(dt.$$.fragment,t),ve=!0)},o(t){c(w.$$.fragment,t),c(b.$$.fragment,t),c(I.$$.fragment,t),c(_.$$.fragment,t),c(E.$$.fragment,t),c(Z.$$.fragment,t),c(A.$$.fragment,t),c(d.$$.fragment,t),c(X.$$.fragment,t),c(W.$$.fragment,t),c(N.$$.fragment,t),c(z.$$.fragment,t),c(q.$$.fragment,t),c(D.$$.fragment,t),c(K.$$.fragment,t),c(lt.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(dt.$$.fragment,t),ve=!1},d(t){t&&(l(j),l(h),l(jt),l($t),l(U),l(_t),l(Bt),l(C),l(Lt),l(Et),l(v),l(Zt),l($),l(At),l(Ft),l(B),l(Ht),l(L),l(kt),l(g),l(Rt),l(Gt),l(F),l(Vt),l(H),l(St),l(k),l(Xt),l(R),l(Wt),l(G),l(xt),l(V),l(Yt),l(S),l(Nt),l(zt),l(Qt),l(Pt),l(x),l(qt),l(Y),l(Dt),l(Ot),l(Kt),l(Q),l(te),l(P),l(ee),l(le),l(ne),l(O),l(se),l(ie),l(tt),l(ae),l(et),l(oe),l(re),l(nt),l(Me),l(st),l(me),l(pe),l(at),l(ue),l(ot),l(ce),l(rt),l(Te),l(Mt),l(fe),l(mt),l(ge),l(Je),l(ut),l(he),l(ct),l(ye),l(Tt),l(de),l(ft),l(je),l(gt),l(we),l(Jt),l(Ue),l(be),l(yt),l(Ce),l(Ie),l(It)),l(f),T(w,t),T(b,t),T(I,t),T(_,t),T(E),T(Z),T(A,t),T(d,t),T(X,t),T(W,t),T(N,t),T(z,t),T(q,t),T(D,t),T(K,t),T(lt,t),T(it,t),T(pt,t),T(ht,t),T(dt,t)}}}const Cl='{"title":"Training with Hugging Face Jobs","local":"training-with-hugging-face-jobs","sections":[{"title":"Why Use Jobs for SFT Training?","local":"why-use-jobs-for-sft-training","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Running SFT with Jobs: Two Approaches","local":"running-sft-with-jobs-two-approaches","sections":[],"depth":2},{"title":"Hardware Selection for SFT","local":"hardware-selection-for-sft","sections":[],"depth":2},{"title":"Advanced Jobs Configuration","local":"advanced-jobs-configuration","sections":[],"depth":2},{"title":"Monitoring Your Training Job","local":"monitoring-your-training-job","sections":[],"depth":2},{"title":"LoRA/PEFT on Jobs (optional)","local":"lorapeft-on-jobs-optional","sections":[],"depth":2},{"title":"Monitoring with Trackio","local":"monitoring-with-trackio","sections":[],"depth":2},{"title":"Cost Estimation","local":"cost-estimation","sections":[],"depth":2},{"title":"Troubleshooting Common Issues","local":"troubleshooting-common-issues","sections":[],"depth":2},{"title":"Resources and Further Reading","local":"resources-and-further-reading","sections":[],"depth":2}],"depth":1}';function Il(vt){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ll extends hl{constructor(f){super(),yl(this,f,Il,bl,fl,{})}}export{Ll as component};
