import{s as mt,f as jt,o as ht,n as ut}from"../chunks/scheduler.37c15a92.js";import{S as It,i as dt,g as M,s as e,r as J,A as gt,h as i,f as t,c as n,j as wt,u as y,x as p,k as b,y as bt,a,v as o,d as T,t as c,w as j,m as Ut,n as rt}from"../chunks/index.2bf4358c.js";import{T as Ct}from"../chunks/Tip.363c041f.js";import{C as h}from"../chunks/CodeBlock.4e987730.js";import{H as m}from"../chunks/Heading.8ada512a.js";import{E as ft}from"../chunks/index.e71982be.js";function Bt(Zl){let U,r,I="this notebook",u;return{c(){U=Ut("You can follow the code in "),r=M("a"),r.textContent=I,u=Ut(" that you can run using Google Colab."),this.h()},l(w){U=rt(w,"You can follow the code in "),r=i(w,"A",{href:!0,target:!0,"data-svelte-h":!0}),p(r)!=="svelte-1wsoqbe"&&(r.textContent=I),u=rt(w," that you can run using Google Colab."),this.h()},h(){b(r,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/mail_sorting.ipynb"),b(r,"target","_blank")},m(w,d){a(w,U,d),a(w,r,d),a(w,u,d)},p:ut,d(w){w&&(t(U),t(r),t(u))}}}function Wt(Zl){let U,r,I,u,w,d,C,Qs="Now that we understand the building blocks, let’s put them into practice by building our first functional graph. We’ll implement Alfred’s email processing system, where he needs to:",Gl,f,Ss="<li>Read incoming emails</li> <li>Classify them as spam or legitimate</li> <li>Draft a preliminary response for legitimate emails</li> <li>Send information to Mr. Wayne when legitimate (printing only)</li>",El,B,ks="This example demonstrates how to structure a workflow with LangGraph that involves LLM-based decision-making. While this can’t be considered an Agent as no tool is involved, this section focuses more on learning the LangGraph framework than Agents.",ql,g,Nl,W,Al,Z,Vs="Here’s the workflow we’ll build:",Ql,G,Ys,Sl,E,kl,q,$s="First, let’s install the required packages:",Vl,N,Yl,A,Fs="Next, let’s import the necessary modules:",$l,Q,Fl,S,_l,k,_s="Let’s define what information Alfred needs to track during the email processing workflow:",vl,V,Xl,Y,vs="<p>💡 <strong>Tip:</strong> Make your state comprehensive enough to track all the important information, but avoid bloating it with unnecessary details.</p>",xl,$,zl,F,Xs="Now, let’s create the processing functions that will form our nodes:",Rl,_,Hl,v,Ll,X,xs="We need a function to determine which path to take after classification:",Dl,x,Ol,z,zs="<p>💡 <strong>Note:</strong> This routing function is called by LangGraph to determine which edge to follow after the classification node. The return value must match one of the keys in our conditional edges mapping.</p>",Pl,R,Kl,H,Rs="Now we connect everything together:",ls,L,ss,D,Hs="Notice how we use the special <code>END</code> node provided by LangGraph. This indicates terminal states where the workflow completes.",ts,O,as,P,Ls="Let’s test our graph with a legitimate email and a spam email:",es,K,ns,ll,Ms,sl,Ds="As Alfred fine-tunes the Main Sorting Agent, he’s growing weary of debugging its runs. Agents, by nature, are unpredictable and difficult to inspect. But since he aims to build the ultimate Spam Detection Agent and deploy it in production, he needs robust traceability for future monitoring and analysis.",is,tl,Os='To do this, Alfred can use an observability tool such as <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> to trace and monitor the agent.',ps,al,Ps="First, we pip install Langfuse:",Js,el,ys,nl,Ks="Second, we pip install Langchain (LangChain is required because we use LangFuse):",os,Ml,Ts,il,lt='Next, we add the Langfuse API keys and host address as environment variables. You can get your Langfuse credentials by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-host Langfuse</a>.',cs,pl,js,Jl,st='Then, we configure the <a href="https://langfuse.com/docs/integrations/langchain/tracing#add-langfuse-to-your-langchain-application" rel="nofollow">Langfuse <code>callback_handler</code></a> and instrument the agent by adding the <code>langfuse_callback</code> to the invocation of the graph: <code>config={&quot;callbacks&quot;: [langfuse_handler]}</code>.',ws,yl,Us,ol,tt="Alfred is now connected 🔌! The runs from LangGraph are being logged in Langfuse, giving him full visibility into the agent’s behavior. With this setup, he’s ready to revisit previous runs and refine his Mail Sorting Agent even further.",rs,Tl,at='<img src="https://langfuse.com/images/cookbook/huggingface-agent-course/langgraph-trace-legit.png" alt="Example trace in Langfuse"/>',ms,cl,et='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/f5d6d72e-20af-4357-b232-af44c3728a7b?timestamp=2025-03-17T10%3A13%3A28.413Z&amp;observation=6997ba69-043f-4f77-9445-700a033afba1" rel="nofollow">Public link to the trace with the legit email</a></em>',hs,jl,us,wl,nt="LangGraph allows us to visualize our workflow to better understand and debug its structure:",Is,Ul,ds,rl,Mt,gs,ml,it="This produces a visual representation showing how our nodes are connected and the conditional paths that can be taken.",bs,hl,Cs,ul,pt="We’ve created a complete email processing workflow that:",fs,Il,Jt="<li>Takes an incoming email</li> <li>Uses an LLM to classify it as spam or legitimate</li> <li>Handles spam by discarding it</li> <li>For legitimate emails, drafts a response and notifies Mr. Hugg</li>",Bs,dl,yt="This demonstrates the power of LangGraph to orchestrate complex workflows with LLMs while maintaining a clear, structured flow.",Ws,gl,Zs,bl,ot="<li><strong>State Management</strong>: We defined comprehensive state to track all aspects of email processing</li> <li><strong>Node Implementation</strong>: We created functional nodes that interact with an LLM</li> <li><strong>Conditional Routing</strong>: We implemented branching logic based on email classification</li> <li><strong>Terminal States</strong>: We used the END node to mark completion points in our workflow</li>",Gs,Cl,Es,fl,Tt="In the next section, we’ll explore more advanced features of LangGraph, including handling human interaction in the workflow and implementing more complex branching logic based on multiple conditions.",qs,Bl,Ns,Wl,As;return w=new m({props:{title:"Building Your First LangGraph",local:"building-your-first-langgraph",headingTag:"h1"}}),g=new Ct({props:{$$slots:{default:[Bt]},$$scope:{ctx:Zl}}}),W=new m({props:{title:"Our Workflow",local:"our-workflow",headingTag:"h2"}}),E=new m({props:{title:"Setting Up Our Environment",local:"setting-up-our-environment",headingTag:"h2"}}),N=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWk=",highlighted:"%pip install langgraph langchain_openai",wrap:!1}}),Q=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwVHlwZWREaWN0JTJDJTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyMENoYXRPcGVuQUklMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUubWVzc2FnZXMlMjBpbXBvcnQlMjBIdW1hbk1lc3NhZ2U=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> HumanMessage`,wrap:!1}}),S=new m({props:{title:"Step 1: Define Our State",local:"step-1-define-our-state",headingTag:"h2"}}),V=new h({props:{code:"Y2xhc3MlMjBFbWFpbFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBlbWFpbCUyMGJlaW5nJTIwcHJvY2Vzc2VkJTBBJTIwJTIwJTIwJTIwZW1haWwlM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTIwJTIzJTIwQ29udGFpbnMlMjBzdWJqZWN0JTJDJTIwc2VuZGVyJTJDJTIwYm9keSUyQyUyMGV0Yy4lMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDYXRlZ29yeSUyMG9mJTIwdGhlJTIwZW1haWwlMjAoaW5xdWlyeSUyQyUyMGNvbXBsYWludCUyQyUyMGV0Yy4pJTBBJTIwJTIwJTIwJTIwZW1haWxfY2F0ZWdvcnklM0ElMjBPcHRpb25hbCU1QnN0ciU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlYXNvbiUyMHdoeSUyMHRoZSUyMGVtYWlsJTIwd2FzJTIwbWFya2VkJTIwYXMlMjBzcGFtJTBBJTIwJTIwJTIwJTIwc3BhbV9yZWFzb24lM0ElMjBPcHRpb25hbCU1QnN0ciU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFuYWx5c2lzJTIwYW5kJTIwZGVjaXNpb25zJTBBJTIwJTIwJTIwJTIwaXNfc3BhbSUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlc3BvbnNlJTIwZ2VuZXJhdGlvbiUwQSUyMCUyMCUyMCUyMGVtYWlsX2RyYWZ0JTNBJTIwT3B0aW9uYWwlNUJzdHIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQcm9jZXNzaW5nJTIwbWV0YWRhdGElMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzQSUyMExpc3QlNUJEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTVEJTIwJTIwJTIzJTIwVHJhY2slMjBjb252ZXJzYXRpb24lMjB3aXRoJTIwTExNJTIwZm9yJTIwYW5hbHlzaXM=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmailState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># The email being processed</span>
    email: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]  <span class="hljs-comment"># Contains subject, sender, body, etc.</span>

    <span class="hljs-comment"># Category of the email (inquiry, complaint, etc.)</span>
    email_category: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]

    <span class="hljs-comment"># Reason why the email was marked as spam</span>
    spam_reason: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]

    <span class="hljs-comment"># Analysis and decisions</span>
    is_spam: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>]
    
    <span class="hljs-comment"># Response generation</span>
    email_draft: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]
    
    <span class="hljs-comment"># Processing metadata</span>
    messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]  <span class="hljs-comment"># Track conversation with LLM for analysis</span>`,wrap:!1}}),$=new m({props:{title:"Step 2: Define Our Nodes",local:"step-2-define-our-nodes",headingTag:"h2"}}),_=new h({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMG91ciUyMExMTSUwQW1vZGVsJTIwJTNEJTIwQ2hhdE9wZW5BSSh0ZW1wZXJhdHVyZSUzRDApJTBBJTBBZGVmJTIwcmVhZF9lbWFpbChzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwcmVhZHMlMjBhbmQlMjBsb2dzJTIwdGhlJTIwaW5jb21pbmclMjBlbWFpbCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVtYWlsJTIwJTNEJTIwc3RhdGUlNUIlMjJlbWFpbCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEhlcmUlMjB3ZSUyMG1pZ2h0JTIwZG8lMjBzb21lJTIwaW5pdGlhbCUyMHByZXByb2Nlc3NpbmclMEElMjAlMjAlMjAlMjBwcmludChmJTIyQWxmcmVkJTIwaXMlMjBwcm9jZXNzaW5nJTIwYW4lMjBlbWFpbCUyMGZyb20lMjAlN0JlbWFpbCU1QidzZW5kZXInJTVEJTdEJTIwd2l0aCUyMHN1YmplY3QlM0ElMjAlN0JlbWFpbCU1QidzdWJqZWN0JyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBObyUyMHN0YXRlJTIwY2hhbmdlcyUyMG5lZWRlZCUyMGhlcmUlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlN0QlMEElMEFkZWYlMjBjbGFzc2lmeV9lbWFpbChzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwdXNlcyUyMGFuJTIwTExNJTIwdG8lMjBkZXRlcm1pbmUlMjBpZiUyMHRoZSUyMGVtYWlsJTIwaXMlMjBzcGFtJTIwb3IlMjBsZWdpdGltYXRlJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwZW1haWwlMjAlM0QlMjBzdGF0ZSU1QiUyMmVtYWlsJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJlcGFyZSUyMG91ciUyMHByb21wdCUyMGZvciUyMHRoZSUyMExMTSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMGYlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBcyUyMEFsZnJlZCUyMHRoZSUyMGJ1dGxlciUyQyUyMGFuYWx5emUlMjB0aGlzJTIwZW1haWwlMjBhbmQlMjBkZXRlcm1pbmUlMjBpZiUyMGl0JTIwaXMlMjBzcGFtJTIwb3IlMjBsZWdpdGltYXRlLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEVtYWlsJTNBJTBBJTIwJTIwJTIwJTIwRnJvbSUzQSUyMCU3QmVtYWlsJTVCJ3NlbmRlciclNUQlN0QlMEElMjAlMjAlMjAlMjBTdWJqZWN0JTNBJTIwJTdCZW1haWwlNUInc3ViamVjdCclNUQlN0QlMEElMjAlMjAlMjAlMjBCb2R5JTNBJTIwJTdCZW1haWwlNUInYm9keSclNUQlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBGaXJzdCUyQyUyMGRldGVybWluZSUyMGlmJTIwdGhpcyUyMGVtYWlsJTIwaXMlMjBzcGFtLiUyMElmJTIwaXQlMjBpcyUyMHNwYW0lMkMlMjBleHBsYWluJTIwd2h5LiUwQSUyMCUyMCUyMCUyMElmJTIwaXQlMjBpcyUyMGxlZ2l0aW1hdGUlMkMlMjBjYXRlZ29yaXplJTIwaXQlMjAoaW5xdWlyeSUyQyUyMGNvbXBsYWludCUyQyUyMHRoYW5rJTIweW91JTJDJTIwZXRjLikuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2FsbCUyMHRoZSUyMExMTSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCSHVtYW5NZXNzYWdlKGNvbnRlbnQlM0Rwcm9tcHQpJTVEJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBtb2RlbC5pbnZva2UobWVzc2FnZXMpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2ltcGxlJTIwbG9naWMlMjB0byUyMHBhcnNlJTIwdGhlJTIwcmVzcG9uc2UlMjAoaW4lMjBhJTIwcmVhbCUyMGFwcCUyQyUyMHlvdSdkJTIwd2FudCUyMG1vcmUlMjByb2J1c3QlMjBwYXJzaW5nKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3RleHQlMjAlM0QlMjByZXNwb25zZS5jb250ZW50Lmxvd2VyKCklMEElMjAlMjAlMjAlMjBpc19zcGFtJTIwJTNEJTIwJTIyc3BhbSUyMiUyMGluJTIwcmVzcG9uc2VfdGV4dCUyMGFuZCUyMCUyMm5vdCUyMHNwYW0lMjIlMjBub3QlMjBpbiUyMHJlc3BvbnNlX3RleHQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWN0JTIwYSUyMHJlYXNvbiUyMGlmJTIwaXQncyUyMHNwYW0lMEElMjAlMjAlMjAlMjBzcGFtX3JlYXNvbiUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBpZiUyMGlzX3NwYW0lMjBhbmQlMjAlMjJyZWFzb24lM0ElMjIlMjBpbiUyMHJlc3BvbnNlX3RleHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGFtX3JlYXNvbiUyMCUzRCUyMHJlc3BvbnNlX3RleHQuc3BsaXQoJTIycmVhc29uJTNBJTIyKSU1QjElNUQuc3RyaXAoKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMERldGVybWluZSUyMGNhdGVnb3J5JTIwaWYlMjBsZWdpdGltYXRlJTBBJTIwJTIwJTIwJTIwZW1haWxfY2F0ZWdvcnklMjAlM0QlMjBOb25lJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpc19zcGFtJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2F0ZWdvcmllcyUyMCUzRCUyMCU1QiUyMmlucXVpcnklMjIlMkMlMjAlMjJjb21wbGFpbnQlMjIlMkMlMjAlMjJ0aGFuayUyMHlvdSUyMiUyQyUyMCUyMnJlcXVlc3QlMjIlMkMlMjAlMjJpbmZvcm1hdGlvbiUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGNhdGVnb3J5JTIwaW4lMjBjYXRlZ29yaWVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBjYXRlZ29yeSUyMGluJTIwcmVzcG9uc2VfdGV4dCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVtYWlsX2NhdGVnb3J5JTIwJTNEJTIwY2F0ZWdvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMG1lc3NhZ2VzJTIwZm9yJTIwdHJhY2tpbmclMEElMjAlMjAlMjAlMjBuZXdfbWVzc2FnZXMlMjAlM0QlMjBzdGF0ZS5nZXQoJTIybWVzc2FnZXMlMjIlMkMlMjAlNUIlNUQpJTIwJTJCJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcHJvbXB0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwc3RhdGUlMjB1cGRhdGVzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaXNfc3BhbSUyMiUzQSUyMGlzX3NwYW0lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGFtX3JlYXNvbiUyMiUzQSUyMHNwYW1fcmVhc29uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1haWxfY2F0ZWdvcnklMjIlM0ElMjBlbWFpbF9jYXRlZ29yeSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwbmV3X21lc3NhZ2VzJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBZGVmJTIwaGFuZGxlX3NwYW0oc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFsZnJlZCUyMGRpc2NhcmRzJTIwc3BhbSUyMGVtYWlsJTIwd2l0aCUyMGElMjBub3RlJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkFsZnJlZCUyMGhhcyUyMG1hcmtlZCUyMHRoZSUyMGVtYWlsJTIwYXMlMjBzcGFtLiUyMFJlYXNvbiUzQSUyMCU3QnN0YXRlJTVCJ3NwYW1fcmVhc29uJyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGUlMjBlbWFpbCUyMGhhcyUyMGJlZW4lMjBtb3ZlZCUyMHRvJTIwdGhlJTIwc3BhbSUyMGZvbGRlci4lMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwV2UncmUlMjBkb25lJTIwcHJvY2Vzc2luZyUyMHRoaXMlMjBlbWFpbCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiU3RCUwQSUwQWRlZiUyMGRyYWZ0X3Jlc3BvbnNlKHN0YXRlJTNBJTIwRW1haWxTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBbGZyZWQlMjBkcmFmdHMlMjBhJTIwcHJlbGltaW5hcnklMjByZXNwb25zZSUyMGZvciUyMGxlZ2l0aW1hdGUlMjBlbWFpbHMlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBlbWFpbCUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWwlMjIlNUQlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWxfY2F0ZWdvcnklMjIlNUQlMjBvciUyMCUyMmdlbmVyYWwlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQcmVwYXJlJTIwb3VyJTIwcHJvbXB0JTIwZm9yJTIwdGhlJTIwTExNJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFzJTIwQWxmcmVkJTIwdGhlJTIwYnV0bGVyJTJDJTIwZHJhZnQlMjBhJTIwcG9saXRlJTIwcHJlbGltaW5hcnklMjByZXNwb25zZSUyMHRvJTIwdGhpcyUyMGVtYWlsLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEVtYWlsJTNBJTBBJTIwJTIwJTIwJTIwRnJvbSUzQSUyMCU3QmVtYWlsJTVCJ3NlbmRlciclNUQlN0QlMEElMjAlMjAlMjAlMjBTdWJqZWN0JTNBJTIwJTdCZW1haWwlNUInc3ViamVjdCclNUQlN0QlMEElMjAlMjAlMjAlMjBCb2R5JTNBJTIwJTdCZW1haWwlNUInYm9keSclNUQlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBUaGlzJTIwZW1haWwlMjBoYXMlMjBiZWVuJTIwY2F0ZWdvcml6ZWQlMjBhcyUzQSUyMCU3QmNhdGVnb3J5JTdEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwRHJhZnQlMjBhJTIwYnJpZWYlMkMlMjBwcm9mZXNzaW9uYWwlMjByZXNwb25zZSUyMHRoYXQlMjBNci4lMjBIdWdnJTIwY2FuJTIwcmV2aWV3JTIwYW5kJTIwcGVyc29uYWxpemUlMjBiZWZvcmUlMjBzZW5kaW5nLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMENhbGwlMjB0aGUlMjBMTE0lMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyMCUzRCUyMCU1Qkh1bWFuTWVzc2FnZShjb250ZW50JTNEcHJvbXB0KSU1RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwbW9kZWwuaW52b2tlKG1lc3NhZ2VzKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMG1lc3NhZ2VzJTIwZm9yJTIwdHJhY2tpbmclMEElMjAlMjAlMjAlMjBuZXdfbWVzc2FnZXMlMjAlM0QlMjBzdGF0ZS5nZXQoJTIybWVzc2FnZXMlMjIlMkMlMjAlNUIlNUQpJTIwJTJCJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcHJvbXB0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwc3RhdGUlMjB1cGRhdGVzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1haWxfZHJhZnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjBuZXdfbWVzc2FnZXMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEFkZWYlMjBub3RpZnlfbXJfaHVnZyhzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwbm90aWZpZXMlMjBNci4lMjBIdWdnJTIwYWJvdXQlMjB0aGUlMjBlbWFpbCUyMGFuZCUyMHByZXNlbnRzJTIwdGhlJTIwZHJhZnQlMjByZXNwb25zZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVtYWlsJTIwJTNEJTIwc3RhdGUlNUIlMjJlbWFpbCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiU1Q24lMjIlMjAlMkIlMjAlMjIlM0QlMjIqNTApJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlNpciUyQyUyMHlvdSd2ZSUyMHJlY2VpdmVkJTIwYW4lMjBlbWFpbCUyMGZyb20lMjAlN0JlbWFpbCU1QidzZW5kZXInJTVEJTdELiUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyU3ViamVjdCUzQSUyMCU3QmVtYWlsJTVCJ3N1YmplY3QnJTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJDYXRlZ29yeSUzQSUyMCU3QnN0YXRlJTVCJ2VtYWlsX2NhdGVnb3J5JyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjIlNUNuSSd2ZSUyMHByZXBhcmVkJTIwYSUyMGRyYWZ0JTIwcmVzcG9uc2UlMjBmb3IlMjB5b3VyJTIwcmV2aWV3JTNBJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0lMjIqNTApJTBBJTIwJTIwJTIwJTIwcHJpbnQoc3RhdGUlNUIlMjJlbWFpbF9kcmFmdCUyMiU1RCklMEElMjAlMjAlMjAlMjBwcmludCglMjIlM0QlMjIqNTAlMjAlMkIlMjAlMjIlNUNuJTIyKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFdlJ3JlJTIwZG9uZSUyMHByb2Nlc3NpbmclMjB0aGlzJTIwZW1haWwlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlN0Q=",highlighted:`<span class="hljs-comment"># Initialize our LLM</span>
model = ChatOpenAI(temperature=<span class="hljs-number">0</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred reads and logs the incoming email&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Here we might do some initial preprocessing</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred is processing an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span> with subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    
    <span class="hljs-comment"># No state changes needed here</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred uses an LLM to determine if the email is spam or legitimate&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Prepare our prompt for the LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, analyze this email and determine if it is spam or legitimate.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    First, determine if this email is spam. If it is spam, explain why.
    If it is legitimate, categorize it (inquiry, complaint, thank you, etc.).
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Simple logic to parse the response (in a real app, you&#x27;d want more robust parsing)</span>
    response_text = response.content.lower()
    is_spam = <span class="hljs-string">&quot;spam&quot;</span> <span class="hljs-keyword">in</span> response_text <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;not spam&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> response_text
    
    <span class="hljs-comment"># Extract a reason if it&#x27;s spam</span>
    spam_reason = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> is_spam <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;reason:&quot;</span> <span class="hljs-keyword">in</span> response_text:
        spam_reason = response_text.split(<span class="hljs-string">&quot;reason:&quot;</span>)[<span class="hljs-number">1</span>].strip()
    
    <span class="hljs-comment"># Determine category if legitimate</span>
    email_category = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> is_spam:
        categories = [<span class="hljs-string">&quot;inquiry&quot;</span>, <span class="hljs-string">&quot;complaint&quot;</span>, <span class="hljs-string">&quot;thank you&quot;</span>, <span class="hljs-string">&quot;request&quot;</span>, <span class="hljs-string">&quot;information&quot;</span>]
        <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> categories:
            <span class="hljs-keyword">if</span> category <span class="hljs-keyword">in</span> response_text:
                email_category = category
                <span class="hljs-keyword">break</span>
    
    <span class="hljs-comment"># Update messages for tracking</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Return state updates</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;is_spam&quot;</span>: is_spam,
        <span class="hljs-string">&quot;spam_reason&quot;</span>: spam_reason,
        <span class="hljs-string">&quot;email_category&quot;</span>: email_category,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_spam</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred discards spam email with a note&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred has marked the email as spam. Reason: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;spam_reason&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The email has been moved to the spam folder.&quot;</span>)
    
    <span class="hljs-comment"># We&#x27;re done processing this email</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draft_response</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred drafts a preliminary response for legitimate emails&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    category = state[<span class="hljs-string">&quot;email_category&quot;</span>] <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;general&quot;</span>
    
    <span class="hljs-comment"># Prepare our prompt for the LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, draft a polite preliminary response to this email.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    This email has been categorized as: <span class="hljs-subst">{category}</span>
    
    Draft a brief, professional response that Mr. Hugg can review and personalize before sending.
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Update messages for tracking</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Return state updates</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;email_draft&quot;</span>: response.content,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">notify_mr_hugg</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred notifies Mr. Hugg about the email and presents the draft response&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Sir, you&#x27;ve received an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Category: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;email_category&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nI&#x27;ve prepared a draft response for your review:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;email_draft&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)
    
    <span class="hljs-comment"># We&#x27;re done processing this email</span>
    <span class="hljs-keyword">return</span> {}`,wrap:!1}}),v=new m({props:{title:"Step 3: Define Our Routing Logic",local:"step-3-define-our-routing-logic",headingTag:"h2"}}),x=new h({props:{code:"ZGVmJTIwcm91dGVfZW1haWwoc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEZXRlcm1pbmUlMjB0aGUlMjBuZXh0JTIwc3RlcCUyMGJhc2VkJTIwb24lMjBzcGFtJTIwY2xhc3NpZmljYXRpb24lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpZiUyMHN0YXRlJTVCJTIyaXNfc3BhbSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMnNwYW0lMjIlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybGVnaXRpbWF0ZSUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">route_email</span>(<span class="hljs-params">state: EmailState</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Determine the next step based on spam classification&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> state[<span class="hljs-string">&quot;is_spam&quot;</span>]:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;spam&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;legitimate&quot;</span>`,wrap:!1}}),R=new m({props:{title:"Step 4: Create the StateGraph and Define Edges",local:"step-4-create-the-stategraph-and-define-edges",headingTag:"h2"}}),L=new h({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwZ3JhcGglMEFlbWFpbF9ncmFwaCUyMCUzRCUyMFN0YXRlR3JhcGgoRW1haWxTdGF0ZSklMEElMEElMjMlMjBBZGQlMjBub2RlcyUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjByZWFkX2VtYWlsKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTIwY2xhc3NpZnlfZW1haWwpJTBBZW1haWxfZ3JhcGguYWRkX25vZGUoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBoYW5kbGVfc3BhbSklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMGRyYWZ0X3Jlc3BvbnNlKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwbm90aWZ5X21yX2h1Z2cpJTBBJTBBJTIzJTIwU3RhcnQlMjB0aGUlMjBlZGdlcyUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIycmVhZF9lbWFpbCUyMiklMEElMjMlMjBBZGQlMjBlZGdlcyUyMC0lMjBkZWZpbmluZyUyMHRoZSUyMGZsb3clMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJyZWFkX2VtYWlsJTIyJTJDJTIwJTIyY2xhc3NpZnlfZW1haWwlMjIpJTBBJTBBJTIzJTIwQWRkJTIwY29uZGl0aW9uYWwlMjBicmFuY2hpbmclMjBmcm9tJTIwY2xhc3NpZnlfZW1haWwlMEFlbWFpbF9ncmFwaC5hZGRfY29uZGl0aW9uYWxfZWRnZXMoJTBBJTIwJTIwJTIwJTIwJTIyY2xhc3NpZnlfZW1haWwlMjIlMkMlMEElMjAlMjAlMjAlMjByb3V0ZV9lbWFpbCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNwYW0lMjIlM0ElMjAlMjJoYW5kbGVfc3BhbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlZ2l0aW1hdGUlMjIlM0ElMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSklMEElMEElMjMlMjBBZGQlMjB0aGUlMjBmaW5hbCUyMGVkZ2VzJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBFTkQpJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIyZHJhZnRfcmVzcG9uc2UlMjIlMkMlMjAlMjJub3RpZnlfbXJfaHVnZyUyMiklMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJub3RpZnlfbXJfaHVnZyUyMiUyQyUyMEVORCklMEElMEElMjMlMjBDb21waWxlJTIwdGhlJTIwZ3JhcGglMEFjb21waWxlZF9ncmFwaCUyMCUzRCUyMGVtYWlsX2dyYXBoLmNvbXBpbGUoKQ==",highlighted:`<span class="hljs-comment"># Create the graph</span>
email_graph = StateGraph(EmailState)

<span class="hljs-comment"># Add nodes</span>
email_graph.add_node(<span class="hljs-string">&quot;read_email&quot;</span>, read_email)
email_graph.add_node(<span class="hljs-string">&quot;classify_email&quot;</span>, classify_email)
email_graph.add_node(<span class="hljs-string">&quot;handle_spam&quot;</span>, handle_spam)
email_graph.add_node(<span class="hljs-string">&quot;draft_response&quot;</span>, draft_response)
email_graph.add_node(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, notify_mr_hugg)

<span class="hljs-comment"># Start the edges</span>
email_graph.add_edge(START, <span class="hljs-string">&quot;read_email&quot;</span>)
<span class="hljs-comment"># Add edges - defining the flow</span>
email_graph.add_edge(<span class="hljs-string">&quot;read_email&quot;</span>, <span class="hljs-string">&quot;classify_email&quot;</span>)

<span class="hljs-comment"># Add conditional branching from classify_email</span>
email_graph.add_conditional_edges(
    <span class="hljs-string">&quot;classify_email&quot;</span>,
    route_email,
    {
        <span class="hljs-string">&quot;spam&quot;</span>: <span class="hljs-string">&quot;handle_spam&quot;</span>,
        <span class="hljs-string">&quot;legitimate&quot;</span>: <span class="hljs-string">&quot;draft_response&quot;</span>
    }
)

<span class="hljs-comment"># Add the final edges</span>
email_graph.add_edge(<span class="hljs-string">&quot;handle_spam&quot;</span>, END)
email_graph.add_edge(<span class="hljs-string">&quot;draft_response&quot;</span>, <span class="hljs-string">&quot;notify_mr_hugg&quot;</span>)
email_graph.add_edge(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, END)

<span class="hljs-comment"># Compile the graph</span>
compiled_graph = email_graph.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),O=new m({props:{title:"Step 5: Run the Application",local:"step-5-run-the-application",headingTag:"h2"}}),K=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># Example legitimate email</span>
legitimate_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;john.smith@example.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;Question about your services&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;Dear Mr. Hugg, I was referred to you by a colleague and I&#x27;m interested in learning more about your consulting services. Could we schedule a call next week? Best regards, John Smith&quot;</span>
}

<span class="hljs-comment"># Example spam email</span>
spam_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;winner@lottery-intl.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;YOU HAVE WON $5,000,000!!!&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;CONGRATULATIONS! You have been selected as the winner of our international lottery! To claim your $5,000,000 prize, please send us your bank details and a processing fee of $100.&quot;</span>
}

<span class="hljs-comment"># Process the legitimate email</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing legitimate email...&quot;</span>)
legitimate_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: legitimate_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_draft&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})

<span class="hljs-comment"># Process the spam email</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing spam email...&quot;</span>)
spam_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: spam_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_draft&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})`,wrap:!1}}),ll=new m({props:{title:"Step 6: Inspecting Our Mail Sorting Agent with Langfuse 📡",local:"step-6-inspecting-our-mail-sorting-agent-with-langfuse-",headingTag:"h2"}}),el=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwbGFuZ2Z1c2U=",highlighted:"%pip install -q langfuse",wrap:!1}}),Ml=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdjaGFpbg==",highlighted:"%pip install langchain",wrap:!1}}),pl=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMjAlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os
 
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),yl=new h({props:{code:"ZnJvbSUyMGxhbmdmdXNlLmNhbGxiYWNrJTIwaW1wb3J0JTIwQ2FsbGJhY2tIYW5kbGVyJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMExhbmdmdXNlJTIwQ2FsbGJhY2tIYW5kbGVyJTIwZm9yJTIwTGFuZ0dyYXBoJTJGTGFuZ2NoYWluJTIwKHRyYWNpbmcpJTBBbGFuZ2Z1c2VfaGFuZGxlciUyMCUzRCUyMENhbGxiYWNrSGFuZGxlcigpJTBBJTBBJTIzJTIwUHJvY2VzcyUyMGxlZ2l0aW1hdGUlMjBlbWFpbCUwQWxlZ2l0aW1hdGVfcmVzdWx0JTIwJTNEJTIwY29tcGlsZWRfZ3JhcGguaW52b2tlKCUwQSUyMCUyMCUyMCUyMGlucHV0JTNEJTdCJTIyZW1haWwlMjIlM0ElMjBsZWdpdGltYXRlX2VtYWlsJTJDJTIwJTIyaXNfc3BhbSUyMiUzQSUyME5vbmUlMkMlMjAlMjJzcGFtX3JlYXNvbiUyMiUzQSUyME5vbmUlMkMlMjAlMjJlbWFpbF9jYXRlZ29yeSUyMiUzQSUyME5vbmUlMkMlMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUzQSUyME5vbmUlMkMlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRCU3QiUyMmNhbGxiYWNrcyUyMiUzQSUyMCU1QmxhbmdmdXNlX2hhbmRsZXIlNUQlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse.callback <span class="hljs-keyword">import</span> CallbackHandler

<span class="hljs-comment"># Initialize Langfuse CallbackHandler for LangGraph/Langchain (tracing)</span>
langfuse_handler = CallbackHandler()

<span class="hljs-comment"># Process legitimate email</span>
legitimate_result = compiled_graph.invoke(
    <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;email&quot;</span>: legitimate_email, <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;messages&quot;</span>: []},
    config={<span class="hljs-string">&quot;callbacks&quot;</span>: [langfuse_handler]}
)`,wrap:!1}}),jl=new m({props:{title:"Visualizing Our Graph",local:"visualizing-our-graph",headingTag:"h2"}}),Ul=new h({props:{code:"Y29tcGlsZWRfZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygp",highlighted:"compiled_graph.get_graph().draw_mermaid_png()",wrap:!1}}),hl=new m({props:{title:"What We’ve Built",local:"what-weve-built",headingTag:"h2"}}),gl=new m({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),Cl=new m({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),Bl=new ft({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/first_graph.mdx"}}),{c(){U=M("meta"),r=e(),I=M("p"),u=e(),J(w.$$.fragment),d=e(),C=M("p"),C.textContent=Qs,Gl=e(),f=M("ol"),f.innerHTML=Ss,El=e(),B=M("p"),B.textContent=ks,ql=e(),J(g.$$.fragment),Nl=e(),J(W.$$.fragment),Al=e(),Z=M("p"),Z.textContent=Vs,Ql=e(),G=M("img"),Sl=e(),J(E.$$.fragment),kl=e(),q=M("p"),q.textContent=$s,Vl=e(),J(N.$$.fragment),Yl=e(),A=M("p"),A.textContent=Fs,$l=e(),J(Q.$$.fragment),Fl=e(),J(S.$$.fragment),_l=e(),k=M("p"),k.textContent=_s,vl=e(),J(V.$$.fragment),Xl=e(),Y=M("blockquote"),Y.innerHTML=vs,xl=e(),J($.$$.fragment),zl=e(),F=M("p"),F.textContent=Xs,Rl=e(),J(_.$$.fragment),Hl=e(),J(v.$$.fragment),Ll=e(),X=M("p"),X.textContent=xs,Dl=e(),J(x.$$.fragment),Ol=e(),z=M("blockquote"),z.innerHTML=zs,Pl=e(),J(R.$$.fragment),Kl=e(),H=M("p"),H.textContent=Rs,ls=e(),J(L.$$.fragment),ss=e(),D=M("p"),D.innerHTML=Hs,ts=e(),J(O.$$.fragment),as=e(),P=M("p"),P.textContent=Ls,es=e(),J(K.$$.fragment),ns=e(),J(ll.$$.fragment),Ms=e(),sl=M("p"),sl.textContent=Ds,is=e(),tl=M("p"),tl.innerHTML=Os,ps=e(),al=M("p"),al.textContent=Ps,Js=e(),J(el.$$.fragment),ys=e(),nl=M("p"),nl.textContent=Ks,os=e(),J(Ml.$$.fragment),Ts=e(),il=M("p"),il.innerHTML=lt,cs=e(),J(pl.$$.fragment),js=e(),Jl=M("p"),Jl.innerHTML=st,ws=e(),J(yl.$$.fragment),Us=e(),ol=M("p"),ol.textContent=tt,rs=e(),Tl=M("p"),Tl.innerHTML=at,ms=e(),cl=M("p"),cl.innerHTML=et,hs=e(),J(jl.$$.fragment),us=e(),wl=M("p"),wl.textContent=nt,Is=e(),J(Ul.$$.fragment),ds=e(),rl=M("img"),gs=e(),ml=M("p"),ml.textContent=it,bs=e(),J(hl.$$.fragment),Cs=e(),ul=M("p"),ul.textContent=pt,fs=e(),Il=M("ol"),Il.innerHTML=Jt,Bs=e(),dl=M("p"),dl.textContent=yt,Ws=e(),J(gl.$$.fragment),Zs=e(),bl=M("ul"),bl.innerHTML=ot,Gs=e(),J(Cl.$$.fragment),Es=e(),fl=M("p"),fl.textContent=Tt,qs=e(),J(Bl.$$.fragment),Ns=e(),Wl=M("p"),this.h()},l(l){const s=gt("svelte-u9bgzb",document.head);U=i(s,"META",{name:!0,content:!0}),s.forEach(t),r=n(l),I=i(l,"P",{}),wt(I).forEach(t),u=n(l),y(w.$$.fragment,l),d=n(l),C=i(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-vhd0jr"&&(C.textContent=Qs),Gl=n(l),f=i(l,"OL",{"data-svelte-h":!0}),p(f)!=="svelte-1v71265"&&(f.innerHTML=Ss),El=n(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1qg9fnr"&&(B.textContent=ks),ql=n(l),y(g.$$.fragment,l),Nl=n(l),y(W.$$.fragment,l),Al=n(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-9r2hfn"&&(Z.textContent=Vs),Ql=n(l),G=i(l,"IMG",{src:!0,alt:!0}),Sl=n(l),y(E.$$.fragment,l),kl=n(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1n92y5t"&&(q.textContent=$s),Vl=n(l),y(N.$$.fragment,l),Yl=n(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-rnel3w"&&(A.textContent=Fs),$l=n(l),y(Q.$$.fragment,l),Fl=n(l),y(S.$$.fragment,l),_l=n(l),k=i(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-54271l"&&(k.textContent=_s),vl=n(l),y(V.$$.fragment,l),Xl=n(l),Y=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(Y)!=="svelte-10gtfo"&&(Y.innerHTML=vs),xl=n(l),y($.$$.fragment,l),zl=n(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1d4gnq4"&&(F.textContent=Xs),Rl=n(l),y(_.$$.fragment,l),Hl=n(l),y(v.$$.fragment,l),Ll=n(l),X=i(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1n2afnf"&&(X.textContent=xs),Dl=n(l),y(x.$$.fragment,l),Ol=n(l),z=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(z)!=="svelte-k4q46u"&&(z.innerHTML=zs),Pl=n(l),y(R.$$.fragment,l),Kl=n(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1c3pli7"&&(H.textContent=Rs),ls=n(l),y(L.$$.fragment,l),ss=n(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-18k1jtw"&&(D.innerHTML=Hs),ts=n(l),y(O.$$.fragment,l),as=n(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1kryxnq"&&(P.textContent=Ls),es=n(l),y(K.$$.fragment,l),ns=n(l),y(ll.$$.fragment,l),Ms=n(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-124nptk"&&(sl.textContent=Ds),is=n(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-i70kr9"&&(tl.innerHTML=Os),ps=n(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-fhqopd"&&(al.textContent=Ps),Js=n(l),y(el.$$.fragment,l),ys=n(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-1ketwty"&&(nl.textContent=Ks),os=n(l),y(Ml.$$.fragment,l),Ts=n(l),il=i(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-1i2d6na"&&(il.innerHTML=lt),cs=n(l),y(pl.$$.fragment,l),js=n(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-1bzsazf"&&(Jl.innerHTML=st),ws=n(l),y(yl.$$.fragment,l),Us=n(l),ol=i(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-blbazh"&&(ol.textContent=tt),rs=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-3rgcl6"&&(Tl.innerHTML=at),ms=n(l),cl=i(l,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-1kmw2a1"&&(cl.innerHTML=et),hs=n(l),y(jl.$$.fragment,l),us=n(l),wl=i(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-1wkuxx2"&&(wl.textContent=nt),Is=n(l),y(Ul.$$.fragment,l),ds=n(l),rl=i(l,"IMG",{src:!0,alt:!0}),gs=n(l),ml=i(l,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-hhguub"&&(ml.textContent=it),bs=n(l),y(hl.$$.fragment,l),Cs=n(l),ul=i(l,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-1vjenz"&&(ul.textContent=pt),fs=n(l),Il=i(l,"OL",{"data-svelte-h":!0}),p(Il)!=="svelte-eyxtqr"&&(Il.innerHTML=Jt),Bs=n(l),dl=i(l,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-1evobzg"&&(dl.textContent=yt),Ws=n(l),y(gl.$$.fragment,l),Zs=n(l),bl=i(l,"UL",{"data-svelte-h":!0}),p(bl)!=="svelte-w0bhrr"&&(bl.innerHTML=ot),Gs=n(l),y(Cl.$$.fragment,l),Es=n(l),fl=i(l,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-1kcwc84"&&(fl.textContent=Tt),qs=n(l),y(Bl.$$.fragment,l),Ns=n(l),Wl=i(l,"P",{}),wt(Wl).forEach(t),this.h()},h(){b(U,"name","hf:doc:metadata"),b(U,"content",Zt),jt(G.src,Ys="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/first_graph.png")||b(G,"src",Ys),b(G,"alt","First LangGraph"),jt(rl.src,Mt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/mail_flow.png")||b(rl,"src",Mt),b(rl,"alt","Mail LangGraph")},m(l,s){bt(document.head,U),a(l,r,s),a(l,I,s),a(l,u,s),o(w,l,s),a(l,d,s),a(l,C,s),a(l,Gl,s),a(l,f,s),a(l,El,s),a(l,B,s),a(l,ql,s),o(g,l,s),a(l,Nl,s),o(W,l,s),a(l,Al,s),a(l,Z,s),a(l,Ql,s),a(l,G,s),a(l,Sl,s),o(E,l,s),a(l,kl,s),a(l,q,s),a(l,Vl,s),o(N,l,s),a(l,Yl,s),a(l,A,s),a(l,$l,s),o(Q,l,s),a(l,Fl,s),o(S,l,s),a(l,_l,s),a(l,k,s),a(l,vl,s),o(V,l,s),a(l,Xl,s),a(l,Y,s),a(l,xl,s),o($,l,s),a(l,zl,s),a(l,F,s),a(l,Rl,s),o(_,l,s),a(l,Hl,s),o(v,l,s),a(l,Ll,s),a(l,X,s),a(l,Dl,s),o(x,l,s),a(l,Ol,s),a(l,z,s),a(l,Pl,s),o(R,l,s),a(l,Kl,s),a(l,H,s),a(l,ls,s),o(L,l,s),a(l,ss,s),a(l,D,s),a(l,ts,s),o(O,l,s),a(l,as,s),a(l,P,s),a(l,es,s),o(K,l,s),a(l,ns,s),o(ll,l,s),a(l,Ms,s),a(l,sl,s),a(l,is,s),a(l,tl,s),a(l,ps,s),a(l,al,s),a(l,Js,s),o(el,l,s),a(l,ys,s),a(l,nl,s),a(l,os,s),o(Ml,l,s),a(l,Ts,s),a(l,il,s),a(l,cs,s),o(pl,l,s),a(l,js,s),a(l,Jl,s),a(l,ws,s),o(yl,l,s),a(l,Us,s),a(l,ol,s),a(l,rs,s),a(l,Tl,s),a(l,ms,s),a(l,cl,s),a(l,hs,s),o(jl,l,s),a(l,us,s),a(l,wl,s),a(l,Is,s),o(Ul,l,s),a(l,ds,s),a(l,rl,s),a(l,gs,s),a(l,ml,s),a(l,bs,s),o(hl,l,s),a(l,Cs,s),a(l,ul,s),a(l,fs,s),a(l,Il,s),a(l,Bs,s),a(l,dl,s),a(l,Ws,s),o(gl,l,s),a(l,Zs,s),a(l,bl,s),a(l,Gs,s),o(Cl,l,s),a(l,Es,s),a(l,fl,s),a(l,qs,s),o(Bl,l,s),a(l,Ns,s),a(l,Wl,s),As=!0},p(l,[s]){const ct={};s&2&&(ct.$$scope={dirty:s,ctx:l}),g.$set(ct)},i(l){As||(T(w.$$.fragment,l),T(g.$$.fragment,l),T(W.$$.fragment,l),T(E.$$.fragment,l),T(N.$$.fragment,l),T(Q.$$.fragment,l),T(S.$$.fragment,l),T(V.$$.fragment,l),T($.$$.fragment,l),T(_.$$.fragment,l),T(v.$$.fragment,l),T(x.$$.fragment,l),T(R.$$.fragment,l),T(L.$$.fragment,l),T(O.$$.fragment,l),T(K.$$.fragment,l),T(ll.$$.fragment,l),T(el.$$.fragment,l),T(Ml.$$.fragment,l),T(pl.$$.fragment,l),T(yl.$$.fragment,l),T(jl.$$.fragment,l),T(Ul.$$.fragment,l),T(hl.$$.fragment,l),T(gl.$$.fragment,l),T(Cl.$$.fragment,l),T(Bl.$$.fragment,l),As=!0)},o(l){c(w.$$.fragment,l),c(g.$$.fragment,l),c(W.$$.fragment,l),c(E.$$.fragment,l),c(N.$$.fragment,l),c(Q.$$.fragment,l),c(S.$$.fragment,l),c(V.$$.fragment,l),c($.$$.fragment,l),c(_.$$.fragment,l),c(v.$$.fragment,l),c(x.$$.fragment,l),c(R.$$.fragment,l),c(L.$$.fragment,l),c(O.$$.fragment,l),c(K.$$.fragment,l),c(ll.$$.fragment,l),c(el.$$.fragment,l),c(Ml.$$.fragment,l),c(pl.$$.fragment,l),c(yl.$$.fragment,l),c(jl.$$.fragment,l),c(Ul.$$.fragment,l),c(hl.$$.fragment,l),c(gl.$$.fragment,l),c(Cl.$$.fragment,l),c(Bl.$$.fragment,l),As=!1},d(l){l&&(t(r),t(I),t(u),t(d),t(C),t(Gl),t(f),t(El),t(B),t(ql),t(Nl),t(Al),t(Z),t(Ql),t(G),t(Sl),t(kl),t(q),t(Vl),t(Yl),t(A),t($l),t(Fl),t(_l),t(k),t(vl),t(Xl),t(Y),t(xl),t(zl),t(F),t(Rl),t(Hl),t(Ll),t(X),t(Dl),t(Ol),t(z),t(Pl),t(Kl),t(H),t(ls),t(ss),t(D),t(ts),t(as),t(P),t(es),t(ns),t(Ms),t(sl),t(is),t(tl),t(ps),t(al),t(Js),t(ys),t(nl),t(os),t(Ts),t(il),t(cs),t(js),t(Jl),t(ws),t(Us),t(ol),t(rs),t(Tl),t(ms),t(cl),t(hs),t(us),t(wl),t(Is),t(ds),t(rl),t(gs),t(ml),t(bs),t(Cs),t(ul),t(fs),t(Il),t(Bs),t(dl),t(Ws),t(Zs),t(bl),t(Gs),t(Es),t(fl),t(qs),t(Ns),t(Wl)),t(U),j(w,l),j(g,l),j(W,l),j(E,l),j(N,l),j(Q,l),j(S,l),j(V,l),j($,l),j(_,l),j(v,l),j(x,l),j(R,l),j(L,l),j(O,l),j(K,l),j(ll,l),j(el,l),j(Ml,l),j(pl,l),j(yl,l),j(jl,l),j(Ul,l),j(hl,l),j(gl,l),j(Cl,l),j(Bl,l)}}}const Zt='{"title":"Building Your First LangGraph","local":"building-your-first-langgraph","sections":[{"title":"Our Workflow","local":"our-workflow","sections":[],"depth":2},{"title":"Setting Up Our Environment","local":"setting-up-our-environment","sections":[],"depth":2},{"title":"Step 1: Define Our State","local":"step-1-define-our-state","sections":[],"depth":2},{"title":"Step 2: Define Our Nodes","local":"step-2-define-our-nodes","sections":[],"depth":2},{"title":"Step 3: Define Our Routing Logic","local":"step-3-define-our-routing-logic","sections":[],"depth":2},{"title":"Step 4: Create the StateGraph and Define Edges","local":"step-4-create-the-stategraph-and-define-edges","sections":[],"depth":2},{"title":"Step 5: Run the Application","local":"step-5-run-the-application","sections":[],"depth":2},{"title":"Step 6: Inspecting Our Mail Sorting Agent with Langfuse 📡","local":"step-6-inspecting-our-mail-sorting-agent-with-langfuse-","sections":[],"depth":2},{"title":"Visualizing Our Graph","local":"visualizing-our-graph","sections":[],"depth":2},{"title":"What We’ve Built","local":"what-weve-built","sections":[],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Gt(Zl){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends It{constructor(U){super(),dt(this,U,Gt,Wt,mt,{})}}export{kt as component};
