import{s as ca,o as ma,n as oa}from"../chunks/scheduler.25b97de1.js";import{S as ra,i as da,g as i,s as l,r as m,A as Ma,h as p,f as e,c as n,j as pa,u as r,x as o,k as x,y as ha,a,v as d,d as M,t as h,w as g,m as ga,n as ua}from"../chunks/index.d9030fc9.js";import{T as re}from"../chunks/Tip.baa67368.js";import{C as f}from"../chunks/CodeBlock.e6cd0d95.js";import{D as ya}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as j,E as fa}from"../chunks/EditOnGithub.91d95064.js";function ja(J){let c;return{c(){c=ga("To run the following examples with a non-quantized version of the model checkpoint you will need at least 20GB of GPU memory.")},l(y){c=ua(y,"To run the following examples with a non-quantized version of the model checkpoint you will need at least 20GB of GPU memory.")},m(y,u){a(y,c,u)},d(y){y&&e(c)}}}function Ja(J){let c,y=`It is a good idea to include the <code>bad_words_ids</code> in the call to <code>generate</code> to avoid errors arising when increasing
the <code>max_new_tokens</code>: the model will want to generate a new <code>&lt;image&gt;</code> or <code>&lt;fake_token_around_image&gt;</code> token when there
is no image being generated by the model.
You can set it on-the-fly as in this guide, or store in the <code>GenerationConfig</code> as described in the <a href="../generation_strategies">Text generation strategies</a> guide.`;return{c(){c=i("p"),c.innerHTML=y},l(u){c=p(u,"P",{"data-svelte-h":!0}),o(c)!=="svelte-uwc51d"&&(c.innerHTML=y)},m(u,w){a(u,c,w)},p:oa,d(u){u&&e(c)}}}function wa(J){let c,y=`For longer outputs like this, you will greatly benefit from tweaking the text generation strategy. This can help
you significantly improve the quality of the generated output. Check out <a href="../generation_strategies">Text generation strategies</a>
to learn more.`;return{c(){c=i("p"),c.innerHTML=y},l(u){c=p(u,"P",{"data-svelte-h":!0}),o(c)!=="svelte-79vr3a"&&(c.innerHTML=y)},m(u,w){a(u,c,w)},p:oa,d(u){u&&e(c)}}}function Ta(J){let c,y,u,w,W,Et,_,Yt,N,de=`While individual tasks can be tackled by fine-tuning specialized models, an alternative approach
that has recently emerged and gained popularity is to use large models for a diverse set of tasks without fine-tuning.
For instance, large language models can handle such NLP tasks as summarization, translation, classification, and more.
This approach is no longer limited to a single modality, such as text, and in this guide, we will illustrate how you can
solve image-text tasks with a large multimodal model called IDEFICS.`,At,G,Me=`<a href="../model_doc/idefics">IDEFICS</a> is an open-access vision and language model based on <a href="https://huggingface.co/papers/2204.14198" rel="nofollow">Flamingo</a>,
a state-of-the-art visual language model initially developed by DeepMind. The model accepts arbitrary sequences of image
and text inputs and generates coherent text as output. It can answer questions about images, describe visual content,
create stories grounded in multiple images, and so on. IDEFICS comes in two variants - <a href="https://huggingface.co/HuggingFaceM4/idefics-80b" rel="nofollow">80 billion parameters</a>
and <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">9 billion parameters</a>, both of which are available on the 🤗 Hub. For each variant, you can also find fine-tuned instructed
versions of the model adapted for conversational use cases.`,qt,z,he=`This model is exceptionally versatile and can be used for a wide range of image and multimodal tasks. However,
being a large model means it requires significant computational resources and infrastructure. It is up to you to decide whether
this approach suits your use case better than fine-tuning specialized models for each individual task.`,St,Q,ge="In this guide, you’ll learn how to:",Dt,B,ue='<li><a href="#loading-the-model">Load IDEFICS</a> and <a href="#quantized-model">load the quantized version of the model</a></li> <li>Use IDEFICS for: <ul><li><a href="#image-captioning">Image captioning</a></li> <li><a href="#prompted-image-captioning">Prompted image captioning</a></li> <li><a href="#few-shot-prompting">Few-shot prompting</a></li> <li><a href="#visual-question-answering">Visual question answering</a></li> <li><a href="#image-classification">Image classification</a></li> <li><a href="#image-guided-text-generation">Image-guided text generation</a></li></ul></li> <li><a href="#running-inference-in-batch-mode">Run inference in batch mode</a></li> <li><a href="#idefics-instruct-for-conversational-use">Run IDEFICS instruct for conversational use</a></li>',Lt,V,ye="Before you begin, make sure you have all the necessary libraries installed.",Pt,H,Ot,T,Kt,X,ts,$,fe="Let’s start by loading the model’s 9 billion parameters checkpoint:",ss,F,es,E,je=`Just like for other Transformers models, you need to load a processor and the model itself from the checkpoint.
The IDEFICS processor wraps a <a href="/docs/transformers/pr_30984/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> and IDEFICS image processor into a single processor to take care of
preparing text and image inputs for the model.`,as,Y,ls,A,Je=`Setting <code>device_map</code> to <code>&quot;auto&quot;</code> will automatically determine how to load and store the model weights in the most optimized
manner given existing devices.`,ns,q,is,S,we=`If high-memory GPU availability is an issue, you can load the quantized version of the model. To load the model and the
processor in 4bit precision, pass a <code>BitsAndBytesConfig</code> to the <code>from_pretrained</code> method and the model will be compressed
on the fly while loading.`,ps,D,os,L,Te="Now that you have the model loaded in one of the suggested ways, let’s move on to exploring tasks that you can use IDEFICS for.",cs,P,ms,O,Ue=`Image captioning is the task of predicting a caption for a given image. A common application is to aid visually impaired
people navigate through different situations, for instance, explore image content online.`,rs,K,be="To illustrate the task, get an image to be captioned, e.g.:",ds,U,Ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-im-captioning.jpg" alt="Image of a puppy in a flower bed"/>',Ms,tt,Ie='Photo by <a href="https://unsplash.com/@hendoo" rel="nofollow">Hendo Wang</a>.',hs,st,ke=`IDEFICS accepts text and image prompts. However, to caption an image, you do not have to provide a text prompt to the
model, only the preprocessed input image. Without a text prompt, the model will start generating text from the
BOS (beginning-of-sequence) token thus creating a caption.`,gs,et,Ce="As image input to the model, you can use either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",us,at,ys,b,fs,lt,js,nt,Re=`You can extend image captioning by providing a text prompt, which the model will continue given the image. Let’s take
another image to illustrate:`,Js,Z,ve='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-prompted-im-captioning.jpg" alt="Image of the Eiffel Tower at night"/>',ws,it,xe='Photo by <a href="https://unsplash.com/@dnevozhai" rel="nofollow">Denys Nevozhai</a>.',Ts,pt,We="Textual and image prompts can be passed to the model’s processor as a single list to create appropriate inputs.",Us,ot,bs,ct,Zs,mt,_e=`While IDEFICS demonstrates great zero-shot results, your task may require a certain format of the caption, or come with
other restrictions or requirements that increase task’s complexity. Few-shot prompting can be used to enable in-context learning.
By providing examples in the prompt, you can steer the model to generate results that mimic the format of given examples.`,Is,rt,Ne=`Let’s use the previous image of the Eiffel Tower as an example for the model and build a prompt that demonstrates to the model
that in addition to learning what the object in an image is, we would also like to get some interesting information about it.
Then, let’s see, if we can get the same response format for an image of the Statue of Liberty:`,ks,I,Ge='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-few-shot.jpg" alt="Image of the Statue of Liberty"/>',Cs,dt,ze='Photo by <a href="https://unsplash.com/@jmayobres" rel="nofollow">Juan Mayobre</a>.',Rs,Mt,vs,ht,Qe=`Notice that just from a single example (i.e., 1-shot) the model has learned how to perform the task. For more complex tasks,
feel free to experiment with a larger number of examples (e.g., 3-shot, 5-shot, etc.).`,xs,gt,Ws,ut,Be=`Visual Question Answering (VQA) is the task of answering open-ended questions based on an image. Similar to image
captioning it can be used in accessibility applications, but also in education (reasoning about visual materials), customer
service (questions about products based on images), and image retrieval.`,_s,yt,Ve="Let’s get a new image for this task:",Ns,k,He='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-vqa.jpg" alt="Image of a couple having a picnic"/>',Gs,ft,Xe='Photo by <a href="https://unsplash.com/@jarritos" rel="nofollow">Jarritos Mexican Soda</a>.',zs,jt,$e="You can steer the model from image captioning to visual question answering by prompting it with appropriate instructions:",Qs,Jt,Bs,wt,Vs,Tt,Fe=`IDEFICS is capable of classifying images into different categories without being explicitly trained on data containing
labeled examples from those specific categories. Given a list of categories and using its image and text understanding
capabilities, the model can infer which category the image likely belongs to.`,Hs,Ut,Ee="Say, we have this image of a vegetable stand:",Xs,C,Ye='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-classification.jpg" alt="Image of a vegetable stand"/>',$s,bt,Ae='Photo by <a href="https://unsplash.com/@peterwendt" rel="nofollow">Peter Wendt</a>.',Fs,Zt,qe="We can instruct the model to classify the image into one of the categories that we have:",Es,It,Ys,kt,Se="In the example above we instruct the model to classify the image into a single category, however, you can also prompt the model to do rank classification.",As,Ct,qs,Rt,De=`For more creative applications, you can use image-guided text generation to generate text based on an image. This can be
useful to create descriptions of products, ads, descriptions of a scene, etc.`,Ss,vt,Le="Let’s prompt IDEFICS to write a story based on a simple image of a red door:",Ds,R,Pe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-story-generation.jpg" alt="Image of a red door with a pumpkin on the steps"/>',Ls,xt,Oe='Photo by <a href="https://unsplash.com/@devonshiremedia" rel="nofollow">Craig Tidball</a>.',Ps,Wt,Os,_t,Ke="Looks like IDEFICS noticed the pumpkin on the doorstep and went with a spooky Halloween story about a ghost.",Ks,v,te,Nt,se,Gt,ta=`All of the earlier sections illustrated IDEFICS for a single example. In a very similar fashion, you can run inference
for a batch of examples by passing a list of prompts:`,ee,zt,ae,Qt,le,Bt,sa=`For conversational use cases, you can find fine-tuned instructed versions of the model on the 🤗 Hub:
<code>HuggingFaceM4/idefics-80b-instruct</code> and <code>HuggingFaceM4/idefics-9b-instruct</code>.`,ne,Vt,ea=`These checkpoints are the result of fine-tuning the respective base models on a mixture of supervised and instruction
fine-tuning datasets, which boosts the downstream performance while making the models more usable in conversational settings.`,ie,Ht,aa="The use and prompting for the conversational use is very similar to using the base models:",pe,Xt,oe,$t,ce,Ft,me;return W=new j({props:{title:"Image tasks with IDEFICS",local:"image-tasks-with-idefics",headingTag:"h1"}}),_=new ya({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/idefics.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/idefics.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/idefics.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/idefics.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/idefics.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/idefics.ipynb"}]}}),H=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwYml0c2FuZGJ5dGVzJTIwc2VudGVuY2VwaWVjZSUyMGFjY2VsZXJhdGUlMjB0cmFuc2Zvcm1lcnM=",highlighted:"pip install -q bitsandbytes sentencepiece accelerate transformers",wrap:!1}}),T=new re({props:{$$slots:{default:[ja]},$$scope:{ctx:J}}}),X=new j({props:{title:"Loading the model",local:"loading-the-model",headingTag:"h2"}}),F=new f({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>',wrap:!1}}),Y=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),q=new j({props:{title:"Quantized model",local:"quantized-model",headingTag:"h3"}}),D=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY2hlY2twb2ludCUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor, BitsAndBytesConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>quantization_config = BitsAndBytesConfig(
<span class="hljs-meta">... </span>    load_in_4bit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    bnb_4bit_compute_dtype=torch.float16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    quantization_config=quantization_config,
<span class="hljs-meta">... </span>    device_map=<span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),P=new j({props:{title:"Image captioning",local:"image-captioning",headingTag:"h2"}}),at=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZpbWFnZXMudW5zcGxhc2guY29tJTJGcGhvdG8tMTU4MzE2MDI0NzcxMS0yMTkxNzc2YjRiOTElM0ZpeGxpYiUzRHJiLTQuMC4zJTI2aXhpZCUzRE0zd3hNakEzZkRCOE1IeHdhRzkwYnkxd1lXZGxmSHg4ZkdWdWZEQjhmSHg4ZkElMjUzRCUyNTNEJTI2YXV0byUzRGZvcm1hdCUyNmZpdCUzRGNyb3AlMjZ3JTNEMzU0MiUyNnElM0Q4MCUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1583160247711-2191776b4b91?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3542&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
A puppy <span class="hljs-keyword">in</span> a flower bed`,wrap:!1}}),b=new re({props:{$$slots:{default:[Ja]},$$scope:{ctx:J}}}),lt=new j({props:{title:"Prompted image captioning",local:"prompted-image-captioning",headingTag:"h2"}}),ot=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZpbWFnZXMudW5zcGxhc2guY29tJTJGcGhvdG8tMTU0MzM0OTY4OS05YTRkNDI2YmVlOGUlM0ZpeGxpYiUzRHJiLTQuMC4zJTI2aXhpZCUzRE0zd3hNakEzZkRCOE1IeHdhRzkwYnkxd1lXZGxmSHg4ZkdWdWZEQjhmSHg4ZkElMjUzRCUyNTNEJTI2YXV0byUzRGZvcm1hdCUyNmZpdCUzRGNyb3AlMjZ3JTNEMzUwMSUyNnElM0Q4MCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBpcyUyMGFuJTIwaW1hZ2UlMjBvZiUyMCUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
This <span class="hljs-keyword">is</span> an image of the Eiffel Tower <span class="hljs-keyword">in</span> Paris, France.`,wrap:!1}}),ct=new j({props:{title:"Few-shot prompting",local:"few-shot-prompting",headingTag:"h2"}}),Mt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1NDMzNDk2ODktOWE0ZDQyNmJlZThlJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1MDElMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lNUNuQXNzaXN0YW50JTNBJTIwQW4lMjBpbWFnZSUyMG9mJTIwdGhlJTIwRWlmZmVsJTIwVG93ZXIlMjBhdCUyMG5pZ2h0LiUyMEZ1biUyMGZhY3QlM0ElMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMGlzJTIwdGhlJTIwc2FtZSUyMGhlaWdodCUyMGFzJTIwYW4lMjA4MS1zdG9yZXklMjBidWlsZGluZy4lNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MjQwOTkxNjMyNTMtMzJiN2YwMjU2ODY4JTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDMzODclMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lNUNuQXNzaXN0YW50JTNBJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBYmFkX3dvcmRzX2lkcyUyMCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIoJTVCJTIyJTNDaW1hZ2UlM0UlMjIlMkMlMjAlMjIlM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUyMiU1RCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0ZWRfdGV4dCU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;Describe this image.\\nAssistant: An image of the Eiffel Tower at night. Fun fact: the Eiffel Tower is the same height as an 81-storey building.\\n&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;https://images.unsplash.com/photo-1524099163253-32b7f0256868?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3387&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;Describe this image.\\nAssistant:&quot;</span>
<span class="hljs-meta">... </span>           ]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
User: Describe this image.
Assistant: An image of the Eiffel Tower at night. Fun fact: the Eiffel Tower <span class="hljs-keyword">is</span> the same height <span class="hljs-keyword">as</span> an <span class="hljs-number">81</span>-storey building. 
User: Describe this image.
Assistant: An image of the Statue of Liberty. Fun fact: the Statue of Liberty <span class="hljs-keyword">is</span> <span class="hljs-number">151</span> feet tall.`,wrap:!1}}),gt=new j({props:{title:"Visual question answering",local:"visual-question-answering",headingTag:"h2"}}),Jt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIySW5zdHJ1Y3Rpb24lM0ElMjBQcm92aWRlJTIwYW4lMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUyMFVzZSUyMHRoZSUyMGltYWdlJTIwdG8lMjBhbnN3ZXIuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE2MjM5NDQ4ODkyODgtY2QxNDdkYmI1MTdjJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1NDAlMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJRdWVzdGlvbiUzQSUyMFdoZXJlJTIwYXJlJTIwdGhlc2UlMjBwZW9wbGUlMjBhbmQlMjB3aGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwbGlrZSUzRiUyMEFuc3dlciUzQSUyMiUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Instruction: Provide an answer to the question. Use the image to answer.\\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1623944889288-cd147dbb517c?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Question: Where are these people and what&#x27;s the weather like? Answer:&quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
Instruction: Provide an answer to the question. Use the image to answer.
 Question: Where are these people <span class="hljs-keyword">and</span> what<span class="hljs-string">&#x27;s the weather like? Answer: They&#x27;</span>re <span class="hljs-keyword">in</span> a park <span class="hljs-keyword">in</span> New York City, <span class="hljs-keyword">and</span> it<span class="hljs-string">&#x27;s a beautiful day.</span>`,wrap:!1}}),wt=new j({props:{title:"Image classification",local:"image-classification",headingTag:"h2"}}),It=new f({props:{code:"Y2F0ZWdvcmllcyUyMCUzRCUyMCU1QidhbmltYWxzJyUyQyd2ZWdldGFibGVzJyUyQyUyMCdjaXR5JTIwbGFuZHNjYXBlJyUyQyUyMCdjYXJzJyUyQyUyMCdvZmZpY2UnJTVEJTBBcHJvbXB0JTIwJTNEJTIwJTVCZiUyMkluc3RydWN0aW9uJTNBJTIwQ2xhc3NpZnklMjB0aGUlMjBmb2xsb3dpbmclMjBpbWFnZSUyMGludG8lMjBhJTIwc2luZ2xlJTIwY2F0ZWdvcnklMjBmcm9tJTIwdGhlJTIwZm9sbG93aW5nJTIwbGlzdCUzQSUyMCU3QmNhdGVnb3JpZXMlN0QuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE0NzExOTM5NDU1MDktOWFkMDYxN2FmYWJmJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1NDAlMjZxJTNEODAlMjIlMkMlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjJDYXRlZ29yeSUzQSUyMCUyMiUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q2JTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0ZWRfdGV4dCU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>categories = [<span class="hljs-string">&#x27;animals&#x27;</span>,<span class="hljs-string">&#x27;vegetables&#x27;</span>, <span class="hljs-string">&#x27;city landscape&#x27;</span>, <span class="hljs-string">&#x27;cars&#x27;</span>, <span class="hljs-string">&#x27;office&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">f&quot;Instruction: Classify the following image into a single category from the following list: <span class="hljs-subst">{categories}</span>.\\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1471193945509-9ad0617afabf?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,    
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Category: &quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">6</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
Instruction: Classify the following image into a single category <span class="hljs-keyword">from</span> the following <span class="hljs-built_in">list</span>: [<span class="hljs-string">&#x27;animals&#x27;</span>, <span class="hljs-string">&#x27;vegetables&#x27;</span>, <span class="hljs-string">&#x27;city landscape&#x27;</span>, <span class="hljs-string">&#x27;cars&#x27;</span>, <span class="hljs-string">&#x27;office&#x27;</span>].
Category: Vegetables`,wrap:!1}}),Ct=new j({props:{title:"Image-guided text generation",local:"image-guided-text-generation",headingTag:"h2"}}),Wt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIySW5zdHJ1Y3Rpb24lM0ElMjBVc2UlMjB0aGUlMjBpbWFnZSUyMHRvJTIwd3JpdGUlMjBhJTIwc3RvcnkuJTIwJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MTcwODY4MjIxNTctMmIwMzU4ZTc2ODRhJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDIyMDMlMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdG9yeSUzQSUyMCU1Q24lMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFiYWRfd29yZHNfaWRzJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplciglNUIlMjIlM0NpbWFnZSUzRSUyMiUyQyUyMCUyMiUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFJTIyJTVEJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpLmlucHV0X2lkcyUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKSUyMCUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;Instruction: Use the image to write a story. \\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1517086822157-2b0358e7684a?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=2203&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Story: \\n&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, num_beams=<span class="hljs-number">2</span>, max_new_tokens=<span class="hljs-number">200</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>]) 
Instruction: Use the image to write a story. 
 Story: 
Once upon a time, there was a little girl who lived <span class="hljs-keyword">in</span> a house <span class="hljs-keyword">with</span> a red door.  She loved her red door.  It was the prettiest door <span class="hljs-keyword">in</span> the whole world.

One day, the little girl was playing <span class="hljs-keyword">in</span> her yard when she noticed a man standing on her doorstep.  He was wearing a long black coat <span class="hljs-keyword">and</span> a top hat.

The little girl ran inside <span class="hljs-keyword">and</span> told her mother about the man.

Her mother said, “Don’t worry, honey.  He’s just a friendly ghost.”

The little girl wasn’t sure <span class="hljs-keyword">if</span> she believed her mother, but she went outside anyway.

When she got to the door, the man was gone.

The <span class="hljs-built_in">next</span> day, the little girl was playing <span class="hljs-keyword">in</span> her yard again when she noticed the man standing on her doorstep.

He was wearing a long black coat <span class="hljs-keyword">and</span> a top hat.

The little girl ran`,wrap:!1}}),v=new re({props:{$$slots:{default:[wa]},$$scope:{ctx:J}}}),Nt=new j({props:{title:"Running inference in batch mode",local:"running-inference-in-batch-mode",headingTag:"h2"}}),zt=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1623944889288-cd147dbb517c?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1471193945509-9ad0617afabf?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i,t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(generated_text):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i}</span>:\\n<span class="hljs-subst">{t}</span>\\n&quot;</span>) 
<span class="hljs-number">0</span>:
This <span class="hljs-keyword">is</span> an image of the Eiffel Tower <span class="hljs-keyword">in</span> Paris, France.

<span class="hljs-number">1</span>:
This <span class="hljs-keyword">is</span> an image of a couple on a picnic blanket.

<span class="hljs-number">2</span>:
This <span class="hljs-keyword">is</span> an image of a vegetable stand.`,wrap:!1}}),Qt=new j({props:{title:"IDEFICS instruct for conversational use",local:"idefics-instruct-for-conversational-use",headingTag:"h2"}}),Xt=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05Yi1pbnN0cnVjdCUyMiUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpLnRvKGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIwV2hhdCUyMGlzJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRjglMkY4NiUyRklkJTI1QzMlMjVBOWZpeC5KUEclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlM0NlbmRfb2ZfdXR0ZXJhbmNlJTNFJTIyJTJDJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTVDbkFzc2lzdGFudCUzQSUyMFRoaXMlMjBwaWN0dXJlJTIwZGVwaWN0cyUyMElkZWZpeCUyQyUyMHRoZSUyMGRvZyUyMG9mJTIwT2JlbGl4JTIwaW4lMjBBc3Rlcml4JTIwYW5kJTIwT2JlbGl4LiUyMElkZWZpeCUyMGlzJTIwcnVubmluZyUyMG9uJTIwdGhlJTIwZ3JvdW5kLiUzQ2VuZF9vZl91dHRlcmFuY2UlM0UlMjIlMkMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNUNuVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGc3RhdGljLndpa2lhLm5vY29va2llLm5ldCUyRmFzdGVyaXglMkZpbWFnZXMlMkYyJTJGMjUlMkZSMjJiLmdpZiUyRnJldmlzaW9uJTJGbGF0ZXN0JTNGY2IlM0QyMDExMDgxNTA3MzA1MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkFuZCUyMHdobyUyMGlzJTIwdGhhdCUzRiUzQ2VuZF9vZl91dHRlcmFuY2UlM0UlMjIlMkMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNUNuQXNzaXN0YW50JTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTVEJTBBJTBBJTIzJTIwLS1iYXRjaGVkJTIwbW9kZSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHRzJTJDJTIwYWRkX2VuZF9vZl91dHRlcmFuY2VfdG9rZW4lM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEElMjMlMjAtLXNpbmdsZSUyMHNhbXBsZSUyMG1vZGUlMEElMjMlMjBpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0cyU1QjAlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMGFyZ3MlMEFleGl0X2NvbmRpdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIoJTIyJTNDZW5kX29mX3V0dGVyYW5jZSUzRSUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlMEFiYWRfd29yZHNfaWRzJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplciglNUIlMjIlM0NpbWFnZSUzRSUyMiUyQyUyMCUyMiUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFJTIyJTVEJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpLmlucHV0X2lkcyUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGVvc190b2tlbl9pZCUzRGV4aXRfY29uZGl0aW9uJTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMTAwKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBZm9yJTIwaSUyQyUyMHQlMjBpbiUyMGVudW1lcmF0ZShnZW5lcmF0ZWRfdGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCaSU3RCUzQSU1Q24lN0J0JTdEJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b-instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(checkpoint, torch_dtype=torch.bfloat16).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User: What is in this image?&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/86/Id%C3%A9fix.JPG&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nAssistant: This picture depicts Idefix, the dog of Obelix in Asterix and Obelix. Idefix is running on the ground.&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nUser:&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;https://static.wikia.nocookie.net/asterix/images/2/25/R22b.gif/revision/latest?cb=20110815073052&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;And who is that?&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nAssistant:&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># --batched mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, add_end_of_utterance_token=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># --single sample mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inputs = processor(prompts[0], return_tensors=&quot;pt&quot;).to(device)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation args</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>exit_condition = processor.tokenizer(<span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, eos_token_id=exit_condition, bad_words_ids=bad_words_ids, max_length=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(generated_text):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i}</span>:\\n<span class="hljs-subst">{t}</span>\\n&quot;</span>)`,wrap:!1}}),$t=new fa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/idefics.md"}}),{c(){c=i("meta"),y=l(),u=i("p"),w=l(),m(W.$$.fragment),Et=l(),m(_.$$.fragment),Yt=l(),N=i("p"),N.textContent=de,At=l(),G=i("p"),G.innerHTML=Me,qt=l(),z=i("p"),z.textContent=he,St=l(),Q=i("p"),Q.textContent=ge,Dt=l(),B=i("ul"),B.innerHTML=ue,Lt=l(),V=i("p"),V.textContent=ye,Pt=l(),m(H.$$.fragment),Ot=l(),m(T.$$.fragment),Kt=l(),m(X.$$.fragment),ts=l(),$=i("p"),$.textContent=fe,ss=l(),m(F.$$.fragment),es=l(),E=i("p"),E.innerHTML=je,as=l(),m(Y.$$.fragment),ls=l(),A=i("p"),A.innerHTML=Je,ns=l(),m(q.$$.fragment),is=l(),S=i("p"),S.innerHTML=we,ps=l(),m(D.$$.fragment),os=l(),L=i("p"),L.textContent=Te,cs=l(),m(P.$$.fragment),ms=l(),O=i("p"),O.textContent=Ue,rs=l(),K=i("p"),K.textContent=be,ds=l(),U=i("div"),U.innerHTML=Ze,Ms=l(),tt=i("p"),tt.innerHTML=Ie,hs=l(),st=i("p"),st.textContent=ke,gs=l(),et=i("p"),et.innerHTML=Ce,us=l(),m(at.$$.fragment),ys=l(),m(b.$$.fragment),fs=l(),m(lt.$$.fragment),js=l(),nt=i("p"),nt.textContent=Re,Js=l(),Z=i("div"),Z.innerHTML=ve,ws=l(),it=i("p"),it.innerHTML=xe,Ts=l(),pt=i("p"),pt.textContent=We,Us=l(),m(ot.$$.fragment),bs=l(),m(ct.$$.fragment),Zs=l(),mt=i("p"),mt.textContent=_e,Is=l(),rt=i("p"),rt.textContent=Ne,ks=l(),I=i("div"),I.innerHTML=Ge,Cs=l(),dt=i("p"),dt.innerHTML=ze,Rs=l(),m(Mt.$$.fragment),vs=l(),ht=i("p"),ht.textContent=Qe,xs=l(),m(gt.$$.fragment),Ws=l(),ut=i("p"),ut.textContent=Be,_s=l(),yt=i("p"),yt.textContent=Ve,Ns=l(),k=i("div"),k.innerHTML=He,Gs=l(),ft=i("p"),ft.innerHTML=Xe,zs=l(),jt=i("p"),jt.textContent=$e,Qs=l(),m(Jt.$$.fragment),Bs=l(),m(wt.$$.fragment),Vs=l(),Tt=i("p"),Tt.textContent=Fe,Hs=l(),Ut=i("p"),Ut.textContent=Ee,Xs=l(),C=i("div"),C.innerHTML=Ye,$s=l(),bt=i("p"),bt.innerHTML=Ae,Fs=l(),Zt=i("p"),Zt.textContent=qe,Es=l(),m(It.$$.fragment),Ys=l(),kt=i("p"),kt.textContent=Se,As=l(),m(Ct.$$.fragment),qs=l(),Rt=i("p"),Rt.textContent=De,Ss=l(),vt=i("p"),vt.textContent=Le,Ds=l(),R=i("div"),R.innerHTML=Pe,Ls=l(),xt=i("p"),xt.innerHTML=Oe,Ps=l(),m(Wt.$$.fragment),Os=l(),_t=i("p"),_t.textContent=Ke,Ks=l(),m(v.$$.fragment),te=l(),m(Nt.$$.fragment),se=l(),Gt=i("p"),Gt.textContent=ta,ee=l(),m(zt.$$.fragment),ae=l(),m(Qt.$$.fragment),le=l(),Bt=i("p"),Bt.innerHTML=sa,ne=l(),Vt=i("p"),Vt.textContent=ea,ie=l(),Ht=i("p"),Ht.textContent=aa,pe=l(),m(Xt.$$.fragment),oe=l(),m($t.$$.fragment),ce=l(),Ft=i("p"),this.h()},l(t){const s=Ma("svelte-u9bgzb",document.head);c=p(s,"META",{name:!0,content:!0}),s.forEach(e),y=n(t),u=p(t,"P",{}),pa(u).forEach(e),w=n(t),r(W.$$.fragment,t),Et=n(t),r(_.$$.fragment,t),Yt=n(t),N=p(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-11wnsr"&&(N.textContent=de),At=n(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1nt7nk6"&&(G.innerHTML=Me),qt=n(t),z=p(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1k5g1sg"&&(z.textContent=he),St=n(t),Q=p(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-fp1hdi"&&(Q.textContent=ge),Dt=n(t),B=p(t,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-lzrpc8"&&(B.innerHTML=ue),Lt=n(t),V=p(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-qn4ey1"&&(V.textContent=ye),Pt=n(t),r(H.$$.fragment,t),Ot=n(t),r(T.$$.fragment,t),Kt=n(t),r(X.$$.fragment,t),ts=n(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-pbsmkm"&&($.textContent=fe),ss=n(t),r(F.$$.fragment,t),es=n(t),E=p(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-jbng9l"&&(E.innerHTML=je),as=n(t),r(Y.$$.fragment,t),ls=n(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-10jwul3"&&(A.innerHTML=Je),ns=n(t),r(q.$$.fragment,t),is=n(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-gb566o"&&(S.innerHTML=we),ps=n(t),r(D.$$.fragment,t),os=n(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-vovwl0"&&(L.textContent=Te),cs=n(t),r(P.$$.fragment,t),ms=n(t),O=p(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-195xyco"&&(O.textContent=Ue),rs=n(t),K=p(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-syqfn9"&&(K.textContent=be),ds=n(t),U=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-t8y7db"&&(U.innerHTML=Ze),Ms=n(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-knozkn"&&(tt.innerHTML=Ie),hs=n(t),st=p(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-10bztc1"&&(st.textContent=ke),gs=n(t),et=p(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-sk4o55"&&(et.innerHTML=Ce),us=n(t),r(at.$$.fragment,t),ys=n(t),r(b.$$.fragment,t),fs=n(t),r(lt.$$.fragment,t),js=n(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-15l3yis"&&(nt.textContent=Re),Js=n(t),Z=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1ritb1k"&&(Z.innerHTML=ve),ws=n(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1uz68x8"&&(it.innerHTML=xe),Ts=n(t),pt=p(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-cncrxa"&&(pt.textContent=We),Us=n(t),r(ot.$$.fragment,t),bs=n(t),r(ct.$$.fragment,t),Zs=n(t),mt=p(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-fytdtn"&&(mt.textContent=_e),Is=n(t),rt=p(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-148v07a"&&(rt.textContent=Ne),ks=n(t),I=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-gin1vp"&&(I.innerHTML=Ge),Cs=n(t),dt=p(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-s7b8dy"&&(dt.innerHTML=ze),Rs=n(t),r(Mt.$$.fragment,t),vs=n(t),ht=p(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-mpygyg"&&(ht.textContent=Qe),xs=n(t),r(gt.$$.fragment,t),Ws=n(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-cnfg69"&&(ut.textContent=Be),_s=n(t),yt=p(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-nptt59"&&(yt.textContent=Ve),Ns=n(t),k=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-1j2xr8e"&&(k.innerHTML=He),Gs=n(t),ft=p(t,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1aj82zb"&&(ft.innerHTML=Xe),zs=n(t),jt=p(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-tdtrto"&&(jt.textContent=$e),Qs=n(t),r(Jt.$$.fragment,t),Bs=n(t),r(wt.$$.fragment,t),Vs=n(t),Tt=p(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-a4cfdv"&&(Tt.textContent=Fe),Hs=n(t),Ut=p(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1xbkffx"&&(Ut.textContent=Ee),Xs=n(t),C=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-g02ga3"&&(C.innerHTML=Ye),$s=n(t),bt=p(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-17q4ltv"&&(bt.innerHTML=Ae),Fs=n(t),Zt=p(t,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-13lz1gw"&&(Zt.textContent=qe),Es=n(t),r(It.$$.fragment,t),Ys=n(t),kt=p(t,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-571z8p"&&(kt.textContent=Se),As=n(t),r(Ct.$$.fragment,t),qs=n(t),Rt=p(t,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1cpi6ml"&&(Rt.textContent=De),Ss=n(t),vt=p(t,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-bxfm2h"&&(vt.textContent=Le),Ds=n(t),R=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(R)!=="svelte-1mf93u3"&&(R.innerHTML=Pe),Ls=n(t),xt=p(t,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-75pbgi"&&(xt.innerHTML=Oe),Ps=n(t),r(Wt.$$.fragment,t),Os=n(t),_t=p(t,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-eumo01"&&(_t.textContent=Ke),Ks=n(t),r(v.$$.fragment,t),te=n(t),r(Nt.$$.fragment,t),se=n(t),Gt=p(t,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-2k4kpw"&&(Gt.textContent=ta),ee=n(t),r(zt.$$.fragment,t),ae=n(t),r(Qt.$$.fragment,t),le=n(t),Bt=p(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-ay5071"&&(Bt.innerHTML=sa),ne=n(t),Vt=p(t,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-8tbmhu"&&(Vt.textContent=ea),ie=n(t),Ht=p(t,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-ccrnle"&&(Ht.textContent=aa),pe=n(t),r(Xt.$$.fragment,t),oe=n(t),r($t.$$.fragment,t),ce=n(t),Ft=p(t,"P",{}),pa(Ft).forEach(e),this.h()},h(){x(c,"name","hf:doc:metadata"),x(c,"content",Ua),x(U,"class","flex justify-center"),x(Z,"class","flex justify-center"),x(I,"class","flex justify-center"),x(k,"class","flex justify-center"),x(C,"class","flex justify-center"),x(R,"class","flex justify-center")},m(t,s){ha(document.head,c),a(t,y,s),a(t,u,s),a(t,w,s),d(W,t,s),a(t,Et,s),d(_,t,s),a(t,Yt,s),a(t,N,s),a(t,At,s),a(t,G,s),a(t,qt,s),a(t,z,s),a(t,St,s),a(t,Q,s),a(t,Dt,s),a(t,B,s),a(t,Lt,s),a(t,V,s),a(t,Pt,s),d(H,t,s),a(t,Ot,s),d(T,t,s),a(t,Kt,s),d(X,t,s),a(t,ts,s),a(t,$,s),a(t,ss,s),d(F,t,s),a(t,es,s),a(t,E,s),a(t,as,s),d(Y,t,s),a(t,ls,s),a(t,A,s),a(t,ns,s),d(q,t,s),a(t,is,s),a(t,S,s),a(t,ps,s),d(D,t,s),a(t,os,s),a(t,L,s),a(t,cs,s),d(P,t,s),a(t,ms,s),a(t,O,s),a(t,rs,s),a(t,K,s),a(t,ds,s),a(t,U,s),a(t,Ms,s),a(t,tt,s),a(t,hs,s),a(t,st,s),a(t,gs,s),a(t,et,s),a(t,us,s),d(at,t,s),a(t,ys,s),d(b,t,s),a(t,fs,s),d(lt,t,s),a(t,js,s),a(t,nt,s),a(t,Js,s),a(t,Z,s),a(t,ws,s),a(t,it,s),a(t,Ts,s),a(t,pt,s),a(t,Us,s),d(ot,t,s),a(t,bs,s),d(ct,t,s),a(t,Zs,s),a(t,mt,s),a(t,Is,s),a(t,rt,s),a(t,ks,s),a(t,I,s),a(t,Cs,s),a(t,dt,s),a(t,Rs,s),d(Mt,t,s),a(t,vs,s),a(t,ht,s),a(t,xs,s),d(gt,t,s),a(t,Ws,s),a(t,ut,s),a(t,_s,s),a(t,yt,s),a(t,Ns,s),a(t,k,s),a(t,Gs,s),a(t,ft,s),a(t,zs,s),a(t,jt,s),a(t,Qs,s),d(Jt,t,s),a(t,Bs,s),d(wt,t,s),a(t,Vs,s),a(t,Tt,s),a(t,Hs,s),a(t,Ut,s),a(t,Xs,s),a(t,C,s),a(t,$s,s),a(t,bt,s),a(t,Fs,s),a(t,Zt,s),a(t,Es,s),d(It,t,s),a(t,Ys,s),a(t,kt,s),a(t,As,s),d(Ct,t,s),a(t,qs,s),a(t,Rt,s),a(t,Ss,s),a(t,vt,s),a(t,Ds,s),a(t,R,s),a(t,Ls,s),a(t,xt,s),a(t,Ps,s),d(Wt,t,s),a(t,Os,s),a(t,_t,s),a(t,Ks,s),d(v,t,s),a(t,te,s),d(Nt,t,s),a(t,se,s),a(t,Gt,s),a(t,ee,s),d(zt,t,s),a(t,ae,s),d(Qt,t,s),a(t,le,s),a(t,Bt,s),a(t,ne,s),a(t,Vt,s),a(t,ie,s),a(t,Ht,s),a(t,pe,s),d(Xt,t,s),a(t,oe,s),d($t,t,s),a(t,ce,s),a(t,Ft,s),me=!0},p(t,[s]){const la={};s&2&&(la.$$scope={dirty:s,ctx:t}),T.$set(la);const na={};s&2&&(na.$$scope={dirty:s,ctx:t}),b.$set(na);const ia={};s&2&&(ia.$$scope={dirty:s,ctx:t}),v.$set(ia)},i(t){me||(M(W.$$.fragment,t),M(_.$$.fragment,t),M(H.$$.fragment,t),M(T.$$.fragment,t),M(X.$$.fragment,t),M(F.$$.fragment,t),M(Y.$$.fragment,t),M(q.$$.fragment,t),M(D.$$.fragment,t),M(P.$$.fragment,t),M(at.$$.fragment,t),M(b.$$.fragment,t),M(lt.$$.fragment,t),M(ot.$$.fragment,t),M(ct.$$.fragment,t),M(Mt.$$.fragment,t),M(gt.$$.fragment,t),M(Jt.$$.fragment,t),M(wt.$$.fragment,t),M(It.$$.fragment,t),M(Ct.$$.fragment,t),M(Wt.$$.fragment,t),M(v.$$.fragment,t),M(Nt.$$.fragment,t),M(zt.$$.fragment,t),M(Qt.$$.fragment,t),M(Xt.$$.fragment,t),M($t.$$.fragment,t),me=!0)},o(t){h(W.$$.fragment,t),h(_.$$.fragment,t),h(H.$$.fragment,t),h(T.$$.fragment,t),h(X.$$.fragment,t),h(F.$$.fragment,t),h(Y.$$.fragment,t),h(q.$$.fragment,t),h(D.$$.fragment,t),h(P.$$.fragment,t),h(at.$$.fragment,t),h(b.$$.fragment,t),h(lt.$$.fragment,t),h(ot.$$.fragment,t),h(ct.$$.fragment,t),h(Mt.$$.fragment,t),h(gt.$$.fragment,t),h(Jt.$$.fragment,t),h(wt.$$.fragment,t),h(It.$$.fragment,t),h(Ct.$$.fragment,t),h(Wt.$$.fragment,t),h(v.$$.fragment,t),h(Nt.$$.fragment,t),h(zt.$$.fragment,t),h(Qt.$$.fragment,t),h(Xt.$$.fragment,t),h($t.$$.fragment,t),me=!1},d(t){t&&(e(y),e(u),e(w),e(Et),e(Yt),e(N),e(At),e(G),e(qt),e(z),e(St),e(Q),e(Dt),e(B),e(Lt),e(V),e(Pt),e(Ot),e(Kt),e(ts),e($),e(ss),e(es),e(E),e(as),e(ls),e(A),e(ns),e(is),e(S),e(ps),e(os),e(L),e(cs),e(ms),e(O),e(rs),e(K),e(ds),e(U),e(Ms),e(tt),e(hs),e(st),e(gs),e(et),e(us),e(ys),e(fs),e(js),e(nt),e(Js),e(Z),e(ws),e(it),e(Ts),e(pt),e(Us),e(bs),e(Zs),e(mt),e(Is),e(rt),e(ks),e(I),e(Cs),e(dt),e(Rs),e(vs),e(ht),e(xs),e(Ws),e(ut),e(_s),e(yt),e(Ns),e(k),e(Gs),e(ft),e(zs),e(jt),e(Qs),e(Bs),e(Vs),e(Tt),e(Hs),e(Ut),e(Xs),e(C),e($s),e(bt),e(Fs),e(Zt),e(Es),e(Ys),e(kt),e(As),e(qs),e(Rt),e(Ss),e(vt),e(Ds),e(R),e(Ls),e(xt),e(Ps),e(Os),e(_t),e(Ks),e(te),e(se),e(Gt),e(ee),e(ae),e(le),e(Bt),e(ne),e(Vt),e(ie),e(Ht),e(pe),e(oe),e(ce),e(Ft)),e(c),g(W,t),g(_,t),g(H,t),g(T,t),g(X,t),g(F,t),g(Y,t),g(q,t),g(D,t),g(P,t),g(at,t),g(b,t),g(lt,t),g(ot,t),g(ct,t),g(Mt,t),g(gt,t),g(Jt,t),g(wt,t),g(It,t),g(Ct,t),g(Wt,t),g(v,t),g(Nt,t),g(zt,t),g(Qt,t),g(Xt,t),g($t,t)}}}const Ua='{"title":"Image tasks with IDEFICS","local":"image-tasks-with-idefics","sections":[{"title":"Loading the model","local":"loading-the-model","sections":[{"title":"Quantized model","local":"quantized-model","sections":[],"depth":3}],"depth":2},{"title":"Image captioning","local":"image-captioning","sections":[],"depth":2},{"title":"Prompted image captioning","local":"prompted-image-captioning","sections":[],"depth":2},{"title":"Few-shot prompting","local":"few-shot-prompting","sections":[],"depth":2},{"title":"Visual question answering","local":"visual-question-answering","sections":[],"depth":2},{"title":"Image classification","local":"image-classification","sections":[],"depth":2},{"title":"Image-guided text generation","local":"image-guided-text-generation","sections":[],"depth":2},{"title":"Running inference in batch mode","local":"running-inference-in-batch-mode","sections":[],"depth":2},{"title":"IDEFICS instruct for conversational use","local":"idefics-instruct-for-conversational-use","sections":[],"depth":2}],"depth":1}';function ba(J){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xa extends ra{constructor(c){super(),da(this,c,ba,Ta,ca,{})}}export{xa as component};
